"""
    Engines API

    Allow clients to fetch Analytics through APIs.  # noqa: E501

    The version of the OpenAPI document: v3:[pa,spar,vault,pub,quant,fi,axp,afi,npo,bpm,fpo,others],v1:[fiab]
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fds.analyticsapi.engines.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from fds.analyticsapi.engines.model.fi_bank_loans import FIBankLoans
    from fds.analyticsapi.engines.model.fi_loss import FILoss
    from fds.analyticsapi.engines.model.fi_municipal_bonds import FIMunicipalBonds
    from fds.analyticsapi.engines.model.fi_prepay import FIPrepay
    from fds.analyticsapi.engines.model.fi_reference_security import FIReferenceSecurity
    from fds.analyticsapi.engines.model.fi_structured_products_for_securities import FIStructuredProductsForSecurities
    globals()['FIBankLoans'] = FIBankLoans
    globals()['FILoss'] = FILoss
    globals()['FIMunicipalBonds'] = FIMunicipalBonds
    globals()['FIPrepay'] = FIPrepay
    globals()['FIReferenceSecurity'] = FIReferenceSecurity
    globals()['FIStructuredProductsForSecurities'] = FIStructuredProductsForSecurities


class FISecurity(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('call_method',): {
            'NO_CALL': "No Call",
            'INTRINSIC_VALUE': "Intrinsic Value",
            'FIRST_CALL': "First Call",
            'FIRST_PAR': "First Par",
        },
        ('face_type',): {
            'CURRENT': "Current",
            'ORIGINAL': "Original",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'calc_from_value': (float,),  # noqa: E501
            'symbol': (str,),  # noqa: E501
            'settlement': (str,),  # noqa: E501
            'call_method': (str,),  # noqa: E501
            'reference_security': (FIReferenceSecurity,),  # noqa: E501
            'bank_loans': (FIBankLoans,),  # noqa: E501
            'municipal_bonds': (FIMunicipalBonds,),  # noqa: E501
            'loss': (FILoss,),  # noqa: E501
            'prepay': (FIPrepay,),  # noqa: E501
            'matrix_spread_adjustment': (float,),  # noqa: E501
            'matrix_multiplier': (float,),  # noqa: E501
            'structured_products': (FIStructuredProductsForSecurities,),  # noqa: E501
            'calc_from_method': (str,),  # noqa: E501
            'face': (float,),  # noqa: E501
            'face_type': (str,),  # noqa: E501
            'discount_curve': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'calc_from_value': 'calcFromValue',  # noqa: E501
        'symbol': 'symbol',  # noqa: E501
        'settlement': 'settlement',  # noqa: E501
        'call_method': 'callMethod',  # noqa: E501
        'reference_security': 'referenceSecurity',  # noqa: E501
        'bank_loans': 'bankLoans',  # noqa: E501
        'municipal_bonds': 'municipalBonds',  # noqa: E501
        'loss': 'loss',  # noqa: E501
        'prepay': 'prepay',  # noqa: E501
        'matrix_spread_adjustment': 'matrixSpreadAdjustment',  # noqa: E501
        'matrix_multiplier': 'matrixMultiplier',  # noqa: E501
        'structured_products': 'structuredProducts',  # noqa: E501
        'calc_from_method': 'calcFromMethod',  # noqa: E501
        'face': 'face',  # noqa: E501
        'face_type': 'faceType',  # noqa: E501
        'discount_curve': 'discountCurve',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, calc_from_value, symbol, *args, **kwargs):  # noqa: E501
        """FISecurity - a model defined in OpenAPI

        Args:
            calc_from_value (float): Calculation from value
            symbol (str): Symbol

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            settlement (str): Settlement date. [optional]  # noqa: E501
            call_method (str): Call Method. [optional]  # noqa: E501
            reference_security (FIReferenceSecurity): [optional]  # noqa: E501
            bank_loans (FIBankLoans): [optional]  # noqa: E501
            municipal_bonds (FIMunicipalBonds): [optional]  # noqa: E501
            loss (FILoss): [optional]  # noqa: E501
            prepay (FIPrepay): [optional]  # noqa: E501
            matrix_spread_adjustment (float): Matrix Spread Adjustment. [optional]  # noqa: E501
            matrix_multiplier (float): Matrix Multiplier. [optional]  # noqa: E501
            structured_products (FIStructuredProductsForSecurities): [optional]  # noqa: E501
            calc_from_method (str): Calculation Method.  Methods : Active Spread, Actual Spread, Actual Spread To Worst Call, OAS, Price, Yield, Yield To No Call, Act/Act Yield To No Call, Bond Equivalent Yield,  Yield To Worst Call, Discount Yield, Discount Margin, Implied Volatility, Bullet Spread, Bullet Spread To Worst Call, Pricing Matrix. [optional]  # noqa: E501
            face (float): Face. [optional] if omitted the server will use the default value of 1  # noqa: E501
            face_type (str): Face type. [optional] if omitted the server will use the default value of "Current"  # noqa: E501
            discount_curve (str): Discount curve. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.calc_from_value = calc_from_value
        self.symbol = symbol
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
