# fds.analyticsapi.engines
Allow clients to fetch Analytics through APIs.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3:[pa,spar,vault,pub,quant,fi,axp,afi,npo,bpm,fpo,others],v1:[fiab]
- Package version: 5.6.0
- Build package: CustomPythonClientCodegen
For more information, please visit [https://developer.factset.com/contact](https://developer.factset.com/contact)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import fds.analyticsapi.engines
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import fds.analyticsapi.engines
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import fds.analyticsapi.engines
from pprint import pprint
from fds.analyticsapi.engines.api import afi_optimizer_api
from fds.analyticsapi.engines.model.afi_optimization_parameters_root import AFIOptimizationParametersRoot
from fds.analyticsapi.engines.model.calculation_info_root import CalculationInfoRoot
from fds.analyticsapi.engines.model.client_error_response import ClientErrorResponse
from fds.analyticsapi.engines.model.object_root import ObjectRoot
# Defining the host is optional and defaults to https://api.factset.com
# See configuration.py for a list of all supported configuration parameters.
configuration = fds.analyticsapi.engines.Configuration(
    host = "https://api.factset.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: Basic
configuration = fds.analyticsapi.engines.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure Bearer authorization: Bearer
configuration = fds.analyticsapi.engines.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with fds.analyticsapi.engines.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = afi_optimizer_api.AFIOptimizerApi(api_client)
    id = "id_example" # str | from url, provided from the location header in the Create and Run AFI optimization endpoint

    try:
        # Cancel AFI optimization by id
        api_instance.cancel_optimization_by_id(id)
    except fds.analyticsapi.engines.ApiException as e:
        print("Exception when calling AFIOptimizerApi->cancel_optimization_by_id: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.factset.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AFIOptimizerApi* | [**cancel_optimization_by_id**](docs/AFIOptimizerApi.md#cancel_optimization_by_id) | **DELETE** /analytics/engines/afi/v3/optimizations/{id} | Cancel AFI optimization by id
*AFIOptimizerApi* | [**get_optimization_parameters**](docs/AFIOptimizerApi.md#get_optimization_parameters) | **GET** /analytics/engines/afi/v3/optimizations/{id} | Get AFI optimization parameters by id
*AFIOptimizerApi* | [**get_optimization_result**](docs/AFIOptimizerApi.md#get_optimization_result) | **GET** /analytics/engines/afi/v3/optimizations/{id}/result | Get AFI optimization result by id
*AFIOptimizerApi* | [**get_optimization_status_by_id**](docs/AFIOptimizerApi.md#get_optimization_status_by_id) | **GET** /analytics/engines/afi/v3/optimizations/{id}/status | Get AFI optimization status by id
*AFIOptimizerApi* | [**post_and_optimize**](docs/AFIOptimizerApi.md#post_and_optimize) | **POST** /analytics/engines/afi/v3/optimizations | Create and Run AFI optimization
*AFIOptimizerApi* | [**put_and_optimize**](docs/AFIOptimizerApi.md#put_and_optimize) | **PUT** /analytics/engines/afi/v3/optimizations/{id} | Create or Update AFI optimization and run it.
*AXPOptimizerApi* | [**cancel_optimization_by_id**](docs/AXPOptimizerApi.md#cancel_optimization_by_id) | **DELETE** /analytics/engines/axp/v3/optimizations/{id} | Cancel Axioma optimization by id
*AXPOptimizerApi* | [**get_optimization_parameters**](docs/AXPOptimizerApi.md#get_optimization_parameters) | **GET** /analytics/engines/axp/v3/optimizations/{id} | Get Axioma optimization parameters by id
*AXPOptimizerApi* | [**get_optimization_result**](docs/AXPOptimizerApi.md#get_optimization_result) | **GET** /analytics/engines/axp/v3/optimizations/{id}/result | Get Axioma optimization result by id
*AXPOptimizerApi* | [**get_optimization_status_by_id**](docs/AXPOptimizerApi.md#get_optimization_status_by_id) | **GET** /analytics/engines/axp/v3/optimizations/{id}/status | Get Axioma optimization status by id
*AXPOptimizerApi* | [**post_and_optimize**](docs/AXPOptimizerApi.md#post_and_optimize) | **POST** /analytics/engines/axp/v3/optimizations | Create and Run Axioma optimization
*AXPOptimizerApi* | [**put_and_optimize**](docs/AXPOptimizerApi.md#put_and_optimize) | **PUT** /analytics/engines/axp/v3/optimizations/{id} | Create or Update Axioma optimization and run it.
*AccountsApi* | [**get_accounts**](docs/AccountsApi.md#get_accounts) | **GET** /analytics/lookups/v3/accounts/{path} | Get accounts and sub-directories in a directory
*AccountsApi* | [**get_spar_returns_type**](docs/AccountsApi.md#get_spar_returns_type) | **GET** /analytics/engines/spar/v3/accounts/{accountPath}/returns-type | Get SPAR account returns type details
*BPMOptimizerApi* | [**cancel_optimization_by_id**](docs/BPMOptimizerApi.md#cancel_optimization_by_id) | **DELETE** /analytics/engines/bpm/v3/optimizations/{id} | Cancel BPM optimization by id
*BPMOptimizerApi* | [**get_optimization_parameters**](docs/BPMOptimizerApi.md#get_optimization_parameters) | **GET** /analytics/engines/bpm/v3/optimizations/{id} | Get BPM optimization parameters by id
*BPMOptimizerApi* | [**get_optimization_result**](docs/BPMOptimizerApi.md#get_optimization_result) | **GET** /analytics/engines/bpm/v3/optimizations/{id}/result | Get BPM optimization result by id
*BPMOptimizerApi* | [**get_optimization_status_by_id**](docs/BPMOptimizerApi.md#get_optimization_status_by_id) | **GET** /analytics/engines/bpm/v3/optimizations/{id}/status | Get BPM optimization status by id
*BPMOptimizerApi* | [**post_and_optimize**](docs/BPMOptimizerApi.md#post_and_optimize) | **POST** /analytics/engines/bpm/v3/optimizations | Create and Run BPM optimization
*BPMOptimizerApi* | [**put_and_optimize**](docs/BPMOptimizerApi.md#put_and_optimize) | **PUT** /analytics/engines/bpm/v3/optimizations/{id} | Create or Update BPM optimization and run it.
*BenchmarksApi* | [**get_spar_benchmark_by_id**](docs/BenchmarksApi.md#get_spar_benchmark_by_id) | **GET** /analytics/engines/spar/v3/benchmarks | Get SPAR benchmark details
*ColumnStatisticsApi* | [**get_pa_column_statistics**](docs/ColumnStatisticsApi.md#get_pa_column_statistics) | **GET** /analytics/engines/pa/v3/columnstatistics | Get PA column statistics
*ColumnsApi* | [**get_pa_column_by_id**](docs/ColumnsApi.md#get_pa_column_by_id) | **GET** /analytics/engines/pa/v3/columns/{id} | Get PA column settings
*ColumnsApi* | [**get_pa_columns**](docs/ColumnsApi.md#get_pa_columns) | **GET** /analytics/engines/pa/v3/columns | Get PA columns
*ComponentsApi* | [**get_pa_component_by_id**](docs/ComponentsApi.md#get_pa_component_by_id) | **GET** /analytics/engines/pa/v3/components/{id} | Get PA component by id
*ComponentsApi* | [**get_pa_components**](docs/ComponentsApi.md#get_pa_components) | **GET** /analytics/engines/pa/v3/components | Get PA components
*ComponentsApi* | [**get_spar_components**](docs/ComponentsApi.md#get_spar_components) | **GET** /analytics/engines/spar/v3/components | Get SPAR components
*ComponentsApi* | [**get_vault_component_by_id**](docs/ComponentsApi.md#get_vault_component_by_id) | **GET** /analytics/engines/vault/v3/components/{id} | Get Vault component by id
*ComponentsApi* | [**get_vault_components**](docs/ComponentsApi.md#get_vault_components) | **GET** /analytics/engines/vault/v3/components | Get Vault components
*ConfigurationsApi* | [**get_vault_configuration_by_id**](docs/ConfigurationsApi.md#get_vault_configuration_by_id) | **GET** /analytics/engines/vault/v3/configurations/{id} | Get Vault configuration by id
*ConfigurationsApi* | [**get_vault_configurations**](docs/ConfigurationsApi.md#get_vault_configurations) | **GET** /analytics/engines/vault/v3/configurations | Get Vault configurations
*CurrenciesApi* | [**get_currencies**](docs/CurrenciesApi.md#get_currencies) | **GET** /analytics/lookups/v3/currencies | Get currencies
*DatesApi* | [**convert_pa_dates_to_absolute_format**](docs/DatesApi.md#convert_pa_dates_to_absolute_format) | **GET** /analytics/engines/pa/v3/dates | Convert PA dates to absolute format
*DatesApi* | [**convert_vault_dates_to_absolute_format**](docs/DatesApi.md#convert_vault_dates_to_absolute_format) | **GET** /analytics/engines/vault/v3/dates | Convert Vault dates to absolute format
*DiscountCurvesApi* | [**get_all_fi_discount_curves**](docs/DiscountCurvesApi.md#get_all_fi_discount_curves) | **GET** /analytics/engines/fi/v3/discount-curves | Get Discount Curves
*DocumentsApi* | [**get_pa3_documents**](docs/DocumentsApi.md#get_pa3_documents) | **GET** /analytics/engines/pa/v3/documents/{path} | Get PA3 documents and sub-directories in a directory
*DocumentsApi* | [**get_pub_documents**](docs/DocumentsApi.md#get_pub_documents) | **GET** /analytics/engines/pub/v3/documents/{path} | Gets Publisher documents and sub-directories in a directory
*DocumentsApi* | [**get_spar3_documents**](docs/DocumentsApi.md#get_spar3_documents) | **GET** /analytics/engines/spar/v3/documents/{path} | Gets SPAR3 documents and sub-directories in a directory
*DocumentsApi* | [**get_vault_documents**](docs/DocumentsApi.md#get_vault_documents) | **GET** /analytics/engines/vault/v3/documents/{path} | Get Vault documents and sub-directories in a directory
*FIABCalculationsApi* | [**get_calculation_by_id**](docs/FIABCalculationsApi.md#get_calculation_by_id) | **GET** /analytics/engines/fiab/v1/calculations/{id} | Get FIAB calculation by id
*FIABCalculationsApi* | [**get_calculation_status_summaries**](docs/FIABCalculationsApi.md#get_calculation_status_summaries) | **GET** /analytics/engines/fiab/v1/calculations | Get all FIAB calculation summaries
*FIABCalculationsApi* | [**run_calculation**](docs/FIABCalculationsApi.md#run_calculation) | **POST** /analytics/engines/fiab/v1/calculations | Run FIAB calculation
*FICalculationsApi* | [**cancel_calculation_by_id**](docs/FICalculationsApi.md#cancel_calculation_by_id) | **DELETE** /analytics/engines/fi/v3/calculations/{id} | Cancel FI calculation by id
*FICalculationsApi* | [**get_calculation_parameters**](docs/FICalculationsApi.md#get_calculation_parameters) | **GET** /analytics/engines/fi/v3/calculations/{id} | Get FI calculation parameters by id
*FICalculationsApi* | [**get_calculation_result**](docs/FICalculationsApi.md#get_calculation_result) | **GET** /analytics/engines/fi/v3/calculations/{id}/result | Get FI calculation result by id
*FICalculationsApi* | [**get_calculation_status_by_id**](docs/FICalculationsApi.md#get_calculation_status_by_id) | **GET** /analytics/engines/fi/v3/calculations/{id}/status | Get FI calculation status by id
*FICalculationsApi* | [**post_and_calculate**](docs/FICalculationsApi.md#post_and_calculate) | **POST** /analytics/engines/fi/v3/calculations | Create and Run FI calculation
*FICalculationsApi* | [**put_and_calculate**](docs/FICalculationsApi.md#put_and_calculate) | **PUT** /analytics/engines/fi/v3/calculations/{id} | Create or Update FI calculation and run it.
*FPOOptimizerApi* | [**cancel_optimization_by_id**](docs/FPOOptimizerApi.md#cancel_optimization_by_id) | **DELETE** /analytics/engines/fpo/v3/optimizations/{id} | Cancel FPO optimization by id
*FPOOptimizerApi* | [**get_optimization_parameters**](docs/FPOOptimizerApi.md#get_optimization_parameters) | **GET** /analytics/engines/fpo/v3/optimizations/{id} | Get FPO optimization parameters by id
*FPOOptimizerApi* | [**get_optimization_result**](docs/FPOOptimizerApi.md#get_optimization_result) | **GET** /analytics/engines/fpo/v3/optimizations/{id}/result | Get FPO optimization result by id
*FPOOptimizerApi* | [**get_optimization_status_by_id**](docs/FPOOptimizerApi.md#get_optimization_status_by_id) | **GET** /analytics/engines/fpo/v3/optimizations/{id}/status | Get FPO optimization status by id
*FPOOptimizerApi* | [**post_and_optimize**](docs/FPOOptimizerApi.md#post_and_optimize) | **POST** /analytics/engines/fpo/v3/optimizations | Create and Run FPO optimization
*FPOOptimizerApi* | [**put_and_optimize**](docs/FPOOptimizerApi.md#put_and_optimize) | **PUT** /analytics/engines/fpo/v3/optimizations/{id} | Create or Update FPO optimization and run it.
*FrequenciesApi* | [**get_pa_frequencies**](docs/FrequenciesApi.md#get_pa_frequencies) | **GET** /analytics/engines/pa/v3/frequencies | Get PA frequencies
*FrequenciesApi* | [**get_spar_frequencies**](docs/FrequenciesApi.md#get_spar_frequencies) | **GET** /analytics/engines/spar/v3/frequencies | Get SPAR frequencies
*FrequenciesApi* | [**get_vault_frequencies**](docs/FrequenciesApi.md#get_vault_frequencies) | **GET** /analytics/engines/vault/v3/frequencies | Get Vault frequencies
*GroupsApi* | [**get_pa_grouping_frequencies**](docs/GroupsApi.md#get_pa_grouping_frequencies) | **GET** /analytics/engines/pa/v3/grouping-frequencies | Get PA grouping frequencies
*GroupsApi* | [**get_pa_groups**](docs/GroupsApi.md#get_pa_groups) | **GET** /analytics/engines/pa/v3/groups | Get PA groups
*LinkedPATemplatesApi* | [**create_linked_pa_templates**](docs/LinkedPATemplatesApi.md#create_linked_pa_templates) | **POST** /analytics/engines/pa/v3/linked-templates | Create a linked PA template
*LinkedPATemplatesApi* | [**delete_linked_pa_templates**](docs/LinkedPATemplatesApi.md#delete_linked_pa_templates) | **DELETE** /analytics/engines/pa/v3/linked-templates/{id} | Delete a linked PA template.
*LinkedPATemplatesApi* | [**get_linked_pa_templates**](docs/LinkedPATemplatesApi.md#get_linked_pa_templates) | **GET** /analytics/engines/pa/v3/linked-templates | Get linked PA templates
*LinkedPATemplatesApi* | [**get_linked_pa_templates_by_id**](docs/LinkedPATemplatesApi.md#get_linked_pa_templates_by_id) | **GET** /analytics/engines/pa/v3/linked-templates/{id} | Get linked PA template by id
*LinkedPATemplatesApi* | [**update_linked_pa_templates**](docs/LinkedPATemplatesApi.md#update_linked_pa_templates) | **PUT** /analytics/engines/pa/v3/linked-templates/{id} | Update a linked PA template
*NPOOptimizerApi* | [**cancel_optimization_by_id**](docs/NPOOptimizerApi.md#cancel_optimization_by_id) | **DELETE** /analytics/engines/npo/v3/optimizations/{id} | Cancel NPO optimization by id
*NPOOptimizerApi* | [**get_optimization_parameters**](docs/NPOOptimizerApi.md#get_optimization_parameters) | **GET** /analytics/engines/npo/v3/optimizations/{id} | Get NPO optimization parameters by id
*NPOOptimizerApi* | [**get_optimization_result**](docs/NPOOptimizerApi.md#get_optimization_result) | **GET** /analytics/engines/npo/v3/optimizations/{id}/result | Get NPO optimization result by id
*NPOOptimizerApi* | [**get_optimization_status_by_id**](docs/NPOOptimizerApi.md#get_optimization_status_by_id) | **GET** /analytics/engines/npo/v3/optimizations/{id}/status | Get NPO optimization status by id
*NPOOptimizerApi* | [**post_and_optimize**](docs/NPOOptimizerApi.md#post_and_optimize) | **POST** /analytics/engines/npo/v3/optimizations | Create and Run NPO optimization
*NPOOptimizerApi* | [**put_and_optimize**](docs/NPOOptimizerApi.md#put_and_optimize) | **PUT** /analytics/engines/npo/v3/optimizations/{id} | Create or Update NPO optimization and run it.
*PACalculationsApi* | [**cancel_calculation_by_id**](docs/PACalculationsApi.md#cancel_calculation_by_id) | **DELETE** /analytics/engines/pa/v3/calculations/{id} | Cancel PA calculation by id
*PACalculationsApi* | [**get_all_calculations**](docs/PACalculationsApi.md#get_all_calculations) | **GET** /analytics/engines/pa/v3/calculations | Get all calculations
*PACalculationsApi* | [**get_calculation_parameters**](docs/PACalculationsApi.md#get_calculation_parameters) | **GET** /analytics/engines/pa/v3/calculations/{id} | Get PA calculation parameters by id
*PACalculationsApi* | [**get_calculation_status_by_id**](docs/PACalculationsApi.md#get_calculation_status_by_id) | **GET** /analytics/engines/pa/v3/calculations/{id}/status | Get PA calculation status by id
*PACalculationsApi* | [**get_calculation_unit_result_by_id**](docs/PACalculationsApi.md#get_calculation_unit_result_by_id) | **GET** /analytics/engines/pa/v3/calculations/{id}/units/{unitId}/result | Get PA calculation result by id
*PACalculationsApi* | [**post_and_calculate**](docs/PACalculationsApi.md#post_and_calculate) | **POST** /analytics/engines/pa/v3/calculations | Create and Run PA calculation
*PACalculationsApi* | [**put_and_calculate**](docs/PACalculationsApi.md#put_and_calculate) | **PUT** /analytics/engines/pa/v3/calculations/{id} | Create or Update PA calculation and run it.
*PricingSourcesApi* | [**get_pa_pricing_sources**](docs/PricingSourcesApi.md#get_pa_pricing_sources) | **GET** /analytics/engines/pa/v3/pricing-sources | Get PA pricing sources
*PubCalculationsApi* | [**cancel_calculation_by_id**](docs/PubCalculationsApi.md#cancel_calculation_by_id) | **DELETE** /analytics/engines/pub/v3/calculations/{id} | Cancel Pub calculation by id
*PubCalculationsApi* | [**get_all_calculations**](docs/PubCalculationsApi.md#get_all_calculations) | **GET** /analytics/engines/pub/v3/calculations | Get all calculations
*PubCalculationsApi* | [**get_calculation_parameters**](docs/PubCalculationsApi.md#get_calculation_parameters) | **GET** /analytics/engines/pub/v3/calculations/{id} | Get Pub calculation parameters by id
*PubCalculationsApi* | [**get_calculation_status_by_id**](docs/PubCalculationsApi.md#get_calculation_status_by_id) | **GET** /analytics/engines/pub/v3/calculations/{id}/status | Get Pub calculation status by id
*PubCalculationsApi* | [**get_calculation_unit_result_by_id**](docs/PubCalculationsApi.md#get_calculation_unit_result_by_id) | **GET** /analytics/engines/pub/v3/calculations/{id}/units/{unitId}/result | Get Pub calculation result by id
*PubCalculationsApi* | [**post_and_calculate**](docs/PubCalculationsApi.md#post_and_calculate) | **POST** /analytics/engines/pub/v3/calculations | Create and Run Pub calculation
*PubCalculationsApi* | [**put_and_calculate**](docs/PubCalculationsApi.md#put_and_calculate) | **PUT** /analytics/engines/pub/v3/calculations/{id} | Create or Update Pub calculation and run it.
*QuantCalculationsApi* | [**cancel_calculation_by_id**](docs/QuantCalculationsApi.md#cancel_calculation_by_id) | **DELETE** /analytics/engines/quant/v3/calculations/{id} | Cancel Quant calculation by id
*QuantCalculationsApi* | [**get_all_calculations**](docs/QuantCalculationsApi.md#get_all_calculations) | **GET** /analytics/engines/quant/v3/calculations | Get all calculations
*QuantCalculationsApi* | [**get_calculation_parameters**](docs/QuantCalculationsApi.md#get_calculation_parameters) | **GET** /analytics/engines/quant/v3/calculations/{id} | Get Quant Engine calculation parameters by id
*QuantCalculationsApi* | [**get_calculation_status_by_id**](docs/QuantCalculationsApi.md#get_calculation_status_by_id) | **GET** /analytics/engines/quant/v3/calculations/{id}/status | Get Quant Engine calculation status by id
*QuantCalculationsApi* | [**get_calculation_unit_info_by_id**](docs/QuantCalculationsApi.md#get_calculation_unit_info_by_id) | **GET** /analytics/engines/quant/v3/calculations/{id}/units/{unitId}/info | Get Quant Engine calculation metadata information by id
*QuantCalculationsApi* | [**get_calculation_unit_result_by_id**](docs/QuantCalculationsApi.md#get_calculation_unit_result_by_id) | **GET** /analytics/engines/quant/v3/calculations/{id}/units/{unitId}/result | Get Quant Engine calculation result by id
*QuantCalculationsApi* | [**post_and_calculate**](docs/QuantCalculationsApi.md#post_and_calculate) | **POST** /analytics/engines/quant/v3/calculations | Create and Run Quant Engine calculation
*QuantCalculationsApi* | [**put_and_calculate**](docs/QuantCalculationsApi.md#put_and_calculate) | **PUT** /analytics/engines/quant/v3/calculations/{id} | Create or update Quant Engine calculation and run it.
*SPARCalculationsApi* | [**cancel_calculation_by_id**](docs/SPARCalculationsApi.md#cancel_calculation_by_id) | **DELETE** /analytics/engines/spar/v3/calculations/{id} | Cancel SPAR calculation
*SPARCalculationsApi* | [**get_all_calculations**](docs/SPARCalculationsApi.md#get_all_calculations) | **GET** /analytics/engines/spar/v3/calculations | Get all calculations
*SPARCalculationsApi* | [**get_calculation_parameters**](docs/SPARCalculationsApi.md#get_calculation_parameters) | **GET** /analytics/engines/spar/v3/calculations/{id} | Get SPAR calculation parameters by id
*SPARCalculationsApi* | [**get_calculation_status_by_id**](docs/SPARCalculationsApi.md#get_calculation_status_by_id) | **GET** /analytics/engines/spar/v3/calculations/{id}/status | Get SPAR calculation status by id
*SPARCalculationsApi* | [**get_calculation_unit_result_by_id**](docs/SPARCalculationsApi.md#get_calculation_unit_result_by_id) | **GET** /analytics/engines/spar/v3/calculations/{id}/units/{unitId}/result | Get SPAR calculation result by id
*SPARCalculationsApi* | [**post_and_calculate**](docs/SPARCalculationsApi.md#post_and_calculate) | **POST** /analytics/engines/spar/v3/calculations | Create and Run SPAR calculation
*SPARCalculationsApi* | [**put_and_calculate**](docs/SPARCalculationsApi.md#put_and_calculate) | **PUT** /analytics/engines/spar/v3/calculations/{id} | Create or Update SPAR calculation and run it.
*StrategyDocumentsApi* | [**get_axioma_equity_strategy_documents**](docs/StrategyDocumentsApi.md#get_axioma_equity_strategy_documents) | **GET** /analytics/engines/axp/v3/strategies/{path} | Get Axioma Equity strategy documents and sub-directories in a directory
*StrategyDocumentsApi* | [**get_axioma_fi_strategy_documents**](docs/StrategyDocumentsApi.md#get_axioma_fi_strategy_documents) | **GET** /analytics/engines/afi/v3/strategies/{path} | Get Axioma FI strategy documents and sub-directories in a directory
*StrategyDocumentsApi* | [**get_barra_strategy_documents**](docs/StrategyDocumentsApi.md#get_barra_strategy_documents) | **GET** /analytics/engines/bpm/v3/strategies/{path} | Get Barra strategy documents and sub-directories in a directory
*StrategyDocumentsApi* | [**get_fpo_strategy_documents**](docs/StrategyDocumentsApi.md#get_fpo_strategy_documents) | **GET** /analytics/engines/fpo/v3/strategies/{path} | Get FactSet Portfolio Optimizer strategy documents and sub-directories in a directory
*StrategyDocumentsApi* | [**get_northfield_strategy_documents**](docs/StrategyDocumentsApi.md#get_northfield_strategy_documents) | **GET** /analytics/engines/npo/v3/strategies/{path} | Get Northfield strategy documents and sub-directories in a directory
*TemplatedPAComponentsApi* | [**create_templated_pa_components**](docs/TemplatedPAComponentsApi.md#create_templated_pa_components) | **POST** /analytics/engines/pa/v3/templated-components | Create templated PA component
*TemplatedPAComponentsApi* | [**delete_templated_pa_components**](docs/TemplatedPAComponentsApi.md#delete_templated_pa_components) | **DELETE** /analytics/engines/pa/v3/templated-components/{id} | Delete templated PA component
*TemplatedPAComponentsApi* | [**get_templated_pa_component_by_id**](docs/TemplatedPAComponentsApi.md#get_templated_pa_component_by_id) | **GET** /analytics/engines/pa/v3/templated-components/{id} | Get templated PA component by id
*TemplatedPAComponentsApi* | [**get_templated_pa_components_in_path**](docs/TemplatedPAComponentsApi.md#get_templated_pa_components_in_path) | **GET** /analytics/engines/pa/v3/templated-components | Get templated PA components in path
*TemplatedPAComponentsApi* | [**update_templated_pa_components**](docs/TemplatedPAComponentsApi.md#update_templated_pa_components) | **PUT** /analytics/engines/pa/v3/templated-components/{id} | Update templated PA component
*UnlinkedPATemplatesApi* | [**create_unlinked_pa_templates**](docs/UnlinkedPATemplatesApi.md#create_unlinked_pa_templates) | **POST** /analytics/engines/pa/v3/unlinked-templates | Create unlinked PA template
*UnlinkedPATemplatesApi* | [**delete_unlinked_pa_templates**](docs/UnlinkedPATemplatesApi.md#delete_unlinked_pa_templates) | **DELETE** /analytics/engines/pa/v3/unlinked-templates/{id} | Delete unlinked PA template
*UnlinkedPATemplatesApi* | [**get_default_unlinked_pa_template_types**](docs/UnlinkedPATemplatesApi.md#get_default_unlinked_pa_template_types) | **GET** /analytics/engines/pa/v3/unlinked-templates/template-types | Get default unlinked PA template types.
*UnlinkedPATemplatesApi* | [**get_details_type**](docs/UnlinkedPATemplatesApi.md#get_details_type) | **GET** /analytics/engines/pa/v3/unlinked-templates/template-types/{id} | Get unlinked PA template type details by id.
*UnlinkedPATemplatesApi* | [**get_unlinked_pa_templates**](docs/UnlinkedPATemplatesApi.md#get_unlinked_pa_templates) | **GET** /analytics/engines/pa/v3/unlinked-templates | Get unlinked PA templates
*UnlinkedPATemplatesApi* | [**get_unlinked_pa_templates_by_id**](docs/UnlinkedPATemplatesApi.md#get_unlinked_pa_templates_by_id) | **GET** /analytics/engines/pa/v3/unlinked-templates/{id} | Get unlinked PA template details by id
*UnlinkedPATemplatesApi* | [**update_unlinked_pa_templates**](docs/UnlinkedPATemplatesApi.md#update_unlinked_pa_templates) | **PUT** /analytics/engines/pa/v3/unlinked-templates/{id} | Update unlinked PA template
*VaultCalculationsApi* | [**cancel_calculation_by_id**](docs/VaultCalculationsApi.md#cancel_calculation_by_id) | **DELETE** /analytics/engines/vault/v3/calculations/{id} | Cancel Vault calculation by id
*VaultCalculationsApi* | [**get_all_calculations**](docs/VaultCalculationsApi.md#get_all_calculations) | **GET** /analytics/engines/vault/v3/calculations | Get all calculations
*VaultCalculationsApi* | [**get_calculation_parameters**](docs/VaultCalculationsApi.md#get_calculation_parameters) | **GET** /analytics/engines/vault/v3/calculations/{id} | Get Vault calculation parameters by id
*VaultCalculationsApi* | [**get_calculation_status_by_id**](docs/VaultCalculationsApi.md#get_calculation_status_by_id) | **GET** /analytics/engines/vault/v3/calculations/{id}/status | Get Vault calculation status by id
*VaultCalculationsApi* | [**get_calculation_unit_result_by_id**](docs/VaultCalculationsApi.md#get_calculation_unit_result_by_id) | **GET** /analytics/engines/vault/v3/calculations/{id}/units/{unitId}/result | Get Vault calculation result by id
*VaultCalculationsApi* | [**post_and_calculate**](docs/VaultCalculationsApi.md#post_and_calculate) | **POST** /analytics/engines/vault/v3/calculations | Create and Run Vault calculation
*VaultCalculationsApi* | [**put_and_calculate**](docs/VaultCalculationsApi.md#put_and_calculate) | **PUT** /analytics/engines/vault/v3/calculations/{id} | Create or Update Vault calculation and run it.


## Documentation For Models

 - [AFIOptimizationParameters](docs/AFIOptimizationParameters.md)
 - [AFIOptimizationParametersRoot](docs/AFIOptimizationParametersRoot.md)
 - [AFIOptimizerStrategy](docs/AFIOptimizerStrategy.md)
 - [AFIOptimizerStrategyOverrides](docs/AFIOptimizerStrategyOverrides.md)
 - [AccountDirectories](docs/AccountDirectories.md)
 - [AccountDirectoriesRoot](docs/AccountDirectoriesRoot.md)
 - [AxiomaEquityOptimizationParameters](docs/AxiomaEquityOptimizationParameters.md)
 - [AxiomaEquityOptimizationParametersRoot](docs/AxiomaEquityOptimizationParametersRoot.md)
 - [AxiomaEquityOptimizerStrategy](docs/AxiomaEquityOptimizerStrategy.md)
 - [AxiomaEquityOptimizerStrategyOverrides](docs/AxiomaEquityOptimizerStrategyOverrides.md)
 - [BPMOptimization](docs/BPMOptimization.md)
 - [BPMOptimizationParameters](docs/BPMOptimizationParameters.md)
 - [BPMOptimizationParametersRoot](docs/BPMOptimizationParametersRoot.md)
 - [BPMOptimizerStrategy](docs/BPMOptimizerStrategy.md)
 - [BPMOptimizerStrategyAlphaOverride](docs/BPMOptimizerStrategyAlphaOverride.md)
 - [BPMOptimizerStrategyOverrides](docs/BPMOptimizerStrategyOverrides.md)
 - [CalculationInfo](docs/CalculationInfo.md)
 - [CalculationInfoRoot](docs/CalculationInfoRoot.md)
 - [CalculationMeta](docs/CalculationMeta.md)
 - [CalculationStatus](docs/CalculationStatus.md)
 - [CalculationStatusMeta](docs/CalculationStatusMeta.md)
 - [CalculationStatusRoot](docs/CalculationStatusRoot.md)
 - [CalculationUnitStatus](docs/CalculationUnitStatus.md)
 - [CalculationUnitStatusMeta](docs/CalculationUnitStatusMeta.md)
 - [CalculationsSummary](docs/CalculationsSummary.md)
 - [CalculationsSummaryRoot](docs/CalculationsSummaryRoot.md)
 - [ClientErrorResponse](docs/ClientErrorResponse.md)
 - [Column](docs/Column.md)
 - [ColumnRoot](docs/ColumnRoot.md)
 - [ColumnStatistic](docs/ColumnStatistic.md)
 - [ColumnStatisticRoot](docs/ColumnStatisticRoot.md)
 - [ColumnSummary](docs/ColumnSummary.md)
 - [ColumnSummaryRoot](docs/ColumnSummaryRoot.md)
 - [ComponentSummary](docs/ComponentSummary.md)
 - [ComponentSummaryRoot](docs/ComponentSummaryRoot.md)
 - [ConfigurationAccount](docs/ConfigurationAccount.md)
 - [ConstraintAction](docs/ConstraintAction.md)
 - [Currency](docs/Currency.md)
 - [CurrencyRoot](docs/CurrencyRoot.md)
 - [DateParametersSummary](docs/DateParametersSummary.md)
 - [DateParametersSummaryRoot](docs/DateParametersSummaryRoot.md)
 - [DocumentDirectories](docs/DocumentDirectories.md)
 - [DocumentDirectoriesRoot](docs/DocumentDirectoriesRoot.md)
 - [Error](docs/Error.md)
 - [ErrorSource](docs/ErrorSource.md)
 - [EventSummary](docs/EventSummary.md)
 - [FIABCalculationParameters](docs/FIABCalculationParameters.md)
 - [FIABCalculationStatus](docs/FIABCalculationStatus.md)
 - [FIABCalculationStatusSummary](docs/FIABCalculationStatusSummary.md)
 - [FIABDateParameters](docs/FIABDateParameters.md)
 - [FIABIdentifier](docs/FIABIdentifier.md)
 - [FIBalloonExtension](docs/FIBalloonExtension.md)
 - [FIBankLoans](docs/FIBankLoans.md)
 - [FICalculationParameters](docs/FICalculationParameters.md)
 - [FICalculationParametersRoot](docs/FICalculationParametersRoot.md)
 - [FICashflows](docs/FICashflows.md)
 - [FIDiscountCurveInfo](docs/FIDiscountCurveInfo.md)
 - [FIDiscountCurveInfoRoot](docs/FIDiscountCurveInfoRoot.md)
 - [FIJobSettings](docs/FIJobSettings.md)
 - [FILoss](docs/FILoss.md)
 - [FIMarketEnvironment](docs/FIMarketEnvironment.md)
 - [FIMunicipalBonds](docs/FIMunicipalBonds.md)
 - [FIMunicipalBondsForJobSettings](docs/FIMunicipalBondsForJobSettings.md)
 - [FIPrepay](docs/FIPrepay.md)
 - [FIPrepayLockout](docs/FIPrepayLockout.md)
 - [FIReferencePrepay](docs/FIReferencePrepay.md)
 - [FIReferenceSecurity](docs/FIReferenceSecurity.md)
 - [FISecurity](docs/FISecurity.md)
 - [FIServicerAdvances](docs/FIServicerAdvances.md)
 - [FIServicerAdvancesForSecurities](docs/FIServicerAdvancesForSecurities.md)
 - [FIStructuredProductsForJobSettings](docs/FIStructuredProductsForJobSettings.md)
 - [FIStructuredProductsForSecurities](docs/FIStructuredProductsForSecurities.md)
 - [FPOAccount](docs/FPOAccount.md)
 - [FPOObjective](docs/FPOObjective.md)
 - [FPOOptimizationParameters](docs/FPOOptimizationParameters.md)
 - [FPOOptimizationParametersRoot](docs/FPOOptimizationParametersRoot.md)
 - [FPOOptimizerStrategy](docs/FPOOptimizerStrategy.md)
 - [FPOOptimizerStrategyOverrides](docs/FPOOptimizerStrategyOverrides.md)
 - [Frequency](docs/Frequency.md)
 - [FrequencyRoot](docs/FrequencyRoot.md)
 - [Group](docs/Group.md)
 - [GroupRoot](docs/GroupRoot.md)
 - [LinkedPATemplate](docs/LinkedPATemplate.md)
 - [LinkedPATemplateParameters](docs/LinkedPATemplateParameters.md)
 - [LinkedPATemplateParametersRoot](docs/LinkedPATemplateParametersRoot.md)
 - [LinkedPATemplatePostSummary](docs/LinkedPATemplatePostSummary.md)
 - [LinkedPATemplatePostSummaryRoot](docs/LinkedPATemplatePostSummaryRoot.md)
 - [LinkedPATemplateRoot](docs/LinkedPATemplateRoot.md)
 - [LinkedPATemplateSummary](docs/LinkedPATemplateSummary.md)
 - [LinkedPATemplateSummaryRoot](docs/LinkedPATemplateSummaryRoot.md)
 - [LinkedPATemplateUpdateParameters](docs/LinkedPATemplateUpdateParameters.md)
 - [LinkedPATemplateUpdateParametersRoot](docs/LinkedPATemplateUpdateParametersRoot.md)
 - [NPOOptimizationParameters](docs/NPOOptimizationParameters.md)
 - [NPOOptimizationParametersRoot](docs/NPOOptimizationParametersRoot.md)
 - [NPOOptimizerStrategy](docs/NPOOptimizerStrategy.md)
 - [NPOOptimizerStrategyOverrides](docs/NPOOptimizerStrategyOverrides.md)
 - [ObjectRoot](docs/ObjectRoot.md)
 - [OptimalPortfolio](docs/OptimalPortfolio.md)
 - [Optimization](docs/Optimization.md)
 - [OptimizerAccount](docs/OptimizerAccount.md)
 - [OptimizerAccountOverrides](docs/OptimizerAccountOverrides.md)
 - [OptimizerOptimalHoldings](docs/OptimizerOptimalHoldings.md)
 - [OptimizerOutputTypes](docs/OptimizerOutputTypes.md)
 - [OptimizerTradesList](docs/OptimizerTradesList.md)
 - [PACalculationColumn](docs/PACalculationColumn.md)
 - [PACalculationDataSources](docs/PACalculationDataSources.md)
 - [PACalculationGroup](docs/PACalculationGroup.md)
 - [PACalculationParameters](docs/PACalculationParameters.md)
 - [PACalculationParametersRoot](docs/PACalculationParametersRoot.md)
 - [PACalculationPricingSource](docs/PACalculationPricingSource.md)
 - [PAComponent](docs/PAComponent.md)
 - [PAComponentData](docs/PAComponentData.md)
 - [PAComponentRoot](docs/PAComponentRoot.md)
 - [PADateParameters](docs/PADateParameters.md)
 - [PAIdentifier](docs/PAIdentifier.md)
 - [PAPricingSource](docs/PAPricingSource.md)
 - [PAPricingSourceRoot](docs/PAPricingSourceRoot.md)
 - [PaDoc](docs/PaDoc.md)
 - [PaginationInfo](docs/PaginationInfo.md)
 - [PaginationMeta](docs/PaginationMeta.md)
 - [PubCalculationParameters](docs/PubCalculationParameters.md)
 - [PubCalculationParametersRoot](docs/PubCalculationParametersRoot.md)
 - [PubDateParameters](docs/PubDateParameters.md)
 - [PubIdentifier](docs/PubIdentifier.md)
 - [QuantAllUniversalScreenParameters](docs/QuantAllUniversalScreenParameters.md)
 - [QuantCalculationMeta](docs/QuantCalculationMeta.md)
 - [QuantCalculationParameters](docs/QuantCalculationParameters.md)
 - [QuantCalculationParametersRoot](docs/QuantCalculationParametersRoot.md)
 - [QuantDate](docs/QuantDate.md)
 - [QuantDateList](docs/QuantDateList.md)
 - [QuantDateListObsolete](docs/QuantDateListObsolete.md)
 - [QuantFdsDate](docs/QuantFdsDate.md)
 - [QuantFdsDateObsolete](docs/QuantFdsDateObsolete.md)
 - [QuantFormula](docs/QuantFormula.md)
 - [QuantFqlExpression](docs/QuantFqlExpression.md)
 - [QuantFqlExpressionObsolete](docs/QuantFqlExpressionObsolete.md)
 - [QuantIdentifierUniverse](docs/QuantIdentifierUniverse.md)
 - [QuantIdentifierUniverseObsolete](docs/QuantIdentifierUniverseObsolete.md)
 - [QuantScreeningExpression](docs/QuantScreeningExpression.md)
 - [QuantScreeningExpressionObsolete](docs/QuantScreeningExpressionObsolete.md)
 - [QuantScreeningExpressionUniverse](docs/QuantScreeningExpressionUniverse.md)
 - [QuantScreeningExpressionUniverseObsolete](docs/QuantScreeningExpressionUniverseObsolete.md)
 - [QuantUniversalScreenParameter](docs/QuantUniversalScreenParameter.md)
 - [QuantUniversalScreenParameterObsolete](docs/QuantUniversalScreenParameterObsolete.md)
 - [QuantUniversalScreenUniverse](docs/QuantUniversalScreenUniverse.md)
 - [QuantUniversalScreenUniverseObsolete](docs/QuantUniversalScreenUniverseObsolete.md)
 - [QuantUniverse](docs/QuantUniverse.md)
 - [ReturnType](docs/ReturnType.md)
 - [SPARAccounts](docs/SPARAccounts.md)
 - [SPARAccountsRoot](docs/SPARAccountsRoot.md)
 - [SPARBenchmark](docs/SPARBenchmark.md)
 - [SPARBenchmarkRoot](docs/SPARBenchmarkRoot.md)
 - [SPARCalculationParameters](docs/SPARCalculationParameters.md)
 - [SPARCalculationParametersRoot](docs/SPARCalculationParametersRoot.md)
 - [SPARDateParameters](docs/SPARDateParameters.md)
 - [SPARIdentifier](docs/SPARIdentifier.md)
 - [TemplateContentTypes](docs/TemplateContentTypes.md)
 - [TemplatedPAComponent](docs/TemplatedPAComponent.md)
 - [TemplatedPAComponentParameters](docs/TemplatedPAComponentParameters.md)
 - [TemplatedPAComponentParametersRoot](docs/TemplatedPAComponentParametersRoot.md)
 - [TemplatedPAComponentPostSummary](docs/TemplatedPAComponentPostSummary.md)
 - [TemplatedPAComponentPostSummaryRoot](docs/TemplatedPAComponentPostSummaryRoot.md)
 - [TemplatedPAComponentRoot](docs/TemplatedPAComponentRoot.md)
 - [TemplatedPAComponentSummary](docs/TemplatedPAComponentSummary.md)
 - [TemplatedPAComponentSummaryRoot](docs/TemplatedPAComponentSummaryRoot.md)
 - [TemplatedPAComponentUpdateParameters](docs/TemplatedPAComponentUpdateParameters.md)
 - [TemplatedPAComponentUpdateParametersRoot](docs/TemplatedPAComponentUpdateParametersRoot.md)
 - [UnlinkedPATemplate](docs/UnlinkedPATemplate.md)
 - [UnlinkedPATemplateCategoryAndType](docs/UnlinkedPATemplateCategoryAndType.md)
 - [UnlinkedPATemplateCategoryAndTypeDetails](docs/UnlinkedPATemplateCategoryAndTypeDetails.md)
 - [UnlinkedPATemplateCategoryAndTypeDetailsRoot](docs/UnlinkedPATemplateCategoryAndTypeDetailsRoot.md)
 - [UnlinkedPATemplateCategoryAndTypeRoot](docs/UnlinkedPATemplateCategoryAndTypeRoot.md)
 - [UnlinkedPATemplateColumnDetails](docs/UnlinkedPATemplateColumnDetails.md)
 - [UnlinkedPATemplateGroupDetails](docs/UnlinkedPATemplateGroupDetails.md)
 - [UnlinkedPATemplateParameters](docs/UnlinkedPATemplateParameters.md)
 - [UnlinkedPATemplateParametersRoot](docs/UnlinkedPATemplateParametersRoot.md)
 - [UnlinkedPATemplatePostSummary](docs/UnlinkedPATemplatePostSummary.md)
 - [UnlinkedPATemplatePostSummaryRoot](docs/UnlinkedPATemplatePostSummaryRoot.md)
 - [UnlinkedPATemplateRoot](docs/UnlinkedPATemplateRoot.md)
 - [UnlinkedPATemplateSummary](docs/UnlinkedPATemplateSummary.md)
 - [UnlinkedPATemplateSummaryRoot](docs/UnlinkedPATemplateSummaryRoot.md)
 - [UnlinkedPATemplateUpdateParameters](docs/UnlinkedPATemplateUpdateParameters.md)
 - [UnlinkedPATemplateUpdateParametersRoot](docs/UnlinkedPATemplateUpdateParametersRoot.md)
 - [VaultCalculationParameters](docs/VaultCalculationParameters.md)
 - [VaultCalculationParametersRoot](docs/VaultCalculationParametersRoot.md)
 - [VaultComponent](docs/VaultComponent.md)
 - [VaultComponentRoot](docs/VaultComponentRoot.md)
 - [VaultConfiguration](docs/VaultConfiguration.md)
 - [VaultConfigurationRoot](docs/VaultConfigurationRoot.md)
 - [VaultConfigurationSummary](docs/VaultConfigurationSummary.md)
 - [VaultConfigurationSummaryRoot](docs/VaultConfigurationSummaryRoot.md)
 - [VaultDateParameters](docs/VaultDateParameters.md)
 - [VaultIdentifier](docs/VaultIdentifier.md)


## Documentation For Authorization


## Basic

- **Type**: HTTP basic authentication


## Bearer

- **Type**: Bearer authentication


## Author

api@factset.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in fds.analyticsapi.engines.apis and fds.analyticsapi.engines.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from fds.analyticsapi.engines.api.default_api import DefaultApi`
- `from fds.analyticsapi.engines.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import fds.analyticsapi.engines
from fds.analyticsapi.engines.apis import *
from fds.analyticsapi.engines.models import *
```

