# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class ChangeAccountPasswordRequest(TeaModel):
    def __init__(self, account_name=None, drds_instance_id=None, password=None):
        self.account_name = account_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.password = password  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeAccountPasswordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.password is not None:
            result['Password'] = self.password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        return self


class ChangeAccountPasswordResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeAccountPasswordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ChangeAccountPasswordResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ChangeAccountPasswordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeAccountPasswordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ChangeAccountPasswordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeInstanceAzoneRequest(TeaModel):
    def __init__(self, drds_instance_id=None, drds_region_id=None, origin_azone_id=None, target_azone_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.drds_region_id = drds_region_id  # type: str
        self.origin_azone_id = origin_azone_id  # type: str
        self.target_azone_id = target_azone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeInstanceAzoneRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.drds_region_id is not None:
            result['DrdsRegionId'] = self.drds_region_id
        if self.origin_azone_id is not None:
            result['OriginAzoneId'] = self.origin_azone_id
        if self.target_azone_id is not None:
            result['TargetAzoneId'] = self.target_azone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('DrdsRegionId') is not None:
            self.drds_region_id = m.get('DrdsRegionId')
        if m.get('OriginAzoneId') is not None:
            self.origin_azone_id = m.get('OriginAzoneId')
        if m.get('TargetAzoneId') is not None:
            self.target_azone_id = m.get('TargetAzoneId')
        return self


class ChangeInstanceAzoneResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeInstanceAzoneResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ChangeInstanceAzoneResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ChangeInstanceAzoneResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeInstanceAzoneResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ChangeInstanceAzoneResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeInstanceNetworkRequest(TeaModel):
    def __init__(self, classic_expired_days=None, drds_instance_id=None, retain_classic=None,
                 src_instance_network_type=None, vpc_id=None, vswitch_id=None):
        self.classic_expired_days = classic_expired_days  # type: int
        self.drds_instance_id = drds_instance_id  # type: str
        self.retain_classic = retain_classic  # type: bool
        self.src_instance_network_type = src_instance_network_type  # type: str
        self.vpc_id = vpc_id  # type: str
        self.vswitch_id = vswitch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeInstanceNetworkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.classic_expired_days is not None:
            result['ClassicExpiredDays'] = self.classic_expired_days
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.retain_classic is not None:
            result['RetainClassic'] = self.retain_classic
        if self.src_instance_network_type is not None:
            result['SrcInstanceNetworkType'] = self.src_instance_network_type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClassicExpiredDays') is not None:
            self.classic_expired_days = m.get('ClassicExpiredDays')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RetainClassic') is not None:
            self.retain_classic = m.get('RetainClassic')
        if m.get('SrcInstanceNetworkType') is not None:
            self.src_instance_network_type = m.get('SrcInstanceNetworkType')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        return self


class ChangeInstanceNetworkResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeInstanceNetworkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ChangeInstanceNetworkResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ChangeInstanceNetworkResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeInstanceNetworkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ChangeInstanceNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckConnectivityRequest(TeaModel):
    def __init__(self, db_info=None, db_type=None):
        self.db_info = db_info  # type: dict[str, any]
        self.db_type = db_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckConnectivityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_info is not None:
            result['DbInfo'] = self.db_info
        if self.db_type is not None:
            result['DbType'] = self.db_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInfo') is not None:
            self.db_info = m.get('DbInfo')
        if m.get('DbType') is not None:
            self.db_type = m.get('DbType')
        return self


class CheckConnectivityShrinkRequest(TeaModel):
    def __init__(self, db_info_shrink=None, db_type=None):
        self.db_info_shrink = db_info_shrink  # type: str
        self.db_type = db_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckConnectivityShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_info_shrink is not None:
            result['DbInfo'] = self.db_info_shrink
        if self.db_type is not None:
            result['DbType'] = self.db_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInfo') is not None:
            self.db_info_shrink = m.get('DbInfo')
        if m.get('DbType') is not None:
            self.db_type = m.get('DbType')
        return self


class CheckConnectivityResponseBodyCheckConnectivityResult(TeaModel):
    def __init__(self, message=None, success=None):
        self.message = message  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckConnectivityResponseBodyCheckConnectivityResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckConnectivityResponseBody(TeaModel):
    def __init__(self, check_connectivity_result=None, request_id=None, success=None):
        self.check_connectivity_result = check_connectivity_result  # type: CheckConnectivityResponseBodyCheckConnectivityResult
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.check_connectivity_result:
            self.check_connectivity_result.validate()

    def to_map(self):
        _map = super(CheckConnectivityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_connectivity_result is not None:
            result['CheckConnectivityResult'] = self.check_connectivity_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckConnectivityResult') is not None:
            temp_model = CheckConnectivityResponseBodyCheckConnectivityResult()
            self.check_connectivity_result = temp_model.from_map(m['CheckConnectivityResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckConnectivityResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckConnectivityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckConnectivityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckConnectivityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckDrdsDbNameRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckDrdsDbNameRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class CheckDrdsDbNameResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: bool
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckDrdsDbNameResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckDrdsDbNameResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckDrdsDbNameResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckDrdsDbNameResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckDrdsDbNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckExpandStatusRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckExpandStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class CheckExpandStatusResponseBodyData(TeaModel):
    def __init__(self, is_active=None, msg=None):
        self.is_active = is_active  # type: bool
        self.msg = msg  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckExpandStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_active is not None:
            result['IsActive'] = self.is_active
        if self.msg is not None:
            result['Msg'] = self.msg
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsActive') is not None:
            self.is_active = m.get('IsActive')
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        return self


class CheckExpandStatusResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: CheckExpandStatusResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CheckExpandStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CheckExpandStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckExpandStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckExpandStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckExpandStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckExpandStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckNewTableNameValidRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None, table_name=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.table_name = table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckNewTableNameValidRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class CheckNewTableNameValidResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckNewTableNameValidResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckNewTableNameValidResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckNewTableNameValidResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckNewTableNameValidResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckNewTableNameValidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckRdsSuperAccountRequest(TeaModel):
    def __init__(self, account_name=None, db_instance_id=None, drds_instance_id=None, password=None):
        self.account_name = account_name  # type: str
        self.db_instance_id = db_instance_id  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.password = password  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckRdsSuperAccountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.password is not None:
            result['Password'] = self.password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        return self


class CheckRdsSuperAccountResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckRdsSuperAccountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckRdsSuperAccountResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckRdsSuperAccountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckRdsSuperAccountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckRdsSuperAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckSqlAuditEnableStatusRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckSqlAuditEnableStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class CheckSqlAuditEnableStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, status=None, success=None):
        self.request_id = request_id  # type: str
        self.status = status  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckSqlAuditEnableStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckSqlAuditEnableStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CheckSqlAuditEnableStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckSqlAuditEnableStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckSqlAuditEnableStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfigureDrdsDbInstancesRequestDbInstance(TeaModel):
    def __init__(self, master_db_instance_id=None, slave_db_instance_id=None, slave_db_instance_type=None):
        self.master_db_instance_id = master_db_instance_id  # type: str
        self.slave_db_instance_id = slave_db_instance_id  # type: str
        self.slave_db_instance_type = slave_db_instance_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfigureDrdsDbInstancesRequestDbInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.master_db_instance_id is not None:
            result['MasterDbInstanceId'] = self.master_db_instance_id
        if self.slave_db_instance_id is not None:
            result['SlaveDbInstanceId'] = self.slave_db_instance_id
        if self.slave_db_instance_type is not None:
            result['SlaveDbInstanceType'] = self.slave_db_instance_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MasterDbInstanceId') is not None:
            self.master_db_instance_id = m.get('MasterDbInstanceId')
        if m.get('SlaveDbInstanceId') is not None:
            self.slave_db_instance_id = m.get('SlaveDbInstanceId')
        if m.get('SlaveDbInstanceType') is not None:
            self.slave_db_instance_type = m.get('SlaveDbInstanceType')
        return self


class ConfigureDrdsDbInstancesRequest(TeaModel):
    def __init__(self, db_instance=None, db_name=None, drds_instance_id=None):
        self.db_instance = db_instance  # type: list[ConfigureDrdsDbInstancesRequestDbInstance]
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        if self.db_instance:
            for k in self.db_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ConfigureDrdsDbInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DbInstance'] = []
        if self.db_instance is not None:
            for k in self.db_instance:
                result['DbInstance'].append(k.to_map() if k else None)
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.db_instance = []
        if m.get('DbInstance') is not None:
            for k in m.get('DbInstance'):
                temp_model = ConfigureDrdsDbInstancesRequestDbInstance()
                self.db_instance.append(temp_model.from_map(k))
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class ConfigureDrdsDbInstancesResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConfigureDrdsDbInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ConfigureDrdsDbInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ConfigureDrdsDbInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ConfigureDrdsDbInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ConfigureDrdsDbInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomDataExportPreCheckTaskRequest(TeaModel):
    def __init__(self, export_param=None):
        self.export_param = export_param  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataExportPreCheckTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_param is not None:
            result['ExportParam'] = self.export_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExportParam') is not None:
            self.export_param = m.get('ExportParam')
        return self


class CreateCustomDataExportPreCheckTaskShrinkRequest(TeaModel):
    def __init__(self, export_param_shrink=None):
        self.export_param_shrink = export_param_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataExportPreCheckTaskShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_param_shrink is not None:
            result['ExportParam'] = self.export_param_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExportParam') is not None:
            self.export_param_shrink = m.get('ExportParam')
        return self


class CreateCustomDataExportPreCheckTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataExportPreCheckTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateCustomDataExportPreCheckTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateCustomDataExportPreCheckTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCustomDataExportPreCheckTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCustomDataExportPreCheckTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomDataExportTaskRequest(TeaModel):
    def __init__(self, export_param=None):
        self.export_param = export_param  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataExportTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_param is not None:
            result['ExportParam'] = self.export_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExportParam') is not None:
            self.export_param = m.get('ExportParam')
        return self


class CreateCustomDataExportTaskShrinkRequest(TeaModel):
    def __init__(self, export_param_shrink=None):
        self.export_param_shrink = export_param_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataExportTaskShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_param_shrink is not None:
            result['ExportParam'] = self.export_param_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExportParam') is not None:
            self.export_param_shrink = m.get('ExportParam')
        return self


class CreateCustomDataExportTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataExportTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateCustomDataExportTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateCustomDataExportTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCustomDataExportTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCustomDataExportTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomDataImportPreCheckTaskRequest(TeaModel):
    def __init__(self, import_param=None):
        self.import_param = import_param  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataImportPreCheckTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param is not None:
            result['ImportParam'] = self.import_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param = m.get('ImportParam')
        return self


class CreateCustomDataImportPreCheckTaskShrinkRequest(TeaModel):
    def __init__(self, import_param_shrink=None):
        self.import_param_shrink = import_param_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataImportPreCheckTaskShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param_shrink is not None:
            result['ImportParam'] = self.import_param_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param_shrink = m.get('ImportParam')
        return self


class CreateCustomDataImportPreCheckTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataImportPreCheckTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateCustomDataImportPreCheckTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateCustomDataImportPreCheckTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCustomDataImportPreCheckTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCustomDataImportPreCheckTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomDataImportTaskRequest(TeaModel):
    def __init__(self, import_param=None):
        self.import_param = import_param  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataImportTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param is not None:
            result['ImportParam'] = self.import_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param = m.get('ImportParam')
        return self


class CreateCustomDataImportTaskShrinkRequest(TeaModel):
    def __init__(self, import_param_shrink=None):
        self.import_param_shrink = import_param_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataImportTaskShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param_shrink is not None:
            result['ImportParam'] = self.import_param_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param_shrink = m.get('ImportParam')
        return self


class CreateCustomDataImportTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCustomDataImportTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateCustomDataImportTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateCustomDataImportTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCustomDataImportTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCustomDataImportTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDrdsDBRequestInstDbName(TeaModel):
    def __init__(self, db_instance_id=None, shard_db_name=None):
        self.db_instance_id = db_instance_id  # type: str
        self.shard_db_name = shard_db_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDrdsDBRequestInstDbName, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.shard_db_name is not None:
            result['ShardDbName'] = self.shard_db_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('ShardDbName') is not None:
            self.shard_db_name = m.get('ShardDbName')
        return self


class CreateDrdsDBRequestRdsSuperAccount(TeaModel):
    def __init__(self, account_name=None, db_instance_id=None, password=None):
        self.account_name = account_name  # type: str
        self.db_instance_id = db_instance_id  # type: str
        self.password = password  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDrdsDBRequestRdsSuperAccount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.password is not None:
            result['Password'] = self.password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        return self


class CreateDrdsDBRequest(TeaModel):
    def __init__(self, account_name=None, db_inst_type=None, db_instance_is_creating=None, db_name=None,
                 drds_instance_id=None, encode=None, inst_db_name=None, password=None, rds_instance=None, rds_super_account=None,
                 type=None):
        self.account_name = account_name  # type: str
        self.db_inst_type = db_inst_type  # type: str
        self.db_instance_is_creating = db_instance_is_creating  # type: bool
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.encode = encode  # type: str
        self.inst_db_name = inst_db_name  # type: list[CreateDrdsDBRequestInstDbName]
        self.password = password  # type: str
        self.rds_instance = rds_instance  # type: list[str]
        self.rds_super_account = rds_super_account  # type: list[CreateDrdsDBRequestRdsSuperAccount]
        self.type = type  # type: str

    def validate(self):
        if self.inst_db_name:
            for k in self.inst_db_name:
                if k:
                    k.validate()
        if self.rds_super_account:
            for k in self.rds_super_account:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDrdsDBRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.db_instance_is_creating is not None:
            result['DbInstanceIsCreating'] = self.db_instance_is_creating
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.encode is not None:
            result['Encode'] = self.encode
        result['InstDbName'] = []
        if self.inst_db_name is not None:
            for k in self.inst_db_name:
                result['InstDbName'].append(k.to_map() if k else None)
        if self.password is not None:
            result['Password'] = self.password
        if self.rds_instance is not None:
            result['RdsInstance'] = self.rds_instance
        result['RdsSuperAccount'] = []
        if self.rds_super_account is not None:
            for k in self.rds_super_account:
                result['RdsSuperAccount'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DbInstanceIsCreating') is not None:
            self.db_instance_is_creating = m.get('DbInstanceIsCreating')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('Encode') is not None:
            self.encode = m.get('Encode')
        self.inst_db_name = []
        if m.get('InstDbName') is not None:
            for k in m.get('InstDbName'):
                temp_model = CreateDrdsDBRequestInstDbName()
                self.inst_db_name.append(temp_model.from_map(k))
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RdsInstance') is not None:
            self.rds_instance = m.get('RdsInstance')
        self.rds_super_account = []
        if m.get('RdsSuperAccount') is not None:
            for k in m.get('RdsSuperAccount'):
                temp_model = CreateDrdsDBRequestRdsSuperAccount()
                self.rds_super_account.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateDrdsDBResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDrdsDBResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDrdsDBResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDrdsDBResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDrdsDBResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDrdsDBResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDrdsDBPreCheckRequestInstDbName(TeaModel):
    def __init__(self, db_instance_id=None, shard_db_name=None):
        self.db_instance_id = db_instance_id  # type: str
        self.shard_db_name = shard_db_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDrdsDBPreCheckRequestInstDbName, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.shard_db_name is not None:
            result['ShardDbName'] = self.shard_db_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('ShardDbName') is not None:
            self.shard_db_name = m.get('ShardDbName')
        return self


class CreateDrdsDBPreCheckRequestRdsSuperAccount(TeaModel):
    def __init__(self, account_name=None, db_instance_id=None, password=None):
        self.account_name = account_name  # type: str
        self.db_instance_id = db_instance_id  # type: str
        self.password = password  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDrdsDBPreCheckRequestRdsSuperAccount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.password is not None:
            result['Password'] = self.password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        return self


class CreateDrdsDBPreCheckRequest(TeaModel):
    def __init__(self, account_name=None, db_inst_type=None, db_instance_is_creating=None, db_name=None,
                 drds_instance_id=None, encode=None, inst_db_name=None, password=None, rds_instance=None, rds_super_account=None,
                 type=None):
        self.account_name = account_name  # type: str
        self.db_inst_type = db_inst_type  # type: str
        self.db_instance_is_creating = db_instance_is_creating  # type: bool
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.encode = encode  # type: str
        self.inst_db_name = inst_db_name  # type: list[CreateDrdsDBPreCheckRequestInstDbName]
        self.password = password  # type: str
        self.rds_instance = rds_instance  # type: list[str]
        self.rds_super_account = rds_super_account  # type: list[CreateDrdsDBPreCheckRequestRdsSuperAccount]
        self.type = type  # type: str

    def validate(self):
        if self.inst_db_name:
            for k in self.inst_db_name:
                if k:
                    k.validate()
        if self.rds_super_account:
            for k in self.rds_super_account:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDrdsDBPreCheckRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.db_instance_is_creating is not None:
            result['DbInstanceIsCreating'] = self.db_instance_is_creating
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.encode is not None:
            result['Encode'] = self.encode
        result['InstDbName'] = []
        if self.inst_db_name is not None:
            for k in self.inst_db_name:
                result['InstDbName'].append(k.to_map() if k else None)
        if self.password is not None:
            result['Password'] = self.password
        if self.rds_instance is not None:
            result['RdsInstance'] = self.rds_instance
        result['RdsSuperAccount'] = []
        if self.rds_super_account is not None:
            for k in self.rds_super_account:
                result['RdsSuperAccount'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DbInstanceIsCreating') is not None:
            self.db_instance_is_creating = m.get('DbInstanceIsCreating')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('Encode') is not None:
            self.encode = m.get('Encode')
        self.inst_db_name = []
        if m.get('InstDbName') is not None:
            for k in m.get('InstDbName'):
                temp_model = CreateDrdsDBPreCheckRequestInstDbName()
                self.inst_db_name.append(temp_model.from_map(k))
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RdsInstance') is not None:
            self.rds_instance = m.get('RdsInstance')
        self.rds_super_account = []
        if m.get('RdsSuperAccount') is not None:
            for k in m.get('RdsSuperAccount'):
                temp_model = CreateDrdsDBPreCheckRequestRdsSuperAccount()
                self.rds_super_account.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateDrdsDBPreCheckResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDrdsDBPreCheckResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateDrdsDBPreCheckResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDrdsDBPreCheckResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDrdsDBPreCheckResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDrdsDBPreCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDrdsDBPreviewRequestInstDbName(TeaModel):
    def __init__(self, db_instance_id=None, shard_db_name=None):
        self.db_instance_id = db_instance_id  # type: str
        self.shard_db_name = shard_db_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDrdsDBPreviewRequestInstDbName, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.shard_db_name is not None:
            result['ShardDbName'] = self.shard_db_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('ShardDbName') is not None:
            self.shard_db_name = m.get('ShardDbName')
        return self


class CreateDrdsDBPreviewRequest(TeaModel):
    def __init__(self, account_name=None, db_inst_type=None, db_instance_is_creating=None, db_name=None,
                 drds_instance_id=None, inst_db_name=None, order_id=None, rds_instance=None, type=None):
        self.account_name = account_name  # type: str
        self.db_inst_type = db_inst_type  # type: str
        self.db_instance_is_creating = db_instance_is_creating  # type: bool
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.inst_db_name = inst_db_name  # type: list[CreateDrdsDBPreviewRequestInstDbName]
        self.order_id = order_id  # type: str
        self.rds_instance = rds_instance  # type: list[str]
        self.type = type  # type: str

    def validate(self):
        if self.inst_db_name:
            for k in self.inst_db_name:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDrdsDBPreviewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.db_instance_is_creating is not None:
            result['DbInstanceIsCreating'] = self.db_instance_is_creating
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        result['InstDbName'] = []
        if self.inst_db_name is not None:
            for k in self.inst_db_name:
                result['InstDbName'].append(k.to_map() if k else None)
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.rds_instance is not None:
            result['RdsInstance'] = self.rds_instance
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DbInstanceIsCreating') is not None:
            self.db_instance_is_creating = m.get('DbInstanceIsCreating')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        self.inst_db_name = []
        if m.get('InstDbName') is not None:
            for k in m.get('InstDbName'):
                temp_model = CreateDrdsDBPreviewRequestInstDbName()
                self.inst_db_name.append(temp_model.from_map(k))
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RdsInstance') is not None:
            self.rds_instance = m.get('RdsInstance')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateDrdsDBPreviewResponseBodyItemsItemDbNames(TeaModel):
    def __init__(self, db_name=None):
        self.db_name = db_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDrdsDBPreviewResponseBodyItemsItemDbNames, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        return self


class CreateDrdsDBPreviewResponseBodyItemsItem(TeaModel):
    def __init__(self, db_instance_id=None, db_names=None):
        self.db_instance_id = db_instance_id  # type: str
        self.db_names = db_names  # type: CreateDrdsDBPreviewResponseBodyItemsItemDbNames

    def validate(self):
        if self.db_names:
            self.db_names.validate()

    def to_map(self):
        _map = super(CreateDrdsDBPreviewResponseBodyItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.db_names is not None:
            result['DbNames'] = self.db_names.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('DbNames') is not None:
            temp_model = CreateDrdsDBPreviewResponseBodyItemsItemDbNames()
            self.db_names = temp_model.from_map(m['DbNames'])
        return self


class CreateDrdsDBPreviewResponseBodyItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[CreateDrdsDBPreviewResponseBodyItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDrdsDBPreviewResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = CreateDrdsDBPreviewResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class CreateDrdsDBPreviewResponseBody(TeaModel):
    def __init__(self, items=None, request_id=None, success=None):
        self.items = items  # type: CreateDrdsDBPreviewResponseBodyItems
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(CreateDrdsDBPreviewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = CreateDrdsDBPreviewResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDrdsDBPreviewResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDrdsDBPreviewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDrdsDBPreviewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDrdsDBPreviewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDrdsInstanceRequest(TeaModel):
    def __init__(self, client_token=None, description=None, duration=None, instance_series=None, is_auto_renew=None,
                 master_inst_id=None, my_sqlversion=None, pay_type=None, pricing_cycle=None, quantity=None, region_id=None,
                 resource_group_id=None, specification=None, type=None, vpc_id=None, vswitch_id=None, zone_id=None, is_ha=None):
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.duration = duration  # type: int
        self.instance_series = instance_series  # type: str
        self.is_auto_renew = is_auto_renew  # type: bool
        self.master_inst_id = master_inst_id  # type: str
        self.my_sqlversion = my_sqlversion  # type: int
        self.pay_type = pay_type  # type: str
        self.pricing_cycle = pricing_cycle  # type: str
        self.quantity = quantity  # type: int
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.specification = specification  # type: str
        self.type = type  # type: str
        self.vpc_id = vpc_id  # type: str
        self.vswitch_id = vswitch_id  # type: str
        self.zone_id = zone_id  # type: str
        self.is_ha = is_ha  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDrdsInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.instance_series is not None:
            result['InstanceSeries'] = self.instance_series
        if self.is_auto_renew is not None:
            result['IsAutoRenew'] = self.is_auto_renew
        if self.master_inst_id is not None:
            result['MasterInstId'] = self.master_inst_id
        if self.my_sqlversion is not None:
            result['MySQLVersion'] = self.my_sqlversion
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.is_ha is not None:
            result['isHa'] = self.is_ha
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('InstanceSeries') is not None:
            self.instance_series = m.get('InstanceSeries')
        if m.get('IsAutoRenew') is not None:
            self.is_auto_renew = m.get('IsAutoRenew')
        if m.get('MasterInstId') is not None:
            self.master_inst_id = m.get('MasterInstId')
        if m.get('MySQLVersion') is not None:
            self.my_sqlversion = m.get('MySQLVersion')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('Quantity') is not None:
            self.quantity = m.get('Quantity')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('isHa') is not None:
            self.is_ha = m.get('isHa')
        return self


class CreateDrdsInstanceResponseBodyDataDrdsInstanceIdList(TeaModel):
    def __init__(self, drds_instance_id_list=None):
        self.drds_instance_id_list = drds_instance_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDrdsInstanceResponseBodyDataDrdsInstanceIdList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id_list is not None:
            result['drdsInstanceIdList'] = self.drds_instance_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('drdsInstanceIdList') is not None:
            self.drds_instance_id_list = m.get('drdsInstanceIdList')
        return self


class CreateDrdsInstanceResponseBodyData(TeaModel):
    def __init__(self, drds_instance_id_list=None, order_id=None):
        self.drds_instance_id_list = drds_instance_id_list  # type: CreateDrdsInstanceResponseBodyDataDrdsInstanceIdList
        self.order_id = order_id  # type: long

    def validate(self):
        if self.drds_instance_id_list:
            self.drds_instance_id_list.validate()

    def to_map(self):
        _map = super(CreateDrdsInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id_list is not None:
            result['DrdsInstanceIdList'] = self.drds_instance_id_list.to_map()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceIdList') is not None:
            temp_model = CreateDrdsInstanceResponseBodyDataDrdsInstanceIdList()
            self.drds_instance_id_list = temp_model.from_map(m['DrdsInstanceIdList'])
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateDrdsInstanceResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: CreateDrdsInstanceResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateDrdsInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateDrdsInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDrdsInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateDrdsInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDrdsInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDrdsInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEvaluateDataImportPreCheckTaskRequest(TeaModel):
    def __init__(self, import_param=None):
        self.import_param = import_param  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEvaluateDataImportPreCheckTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param is not None:
            result['ImportParam'] = self.import_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param = m.get('ImportParam')
        return self


class CreateEvaluateDataImportPreCheckTaskShrinkRequest(TeaModel):
    def __init__(self, import_param_shrink=None):
        self.import_param_shrink = import_param_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEvaluateDataImportPreCheckTaskShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param_shrink is not None:
            result['ImportParam'] = self.import_param_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param_shrink = m.get('ImportParam')
        return self


class CreateEvaluateDataImportPreCheckTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEvaluateDataImportPreCheckTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateEvaluateDataImportPreCheckTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateEvaluateDataImportPreCheckTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEvaluateDataImportPreCheckTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEvaluateDataImportPreCheckTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEvaluateDataImportTaskRequest(TeaModel):
    def __init__(self, import_param=None):
        self.import_param = import_param  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEvaluateDataImportTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param is not None:
            result['ImportParam'] = self.import_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param = m.get('ImportParam')
        return self


class CreateEvaluateDataImportTaskShrinkRequest(TeaModel):
    def __init__(self, import_param_shrink=None):
        self.import_param_shrink = import_param_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEvaluateDataImportTaskShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param_shrink is not None:
            result['ImportParam'] = self.import_param_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param_shrink = m.get('ImportParam')
        return self


class CreateEvaluateDataImportTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEvaluateDataImportTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateEvaluateDataImportTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateEvaluateDataImportTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEvaluateDataImportTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEvaluateDataImportTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEvaluatePreCheckTaskRequestDbInfo(TeaModel):
    def __init__(self, db_name=None, db_password=None, db_port=None, db_user=None, inst_id=None):
        self.db_name = db_name  # type: str
        self.db_password = db_password  # type: str
        self.db_port = db_port  # type: str
        self.db_user = db_user  # type: str
        self.inst_id = inst_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEvaluatePreCheckTaskRequestDbInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.db_password is not None:
            result['DbPassword'] = self.db_password
        if self.db_port is not None:
            result['DbPort'] = self.db_port
        if self.db_user is not None:
            result['DbUser'] = self.db_user
        if self.inst_id is not None:
            result['InstId'] = self.inst_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DbPassword') is not None:
            self.db_password = m.get('DbPassword')
        if m.get('DbPort') is not None:
            self.db_port = m.get('DbPort')
        if m.get('DbUser') is not None:
            self.db_user = m.get('DbUser')
        if m.get('InstId') is not None:
            self.inst_id = m.get('InstId')
        return self


class CreateEvaluatePreCheckTaskRequest(TeaModel):
    def __init__(self, avg_qps_growth_scale=None, data_growth_scale=None, db_info=None, evaluate_hours=None,
                 task_name=None):
        self.avg_qps_growth_scale = avg_qps_growth_scale  # type: int
        self.data_growth_scale = data_growth_scale  # type: int
        self.db_info = db_info  # type: list[CreateEvaluatePreCheckTaskRequestDbInfo]
        self.evaluate_hours = evaluate_hours  # type: int
        self.task_name = task_name  # type: str

    def validate(self):
        if self.db_info:
            for k in self.db_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateEvaluatePreCheckTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_qps_growth_scale is not None:
            result['AvgQpsGrowthScale'] = self.avg_qps_growth_scale
        if self.data_growth_scale is not None:
            result['DataGrowthScale'] = self.data_growth_scale
        result['DbInfo'] = []
        if self.db_info is not None:
            for k in self.db_info:
                result['DbInfo'].append(k.to_map() if k else None)
        if self.evaluate_hours is not None:
            result['EvaluateHours'] = self.evaluate_hours
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgQpsGrowthScale') is not None:
            self.avg_qps_growth_scale = m.get('AvgQpsGrowthScale')
        if m.get('DataGrowthScale') is not None:
            self.data_growth_scale = m.get('DataGrowthScale')
        self.db_info = []
        if m.get('DbInfo') is not None:
            for k in m.get('DbInfo'):
                temp_model = CreateEvaluatePreCheckTaskRequestDbInfo()
                self.db_info.append(temp_model.from_map(k))
        if m.get('EvaluateHours') is not None:
            self.evaluate_hours = m.get('EvaluateHours')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateEvaluatePreCheckTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEvaluatePreCheckTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateEvaluatePreCheckTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateEvaluatePreCheckTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEvaluatePreCheckTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEvaluatePreCheckTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEvaluateTaskRequestDbInfo(TeaModel):
    def __init__(self, db_name=None, db_password=None, db_port=None, db_user=None, inst_id=None):
        self.db_name = db_name  # type: str
        self.db_password = db_password  # type: str
        self.db_port = db_port  # type: str
        self.db_user = db_user  # type: str
        self.inst_id = inst_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEvaluateTaskRequestDbInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.db_password is not None:
            result['DbPassword'] = self.db_password
        if self.db_port is not None:
            result['DbPort'] = self.db_port
        if self.db_user is not None:
            result['DbUser'] = self.db_user
        if self.inst_id is not None:
            result['InstId'] = self.inst_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DbPassword') is not None:
            self.db_password = m.get('DbPassword')
        if m.get('DbPort') is not None:
            self.db_port = m.get('DbPort')
        if m.get('DbUser') is not None:
            self.db_user = m.get('DbUser')
        if m.get('InstId') is not None:
            self.inst_id = m.get('InstId')
        return self


class CreateEvaluateTaskRequest(TeaModel):
    def __init__(self, avg_qps_growth_scale=None, data_growth_scale=None, db_info=None, evaluate_hours=None,
                 task_name=None):
        self.avg_qps_growth_scale = avg_qps_growth_scale  # type: int
        self.data_growth_scale = data_growth_scale  # type: int
        self.db_info = db_info  # type: list[CreateEvaluateTaskRequestDbInfo]
        self.evaluate_hours = evaluate_hours  # type: int
        self.task_name = task_name  # type: str

    def validate(self):
        if self.db_info:
            for k in self.db_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateEvaluateTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_qps_growth_scale is not None:
            result['AvgQpsGrowthScale'] = self.avg_qps_growth_scale
        if self.data_growth_scale is not None:
            result['DataGrowthScale'] = self.data_growth_scale
        result['DbInfo'] = []
        if self.db_info is not None:
            for k in self.db_info:
                result['DbInfo'].append(k.to_map() if k else None)
        if self.evaluate_hours is not None:
            result['EvaluateHours'] = self.evaluate_hours
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgQpsGrowthScale') is not None:
            self.avg_qps_growth_scale = m.get('AvgQpsGrowthScale')
        if m.get('DataGrowthScale') is not None:
            self.data_growth_scale = m.get('DataGrowthScale')
        self.db_info = []
        if m.get('DbInfo') is not None:
            for k in m.get('DbInfo'):
                temp_model = CreateEvaluateTaskRequestDbInfo()
                self.db_info.append(temp_model.from_map(k))
        if m.get('EvaluateHours') is not None:
            self.evaluate_hours = m.get('EvaluateHours')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateEvaluateTaskResponseBodyData(TeaModel):
    def __init__(self, task_ids=None):
        self.task_ids = task_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateEvaluateTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_ids is not None:
            result['TaskIds'] = self.task_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskIds') is not None:
            self.task_ids = m.get('TaskIds')
        return self


class CreateEvaluateTaskResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: CreateEvaluateTaskResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateEvaluateTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateEvaluateTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEvaluateTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateEvaluateTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateEvaluateTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEvaluateTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceAccountRequestDbPrivilege(TeaModel):
    def __init__(self, db_name=None, privilege=None):
        self.db_name = db_name  # type: str
        self.privilege = privilege  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceAccountRequestDbPrivilege, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.privilege is not None:
            result['Privilege'] = self.privilege
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('Privilege') is not None:
            self.privilege = m.get('Privilege')
        return self


class CreateInstanceAccountRequest(TeaModel):
    def __init__(self, account_name=None, db_privilege=None, drds_instance_id=None, password=None):
        self.account_name = account_name  # type: str
        self.db_privilege = db_privilege  # type: list[CreateInstanceAccountRequestDbPrivilege]
        self.drds_instance_id = drds_instance_id  # type: str
        self.password = password  # type: str

    def validate(self):
        if self.db_privilege:
            for k in self.db_privilege:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateInstanceAccountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        result['DbPrivilege'] = []
        if self.db_privilege is not None:
            for k in self.db_privilege:
                result['DbPrivilege'].append(k.to_map() if k else None)
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.password is not None:
            result['Password'] = self.password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        self.db_privilege = []
        if m.get('DbPrivilege') is not None:
            for k in m.get('DbPrivilege'):
                temp_model = CreateInstanceAccountRequestDbPrivilege()
                self.db_privilege.append(temp_model.from_map(k))
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        return self


class CreateInstanceAccountResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceAccountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateInstanceAccountResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateInstanceAccountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateInstanceAccountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateInstanceAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceInternetAddressRequest(TeaModel):
    def __init__(self, drds_instance_id=None, region_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceInternetAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateInstanceInternetAddressResponseBody(TeaModel):
    def __init__(self, code=None, data=None, request_id=None, success=None):
        self.code = code  # type: int
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceInternetAddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateInstanceInternetAddressResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateInstanceInternetAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateInstanceInternetAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateInstanceInternetAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMyCatEvaluateRequest(TeaModel):
    def __init__(self, bus_peak_qps=None, capacity_inc_percent=None, import_db_list=None, qps_inc_percent=None,
                 region_id=None, rule_url=None, schema_url=None, sequence_type=None, server_url=None, task_name=None):
        self.bus_peak_qps = bus_peak_qps  # type: long
        self.capacity_inc_percent = capacity_inc_percent  # type: int
        self.import_db_list = import_db_list  # type: list[str]
        self.qps_inc_percent = qps_inc_percent  # type: int
        self.region_id = region_id  # type: str
        self.rule_url = rule_url  # type: str
        self.schema_url = schema_url  # type: str
        self.sequence_type = sequence_type  # type: int
        self.server_url = server_url  # type: str
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMyCatEvaluateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bus_peak_qps is not None:
            result['BusPeakQps'] = self.bus_peak_qps
        if self.capacity_inc_percent is not None:
            result['CapacityIncPercent'] = self.capacity_inc_percent
        if self.import_db_list is not None:
            result['ImportDbList'] = self.import_db_list
        if self.qps_inc_percent is not None:
            result['QpsIncPercent'] = self.qps_inc_percent
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_url is not None:
            result['RuleUrl'] = self.rule_url
        if self.schema_url is not None:
            result['SchemaUrl'] = self.schema_url
        if self.sequence_type is not None:
            result['SequenceType'] = self.sequence_type
        if self.server_url is not None:
            result['ServerUrl'] = self.server_url
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusPeakQps') is not None:
            self.bus_peak_qps = m.get('BusPeakQps')
        if m.get('CapacityIncPercent') is not None:
            self.capacity_inc_percent = m.get('CapacityIncPercent')
        if m.get('ImportDbList') is not None:
            self.import_db_list = m.get('ImportDbList')
        if m.get('QpsIncPercent') is not None:
            self.qps_inc_percent = m.get('QpsIncPercent')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleUrl') is not None:
            self.rule_url = m.get('RuleUrl')
        if m.get('SchemaUrl') is not None:
            self.schema_url = m.get('SchemaUrl')
        if m.get('SequenceType') is not None:
            self.sequence_type = m.get('SequenceType')
        if m.get('ServerUrl') is not None:
            self.server_url = m.get('ServerUrl')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateMyCatEvaluateResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_id_list=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id_list = task_id_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateMyCatEvaluateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id_list is not None:
            result['TaskIdList'] = self.task_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskIdList') is not None:
            self.task_id_list = m.get('TaskIdList')
        return self


class CreateMyCatEvaluateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateMyCatEvaluateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateMyCatEvaluateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMyCatEvaluateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrderForRdsRequest(TeaModel):
    def __init__(self, params=None, region_id=None):
        self.params = params  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrderForRdsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.params is not None:
            result['Params'] = self.params
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateOrderForRdsResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOrderForRdsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOrderForRdsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateOrderForRdsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOrderForRdsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOrderForRdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateShardTaskRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None, source_table_name=None,
                 target_table_name=None, task_type=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.source_table_name = source_table_name  # type: str
        self.target_table_name = target_table_name  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateShardTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.source_table_name is not None:
            result['SourceTableName'] = self.source_table_name
        if self.target_table_name is not None:
            result['TargetTableName'] = self.target_table_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SourceTableName') is not None:
            self.source_table_name = m.get('SourceTableName')
        if m.get('TargetTableName') is not None:
            self.target_table_name = m.get('TargetTableName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateShardTaskResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateShardTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateShardTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: CreateShardTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateShardTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateShardTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackMenuRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackMenuRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeBackMenuResponseBodyListList(TeaModel):
    def __init__(self, menu_name=None, support=None):
        self.menu_name = menu_name  # type: str
        self.support = support  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackMenuResponseBodyListList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.menu_name is not None:
            result['MenuName'] = self.menu_name
        if self.support is not None:
            result['Support'] = self.support
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MenuName') is not None:
            self.menu_name = m.get('MenuName')
        if m.get('Support') is not None:
            self.support = m.get('Support')
        return self


class DescribeBackMenuResponseBodyList(TeaModel):
    def __init__(self, list=None):
        self.list = list  # type: list[DescribeBackMenuResponseBodyListList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBackMenuResponseBodyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['list'] = []
        if self.list is not None:
            for k in self.list:
                result['list'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('list') is not None:
            for k in m.get('list'):
                temp_model = DescribeBackMenuResponseBodyListList()
                self.list.append(temp_model.from_map(k))
        return self


class DescribeBackMenuResponseBody(TeaModel):
    def __init__(self, list=None, request_id=None, success=None):
        self.list = list  # type: DescribeBackMenuResponseBodyList
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super(DescribeBackMenuResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = DescribeBackMenuResponseBodyList()
            self.list = temp_model.from_map(m['List'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeBackMenuResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBackMenuResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackMenuResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackMenuResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupDbsRequest(TeaModel):
    def __init__(self, backup_id=None, drds_instance_id=None, preferred_restore_time=None):
        self.backup_id = backup_id  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.preferred_restore_time = preferred_restore_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupDbsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.preferred_restore_time is not None:
            result['PreferredRestoreTime'] = self.preferred_restore_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PreferredRestoreTime') is not None:
            self.preferred_restore_time = m.get('PreferredRestoreTime')
        return self


class DescribeBackupDbsResponseBodyDbNames(TeaModel):
    def __init__(self, db_name=None):
        self.db_name = db_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupDbsResponseBodyDbNames, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['dbName'] = self.db_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('dbName') is not None:
            self.db_name = m.get('dbName')
        return self


class DescribeBackupDbsResponseBody(TeaModel):
    def __init__(self, db_names=None, request_id=None, success=None):
        self.db_names = db_names  # type: DescribeBackupDbsResponseBodyDbNames
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.db_names:
            self.db_names.validate()

    def to_map(self):
        _map = super(DescribeBackupDbsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_names is not None:
            result['DbNames'] = self.db_names.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbNames') is not None:
            temp_model = DescribeBackupDbsResponseBodyDbNames()
            self.db_names = temp_model.from_map(m['DbNames'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeBackupDbsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBackupDbsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupDbsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupDbsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupLocalRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupLocalRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeBackupLocalResponseBodyBackupPolicyDO(TeaModel):
    def __init__(self, backup_app_name=None, backup_db_name=None, backup_level=None, backup_log=None,
                 backup_mode=None, backup_policy_mode=None, backup_retention_period=None, backup_type=None,
                 data_backup_retention_period=None, gmt_create=None, gmt_modified=None, high_space_usage_protection=None,
                 local_log_retention_hours=None, local_log_retention_space=None, log_backup_retention_period=None,
                 next_backup_actually_time=None, preferred_backup_period=None, preferred_backup_time=None):
        self.backup_app_name = backup_app_name  # type: str
        self.backup_db_name = backup_db_name  # type: str
        self.backup_level = backup_level  # type: str
        self.backup_log = backup_log  # type: str
        self.backup_mode = backup_mode  # type: str
        self.backup_policy_mode = backup_policy_mode  # type: str
        self.backup_retention_period = backup_retention_period  # type: long
        self.backup_type = backup_type  # type: str
        self.data_backup_retention_period = data_backup_retention_period  # type: long
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.high_space_usage_protection = high_space_usage_protection  # type: long
        self.local_log_retention_hours = local_log_retention_hours  # type: long
        self.local_log_retention_space = local_log_retention_space  # type: long
        self.log_backup_retention_period = log_backup_retention_period  # type: long
        self.next_backup_actually_time = next_backup_actually_time  # type: str
        self.preferred_backup_period = preferred_backup_period  # type: str
        self.preferred_backup_time = preferred_backup_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupLocalResponseBodyBackupPolicyDO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_app_name is not None:
            result['BackupAppName'] = self.backup_app_name
        if self.backup_db_name is not None:
            result['BackupDbName'] = self.backup_db_name
        if self.backup_level is not None:
            result['BackupLevel'] = self.backup_level
        if self.backup_log is not None:
            result['BackupLog'] = self.backup_log
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.backup_policy_mode is not None:
            result['BackupPolicyMode'] = self.backup_policy_mode
        if self.backup_retention_period is not None:
            result['BackupRetentionPeriod'] = self.backup_retention_period
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.data_backup_retention_period is not None:
            result['DataBackupRetentionPeriod'] = self.data_backup_retention_period
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.high_space_usage_protection is not None:
            result['HighSpaceUsageProtection'] = self.high_space_usage_protection
        if self.local_log_retention_hours is not None:
            result['LocalLogRetentionHours'] = self.local_log_retention_hours
        if self.local_log_retention_space is not None:
            result['LocalLogRetentionSpace'] = self.local_log_retention_space
        if self.log_backup_retention_period is not None:
            result['LogBackupRetentionPeriod'] = self.log_backup_retention_period
        if self.next_backup_actually_time is not None:
            result['NextBackupActuallyTime'] = self.next_backup_actually_time
        if self.preferred_backup_period is not None:
            result['PreferredBackupPeriod'] = self.preferred_backup_period
        if self.preferred_backup_time is not None:
            result['PreferredBackupTime'] = self.preferred_backup_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupAppName') is not None:
            self.backup_app_name = m.get('BackupAppName')
        if m.get('BackupDbName') is not None:
            self.backup_db_name = m.get('BackupDbName')
        if m.get('BackupLevel') is not None:
            self.backup_level = m.get('BackupLevel')
        if m.get('BackupLog') is not None:
            self.backup_log = m.get('BackupLog')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('BackupPolicyMode') is not None:
            self.backup_policy_mode = m.get('BackupPolicyMode')
        if m.get('BackupRetentionPeriod') is not None:
            self.backup_retention_period = m.get('BackupRetentionPeriod')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('DataBackupRetentionPeriod') is not None:
            self.data_backup_retention_period = m.get('DataBackupRetentionPeriod')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HighSpaceUsageProtection') is not None:
            self.high_space_usage_protection = m.get('HighSpaceUsageProtection')
        if m.get('LocalLogRetentionHours') is not None:
            self.local_log_retention_hours = m.get('LocalLogRetentionHours')
        if m.get('LocalLogRetentionSpace') is not None:
            self.local_log_retention_space = m.get('LocalLogRetentionSpace')
        if m.get('LogBackupRetentionPeriod') is not None:
            self.log_backup_retention_period = m.get('LogBackupRetentionPeriod')
        if m.get('NextBackupActuallyTime') is not None:
            self.next_backup_actually_time = m.get('NextBackupActuallyTime')
        if m.get('PreferredBackupPeriod') is not None:
            self.preferred_backup_period = m.get('PreferredBackupPeriod')
        if m.get('PreferredBackupTime') is not None:
            self.preferred_backup_time = m.get('PreferredBackupTime')
        return self


class DescribeBackupLocalResponseBody(TeaModel):
    def __init__(self, backup_policy_do=None, request_id=None, success=None):
        self.backup_policy_do = backup_policy_do  # type: DescribeBackupLocalResponseBodyBackupPolicyDO
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.backup_policy_do:
            self.backup_policy_do.validate()

    def to_map(self):
        _map = super(DescribeBackupLocalResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_policy_do is not None:
            result['BackupPolicyDO'] = self.backup_policy_do.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupPolicyDO') is not None:
            temp_model = DescribeBackupLocalResponseBodyBackupPolicyDO()
            self.backup_policy_do = temp_model.from_map(m['BackupPolicyDO'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeBackupLocalResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBackupLocalResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupLocalResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupLocalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPolicyRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeBackupPolicyResponseBodyBackupPolicyDO(TeaModel):
    def __init__(self, backup_app_name=None, backup_db_name=None, backup_level=None, backup_log=None,
                 backup_mode=None, backup_policy_mode=None, backup_retention_period=None, backup_type=None,
                 data_backup_retention_period=None, gmt_create=None, gmt_modified=None, high_space_usage_protection=None,
                 local_log_retention_hours=None, local_log_retention_space=None, log_backup_retention_period=None,
                 next_backup_actually_time=None, preferred_backup_period=None, preferred_backup_time=None):
        self.backup_app_name = backup_app_name  # type: str
        self.backup_db_name = backup_db_name  # type: str
        self.backup_level = backup_level  # type: str
        self.backup_log = backup_log  # type: str
        self.backup_mode = backup_mode  # type: str
        self.backup_policy_mode = backup_policy_mode  # type: str
        self.backup_retention_period = backup_retention_period  # type: long
        self.backup_type = backup_type  # type: str
        self.data_backup_retention_period = data_backup_retention_period  # type: long
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.high_space_usage_protection = high_space_usage_protection  # type: long
        self.local_log_retention_hours = local_log_retention_hours  # type: long
        self.local_log_retention_space = local_log_retention_space  # type: long
        self.log_backup_retention_period = log_backup_retention_period  # type: long
        self.next_backup_actually_time = next_backup_actually_time  # type: str
        self.preferred_backup_period = preferred_backup_period  # type: str
        self.preferred_backup_time = preferred_backup_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupPolicyResponseBodyBackupPolicyDO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_app_name is not None:
            result['BackupAppName'] = self.backup_app_name
        if self.backup_db_name is not None:
            result['BackupDbName'] = self.backup_db_name
        if self.backup_level is not None:
            result['BackupLevel'] = self.backup_level
        if self.backup_log is not None:
            result['BackupLog'] = self.backup_log
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.backup_policy_mode is not None:
            result['BackupPolicyMode'] = self.backup_policy_mode
        if self.backup_retention_period is not None:
            result['BackupRetentionPeriod'] = self.backup_retention_period
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.data_backup_retention_period is not None:
            result['DataBackupRetentionPeriod'] = self.data_backup_retention_period
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.high_space_usage_protection is not None:
            result['HighSpaceUsageProtection'] = self.high_space_usage_protection
        if self.local_log_retention_hours is not None:
            result['LocalLogRetentionHours'] = self.local_log_retention_hours
        if self.local_log_retention_space is not None:
            result['LocalLogRetentionSpace'] = self.local_log_retention_space
        if self.log_backup_retention_period is not None:
            result['LogBackupRetentionPeriod'] = self.log_backup_retention_period
        if self.next_backup_actually_time is not None:
            result['NextBackupActuallyTime'] = self.next_backup_actually_time
        if self.preferred_backup_period is not None:
            result['PreferredBackupPeriod'] = self.preferred_backup_period
        if self.preferred_backup_time is not None:
            result['PreferredBackupTime'] = self.preferred_backup_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupAppName') is not None:
            self.backup_app_name = m.get('BackupAppName')
        if m.get('BackupDbName') is not None:
            self.backup_db_name = m.get('BackupDbName')
        if m.get('BackupLevel') is not None:
            self.backup_level = m.get('BackupLevel')
        if m.get('BackupLog') is not None:
            self.backup_log = m.get('BackupLog')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('BackupPolicyMode') is not None:
            self.backup_policy_mode = m.get('BackupPolicyMode')
        if m.get('BackupRetentionPeriod') is not None:
            self.backup_retention_period = m.get('BackupRetentionPeriod')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('DataBackupRetentionPeriod') is not None:
            self.data_backup_retention_period = m.get('DataBackupRetentionPeriod')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HighSpaceUsageProtection') is not None:
            self.high_space_usage_protection = m.get('HighSpaceUsageProtection')
        if m.get('LocalLogRetentionHours') is not None:
            self.local_log_retention_hours = m.get('LocalLogRetentionHours')
        if m.get('LocalLogRetentionSpace') is not None:
            self.local_log_retention_space = m.get('LocalLogRetentionSpace')
        if m.get('LogBackupRetentionPeriod') is not None:
            self.log_backup_retention_period = m.get('LogBackupRetentionPeriod')
        if m.get('NextBackupActuallyTime') is not None:
            self.next_backup_actually_time = m.get('NextBackupActuallyTime')
        if m.get('PreferredBackupPeriod') is not None:
            self.preferred_backup_period = m.get('PreferredBackupPeriod')
        if m.get('PreferredBackupTime') is not None:
            self.preferred_backup_time = m.get('PreferredBackupTime')
        return self


class DescribeBackupPolicyResponseBody(TeaModel):
    def __init__(self, backup_policy_do=None, request_id=None, success=None):
        self.backup_policy_do = backup_policy_do  # type: DescribeBackupPolicyResponseBodyBackupPolicyDO
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.backup_policy_do:
            self.backup_policy_do.validate()

    def to_map(self):
        _map = super(DescribeBackupPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_policy_do is not None:
            result['BackupPolicyDO'] = self.backup_policy_do.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupPolicyDO') is not None:
            temp_model = DescribeBackupPolicyResponseBodyBackupPolicyDO()
            self.backup_policy_do = temp_model.from_map(m['BackupPolicyDO'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeBackupPolicyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBackupPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupSetsRequest(TeaModel):
    def __init__(self, drds_instance_id=None, end_time=None, start_time=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.end_time = end_time  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupSetsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeBackupSetsResponseBodyBackupSetsBackupSetBackupDbs(TeaModel):
    def __init__(self, backup_db=None):
        self.backup_db = backup_db  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupSetsResponseBodyBackupSetsBackupSetBackupDbs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_db is not None:
            result['backupDb'] = self.backup_db
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('backupDb') is not None:
            self.backup_db = m.get('backupDb')
        return self


class DescribeBackupSetsResponseBodyBackupSetsBackupSet(TeaModel):
    def __init__(self, backup_consitent_time=None, backup_dbs=None, backup_end_time=None, backup_level=None,
                 backup_mode=None, backup_start_time=None, backup_total_size=None, backup_type=None, enable_recovery=None,
                 id=None, status=None):
        self.backup_consitent_time = backup_consitent_time  # type: str
        self.backup_dbs = backup_dbs  # type: DescribeBackupSetsResponseBodyBackupSetsBackupSetBackupDbs
        self.backup_end_time = backup_end_time  # type: long
        self.backup_level = backup_level  # type: str
        self.backup_mode = backup_mode  # type: str
        self.backup_start_time = backup_start_time  # type: long
        self.backup_total_size = backup_total_size  # type: str
        self.backup_type = backup_type  # type: str
        self.enable_recovery = enable_recovery  # type: bool
        self.id = id  # type: str
        self.status = status  # type: long

    def validate(self):
        if self.backup_dbs:
            self.backup_dbs.validate()

    def to_map(self):
        _map = super(DescribeBackupSetsResponseBodyBackupSetsBackupSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_consitent_time is not None:
            result['BackupConsitentTime'] = self.backup_consitent_time
        if self.backup_dbs is not None:
            result['BackupDbs'] = self.backup_dbs.to_map()
        if self.backup_end_time is not None:
            result['BackupEndTime'] = self.backup_end_time
        if self.backup_level is not None:
            result['BackupLevel'] = self.backup_level
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.backup_start_time is not None:
            result['BackupStartTime'] = self.backup_start_time
        if self.backup_total_size is not None:
            result['BackupTotalSize'] = self.backup_total_size
        if self.backup_type is not None:
            result['BackupType'] = self.backup_type
        if self.enable_recovery is not None:
            result['EnableRecovery'] = self.enable_recovery
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupConsitentTime') is not None:
            self.backup_consitent_time = m.get('BackupConsitentTime')
        if m.get('BackupDbs') is not None:
            temp_model = DescribeBackupSetsResponseBodyBackupSetsBackupSetBackupDbs()
            self.backup_dbs = temp_model.from_map(m['BackupDbs'])
        if m.get('BackupEndTime') is not None:
            self.backup_end_time = m.get('BackupEndTime')
        if m.get('BackupLevel') is not None:
            self.backup_level = m.get('BackupLevel')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('BackupStartTime') is not None:
            self.backup_start_time = m.get('BackupStartTime')
        if m.get('BackupTotalSize') is not None:
            self.backup_total_size = m.get('BackupTotalSize')
        if m.get('BackupType') is not None:
            self.backup_type = m.get('BackupType')
        if m.get('EnableRecovery') is not None:
            self.enable_recovery = m.get('EnableRecovery')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeBackupSetsResponseBodyBackupSets(TeaModel):
    def __init__(self, backup_set=None):
        self.backup_set = backup_set  # type: list[DescribeBackupSetsResponseBodyBackupSetsBackupSet]

    def validate(self):
        if self.backup_set:
            for k in self.backup_set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBackupSetsResponseBodyBackupSets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['backupSet'] = []
        if self.backup_set is not None:
            for k in self.backup_set:
                result['backupSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.backup_set = []
        if m.get('backupSet') is not None:
            for k in m.get('backupSet'):
                temp_model = DescribeBackupSetsResponseBodyBackupSetsBackupSet()
                self.backup_set.append(temp_model.from_map(k))
        return self


class DescribeBackupSetsResponseBody(TeaModel):
    def __init__(self, backup_sets=None, request_id=None, success=None):
        self.backup_sets = backup_sets  # type: DescribeBackupSetsResponseBodyBackupSets
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.backup_sets:
            self.backup_sets.validate()

    def to_map(self):
        _map = super(DescribeBackupSetsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_sets is not None:
            result['BackupSets'] = self.backup_sets.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupSets') is not None:
            temp_model = DescribeBackupSetsResponseBodyBackupSets()
            self.backup_sets = temp_model.from_map(m['BackupSets'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeBackupSetsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBackupSetsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupSetsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupSetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupTimesRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupTimesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeBackupTimesResponseBodyRestoreTime(TeaModel):
    def __init__(self, end_time=None, start_time=None):
        self.end_time = end_time  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBackupTimesResponseBodyRestoreTime, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeBackupTimesResponseBody(TeaModel):
    def __init__(self, request_id=None, restore_time=None, success=None):
        self.request_id = request_id  # type: str
        self.restore_time = restore_time  # type: DescribeBackupTimesResponseBodyRestoreTime
        self.success = success  # type: bool

    def validate(self):
        if self.restore_time:
            self.restore_time.validate()

    def to_map(self):
        _map = super(DescribeBackupTimesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.restore_time is not None:
            result['RestoreTime'] = self.restore_time.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RestoreTime') is not None:
            temp_model = DescribeBackupTimesResponseBodyRestoreTime()
            self.restore_time = temp_model.from_map(m['RestoreTime'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeBackupTimesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBackupTimesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBackupTimesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupTimesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBatchEvaluateTaskReportRequest(TeaModel):
    def __init__(self, batch_evaluate_task_id=None):
        self.batch_evaluate_task_id = batch_evaluate_task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBatchEvaluateTaskReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_evaluate_task_id is not None:
            result['BatchEvaluateTaskId'] = self.batch_evaluate_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BatchEvaluateTaskId') is not None:
            self.batch_evaluate_task_id = m.get('BatchEvaluateTaskId')
        return self


class DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfosRdsInstInfos(TeaModel):
    def __init__(self, avg_qps_growth_scale=None, data_growth_scale=None, inst_id=None, rds_peak_iops_weekly=None,
                 rds_peak_qps_weekly=None, rds_peak_sessions_weekly=None, rds_used_space=None):
        self.avg_qps_growth_scale = avg_qps_growth_scale  # type: int
        self.data_growth_scale = data_growth_scale  # type: int
        self.inst_id = inst_id  # type: str
        self.rds_peak_iops_weekly = rds_peak_iops_weekly  # type: int
        self.rds_peak_qps_weekly = rds_peak_qps_weekly  # type: int
        self.rds_peak_sessions_weekly = rds_peak_sessions_weekly  # type: int
        self.rds_used_space = rds_used_space  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfosRdsInstInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_qps_growth_scale is not None:
            result['AvgQpsGrowthScale'] = self.avg_qps_growth_scale
        if self.data_growth_scale is not None:
            result['DataGrowthScale'] = self.data_growth_scale
        if self.inst_id is not None:
            result['InstId'] = self.inst_id
        if self.rds_peak_iops_weekly is not None:
            result['RdsPeakIopsWeekly'] = self.rds_peak_iops_weekly
        if self.rds_peak_qps_weekly is not None:
            result['RdsPeakQpsWeekly'] = self.rds_peak_qps_weekly
        if self.rds_peak_sessions_weekly is not None:
            result['RdsPeakSessionsWeekly'] = self.rds_peak_sessions_weekly
        if self.rds_used_space is not None:
            result['RdsUsedSpace'] = self.rds_used_space
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgQpsGrowthScale') is not None:
            self.avg_qps_growth_scale = m.get('AvgQpsGrowthScale')
        if m.get('DataGrowthScale') is not None:
            self.data_growth_scale = m.get('DataGrowthScale')
        if m.get('InstId') is not None:
            self.inst_id = m.get('InstId')
        if m.get('RdsPeakIopsWeekly') is not None:
            self.rds_peak_iops_weekly = m.get('RdsPeakIopsWeekly')
        if m.get('RdsPeakQpsWeekly') is not None:
            self.rds_peak_qps_weekly = m.get('RdsPeakQpsWeekly')
        if m.get('RdsPeakSessionsWeekly') is not None:
            self.rds_peak_sessions_weekly = m.get('RdsPeakSessionsWeekly')
        if m.get('RdsUsedSpace') is not None:
            self.rds_used_space = m.get('RdsUsedSpace')
        return self


class DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfos(TeaModel):
    def __init__(self, rds_inst_infos=None):
        self.rds_inst_infos = rds_inst_infos  # type: list[DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfosRdsInstInfos]

    def validate(self):
        if self.rds_inst_infos:
            for k in self.rds_inst_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RdsInstInfos'] = []
        if self.rds_inst_infos is not None:
            for k in self.rds_inst_infos:
                result['RdsInstInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rds_inst_infos = []
        if m.get('RdsInstInfos') is not None:
            for k in m.get('RdsInstInfos'):
                temp_model = DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfosRdsInstInfos()
                self.rds_inst_infos.append(temp_model.from_map(k))
        return self


class DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResultsTableShardResults(TeaModel):
    def __init__(self, create_table_sql=None, db_shard_key=None, db_shard_method=None, dbpartitions=None,
                 origin_db_shard_method=None, origin_tb_shard_method=None, row_count=None, shard_key_type=None, shard_type=None,
                 sql_count=None, table=None, tb_shard_key=None, tb_shard_method=None, tbpartitions=None):
        self.create_table_sql = create_table_sql  # type: str
        self.db_shard_key = db_shard_key  # type: str
        self.db_shard_method = db_shard_method  # type: str
        self.dbpartitions = dbpartitions  # type: int
        self.origin_db_shard_method = origin_db_shard_method  # type: str
        self.origin_tb_shard_method = origin_tb_shard_method  # type: str
        self.row_count = row_count  # type: int
        self.shard_key_type = shard_key_type  # type: str
        self.shard_type = shard_type  # type: str
        self.sql_count = sql_count  # type: int
        self.table = table  # type: str
        self.tb_shard_key = tb_shard_key  # type: str
        self.tb_shard_method = tb_shard_method  # type: str
        self.tbpartitions = tbpartitions  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResultsTableShardResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_table_sql is not None:
            result['CreateTableSql'] = self.create_table_sql
        if self.db_shard_key is not None:
            result['DbShardKey'] = self.db_shard_key
        if self.db_shard_method is not None:
            result['DbShardMethod'] = self.db_shard_method
        if self.dbpartitions is not None:
            result['Dbpartitions'] = self.dbpartitions
        if self.origin_db_shard_method is not None:
            result['OriginDbShardMethod'] = self.origin_db_shard_method
        if self.origin_tb_shard_method is not None:
            result['OriginTbShardMethod'] = self.origin_tb_shard_method
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        if self.shard_key_type is not None:
            result['ShardKeyType'] = self.shard_key_type
        if self.shard_type is not None:
            result['ShardType'] = self.shard_type
        if self.sql_count is not None:
            result['SqlCount'] = self.sql_count
        if self.table is not None:
            result['Table'] = self.table
        if self.tb_shard_key is not None:
            result['TbShardKey'] = self.tb_shard_key
        if self.tb_shard_method is not None:
            result['TbShardMethod'] = self.tb_shard_method
        if self.tbpartitions is not None:
            result['Tbpartitions'] = self.tbpartitions
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTableSql') is not None:
            self.create_table_sql = m.get('CreateTableSql')
        if m.get('DbShardKey') is not None:
            self.db_shard_key = m.get('DbShardKey')
        if m.get('DbShardMethod') is not None:
            self.db_shard_method = m.get('DbShardMethod')
        if m.get('Dbpartitions') is not None:
            self.dbpartitions = m.get('Dbpartitions')
        if m.get('OriginDbShardMethod') is not None:
            self.origin_db_shard_method = m.get('OriginDbShardMethod')
        if m.get('OriginTbShardMethod') is not None:
            self.origin_tb_shard_method = m.get('OriginTbShardMethod')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        if m.get('ShardKeyType') is not None:
            self.shard_key_type = m.get('ShardKeyType')
        if m.get('ShardType') is not None:
            self.shard_type = m.get('ShardType')
        if m.get('SqlCount') is not None:
            self.sql_count = m.get('SqlCount')
        if m.get('Table') is not None:
            self.table = m.get('Table')
        if m.get('TbShardKey') is not None:
            self.tb_shard_key = m.get('TbShardKey')
        if m.get('TbShardMethod') is not None:
            self.tb_shard_method = m.get('TbShardMethod')
        if m.get('Tbpartitions') is not None:
            self.tbpartitions = m.get('Tbpartitions')
        return self


class DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResults(TeaModel):
    def __init__(self, table_shard_results=None):
        self.table_shard_results = table_shard_results  # type: list[DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResultsTableShardResults]

    def validate(self):
        if self.table_shard_results:
            for k in self.table_shard_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TableShardResults'] = []
        if self.table_shard_results is not None:
            for k in self.table_shard_results:
                result['TableShardResults'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.table_shard_results = []
        if m.get('TableShardResults') is not None:
            for k in m.get('TableShardResults'):
                temp_model = DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResultsTableShardResults()
                self.table_shard_results.append(temp_model.from_map(k))
        return self


class DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResults(TeaModel):
    def __init__(self, all_sql_count=None, db_name=None, drds_count=None, drds_type=None, gmt_create=None,
                 gmt_modified=None, inst_id=None, rds_count=None, rds_inst_infos=None, rds_total_space=None, rds_type=None,
                 slow_sql_count=None, table_shard_results=None, task_id=None, task_name=None, task_status=None):
        self.all_sql_count = all_sql_count  # type: int
        self.db_name = db_name  # type: str
        self.drds_count = drds_count  # type: int
        self.drds_type = drds_type  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.inst_id = inst_id  # type: int
        self.rds_count = rds_count  # type: int
        self.rds_inst_infos = rds_inst_infos  # type: DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfos
        self.rds_total_space = rds_total_space  # type: str
        self.rds_type = rds_type  # type: str
        self.slow_sql_count = slow_sql_count  # type: int
        self.table_shard_results = table_shard_results  # type: DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResults
        self.task_id = task_id  # type: int
        self.task_name = task_name  # type: str
        self.task_status = task_status  # type: str

    def validate(self):
        if self.rds_inst_infos:
            self.rds_inst_infos.validate()
        if self.table_shard_results:
            self.table_shard_results.validate()

    def to_map(self):
        _map = super(DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_sql_count is not None:
            result['AllSqlCount'] = self.all_sql_count
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_count is not None:
            result['DrdsCount'] = self.drds_count
        if self.drds_type is not None:
            result['DrdsType'] = self.drds_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.inst_id is not None:
            result['InstId'] = self.inst_id
        if self.rds_count is not None:
            result['RdsCount'] = self.rds_count
        if self.rds_inst_infos is not None:
            result['RdsInstInfos'] = self.rds_inst_infos.to_map()
        if self.rds_total_space is not None:
            result['RdsTotalSpace'] = self.rds_total_space
        if self.rds_type is not None:
            result['RdsType'] = self.rds_type
        if self.slow_sql_count is not None:
            result['SlowSqlCount'] = self.slow_sql_count
        if self.table_shard_results is not None:
            result['TableShardResults'] = self.table_shard_results.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllSqlCount') is not None:
            self.all_sql_count = m.get('AllSqlCount')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsCount') is not None:
            self.drds_count = m.get('DrdsCount')
        if m.get('DrdsType') is not None:
            self.drds_type = m.get('DrdsType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('InstId') is not None:
            self.inst_id = m.get('InstId')
        if m.get('RdsCount') is not None:
            self.rds_count = m.get('RdsCount')
        if m.get('RdsInstInfos') is not None:
            temp_model = DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfos()
            self.rds_inst_infos = temp_model.from_map(m['RdsInstInfos'])
        if m.get('RdsTotalSpace') is not None:
            self.rds_total_space = m.get('RdsTotalSpace')
        if m.get('RdsType') is not None:
            self.rds_type = m.get('RdsType')
        if m.get('SlowSqlCount') is not None:
            self.slow_sql_count = m.get('SlowSqlCount')
        if m.get('TableShardResults') is not None:
            temp_model = DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResults()
            self.table_shard_results = temp_model.from_map(m['TableShardResults'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class DescribeBatchEvaluateTaskReportResponseBodyData(TeaModel):
    def __init__(self, evaluate_results=None):
        self.evaluate_results = evaluate_results  # type: list[DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResults]

    def validate(self):
        if self.evaluate_results:
            for k in self.evaluate_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBatchEvaluateTaskReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EvaluateResults'] = []
        if self.evaluate_results is not None:
            for k in self.evaluate_results:
                result['EvaluateResults'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.evaluate_results = []
        if m.get('EvaluateResults') is not None:
            for k in m.get('EvaluateResults'):
                temp_model = DescribeBatchEvaluateTaskReportResponseBodyDataEvaluateResults()
                self.evaluate_results.append(temp_model.from_map(k))
        return self


class DescribeBatchEvaluateTaskReportResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: DescribeBatchEvaluateTaskReportResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeBatchEvaluateTaskReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeBatchEvaluateTaskReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeBatchEvaluateTaskReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBatchEvaluateTaskReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBatchEvaluateTaskReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBatchEvaluateTaskReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBroadcastTablesRequest(TeaModel):
    def __init__(self, current_page=None, db_name=None, drds_instance_id=None, page_size=None, query=None,
                 region_id=None):
        self.current_page = current_page  # type: int
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.query = query  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBroadcastTablesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeBroadcastTablesResponseBodyList(TeaModel):
    def __init__(self, broadcast=None, broadcast_type=None, db_inst_type=None, is_shard=None, status=None,
                 table=None):
        self.broadcast = broadcast  # type: bool
        self.broadcast_type = broadcast_type  # type: str
        self.db_inst_type = db_inst_type  # type: int
        self.is_shard = is_shard  # type: bool
        self.status = status  # type: int
        self.table = table  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBroadcastTablesResponseBodyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.broadcast is not None:
            result['Broadcast'] = self.broadcast
        if self.broadcast_type is not None:
            result['BroadcastType'] = self.broadcast_type
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.is_shard is not None:
            result['IsShard'] = self.is_shard
        if self.status is not None:
            result['Status'] = self.status
        if self.table is not None:
            result['Table'] = self.table
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Broadcast') is not None:
            self.broadcast = m.get('Broadcast')
        if m.get('BroadcastType') is not None:
            self.broadcast_type = m.get('BroadcastType')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('IsShard') is not None:
            self.is_shard = m.get('IsShard')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Table') is not None:
            self.table = m.get('Table')
        return self


class DescribeBroadcastTablesResponseBody(TeaModel):
    def __init__(self, is_shard=None, list=None, page_number=None, page_size=None, request_id=None, success=None,
                 total=None):
        self.is_shard = is_shard  # type: bool
        self.list = list  # type: list[DescribeBroadcastTablesResponseBodyList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBroadcastTablesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_shard is not None:
            result['IsShard'] = self.is_shard
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsShard') is not None:
            self.is_shard = m.get('IsShard')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeBroadcastTablesResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeBroadcastTablesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeBroadcastTablesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBroadcastTablesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBroadcastTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCanExpandInstanceDetailListRequest(TeaModel):
    def __init__(self, current_plan=None, db_name=None, drds_instance_id=None):
        self.current_plan = current_plan  # type: str
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCanExpandInstanceDetailListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_plan is not None:
            result['CurrentPlan'] = self.current_plan
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPlan') is not None:
            self.current_plan = m.get('CurrentPlan')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeCanExpandInstanceDetailListResponseBodyDataItemDataDbList(TeaModel):
    def __init__(self, db=None):
        self.db = db  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCanExpandInstanceDetailListResponseBodyDataItemDataDbList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db is not None:
            result['db'] = self.db
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('db') is not None:
            self.db = m.get('db')
        return self


class DescribeCanExpandInstanceDetailListResponseBodyDataItemData(TeaModel):
    def __init__(self, db_list=None, src_instance=None):
        self.db_list = db_list  # type: DescribeCanExpandInstanceDetailListResponseBodyDataItemDataDbList
        self.src_instance = src_instance  # type: str

    def validate(self):
        if self.db_list:
            self.db_list.validate()

    def to_map(self):
        _map = super(DescribeCanExpandInstanceDetailListResponseBodyDataItemData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_list is not None:
            result['DbList'] = self.db_list.to_map()
        if self.src_instance is not None:
            result['SrcInstance'] = self.src_instance
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbList') is not None:
            temp_model = DescribeCanExpandInstanceDetailListResponseBodyDataItemDataDbList()
            self.db_list = temp_model.from_map(m['DbList'])
        if m.get('SrcInstance') is not None:
            self.src_instance = m.get('SrcInstance')
        return self


class DescribeCanExpandInstanceDetailListResponseBodyData(TeaModel):
    def __init__(self, item_data=None):
        self.item_data = item_data  # type: list[DescribeCanExpandInstanceDetailListResponseBodyDataItemData]

    def validate(self):
        if self.item_data:
            for k in self.item_data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCanExpandInstanceDetailListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['itemData'] = []
        if self.item_data is not None:
            for k in self.item_data:
                result['itemData'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item_data = []
        if m.get('itemData') is not None:
            for k in m.get('itemData'):
                temp_model = DescribeCanExpandInstanceDetailListResponseBodyDataItemData()
                self.item_data.append(temp_model.from_map(k))
        return self


class DescribeCanExpandInstanceDetailListResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: DescribeCanExpandInstanceDetailListResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeCanExpandInstanceDetailListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeCanExpandInstanceDetailListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCanExpandInstanceDetailListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeCanExpandInstanceDetailListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCanExpandInstanceDetailListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCanExpandInstanceDetailListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomDataExportSrcDstTablesRequest(TeaModel):
    def __init__(self, export_param=None):
        self.export_param = export_param  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomDataExportSrcDstTablesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_param is not None:
            result['ExportParam'] = self.export_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExportParam') is not None:
            self.export_param = m.get('ExportParam')
        return self


class DescribeCustomDataExportSrcDstTablesShrinkRequest(TeaModel):
    def __init__(self, export_param_shrink=None):
        self.export_param_shrink = export_param_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomDataExportSrcDstTablesShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_param_shrink is not None:
            result['ExportParam'] = self.export_param_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExportParam') is not None:
            self.export_param_shrink = m.get('ExportParam')
        return self


class DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTablesDstTables(TeaModel):
    def __init__(self, dst_tables=None):
        self.dst_tables = dst_tables  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTablesDstTables, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_tables is not None:
            result['DstTables'] = self.dst_tables
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstTables') is not None:
            self.dst_tables = m.get('DstTables')
        return self


class DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTablesSrcTables(TeaModel):
    def __init__(self, src_tables=None):
        self.src_tables = src_tables  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTablesSrcTables, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.src_tables is not None:
            result['SrcTables'] = self.src_tables
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SrcTables') is not None:
            self.src_tables = m.get('SrcTables')
        return self


class DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTables(TeaModel):
    def __init__(self, dst_tables=None, src_tables=None):
        self.dst_tables = dst_tables  # type: DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTablesDstTables
        self.src_tables = src_tables  # type: DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTablesSrcTables

    def validate(self):
        if self.dst_tables:
            self.dst_tables.validate()
        if self.src_tables:
            self.src_tables.validate()

    def to_map(self):
        _map = super(DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTables, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_tables is not None:
            result['DstTables'] = self.dst_tables.to_map()
        if self.src_tables is not None:
            result['SrcTables'] = self.src_tables.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstTables') is not None:
            temp_model = DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTablesDstTables()
            self.dst_tables = temp_model.from_map(m['DstTables'])
        if m.get('SrcTables') is not None:
            temp_model = DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTablesSrcTables()
            self.src_tables = temp_model.from_map(m['SrcTables'])
        return self


class DescribeCustomDataExportSrcDstTablesResponseBody(TeaModel):
    def __init__(self, data_export_src_dst_tables=None, request_id=None, success=None):
        self.data_export_src_dst_tables = data_export_src_dst_tables  # type: DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTables
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data_export_src_dst_tables:
            self.data_export_src_dst_tables.validate()

    def to_map(self):
        _map = super(DescribeCustomDataExportSrcDstTablesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_export_src_dst_tables is not None:
            result['DataExportSrcDstTables'] = self.data_export_src_dst_tables.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataExportSrcDstTables') is not None:
            temp_model = DescribeCustomDataExportSrcDstTablesResponseBodyDataExportSrcDstTables()
            self.data_export_src_dst_tables = temp_model.from_map(m['DataExportSrcDstTables'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCustomDataExportSrcDstTablesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeCustomDataExportSrcDstTablesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCustomDataExportSrcDstTablesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCustomDataExportSrcDstTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomDataImportSrcDstTablesRequest(TeaModel):
    def __init__(self, import_param=None):
        self.import_param = import_param  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomDataImportSrcDstTablesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param is not None:
            result['ImportParam'] = self.import_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param = m.get('ImportParam')
        return self


class DescribeCustomDataImportSrcDstTablesShrinkRequest(TeaModel):
    def __init__(self, import_param_shrink=None):
        self.import_param_shrink = import_param_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomDataImportSrcDstTablesShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param_shrink is not None:
            result['ImportParam'] = self.import_param_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param_shrink = m.get('ImportParam')
        return self


class DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTablesDstTables(TeaModel):
    def __init__(self, dst_tables=None):
        self.dst_tables = dst_tables  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTablesDstTables, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_tables is not None:
            result['DstTables'] = self.dst_tables
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstTables') is not None:
            self.dst_tables = m.get('DstTables')
        return self


class DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTablesSrcTables(TeaModel):
    def __init__(self, src_tables=None):
        self.src_tables = src_tables  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTablesSrcTables, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.src_tables is not None:
            result['SrcTables'] = self.src_tables
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SrcTables') is not None:
            self.src_tables = m.get('SrcTables')
        return self


class DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTables(TeaModel):
    def __init__(self, dst_tables=None, src_tables=None):
        self.dst_tables = dst_tables  # type: DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTablesDstTables
        self.src_tables = src_tables  # type: DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTablesSrcTables

    def validate(self):
        if self.dst_tables:
            self.dst_tables.validate()
        if self.src_tables:
            self.src_tables.validate()

    def to_map(self):
        _map = super(DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTables, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_tables is not None:
            result['DstTables'] = self.dst_tables.to_map()
        if self.src_tables is not None:
            result['SrcTables'] = self.src_tables.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstTables') is not None:
            temp_model = DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTablesDstTables()
            self.dst_tables = temp_model.from_map(m['DstTables'])
        if m.get('SrcTables') is not None:
            temp_model = DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTablesSrcTables()
            self.src_tables = temp_model.from_map(m['SrcTables'])
        return self


class DescribeCustomDataImportSrcDstTablesResponseBody(TeaModel):
    def __init__(self, data_import_src_dst_tables=None, request_id=None, success=None):
        self.data_import_src_dst_tables = data_import_src_dst_tables  # type: DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTables
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data_import_src_dst_tables:
            self.data_import_src_dst_tables.validate()

    def to_map(self):
        _map = super(DescribeCustomDataImportSrcDstTablesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_import_src_dst_tables is not None:
            result['DataImportSrcDstTables'] = self.data_import_src_dst_tables.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DataImportSrcDstTables') is not None:
            temp_model = DescribeCustomDataImportSrcDstTablesResponseBodyDataImportSrcDstTables()
            self.data_import_src_dst_tables = temp_model.from_map(m['DataImportSrcDstTables'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCustomDataImportSrcDstTablesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeCustomDataImportSrcDstTablesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCustomDataImportSrcDstTablesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCustomDataImportSrcDstTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataExportPreCheckResultRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataExportPreCheckResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams(TeaModel):
    def __init__(self, error_msg_params=None):
        self.error_msg_params = error_msg_params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg_params is not None:
            result['ErrorMsgParams'] = self.error_msg_params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMsgParams') is not None:
            self.error_msg_params = m.get('ErrorMsgParams')
        return self


class DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems(TeaModel):
    def __init__(self, error_msg_code=None, error_msg_params=None, pre_check_item_name=None, state=None):
        self.error_msg_code = error_msg_code  # type: str
        self.error_msg_params = error_msg_params  # type: DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams
        self.pre_check_item_name = pre_check_item_name  # type: str
        self.state = state  # type: str

    def validate(self):
        if self.error_msg_params:
            self.error_msg_params.validate()

    def to_map(self):
        _map = super(DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg_code is not None:
            result['ErrorMsgCode'] = self.error_msg_code
        if self.error_msg_params is not None:
            result['ErrorMsgParams'] = self.error_msg_params.to_map()
        if self.pre_check_item_name is not None:
            result['PreCheckItemName'] = self.pre_check_item_name
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMsgCode') is not None:
            self.error_msg_code = m.get('ErrorMsgCode')
        if m.get('ErrorMsgParams') is not None:
            temp_model = DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams()
            self.error_msg_params = temp_model.from_map(m['ErrorMsgParams'])
        if m.get('PreCheckItemName') is not None:
            self.pre_check_item_name = m.get('PreCheckItemName')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItems(TeaModel):
    def __init__(self, sub_check_items=None):
        self.sub_check_items = sub_check_items  # type: list[DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems]

    def validate(self):
        if self.sub_check_items:
            for k in self.sub_check_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubCheckItems'] = []
        if self.sub_check_items is not None:
            for k in self.sub_check_items:
                result['SubCheckItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sub_check_items = []
        if m.get('SubCheckItems') is not None:
            for k in m.get('SubCheckItems'):
                temp_model = DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems()
                self.sub_check_items.append(temp_model.from_map(k))
        return self


class DescribeDataExportPreCheckResultResponseBodyPreCheckResult(TeaModel):
    def __init__(self, pre_check_name=None, state=None, sub_check_items=None):
        self.pre_check_name = pre_check_name  # type: str
        self.state = state  # type: str
        self.sub_check_items = sub_check_items  # type: DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItems

    def validate(self):
        if self.sub_check_items:
            self.sub_check_items.validate()

    def to_map(self):
        _map = super(DescribeDataExportPreCheckResultResponseBodyPreCheckResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_check_name is not None:
            result['PreCheckName'] = self.pre_check_name
        if self.state is not None:
            result['State'] = self.state
        if self.sub_check_items is not None:
            result['SubCheckItems'] = self.sub_check_items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PreCheckName') is not None:
            self.pre_check_name = m.get('PreCheckName')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('SubCheckItems') is not None:
            temp_model = DescribeDataExportPreCheckResultResponseBodyPreCheckResultSubCheckItems()
            self.sub_check_items = temp_model.from_map(m['SubCheckItems'])
        return self


class DescribeDataExportPreCheckResultResponseBody(TeaModel):
    def __init__(self, pre_check_result=None, request_id=None, success=None):
        self.pre_check_result = pre_check_result  # type: DescribeDataExportPreCheckResultResponseBodyPreCheckResult
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.pre_check_result:
            self.pre_check_result.validate()

    def to_map(self):
        _map = super(DescribeDataExportPreCheckResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_check_result is not None:
            result['PreCheckResult'] = self.pre_check_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PreCheckResult') is not None:
            temp_model = DescribeDataExportPreCheckResultResponseBodyPreCheckResult()
            self.pre_check_result = temp_model.from_map(m['PreCheckResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDataExportPreCheckResultResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDataExportPreCheckResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDataExportPreCheckResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDataExportPreCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataExportTaskReportRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataExportTaskReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeDataExportTaskReportResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataExportTaskReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDataExportTaskReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDataExportTaskReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDataExportTaskReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDataExportTaskReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataExportTasksRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataExportTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgressFull(TeaModel):
    def __init__(self, need_time=None, progress=None, tps=None, transfer_count=None):
        self.need_time = need_time  # type: int
        self.progress = progress  # type: int
        self.tps = tps  # type: int
        self.transfer_count = transfer_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgressFull, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.need_time is not None:
            result['NeedTime'] = self.need_time
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.tps is not None:
            result['Tps'] = self.tps
        if self.transfer_count is not None:
            result['TransferCount'] = self.transfer_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NeedTime') is not None:
            self.need_time = m.get('NeedTime')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Tps') is not None:
            self.tps = m.get('Tps')
        if m.get('TransferCount') is not None:
            self.transfer_count = m.get('TransferCount')
        return self


class DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgressIncrement(TeaModel):
    def __init__(self, delay=None, tps=None, transfer_count=None):
        self.delay = delay  # type: int
        self.tps = tps  # type: int
        self.transfer_count = transfer_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgressIncrement, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.tps is not None:
            result['Tps'] = self.tps
        if self.transfer_count is not None:
            result['TransferCount'] = self.transfer_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('Tps') is not None:
            self.tps = m.get('Tps')
        if m.get('TransferCount') is not None:
            self.transfer_count = m.get('TransferCount')
        return self


class DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgress(TeaModel):
    def __init__(self, full=None, full_running=None, increment=None, increment_running=None):
        self.full = full  # type: DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgressFull
        self.full_running = full_running  # type: bool
        self.increment = increment  # type: DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgressIncrement
        self.increment_running = increment_running  # type: bool

    def validate(self):
        if self.full:
            self.full.validate()
        if self.increment:
            self.increment.validate()

    def to_map(self):
        _map = super(DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.full is not None:
            result['Full'] = self.full.to_map()
        if self.full_running is not None:
            result['FullRunning'] = self.full_running
        if self.increment is not None:
            result['Increment'] = self.increment.to_map()
        if self.increment_running is not None:
            result['IncrementRunning'] = self.increment_running
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Full') is not None:
            temp_model = DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgressFull()
            self.full = temp_model.from_map(m['Full'])
        if m.get('FullRunning') is not None:
            self.full_running = m.get('FullRunning')
        if m.get('Increment') is not None:
            temp_model = DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgressIncrement()
            self.increment = temp_model.from_map(m['Increment'])
        if m.get('IncrementRunning') is not None:
            self.increment_running = m.get('IncrementRunning')
        return self


class DescribeDataExportTasksResponseBodyDataDataExportTask(TeaModel):
    def __init__(self, batch_evaluate_task_id=None, create_db_progress=None, create_tables_progress=None,
                 dst_db_name=None, dst_inst_id=None, evaluate_task_id=None, gmt_create=None, gmt_modified=None, id=None,
                 jingwei_progress=None, progress=None, src_db_name=None, src_inst_id=None, stage=None, status=None, task_name=None,
                 type=None):
        self.batch_evaluate_task_id = batch_evaluate_task_id  # type: int
        self.create_db_progress = create_db_progress  # type: int
        self.create_tables_progress = create_tables_progress  # type: int
        self.dst_db_name = dst_db_name  # type: str
        self.dst_inst_id = dst_inst_id  # type: str
        self.evaluate_task_id = evaluate_task_id  # type: int
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.id = id  # type: int
        self.jingwei_progress = jingwei_progress  # type: DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgress
        self.progress = progress  # type: int
        self.src_db_name = src_db_name  # type: str
        self.src_inst_id = src_inst_id  # type: str
        self.stage = stage  # type: str
        self.status = status  # type: str
        self.task_name = task_name  # type: str
        self.type = type  # type: int

    def validate(self):
        if self.jingwei_progress:
            self.jingwei_progress.validate()

    def to_map(self):
        _map = super(DescribeDataExportTasksResponseBodyDataDataExportTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_evaluate_task_id is not None:
            result['BatchEvaluateTaskId'] = self.batch_evaluate_task_id
        if self.create_db_progress is not None:
            result['CreateDbProgress'] = self.create_db_progress
        if self.create_tables_progress is not None:
            result['CreateTablesProgress'] = self.create_tables_progress
        if self.dst_db_name is not None:
            result['DstDbName'] = self.dst_db_name
        if self.dst_inst_id is not None:
            result['DstInstId'] = self.dst_inst_id
        if self.evaluate_task_id is not None:
            result['EvaluateTaskId'] = self.evaluate_task_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.jingwei_progress is not None:
            result['JingweiProgress'] = self.jingwei_progress.to_map()
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.src_db_name is not None:
            result['SrcDbName'] = self.src_db_name
        if self.src_inst_id is not None:
            result['SrcInstId'] = self.src_inst_id
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BatchEvaluateTaskId') is not None:
            self.batch_evaluate_task_id = m.get('BatchEvaluateTaskId')
        if m.get('CreateDbProgress') is not None:
            self.create_db_progress = m.get('CreateDbProgress')
        if m.get('CreateTablesProgress') is not None:
            self.create_tables_progress = m.get('CreateTablesProgress')
        if m.get('DstDbName') is not None:
            self.dst_db_name = m.get('DstDbName')
        if m.get('DstInstId') is not None:
            self.dst_inst_id = m.get('DstInstId')
        if m.get('EvaluateTaskId') is not None:
            self.evaluate_task_id = m.get('EvaluateTaskId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('JingweiProgress') is not None:
            temp_model = DescribeDataExportTasksResponseBodyDataDataExportTaskJingweiProgress()
            self.jingwei_progress = temp_model.from_map(m['JingweiProgress'])
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('SrcDbName') is not None:
            self.src_db_name = m.get('SrcDbName')
        if m.get('SrcInstId') is not None:
            self.src_inst_id = m.get('SrcInstId')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDataExportTasksResponseBodyData(TeaModel):
    def __init__(self, data_export_task=None):
        self.data_export_task = data_export_task  # type: list[DescribeDataExportTasksResponseBodyDataDataExportTask]

    def validate(self):
        if self.data_export_task:
            for k in self.data_export_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDataExportTasksResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataExportTask'] = []
        if self.data_export_task is not None:
            for k in self.data_export_task:
                result['DataExportTask'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_export_task = []
        if m.get('DataExportTask') is not None:
            for k in m.get('DataExportTask'):
                temp_model = DescribeDataExportTasksResponseBodyDataDataExportTask()
                self.data_export_task.append(temp_model.from_map(k))
        return self


class DescribeDataExportTasksResponseBody(TeaModel):
    def __init__(self, data=None, page_number=None, page_size=None, request_id=None, success=None, total=None):
        self.data = data  # type: DescribeDataExportTasksResponseBodyData
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDataExportTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDataExportTasksResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDataExportTasksResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDataExportTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDataExportTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDataExportTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataImportPreCheckResultRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataImportPreCheckResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams(TeaModel):
    def __init__(self, error_msg_params=None):
        self.error_msg_params = error_msg_params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg_params is not None:
            result['ErrorMsgParams'] = self.error_msg_params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMsgParams') is not None:
            self.error_msg_params = m.get('ErrorMsgParams')
        return self


class DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems(TeaModel):
    def __init__(self, error_msg_code=None, error_msg_params=None, pre_check_item_name=None, state=None):
        self.error_msg_code = error_msg_code  # type: str
        self.error_msg_params = error_msg_params  # type: DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams
        self.pre_check_item_name = pre_check_item_name  # type: str
        self.state = state  # type: str

    def validate(self):
        if self.error_msg_params:
            self.error_msg_params.validate()

    def to_map(self):
        _map = super(DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg_code is not None:
            result['ErrorMsgCode'] = self.error_msg_code
        if self.error_msg_params is not None:
            result['ErrorMsgParams'] = self.error_msg_params.to_map()
        if self.pre_check_item_name is not None:
            result['PreCheckItemName'] = self.pre_check_item_name
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMsgCode') is not None:
            self.error_msg_code = m.get('ErrorMsgCode')
        if m.get('ErrorMsgParams') is not None:
            temp_model = DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams()
            self.error_msg_params = temp_model.from_map(m['ErrorMsgParams'])
        if m.get('PreCheckItemName') is not None:
            self.pre_check_item_name = m.get('PreCheckItemName')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItems(TeaModel):
    def __init__(self, sub_check_items=None):
        self.sub_check_items = sub_check_items  # type: list[DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems]

    def validate(self):
        if self.sub_check_items:
            for k in self.sub_check_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubCheckItems'] = []
        if self.sub_check_items is not None:
            for k in self.sub_check_items:
                result['SubCheckItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sub_check_items = []
        if m.get('SubCheckItems') is not None:
            for k in m.get('SubCheckItems'):
                temp_model = DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems()
                self.sub_check_items.append(temp_model.from_map(k))
        return self


class DescribeDataImportPreCheckResultResponseBodyPreCheckResult(TeaModel):
    def __init__(self, pre_check_name=None, state=None, sub_check_items=None):
        self.pre_check_name = pre_check_name  # type: str
        self.state = state  # type: str
        self.sub_check_items = sub_check_items  # type: DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItems

    def validate(self):
        if self.sub_check_items:
            self.sub_check_items.validate()

    def to_map(self):
        _map = super(DescribeDataImportPreCheckResultResponseBodyPreCheckResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_check_name is not None:
            result['PreCheckName'] = self.pre_check_name
        if self.state is not None:
            result['State'] = self.state
        if self.sub_check_items is not None:
            result['SubCheckItems'] = self.sub_check_items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PreCheckName') is not None:
            self.pre_check_name = m.get('PreCheckName')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('SubCheckItems') is not None:
            temp_model = DescribeDataImportPreCheckResultResponseBodyPreCheckResultSubCheckItems()
            self.sub_check_items = temp_model.from_map(m['SubCheckItems'])
        return self


class DescribeDataImportPreCheckResultResponseBody(TeaModel):
    def __init__(self, pre_check_result=None, request_id=None, success=None):
        self.pre_check_result = pre_check_result  # type: DescribeDataImportPreCheckResultResponseBodyPreCheckResult
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.pre_check_result:
            self.pre_check_result.validate()

    def to_map(self):
        _map = super(DescribeDataImportPreCheckResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_check_result is not None:
            result['PreCheckResult'] = self.pre_check_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PreCheckResult') is not None:
            temp_model = DescribeDataImportPreCheckResultResponseBodyPreCheckResult()
            self.pre_check_result = temp_model.from_map(m['PreCheckResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDataImportPreCheckResultResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDataImportPreCheckResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDataImportPreCheckResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDataImportPreCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataImportTaskReportRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataImportTaskReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeDataImportTaskReportResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataImportTaskReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDataImportTaskReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDataImportTaskReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDataImportTaskReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDataImportTaskReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDataImportTasksRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataImportTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgressFull(TeaModel):
    def __init__(self, need_time=None, progress=None, tps=None, transfer_count=None):
        self.need_time = need_time  # type: int
        self.progress = progress  # type: int
        self.tps = tps  # type: int
        self.transfer_count = transfer_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgressFull, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.need_time is not None:
            result['NeedTime'] = self.need_time
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.tps is not None:
            result['Tps'] = self.tps
        if self.transfer_count is not None:
            result['TransferCount'] = self.transfer_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NeedTime') is not None:
            self.need_time = m.get('NeedTime')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Tps') is not None:
            self.tps = m.get('Tps')
        if m.get('TransferCount') is not None:
            self.transfer_count = m.get('TransferCount')
        return self


class DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgressIncrement(TeaModel):
    def __init__(self, delay=None, tps=None, transfer_count=None):
        self.delay = delay  # type: int
        self.tps = tps  # type: int
        self.transfer_count = transfer_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgressIncrement, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.tps is not None:
            result['Tps'] = self.tps
        if self.transfer_count is not None:
            result['TransferCount'] = self.transfer_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('Tps') is not None:
            self.tps = m.get('Tps')
        if m.get('TransferCount') is not None:
            self.transfer_count = m.get('TransferCount')
        return self


class DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgress(TeaModel):
    def __init__(self, full=None, full_running=None, increment=None, increment_running=None):
        self.full = full  # type: DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgressFull
        self.full_running = full_running  # type: bool
        self.increment = increment  # type: DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgressIncrement
        self.increment_running = increment_running  # type: bool

    def validate(self):
        if self.full:
            self.full.validate()
        if self.increment:
            self.increment.validate()

    def to_map(self):
        _map = super(DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.full is not None:
            result['Full'] = self.full.to_map()
        if self.full_running is not None:
            result['FullRunning'] = self.full_running
        if self.increment is not None:
            result['Increment'] = self.increment.to_map()
        if self.increment_running is not None:
            result['IncrementRunning'] = self.increment_running
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Full') is not None:
            temp_model = DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgressFull()
            self.full = temp_model.from_map(m['Full'])
        if m.get('FullRunning') is not None:
            self.full_running = m.get('FullRunning')
        if m.get('Increment') is not None:
            temp_model = DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgressIncrement()
            self.increment = temp_model.from_map(m['Increment'])
        if m.get('IncrementRunning') is not None:
            self.increment_running = m.get('IncrementRunning')
        return self


class DescribeDataImportTasksResponseBodyDataDataImportTask(TeaModel):
    def __init__(self, batch_evaluate_task_id=None, create_db_progress=None, create_tables_progress=None,
                 dst_db_name=None, dst_inst_id=None, evaluate_task_id=None, gmt_create=None, gmt_modified=None, id=None,
                 jingwei_progress=None, progress=None, src_db_name=None, src_inst_id=None, stage=None, status=None, task_name=None,
                 type=None):
        self.batch_evaluate_task_id = batch_evaluate_task_id  # type: int
        self.create_db_progress = create_db_progress  # type: int
        self.create_tables_progress = create_tables_progress  # type: int
        self.dst_db_name = dst_db_name  # type: str
        self.dst_inst_id = dst_inst_id  # type: str
        self.evaluate_task_id = evaluate_task_id  # type: int
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.id = id  # type: int
        self.jingwei_progress = jingwei_progress  # type: DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgress
        self.progress = progress  # type: int
        self.src_db_name = src_db_name  # type: str
        self.src_inst_id = src_inst_id  # type: str
        self.stage = stage  # type: str
        self.status = status  # type: str
        self.task_name = task_name  # type: str
        self.type = type  # type: int

    def validate(self):
        if self.jingwei_progress:
            self.jingwei_progress.validate()

    def to_map(self):
        _map = super(DescribeDataImportTasksResponseBodyDataDataImportTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_evaluate_task_id is not None:
            result['BatchEvaluateTaskId'] = self.batch_evaluate_task_id
        if self.create_db_progress is not None:
            result['CreateDbProgress'] = self.create_db_progress
        if self.create_tables_progress is not None:
            result['CreateTablesProgress'] = self.create_tables_progress
        if self.dst_db_name is not None:
            result['DstDbName'] = self.dst_db_name
        if self.dst_inst_id is not None:
            result['DstInstId'] = self.dst_inst_id
        if self.evaluate_task_id is not None:
            result['EvaluateTaskId'] = self.evaluate_task_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.jingwei_progress is not None:
            result['JingweiProgress'] = self.jingwei_progress.to_map()
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.src_db_name is not None:
            result['SrcDbName'] = self.src_db_name
        if self.src_inst_id is not None:
            result['SrcInstId'] = self.src_inst_id
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BatchEvaluateTaskId') is not None:
            self.batch_evaluate_task_id = m.get('BatchEvaluateTaskId')
        if m.get('CreateDbProgress') is not None:
            self.create_db_progress = m.get('CreateDbProgress')
        if m.get('CreateTablesProgress') is not None:
            self.create_tables_progress = m.get('CreateTablesProgress')
        if m.get('DstDbName') is not None:
            self.dst_db_name = m.get('DstDbName')
        if m.get('DstInstId') is not None:
            self.dst_inst_id = m.get('DstInstId')
        if m.get('EvaluateTaskId') is not None:
            self.evaluate_task_id = m.get('EvaluateTaskId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('JingweiProgress') is not None:
            temp_model = DescribeDataImportTasksResponseBodyDataDataImportTaskJingweiProgress()
            self.jingwei_progress = temp_model.from_map(m['JingweiProgress'])
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('SrcDbName') is not None:
            self.src_db_name = m.get('SrcDbName')
        if m.get('SrcInstId') is not None:
            self.src_inst_id = m.get('SrcInstId')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDataImportTasksResponseBodyData(TeaModel):
    def __init__(self, data_import_task=None):
        self.data_import_task = data_import_task  # type: list[DescribeDataImportTasksResponseBodyDataDataImportTask]

    def validate(self):
        if self.data_import_task:
            for k in self.data_import_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDataImportTasksResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataImportTask'] = []
        if self.data_import_task is not None:
            for k in self.data_import_task:
                result['DataImportTask'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data_import_task = []
        if m.get('DataImportTask') is not None:
            for k in m.get('DataImportTask'):
                temp_model = DescribeDataImportTasksResponseBodyDataDataImportTask()
                self.data_import_task.append(temp_model.from_map(k))
        return self


class DescribeDataImportTasksResponseBody(TeaModel):
    def __init__(self, data=None, page_number=None, page_size=None, request_id=None, success=None, total=None):
        self.data = data  # type: DescribeDataImportTasksResponseBodyData
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDataImportTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDataImportTasksResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDataImportTasksResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDataImportTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDataImportTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDataImportTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDbInstanceDbsRequest(TeaModel):
    def __init__(self, account_name=None, db_inst_type=None, db_instance_id=None, drds_instance_id=None,
                 password=None):
        self.account_name = account_name  # type: str
        self.db_inst_type = db_inst_type  # type: str
        self.db_instance_id = db_instance_id  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.password = password  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDbInstanceDbsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.password is not None:
            result['Password'] = self.password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        return self


class DescribeDbInstanceDbsResponseBodyDatabasesDatabase(TeaModel):
    def __init__(self, db_name=None, description=None, status=None):
        self.db_name = db_name  # type: str
        self.description = description  # type: str
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDbInstanceDbsResponseBodyDatabasesDatabase, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.description is not None:
            result['Description'] = self.description
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDbInstanceDbsResponseBodyDatabases(TeaModel):
    def __init__(self, database=None):
        self.database = database  # type: list[DescribeDbInstanceDbsResponseBodyDatabasesDatabase]

    def validate(self):
        if self.database:
            for k in self.database:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDbInstanceDbsResponseBodyDatabases, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Database'] = []
        if self.database is not None:
            for k in self.database:
                result['Database'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.database = []
        if m.get('Database') is not None:
            for k in m.get('Database'):
                temp_model = DescribeDbInstanceDbsResponseBodyDatabasesDatabase()
                self.database.append(temp_model.from_map(k))
        return self


class DescribeDbInstanceDbsResponseBody(TeaModel):
    def __init__(self, databases=None, request_id=None, success=None, total=None):
        self.databases = databases  # type: DescribeDbInstanceDbsResponseBodyDatabases
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: str

    def validate(self):
        if self.databases:
            self.databases.validate()

    def to_map(self):
        _map = super(DescribeDbInstanceDbsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.databases is not None:
            result['Databases'] = self.databases.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Databases') is not None:
            temp_model = DescribeDbInstanceDbsResponseBodyDatabases()
            self.databases = temp_model.from_map(m['Databases'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDbInstanceDbsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDbInstanceDbsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDbInstanceDbsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDbInstanceDbsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDbInstancesRequest(TeaModel):
    def __init__(self, db_inst_type=None, drds_instance_id=None, page_number=None, page_size=None, search=None):
        self.db_inst_type = db_inst_type  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.search = search  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDbInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search is not None:
            result['Search'] = self.search
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Search') is not None:
            self.search = m.get('Search')
        return self


class DescribeDbInstancesResponseBodyItemsDBInstanceReadOnlyDBInstanceId(TeaModel):
    def __init__(self, read_only_dbinstance_id=None):
        self.read_only_dbinstance_id = read_only_dbinstance_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDbInstancesResponseBodyItemsDBInstanceReadOnlyDBInstanceId, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.read_only_dbinstance_id is not None:
            result['ReadOnlyDBInstanceId'] = self.read_only_dbinstance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReadOnlyDBInstanceId') is not None:
            self.read_only_dbinstance_id = m.get('ReadOnlyDBInstanceId')
        return self


class DescribeDbInstancesResponseBodyItemsDBInstance(TeaModel):
    def __init__(self, dbinstance_description=None, dbinstance_id=None, dbinstance_status=None,
                 dbinstance_type=None, engine=None, engine_version=None, instance_network_type=None, read_only_dbinstance_id=None,
                 region_id=None, zone_id=None):
        self.dbinstance_description = dbinstance_description  # type: str
        self.dbinstance_id = dbinstance_id  # type: str
        self.dbinstance_status = dbinstance_status  # type: int
        self.dbinstance_type = dbinstance_type  # type: str
        self.engine = engine  # type: str
        self.engine_version = engine_version  # type: str
        self.instance_network_type = instance_network_type  # type: str
        self.read_only_dbinstance_id = read_only_dbinstance_id  # type: DescribeDbInstancesResponseBodyItemsDBInstanceReadOnlyDBInstanceId
        self.region_id = region_id  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.read_only_dbinstance_id:
            self.read_only_dbinstance_id.validate()

    def to_map(self):
        _map = super(DescribeDbInstancesResponseBodyItemsDBInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_description is not None:
            result['DBInstanceDescription'] = self.dbinstance_description
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.dbinstance_type is not None:
            result['DBInstanceType'] = self.dbinstance_type
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.instance_network_type is not None:
            result['InstanceNetworkType'] = self.instance_network_type
        if self.read_only_dbinstance_id is not None:
            result['ReadOnlyDBInstanceId'] = self.read_only_dbinstance_id.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceDescription') is not None:
            self.dbinstance_description = m.get('DBInstanceDescription')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DBInstanceType') is not None:
            self.dbinstance_type = m.get('DBInstanceType')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('InstanceNetworkType') is not None:
            self.instance_network_type = m.get('InstanceNetworkType')
        if m.get('ReadOnlyDBInstanceId') is not None:
            temp_model = DescribeDbInstancesResponseBodyItemsDBInstanceReadOnlyDBInstanceId()
            self.read_only_dbinstance_id = temp_model.from_map(m['ReadOnlyDBInstanceId'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDbInstancesResponseBodyItems(TeaModel):
    def __init__(self, dbinstance=None):
        self.dbinstance = dbinstance  # type: list[DescribeDbInstancesResponseBodyItemsDBInstance]

    def validate(self):
        if self.dbinstance:
            for k in self.dbinstance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDbInstancesResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBInstance'] = []
        if self.dbinstance is not None:
            for k in self.dbinstance:
                result['DBInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbinstance = []
        if m.get('DBInstance') is not None:
            for k in m.get('DBInstance'):
                temp_model = DescribeDbInstancesResponseBodyItemsDBInstance()
                self.dbinstance.append(temp_model.from_map(k))
        return self


class DescribeDbInstancesResponseBody(TeaModel):
    def __init__(self, items=None, request_id=None):
        self.items = items  # type: DescribeDbInstancesResponseBodyItems
        self.request_id = request_id  # type: str

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeDbInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeDbInstancesResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDbInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDbInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDbInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDbInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsDBRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDBRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeDrdsDBResponseBodyData(TeaModel):
    def __init__(self, create_time=None, db_inst_type=None, db_name=None, inst_role=None, mode=None, schema=None,
                 status=None):
        self.create_time = create_time  # type: str
        self.db_inst_type = db_inst_type  # type: str
        self.db_name = db_name  # type: str
        self.inst_role = inst_role  # type: str
        self.mode = mode  # type: str
        self.schema = schema  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDBResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.inst_role is not None:
            result['InstRole'] = self.inst_role
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.schema is not None:
            result['Schema'] = self.schema
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('InstRole') is not None:
            self.inst_role = m.get('InstRole')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Schema') is not None:
            self.schema = m.get('Schema')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDrdsDBResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: DescribeDrdsDBResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDrdsDBResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsDBResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsDBResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsDBResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsDBClusterRequest(TeaModel):
    def __init__(self, db_instance_id=None, db_name=None, drds_instance_id=None):
        self.db_instance_id = db_instance_id  # type: str
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDBClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeDrdsDBClusterResponseBodyDbInstanceDBNodesDBNode(TeaModel):
    def __init__(self, dbnode_id=None, dbnode_role=None, dbnode_status=None, zone_id=None):
        self.dbnode_id = dbnode_id  # type: str
        self.dbnode_role = dbnode_role  # type: str
        self.dbnode_status = dbnode_status  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDBClusterResponseBodyDbInstanceDBNodesDBNode, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbnode_id is not None:
            result['DBNodeId'] = self.dbnode_id
        if self.dbnode_role is not None:
            result['DBNodeRole'] = self.dbnode_role
        if self.dbnode_status is not None:
            result['DBNodeStatus'] = self.dbnode_status
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBNodeId') is not None:
            self.dbnode_id = m.get('DBNodeId')
        if m.get('DBNodeRole') is not None:
            self.dbnode_role = m.get('DBNodeRole')
        if m.get('DBNodeStatus') is not None:
            self.dbnode_status = m.get('DBNodeStatus')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDrdsDBClusterResponseBodyDbInstanceDBNodes(TeaModel):
    def __init__(self, dbnode=None):
        self.dbnode = dbnode  # type: list[DescribeDrdsDBClusterResponseBodyDbInstanceDBNodesDBNode]

    def validate(self):
        if self.dbnode:
            for k in self.dbnode:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBClusterResponseBodyDbInstanceDBNodes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DBNode'] = []
        if self.dbnode is not None:
            for k in self.dbnode:
                result['DBNode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dbnode = []
        if m.get('DBNode') is not None:
            for k in m.get('DBNode'):
                temp_model = DescribeDrdsDBClusterResponseBodyDbInstanceDBNodesDBNode()
                self.dbnode.append(temp_model.from_map(k))
        return self


class DescribeDrdsDBClusterResponseBodyDbInstanceEndpointsEndpoint(TeaModel):
    def __init__(self, endpoint_id=None, node_ids=None, read_weight=None):
        self.endpoint_id = endpoint_id  # type: str
        self.node_ids = node_ids  # type: str
        self.read_weight = read_weight  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDBClusterResponseBodyDbInstanceEndpointsEndpoint, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.endpoint_id is not None:
            result['EndpointId'] = self.endpoint_id
        if self.node_ids is not None:
            result['NodeIds'] = self.node_ids
        if self.read_weight is not None:
            result['ReadWeight'] = self.read_weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndpointId') is not None:
            self.endpoint_id = m.get('EndpointId')
        if m.get('NodeIds') is not None:
            self.node_ids = m.get('NodeIds')
        if m.get('ReadWeight') is not None:
            self.read_weight = m.get('ReadWeight')
        return self


class DescribeDrdsDBClusterResponseBodyDbInstanceEndpoints(TeaModel):
    def __init__(self, endpoint=None):
        self.endpoint = endpoint  # type: list[DescribeDrdsDBClusterResponseBodyDbInstanceEndpointsEndpoint]

    def validate(self):
        if self.endpoint:
            for k in self.endpoint:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBClusterResponseBodyDbInstanceEndpoints, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Endpoint'] = []
        if self.endpoint is not None:
            for k in self.endpoint:
                result['Endpoint'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.endpoint = []
        if m.get('Endpoint') is not None:
            for k in m.get('Endpoint'):
                temp_model = DescribeDrdsDBClusterResponseBodyDbInstanceEndpointsEndpoint()
                self.endpoint.append(temp_model.from_map(k))
        return self


class DescribeDrdsDBClusterResponseBodyDbInstance(TeaModel):
    def __init__(self, dbinstance_id=None, dbinstance_status=None, dbnodes=None, db_inst_type=None, endpoints=None,
                 engine=None, engine_version=None, expire_time=None, network_type=None, pay_type=None, port=None,
                 rds_inst_type=None, read_mode=None, remain_days=None):
        self.dbinstance_id = dbinstance_id  # type: str
        self.dbinstance_status = dbinstance_status  # type: str
        self.dbnodes = dbnodes  # type: DescribeDrdsDBClusterResponseBodyDbInstanceDBNodes
        self.db_inst_type = db_inst_type  # type: str
        self.endpoints = endpoints  # type: DescribeDrdsDBClusterResponseBodyDbInstanceEndpoints
        self.engine = engine  # type: str
        self.engine_version = engine_version  # type: str
        self.expire_time = expire_time  # type: str
        self.network_type = network_type  # type: str
        self.pay_type = pay_type  # type: str
        self.port = port  # type: int
        self.rds_inst_type = rds_inst_type  # type: str
        self.read_mode = read_mode  # type: str
        self.remain_days = remain_days  # type: str

    def validate(self):
        if self.dbnodes:
            self.dbnodes.validate()
        if self.endpoints:
            self.endpoints.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBClusterResponseBodyDbInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.dbnodes is not None:
            result['DBNodes'] = self.dbnodes.to_map()
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.endpoints is not None:
            result['Endpoints'] = self.endpoints.to_map()
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.port is not None:
            result['Port'] = self.port
        if self.rds_inst_type is not None:
            result['RdsInstType'] = self.rds_inst_type
        if self.read_mode is not None:
            result['ReadMode'] = self.read_mode
        if self.remain_days is not None:
            result['RemainDays'] = self.remain_days
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DBNodes') is not None:
            temp_model = DescribeDrdsDBClusterResponseBodyDbInstanceDBNodes()
            self.dbnodes = temp_model.from_map(m['DBNodes'])
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('Endpoints') is not None:
            temp_model = DescribeDrdsDBClusterResponseBodyDbInstanceEndpoints()
            self.endpoints = temp_model.from_map(m['Endpoints'])
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RdsInstType') is not None:
            self.rds_inst_type = m.get('RdsInstType')
        if m.get('ReadMode') is not None:
            self.read_mode = m.get('ReadMode')
        if m.get('RemainDays') is not None:
            self.remain_days = m.get('RemainDays')
        return self


class DescribeDrdsDBClusterResponseBody(TeaModel):
    def __init__(self, db_instance=None, request_id=None, success=None):
        self.db_instance = db_instance  # type: DescribeDrdsDBClusterResponseBodyDbInstance
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.db_instance:
            self.db_instance.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance is not None:
            result['DbInstance'] = self.db_instance.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstance') is not None:
            temp_model = DescribeDrdsDBClusterResponseBodyDbInstance()
            self.db_instance = temp_model.from_map(m['DbInstance'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsDBClusterResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsDBClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsDBClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsDBIpWhiteListRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, group_name=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.group_name = group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDBIpWhiteListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DescribeDrdsDBIpWhiteListResponseBodyIpWhiteList(TeaModel):
    def __init__(self, ip=None):
        self.ip = ip  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDBIpWhiteListResponseBodyIpWhiteList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class DescribeDrdsDBIpWhiteListResponseBody(TeaModel):
    def __init__(self, ip_white_list=None, request_id=None, success=None):
        self.ip_white_list = ip_white_list  # type: DescribeDrdsDBIpWhiteListResponseBodyIpWhiteList
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.ip_white_list:
            self.ip_white_list.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBIpWhiteListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_white_list is not None:
            result['IpWhiteList'] = self.ip_white_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IpWhiteList') is not None:
            temp_model = DescribeDrdsDBIpWhiteListResponseBodyIpWhiteList()
            self.ip_white_list = temp_model.from_map(m['IpWhiteList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsDBIpWhiteListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsDBIpWhiteListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBIpWhiteListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsDBIpWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsDBsRequest(TeaModel):
    def __init__(self, drds_instance_id=None, page_number=None, page_size=None, region_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDBsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDrdsDBsResponseBodyDataDb(TeaModel):
    def __init__(self, create_time=None, db_inst_type=None, db_name=None, mode=None, schema=None, status=None):
        self.create_time = create_time  # type: str
        self.db_inst_type = db_inst_type  # type: str
        self.db_name = db_name  # type: str
        self.mode = mode  # type: str
        self.schema = schema  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDBsResponseBodyDataDb, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.schema is not None:
            result['Schema'] = self.schema
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Schema') is not None:
            self.schema = m.get('Schema')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDrdsDBsResponseBodyData(TeaModel):
    def __init__(self, db=None):
        self.db = db  # type: list[DescribeDrdsDBsResponseBodyDataDb]

    def validate(self):
        if self.db:
            for k in self.db:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Db'] = []
        if self.db is not None:
            for k in self.db:
                result['Db'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.db = []
        if m.get('Db') is not None:
            for k in m.get('Db'):
                temp_model = DescribeDrdsDBsResponseBodyDataDb()
                self.db.append(temp_model.from_map(k))
        return self


class DescribeDrdsDBsResponseBody(TeaModel):
    def __init__(self, data=None, page_number=None, page_size=None, request_id=None, success=None, total=None):
        self.data = data  # type: DescribeDrdsDBsResponseBodyData
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDrdsDBsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDrdsDBsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsDBsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsDBsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsDBsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsDbInstanceRequest(TeaModel):
    def __init__(self, db_instance_id=None, db_name=None, drds_instance_id=None):
        self.db_instance_id = db_instance_id  # type: str
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDbInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeDrdsDbInstanceResponseBodyDbInstanceReadOnlyInstancesReadOnlyInstance(TeaModel):
    def __init__(self, connect_url=None, dbinstance_id=None, dbinstance_status=None, db_inst_type=None,
                 dm_instance_id=None, engine=None, engine_version=None, expire_time=None, network_type=None, pay_type=None,
                 port=None, rds_inst_type=None, read_weight=None, remain_days=None, version_action=None):
        self.connect_url = connect_url  # type: str
        self.dbinstance_id = dbinstance_id  # type: str
        self.dbinstance_status = dbinstance_status  # type: str
        self.db_inst_type = db_inst_type  # type: str
        self.dm_instance_id = dm_instance_id  # type: str
        self.engine = engine  # type: str
        self.engine_version = engine_version  # type: str
        self.expire_time = expire_time  # type: str
        self.network_type = network_type  # type: str
        self.pay_type = pay_type  # type: str
        self.port = port  # type: int
        self.rds_inst_type = rds_inst_type  # type: str
        self.read_weight = read_weight  # type: int
        self.remain_days = remain_days  # type: str
        self.version_action = version_action  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDbInstanceResponseBodyDbInstanceReadOnlyInstancesReadOnlyInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connect_url is not None:
            result['ConnectUrl'] = self.connect_url
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.dm_instance_id is not None:
            result['DmInstanceId'] = self.dm_instance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.port is not None:
            result['Port'] = self.port
        if self.rds_inst_type is not None:
            result['RdsInstType'] = self.rds_inst_type
        if self.read_weight is not None:
            result['ReadWeight'] = self.read_weight
        if self.remain_days is not None:
            result['RemainDays'] = self.remain_days
        if self.version_action is not None:
            result['VersionAction'] = self.version_action
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectUrl') is not None:
            self.connect_url = m.get('ConnectUrl')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DmInstanceId') is not None:
            self.dm_instance_id = m.get('DmInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RdsInstType') is not None:
            self.rds_inst_type = m.get('RdsInstType')
        if m.get('ReadWeight') is not None:
            self.read_weight = m.get('ReadWeight')
        if m.get('RemainDays') is not None:
            self.remain_days = m.get('RemainDays')
        if m.get('VersionAction') is not None:
            self.version_action = m.get('VersionAction')
        return self


class DescribeDrdsDbInstanceResponseBodyDbInstanceReadOnlyInstances(TeaModel):
    def __init__(self, read_only_instance=None):
        self.read_only_instance = read_only_instance  # type: list[DescribeDrdsDbInstanceResponseBodyDbInstanceReadOnlyInstancesReadOnlyInstance]

    def validate(self):
        if self.read_only_instance:
            for k in self.read_only_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbInstanceResponseBodyDbInstanceReadOnlyInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ReadOnlyInstance'] = []
        if self.read_only_instance is not None:
            for k in self.read_only_instance:
                result['ReadOnlyInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.read_only_instance = []
        if m.get('ReadOnlyInstance') is not None:
            for k in m.get('ReadOnlyInstance'):
                temp_model = DescribeDrdsDbInstanceResponseBodyDbInstanceReadOnlyInstancesReadOnlyInstance()
                self.read_only_instance.append(temp_model.from_map(k))
        return self


class DescribeDrdsDbInstanceResponseBodyDbInstance(TeaModel):
    def __init__(self, connect_url=None, dbinstance_id=None, dbinstance_status=None, db_inst_type=None,
                 dm_instance_id=None, engine=None, engine_version=None, expire_time=None, network_type=None, pay_type=None,
                 port=None, rds_inst_type=None, read_only_instances=None, read_weight=None, remain_days=None):
        self.connect_url = connect_url  # type: str
        self.dbinstance_id = dbinstance_id  # type: str
        self.dbinstance_status = dbinstance_status  # type: str
        self.db_inst_type = db_inst_type  # type: str
        self.dm_instance_id = dm_instance_id  # type: str
        self.engine = engine  # type: str
        self.engine_version = engine_version  # type: str
        self.expire_time = expire_time  # type: str
        self.network_type = network_type  # type: str
        self.pay_type = pay_type  # type: str
        self.port = port  # type: int
        self.rds_inst_type = rds_inst_type  # type: str
        self.read_only_instances = read_only_instances  # type: DescribeDrdsDbInstanceResponseBodyDbInstanceReadOnlyInstances
        self.read_weight = read_weight  # type: int
        self.remain_days = remain_days  # type: str

    def validate(self):
        if self.read_only_instances:
            self.read_only_instances.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbInstanceResponseBodyDbInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connect_url is not None:
            result['ConnectUrl'] = self.connect_url
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.dm_instance_id is not None:
            result['DmInstanceId'] = self.dm_instance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.port is not None:
            result['Port'] = self.port
        if self.rds_inst_type is not None:
            result['RdsInstType'] = self.rds_inst_type
        if self.read_only_instances is not None:
            result['ReadOnlyInstances'] = self.read_only_instances.to_map()
        if self.read_weight is not None:
            result['ReadWeight'] = self.read_weight
        if self.remain_days is not None:
            result['RemainDays'] = self.remain_days
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectUrl') is not None:
            self.connect_url = m.get('ConnectUrl')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DmInstanceId') is not None:
            self.dm_instance_id = m.get('DmInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RdsInstType') is not None:
            self.rds_inst_type = m.get('RdsInstType')
        if m.get('ReadOnlyInstances') is not None:
            temp_model = DescribeDrdsDbInstanceResponseBodyDbInstanceReadOnlyInstances()
            self.read_only_instances = temp_model.from_map(m['ReadOnlyInstances'])
        if m.get('ReadWeight') is not None:
            self.read_weight = m.get('ReadWeight')
        if m.get('RemainDays') is not None:
            self.remain_days = m.get('RemainDays')
        return self


class DescribeDrdsDbInstanceResponseBody(TeaModel):
    def __init__(self, db_instance=None, request_id=None, success=None):
        self.db_instance = db_instance  # type: DescribeDrdsDbInstanceResponseBodyDbInstance
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.db_instance:
            self.db_instance.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance is not None:
            result['DbInstance'] = self.db_instance.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstance') is not None:
            temp_model = DescribeDrdsDbInstanceResponseBodyDbInstance()
            self.db_instance = temp_model.from_map(m['DbInstance'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsDbInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsDbInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsDbInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsDbInstancesRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, page_number=None, page_size=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDbInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstanceReadOnlyInstancesReadOnlyInstance(TeaModel):
    def __init__(self, connect_url=None, dbinstance_status=None, db_inst_type=None, dm_instance_id=None,
                 engine=None, engine_version=None, expire_time=None, instance_name=None, network_type=None, pay_type=None,
                 port=None, rds_inst_type=None, read_weight=None, remain_days=None):
        self.connect_url = connect_url  # type: str
        self.dbinstance_status = dbinstance_status  # type: str
        self.db_inst_type = db_inst_type  # type: str
        self.dm_instance_id = dm_instance_id  # type: str
        self.engine = engine  # type: str
        self.engine_version = engine_version  # type: str
        self.expire_time = expire_time  # type: str
        self.instance_name = instance_name  # type: str
        self.network_type = network_type  # type: str
        self.pay_type = pay_type  # type: str
        self.port = port  # type: int
        self.rds_inst_type = rds_inst_type  # type: str
        self.read_weight = read_weight  # type: int
        self.remain_days = remain_days  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstanceReadOnlyInstancesReadOnlyInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connect_url is not None:
            result['ConnectUrl'] = self.connect_url
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.dm_instance_id is not None:
            result['DmInstanceId'] = self.dm_instance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.port is not None:
            result['Port'] = self.port
        if self.rds_inst_type is not None:
            result['RdsInstType'] = self.rds_inst_type
        if self.read_weight is not None:
            result['ReadWeight'] = self.read_weight
        if self.remain_days is not None:
            result['RemainDays'] = self.remain_days
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectUrl') is not None:
            self.connect_url = m.get('ConnectUrl')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DmInstanceId') is not None:
            self.dm_instance_id = m.get('DmInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RdsInstType') is not None:
            self.rds_inst_type = m.get('RdsInstType')
        if m.get('ReadWeight') is not None:
            self.read_weight = m.get('ReadWeight')
        if m.get('RemainDays') is not None:
            self.remain_days = m.get('RemainDays')
        return self


class DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstanceReadOnlyInstances(TeaModel):
    def __init__(self, read_only_instance=None):
        self.read_only_instance = read_only_instance  # type: list[DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstanceReadOnlyInstancesReadOnlyInstance]

    def validate(self):
        if self.read_only_instance:
            for k in self.read_only_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstanceReadOnlyInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ReadOnlyInstance'] = []
        if self.read_only_instance is not None:
            for k in self.read_only_instance:
                result['ReadOnlyInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.read_only_instance = []
        if m.get('ReadOnlyInstance') is not None:
            for k in m.get('ReadOnlyInstance'):
                temp_model = DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstanceReadOnlyInstancesReadOnlyInstance()
                self.read_only_instance.append(temp_model.from_map(k))
        return self


class DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstance(TeaModel):
    def __init__(self, connect_url=None, dbinstance_id=None, dbinstance_status=None, db_inst_type=None,
                 dm_instance_id=None, engine=None, engine_version=None, expire_time=None, network_type=None, pay_type=None,
                 port=None, rds_inst_type=None, read_only_instances=None, read_weight=None, remain_days=None):
        self.connect_url = connect_url  # type: str
        self.dbinstance_id = dbinstance_id  # type: str
        self.dbinstance_status = dbinstance_status  # type: str
        self.db_inst_type = db_inst_type  # type: str
        self.dm_instance_id = dm_instance_id  # type: str
        self.engine = engine  # type: str
        self.engine_version = engine_version  # type: str
        self.expire_time = expire_time  # type: str
        self.network_type = network_type  # type: str
        self.pay_type = pay_type  # type: str
        self.port = port  # type: int
        self.rds_inst_type = rds_inst_type  # type: str
        self.read_only_instances = read_only_instances  # type: DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstanceReadOnlyInstances
        self.read_weight = read_weight  # type: int
        self.remain_days = remain_days  # type: int

    def validate(self):
        if self.read_only_instances:
            self.read_only_instances.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connect_url is not None:
            result['ConnectUrl'] = self.connect_url
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.dm_instance_id is not None:
            result['DmInstanceId'] = self.dm_instance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.port is not None:
            result['Port'] = self.port
        if self.rds_inst_type is not None:
            result['RdsInstType'] = self.rds_inst_type
        if self.read_only_instances is not None:
            result['ReadOnlyInstances'] = self.read_only_instances.to_map()
        if self.read_weight is not None:
            result['ReadWeight'] = self.read_weight
        if self.remain_days is not None:
            result['RemainDays'] = self.remain_days
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectUrl') is not None:
            self.connect_url = m.get('ConnectUrl')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DmInstanceId') is not None:
            self.dm_instance_id = m.get('DmInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RdsInstType') is not None:
            self.rds_inst_type = m.get('RdsInstType')
        if m.get('ReadOnlyInstances') is not None:
            temp_model = DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstanceReadOnlyInstances()
            self.read_only_instances = temp_model.from_map(m['ReadOnlyInstances'])
        if m.get('ReadWeight') is not None:
            self.read_weight = m.get('ReadWeight')
        if m.get('RemainDays') is not None:
            self.remain_days = m.get('RemainDays')
        return self


class DescribeDrdsDbInstancesResponseBodyDbInstances(TeaModel):
    def __init__(self, db_instance=None):
        self.db_instance = db_instance  # type: list[DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstance]

    def validate(self):
        if self.db_instance:
            for k in self.db_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbInstancesResponseBodyDbInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DbInstance'] = []
        if self.db_instance is not None:
            for k in self.db_instance:
                result['DbInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.db_instance = []
        if m.get('DbInstance') is not None:
            for k in m.get('DbInstance'):
                temp_model = DescribeDrdsDbInstancesResponseBodyDbInstancesDbInstance()
                self.db_instance.append(temp_model.from_map(k))
        return self


class DescribeDrdsDbInstancesResponseBody(TeaModel):
    def __init__(self, db_instances=None, page_number=None, page_size=None, request_id=None, success=None,
                 total=None):
        self.db_instances = db_instances  # type: DescribeDrdsDbInstancesResponseBodyDbInstances
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: str

    def validate(self):
        if self.db_instances:
            self.db_instances.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instances is not None:
            result['DbInstances'] = self.db_instances.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstances') is not None:
            temp_model = DescribeDrdsDbInstancesResponseBodyDbInstances()
            self.db_instances = temp_model.from_map(m['DbInstances'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDrdsDbInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsDbInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsDbInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsDbRdsNameListRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDbRdsNameListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeDrdsDbRdsNameListResponseBodyInstanceNameList(TeaModel):
    def __init__(self, instance_name=None):
        self.instance_name = instance_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDbRdsNameListResponseBodyInstanceNameList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        return self


class DescribeDrdsDbRdsNameListResponseBody(TeaModel):
    def __init__(self, instance_name_list=None, request_id=None, success=None):
        self.instance_name_list = instance_name_list  # type: DescribeDrdsDbRdsNameListResponseBodyInstanceNameList
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.instance_name_list:
            self.instance_name_list.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbRdsNameListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_name_list is not None:
            result['InstanceNameList'] = self.instance_name_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceNameList') is not None:
            temp_model = DescribeDrdsDbRdsNameListResponseBodyInstanceNameList()
            self.instance_name_list = temp_model.from_map(m['InstanceNameList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsDbRdsNameListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsDbRdsNameListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbRdsNameListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsDbRdsNameListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsDbTasksRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, task_type=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDbTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeDrdsDbTasksResponseBodyTasksTask(TeaModel):
    def __init__(self, allow_cancel=None, db_compute_length=None, detail_task_id=None, expand_type=None,
                 gmt_create=None, label=None, parent_job_id=None, progress=None, show_progress=None, target_id=None,
                 task_detail=None, task_name=None, task_phase=None, task_status=None, task_type=None, tb_compute_length=None):
        self.allow_cancel = allow_cancel  # type: bool
        self.db_compute_length = db_compute_length  # type: int
        self.detail_task_id = detail_task_id  # type: str
        self.expand_type = expand_type  # type: str
        self.gmt_create = gmt_create  # type: long
        self.label = label  # type: str
        self.parent_job_id = parent_job_id  # type: str
        self.progress = progress  # type: int
        self.show_progress = show_progress  # type: bool
        self.target_id = target_id  # type: long
        self.task_detail = task_detail  # type: str
        self.task_name = task_name  # type: str
        self.task_phase = task_phase  # type: str
        self.task_status = task_status  # type: int
        self.task_type = task_type  # type: int
        self.tb_compute_length = tb_compute_length  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsDbTasksResponseBodyTasksTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_cancel is not None:
            result['AllowCancel'] = self.allow_cancel
        if self.db_compute_length is not None:
            result['DbComputeLength'] = self.db_compute_length
        if self.detail_task_id is not None:
            result['DetailTaskId'] = self.detail_task_id
        if self.expand_type is not None:
            result['ExpandType'] = self.expand_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.label is not None:
            result['Label'] = self.label
        if self.parent_job_id is not None:
            result['ParentJobId'] = self.parent_job_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.show_progress is not None:
            result['ShowProgress'] = self.show_progress
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        if self.task_detail is not None:
            result['TaskDetail'] = self.task_detail
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_phase is not None:
            result['TaskPhase'] = self.task_phase
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.tb_compute_length is not None:
            result['TbComputeLength'] = self.tb_compute_length
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllowCancel') is not None:
            self.allow_cancel = m.get('AllowCancel')
        if m.get('DbComputeLength') is not None:
            self.db_compute_length = m.get('DbComputeLength')
        if m.get('DetailTaskId') is not None:
            self.detail_task_id = m.get('DetailTaskId')
        if m.get('ExpandType') is not None:
            self.expand_type = m.get('ExpandType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('ParentJobId') is not None:
            self.parent_job_id = m.get('ParentJobId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ShowProgress') is not None:
            self.show_progress = m.get('ShowProgress')
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        if m.get('TaskDetail') is not None:
            self.task_detail = m.get('TaskDetail')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskPhase') is not None:
            self.task_phase = m.get('TaskPhase')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TbComputeLength') is not None:
            self.tb_compute_length = m.get('TbComputeLength')
        return self


class DescribeDrdsDbTasksResponseBodyTasks(TeaModel):
    def __init__(self, task=None):
        self.task = task  # type: list[DescribeDrdsDbTasksResponseBodyTasksTask]

    def validate(self):
        if self.task:
            for k in self.task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbTasksResponseBodyTasks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Task'] = []
        if self.task is not None:
            for k in self.task:
                result['Task'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.task = []
        if m.get('Task') is not None:
            for k in m.get('Task'):
                temp_model = DescribeDrdsDbTasksResponseBodyTasksTask()
                self.task.append(temp_model.from_map(k))
        return self


class DescribeDrdsDbTasksResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, tasks=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.tasks = tasks  # type: DescribeDrdsDbTasksResponseBodyTasks

    def validate(self):
        if self.tasks:
            self.tasks.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tasks is not None:
            result['Tasks'] = self.tasks.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Tasks') is not None:
            temp_model = DescribeDrdsDbTasksResponseBodyTasks()
            self.tasks = temp_model.from_map(m['Tasks'])
        return self


class DescribeDrdsDbTasksResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsDbTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsDbTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsDbTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsInstanceRequest(TeaModel):
    def __init__(self, drds_instance_id=None, region_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDrdsInstanceResponseBodyDataReadOnlyDBInstanceIds(TeaModel):
    def __init__(self, read_only_dbinstance_id=None):
        self.read_only_dbinstance_id = read_only_dbinstance_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstanceResponseBodyDataReadOnlyDBInstanceIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.read_only_dbinstance_id is not None:
            result['ReadOnlyDBInstanceId'] = self.read_only_dbinstance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReadOnlyDBInstanceId') is not None:
            self.read_only_dbinstance_id = m.get('ReadOnlyDBInstanceId')
        return self


class DescribeDrdsInstanceResponseBodyDataVipsVip(TeaModel):
    def __init__(self, dns=None, expire_days=None, port=None, type=None, vpc_id=None, vswitch_id=None):
        self.dns = dns  # type: str
        self.expire_days = expire_days  # type: long
        self.port = port  # type: str
        self.type = type  # type: str
        self.vpc_id = vpc_id  # type: str
        self.vswitch_id = vswitch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstanceResponseBodyDataVipsVip, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns is not None:
            result['Dns'] = self.dns
        if self.expire_days is not None:
            result['ExpireDays'] = self.expire_days
        if self.port is not None:
            result['Port'] = self.port
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dns') is not None:
            self.dns = m.get('Dns')
        if m.get('ExpireDays') is not None:
            self.expire_days = m.get('ExpireDays')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        return self


class DescribeDrdsInstanceResponseBodyDataVips(TeaModel):
    def __init__(self, vip=None):
        self.vip = vip  # type: list[DescribeDrdsInstanceResponseBodyDataVipsVip]

    def validate(self):
        if self.vip:
            for k in self.vip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceResponseBodyDataVips, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Vip'] = []
        if self.vip is not None:
            for k in self.vip:
                result['Vip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.vip = []
        if m.get('Vip') is not None:
            for k in m.get('Vip'):
                temp_model = DescribeDrdsInstanceResponseBodyDataVipsVip()
                self.vip.append(temp_model.from_map(k))
        return self


class DescribeDrdsInstanceResponseBodyData(TeaModel):
    def __init__(self, commodity_code=None, create_time=None, description=None, drds_instance_id=None,
                 expire_date=None, inst_role=None, instance_series=None, instance_spec=None, label=None, machine_type=None,
                 master_instance_id=None, mysql_version=None, network_type=None, order_instance_id=None, product_version=None,
                 read_only_dbinstance_ids=None, region_id=None, resource_group_id=None, status=None, storage_type=None, type=None,
                 version=None, version_action=None, vips=None, vpc_cloud_instance_id=None, zone_id=None):
        self.commodity_code = commodity_code  # type: str
        self.create_time = create_time  # type: long
        self.description = description  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.expire_date = expire_date  # type: long
        self.inst_role = inst_role  # type: str
        self.instance_series = instance_series  # type: str
        self.instance_spec = instance_spec  # type: str
        self.label = label  # type: str
        self.machine_type = machine_type  # type: str
        self.master_instance_id = master_instance_id  # type: str
        self.mysql_version = mysql_version  # type: int
        self.network_type = network_type  # type: str
        self.order_instance_id = order_instance_id  # type: str
        self.product_version = product_version  # type: str
        self.read_only_dbinstance_ids = read_only_dbinstance_ids  # type: DescribeDrdsInstanceResponseBodyDataReadOnlyDBInstanceIds
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.status = status  # type: str
        self.storage_type = storage_type  # type: str
        self.type = type  # type: str
        self.version = version  # type: long
        self.version_action = version_action  # type: str
        self.vips = vips  # type: DescribeDrdsInstanceResponseBodyDataVips
        self.vpc_cloud_instance_id = vpc_cloud_instance_id  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.read_only_dbinstance_ids:
            self.read_only_dbinstance_ids.validate()
        if self.vips:
            self.vips.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.expire_date is not None:
            result['ExpireDate'] = self.expire_date
        if self.inst_role is not None:
            result['InstRole'] = self.inst_role
        if self.instance_series is not None:
            result['InstanceSeries'] = self.instance_series
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.label is not None:
            result['Label'] = self.label
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.master_instance_id is not None:
            result['MasterInstanceId'] = self.master_instance_id
        if self.mysql_version is not None:
            result['MysqlVersion'] = self.mysql_version
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.order_instance_id is not None:
            result['OrderInstanceId'] = self.order_instance_id
        if self.product_version is not None:
            result['ProductVersion'] = self.product_version
        if self.read_only_dbinstance_ids is not None:
            result['ReadOnlyDBInstanceIds'] = self.read_only_dbinstance_ids.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.status is not None:
            result['Status'] = self.status
        if self.storage_type is not None:
            result['StorageType'] = self.storage_type
        if self.type is not None:
            result['Type'] = self.type
        if self.version is not None:
            result['Version'] = self.version
        if self.version_action is not None:
            result['VersionAction'] = self.version_action
        if self.vips is not None:
            result['Vips'] = self.vips.to_map()
        if self.vpc_cloud_instance_id is not None:
            result['VpcCloudInstanceId'] = self.vpc_cloud_instance_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('ExpireDate') is not None:
            self.expire_date = m.get('ExpireDate')
        if m.get('InstRole') is not None:
            self.inst_role = m.get('InstRole')
        if m.get('InstanceSeries') is not None:
            self.instance_series = m.get('InstanceSeries')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('MasterInstanceId') is not None:
            self.master_instance_id = m.get('MasterInstanceId')
        if m.get('MysqlVersion') is not None:
            self.mysql_version = m.get('MysqlVersion')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('OrderInstanceId') is not None:
            self.order_instance_id = m.get('OrderInstanceId')
        if m.get('ProductVersion') is not None:
            self.product_version = m.get('ProductVersion')
        if m.get('ReadOnlyDBInstanceIds') is not None:
            temp_model = DescribeDrdsInstanceResponseBodyDataReadOnlyDBInstanceIds()
            self.read_only_dbinstance_ids = temp_model.from_map(m['ReadOnlyDBInstanceIds'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StorageType') is not None:
            self.storage_type = m.get('StorageType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VersionAction') is not None:
            self.version_action = m.get('VersionAction')
        if m.get('Vips') is not None:
            temp_model = DescribeDrdsInstanceResponseBodyDataVips()
            self.vips = temp_model.from_map(m['Vips'])
        if m.get('VpcCloudInstanceId') is not None:
            self.vpc_cloud_instance_id = m.get('VpcCloudInstanceId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDrdsInstanceResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: DescribeDrdsInstanceResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDrdsInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsInstanceDbMonitorRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, end_time=None, key=None, region_id=None, start_time=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.end_time = end_time  # type: long
        self.key = key  # type: str
        self.region_id = region_id  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstanceDbMonitorRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.key is not None:
            result['Key'] = self.key
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDrdsInstanceDbMonitorResponseBodyDataValues(TeaModel):
    def __init__(self, date=None, value=None):
        self.date = date  # type: long
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstanceDbMonitorResponseBodyDataValues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDrdsInstanceDbMonitorResponseBodyData(TeaModel):
    def __init__(self, key=None, unit=None, values=None):
        self.key = key  # type: str
        self.unit = unit  # type: str
        self.values = values  # type: list[DescribeDrdsInstanceDbMonitorResponseBodyDataValues]

    def validate(self):
        if self.values:
            for k in self.values:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceDbMonitorResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.unit is not None:
            result['Unit'] = self.unit
        result['Values'] = []
        if self.values is not None:
            for k in self.values:
                result['Values'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        self.values = []
        if m.get('Values') is not None:
            for k in m.get('Values'):
                temp_model = DescribeDrdsInstanceDbMonitorResponseBodyDataValues()
                self.values.append(temp_model.from_map(k))
        return self


class DescribeDrdsInstanceDbMonitorResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: list[DescribeDrdsInstanceDbMonitorResponseBodyData]
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceDbMonitorResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeDrdsInstanceDbMonitorResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsInstanceDbMonitorResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsInstanceDbMonitorResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceDbMonitorResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsInstanceDbMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsInstanceLevelTasksRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstanceLevelTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeDrdsInstanceLevelTasksResponseBodyTasksTask(TeaModel):
    def __init__(self, allow_cancel=None, err_msg=None, gmt_create=None, progress=None, progress_description=None,
                 show_progress=None, target_id=None, task_name=None, task_phase=None, task_status=None, task_type=None):
        self.allow_cancel = allow_cancel  # type: bool
        self.err_msg = err_msg  # type: str
        self.gmt_create = gmt_create  # type: long
        self.progress = progress  # type: int
        self.progress_description = progress_description  # type: str
        self.show_progress = show_progress  # type: bool
        self.target_id = target_id  # type: long
        self.task_name = task_name  # type: str
        self.task_phase = task_phase  # type: str
        self.task_status = task_status  # type: int
        self.task_type = task_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstanceLevelTasksResponseBodyTasksTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_cancel is not None:
            result['AllowCancel'] = self.allow_cancel
        if self.err_msg is not None:
            result['ErrMsg'] = self.err_msg
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.progress_description is not None:
            result['ProgressDescription'] = self.progress_description
        if self.show_progress is not None:
            result['ShowProgress'] = self.show_progress
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_phase is not None:
            result['TaskPhase'] = self.task_phase
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllowCancel') is not None:
            self.allow_cancel = m.get('AllowCancel')
        if m.get('ErrMsg') is not None:
            self.err_msg = m.get('ErrMsg')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('ProgressDescription') is not None:
            self.progress_description = m.get('ProgressDescription')
        if m.get('ShowProgress') is not None:
            self.show_progress = m.get('ShowProgress')
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskPhase') is not None:
            self.task_phase = m.get('TaskPhase')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeDrdsInstanceLevelTasksResponseBodyTasks(TeaModel):
    def __init__(self, task=None):
        self.task = task  # type: list[DescribeDrdsInstanceLevelTasksResponseBodyTasksTask]

    def validate(self):
        if self.task:
            for k in self.task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceLevelTasksResponseBodyTasks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Task'] = []
        if self.task is not None:
            for k in self.task:
                result['Task'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.task = []
        if m.get('Task') is not None:
            for k in m.get('Task'):
                temp_model = DescribeDrdsInstanceLevelTasksResponseBodyTasksTask()
                self.task.append(temp_model.from_map(k))
        return self


class DescribeDrdsInstanceLevelTasksResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, tasks=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.tasks = tasks  # type: DescribeDrdsInstanceLevelTasksResponseBodyTasks

    def validate(self):
        if self.tasks:
            self.tasks.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceLevelTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tasks is not None:
            result['Tasks'] = self.tasks.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Tasks') is not None:
            temp_model = DescribeDrdsInstanceLevelTasksResponseBodyTasks()
            self.tasks = temp_model.from_map(m['Tasks'])
        return self


class DescribeDrdsInstanceLevelTasksResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsInstanceLevelTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceLevelTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsInstanceLevelTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsInstanceMonitorRequest(TeaModel):
    def __init__(self, drds_instance_id=None, end_time=None, key=None, period_multiple=None, region_id=None,
                 start_time=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.end_time = end_time  # type: long
        self.key = key  # type: str
        self.period_multiple = period_multiple  # type: int
        self.region_id = region_id  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstanceMonitorRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.key is not None:
            result['Key'] = self.key
        if self.period_multiple is not None:
            result['PeriodMultiple'] = self.period_multiple
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('PeriodMultiple') is not None:
            self.period_multiple = m.get('PeriodMultiple')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDrdsInstanceMonitorResponseBodyDataValues(TeaModel):
    def __init__(self, date=None, value=None):
        self.date = date  # type: long
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstanceMonitorResponseBodyDataValues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDrdsInstanceMonitorResponseBodyData(TeaModel):
    def __init__(self, key=None, node_num=None, unit=None, values=None):
        self.key = key  # type: str
        self.node_num = node_num  # type: int
        self.unit = unit  # type: str
        self.values = values  # type: list[DescribeDrdsInstanceMonitorResponseBodyDataValues]

    def validate(self):
        if self.values:
            for k in self.values:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceMonitorResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.node_num is not None:
            result['NodeNum'] = self.node_num
        if self.unit is not None:
            result['Unit'] = self.unit
        result['Values'] = []
        if self.values is not None:
            for k in self.values:
                result['Values'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('NodeNum') is not None:
            self.node_num = m.get('NodeNum')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        self.values = []
        if m.get('Values') is not None:
            for k in m.get('Values'):
                temp_model = DescribeDrdsInstanceMonitorResponseBodyDataValues()
                self.values.append(temp_model.from_map(k))
        return self


class DescribeDrdsInstanceMonitorResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: list[DescribeDrdsInstanceMonitorResponseBodyData]
        self.request_id = request_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceMonitorResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeDrdsInstanceMonitorResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDrdsInstanceMonitorResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsInstanceMonitorResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceMonitorResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsInstanceMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsInstanceVersionRequest(TeaModel):
    def __init__(self, drds_instance_id=None, region_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstanceVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDrdsInstanceVersionResponseBodyData(TeaModel):
    def __init__(self, instance_version=None, newest_version=None):
        self.instance_version = instance_version  # type: str
        self.newest_version = newest_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstanceVersionResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_version is not None:
            result['InstanceVersion'] = self.instance_version
        if self.newest_version is not None:
            result['NewestVersion'] = self.newest_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceVersion') is not None:
            self.instance_version = m.get('InstanceVersion')
        if m.get('NewestVersion') is not None:
            self.newest_version = m.get('NewestVersion')
        return self


class DescribeDrdsInstanceVersionResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: DescribeDrdsInstanceVersionResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDrdsInstanceVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsInstanceVersionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsInstanceVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstanceVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsInstanceVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsInstancesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstancesRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDrdsInstancesRequest(TeaModel):
    def __init__(self, description=None, expired=None, mix=None, page_number=None, page_size=None,
                 product_version=None, region_id=None, resource_group_id=None, tag=None, type=None):
        self.description = description  # type: str
        self.expired = expired  # type: bool
        self.mix = mix  # type: bool
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.product_version = product_version  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tag = tag  # type: list[DescribeDrdsInstancesRequestTag]
        self.type = type  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.mix is not None:
            result['Mix'] = self.mix
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_version is not None:
            result['ProductVersion'] = self.product_version
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('Mix') is not None:
            self.mix = m.get('Mix')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductVersion') is not None:
            self.product_version = m.get('ProductVersion')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDrdsInstancesRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDrdsInstancesResponseBodyInstancesInstanceReadOnlyDBInstanceIds(TeaModel):
    def __init__(self, read_only_dbinstance_id=None):
        self.read_only_dbinstance_id = read_only_dbinstance_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstancesResponseBodyInstancesInstanceReadOnlyDBInstanceIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.read_only_dbinstance_id is not None:
            result['ReadOnlyDBInstanceId'] = self.read_only_dbinstance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReadOnlyDBInstanceId') is not None:
            self.read_only_dbinstance_id = m.get('ReadOnlyDBInstanceId')
        return self


class DescribeDrdsInstancesResponseBodyInstancesInstanceVipsVip(TeaModel):
    def __init__(self, ip=None, port=None, type=None, vpc_id=None, vswitch_id=None):
        self.ip = ip  # type: str
        self.port = port  # type: str
        self.type = type  # type: str
        self.vpc_id = vpc_id  # type: str
        self.vswitch_id = vswitch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsInstancesResponseBodyInstancesInstanceVipsVip, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['IP'] = self.ip
        if self.port is not None:
            result['Port'] = self.port
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        return self


class DescribeDrdsInstancesResponseBodyInstancesInstanceVips(TeaModel):
    def __init__(self, vip=None):
        self.vip = vip  # type: list[DescribeDrdsInstancesResponseBodyInstancesInstanceVipsVip]

    def validate(self):
        if self.vip:
            for k in self.vip:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstancesResponseBodyInstancesInstanceVips, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Vip'] = []
        if self.vip is not None:
            for k in self.vip:
                result['Vip'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.vip = []
        if m.get('Vip') is not None:
            for k in m.get('Vip'):
                temp_model = DescribeDrdsInstancesResponseBodyInstancesInstanceVipsVip()
                self.vip.append(temp_model.from_map(k))
        return self


class DescribeDrdsInstancesResponseBodyInstancesInstance(TeaModel):
    def __init__(self, commodity_code=None, create_time=None, description=None, drds_instance_id=None,
                 expire_date=None, inst_role=None, instance_series=None, instance_spec=None, label=None, machine_type=None,
                 master_instance_id=None, network_type=None, order_instance_id=None, product_version=None,
                 read_only_dbinstance_ids=None, region_id=None, resource_group_id=None, status=None, type=None, version=None,
                 version_action=None, vips=None, vpc_cloud_instance_id=None, vpc_id=None, zone_id=None):
        self.commodity_code = commodity_code  # type: str
        self.create_time = create_time  # type: long
        self.description = description  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.expire_date = expire_date  # type: long
        self.inst_role = inst_role  # type: str
        self.instance_series = instance_series  # type: str
        self.instance_spec = instance_spec  # type: str
        self.label = label  # type: str
        self.machine_type = machine_type  # type: str
        self.master_instance_id = master_instance_id  # type: str
        self.network_type = network_type  # type: str
        self.order_instance_id = order_instance_id  # type: str
        self.product_version = product_version  # type: str
        self.read_only_dbinstance_ids = read_only_dbinstance_ids  # type: DescribeDrdsInstancesResponseBodyInstancesInstanceReadOnlyDBInstanceIds
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.status = status  # type: str
        self.type = type  # type: str
        self.version = version  # type: long
        self.version_action = version_action  # type: str
        self.vips = vips  # type: DescribeDrdsInstancesResponseBodyInstancesInstanceVips
        self.vpc_cloud_instance_id = vpc_cloud_instance_id  # type: str
        self.vpc_id = vpc_id  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.read_only_dbinstance_ids:
            self.read_only_dbinstance_ids.validate()
        if self.vips:
            self.vips.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstancesResponseBodyInstancesInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.expire_date is not None:
            result['ExpireDate'] = self.expire_date
        if self.inst_role is not None:
            result['InstRole'] = self.inst_role
        if self.instance_series is not None:
            result['InstanceSeries'] = self.instance_series
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.label is not None:
            result['Label'] = self.label
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.master_instance_id is not None:
            result['MasterInstanceId'] = self.master_instance_id
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.order_instance_id is not None:
            result['OrderInstanceId'] = self.order_instance_id
        if self.product_version is not None:
            result['ProductVersion'] = self.product_version
        if self.read_only_dbinstance_ids is not None:
            result['ReadOnlyDBInstanceIds'] = self.read_only_dbinstance_ids.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.version is not None:
            result['Version'] = self.version
        if self.version_action is not None:
            result['VersionAction'] = self.version_action
        if self.vips is not None:
            result['Vips'] = self.vips.to_map()
        if self.vpc_cloud_instance_id is not None:
            result['VpcCloudInstanceId'] = self.vpc_cloud_instance_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('ExpireDate') is not None:
            self.expire_date = m.get('ExpireDate')
        if m.get('InstRole') is not None:
            self.inst_role = m.get('InstRole')
        if m.get('InstanceSeries') is not None:
            self.instance_series = m.get('InstanceSeries')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('MasterInstanceId') is not None:
            self.master_instance_id = m.get('MasterInstanceId')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('OrderInstanceId') is not None:
            self.order_instance_id = m.get('OrderInstanceId')
        if m.get('ProductVersion') is not None:
            self.product_version = m.get('ProductVersion')
        if m.get('ReadOnlyDBInstanceIds') is not None:
            temp_model = DescribeDrdsInstancesResponseBodyInstancesInstanceReadOnlyDBInstanceIds()
            self.read_only_dbinstance_ids = temp_model.from_map(m['ReadOnlyDBInstanceIds'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VersionAction') is not None:
            self.version_action = m.get('VersionAction')
        if m.get('Vips') is not None:
            temp_model = DescribeDrdsInstancesResponseBodyInstancesInstanceVips()
            self.vips = temp_model.from_map(m['Vips'])
        if m.get('VpcCloudInstanceId') is not None:
            self.vpc_cloud_instance_id = m.get('VpcCloudInstanceId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDrdsInstancesResponseBodyInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance  # type: list[DescribeDrdsInstancesResponseBodyInstancesInstance]

    def validate(self):
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstancesResponseBodyInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instance = []
        if m.get('Instance') is not None:
            for k in m.get('Instance'):
                temp_model = DescribeDrdsInstancesResponseBodyInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        return self


class DescribeDrdsInstancesResponseBody(TeaModel):
    def __init__(self, instances=None, page_number=None, page_size=None, request_id=None, total=None):
        self.instances = instances  # type: DescribeDrdsInstancesResponseBodyInstances
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.instances:
            self.instances.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Instances') is not None:
            temp_model = DescribeDrdsInstancesResponseBodyInstances()
            self.instances = temp_model.from_map(m['Instances'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDrdsInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsParamsRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, param_level=None, region_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.param_level = param_level  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsParamsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.param_level is not None:
            result['ParamLevel'] = self.param_level
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('ParamLevel') is not None:
            self.param_level = m.get('ParamLevel')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeDrdsParamsResponseBodyList(TeaModel):
    def __init__(self, db_name=None, need_restart=None, param_default_value=None, param_desc=None,
                 param_english_name=None, param_level=None, param_name=None, param_ranges=None, param_type=None, param_value=None,
                 param_variable_name=None):
        self.db_name = db_name  # type: str
        self.need_restart = need_restart  # type: bool
        self.param_default_value = param_default_value  # type: str
        self.param_desc = param_desc  # type: str
        self.param_english_name = param_english_name  # type: str
        self.param_level = param_level  # type: str
        self.param_name = param_name  # type: str
        self.param_ranges = param_ranges  # type: str
        self.param_type = param_type  # type: str
        self.param_value = param_value  # type: str
        self.param_variable_name = param_variable_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsParamsResponseBodyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.need_restart is not None:
            result['NeedRestart'] = self.need_restart
        if self.param_default_value is not None:
            result['ParamDefaultValue'] = self.param_default_value
        if self.param_desc is not None:
            result['ParamDesc'] = self.param_desc
        if self.param_english_name is not None:
            result['ParamEnglishName'] = self.param_english_name
        if self.param_level is not None:
            result['ParamLevel'] = self.param_level
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        if self.param_ranges is not None:
            result['ParamRanges'] = self.param_ranges
        if self.param_type is not None:
            result['ParamType'] = self.param_type
        if self.param_value is not None:
            result['ParamValue'] = self.param_value
        if self.param_variable_name is not None:
            result['ParamVariableName'] = self.param_variable_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('NeedRestart') is not None:
            self.need_restart = m.get('NeedRestart')
        if m.get('ParamDefaultValue') is not None:
            self.param_default_value = m.get('ParamDefaultValue')
        if m.get('ParamDesc') is not None:
            self.param_desc = m.get('ParamDesc')
        if m.get('ParamEnglishName') is not None:
            self.param_english_name = m.get('ParamEnglishName')
        if m.get('ParamLevel') is not None:
            self.param_level = m.get('ParamLevel')
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        if m.get('ParamRanges') is not None:
            self.param_ranges = m.get('ParamRanges')
        if m.get('ParamType') is not None:
            self.param_type = m.get('ParamType')
        if m.get('ParamValue') is not None:
            self.param_value = m.get('ParamValue')
        if m.get('ParamVariableName') is not None:
            self.param_variable_name = m.get('ParamVariableName')
        return self


class DescribeDrdsParamsResponseBody(TeaModel):
    def __init__(self, list=None, request_id=None, success=None):
        self.list = list  # type: list[DescribeDrdsParamsResponseBodyList]
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsParamsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeDrdsParamsResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsParamsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsParamsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsParamsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsParamsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsRdsInstancesRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsRdsInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeDrdsRdsInstancesResponseBodyDbInstancesDbInstance(TeaModel):
    def __init__(self, connect_url=None, dbinstance_cpu=None, dbinstance_class_type=None, dbinstance_id=None,
                 dbinstance_memory=None, dbinstance_status=None, dbinstance_storage=None, db_inst_type=None, dm_instance_id=None,
                 engine=None, engine_version=None, network_type=None, pay_type=None, port=None, rds_inst_type=None,
                 read_weight=None):
        self.connect_url = connect_url  # type: str
        self.dbinstance_cpu = dbinstance_cpu  # type: str
        self.dbinstance_class_type = dbinstance_class_type  # type: str
        self.dbinstance_id = dbinstance_id  # type: str
        self.dbinstance_memory = dbinstance_memory  # type: long
        self.dbinstance_status = dbinstance_status  # type: str
        self.dbinstance_storage = dbinstance_storage  # type: long
        self.db_inst_type = db_inst_type  # type: str
        self.dm_instance_id = dm_instance_id  # type: str
        self.engine = engine  # type: str
        self.engine_version = engine_version  # type: str
        self.network_type = network_type  # type: str
        self.pay_type = pay_type  # type: str
        self.port = port  # type: int
        self.rds_inst_type = rds_inst_type  # type: str
        self.read_weight = read_weight  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsRdsInstancesResponseBodyDbInstancesDbInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connect_url is not None:
            result['ConnectUrl'] = self.connect_url
        if self.dbinstance_cpu is not None:
            result['DBInstanceCPU'] = self.dbinstance_cpu
        if self.dbinstance_class_type is not None:
            result['DBInstanceClassType'] = self.dbinstance_class_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_memory is not None:
            result['DBInstanceMemory'] = self.dbinstance_memory
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.dm_instance_id is not None:
            result['DmInstanceId'] = self.dm_instance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.port is not None:
            result['Port'] = self.port
        if self.rds_inst_type is not None:
            result['RdsInstType'] = self.rds_inst_type
        if self.read_weight is not None:
            result['ReadWeight'] = self.read_weight
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectUrl') is not None:
            self.connect_url = m.get('ConnectUrl')
        if m.get('DBInstanceCPU') is not None:
            self.dbinstance_cpu = m.get('DBInstanceCPU')
        if m.get('DBInstanceClassType') is not None:
            self.dbinstance_class_type = m.get('DBInstanceClassType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceMemory') is not None:
            self.dbinstance_memory = m.get('DBInstanceMemory')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DmInstanceId') is not None:
            self.dm_instance_id = m.get('DmInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RdsInstType') is not None:
            self.rds_inst_type = m.get('RdsInstType')
        if m.get('ReadWeight') is not None:
            self.read_weight = m.get('ReadWeight')
        return self


class DescribeDrdsRdsInstancesResponseBodyDbInstances(TeaModel):
    def __init__(self, db_instance=None):
        self.db_instance = db_instance  # type: list[DescribeDrdsRdsInstancesResponseBodyDbInstancesDbInstance]

    def validate(self):
        if self.db_instance:
            for k in self.db_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsRdsInstancesResponseBodyDbInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DbInstance'] = []
        if self.db_instance is not None:
            for k in self.db_instance:
                result['DbInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.db_instance = []
        if m.get('DbInstance') is not None:
            for k in m.get('DbInstance'):
                temp_model = DescribeDrdsRdsInstancesResponseBodyDbInstancesDbInstance()
                self.db_instance.append(temp_model.from_map(k))
        return self


class DescribeDrdsRdsInstancesResponseBody(TeaModel):
    def __init__(self, db_instances=None, request_id=None, success=None):
        self.db_instances = db_instances  # type: DescribeDrdsRdsInstancesResponseBodyDbInstances
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.db_instances:
            self.db_instances.validate()

    def to_map(self):
        _map = super(DescribeDrdsRdsInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instances is not None:
            result['DbInstances'] = self.db_instances.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstances') is not None:
            temp_model = DescribeDrdsRdsInstancesResponseBodyDbInstances()
            self.db_instances = temp_model.from_map(m['DbInstances'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsRdsInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsRdsInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsRdsInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsRdsInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsShardingDbsRequest(TeaModel):
    def __init__(self, db_name=None, db_name_pattern=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.db_name_pattern = db_name_pattern  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsShardingDbsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.db_name_pattern is not None:
            result['DbNamePattern'] = self.db_name_pattern
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DbNamePattern') is not None:
            self.db_name_pattern = m.get('DbNamePattern')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeDrdsShardingDbsResponseBodyShardingDbsShardingDb(TeaModel):
    def __init__(self, blocking_timeout=None, connect_url=None, connection_properties=None, db_instance_id=None,
                 db_status=None, db_type=None, group_name=None, idle_time_out=None, max_pool_size=None, min_pool_size=None,
                 prepared_statement_cache_size=None, sharding_db_name=None, user_name=None):
        self.blocking_timeout = blocking_timeout  # type: int
        self.connect_url = connect_url  # type: str
        self.connection_properties = connection_properties  # type: str
        self.db_instance_id = db_instance_id  # type: str
        self.db_status = db_status  # type: str
        self.db_type = db_type  # type: str
        self.group_name = group_name  # type: str
        self.idle_time_out = idle_time_out  # type: int
        self.max_pool_size = max_pool_size  # type: int
        self.min_pool_size = min_pool_size  # type: int
        self.prepared_statement_cache_size = prepared_statement_cache_size  # type: int
        self.sharding_db_name = sharding_db_name  # type: str
        self.user_name = user_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsShardingDbsResponseBodyShardingDbsShardingDb, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.blocking_timeout is not None:
            result['BlockingTimeout'] = self.blocking_timeout
        if self.connect_url is not None:
            result['ConnectUrl'] = self.connect_url
        if self.connection_properties is not None:
            result['ConnectionProperties'] = self.connection_properties
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.db_status is not None:
            result['DbStatus'] = self.db_status
        if self.db_type is not None:
            result['DbType'] = self.db_type
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.idle_time_out is not None:
            result['IdleTimeOut'] = self.idle_time_out
        if self.max_pool_size is not None:
            result['MaxPoolSize'] = self.max_pool_size
        if self.min_pool_size is not None:
            result['MinPoolSize'] = self.min_pool_size
        if self.prepared_statement_cache_size is not None:
            result['PreparedStatementCacheSize'] = self.prepared_statement_cache_size
        if self.sharding_db_name is not None:
            result['ShardingDbName'] = self.sharding_db_name
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BlockingTimeout') is not None:
            self.blocking_timeout = m.get('BlockingTimeout')
        if m.get('ConnectUrl') is not None:
            self.connect_url = m.get('ConnectUrl')
        if m.get('ConnectionProperties') is not None:
            self.connection_properties = m.get('ConnectionProperties')
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('DbStatus') is not None:
            self.db_status = m.get('DbStatus')
        if m.get('DbType') is not None:
            self.db_type = m.get('DbType')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IdleTimeOut') is not None:
            self.idle_time_out = m.get('IdleTimeOut')
        if m.get('MaxPoolSize') is not None:
            self.max_pool_size = m.get('MaxPoolSize')
        if m.get('MinPoolSize') is not None:
            self.min_pool_size = m.get('MinPoolSize')
        if m.get('PreparedStatementCacheSize') is not None:
            self.prepared_statement_cache_size = m.get('PreparedStatementCacheSize')
        if m.get('ShardingDbName') is not None:
            self.sharding_db_name = m.get('ShardingDbName')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeDrdsShardingDbsResponseBodyShardingDbs(TeaModel):
    def __init__(self, sharding_db=None):
        self.sharding_db = sharding_db  # type: list[DescribeDrdsShardingDbsResponseBodyShardingDbsShardingDb]

    def validate(self):
        if self.sharding_db:
            for k in self.sharding_db:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsShardingDbsResponseBodyShardingDbs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ShardingDb'] = []
        if self.sharding_db is not None:
            for k in self.sharding_db:
                result['ShardingDb'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sharding_db = []
        if m.get('ShardingDb') is not None:
            for k in m.get('ShardingDb'):
                temp_model = DescribeDrdsShardingDbsResponseBodyShardingDbsShardingDb()
                self.sharding_db.append(temp_model.from_map(k))
        return self


class DescribeDrdsShardingDbsResponseBody(TeaModel):
    def __init__(self, request_id=None, sharding_dbs=None, success=None):
        self.request_id = request_id  # type: str
        self.sharding_dbs = sharding_dbs  # type: DescribeDrdsShardingDbsResponseBodyShardingDbs
        self.success = success  # type: bool

    def validate(self):
        if self.sharding_dbs:
            self.sharding_dbs.validate()

    def to_map(self):
        _map = super(DescribeDrdsShardingDbsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sharding_dbs is not None:
            result['ShardingDbs'] = self.sharding_dbs.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ShardingDbs') is not None:
            temp_model = DescribeDrdsShardingDbsResponseBodyShardingDbs()
            self.sharding_dbs = temp_model.from_map(m['ShardingDbs'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsShardingDbsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsShardingDbsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsShardingDbsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsShardingDbsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsSlowSqlsRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, end_time=None, exe_time=None, page_number=None,
                 page_size=None, start_time=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.end_time = end_time  # type: long
        self.exe_time = exe_time  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsSlowSqlsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.exe_time is not None:
            result['ExeTime'] = self.exe_time
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExeTime') is not None:
            self.exe_time = m.get('ExeTime')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeDrdsSlowSqlsResponseBodyItemsItem(TeaModel):
    def __init__(self, host=None, response_time=None, schema=None, send_time=None, sql=None):
        self.host = host  # type: str
        self.response_time = response_time  # type: long
        self.schema = schema  # type: str
        self.send_time = send_time  # type: long
        self.sql = sql  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsSlowSqlsResponseBodyItemsItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        if self.response_time is not None:
            result['ResponseTime'] = self.response_time
        if self.schema is not None:
            result['Schema'] = self.schema
        if self.send_time is not None:
            result['SendTime'] = self.send_time
        if self.sql is not None:
            result['Sql'] = self.sql
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('ResponseTime') is not None:
            self.response_time = m.get('ResponseTime')
        if m.get('Schema') is not None:
            self.schema = m.get('Schema')
        if m.get('SendTime') is not None:
            self.send_time = m.get('SendTime')
        if m.get('Sql') is not None:
            self.sql = m.get('Sql')
        return self


class DescribeDrdsSlowSqlsResponseBodyItems(TeaModel):
    def __init__(self, item=None):
        self.item = item  # type: list[DescribeDrdsSlowSqlsResponseBodyItemsItem]

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsSlowSqlsResponseBodyItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = DescribeDrdsSlowSqlsResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class DescribeDrdsSlowSqlsResponseBody(TeaModel):
    def __init__(self, items=None, page_number=None, page_size=None, request_id=None, success=None, total=None):
        self.items = items  # type: DescribeDrdsSlowSqlsResponseBodyItems
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super(DescribeDrdsSlowSqlsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Items') is not None:
            temp_model = DescribeDrdsSlowSqlsResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeDrdsSlowSqlsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsSlowSqlsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsSlowSqlsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsSlowSqlsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsSqlAuditStatusRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsSqlAuditStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeDrdsSqlAuditStatusResponseBodyDataData(TeaModel):
    def __init__(self, db_name=None, detailed=None, enabled=None, extra_ali_uid=None, extra_sls_log_store=None,
                 extra_sls_project=None, extra_write_enabled=None):
        self.db_name = db_name  # type: str
        self.detailed = detailed  # type: str
        self.enabled = enabled  # type: str
        self.extra_ali_uid = extra_ali_uid  # type: long
        self.extra_sls_log_store = extra_sls_log_store  # type: str
        self.extra_sls_project = extra_sls_project  # type: str
        self.extra_write_enabled = extra_write_enabled  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsSqlAuditStatusResponseBodyDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.detailed is not None:
            result['Detailed'] = self.detailed
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.extra_ali_uid is not None:
            result['ExtraAliUid'] = self.extra_ali_uid
        if self.extra_sls_log_store is not None:
            result['ExtraSlsLogStore'] = self.extra_sls_log_store
        if self.extra_sls_project is not None:
            result['ExtraSlsProject'] = self.extra_sls_project
        if self.extra_write_enabled is not None:
            result['ExtraWriteEnabled'] = self.extra_write_enabled
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('Detailed') is not None:
            self.detailed = m.get('Detailed')
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('ExtraAliUid') is not None:
            self.extra_ali_uid = m.get('ExtraAliUid')
        if m.get('ExtraSlsLogStore') is not None:
            self.extra_sls_log_store = m.get('ExtraSlsLogStore')
        if m.get('ExtraSlsProject') is not None:
            self.extra_sls_project = m.get('ExtraSlsProject')
        if m.get('ExtraWriteEnabled') is not None:
            self.extra_write_enabled = m.get('ExtraWriteEnabled')
        return self


class DescribeDrdsSqlAuditStatusResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[DescribeDrdsSqlAuditStatusResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsSqlAuditStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeDrdsSqlAuditStatusResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class DescribeDrdsSqlAuditStatusResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: DescribeDrdsSqlAuditStatusResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeDrdsSqlAuditStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeDrdsSqlAuditStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeDrdsSqlAuditStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsSqlAuditStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsSqlAuditStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsSqlAuditStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDrdsTasksRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, task_type=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeDrdsTasksResponseBodyTasksTask(TeaModel):
    def __init__(self, content=None, id=None, state=None):
        self.content = content  # type: str
        self.id = id  # type: long
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDrdsTasksResponseBodyTasksTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.id is not None:
            result['Id'] = self.id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeDrdsTasksResponseBodyTasks(TeaModel):
    def __init__(self, task=None):
        self.task = task  # type: list[DescribeDrdsTasksResponseBodyTasksTask]

    def validate(self):
        if self.task:
            for k in self.task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDrdsTasksResponseBodyTasks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Task'] = []
        if self.task is not None:
            for k in self.task:
                result['Task'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.task = []
        if m.get('Task') is not None:
            for k in m.get('Task'):
                temp_model = DescribeDrdsTasksResponseBodyTasksTask()
                self.task.append(temp_model.from_map(k))
        return self


class DescribeDrdsTasksResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, tasks=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.tasks = tasks  # type: DescribeDrdsTasksResponseBodyTasks

    def validate(self):
        if self.tasks:
            self.tasks.validate()

    def to_map(self):
        _map = super(DescribeDrdsTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tasks is not None:
            result['Tasks'] = self.tasks.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Tasks') is not None:
            temp_model = DescribeDrdsTasksResponseBodyTasks()
            self.tasks = temp_model.from_map(m['Tasks'])
        return self


class DescribeDrdsTasksResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeDrdsTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDrdsTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDrdsTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEvaluateDataImportDbTopologysRequest(TeaModel):
    def __init__(self, import_param=None):
        self.import_param = import_param  # type: dict[str, any]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEvaluateDataImportDbTopologysRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param is not None:
            result['ImportParam'] = self.import_param
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param = m.get('ImportParam')
        return self


class DescribeEvaluateDataImportDbTopologysShrinkRequest(TeaModel):
    def __init__(self, import_param_shrink=None):
        self.import_param_shrink = import_param_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEvaluateDataImportDbTopologysShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.import_param_shrink is not None:
            result['ImportParam'] = self.import_param_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImportParam') is not None:
            self.import_param_shrink = m.get('ImportParam')
        return self


class DescribeEvaluateDataImportDbTopologysResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEvaluateDataImportDbTopologysResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeEvaluateDataImportDbTopologysResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeEvaluateDataImportDbTopologysResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEvaluateDataImportDbTopologysResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEvaluateDataImportDbTopologysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEvaluatePreCheckResultRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEvaluatePreCheckResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams(TeaModel):
    def __init__(self, error_msg_params=None):
        self.error_msg_params = error_msg_params  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg_params is not None:
            result['ErrorMsgParams'] = self.error_msg_params
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMsgParams') is not None:
            self.error_msg_params = m.get('ErrorMsgParams')
        return self


class DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems(TeaModel):
    def __init__(self, error_msg_code=None, error_msg_params=None, pre_check_item_name=None, state=None):
        self.error_msg_code = error_msg_code  # type: str
        self.error_msg_params = error_msg_params  # type: DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams
        self.pre_check_item_name = pre_check_item_name  # type: str
        self.state = state  # type: str

    def validate(self):
        if self.error_msg_params:
            self.error_msg_params.validate()

    def to_map(self):
        _map = super(DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg_code is not None:
            result['ErrorMsgCode'] = self.error_msg_code
        if self.error_msg_params is not None:
            result['ErrorMsgParams'] = self.error_msg_params.to_map()
        if self.pre_check_item_name is not None:
            result['PreCheckItemName'] = self.pre_check_item_name
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMsgCode') is not None:
            self.error_msg_code = m.get('ErrorMsgCode')
        if m.get('ErrorMsgParams') is not None:
            temp_model = DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItemsErrorMsgParams()
            self.error_msg_params = temp_model.from_map(m['ErrorMsgParams'])
        if m.get('PreCheckItemName') is not None:
            self.pre_check_item_name = m.get('PreCheckItemName')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItems(TeaModel):
    def __init__(self, sub_check_items=None):
        self.sub_check_items = sub_check_items  # type: list[DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems]

    def validate(self):
        if self.sub_check_items:
            for k in self.sub_check_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SubCheckItems'] = []
        if self.sub_check_items is not None:
            for k in self.sub_check_items:
                result['SubCheckItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sub_check_items = []
        if m.get('SubCheckItems') is not None:
            for k in m.get('SubCheckItems'):
                temp_model = DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItemsSubCheckItems()
                self.sub_check_items.append(temp_model.from_map(k))
        return self


class DescribeEvaluatePreCheckResultResponseBodyPreCheckResult(TeaModel):
    def __init__(self, pre_check_name=None, state=None, sub_check_items=None):
        self.pre_check_name = pre_check_name  # type: str
        self.state = state  # type: str
        self.sub_check_items = sub_check_items  # type: DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItems

    def validate(self):
        if self.sub_check_items:
            self.sub_check_items.validate()

    def to_map(self):
        _map = super(DescribeEvaluatePreCheckResultResponseBodyPreCheckResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_check_name is not None:
            result['PreCheckName'] = self.pre_check_name
        if self.state is not None:
            result['State'] = self.state
        if self.sub_check_items is not None:
            result['SubCheckItems'] = self.sub_check_items.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PreCheckName') is not None:
            self.pre_check_name = m.get('PreCheckName')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('SubCheckItems') is not None:
            temp_model = DescribeEvaluatePreCheckResultResponseBodyPreCheckResultSubCheckItems()
            self.sub_check_items = temp_model.from_map(m['SubCheckItems'])
        return self


class DescribeEvaluatePreCheckResultResponseBody(TeaModel):
    def __init__(self, pre_check_result=None, request_id=None, success=None):
        self.pre_check_result = pre_check_result  # type: DescribeEvaluatePreCheckResultResponseBodyPreCheckResult
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.pre_check_result:
            self.pre_check_result.validate()

    def to_map(self):
        _map = super(DescribeEvaluatePreCheckResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_check_result is not None:
            result['PreCheckResult'] = self.pre_check_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PreCheckResult') is not None:
            temp_model = DescribeEvaluatePreCheckResultResponseBodyPreCheckResult()
            self.pre_check_result = temp_model.from_map(m['PreCheckResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeEvaluatePreCheckResultResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeEvaluatePreCheckResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEvaluatePreCheckResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEvaluatePreCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEvaluateTaskReportRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEvaluateTaskReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeEvaluateTaskReportResponseBodyEvaluateResultRdsInstInfosRdsInstInfos(TeaModel):
    def __init__(self, avg_qps_growth_scale=None, data_growth_scale=None, inst_id=None, rds_peak_iops_weekly=None,
                 rds_peak_qps_weekly=None, rds_peak_sessions_weekly=None, rds_used_space=None):
        self.avg_qps_growth_scale = avg_qps_growth_scale  # type: int
        self.data_growth_scale = data_growth_scale  # type: int
        self.inst_id = inst_id  # type: str
        self.rds_peak_iops_weekly = rds_peak_iops_weekly  # type: int
        self.rds_peak_qps_weekly = rds_peak_qps_weekly  # type: int
        self.rds_peak_sessions_weekly = rds_peak_sessions_weekly  # type: int
        self.rds_used_space = rds_used_space  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEvaluateTaskReportResponseBodyEvaluateResultRdsInstInfosRdsInstInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_qps_growth_scale is not None:
            result['AvgQpsGrowthScale'] = self.avg_qps_growth_scale
        if self.data_growth_scale is not None:
            result['DataGrowthScale'] = self.data_growth_scale
        if self.inst_id is not None:
            result['InstId'] = self.inst_id
        if self.rds_peak_iops_weekly is not None:
            result['RdsPeakIopsWeekly'] = self.rds_peak_iops_weekly
        if self.rds_peak_qps_weekly is not None:
            result['RdsPeakQpsWeekly'] = self.rds_peak_qps_weekly
        if self.rds_peak_sessions_weekly is not None:
            result['RdsPeakSessionsWeekly'] = self.rds_peak_sessions_weekly
        if self.rds_used_space is not None:
            result['RdsUsedSpace'] = self.rds_used_space
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgQpsGrowthScale') is not None:
            self.avg_qps_growth_scale = m.get('AvgQpsGrowthScale')
        if m.get('DataGrowthScale') is not None:
            self.data_growth_scale = m.get('DataGrowthScale')
        if m.get('InstId') is not None:
            self.inst_id = m.get('InstId')
        if m.get('RdsPeakIopsWeekly') is not None:
            self.rds_peak_iops_weekly = m.get('RdsPeakIopsWeekly')
        if m.get('RdsPeakQpsWeekly') is not None:
            self.rds_peak_qps_weekly = m.get('RdsPeakQpsWeekly')
        if m.get('RdsPeakSessionsWeekly') is not None:
            self.rds_peak_sessions_weekly = m.get('RdsPeakSessionsWeekly')
        if m.get('RdsUsedSpace') is not None:
            self.rds_used_space = m.get('RdsUsedSpace')
        return self


class DescribeEvaluateTaskReportResponseBodyEvaluateResultRdsInstInfos(TeaModel):
    def __init__(self, rds_inst_infos=None):
        self.rds_inst_infos = rds_inst_infos  # type: list[DescribeEvaluateTaskReportResponseBodyEvaluateResultRdsInstInfosRdsInstInfos]

    def validate(self):
        if self.rds_inst_infos:
            for k in self.rds_inst_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEvaluateTaskReportResponseBodyEvaluateResultRdsInstInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RdsInstInfos'] = []
        if self.rds_inst_infos is not None:
            for k in self.rds_inst_infos:
                result['RdsInstInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rds_inst_infos = []
        if m.get('RdsInstInfos') is not None:
            for k in m.get('RdsInstInfos'):
                temp_model = DescribeEvaluateTaskReportResponseBodyEvaluateResultRdsInstInfosRdsInstInfos()
                self.rds_inst_infos.append(temp_model.from_map(k))
        return self


class DescribeEvaluateTaskReportResponseBodyEvaluateResultTableShardResultsTableShardResults(TeaModel):
    def __init__(self, create_table_sql=None, db_shard_key=None, db_shard_method=None, dbpartitions=None,
                 origin_db_shard_method=None, origin_tb_shard_method=None, row_count=None, shard_key_type=None, shard_type=None,
                 sql_count=None, table=None, tb_shard_key=None, tb_shard_method=None, tbpartitions=None):
        self.create_table_sql = create_table_sql  # type: str
        self.db_shard_key = db_shard_key  # type: str
        self.db_shard_method = db_shard_method  # type: str
        self.dbpartitions = dbpartitions  # type: int
        self.origin_db_shard_method = origin_db_shard_method  # type: str
        self.origin_tb_shard_method = origin_tb_shard_method  # type: str
        self.row_count = row_count  # type: int
        self.shard_key_type = shard_key_type  # type: str
        self.shard_type = shard_type  # type: str
        self.sql_count = sql_count  # type: int
        self.table = table  # type: str
        self.tb_shard_key = tb_shard_key  # type: str
        self.tb_shard_method = tb_shard_method  # type: str
        self.tbpartitions = tbpartitions  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEvaluateTaskReportResponseBodyEvaluateResultTableShardResultsTableShardResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_table_sql is not None:
            result['CreateTableSql'] = self.create_table_sql
        if self.db_shard_key is not None:
            result['DbShardKey'] = self.db_shard_key
        if self.db_shard_method is not None:
            result['DbShardMethod'] = self.db_shard_method
        if self.dbpartitions is not None:
            result['Dbpartitions'] = self.dbpartitions
        if self.origin_db_shard_method is not None:
            result['OriginDbShardMethod'] = self.origin_db_shard_method
        if self.origin_tb_shard_method is not None:
            result['OriginTbShardMethod'] = self.origin_tb_shard_method
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        if self.shard_key_type is not None:
            result['ShardKeyType'] = self.shard_key_type
        if self.shard_type is not None:
            result['ShardType'] = self.shard_type
        if self.sql_count is not None:
            result['SqlCount'] = self.sql_count
        if self.table is not None:
            result['Table'] = self.table
        if self.tb_shard_key is not None:
            result['TbShardKey'] = self.tb_shard_key
        if self.tb_shard_method is not None:
            result['TbShardMethod'] = self.tb_shard_method
        if self.tbpartitions is not None:
            result['Tbpartitions'] = self.tbpartitions
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTableSql') is not None:
            self.create_table_sql = m.get('CreateTableSql')
        if m.get('DbShardKey') is not None:
            self.db_shard_key = m.get('DbShardKey')
        if m.get('DbShardMethod') is not None:
            self.db_shard_method = m.get('DbShardMethod')
        if m.get('Dbpartitions') is not None:
            self.dbpartitions = m.get('Dbpartitions')
        if m.get('OriginDbShardMethod') is not None:
            self.origin_db_shard_method = m.get('OriginDbShardMethod')
        if m.get('OriginTbShardMethod') is not None:
            self.origin_tb_shard_method = m.get('OriginTbShardMethod')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        if m.get('ShardKeyType') is not None:
            self.shard_key_type = m.get('ShardKeyType')
        if m.get('ShardType') is not None:
            self.shard_type = m.get('ShardType')
        if m.get('SqlCount') is not None:
            self.sql_count = m.get('SqlCount')
        if m.get('Table') is not None:
            self.table = m.get('Table')
        if m.get('TbShardKey') is not None:
            self.tb_shard_key = m.get('TbShardKey')
        if m.get('TbShardMethod') is not None:
            self.tb_shard_method = m.get('TbShardMethod')
        if m.get('Tbpartitions') is not None:
            self.tbpartitions = m.get('Tbpartitions')
        return self


class DescribeEvaluateTaskReportResponseBodyEvaluateResultTableShardResults(TeaModel):
    def __init__(self, table_shard_results=None):
        self.table_shard_results = table_shard_results  # type: list[DescribeEvaluateTaskReportResponseBodyEvaluateResultTableShardResultsTableShardResults]

    def validate(self):
        if self.table_shard_results:
            for k in self.table_shard_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEvaluateTaskReportResponseBodyEvaluateResultTableShardResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TableShardResults'] = []
        if self.table_shard_results is not None:
            for k in self.table_shard_results:
                result['TableShardResults'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.table_shard_results = []
        if m.get('TableShardResults') is not None:
            for k in m.get('TableShardResults'):
                temp_model = DescribeEvaluateTaskReportResponseBodyEvaluateResultTableShardResultsTableShardResults()
                self.table_shard_results.append(temp_model.from_map(k))
        return self


class DescribeEvaluateTaskReportResponseBodyEvaluateResult(TeaModel):
    def __init__(self, all_sql_count=None, db_name=None, drds_count=None, drds_type=None, gmt_create=None,
                 gmt_modified=None, inst_id=None, rds_count=None, rds_inst_infos=None, rds_total_space=None, rds_type=None,
                 slow_sql_count=None, table_shard_results=None, task_id=None, task_name=None, task_status=None):
        self.all_sql_count = all_sql_count  # type: int
        self.db_name = db_name  # type: str
        self.drds_count = drds_count  # type: int
        self.drds_type = drds_type  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.inst_id = inst_id  # type: int
        self.rds_count = rds_count  # type: int
        self.rds_inst_infos = rds_inst_infos  # type: DescribeEvaluateTaskReportResponseBodyEvaluateResultRdsInstInfos
        self.rds_total_space = rds_total_space  # type: str
        self.rds_type = rds_type  # type: str
        self.slow_sql_count = slow_sql_count  # type: int
        self.table_shard_results = table_shard_results  # type: DescribeEvaluateTaskReportResponseBodyEvaluateResultTableShardResults
        self.task_id = task_id  # type: int
        self.task_name = task_name  # type: str
        self.task_status = task_status  # type: str

    def validate(self):
        if self.rds_inst_infos:
            self.rds_inst_infos.validate()
        if self.table_shard_results:
            self.table_shard_results.validate()

    def to_map(self):
        _map = super(DescribeEvaluateTaskReportResponseBodyEvaluateResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_sql_count is not None:
            result['AllSqlCount'] = self.all_sql_count
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_count is not None:
            result['DrdsCount'] = self.drds_count
        if self.drds_type is not None:
            result['DrdsType'] = self.drds_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.inst_id is not None:
            result['InstId'] = self.inst_id
        if self.rds_count is not None:
            result['RdsCount'] = self.rds_count
        if self.rds_inst_infos is not None:
            result['RdsInstInfos'] = self.rds_inst_infos.to_map()
        if self.rds_total_space is not None:
            result['RdsTotalSpace'] = self.rds_total_space
        if self.rds_type is not None:
            result['RdsType'] = self.rds_type
        if self.slow_sql_count is not None:
            result['SlowSqlCount'] = self.slow_sql_count
        if self.table_shard_results is not None:
            result['TableShardResults'] = self.table_shard_results.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllSqlCount') is not None:
            self.all_sql_count = m.get('AllSqlCount')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsCount') is not None:
            self.drds_count = m.get('DrdsCount')
        if m.get('DrdsType') is not None:
            self.drds_type = m.get('DrdsType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('InstId') is not None:
            self.inst_id = m.get('InstId')
        if m.get('RdsCount') is not None:
            self.rds_count = m.get('RdsCount')
        if m.get('RdsInstInfos') is not None:
            temp_model = DescribeEvaluateTaskReportResponseBodyEvaluateResultRdsInstInfos()
            self.rds_inst_infos = temp_model.from_map(m['RdsInstInfos'])
        if m.get('RdsTotalSpace') is not None:
            self.rds_total_space = m.get('RdsTotalSpace')
        if m.get('RdsType') is not None:
            self.rds_type = m.get('RdsType')
        if m.get('SlowSqlCount') is not None:
            self.slow_sql_count = m.get('SlowSqlCount')
        if m.get('TableShardResults') is not None:
            temp_model = DescribeEvaluateTaskReportResponseBodyEvaluateResultTableShardResults()
            self.table_shard_results = temp_model.from_map(m['TableShardResults'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class DescribeEvaluateTaskReportResponseBody(TeaModel):
    def __init__(self, evaluate_result=None, request_id=None, success=None):
        self.evaluate_result = evaluate_result  # type: DescribeEvaluateTaskReportResponseBodyEvaluateResult
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.evaluate_result:
            self.evaluate_result.validate()

    def to_map(self):
        _map = super(DescribeEvaluateTaskReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.evaluate_result is not None:
            result['EvaluateResult'] = self.evaluate_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EvaluateResult') is not None:
            temp_model = DescribeEvaluateTaskReportResponseBodyEvaluateResult()
            self.evaluate_result = temp_model.from_map(m['EvaluateResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeEvaluateTaskReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeEvaluateTaskReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEvaluateTaskReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEvaluateTaskReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEvaluateTasksRequest(TeaModel):
    def __init__(self, page_number=None, page_size=None):
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEvaluateTasksRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeEvaluateTasksResponseBodyDataEvaluateTask(TeaModel):
    def __init__(self, all_sql_count=None, batch_evaluate_task_id=None, db_name=None, db_type=None,
                 evalaute_hours=None, gmt_create=None, gmt_modified=None, id=None, inst_id=None, progress=None, status=None,
                 task_name=None):
        self.all_sql_count = all_sql_count  # type: int
        self.batch_evaluate_task_id = batch_evaluate_task_id  # type: int
        self.db_name = db_name  # type: str
        self.db_type = db_type  # type: int
        self.evalaute_hours = evalaute_hours  # type: int
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.id = id  # type: int
        self.inst_id = inst_id  # type: str
        self.progress = progress  # type: int
        self.status = status  # type: str
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeEvaluateTasksResponseBodyDataEvaluateTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_sql_count is not None:
            result['AllSqlCount'] = self.all_sql_count
        if self.batch_evaluate_task_id is not None:
            result['BatchEvaluateTaskId'] = self.batch_evaluate_task_id
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.db_type is not None:
            result['DbType'] = self.db_type
        if self.evalaute_hours is not None:
            result['EvalauteHours'] = self.evalaute_hours
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.inst_id is not None:
            result['InstId'] = self.inst_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.status is not None:
            result['Status'] = self.status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllSqlCount') is not None:
            self.all_sql_count = m.get('AllSqlCount')
        if m.get('BatchEvaluateTaskId') is not None:
            self.batch_evaluate_task_id = m.get('BatchEvaluateTaskId')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DbType') is not None:
            self.db_type = m.get('DbType')
        if m.get('EvalauteHours') is not None:
            self.evalaute_hours = m.get('EvalauteHours')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstId') is not None:
            self.inst_id = m.get('InstId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class DescribeEvaluateTasksResponseBodyData(TeaModel):
    def __init__(self, evaluate_task=None):
        self.evaluate_task = evaluate_task  # type: list[DescribeEvaluateTasksResponseBodyDataEvaluateTask]

    def validate(self):
        if self.evaluate_task:
            for k in self.evaluate_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeEvaluateTasksResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EvaluateTask'] = []
        if self.evaluate_task is not None:
            for k in self.evaluate_task:
                result['EvaluateTask'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.evaluate_task = []
        if m.get('EvaluateTask') is not None:
            for k in m.get('EvaluateTask'):
                temp_model = DescribeEvaluateTasksResponseBodyDataEvaluateTask()
                self.evaluate_task.append(temp_model.from_map(k))
        return self


class DescribeEvaluateTasksResponseBody(TeaModel):
    def __init__(self, data=None, page_number=None, page_size=None, request_id=None, success=None, total=None):
        self.data = data  # type: DescribeEvaluateTasksResponseBodyData
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeEvaluateTasksResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeEvaluateTasksResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeEvaluateTasksResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeEvaluateTasksResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeEvaluateTasksResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEvaluateTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExpandLogicTableInfoListRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExpandLogicTableInfoListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeExpandLogicTableInfoListResponseBodyDataData(TeaModel):
    def __init__(self, shard_db_key=None, shard_tb_key=None, table_name=None):
        self.shard_db_key = shard_db_key  # type: str
        self.shard_tb_key = shard_tb_key  # type: str
        self.table_name = table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeExpandLogicTableInfoListResponseBodyDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.shard_db_key is not None:
            result['ShardDbKey'] = self.shard_db_key
        if self.shard_tb_key is not None:
            result['ShardTbKey'] = self.shard_tb_key
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ShardDbKey') is not None:
            self.shard_db_key = m.get('ShardDbKey')
        if m.get('ShardTbKey') is not None:
            self.shard_tb_key = m.get('ShardTbKey')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class DescribeExpandLogicTableInfoListResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[DescribeExpandLogicTableInfoListResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeExpandLogicTableInfoListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = DescribeExpandLogicTableInfoListResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class DescribeExpandLogicTableInfoListResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: DescribeExpandLogicTableInfoListResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeExpandLogicTableInfoListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeExpandLogicTableInfoListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeExpandLogicTableInfoListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeExpandLogicTableInfoListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeExpandLogicTableInfoListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExpandLogicTableInfoListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHiStoreInstanceInfoRequest(TeaModel):
    def __init__(self, drds_instance_id=None, histore_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.histore_instance_id = histore_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHiStoreInstanceInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.histore_instance_id is not None:
            result['HistoreInstanceId'] = self.histore_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('HistoreInstanceId') is not None:
            self.histore_instance_id = m.get('HistoreInstanceId')
        return self


class DescribeHiStoreInstanceInfoResponseBodyHiStoreInstanceInfo(TeaModel):
    def __init__(self, disk_size=None, gmt_create=None, histore_instance_id=None, machine_spec=None,
                 rpm_version=None):
        self.disk_size = disk_size  # type: int
        self.gmt_create = gmt_create  # type: long
        self.histore_instance_id = histore_instance_id  # type: str
        self.machine_spec = machine_spec  # type: str
        self.rpm_version = rpm_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHiStoreInstanceInfoResponseBodyHiStoreInstanceInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.histore_instance_id is not None:
            result['HistoreInstanceId'] = self.histore_instance_id
        if self.machine_spec is not None:
            result['MachineSpec'] = self.machine_spec
        if self.rpm_version is not None:
            result['RpmVersion'] = self.rpm_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiskSize') is not None:
            self.disk_size = m.get('DiskSize')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('HistoreInstanceId') is not None:
            self.histore_instance_id = m.get('HistoreInstanceId')
        if m.get('MachineSpec') is not None:
            self.machine_spec = m.get('MachineSpec')
        if m.get('RpmVersion') is not None:
            self.rpm_version = m.get('RpmVersion')
        return self


class DescribeHiStoreInstanceInfoResponseBody(TeaModel):
    def __init__(self, hi_store_instance_info=None, request_id=None, success=None):
        self.hi_store_instance_info = hi_store_instance_info  # type: DescribeHiStoreInstanceInfoResponseBodyHiStoreInstanceInfo
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.hi_store_instance_info:
            self.hi_store_instance_info.validate()

    def to_map(self):
        _map = super(DescribeHiStoreInstanceInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hi_store_instance_info is not None:
            result['HiStoreInstanceInfo'] = self.hi_store_instance_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HiStoreInstanceInfo') is not None:
            temp_model = DescribeHiStoreInstanceInfoResponseBodyHiStoreInstanceInfo()
            self.hi_store_instance_info = temp_model.from_map(m['HiStoreInstanceInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeHiStoreInstanceInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeHiStoreInstanceInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHiStoreInstanceInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHiStoreInstanceInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHotDbListRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHotDbListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeHotDbListResponseBodyDataListInstanceDbHotDbList(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeHotDbListResponseBodyDataListInstanceDbHotDbList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class DescribeHotDbListResponseBodyDataListInstanceDb(TeaModel):
    def __init__(self, hot_db_list=None, instance_name=None):
        self.hot_db_list = hot_db_list  # type: DescribeHotDbListResponseBodyDataListInstanceDbHotDbList
        self.instance_name = instance_name  # type: str

    def validate(self):
        if self.hot_db_list:
            self.hot_db_list.validate()

    def to_map(self):
        _map = super(DescribeHotDbListResponseBodyDataListInstanceDb, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hot_db_list is not None:
            result['HotDbList'] = self.hot_db_list.to_map()
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HotDbList') is not None:
            temp_model = DescribeHotDbListResponseBodyDataListInstanceDbHotDbList()
            self.hot_db_list = temp_model.from_map(m['HotDbList'])
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        return self


class DescribeHotDbListResponseBodyDataList(TeaModel):
    def __init__(self, instance_db=None):
        self.instance_db = instance_db  # type: list[DescribeHotDbListResponseBodyDataListInstanceDb]

    def validate(self):
        if self.instance_db:
            for k in self.instance_db:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeHotDbListResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceDb'] = []
        if self.instance_db is not None:
            for k in self.instance_db:
                result['InstanceDb'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instance_db = []
        if m.get('InstanceDb') is not None:
            for k in m.get('InstanceDb'):
                temp_model = DescribeHotDbListResponseBodyDataListInstanceDb()
                self.instance_db.append(temp_model.from_map(k))
        return self


class DescribeHotDbListResponseBodyData(TeaModel):
    def __init__(self, list=None, random_code=None):
        self.list = list  # type: DescribeHotDbListResponseBodyDataList
        self.random_code = random_code  # type: str

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super(DescribeHotDbListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.random_code is not None:
            result['RandomCode'] = self.random_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = DescribeHotDbListResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        if m.get('RandomCode') is not None:
            self.random_code = m.get('RandomCode')
        return self


class DescribeHotDbListResponseBody(TeaModel):
    def __init__(self, data=None, msg=None, request_id=None, success=None):
        self.data = data  # type: DescribeHotDbListResponseBodyData
        self.msg = msg  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeHotDbListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeHotDbListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeHotDbListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeHotDbListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeHotDbListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHotDbListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstDbLogInfoRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstDbLogInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeInstDbLogInfoResponseBodyLogTimeRange(TeaModel):
    def __init__(self, support_latest_time=None, support_oldest_time=None):
        self.support_latest_time = support_latest_time  # type: long
        self.support_oldest_time = support_oldest_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstDbLogInfoResponseBodyLogTimeRange, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.support_latest_time is not None:
            result['SupportLatestTime'] = self.support_latest_time
        if self.support_oldest_time is not None:
            result['SupportOldestTime'] = self.support_oldest_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SupportLatestTime') is not None:
            self.support_latest_time = m.get('SupportLatestTime')
        if m.get('SupportOldestTime') is not None:
            self.support_oldest_time = m.get('SupportOldestTime')
        return self


class DescribeInstDbLogInfoResponseBody(TeaModel):
    def __init__(self, log_time_range=None, request_id=None, success=None):
        self.log_time_range = log_time_range  # type: DescribeInstDbLogInfoResponseBodyLogTimeRange
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.log_time_range:
            self.log_time_range.validate()

    def to_map(self):
        _map = super(DescribeInstDbLogInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_time_range is not None:
            result['LogTimeRange'] = self.log_time_range.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LogTimeRange') is not None:
            temp_model = DescribeInstDbLogInfoResponseBodyLogTimeRange()
            self.log_time_range = temp_model.from_map(m['LogTimeRange'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeInstDbLogInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeInstDbLogInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstDbLogInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstDbLogInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstDbSlsInfoRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstDbSlsInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeInstDbSlsInfoResponseBodyAuditInfo(TeaModel):
    def __init__(self, log_store=None, project=None):
        self.log_store = log_store  # type: str
        self.project = project  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstDbSlsInfoResponseBodyAuditInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_store is not None:
            result['LogStore'] = self.log_store
        if self.project is not None:
            result['Project'] = self.project
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LogStore') is not None:
            self.log_store = m.get('LogStore')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        return self


class DescribeInstDbSlsInfoResponseBody(TeaModel):
    def __init__(self, audit_info=None, request_id=None, success=None):
        self.audit_info = audit_info  # type: DescribeInstDbSlsInfoResponseBodyAuditInfo
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.audit_info:
            self.audit_info.validate()

    def to_map(self):
        _map = super(DescribeInstDbSlsInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audit_info is not None:
            result['AuditInfo'] = self.audit_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuditInfo') is not None:
            temp_model = DescribeInstDbSlsInfoResponseBodyAuditInfo()
            self.audit_info = temp_model.from_map(m['AuditInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeInstDbSlsInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeInstDbSlsInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstDbSlsInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstDbSlsInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceAccountsRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceAccountsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccountDbPrivilegesDbPrivilege(TeaModel):
    def __init__(self, db_name=None, privilege=None):
        self.db_name = db_name  # type: str
        self.privilege = privilege  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccountDbPrivilegesDbPrivilege, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.privilege is not None:
            result['Privilege'] = self.privilege
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('Privilege') is not None:
            self.privilege = m.get('Privilege')
        return self


class DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccountDbPrivileges(TeaModel):
    def __init__(self, db_privilege=None):
        self.db_privilege = db_privilege  # type: list[DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccountDbPrivilegesDbPrivilege]

    def validate(self):
        if self.db_privilege:
            for k in self.db_privilege:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccountDbPrivileges, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DbPrivilege'] = []
        if self.db_privilege is not None:
            for k in self.db_privilege:
                result['DbPrivilege'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.db_privilege = []
        if m.get('DbPrivilege') is not None:
            for k in m.get('DbPrivilege'):
                temp_model = DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccountDbPrivilegesDbPrivilege()
                self.db_privilege.append(temp_model.from_map(k))
        return self


class DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccount(TeaModel):
    def __init__(self, account_name=None, account_type=None, db_privileges=None, description=None, host=None):
        self.account_name = account_name  # type: str
        self.account_type = account_type  # type: int
        self.db_privileges = db_privileges  # type: DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccountDbPrivileges
        self.description = description  # type: str
        self.host = host  # type: str

    def validate(self):
        if self.db_privileges:
            self.db_privileges.validate()

    def to_map(self):
        _map = super(DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccount, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.db_privileges is not None:
            result['DbPrivileges'] = self.db_privileges.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.host is not None:
            result['Host'] = self.host
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('DbPrivileges') is not None:
            temp_model = DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccountDbPrivileges()
            self.db_privileges = temp_model.from_map(m['DbPrivileges'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        return self


class DescribeInstanceAccountsResponseBodyInstanceAccounts(TeaModel):
    def __init__(self, instance_account=None):
        self.instance_account = instance_account  # type: list[DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccount]

    def validate(self):
        if self.instance_account:
            for k in self.instance_account:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceAccountsResponseBodyInstanceAccounts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceAccount'] = []
        if self.instance_account is not None:
            for k in self.instance_account:
                result['InstanceAccount'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instance_account = []
        if m.get('InstanceAccount') is not None:
            for k in m.get('InstanceAccount'):
                temp_model = DescribeInstanceAccountsResponseBodyInstanceAccountsInstanceAccount()
                self.instance_account.append(temp_model.from_map(k))
        return self


class DescribeInstanceAccountsResponseBody(TeaModel):
    def __init__(self, instance_accounts=None, request_id=None, success=None):
        self.instance_accounts = instance_accounts  # type: DescribeInstanceAccountsResponseBodyInstanceAccounts
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.instance_accounts:
            self.instance_accounts.validate()

    def to_map(self):
        _map = super(DescribeInstanceAccountsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_accounts is not None:
            result['InstanceAccounts'] = self.instance_accounts.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceAccounts') is not None:
            temp_model = DescribeInstanceAccountsResponseBodyInstanceAccounts()
            self.instance_accounts = temp_model.from_map(m['InstanceAccounts'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeInstanceAccountsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeInstanceAccountsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceAccountsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceAccountsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceMenuSwitchRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceMenuSwitchRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeInstanceMenuSwitchResponseBody(TeaModel):
    def __init__(self, config=None, request_id=None, success=None):
        self.config = config  # type: dict[str, any]
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceMenuSwitchResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeInstanceMenuSwitchResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeInstanceMenuSwitchResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceMenuSwitchResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceMenuSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceSwitchAzoneRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceSwitchAzoneRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeInstanceSwitchAzoneResponseBodyResultTargetAzones(TeaModel):
    def __init__(self, target_azone=None):
        self.target_azone = target_azone  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceSwitchAzoneResponseBodyResultTargetAzones, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_azone is not None:
            result['TargetAzone'] = self.target_azone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TargetAzone') is not None:
            self.target_azone = m.get('TargetAzone')
        return self


class DescribeInstanceSwitchAzoneResponseBodyResult(TeaModel):
    def __init__(self, origin_azone_id=None, region_id=None, switch_able=None, target_azones=None):
        self.origin_azone_id = origin_azone_id  # type: str
        self.region_id = region_id  # type: str
        self.switch_able = switch_able  # type: bool
        self.target_azones = target_azones  # type: DescribeInstanceSwitchAzoneResponseBodyResultTargetAzones

    def validate(self):
        if self.target_azones:
            self.target_azones.validate()

    def to_map(self):
        _map = super(DescribeInstanceSwitchAzoneResponseBodyResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_azone_id is not None:
            result['OriginAzoneId'] = self.origin_azone_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.switch_able is not None:
            result['SwitchAble'] = self.switch_able
        if self.target_azones is not None:
            result['TargetAzones'] = self.target_azones.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OriginAzoneId') is not None:
            self.origin_azone_id = m.get('OriginAzoneId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SwitchAble') is not None:
            self.switch_able = m.get('SwitchAble')
        if m.get('TargetAzones') is not None:
            temp_model = DescribeInstanceSwitchAzoneResponseBodyResultTargetAzones()
            self.target_azones = temp_model.from_map(m['TargetAzones'])
        return self


class DescribeInstanceSwitchAzoneResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: DescribeInstanceSwitchAzoneResponseBodyResult
        self.success = success  # type: bool

    def validate(self):
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super(DescribeInstanceSwitchAzoneResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            temp_model = DescribeInstanceSwitchAzoneResponseBodyResult()
            self.result = temp_model.from_map(m['Result'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeInstanceSwitchAzoneResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeInstanceSwitchAzoneResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceSwitchAzoneResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceSwitchAzoneResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceSwitchNetworkRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceSwitchNetworkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfoVswitchInfosVswitchInfo(TeaModel):
    def __init__(self, azone_id=None, drds_supported=None, vpc_id=None, vswitch_id=None, vswitch_name=None):
        self.azone_id = azone_id  # type: str
        self.drds_supported = drds_supported  # type: bool
        self.vpc_id = vpc_id  # type: str
        self.vswitch_id = vswitch_id  # type: str
        self.vswitch_name = vswitch_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfoVswitchInfosVswitchInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.azone_id is not None:
            result['AzoneId'] = self.azone_id
        if self.drds_supported is not None:
            result['DrdsSupported'] = self.drds_supported
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.vswitch_name is not None:
            result['VswitchName'] = self.vswitch_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AzoneId') is not None:
            self.azone_id = m.get('AzoneId')
        if m.get('DrdsSupported') is not None:
            self.drds_supported = m.get('DrdsSupported')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('VswitchName') is not None:
            self.vswitch_name = m.get('VswitchName')
        return self


class DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfoVswitchInfos(TeaModel):
    def __init__(self, vswitch_info=None):
        self.vswitch_info = vswitch_info  # type: list[DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfoVswitchInfosVswitchInfo]

    def validate(self):
        if self.vswitch_info:
            for k in self.vswitch_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfoVswitchInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VswitchInfo'] = []
        if self.vswitch_info is not None:
            for k in self.vswitch_info:
                result['VswitchInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.vswitch_info = []
        if m.get('VswitchInfo') is not None:
            for k in m.get('VswitchInfo'):
                temp_model = DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfoVswitchInfosVswitchInfo()
                self.vswitch_info.append(temp_model.from_map(k))
        return self


class DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfo(TeaModel):
    def __init__(self, region_id=None, vpc_id=None, vpc_name=None, vswitch_infos=None):
        self.region_id = region_id  # type: str
        self.vpc_id = vpc_id  # type: str
        self.vpc_name = vpc_name  # type: str
        self.vswitch_infos = vswitch_infos  # type: DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfoVswitchInfos

    def validate(self):
        if self.vswitch_infos:
            self.vswitch_infos.validate()

    def to_map(self):
        _map = super(DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        if self.vswitch_infos is not None:
            result['VswitchInfos'] = self.vswitch_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        if m.get('VswitchInfos') is not None:
            temp_model = DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfoVswitchInfos()
            self.vswitch_infos = temp_model.from_map(m['VswitchInfos'])
        return self


class DescribeInstanceSwitchNetworkResponseBodyVpcInfos(TeaModel):
    def __init__(self, vpc_info=None):
        self.vpc_info = vpc_info  # type: list[DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfo]

    def validate(self):
        if self.vpc_info:
            for k in self.vpc_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeInstanceSwitchNetworkResponseBodyVpcInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VpcInfo'] = []
        if self.vpc_info is not None:
            for k in self.vpc_info:
                result['VpcInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.vpc_info = []
        if m.get('VpcInfo') is not None:
            for k in m.get('VpcInfo'):
                temp_model = DescribeInstanceSwitchNetworkResponseBodyVpcInfosVpcInfo()
                self.vpc_info.append(temp_model.from_map(k))
        return self


class DescribeInstanceSwitchNetworkResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, vpc_infos=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.vpc_infos = vpc_infos  # type: DescribeInstanceSwitchNetworkResponseBodyVpcInfos

    def validate(self):
        if self.vpc_infos:
            self.vpc_infos.validate()

    def to_map(self):
        _map = super(DescribeInstanceSwitchNetworkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.vpc_infos is not None:
            result['VpcInfos'] = self.vpc_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('VpcInfos') is not None:
            temp_model = DescribeInstanceSwitchNetworkResponseBodyVpcInfos()
            self.vpc_infos = temp_model.from_map(m['VpcInfos'])
        return self


class DescribeInstanceSwitchNetworkResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeInstanceSwitchNetworkResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeInstanceSwitchNetworkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceSwitchNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePreCheckResultRequest(TeaModel):
    def __init__(self, drds_instance_id=None, region_id=None, task_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePreCheckResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribePreCheckResultResponseBodyPreCheckResultSubCheckItems(TeaModel):
    def __init__(self, error_msg_code=None, error_msg_params=None, pre_check_item_name=None, state=None):
        self.error_msg_code = error_msg_code  # type: str
        self.error_msg_params = error_msg_params  # type: list[str]
        self.pre_check_item_name = pre_check_item_name  # type: str
        self.state = state  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePreCheckResultResponseBodyPreCheckResultSubCheckItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg_code is not None:
            result['ErrorMsgCode'] = self.error_msg_code
        if self.error_msg_params is not None:
            result['ErrorMsgParams'] = self.error_msg_params
        if self.pre_check_item_name is not None:
            result['PreCheckItemName'] = self.pre_check_item_name
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorMsgCode') is not None:
            self.error_msg_code = m.get('ErrorMsgCode')
        if m.get('ErrorMsgParams') is not None:
            self.error_msg_params = m.get('ErrorMsgParams')
        if m.get('PreCheckItemName') is not None:
            self.pre_check_item_name = m.get('PreCheckItemName')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribePreCheckResultResponseBodyPreCheckResult(TeaModel):
    def __init__(self, pre_check_name=None, state=None, sub_check_items=None):
        self.pre_check_name = pre_check_name  # type: str
        self.state = state  # type: str
        self.sub_check_items = sub_check_items  # type: list[DescribePreCheckResultResponseBodyPreCheckResultSubCheckItems]

    def validate(self):
        if self.sub_check_items:
            for k in self.sub_check_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePreCheckResultResponseBodyPreCheckResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_check_name is not None:
            result['PreCheckName'] = self.pre_check_name
        if self.state is not None:
            result['State'] = self.state
        result['SubCheckItems'] = []
        if self.sub_check_items is not None:
            for k in self.sub_check_items:
                result['SubCheckItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PreCheckName') is not None:
            self.pre_check_name = m.get('PreCheckName')
        if m.get('State') is not None:
            self.state = m.get('State')
        self.sub_check_items = []
        if m.get('SubCheckItems') is not None:
            for k in m.get('SubCheckItems'):
                temp_model = DescribePreCheckResultResponseBodyPreCheckResultSubCheckItems()
                self.sub_check_items.append(temp_model.from_map(k))
        return self


class DescribePreCheckResultResponseBody(TeaModel):
    def __init__(self, pre_check_result=None, request_id=None, success=None):
        self.pre_check_result = pre_check_result  # type: DescribePreCheckResultResponseBodyPreCheckResult
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.pre_check_result:
            self.pre_check_result.validate()

    def to_map(self):
        _map = super(DescribePreCheckResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_check_result is not None:
            result['PreCheckResult'] = self.pre_check_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PreCheckResult') is not None:
            temp_model = DescribePreCheckResultResponseBodyPreCheckResult()
            self.pre_check_result = temp_model.from_map(m['PreCheckResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribePreCheckResultResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribePreCheckResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePreCheckResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePreCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRDSPerformanceRequest(TeaModel):
    def __init__(self, db_inst_type=None, drds_instance_id=None, end_time=None, keys=None, rds_instance_id=None,
                 start_time=None):
        self.db_inst_type = db_inst_type  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.end_time = end_time  # type: long
        self.keys = keys  # type: str
        self.rds_instance_id = rds_instance_id  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRDSPerformanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.keys is not None:
            result['Keys'] = self.keys
        if self.rds_instance_id is not None:
            result['RdsInstanceId'] = self.rds_instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Keys') is not None:
            self.keys = m.get('Keys')
        if m.get('RdsInstanceId') is not None:
            self.rds_instance_id = m.get('RdsInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeRDSPerformanceResponseBodyDataValues(TeaModel):
    def __init__(self, date=None, value=None):
        self.date = date  # type: long
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRDSPerformanceResponseBodyDataValues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date is not None:
            result['Date'] = self.date
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Date') is not None:
            self.date = m.get('Date')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeRDSPerformanceResponseBodyData(TeaModel):
    def __init__(self, key=None, node_name=None, node_num=None, unit=None, values=None):
        self.key = key  # type: str
        self.node_name = node_name  # type: str
        self.node_num = node_num  # type: int
        self.unit = unit  # type: str
        self.values = values  # type: list[DescribeRDSPerformanceResponseBodyDataValues]

    def validate(self):
        if self.values:
            for k in self.values:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRDSPerformanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.node_num is not None:
            result['NodeNum'] = self.node_num
        if self.unit is not None:
            result['Unit'] = self.unit
        result['Values'] = []
        if self.values is not None:
            for k in self.values:
                result['Values'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('NodeNum') is not None:
            self.node_num = m.get('NodeNum')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        self.values = []
        if m.get('Values') is not None:
            for k in m.get('Values'):
                temp_model = DescribeRDSPerformanceResponseBodyDataValues()
                self.values.append(temp_model.from_map(k))
        return self


class DescribeRDSPerformanceResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: list[DescribeRDSPerformanceResponseBodyData]
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRDSPerformanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeRDSPerformanceResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeRDSPerformanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRDSPerformanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRDSPerformanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRDSPerformanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRdsCommodityRequest(TeaModel):
    def __init__(self, commodity_code=None, drds_instance_id=None, order_type=None):
        self.commodity_code = commodity_code  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.order_type = order_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsCommodityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        return self


class DescribeRdsCommodityResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsCommodityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeRdsCommodityResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRdsCommodityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRdsCommodityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRdsCommodityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRdsDrdsDBRequest(TeaModel):
    def __init__(self, drds_instance_id=None, rds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.rds_instance_id = rds_instance_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsDrdsDBRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.rds_instance_id is not None:
            result['RdsInstanceId'] = self.rds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RdsInstanceId') is not None:
            self.rds_instance_id = m.get('RdsInstanceId')
        return self


class DescribeRdsDrdsDBResponseBodyRdsDrdsDbsRdsDrdsDbDBList(TeaModel):
    def __init__(self, db=None):
        self.db = db  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsDrdsDBResponseBodyRdsDrdsDbsRdsDrdsDbDBList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db is not None:
            result['DB'] = self.db
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DB') is not None:
            self.db = m.get('DB')
        return self


class DescribeRdsDrdsDBResponseBodyRdsDrdsDbsRdsDrdsDb(TeaModel):
    def __init__(self, dblist=None, rds_id=None):
        self.dblist = dblist  # type: DescribeRdsDrdsDBResponseBodyRdsDrdsDbsRdsDrdsDbDBList
        self.rds_id = rds_id  # type: str

    def validate(self):
        if self.dblist:
            self.dblist.validate()

    def to_map(self):
        _map = super(DescribeRdsDrdsDBResponseBodyRdsDrdsDbsRdsDrdsDb, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dblist is not None:
            result['DBList'] = self.dblist.to_map()
        if self.rds_id is not None:
            result['RdsId'] = self.rds_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBList') is not None:
            temp_model = DescribeRdsDrdsDBResponseBodyRdsDrdsDbsRdsDrdsDbDBList()
            self.dblist = temp_model.from_map(m['DBList'])
        if m.get('RdsId') is not None:
            self.rds_id = m.get('RdsId')
        return self


class DescribeRdsDrdsDBResponseBodyRdsDrdsDbs(TeaModel):
    def __init__(self, rds_drds_db=None):
        self.rds_drds_db = rds_drds_db  # type: list[DescribeRdsDrdsDBResponseBodyRdsDrdsDbsRdsDrdsDb]

    def validate(self):
        if self.rds_drds_db:
            for k in self.rds_drds_db:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRdsDrdsDBResponseBodyRdsDrdsDbs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RdsDrdsDb'] = []
        if self.rds_drds_db is not None:
            for k in self.rds_drds_db:
                result['RdsDrdsDb'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rds_drds_db = []
        if m.get('RdsDrdsDb') is not None:
            for k in m.get('RdsDrdsDb'):
                temp_model = DescribeRdsDrdsDBResponseBodyRdsDrdsDbsRdsDrdsDb()
                self.rds_drds_db.append(temp_model.from_map(k))
        return self


class DescribeRdsDrdsDBResponseBody(TeaModel):
    def __init__(self, rds_drds_dbs=None, request_id=None, success=None):
        self.rds_drds_dbs = rds_drds_dbs  # type: DescribeRdsDrdsDBResponseBodyRdsDrdsDbs
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.rds_drds_dbs:
            self.rds_drds_dbs.validate()

    def to_map(self):
        _map = super(DescribeRdsDrdsDBResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rds_drds_dbs is not None:
            result['RdsDrdsDbs'] = self.rds_drds_dbs.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RdsDrdsDbs') is not None:
            temp_model = DescribeRdsDrdsDBResponseBodyRdsDrdsDbs()
            self.rds_drds_dbs = temp_model.from_map(m['RdsDrdsDbs'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeRdsDrdsDBResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRdsDrdsDBResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRdsDrdsDBResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRdsDrdsDBResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRdsPerformanceSummaryRequest(TeaModel):
    def __init__(self, drds_instance_id=None, rds_instance_id=None, region_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.rds_instance_id = rds_instance_id  # type: list[str]
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsPerformanceSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.rds_instance_id is not None:
            result['RdsInstanceId'] = self.rds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RdsInstanceId') is not None:
            self.rds_instance_id = m.get('RdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRdsPerformanceSummaryResponseBodyRdsPerformanceInfos(TeaModel):
    def __init__(self, active_sessions=None, cpu=None, iops=None, rds_id=None, space_usage=None, total_sessions=None):
        self.active_sessions = active_sessions  # type: int
        self.cpu = cpu  # type: float
        self.iops = iops  # type: float
        self.rds_id = rds_id  # type: str
        self.space_usage = space_usage  # type: long
        self.total_sessions = total_sessions  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsPerformanceSummaryResponseBodyRdsPerformanceInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_sessions is not None:
            result['ActiveSessions'] = self.active_sessions
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.iops is not None:
            result['Iops'] = self.iops
        if self.rds_id is not None:
            result['RdsId'] = self.rds_id
        if self.space_usage is not None:
            result['SpaceUsage'] = self.space_usage
        if self.total_sessions is not None:
            result['TotalSessions'] = self.total_sessions
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActiveSessions') is not None:
            self.active_sessions = m.get('ActiveSessions')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('Iops') is not None:
            self.iops = m.get('Iops')
        if m.get('RdsId') is not None:
            self.rds_id = m.get('RdsId')
        if m.get('SpaceUsage') is not None:
            self.space_usage = m.get('SpaceUsage')
        if m.get('TotalSessions') is not None:
            self.total_sessions = m.get('TotalSessions')
        return self


class DescribeRdsPerformanceSummaryResponseBody(TeaModel):
    def __init__(self, rds_performance_infos=None, request_id=None, success=None):
        self.rds_performance_infos = rds_performance_infos  # type: list[DescribeRdsPerformanceSummaryResponseBodyRdsPerformanceInfos]
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.rds_performance_infos:
            for k in self.rds_performance_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRdsPerformanceSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RdsPerformanceInfos'] = []
        if self.rds_performance_infos is not None:
            for k in self.rds_performance_infos:
                result['RdsPerformanceInfos'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rds_performance_infos = []
        if m.get('RdsPerformanceInfos') is not None:
            for k in m.get('RdsPerformanceInfos'):
                temp_model = DescribeRdsPerformanceSummaryResponseBodyRdsPerformanceInfos()
                self.rds_performance_infos.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeRdsPerformanceSummaryResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRdsPerformanceSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRdsPerformanceSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRdsPerformanceSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRdsPriceRequest(TeaModel):
    def __init__(self, params=None, region_id=None):
        self.params = params  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsPriceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.params is not None:
            result['Params'] = self.params
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRdsPriceResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsPriceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeRdsPriceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRdsPriceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRdsPriceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRdsPriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRdsReadOnlyRequest(TeaModel):
    def __init__(self, db_inst_type=None, drds_instance_id=None, rds_instance_id=None):
        self.db_inst_type = db_inst_type  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.rds_instance_id = rds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsReadOnlyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.rds_instance_id is not None:
            result['RdsInstanceId'] = self.rds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RdsInstanceId') is not None:
            self.rds_instance_id = m.get('RdsInstanceId')
        return self


class DescribeRdsReadOnlyResponseBodyDbInstancesDbInstance(TeaModel):
    def __init__(self, connect_url=None, dbinstance_cpu=None, dbinstance_class_type=None, dbinstance_id=None,
                 dbinstance_memory=None, dbinstance_status=None, dbinstance_storage=None, db_inst_type=None, dm_instance_id=None,
                 engine=None, engine_version=None, expire_time=None, network_type=None, pay_type=None, port=None,
                 rds_inst_type=None, read_weight=None, remain_days=None):
        self.connect_url = connect_url  # type: str
        self.dbinstance_cpu = dbinstance_cpu  # type: str
        self.dbinstance_class_type = dbinstance_class_type  # type: str
        self.dbinstance_id = dbinstance_id  # type: str
        self.dbinstance_memory = dbinstance_memory  # type: long
        self.dbinstance_status = dbinstance_status  # type: str
        self.dbinstance_storage = dbinstance_storage  # type: long
        self.db_inst_type = db_inst_type  # type: str
        self.dm_instance_id = dm_instance_id  # type: str
        self.engine = engine  # type: str
        self.engine_version = engine_version  # type: str
        self.expire_time = expire_time  # type: str
        self.network_type = network_type  # type: str
        self.pay_type = pay_type  # type: str
        self.port = port  # type: int
        self.rds_inst_type = rds_inst_type  # type: str
        self.read_weight = read_weight  # type: int
        self.remain_days = remain_days  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsReadOnlyResponseBodyDbInstancesDbInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connect_url is not None:
            result['ConnectUrl'] = self.connect_url
        if self.dbinstance_cpu is not None:
            result['DBInstanceCPU'] = self.dbinstance_cpu
        if self.dbinstance_class_type is not None:
            result['DBInstanceClassType'] = self.dbinstance_class_type
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.dbinstance_memory is not None:
            result['DBInstanceMemory'] = self.dbinstance_memory
        if self.dbinstance_status is not None:
            result['DBInstanceStatus'] = self.dbinstance_status
        if self.dbinstance_storage is not None:
            result['DBInstanceStorage'] = self.dbinstance_storage
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.dm_instance_id is not None:
            result['DmInstanceId'] = self.dm_instance_id
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.engine_version is not None:
            result['EngineVersion'] = self.engine_version
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.port is not None:
            result['Port'] = self.port
        if self.rds_inst_type is not None:
            result['RdsInstType'] = self.rds_inst_type
        if self.read_weight is not None:
            result['ReadWeight'] = self.read_weight
        if self.remain_days is not None:
            result['RemainDays'] = self.remain_days
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConnectUrl') is not None:
            self.connect_url = m.get('ConnectUrl')
        if m.get('DBInstanceCPU') is not None:
            self.dbinstance_cpu = m.get('DBInstanceCPU')
        if m.get('DBInstanceClassType') is not None:
            self.dbinstance_class_type = m.get('DBInstanceClassType')
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DBInstanceMemory') is not None:
            self.dbinstance_memory = m.get('DBInstanceMemory')
        if m.get('DBInstanceStatus') is not None:
            self.dbinstance_status = m.get('DBInstanceStatus')
        if m.get('DBInstanceStorage') is not None:
            self.dbinstance_storage = m.get('DBInstanceStorage')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DmInstanceId') is not None:
            self.dm_instance_id = m.get('DmInstanceId')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('EngineVersion') is not None:
            self.engine_version = m.get('EngineVersion')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RdsInstType') is not None:
            self.rds_inst_type = m.get('RdsInstType')
        if m.get('ReadWeight') is not None:
            self.read_weight = m.get('ReadWeight')
        if m.get('RemainDays') is not None:
            self.remain_days = m.get('RemainDays')
        return self


class DescribeRdsReadOnlyResponseBodyDbInstances(TeaModel):
    def __init__(self, db_instance=None):
        self.db_instance = db_instance  # type: list[DescribeRdsReadOnlyResponseBodyDbInstancesDbInstance]

    def validate(self):
        if self.db_instance:
            for k in self.db_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRdsReadOnlyResponseBodyDbInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DbInstance'] = []
        if self.db_instance is not None:
            for k in self.db_instance:
                result['DbInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.db_instance = []
        if m.get('DbInstance') is not None:
            for k in m.get('DbInstance'):
                temp_model = DescribeRdsReadOnlyResponseBodyDbInstancesDbInstance()
                self.db_instance.append(temp_model.from_map(k))
        return self


class DescribeRdsReadOnlyResponseBody(TeaModel):
    def __init__(self, db_instances=None, request_id=None, success=None):
        self.db_instances = db_instances  # type: DescribeRdsReadOnlyResponseBodyDbInstances
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.db_instances:
            self.db_instances.validate()

    def to_map(self):
        _map = super(DescribeRdsReadOnlyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instances is not None:
            result['DbInstances'] = self.db_instances.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstances') is not None:
            temp_model = DescribeRdsReadOnlyResponseBodyDbInstances()
            self.db_instances = temp_model.from_map(m['DbInstances'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeRdsReadOnlyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRdsReadOnlyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRdsReadOnlyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRdsReadOnlyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRdsSuperAccountInstancesRequest(TeaModel):
    def __init__(self, db_inst_type=None, drds_instance_id=None, rds_instance=None):
        self.db_inst_type = db_inst_type  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.rds_instance = rds_instance  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsSuperAccountInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.rds_instance is not None:
            result['RdsInstance'] = self.rds_instance
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RdsInstance') is not None:
            self.rds_instance = m.get('RdsInstance')
        return self


class DescribeRdsSuperAccountInstancesResponseBodyDbInstances(TeaModel):
    def __init__(self, db_instance=None):
        self.db_instance = db_instance  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsSuperAccountInstancesResponseBodyDbInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance is not None:
            result['DbInstance'] = self.db_instance
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstance') is not None:
            self.db_instance = m.get('DbInstance')
        return self


class DescribeRdsSuperAccountInstancesResponseBody(TeaModel):
    def __init__(self, db_instances=None, request_id=None):
        self.db_instances = db_instances  # type: DescribeRdsSuperAccountInstancesResponseBodyDbInstances
        self.request_id = request_id  # type: str

    def validate(self):
        if self.db_instances:
            self.db_instances.validate()

    def to_map(self):
        _map = super(DescribeRdsSuperAccountInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instances is not None:
            result['DbInstances'] = self.db_instances.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstances') is not None:
            temp_model = DescribeRdsSuperAccountInstancesResponseBodyDbInstances()
            self.db_instances = temp_model.from_map(m['DbInstances'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRdsSuperAccountInstancesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRdsSuperAccountInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRdsSuperAccountInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRdsSuperAccountInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRdsVpcForZoneRequest(TeaModel):
    def __init__(self, region_id=None, zone_id=None):
        self.region_id = region_id  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsVpcForZoneRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeRdsVpcForZoneResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRdsVpcForZoneResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeRdsVpcForZoneResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRdsVpcForZoneResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRdsVpcForZoneResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRdsVpcForZoneResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRecycleBinStatusRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRecycleBinStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRecycleBinStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, status=None, success=None):
        self.request_id = request_id  # type: str
        self.status = status  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRecycleBinStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeRecycleBinStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRecycleBinStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRecycleBinStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRecycleBinStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRecycleBinTablesRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRecycleBinTablesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRecycleBinTablesResponseBodyData(TeaModel):
    def __init__(self, create_time=None, original_table_name=None, table_name=None):
        self.create_time = create_time  # type: str
        self.original_table_name = original_table_name  # type: str
        self.table_name = table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRecycleBinTablesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.original_table_name is not None:
            result['OriginalTableName'] = self.original_table_name
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('OriginalTableName') is not None:
            self.original_table_name = m.get('OriginalTableName')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class DescribeRecycleBinTablesResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: list[DescribeRecycleBinTablesResponseBodyData]
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRecycleBinTablesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeRecycleBinTablesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeRecycleBinTablesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRecycleBinTablesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRecycleBinTablesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRecycleBinTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRestoreOrderRequest(TeaModel):
    def __init__(self, backup_db_names=None, backup_id=None, backup_level=None, backup_mode=None,
                 drds_instance_id=None, preferred_backup_time=None):
        self.backup_db_names = backup_db_names  # type: str
        self.backup_id = backup_id  # type: str
        self.backup_level = backup_level  # type: str
        self.backup_mode = backup_mode  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.preferred_backup_time = preferred_backup_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRestoreOrderRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_db_names is not None:
            result['BackupDbNames'] = self.backup_db_names
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_level is not None:
            result['BackupLevel'] = self.backup_level
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.preferred_backup_time is not None:
            result['PreferredBackupTime'] = self.preferred_backup_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupDbNames') is not None:
            self.backup_db_names = m.get('BackupDbNames')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupLevel') is not None:
            self.backup_level = m.get('BackupLevel')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PreferredBackupTime') is not None:
            self.preferred_backup_time = m.get('PreferredBackupTime')
        return self


class DescribeRestoreOrderResponseBodyRestoreOrderDODrdsOrderDOListDrdsOrderDOList(TeaModel):
    def __init__(self, azone_id=None, inst_spec=None, network=None, region_id=None, vswtich_id=None, vpc_id=None):
        self.azone_id = azone_id  # type: str
        self.inst_spec = inst_spec  # type: str
        self.network = network  # type: str
        self.region_id = region_id  # type: str
        self.vswtich_id = vswtich_id  # type: str
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRestoreOrderResponseBodyRestoreOrderDODrdsOrderDOListDrdsOrderDOList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.azone_id is not None:
            result['AzoneId'] = self.azone_id
        if self.inst_spec is not None:
            result['InstSpec'] = self.inst_spec
        if self.network is not None:
            result['Network'] = self.network
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vswtich_id is not None:
            result['VSwtichId'] = self.vswtich_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AzoneId') is not None:
            self.azone_id = m.get('AzoneId')
        if m.get('InstSpec') is not None:
            self.inst_spec = m.get('InstSpec')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VSwtichId') is not None:
            self.vswtich_id = m.get('VSwtichId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeRestoreOrderResponseBodyRestoreOrderDODrdsOrderDOList(TeaModel):
    def __init__(self, drds_order_dolist=None):
        self.drds_order_dolist = drds_order_dolist  # type: list[DescribeRestoreOrderResponseBodyRestoreOrderDODrdsOrderDOListDrdsOrderDOList]

    def validate(self):
        if self.drds_order_dolist:
            for k in self.drds_order_dolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRestoreOrderResponseBodyRestoreOrderDODrdsOrderDOList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DrdsOrderDOList'] = []
        if self.drds_order_dolist is not None:
            for k in self.drds_order_dolist:
                result['DrdsOrderDOList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.drds_order_dolist = []
        if m.get('DrdsOrderDOList') is not None:
            for k in m.get('DrdsOrderDOList'):
                temp_model = DescribeRestoreOrderResponseBodyRestoreOrderDODrdsOrderDOListDrdsOrderDOList()
                self.drds_order_dolist.append(temp_model.from_map(k))
        return self


class DescribeRestoreOrderResponseBodyRestoreOrderDOPolarOrderDOListPolarOrderDOList(TeaModel):
    def __init__(self, azone_id=None, db_instance_storage=None, engine=None, instance_class=None, network=None,
                 num=None, region_id=None, version=None):
        self.azone_id = azone_id  # type: str
        self.db_instance_storage = db_instance_storage  # type: str
        self.engine = engine  # type: str
        self.instance_class = instance_class  # type: str
        self.network = network  # type: str
        self.num = num  # type: long
        self.region_id = region_id  # type: str
        self.version = version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRestoreOrderResponseBodyRestoreOrderDOPolarOrderDOListPolarOrderDOList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.azone_id is not None:
            result['AzoneId'] = self.azone_id
        if self.db_instance_storage is not None:
            result['DbInstanceStorage'] = self.db_instance_storage
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_class is not None:
            result['InstanceClass'] = self.instance_class
        if self.network is not None:
            result['Network'] = self.network
        if self.num is not None:
            result['Num'] = self.num
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AzoneId') is not None:
            self.azone_id = m.get('AzoneId')
        if m.get('DbInstanceStorage') is not None:
            self.db_instance_storage = m.get('DbInstanceStorage')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceClass') is not None:
            self.instance_class = m.get('InstanceClass')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('Num') is not None:
            self.num = m.get('Num')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeRestoreOrderResponseBodyRestoreOrderDOPolarOrderDOList(TeaModel):
    def __init__(self, polar_order_dolist=None):
        self.polar_order_dolist = polar_order_dolist  # type: list[DescribeRestoreOrderResponseBodyRestoreOrderDOPolarOrderDOListPolarOrderDOList]

    def validate(self):
        if self.polar_order_dolist:
            for k in self.polar_order_dolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRestoreOrderResponseBodyRestoreOrderDOPolarOrderDOList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PolarOrderDOList'] = []
        if self.polar_order_dolist is not None:
            for k in self.polar_order_dolist:
                result['PolarOrderDOList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.polar_order_dolist = []
        if m.get('PolarOrderDOList') is not None:
            for k in m.get('PolarOrderDOList'):
                temp_model = DescribeRestoreOrderResponseBodyRestoreOrderDOPolarOrderDOListPolarOrderDOList()
                self.polar_order_dolist.append(temp_model.from_map(k))
        return self


class DescribeRestoreOrderResponseBodyRestoreOrderDORdsOrderDOListRdsOrderDOList(TeaModel):
    def __init__(self, azone_id=None, db_instance_storage=None, engine=None, instance_class=None, network=None,
                 num=None, region_id=None, version=None):
        self.azone_id = azone_id  # type: str
        self.db_instance_storage = db_instance_storage  # type: str
        self.engine = engine  # type: str
        self.instance_class = instance_class  # type: str
        self.network = network  # type: str
        self.num = num  # type: long
        self.region_id = region_id  # type: str
        self.version = version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRestoreOrderResponseBodyRestoreOrderDORdsOrderDOListRdsOrderDOList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.azone_id is not None:
            result['AzoneId'] = self.azone_id
        if self.db_instance_storage is not None:
            result['DbInstanceStorage'] = self.db_instance_storage
        if self.engine is not None:
            result['Engine'] = self.engine
        if self.instance_class is not None:
            result['InstanceClass'] = self.instance_class
        if self.network is not None:
            result['Network'] = self.network
        if self.num is not None:
            result['Num'] = self.num
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AzoneId') is not None:
            self.azone_id = m.get('AzoneId')
        if m.get('DbInstanceStorage') is not None:
            self.db_instance_storage = m.get('DbInstanceStorage')
        if m.get('Engine') is not None:
            self.engine = m.get('Engine')
        if m.get('InstanceClass') is not None:
            self.instance_class = m.get('InstanceClass')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('Num') is not None:
            self.num = m.get('Num')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeRestoreOrderResponseBodyRestoreOrderDORdsOrderDOList(TeaModel):
    def __init__(self, rds_order_dolist=None):
        self.rds_order_dolist = rds_order_dolist  # type: list[DescribeRestoreOrderResponseBodyRestoreOrderDORdsOrderDOListRdsOrderDOList]

    def validate(self):
        if self.rds_order_dolist:
            for k in self.rds_order_dolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRestoreOrderResponseBodyRestoreOrderDORdsOrderDOList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RdsOrderDOList'] = []
        if self.rds_order_dolist is not None:
            for k in self.rds_order_dolist:
                result['RdsOrderDOList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rds_order_dolist = []
        if m.get('RdsOrderDOList') is not None:
            for k in m.get('RdsOrderDOList'):
                temp_model = DescribeRestoreOrderResponseBodyRestoreOrderDORdsOrderDOListRdsOrderDOList()
                self.rds_order_dolist.append(temp_model.from_map(k))
        return self


class DescribeRestoreOrderResponseBodyRestoreOrderDO(TeaModel):
    def __init__(self, drds_order_dolist=None, polar_order_dolist=None, rds_order_dolist=None):
        self.drds_order_dolist = drds_order_dolist  # type: DescribeRestoreOrderResponseBodyRestoreOrderDODrdsOrderDOList
        self.polar_order_dolist = polar_order_dolist  # type: DescribeRestoreOrderResponseBodyRestoreOrderDOPolarOrderDOList
        self.rds_order_dolist = rds_order_dolist  # type: DescribeRestoreOrderResponseBodyRestoreOrderDORdsOrderDOList

    def validate(self):
        if self.drds_order_dolist:
            self.drds_order_dolist.validate()
        if self.polar_order_dolist:
            self.polar_order_dolist.validate()
        if self.rds_order_dolist:
            self.rds_order_dolist.validate()

    def to_map(self):
        _map = super(DescribeRestoreOrderResponseBodyRestoreOrderDO, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_order_dolist is not None:
            result['DrdsOrderDOList'] = self.drds_order_dolist.to_map()
        if self.polar_order_dolist is not None:
            result['PolarOrderDOList'] = self.polar_order_dolist.to_map()
        if self.rds_order_dolist is not None:
            result['RdsOrderDOList'] = self.rds_order_dolist.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsOrderDOList') is not None:
            temp_model = DescribeRestoreOrderResponseBodyRestoreOrderDODrdsOrderDOList()
            self.drds_order_dolist = temp_model.from_map(m['DrdsOrderDOList'])
        if m.get('PolarOrderDOList') is not None:
            temp_model = DescribeRestoreOrderResponseBodyRestoreOrderDOPolarOrderDOList()
            self.polar_order_dolist = temp_model.from_map(m['PolarOrderDOList'])
        if m.get('RdsOrderDOList') is not None:
            temp_model = DescribeRestoreOrderResponseBodyRestoreOrderDORdsOrderDOList()
            self.rds_order_dolist = temp_model.from_map(m['RdsOrderDOList'])
        return self


class DescribeRestoreOrderResponseBody(TeaModel):
    def __init__(self, request_id=None, restore_order_do=None, success=None):
        self.request_id = request_id  # type: str
        self.restore_order_do = restore_order_do  # type: DescribeRestoreOrderResponseBodyRestoreOrderDO
        self.success = success  # type: bool

    def validate(self):
        if self.restore_order_do:
            self.restore_order_do.validate()

    def to_map(self):
        _map = super(DescribeRestoreOrderResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.restore_order_do is not None:
            result['RestoreOrderDO'] = self.restore_order_do.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RestoreOrderDO') is not None:
            temp_model = DescribeRestoreOrderResponseBodyRestoreOrderDO()
            self.restore_order_do = temp_model.from_map(m['RestoreOrderDO'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeRestoreOrderResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeRestoreOrderResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRestoreOrderResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRestoreOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeShardTaskInfoRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None, source_table_name=None,
                 target_table_name=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.source_table_name = source_table_name  # type: str
        self.target_table_name = target_table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeShardTaskInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.source_table_name is not None:
            result['SourceTableName'] = self.source_table_name
        if self.target_table_name is not None:
            result['TargetTableName'] = self.target_table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SourceTableName') is not None:
            self.source_table_name = m.get('SourceTableName')
        if m.get('TargetTableName') is not None:
            self.target_table_name = m.get('TargetTableName')
        return self


class DescribeShardTaskInfoResponseBodyDataFull(TeaModel):
    def __init__(self, expired=None, progress=None, start_time=None, total=None, tps=None):
        self.expired = expired  # type: int
        self.progress = progress  # type: int
        self.start_time = start_time  # type: str
        self.total = total  # type: int
        self.tps = tps  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeShardTaskInfoResponseBodyDataFull, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.total is not None:
            result['Total'] = self.total
        if self.tps is not None:
            result['Tps'] = self.tps
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Tps') is not None:
            self.tps = m.get('Tps')
        return self


class DescribeShardTaskInfoResponseBodyDataFullCheck(TeaModel):
    def __init__(self, expired=None, progress=None, start_time=None, total=None, tps=None):
        self.expired = expired  # type: int
        self.progress = progress  # type: int
        self.start_time = start_time  # type: str
        self.total = total  # type: int
        self.tps = tps  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeShardTaskInfoResponseBodyDataFullCheck, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.total is not None:
            result['Total'] = self.total
        if self.tps is not None:
            result['Tps'] = self.tps
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Tps') is not None:
            self.tps = m.get('Tps')
        return self


class DescribeShardTaskInfoResponseBodyDataFullRevise(TeaModel):
    def __init__(self, expired=None, progress=None, start_time=None, total=None, tps=None):
        self.expired = expired  # type: int
        self.progress = progress  # type: int
        self.start_time = start_time  # type: str
        self.total = total  # type: int
        self.tps = tps  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeShardTaskInfoResponseBodyDataFullRevise, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.total is not None:
            result['Total'] = self.total
        if self.tps is not None:
            result['Tps'] = self.tps
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Tps') is not None:
            self.tps = m.get('Tps')
        return self


class DescribeShardTaskInfoResponseBodyDataIncrement(TeaModel):
    def __init__(self, delay=None, start_time=None, tps=None):
        self.delay = delay  # type: int
        self.start_time = start_time  # type: str
        self.tps = tps  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeShardTaskInfoResponseBodyDataIncrement, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tps is not None:
            result['Tps'] = self.tps
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Tps') is not None:
            self.tps = m.get('Tps')
        return self


class DescribeShardTaskInfoResponseBodyDataReview(TeaModel):
    def __init__(self, expired=None, progress=None, start_time=None, total=None, tps=None):
        self.expired = expired  # type: int
        self.progress = progress  # type: int
        self.start_time = start_time  # type: str
        self.total = total  # type: int
        self.tps = tps  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeShardTaskInfoResponseBodyDataReview, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.total is not None:
            result['Total'] = self.total
        if self.tps is not None:
            result['Tps'] = self.tps
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Tps') is not None:
            self.tps = m.get('Tps')
        return self


class DescribeShardTaskInfoResponseBodyData(TeaModel):
    def __init__(self, expired=None, full=None, full_check=None, full_revise=None, increment=None, progress=None,
                 review=None, source_table_name=None, stage=None, status=None, target_table_name=None):
        self.expired = expired  # type: str
        self.full = full  # type: DescribeShardTaskInfoResponseBodyDataFull
        self.full_check = full_check  # type: DescribeShardTaskInfoResponseBodyDataFullCheck
        self.full_revise = full_revise  # type: DescribeShardTaskInfoResponseBodyDataFullRevise
        self.increment = increment  # type: DescribeShardTaskInfoResponseBodyDataIncrement
        self.progress = progress  # type: str
        self.review = review  # type: DescribeShardTaskInfoResponseBodyDataReview
        self.source_table_name = source_table_name  # type: str
        self.stage = stage  # type: str
        self.status = status  # type: str
        self.target_table_name = target_table_name  # type: str

    def validate(self):
        if self.full:
            self.full.validate()
        if self.full_check:
            self.full_check.validate()
        if self.full_revise:
            self.full_revise.validate()
        if self.increment:
            self.increment.validate()
        if self.review:
            self.review.validate()

    def to_map(self):
        _map = super(DescribeShardTaskInfoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.full is not None:
            result['Full'] = self.full.to_map()
        if self.full_check is not None:
            result['FullCheck'] = self.full_check.to_map()
        if self.full_revise is not None:
            result['FullRevise'] = self.full_revise.to_map()
        if self.increment is not None:
            result['Increment'] = self.increment.to_map()
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.review is not None:
            result['Review'] = self.review.to_map()
        if self.source_table_name is not None:
            result['SourceTableName'] = self.source_table_name
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.target_table_name is not None:
            result['TargetTableName'] = self.target_table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('Full') is not None:
            temp_model = DescribeShardTaskInfoResponseBodyDataFull()
            self.full = temp_model.from_map(m['Full'])
        if m.get('FullCheck') is not None:
            temp_model = DescribeShardTaskInfoResponseBodyDataFullCheck()
            self.full_check = temp_model.from_map(m['FullCheck'])
        if m.get('FullRevise') is not None:
            temp_model = DescribeShardTaskInfoResponseBodyDataFullRevise()
            self.full_revise = temp_model.from_map(m['FullRevise'])
        if m.get('Increment') is not None:
            temp_model = DescribeShardTaskInfoResponseBodyDataIncrement()
            self.increment = temp_model.from_map(m['Increment'])
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Review') is not None:
            temp_model = DescribeShardTaskInfoResponseBodyDataReview()
            self.review = temp_model.from_map(m['Review'])
        if m.get('SourceTableName') is not None:
            self.source_table_name = m.get('SourceTableName')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TargetTableName') is not None:
            self.target_table_name = m.get('TargetTableName')
        return self


class DescribeShardTaskInfoResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: DescribeShardTaskInfoResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeShardTaskInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeShardTaskInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeShardTaskInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeShardTaskInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeShardTaskInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeShardTaskInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeShardTaskListRequest(TeaModel):
    def __init__(self, current_page=None, db_name=None, drds_instance_id=None, page_size=None, query=None,
                 region_id=None, task_type=None):
        self.current_page = current_page  # type: int
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.query = query  # type: str
        self.region_id = region_id  # type: str
        self.task_type = task_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeShardTaskListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeShardTaskListResponseBodyList(TeaModel):
    def __init__(self, delay=None, expired=None, progress=None, source_table_name=None, stage=None, status=None,
                 target_table_name=None):
        self.delay = delay  # type: int
        self.expired = expired  # type: long
        self.progress = progress  # type: int
        self.source_table_name = source_table_name  # type: str
        self.stage = stage  # type: int
        self.status = status  # type: str
        self.target_table_name = target_table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeShardTaskListResponseBodyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delay is not None:
            result['Delay'] = self.delay
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.source_table_name is not None:
            result['SourceTableName'] = self.source_table_name
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.status is not None:
            result['Status'] = self.status
        if self.target_table_name is not None:
            result['TargetTableName'] = self.target_table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Delay') is not None:
            self.delay = m.get('Delay')
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('SourceTableName') is not None:
            self.source_table_name = m.get('SourceTableName')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TargetTableName') is not None:
            self.target_table_name = m.get('TargetTableName')
        return self


class DescribeShardTaskListResponseBody(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, request_id=None, success=None, total=None):
        self.list = list  # type: list[DescribeShardTaskListResponseBodyList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeShardTaskListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeShardTaskListResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeShardTaskListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeShardTaskListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeShardTaskListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeShardTaskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSqlFlashbakTaskRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSqlFlashbakTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DescribeSqlFlashbakTaskResponseBodySqlFlashbackTasksSqlFlashbackTask(TeaModel):
    def __init__(self, db_name=None, download_url=None, expire_time=None, gmt_create=None, gmt_modified=None,
                 id=None, inst_id=None, recall_progress=None, recall_restore_type=None, recall_status=None,
                 recall_type=None, search_end_time=None, search_start_time=None, sql_counter=None, sql_pk=None, sql_type=None,
                 table_name=None, trace_id=None):
        self.db_name = db_name  # type: str
        self.download_url = download_url  # type: str
        self.expire_time = expire_time  # type: long
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.id = id  # type: long
        self.inst_id = inst_id  # type: str
        self.recall_progress = recall_progress  # type: int
        self.recall_restore_type = recall_restore_type  # type: int
        self.recall_status = recall_status  # type: int
        self.recall_type = recall_type  # type: int
        self.search_end_time = search_end_time  # type: long
        self.search_start_time = search_start_time  # type: long
        self.sql_counter = sql_counter  # type: long
        self.sql_pk = sql_pk  # type: str
        self.sql_type = sql_type  # type: str
        self.table_name = table_name  # type: str
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSqlFlashbakTaskResponseBodySqlFlashbackTasksSqlFlashbackTask, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.inst_id is not None:
            result['InstId'] = self.inst_id
        if self.recall_progress is not None:
            result['RecallProgress'] = self.recall_progress
        if self.recall_restore_type is not None:
            result['RecallRestoreType'] = self.recall_restore_type
        if self.recall_status is not None:
            result['RecallStatus'] = self.recall_status
        if self.recall_type is not None:
            result['RecallType'] = self.recall_type
        if self.search_end_time is not None:
            result['SearchEndTime'] = self.search_end_time
        if self.search_start_time is not None:
            result['SearchStartTime'] = self.search_start_time
        if self.sql_counter is not None:
            result['SqlCounter'] = self.sql_counter
        if self.sql_pk is not None:
            result['SqlPk'] = self.sql_pk
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstId') is not None:
            self.inst_id = m.get('InstId')
        if m.get('RecallProgress') is not None:
            self.recall_progress = m.get('RecallProgress')
        if m.get('RecallRestoreType') is not None:
            self.recall_restore_type = m.get('RecallRestoreType')
        if m.get('RecallStatus') is not None:
            self.recall_status = m.get('RecallStatus')
        if m.get('RecallType') is not None:
            self.recall_type = m.get('RecallType')
        if m.get('SearchEndTime') is not None:
            self.search_end_time = m.get('SearchEndTime')
        if m.get('SearchStartTime') is not None:
            self.search_start_time = m.get('SearchStartTime')
        if m.get('SqlCounter') is not None:
            self.sql_counter = m.get('SqlCounter')
        if m.get('SqlPk') is not None:
            self.sql_pk = m.get('SqlPk')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeSqlFlashbakTaskResponseBodySqlFlashbackTasks(TeaModel):
    def __init__(self, sql_flashback_task=None):
        self.sql_flashback_task = sql_flashback_task  # type: list[DescribeSqlFlashbakTaskResponseBodySqlFlashbackTasksSqlFlashbackTask]

    def validate(self):
        if self.sql_flashback_task:
            for k in self.sql_flashback_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSqlFlashbakTaskResponseBodySqlFlashbackTasks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SqlFlashbackTask'] = []
        if self.sql_flashback_task is not None:
            for k in self.sql_flashback_task:
                result['SqlFlashbackTask'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.sql_flashback_task = []
        if m.get('SqlFlashbackTask') is not None:
            for k in m.get('SqlFlashbackTask'):
                temp_model = DescribeSqlFlashbakTaskResponseBodySqlFlashbackTasksSqlFlashbackTask()
                self.sql_flashback_task.append(temp_model.from_map(k))
        return self


class DescribeSqlFlashbakTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, sql_flashback_tasks=None, success=None):
        self.request_id = request_id  # type: str
        self.sql_flashback_tasks = sql_flashback_tasks  # type: DescribeSqlFlashbakTaskResponseBodySqlFlashbackTasks
        self.success = success  # type: bool

    def validate(self):
        if self.sql_flashback_tasks:
            self.sql_flashback_tasks.validate()

    def to_map(self):
        _map = super(DescribeSqlFlashbakTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sql_flashback_tasks is not None:
            result['SqlFlashbackTasks'] = self.sql_flashback_tasks.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SqlFlashbackTasks') is not None:
            temp_model = DescribeSqlFlashbakTaskResponseBodySqlFlashbackTasks()
            self.sql_flashback_tasks = temp_model.from_map(m['SqlFlashbackTasks'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSqlFlashbakTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSqlFlashbakTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSqlFlashbakTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSqlFlashbakTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSrcRdsListRequestPartitionMapping(TeaModel):
    def __init__(self, db_shard_value=None, hot_db_name=None, hot_table_name=None, logic_table=None,
                 tb_shard_value=None):
        self.db_shard_value = db_shard_value  # type: str
        self.hot_db_name = hot_db_name  # type: str
        self.hot_table_name = hot_table_name  # type: str
        self.logic_table = logic_table  # type: str
        self.tb_shard_value = tb_shard_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSrcRdsListRequestPartitionMapping, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_shard_value is not None:
            result['DbShardValue'] = self.db_shard_value
        if self.hot_db_name is not None:
            result['HotDbName'] = self.hot_db_name
        if self.hot_table_name is not None:
            result['HotTableName'] = self.hot_table_name
        if self.logic_table is not None:
            result['LogicTable'] = self.logic_table
        if self.tb_shard_value is not None:
            result['TbShardValue'] = self.tb_shard_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbShardValue') is not None:
            self.db_shard_value = m.get('DbShardValue')
        if m.get('HotDbName') is not None:
            self.hot_db_name = m.get('HotDbName')
        if m.get('HotTableName') is not None:
            self.hot_table_name = m.get('HotTableName')
        if m.get('LogicTable') is not None:
            self.logic_table = m.get('LogicTable')
        if m.get('TbShardValue') is not None:
            self.tb_shard_value = m.get('TbShardValue')
        return self


class DescribeSrcRdsListRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, partition_mapping=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.partition_mapping = partition_mapping  # type: list[DescribeSrcRdsListRequestPartitionMapping]

    def validate(self):
        if self.partition_mapping:
            for k in self.partition_mapping:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSrcRdsListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        result['PartitionMapping'] = []
        if self.partition_mapping is not None:
            for k in self.partition_mapping:
                result['PartitionMapping'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        self.partition_mapping = []
        if m.get('PartitionMapping') is not None:
            for k in m.get('PartitionMapping'):
                temp_model = DescribeSrcRdsListRequestPartitionMapping()
                self.partition_mapping.append(temp_model.from_map(k))
        return self


class DescribeSrcRdsListResponseBodyDataData(TeaModel):
    def __init__(self, db_name=None, rds=None):
        self.db_name = db_name  # type: str
        self.rds = rds  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeSrcRdsListResponseBodyDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.rds is not None:
            result['Rds'] = self.rds
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('Rds') is not None:
            self.rds = m.get('Rds')
        return self


class DescribeSrcRdsListResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[DescribeSrcRdsListResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeSrcRdsListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = DescribeSrcRdsListResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class DescribeSrcRdsListResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: DescribeSrcRdsListResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeSrcRdsListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeSrcRdsListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSrcRdsListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeSrcRdsListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeSrcRdsListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSrcRdsListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTableRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None, table_name=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.table_name = table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class DescribeTableResponseBodyDataList(TeaModel):
    def __init__(self, column_name=None, column_type=None, extra=None, index=None, is_allow_null=None, is_pk=None):
        self.column_name = column_name  # type: str
        self.column_type = column_type  # type: str
        self.extra = extra  # type: str
        self.index = index  # type: str
        self.is_allow_null = is_allow_null  # type: str
        self.is_pk = is_pk  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTableResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column_name is not None:
            result['ColumnName'] = self.column_name
        if self.column_type is not None:
            result['ColumnType'] = self.column_type
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.index is not None:
            result['Index'] = self.index
        if self.is_allow_null is not None:
            result['IsAllowNull'] = self.is_allow_null
        if self.is_pk is not None:
            result['IsPk'] = self.is_pk
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ColumnName') is not None:
            self.column_name = m.get('ColumnName')
        if m.get('ColumnType') is not None:
            self.column_type = m.get('ColumnType')
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('Index') is not None:
            self.index = m.get('Index')
        if m.get('IsAllowNull') is not None:
            self.is_allow_null = m.get('IsAllowNull')
        if m.get('IsPk') is not None:
            self.is_pk = m.get('IsPk')
        return self


class DescribeTableResponseBodyData(TeaModel):
    def __init__(self, list=None):
        self.list = list  # type: list[DescribeTableResponseBodyDataList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeTableResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeTableResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        return self


class DescribeTableResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: DescribeTableResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeTableResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTableListByTypeRequest(TeaModel):
    def __init__(self, current_page=None, db_name=None, drds_instance_id=None, page_size=None, query=None,
                 region_id=None, table_type=None):
        self.current_page = current_page  # type: int
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.query = query  # type: str
        self.region_id = region_id  # type: str
        self.table_type = table_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTableListByTypeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.table_type is not None:
            result['TableType'] = self.table_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TableType') is not None:
            self.table_type = m.get('TableType')
        return self


class DescribeTableListByTypeResponseBodyList(TeaModel):
    def __init__(self, property=None, table_name=None):
        self.property = property  # type: str
        self.table_name = table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTableListByTypeResponseBodyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.property is not None:
            result['Property'] = self.property
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Property') is not None:
            self.property = m.get('Property')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class DescribeTableListByTypeResponseBody(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, request_id=None, success=None, total=None):
        self.list = list  # type: list[DescribeTableListByTypeResponseBodyList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeTableListByTypeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeTableListByTypeResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeTableListByTypeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeTableListByTypeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeTableListByTypeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeTableListByTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTableShardingInfoRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None, table_name=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.table_name = table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTableShardingInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class DescribeTableShardingInfoResponseBodyDataColumnList(TeaModel):
    def __init__(self, name=None, type=None):
        self.name = name  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTableShardingInfoResponseBodyDataColumnList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeTableShardingInfoResponseBodyData(TeaModel):
    def __init__(self, column_list=None, db_compute_length=None, db_right_shift_offset=None,
                 db_sharding_column_list=None, db_sharding_function=None, is_shard=None, tb_compute_length=None, tb_partitions=None,
                 tb_right_shift_offset=None, tb_sharding_column_list=None, tb_sharding_function=None):
        self.column_list = column_list  # type: list[DescribeTableShardingInfoResponseBodyDataColumnList]
        self.db_compute_length = db_compute_length  # type: int
        self.db_right_shift_offset = db_right_shift_offset  # type: int
        self.db_sharding_column_list = db_sharding_column_list  # type: list[str]
        self.db_sharding_function = db_sharding_function  # type: str
        self.is_shard = is_shard  # type: bool
        self.tb_compute_length = tb_compute_length  # type: int
        self.tb_partitions = tb_partitions  # type: int
        self.tb_right_shift_offset = tb_right_shift_offset  # type: int
        self.tb_sharding_column_list = tb_sharding_column_list  # type: list[str]
        self.tb_sharding_function = tb_sharding_function  # type: str

    def validate(self):
        if self.column_list:
            for k in self.column_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeTableShardingInfoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ColumnList'] = []
        if self.column_list is not None:
            for k in self.column_list:
                result['ColumnList'].append(k.to_map() if k else None)
        if self.db_compute_length is not None:
            result['DbComputeLength'] = self.db_compute_length
        if self.db_right_shift_offset is not None:
            result['DbRightShiftOffset'] = self.db_right_shift_offset
        if self.db_sharding_column_list is not None:
            result['DbShardingColumnList'] = self.db_sharding_column_list
        if self.db_sharding_function is not None:
            result['DbShardingFunction'] = self.db_sharding_function
        if self.is_shard is not None:
            result['IsShard'] = self.is_shard
        if self.tb_compute_length is not None:
            result['TbComputeLength'] = self.tb_compute_length
        if self.tb_partitions is not None:
            result['TbPartitions'] = self.tb_partitions
        if self.tb_right_shift_offset is not None:
            result['TbRightShiftOffset'] = self.tb_right_shift_offset
        if self.tb_sharding_column_list is not None:
            result['TbShardingColumnList'] = self.tb_sharding_column_list
        if self.tb_sharding_function is not None:
            result['TbShardingFunction'] = self.tb_sharding_function
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.column_list = []
        if m.get('ColumnList') is not None:
            for k in m.get('ColumnList'):
                temp_model = DescribeTableShardingInfoResponseBodyDataColumnList()
                self.column_list.append(temp_model.from_map(k))
        if m.get('DbComputeLength') is not None:
            self.db_compute_length = m.get('DbComputeLength')
        if m.get('DbRightShiftOffset') is not None:
            self.db_right_shift_offset = m.get('DbRightShiftOffset')
        if m.get('DbShardingColumnList') is not None:
            self.db_sharding_column_list = m.get('DbShardingColumnList')
        if m.get('DbShardingFunction') is not None:
            self.db_sharding_function = m.get('DbShardingFunction')
        if m.get('IsShard') is not None:
            self.is_shard = m.get('IsShard')
        if m.get('TbComputeLength') is not None:
            self.tb_compute_length = m.get('TbComputeLength')
        if m.get('TbPartitions') is not None:
            self.tb_partitions = m.get('TbPartitions')
        if m.get('TbRightShiftOffset') is not None:
            self.tb_right_shift_offset = m.get('TbRightShiftOffset')
        if m.get('TbShardingColumnList') is not None:
            self.tb_sharding_column_list = m.get('TbShardingColumnList')
        if m.get('TbShardingFunction') is not None:
            self.tb_sharding_function = m.get('TbShardingFunction')
        return self


class DescribeTableShardingInfoResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: DescribeTableShardingInfoResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(DescribeTableShardingInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeTableShardingInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeTableShardingInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeTableShardingInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeTableShardingInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeTableShardingInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTablesRequest(TeaModel):
    def __init__(self, current_page=None, db_name=None, drds_instance_id=None, page_size=None, query=None,
                 region_id=None):
        self.current_page = current_page  # type: int
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.page_size = page_size  # type: int
        self.query = query  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTablesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeTablesResponseBodyList(TeaModel):
    def __init__(self, allow_full_table_scan=None, broadcast=None, db_inst_type=None, is_locked=None, is_shard=None,
                 shard_key=None, status=None, table=None):
        self.allow_full_table_scan = allow_full_table_scan  # type: bool
        self.broadcast = broadcast  # type: bool
        self.db_inst_type = db_inst_type  # type: int
        self.is_locked = is_locked  # type: bool
        self.is_shard = is_shard  # type: bool
        self.shard_key = shard_key  # type: str
        self.status = status  # type: int
        self.table = table  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTablesResponseBodyList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_full_table_scan is not None:
            result['AllowFullTableScan'] = self.allow_full_table_scan
        if self.broadcast is not None:
            result['Broadcast'] = self.broadcast
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.is_locked is not None:
            result['IsLocked'] = self.is_locked
        if self.is_shard is not None:
            result['IsShard'] = self.is_shard
        if self.shard_key is not None:
            result['ShardKey'] = self.shard_key
        if self.status is not None:
            result['Status'] = self.status
        if self.table is not None:
            result['Table'] = self.table
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllowFullTableScan') is not None:
            self.allow_full_table_scan = m.get('AllowFullTableScan')
        if m.get('Broadcast') is not None:
            self.broadcast = m.get('Broadcast')
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('IsLocked') is not None:
            self.is_locked = m.get('IsLocked')
        if m.get('IsShard') is not None:
            self.is_shard = m.get('IsShard')
        if m.get('ShardKey') is not None:
            self.shard_key = m.get('ShardKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Table') is not None:
            self.table = m.get('Table')
        return self


class DescribeTablesResponseBody(TeaModel):
    def __init__(self, list=None, page_number=None, page_size=None, request_id=None, success=None, total=None):
        self.list = list  # type: list[DescribeTablesResponseBodyList]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total = total  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeTablesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeTablesResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeTablesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DescribeTablesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeTablesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableSqlAuditRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableSqlAuditRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class DisableSqlAuditResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: bool
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableSqlAuditResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableSqlAuditResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: DisableSqlAuditResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisableSqlAuditResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableSqlAuditResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableInstanceIpv6AddressRequest(TeaModel):
    def __init__(self, drds_instance_id=None, region_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableInstanceIpv6AddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class EnableInstanceIpv6AddressResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableInstanceIpv6AddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableInstanceIpv6AddressResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: EnableInstanceIpv6AddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableInstanceIpv6AddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableInstanceIpv6AddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableSqlAuditRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, is_recall=None, recall_end_timestamp=None,
                 recall_start_timestamp=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.is_recall = is_recall  # type: bool
        self.recall_end_timestamp = recall_end_timestamp  # type: str
        self.recall_start_timestamp = recall_start_timestamp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableSqlAuditRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.is_recall is not None:
            result['IsRecall'] = self.is_recall
        if self.recall_end_timestamp is not None:
            result['RecallEndTimestamp'] = self.recall_end_timestamp
        if self.recall_start_timestamp is not None:
            result['RecallStartTimestamp'] = self.recall_start_timestamp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('IsRecall') is not None:
            self.is_recall = m.get('IsRecall')
        if m.get('RecallEndTimestamp') is not None:
            self.recall_end_timestamp = m.get('RecallEndTimestamp')
        if m.get('RecallStartTimestamp') is not None:
            self.recall_start_timestamp = m.get('RecallStartTimestamp')
        return self


class EnableSqlAuditResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: bool
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableSqlAuditResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableSqlAuditResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: EnableSqlAuditResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableSqlAuditResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableSqlAuditResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableSqlFlashbackMatchSwitchRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableSqlFlashbackMatchSwitchRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class EnableSqlFlashbackMatchSwitchResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: bool
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableSqlFlashbackMatchSwitchResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableSqlFlashbackMatchSwitchResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: EnableSqlFlashbackMatchSwitchResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableSqlFlashbackMatchSwitchResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableSqlFlashbackMatchSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FlashbackRecycleBinTableRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None, table_name=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.table_name = table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlashbackRecycleBinTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class FlashbackRecycleBinTableResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(FlashbackRecycleBinTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class FlashbackRecycleBinTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: FlashbackRecycleBinTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FlashbackRecycleBinTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = FlashbackRecycleBinTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBatchEvaluateTaskReportRequest(TeaModel):
    def __init__(self, batch_evaluate_task_id=None):
        self.batch_evaluate_task_id = batch_evaluate_task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBatchEvaluateTaskReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_evaluate_task_id is not None:
            result['BatchEvaluateTaskId'] = self.batch_evaluate_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BatchEvaluateTaskId') is not None:
            self.batch_evaluate_task_id = m.get('BatchEvaluateTaskId')
        return self


class GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfosRdsInstInfos(TeaModel):
    def __init__(self, avg_qps_growth_scale=None, data_growth_scale=None, inst_id=None, rds_peak_iops_weekly=None,
                 rds_peak_qps_weekly=None, rds_peak_sessions_weekly=None, rds_used_space=None):
        self.avg_qps_growth_scale = avg_qps_growth_scale  # type: int
        self.data_growth_scale = data_growth_scale  # type: int
        self.inst_id = inst_id  # type: str
        self.rds_peak_iops_weekly = rds_peak_iops_weekly  # type: int
        self.rds_peak_qps_weekly = rds_peak_qps_weekly  # type: int
        self.rds_peak_sessions_weekly = rds_peak_sessions_weekly  # type: int
        self.rds_used_space = rds_used_space  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfosRdsInstInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_qps_growth_scale is not None:
            result['AvgQpsGrowthScale'] = self.avg_qps_growth_scale
        if self.data_growth_scale is not None:
            result['DataGrowthScale'] = self.data_growth_scale
        if self.inst_id is not None:
            result['InstId'] = self.inst_id
        if self.rds_peak_iops_weekly is not None:
            result['RdsPeakIopsWeekly'] = self.rds_peak_iops_weekly
        if self.rds_peak_qps_weekly is not None:
            result['RdsPeakQpsWeekly'] = self.rds_peak_qps_weekly
        if self.rds_peak_sessions_weekly is not None:
            result['RdsPeakSessionsWeekly'] = self.rds_peak_sessions_weekly
        if self.rds_used_space is not None:
            result['RdsUsedSpace'] = self.rds_used_space
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvgQpsGrowthScale') is not None:
            self.avg_qps_growth_scale = m.get('AvgQpsGrowthScale')
        if m.get('DataGrowthScale') is not None:
            self.data_growth_scale = m.get('DataGrowthScale')
        if m.get('InstId') is not None:
            self.inst_id = m.get('InstId')
        if m.get('RdsPeakIopsWeekly') is not None:
            self.rds_peak_iops_weekly = m.get('RdsPeakIopsWeekly')
        if m.get('RdsPeakQpsWeekly') is not None:
            self.rds_peak_qps_weekly = m.get('RdsPeakQpsWeekly')
        if m.get('RdsPeakSessionsWeekly') is not None:
            self.rds_peak_sessions_weekly = m.get('RdsPeakSessionsWeekly')
        if m.get('RdsUsedSpace') is not None:
            self.rds_used_space = m.get('RdsUsedSpace')
        return self


class GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfos(TeaModel):
    def __init__(self, rds_inst_infos=None):
        self.rds_inst_infos = rds_inst_infos  # type: list[GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfosRdsInstInfos]

    def validate(self):
        if self.rds_inst_infos:
            for k in self.rds_inst_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RdsInstInfos'] = []
        if self.rds_inst_infos is not None:
            for k in self.rds_inst_infos:
                result['RdsInstInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rds_inst_infos = []
        if m.get('RdsInstInfos') is not None:
            for k in m.get('RdsInstInfos'):
                temp_model = GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfosRdsInstInfos()
                self.rds_inst_infos.append(temp_model.from_map(k))
        return self


class GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResultsTableShardResults(TeaModel):
    def __init__(self, create_table_sql=None, db_shard_key=None, dbpartitions=None, row_count=None,
                 shard_key_type=None, shard_type=None, sql_count=None, table=None, tb_shard_key=None, tbpartitions=None):
        self.create_table_sql = create_table_sql  # type: str
        self.db_shard_key = db_shard_key  # type: str
        self.dbpartitions = dbpartitions  # type: int
        self.row_count = row_count  # type: int
        self.shard_key_type = shard_key_type  # type: str
        self.shard_type = shard_type  # type: str
        self.sql_count = sql_count  # type: int
        self.table = table  # type: str
        self.tb_shard_key = tb_shard_key  # type: str
        self.tbpartitions = tbpartitions  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResultsTableShardResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_table_sql is not None:
            result['CreateTableSql'] = self.create_table_sql
        if self.db_shard_key is not None:
            result['DbShardKey'] = self.db_shard_key
        if self.dbpartitions is not None:
            result['Dbpartitions'] = self.dbpartitions
        if self.row_count is not None:
            result['RowCount'] = self.row_count
        if self.shard_key_type is not None:
            result['ShardKeyType'] = self.shard_key_type
        if self.shard_type is not None:
            result['ShardType'] = self.shard_type
        if self.sql_count is not None:
            result['SqlCount'] = self.sql_count
        if self.table is not None:
            result['Table'] = self.table
        if self.tb_shard_key is not None:
            result['TbShardKey'] = self.tb_shard_key
        if self.tbpartitions is not None:
            result['Tbpartitions'] = self.tbpartitions
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTableSql') is not None:
            self.create_table_sql = m.get('CreateTableSql')
        if m.get('DbShardKey') is not None:
            self.db_shard_key = m.get('DbShardKey')
        if m.get('Dbpartitions') is not None:
            self.dbpartitions = m.get('Dbpartitions')
        if m.get('RowCount') is not None:
            self.row_count = m.get('RowCount')
        if m.get('ShardKeyType') is not None:
            self.shard_key_type = m.get('ShardKeyType')
        if m.get('ShardType') is not None:
            self.shard_type = m.get('ShardType')
        if m.get('SqlCount') is not None:
            self.sql_count = m.get('SqlCount')
        if m.get('Table') is not None:
            self.table = m.get('Table')
        if m.get('TbShardKey') is not None:
            self.tb_shard_key = m.get('TbShardKey')
        if m.get('Tbpartitions') is not None:
            self.tbpartitions = m.get('Tbpartitions')
        return self


class GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResults(TeaModel):
    def __init__(self, table_shard_results=None):
        self.table_shard_results = table_shard_results  # type: list[GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResultsTableShardResults]

    def validate(self):
        if self.table_shard_results:
            for k in self.table_shard_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TableShardResults'] = []
        if self.table_shard_results is not None:
            for k in self.table_shard_results:
                result['TableShardResults'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.table_shard_results = []
        if m.get('TableShardResults') is not None:
            for k in m.get('TableShardResults'):
                temp_model = GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResultsTableShardResults()
                self.table_shard_results.append(temp_model.from_map(k))
        return self


class GetBatchEvaluateTaskReportResponseBodyDataEvaluateResults(TeaModel):
    def __init__(self, all_sql_count=None, db_name=None, drds_count=None, drds_type=None, gmt_create=None,
                 gmt_modified=None, inst_id=None, rds_count=None, rds_inst_infos=None, rds_total_space=None, rds_type=None,
                 slow_sql_count=None, table_shard_results=None, task_id=None, task_name=None, task_status=None):
        self.all_sql_count = all_sql_count  # type: int
        self.db_name = db_name  # type: str
        self.drds_count = drds_count  # type: int
        self.drds_type = drds_type  # type: str
        self.gmt_create = gmt_create  # type: str
        self.gmt_modified = gmt_modified  # type: str
        self.inst_id = inst_id  # type: int
        self.rds_count = rds_count  # type: int
        self.rds_inst_infos = rds_inst_infos  # type: GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfos
        self.rds_total_space = rds_total_space  # type: str
        self.rds_type = rds_type  # type: str
        self.slow_sql_count = slow_sql_count  # type: int
        self.table_shard_results = table_shard_results  # type: GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResults
        self.task_id = task_id  # type: int
        self.task_name = task_name  # type: str
        self.task_status = task_status  # type: str

    def validate(self):
        if self.rds_inst_infos:
            self.rds_inst_infos.validate()
        if self.table_shard_results:
            self.table_shard_results.validate()

    def to_map(self):
        _map = super(GetBatchEvaluateTaskReportResponseBodyDataEvaluateResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_sql_count is not None:
            result['AllSqlCount'] = self.all_sql_count
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_count is not None:
            result['DrdsCount'] = self.drds_count
        if self.drds_type is not None:
            result['DrdsType'] = self.drds_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.inst_id is not None:
            result['InstId'] = self.inst_id
        if self.rds_count is not None:
            result['RdsCount'] = self.rds_count
        if self.rds_inst_infos is not None:
            result['RdsInstInfos'] = self.rds_inst_infos.to_map()
        if self.rds_total_space is not None:
            result['RdsTotalSpace'] = self.rds_total_space
        if self.rds_type is not None:
            result['RdsType'] = self.rds_type
        if self.slow_sql_count is not None:
            result['SlowSqlCount'] = self.slow_sql_count
        if self.table_shard_results is not None:
            result['TableShardResults'] = self.table_shard_results.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllSqlCount') is not None:
            self.all_sql_count = m.get('AllSqlCount')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsCount') is not None:
            self.drds_count = m.get('DrdsCount')
        if m.get('DrdsType') is not None:
            self.drds_type = m.get('DrdsType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('InstId') is not None:
            self.inst_id = m.get('InstId')
        if m.get('RdsCount') is not None:
            self.rds_count = m.get('RdsCount')
        if m.get('RdsInstInfos') is not None:
            temp_model = GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsRdsInstInfos()
            self.rds_inst_infos = temp_model.from_map(m['RdsInstInfos'])
        if m.get('RdsTotalSpace') is not None:
            self.rds_total_space = m.get('RdsTotalSpace')
        if m.get('RdsType') is not None:
            self.rds_type = m.get('RdsType')
        if m.get('SlowSqlCount') is not None:
            self.slow_sql_count = m.get('SlowSqlCount')
        if m.get('TableShardResults') is not None:
            temp_model = GetBatchEvaluateTaskReportResponseBodyDataEvaluateResultsTableShardResults()
            self.table_shard_results = temp_model.from_map(m['TableShardResults'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class GetBatchEvaluateTaskReportResponseBodyData(TeaModel):
    def __init__(self, evaluate_results=None):
        self.evaluate_results = evaluate_results  # type: list[GetBatchEvaluateTaskReportResponseBodyDataEvaluateResults]

    def validate(self):
        if self.evaluate_results:
            for k in self.evaluate_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetBatchEvaluateTaskReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EvaluateResults'] = []
        if self.evaluate_results is not None:
            for k in self.evaluate_results:
                result['EvaluateResults'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.evaluate_results = []
        if m.get('EvaluateResults') is not None:
            for k in m.get('EvaluateResults'):
                temp_model = GetBatchEvaluateTaskReportResponseBodyDataEvaluateResults()
                self.evaluate_results.append(temp_model.from_map(k))
        return self


class GetBatchEvaluateTaskReportResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: GetBatchEvaluateTaskReportResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetBatchEvaluateTaskReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetBatchEvaluateTaskReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetBatchEvaluateTaskReportResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetBatchEvaluateTaskReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetBatchEvaluateTaskReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBatchEvaluateTaskReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDrdsDbRdsRelationInfoRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDrdsDbRdsRelationInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class GetDrdsDbRdsRelationInfoResponseBodyData(TeaModel):
    def __init__(self, rds_instance_id=None, read_only_instance_info=None, used_instance_id=None,
                 used_instance_type=None):
        self.rds_instance_id = rds_instance_id  # type: str
        self.read_only_instance_info = read_only_instance_info  # type: list[str]
        self.used_instance_id = used_instance_id  # type: str
        self.used_instance_type = used_instance_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDrdsDbRdsRelationInfoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rds_instance_id is not None:
            result['RdsInstanceId'] = self.rds_instance_id
        if self.read_only_instance_info is not None:
            result['ReadOnlyInstanceInfo'] = self.read_only_instance_info
        if self.used_instance_id is not None:
            result['UsedInstanceId'] = self.used_instance_id
        if self.used_instance_type is not None:
            result['UsedInstanceType'] = self.used_instance_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RdsInstanceId') is not None:
            self.rds_instance_id = m.get('RdsInstanceId')
        if m.get('ReadOnlyInstanceInfo') is not None:
            self.read_only_instance_info = m.get('ReadOnlyInstanceInfo')
        if m.get('UsedInstanceId') is not None:
            self.used_instance_id = m.get('UsedInstanceId')
        if m.get('UsedInstanceType') is not None:
            self.used_instance_type = m.get('UsedInstanceType')
        return self


class GetDrdsDbRdsRelationInfoResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: list[GetDrdsDbRdsRelationInfoResponseBodyData]
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDrdsDbRdsRelationInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetDrdsDbRdsRelationInfoResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDrdsDbRdsRelationInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: GetDrdsDbRdsRelationInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDrdsDbRdsRelationInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDrdsDbRdsRelationInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTagResourcesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTagResourcesRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListTagResourcesRequest(TeaModel):
    def __init__(self, next_token=None, region_id=None, resource_id=None, resource_type=None, tag=None):
        self.next_token = next_token  # type: str
        self.region_id = region_id  # type: str
        self.resource_id = resource_id  # type: list[str]
        self.resource_type = resource_type  # type: str
        self.tag = tag  # type: list[ListTagResourcesRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTagResourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListTagResourcesRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class ListTagResourcesResponseBodyTagResourcesTagResource(TeaModel):
    def __init__(self, resource_id=None, resource_type=None, tag_key=None, tag_value=None):
        self.resource_id = resource_id  # type: str
        self.resource_type = resource_type  # type: str
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTagResourcesResponseBodyTagResourcesTagResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListTagResourcesResponseBodyTagResources(TeaModel):
    def __init__(self, tag_resource=None):
        self.tag_resource = tag_resource  # type: list[ListTagResourcesResponseBodyTagResourcesTagResource]

    def validate(self):
        if self.tag_resource:
            for k in self.tag_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTagResourcesResponseBodyTagResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TagResource'] = []
        if self.tag_resource is not None:
            for k in self.tag_resource:
                result['TagResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag_resource = []
        if m.get('TagResource') is not None:
            for k in m.get('TagResource'):
                temp_model = ListTagResourcesResponseBodyTagResourcesTagResource()
                self.tag_resource.append(temp_model.from_map(k))
        return self


class ListTagResourcesResponseBody(TeaModel):
    def __init__(self, next_token=None, request_id=None, success=None, tag_resources=None):
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.tag_resources = tag_resources  # type: ListTagResourcesResponseBodyTagResources

    def validate(self):
        if self.tag_resources:
            self.tag_resources.validate()

    def to_map(self):
        _map = super(ListTagResourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.tag_resources is not None:
            result['TagResources'] = self.tag_resources.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TagResources') is not None:
            temp_model = ListTagResourcesResponseBodyTagResources()
            self.tag_resources = temp_model.from_map(m['TagResources'])
        return self


class ListTagResourcesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListTagResourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTagResourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUserReportsRequest(TeaModel):
    def __init__(self, drds_instance_id=None, report_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.report_id = report_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUserReportsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        return self


class ListUserReportsResponseBodySqlComparisonReportExecuteDetailListExecuteDetail(TeaModel):
    def __init__(self, db_name=None, exec_detail_msg=None, execute=None, sql_content=None):
        self.db_name = db_name  # type: str
        self.exec_detail_msg = exec_detail_msg  # type: str
        self.execute = execute  # type: str
        self.sql_content = sql_content  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListUserReportsResponseBodySqlComparisonReportExecuteDetailListExecuteDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.exec_detail_msg is not None:
            result['ExecDetailMsg'] = self.exec_detail_msg
        if self.execute is not None:
            result['Execute'] = self.execute
        if self.sql_content is not None:
            result['SqlContent'] = self.sql_content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('ExecDetailMsg') is not None:
            self.exec_detail_msg = m.get('ExecDetailMsg')
        if m.get('Execute') is not None:
            self.execute = m.get('Execute')
        if m.get('SqlContent') is not None:
            self.sql_content = m.get('SqlContent')
        return self


class ListUserReportsResponseBodySqlComparisonReportExecuteDetailList(TeaModel):
    def __init__(self, execute_detail=None):
        self.execute_detail = execute_detail  # type: list[ListUserReportsResponseBodySqlComparisonReportExecuteDetailListExecuteDetail]

    def validate(self):
        if self.execute_detail:
            for k in self.execute_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListUserReportsResponseBodySqlComparisonReportExecuteDetailList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['executeDetail'] = []
        if self.execute_detail is not None:
            for k in self.execute_detail:
                result['executeDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.execute_detail = []
        if m.get('executeDetail') is not None:
            for k in m.get('executeDetail'):
                temp_model = ListUserReportsResponseBodySqlComparisonReportExecuteDetailListExecuteDetail()
                self.execute_detail.append(temp_model.from_map(k))
        return self


class ListUserReportsResponseBodySqlComparisonReport(TeaModel):
    def __init__(self, sql_pass_fail_num=None, sql_pass_rate=None, sql_pass_succ_num=None, version=None,
                 execute_detail_list=None):
        self.sql_pass_fail_num = sql_pass_fail_num  # type: long
        self.sql_pass_rate = sql_pass_rate  # type: str
        self.sql_pass_succ_num = sql_pass_succ_num  # type: long
        self.version = version  # type: str
        self.execute_detail_list = execute_detail_list  # type: ListUserReportsResponseBodySqlComparisonReportExecuteDetailList

    def validate(self):
        if self.execute_detail_list:
            self.execute_detail_list.validate()

    def to_map(self):
        _map = super(ListUserReportsResponseBodySqlComparisonReport, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sql_pass_fail_num is not None:
            result['SqlPassFailNum'] = self.sql_pass_fail_num
        if self.sql_pass_rate is not None:
            result['SqlPassRate'] = self.sql_pass_rate
        if self.sql_pass_succ_num is not None:
            result['SqlPassSuccNum'] = self.sql_pass_succ_num
        if self.version is not None:
            result['Version'] = self.version
        if self.execute_detail_list is not None:
            result['executeDetailList'] = self.execute_detail_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SqlPassFailNum') is not None:
            self.sql_pass_fail_num = m.get('SqlPassFailNum')
        if m.get('SqlPassRate') is not None:
            self.sql_pass_rate = m.get('SqlPassRate')
        if m.get('SqlPassSuccNum') is not None:
            self.sql_pass_succ_num = m.get('SqlPassSuccNum')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('executeDetailList') is not None:
            temp_model = ListUserReportsResponseBodySqlComparisonReportExecuteDetailList()
            self.execute_detail_list = temp_model.from_map(m['executeDetailList'])
        return self


class ListUserReportsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, sql_comparison_report=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.sql_comparison_report = sql_comparison_report  # type: ListUserReportsResponseBodySqlComparisonReport

    def validate(self):
        if self.sql_comparison_report:
            self.sql_comparison_report.validate()

    def to_map(self):
        _map = super(ListUserReportsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.sql_comparison_report is not None:
            result['sqlComparisonReport'] = self.sql_comparison_report.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('sqlComparisonReport') is not None:
            temp_model = ListUserReportsResponseBodySqlComparisonReport()
            self.sql_comparison_report = temp_model.from_map(m['sqlComparisonReport'])
        return self


class ListUserReportsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListUserReportsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListUserReportsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListUserReportsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListVersionsRequest(TeaModel):
    def __init__(self, drds_instance_id=None, drds_ver=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.drds_ver = drds_ver  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListVersionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.drds_ver is not None:
            result['DrdsVer'] = self.drds_ver
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('DrdsVer') is not None:
            self.drds_ver = m.get('DrdsVer')
        return self


class ListVersionsResponseBodyVersionsVersions(TeaModel):
    def __init__(self, drds_version=None, latest=None):
        self.drds_version = drds_version  # type: str
        self.latest = latest  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListVersionsResponseBodyVersionsVersions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_version is not None:
            result['DrdsVersion'] = self.drds_version
        if self.latest is not None:
            result['Latest'] = self.latest
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsVersion') is not None:
            self.drds_version = m.get('DrdsVersion')
        if m.get('Latest') is not None:
            self.latest = m.get('Latest')
        return self


class ListVersionsResponseBodyVersions(TeaModel):
    def __init__(self, versions=None):
        self.versions = versions  # type: list[ListVersionsResponseBodyVersionsVersions]

    def validate(self):
        if self.versions:
            for k in self.versions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListVersionsResponseBodyVersions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['versions'] = []
        if self.versions is not None:
            for k in self.versions:
                result['versions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.versions = []
        if m.get('versions') is not None:
            for k in m.get('versions'):
                temp_model = ListVersionsResponseBodyVersionsVersions()
                self.versions.append(temp_model.from_map(k))
        return self


class ListVersionsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, versions=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.versions = versions  # type: ListVersionsResponseBodyVersions

    def validate(self):
        if self.versions:
            self.versions.validate()

    def to_map(self):
        _map = super(ListVersionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.versions is not None:
            result['versions'] = self.versions.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('versions') is not None:
            temp_model = ListVersionsResponseBodyVersions()
            self.versions = temp_model.from_map(m['versions'])
        return self


class ListVersionsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ListVersionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListVersionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListVersionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ManagePrivateRdsRequest(TeaModel):
    def __init__(self, dbinstance_id=None, drds_instance_id=None, params=None, rds_action=None, region_id=None):
        self.dbinstance_id = dbinstance_id  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.params = params  # type: str
        self.rds_action = rds_action  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ManagePrivateRdsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dbinstance_id is not None:
            result['DBInstanceId'] = self.dbinstance_id
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.params is not None:
            result['Params'] = self.params
        if self.rds_action is not None:
            result['RdsAction'] = self.rds_action
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DBInstanceId') is not None:
            self.dbinstance_id = m.get('DBInstanceId')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RdsAction') is not None:
            self.rds_action = m.get('RdsAction')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ManagePrivateRdsResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ManagePrivateRdsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ManagePrivateRdsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ManagePrivateRdsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ManagePrivateRdsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ManagePrivateRdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyAccountDescriptionRequest(TeaModel):
    def __init__(self, account_name=None, description=None, drds_instance_id=None):
        self.account_name = account_name  # type: str
        self.description = description  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyAccountDescriptionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.description is not None:
            result['Description'] = self.description
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class ModifyAccountDescriptionResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyAccountDescriptionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ModifyAccountDescriptionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyAccountDescriptionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyAccountDescriptionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyAccountDescriptionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyAccountPrivilegeRequestDbPrivilege(TeaModel):
    def __init__(self, db_name=None, privilege=None):
        self.db_name = db_name  # type: str
        self.privilege = privilege  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyAccountPrivilegeRequestDbPrivilege, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.privilege is not None:
            result['Privilege'] = self.privilege
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('Privilege') is not None:
            self.privilege = m.get('Privilege')
        return self


class ModifyAccountPrivilegeRequest(TeaModel):
    def __init__(self, account_name=None, db_privilege=None, drds_instance_id=None, region_id=None):
        self.account_name = account_name  # type: str
        self.db_privilege = db_privilege  # type: list[ModifyAccountPrivilegeRequestDbPrivilege]
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        if self.db_privilege:
            for k in self.db_privilege:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ModifyAccountPrivilegeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        result['DbPrivilege'] = []
        if self.db_privilege is not None:
            for k in self.db_privilege:
                result['DbPrivilege'].append(k.to_map() if k else None)
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        self.db_privilege = []
        if m.get('DbPrivilege') is not None:
            for k in m.get('DbPrivilege'):
                temp_model = ModifyAccountPrivilegeRequestDbPrivilege()
                self.db_privilege.append(temp_model.from_map(k))
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ModifyAccountPrivilegeResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyAccountPrivilegeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ModifyAccountPrivilegeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyAccountPrivilegeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyAccountPrivilegeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyAccountPrivilegeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyDrdsInstanceDescriptionRequest(TeaModel):
    def __init__(self, description=None, drds_instance_id=None):
        self.description = description  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyDrdsInstanceDescriptionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class ModifyDrdsInstanceDescriptionResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyDrdsInstanceDescriptionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ModifyDrdsInstanceDescriptionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyDrdsInstanceDescriptionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyDrdsInstanceDescriptionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyDrdsInstanceDescriptionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyDrdsIpWhiteListRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, group_attribute=None, group_name=None,
                 ip_white_list=None, mode=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.group_attribute = group_attribute  # type: str
        self.group_name = group_name  # type: str
        self.ip_white_list = ip_white_list  # type: str
        self.mode = mode  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyDrdsIpWhiteListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.group_attribute is not None:
            result['GroupAttribute'] = self.group_attribute
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.ip_white_list is not None:
            result['IpWhiteList'] = self.ip_white_list
        if self.mode is not None:
            result['Mode'] = self.mode
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('GroupAttribute') is not None:
            self.group_attribute = m.get('GroupAttribute')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IpWhiteList') is not None:
            self.ip_white_list = m.get('IpWhiteList')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        return self


class ModifyDrdsIpWhiteListResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyDrdsIpWhiteListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ModifyDrdsIpWhiteListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyDrdsIpWhiteListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyDrdsIpWhiteListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyDrdsIpWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyEventTaskStatusRequest(TeaModel):
    def __init__(self, event_id=None, ids=None, region=None, switch_time=None):
        self.event_id = event_id  # type: str
        self.ids = ids  # type: str
        self.region = region  # type: str
        self.switch_time = switch_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyEventTaskStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.region is not None:
            result['Region'] = self.region
        if self.switch_time is not None:
            result['SwitchTime'] = self.switch_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SwitchTime') is not None:
            self.switch_time = m.get('SwitchTime')
        return self


class ModifyEventTaskStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyEventTaskStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ModifyEventTaskStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyEventTaskStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyEventTaskStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyEventTaskStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyPolarDbReadWeightRequest(TeaModel):
    def __init__(self, db_instance_id=None, db_name=None, db_node_ids=None, drds_instance_id=None, weights=None):
        self.db_instance_id = db_instance_id  # type: str
        self.db_name = db_name  # type: str
        self.db_node_ids = db_node_ids  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.weights = weights  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyPolarDbReadWeightRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.db_node_ids is not None:
            result['DbNodeIds'] = self.db_node_ids
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.weights is not None:
            result['Weights'] = self.weights
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DbNodeIds') is not None:
            self.db_node_ids = m.get('DbNodeIds')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('Weights') is not None:
            self.weights = m.get('Weights')
        return self


class ModifyPolarDbReadWeightResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyPolarDbReadWeightResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ModifyPolarDbReadWeightResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyPolarDbReadWeightResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyPolarDbReadWeightResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyPolarDbReadWeightResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyRdsReadWeightRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, instance_names=None, weights=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.instance_names = instance_names  # type: str
        self.weights = weights  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyRdsReadWeightRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.instance_names is not None:
            result['InstanceNames'] = self.instance_names
        if self.weights is not None:
            result['Weights'] = self.weights
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('InstanceNames') is not None:
            self.instance_names = m.get('InstanceNames')
        if m.get('Weights') is not None:
            self.weights = m.get('Weights')
        return self


class ModifyRdsReadWeightResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ModifyRdsReadWeightResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ModifyRdsReadWeightResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ModifyRdsReadWeightResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ModifyRdsReadWeightResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyRdsReadWeightResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MyCatConnectTestRequest(TeaModel):
    def __init__(self, db_name=None, region_id=None, rule_url=None, schema_url=None):
        self.db_name = db_name  # type: str
        self.region_id = region_id  # type: str
        self.rule_url = rule_url  # type: str
        self.schema_url = schema_url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MyCatConnectTestRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_url is not None:
            result['RuleUrl'] = self.rule_url
        if self.schema_url is not None:
            result['SchemaUrl'] = self.schema_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleUrl') is not None:
            self.rule_url = m.get('RuleUrl')
        if m.get('SchemaUrl') is not None:
            self.schema_url = m.get('SchemaUrl')
        return self


class MyCatConnectTestResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(MyCatConnectTestResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class MyCatConnectTestResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: MyCatConnectTestResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(MyCatConnectTestResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = MyCatConnectTestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MyCatCustomImportPreCheckRequest(TeaModel):
    def __init__(self, dst_db_nme=None, dst_drds_instance_id=None, dst_port=None, dst_pwd=None, dst_user=None,
                 import_db=None, region_id=None, rule_url=None, schema_url=None, table_map=None, task_name=None):
        self.dst_db_nme = dst_db_nme  # type: str
        self.dst_drds_instance_id = dst_drds_instance_id  # type: str
        self.dst_port = dst_port  # type: int
        self.dst_pwd = dst_pwd  # type: str
        self.dst_user = dst_user  # type: str
        self.import_db = import_db  # type: str
        self.region_id = region_id  # type: str
        self.rule_url = rule_url  # type: str
        self.schema_url = schema_url  # type: str
        self.table_map = table_map  # type: dict[str, any]
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MyCatCustomImportPreCheckRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_db_nme is not None:
            result['DstDbNme'] = self.dst_db_nme
        if self.dst_drds_instance_id is not None:
            result['DstDrdsInstanceId'] = self.dst_drds_instance_id
        if self.dst_port is not None:
            result['DstPort'] = self.dst_port
        if self.dst_pwd is not None:
            result['DstPwd'] = self.dst_pwd
        if self.dst_user is not None:
            result['DstUser'] = self.dst_user
        if self.import_db is not None:
            result['ImportDb'] = self.import_db
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_url is not None:
            result['RuleUrl'] = self.rule_url
        if self.schema_url is not None:
            result['SchemaUrl'] = self.schema_url
        if self.table_map is not None:
            result['TableMap'] = self.table_map
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstDbNme') is not None:
            self.dst_db_nme = m.get('DstDbNme')
        if m.get('DstDrdsInstanceId') is not None:
            self.dst_drds_instance_id = m.get('DstDrdsInstanceId')
        if m.get('DstPort') is not None:
            self.dst_port = m.get('DstPort')
        if m.get('DstPwd') is not None:
            self.dst_pwd = m.get('DstPwd')
        if m.get('DstUser') is not None:
            self.dst_user = m.get('DstUser')
        if m.get('ImportDb') is not None:
            self.import_db = m.get('ImportDb')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleUrl') is not None:
            self.rule_url = m.get('RuleUrl')
        if m.get('SchemaUrl') is not None:
            self.schema_url = m.get('SchemaUrl')
        if m.get('TableMap') is not None:
            self.table_map = m.get('TableMap')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class MyCatCustomImportPreCheckShrinkRequest(TeaModel):
    def __init__(self, dst_db_nme=None, dst_drds_instance_id=None, dst_port=None, dst_pwd=None, dst_user=None,
                 import_db=None, region_id=None, rule_url=None, schema_url=None, table_map_shrink=None, task_name=None):
        self.dst_db_nme = dst_db_nme  # type: str
        self.dst_drds_instance_id = dst_drds_instance_id  # type: str
        self.dst_port = dst_port  # type: int
        self.dst_pwd = dst_pwd  # type: str
        self.dst_user = dst_user  # type: str
        self.import_db = import_db  # type: str
        self.region_id = region_id  # type: str
        self.rule_url = rule_url  # type: str
        self.schema_url = schema_url  # type: str
        self.table_map_shrink = table_map_shrink  # type: str
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MyCatCustomImportPreCheckShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_db_nme is not None:
            result['DstDbNme'] = self.dst_db_nme
        if self.dst_drds_instance_id is not None:
            result['DstDrdsInstanceId'] = self.dst_drds_instance_id
        if self.dst_port is not None:
            result['DstPort'] = self.dst_port
        if self.dst_pwd is not None:
            result['DstPwd'] = self.dst_pwd
        if self.dst_user is not None:
            result['DstUser'] = self.dst_user
        if self.import_db is not None:
            result['ImportDb'] = self.import_db
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_url is not None:
            result['RuleUrl'] = self.rule_url
        if self.schema_url is not None:
            result['SchemaUrl'] = self.schema_url
        if self.table_map_shrink is not None:
            result['TableMap'] = self.table_map_shrink
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstDbNme') is not None:
            self.dst_db_nme = m.get('DstDbNme')
        if m.get('DstDrdsInstanceId') is not None:
            self.dst_drds_instance_id = m.get('DstDrdsInstanceId')
        if m.get('DstPort') is not None:
            self.dst_port = m.get('DstPort')
        if m.get('DstPwd') is not None:
            self.dst_pwd = m.get('DstPwd')
        if m.get('DstUser') is not None:
            self.dst_user = m.get('DstUser')
        if m.get('ImportDb') is not None:
            self.import_db = m.get('ImportDb')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleUrl') is not None:
            self.rule_url = m.get('RuleUrl')
        if m.get('SchemaUrl') is not None:
            self.schema_url = m.get('SchemaUrl')
        if m.get('TableMap') is not None:
            self.table_map_shrink = m.get('TableMap')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class MyCatCustomImportPreCheckResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(MyCatCustomImportPreCheckResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class MyCatCustomImportPreCheckResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: MyCatCustomImportPreCheckResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(MyCatCustomImportPreCheckResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = MyCatCustomImportPreCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PreCheckModifyTableShardingKeyParamRequest(TeaModel):
    def __init__(self, db_compute_length=None, db_name=None, db_right_shift_offset=None,
                 db_sharding_column_list=None, db_sharding_function=None, drds_instance_id=None, is_shard=None, region_id=None,
                 src_table_name=None, target_table_name=None, tb_compute_length=None, tb_partitions=None,
                 tb_right_shift_offset=None, tb_sharding_column_list=None, tb_sharding_function=None):
        self.db_compute_length = db_compute_length  # type: str
        self.db_name = db_name  # type: str
        self.db_right_shift_offset = db_right_shift_offset  # type: int
        self.db_sharding_column_list = db_sharding_column_list  # type: str
        self.db_sharding_function = db_sharding_function  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.is_shard = is_shard  # type: bool
        self.region_id = region_id  # type: str
        self.src_table_name = src_table_name  # type: str
        self.target_table_name = target_table_name  # type: str
        self.tb_compute_length = tb_compute_length  # type: str
        self.tb_partitions = tb_partitions  # type: str
        self.tb_right_shift_offset = tb_right_shift_offset  # type: str
        self.tb_sharding_column_list = tb_sharding_column_list  # type: str
        self.tb_sharding_function = tb_sharding_function  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PreCheckModifyTableShardingKeyParamRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_compute_length is not None:
            result['DbComputeLength'] = self.db_compute_length
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.db_right_shift_offset is not None:
            result['DbRightShiftOffset'] = self.db_right_shift_offset
        if self.db_sharding_column_list is not None:
            result['DbShardingColumnList'] = self.db_sharding_column_list
        if self.db_sharding_function is not None:
            result['DbShardingFunction'] = self.db_sharding_function
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.is_shard is not None:
            result['IsShard'] = self.is_shard
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.src_table_name is not None:
            result['SrcTableName'] = self.src_table_name
        if self.target_table_name is not None:
            result['TargetTableName'] = self.target_table_name
        if self.tb_compute_length is not None:
            result['TbComputeLength'] = self.tb_compute_length
        if self.tb_partitions is not None:
            result['TbPartitions'] = self.tb_partitions
        if self.tb_right_shift_offset is not None:
            result['TbRightShiftOffset'] = self.tb_right_shift_offset
        if self.tb_sharding_column_list is not None:
            result['TbShardingColumnList'] = self.tb_sharding_column_list
        if self.tb_sharding_function is not None:
            result['TbShardingFunction'] = self.tb_sharding_function
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbComputeLength') is not None:
            self.db_compute_length = m.get('DbComputeLength')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DbRightShiftOffset') is not None:
            self.db_right_shift_offset = m.get('DbRightShiftOffset')
        if m.get('DbShardingColumnList') is not None:
            self.db_sharding_column_list = m.get('DbShardingColumnList')
        if m.get('DbShardingFunction') is not None:
            self.db_sharding_function = m.get('DbShardingFunction')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('IsShard') is not None:
            self.is_shard = m.get('IsShard')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SrcTableName') is not None:
            self.src_table_name = m.get('SrcTableName')
        if m.get('TargetTableName') is not None:
            self.target_table_name = m.get('TargetTableName')
        if m.get('TbComputeLength') is not None:
            self.tb_compute_length = m.get('TbComputeLength')
        if m.get('TbPartitions') is not None:
            self.tb_partitions = m.get('TbPartitions')
        if m.get('TbRightShiftOffset') is not None:
            self.tb_right_shift_offset = m.get('TbRightShiftOffset')
        if m.get('TbShardingColumnList') is not None:
            self.tb_sharding_column_list = m.get('TbShardingColumnList')
        if m.get('TbShardingFunction') is not None:
            self.tb_sharding_function = m.get('TbShardingFunction')
        return self


class PreCheckModifyTableShardingKeyParamResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(PreCheckModifyTableShardingKeyParamResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class PreCheckModifyTableShardingKeyParamResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PreCheckModifyTableShardingKeyParamResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PreCheckModifyTableShardingKeyParamResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PreCheckModifyTableShardingKeyParamResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PreCheckSqlFlashbackTaskRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, end_time=None, start_time=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.end_time = end_time  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PreCheckSqlFlashbackTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class PreCheckSqlFlashbackTaskResponseBodyCheckResult(TeaModel):
    def __init__(self, binlog_exists=None, binlog_row_query_event_enabled=None,
                 can_upgrade_support_binlog_row_query_events=None, has_table=None, support_binlog_row_query_events=None):
        self.binlog_exists = binlog_exists  # type: bool
        self.binlog_row_query_event_enabled = binlog_row_query_event_enabled  # type: bool
        self.can_upgrade_support_binlog_row_query_events = can_upgrade_support_binlog_row_query_events  # type: bool
        self.has_table = has_table  # type: bool
        self.support_binlog_row_query_events = support_binlog_row_query_events  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(PreCheckSqlFlashbackTaskResponseBodyCheckResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.binlog_exists is not None:
            result['BinlogExists'] = self.binlog_exists
        if self.binlog_row_query_event_enabled is not None:
            result['BinlogRowQueryEventEnabled'] = self.binlog_row_query_event_enabled
        if self.can_upgrade_support_binlog_row_query_events is not None:
            result['CanUpgradeSupportBinlogRowQueryEvents'] = self.can_upgrade_support_binlog_row_query_events
        if self.has_table is not None:
            result['HasTable'] = self.has_table
        if self.support_binlog_row_query_events is not None:
            result['SupportBinlogRowQueryEvents'] = self.support_binlog_row_query_events
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BinlogExists') is not None:
            self.binlog_exists = m.get('BinlogExists')
        if m.get('BinlogRowQueryEventEnabled') is not None:
            self.binlog_row_query_event_enabled = m.get('BinlogRowQueryEventEnabled')
        if m.get('CanUpgradeSupportBinlogRowQueryEvents') is not None:
            self.can_upgrade_support_binlog_row_query_events = m.get('CanUpgradeSupportBinlogRowQueryEvents')
        if m.get('HasTable') is not None:
            self.has_table = m.get('HasTable')
        if m.get('SupportBinlogRowQueryEvents') is not None:
            self.support_binlog_row_query_events = m.get('SupportBinlogRowQueryEvents')
        return self


class PreCheckSqlFlashbackTaskResponseBody(TeaModel):
    def __init__(self, check_result=None, request_id=None, success=None):
        self.check_result = check_result  # type: PreCheckSqlFlashbackTaskResponseBodyCheckResult
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.check_result:
            self.check_result.validate()

    def to_map(self):
        _map = super(PreCheckSqlFlashbackTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_result is not None:
            result['CheckResult'] = self.check_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckResult') is not None:
            temp_model = PreCheckSqlFlashbackTaskResponseBodyCheckResult()
            self.check_result = temp_model.from_map(m['CheckResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class PreCheckSqlFlashbackTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PreCheckSqlFlashbackTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PreCheckSqlFlashbackTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PreCheckSqlFlashbackTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PrecheckMyCatEvaluateRequest(TeaModel):
    def __init__(self, bus_peak_qps=None, capacity_inc_percent=None, import_db_list=None, qps_inc_percent=None,
                 region_id=None, rule_url=None, schema_url=None, sequence_type=None, server_url=None, task_name=None):
        self.bus_peak_qps = bus_peak_qps  # type: long
        self.capacity_inc_percent = capacity_inc_percent  # type: int
        self.import_db_list = import_db_list  # type: list[str]
        self.qps_inc_percent = qps_inc_percent  # type: int
        self.region_id = region_id  # type: str
        self.rule_url = rule_url  # type: str
        self.schema_url = schema_url  # type: str
        self.sequence_type = sequence_type  # type: int
        self.server_url = server_url  # type: str
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PrecheckMyCatEvaluateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bus_peak_qps is not None:
            result['BusPeakQps'] = self.bus_peak_qps
        if self.capacity_inc_percent is not None:
            result['CapacityIncPercent'] = self.capacity_inc_percent
        if self.import_db_list is not None:
            result['ImportDbList'] = self.import_db_list
        if self.qps_inc_percent is not None:
            result['QpsIncPercent'] = self.qps_inc_percent
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_url is not None:
            result['RuleUrl'] = self.rule_url
        if self.schema_url is not None:
            result['SchemaUrl'] = self.schema_url
        if self.sequence_type is not None:
            result['SequenceType'] = self.sequence_type
        if self.server_url is not None:
            result['ServerUrl'] = self.server_url
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusPeakQps') is not None:
            self.bus_peak_qps = m.get('BusPeakQps')
        if m.get('CapacityIncPercent') is not None:
            self.capacity_inc_percent = m.get('CapacityIncPercent')
        if m.get('ImportDbList') is not None:
            self.import_db_list = m.get('ImportDbList')
        if m.get('QpsIncPercent') is not None:
            self.qps_inc_percent = m.get('QpsIncPercent')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleUrl') is not None:
            self.rule_url = m.get('RuleUrl')
        if m.get('SchemaUrl') is not None:
            self.schema_url = m.get('SchemaUrl')
        if m.get('SequenceType') is not None:
            self.sequence_type = m.get('SequenceType')
        if m.get('ServerUrl') is not None:
            self.server_url = m.get('ServerUrl')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class PrecheckMyCatEvaluateResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(PrecheckMyCatEvaluateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class PrecheckMyCatEvaluateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PrecheckMyCatEvaluateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PrecheckMyCatEvaluateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PrecheckMyCatEvaluateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PutRestorePreCheckRequest(TeaModel):
    def __init__(self, backup_db_names=None, backup_id=None, backup_level=None, backup_mode=None,
                 drds_instance_id=None, preferred_backup_time=None):
        self.backup_db_names = backup_db_names  # type: str
        self.backup_id = backup_id  # type: str
        self.backup_level = backup_level  # type: str
        self.backup_mode = backup_mode  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.preferred_backup_time = preferred_backup_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PutRestorePreCheckRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_db_names is not None:
            result['BackupDbNames'] = self.backup_db_names
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_level is not None:
            result['BackupLevel'] = self.backup_level
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.preferred_backup_time is not None:
            result['PreferredBackupTime'] = self.preferred_backup_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupDbNames') is not None:
            self.backup_db_names = m.get('BackupDbNames')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupLevel') is not None:
            self.backup_level = m.get('BackupLevel')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PreferredBackupTime') is not None:
            self.preferred_backup_time = m.get('PreferredBackupTime')
        return self


class PutRestorePreCheckResponseBodyPrecheckBackupResultListList(TeaModel):
    def __init__(self, check_fail_reason=None, check_item_content=None, check_item_name=None, check_result=None,
                 item_id=None, result=None):
        self.check_fail_reason = check_fail_reason  # type: str
        self.check_item_content = check_item_content  # type: str
        self.check_item_name = check_item_name  # type: str
        self.check_result = check_result  # type: str
        self.item_id = item_id  # type: long
        self.result = result  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(PutRestorePreCheckResponseBodyPrecheckBackupResultListList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_fail_reason is not None:
            result['CheckFailReason'] = self.check_fail_reason
        if self.check_item_content is not None:
            result['CheckItemContent'] = self.check_item_content
        if self.check_item_name is not None:
            result['CheckItemName'] = self.check_item_name
        if self.check_result is not None:
            result['CheckResult'] = self.check_result
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckFailReason') is not None:
            self.check_fail_reason = m.get('CheckFailReason')
        if m.get('CheckItemContent') is not None:
            self.check_item_content = m.get('CheckItemContent')
        if m.get('CheckItemName') is not None:
            self.check_item_name = m.get('CheckItemName')
        if m.get('CheckResult') is not None:
            self.check_result = m.get('CheckResult')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class PutRestorePreCheckResponseBodyPrecheckBackupResultList(TeaModel):
    def __init__(self, list=None):
        self.list = list  # type: list[PutRestorePreCheckResponseBodyPrecheckBackupResultListList]

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(PutRestorePreCheckResponseBodyPrecheckBackupResultList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = PutRestorePreCheckResponseBodyPrecheckBackupResultListList()
                self.list.append(temp_model.from_map(k))
        return self


class PutRestorePreCheckResponseBodyPrecheckBackupResult(TeaModel):
    def __init__(self, list=None, result=None):
        self.list = list  # type: PutRestorePreCheckResponseBodyPrecheckBackupResultList
        self.result = result  # type: bool

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        _map = super(PutRestorePreCheckResponseBodyPrecheckBackupResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = PutRestorePreCheckResponseBodyPrecheckBackupResultList()
            self.list = temp_model.from_map(m['List'])
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class PutRestorePreCheckResponseBody(TeaModel):
    def __init__(self, precheck_backup_result=None, request_id=None, success=None):
        self.precheck_backup_result = precheck_backup_result  # type: PutRestorePreCheckResponseBodyPrecheckBackupResult
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.precheck_backup_result:
            self.precheck_backup_result.validate()

    def to_map(self):
        _map = super(PutRestorePreCheckResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.precheck_backup_result is not None:
            result['PrecheckBackupResult'] = self.precheck_backup_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrecheckBackupResult') is not None:
            temp_model = PutRestorePreCheckResponseBodyPrecheckBackupResult()
            self.precheck_backup_result = temp_model.from_map(m['PrecheckBackupResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class PutRestorePreCheckResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PutRestorePreCheckResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PutRestorePreCheckResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PutRestorePreCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PutStartBackupRequest(TeaModel):
    def __init__(self, backup_db_names=None, backup_level=None, backup_mode=None, drds_instance_id=None):
        self.backup_db_names = backup_db_names  # type: str
        self.backup_level = backup_level  # type: str
        self.backup_mode = backup_mode  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(PutStartBackupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_db_names is not None:
            result['BackupDbNames'] = self.backup_db_names
        if self.backup_level is not None:
            result['BackupLevel'] = self.backup_level
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupDbNames') is not None:
            self.backup_db_names = m.get('BackupDbNames')
        if m.get('BackupLevel') is not None:
            self.backup_level = m.get('BackupLevel')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class PutStartBackupResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(PutStartBackupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class PutStartBackupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: PutStartBackupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(PutStartBackupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PutStartBackupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RearrangeDbToInstanceRequest(TeaModel):
    def __init__(self, choose_rds=None, choose_sub_db=None, db_name=None, drds_instance_id=None, instance_list=None,
                 order_id=None):
        self.choose_rds = choose_rds  # type: str
        self.choose_sub_db = choose_sub_db  # type: str
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.instance_list = instance_list  # type: list[str]
        self.order_id = order_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RearrangeDbToInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.choose_rds is not None:
            result['ChooseRds'] = self.choose_rds
        if self.choose_sub_db is not None:
            result['ChooseSubDb'] = self.choose_sub_db
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.instance_list is not None:
            result['InstanceList'] = self.instance_list
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChooseRds') is not None:
            self.choose_rds = m.get('ChooseRds')
        if m.get('ChooseSubDb') is not None:
            self.choose_sub_db = m.get('ChooseSubDb')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('InstanceList') is not None:
            self.instance_list = m.get('InstanceList')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class RearrangeDbToInstanceResponseBodyDataData(TeaModel):
    def __init__(self, dst_instance=None, src_db_name=None, src_instance=None):
        self.dst_instance = dst_instance  # type: str
        self.src_db_name = src_db_name  # type: str
        self.src_instance = src_instance  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RearrangeDbToInstanceResponseBodyDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_instance is not None:
            result['DstInstance'] = self.dst_instance
        if self.src_db_name is not None:
            result['SrcDbName'] = self.src_db_name
        if self.src_instance is not None:
            result['SrcInstance'] = self.src_instance
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstInstance') is not None:
            self.dst_instance = m.get('DstInstance')
        if m.get('SrcDbName') is not None:
            self.src_db_name = m.get('SrcDbName')
        if m.get('SrcInstance') is not None:
            self.src_instance = m.get('SrcInstance')
        return self


class RearrangeDbToInstanceResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[RearrangeDbToInstanceResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(RearrangeDbToInstanceResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = RearrangeDbToInstanceResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class RearrangeDbToInstanceResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: RearrangeDbToInstanceResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(RearrangeDbToInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = RearrangeDbToInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RearrangeDbToInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RearrangeDbToInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RearrangeDbToInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RearrangeDbToInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RefreshDrdsAtomUrlRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RefreshDrdsAtomUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class RefreshDrdsAtomUrlResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: bool
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RefreshDrdsAtomUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RefreshDrdsAtomUrlResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RefreshDrdsAtomUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RefreshDrdsAtomUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RefreshDrdsAtomUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReleaseInstanceInternetAddressRequest(TeaModel):
    def __init__(self, drds_instance_id=None, region_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ReleaseInstanceInternetAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ReleaseInstanceInternetAddressResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ReleaseInstanceInternetAddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ReleaseInstanceInternetAddressResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: ReleaseInstanceInternetAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ReleaseInstanceInternetAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReleaseInstanceInternetAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveBackupsSetRequest(TeaModel):
    def __init__(self, backup_id=None, drds_instance_id=None):
        self.backup_id = backup_id  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveBackupsSetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class RemoveBackupsSetResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveBackupsSetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveBackupsSetResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveBackupsSetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveBackupsSetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveBackupsSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveDataExportTaskRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDataExportTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class RemoveDataExportTaskResponseBodyTaskManageResult(TeaModel):
    def __init__(self, message=None, success=None):
        self.message = message  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDataExportTaskResponseBodyTaskManageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveDataExportTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_manage_result=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_manage_result = task_manage_result  # type: RemoveDataExportTaskResponseBodyTaskManageResult

    def validate(self):
        if self.task_manage_result:
            self.task_manage_result.validate()

    def to_map(self):
        _map = super(RemoveDataExportTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_manage_result is not None:
            result['TaskManageResult'] = self.task_manage_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskManageResult') is not None:
            temp_model = RemoveDataExportTaskResponseBodyTaskManageResult()
            self.task_manage_result = temp_model.from_map(m['TaskManageResult'])
        return self


class RemoveDataExportTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveDataExportTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveDataExportTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveDataExportTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveDataImportTaskRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDataImportTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class RemoveDataImportTaskResponseBodyTaskManageResult(TeaModel):
    def __init__(self, message=None, success=None):
        self.message = message  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDataImportTaskResponseBodyTaskManageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveDataImportTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_manage_result=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_manage_result = task_manage_result  # type: RemoveDataImportTaskResponseBodyTaskManageResult

    def validate(self):
        if self.task_manage_result:
            self.task_manage_result.validate()

    def to_map(self):
        _map = super(RemoveDataImportTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_manage_result is not None:
            result['TaskManageResult'] = self.task_manage_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskManageResult') is not None:
            temp_model = RemoveDataImportTaskResponseBodyTaskManageResult()
            self.task_manage_result = temp_model.from_map(m['TaskManageResult'])
        return self


class RemoveDataImportTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveDataImportTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveDataImportTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveDataImportTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveDrdsDbRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDrdsDbRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class RemoveDrdsDbResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDrdsDbResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveDrdsDbResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveDrdsDbResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveDrdsDbResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveDrdsDbResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveDrdsDbFailedRecordRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDrdsDbFailedRecordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class RemoveDrdsDbFailedRecordResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: bool
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDrdsDbFailedRecordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveDrdsDbFailedRecordResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveDrdsDbFailedRecordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveDrdsDbFailedRecordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveDrdsDbFailedRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveDrdsInstanceRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDrdsInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class RemoveDrdsInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDrdsInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveDrdsInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveDrdsInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveDrdsInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveDrdsInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveDrdsMysqlRequest(TeaModel):
    def __init__(self, db_instance_id=None, db_name=None, drds_instance_id=None, force=None, ro_db_instance_id=None):
        self.db_instance_id = db_instance_id  # type: str
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.force = force  # type: bool
        self.ro_db_instance_id = ro_db_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDrdsMysqlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance_id is not None:
            result['DbInstanceId'] = self.db_instance_id
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.force is not None:
            result['Force'] = self.force
        if self.ro_db_instance_id is not None:
            result['RoDbInstanceId'] = self.ro_db_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstanceId') is not None:
            self.db_instance_id = m.get('DbInstanceId')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('RoDbInstanceId') is not None:
            self.ro_db_instance_id = m.get('RoDbInstanceId')
        return self


class RemoveDrdsMysqlResponseBodyData(TeaModel):
    def __init__(self, message=None, result=None):
        self.message = message  # type: str
        self.result = result  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveDrdsMysqlResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class RemoveDrdsMysqlResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: RemoveDrdsMysqlResponseBodyData
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(RemoveDrdsMysqlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = RemoveDrdsMysqlResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveDrdsMysqlResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveDrdsMysqlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveDrdsMysqlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveDrdsMysqlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveEvaluateTaskRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveEvaluateTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class RemoveEvaluateTaskResponseBodyTaskManageResult(TeaModel):
    def __init__(self, message=None, success=None):
        self.message = message  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveEvaluateTaskResponseBodyTaskManageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveEvaluateTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_manage_result=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_manage_result = task_manage_result  # type: RemoveEvaluateTaskResponseBodyTaskManageResult

    def validate(self):
        if self.task_manage_result:
            self.task_manage_result.validate()

    def to_map(self):
        _map = super(RemoveEvaluateTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_manage_result is not None:
            result['TaskManageResult'] = self.task_manage_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskManageResult') is not None:
            temp_model = RemoveEvaluateTaskResponseBodyTaskManageResult()
            self.task_manage_result = temp_model.from_map(m['TaskManageResult'])
        return self


class RemoveEvaluateTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveEvaluateTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveEvaluateTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveEvaluateTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveInstanceAccountRequest(TeaModel):
    def __init__(self, account_name=None, drds_instance_id=None):
        self.account_name = account_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveInstanceAccountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class RemoveInstanceAccountResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveInstanceAccountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveInstanceAccountResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveInstanceAccountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveInstanceAccountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveInstanceAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveRecycleBinTableRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None, table_name=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.table_name = table_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveRecycleBinTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class RemoveRecycleBinTableResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveRecycleBinTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveRecycleBinTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RemoveRecycleBinTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveRecycleBinTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveRecycleBinTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RestartDrdsInstanceRequest(TeaModel):
    def __init__(self, drds_instance_id=None):
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RestartDrdsInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class RestartDrdsInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(RestartDrdsInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class RestartDrdsInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RestartDrdsInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RestartDrdsInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RestartDrdsInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RollbackInstanceVersionRequest(TeaModel):
    def __init__(self, drds_instance_id=None, region_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RollbackInstanceVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class RollbackInstanceVersionResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RollbackInstanceVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RollbackInstanceVersionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: RollbackInstanceVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RollbackInstanceVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RollbackInstanceVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetBackupLocalRequest(TeaModel):
    def __init__(self, drds_instance_id=None, high_space_usage_protection=None, local_log_retention_hours=None,
                 local_log_retention_space=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.high_space_usage_protection = high_space_usage_protection  # type: str
        self.local_log_retention_hours = local_log_retention_hours  # type: str
        self.local_log_retention_space = local_log_retention_space  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetBackupLocalRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.high_space_usage_protection is not None:
            result['HighSpaceUsageProtection'] = self.high_space_usage_protection
        if self.local_log_retention_hours is not None:
            result['LocalLogRetentionHours'] = self.local_log_retention_hours
        if self.local_log_retention_space is not None:
            result['LocalLogRetentionSpace'] = self.local_log_retention_space
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('HighSpaceUsageProtection') is not None:
            self.high_space_usage_protection = m.get('HighSpaceUsageProtection')
        if m.get('LocalLogRetentionHours') is not None:
            self.local_log_retention_hours = m.get('LocalLogRetentionHours')
        if m.get('LocalLogRetentionSpace') is not None:
            self.local_log_retention_space = m.get('LocalLogRetentionSpace')
        return self


class SetBackupLocalResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetBackupLocalResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SetBackupLocalResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SetBackupLocalResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SetBackupLocalResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetBackupLocalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetBackupPolicyRequest(TeaModel):
    def __init__(self, backup_db_names=None, backup_level=None, backup_log=None, backup_mode=None,
                 data_backup_retention_period=None, drds_instance_id=None, log_backup_retention_period=None, preferred_backup_end_time=None,
                 preferred_backup_period=None, preferred_backup_start_time=None):
        self.backup_db_names = backup_db_names  # type: str
        self.backup_level = backup_level  # type: str
        self.backup_log = backup_log  # type: str
        self.backup_mode = backup_mode  # type: str
        self.data_backup_retention_period = data_backup_retention_period  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.log_backup_retention_period = log_backup_retention_period  # type: str
        self.preferred_backup_end_time = preferred_backup_end_time  # type: str
        self.preferred_backup_period = preferred_backup_period  # type: str
        self.preferred_backup_start_time = preferred_backup_start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetBackupPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_db_names is not None:
            result['BackupDbNames'] = self.backup_db_names
        if self.backup_level is not None:
            result['BackupLevel'] = self.backup_level
        if self.backup_log is not None:
            result['BackupLog'] = self.backup_log
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.data_backup_retention_period is not None:
            result['DataBackupRetentionPeriod'] = self.data_backup_retention_period
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.log_backup_retention_period is not None:
            result['LogBackupRetentionPeriod'] = self.log_backup_retention_period
        if self.preferred_backup_end_time is not None:
            result['PreferredBackupEndTime'] = self.preferred_backup_end_time
        if self.preferred_backup_period is not None:
            result['PreferredBackupPeriod'] = self.preferred_backup_period
        if self.preferred_backup_start_time is not None:
            result['PreferredBackupStartTime'] = self.preferred_backup_start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupDbNames') is not None:
            self.backup_db_names = m.get('BackupDbNames')
        if m.get('BackupLevel') is not None:
            self.backup_level = m.get('BackupLevel')
        if m.get('BackupLog') is not None:
            self.backup_log = m.get('BackupLog')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('DataBackupRetentionPeriod') is not None:
            self.data_backup_retention_period = m.get('DataBackupRetentionPeriod')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('LogBackupRetentionPeriod') is not None:
            self.log_backup_retention_period = m.get('LogBackupRetentionPeriod')
        if m.get('PreferredBackupEndTime') is not None:
            self.preferred_backup_end_time = m.get('PreferredBackupEndTime')
        if m.get('PreferredBackupPeriod') is not None:
            self.preferred_backup_period = m.get('PreferredBackupPeriod')
        if m.get('PreferredBackupStartTime') is not None:
            self.preferred_backup_start_time = m.get('PreferredBackupStartTime')
        return self


class SetBackupPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetBackupPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SetBackupPolicyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SetBackupPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SetBackupPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetupBroadcastTablesRequest(TeaModel):
    def __init__(self, active=None, db_name=None, drds_instance_id=None, region_id=None, table_name=None):
        self.active = active  # type: bool
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.table_name = table_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetupBroadcastTablesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class SetupBroadcastTablesResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetupBroadcastTablesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SetupBroadcastTablesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SetupBroadcastTablesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SetupBroadcastTablesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetupBroadcastTablesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetupDrdsParamsRequestData(TeaModel):
    def __init__(self, db_name=None, param_ranges=None, param_type=None, param_value=None, param_variable_name=None):
        self.db_name = db_name  # type: str
        self.param_ranges = param_ranges  # type: str
        self.param_type = param_type  # type: str
        self.param_value = param_value  # type: str
        self.param_variable_name = param_variable_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetupDrdsParamsRequestData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.param_ranges is not None:
            result['ParamRanges'] = self.param_ranges
        if self.param_type is not None:
            result['ParamType'] = self.param_type
        if self.param_value is not None:
            result['ParamValue'] = self.param_value
        if self.param_variable_name is not None:
            result['ParamVariableName'] = self.param_variable_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('ParamRanges') is not None:
            self.param_ranges = m.get('ParamRanges')
        if m.get('ParamType') is not None:
            self.param_type = m.get('ParamType')
        if m.get('ParamValue') is not None:
            self.param_value = m.get('ParamValue')
        if m.get('ParamVariableName') is not None:
            self.param_variable_name = m.get('ParamVariableName')
        return self


class SetupDrdsParamsRequest(TeaModel):
    def __init__(self, data=None, drds_instance_id=None, param_level=None, region_id=None):
        self.data = data  # type: list[SetupDrdsParamsRequestData]
        self.drds_instance_id = drds_instance_id  # type: str
        self.param_level = param_level  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(SetupDrdsParamsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.param_level is not None:
            result['ParamLevel'] = self.param_level
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = SetupDrdsParamsRequestData()
                self.data.append(temp_model.from_map(k))
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('ParamLevel') is not None:
            self.param_level = m.get('ParamLevel')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class SetupDrdsParamsResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetupDrdsParamsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SetupDrdsParamsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SetupDrdsParamsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SetupDrdsParamsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetupDrdsParamsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetupRecycleBinStatusRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None, status_action=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.status_action = status_action  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetupRecycleBinStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status_action is not None:
            result['StatusAction'] = self.status_action
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StatusAction') is not None:
            self.status_action = m.get('StatusAction')
        return self


class SetupRecycleBinStatusResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetupRecycleBinStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SetupRecycleBinStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SetupRecycleBinStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SetupRecycleBinStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetupRecycleBinStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetupTableRequest(TeaModel):
    def __init__(self, allow_full_table_scan=None, db_name=None, drds_instance_id=None, region_id=None,
                 table_name=None):
        self.allow_full_table_scan = allow_full_table_scan  # type: bool
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.table_name = table_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetupTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_full_table_scan is not None:
            result['AllowFullTableScan'] = self.allow_full_table_scan
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllowFullTableScan') is not None:
            self.allow_full_table_scan = m.get('AllowFullTableScan')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class SetupTableResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetupTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SetupTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SetupTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SetupTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetupTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetupTableAsyncRequest(TeaModel):
    def __init__(self, allow_full_table_scan=None, db_name=None, drds_instance_id=None, region_id=None,
                 table_name=None):
        self.allow_full_table_scan = allow_full_table_scan  # type: bool
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.table_name = table_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetupTableAsyncRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_full_table_scan is not None:
            result['AllowFullTableScan'] = self.allow_full_table_scan
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.table_name is not None:
            result['TableName'] = self.table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllowFullTableScan') is not None:
            self.allow_full_table_scan = m.get('AllowFullTableScan')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        return self


class SetupTableAsyncResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SetupTableAsyncResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SetupTableAsyncResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SetupTableAsyncResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SetupTableAsyncResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SetupTableAsyncResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SqlCompatibilityCancelRequest(TeaModel):
    def __init__(self, drds_instance_id=None, task_id=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(SqlCompatibilityCancelRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class SqlCompatibilityCancelResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SqlCompatibilityCancelResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SqlCompatibilityCancelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SqlCompatibilityCancelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SqlCompatibilityCancelResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SqlCompatibilityCancelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SqlCompatibilityStartRequest(TeaModel):
    def __init__(self, drds_instance_id=None, performance_test=None, target_version=None):
        self.drds_instance_id = drds_instance_id  # type: str
        self.performance_test = performance_test  # type: bool
        self.target_version = target_version  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SqlCompatibilityStartRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.performance_test is not None:
            result['PerformanceTest'] = self.performance_test
        if self.target_version is not None:
            result['TargetVersion'] = self.target_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PerformanceTest') is not None:
            self.performance_test = m.get('PerformanceTest')
        if m.get('TargetVersion') is not None:
            self.target_version = m.get('TargetVersion')
        return self


class SqlCompatibilityStartResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SqlCompatibilityStartResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SqlCompatibilityStartResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SqlCompatibilityStartResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SqlCompatibilityStartResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SqlCompatibilityStartResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartEvaluateTaskRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartEvaluateTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StartEvaluateTaskResponseBodyTaskManageResult(TeaModel):
    def __init__(self, message=None, success=None):
        self.message = message  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartEvaluateTaskResponseBodyTaskManageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartEvaluateTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_manage_result=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_manage_result = task_manage_result  # type: StartEvaluateTaskResponseBodyTaskManageResult

    def validate(self):
        if self.task_manage_result:
            self.task_manage_result.validate()

    def to_map(self):
        _map = super(StartEvaluateTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_manage_result is not None:
            result['TaskManageResult'] = self.task_manage_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskManageResult') is not None:
            temp_model = StartEvaluateTaskResponseBodyTaskManageResult()
            self.task_manage_result = temp_model.from_map(m['TaskManageResult'])
        return self


class StartEvaluateTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: StartEvaluateTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartEvaluateTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StartEvaluateTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartRestoreRequest(TeaModel):
    def __init__(self, backup_db_names=None, backup_id=None, backup_level=None, backup_mode=None,
                 drds_instance_id=None, preferred_backup_time=None):
        self.backup_db_names = backup_db_names  # type: str
        self.backup_id = backup_id  # type: str
        self.backup_level = backup_level  # type: str
        self.backup_mode = backup_mode  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.preferred_backup_time = preferred_backup_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartRestoreRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_db_names is not None:
            result['BackupDbNames'] = self.backup_db_names
        if self.backup_id is not None:
            result['BackupId'] = self.backup_id
        if self.backup_level is not None:
            result['BackupLevel'] = self.backup_level
        if self.backup_mode is not None:
            result['BackupMode'] = self.backup_mode
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.preferred_backup_time is not None:
            result['PreferredBackupTime'] = self.preferred_backup_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BackupDbNames') is not None:
            self.backup_db_names = m.get('BackupDbNames')
        if m.get('BackupId') is not None:
            self.backup_id = m.get('BackupId')
        if m.get('BackupLevel') is not None:
            self.backup_level = m.get('BackupLevel')
        if m.get('BackupMode') is not None:
            self.backup_mode = m.get('BackupMode')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('PreferredBackupTime') is not None:
            self.preferred_backup_time = m.get('PreferredBackupTime')
        return self


class StartRestoreResponseBody(TeaModel):
    def __init__(self, request_id=None, result=None, success=None):
        self.request_id = request_id  # type: str
        self.result = result  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartRestoreResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartRestoreResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: StartRestoreResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartRestoreResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StartRestoreResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StopDataExportTaskRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(StopDataExportTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StopDataExportTaskResponseBodyTaskManageResult(TeaModel):
    def __init__(self, message=None, success=None):
        self.message = message  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StopDataExportTaskResponseBodyTaskManageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StopDataExportTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_manage_result=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_manage_result = task_manage_result  # type: StopDataExportTaskResponseBodyTaskManageResult

    def validate(self):
        if self.task_manage_result:
            self.task_manage_result.validate()

    def to_map(self):
        _map = super(StopDataExportTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_manage_result is not None:
            result['TaskManageResult'] = self.task_manage_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskManageResult') is not None:
            temp_model = StopDataExportTaskResponseBodyTaskManageResult()
            self.task_manage_result = temp_model.from_map(m['TaskManageResult'])
        return self


class StopDataExportTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: StopDataExportTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StopDataExportTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StopDataExportTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StopDataImportTaskRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(StopDataImportTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StopDataImportTaskResponseBodyTaskManageResult(TeaModel):
    def __init__(self, message=None, success=None):
        self.message = message  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StopDataImportTaskResponseBodyTaskManageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StopDataImportTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_manage_result=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_manage_result = task_manage_result  # type: StopDataImportTaskResponseBodyTaskManageResult

    def validate(self):
        if self.task_manage_result:
            self.task_manage_result.validate()

    def to_map(self):
        _map = super(StopDataImportTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_manage_result is not None:
            result['TaskManageResult'] = self.task_manage_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskManageResult') is not None:
            temp_model = StopDataImportTaskResponseBodyTaskManageResult()
            self.task_manage_result = temp_model.from_map(m['TaskManageResult'])
        return self


class StopDataImportTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: StopDataImportTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StopDataImportTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StopDataImportTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StopEvaluateTaskRequest(TeaModel):
    def __init__(self, task_id=None):
        self.task_id = task_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(StopEvaluateTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StopEvaluateTaskResponseBodyTaskManageResult(TeaModel):
    def __init__(self, message=None, success=None):
        self.message = message  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StopEvaluateTaskResponseBodyTaskManageResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StopEvaluateTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_manage_result=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_manage_result = task_manage_result  # type: StopEvaluateTaskResponseBodyTaskManageResult

    def validate(self):
        if self.task_manage_result:
            self.task_manage_result.validate()

    def to_map(self):
        _map = super(StopEvaluateTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_manage_result is not None:
            result['TaskManageResult'] = self.task_manage_result.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskManageResult') is not None:
            temp_model = StopEvaluateTaskResponseBodyTaskManageResult()
            self.task_manage_result = temp_model.from_map(m['TaskManageResult'])
        return self


class StopEvaluateTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: StopEvaluateTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StopEvaluateTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StopEvaluateTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitCleanTableShardingKeyModifyRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None, task_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitCleanTableShardingKeyModifyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class SubmitCleanTableShardingKeyModifyResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitCleanTableShardingKeyModifyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SubmitCleanTableShardingKeyModifyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitCleanTableShardingKeyModifyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitCleanTableShardingKeyModifyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitCleanTableShardingKeyModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitCleanTaskRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, expand_type=None, job_id=None, parent_job_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.expand_type = expand_type  # type: str
        self.job_id = job_id  # type: str
        self.parent_job_id = parent_job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitCleanTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.expand_type is not None:
            result['ExpandType'] = self.expand_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.parent_job_id is not None:
            result['ParentJobId'] = self.parent_job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('ExpandType') is not None:
            self.expand_type = m.get('ExpandType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ParentJobId') is not None:
            self.parent_job_id = m.get('ParentJobId')
        return self


class SubmitCleanTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitCleanTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SubmitCleanTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitCleanTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitCleanTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitCleanTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitHotExpandPreCheckTaskRequest(TeaModel):
    def __init__(self, db_inst_type=None, db_name=None, drds_instance_id=None, table_list=None):
        self.db_inst_type = db_inst_type  # type: str
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.table_list = table_list  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitHotExpandPreCheckTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.table_list is not None:
            result['TableList'] = self.table_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('TableList') is not None:
            self.table_list = m.get('TableList')
        return self


class SubmitHotExpandPreCheckTaskResponseBody(TeaModel):
    def __init__(self, msg=None, request_id=None, success=None, task_id=None):
        self.msg = msg  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitHotExpandPreCheckTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class SubmitHotExpandPreCheckTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitHotExpandPreCheckTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitHotExpandPreCheckTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitHotExpandPreCheckTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitHotExpandTaskRequestExtendedMapping(TeaModel):
    def __init__(self, src_db=None, src_instance_id=None):
        self.src_db = src_db  # type: str
        self.src_instance_id = src_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitHotExpandTaskRequestExtendedMapping, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.src_db is not None:
            result['SrcDb'] = self.src_db
        if self.src_instance_id is not None:
            result['SrcInstanceId'] = self.src_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SrcDb') is not None:
            self.src_db = m.get('SrcDb')
        if m.get('SrcInstanceId') is not None:
            self.src_instance_id = m.get('SrcInstanceId')
        return self


class SubmitHotExpandTaskRequestInstanceDbMapping(TeaModel):
    def __init__(self, db_list=None, instance_name=None):
        self.db_list = db_list  # type: str
        self.instance_name = instance_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitHotExpandTaskRequestInstanceDbMapping, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_list is not None:
            result['DbList'] = self.db_list
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbList') is not None:
            self.db_list = m.get('DbList')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        return self


class SubmitHotExpandTaskRequestMapping(TeaModel):
    def __init__(self, db_shard_column=None, hot_db_name=None, hot_table_name=None, logic_table=None,
                 shard_db_value=None, shard_tb_value=None, tb_shard_column=None):
        self.db_shard_column = db_shard_column  # type: str
        self.hot_db_name = hot_db_name  # type: str
        self.hot_table_name = hot_table_name  # type: str
        self.logic_table = logic_table  # type: str
        self.shard_db_value = shard_db_value  # type: str
        self.shard_tb_value = shard_tb_value  # type: str
        self.tb_shard_column = tb_shard_column  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitHotExpandTaskRequestMapping, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_shard_column is not None:
            result['DbShardColumn'] = self.db_shard_column
        if self.hot_db_name is not None:
            result['HotDbName'] = self.hot_db_name
        if self.hot_table_name is not None:
            result['HotTableName'] = self.hot_table_name
        if self.logic_table is not None:
            result['LogicTable'] = self.logic_table
        if self.shard_db_value is not None:
            result['ShardDbValue'] = self.shard_db_value
        if self.shard_tb_value is not None:
            result['ShardTbValue'] = self.shard_tb_value
        if self.tb_shard_column is not None:
            result['TbShardColumn'] = self.tb_shard_column
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbShardColumn') is not None:
            self.db_shard_column = m.get('DbShardColumn')
        if m.get('HotDbName') is not None:
            self.hot_db_name = m.get('HotDbName')
        if m.get('HotTableName') is not None:
            self.hot_table_name = m.get('HotTableName')
        if m.get('LogicTable') is not None:
            self.logic_table = m.get('LogicTable')
        if m.get('ShardDbValue') is not None:
            self.shard_db_value = m.get('ShardDbValue')
        if m.get('ShardTbValue') is not None:
            self.shard_tb_value = m.get('ShardTbValue')
        if m.get('TbShardColumn') is not None:
            self.tb_shard_column = m.get('TbShardColumn')
        return self


class SubmitHotExpandTaskRequestSupperAccountMapping(TeaModel):
    def __init__(self, instance_name=None, supper_account=None, supper_password=None):
        self.instance_name = instance_name  # type: str
        self.supper_account = supper_account  # type: str
        self.supper_password = supper_password  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitHotExpandTaskRequestSupperAccountMapping, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.supper_account is not None:
            result['SupperAccount'] = self.supper_account
        if self.supper_password is not None:
            result['SupperPassword'] = self.supper_password
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('SupperAccount') is not None:
            self.supper_account = m.get('SupperAccount')
        if m.get('SupperPassword') is not None:
            self.supper_password = m.get('SupperPassword')
        return self


class SubmitHotExpandTaskRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, extended_mapping=None, instance_db_mapping=None,
                 mapping=None, supper_account_mapping=None, task_desc=None, task_name=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.extended_mapping = extended_mapping  # type: list[SubmitHotExpandTaskRequestExtendedMapping]
        self.instance_db_mapping = instance_db_mapping  # type: list[SubmitHotExpandTaskRequestInstanceDbMapping]
        self.mapping = mapping  # type: list[SubmitHotExpandTaskRequestMapping]
        self.supper_account_mapping = supper_account_mapping  # type: list[SubmitHotExpandTaskRequestSupperAccountMapping]
        self.task_desc = task_desc  # type: str
        self.task_name = task_name  # type: str

    def validate(self):
        if self.extended_mapping:
            for k in self.extended_mapping:
                if k:
                    k.validate()
        if self.instance_db_mapping:
            for k in self.instance_db_mapping:
                if k:
                    k.validate()
        if self.mapping:
            for k in self.mapping:
                if k:
                    k.validate()
        if self.supper_account_mapping:
            for k in self.supper_account_mapping:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(SubmitHotExpandTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        result['ExtendedMapping'] = []
        if self.extended_mapping is not None:
            for k in self.extended_mapping:
                result['ExtendedMapping'].append(k.to_map() if k else None)
        result['InstanceDbMapping'] = []
        if self.instance_db_mapping is not None:
            for k in self.instance_db_mapping:
                result['InstanceDbMapping'].append(k.to_map() if k else None)
        result['Mapping'] = []
        if self.mapping is not None:
            for k in self.mapping:
                result['Mapping'].append(k.to_map() if k else None)
        result['SupperAccountMapping'] = []
        if self.supper_account_mapping is not None:
            for k in self.supper_account_mapping:
                result['SupperAccountMapping'].append(k.to_map() if k else None)
        if self.task_desc is not None:
            result['TaskDesc'] = self.task_desc
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        self.extended_mapping = []
        if m.get('ExtendedMapping') is not None:
            for k in m.get('ExtendedMapping'):
                temp_model = SubmitHotExpandTaskRequestExtendedMapping()
                self.extended_mapping.append(temp_model.from_map(k))
        self.instance_db_mapping = []
        if m.get('InstanceDbMapping') is not None:
            for k in m.get('InstanceDbMapping'):
                temp_model = SubmitHotExpandTaskRequestInstanceDbMapping()
                self.instance_db_mapping.append(temp_model.from_map(k))
        self.mapping = []
        if m.get('Mapping') is not None:
            for k in m.get('Mapping'):
                temp_model = SubmitHotExpandTaskRequestMapping()
                self.mapping.append(temp_model.from_map(k))
        self.supper_account_mapping = []
        if m.get('SupperAccountMapping') is not None:
            for k in m.get('SupperAccountMapping'):
                temp_model = SubmitHotExpandTaskRequestSupperAccountMapping()
                self.supper_account_mapping.append(temp_model.from_map(k))
        if m.get('TaskDesc') is not None:
            self.task_desc = m.get('TaskDesc')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class SubmitHotExpandTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitHotExpandTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SubmitHotExpandTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitHotExpandTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitHotExpandTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitHotExpandTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitRollbackShardingKeyModifyRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None, task_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitRollbackShardingKeyModifyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class SubmitRollbackShardingKeyModifyResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitRollbackShardingKeyModifyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SubmitRollbackShardingKeyModifyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitRollbackShardingKeyModifyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitRollbackShardingKeyModifyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitRollbackShardingKeyModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitSmoothExpandPreCheckRequest(TeaModel):
    def __init__(self, db_inst_type=None, db_name=None, drds_instance_id=None):
        self.db_inst_type = db_inst_type  # type: str
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSmoothExpandPreCheckRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_inst_type is not None:
            result['DbInstType'] = self.db_inst_type
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstType') is not None:
            self.db_inst_type = m.get('DbInstType')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class SubmitSmoothExpandPreCheckResponseBody(TeaModel):
    def __init__(self, msg=None, request_id=None, success=None, task_id=None):
        self.msg = msg  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSmoothExpandPreCheckResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class SubmitSmoothExpandPreCheckResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitSmoothExpandPreCheckResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitSmoothExpandPreCheckResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitSmoothExpandPreCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitSmoothExpandPreCheckTaskRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSmoothExpandPreCheckTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        return self


class SubmitSmoothExpandPreCheckTaskResponseBody(TeaModel):
    def __init__(self, msg=None, request_id=None, success=None, task_id=None):
        self.msg = msg  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSmoothExpandPreCheckTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class SubmitSmoothExpandPreCheckTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitSmoothExpandPreCheckTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitSmoothExpandPreCheckTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitSmoothExpandPreCheckTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitSmoothExpandTaskRequestRdsSuperInstances(TeaModel):
    def __init__(self, account_name=None, password=None, rds_name=None):
        self.account_name = account_name  # type: str
        self.password = password  # type: str
        self.rds_name = rds_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSmoothExpandTaskRequestRdsSuperInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.password is not None:
            result['Password'] = self.password
        if self.rds_name is not None:
            result['RdsName'] = self.rds_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RdsName') is not None:
            self.rds_name = m.get('RdsName')
        return self


class SubmitSmoothExpandTaskRequestTransferTaskInfos(TeaModel):
    def __init__(self, db_name=None, dst_instance_name=None, instance_type=None, src_instance_name=None):
        self.db_name = db_name  # type: str
        self.dst_instance_name = dst_instance_name  # type: str
        self.instance_type = instance_type  # type: str
        self.src_instance_name = src_instance_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSmoothExpandTaskRequestTransferTaskInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.dst_instance_name is not None:
            result['DstInstanceName'] = self.dst_instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.src_instance_name is not None:
            result['SrcInstanceName'] = self.src_instance_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DstInstanceName') is not None:
            self.dst_instance_name = m.get('DstInstanceName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('SrcInstanceName') is not None:
            self.src_instance_name = m.get('SrcInstanceName')
        return self


class SubmitSmoothExpandTaskRequest(TeaModel):
    def __init__(self, db_instance_is_creating=None, db_name=None, drds_instance_id=None, rds_super_instances=None,
                 transfer_task_infos=None):
        self.db_instance_is_creating = db_instance_is_creating  # type: bool
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.rds_super_instances = rds_super_instances  # type: list[SubmitSmoothExpandTaskRequestRdsSuperInstances]
        self.transfer_task_infos = transfer_task_infos  # type: list[SubmitSmoothExpandTaskRequestTransferTaskInfos]

    def validate(self):
        if self.rds_super_instances:
            for k in self.rds_super_instances:
                if k:
                    k.validate()
        if self.transfer_task_infos:
            for k in self.transfer_task_infos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(SubmitSmoothExpandTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_instance_is_creating is not None:
            result['DbInstanceIsCreating'] = self.db_instance_is_creating
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        result['RdsSuperInstances'] = []
        if self.rds_super_instances is not None:
            for k in self.rds_super_instances:
                result['RdsSuperInstances'].append(k.to_map() if k else None)
        result['TransferTaskInfos'] = []
        if self.transfer_task_infos is not None:
            for k in self.transfer_task_infos:
                result['TransferTaskInfos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbInstanceIsCreating') is not None:
            self.db_instance_is_creating = m.get('DbInstanceIsCreating')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        self.rds_super_instances = []
        if m.get('RdsSuperInstances') is not None:
            for k in m.get('RdsSuperInstances'):
                temp_model = SubmitSmoothExpandTaskRequestRdsSuperInstances()
                self.rds_super_instances.append(temp_model.from_map(k))
        self.transfer_task_infos = []
        if m.get('TransferTaskInfos') is not None:
            for k in m.get('TransferTaskInfos'):
                temp_model = SubmitSmoothExpandTaskRequestTransferTaskInfos()
                self.transfer_task_infos.append(temp_model.from_map(k))
        return self


class SubmitSmoothExpandTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSmoothExpandTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SubmitSmoothExpandTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitSmoothExpandTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitSmoothExpandTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitSmoothExpandTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitSqlFlashbackTaskRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, end_time=None, recall_restore_type=None,
                 recall_type=None, sql_pk=None, sql_type=None, start_time=None, table_name=None, trace_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.end_time = end_time  # type: str
        self.recall_restore_type = recall_restore_type  # type: int
        self.recall_type = recall_type  # type: int
        self.sql_pk = sql_pk  # type: str
        self.sql_type = sql_type  # type: str
        self.start_time = start_time  # type: str
        self.table_name = table_name  # type: str
        self.trace_id = trace_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSqlFlashbackTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.recall_restore_type is not None:
            result['RecallRestoreType'] = self.recall_restore_type
        if self.recall_type is not None:
            result['RecallType'] = self.recall_type
        if self.sql_pk is not None:
            result['SqlPk'] = self.sql_pk
        if self.sql_type is not None:
            result['SqlType'] = self.sql_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.table_name is not None:
            result['TableName'] = self.table_name
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RecallRestoreType') is not None:
            self.recall_restore_type = m.get('RecallRestoreType')
        if m.get('RecallType') is not None:
            self.recall_type = m.get('RecallType')
        if m.get('SqlPk') is not None:
            self.sql_pk = m.get('SqlPk')
        if m.get('SqlType') is not None:
            self.sql_type = m.get('SqlType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TableName') is not None:
            self.table_name = m.get('TableName')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class SubmitSqlFlashbackTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, task_id=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSqlFlashbackTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class SubmitSqlFlashbackTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitSqlFlashbackTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitSqlFlashbackTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitSqlFlashbackTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitSwitchTableShardingKeyModifyRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None, task_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSwitchTableShardingKeyModifyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class SubmitSwitchTableShardingKeyModifyResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSwitchTableShardingKeyModifyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SubmitSwitchTableShardingKeyModifyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitSwitchTableShardingKeyModifyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitSwitchTableShardingKeyModifyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitSwitchTableShardingKeyModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitSwitchTaskRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, expand_type=None, job_id=None, parent_job_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.expand_type = expand_type  # type: str
        self.job_id = job_id  # type: str
        self.parent_job_id = parent_job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSwitchTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.expand_type is not None:
            result['ExpandType'] = self.expand_type
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.parent_job_id is not None:
            result['ParentJobId'] = self.parent_job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('ExpandType') is not None:
            self.expand_type = m.get('ExpandType')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ParentJobId') is not None:
            self.parent_job_id = m.get('ParentJobId')
        return self


class SubmitSwitchTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitSwitchTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SubmitSwitchTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitSwitchTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitSwitchTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitSwitchTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitTableShardingKeyModifyRequest(TeaModel):
    def __init__(self, db_compute_length=None, db_name=None, db_right_shift_offset=None,
                 db_sharding_column_list=None, db_sharding_function=None, drds_instance_id=None, is_shard=None, region_id=None,
                 src_table_name=None, target_table_name=None, tb_compute_length=None, tb_partitions=None,
                 tb_right_shift_offset=None, tb_sharding_column_list=None, tb_sharding_function=None):
        self.db_compute_length = db_compute_length  # type: str
        self.db_name = db_name  # type: str
        self.db_right_shift_offset = db_right_shift_offset  # type: int
        self.db_sharding_column_list = db_sharding_column_list  # type: str
        self.db_sharding_function = db_sharding_function  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.is_shard = is_shard  # type: bool
        self.region_id = region_id  # type: str
        self.src_table_name = src_table_name  # type: str
        self.target_table_name = target_table_name  # type: str
        self.tb_compute_length = tb_compute_length  # type: str
        self.tb_partitions = tb_partitions  # type: str
        self.tb_right_shift_offset = tb_right_shift_offset  # type: str
        self.tb_sharding_column_list = tb_sharding_column_list  # type: str
        self.tb_sharding_function = tb_sharding_function  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitTableShardingKeyModifyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_compute_length is not None:
            result['DbComputeLength'] = self.db_compute_length
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.db_right_shift_offset is not None:
            result['DbRightShiftOffset'] = self.db_right_shift_offset
        if self.db_sharding_column_list is not None:
            result['DbShardingColumnList'] = self.db_sharding_column_list
        if self.db_sharding_function is not None:
            result['DbShardingFunction'] = self.db_sharding_function
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.is_shard is not None:
            result['IsShard'] = self.is_shard
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.src_table_name is not None:
            result['SrcTableName'] = self.src_table_name
        if self.target_table_name is not None:
            result['TargetTableName'] = self.target_table_name
        if self.tb_compute_length is not None:
            result['TbComputeLength'] = self.tb_compute_length
        if self.tb_partitions is not None:
            result['TbPartitions'] = self.tb_partitions
        if self.tb_right_shift_offset is not None:
            result['TbRightShiftOffset'] = self.tb_right_shift_offset
        if self.tb_sharding_column_list is not None:
            result['TbShardingColumnList'] = self.tb_sharding_column_list
        if self.tb_sharding_function is not None:
            result['TbShardingFunction'] = self.tb_sharding_function
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbComputeLength') is not None:
            self.db_compute_length = m.get('DbComputeLength')
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DbRightShiftOffset') is not None:
            self.db_right_shift_offset = m.get('DbRightShiftOffset')
        if m.get('DbShardingColumnList') is not None:
            self.db_sharding_column_list = m.get('DbShardingColumnList')
        if m.get('DbShardingFunction') is not None:
            self.db_sharding_function = m.get('DbShardingFunction')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('IsShard') is not None:
            self.is_shard = m.get('IsShard')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SrcTableName') is not None:
            self.src_table_name = m.get('SrcTableName')
        if m.get('TargetTableName') is not None:
            self.target_table_name = m.get('TargetTableName')
        if m.get('TbComputeLength') is not None:
            self.tb_compute_length = m.get('TbComputeLength')
        if m.get('TbPartitions') is not None:
            self.tb_partitions = m.get('TbPartitions')
        if m.get('TbRightShiftOffset') is not None:
            self.tb_right_shift_offset = m.get('TbRightShiftOffset')
        if m.get('TbShardingColumnList') is not None:
            self.tb_sharding_column_list = m.get('TbShardingColumnList')
        if m.get('TbShardingFunction') is not None:
            self.tb_sharding_function = m.get('TbShardingFunction')
        return self


class SubmitTableShardingKeyModifyResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SubmitTableShardingKeyModifyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SubmitTableShardingKeyModifyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SubmitTableShardingKeyModifyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SubmitTableShardingKeyModifyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitTableShardingKeyModifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SwitchGlobalBroadcastTypeRequest(TeaModel):
    def __init__(self, db_name=None, drds_instance_id=None, region_id=None):
        self.db_name = db_name  # type: str
        self.drds_instance_id = drds_instance_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SwitchGlobalBroadcastTypeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.db_name is not None:
            result['DbName'] = self.db_name
        if self.drds_instance_id is not None:
            result['DrdsInstanceId'] = self.drds_instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DbName') is not None:
            self.db_name = m.get('DbName')
        if m.get('DrdsInstanceId') is not None:
            self.drds_instance_id = m.get('DrdsInstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class SwitchGlobalBroadcastTypeResponseBody(TeaModel):
    def __init__(self, data=None, request_id=None, success=None):
        self.data = data  # type: bool
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SwitchGlobalBroadcastTypeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SwitchGlobalBroadcastTypeResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: SwitchGlobalBroadcastTypeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SwitchGlobalBroadcastTypeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SwitchGlobalBroadcastTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class TagResourcesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(TagResourcesRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class TagResourcesRequest(TeaModel):
    def __init__(self, region_id=None, resource_id=None, resource_type=None, tag=None):
        self.region_id = region_id  # type: str
        self.resource_id = resource_id  # type: list[str]
        self.resource_type = resource_type  # type: str
        self.tag = tag  # type: list[TagResourcesRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(TagResourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = TagResourcesRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class TagResourcesResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(TagResourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class TagResourcesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.body = body  # type: TagResourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(TagResourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = TagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UntagResourcesRequest(TeaModel):
    def __init__(self, all=None, region_id=None, resource_id=None, resource_type=None, tag_key=None):
        self.all = all  # type: bool
        self.region_id = region_id  # type: str
        self.resource_id = resource_id  # type: list[str]
        self.resource_type = resource_type  # type: str
        self.tag_key = tag_key  # type: list[str]

 