import collections

FunctionInfo = collections.namedtuple(
    'FunctionInfo', 'name category version uri')

function_info = (
    FunctionInfo('ABS', 'Math and trigonometry', '', 'abs-function-3420200f-5628-4e8c-99da-c99d7c87713c'),
    FunctionInfo('ACCRINT', 'Financial', '', 'accrint-function-fe45d089-6722-4fb3-9379-e1f911d8dc74'),
    FunctionInfo('ACCRINTM', 'Financial', '', 'accrintm-function-f62f01f9-5754-4cc4-805b-0e70199328a7'),
    FunctionInfo('ACOS', 'Math and trigonometry', '', 'acos-function-cb73173f-d089-4582-afa1-76e5524b5d5b'),
    FunctionInfo('ACOSH', 'Math and trigonometry', '', 'acosh-function-e3992cc1-103f-4e72-9f04-624b9ef5ebfe'),
    FunctionInfo('ACOT', 'Math and trigonometry', 'Excel 2013', 'acot-function-dc7e5008-fe6b-402e-bdd6-2eea8383d905'),
    FunctionInfo('ACOTH', 'Math and trigonometry', 'Excel 2013', 'acoth-function-cc49480f-f684-4171-9fc5-73e4e852300f'),
    FunctionInfo('AGGREGATE', 'Math and trigonometry', '', 'aggregate-function-43b9278e-6aa7-4f17-92b6-e19993fa26df'),
    FunctionInfo('ADDRESS', 'Lookup and reference', '', 'address-function-d0c26c0d-3991-446b-8de4-ab46431d4f89'),
    FunctionInfo('AMORDEGRC', 'Financial', '', 'amordegrc-function-a14d0ca1-64a4-42eb-9b3d-b0dededf9e51'),
    FunctionInfo('AMORLINC', 'Financial', '', 'amorlinc-function-7d417b45-f7f5-4dba-a0a5-3451a81079a8'),
    FunctionInfo('AND', 'Logical', '', 'and-function-5f19b2e8-e1df-4408-897a-ce285a19e9d9'),
    FunctionInfo('ARABIC', 'Math and trigonometry', 'Excel 2013', 'arabic-function-9a8da418-c17b-4ef9-a657-9370a30a674f'),
    FunctionInfo('AREAS', 'Lookup and reference', '', 'areas-function-8392ba32-7a41-43b3-96b0-3695d2ec6152'),
    FunctionInfo('ASC', 'Text', '', 'asc-function-0b6abf1c-c663-4004-a964-ebc00b723266'),
    FunctionInfo('ASIN', 'Math and trigonometry', '', 'asin-function-81fb95e5-6d6f-48c4-bc45-58f955c6d347'),
    FunctionInfo('ASINH', 'Math and trigonometry', '', 'asinh-function-4e00475a-067a-43cf-926a-765b0249717c'),
    FunctionInfo('ATAN', 'Math and trigonometry', '', 'atan-function-50746fa8-630a-406b-81d0-4a2aed395543'),
    FunctionInfo('ATAN2', 'Math and trigonometry', '', 'atan2-function-c04592ab-b9e3-4908-b428-c96b3a565033'),
    FunctionInfo('ATANH', 'Math and trigonometry', '', 'atanh-function-3cd65768-0de7-4f1d-b312-d01c8c930d90'),
    FunctionInfo('AVEDEV', 'Statistical', '', 'avedev-function-58fe8d65-2a84-4dc7-8052-f3f87b5c6639'),
    FunctionInfo('AVERAGE', 'Statistical', '', 'average-function-047bac88-d466-426c-a32b-8f33eb960cf6'),
    FunctionInfo('AVERAGEA', 'Statistical', '', 'averagea-function-f5f84098-d453-4f4c-bbba-3d2c66356091'),
    FunctionInfo('AVERAGEIF', 'Statistical', '', 'averageif-function-faec8e2e-0dec-4308-af69-f5576d8ac642'),
    FunctionInfo('AVERAGEIFS', 'Statistical', '', 'averageifs-function-48910c45-1fc0-4389-a028-f7c5c3001690'),
    FunctionInfo('BAHTTEXT', 'Text', '', 'bahttext-function-5ba4d0b4-abd3-4325-8d22-7a92d59aab9c'),
    FunctionInfo('BASE', 'Math and trigonometry', '', 'base-function-2ef61411-aee9-4f29-a811-1c42456c6342'),
    FunctionInfo('BESSELI', 'Engineering', '', 'besseli-function-8d33855c-9a8d-444b-98e0-852267b1c0df'),
    FunctionInfo('BESSELJ', 'Engineering', '', 'besselj-function-839cb181-48de-408b-9d80-bd02982d94f7'),
    FunctionInfo('BESSELK', 'Engineering', '', 'besselk-function-606d11bc-06d3-4d53-9ecb-2803e2b90b70'),
    FunctionInfo('BESSELY', 'Engineering', '', 'bessely-function-f3a356b3-da89-42c3-8974-2da54d6353a2'),
    FunctionInfo('BETADIST', 'Compatibility', '', 'betadist-function-49f1b9a9-a5da-470f-8077-5f1730b5fd47'),
    FunctionInfo('BETA.DIST', 'Statistical', 'Excel 2010', 'beta-dist-function-11188c9c-780a-42c7-ba43-9ecb5a878d31'),
    FunctionInfo('BETAINV', 'Compatibility', '', 'betainv-function-8b914ade-b902-43c1-ac9c-c05c54f10d6c'),
    FunctionInfo('BETA.INV', 'Statistical', 'Excel 2010', 'beta-inv-function-e84cb8aa-8df0-4cf6-9892-83a341d252eb'),
    FunctionInfo('BIN2DEC', 'Engineering', '', 'bin2dec-function-63905b57-b3a0-453d-99f4-647bb519cd6c'),
    FunctionInfo('BIN2HEX', 'Engineering', '', 'bin2hex-function-0375e507-f5e5-4077-9af8-28d84f9f41cc'),
    FunctionInfo('BIN2OCT', 'Engineering', '', 'bin2oct-function-0a4e01ba-ac8d-4158-9b29-16c25c4c23fd'),
    FunctionInfo('BINOMDIST', 'Compatibility', '', 'binomdist-function-506a663e-c4ca-428d-b9a8-05583d68789c'),
    FunctionInfo('BINOM.DIST', 'Statistical', 'Excel 2010', 'binom-dist-function-c5ae37b6-f39c-4be2-94c2-509a1480770c'),
    FunctionInfo('BINOM.DIST.RANGE', 'Statistical', 'Excel 2013', 'binom-dist-range-function-17331329-74c7-4053-bb4c-6653a7421595'),
    FunctionInfo('BINOM.INV', 'Statistical', 'Excel 2010', 'binom-inv-function-80a0370c-ada6-49b4-83e7-05a91ba77ac9'),
    FunctionInfo('BITAND', 'Engineering', 'Excel 2013', 'bitand-function-8a2be3d7-91c3-4b48-9517-64548008563a'),
    FunctionInfo('BITLSHIFT', 'Engineering', 'Excel 2013', 'bitlshift-function-c55bb27e-cacd-4c7c-b258-d80861a03c9c'),
    FunctionInfo('BITOR', 'Engineering', 'Excel 2013', 'bitor-function-f6ead5c8-5b98-4c9e-9053-8ad5234919b2'),
    FunctionInfo('BITRSHIFT', 'Engineering', 'Excel 2013', 'bitrshift-function-274d6996-f42c-4743-abdb-4ff95351222c'),
    FunctionInfo('BITXOR', 'Engineering', 'Excel 2013', 'bitxor-function-c81306a1-03f9-4e89-85ac-b86c3cba10e4'),
    FunctionInfo('CALL', 'Add-in and Automation', '', 'call-function-32d58445-e646-4ffd-8d5e-b45077a5e995'),
    FunctionInfo('CEILING', 'Compatibility', '', 'ceiling-function-0a5cd7c8-0720-4f0a-bd2c-c943e510899f'),
    FunctionInfo('CEILING.MATH', 'Math and trigonometry', 'Excel 2013', 'ceiling-math-function-80f95d2f-b499-4eee-9f16-f795a8e306c8'),
    FunctionInfo('CEILING.PRECISE', 'Math and trigonometry', '', 'ceiling-precise-function-f366a774-527a-4c92-ba49-af0a196e66cb'),
    FunctionInfo('CELL', 'Information', '', 'cell-function-51bd39a5-f338-4dbe-a33f-955d67c2b2cf'),
    FunctionInfo('CHAR', 'Text', '', 'char-function-bbd249c8-b36e-4a91-8017-1c133f9b837a'),
    FunctionInfo('CHIDIST', 'Compatibility', '', 'chidist-function-c90d0fbc-5b56-4f5f-ab57-34af1bf6897e'),
    FunctionInfo('CHIINV', 'Compatibility', '', 'chiinv-function-cfbea3f6-6e4f-40c9-a87f-20472e0512af'),
    FunctionInfo('CHITEST', 'Compatibility', '', 'chitest-function-981ff871-b694-4134-848e-38ec704577ac'),
    FunctionInfo('CHISQ.DIST', 'Statistical', 'Excel 2010', 'chisq-dist-function-8486b05e-5c05-4942-a9ea-f6b341518732'),
    FunctionInfo('CHISQ.DIST.RT', 'Statistical', 'Excel 2010', 'chisq-dist-rt-function-dc4832e8-ed2b-49ae-8d7c-b28d5804c0f2'),
    FunctionInfo('CHISQ.INV', 'Statistical', 'Excel 2010', 'chisq-inv-function-400db556-62b3-472d-80b3-254723e7092f'),
    FunctionInfo('CHISQ.INV.RT', 'Statistical', 'Excel 2010', 'chisq-inv-rt-function-435b5ed8-98d5-4da6-823f-293e2cbc94fe'),
    FunctionInfo('CHISQ.TEST', 'Statistical', 'Excel 2010', 'chisq-test-function-2e8a7861-b14a-4985-aa93-fb88de3f260f'),
    FunctionInfo('CHOOSE', 'Lookup and reference', '', 'choose-function-fc5c184f-cb62-4ec7-a46e-38653b98f5bc'),
    FunctionInfo('CLEAN', 'Text', '', 'clean-function-26f3d7c5-475f-4a9c-90e5-4b8ba987ba41'),
    FunctionInfo('CODE', 'Text', '', 'code-function-c32b692b-2ed0-4a04-bdd9-75640144b928'),
    FunctionInfo('COLUMN', 'Lookup and reference', '', 'column-function-44e8c754-711c-4df3-9da4-47a55042554b'),
    FunctionInfo('COLUMNS', 'Lookup and reference', '', 'columns-function-4e8e7b4e-e603-43e8-b177-956088fa48ca'),
    FunctionInfo('COMBIN', 'Math and trigonometry', '', 'combin-function-12a3f276-0a21-423a-8de6-06990aaf638a'),
    FunctionInfo('COMBINA', 'Math and trigonometry', 'Excel 2013', 'combina-function-efb49eaa-4f4c-4cd2-8179-0ddfcf9d035d'),
    FunctionInfo('COMPLEX', 'Engineering', '', 'complex-function-f0b8f3a9-51cc-4d6d-86fb-3a9362fa4128'),
    FunctionInfo('CONCAT', 'Text', 'Excel 2019', 'concat-function-9b1a9a3f-94ff-41af-9736-694cbd6b4ca2'),
    FunctionInfo('CONCATENATE', 'Text', '', 'concatenate-function-8f8ae884-2ca8-4f7a-b093-75d702bea31d'),
    FunctionInfo('CONFIDENCE', 'Compatibility', '', 'confidence-function-75ccc007-f77c-4343-bc14-673642091ad6'),
    FunctionInfo('CONFIDENCE.NORM', 'Statistical', 'Excel 2010', 'confidence-norm-function-7cec58a6-85bb-488d-91c3-63828d4fbfd4'),
    FunctionInfo('CONFIDENCE.T', 'Statistical', 'Excel 2010', 'confidence-t-function-e8eca395-6c3a-4ba9-9003-79ccc61d3c53'),
    FunctionInfo('CONVERT', 'Engineering', '', 'convert-function-d785bef1-808e-4aac-bdcd-666c810f9af2'),
    FunctionInfo('CORREL', 'Statistical', '', 'correl-function-995dcef7-0c0a-4bed-a3fb-239d7b68ca92'),
    FunctionInfo('COS', 'Math and trigonometry', '', 'cos-function-0fb808a5-95d6-4553-8148-22aebdce5f05'),
    FunctionInfo('COSH', 'Math and trigonometry', '', 'cosh-function-e460d426-c471-43e8-9540-a57ff3b70555'),
    FunctionInfo('COT', 'Math and trigonometry', 'Excel 2013', 'cot-function-c446f34d-6fe4-40dc-84f8-cf59e5f5e31a'),
    FunctionInfo('COTH', 'Math and trigonometry', 'Excel 2013', 'coth-function-2e0b4cb6-0ba0-403e-aed4-deaa71b49df5'),
    FunctionInfo('COUNT', 'Statistical', '', 'count-function-a59cd7fc-b623-4d93-87a4-d23bf411294c'),
    FunctionInfo('COUNTA', 'Statistical', '', 'counta-function-7dc98875-d5c1-46f1-9a82-53f3219e2509'),
    FunctionInfo('COUNTBLANK', 'Statistical', '', 'countblank-function-6a92d772-675c-4bee-b346-24af6bd3ac22'),
    FunctionInfo('COUNTIF', 'Statistical', '', 'countif-function-e0de10c6-f885-4e71-abb4-1f464816df34'),
    FunctionInfo('COUNTIFS', 'Statistical', '', 'countifs-function-dda3dc6e-f74e-4aee-88bc-aa8c2a866842'),
    FunctionInfo('COUPDAYBS', 'Financial', '', 'coupdaybs-function-eb9a8dfb-2fb2-4c61-8e5d-690b320cf872'),
    FunctionInfo('COUPDAYS', 'Financial', '', 'coupdays-function-cc64380b-315b-4e7b-950c-b30b0a76f671'),
    FunctionInfo('COUPDAYSNC', 'Financial', '', 'coupdaysnc-function-5ab3f0b2-029f-4a8b-bb65-47d525eea547'),
    FunctionInfo('COUPNCD', 'Financial', '', 'coupncd-function-fd962fef-506b-4d9d-8590-16df5393691f'),
    FunctionInfo('COUPNUM', 'Financial', '', 'coupnum-function-a90af57b-de53-4969-9c99-dd6139db2522'),
    FunctionInfo('COUPPCD', 'Financial', '', 'couppcd-function-2eb50473-6ee9-4052-a206-77a9a385d5b3'),
    FunctionInfo('COVAR', 'Compatibility', '', 'covar-function-50479552-2c03-4daf-bd71-a5ab88b2db03'),
    FunctionInfo('COVARIANCE.P', 'Statistical', 'Excel 2010', 'covariance-p-function-6f0e1e6d-956d-4e4b-9943-cfef0bf9edfc'),
    FunctionInfo('COVARIANCE.S', 'Statistical', 'Excel 2010', 'covariance-s-function-0a539b74-7371-42aa-a18f-1f5320314977'),
    FunctionInfo('CRITBINOM', 'Compatibility', '', 'critbinom-function-eb6b871d-796b-4d21-b69b-e4350d5f407b'),
    FunctionInfo('CSC', 'Math and trigonometry', 'Excel 2013', 'csc-function-07379361-219a-4398-8675-07ddc4f135c1'),
    FunctionInfo('CSCH', 'Math and trigonometry', 'Excel 2013', 'csch-function-f58f2c22-eb75-4dd6-84f4-a503527f8eeb'),
    FunctionInfo('CUBEKPIMEMBER', 'Cube', '', 'cubekpimember-function-744608bf-2c62-42cd-b67a-a56109f4b03b'),
    FunctionInfo('CUBEMEMBER', 'Cube', '', 'cubemember-function-0f6a15b9-2c18-4819-ae89-e1b5c8b398ad'),
    FunctionInfo('CUBEMEMBERPROPERTY', 'Cube', '', 'cubememberproperty-function-001e57d6-b35a-49e5-abcd-05ff599e8951'),
    FunctionInfo('CUBERANKEDMEMBER', 'Cube', '', 'cuberankedmember-function-07efecde-e669-4075-b4bf-6b40df2dc4b3'),
    FunctionInfo('CUBESET', 'Cube', '', 'cubeset-function-5b2146bd-62d6-4d04-9d8f-670e993ee1d9'),
    FunctionInfo('CUBESETCOUNT', 'Cube', '', 'cubesetcount-function-c4c2a438-c1ff-4061-80fe-982f2d705286'),
    FunctionInfo('CUBEVALUE', 'Cube', '', 'cubevalue-function-8733da24-26d1-4e34-9b3a-84a8f00dcbe0'),
    FunctionInfo('CUMIPMT', 'Financial', '', 'cumipmt-function-61067bb0-9016-427d-b95b-1a752af0e606'),
    FunctionInfo('CUMPRINC', 'Financial', '', 'cumprinc-function-94a4516d-bd65-41a1-bc16-053a6af4c04d'),
    FunctionInfo('DATE', 'Date and time', '', 'date-function-e36c0c8c-4104-49da-ab83-82328b832349'),
    FunctionInfo('DATEDIF', 'Date and time', '', 'datedif-function-25dba1a4-2812-480b-84dd-8b32a451b35c'),
    FunctionInfo('DATEVALUE', 'Date and time', '', 'datevalue-function-df8b07d4-7761-4a93-bc33-b7471bbff252'),
    FunctionInfo('DAVERAGE', 'Database', '', 'daverage-function-a6a2d5ac-4b4b-48cd-a1d8-7b37834e5aee'),
    FunctionInfo('DAY', 'Date and time', '', 'day-function-8a7d1cbb-6c7d-4ba1-8aea-25c134d03101'),
    FunctionInfo('DAYS', 'Date and time', 'Excel 2013', 'days-function-57740535-d549-4395-8728-0f07bff0b9df'),
    FunctionInfo('DAYS360', 'Date and time', '', 'days360-function-b9a509fd-49ef-407e-94df-0cbda5718c2a'),
    FunctionInfo('DB', 'Financial', '', 'db-function-354e7d28-5f93-4ff1-8a52-eb4ee549d9d7'),
    FunctionInfo('DBCS', 'Text', 'Excel 2013', 'dbcs-function-a4025e73-63d2-4958-9423-21a24794c9e5'),
    FunctionInfo('DCOUNT', 'Database', '', 'dcount-function-c1fc7b93-fb0d-4d8d-97db-8d5f076eaeb1'),
    FunctionInfo('DCOUNTA', 'Database', '', 'dcounta-function-00232a6d-5a66-4a01-a25b-c1653fda1244'),
    FunctionInfo('DDB', 'Financial', '', 'ddb-function-519a7a37-8772-4c96-85c0-ed2c209717a5'),
    FunctionInfo('DEC2BIN', 'Engineering', '', 'dec2bin-function-0f63dd0e-5d1a-42d8-b511-5bf5c6d43838'),
    FunctionInfo('DEC2HEX', 'Engineering', '', 'dec2hex-function-6344ee8b-b6b5-4c6a-a672-f64666704619'),
    FunctionInfo('DEC2OCT', 'Engineering', '', 'dec2oct-function-c9d835ca-20b7-40c4-8a9e-d3be351ce00f'),
    FunctionInfo('DECIMAL', 'Math and trigonometry', 'Excel 2013', 'decimal-function-ee554665-6176-46ef-82de-0a283658da2e'),
    FunctionInfo('DEGREES', 'Math and trigonometry', '', 'degrees-function-4d6ec4db-e694-4b94-ace0-1cc3f61f9ba1'),
    FunctionInfo('DELTA', 'Engineering', '', 'delta-function-2f763672-c959-4e07-ac33-fe03220ba432'),
    FunctionInfo('DEVSQ', 'Statistical', '', 'devsq-function-8b739616-8376-4df5-8bd0-cfe0a6caf444'),
    FunctionInfo('DGET', 'Database', '', 'dget-function-455568bf-4eef-45f7-90f0-ec250d00892e'),
    FunctionInfo('DISC', 'Financial', '', 'disc-function-71fce9f3-3f05-4acf-a5a3-eac6ef4daa53'),
    FunctionInfo('DMAX', 'Database', '', 'dmax-function-f4e8209d-8958-4c3d-a1ee-6351665d41c2'),
    FunctionInfo('DMIN', 'Database', '', 'dmin-function-4ae6f1d9-1f26-40f1-a783-6dc3680192a3'),
    FunctionInfo('DOLLAR', 'Text', '', 'dollar-function-a6cd05d9-9740-4ad3-a469-8109d18ff611'),
    FunctionInfo('DOLLARDE', 'Financial', '', 'dollarde-function-db85aab0-1677-428a-9dfd-a38476693427'),
    FunctionInfo('DOLLARFR', 'Financial', '', 'dollarfr-function-0835d163-3023-4a33-9824-3042c5d4f495'),
    FunctionInfo('DPRODUCT', 'Database', '', 'dproduct-function-4f96b13e-d49c-47a7-b769-22f6d017cb31'),
    FunctionInfo('DSTDEV', 'Database', '', 'dstdev-function-026b8c73-616d-4b5e-b072-241871c4ab96'),
    FunctionInfo('DSTDEVP', 'Database', '', 'dstdevp-function-04b78995-da03-4813-bbd9-d74fd0f5d94b'),
    FunctionInfo('DSUM', 'Database', '', 'dsum-function-53181285-0c4b-4f5a-aaa3-529a322be41b'),
    FunctionInfo('DURATION', 'Financial', '', 'duration-function-b254ea57-eadc-4602-a86a-c8e369334038'),
    FunctionInfo('DVAR', 'Database', '', 'dvar-function-d6747ca9-99c7-48bb-996e-9d7af00f3ed1'),
    FunctionInfo('DVARP', 'Database', '', 'dvarp-function-eb0ba387-9cb7-45c8-81e9-0394912502fc'),
    FunctionInfo('EDATE', 'Date and time', '', 'edate-function-3c920eb2-6e66-44e7-a1f5-753ae47ee4f5'),
    FunctionInfo('EFFECT', 'Financial', '', 'effect-function-910d4e4c-79e2-4009-95e6-507e04f11bc4'),
    FunctionInfo('ENCODEURL', 'Web', 'Excel 2013', 'encodeurl-function-07c7fb90-7c60-4bff-8687-fac50fe33d0e'),
    FunctionInfo('EOMONTH', 'Date and time', '', 'eomonth-function-7314ffa1-2bc9-4005-9d66-f49db127d628'),
    FunctionInfo('ERF', 'Engineering', '', 'erf-function-c53c7e7b-5482-4b6c-883e-56df3c9af349'),
    FunctionInfo('ERF.PRECISE', 'Engineering', 'Excel 2010', 'erf-precise-function-9a349593-705c-4278-9a98-e4122831a8e0'),
    FunctionInfo('ERFC', 'Engineering', '', 'erfc-function-736e0318-70ba-4e8b-8d08-461fe68b71b3'),
    FunctionInfo('ERFC.PRECISE', 'Engineering', 'Excel 2010', 'erfc-precise-function-e90e6bab-f45e-45df-b2ac-cd2eb4d4a273'),
    FunctionInfo('ERROR.TYPE', 'Information', '', 'error-type-function-10958677-7c8d-44f7-ae77-b9a9ee6eefaa'),
    FunctionInfo('EUROCONVERT', 'Add-in and Automation', '', 'euroconvert-function-79c8fd67-c665-450c-bb6c-15fc92f8345c'),
    FunctionInfo('EVEN', 'Math and trigonometry', '', 'even-function-197b5f06-c795-4c1e-8696-3c3b8a646cf9'),
    FunctionInfo('EXACT', 'Text', '', 'exact-function-d3087698-fc15-4a15-9631-12575cf29926'),
    FunctionInfo('EXP', 'Math and trigonometry', '', 'exp-function-c578f034-2c45-4c37-bc8c-329660a63abe'),
    FunctionInfo('EXPON.DIST', 'Statistical', 'Excel 2010', 'expon-dist-function-4c12ae24-e563-4155-bf3e-8b78b6ae140e'),
    FunctionInfo('EXPONDIST', 'Compatibility', '', 'expondist-function-68ab45fd-cd6d-4887-9770-9357eb8ee06a'),
    FunctionInfo('FACT', 'Math and trigonometry', '', 'fact-function-ca8588c2-15f2-41c0-8e8c-c11bd471a4f3'),
    FunctionInfo('FACTDOUBLE', 'Math and trigonometry', '', 'factdouble-function-e67697ac-d214-48eb-b7b7-cce2589ecac8'),
    FunctionInfo('FALSE', 'Logical', '', 'false-function-2d58dfa5-9c03-4259-bf8f-f0ae14346904'),
    FunctionInfo('F.DIST', 'Statistical', 'Excel 2010', 'f-dist-function-a887efdc-7c8e-46cb-a74a-f884cd29b25d'),
    FunctionInfo('FDIST', 'Compatibility', '', 'fdist-function-ecf76fba-b3f1-4e7d-a57e-6a5b7460b786'),
    FunctionInfo('F.DIST.RT', 'Statistical', 'Excel 2010', 'f-dist-rt-function-d74cbb00-6017-4ac9-b7d7-6049badc0520'),
    FunctionInfo('FILTER', 'Lookup and reference', 'Office 365', 'filter-function-f4f7cb66-82eb-4767-8f7c-4877ad80c759'),
    FunctionInfo('FILTERXML', 'Web', 'Excel 2013', 'filterxml-function-4df72efc-11ec-4951-86f5-c1374812f5b7'),
    FunctionInfo('FIND', 'Text', '', 'find-findb-functions-c7912941-af2a-4bdf-a553-d0d89b0a0628'),
    FunctionInfo('FINDB', 'Text', '', 'find-findb-functions-c7912941-af2a-4bdf-a553-d0d89b0a0628'),
    FunctionInfo('F.INV', 'Statistical', 'Excel 2010', 'f-inv-function-0dda0cf9-4ea0-42fd-8c3c-417a1ff30dbe'),
    FunctionInfo('F.INV.RT', 'Statistical', 'Excel 2010', 'f-inv-rt-function-d371aa8f-b0b1-40ef-9cc2-496f0693ac00'),
    FunctionInfo('FINV', 'Compatibility', '', 'finv-function-4d46c97c-c368-4852-bc15-41e8e31140b1'),
    FunctionInfo('FISHER', 'Statistical', '', 'fisher-function-d656523c-5076-4f95-b87b-7741bf236c69'),
    FunctionInfo('FISHERINV', 'Statistical', '', 'fisherinv-function-62504b39-415a-4284-a285-19c8e82f86bb'),
    FunctionInfo('FIXED', 'Text', '', 'fixed-function-ffd5723c-324c-45e9-8b96-e41be2a8274a'),
    FunctionInfo('FLOOR', 'Compatibility', '', 'floor-function-14bb497c-24f2-4e04-b327-b0b4de5a8886'),
    FunctionInfo('FLOOR.MATH', 'Math and trigonometry', 'Excel 2013', 'floor-math-function-c302b599-fbdb-4177-ba19-2c2b1249a2f5'),
    FunctionInfo('FLOOR.PRECISE', 'Math and trigonometry', '', 'floor-precise-function-f769b468-1452-4617-8dc3-02f842a0702e'),
    FunctionInfo('FORECAST', 'Statistical', '', 'forecasting-functions-reference-897a2fe9-6595-4680-a0b0-93e0308d5f6e'),
    FunctionInfo('FORECAST.ETS', 'Statistical', 'Excel 2016', 'forecasting-functions-reference-897a2fe9-6595-4680-a0b0-93e0308d5f6e#_forecast.ets'),
    FunctionInfo('FORECAST.ETS.CONFINT', 'Statistical', 'Excel 2016', 'forecasting-functions-reference-897a2fe9-6595-4680-a0b0-93e0308d5f6e#_forecast.ets.confint'),
    FunctionInfo('FORECAST.ETS.SEASONALITY', 'Statistical', 'Excel 2016', 'forecasting-functions-reference-897a2fe9-6595-4680-a0b0-93e0308d5f6e#_forecast.ets.seasonality'),
    FunctionInfo('FORECAST.ETS.STAT', 'Statistical', 'Excel 2016', 'forecasting-functions-reference-897a2fe9-6595-4680-a0b0-93e0308d5f6e#_forecast.ets.stat'),
    FunctionInfo('FORECAST.LINEAR', 'Statistical', 'Excel 2016', 'forecasting-functions-reference-897a2fe9-6595-4680-a0b0-93e0308d5f6e#_forecast.linear'),
    FunctionInfo('FORMULATEXT', 'Lookup and reference', 'Excel 2013', 'formulatext-function-0a786771-54fd-4ae2-96ee-09cda35439c8'),
    FunctionInfo('FREQUENCY', 'Statistical', '', 'frequency-function-44e3be2b-eca0-42cd-a3f7-fd9ea898fdb9'),
    FunctionInfo('F.TEST', 'Statistical', 'Excel 2010', 'f-test-function-100a59e7-4108-46f8-8443-78ffacb6c0a7'),
    FunctionInfo('FTEST', 'Compatibility', '', 'ftest-function-4c9e1202-53fe-428c-a737-976f6fc3f9fd'),
    FunctionInfo('FV', 'Financial', '', 'fv-function-2eef9f44-a084-4c61-bdd8-4fe4bb1b71b3'),
    FunctionInfo('FVSCHEDULE', 'Financial', '', 'fvschedule-function-bec29522-bd87-4082-bab9-a241f3fb251d'),
    FunctionInfo('GAMMA', 'Statistical', 'Excel 2013', 'gamma-function-ce1702b1-cf55-471d-8307-f83be0fc5297'),
    FunctionInfo('GAMMA.DIST', 'Statistical', 'Excel 2010', 'gamma-dist-function-9b6f1538-d11c-4d5f-8966-21f6a2201def'),
    FunctionInfo('GAMMADIST', 'Compatibility', '', 'gammadist-function-7327c94d-0f05-4511-83df-1dd7ed23e19e'),
    FunctionInfo('GAMMA.INV', 'Statistical', 'Excel 2010', 'gamma-inv-function-74991443-c2b0-4be5-aaab-1aa4d71fbb18'),
    FunctionInfo('GAMMAINV', 'Compatibility', '', 'gammainv-function-06393558-37ab-47d0-aa63-432f99e7916d'),
    FunctionInfo('GAMMALN', 'Statistical', '', 'gammaln-function-b838c48b-c65f-484f-9e1d-141c55470eb9'),
    FunctionInfo('GAMMALN.PRECISE', 'Statistical', 'Excel 2010', 'gammaln-precise-function-5cdfe601-4e1e-4189-9d74-241ef1caa599'),
    FunctionInfo('GAUSS', 'Statistical', 'Excel 2013', 'gauss-function-069f1b4e-7dee-4d6a-a71f-4b69044a6b33'),
    FunctionInfo('GCD', 'Math and trigonometry', '', 'gcd-function-d5107a51-69e3-461f-8e4c-ddfc21b5073a'),
    FunctionInfo('GEOMEAN', 'Statistical', '', 'geomean-function-db1ac48d-25a5-40a0-ab83-0b38980e40d5'),
    FunctionInfo('GESTEP', 'Engineering', '', 'gestep-function-f37e7d2a-41da-4129-be95-640883fca9df'),
    FunctionInfo('GETPIVOTDATA', 'Lookup and reference', '', 'getpivotdata-function-8c083b99-a922-4ca0-af5e-3af55960761f'),
    FunctionInfo('GROWTH', 'Statistical', '', 'growth-function-541a91dc-3d5e-437d-b156-21324e68b80d'),
    FunctionInfo('HARMEAN', 'Statistical', '', 'harmean-function-5efd9184-fab5-42f9-b1d3-57883a1d3bc6'),
    FunctionInfo('HEX2BIN', 'Engineering', '', 'hex2bin-function-a13aafaa-5737-4920-8424-643e581828c1'),
    FunctionInfo('HEX2DEC', 'Engineering', '', 'hex2dec-function-8c8c3155-9f37-45a5-a3ee-ee5379ef106e'),
    FunctionInfo('HEX2OCT', 'Engineering', '', 'hex2oct-function-54d52808-5d19-4bd0-8a63-1096a5d11912'),
    FunctionInfo('HLOOKUP', 'Lookup and reference', '', 'hlookup-function-a3034eec-b719-4ba3-bb65-e1ad662ed95f'),
    FunctionInfo('HOUR', 'Date and time', '', 'hour-function-a3afa879-86cb-4339-b1b5-2dd2d7310ac7'),
    FunctionInfo('HYPERLINK', 'Lookup and reference', '', 'hyperlink-function-333c7ce6-c5ae-4164-9c47-7de9b76f577f'),
    FunctionInfo('HYPGEOM.DIST', 'Statistical', '', 'hypgeom-dist-function-6dbd547f-1d12-4b1f-8ae5-b0d9e3d22fbf'),
    FunctionInfo('HYPGEOMDIST', 'Compatibility', '', 'hypgeomdist-function-23e37961-2871-4195-9629-d0b2c108a12e'),
    FunctionInfo('IF', 'Logical', '', 'if-function-69aed7c9-4e8a-4755-a9bc-aa8bbff73be2'),
    FunctionInfo('IFERROR', 'Logical', '', 'iferror-function-c526fd07-caeb-47b8-8bb6-63f3e417f611'),
    FunctionInfo('IFNA', 'Logical', 'Excel 2013', 'ifna-function-6626c961-a569-42fc-a49d-79b4951fd461'),
    FunctionInfo('IFS', 'Logical', 'Excel 2019', 'ifs-function-36329a26-37b2-467c-972b-4a39bd951d45'),
    FunctionInfo('IMABS', 'Engineering', '', 'imabs-function-b31e73c6-d90c-4062-90bc-8eb351d765a1'),
    FunctionInfo('IMAGINARY', 'Engineering', '', 'imaginary-function-dd5952fd-473d-44d9-95a1-9a17b23e428a'),
    FunctionInfo('IMARGUMENT', 'Engineering', '', 'imargument-function-eed37ec1-23b3-4f59-b9f3-d340358a034a'),
    FunctionInfo('IMCONJUGATE', 'Engineering', '', 'imconjugate-function-2e2fc1ea-f32b-4f9b-9de6-233853bafd42'),
    FunctionInfo('IMCOS', 'Engineering', '', 'imcos-function-dad75277-f592-4a6b-ad6c-be93a808a53c'),
    FunctionInfo('IMCOSH', 'Engineering', 'Excel 2013', 'imcosh-function-053e4ddb-4122-458b-be9a-457c405e90ff'),
    FunctionInfo('IMCOT', 'Engineering', 'Excel 2013', 'imcot-function-dc6a3607-d26a-4d06-8b41-8931da36442c'),
    FunctionInfo('IMCSC', 'Engineering', 'Excel 2013', 'imcsc-function-9e158d8f-2ddf-46cd-9b1d-98e29904a323'),
    FunctionInfo('IMCSCH', 'Engineering', 'Excel 2013', 'imcsch-function-c0ae4f54-5f09-4fef-8da0-dc33ea2c5ca9'),
    FunctionInfo('IMDIV', 'Engineering', '', 'imdiv-function-a505aff7-af8a-4451-8142-77ec3d74d83f'),
    FunctionInfo('IMEXP', 'Engineering', '', 'imexp-function-c6f8da1f-e024-4c0c-b802-a60e7147a95f'),
    FunctionInfo('IMLN', 'Engineering', '', 'imln-function-32b98bcf-8b81-437c-a636-6fb3aad509d8'),
    FunctionInfo('IMLOG10', 'Engineering', '', 'imlog10-function-58200fca-e2a2-4271-8a98-ccd4360213a5'),
    FunctionInfo('IMLOG2', 'Engineering', '', 'imlog2-function-152e13b4-bc79-486c-a243-e6a676878c51'),
    FunctionInfo('IMPOWER', 'Engineering', '', 'impower-function-210fd2f5-f8ff-4c6a-9d60-30e34fbdef39'),
    FunctionInfo('IMPRODUCT', 'Engineering', '', 'improduct-function-2fb8651a-a4f2-444f-975e-8ba7aab3a5ba'),
    FunctionInfo('IMREAL', 'Engineering', '', 'imreal-function-d12bc4c0-25d0-4bb3-a25f-ece1938bf366'),
    FunctionInfo('IMSEC', 'Engineering', 'Excel 2013', 'imsec-function-6df11132-4411-4df4-a3dc-1f17372459e0'),
    FunctionInfo('IMSECH', 'Engineering', 'Excel 2013', 'imsech-function-f250304f-788b-4505-954e-eb01fa50903b'),
    FunctionInfo('IMSIN', 'Engineering', '', 'imsin-function-1ab02a39-a721-48de-82ef-f52bf37859f6'),
    FunctionInfo('IMSINH', 'Engineering', 'Excel 2013', 'imsinh-function-dfb9ec9e-8783-4985-8c42-b028e9e8da3d'),
    FunctionInfo('IMSQRT', 'Engineering', '', 'imsqrt-function-e1753f80-ba11-4664-a10e-e17368396b70'),
    FunctionInfo('IMSUB', 'Engineering', '', 'imsub-function-2e404b4d-4935-4e85-9f52-cb08b9a45054'),
    FunctionInfo('IMSUM', 'Engineering', '', 'imsum-function-81542999-5f1c-4da6-9ffe-f1d7aaa9457f'),
    FunctionInfo('IMTAN', 'Engineering', 'Excel 2013', 'imtan-function-8478f45d-610a-43cf-8544-9fc0b553a132'),
    FunctionInfo('INDEX', 'Lookup and reference', '', 'index-function-a5dcf0dd-996d-40a4-a822-b56b061328bd'),
    FunctionInfo('INDIRECT', 'Lookup and reference', '', 'indirect-function-474b3a3a-8a26-4f44-b491-92b6306fa261'),
    FunctionInfo('INFO', 'Information', '', 'info-function-725f259a-0e4b-49b3-8b52-58815c69acae'),
    FunctionInfo('INT', 'Math and trigonometry', '', 'int-function-a6c4af9e-356d-4369-ab6a-cb1fd9d343ef'),
    FunctionInfo('INTERCEPT', 'Statistical', '', 'intercept-function-2a9b74e2-9d47-4772-b663-3bca70bf63ef'),
    FunctionInfo('INTRATE', 'Financial', '', 'intrate-function-5cb34dde-a221-4cb6-b3eb-0b9e55e1316f'),
    FunctionInfo('IPMT', 'Financial', '', 'ipmt-function-5cce0ad6-8402-4a41-8d29-61a0b054cb6f'),
    FunctionInfo('IRR', 'Financial', '', 'irr-function-64925eaa-9988-495b-b290-3ad0c163c1bc'),
    FunctionInfo('ISBLANK', 'Information', '', 'is-functions-0f2d7971-6019-40a0-a171-f2d869135665'),
    FunctionInfo('ISERR', 'Information', '', 'is-functions-0f2d7971-6019-40a0-a171-f2d869135665'),
    FunctionInfo('ISERROR', 'Information', '', 'is-functions-0f2d7971-6019-40a0-a171-f2d869135665'),
    FunctionInfo('ISEVEN', 'Information', '', 'iseven-function-aa15929a-d77b-4fbb-92f4-2f479af55356'),
    FunctionInfo('ISFORMULA', 'Information', 'Excel 2013', 'isformula-function-e4d1355f-7121-4ef2-801e-3839bfd6b1e5'),
    FunctionInfo('ISLOGICAL', 'Information', '', 'is-functions-0f2d7971-6019-40a0-a171-f2d869135665'),
    FunctionInfo('ISNA', 'Information', '', 'is-functions-0f2d7971-6019-40a0-a171-f2d869135665'),
    FunctionInfo('ISNONTEXT', 'Information', '', 'is-functions-0f2d7971-6019-40a0-a171-f2d869135665'),
    FunctionInfo('ISNUMBER', 'Information', '', 'is-functions-0f2d7971-6019-40a0-a171-f2d869135665'),
    FunctionInfo('ISODD', 'Information', '', 'is-functions-0f2d7971-6019-40a0-a171-f2d869135665'),
    FunctionInfo('ISREF', 'Information', '', 'is-functions-0f2d7971-6019-40a0-a171-f2d869135665'),
    FunctionInfo('ISTEXT', 'Information', '', 'is-functions-0f2d7971-6019-40a0-a171-f2d869135665'),
    FunctionInfo('ISO.CEILING', 'Math and trigonometry', 'Excel 2013', 'iso-ceiling-function-e587bb73-6cc2-4113-b664-ff5b09859a83'),
    FunctionInfo('ISOWEEKNUM', 'Date and time', 'Excel 2013', 'isoweeknum-function-1c2d0afe-d25b-4ab1-8894-8d0520e90e0e'),
    FunctionInfo('ISPMT', 'Financial', '', 'ispmt-function-fa58adb6-9d39-4ce0-8f43-75399cea56cc'),
    FunctionInfo('JIS', 'Text', '', 'jis-function-b72fb1a7-ba52-448a-b7d3-d2610868b7e2'),
    FunctionInfo('KURT', 'Statistical', '', 'kurt-function-bc3a265c-5da4-4dcb-b7fd-c237789095ab'),
    FunctionInfo('LARGE', 'Statistical', '', 'large-function-3af0af19-1190-42bb-bb8b-01672ec00a64'),
    FunctionInfo('LCM', 'Math and trigonometry', '', 'lcm-function-7152b67a-8bb5-4075-ae5c-06ede5563c94'),
    FunctionInfo('LEFT', 'Text', '', 'left-leftb-functions-9203d2d2-7960-479b-84c6-1ea52b99640c'),
    FunctionInfo('LEFTB', 'Text', '', 'left-leftb-functions-9203d2d2-7960-479b-84c6-1ea52b99640c'),
    FunctionInfo('LEN', 'Text', '', 'len-lenb-functions-29236f94-cedc-429d-affd-b5e33d2c67cb'),
    FunctionInfo('LENB', 'Text', '', 'len-lenb-functions-29236f94-cedc-429d-affd-b5e33d2c67cb'),
    FunctionInfo('LET', 'Math and trigonometry', 'Office 365', 'let-function-34842dd8-b92b-4d3f-b325-b8b8f9908999'),
    FunctionInfo('LINEST', 'Statistical', '', 'linest-function-84d7d0d9-6e50-4101-977a-fa7abf772b6d'),
    FunctionInfo('LN', 'Math and trigonometry', '', 'ln-function-81fe1ed7-dac9-4acd-ba1d-07a142c6118f'),
    FunctionInfo('LOG', 'Math and trigonometry', '', 'log-function-4e82f196-1ca9-4747-8fb0-6c4a3abb3280'),
    FunctionInfo('LOG10', 'Math and trigonometry', '', 'log10-function-c75b881b-49dd-44fb-b6f4-37e3486a0211'),
    FunctionInfo('LOGEST', 'Statistical', '', 'logest-function-f27462d8-3657-4030-866b-a272c1d18b4b'),
    FunctionInfo('LOGINV', 'Compatibility', '', 'loginv-function-0bd7631a-2725-482b-afb4-de23df77acfe'),
    FunctionInfo('LOGNORM.DIST', 'Statistical', 'Excel 2010', 'lognorm-dist-function-eb60d00b-48a9-4217-be2b-6074aee6b070'),
    FunctionInfo('LOGNORMDIST', 'Compatibility', '', 'lognormdist-function-f8d194cb-9ee3-4034-8c75-1bdb3884100b'),
    FunctionInfo('LOGNORM.INV', 'Statistical', 'Excel 2010', 'lognorm-inv-function-fe79751a-f1f2-4af8-a0a1-e151b2d4f600'),
    FunctionInfo('LOOKUP', 'Lookup and reference', '', 'lookup-function-446d94af-663b-451d-8251-369d5e3864cb'),
    FunctionInfo('LOWER', 'Text', '', 'lower-function-3f21df02-a80c-44b2-afaf-81358f9fdeb4'),
    FunctionInfo('MATCH', 'Lookup and reference', '', 'match-function-e8dffd45-c762-47d6-bf89-533f4a37673a'),
    FunctionInfo('MAX', 'Statistical', '', 'max-function-e0012414-9ac8-4b34-9a47-73e662c08098'),
    FunctionInfo('MAXA', 'Statistical', '', 'maxa-function-814bda1e-3840-4bff-9365-2f59ac2ee62d'),
    FunctionInfo('MAXIFS', 'Statistical', 'Excel 2019', 'maxifs-function-dfd611e6-da2c-488a-919b-9b6376b28883'),
    FunctionInfo('MDETERM', 'Math and trigonometry', '', 'mdeterm-function-e7bfa857-3834-422b-b871-0ffd03717020'),
    FunctionInfo('MDURATION', 'Financial', '', 'mduration-function-b3786a69-4f20-469a-94ad-33e5b90a763c'),
    FunctionInfo('MEDIAN', 'Statistical', '', 'median-function-d0916313-4753-414c-8537-ce85bdd967d2'),
    FunctionInfo('MID', 'Text', '', 'mid-midb-functions-d5f9e25c-d7d6-472e-b568-4ecb12433028'),
    FunctionInfo('MIDB', 'Text', '', 'mid-midb-functions-d5f9e25c-d7d6-472e-b568-4ecb12433028'),
    FunctionInfo('MIN', 'Statistical', '', 'min-function-61635d12-920f-4ce2-a70f-96f202dcc152'),
    FunctionInfo('MINIFS', 'Statistical', 'Excel 2019', 'minifs-function-6ca1ddaa-079b-4e74-80cc-72eef32e6599'),
    FunctionInfo('MINA', 'Statistical', '', 'mina-function-245a6f46-7ca5-4dc7-ab49-805341bc31d3'),
    FunctionInfo('MINUTE', 'Date and time', '', 'minute-function-af728df0-05c4-4b07-9eed-a84801a60589'),
    FunctionInfo('MINVERSE', 'Math and trigonometry', '', 'minverse-function-11f55086-adde-4c9f-8eb9-59da2d72efc6'),
    FunctionInfo('MIRR', 'Financial', '', 'mirr-function-b020f038-7492-4fb4-93c1-35c345b53524'),
    FunctionInfo('MMULT', 'Math and trigonometry', '', 'mmult-function-40593ed7-a3cd-4b6b-b9a3-e4ad3c7245eb'),
    FunctionInfo('MOD', 'Math and trigonometry', '', 'mod-function-9b6cd169-b6ee-406a-a97b-edf2a9dc24f3'),
    FunctionInfo('MODE', 'Compatibility', '', 'mode-function-e45192ce-9122-4980-82ed-4bdc34973120'),
    FunctionInfo('MODE.MULT', 'Statistical', 'Excel 2010', 'mode-mult-function-50fd9464-b2ba-4191-b57a-39446689ae8c'),
    FunctionInfo('MODE.SNGL', 'Statistical', 'Excel 2010', 'mode-sngl-function-f1267c16-66c6-4386-959f-8fba5f8bb7f8'),
    FunctionInfo('MONTH', 'Date and time', '', 'month-function-579a2881-199b-48b2-ab90-ddba0eba86e8'),
    FunctionInfo('MROUND', 'Math and trigonometry', '', 'mround-function-c299c3b0-15a5-426d-aa4b-d2d5b3baf427'),
    FunctionInfo('MULTINOMIAL', 'Math and trigonometry', '', 'multinomial-function-6fa6373c-6533-41a2-a45e-a56db1db1bf6'),
    FunctionInfo('MUNIT', 'Math and trigonometry', 'Excel 2013', 'munit-function-c9fe916a-dc26-4105-997d-ba22799853a3'),
    FunctionInfo('N', 'Information', '', 'n-function-a624cad1-3635-4208-b54a-29733d1278c9'),
    FunctionInfo('NA', 'Information', '', 'na-function-5469c2d1-a90c-4fb5-9bbc-64bd9bb6b47c'),
    FunctionInfo('NEGBINOM.DIST', 'Statistical', 'Excel 2010', 'negbinom-dist-function-c8239f89-c2d0-45bd-b6af-172e570f8599'),
    FunctionInfo('NEGBINOMDIST', 'Compatibility', '', 'negbinomdist-function-f59b0a37-bae2-408d-b115-a315609ba714'),
    FunctionInfo('NETWORKDAYS', 'Date and time', '', 'networkdays-function-48e717bf-a7a3-495f-969e-5005e3eb18e7'),
    FunctionInfo('NETWORKDAYS.INTL', 'Date and time', 'Excel 2010', 'networkdays-intl-function-a9b26239-4f20-46a1-9ab8-4e925bfd5e28'),
    FunctionInfo('NOMINAL', 'Financial', '', 'nominal-function-7f1ae29b-6b92-435e-b950-ad8b190ddd2b'),
    FunctionInfo('NORM.DIST', 'Statistical', 'Excel 2010', 'norm-dist-function-edb1cc14-a21c-4e53-839d-8082074c9f8d'),
    FunctionInfo('NORMDIST', 'Compatibility', '', 'normdist-function-126db625-c53e-4591-9a22-c9ff422d6d58'),
    FunctionInfo('NORMINV', 'Statistical', '', 'norminv-function-87981ab8-2de0-4cb0-b1aa-e21d4cb879b8'),
    FunctionInfo('NORM.INV', 'Compatibility', 'Excel 2010', 'norm-inv-function-54b30935-fee7-493c-bedb-2278a9db7e13'),
    FunctionInfo('NORM.S.DIST', 'Statistical', 'Excel 2010', 'norm-s-dist-function-1e787282-3832-4520-a9ae-bd2a8d99ba88'),
    FunctionInfo('NORMSDIST', 'Compatibility', '', 'normsdist-function-463369ea-0345-445d-802a-4ff0d6ce7cac'),
    FunctionInfo('NORM.S.INV', 'Statistical', 'Excel 2010', 'norm-s-inv-function-d6d556b4-ab7f-49cd-b526-5a20918452b1'),
    FunctionInfo('NORMSINV', 'Compatibility', '', 'normsinv-function-8d1bce66-8e4d-4f3b-967c-30eed61f019d'),
    FunctionInfo('NOT', 'Logical', '', 'not-function-9cfc6011-a054-40c7-a140-cd4ba2d87d77'),
    FunctionInfo('NOW', 'Date and time', '', 'now-function-3337fd29-145a-4347-b2e6-20c904739c46'),
    FunctionInfo('NPER', 'Financial', '', 'nper-function-240535b5-6653-4d2d-bfcf-b6a38151d815'),
    FunctionInfo('NPV', 'Financial', '', 'npv-function-8672cb67-2576-4d07-b67b-ac28acf2a568'),
    FunctionInfo('NUMBERVALUE', 'Text', 'Excel 2013', 'numbervalue-function-1b05c8cf-2bfa-4437-af70-596c7ea7d879'),
    FunctionInfo('OCT2BIN', 'Engineering', '', 'oct2bin-function-55383471-3c56-4d27-9522-1a8ec646c589'),
    FunctionInfo('OCT2DEC', 'Engineering', '', 'oct2dec-function-87606014-cb98-44b2-8dbb-e48f8ced1554'),
    FunctionInfo('OCT2HEX', 'Engineering', '', 'oct2hex-function-912175b4-d497-41b4-a029-221f051b858f'),
    FunctionInfo('ODD', 'Math and trigonometry', '', 'odd-function-deae64eb-e08a-4c88-8b40-6d0b42575c98'),
    FunctionInfo('ODDFPRICE', 'Financial', '', 'oddfprice-function-d7d664a8-34df-4233-8d2b-922bcf6a69e1'),
    FunctionInfo('ODDFYIELD', 'Financial', '', 'oddfyield-function-66bc8b7b-6501-4c93-9ce3-2fd16220fe37'),
    FunctionInfo('ODDLPRICE', 'Financial', '', 'oddlprice-function-fb657749-d200-4902-afaf-ed5445027fc4'),
    FunctionInfo('ODDLYIELD', 'Financial', '', 'oddlyield-function-c873d088-cf40-435f-8d41-c8232fee9238'),
    FunctionInfo('OFFSET', 'Lookup and reference', '', 'offset-function-c8de19ae-dd79-4b9b-a14e-b4d906d11b66'),
    FunctionInfo('OR', 'Logical', '', 'or-function-7d17ad14-8700-4281-b308-00b131e22af0'),
    FunctionInfo('PDURATION', 'Financial', 'Excel 2013', 'pduration-function-44f33460-5be5-4c90-b857-22308892adaf'),
    FunctionInfo('PEARSON', 'Statistical', '', 'pearson-function-0c3e30fc-e5af-49c4-808a-3ef66e034c18'),
    FunctionInfo('PERCENTILE.EXC', 'Statistical', 'Excel 2010', 'percentile-exc-function-bbaa7204-e9e1-4010-85bf-c31dc5dce4ba'),
    FunctionInfo('PERCENTILE.INC', 'Statistical', 'Excel 2010', 'percentile-inc-function-680f9539-45eb-410b-9a5e-c1355e5fe2ed'),
    FunctionInfo('PERCENTILE', 'Compatibility', '', 'percentile-function-91b43a53-543c-4708-93de-d626debdddca'),
    FunctionInfo('PERCENTRANK.EXC', 'Statistical', 'Excel 2010', 'percentrank-exc-function-d8afee96-b7e2-4a2f-8c01-8fcdedaa6314'),
    FunctionInfo('PERCENTRANK.INC', 'Statistical', 'Excel 2010', 'percentrank-inc-function-149592c9-00c0-49ba-86c1-c1f45b80463a'),
    FunctionInfo('PERCENTRANK', 'Compatibility', '', 'percentrank-function-f1b5836c-9619-4847-9fc9-080ec9024442'),
    FunctionInfo('PERMUT', 'Statistical', '', 'permut-function-3bd1cb9a-2880-41ab-a197-f246a7a602d3'),
    FunctionInfo('PERMUTATIONA', 'Statistical', 'Excel 2013', 'permutationa-function-6c7d7fdc-d657-44e6-aa19-2857b25cae4e'),
    FunctionInfo('PHI', 'Statistical', 'Excel 2013', 'phi-function-23e49bc6-a8e8-402d-98d3-9ded87f6295c'),
    FunctionInfo('PHONETIC', 'Text', '', 'phonetic-function-9a329dac-0c0f-42f8-9a55-639086988554'),
    FunctionInfo('PI', 'Math and trigonometry', '', 'pi-function-264199d0-a3ba-46b8-975a-c4a04608989b'),
    FunctionInfo('PMT', 'Financial', '', 'pmt-function-0214da64-9a63-4996-bc20-214433fa6441'),
    FunctionInfo('POISSON.DIST', 'Statistical', 'Excel 2010', 'poisson-dist-function-8fe148ff-39a2-46cb-abf3-7772695d9636'),
    FunctionInfo('POISSON', 'Compatibility', '', 'poisson-function-d81f7294-9d7c-4f75-bc23-80aa8624173a'),
    FunctionInfo('POWER', 'Math and trigonometry', '', 'power-function-d3f2908b-56f4-4c3f-895a-07fb519c362a'),
    FunctionInfo('PPMT', 'Financial', '', 'ppmt-function-c370d9e3-7749-4ca4-beea-b06c6ac95e1b'),
    FunctionInfo('PRICE', 'Financial', '', 'price-function-3ea9deac-8dfa-436f-a7c8-17ea02c21b0a'),
    FunctionInfo('PRICEDISC', 'Financial', '', 'pricedisc-function-d06ad7c1-380e-4be7-9fd9-75e3079acfd3'),
    FunctionInfo('PRICEMAT', 'Financial', '', 'pricemat-function-52c3b4da-bc7e-476a-989f-a95f675cae77'),
    FunctionInfo('PROB', 'Statistical', '', 'prob-function-9ac30561-c81c-4259-8253-34f0a238fc49'),
    FunctionInfo('PRODUCT', 'Math and trigonometry', '', 'product-function-8e6b5b24-90ee-4650-aeec-80982a0512ce'),
    FunctionInfo('PROPER', 'Text', '', 'proper-function-52a5a283-e8b2-49be-8506-b2887b889f94'),
    FunctionInfo('PV', 'Financial', '', 'pv-function-23879d31-0e02-4321-be01-da16e8168cbd'),
    FunctionInfo('QUARTILE', 'Compatibility', '', 'quartile-function-93cf8f62-60cd-4fdb-8a92-8451041e1a2a'),
    FunctionInfo('QUARTILE.EXC', 'Statistical', 'Excel 2010', 'quartile-exc-function-5a355b7a-840b-4a01-b0f1-f538c2864cad'),
    FunctionInfo('QUARTILE.INC', 'Statistical', 'Excel 2010', 'quartile-inc-function-1bbacc80-5075-42f1-aed6-47d735c4819d'),
    FunctionInfo('QUOTIENT', 'Math and trigonometry', '', 'quotient-function-9f7bf099-2a18-4282-8fa4-65290cc99dee'),
    FunctionInfo('RADIANS', 'Math and trigonometry', '', 'radians-function-ac409508-3d48-45f5-ac02-1497c92de5bf'),
    FunctionInfo('RAND', 'Math and trigonometry', '', 'rand-function-4cbfa695-8869-4788-8d90-021ea9f5be73'),
    FunctionInfo('RANDARRAY', 'Math and trigonometry', 'Office 365', 'randarray-function-21261e55-3bec-4885-86a6-8b0a47fd4d33'),
    FunctionInfo('RANDBETWEEN', 'Math and trigonometry', '', 'randbetween-function-4cc7f0d1-87dc-4eb7-987f-a469ab381685'),
    FunctionInfo('RANK.AVG', 'Statistical', 'Excel 2010', 'rank-avg-function-bd406a6f-eb38-4d73-aa8e-6d1c3c72e83a'),
    FunctionInfo('RANK.EQ', 'Statistical', 'Excel 2010', 'rank-eq-function-284858ce-8ef6-450e-b662-26245be04a40'),
    FunctionInfo('RANK', 'Compatibility', '', 'rank-function-6a2fc49d-1831-4a03-9d8c-c279cf99f723'),
    FunctionInfo('RATE', 'Financial', '', 'rate-function-9f665657-4a7e-4bb7-a030-83fc59e748ce'),
    FunctionInfo('RECEIVED', 'Financial', '', 'received-function-7a3f8b93-6611-4f81-8576-828312c9b5e5'),
    FunctionInfo('REGISTER.ID', 'Add-in and Automation', '', 'register-id-function-f8f0af0f-fd66-4704-a0f2-87b27b175b50'),
    FunctionInfo('REPLACE', 'Text', '', 'replace-replaceb-functions-8d799074-2425-4a8a-84bc-82472868878a'),
    FunctionInfo('REPLACEB', 'Text', '', 'replace-replaceb-functions-8d799074-2425-4a8a-84bc-82472868878a'),
    FunctionInfo('REPT', 'Text', '', 'rept-function-04c4d778-e712-43b4-9c15-d656582bb061'),
    FunctionInfo('RIGHT', 'Text', '', 'right-rightb-functions-240267ee-9afa-4639-a02b-f19e1786cf2f'),
    FunctionInfo('RIGHTB', 'Text', '', 'right-rightb-functions-240267ee-9afa-4639-a02b-f19e1786cf2f'),
    FunctionInfo('ROMAN', 'Math and trigonometry', '', 'roman-function-d6b0b99e-de46-4704-a518-b45a0f8b56f5'),
    FunctionInfo('ROUND', 'Math and trigonometry', '', 'round-function-c018c5d8-40fb-4053-90b1-b3e7f61a213c'),
    FunctionInfo('ROUNDDOWN', 'Math and trigonometry', '', 'rounddown-function-2ec94c73-241f-4b01-8c6f-17e6d7968f53'),
    FunctionInfo('ROUNDUP', 'Math and trigonometry', '', 'roundup-function-f8bc9b23-e795-47db-8703-db171d0c42a7'),
    FunctionInfo('ROW', 'Lookup and reference', '', 'row-function-3a63b74a-c4d0-4093-b49a-e76eb49a6d8d'),
    FunctionInfo('ROWS', 'Lookup and reference', '', 'rows-function-b592593e-3fc2-47f2-bec1-bda493811597'),
    FunctionInfo('RRI', 'Financial', 'Excel 2013', 'rri-function-6f5822d8-7ef1-4233-944c-79e8172930f4'),
    FunctionInfo('RSQ', 'Statistical', '', 'rsq-function-d7161715-250d-4a01-b80d-a8364f2be08f'),
    FunctionInfo('RTD', 'Lookup and reference', '', 'rtd-function-e0cc001a-56f0-470a-9b19-9455dc0eb593'),
    FunctionInfo('SEARCH', 'Text', '', 'search-searchb-functions-9ab04538-0e55-4719-a72e-b6f54513b495'),
    FunctionInfo('SEARCHB', 'Text', '', 'search-searchb-functions-9ab04538-0e55-4719-a72e-b6f54513b495'),
    FunctionInfo('SEC', 'Math and trigonometry', 'Excel 2013', 'sec-function-ff224717-9c87-4170-9b58-d069ced6d5f7'),
    FunctionInfo('SECH', 'Math and trigonometry', 'Excel 2013', 'sech-function-e05a789f-5ff7-4d7f-984a-5edb9b09556f'),
    FunctionInfo('SECOND', 'Date and time', '', 'second-function-740d1cfc-553c-4099-b668-80eaa24e8af1'),
    FunctionInfo('SEQUENCE', 'Math and trigonometry', 'Office 365', 'sequence-function-57467a98-57e0-4817-9f14-2eb78519ca90'),
    FunctionInfo('SERIESSUM', 'Math and trigonometry', '', 'seriessum-function-a3ab25b5-1093-4f5b-b084-96c49087f637'),
    FunctionInfo('SHEET', 'Information', 'Excel 2013', 'sheet-function-44718b6f-8b87-47a1-a9d6-b701c06cff24'),
    FunctionInfo('SHEETS', 'Information', 'Excel 2013', 'sheets-function-770515eb-e1e8-45ce-8066-b557e5e4b80b'),
    FunctionInfo('SIGN', 'Math and trigonometry', '', 'sign-function-109c932d-fcdc-4023-91f1-2dd0e916a1d8'),
    FunctionInfo('SIN', 'Math and trigonometry', '', 'sin-function-cf0e3432-8b9e-483c-bc55-a76651c95602'),
    FunctionInfo('SINH', 'Math and trigonometry', '', 'sinh-function-1e4e8b9f-2b65-43fc-ab8a-0a37f4081fa7'),
    FunctionInfo('SKEW', 'Statistical', '', 'skew-function-bdf49d86-b1ef-4804-a046-28eaea69c9fa'),
    FunctionInfo('SKEW.P', 'Statistical', 'Excel 2013', 'skew-p-function-76530a5c-99b9-48a1-8392-26632d542fcb'),
    FunctionInfo('SLN', 'Financial', '', 'sln-function-cdb666e5-c1c6-40a7-806a-e695edc2f1c8'),
    FunctionInfo('SLOPE', 'Statistical', '', 'slope-function-11fb8f97-3117-4813-98aa-61d7e01276b9'),
    FunctionInfo('SMALL', 'Statistical', '', 'small-function-17da8222-7c82-42b2-961b-14c45384df07'),
    FunctionInfo('SORT', 'Lookup and reference', 'Office 365', 'sort-function-22f63bd0-ccc8-492f-953d-c20e8e44b86c'),
    FunctionInfo('SORTBY', 'Lookup and reference', 'Office 365', 'sortby-function-cd2d7a62-1b93-435c-b561-d6a35134f28f'),
    FunctionInfo('SQRT', 'Math and trigonometry', '', 'sqrt-function-654975c2-05c4-4831-9a24-2c65e4040fdf'),
    FunctionInfo('SQRTPI', 'Math and trigonometry', '', 'sqrtpi-function-1fb4e63f-9b51-46d6-ad68-b3e7a8b519b4'),
    FunctionInfo('STANDARDIZE', 'Statistical', '', 'standardize-function-81d66554-2d54-40ec-ba83-6437108ee775'),
    FunctionInfo('STDEV', 'Compatibility', '', 'stdev-function-51fecaaa-231e-4bbb-9230-33650a72c9b0'),
    FunctionInfo('STDEV.P', 'Statistical', 'Excel 2010', 'stdev-p-function-6e917c05-31a0-496f-ade7-4f4e7462f285'),
    FunctionInfo('STDEV.S', 'Statistical', 'Excel 2010', 'stdev-s-function-7d69cf97-0c1f-4acf-be27-f3e83904cc23'),
    FunctionInfo('STDEVA', 'Statistical', '', 'stdeva-function-5ff38888-7ea5-48de-9a6d-11ed73b29e9d'),
    FunctionInfo('STDEVP', 'Compatibility', '', 'stdevp-function-1f7c1c88-1bec-4422-8242-e9f7dc8bb195'),
    FunctionInfo('STDEVPA', 'Statistical', '', 'stdevpa-function-5578d4d6-455a-4308-9991-d405afe2c28c'),
    FunctionInfo('STEYX', 'Statistical', '', 'steyx-function-6ce74b2c-449d-4a6e-b9ac-f9cef5ba48ab'),
    FunctionInfo('SUBSTITUTE', 'Text', '', 'substitute-function-6434944e-a904-4336-a9b0-1e58df3bc332'),
    FunctionInfo('SUBTOTAL', 'Math and trigonometry', '', 'subtotal-function-7b027003-f060-4ade-9040-e478765b9939'),
    FunctionInfo('SUM', 'Math and trigonometry', '', 'sum-function-043e1c7d-7726-4e80-8f32-07b23e057f89'),
    FunctionInfo('SUMIF', 'Math and trigonometry', '', 'sumif-function-169b8c99-c05c-4483-a712-1697a653039b'),
    FunctionInfo('SUMIFS', 'Math and trigonometry', '', 'sumifs-function-c9e748f5-7ea7-455d-9406-611cebce642b'),
    FunctionInfo('SUMPRODUCT', 'Math and trigonometry', '', 'sumproduct-function-16753e75-9f68-4874-94ac-4d2145a2fd2e'),
    FunctionInfo('SUMSQ', 'Math and trigonometry', '', 'sumsq-function-e3313c02-51cc-4963-aae6-31442d9ec307'),
    FunctionInfo('SUMX2MY2', 'Math and trigonometry', '', 'sumx2my2-function-9e599cc5-5399-48e9-a5e0-e37812dfa3e9'),
    FunctionInfo('SUMX2PY2', 'Math and trigonometry', '', 'sumx2py2-function-826b60b4-0aa2-4e5e-81d2-be704d3d786f'),
    FunctionInfo('SUMXMY2', 'Math and trigonometry', '', 'sumxmy2-function-9d144ac1-4d79-43de-b524-e2ecee23b299'),
    FunctionInfo('SWITCH', 'Logical', 'Excel 2016', 'switch-function-47ab33c0-28ce-4530-8a45-d532ec4aa25e'),
    FunctionInfo('SYD', 'Financial', '', 'syd-function-069f8106-b60b-4ca2-98e0-2a0f206bdb27'),
    FunctionInfo('T', 'Text', '', 't-function-fb83aeec-45e7-4924-af95-53e073541228'),
    FunctionInfo('TAN', 'Math and trigonometry', '', 'tan-function-08851a40-179f-4052-b789-d7f699447401'),
    FunctionInfo('TANH', 'Math and trigonometry', '', 'tanh-function-017222f0-a0c3-4f69-9787-b3202295dc6c'),
    FunctionInfo('TBILLEQ', 'Financial', '', 'tbilleq-function-2ab72d90-9b4d-4efe-9fc2-0f81f2c19c8c'),
    FunctionInfo('TBILLPRICE', 'Financial', '', 'tbillprice-function-eacca992-c29d-425a-9eb8-0513fe6035a2'),
    FunctionInfo('TBILLYIELD', 'Financial', '', 'tbillyield-function-6d381232-f4b0-4cd5-8e97-45b9c03468ba'),
    FunctionInfo('T.DIST', 'Statistical', 'Excel 2010', 't-dist-function-4329459f-ae91-48c2-bba8-1ead1c6c21b2'),
    FunctionInfo('T.DIST.2T', 'Statistical', 'Excel 2010', 't-dist-2t-function-198e9340-e360-4230-bd21-f52f22ff5c28'),
    FunctionInfo('T.DIST.RT', 'Statistical', 'Excel 2010', 't-dist-rt-function-20a30020-86f9-4b35-af1f-7ef6ae683eda'),
    FunctionInfo('TDIST', 'Compatibility', '', 'tdist-function-630a7695-4021-4853-9468-4a1f9dcdd192'),
    FunctionInfo('TEXT', 'Text', '', 'text-function-20d5ac4d-7b94-49fd-bb38-93d29371225c'),
    FunctionInfo('TEXTJOIN', 'Text', 'Excel 2019', 'textjoin-function-357b449a-ec91-49d0-80c3-0e8fc845691c'),
    FunctionInfo('TIME', 'Date and time', '', 'time-function-9a5aff99-8f7d-4611-845e-747d0b8d5457'),
    FunctionInfo('TIMEVALUE', 'Date and time', '', 'timevalue-function-0b615c12-33d8-4431-bf3d-f3eb6d186645'),
    FunctionInfo('T.INV', 'Statistical', 'Excel 2010', 't-inv-function-2908272b-4e61-4942-9df9-a25fec9b0e2e'),
    FunctionInfo('T.INV.2T', 'Statistical', 'Excel 2010', 't-inv-2t-function-ce72ea19-ec6c-4be7-bed2-b9baf2264f17'),
    FunctionInfo('TINV', 'Compatibility', '', 'tinv-function-a7c85b9d-90f5-41fe-9ca5-1cd2f3e1ed7c'),
    FunctionInfo('TODAY', 'Date and time', '', 'today-function-5eb3078d-a82c-4736-8930-2f51a028fdd9'),
    FunctionInfo('TRANSPOSE', 'Lookup and reference', '', 'transpose-function-ed039415-ed8a-4a81-93e9-4b6dfac76027'),
    FunctionInfo('TREND', 'Statistical', '', 'trend-function-e2f135f0-8827-4096-9873-9a7cf7b51ef1'),
    FunctionInfo('TRIM', 'Text', '', 'trim-function-410388fa-c5df-49c6-b16c-9e5630b479f9'),
    FunctionInfo('TRIMMEAN', 'Statistical', '', 'trimmean-function-d90c9878-a119-4746-88fa-63d988f511d3'),
    FunctionInfo('TRUE', 'Logical', '', 'true-function-7652c6e3-8987-48d0-97cd-ef223246b3fb'),
    FunctionInfo('TRUNC', 'Math and trigonometry', '', 'trunc-function-8b86a64c-3127-43db-ba14-aa5ceb292721'),
    FunctionInfo('T.TEST', 'Statistical', 'Excel 2010', 't-test-function-d4e08ec3-c545-485f-962e-276f7cbed055'),
    FunctionInfo('TTEST', 'Compatibility', '', 'ttest-function-1696ffc1-4811-40fd-9d13-a0eaad83c7ae'),
    FunctionInfo('TYPE', 'Information', '', 'type-function-45b4e688-4bc3-48b3-a105-ffa892995899'),
    FunctionInfo('UNICHAR', 'Text', 'Excel 2013', 'unichar-function-ffeb64f5-f131-44c6-b332-5cd72f0659b8'),
    FunctionInfo('UNICODE', 'Text', 'Excel 2013', 'unicode-function-adb74aaa-a2a5-4dde-aff6-966e4e81f16f'),
    FunctionInfo('UNIQUE', 'Lookup and reference', 'Office 365', 'unique-function-c5ab87fd-30a3-4ce9-9d1a-40204fb85e1e'),
    FunctionInfo('UPPER', 'Text', '', 'upper-function-c11f29b3-d1a3-4537-8df6-04d0049963d6'),
    FunctionInfo('VALUE', 'Text', '', 'value-function-257d0108-07dc-437d-ae1c-bc2d3953d8c2'),
    FunctionInfo('VAR', 'Compatibility', '', 'var-function-1f2b7ab2-954d-4e17-ba2c-9e58b15a7da2'),
    FunctionInfo('VAR.P', 'Statistical', 'Excel 2010', 'var-p-function-73d1285c-108c-4843-ba5d-a51f90656f3a'),
    FunctionInfo('VAR.S', 'Statistical', 'Excel 2010', 'var-s-function-913633de-136b-449d-813e-65a00b2b990b'),
    FunctionInfo('VARA', 'Statistical', '', 'vara-function-3de77469-fa3a-47b4-85fd-81758a1e1d07'),
    FunctionInfo('VARP', 'Compatibility', '', 'varp-function-26a541c4-ecee-464d-a731-bd4c575b1a6b'),
    FunctionInfo('VARPA', 'Statistical', '', 'varpa-function-59a62635-4e89-4fad-88ac-ce4dc0513b96'),
    FunctionInfo('VDB', 'Financial', '', 'vdb-function-dde4e207-f3fa-488d-91d2-66d55e861d73'),
    FunctionInfo('VLOOKUP', 'Lookup and reference', '', 'vlookup-function-0bbc8083-26fe-4963-8ab8-93a18ad188a1'),
    FunctionInfo('WEBSERVICE', 'Web', 'Excel 2013', 'webservice-function-0546a35a-ecc6-4739-aed7-c0b7ce1562c4'),
    FunctionInfo('WEEKDAY', 'Date and time', '', 'weekday-function-60e44483-2ed1-439f-8bd0-e404c190949a'),
    FunctionInfo('WEEKNUM', 'Date and time', '', 'weeknum-function-e5c43a03-b4ab-426c-b411-b18c13c75340'),
    FunctionInfo('WEIBULL', 'Compatibility', '', 'weibull-function-b83dc2c6-260b-4754-bef2-633196f6fdcc'),
    FunctionInfo('WEIBULL.DIST', 'Statistical', 'Excel 2010', 'weibull-dist-function-4e783c39-9325-49be-bbc9-a83ef82b45db'),
    FunctionInfo('WORKDAY', 'Date and time', '', 'workday-function-f764a5b7-05fc-4494-9486-60d494efbf33'),
    FunctionInfo('WORKDAY.INTL', 'Date and time', 'Excel 2010', 'workday-intl-function-a378391c-9ba7-4678-8a39-39611a9bf81d'),
    FunctionInfo('XIRR', 'Financial', '', 'xirr-function-de1242ec-6477-445b-b11b-a303ad9adc9d'),
    FunctionInfo('XLOOKUP', 'Lookup and reference', 'Office 365', 'xlookup-function-b7fd680e-6d10-43e6-84f9-88eae8bf5929'),
    FunctionInfo('XMATCH', 'Lookup and reference', 'Office 365', 'xmatch-function-d966da31-7a6b-4a13-a1c6-5a33ed6a0312'),
    FunctionInfo('XNPV', 'Financial', '', 'xnpv-function-1b42bbf6-370f-4532-a0eb-d67c16b664b7'),
    FunctionInfo('XOR', 'Logical', 'Excel 2013', 'xor-function-1548d4c2-5e47-4f77-9a92-0533bba14f37'),
    FunctionInfo('YEAR', 'Date and time', '', 'year-function-c64f017a-1354-490d-981f-578e8ec8d3b9'),
    FunctionInfo('YEARFRAC', 'Date and time', '', 'yearfrac-function-3844141e-c76d-4143-82b6-208454ddc6a8'),
    FunctionInfo('YIELD', 'Financial', '', 'yield-function-f5f5ca43-c4bd-434f-8bd2-ed3c9727a4fe'),
    FunctionInfo('YIELDDISC', 'Financial', '', 'yielddisc-function-a9dbdbae-7dae-46de-b995-615faffaaed7'),
    FunctionInfo('YIELDMAT', 'Financial', '', 'yieldmat-function-ba7d1809-0d33-4bcb-96c7-6c56ec62ef6f'),
    FunctionInfo('Z.TEST', 'Statistical', 'Excel 2010', 'z-test-function-d633d5a3-2031-4614-a016-92180ad82bee'),
    FunctionInfo('ZTEST', 'Compatibility', '', 'ztest-function-8f33be8a-6bd6-4ecc-8e3a-d9a4420c4a6a'),
)
