#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ..schema_config.json_scalar import custom_scalars
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config


# fmt: off
QUERY: List[str] = ["""
query predictNextTurn($history: [String!]!, $alternatives: [String!]!) {
  result: callNextDialogTurn(history: $history, alternatives: $alternatives) {
    nextTurn: alternative
    confidence
  }
}

"""
]


class predictNextTurn:
    @dataclass(frozen=True)
    class predictNextTurnData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class DialogAlternative(DataClassJsonMixin):
            nextTurn: Optional[str]
            confidence: Optional[Number]

        result: Optional[List[DialogAlternative]]

    # fmt: off
    @classmethod
    def execute(cls, client: Client, history: List[str] = [], alternatives: List[str] = []) -> List[Optional[predictNextTurnData.DialogAlternative]]:
        variables: Dict[str, Any] = {"history": history, "alternatives": alternatives}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.predictNextTurnData.from_dict(response_text)
        return res.result

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, history: List[str] = [], alternatives: List[str] = []) -> List[Optional[predictNextTurnData.DialogAlternative]]:
        variables: Dict[str, Any] = {"history": history, "alternatives": alternatives}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.predictNextTurnData.from_dict(response_text)
        return res.result
