#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ..schema_config.json_scalar import custom_scalars
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config


# fmt: off
QUERY: List[str] = ["""
query parseTextTokens($text: String!) {
  result: callNlpDoc(text: $text) {
    tokens {
      dependency: dep
      entity_type: ent_type
      is_alpha
      is_currency
      is_digit
      is_oov
      is_sent_start
      is_stop
      is_title
      lemma
      like_email
      like_num
      like_url
      part_of_speech: pos
      prob
      tag
      text
    }
  }
}

"""
]


class parseTextTokens:
    @dataclass(frozen=True)
    class parseTextTokensData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class NlpDoc(DataClassJsonMixin):
            @dataclass(frozen=True)
            class Token(DataClassJsonMixin):
                dependency: Optional[str]
                entity_type: Optional[str]
                is_alpha: Optional[bool]
                is_currency: Optional[bool]
                is_digit: Optional[bool]
                is_oov: Optional[bool]
                is_sent_start: Optional[bool]
                is_stop: Optional[bool]
                is_title: Optional[bool]
                lemma: Optional[str]
                like_email: Optional[bool]
                like_num: Optional[bool]
                like_url: Optional[bool]
                part_of_speech: Optional[str]
                prob: Optional[Number]
                tag: Optional[str]
                text: Optional[str]

            tokens: Optional[List[Token]]

        result: Optional[NlpDoc]

    # fmt: off
    @classmethod
    def execute(cls, client: Client, text: str) -> Optional[parseTextTokensData.NlpDoc]:
        variables: Dict[str, Any] = {"text": text}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.parseTextTokensData.from_dict(response_text)
        return res.result

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, text: str) -> Optional[parseTextTokensData.NlpDoc]:
        variables: Dict[str, Any] = {"text": text}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.parseTextTokensData.from_dict(response_text)
        return res.result
