#!/usr/bin/env python3
# @generated AUTOGENERATED file. Do not Change!

from dataclasses import dataclass, field as _field
from ..schema_config.json_scalar import custom_scalars
from gql_client.runtime.variables import encode_variables
from gql import gql, Client
from gql.transport.exceptions import TransportQueryError
from functools import partial
from numbers import Number
from typing import Any, AsyncGenerator, Dict, List, Generator, Optional
from time import perf_counter
from dataclasses_json import DataClassJsonMixin, config


# fmt: off
QUERY: List[str] = ["""
query measureSimilarity($sentence: String!, $compareWith: [String!]!) {
  result: callMeasureSimilarity(
    sentence: $sentence
    compareWith: $compareWith
  ) {
    scores: result {
      score
      sentencePair
    }
  }
}

"""
]


class measureSimilarity:
    @dataclass(frozen=True)
    class measureSimilarityData(DataClassJsonMixin):
        @dataclass(frozen=True)
        class SentenceSimilarityScores(DataClassJsonMixin):
            @dataclass(frozen=True)
            class PairSimilarity(DataClassJsonMixin):
                score: Optional[Number]
                sentencePair: Optional[List[str]]

            scores: Optional[List[PairSimilarity]]

        result: Optional[SentenceSimilarityScores]

    # fmt: off
    @classmethod
    def execute(cls, client: Client, sentence: str, compareWith: List[str] = []) -> Optional[measureSimilarityData.SentenceSimilarityScores]:
        variables: Dict[str, Any] = {"sentence": sentence, "compareWith": compareWith}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = client.execute(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.measureSimilarityData.from_dict(response_text)
        return res.result

    # fmt: off
    @classmethod
    async def execute_async(cls, client: Client, sentence: str, compareWith: List[str] = []) -> Optional[measureSimilarityData.SentenceSimilarityScores]:
        variables: Dict[str, Any] = {"sentence": sentence, "compareWith": compareWith}
        new_variables = encode_variables(variables, custom_scalars)
        response_text = await client.execute_async(
            gql("".join(set(QUERY))), variable_values=new_variables
        )
        res = cls.measureSimilarityData.from_dict(response_text)
        return res.result
