from typing import Any

class RequestValidator:
    def __init__(self) -> None: ...
    @property
    def allowed_signature_methods(self): ...
    @property
    def safe_characters(self): ...
    @property
    def client_key_length(self): ...
    @property
    def request_token_length(self): ...
    @property
    def access_token_length(self): ...
    @property
    def timestamp_lifetime(self): ...
    @property
    def nonce_length(self): ...
    @property
    def verifier_length(self): ...
    @property
    def realms(self): ...
    @property
    def enforce_ssl(self): ...
    def check_client_key(self, client_key): ...
    def check_request_token(self, request_token): ...
    def check_access_token(self, request_token): ...
    def check_nonce(self, nonce): ...
    def check_verifier(self, verifier): ...
    def check_realms(self, realms): ...
    @property
    def dummy_client(self) -> None: ...
    @property
    def dummy_request_token(self) -> None: ...
    @property
    def dummy_access_token(self) -> None: ...
    def get_client_secret(self, client_key, request) -> None: ...
    def get_request_token_secret(self, client_key, token, request) -> None: ...
    def get_access_token_secret(self, client_key, token, request) -> None: ...
    def get_default_realms(self, client_key, request) -> None: ...
    def get_realms(self, token, request) -> None: ...
    def get_redirect_uri(self, token, request) -> None: ...
    def get_rsa_key(self, client_key, request) -> None: ...
    def invalidate_request_token(self, client_key, request_token, request) -> None: ...
    def validate_client_key(self, client_key, request) -> None: ...
    def validate_request_token(self, client_key, token, request) -> None: ...
    def validate_access_token(self, client_key, token, request) -> None: ...
    def validate_timestamp_and_nonce(
        self, client_key, timestamp, nonce, request, request_token: Any | None = ..., access_token: Any | None = ...
    ) -> None: ...
    def validate_redirect_uri(self, client_key, redirect_uri, request) -> None: ...
    def validate_requested_realms(self, client_key, realms, request) -> None: ...
    def validate_realms(self, client_key, token, request, uri: Any | None = ..., realms: Any | None = ...) -> None: ...
    def validate_verifier(self, client_key, token, verifier, request) -> None: ...
    def verify_request_token(self, token, request) -> None: ...
    def verify_realms(self, token, realms, request) -> None: ...
    def save_access_token(self, token, request) -> None: ...
    def save_request_token(self, token, request) -> None: ...
    def save_verifier(self, token, verifier, request) -> None: ...
