<p align="center">
    <picture>
      <source media="(prefers-color-scheme: dark)" srcset="https://user-images.githubusercontent.com/40870026/200185752-14fa7ba1-26cc-483a-b307-7306326fbfe3.png">
      <source media="(prefers-color-scheme: light)" srcset="https://user-images.githubusercontent.com/40870026/200185754-e145553b-3a87-4f97-92b2-ae12c0617f46.png">
      <img alt="Shows a black logo in light color mode and a white one in dark color mode." src="https://user-images.githubusercontent.com/40870026/200185754-e145553b-3a87-4f97-92b2-ae12c0617f46.png">
    </picture>
</p>

[![PyPI](https://img.shields.io/pypi/v/chimerapy)](https://pypi.org/project/chimerapy/) [![Coverage Status](https://coveralls.io/repos/github/oele-isis-vanderbilt/ChimeraPy/badge.svg?branch=main)](https://coveralls.io/github/oele-isis-vanderbilt/ChimeraPy?branch=main) ![](https://img.shields.io/github/workflow/status/oele-isis-vanderbilt/ChimeraPy/Test) ![](https://img.shields.io/github/license/oele-isis-vanderbilt/ChimeraPy) ![](https://img.shields.io/badge/style-black-black)
* [Docs](https://oele-isis-vanderbilt.github.io/ChimeraPy)

<!-- Summary -->
ChimeraPy is a distributed computing framework for multimodal data dollection, processing, and feedback. It's a real-time streaming tool that leverages from a distributed cluster to empower AI-driven applications.

1. **Collect** your data in real-time from any computer and time aligned it to the rest of your data streams.
2. **Process** data as soon as it comes, providing a service to your users.
3. **Archive** your outputs and later retrieve them in a single main data archive for later careful post-hoc analysis.
4. **Monitor** the executing of your distributed cluster, view live outputs, and verify that you collected clean data.

## Installation

You can install the package with the following command.

```
pip install chimerapy
```

Additionally, you can install the package through GitHub instead.

```
git clone https://github.com/oele-isis-vanderbilt/ChimeraPy
cd ChimeraPy
pip install .
```

## Contributing

Contributions are welcomed! Our [Developer Documentation](https://oele-isis-vanderbilt.github.io/ChimeraPy/developer/index.html) should provide more details in how ChimeraPy works and what is in current development.

## License

ChimeraPy uses the GNU GENERAL PUBLIC LICENSE, as found in [LICENSE](https://oele-isis-vanderbilt/ChimeraPy/blob/main/LICENSE) file.
