# -*- coding:utf-8 -*-

query = 'https://en.wikipedia.org/api/rest_v1/page/html/Douglas_Adams'

response = r"""<!DOCTYPE html>
<html prefix="dc: http://purl.org/dc/terms/ mw: http://mediawiki.org/rdf/" about="http://en.wikipedia.org/wiki/Special:Redirect/revision/793736590"><head prefix="mwr: http://en.wikipedia.org/wiki/Special:Redirect/"><meta property="mw:TimeUuid" content="1aa0981d-786a-11e7-b71e-b4c6a75a8d24"/><meta charset="utf-8"/><meta property="mw:pageNamespace" content="0"/><meta property="mw:pageId" content="8091"/><link rel="dc:replaces" resource="mwr:revision/793736059"/><meta property="dc:modified" content="2017-08-03T16:37:48.000Z"/><meta property="mw:revisionSHA1" content="ad78062474198c0565014503d928903800fc4d85"/><meta property="mw:html:version" content="1.5.0"/><link rel="dc:isVersionOf" href="//en.wikipedia.org/wiki/Douglas_Adams"/><title>Douglas_Adams</title><base href="//en.wikipedia.org/wiki/"/><link rel="stylesheet" href="//en.wikipedia.org/w/load.php?modules=mediawiki.legacy.commonPrint%2Cshared%7Cmediawiki.skinning.content.parsoid%7Cmediawiki.skinning.interface%7Cskins.vector.styles%7Csite.styles%7Cext.cite.style%7Cmediawiki.page.gallery.styles&amp;only=styles&amp;skin=vector"/></head><body id="mwAA" lang="en" class="mw-content-ltr sitedir-ltr ltr mw-body-content parsoid-body mediawiki mw-parser-output" dir="ltr"><div class="hatnote navigation-not-searchable" about="#mwt1" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"other people","href":"./Template:Other_people"},"params":{},"i":0}}]}' id="mwAQ">For other people named Douglas Adams, see <a rel="mw:WikiLink" href="./Douglas_Adams_(disambiguation)" title="Douglas Adams (disambiguation)">Douglas Adams (disambiguation)</a>.</div>
<p id="mwAg"><span typeof="mw:Transclusion mw:Nowiki" about="#mwt2" data-mw='{"parts":[{"template":{"target":{"wt":"Use British English","href":"./Template:Use_British_English"},"params":{"date":{"wt":"October 2013"}},"i":0}}]}' id="mwAw"></span><link rel="mw:PageProp/Category" href="./Category:Use_British_English_from_October_2013" about="#mwt2" id="mwBA"/>
<span typeof="mw:Transclusion mw:Nowiki" about="#mwt3" data-mw='{"parts":[{"template":{"target":{"wt":"Use dmy dates","href":"./Template:Use_dmy_dates"},"params":{"date":{"wt":"April 2015"}},"i":0}}]}' id="mwBQ"></span><link rel="mw:PageProp/Category" href="./Category:Use_dmy_dates_from_April_2015" about="#mwt3" id="mwBg"/></p>
<table class="infobox vcard" style="width:22em" about="#mwt4" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Infobox writer &lt;!-- for more information see [[:Template:Infobox writer/doc]] -->\n","href":"./Template:Infobox_writer"},"params":{"name":{"wt":"Douglas Adams"},"image":{"wt":"Douglas adams portrait cropped.jpg"},"caption":{"wt":""},"birth_name":{"wt":"Douglas Noel Adams"},"birth_date":{"wt":"{{birth date|1952|3|11|df=yes}}"},"birth_place":{"wt":"[[Cambridge]], England"},"height":{"wt":"{{height|ft=6|in=5}}"},"death_date":{"wt":"{{Death date and age|2001|5|11|1952|3|11|df=yes}}"},"death_place":{"wt":"[[Montecito, California]], US"},"resting_place":{"wt":"[[Highgate Cemetery]], London, England"},"alma_mater":{"wt":"[[St John&#39;s College, Cambridge]]"},"occupation":{"wt":"Writer"},"genre":{"wt":"Science fiction, comedy, satire"},"movement":{"wt":""},"website":{"wt":"{{URL|douglasadams.com/}}"}},"i":0}}]}' id="mwBw"><tbody><tr><th colspan="2" style="text-align:center;font-size:125%;font-weight:bold"><span class="fn">Douglas Adams</span></th></tr><tr><td colspan="2" style="text-align:center">
<span class="mw-default-size" typeof="mw:Image/Frameless"><a href="./File:Douglas_adams_portrait_cropped.jpg"><img resource="./File:Douglas_adams_portrait_cropped.jpg" src="//upload.wikimedia.org/wikipedia/commons/thumb/c/c0/Douglas_adams_portrait_cropped.jpg/220px-Douglas_adams_portrait_cropped.jpg" data-file-width="333" data-file-height="386" data-file-type="bitmap" height="255" width="220" srcset="//upload.wikimedia.org/wikipedia/commons/c/c0/Douglas_adams_portrait_cropped.jpg 2x, //upload.wikimedia.org/wikipedia/commons/thumb/c/c0/Douglas_adams_portrait_cropped.jpg/330px-Douglas_adams_portrait_cropped.jpg 1.5x"/></a></span></td></tr><tr><th scope="row" style="padding-top:0.225em;line-height:1.1em;padding-right:0.65em;">Born</th><td style="line-height:1.4em;">
Douglas Noel Adams<br/><span style="display:none">(<span class="bday">1952-03-11</span>)</span>11 March 1952<br/><a rel="mw:WikiLink" href="./Cambridge" title="Cambridge">Cambridge</a>, England</td></tr><tr><th scope="row" style="padding-top:0.225em;line-height:1.1em;padding-right:0.65em;">Died</th><td style="line-height:1.4em;">
11 May 2001<span style="display:none">(<span class="dday deathdate">2001-05-11</span>)</span> (aged<span typeof="mw:Entity"> </span>49)<br/><a rel="mw:WikiLink" href="./Montecito,_California" title="Montecito, California">Montecito, California</a>, US</td></tr><tr><th scope="row" style="padding-top:0.225em;line-height:1.1em;padding-right:0.65em;">Resting place</th><td style="line-height:1.4em;">
<a rel="mw:WikiLink" href="./Highgate_Cemetery" title="Highgate Cemetery">Highgate Cemetery</a>, London, England</td></tr><tr><th scope="row" style="padding-top:0.225em;line-height:1.1em;padding-right:0.65em;">Occupation</th><td class="role" style="line-height:1.4em;">
Writer</td></tr><tr><th scope="row" style="padding-top:0.225em;line-height:1.1em;padding-right:0.65em;">Alma<span typeof="mw:Entity"> </span>mater</th><td style="line-height:1.4em;">
<a rel="mw:WikiLink" href="./St_John's_College,_Cambridge" title="St John's College, Cambridge">St John's College, Cambridge</a></td></tr><tr><th scope="row" style="padding-top:0.225em;line-height:1.1em;padding-right:0.65em;">Genre</th><td class="category" style="line-height:1.4em;">
Science fiction, comedy, satire</td></tr><tr><th colspan="2" style="text-align:center">Website</th></tr><tr><td colspan="2" style="text-align:center;line-height:1.4em;">
<span class="url"><a rel="mw:ExtLink" href="http://douglasadams.com/">douglasadams<wbr/>.com</a></span></td></tr></tbody></table><div class="hatnote" style="color:red" about="#mwt4" id="mwCA"><strong>Warning:</strong> Page using <a rel="mw:WikiLink" href="./Template:Infobox_writer" title="Template:Infobox writer">Template:Infobox writer</a> with unknown parameter "height" (this message is shown only in preview).</div>
<!-- Do *not* change spelling of "Hitchhiker's"; see talk page for details -->
<!-- Please do *not* change spelling of "Noel". There is no 'ë'. Any citations have themselves been taken from an earlier, incorrect edit of Wikipedia; see talk page for details -->
<p id="mwCQ"><b id="mwCg">Douglas Noel Adams</b> (11 March 1952 – 11 May 2001) was an English <a rel="mw:WikiLink" href="./Author" title="Author" id="mwCw">author</a>, <a rel="mw:WikiLink" href="./Scriptwriter" title="Scriptwriter" id="mwDA" class="mw-redirect">scriptwriter</a>, <a rel="mw:WikiLink" href="./Essayist" title="Essayist" id="mwDQ" class="mw-redirect">essayist</a>, <a rel="mw:WikiLink" href="./List_of_humorists" title="List of humorists" id="mwDg">humorist</a>, <a rel="mw:WikiLink" href="./Satirist" title="Satirist" id="mwDw" class="mw-redirect">satirist</a> and <a rel="mw:WikiLink" href="./Dramatist" title="Dramatist" id="mwEA" class="mw-redirect">dramatist</a>.</p>

<p id="mwEQ">Adams is best known as the author of <i id="mwEg"><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy" title="The Hitchhiker's Guide to the Galaxy" id="mwEw">The Hitchhiker's Guide to the Galaxy</a></i>, which originated in 1978 as a BBC <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(radio_series)" title="The Hitchhiker's Guide to the Galaxy (radio series)" id="mwFA">radio comedy</a> before developing into a "trilogy" of five books that sold more than 15<span typeof="mw:Entity" id="mwFQ"> </span>million copies in his lifetime and generated a <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(TV_series)" title="The Hitchhiker's Guide to the Galaxy (TV series)" id="mwFg">television series</a>, several stage plays, comics, a <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(computer_game)" title="The Hitchhiker's Guide to the Galaxy (computer game)" id="mwFw" class="mw-redirect">computer game</a>, and in 2005 a <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(film)" title="The Hitchhiker's Guide to the Galaxy (film)" id="mwGA">feature film</a>. Adams's contribution to UK radio is commemorated in <a rel="mw:WikiLink" href="./Radio_Academy" title="Radio Academy" id="mwGQ">The Radio Academy</a>'s Hall of Fame.<span about="#mwt6" class="mw-ref" id="cite_ref-radioacad_1-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-radioacad-1"},"attrs":{"name":"radioacad"}}'><a href="./Douglas_Adams#cite_note-radioacad-1" style="counter-reset: mw-Ref 1;"><span class="mw-reflink-text">[1]</span></a></span></p>

<p id="mwGg">Adams also wrote <i id="mwGw"><a rel="mw:WikiLink" href="./Dirk_Gently's_Holistic_Detective_Agency" title="Dirk Gently's Holistic Detective Agency" id="mwHA">Dirk Gently's Holistic Detective Agency</a></i> (1987) and <i id="mwHQ"><a rel="mw:WikiLink" href="./The_Long_Dark_Tea-Time_of_the_Soul" title="The Long Dark Tea-Time of the Soul" id="mwHg">The Long Dark Tea-Time of the Soul</a></i> (1988), and co-wrote <i id="mwHw"><a rel="mw:WikiLink" href="./The_Meaning_of_Liff" title="The Meaning of Liff" id="mwIA">The Meaning of Liff</a></i> (1983), <i id="mwIQ"><a rel="mw:WikiLink" href="./The_Deeper_Meaning_of_Liff" title="The Deeper Meaning of Liff" id="mwIg" class="mw-redirect">The Deeper Meaning of Liff</a></i> (1990), <i id="mwIw"><a rel="mw:WikiLink" href="./Last_Chance_to_See" title="Last Chance to See" id="mwJA">Last Chance to See</a></i> (1990), and three stories for the television series <i id="mwJQ"><a rel="mw:WikiLink" href="./Doctor_Who" title="Doctor Who" id="mwJg">Doctor Who</a></i>; he also served as <a rel="mw:WikiLink" href="./Script_editor" title="Script editor" id="mwJw">script editor</a> for the show's seventeenth season in 1979. A posthumous collection of his works, including an unfinished novel, was published as <i id="mwKA"><a rel="mw:WikiLink" href="./The_Salmon_of_Doubt" title="The Salmon of Doubt" id="mwKQ">The Salmon of Doubt</a></i> in 2002.</p>

<p id="mwKg">Adams was known as an advocate for environmentalism and <a rel="mw:WikiLink" href="./Conservation_movement" title="Conservation movement" id="mwKw">conservation</a>, as a lover of fast cars, cameras, <a rel="mw:WikiLink" href="./Technological_innovation" title="Technological innovation" id="mwLA" class="mw-redirect">technological innovation</a> and the <a rel="mw:WikiLink" href="./Apple_Macintosh" title="Apple Macintosh" id="mwLQ" class="mw-redirect">Apple Macintosh</a>, and as a "devout <a rel="mw:WikiLink" href="./Atheist" title="Atheist" id="mwLg" class="mw-redirect">atheist</a>".</p>

<h2 id="Early_life">Early life</h2>
<!-- Please leave this section heading as is, for the chronology of events. Adams's own family (wife and daughter) are discussed later. -->
<p id="mwLw">Adams was born on 11 March 1952 to Janet (née Donovan; 1927–2016) and Christopher Douglas Adams (1927–1985) in <a rel="mw:WikiLink" href="./Cambridge" title="Cambridge" id="mwMA">Cambridge</a>, England.<span about="#mwt11" class="mw-ref" id="cite_ref-ODNB_2-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-ODNB-2"},"attrs":{"name":"ODNB"}}'><a href="./Douglas_Adams#cite_note-ODNB-2" style="counter-reset: mw-Ref 2;"><span class="mw-reflink-text">[2]</span></a></span> The family moved to the <a rel="mw:WikiLink" href="./East_End_of_London" title="East End of London" id="mwMQ">East End of London</a> a few months after his birth, where his sister, Susan, was born three years later.<span about="#mwt12" class="mw-ref" id="cite_ref-Adams_xix_3-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-Adams_xix-3"},"attrs":{"name":"Adams_xix"}}'><a href="./Douglas_Adams#cite_note-Adams_xix-3" style="counter-reset: mw-Ref 3;"><span class="mw-reflink-text">[3]</span></a></span> His parents divorced in 1957; Douglas, Susan, and their mother moved to an <a rel="mw:WikiLink" href="./RSPCA" title="RSPCA" id="mwMg" class="mw-redirect">RSPCA</a> animal shelter in <a rel="mw:WikiLink" href="./Brentwood,_Essex" title="Brentwood, Essex" id="mwMw">Brentwood, Essex</a>, run by his maternal grandparents.<span about="#mwt14" class="mw-ref" id="cite_ref-4" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-4"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-4" style="counter-reset: mw-Ref 4;"><span class="mw-reflink-text">[4]</span></a></span></p>

<h3 id="Education">Education</h3>
<p id="mwNA">Adams attended Primrose Hill Primary School in <a rel="mw:WikiLink" href="./Brentwood,_Essex" title="Brentwood, Essex" id="mwNQ">Brentwood</a>. At nine, he passed the entrance exam for <a rel="mw:WikiLink" href="./Brentwood_School_(Essex)" title="Brentwood School (Essex)" id="mwNg" class="mw-redirect">Brentwood School</a>, an independent school whose alumni include <a rel="mw:WikiLink" href="./Robin_Day" title="Robin Day" id="mwNw">Robin Day</a>, <a rel="mw:WikiLink" href="./Jack_Straw" title="Jack Straw" id="mwOA">Jack Straw</a>, <a rel="mw:WikiLink" href="./Noel_Edmonds" title="Noel Edmonds" id="mwOQ">Noel Edmonds</a>, and <a rel="mw:WikiLink" href="./David_Irving" title="David Irving" id="mwOg">David Irving</a>. <a rel="mw:WikiLink" href="./Griff_Rhys_Jones" title="Griff Rhys Jones" id="mwOw">Griff Rhys Jones</a> was a year below him, and he was in the same class as <a rel="mw:WikiLink" href="./Stuckism" title="Stuckism" id="mwPA">Stuckist</a> artist <a rel="mw:WikiLink" href="./Charles_Thomson_(artist)" title="Charles Thomson (artist)" id="mwPQ">Charles Thomson</a>. He attended the <a rel="mw:WikiLink" href="./Preparatory_school_(UK)" title="Preparatory school (UK)" id="mwPg" class="mw-redirect">prep school</a> from 1959 to 1964, then the main school until December 1970. Adams was six feet tall (1.83<span typeof="mw:Entity" id="mwPw"> </span>m) by age 12 and stopped growing at 6<span typeof="mw:Entity" id="mwQA"> </span>ft 5<span typeof="mw:Entity" id="mwQQ"> </span>in (1.96<span typeof="mw:Entity" id="mwQg"> </span>m). His form master, Frank Halford, said his height had made him stand out and that he had been self-conscious about it.<span about="#mwt19" class="mw-ref" id="cite_ref-Adams_7_5-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-Adams_7-5"},"attrs":{"name":"Adams_7"}}'><a href="./Douglas_Adams#cite_note-Adams_7-5" style="counter-reset: mw-Ref 5;"><span class="mw-reflink-text">[5]</span></a></span><span about="#mwt21" class="mw-ref" id="cite_ref-6" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-6"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-6" style="counter-reset: mw-Ref 6;"><span class="mw-reflink-text">[6]</span></a></span> His ability to write stories made him well known in the school.<span about="#mwt22" class="mw-ref" id="cite_ref-Simpson_9_7-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-Simpson_9-7"},"attrs":{"name":"Simpson_9"}}'><a href="./Douglas_Adams#cite_note-Simpson_9-7" style="counter-reset: mw-Ref 7;"><span class="mw-reflink-text">[7]</span></a></span> He became the only student ever to be awarded a ten out of ten by Halford for creative writing, something he remembered for the rest of his life, particularly when facing <a rel="mw:WikiLink" href="./Writer's_block" title="Writer's block" id="mwQw">writer's block</a>.<span about="#mwt24" class="mw-ref" id="cite_ref-Adams_xix_3-1" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","attrs":{"name":"Adams_xix"}}'><a href="./Douglas_Adams#cite_note-Adams_xix-3" style="counter-reset: mw-Ref 3;"><span class="mw-reflink-text">[3]</span></a></span></p>

<p id="mwRA">Some of his earliest writing was published at the school, such as a report on its photography club in <i id="mwRQ">The Brentwoodian</i> in 1962, or spoof reviews in the school magazine <i id="mwRg">Broadsheet</i>, edited by <a rel="mw:WikiLink" href="./Paul_Neil_Milne_Johnstone" title="Paul Neil Milne Johnstone" id="mwRw" class="mw-redirect">Paul Neil Milne Johnstone</a>, who later became a character in <i id="mwSA">The Hitchhiker's Guide</i>. He also designed the cover of one issue of the <i id="mwSQ">Broadsheet</i>, and had a letter and short story published in <i id="mwSg"><a rel="mw:WikiLink" href="./Eagle_(comic)" title="Eagle (comic)" id="mwSw" class="mw-redirect">The Eagle</a></i>, the boys' comic, in 1965. A poem entitled "A Dissertation on the task of writing a poem on a candle and an account of some of the difficulties thereto pertaining" written by Adams in January 1970, at the age of 17, was discovered in a cupboard at the school in early 2014.<span about="#mwt26" class="mw-ref" id="cite_ref-8" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-8"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-8" style="counter-reset: mw-Ref 8;"><span class="mw-reflink-text">[8]</span></a></span></p>

<p id="mwTA">On the strength of a bravura essay on religious poetry that discussed <a rel="mw:WikiLink" href="./The_Beatles" title="The Beatles" id="mwTQ">the Beatles</a> and <a rel="mw:WikiLink" href="./William_Blake" title="William Blake" id="mwTg">William Blake</a>, he was awarded an <a rel="mw:WikiLink" href="./Exhibition_(scholarship)" title="Exhibition (scholarship)" id="mwTw">Exhibition</a> in English at <a rel="mw:WikiLink" href="./St_John's_College,_Cambridge" title="St John's College, Cambridge" id="mwUA">St John's College, Cambridge</a>, going up in 1971. He wanted to join the <a rel="mw:WikiLink" href="./Footlights" title="Footlights" id="mwUQ">Footlights</a>, an invitation-only student comedy club that has acted as a hothouse for comic talent. He was not elected immediately as he had hoped, and started to write and perform in revues with Will Adams (no relation) and Martin Smith, forming a group called "Adams-Smith-Adams", but became a member of the Footlights by 1973.<span about="#mwt29" class="mw-ref" id="cite_ref-Simpson_30-40_9-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-Simpson_30-40-9"},"attrs":{"name":"Simpson_30-40"}}'><a href="./Douglas_Adams#cite_note-Simpson_30-40-9" style="counter-reset: mw-Ref 9;"><span class="mw-reflink-text">[9]</span></a></span> Despite doing very little work—he recalled having completed three essays in three years—he graduated in 1974 with a B.A. in <a rel="mw:WikiLink" href="./English_literature" title="English literature" id="mwUg">English literature</a>.<span about="#mwt31" class="mw-ref" id="cite_ref-ODNB_2-1" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","attrs":{"name":"ODNB"}}'><a href="./Douglas_Adams#cite_note-ODNB-2" style="counter-reset: mw-Ref 2;"><span class="mw-reflink-text">[2]</span></a></span></p>

<h2 id="Career">Career</h2>

<h3 id="Writing">Writing</h3>
<p id="mwUw">After leaving university Adams moved back to London, determined to break into TV and radio as a writer. An edited version of the <i id="mwVA">Footlights Revue</i> appeared on <a rel="mw:WikiLink" href="./BBC_Two" title="BBC Two" id="mwVQ">BBC2</a> television in 1974. A version of the Revue performed live in London's <a rel="mw:WikiLink" href="./West_End_of_London" title="West End of London" id="mwVg">West End</a> led to Adams being discovered by <a rel="mw:WikiLink" href="./Monty_Python" title="Monty Python" id="mwVw">Monty Python</a>'s <a rel="mw:WikiLink" href="./Graham_Chapman" title="Graham Chapman" id="mwWA">Graham Chapman</a>. The two formed a brief writing partnership, earning Adams a writing credit in <a rel="mw:WikiLink" href="./List_of_Monty_Python's_Flying_Circus_episodes#6._Party_Political_Broadcast" title="List of Monty Python's Flying Circus episodes" id="mwWQ">episode 45</a> of <i id="mwWg">Monty Python</i> for a sketch called "<a rel="mw:WikiLink" href="./Patient_Abuse" title="Patient Abuse" id="mwWw">Patient Abuse</a>". He is one of only two people other than the original Python members to get a writing credit (the other being <a rel="mw:WikiLink" href="./Neil_Innes" title="Neil Innes" id="mwXA">Neil Innes</a>).<span about="#mwt33" class="mw-ref" id="cite_ref-times_10-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-times-10"},"attrs":{"name":"times"}}'><a href="./Douglas_Adams#cite_note-times-10" style="counter-reset: mw-Ref 10;"><span class="mw-reflink-text">[10]</span></a></span></p>

<figure class="mw-default-size" typeof="mw:Image/Thumb" id="mwXQ"><a href="./File:DNA_in_Monty_Python.jpg" id="mwXg"><img resource="./File:DNA_in_Monty_Python.jpg" src="//upload.wikimedia.org/wikipedia/en/thumb/0/0a/DNA_in_Monty_Python.jpg/220px-DNA_in_Monty_Python.jpg" data-file-width="333" data-file-height="299" data-file-type="bitmap" height="198" width="220" srcset="//upload.wikimedia.org/wikipedia/en/0/0a/DNA_in_Monty_Python.jpg 2x, //upload.wikimedia.org/wikipedia/en/thumb/0/0a/DNA_in_Monty_Python.jpg/330px-DNA_in_Monty_Python.jpg 1.5x" id="mwXw"/></a><figcaption id="mwYA">Adams in his first <i id="mwYQ"><a rel="mw:WikiLink" href="./Monty_Python's_Flying_Circus" title="Monty Python's Flying Circus" id="mwYg">Monty Python</a></i> appearance, in full surgeon's garb</figcaption></figure>

<p id="mwYw">Adams had two brief appearances in the fourth series of <i id="mwZA"><a rel="mw:WikiLink" href="./Monty_Python's_Flying_Circus" title="Monty Python's Flying Circus" id="mwZQ">Monty Python's Flying Circus</a></i>. At the beginning of episode 42, "The Light Entertainment War", Adams is in a surgeon's mask (as Dr. Emile Koning, according to on-screen captions), pulling on gloves, while <a rel="mw:WikiLink" href="./Michael_Palin" title="Michael Palin" id="mwZg">Michael Palin</a> narrates a sketch that introduces one person after another but never gets started. At the beginning of episode 44, "Mr. Neutron", Adams is dressed in a <a rel="mw:WikiLink" href="./List_of_recurring_Monty_Python's_Flying_Circus_characters#Pepperpots" title="List of recurring Monty Python's Flying Circus characters" id="mwZw">pepper-pot</a> outfit and loads a missile onto a cart driven by <a rel="mw:WikiLink" href="./Terry_Jones" title="Terry Jones" id="mwaA">Terry Jones</a>, who is calling for scrap metal ("Any old iron..."). The two episodes were broadcast in November 1974. Adams and Chapman also attempted non-Python projects, including <i id="mwaQ"><a rel="mw:WikiLink" href="./Out_of_the_Trees" title="Out of the Trees" id="mwag">Out of the Trees</a></i>.</p>

<p id="mwaw">At this point Adams's career stalled; his writing style was unsuited to the then-current style of radio and TV comedy.<span about="#mwt37" class="mw-ref" id="cite_ref-ODNB_2-2" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","attrs":{"name":"ODNB"}}'><a href="./Douglas_Adams#cite_note-ODNB-2" style="counter-reset: mw-Ref 2;"><span class="mw-reflink-text">[2]</span></a></span> To make ends meet he took a series of odd jobs, including as a hospital porter, barn builder, and chicken shed cleaner. He was employed as a bodyguard by a Qatari family, who had made their fortune in oil.<span about="#mwt38" class="mw-ref" id="cite_ref-11" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-11"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-11" style="counter-reset: mw-Ref 11;"><span class="mw-reflink-text">[11]</span></a></span></p>

<p id="mwbA">During this time Adams continued to write and submit sketches, though few were accepted. In 1976 his career had a brief improvement when he wrote and performed <i id="mwbQ">Unpleasantness at Brodie's Close</i> at the <a rel="mw:WikiLink" href="./Edinburgh_Fringe" title="Edinburgh Fringe" id="mwbg" class="mw-redirect">Edinburgh Fringe</a> festival. By Christmas, work had dried up again, and a depressed Adams moved to live with his mother.<span about="#mwt41" class="mw-ref" id="cite_ref-ODNB_2-3" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","attrs":{"name":"ODNB"}}'><a href="./Douglas_Adams#cite_note-ODNB-2" style="counter-reset: mw-Ref 2;"><span class="mw-reflink-text">[2]</span></a></span> The lack of writing work hit him hard and low confidence became a feature of Adams's life; "I have terrible periods of lack of confidence [..] I briefly did therapy, but after a while I realised it was like a farmer complaining about the weather. You can't fix the weather<span typeof="mw:Entity" id="mwbw"> </span>– you just have to get on with it".<span about="#mwt42" class="mw-ref" id="cite_ref-Adams_prologue_12-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-Adams_prologue-12"},"attrs":{"name":"Adams_prologue"}}'><a href="./Douglas_Adams#cite_note-Adams_prologue-12" style="counter-reset: mw-Ref 12;"><span class="mw-reflink-text">[12]</span></a></span></p>

<p id="mwcA">Some of Adams's early radio work included sketches for <i id="mwcQ"><a rel="mw:WikiLink" href="./The_Burkiss_Way" title="The Burkiss Way" id="mwcg">The Burkiss Way</a></i> in 1977 and <i id="mwcw"><a rel="mw:WikiLink" href="./The_News_Huddlines" title="The News Huddlines" id="mwdA">The News Huddlines</a></i>.<span about="#mwt46" class="mw-ref" id="cite_ref-13" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-13"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-13" style="counter-reset: mw-Ref 13;"><span class="mw-reflink-text">[13]</span></a></span> He also wrote, again with Chapman, 20 February 1977 episode of <i id="mwdQ">Doctor on the Go</i>, a sequel to the <i id="mwdg"><a rel="mw:WikiLink" href="./Doctor_in_the_House_(TV_series)" title="Doctor in the House (TV series)" id="mwdw">Doctor in the House</a></i> television comedy series. After the <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(radio_series)" title="The Hitchhiker's Guide to the Galaxy (radio series)" id="mweA">first radio series of <i id="mweQ">The Hitchhiker's Guide</i></a> became successful, Adams was made a BBC radio producer, working on <i id="mweg"><a rel="mw:WikiLink" href="./Week_Ending" title="Week Ending" id="mwew">Week Ending</a></i> and a pantomime called <i id="mwfA"><a rel="mw:WikiLink" href="./Black_Cinderella_Two_Goes_East" title="Black Cinderella Two Goes East" id="mwfQ">Black Cinderella Two Goes East</a></i>.<span about="#mwt48" class="mw-ref" id="cite_ref-14" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-14"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-14" style="counter-reset: mw-Ref 14;"><span class="mw-reflink-text">[14]</span></a></span> He left  after six months to become the script editor for <i id="mwfg"><a rel="mw:WikiLink" href="./Doctor_Who" title="Doctor Who" id="mwfw">Doctor Who</a></i>.</p>

<p id="mwgA">In 1979 Adams and <a rel="mw:WikiLink" href="./John_Lloyd_(producer)" title="John Lloyd (producer)" id="mwgQ">John Lloyd</a> wrote scripts for two half-hour episodes of <i id="mwgg"><a rel="mw:WikiLink" href="./Doctor_Snuggles" title="Doctor Snuggles" id="mwgw">Doctor Snuggles</a></i>: "The Remarkable Fidgety River" and "The Great Disappearing Mystery" (episodes seven and twelve). John Lloyd was also co-author of two episodes from the original <i id="mwhA">Hitchhiker</i> radio series ("Fit the Fifth" and "Fit the Sixth", also known as "Episode Five" and "Episode Six"), as well as <i id="mwhQ"><a rel="mw:WikiLink" href="./The_Meaning_of_Liff" title="The Meaning of Liff" id="mwhg">The Meaning of Liff</a></i> and <i id="mwhw"><a rel="mw:WikiLink" href="./The_Deeper_Meaning_of_Liff" title="The Deeper Meaning of Liff" id="mwiA" class="mw-redirect">The Deeper Meaning of Liff</a></i>.</p>

<h4 id="The_Hitchhiker.27s_Guide_to_the_Galaxy"><i id="mwiQ">The Hitchhiker's Guide to the Galaxy</i></h4>
<div class="hatnote navigation-not-searchable" about="#mwt49" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Main article","href":"./Template:Main_article"},"params":{"1":{"wt":"The Hitchhiker&#39;s Guide to the Galaxy"}},"i":0}}]}' id="mwig">Main article: <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy" title="The Hitchhiker's Guide to the Galaxy">The Hitchhiker's Guide to the Galaxy</a></div>
<p id="mwiw"><i id="mwjA">The Hitchhiker's Guide to the Galaxy</i> was a concept for a science-fiction comedy radio series pitched by Adams and radio producer <a rel="mw:WikiLink" href="./Simon_Brett" title="Simon Brett" id="mwjQ">Simon Brett</a> to <a rel="mw:WikiLink" href="./BBC_Radio_4" title="BBC Radio 4" id="mwjg">BBC Radio 4</a> in 1977. Adams came up with an outline for a pilot episode, as well as a few other stories (reprinted in <a rel="mw:WikiLink" href="./Neil_Gaiman" title="Neil Gaiman" id="mwjw">Neil Gaiman</a>'s book <i id="mwkA"><a rel="mw:WikiLink" href="./Don't_Panic:_The_Official_Hitchhiker's_Guide_to_the_Galaxy_Companion" title="Don't Panic: The Official Hitchhiker's Guide to the Galaxy Companion" id="mwkQ">Don't Panic: The Official Hitchhiker's Guide to the Galaxy Companion</a></i>) that could potentially be used in the series.</p>
<figure class="mw-default-size" typeof="mw:Image/Thumb" id="mwkg"><a href="./File:Towelday-Innsbruck.jpg" id="mwkw"><img resource="./File:Towelday-Innsbruck.jpg" src="//upload.wikimedia.org/wikipedia/commons/thumb/1/17/Towelday-Innsbruck.jpg/170px-Towelday-Innsbruck.jpg" data-file-width="450" data-file-height="600" data-file-type="bitmap" height="227" width="170" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/1/17/Towelday-Innsbruck.jpg/340px-Towelday-Innsbruck.jpg 2x, //upload.wikimedia.org/wikipedia/commons/thumb/1/17/Towelday-Innsbruck.jpg/255px-Towelday-Innsbruck.jpg 1.5x" id="mwlA"/></a><figcaption id="mwlQ"><a rel="mw:WikiLink" href="./Towel_Day" title="Towel Day" id="mwlg">Towel Day</a> 2005 in Innsbruck, Austria, where Adams first had the idea of <i id="mwlw">The Hitchhiker's Guide</i>. In the novels a towel is the most useful thing a space traveller can have.  The annual Towel Day (25 May) was first celebrated in 2001, two weeks after Adams's death.</figcaption></figure>

<p id="mwmA">According to Adams, the idea for the title occurred to him while he lay drunk in a field in <a rel="mw:WikiLink" href="./Innsbruck" title="Innsbruck" id="mwmQ">Innsbruck</a>, Austria, gazing at the stars. He was carrying a copy of the <i id="mwmg"><a rel="mw:WikiLink" href="./Hitch-hiker's_Guide_to_Europe" title="Hitch-hiker's Guide to Europe" id="mwmw">Hitch-hiker's Guide to Europe</a></i>, and it occurred to him that "somebody ought to write a <i id="mwnA">Hitchhiker's Guide to the Galaxy</i>". He later said that the constant repetition of this anecdote had obliterated his memory of the actual event.<span about="#mwt51" class="mw-ref" id="cite_ref-15" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-15"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-15" style="counter-reset: mw-Ref 15;"><span class="mw-reflink-text">[15]</span></a></span></p>

<p id="mwnQ">Despite the original outline, Adams was said to make up the stories as he wrote. He turned to <a rel="mw:WikiLink" href="./John_Lloyd_(producer)" title="John Lloyd (producer)" id="mwng">John Lloyd</a> for help with the final two episodes of <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_Primary_and_Secondary_Phases#The_Primary_Phase" title="The Hitchhiker's Guide to the Galaxy Primary and Secondary Phases" id="mwnw">the first series</a>. Lloyd contributed bits from an unpublished science fiction book of his own, called <i id="mwoA">GiGax</i>.<span about="#mwt54" class="mw-ref" id="cite_ref-16" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-16"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-16" style="counter-reset: mw-Ref 16;"><span class="mw-reflink-text">[16]</span></a></span> Very little of Lloyd's material survived in later adaptations of <i id="mwoQ">Hitchhiker's</i>, such as the novels and the TV series. The TV series was based on the first six radio episodes, and sections contributed by Lloyd were largely re-written.</p>

<p id="mwog"><a rel="mw:WikiLink" href="./BBC_Radio_4" title="BBC Radio 4" id="mwow">BBC Radio 4</a> broadcast the first radio series weekly in the UK in March and April 1978. The series was distributed in the United States by <a rel="mw:WikiLink" href="./National_Public_Radio" title="National Public Radio" id="mwpA" class="mw-redirect">National Public Radio</a>.  Following the success of the first series, another episode was recorded and broadcast, which was commonly known as the Christmas Episode. <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_Primary_and_Secondary_Phases#The_Secondary_Phase" title="The Hitchhiker's Guide to the Galaxy Primary and Secondary Phases" id="mwpQ">A second series</a> of five episodes was broadcast one per night, during the week of 21–25 January 1980.</p>

<p id="mwpg">While working on the radio series (and with simultaneous projects such as <i id="mwpw"><a rel="mw:WikiLink" href="./The_Pirate_Planet" title="The Pirate Planet" id="mwqA">The Pirate Planet</a></i>) Adams developed problems keeping to writing deadlines that got worse as he published novels. Adams was never a prolific writer and usually had to be forced by others to do any writing. This included being locked in a hotel suite with his editor for three weeks to ensure that <i id="mwqQ"><a rel="mw:WikiLink" href="./So_Long,_and_Thanks_for_All_the_Fish" title="So Long, and Thanks for All the Fish" id="mwqg">So Long, and Thanks for All the Fish</a></i> was completed.<span about="#mwt57" class="mw-ref" id="cite_ref-17" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-17"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-17" style="counter-reset: mw-Ref 17;"><span class="mw-reflink-text">[17]</span></a></span> He was quoted as saying, "I love deadlines. I love the whooshing noise they make as they go by."<span about="#mwt58" class="mw-ref" id="cite_ref-Simpson_236_18-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-Simpson_236-18"},"attrs":{"name":"Simpson_236"}}'><a href="./Douglas_Adams#cite_note-Simpson_236-18" style="counter-reset: mw-Ref 18;"><span class="mw-reflink-text">[18]</span></a></span> Despite the difficulty with deadlines, Adams wrote five novels in the series, published in 1979, 1980, 1982, 1984, and 1992.</p>

<p id="mwqw">The books formed the basis for other adaptations, such as three-part comic book adaptations for each of the first three books, an interactive text-adventure <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(computer_game)" title="The Hitchhiker's Guide to the Galaxy (computer game)" id="mwrA" class="mw-redirect">computer game</a>, and a photo-illustrated edition, published in 1994. This latter edition featured a <a rel="mw:WikiLink" href="./42_Puzzle" title="42 Puzzle" id="mwrQ" class="mw-redirect">42 Puzzle</a> designed by Adams, which was later incorporated into paperback covers of the first four <i id="mwrg">Hitchhiker's</i> novels (the paperback for the fifth re-used the artwork from the hardback edition).<span about="#mwt61" class="mw-ref" id="cite_ref-19" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-19"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-19" style="counter-reset: mw-Ref 19;"><span class="mw-reflink-text">[19]</span></a></span></p>

<p id="mwrw">In 1980 Adams began attempts to turn the first <i id="mwsA">Hitchhiker's</i> novel into a film, making several trips to Los Angeles, and working with Hollywood studios and potential producers. The next year, the radio series became the basis for a BBC television mini-series<span about="#mwt63" class="mw-ref" id="cite_ref-20" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-20"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-20" style="counter-reset: mw-Ref 20;"><span class="mw-reflink-text">[20]</span></a></span> broadcast in six parts. When he died in 2001 in California, he had been trying again to get the movie project started with <a rel="mw:WikiLink" href="./Disney" title="Disney" id="mwsQ" class="mw-redirect">Disney</a>, which had bought the rights in 1998. The screenplay got a posthumous re-write by <a rel="mw:WikiLink" href="./Karey_Kirkpatrick" title="Karey Kirkpatrick" id="mwsg">Karey Kirkpatrick</a>, and <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(film)" title="The Hitchhiker's Guide to the Galaxy (film)" id="mwsw">the resulting film</a> was released in 2005.</p>

<p id="mwtA">Radio producer <a rel="mw:WikiLink" href="./Dirk_Maggs" title="Dirk Maggs" id="mwtQ">Dirk Maggs</a> had consulted with Adams, first in 1993, and later in 1997 and 2000 about creating a third radio series, based on the third novel in the <i id="mwtg">Hitchhiker's</i> series.<span about="#mwt67" class="mw-ref" id="cite_ref-21" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-21"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-21" style="counter-reset: mw-Ref 21;"><span class="mw-reflink-text">[21]</span></a></span> They also discussed the possibilities of radio adaptations of the final two novels in the five-book "trilogy". As with the movie, this project was only realised after Adams's death. The third series, <i id="mwtw"><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_Tertiary_to_Quintessential_Phases#The_Tertiary_Phase" title="The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases" id="mwuA">The Tertiary Phase</a></i>, was broadcast on <a rel="mw:WikiLink" href="./BBC_Radio_4" title="BBC Radio 4" id="mwuQ">BBC Radio 4</a> in September 2004 and was subsequently released on audio CD. With the aid of a recording of his reading of <i id="mwug">Life, the Universe and Everything</i> and editing, Adams can be heard playing the part of Agrajag posthumously. <i id="mwuw">So Long, and Thanks for All the Fish</i> and <i id="mwvA">Mostly Harmless</i> made up the fourth and fifth radio series, respectively (on radio they were titled <i id="mwvQ"><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_Tertiary_to_Quintessential_Phases#The_Quandary_Phase" title="The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases" id="mwvg">The Quandary Phase</a></i> and <i id="mwvw"><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_Tertiary_to_Quintessential_Phases#The_Quintessential_Phase" title="The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases" id="mwwA">The Quintessential Phase</a></i>) and these were broadcast in May and June 2005, and also subsequently released on Audio CD. The last episode in the last series (with a new, "more upbeat" ending) concluded with, "The very final episode of <i id="mwwQ">The Hitchhiker's Guide to the Galaxy</i> by Douglas Adams is affectionately dedicated to its author."<span about="#mwt69" class="mw-ref" id="cite_ref-22" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-22"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-22" style="counter-reset: mw-Ref 22;"><span class="mw-reflink-text">[22]</span></a></span></p>

<h4 id="Dirk_Gently_series"><i id="mwwg">Dirk Gently</i> series</h4>
<figure class="mw-default-size" typeof="mw:Image/Thumb" id="mwww"><a href="./File:Douglas_Adams_San_Francisco.jpg" id="mwxA"><img resource="./File:Douglas_Adams_San_Francisco.jpg" src="//upload.wikimedia.org/wikipedia/commons/thumb/e/ee/Douglas_Adams_San_Francisco.jpg/220px-Douglas_Adams_San_Francisco.jpg" data-file-width="1024" data-file-height="768" data-file-type="bitmap" height="165" width="220" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/e/ee/Douglas_Adams_San_Francisco.jpg/440px-Douglas_Adams_San_Francisco.jpg 2x, //upload.wikimedia.org/wikipedia/commons/thumb/e/ee/Douglas_Adams_San_Francisco.jpg/330px-Douglas_Adams_San_Francisco.jpg 1.5x" id="mwxQ"/></a><figcaption id="mwxg">Adams in March 2000</figcaption></figure>
<p id="mwxw">Between Adams's first trip to Madagascar with <a rel="mw:WikiLink" href="./Mark_Carwardine" title="Mark Carwardine" id="mwyA">Mark Carwardine</a> in 1985, and their series of travels that formed the basis for the radio series and non-fiction book <i id="mwyQ"><a rel="mw:WikiLink" href="./Last_Chance_to_See" title="Last Chance to See" id="mwyg">Last Chance to See</a></i>, Adams wrote two other novels with a new cast of characters. <i id="mwyw"><a rel="mw:WikiLink" href="./Dirk_Gently's_Holistic_Detective_Agency" title="Dirk Gently's Holistic Detective Agency" id="mwzA">Dirk Gently's Holistic Detective Agency</a></i> was published in 1987, and was described by its author as "a kind of ghost-horror-detective-time-travel-romantic-comedy-epic, mainly concerned with mud, music and quantum mechanics".<span about="#mwt71" class="mw-ref" id="cite_ref-23" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-23"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-23" style="counter-reset: mw-Ref 23;"><span class="mw-reflink-text">[23]</span></a></span> It was derived from two Doctor Who serials Adams had written.</p>

<p id="mwzQ">A sequel, <i id="mwzg"><a rel="mw:WikiLink" href="./The_Long_Dark_Tea-Time_of_the_Soul" title="The Long Dark Tea-Time of the Soul" id="mwzw">The Long Dark Tea-Time of the Soul</a></i>, was published a year later. This was an entirely original work, Adams's first since <i id="mw0A">So Long, and Thanks for All the Fish.</i> After the book tour, Adams set off on his round-the-world excursion which supplied him with the material for <i id="mw0Q">Last Chance to See</i>.</p>

<h4 id="Doctor_Who"><i id="mw0g">Doctor Who</i></h4>
<div class="hatnote navigation-not-searchable" about="#mwt73" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Main article","href":"./Template:Main_article"},"params":{"1":{"wt":"Doctor Who"}},"i":0}}]}' id="mw0w">Main article: <a rel="mw:WikiLink" href="./Doctor_Who" title="Doctor Who">Doctor Who</a></div>
<p id="mw1A">Adams sent the script for the <i id="mw1Q">HHGG</i> pilot radio programme to the <i id="mw1g">Doctor Who</i> production office in 1978, and was commissioned to write <i id="mw1w"><a rel="mw:WikiLink" href="./The_Pirate_Planet" title="The Pirate Planet" id="mw2A">The Pirate Planet</a></i> (see below). He had also previously attempted to submit a potential movie script, called "Doctor Who and the Krikkitmen", which later became his novel <i id="mw2Q">Life, the Universe and Everything</i> (which in turn became the third <i id="mw2g">Hitchhiker's Guide</i> radio series). Adams then went on to serve as script editor on the show for its seventeenth season in 1979. Altogether, he wrote three <a rel="mw:WikiLink" href="./List_of_Doctor_Who_serials" title="List of Doctor Who serials" id="mw2w"><i id="mw3A">Doctor Who</i> serials</a> starring <a rel="mw:WikiLink" href="./Tom_Baker" title="Tom Baker" id="mw3Q">Tom Baker</a> as <a rel="mw:WikiLink" href="./The_Doctor_(Doctor_Who)" title="The Doctor (Doctor Who)" id="mw3g">the Doctor</a>:</p>
<ul id="mw3w"><li id="mw4A"> "<a rel="mw:WikiLink" href="./The_Pirate_Planet" title="The Pirate Planet" id="mw4Q">The Pirate Planet</a>" (the second serial in the "<a rel="mw:WikiLink" href="./The_Key_to_Time" title="The Key to Time" id="mw4g" class="mw-redirect">Key to Time</a>" arc, in <a rel="mw:WikiLink" href="./Doctor_Who_(season_16)" title="Doctor Who (season 16)" id="mw4w" class="mw-redirect">season 16</a>)</li>
<li id="mw5A"> "<a rel="mw:WikiLink" href="./City_of_Death" title="City of Death" id="mw5Q">City of Death</a>" (with producer <a rel="mw:WikiLink" href="./Graham_Williams_(television_producer)" title="Graham Williams (television producer)" id="mw5g">Graham Williams</a>, from an original storyline by writer <a rel="mw:WikiLink" href="./David_Fisher_(writer)" title="David Fisher (writer)" id="mw5w">David Fisher</a>. It was transmitted under the pseudonym "<a rel="mw:WikiLink" href="./David_Agnew" title="David Agnew" id="mw6A">David Agnew</a>")</li>
<li id="mw6Q"> "<a rel="mw:WikiLink" href="./Shada_(Doctor_Who)" title="Shada (Doctor Who)" id="mw6g">Shada</a>" (only partially filmed; not televised due to <a rel="mw:WikiLink" href="./Strike_action" title="Strike action" id="mw6w">industry disputes</a>)</li></ul>

<p id="mw7A">The episodes authored by Adams are some of the few that were not novelised as Adams would not allow anyone else to write them, and asked for a higher price than the publishers were willing to pay.<span about="#mwt76" class="mw-ref" id="cite_ref-24" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-24"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-24" style="counter-reset: mw-Ref 24;"><span class="mw-reflink-text">[24]</span></a></span> "Shada" was later adapted as a novel by <a rel="mw:WikiLink" href="./Gareth_Roberts_(writer)" title="Gareth Roberts (writer)" id="mw7Q">Gareth Roberts</a> in 2012 and "City of Death" and "The Pirate Planet" by <a rel="mw:WikiLink" href="./James_Goss_(producer)" title="James Goss (producer)" id="mw7g">James Goss</a> in 2015 and 2017 respectively.</p>

<p id="mw7w">Elements of <i id="mw8A">Shada</i> and <i id="mw8Q">City of Death</i> were reused in Adams's later novel <i id="mw8g"><a rel="mw:WikiLink" href="./Dirk_Gently's_Holistic_Detective_Agency" title="Dirk Gently's Holistic Detective Agency" id="mw8w">Dirk Gently's Holistic Detective Agency</a></i>, in particular the character of <a rel="mw:WikiLink" href="./Professor_Chronotis" title="Professor Chronotis" id="mw9A">Professor Chronotis</a>. <a rel="mw:WikiLink" href="./Big_Finish_Productions" title="Big Finish Productions" id="mw9Q">Big Finish Productions</a> eventually remade <i id="mw9g">Shada</i> as an audio play starring <a rel="mw:WikiLink" href="./Paul_McGann" title="Paul McGann" id="mw9w">Paul McGann</a> as the Doctor. Accompanied by partially animated illustrations, it was <a rel="mw:WikiLink" href="./Doctor_Who_spin-offs#Webcasts" title="Doctor Who spin-offs" id="mw-A">webcast</a> on the <a rel="mw:WikiLink" href="./BBC_Online" title="BBC Online" id="mw-Q">BBC website</a> in 2003, and subsequently released as a two-CD set later that year. An omnibus edition of this version was broadcast on the digital radio station <a rel="mw:WikiLink" href="./BBC7" title="BBC7" id="mw-g" class="mw-redirect">BBC7</a> on 10 December 2005.</p>

<p id="mw-w">In the <i id="mw_A">Doctor Who</i> 2012 Christmas episode <i id="mw_Q"><a rel="mw:WikiLink" href="./The_Snowmen#Production" title="The Snowmen" id="mw_g">The Snowmen</a></i>, writer <a rel="mw:WikiLink" href="./Steven_Moffat" title="Steven Moffat" id="mw_w">Steven Moffat</a> was inspired by a storyline that Adams pitched called <i id="mwAQA">The Doctor Retires</i>.<span about="#mwt79" class="mw-ref" id="cite_ref-25" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-25"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-25" style="counter-reset: mw-Ref 25;"><span class="mw-reflink-text">[25]</span></a></span></p>

<h3 id="Music">Music</h3>
<p id="mwAQE">Adams played the guitar left-handed and had a collection of twenty-four left-handed guitars when he died (having received his first guitar in 1964). He also studied piano in the 1960s with the same teacher as <a rel="mw:WikiLink" href="./Paul_Wickens" title="Paul Wickens" id="mwAQI">Paul Wickens</a>, the pianist who plays in <a rel="mw:WikiLink" href="./Paul_McCartney" title="Paul McCartney" id="mwAQM">Paul McCartney</a>'s band (and composed the music for the 2004–2005 editions of the <i id="mwAQQ">Hitchhiker's Guide</i> radio series).<span about="#mwt82" class="mw-ref" id="cite_ref-26" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-26"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-26" style="counter-reset: mw-Ref 26;"><span class="mw-reflink-text">[26]</span></a></span> <a rel="mw:WikiLink" href="./Pink_Floyd" title="Pink Floyd" id="mwAQU">Pink Floyd</a> and <a rel="mw:WikiLink" href="./Procol_Harum" title="Procol Harum" id="mwAQY">Procol Harum</a> had important influence on Adams's work.</p>

<h4 id="Pink_Floyd">Pink Floyd</h4>

<p id="mwAQc">Adams's official biography shares its name with the song "<a rel="mw:WikiLink" href="./Wish_You_Were_Here_(1975_song)" title="Wish You Were Here (1975 song)" id="mwAQg" class="mw-redirect">Wish You Were Here</a>" by Pink Floyd. Adams was friends with Pink Floyd guitarist <a rel="mw:WikiLink" href="./David_Gilmour" title="David Gilmour" id="mwAQk">David Gilmour</a> and, on Adams's 42nd birthday, he was invited to make a guest appearance at Pink Floyd's concert of 28 October 1994 at Earls Court in London, playing guitar on the songs "<a rel="mw:WikiLink" href="./Brain_Damage_(song)" title="Brain Damage (song)" id="mwAQo">Brain Damage</a>" and "<a rel="mw:WikiLink" href="./Eclipse_(song)" title="Eclipse (song)" id="mwAQs">Eclipse</a>".<span about="#mwt85" class="mw-ref" id="cite_ref-Mabbett-MM_27-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-Mabbett-MM-27"},"attrs":{"name":"Mabbett-MM"}}'><a href="./Douglas_Adams#cite_note-Mabbett-MM-27" style="counter-reset: mw-Ref 27;"><span class="mw-reflink-text">[27]</span></a></span> Adams chose the name for Pink Floyd's 1994 album, <i id="mwAQw"><a rel="mw:WikiLink" href="./The_Division_Bell" title="The Division Bell" id="mwAQ0">The Division Bell</a></i>, by picking the words from the lyrics to one of its tracks, "High Hopes".<span about="#mwt87" class="mw-ref" id="cite_ref-Mabbett-MM_27-1" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","attrs":{"name":"Mabbett-MM"}}'><a href="./Douglas_Adams#cite_note-Mabbett-MM-27" style="counter-reset: mw-Ref 27;"><span class="mw-reflink-text">[27]</span></a></span> Gilmour also performed at Adams's memorial service in 2001, and what would have been Adams's 60th birthday party in 2012.</p>

<h3 id="Computer_games_and_projects">Computer games and projects</h3>
<p id="mwAQ4">Douglas Adams created an <a rel="mw:WikiLink" href="./Interactive_fiction" title="Interactive fiction" id="mwAQ8">interactive fiction</a> version of <i id="mwARA"><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(computer_game)" title="The Hitchhiker's Guide to the Galaxy (computer game)" id="mwARE" class="mw-redirect">HHGG</a></i> with <a rel="mw:WikiLink" href="./Steve_Meretzky" title="Steve Meretzky" id="mwARI">Steve Meretzky</a> from <a rel="mw:WikiLink" href="./Infocom" title="Infocom" id="mwARM">Infocom</a> in 1984. In 1986 he participated in a week-long brainstorming session with the <a rel="mw:WikiLink" href="./Lucasfilm_Games" title="Lucasfilm Games" id="mwARQ" class="mw-redirect">Lucasfilm Games</a> team for the game <i id="mwARU"><a rel="mw:WikiLink" href="./Labyrinth:_The_Computer_Game" title="Labyrinth: The Computer Game" id="mwARY">Labyrinth</a></i>. Later he was also involved in creating <i id="mwARc"><a rel="mw:WikiLink" href="./Bureaucracy_(computer_game)" title="Bureaucracy (computer game)" id="mwARg" class="mw-redirect">Bureaucracy</a></i> as a parody of events in his own life.</p>

<p id="mwARk">Adams was a founder-director and Chief Fantasist of <a rel="mw:WikiLink" href="./The_Digital_Village" title="The Digital Village" id="mwARo">The Digital Village</a>, a digital media and Internet company with which he created <i id="mwARs"><a rel="mw:WikiLink" href="./Starship_Titanic" title="Starship Titanic" id="mwARw">Starship Titanic</a></i>, a <a rel="mw:WikiLink" href="./Codie" title="Codie" id="mwAR0" class="mw-redirect">Codie</a> Award-winning and <a rel="mw:WikiLink" href="./BAFTA#Games_Awards" title="BAFTA" id="mwAR4" class="mw-redirect">BAFTA-nominated adventure game</a>, which was published in 1998 by <a rel="mw:WikiLink" href="./Simon_&amp;_Schuster" title="Simon &amp; Schuster" id="mwAR8">Simon &amp; Schuster</a>.<span about="#mwt91" class="mw-ref" id="cite_ref-bbc.co.uk_28-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-bbc.co.uk-28"},"attrs":{"name":"bbc.co.uk"}}'><a href="./Douglas_Adams#cite_note-bbc.co.uk-28" style="counter-reset: mw-Ref 28;"><span class="mw-reflink-text">[28]</span></a></span><span about="#mwt92" class="mw-ref" id="cite_ref-29" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-29"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-29" style="counter-reset: mw-Ref 29;"><span class="mw-reflink-text">[29]</span></a></span> <a rel="mw:WikiLink" href="./Terry_Jones" title="Terry Jones" id="mwASA">Terry Jones</a> wrote the accompanying book, entitled <i id="mwASE">Douglas Adams Starship Titanic</i>, since Adams was too busy with the computer game to do both. In April 1999, Adams initiated the <a rel="mw:WikiLink" href="./H2g2" title="H2g2" id="mwASI">h2g2</a> <a rel="mw:WikiLink" href="./Collaborative_writing" title="Collaborative writing" id="mwASM">collaborative writing</a> project, an experimental attempt at making <i id="mwASQ">The Hitchhiker's Guide to the Galaxy</i> a reality, and at harnessing the collective brainpower of the internet community. It was hosted by BBC Online from 2001 to 2011.<span about="#mwt94" class="mw-ref" id="cite_ref-bbc.co.uk_28-1" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","attrs":{"name":"bbc.co.uk"}}'><a href="./Douglas_Adams#cite_note-bbc.co.uk-28" style="counter-reset: mw-Ref 28;"><span class="mw-reflink-text">[28]</span></a></span></p>

<p id="mwASU">In 1990 Adams wrote and presented a television documentary programme <i id="mwASY"><a rel="mw:WikiLink" href="./Hyperland" title="Hyperland" id="mwASc">Hyperland</a></i><span about="#mwt96" class="mw-ref" id="cite_ref-30" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-30"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-30" style="counter-reset: mw-Ref 30;"><span class="mw-reflink-text">[30]</span></a></span> which featured <a rel="mw:WikiLink" href="./Tom_Baker" title="Tom Baker" id="mwASg">Tom Baker</a> as a "software agent" (similar to the assistant pictured in Apple's <a rel="mw:WikiLink" href="./Knowledge_Navigator" title="Knowledge Navigator" id="mwASk">Knowledge Navigator</a> video of future concepts from 1987), and interviews with <a rel="mw:WikiLink" href="./Ted_Nelson" title="Ted Nelson" id="mwASo">Ted Nelson</a>, the co-inventor of <a rel="mw:WikiLink" href="./Hypertext" title="Hypertext" id="mwASs">hypertext</a> and the person who coined the term. Adams was an <a rel="mw:WikiLink" href="./Early_adopter" title="Early adopter" id="mwASw">early adopter</a> and advocate of hypertext.</p>

<h2 id="Personal_beliefs_and_activism">Personal beliefs and activism</h2>

<h3 id="Atheism_and_views_on_religion">Atheism and views on religion</h3>
<p id="mwAS0">Adams described himself as a "radical <a rel="mw:WikiLink" href="./Atheist" title="Atheist" id="mwAS4" class="mw-redirect">atheist</a>", adding "radical" for emphasis so he would not be asked if he meant agnostic. He told <a rel="mw:WikiLink" href="./American_Atheists" title="American Atheists" id="mwAS8">American Atheists</a> that this conveyed the fact that he really meant it. He imagined a sentient puddle who wakes up one morning and thinks, "This is an interesting world I find myself in – an interesting hole I find myself in – fits me rather neatly, doesn't it? In fact it fits me staggeringly well, must have been made to have me in it!" to demonstrate his view that the <a rel="mw:WikiLink" href="./Fine-tuned_Universe" title="Fine-tuned Universe" id="mwATA">fine-tuned Universe</a> argument for God was a fallacy.<span about="#mwt99" class="mw-ref" id="cite_ref-31" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-31"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-31" style="counter-reset: mw-Ref 31;"><span class="mw-reflink-text">[31]</span></a></span></p>

<p id="mwATE">He remained fascinated by religion because of its effect on human affairs. "I love to keep poking and prodding at it. I've thought about it so much over the years that that fascination is bound to spill over into my writing."<span about="#mwt101" class="mw-ref" id="cite_ref-amath_32-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-amath-32"},"attrs":{"name":"amath"}}'><a href="./Douglas_Adams#cite_note-amath-32" style="counter-reset: mw-Ref 32;"><span class="mw-reflink-text">[32]</span></a></span></p>

<p id="mwATI">The evolutionary biologist and atheist <a rel="mw:WikiLink" href="./Richard_Dawkins" title="Richard Dawkins" id="mwATM">Richard Dawkins</a> uses Adams's influence throughout to exemplify arguments for non-belief in his 2006 book <i id="mwATQ"><a rel="mw:WikiLink" href="./The_God_Delusion" title="The God Delusion" id="mwATU">The God Delusion</a></i>. Dawkins dedicated the book to Adams, whom he jokingly called "possibly [my] only convert" to atheism<span about="#mwt107" class="mw-ref" id="cite_ref-TheGuardian_33-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-TheGuardian-33"},"attrs":{"name":"TheGuardian"}}'><a href="./Douglas_Adams#cite_note-TheGuardian-33" style="counter-reset: mw-Ref 33;"><span class="mw-reflink-text">[33]</span></a></span> and wrote on his death that "Science has lost a friend, literature has lost a luminary, the <a rel="mw:WikiLink" href="./Mountain_gorilla" title="Mountain gorilla" id="mwATY">mountain gorilla</a> and the <a rel="mw:WikiLink" href="./Black_rhino" title="Black rhino" id="mwATc" class="mw-redirect">black rhino</a> have lost a gallant defender."<span about="#mwt109" class="mw-ref" id="cite_ref-Dawkins2001_34-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-Dawkins2001-34"},"attrs":{"name":"Dawkins2001"}}'><a href="./Douglas_Adams#cite_note-Dawkins2001-34" style="counter-reset: mw-Ref 34;"><span class="mw-reflink-text">[34]</span></a></span></p>

<h3 id="Environmental_activism">Environmental activism</h3>
<p id="mwATg">Adams was also an <a rel="mw:WikiLink" href="./Environmental_activist" title="Environmental activist" id="mwATk" class="mw-redirect">environmental activist</a> who campaigned on behalf of <a rel="mw:WikiLink" href="./Endangered_species" title="Endangered species" id="mwATo">endangered species</a>. This activism included the production of the non-fiction radio series <i id="mwATs"><a rel="mw:WikiLink" href="./Last_Chance_to_See" title="Last Chance to See" id="mwATw">Last Chance to See</a></i>, in which he and <a rel="mw:WikiLink" href="./Natural_history" title="Natural history" id="mwAT0">naturalist</a> <a rel="mw:WikiLink" href="./Mark_Carwardine" title="Mark Carwardine" id="mwAT4">Mark Carwardine</a> visited rare species such as the <a rel="mw:WikiLink" href="./Kakapo" title="Kakapo" id="mwAT8">kakapo</a> and <a rel="mw:WikiLink" href="./Chinese_river_dolphin" title="Chinese river dolphin" id="mwAUA" class="mw-redirect">baiji</a>, and the publication of a tie-in book of the same name. In 1992 this was made into a CD-ROM combination of <a rel="mw:WikiLink" href="./Audiobook" title="Audiobook" id="mwAUE">audiobook</a>, <a rel="mw:WikiLink" href="./E-book" title="E-book" id="mwAUI">e-book</a> and picture slide show.</p>

<p id="mwAUM">Adams and Mark Carwardine contributed the 'Meeting a Gorilla' passage from <i id="mwAUQ"><a rel="mw:WikiLink" href="./Last_Chance_to_See" title="Last Chance to See" id="mwAUU">Last Chance to See</a></i> to the book <i id="mwAUY"><a rel="mw:WikiLink" href="./Great_Ape_Project" title="Great Ape Project" id="mwAUc">The Great Ape Project</a></i>.<span about="#mwt112" class="mw-ref" id="cite_ref-35" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-35"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-35" style="counter-reset: mw-Ref 35;"><span class="mw-reflink-text">[35]</span></a></span> This book, edited by <a rel="mw:WikiLink" href="./Paola_Cavalieri" title="Paola Cavalieri" id="mwAUg">Paola Cavalieri</a> and <a rel="mw:WikiLink" href="./Peter_Singer" title="Peter Singer" id="mwAUk">Peter Singer</a>, launched a wider-scale project in 1993, which calls for the extension of moral equality to include all great apes, human and non-human.</p>

<p id="mwAUo">In 1994 he participated in a climb of <a rel="mw:WikiLink" href="./Mount_Kilimanjaro" title="Mount Kilimanjaro" id="mwAUs">Mount Kilimanjaro</a> while wearing a rhino suit for the British charity organisation <i id="mwAUw"><a rel="mw:WikiLink" href="./Save_the_Rhino" title="Save the Rhino" id="mwAU0">Save the Rhino International</a></i>. Puppeteer <a rel="mw:WikiLink" href="./William_Todd-Jones" title="William Todd-Jones" id="mwAU4">William Todd-Jones</a>, who had originally worn the suit in the London Marathon to raise money and bring awareness to the group, also participated in the climb wearing a rhino suit; Adams wore the suit while travelling to the mountain before the climb began. About £100,000 was raised through that event, benefiting schools in Kenya and a <a rel="mw:WikiLink" href="./Black_rhinoceros" title="Black rhinoceros" id="mwAU8">black rhinoceros</a> preservation programme in <a rel="mw:WikiLink" href="./Tanzania" title="Tanzania" id="mwAVA">Tanzania</a>. Adams was also an active supporter of the <i id="mwAVE"><a rel="mw:WikiLink" href="./Dian_Fossey" title="Dian Fossey" id="mwAVI">Dian Fossey</a> Gorilla Fund</i>.</p>

<p id="mwAVM">Since 2003, <i id="mwAVQ">Save the Rhino</i> has held an annual Douglas Adams Memorial Lecture around the time of his birthday to raise money for environmental campaigns.<span about="#mwt115" class="mw-ref" id="cite_ref-36" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-36"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-36" style="counter-reset: mw-Ref 36;"><span class="mw-reflink-text">[36]</span></a></span></p>

<h3 id="Technology_and_innovation">Technology and innovation</h3>
<p id="mwAVU">Adams bought his first <a rel="mw:WikiLink" href="./Word_processor" title="Word processor" id="mwAVY">word processor</a> in 1982, having considered one as early as 1979. His first purchase was a 'Nexus'. In 1983, when he and Jane Belson went to Los Angeles, he bought a <a rel="mw:WikiLink" href="./Digital_Equipment_Corporation" title="Digital Equipment Corporation" id="mwAVc">DEC</a> <a rel="mw:WikiLink" href="./Rainbow_100" title="Rainbow 100" id="mwAVg">Rainbow</a>. Upon their return to England, Adams bought an <a rel="mw:WikiLink" href="./Apricot_Computers" title="Apricot Computers" id="mwAVk">Apricot</a>, then a <a rel="mw:WikiLink" href="./BBC_Micro" title="BBC Micro" id="mwAVo">BBC Micro</a> and a <a rel="mw:WikiLink" href="./Tandy_1000" title="Tandy 1000" id="mwAVs">Tandy 1000</a>.<span about="#mwt119" class="mw-ref" id="cite_ref-Simpson_184-185_37-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-Simpson_184-185-37"},"attrs":{"name":"Simpson_184-185"}}'><a href="./Douglas_Adams#cite_note-Simpson_184-185-37" style="counter-reset: mw-Ref 37;"><span class="mw-reflink-text">[37]</span></a></span> In <i id="mwAVw"><a rel="mw:WikiLink" href="./Last_Chance_to_See" title="Last Chance to See" id="mwAV0">Last Chance to See</a></i> Adams mentions his <a rel="mw:WikiLink" href="./Cambridge_Z88" title="Cambridge Z88" id="mwAV4">Cambridge Z88</a>, which he had taken to <a rel="mw:WikiLink" href="./Zaire" title="Zaire" id="mwAV8">Zaire</a> on a quest to find the <a rel="mw:WikiLink" href="./Northern_white_rhinoceros" title="Northern white rhinoceros" id="mwAWA">northern white rhinoceros</a>.<span about="#mwt121" class="mw-ref" id="cite_ref-38" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-38"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-38" style="counter-reset: mw-Ref 38;"><span class="mw-reflink-text">[38]</span></a></span></p>

<p id="mwAWE">Adams's posthumously published work, <i id="mwAWI"><a rel="mw:WikiLink" href="./The_Salmon_of_Doubt" title="The Salmon of Doubt" id="mwAWM">The Salmon of Doubt</a></i>, features multiple articles by him on the subject of technology, including reprints of articles that originally ran in <i id="mwAWQ"><a rel="mw:WikiLink" href="./MacUser" title="MacUser" id="mwAWU">MacUser</a></i> magazine, and in <i id="mwAWY"><a rel="mw:WikiLink" href="./The_Independent_on_Sunday" title="The Independent on Sunday" id="mwAWc" class="mw-redirect">The Independent on Sunday</a></i> newspaper. In these Adams claims that one of the first computers he ever saw was a <a rel="mw:WikiLink" href="./Commodore_PET" title="Commodore PET" id="mwAWg">Commodore PET</a>, and that he had "adored" his Apple Macintosh ("or rather my family of however many Macintoshes it is that I've recklessly accumulated over the years") since he first saw one at Infocom's offices in Boston in 1984.<span about="#mwt124" class="mw-ref" id="cite_ref-39" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-39"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-39" style="counter-reset: mw-Ref 39;"><span class="mw-reflink-text">[39]</span></a></span></p>

<p id="mwAWk">Adams was a Macintosh user from the time they first came out in 1984 until his death in 2001. He was the first person to buy a Mac in Europe (the second being <a rel="mw:WikiLink" href="./Stephen_Fry" title="Stephen Fry" id="mwAWo">Stephen Fry</a> – though some accounts differ on this, saying Fry bought his Mac first. Fry claims he was second to Adams<span about="#mwt128" class="mw-ref" id="cite_ref-40" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-40"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-40" style="counter-reset: mw-Ref 40;"><span class="mw-reflink-text">[40]</span></a></span>). Adams was also an "<a rel="mw:WikiLink" href="./AppleMasters" title="AppleMasters" id="mwAWs">Apple Master</a>", celebrities whom Apple made into spokespeople for its products (others included <a rel="mw:WikiLink" href="./John_Cleese" title="John Cleese" id="mwAWw">John Cleese</a> and <a rel="mw:WikiLink" href="./Gregory_Hines" title="Gregory Hines" id="mwAW0">Gregory Hines</a>). Adams's contributions included a rock video that he created using the first version of <a rel="mw:WikiLink" href="./IMovie" title="IMovie" id="mwAW4">iMovie</a> with footage featuring his daughter Polly. The video was available on Adams's <a rel="mw:WikiLink" href="./.Mac" title=".Mac" id="mwAW8" class="mw-redirect">.Mac</a> homepage. Adams installed and started using the first release of <a rel="mw:WikiLink" href="./Mac_OS_X" title="Mac OS X" id="mwAXA" class="mw-redirect">Mac OS X</a> in the weeks leading up to his death. His very last post to his own forum was in praise of Mac OS X and the possibilities of its <a rel="mw:WikiLink" href="./Cocoa_(API)" title="Cocoa (API)" id="mwAXE">Cocoa</a> programming framework. He said it was "awesome...", which was also the last word he wrote on his site.<span about="#mwt130" class="mw-ref" id="cite_ref-41" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-41"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-41" style="counter-reset: mw-Ref 41;"><span class="mw-reflink-text">[41]</span></a></span></p>

<p id="mwAXI">Adams used email to correspond with <a rel="mw:WikiLink" href="./Steve_Meretzky" title="Steve Meretzky" id="mwAXM">Steve Meretzky</a> in the early 1980s, during their collaboration on Infocom's version of <i id="mwAXQ"><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(computer_game)" title="The Hitchhiker's Guide to the Galaxy (computer game)" id="mwAXU" class="mw-redirect">The Hitchhiker's Guide to the Galaxy</a></i>.<span about="#mwt135" class="mw-ref" id="cite_ref-Simpson_184-185_37-1" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","attrs":{"name":"Simpson_184-185"}}'><a href="./Douglas_Adams#cite_note-Simpson_184-185-37" style="counter-reset: mw-Ref 37;"><span class="mw-reflink-text">[37]</span></a></span> While living in New Mexico in 1993 he set up another e-mail address and began posting to his own <a rel="mw:WikiLink" href="./USENET" title="USENET" id="mwAXY" class="mw-redirect">USENET</a> newsgroup, alt.fan.douglas-adams, and occasionally, when his computer was acting up, to the comp.sys.mac hierarchy.<span about="#mwt136" class="mw-ref" id="cite_ref-42" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-42"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-42" style="counter-reset: mw-Ref 42;"><span class="mw-reflink-text">[42]</span></a></span> Challenges to the authenticity of his messages later led Adams to set up a message forum on his own website to avoid the issue. In 1996, Adams was a keynote speaker at the <a rel="mw:WikiLink" href="./Microsoft" title="Microsoft" id="mwAXc">Microsoft</a> <a rel="mw:WikiLink" href="./Professional_Developers_Conference" title="Professional Developers Conference" id="mwAXg">Professional Developers Conference</a> (PDC) where he described the personal computer as being a modelling device. The video of his keynote speech is archived on <a rel="mw:WikiLink" href="./Channel_9_(discussion_forum)" title="Channel 9 (discussion forum)" id="mwAXk" class="mw-redirect">Channel 9</a>.<span about="#mwt138" class="mw-ref" id="cite_ref-43" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-43"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-43" style="counter-reset: mw-Ref 43;"><span class="mw-reflink-text">[43]</span></a></span>
Adams was also a keynote speaker for the April 2001 <a rel="mw:WikiLink" href="./Embedded_Systems_Conference#ESC_Silicon_Valley" title="Embedded Systems Conference" id="mwAXo" class="new">Embedded Systems Conference</a> in San Francisco, one of the major technical conferences on <a rel="mw:WikiLink" href="./Embedded_system" title="Embedded system" id="mwAXs">embedded system</a> engineering.<span about="#mwt141" class="mw-ref" id="cite_ref-44" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-44"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-44" style="counter-reset: mw-Ref 44;"><span class="mw-reflink-text">[44]</span></a></span></p>

<h2 id="Personal_life">Personal life</h2>
<p id="mwAXw">Adams moved to <a rel="mw:WikiLink" href="./Upper_Street" title="Upper Street" id="mwAX0">Upper Street</a>, <a rel="mw:WikiLink" href="./Islington" title="Islington" id="mwAX4">Islington</a>, in 1981<span about="#mwt145" class="mw-ref" id="cite_ref-IPP_45-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","attrs":{"name":"IPP"}}'><a href="./Douglas_Adams#cite_note-IPP-45" style="counter-reset: mw-Ref 45;"><span class="mw-reflink-text">[45]</span></a></span> and to Duncan Terrace, a few minutes' walk away, in the late 1980s.<span about="#mwt146" class="mw-ref" id="cite_ref-IPP_45-1" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","attrs":{"name":"IPP"}}'><a href="./Douglas_Adams#cite_note-IPP-45" style="counter-reset: mw-Ref 45;"><span class="mw-reflink-text">[45]</span></a></span></p>

<p id="mwAX8">In the early 1980s Adams had an affair with novelist <a rel="mw:WikiLink" href="./Sally_Emerson" title="Sally Emerson" id="mwAYA">Sally Emerson</a>, who was separated from her husband at that time. Adams later dedicated his book <i id="mwAYE"><a rel="mw:WikiLink" href="./Life,_the_Universe_and_Everything" title="Life, the Universe and Everything" id="mwAYI">Life, the Universe and Everything</a></i> to Emerson. In 1981 Emerson returned to her husband, <a rel="mw:WikiLink" href="./Peter_Stothard" title="Peter Stothard" id="mwAYM">Peter Stothard</a>, a contemporary of Adams's at <a rel="mw:WikiLink" href="./Brentwood_School_(England)" title="Brentwood School (England)" id="mwAYQ" class="mw-redirect">Brentwood School</a>, and later editor of <i id="mwAYU"><a rel="mw:WikiLink" href="./The_Times" title="The Times" id="mwAYY">The Times</a></i>. Adams was soon introduced by friends to Jane Belson, with whom he later became romantically involved. Belson was the "lady barrister" mentioned in the jacket-flap biography printed in his books during the mid-1980s ("He [Adams] lives in Islington with a lady barrister and an Apple Macintosh"). The two lived in Los Angeles together during 1983 while Adams worked on an early screenplay adaptation of <i id="mwAYc">Hitchhiker's</i>. When the deal fell through, they moved back to London, and after several separations ("He is currently not certain where he lives, or with whom")<span about="#mwt151" class="mw-ref" id="cite_ref-sfweekly_46-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-sfweekly-46"},"attrs":{"name":"sfweekly"}}'><a href="./Douglas_Adams#cite_note-sfweekly-46" style="counter-reset: mw-Ref 46;"><span class="mw-reflink-text">[46]</span></a></span> and a broken engagement, they married on 25 November 1991. Adams and Belson had one daughter together, Polly Jane Rocket Adams, born on 22 June 1994, shortly after Adams turned 42. In 1999 the family moved from London to <a rel="mw:WikiLink" href="./Santa_Barbara,_California" title="Santa Barbara, California" id="mwAYg">Santa Barbara, California</a>, where they lived until his death. Following the funeral, Jane Belson and Polly Adams returned to London.<span about="#mwt153" class="mw-ref" id="cite_ref-47" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-47"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-47" style="counter-reset: mw-Ref 47;"><span class="mw-reflink-text">[47]</span></a></span> Jane died on 7 September 2011 of cancer, aged 59.<span about="#mwt154" class="mw-ref" id="cite_ref-timesobit_48-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-timesobit-48"},"attrs":{"name":"timesobit"}}'><a href="./Douglas_Adams#cite_note-timesobit-48" style="counter-reset: mw-Ref 48;"><span class="mw-reflink-text">[48]</span></a></span><span about="#mwt156" class="mw-ref" id="cite_ref-h2g2obit_49-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-h2g2obit-49"},"attrs":{"name":"h2g2obit"}}'><a href="./Douglas_Adams#cite_note-h2g2obit-49" style="counter-reset: mw-Ref 49;"><span class="mw-reflink-text">[49]</span></a></span></p>

<h2 id="Death_and_legacy">Death and legacy</h2>
<figure class="mw-default-size" typeof="mw:Image/Thumb" id="mwAYk"><a href="./File:Grave_of_Douglas_Adams,_Highgate.jpg" id="mwAYo"><img resource="./File:Grave_of_Douglas_Adams,_Highgate.jpg" src="//upload.wikimedia.org/wikipedia/en/thumb/2/27/Grave_of_Douglas_Adams%2C_Highgate.jpg/170px-Grave_of_Douglas_Adams%2C_Highgate.jpg" data-file-width="1552" data-file-height="2592" data-file-type="bitmap" height="284" width="170" srcset="//upload.wikimedia.org/wikipedia/en/thumb/2/27/Grave_of_Douglas_Adams%2C_Highgate.jpg/340px-Grave_of_Douglas_Adams%2C_Highgate.jpg 2x, //upload.wikimedia.org/wikipedia/en/thumb/2/27/Grave_of_Douglas_Adams%2C_Highgate.jpg/255px-Grave_of_Douglas_Adams%2C_Highgate.jpg 1.5x" id="mwAYs"/></a><figcaption id="mwAYw">Adams's gravestone, <a rel="mw:WikiLink" href="./Highgate_Cemetery" title="Highgate Cemetery" id="mwAY0">Highgate Cemetery</a>, North London</figcaption></figure>
<p id="mwAY4">Adams died of a <a rel="mw:WikiLink" href="./Myocardial_infarction" title="Myocardial infarction" id="mwAY8">heart attack</a> on 11 May 2001, aged 49, after resting from his regular workout at a private gym in <a rel="mw:WikiLink" href="./Montecito,_California" title="Montecito, California" id="mwAZA">Montecito, California</a>. He had unknowingly suffered a <a rel="mw:WikiLink" href="./Atherosclerosis" title="Atherosclerosis" id="mwAZE">gradual narrowing of the coronary arteries</a>, which led to a <a rel="mw:WikiLink" href="./Myocardial_infarction" title="Myocardial infarction" id="mwAZI">myocardial infarction</a> and a fatal <a rel="mw:WikiLink" href="./Cardiac_arrhythmia" title="Cardiac arrhythmia" id="mwAZM" class="mw-redirect">cardiac arrhythmia</a>.<span about="#mwt161" class="mw-ref" id="cite_ref-50" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-50"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-50" style="counter-reset: mw-Ref 50;"><span class="mw-reflink-text">[50]</span></a></span> Adams had been due to deliver the commencement address at <a rel="mw:WikiLink" href="./Harvey_Mudd_College" title="Harvey Mudd College" id="mwAZQ">Harvey Mudd College</a> on 13 May.<span about="#mwt162" class="mw-ref" id="cite_ref-51" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-51"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-51" style="counter-reset: mw-Ref 51;"><span class="mw-reflink-text">[51]</span></a></span> His funeral was held on 16 May in Santa Barbara. His ashes were placed in <a rel="mw:WikiLink" href="./Highgate_Cemetery" title="Highgate Cemetery" id="mwAZU">Highgate Cemetery</a> in north London in June 2002.<span about="#mwt164" class="mw-ref" id="cite_ref-Simpson_337-338_52-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-Simpson_337-338-52"},"attrs":{"name":"Simpson_337-338"}}'><a href="./Douglas_Adams#cite_note-Simpson_337-338-52" style="counter-reset: mw-Ref 52;"><span class="mw-reflink-text">[52]</span></a></span></p>

<p id="mwAZY">A memorial service was held on 17 September 2001 at <a rel="mw:WikiLink" href="./St_Martin-in-the-Fields" title="St Martin-in-the-Fields" id="mwAZc">St Martin-in-the-Fields</a> church, <a rel="mw:WikiLink" href="./Trafalgar_Square" title="Trafalgar Square" id="mwAZg">Trafalgar Square</a>, London. This became the first church service broadcast live on the web by the BBC.<span about="#mwt168" class="mw-ref" id="cite_ref-53" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-53"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-53" style="counter-reset: mw-Ref 53;"><span class="mw-reflink-text">[53]</span></a></span> Video clips of the service are still available on the BBC's website for download.<span about="#mwt169" class="mw-ref" id="cite_ref-54" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-54"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-54" style="counter-reset: mw-Ref 54;"><span class="mw-reflink-text">[54]</span></a></span></p>

<p id="mwAZk">One of his last public appearances was a talk given at the University of California, Santa Barbara, <i id="mwAZo">Parrots, the universe and everything</i>, recorded days before his death.<span about="#mwt173" class="mw-ref" id="cite_ref-55" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-55"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-55" style="counter-reset: mw-Ref 55;"><span class="mw-reflink-text">[55]</span></a></span> A full transcript of the talk is available, and the university has made the full video available on YouTube.<span about="#mwt175" class="mw-ref" id="cite_ref-56" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-56"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-56" style="counter-reset: mw-Ref 56;"><span class="mw-reflink-text">[56]</span></a></span></p>

<p id="mwAZs">The <a rel="mw:WikiLink" href="./Minor_Planet_Centre" title="Minor Planet Centre" id="mwAZw" class="mw-redirect">Minor Planet Centre</a> space agency named an asteroid <a rel="mw:WikiLink" href="./18610_Arthurdent" title="18610 Arthurdent" id="mwAZ0">18610 Arthurdent</a>, announcing its plan two days before Adams died.<span about="#mwt179" class="mw-ref" id="cite_ref-MPC42677_57-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-MPC42677-57"},"attrs":{"name":"MPC42677"}}'><a href="./Douglas_Adams#cite_note-MPC42677-57" style="counter-reset: mw-Ref 57;"><span class="mw-reflink-text">[57]</span></a></span>  <a rel="mw:WikiLink" href="./25924_Douglasadams" title="25924 Douglasadams" id="mwAZ4">Another asteroid</a> was later named after Adams himself.<span about="#mwt181" class="mw-ref" id="cite_ref-58" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-58"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-58" style="counter-reset: mw-Ref 58;"><span class="mw-reflink-text">[58]</span></a></span></p>

<p id="mwAZ8">In May 2002 <i id="mwAaA"><a rel="mw:WikiLink" href="./The_Salmon_of_Doubt" title="The Salmon of Doubt" id="mwAaE">The Salmon of Doubt</a></i> was published, containing many short stories, essays, and letters, as well as eulogies from <a rel="mw:WikiLink" href="./Richard_Dawkins" title="Richard Dawkins" id="mwAaI">Richard Dawkins</a>, <a rel="mw:WikiLink" href="./Stephen_Fry" title="Stephen Fry" id="mwAaM">Stephen Fry</a> (in the UK edition), <a rel="mw:WikiLink" href="./Christopher_Cerf" title="Christopher Cerf" id="mwAaQ">Christopher Cerf</a> (in the US edition), and <a rel="mw:WikiLink" href="./Terry_Jones" title="Terry Jones" id="mwAaU">Terry Jones</a> (in the US paperback edition). It also includes eleven chapters of his unfinished novel, <i id="mwAaY">The Salmon of Doubt</i>, which was originally intended to become a new <a rel="mw:WikiLink" href="./Dirk_Gently" title="Dirk Gently" id="mwAac">Dirk Gently</a> novel, but might have later become the sixth <i id="mwAag">Hitchhiker</i> novel.<span about="#mwt184" class="mw-ref" id="cite_ref-59" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-59"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-59" style="counter-reset: mw-Ref 59;"><span class="mw-reflink-text">[59]</span></a></span><span about="#mwt186" class="mw-ref" id="cite_ref-60" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-60"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-60" style="counter-reset: mw-Ref 60;"><span class="mw-reflink-text">[60]</span></a></span></p>

<p id="mwAak">Other events after Adams's death included a <a rel="mw:WikiLink" href="./Webcast" title="Webcast" id="mwAao">webcast</a> production of <i id="mwAas"><a rel="mw:WikiLink" href="./Shada_(Doctor_Who)" title="Shada (Doctor Who)" id="mwAaw">Shada</a></i>, allowing the complete story to be told, radio dramatisations of the final three books in the <i id="mwAa0">Hitchhiker's</i> series, and the completion of <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(film)" title="The Hitchhiker's Guide to the Galaxy (film)" id="mwAa4">the film adaptation</a> of <i id="mwAa8"><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(book)" title="The Hitchhiker's Guide to the Galaxy (book)" id="mwAbA" class="mw-redirect">The Hitchhiker's Guide to the Galaxy</a></i>. The film, released in 2005, posthumously credits Adams as a producer, and several design elements – including a head-shaped planet seen near the end of the film – incorporated Adams's features.</p>

<p id="mwAbE">A 12-part radio series based on the <a rel="mw:WikiLink" href="./Dirk_Gently" title="Dirk Gently" id="mwAbI">Dirk Gently</a> novels was announced in 2007, with annual transmissions starting in October.<span about="#mwt189" class="mw-ref" id="cite_ref-61" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-61"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-61" style="counter-reset: mw-Ref 61;"><span class="mw-reflink-text">[61]</span></a></span></p>

<p id="mwAbM">BBC Radio 4 also commissioned a third Dirk Gently radio series based on the incomplete chapters of <i id="mwAbQ">The Salmon of Doubt</i>, and written by <a rel="mw:WikiLink" href="./Kim_Fuller" title="Kim Fuller" id="mwAbU">Kim Fuller</a>;<span about="#mwt193" class="mw-ref" id="cite_ref-62" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-62"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-62" style="counter-reset: mw-Ref 62;"><span class="mw-reflink-text">[62]</span></a></span> but this was dropped in favour of a BBC TV series based on the two completed novels.<span about="#mwt195" class="mw-ref" id="cite_ref-63" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-63"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-63" style="counter-reset: mw-Ref 63;"><span class="mw-reflink-text">[63]</span></a></span> A sixth <i id="mwAbY">Hitchhiker</i> novel, <i id="mwAbc"><a rel="mw:WikiLink" href="./And_Another_Thing..._(novel)" title="And Another Thing... (novel)" id="mwAbg">And Another Thing...</a></i>, by <i id="mwAbk"><a rel="mw:WikiLink" href="./Artemis_Fowl_(series)" title="Artemis Fowl (series)" id="mwAbo">Artemis Fowl</a></i> author <a rel="mw:WikiLink" href="./Eoin_Colfer" title="Eoin Colfer" id="mwAbs">Eoin Colfer</a>, was released on 12 October 2009 (the 30th anniversary of the first book), published with the support of Adams's estate. A <a rel="mw:WikiLink" href="./BBC_Radio_4" title="BBC Radio 4" id="mwAbw">BBC Radio 4</a> <i id="mwAb0"><a rel="mw:WikiLink" href="./Book_at_Bedtime" title="Book at Bedtime" id="mwAb4">Book at Bedtime</a></i> adaptation and an audio book soon followed.</p>

<p id="mwAb8">On 25 May 2001, two weeks after Adams's death, his fans organised a tribute known as <a rel="mw:WikiLink" href="./Towel_Day" title="Towel Day" id="mwAcA">Towel Day</a>, which has been observed every year since then.<span about="#mwt198" class="mw-ref" id="cite_ref-64" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-64"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-64" style="counter-reset: mw-Ref 64;"><span class="mw-reflink-text">[64]</span></a></span></p>

<p id="mwAcE">In 2011, over 3,000 people took part in a public vote to choose the subjects of <a rel="mw:WikiLink" href="./Blue_plaque" title="Blue plaque" id="mwAcI">People's Plaques</a> in Islington;<span about="#mwt201" class="mw-ref" id="cite_ref-IPP_45-2" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-IPP-45"},"attrs":{"name":"IPP"}}'><a href="./Douglas_Adams#cite_note-IPP-45" style="counter-reset: mw-Ref 45;"><span class="mw-reflink-text">[45]</span></a></span> Adams received 489 votes.</p>

<p id="mwAcM">On 11 March 2013, Adams's 61st birthday was celebrated with an interactive <a rel="mw:WikiLink" href="./Google_Doodle" title="Google Doodle" id="mwAcQ">Google Doodle</a>.<span about="#mwt205" class="mw-ref" id="cite_ref-GoogleDoodle2013a_65-0" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-GoogleDoodle2013a-65"},"attrs":{"name":"GoogleDoodle2013a"}}'><a href="./Douglas_Adams#cite_note-GoogleDoodle2013a-65" style="counter-reset: mw-Ref 65;"><span class="mw-reflink-text">[65]</span></a></span><span about="#mwt207" class="mw-ref" id="cite_ref-66" rel="dc:references" typeof="mw:Extension/ref" data-mw='{"name":"ref","body":{"id":"mw-reference-text-cite_note-66"},"attrs":{}}'><a href="./Douglas_Adams#cite_note-66" style="counter-reset: mw-Ref 66;"><span class="mw-reflink-text">[66]</span></a></span></p>

<h2 id="Awards_and_nominations">Awards and nominations</h2>
<table class="wikitable" style="font-size:90%" id="mwAcU">
<tbody id="mwAcY"><tr style="text-align:center;" id="mwAcc">
<th style="background:#B0C4DE;" id="mwAcg"> Year</th>
<th style="background:#B0C4DE;" id="mwAck"> Award</th>
<th style="background:#B0C4DE;" id="mwAco"> Work</th>
<th style="background:#B0C4DE;" id="mwAcs"> Category</th>
<th style="background:#B0C4DE;" id="mwAcw"> Result</th>
<th style="background:#B0C4DE;" id="mwAc0"> Reference</th></tr>
<tr id="mwAc4">
<td id="mwAc8">1979</td>
<td id="mwAdA"><a rel="mw:WikiLink" href="./Hugo_Award" title="Hugo Award" id="mwAdE">Hugo Award</a></td>
<td id="mwAdI"><i id="mwAdM"><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(radio_series)" title="The Hitchhiker's Guide to the Galaxy (radio series)" id="mwAdQ">The Hitchhiker's Guide to the Galaxy</a></i><small id="mwAdU">(shared with <a rel="mw:WikiLink" href="./Geoffrey_Perkins" title="Geoffrey Perkins" id="mwAdY">Geoffrey Perkins</a>)</small></td>
<td id="mwAdc"><a rel="mw:WikiLink" href="./Hugo_Award_for_Best_Dramatic_Presentation" title="Hugo Award for Best Dramatic Presentation" id="mwAdg">Best Dramatic Presentation</a></td>
<td style="background: #FDD; color: black; vertical-align: middle; text-align: center; " class="no table-no2" typeof="mw:Transclusion" about="#mwt210" data-mw='{"parts":["|",{"template":{"target":{"wt":"nom","href":"./Template:Nom"},"params":{},"i":0}}]}' id="mwAdk">Nominated</td>
<td id="mwAdo"></td></tr>
</tbody></table>

<h2 id="Works">Works</h2>
<div class="refbegin   columns references-column-width" style="-moz-column-width: 20em; -webkit-column-width: 20em; column-width: 20em;" about="#mwt211" typeof="mw:Transclusion" data-mw="{&quot;parts&quot;:[{&quot;template&quot;:{&quot;target&quot;:{&quot;wt&quot;:&quot;Refbegin&quot;,&quot;href&quot;:&quot;./Template:Refbegin&quot;},&quot;params&quot;:{&quot;1&quot;:{&quot;wt&quot;:&quot;20em&quot;}},&quot;i&quot;:0}},&quot;\n* ''[[The Private Life of Genghis Khan]]'' (1975), based on a comedy sketch Adams co-wrote with [[Graham Chapman]] (short story)\n* ''[[The Hitchhiker's Guide to the Galaxy (radio series)|The Hitchhiker's Guide to the Galaxy]]'' (1978) (radio series)\n* ''[[The Hitchhiker's Guide to the Galaxy (book)|The Hitchhiker's Guide to the Galaxy]]'' (1979) (novel)\n* ''[[Shada (Doctor Who)|Shada]]'' (1979–1980), a Doctor Who serial\n* ''[[The Restaurant at the End of the Universe]]'' (1980) (novel)\n* ''[[Life, the Universe and Everything]]'' (1982) (novel)\n* ''[[The Meaning of Liff]]'' (1983 (book), with [[John Lloyd (producer)|John Lloyd]])\n* ''[[So Long, and Thanks for All the Fish]]'' (1984) (novel)\n* ''[[The Hitchhiker's Guide to the Galaxy (computer game)|The Hitchhiker's Guide to the Galaxy]]'' (1984, with [[Steve Meretzky]]) (computer game)\n* ''[[The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts]]'' (1985, with [[Geoffrey Perkins]])\n* ''[[Young Zaphod Plays It Safe]] (short story)'' (1986)\n* ''[[A Christmas Fairly Story]]'' &quot;,{&quot;template&quot;:{&quot;target&quot;:{&quot;wt&quot;:&quot;sic&quot;,&quot;href&quot;:&quot;./Template:Sic&quot;},&quot;params&quot;:{},&quot;i&quot;:1}},&quot; (1986, with [[Terry Jones]]), and\n* ''Supplement to The Meaning of Liff'' (1986, with [[John Lloyd (producer)|John Lloyd]] and [[Stephen Fry]]), both part of\n** ''[[The Utterly Utterly Merry Comic Relief Christmas Book]]'' (1986, edited with [[Peter Fincham]])\n* ''[[Bureaucracy (computer game)|Bureaucracy]]'' (1987) (computer game)\n* ''[[Dirk Gently's Holistic Detective Agency]]'' (1987) (novel)\n* ''[[The Long Dark Tea-Time of the Soul]]'' (1988) (novel)\n* ''[[The Deeper Meaning of Liff]]'' (1990, with [[John Lloyd (producer)|John Lloyd]])\n* ''[[Last Chance to See]]'' (1990, with [[Mark Carwardine]]) (book)\n* ''[[Mostly Harmless]]'' (1992) (novel)\n* ''[[The Hitchhiker's Guide to the Galaxy (book)#Illustrated edition|The Illustrated Hitchhiker's Guide to the Galaxy]]'' (1994)\n* ''[[Douglas Adams's Starship Titanic]]'' (1997), written by [[Terry Jones]], based on an idea by Adams\n* ''[[Starship Titanic]]'' (computer game) (1998)\n* ''[[h2g2]]'' (internet project) (1999)\n* ''The Internet: The Last Battleground of the 20th century'' (radio series) (2000)\n* ''[[The Hitchhiker's Guide to the Future]]'' (radio series) (2001) final project for [[BBC Radio 4]] before his death\n* ''[https://www.youtube.com/watch?v=_ZG8HBuDjgc Parrots, the universe and everything]'' (2001)\n* ''[[The Salmon of Doubt]]'' (2002), unfinished novel manuscript (11 chapters), short stories, essays, and interviews (also available as an audiobook, read by [[Simon Jones (actor)|Simon Jones]])\n*  ''[[The Hitchhiker's Guide to the Galaxy (film)|The Hitchhiker's Guide to the Galaxy]]'' (2005) (film)\n&quot;,{&quot;template&quot;:{&quot;target&quot;:{&quot;wt&quot;:&quot;Refend&quot;,&quot;href&quot;:&quot;./Template:Refend&quot;},&quot;params&quot;:{},&quot;i&quot;:2}}]}" id="mwAds">
<ul><li> <i><a rel="mw:WikiLink" href="./The_Private_Life_of_Genghis_Khan" title="The Private Life of Genghis Khan">The Private Life of Genghis Khan</a></i> (1975), based on a comedy sketch Adams co-wrote with <a rel="mw:WikiLink" href="./Graham_Chapman" title="Graham Chapman">Graham Chapman</a> (short story)</li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(radio_series)" title="The Hitchhiker's Guide to the Galaxy (radio series)">The Hitchhiker's Guide to the Galaxy</a></i> (1978) (radio series)</li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(book)" title="The Hitchhiker's Guide to the Galaxy (book)" class="mw-redirect">The Hitchhiker's Guide to the Galaxy</a></i> (1979) (novel)</li>
<li> <i><a rel="mw:WikiLink" href="./Shada_(Doctor_Who)" title="Shada (Doctor Who)">Shada</a></i> (1979–1980), a Doctor Who serial</li>
<li> <i><a rel="mw:WikiLink" href="./The_Restaurant_at_the_End_of_the_Universe" title="The Restaurant at the End of the Universe">The Restaurant at the End of the Universe</a></i> (1980) (novel)</li>
<li> <i><a rel="mw:WikiLink" href="./Life,_the_Universe_and_Everything" title="Life, the Universe and Everything">Life, the Universe and Everything</a></i> (1982) (novel)</li>
<li> <i><a rel="mw:WikiLink" href="./The_Meaning_of_Liff" title="The Meaning of Liff">The Meaning of Liff</a></i> (1983 (book), with <a rel="mw:WikiLink" href="./John_Lloyd_(producer)" title="John Lloyd (producer)">John Lloyd</a>)</li>
<li> <i><a rel="mw:WikiLink" href="./So_Long,_and_Thanks_for_All_the_Fish" title="So Long, and Thanks for All the Fish">So Long, and Thanks for All the Fish</a></i> (1984) (novel)</li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(computer_game)" title="The Hitchhiker's Guide to the Galaxy (computer game)" class="mw-redirect">The Hitchhiker's Guide to the Galaxy</a></i> (1984, with <a rel="mw:WikiLink" href="./Steve_Meretzky" title="Steve Meretzky">Steve Meretzky</a>) (computer game)</li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy:_The_Original_Radio_Scripts" title="The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts">The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts</a></i> (1985, with <a rel="mw:WikiLink" href="./Geoffrey_Perkins" title="Geoffrey Perkins">Geoffrey Perkins</a>)</li>
<li> <i><a rel="mw:WikiLink" href="./Young_Zaphod_Plays_It_Safe" title="Young Zaphod Plays It Safe">Young Zaphod Plays It Safe</a> (short story)</i> (1986)</li>
<li> <i><a rel="mw:WikiLink" href="./A_Christmas_Fairly_Story" title="A Christmas Fairly Story" class="new">A Christmas Fairly Story</a></i> <span typeof="mw:Entity"> </span><span typeof="mw:Entity">[</span><i><a rel="mw:WikiLink" href="./Sic" title="Sic">sic</a></i><span typeof="mw:Entity">]</span> (1986, with <a rel="mw:WikiLink" href="./Terry_Jones" title="Terry Jones">Terry Jones</a>), and</li>
<li> <i>Supplement to The Meaning of Liff</i> (1986, with <a rel="mw:WikiLink" href="./John_Lloyd_(producer)" title="John Lloyd (producer)">John Lloyd</a> and <a rel="mw:WikiLink" href="./Stephen_Fry" title="Stephen Fry">Stephen Fry</a>), both part of
<ul><li> <i><a rel="mw:WikiLink" href="./The_Utterly_Utterly_Merry_Comic_Relief_Christmas_Book" title="The Utterly Utterly Merry Comic Relief Christmas Book">The Utterly Utterly Merry Comic Relief Christmas Book</a></i> (1986, edited with <a rel="mw:WikiLink" href="./Peter_Fincham" title="Peter Fincham">Peter Fincham</a>)</li></ul></li>
<li> <i><a rel="mw:WikiLink" href="./Bureaucracy_(computer_game)" title="Bureaucracy (computer game)" class="mw-redirect">Bureaucracy</a></i> (1987) (computer game)</li>
<li> <i><a rel="mw:WikiLink" href="./Dirk_Gently's_Holistic_Detective_Agency" title="Dirk Gently's Holistic Detective Agency">Dirk Gently's Holistic Detective Agency</a></i> (1987) (novel)</li>
<li> <i><a rel="mw:WikiLink" href="./The_Long_Dark_Tea-Time_of_the_Soul" title="The Long Dark Tea-Time of the Soul">The Long Dark Tea-Time of the Soul</a></i> (1988) (novel)</li>
<li> <i><a rel="mw:WikiLink" href="./The_Deeper_Meaning_of_Liff" title="The Deeper Meaning of Liff" class="mw-redirect">The Deeper Meaning of Liff</a></i> (1990, with <a rel="mw:WikiLink" href="./John_Lloyd_(producer)" title="John Lloyd (producer)">John Lloyd</a>)</li>
<li> <i><a rel="mw:WikiLink" href="./Last_Chance_to_See" title="Last Chance to See">Last Chance to See</a></i> (1990, with <a rel="mw:WikiLink" href="./Mark_Carwardine" title="Mark Carwardine">Mark Carwardine</a>) (book)</li>
<li> <i><a rel="mw:WikiLink" href="./Mostly_Harmless" title="Mostly Harmless">Mostly Harmless</a></i> (1992) (novel)</li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(book)#Illustrated_edition" title="The Hitchhiker's Guide to the Galaxy (book)" class="mw-redirect">The Illustrated Hitchhiker's Guide to the Galaxy</a></i> (1994)</li>
<li> <i><a rel="mw:WikiLink" href="./Douglas_Adams's_Starship_Titanic" title="Douglas Adams's Starship Titanic" class="mw-redirect">Douglas Adams's Starship Titanic</a></i> (1997), written by <a rel="mw:WikiLink" href="./Terry_Jones" title="Terry Jones">Terry Jones</a>, based on an idea by Adams</li>
<li> <i><a rel="mw:WikiLink" href="./Starship_Titanic" title="Starship Titanic">Starship Titanic</a></i> (computer game) (1998)</li>
<li> <i><a rel="mw:WikiLink" href="./H2g2" title="H2g2">h2g2</a></i> (internet project) (1999)</li>
<li> <i>The Internet: The Last Battleground of the 20th century</i> (radio series) (2000)</li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Future" title="The Hitchhiker's Guide to the Future">The Hitchhiker's Guide to the Future</a></i> (radio series) (2001) final project for <a rel="mw:WikiLink" href="./BBC_Radio_4" title="BBC Radio 4">BBC Radio 4</a> before his death</li>
<li> <i><a rel="mw:ExtLink" href="https://www.youtube.com/watch?v=_ZG8HBuDjgc">Parrots, the universe and everything</a></i> (2001)</li>
<li> <i><a rel="mw:WikiLink" href="./The_Salmon_of_Doubt" title="The Salmon of Doubt">The Salmon of Doubt</a></i> (2002), unfinished novel manuscript (11 chapters), short stories, essays, and interviews (also available as an audiobook, read by <a rel="mw:WikiLink" href="./Simon_Jones_(actor)" title="Simon Jones (actor)">Simon Jones</a>)</li>
<li>  <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(film)" title="The Hitchhiker's Guide to the Galaxy (film)">The Hitchhiker's Guide to the Galaxy</a></i> (2005) (film)</li></ul>
</div>

<h2 id="Writing_credits">Writing credits</h2>
<table class="wikitable" id="mwAdw">
<tbody id="mwAd0"><tr style="background:#ccc; text-align:center;" id="mwAd4">
<th id="mwAd8"> Production</th>
<th id="mwAeA"> Notes</th>
<th id="mwAeE"> Broadcaster</th></tr>
<tr id="mwAeI">
<td id="mwAeM"><i id="mwAeQ"><a rel="mw:WikiLink" href="./Monty_Python's_Flying_Circus" title="Monty Python's Flying Circus" id="mwAeU">Monty Python's Flying Circus</a></i></td>
<td id="mwAeY">
<ul id="mwAec"><li id="mwAeg">"<a rel="mw:WikiLink" href="./List_of_Monty_Python's_Flying_Circus_episodes#6._Party_Political_Broadcast" title="List of Monty Python's Flying Circus episodes" id="mwAek">Party Political Broadcast on Behalf of the Liberal Party</a>" (1974)</li></ul></td>
<td id="mwAeo"><a rel="mw:WikiLink" href="./BBC_Two" title="BBC Two" id="mwAes">BBC Two</a></td></tr>
<tr id="mwAew">
<td id="mwAe0"><i id="mwAe4"><a rel="mw:WikiLink" href="./Out_of_the_Trees" title="Out of the Trees" id="mwAe8">Out of the Trees</a></i></td>
<td id="mwAfA">
<ul id="mwAfE"><li id="mwAfI">Television pilot (1976)</li></ul></td>
<td id="mwAfM">BBC Two</td></tr>
<tr id="mwAfQ">
<td id="mwAfU"><i id="mwAfY"><a rel="mw:WikiLink" href="./Doctor_on_the_Go" title="Doctor on the Go" id="mwAfc">Doctor on the Go</a></i></td>
<td id="mwAfg">
<ul id="mwAfk"><li id="mwAfo">"For Your Own Good" (1977)</li></ul></td>
<td id="mwAfs"><a rel="mw:WikiLink" href="./ITV_(TV_network)" title="ITV (TV network)" id="mwAfw">ITV</a></td></tr>
<tr id="mwAf0">
<td id="mwAf4"><i id="mwAf8"><a rel="mw:WikiLink" href="./Doctor_Who" title="Doctor Who" id="mwAgA">Doctor Who</a></i></td>
<td id="mwAgE">
<p id="mwAgI">5 episodes (1978-1979, 1983): </p>
<ul id="mwAgM"><li id="mwAgQ">"<a rel="mw:WikiLink" href="./The_Pirate_Planet" title="The Pirate Planet" id="mwAgU">The Pirate Planet</a>" (1978)</li>
<li id="mwAgY">"<a rel="mw:WikiLink" href="./Destiny_of_the_Daleks" title="Destiny of the Daleks" id="mwAgc">Destiny of the Daleks</a>" (1979) (uncredited)</li>
<li id="mwAgg">"<a rel="mw:WikiLink" href="./City_of_Death" title="City of Death" id="mwAgk">City of Death</a>" (co-written with <a rel="mw:WikiLink" href="./Graham_Williams_(television_producer)" title="Graham Williams (television producer)" id="mwAgo">Graham Williams</a>, 1979)</li>
<li id="mwAgs">"<a rel="mw:WikiLink" href="./The_Five_Doctors" title="The Five Doctors" id="mwAgw">The Five Doctors</a>" (1983) (<a rel="mw:WikiLink" href="./Shada_(Doctor_Who)" title="Shada (Doctor Who)" id="mwAg0">Shada</a> segments; uncredited)</li></ul></td>
<td id="mwAg4"><a rel="mw:WikiLink" href="./BBC_One" title="BBC One" id="mwAg8">BBC One</a></td></tr>
<tr id="mwAhA">
<td id="mwAhE"><i id="mwAhI"><a rel="mw:WikiLink" href="./Doctor_Snuggles" title="Doctor Snuggles" id="mwAhM">Doctor Snuggles</a></i></td>
<td id="mwAhQ">
<ul id="mwAhU"><li id="mwAhY">"The Great Disappearing Mystery" (1979)</li>
<li id="mwAhc">"The Remarkable Fidgety River" (1979)</li></ul></td>
<td id="mwAhg">ITV</td></tr>
<tr id="mwAhk">
<td id="mwAho"><i id="mwAhs"><a rel="mw:WikiLink" href="./Not_the_Nine_O'Clock_News" title="Not the Nine O'Clock News" id="mwAhw">Not the Nine O'Clock News</a></i></td>
<td id="mwAh0">
<ul id="mwAh4"><li id="mwAh8">Unknown episodes (1979)</li></ul></td>
<td id="mwAiA">BBC Two</td></tr>
<tr id="mwAiE">
<td id="mwAiI"><i id="mwAiM"><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(TV_series)" title="The Hitchhiker's Guide to the Galaxy (TV series)" id="mwAiQ">The Hitchhiker's Guide to the Galaxy</a></i></td>
<td id="mwAiU">
<ul id="mwAiY"><li id="mwAic">6 episodes (1981)</li></ul></td>
<td id="mwAig">BBC Two</td></tr>
<tr id="mwAik">
<td id="mwAio"><i id="mwAis"><a rel="mw:WikiLink" href="./Hyperland" title="Hyperland" id="mwAiw">Hyperland</a></i></td>
<td id="mwAi0">
<ul id="mwAi4"><li id="mwAi8">Television documentary (1990)</li></ul></td>
<td id="mwAjA">BBC Two</td></tr>
</tbody></table>

<h2 id="Notes">Notes</h2>
<div class="reflist columns references-column-width" style="-moz-column-width: 30em; -webkit-column-width: 30em; column-width: 30em; list-style-type: decimal;" about="#mwt214" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"reflist","href":"./Template:Reflist"},"params":{"1":{"wt":"30em"}},"i":0}}]}' id="mwAjE">
<ol class="mw-references" typeof="mw:Extension/references" about="#mwt252" data-mw='{"name":"references","attrs":{}}'><li about="#cite_note-radioacad-1" id="cite_note-radioacad-1"><a href="./Douglas_Adams#cite_ref-radioacad_1-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-radioacad-1" class="mw-reference-text"><cite class="citation web" about="#mwt7" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"title":{"wt":"The Radio Academy Hall of Fame"},"url":{"wt":"http://www.radioacademy.org/hall-of-fame"},"work":{"wt":"The Radio Academy"},"accessdate":{"wt":"8 December 2011"},"archiveurl":{"wt":"http://www.webcitation.org/63mNGrql2?url=http://www.radioacademy.org/hall-of-fame/"},"archivedate":{"wt":"8 December 2011"},"deadurl":{"wt":"yes"},"df":{"wt":"dmy"}},"i":0}}]}' id="mwAjI"><a rel="mw:ExtLink" href="http://www.webcitation.org/63mNGrql2?url=http://www.radioacademy.org/hall-of-fame/" id="mwAjM">"The Radio Academy Hall of Fame"</a>. <i id="mwAjQ">The Radio Academy</i>. Archived from <a rel="mw:ExtLink" href="http://www.radioacademy.org/hall-of-fame" id="mwAjU">the original</a> on 8 December 2011<span class="reference-accessdate" id="mwAjY">. Retrieved <span class="nowrap" id="mwAjc">8 December</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=The+Radio+Academy+Hall+of+Fame&amp;rft.genre=unknown&amp;rft.jtitle=The+Radio+Academy&amp;rft_id=http%3A%2F%2Fwww.radioacademy.org%2Fhall-of-fame&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt7" id="mwAjg"><span style="display:none;" id="mwAjk"><span typeof="mw:Entity" id="mwAjo"> </span></span></span></span></li><li about="#cite_note-ODNB-2" id="cite_note-ODNB-2"><span rel="mw:referencedBy"><a href="./Douglas_Adams#cite_ref-ODNB_2-0"><span class="mw-linkback-text">1 </span></a><a href="./Douglas_Adams#cite_ref-ODNB_2-1"><span class="mw-linkback-text">2 </span></a><a href="./Douglas_Adams#cite_ref-ODNB_2-2"><span class="mw-linkback-text">3 </span></a><a href="./Douglas_Adams#cite_ref-ODNB_2-3"><span class="mw-linkback-text">4 </span></a></span> <span id="mw-reference-text-cite_note-ODNB-2" class="mw-reference-text">Webb 2005b</span></li><li about="#cite_note-Adams_xix-3" id="cite_note-Adams_xix-3"><span rel="mw:referencedBy"><a href="./Douglas_Adams#cite_ref-Adams_xix_3-0"><span class="mw-linkback-text">1 </span></a><a href="./Douglas_Adams#cite_ref-Adams_xix_3-1"><span class="mw-linkback-text">2 </span></a></span> <span id="mw-reference-text-cite_note-Adams_xix-3" class="mw-reference-text"><a rel="mw:WikiLink" href="./Douglas_Adams#CITEREFAdams2002" about="#mwt13" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Harvnb","href":"./Template:Harvnb"},"params":{"1":{"wt":"Adams"},"2":{"wt":"2002"},"pp":{"wt":"xix"}},"i":0}}]}' id="mwAjs">Adams 2002</a><span about="#mwt13" id="mwAjw">, pp.</span><span typeof="mw:Entity" about="#mwt13" id="mwAj0"> </span><span about="#mwt13" id="mwAj4">xix</span></span></li><li about="#cite_note-4" id="cite_note-4"><a href="./Douglas_Adams#cite_ref-4" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-4" class="mw-reference-text">Webb 2005a, p. 32.</span></li><li about="#cite_note-Adams_7-5" id="cite_note-Adams_7-5"><a href="./Douglas_Adams#cite_ref-Adams_7_5-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-Adams_7-5" class="mw-reference-text"><a rel="mw:WikiLink" href="./Douglas_Adams#CITEREFAdams2002" about="#mwt20" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Harvnb","href":"./Template:Harvnb"},"params":{"1":{"wt":"Adams"},"2":{"wt":"2002"},"pp":{"wt":"7"}},"i":0}}]}' id="mwAj8">Adams 2002</a><span about="#mwt20" id="mwAkA">, pp.</span><span typeof="mw:Entity" about="#mwt20" id="mwAkE"> </span><span about="#mwt20" id="mwAkI">7</span></span></li><li about="#cite_note-6" id="cite_note-6"><a href="./Douglas_Adams#cite_ref-6" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-6" class="mw-reference-text">Botti, Nicholas. <a rel="mw:ExtLink" href="http://douglasadams.eu/interview-with-frank-halford/" id="mwAkM">"Interview with Frank Halford"</a>. <i id="mwAkQ">Life, DNA, and H2G2.</i> 2009. Web. Retrieved 13 March 2012. (Click on link at bottom for facsimile page from <i id="mwAkU">Daily News</i> article, 7 March 1998.)</span></li><li about="#cite_note-Simpson_9-7" id="cite_note-Simpson_9-7"><a href="./Douglas_Adams#cite_ref-Simpson_9_7-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-Simpson_9-7" class="mw-reference-text"><a rel="mw:WikiLink" href="./Douglas_Adams#CITEREFSimpson2003" about="#mwt23" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Harvnb","href":"./Template:Harvnb"},"params":{"1":{"wt":"Simpson"},"2":{"wt":"2003"},"pp":{"wt":"9"}},"i":0}}]}' id="mwAkY">Simpson 2003</a><span about="#mwt23" id="mwAkc">, pp.</span><span typeof="mw:Entity" about="#mwt23" id="mwAkg"> </span><span about="#mwt23" id="mwAkk">9</span></span></li><li about="#cite_note-8" id="cite_note-8"><a href="./Douglas_Adams#cite_ref-8" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-8" class="mw-reference-text">Flood, Alison (March 2014). <a rel="mw:ExtLink" href="https://www.theguardian.com/books/2014/mar/19/lost-school-poems-douglas-adams-griff-rhys-jones" id="mwAko">"Lost poems of Douglas Adams and Griff Rhys Jones found in school cupboard"</a>, <i id="mwAks">The Guardian</i>, 19 March 2014. Accessed 2 July 2014</span></li><li about="#cite_note-Simpson_30-40-9" id="cite_note-Simpson_30-40-9"><a href="./Douglas_Adams#cite_ref-Simpson_30-40_9-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-Simpson_30-40-9" class="mw-reference-text"><a rel="mw:WikiLink" href="./Douglas_Adams#CITEREFSimpson2003" about="#mwt30" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Harvnb","href":"./Template:Harvnb"},"params":{"1":{"wt":"Simpson"},"2":{"wt":"2003"},"pp":{"wt":"30–40"}},"i":0}}]}' id="mwAkw">Simpson 2003</a><span about="#mwt30" id="mwAk0">, pp.</span><span typeof="mw:Entity" about="#mwt30" id="mwAk4"> </span><span about="#mwt30" id="mwAk8">30–40</span></span></li><li about="#cite_note-times-10" id="cite_note-times-10"><a href="./Douglas_Adams#cite_ref-times_10-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-times-10" class="mw-reference-text"><cite class="citation news" about="#mwt34" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite news","href":"./Template:Cite_news"},"params":{"title":{"wt":"Terry Jones remembers Douglas Adams, &#39;the last of the Pythons&#39;"},"newspaper":{"wt":"The Times"},"date":{"wt":"10 October 2009"}},"i":0}}]}' id="mwAlA">"Terry Jones remembers Douglas Adams, 'the last of the Pythons<span style="padding-right:0.2em;" id="mwAlE">'</span>". <i id="mwAlI">The Times</i>. 10 October 2009.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Terry+Jones+remembers+Douglas+Adams%2C+%27the+last+of+the+Pythons%27&amp;rft.date=2009-10-10&amp;rft.genre=article&amp;rft.jtitle=The+Times&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt34" id="mwAlM"><span style="display:none;" id="mwAlQ"><span typeof="mw:Entity" id="mwAlU"> </span></span></span></span></li><li about="#cite_note-11" id="cite_note-11"><a href="./Douglas_Adams#cite_ref-11" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-11" class="mw-reference-text">Webb 2005a, p. 93.</span></li><li about="#cite_note-Adams_prologue-12" id="cite_note-Adams_prologue-12"><a href="./Douglas_Adams#cite_ref-Adams_prologue_12-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-Adams_prologue-12" class="mw-reference-text"><a rel="mw:WikiLink" href="./Douglas_Adams#CITEREFAdams2002" about="#mwt43" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Harvnb","href":"./Template:Harvnb"},"params":{"1":{"wt":"Adams"},"2":{"wt":"2002"},"pp":{"wt":"prologue"}},"i":0}}]}' id="mwAlY">Adams 2002</a><span about="#mwt43" id="mwAlc">, pp.</span><span typeof="mw:Entity" about="#mwt43" id="mwAlg"> </span><span about="#mwt43" id="mwAlk">prologue</span></span></li><li about="#cite_note-13" id="cite_note-13"><a href="./Douglas_Adams#cite_ref-13" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-13" class="mw-reference-text"><i id="mwAlo">Hitchhiker: A Biography of Douglas Adams</i> by M. J. Simpson, p87</span></li><li about="#cite_note-14" id="cite_note-14"><a href="./Douglas_Adams#cite_ref-14" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-14" class="mw-reference-text">Roberts, Jem. <i id="mwAls">The Clue Bible: The Fully Authorised History of I'm Sorry I Haven't A Clue from Footlights to Mornington Crescent</i>: London, 2009, p164-5</span></li><li about="#cite_note-15" id="cite_note-15"><a href="./Douglas_Adams#cite_ref-15" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-15" class="mw-reference-text"><cite class="citation book" about="#mwt52" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite book ","href":"./Template:Cite_book"},"params":{"author":{"wt":"Adams, Douglas"},"editor":{"wt":"Geoffrey Perkins (ed.), Additional Material by M. J. Simpson"},"title":{"wt":"[[The Hitchhiker&#39;s Guide to the Galaxy: The Original Radio Scripts]]"},"page":{"wt":"10"},"edition":{"wt":"25th Anniversary"},"publisher":{"wt":"Pan Books"},"year":{"wt":"2003"},"isbn":{"wt":"0-330-41957-9"}},"i":0}}]}' id="mwAlw">Adams, Douglas (2003).  Geoffrey Perkins (ed.), Additional Material by M. J. Simpson, ed. <i id="mwAl0"><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy:_The_Original_Radio_Scripts" title="The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts" id="mwAl4">The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts</a></i> (25th Anniversary ed.). Pan Books. p.<span typeof="mw:Entity" id="mwAl8"> </span>10. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" id="mwAmA">ISBN</a><span typeof="mw:Entity" id="mwAmE"> </span><a rel="mw:WikiLink" href="./Special:BookSources/0-330-41957-9" title="Special:BookSources/0-330-41957-9" id="mwAmI">0-330-41957-9</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Adams%2C+Douglas&amp;rft.btitle=The+Hitchhiker%27s+Guide+to+the+Galaxy%3A+The+Original+Radio+Scripts&amp;rft.date=2003&amp;rft.edition=25th+Anniversary&amp;rft.genre=book&amp;rft.isbn=0-330-41957-9&amp;rft.pages=10&amp;rft.pub=Pan+Books&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt52" id="mwAmM"><span style="display:none;" id="mwAmQ"><span typeof="mw:Entity" id="mwAmU"> </span></span></span></span></li><li about="#cite_note-16" id="cite_note-16"><a href="./Douglas_Adams#cite_ref-16" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-16" class="mw-reference-text">Webb 2005a, p. 120.</span></li><li about="#cite_note-17" id="cite_note-17"><a href="./Douglas_Adams#cite_ref-17" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-17" class="mw-reference-text">Felch 2004</span></li><li about="#cite_note-Simpson_236-18" id="cite_note-Simpson_236-18"><a href="./Douglas_Adams#cite_ref-Simpson_236_18-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-Simpson_236-18" class="mw-reference-text"><a rel="mw:WikiLink" href="./Douglas_Adams#CITEREFSimpson2003" about="#mwt59" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Harvnb","href":"./Template:Harvnb"},"params":{"1":{"wt":"Simpson"},"2":{"wt":"2003"},"pp":{"wt":"236"}},"i":0}}]}' id="mwAmY">Simpson 2003</a><span about="#mwt59" id="mwAmc">, pp.</span><span typeof="mw:Entity" about="#mwt59" id="mwAmg"> </span><span about="#mwt59" id="mwAmk">236</span></span></li><li about="#cite_note-19" id="cite_note-19"><a href="./Douglas_Adams#cite_ref-19" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-19" class="mw-reference-text"><a rel="mw:ExtLink" href="http://www.iblist.com/series.php?id=2" id="mwAmo">Internet Book List</a> page, with links to all five novels, and reproductions of the 1990s paperback covers that included the <a rel="mw:WikiLink" href="./42_Puzzle" title="42 Puzzle" id="mwAms" class="mw-redirect">42 Puzzle</a>.</span></li><li about="#cite_note-20" id="cite_note-20"><a href="./Douglas_Adams#cite_ref-20" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-20" class="mw-reference-text"><cite class="citation" about="#mwt64" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"citation","href":"./Template:Citation"},"params":{"url":{"wt":"http://www.imdb.com/title/tt0081874/"},"title":{"wt":"&#39;&#39;The Hitch Hiker&#39;s Guide to the Galaxy&#39;&#39;"},"publisher":{"wt":"Internet Movie Database"}},"i":0}}]}' id="mwAmw"><a rel="mw:ExtLink" href="http://www.imdb.com/title/tt0081874/" id="mwAm0"><i id="mwAm4"><span id="mwAm8"></span></i>The Hitch Hiker's Guide to the Galaxy<i id="mwAnA"><span id="mwAnE"></span></i></a>, Internet Movie Database</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=The+Hitch+Hiker%27s+Guide+to+the+Galaxy&amp;rft.genre=book&amp;rft.pub=Internet+Movie+Database&amp;rft_id=http%3A%2F%2Fwww.imdb.com%2Ftitle%2Ftt0081874%2F&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt64" id="mwAnI"><span style="display:none;" id="mwAnM"><span typeof="mw:Entity" id="mwAnQ"> </span></span></span></span></li><li about="#cite_note-21" id="cite_note-21"><a href="./Douglas_Adams#cite_ref-21" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-21" class="mw-reference-text"><cite class="citation book" about="#mwt68" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite book ","href":"./Template:Cite_book"},"params":{"author":{"wt":"Adams, Douglas."},"editor":{"wt":"[[Dirk Maggs]], dramatisations and editor"},"title":{"wt":"The Hitchhiker&#39;s Guide to the Galaxy Radio Scripts: The Tertiary, Quandary and Quintessential Phases"},"publisher":{"wt":"Pan Books"},"year":{"wt":"2005"},"isbn":{"wt":"0-330-43510-8"},"pages":{"wt":"xiv"},"nopp":{"wt":"true"}},"i":0}}]}' id="mwAnU">Adams, Douglas. (2005).  <a rel="mw:WikiLink" href="./Dirk_Maggs" title="Dirk Maggs" id="mwAnY">Dirk Maggs</a>, dramatisations and editor, ed. <i id="mwAnc">The Hitchhiker's Guide to the Galaxy Radio Scripts: The Tertiary, Quandary and Quintessential Phases</i>. Pan Books. xiv. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" id="mwAng">ISBN</a><span typeof="mw:Entity" id="mwAnk"> </span><a rel="mw:WikiLink" href="./Special:BookSources/0-330-43510-8" title="Special:BookSources/0-330-43510-8" id="mwAno">0-330-43510-8</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Adams%2C+Douglas.&amp;rft.btitle=The+Hitchhiker%27s+Guide+to+the+Galaxy+Radio+Scripts%3A+The+Tertiary%2C+Quandary+and+Quintessential+Phases&amp;rft.date=2005&amp;rft.genre=book&amp;rft.isbn=0-330-43510-8&amp;rft.pages=xiv&amp;rft.pub=Pan+Books&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt68" id="mwAns"><span style="display:none;" id="mwAnw"><span typeof="mw:Entity" id="mwAn0"> </span></span></span><span class="citation-comment" style="display:none; color:#33aa33; margin-left:0.3em" about="#mwt68" id="mwAn4">CS1 maint: Extra text: editors list (<a rel="mw:WikiLink" href="./Category:CS1_maint:_Extra_text:_editors_list" title="Category:CS1 maint: Extra text: editors list" id="mwAn8">link</a>)</span><link rel="mw:PageProp/Category" href="./Category:CS1_maint:_Extra_text:_editors_list" about="#mwt68" id="mwAoA"/></span></li><li about="#cite_note-22" id="cite_note-22"><a href="./Douglas_Adams#cite_ref-22" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-22" class="mw-reference-text">Adams, <i id="mwAoE">Dirk Maggs</i>, Page 356.</span></li><li about="#cite_note-23" id="cite_note-23"><a href="./Douglas_Adams#cite_ref-23" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-23" class="mw-reference-text"><cite class="citation book" about="#mwt72" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite book","href":"./Template:Cite_book"},"params":{"author":{"wt":"[[Neil Gaiman|Gaiman, Neil]]"},"title":{"wt":"Don&#39;t Panic: Douglas Adams &amp; The Hitchhiker&#39;s Guide to the Galaxy"},"edition":{"wt":"Second U.S."},"publisher":{"wt":"Titan Books"},"year":{"wt":"2003"},"page":{"wt":"169"},"isbn":{"wt":"1-84023-742-2"}},"i":0}}]}' id="mwAoI"><a rel="mw:WikiLink" href="./Neil_Gaiman" title="Neil Gaiman" id="mwAoM">Gaiman, Neil</a> (2003). <i id="mwAoQ">Don't Panic: Douglas Adams &amp; The Hitchhiker's Guide to the Galaxy</i> (Second U.S. ed.). Titan Books. p.<span typeof="mw:Entity" id="mwAoU"> </span>169. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" id="mwAoY">ISBN</a><span typeof="mw:Entity" id="mwAoc"> </span><a rel="mw:WikiLink" href="./Special:BookSources/1-84023-742-2" title="Special:BookSources/1-84023-742-2" id="mwAog">1-84023-742-2</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Gaiman%2C+Neil&amp;rft.btitle=Don%27t+Panic%3A+Douglas+Adams+%26+The+Hitchhiker%27s+Guide+to+the+Galaxy&amp;rft.date=2003&amp;rft.edition=Second+U.S.&amp;rft.genre=book&amp;rft.isbn=1-84023-742-2&amp;rft.pages=169&amp;rft.pub=Titan+Books&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt72" id="mwAok"><span style="display:none;" id="mwAoo"><span typeof="mw:Entity" id="mwAos"> </span></span></span></span></li><li about="#cite_note-24" id="cite_note-24"><a href="./Douglas_Adams#cite_ref-24" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-24" class="mw-reference-text"><cite class="citation web" about="#mwt77" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"http://www.skepticfiles.org/en001/drwhogde.htm"},"title":{"wt":"A 1990s Doctor Who FAQ"},"publisher":{"wt":"Skepticfiles.org"},"accessdate":{"wt":"11 March 2013"}},"i":0}}]}' id="mwAow"><a rel="mw:ExtLink" href="http://www.skepticfiles.org/en001/drwhogde.htm" id="mwAo0">"A 1990s Doctor Who FAQ"</a>. Skepticfiles.org<span class="reference-accessdate" id="mwAo4">. Retrieved <span class="nowrap" id="mwAo8">11 March</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=A+1990s+Doctor+Who+FAQ&amp;rft.genre=unknown&amp;rft.pub=Skepticfiles.org&amp;rft_id=http%3A%2F%2Fwww.skepticfiles.org%2Fen001%2Fdrwhogde.htm&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt77" id="mwApA"><span style="display:none;" id="mwApE"><span typeof="mw:Entity" id="mwApI"> </span></span></span></span></li><li about="#cite_note-25" id="cite_note-25"><a href="./Douglas_Adams#cite_ref-25" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-25" class="mw-reference-text"><cite class="citation web" about="#mwt80" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"last":{"wt":"Moffat"},"first":{"wt":"Steven"},"url":{"wt":"http://www.radiotimes.com/news/2012-12-24/doctor-who-christmas-special-steven-moffat-matt-smith-and-jenna-louise-coleman-reveal-all"},"title":{"wt":"Doctor Who Christmas special: Steven Moffat, Matt Smith and Jenna-Louise Coleman reveal all"},"work":{"wt":"Radio Times"},"date":{"wt":"24 December 2012"},"accessdate":{"wt":"8 July 2013"}},"i":0}}]}' id="mwApM">Moffat, Steven (24 December 2012). <a rel="mw:ExtLink" href="http://www.radiotimes.com/news/2012-12-24/doctor-who-christmas-special-steven-moffat-matt-smith-and-jenna-louise-coleman-reveal-all" id="mwApQ">"Doctor Who Christmas special: Steven Moffat, Matt Smith and Jenna-Louise Coleman reveal all"</a>. <i id="mwApU">Radio Times</i><span class="reference-accessdate" id="mwApY">. Retrieved <span class="nowrap" id="mwApc">8 July</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Doctor+Who+Christmas+special%3A+Steven+Moffat%2C+Matt+Smith+and+Jenna-Louise+Coleman+reveal+all&amp;rft.aufirst=Steven&amp;rft.aulast=Moffat&amp;rft.date=2012-12-24&amp;rft.genre=unknown&amp;rft.jtitle=Radio+Times&amp;rft_id=http%3A%2F%2Fwww.radiotimes.com%2Fnews%2F2012-12-24%2Fdoctor-who-christmas-special-steven-moffat-matt-smith-and-jenna-louise-coleman-reveal-all&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt80" id="mwApg"><span style="display:none;" id="mwApk"><span typeof="mw:Entity" id="mwApo"> </span></span></span></span></li><li about="#cite_note-26" id="cite_note-26"><a href="./Douglas_Adams#cite_ref-26" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-26" class="mw-reference-text">Webb, page 49.</span></li><li about="#cite_note-Mabbett-MM-27" id="cite_note-Mabbett-MM-27"><span rel="mw:referencedBy"><a href="./Douglas_Adams#cite_ref-Mabbett-MM_27-0"><span class="mw-linkback-text">1 </span></a><a href="./Douglas_Adams#cite_ref-Mabbett-MM_27-1"><span class="mw-linkback-text">2 </span></a></span> <span id="mw-reference-text-cite_note-Mabbett-MM-27" class="mw-reference-text"><cite class="citation book" about="#mwt86" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Cite book ","href":"./Template:Cite_book"},"params":{"publisher":{"wt":"Omnibus Press"},"isbn":{"wt":"978-1-84938-370-7"},"last":{"wt":"Mabbett"},"first":{"wt":"Andy"},"title":{"wt":"Pink Floyd – The Music and the Mystery"},"location":{"wt":"London"},"year":{"wt":"2010"}},"i":0}}]}' id="mwAps">Mabbett, Andy (2010). <i id="mwApw">Pink Floyd – The Music and the Mystery</i>. London: Omnibus Press. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" id="mwAp0">ISBN</a><span typeof="mw:Entity" id="mwAp4"> </span><a rel="mw:WikiLink" href="./Special:BookSources/978-1-84938-370-7" title="Special:BookSources/978-1-84938-370-7" id="mwAp8">978-1-84938-370-7</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.aufirst=Andy&amp;rft.aulast=Mabbett&amp;rft.btitle=Pink+Floyd+%E2%80%93+The+Music+and+the+Mystery&amp;rft.date=2010&amp;rft.genre=book&amp;rft.isbn=978-1-84938-370-7&amp;rft.place=London&amp;rft.pub=Omnibus+Press&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt86" id="mwAqA"><span style="display:none;" id="mwAqE"><span typeof="mw:Entity" id="mwAqI"> </span></span></span></span></li><li about="#cite_note-bbc.co.uk-28" id="cite_note-bbc.co.uk-28"><span rel="mw:referencedBy"><a href="./Douglas_Adams#cite_ref-bbc.co.uk_28-0"><span class="mw-linkback-text">1 </span></a><a href="./Douglas_Adams#cite_ref-bbc.co.uk_28-1"><span class="mw-linkback-text">2 </span></a></span> <span id="mw-reference-text-cite_note-bbc.co.uk-28" class="mw-reference-text">BBC Online (no date) <a rel="mw:ExtLink" href="http://www.bbc.co.uk/cult/hitchhikers/dna/biog.shtml" id="mwAqM">"The Hitchhiker's Guide to the Galaxy: DNA (1952-2001)"</a> Accessed 9 July 2014</span></li><li about="#cite_note-29" id="cite_note-29"><a href="./Douglas_Adams#cite_ref-29" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-29" class="mw-reference-text">Botti, Nicolas (2009). <a rel="mw:ExtLink" href="http://www.douglasadams.eu/en_adams_bio.php" id="mwAqQ">"Life, DNA &amp; h2g2: Douglas Adams's Biography"</a> <a rel="mw:ExtLink" href="https://web.archive.org/web/20140901131941/http://www.douglasadams.eu/en_adams_bio.php" about="#mwt93" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"webarchive","href":"./Template:Webarchive"},"params":{"url":{"wt":"https://web.archive.org/web/20140901131941/http://www.douglasadams.eu/en_adams_bio.php"},"date":{"wt":"1 September 2014"}},"i":0}}]}' id="mwAqU">Archived</a><span about="#mwt93" id="mwAqY"> 1 September 2014 at the </span><a rel="mw:WikiLink" href="./Wayback_Machine" title="Wayback Machine" about="#mwt93" id="mwAqc">Wayback Machine</a><span about="#mwt93" id="mwAqg">.</span><link rel="mw:PageProp/Category" href="./Category:Webarchive_template_wayback_links" about="#mwt93" id="mwAqk"/> Accessed 9 July 2014</span></li><li about="#cite_note-30" id="cite_note-30"><a href="./Douglas_Adams#cite_ref-30" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-30" class="mw-reference-text"><a rel="mw:ExtLink" href="http://www.imdb.com/title/tt0188677/" id="mwAqo">Internet Movie Database's page for <i id="mwAqs">Hyperland</i></a></span></li><li about="#cite_note-31" id="cite_note-31"><a href="./Douglas_Adams#cite_ref-31" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-31" class="mw-reference-text">Adams 1998.</span></li><li about="#cite_note-amath-32" id="cite_note-amath-32"><a href="./Douglas_Adams#cite_ref-amath_32-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-amath-32" class="mw-reference-text"><cite class="citation journal" about="#mwt102" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite journal","href":"./Template:Cite_journal"},"params":{"last":{"wt":"Silverman"},"first":{"wt":"Dave"},"title":{"wt":"Interview: Douglas Adams"},"journal":{"wt":"American Atheist"},"year":{"wt":"1998–1999"},"volume":{"wt":"37"},"issue":{"wt":"1"},"url":{"wt":"http://www.atheists.org/Interview%3A__Douglas_Adams"},"accessdate":{"wt":"16 August 2009"},"archiveurl":{"wt":"http://www.webcitation.org/63mRFcWVO?url=http://www.atheists.org/Interview%3A__Douglas_Adams"},"archivedate":{"wt":"8 December 2011"},"deadurl":{"wt":"yes"},"df":{"wt":"dmy"}},"i":0}}]}' id="mwAqw">Silverman, Dave (1998–1999). <a rel="mw:ExtLink" href="http://www.webcitation.org/63mRFcWVO?url=http://www.atheists.org/Interview%3A__Douglas_Adams" id="mwAq0">"Interview: Douglas Adams"</a>. <i id="mwAq4">American Atheist</i>. <b id="mwAq8">37</b> (1). Archived from <a rel="mw:ExtLink" href="http://www.atheists.org/Interview%3A__Douglas_Adams" id="mwArA">the original</a> on 8 December 2011<span class="reference-accessdate" id="mwArE">. Retrieved <span class="nowrap" id="mwArI">16 August</span> 2009</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Interview%3A+Douglas+Adams&amp;rft.aufirst=Dave&amp;rft.aulast=Silverman&amp;rft.date=1998%2F1999&amp;rft.genre=article&amp;rft.issue=1&amp;rft.jtitle=American+Atheist&amp;rft.volume=37&amp;rft_id=http%3A%2F%2Fwww.atheists.org%2FInterview%253A__Douglas_Adams&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt102" id="mwArM"><span style="display:none;" id="mwArQ"><span typeof="mw:Entity" id="mwArU"> </span></span></span></span></li><li about="#cite_note-TheGuardian-33" id="cite_note-TheGuardian-33"><a href="./Douglas_Adams#cite_ref-TheGuardian_33-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-TheGuardian-33" class="mw-reference-text"><cite class="citation news" about="#mwt108" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite news","href":"./Template:Cite_news"},"params":{"url":{"wt":"http://books.guardian.co.uk/reviews/roundupstory/0,,1939704,00.html"},"title":{"wt":"Observer, &#39;&amp;#39;The God Delusion&#39;&amp;#39;, 5&amp;nbsp;November 2006"},"newspaper":{"wt":"[[The Guardian]]"},"date":{"wt":"5 November 2006"},"accessdate":{"wt":"1 June 2009"},"location":{"wt":"London"},"first":{"wt":"Kim"},"last":{"wt":"Bunce"}},"i":0}}]}' id="mwArY">Bunce, Kim (5 November 2006). <a rel="mw:ExtLink" href="http://books.guardian.co.uk/reviews/roundupstory/0,,1939704,00.html" id="mwArc">"Observer, '<span typeof="mw:Entity" id="mwArg">'</span>The God Delusion'<span typeof="mw:Entity" id="mwArk">'</span>, 5<span typeof="mw:Entity" id="mwAro"> </span>November 2006"</a>. <i id="mwArs"><a rel="mw:WikiLink" href="./The_Guardian" title="The Guardian" id="mwArw">The Guardian</a></i>. London<span class="reference-accessdate" id="mwAr0">. Retrieved <span class="nowrap" id="mwAr4">1 June</span> 2009</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Observer%2C+%27%26%2339%3BThe+God+Delusion%27%26%2339%3B%2C+5+November+2006&amp;rft.aufirst=Kim&amp;rft.aulast=Bunce&amp;rft.date=2006-11-05&amp;rft.genre=article&amp;rft.jtitle=The+Guardian&amp;rft_id=http%3A%2F%2Fbooks.guardian.co.uk%2Freviews%2Froundupstory%2F0%2C%2C1939704%2C00.html&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt108" id="mwAr8"><span style="display:none;" id="mwAsA"><span typeof="mw:Entity" id="mwAsE"> </span></span></span></span></li><li about="#cite_note-Dawkins2001-34" id="cite_note-Dawkins2001-34"><a href="./Douglas_Adams#cite_ref-Dawkins2001_34-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-Dawkins2001-34" class="mw-reference-text"><cite class="citation news" about="#mwt110" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite news","href":"./Template:Cite_news"},"params":{"last":{"wt":"Dawkins"},"first":{"wt":"Richard"},"title":{"wt":"Lament for Douglas Adams"},"url":{"wt":"https://www.theguardian.com/uk/2001/may/14/books.booksnews"},"accessdate":{"wt":"29 December 2012"},"newspaper":{"wt":"The Guardian"},"date":{"wt":"13 May 2001"}},"i":0}}]}' id="mwAsI">Dawkins, Richard (13 May 2001). <a rel="mw:ExtLink" href="https://www.theguardian.com/uk/2001/may/14/books.booksnews" id="mwAsM">"Lament for Douglas Adams"</a>. <i id="mwAsQ">The Guardian</i><span class="reference-accessdate" id="mwAsU">. Retrieved <span class="nowrap" id="mwAsY">29 December</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Lament+for+Douglas+Adams&amp;rft.aufirst=Richard&amp;rft.aulast=Dawkins&amp;rft.date=2001-05-13&amp;rft.genre=article&amp;rft.jtitle=The+Guardian&amp;rft_id=https%3A%2F%2Fwww.theguardian.com%2Fuk%2F2001%2Fmay%2F14%2Fbooks.booksnews&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt110" id="mwAsc"><span style="display:none;" id="mwAsg"><span typeof="mw:Entity" id="mwAsk"> </span></span></span></span></li><li about="#cite_note-35" id="cite_note-35"><a href="./Douglas_Adams#cite_ref-35" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-35" class="mw-reference-text"><cite class="citation book" about="#mwt113" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite book ","href":"./Template:Cite_book"},"params":{"author":{"wt":"[[Paola Cavalieri|Cavalieri, Paola]] and [[Peter Singer]], editors"},"title":{"wt":"The Great Ape Project: Equality Beyond Humanity"},"edition":{"wt":"U.S. Paperback"},"publisher":{"wt":"St. Martin&#39;s Griffin"},"year":{"wt":"1994"},"pages":{"wt":"19–23"},"isbn":{"wt":"0-312-11818-X"}},"i":0}}]}' id="mwAso"><a rel="mw:WikiLink" href="./Paola_Cavalieri" title="Paola Cavalieri" id="mwAss">Cavalieri, Paola</a> and <a rel="mw:WikiLink" href="./Peter_Singer" title="Peter Singer" id="mwAsw">Peter Singer</a>, editors (1994). <i id="mwAs0">The Great Ape Project: Equality Beyond Humanity</i> (U.S. Paperback ed.). St. Martin's Griffin. pp.<span typeof="mw:Entity" id="mwAs4"> </span>19–23. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" id="mwAs8">ISBN</a><span typeof="mw:Entity" id="mwAtA"> </span><a rel="mw:WikiLink" href="./Special:BookSources/0-312-11818-X" title="Special:BookSources/0-312-11818-X" id="mwAtE">0-312-11818-X</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Cavalieri%2C+Paola+and+Peter+Singer%2C+editors&amp;rft.btitle=The+Great+Ape+Project%3A+Equality+Beyond+Humanity&amp;rft.date=1994&amp;rft.edition=U.S.+Paperback&amp;rft.genre=book&amp;rft.isbn=0-312-11818-X&amp;rft.pages=19-23&amp;rft.pub=St.+Martin%27s+Griffin&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt113" id="mwAtI"><span style="display:none;" id="mwAtM"><span typeof="mw:Entity" id="mwAtQ"> </span></span></span><span class="citation-comment" style="display:none; color:#33aa33; margin-left:0.3em" about="#mwt113" id="mwAtU">CS1 maint: Multiple names: authors list (<a rel="mw:WikiLink" href="./Category:CS1_maint:_Multiple_names:_authors_list" title="Category:CS1 maint: Multiple names: authors list" id="mwAtY">link</a>)CS1 maint: Extra text: authors list (<a rel="mw:WikiLink" href="./Category:CS1_maint:_Extra_text:_authors_list" title="Category:CS1 maint: Extra text: authors list" id="mwAtc">link</a>)</span><link rel="mw:PageProp/Category" href="./Category:CS1_maint:_Multiple_names:_authors_list" about="#mwt113" id="mwAtg"/><link rel="mw:PageProp/Category" href="./Category:CS1_maint:_Extra_text:_authors_list" about="#mwt113" id="mwAtk"/></span></li><li about="#cite_note-36" id="cite_note-36"><a href="./Douglas_Adams#cite_ref-36" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-36" class="mw-reference-text"><cite class="citation web" about="#mwt116" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"http://lifednah2g2.blogspot.co.uk/2011/01/ninth-douglas-adams-memorial-lecture.html"},"title":{"wt":"The Ninth Douglas Adams Memorial Lecture"},"publisher":{"wt":"Save the Rhino International"},"accessdate":{"wt":"27 July 2011"}},"i":0}}]}' id="mwAto"><a rel="mw:ExtLink" href="http://lifednah2g2.blogspot.co.uk/2011/01/ninth-douglas-adams-memorial-lecture.html" id="mwAts">"The Ninth Douglas Adams Memorial Lecture"</a>. Save the Rhino International<span class="reference-accessdate" id="mwAtw">. Retrieved <span class="nowrap" id="mwAt0">27 July</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=The+Ninth+Douglas+Adams+Memorial+Lecture&amp;rft.genre=unknown&amp;rft.pub=Save+the+Rhino+International&amp;rft_id=http%3A%2F%2Flifednah2g2.blogspot.co.uk%2F2011%2F01%2Fninth-douglas-adams-memorial-lecture.html&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt116" id="mwAt4"><span style="display:none;" id="mwAt8"><span typeof="mw:Entity" id="mwAuA"> </span></span></span></span></li><li about="#cite_note-Simpson_184-185-37" id="cite_note-Simpson_184-185-37"><span rel="mw:referencedBy"><a href="./Douglas_Adams#cite_ref-Simpson_184-185_37-0"><span class="mw-linkback-text">1 </span></a><a href="./Douglas_Adams#cite_ref-Simpson_184-185_37-1"><span class="mw-linkback-text">2 </span></a></span> <span id="mw-reference-text-cite_note-Simpson_184-185-37" class="mw-reference-text"><a rel="mw:WikiLink" href="./Douglas_Adams#CITEREFSimpson2003" about="#mwt120" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Harvnb","href":"./Template:Harvnb"},"params":{"1":{"wt":"Simpson"},"2":{"wt":"2003"},"pp":{"wt":"184–185"}},"i":0}}]}' id="mwAuE">Simpson 2003</a><span about="#mwt120" id="mwAuI">, pp.</span><span typeof="mw:Entity" about="#mwt120" id="mwAuM"> </span><span about="#mwt120" id="mwAuQ">184–185</span></span></li><li about="#cite_note-38" id="cite_note-38"><a href="./Douglas_Adams#cite_ref-38" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-38" class="mw-reference-text"><cite class="citation book" about="#mwt122" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite book","href":"./Template:Cite_book"},"params":{"author":{"wt":"Adams, Douglas and [[Mark Carwardine]]"},"title":{"wt":"Last Chance to See"},"edition":{"wt":"First U.S. Hardcover"},"publisher":{"wt":"[[Harmony Books]]"},"year":{"wt":"1991"},"page":{"wt":"59"},"isbn":{"wt":"0-517-58215-5"}},"i":0}}]}' id="mwAuU">Adams, Douglas and <a rel="mw:WikiLink" href="./Mark_Carwardine" title="Mark Carwardine" id="mwAuY">Mark Carwardine</a> (1991). <i id="mwAuc">Last Chance to See</i> (First U.S. Hardcover ed.). <a rel="mw:WikiLink" href="./Harmony_Books" title="Harmony Books" id="mwAug">Harmony Books</a>. p.<span typeof="mw:Entity" id="mwAuk"> </span>59. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" id="mwAuo">ISBN</a><span typeof="mw:Entity" id="mwAus"> </span><a rel="mw:WikiLink" href="./Special:BookSources/0-517-58215-5" title="Special:BookSources/0-517-58215-5" id="mwAuw">0-517-58215-5</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Adams%2C+Douglas+and+Mark+Carwardine&amp;rft.btitle=Last+Chance+to+See&amp;rft.date=1991&amp;rft.edition=First+U.S.+Hardcover&amp;rft.genre=book&amp;rft.isbn=0-517-58215-5&amp;rft.pages=59&amp;rft.pub=Harmony+Books&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt122" id="mwAu0"><span style="display:none;" id="mwAu4"><span typeof="mw:Entity" id="mwAu8"> </span></span></span></span></li><li about="#cite_note-39" id="cite_note-39"><a href="./Douglas_Adams#cite_ref-39" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-39" class="mw-reference-text"><cite class="citation book" about="#mwt125" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite book ","href":"./Template:Cite_book"},"params":{"author":{"wt":"Adams, Douglas"},"title":{"wt":"The Salmon of Doubt: Hitchhiking the Galaxy One Last Time"},"edition":{"wt":"First UK hardcover"},"publisher":{"wt":"Macmillan"},"year":{"wt":"2002"},"pages":{"wt":"90–1"},"isbn":{"wt":"0-333-76657-1"}},"i":0}}]}' id="mwAvA">Adams, Douglas (2002). <i id="mwAvE">The Salmon of Doubt: Hitchhiking the Galaxy One Last Time</i> (First UK hardcover ed.). Macmillan. pp.<span typeof="mw:Entity" id="mwAvI"> </span>90–1. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" id="mwAvM">ISBN</a><span typeof="mw:Entity" id="mwAvQ"> </span><a rel="mw:WikiLink" href="./Special:BookSources/0-333-76657-1" title="Special:BookSources/0-333-76657-1" id="mwAvU">0-333-76657-1</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Adams%2C+Douglas&amp;rft.btitle=The+Salmon+of+Doubt%3A+Hitchhiking+the+Galaxy+One+Last+Time&amp;rft.date=2002&amp;rft.edition=First+UK+hardcover&amp;rft.genre=book&amp;rft.isbn=0-333-76657-1&amp;rft.pages=90-1&amp;rft.pub=Macmillan&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt125" id="mwAvY"><span style="display:none;" id="mwAvc"><span typeof="mw:Entity" id="mwAvg"> </span></span></span></span></li><li about="#cite_note-40" id="cite_note-40"><a href="./Douglas_Adams#cite_ref-40" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-40" class="mw-reference-text"><cite class="citation web" about="#mwt129" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"https://www.youtube.com/watch?v=gx6WPQkhUXI"},"title":{"wt":"Craig Ferguson 23 February, 2010B Late Late show Stephen Fry PT2"},"publisher":{"wt":"YouTube"},"date":{"wt":"21 June 2010"},"accessdate":{"wt":"27 July 2011"}},"i":0}}]}' id="mwAvk"><a rel="mw:ExtLink" href="https://www.youtube.com/watch?v=gx6WPQkhUXI" id="mwAvo">"Craig Ferguson 23 February, 2010B Late Late show Stephen Fry PT2"</a>. YouTube. 21 June 2010<span class="reference-accessdate" id="mwAvs">. Retrieved <span class="nowrap" id="mwAvw">27 July</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Craig+Ferguson+23+February%2C+2010B+Late+Late+show+Stephen+Fry+PT2&amp;rft.date=2010-06-21&amp;rft.genre=unknown&amp;rft.pub=YouTube&amp;rft_id=https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3Dgx6WPQkhUXI&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt129" id="mwAv0"><span style="display:none;" id="mwAv4"><span typeof="mw:Entity" id="mwAv8"> </span></span></span></span></li><li about="#cite_note-41" id="cite_note-41"><a href="./Douglas_Adams#cite_ref-41" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-41" class="mw-reference-text"><cite class="citation web" about="#mwt131" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"http://www.douglasadams.com/cgi-bin/mboard/info/dnathread.cgi?2922,1"},"title":{"wt":"Adams&#39;s final post on his forums at"},"publisher":{"wt":"Douglasadams.com"},"accessdate":{"wt":"1 June 2009"}},"i":0}}]}' id="mwAwA"><a rel="mw:ExtLink" href="http://www.douglasadams.com/cgi-bin/mboard/info/dnathread.cgi?2922,1" id="mwAwE">"Adams's final post on his forums at"</a>. Douglasadams.com<span class="reference-accessdate" id="mwAwI">. Retrieved <span class="nowrap" id="mwAwM">1 June</span> 2009</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Adams%27s+final+post+on+his+forums+at&amp;rft.genre=unknown&amp;rft.pub=Douglasadams.com&amp;rft_id=http%3A%2F%2Fwww.douglasadams.com%2Fcgi-bin%2Fmboard%2Finfo%2Fdnathread.cgi%3F2922%2C1&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt131" id="mwAwQ"><span style="display:none;" id="mwAwU"><span typeof="mw:Entity" id="mwAwY"> </span></span></span></span></li><li about="#cite_note-42" id="cite_note-42"><a href="./Douglas_Adams#cite_ref-42" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-42" class="mw-reference-text"><cite class="citation web" about="#mwt137" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"https://groups.google.com/group/alt.fan.douglas-adams"},"title":{"wt":"Discussions – alt.fan.douglas-adams &amp;#124; Google Groups"},"publisher":{"wt":"Google"},"accessdate":{"wt":"11 March 2013"}},"i":0}}]}' id="mwAwc"><a rel="mw:ExtLink" href="https://groups.google.com/group/alt.fan.douglas-adams" id="mwAwg">"Discussions – alt.fan.douglas-adams <span typeof="mw:Entity" id="mwAwk">|</span> Google Groups"</a>. Google<span class="reference-accessdate" id="mwAwo">. Retrieved <span class="nowrap" id="mwAws">11 March</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Discussions+%E2%80%93+alt.fan.douglas-adams+%26%23124%3B+Google+Groups&amp;rft.genre=unknown&amp;rft.pub=Google&amp;rft_id=https%3A%2F%2Fgroups.google.com%2Fgroup%2Falt.fan.douglas-adams&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt137" id="mwAww"><span style="display:none;" id="mwAw0"><span typeof="mw:Entity" id="mwAw4"> </span></span></span></span></li><li about="#cite_note-43" id="cite_note-43"><a href="./Douglas_Adams#cite_ref-43" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-43" class="mw-reference-text"><cite class="citation web" about="#mwt139" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web ","href":"./Template:Cite_web"},"params":{"last":{"wt":"Adams"},"first":{"wt":"Douglas"},"title":{"wt":"PDC 1996 Keynote with Douglas Adams"},"work":{"wt":"[[channel9.msdn.com]]"},"publisher":{"wt":"Channel 9"},"date":{"wt":"15 May 2001"},"url":{"wt":"http://channel9.msdn.com/Events/PDC/PDC-1996/PDC-1996-Keynote-with-Douglas-Adams"},"accessdate":{"wt":"22 March 2013"}},"i":0}}]}' id="mwAw8">Adams, Douglas (15 May 2001). <a rel="mw:ExtLink" href="http://channel9.msdn.com/Events/PDC/PDC-1996/PDC-1996-Keynote-with-Douglas-Adams" id="mwAxA">"PDC 1996 Keynote with Douglas Adams"</a>. <i id="mwAxE"><a rel="mw:WikiLink" href="./Channel9.msdn.com" title="Channel9.msdn.com" id="mwAxI" class="new">channel9.msdn.com</a></i>. Channel 9<span class="reference-accessdate" id="mwAxM">. Retrieved <span class="nowrap" id="mwAxQ">22 March</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=PDC+1996+Keynote+with+Douglas+Adams&amp;rft.aufirst=Douglas&amp;rft.aulast=Adams&amp;rft.date=2001-05-15&amp;rft.genre=unknown&amp;rft.jtitle=channel9.msdn.com&amp;rft_id=http%3A%2F%2Fchannel9.msdn.com%2FEvents%2FPDC%2FPDC-1996%2FPDC-1996-Keynote-with-Douglas-Adams&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt139" id="mwAxU"><span style="display:none;" id="mwAxY"><span typeof="mw:Entity" id="mwAxc"> </span></span></span></span></li><li about="#cite_note-44" id="cite_note-44"><a href="./Douglas_Adams#cite_ref-44" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-44" class="mw-reference-text"><cite class="citation web" about="#mwt142" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"last":{"wt":"Cassel"},"first":{"wt":"David"},"title":{"wt":"So long, Douglas Adams, and thanks for all the fun"},"work":{"wt":"[[Salon (website)|Salon]]"},"publisher":{"wt":"Salon Media Group"},"date":{"wt":"15 May 2001"},"url":{"wt":"http://archive.salon.com/tech/feature/2001/05/15/douglas_adams/index.html"},"accessdate":{"wt":"10 July 2009"},"deadurl":{"wt":"yes"},"archiveurl":{"wt":"https://web.archive.org/web/20080307080733/http://archive.salon.com/tech/feature/2001/05/15/douglas_adams/index.html"},"archivedate":{"wt":"7 March 2008"},"df":{"wt":"dmy"}},"i":0}}]}' id="mwAxg">Cassel, David (15 May 2001). <a rel="mw:ExtLink" href="https://web.archive.org/web/20080307080733/http://archive.salon.com/tech/feature/2001/05/15/douglas_adams/index.html" id="mwAxk">"So long, Douglas Adams, and thanks for all the fun"</a>. <i id="mwAxo"><a rel="mw:WikiLink" href="./Salon_(website)" title="Salon (website)" id="mwAxs">Salon</a></i>. Salon Media Group. Archived from <a rel="mw:ExtLink" href="http://archive.salon.com/tech/feature/2001/05/15/douglas_adams/index.html" id="mwAxw">the original</a> on 7 March 2008<span class="reference-accessdate" id="mwAx0">. Retrieved <span class="nowrap" id="mwAx4">10 July</span> 2009</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=So+long%2C+Douglas+Adams%2C+and+thanks+for+all+the+fun&amp;rft.aufirst=David&amp;rft.aulast=Cassel&amp;rft.date=2001-05-15&amp;rft.genre=unknown&amp;rft.jtitle=Salon&amp;rft_id=http%3A%2F%2Farchive.salon.com%2Ftech%2Ffeature%2F2001%2F05%2F15%2Fdouglas_adams%2Findex.html&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt142" id="mwAx8"><span style="display:none;" id="mwAyA"><span typeof="mw:Entity" id="mwAyE"> </span></span></span></span></li><li about="#cite_note-IPP-45" id="cite_note-IPP-45"><span rel="mw:referencedBy"><a href="./Douglas_Adams#cite_ref-IPP_45-0"><span class="mw-linkback-text">1 </span></a><a href="./Douglas_Adams#cite_ref-IPP_45-1"><span class="mw-linkback-text">2 </span></a><a href="./Douglas_Adams#cite_ref-IPP_45-2"><span class="mw-linkback-text">3 </span></a></span> <span id="mw-reference-text-cite_note-IPP-45" class="mw-reference-text"><cite class="citation web" about="#mwt202" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"http://www.islington.gov.uk/Leisure/heritage/heritage_borough/bor_plaques/peoplesplaques.asp"},"title":{"wt":"Islington People&#39;s Plaques"},"date":{"wt":"25 July 2011"},"accessdate":{"wt":"13 August 2011"},"deadurl":{"wt":"yes"},"archiveurl":{"wt":"https://web.archive.org/web/20120318001614/http://www.islington.gov.uk/Leisure/heritage/heritage_borough/bor_plaques/peoplesplaques.asp"},"archivedate":{"wt":"18 March 2012"}},"i":0}}]}' id="mwAyI"><a rel="mw:ExtLink" href="https://web.archive.org/web/20120318001614/http://www.islington.gov.uk/Leisure/heritage/heritage_borough/bor_plaques/peoplesplaques.asp" id="mwAyM">"Islington People's Plaques"</a>. 25 July 2011. Archived from <a rel="mw:ExtLink" href="http://www.islington.gov.uk/Leisure/heritage/heritage_borough/bor_plaques/peoplesplaques.asp" id="mwAyQ">the original</a> on 18 March 2012<span class="reference-accessdate" id="mwAyU">. Retrieved <span class="nowrap" id="mwAyY">13 August</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Islington+People%27s+Plaques&amp;rft.date=2011-07-25&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.islington.gov.uk%2FLeisure%2Fheritage%2Fheritage_borough%2Fbor_plaques%2Fpeoplesplaques.asp&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt202" id="mwAyc"><span style="display:none;" id="mwAyg"><span typeof="mw:Entity" id="mwAyk"> </span></span></span></span></li><li about="#cite_note-sfweekly-46" id="cite_note-sfweekly-46"><a href="./Douglas_Adams#cite_ref-sfweekly_46-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-sfweekly-46" class="mw-reference-text"><cite class="citation web" about="#mwt152" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"last":{"wt":"Bowers"},"first":{"wt":"Keith"},"title":{"wt":"Big Three"},"url":{"wt":"http://www.sfweekly.com/2011-07-06/calendar/big-three/"},"work":{"wt":"SF Weekly"},"accessdate":{"wt":"8 December 2011"},"archiveurl":{"wt":"http://www.webcitation.org/63mSWp8yr?url=http://www.sfweekly.com/2011-07-06/calendar/big-three/"},"archivedate":{"wt":"8 December 2011"},"deadurl":{"wt":"no"},"date":{"wt":"6 July 2011"},"df":{"wt":"dmy"}},"i":0}}]}' id="mwAyo">Bowers, Keith (6 July 2011). <a rel="mw:ExtLink" href="http://www.sfweekly.com/2011-07-06/calendar/big-three/" id="mwAys">"Big Three"</a>. <i id="mwAyw">SF Weekly</i>. <a rel="mw:ExtLink" href="http://www.webcitation.org/63mSWp8yr?url=http://www.sfweekly.com/2011-07-06/calendar/big-three/" id="mwAy0">Archived</a> from the original on 8 December 2011<span class="reference-accessdate" id="mwAy4">. Retrieved <span class="nowrap" id="mwAy8">8 December</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Big+Three&amp;rft.aufirst=Keith&amp;rft.aulast=Bowers&amp;rft.date=2011-07-06&amp;rft.genre=unknown&amp;rft.jtitle=SF+Weekly&amp;rft_id=http%3A%2F%2Fwww.sfweekly.com%2F2011-07-06%2Fcalendar%2Fbig-three%2F&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt152" id="mwAzA"><span style="display:none;" id="mwAzE"><span typeof="mw:Entity" id="mwAzI"> </span></span></span></span></li><li about="#cite_note-47" id="cite_note-47"><a href="./Douglas_Adams#cite_ref-47" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-47" class="mw-reference-text">Webb, Chapter 10.</span></li><li about="#cite_note-timesobit-48" id="cite_note-timesobit-48"><a href="./Douglas_Adams#cite_ref-timesobit_48-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-timesobit-48" class="mw-reference-text"><cite class="citation web" about="#mwt155" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"title":{"wt":"Obituary &amp; Guest Book Preview for Jane Elizabeth BELSON"},"url":{"wt":"http://announcements.thetimes.co.uk/obituaries/timesonline-uk/obituary.aspx?page=lifestory&amp;pid=153521790"},"work":{"wt":"The Times"},"accessdate":{"wt":"8 December 2011"},"archiveurl":{"wt":"http://www.webcitation.org/63mSoMnJe?url=http://announcements.thetimes.co.uk/obituaries/timesonline-uk/obituary-preview.aspx?n%3Djane-elizabeth-belson%26pid%3D153521790%26referrer%3D2282"},"archivedate":{"wt":"8 December 2011"},"deadurl":{"wt":"no"},"date":{"wt":"9 September 2011"},"df":{"wt":""}},"i":0}}]}' id="mwAzM"><a rel="mw:ExtLink" href="http://announcements.thetimes.co.uk/obituaries/timesonline-uk/obituary.aspx?page=lifestory&amp;pid=153521790" id="mwAzQ">"Obituary &amp; Guest Book Preview for Jane Elizabeth BELSON"</a>. <i id="mwAzU">The Times</i>. 9 September 2011. <a rel="mw:ExtLink" href="http://www.webcitation.org/63mSoMnJe?url=http://announcements.thetimes.co.uk/obituaries/timesonline-uk/obituary-preview.aspx?n%3Djane-elizabeth-belson%26pid%3D153521790%26referrer%3D2282" id="mwAzY">Archived</a> from the original on 8 December 2011<span class="reference-accessdate" id="mwAzc">. Retrieved <span class="nowrap" id="mwAzg">8 December</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Obituary+%26+Guest+Book+Preview+for+Jane+Elizabeth+BELSON&amp;rft.date=2011-09-09&amp;rft.genre=unknown&amp;rft.jtitle=The+Times&amp;rft_id=http%3A%2F%2Fannouncements.thetimes.co.uk%2Fobituaries%2Ftimesonline-uk%2Fobituary.aspx%3Fpage%3Dlifestory%26pid%3D153521790&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt155" id="mwAzk"><span style="display:none;" id="mwAzo"><span typeof="mw:Entity" id="mwAzs"> </span></span></span></span></li><li about="#cite_note-h2g2obit-49" id="cite_note-h2g2obit-49"><a href="./Douglas_Adams#cite_ref-h2g2obit_49-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-h2g2obit-49" class="mw-reference-text"><cite class="citation web" about="#mwt157" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"title":{"wt":"Jane Belson, Douglas Adams&#39;s widow, passed away"},"url":{"wt":"http://lifednah2g2.blogspot.com/2011/09/jane-belson-douglas-adams-widow-passed.html"},"work":{"wt":"h2g2"},"accessdate":{"wt":"9 July 2013"}},"i":0}}]}' id="mwAzw"><a rel="mw:ExtLink" href="http://lifednah2g2.blogspot.com/2011/09/jane-belson-douglas-adams-widow-passed.html" id="mwAz0">"Jane Belson, Douglas Adams's widow, passed away"</a>. <i id="mwAz4">h2g2</i><span class="reference-accessdate" id="mwAz8">. Retrieved <span class="nowrap" id="mwA0A">9 July</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Jane+Belson%2C+Douglas+Adams%27s+widow%2C+passed+away&amp;rft.genre=unknown&amp;rft.jtitle=h2g2&amp;rft_id=http%3A%2F%2Flifednah2g2.blogspot.com%2F2011%2F09%2Fjane-belson-douglas-adams-widow-passed.html&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt157" id="mwA0E"><span style="display:none;" id="mwA0I"><span typeof="mw:Entity" id="mwA0M"> </span></span></span></span></li><li about="#cite_note-50" id="cite_note-50"><a href="./Douglas_Adams#cite_ref-50" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-50" class="mw-reference-text"><a rel="mw:ExtLink" href="https://h2g2.com/edited_entry/A3790659" id="mwA0Q">https://h2g2.com/edited_entry/A3790659</a></span></li><li about="#cite_note-51" id="cite_note-51"><a href="./Douglas_Adams#cite_ref-51" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-51" class="mw-reference-text"><cite class="citation web" about="#mwt163" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"http://www.laweekly.com/2001-05-24/news/lots-of-screamingly-funny-sentences-no-fish/"},"title":{"wt":"Lots of Screamingly Funny Sentences. No Fish. – page 1"},"last1":{"wt":"Lewis"},"first1":{"wt":"Judith"},"last2":{"wt":"Shulman"},"first2":{"wt":"Dave"},"publisher":{"wt":"LA Weekly"},"date":{"wt":"24 May 2001"},"accessdate":{"wt":"20 August 2009"},"archiveurl":{"wt":"http://www.webcitation.org/63mQ1aCJQ?url=http://www.laweekly.com/2001-05-24/news/lots-of-screamingly-funny-sentences-no-fish/"},"archivedate":{"wt":"8 December 2011"},"deadurl":{"wt":"no"},"df":{"wt":"dmy"}},"i":0}}]}' id="mwA0U">Lewis, Judith; Shulman, Dave (24 May 2001). <a rel="mw:ExtLink" href="http://www.laweekly.com/2001-05-24/news/lots-of-screamingly-funny-sentences-no-fish/" id="mwA0Y">"Lots of Screamingly Funny Sentences. No Fish. – page 1"</a>. LA Weekly. <a rel="mw:ExtLink" href="http://www.webcitation.org/63mQ1aCJQ?url=http://www.laweekly.com/2001-05-24/news/lots-of-screamingly-funny-sentences-no-fish/" id="mwA0c">Archived</a> from the original on 8 December 2011<span class="reference-accessdate" id="mwA0g">. Retrieved <span class="nowrap" id="mwA0k">20 August</span> 2009</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Shulman%2C+Dave&amp;rft.aufirst=Judith&amp;rft.aulast=Lewis&amp;rft.btitle=Lots+of+Screamingly+Funny+Sentences.+No+Fish.+%E2%80%93+page+1&amp;rft.date=2001-05-24&amp;rft.genre=unknown&amp;rft.pub=LA+Weekly&amp;rft_id=http%3A%2F%2Fwww.laweekly.com%2F2001-05-24%2Fnews%2Flots-of-screamingly-funny-sentences-no-fish%2F&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt163" id="mwA0o"><span style="display:none;" id="mwA0s"><span typeof="mw:Entity" id="mwA0w"> </span></span></span></span></li><li about="#cite_note-Simpson_337-338-52" id="cite_note-Simpson_337-338-52"><a href="./Douglas_Adams#cite_ref-Simpson_337-338_52-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-Simpson_337-338-52" class="mw-reference-text"><a rel="mw:WikiLink" href="./Douglas_Adams#CITEREFSimpson2003" about="#mwt165" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Harvnb","href":"./Template:Harvnb"},"params":{"1":{"wt":"Simpson"},"2":{"wt":"2003"},"pp":{"wt":"337–338"}},"i":0}}]}' id="mwA00">Simpson 2003</a><span about="#mwt165" id="mwA04">, pp.</span><span typeof="mw:Entity" about="#mwt165" id="mwA08"> </span><span about="#mwt165" id="mwA1A">337–338</span></span></li><li about="#cite_note-53" id="cite_note-53"><a href="./Douglas_Adams#cite_ref-53" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-53" class="mw-reference-text">Gaiman, 204.</span></li><li about="#cite_note-54" id="cite_note-54"><a href="./Douglas_Adams#cite_ref-54" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-54" class="mw-reference-text"><cite class="citation web" about="#mwt170" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"http://www.bbc.co.uk/cult/hitchhikers/celebration/"},"title":{"wt":"BBC Online – Cult – Hitchhiker&#39;s – Douglas Adams – Service of Celebration"},"publisher":{"wt":"BBC"},"date":{"wt":"17 September 2001"},"accessdate":{"wt":"11 March 2013"}},"i":0}}]}' id="mwA1E"><a rel="mw:ExtLink" href="http://www.bbc.co.uk/cult/hitchhikers/celebration/" id="mwA1I">"BBC Online – Cult – Hitchhiker's – Douglas Adams – Service of Celebration"</a>. BBC. 17 September 2001<span class="reference-accessdate" id="mwA1M">. Retrieved <span class="nowrap" id="mwA1Q">11 March</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=BBC+Online+%E2%80%93+Cult+%E2%80%93+Hitchhiker%27s+%E2%80%93+Douglas+Adams+%E2%80%93+Service+of+Celebration&amp;rft.date=2001-09-17&amp;rft.genre=unknown&amp;rft.pub=BBC&amp;rft_id=http%3A%2F%2Fwww.bbc.co.uk%2Fcult%2Fhitchhikers%2Fcelebration%2F&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt170" id="mwA1U"><span style="display:none;" id="mwA1Y"><span typeof="mw:Entity" id="mwA1c"> </span></span></span></span></li><li about="#cite_note-55" id="cite_note-55"><a href="./Douglas_Adams#cite_ref-55" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-55" class="mw-reference-text"><cite class="citation web" about="#mwt174" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"https://www.youtube.com/watch?v=_ZG8HBuDjgc"},"title":{"wt":"Parrots, the universe and everything, recorded May 2001"},"publisher":{"wt":"YouTube"},"accessdate":{"wt":"11 March 2013"}},"i":0}}]}' id="mwA1g"><a rel="mw:ExtLink" href="https://www.youtube.com/watch?v=_ZG8HBuDjgc" id="mwA1k">"Parrots, the universe and everything, recorded May 2001"</a>. YouTube<span class="reference-accessdate" id="mwA1o">. Retrieved <span class="nowrap" id="mwA1s">11 March</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Parrots%2C+the+universe+and+everything%2C+recorded+May+2001&amp;rft.genre=unknown&amp;rft.pub=YouTube&amp;rft_id=https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D_ZG8HBuDjgc&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt174" id="mwA1w"><span style="display:none;" id="mwA10"><span typeof="mw:Entity" id="mwA14"> </span></span></span></span></li><li about="#cite_note-56" id="cite_note-56"><a href="./Douglas_Adams#cite_ref-56" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-56" class="mw-reference-text"><cite class="citation web" about="#mwt176" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"http://navarroj.com/parrots"},"title":{"wt":"Transcript of \"Parrots, the Universe and Everything\""},"publisher":{"wt":"Navarroj.com"},"accessdate":{"wt":"27 July 2011"}},"i":0}}]}' id="mwA18"><a rel="mw:ExtLink" href="http://navarroj.com/parrots" id="mwA2A">"Transcript of "Parrots, the Universe and Everything<span style="padding-right:0.2em;" id="mwA2E">"</span>"</a>. Navarroj.com<span class="reference-accessdate" id="mwA2I">. Retrieved <span class="nowrap" id="mwA2M">27 July</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Transcript+of+%22Parrots%2C+the+Universe+and+Everything%22&amp;rft.genre=unknown&amp;rft.pub=Navarroj.com&amp;rft_id=http%3A%2F%2Fnavarroj.com%2Fparrots&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt176" id="mwA2Q"><span style="display:none;" id="mwA2U"><span typeof="mw:Entity" id="mwA2Y"> </span></span></span></span></li><li about="#cite_note-MPC42677-57" id="cite_note-MPC42677-57"><a href="./Douglas_Adams#cite_ref-MPC42677_57-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-MPC42677-57" class="mw-reference-text"><cite class="citation" about="#mwt180" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Citation ","href":"./Template:Citation"},"params":{"publication-date":{"wt":"9 May 2001"},"title":{"wt":"New Names of Minor Planets"},"periodical":{"wt":"[[Minor Planet Circular]]"},"publication-place":{"wt":"Cambridge, Mass"},"publisher":{"wt":"[[Minor Planet Center]]"},"issue":{"wt":"MPC 42677"},"url":{"wt":"http://www.minorplanetcenter.net/iau/ECS/MPCArchive/2001/MPC_20010509.pdf"},"issn":{"wt":"0736-6884"}},"i":0}}]}' id="mwA2c"><a rel="mw:ExtLink" href="http://www.minorplanetcenter.net/iau/ECS/MPCArchive/2001/MPC_20010509.pdf" id="mwA2g">"New Names of Minor Planets"</a> <span style="font-size:85%;" id="mwA2k">(PDF)</span>, <i id="mwA2o"><a rel="mw:WikiLink" href="./Minor_Planet_Circular" title="Minor Planet Circular" id="mwA2s" class="mw-redirect">Minor Planet Circular</a></i>, Cambridge, Mass: <a rel="mw:WikiLink" href="./Minor_Planet_Center" title="Minor Planet Center" id="mwA2w">Minor Planet Center</a> (MPC 42677), 9 May 2001, <a rel="mw:WikiLink" href="./International_Standard_Serial_Number" title="International Standard Serial Number" id="mwA20">ISSN</a><span typeof="mw:Entity" id="mwA24"> </span><a rel="mw:ExtLink" href="//www.worldcat.org/issn/0736-6884" id="mwA28">0736-6884</a></cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=New+Names+of+Minor+Planets&amp;rft.date=2001-05-09&amp;rft.genre=article&amp;rft.issn=0736-6884&amp;rft.issue=MPC+42677&amp;rft.jtitle=Minor+Planet+Circular&amp;rft_id=http%3A%2F%2Fwww.minorplanetcenter.net%2Fiau%2FECS%2FMPCArchive%2F2001%2FMPC_20010509.pdf&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt180" id="mwA3A"><span style="display:none;" id="mwA3E"><span typeof="mw:Entity" id="mwA3I"> </span></span></span></span></li><li about="#cite_note-58" id="cite_note-58"><a href="./Douglas_Adams#cite_ref-58" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-58" class="mw-reference-text"><a rel="mw:ExtLink" href="http://www.msnbc.msn.com/id/6867061/" id="mwA3M">Asteroid named after 'Hitchhiker' humorist: Late British sci-fi author honored after cosmic campaign</a> by Alan Boyle, MSNBC, 25 January 2005</span></li><li about="#cite_note-59" id="cite_note-59"><a href="./Douglas_Adams#cite_ref-59" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-59" class="mw-reference-text"><cite class="citation news" about="#mwt185" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite news\n","href":"./Template:Cite_news"},"params":{"url":{"wt":"http://www.independent.co.uk/arts-entertainment/books/reviews/the-salmon-of-doubt-by-douglas-adams-650803.html"},"title":{"wt":"The Salmon of Doubt by Douglas Adams"},"work":{"wt":"The Independent"},"location":{"wt":"London"},"accessdate":{"wt":"2 August 2009"},"last":{"wt":"Murray"},"first":{"wt":"Charles Shaar"},"date":{"wt":"10 May 2002"}},"i":0}}]}' id="mwA3Q">Murray, Charles Shaar (10 May 2002). <a rel="mw:ExtLink" href="http://www.independent.co.uk/arts-entertainment/books/reviews/the-salmon-of-doubt-by-douglas-adams-650803.html" id="mwA3U">"The Salmon of Doubt by Douglas Adams"</a>. <i id="mwA3Y">The Independent</i>. London<span class="reference-accessdate" id="mwA3c">. Retrieved <span class="nowrap" id="mwA3g">2 August</span> 2009</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=The+Salmon+of+Doubt+by+Douglas+Adams&amp;rft.aufirst=Charles+Shaar&amp;rft.aulast=Murray&amp;rft.date=2002-05-10&amp;rft.genre=article&amp;rft.jtitle=The+Independent&amp;rft_id=http%3A%2F%2Fwww.independent.co.uk%2Farts-entertainment%2Fbooks%2Freviews%2Fthe-salmon-of-doubt-by-douglas-adams-650803.html&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt185" id="mwA3k"><span style="display:none;" id="mwA3o"><span typeof="mw:Entity" id="mwA3s"> </span></span></span>
</span></li><li about="#cite_note-60" id="cite_note-60"><a href="./Douglas_Adams#cite_ref-60" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-60" class="mw-reference-text"><cite class="citation news" about="#mwt187" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite news\n","href":"./Template:Cite_news"},"params":{"url":{"wt":"http://www.independent.co.uk/arts-entertainment/books/features/cover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html"},"title":{"wt":"Cover Stories: Douglas Adams, Narnia Chronicles, Something like a House"},"work":{"wt":"The Independent"},"location":{"wt":"London"},"accessdate":{"wt":"2 August 2009"},"author":{"wt":"The Literator"},"date":{"wt":"5 January 2002"},"archiveurl":{"wt":"https://web.archive.org/web/20090801062359/http://www.independent.co.uk/arts-entertainment/books/features/cover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html"},"archivedate":{"wt":"1 August 2009"}},"i":0}}]}' id="mwA3w">The Literator (5 January 2002). <a rel="mw:ExtLink" href="https://web.archive.org/web/20090801062359/http://www.independent.co.uk/arts-entertainment/books/features/cover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html" id="mwA30">"Cover Stories: Douglas Adams, Narnia Chronicles, Something like a House"</a>. <i id="mwA34">The Independent</i>. London. Archived from <a rel="mw:ExtLink" href="http://www.independent.co.uk/arts-entertainment/books/features/cover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html" id="mwA38">the original</a> on 1 August 2009<span class="reference-accessdate" id="mwA4A">. Retrieved <span class="nowrap" id="mwA4E">2 August</span> 2009</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Cover+Stories%3A+Douglas+Adams%2C+Narnia+Chronicles%2C+Something+like+a+House&amp;rft.au=The+Literator&amp;rft.date=2002-01-05&amp;rft.genre=article&amp;rft.jtitle=The+Independent&amp;rft_id=http%3A%2F%2Fwww.independent.co.uk%2Farts-entertainment%2Fbooks%2Ffeatures%2Fcover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt187" id="mwA4I"><span style="display:none;" id="mwA4M"><span typeof="mw:Entity" id="mwA4Q"> </span></span></span>
</span></li><li about="#cite_note-61" id="cite_note-61"><a href="./Douglas_Adams#cite_ref-61" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-61" class="mw-reference-text"><cite class="citation web" about="#mwt190" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"http://www.dirkmaggs.dswilliams.co.uk/Dirk%20Maggs%20News%20%20new%20projects.htm"},"archive-url":{"wt":"https://web.archive.org/web/20021209193312/http://www.dirkmaggs.dswilliams.co.uk/dirk%20maggs%20news%20%20new%20projects.htm"},"dead-url":{"wt":"yes"},"archive-date":{"wt":"9 December 2002"},"title":{"wt":"Dirk Maggs News and New Projects page"},"df":{"wt":""}},"i":0}}]}' id="mwA4U"><a rel="mw:ExtLink" href="https://web.archive.org/web/20021209193312/http://www.dirkmaggs.dswilliams.co.uk/dirk%20maggs%20news%20%20new%20projects.htm" id="mwA4Y">"Dirk Maggs News and New Projects page"</a>. Archived from <a rel="mw:ExtLink" href="http://www.dirkmaggs.dswilliams.co.uk/Dirk%20Maggs%20News%20%20new%20projects.htm" id="mwA4c">the original</a> on 9 December 2002.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Dirk+Maggs+News+and+New+Projects+page&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.dirkmaggs.dswilliams.co.uk%2FDirk%2520Maggs%2520News%2520%2520new%2520projects.htm&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt190" id="mwA4g"><span style="display:none;" id="mwA4k"><span typeof="mw:Entity" id="mwA4o"> </span></span></span></span></li><li about="#cite_note-62" id="cite_note-62"><a href="./Douglas_Adams#cite_ref-62" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-62" class="mw-reference-text"><cite class="citation web" about="#mwt194" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"author":{"wt":"Matthew Hemley"},"url":{"wt":"http://www.thestage.co.uk/news/newsstory.php/24312/douglas-adams-final-dirk-gently-novel-to-be"},"title":{"wt":"The Stage / News / Douglas Adams&#39;s final Dirk Gently novel to be adapted for Radio 4"},"work":{"wt":"The Stage"},"date":{"wt":"5 May 2009"},"accessdate":{"wt":"20 August 2009"}},"i":0}}]}' id="mwA4s">Matthew Hemley (5 May 2009). <a rel="mw:ExtLink" href="http://www.thestage.co.uk/news/newsstory.php/24312/douglas-adams-final-dirk-gently-novel-to-be" id="mwA4w">"The Stage / News / Douglas Adams's final Dirk Gently novel to be adapted for Radio 4"</a>. <i id="mwA40">The Stage</i><span class="reference-accessdate" id="mwA44">. Retrieved <span class="nowrap" id="mwA48">20 August</span> 2009</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=The+Stage+%2F+News+%2F+Douglas+Adams%27s+final+Dirk+Gently+novel+to+be+adapted+for+Radio+4&amp;rft.au=Matthew+Hemley&amp;rft.date=2009-05-05&amp;rft.genre=unknown&amp;rft.jtitle=The+Stage&amp;rft_id=http%3A%2F%2Fwww.thestage.co.uk%2Fnews%2Fnewsstory.php%2F24312%2Fdouglas-adams-final-dirk-gently-novel-to-be&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt194" id="mwA5A"><span style="display:none;" id="mwA5E"><span typeof="mw:Entity" id="mwA5I"> </span></span></span></span></li><li about="#cite_note-63" id="cite_note-63"><a href="./Douglas_Adams#cite_ref-63" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-63" class="mw-reference-text"><cite class="citation web" about="#mwt196" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"url":{"wt":"http://www.chortle.co.uk/news/2009/10/11/9767/bbc_plans_dirk_gently_tv_series"},"title":{"wt":"BBC plans Dirk Gently TV series"},"publisher":{"wt":"Chortle.co.uk"},"date":{"wt":"11 October 2009"},"accessdate":{"wt":"11 October 2009"}},"i":0}}]}' id="mwA5M"><a rel="mw:ExtLink" href="http://www.chortle.co.uk/news/2009/10/11/9767/bbc_plans_dirk_gently_tv_series" id="mwA5Q">"BBC plans Dirk Gently TV series"</a>. Chortle.co.uk. 11 October 2009<span class="reference-accessdate" id="mwA5U">. Retrieved <span class="nowrap" id="mwA5Y">11 October</span> 2009</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=BBC+plans+Dirk+Gently+TV+series&amp;rft.date=2009-10-11&amp;rft.genre=unknown&amp;rft.pub=Chortle.co.uk&amp;rft_id=http%3A%2F%2Fwww.chortle.co.uk%2Fnews%2F2009%2F10%2F11%2F9767%2Fbbc_plans_dirk_gently_tv_series&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt196" id="mwA5c"><span style="display:none;" id="mwA5g"><span typeof="mw:Entity" id="mwA5k"> </span></span></span></span></li><li about="#cite_note-64" id="cite_note-64"><a href="./Douglas_Adams#cite_ref-64" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-64" class="mw-reference-text"><cite class="citation news" about="#mwt199" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite news ","href":"./Template:Cite_news"},"params":{"last":{"wt":"Molloy"},"first":{"wt":"Mark"},"date":{"wt":"May 25, 2016"},"title":{"wt":"What is Towel Day? The Hitchhiker&#39;s Guide to the Galaxy creator Douglas Adams celebrated"},"work":{"wt":"[[The Daily Telegraph|The Telegraph]]"},"url":{"wt":"http://www.telegraph.co.uk/books/authors/what-is-towel-day-the-hitchhikers-guide-to-the-galaxy-creator-do/"},"access-date":{"wt":"July 27, 2017"}},"i":0}}]}' id="mwA5o">Molloy, Mark (May 25, 2016). <a rel="mw:ExtLink" href="http://www.telegraph.co.uk/books/authors/what-is-towel-day-the-hitchhikers-guide-to-the-galaxy-creator-do/" id="mwA5s">"What is Towel Day? The Hitchhiker's Guide to the Galaxy creator Douglas Adams celebrated"</a>. <i id="mwA5w"><a rel="mw:WikiLink" href="./The_Daily_Telegraph" title="The Daily Telegraph" id="mwA50">The Telegraph</a></i><span class="reference-accessdate" id="mwA54">. Retrieved <span class="nowrap" id="mwA58">July 27,</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=What+is+Towel+Day%3F+The+Hitchhiker%27s+Guide+to+the+Galaxy+creator+Douglas+Adams+celebrated&amp;rft.aufirst=Mark&amp;rft.aulast=Molloy&amp;rft.date=2016-05-25&amp;rft.genre=article&amp;rft.jtitle=The+Telegraph&amp;rft_id=http%3A%2F%2Fwww.telegraph.co.uk%2Fbooks%2Fauthors%2Fwhat-is-towel-day-the-hitchhikers-guide-to-the-galaxy-creator-do%2F&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt199" id="mwA6A"><span style="display:none;" id="mwA6E"><span typeof="mw:Entity" id="mwA6I"> </span></span></span></span></li><li about="#cite_note-GoogleDoodle2013a-65" id="cite_note-GoogleDoodle2013a-65"><a href="./Douglas_Adams#cite_ref-GoogleDoodle2013a_65-0" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-GoogleDoodle2013a-65" class="mw-reference-text"><cite class="citation news" about="#mwt206" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite news","href":"./Template:Cite_news"},"params":{"title":{"wt":"Don&#39;t Panic! Google Doodle Honors Author Douglas Adams"},"url":{"wt":"http://abcnews.go.com/blogs/technology/2013/03/dont-panic-google-doodle-honors-author-douglas-adams/"},"accessdate":{"wt":"11 March 2013"},"newspaper":{"wt":"abc News"},"date":{"wt":"11 March 2013"}},"i":0}}]}' id="mwA6M"><a rel="mw:ExtLink" href="http://abcnews.go.com/blogs/technology/2013/03/dont-panic-google-doodle-honors-author-douglas-adams/" id="mwA6Q">"Don't Panic! Google Doodle Honors Author Douglas Adams"</a>. <i id="mwA6U">abc News</i>. 11 March 2013<span class="reference-accessdate" id="mwA6Y">. Retrieved <span class="nowrap" id="mwA6c">11 March</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Don%27t+Panic%21+Google+Doodle+Honors+Author+Douglas+Adams&amp;rft.date=2013-03-11&amp;rft.genre=article&amp;rft.jtitle=abc+News&amp;rft_id=http%3A%2F%2Fabcnews.go.com%2Fblogs%2Ftechnology%2F2013%2F03%2Fdont-panic-google-doodle-honors-author-douglas-adams%2F&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal" class="Z3988" about="#mwt206" id="mwA6g"><span style="display:none;" id="mwA6k"><span typeof="mw:Entity" id="mwA6o"> </span></span></span></span></li><li about="#cite_note-66" id="cite_note-66"><a href="./Douglas_Adams#cite_ref-66" rel="mw:referencedBy"><span class="mw-linkback-text">↑ </span></a> <span id="mw-reference-text-cite_note-66" class="mw-reference-text"><cite class="citation web" about="#mwt208" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite web","href":"./Template:Cite_web"},"params":{"title":{"wt":"Douglas Adams&#39; 61st Birthday"},"url":{"wt":"https://www.google.com/doodles/douglas-adams-61st-birthday"},"accessdate":{"wt":"11 March 2013"}},"i":0}}]}' id="mwA6s"><a rel="mw:ExtLink" href="https://www.google.com/doodles/douglas-adams-61st-birthday" id="mwA6w">"Douglas Adams' 61st Birthday"</a><span class="reference-accessdate" id="mwA60">. Retrieved <span class="nowrap" id="mwA64">11 March</span> 2013</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Douglas+Adams%27+61st+Birthday&amp;rft.genre=unknown&amp;rft_id=https%3A%2F%2Fwww.google.com%2Fdoodles%2Fdouglas-adams-61st-birthday&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt208" id="mwA68"><span style="display:none;" id="mwA7A"><span typeof="mw:Entity" id="mwA7E"> </span></span></span></span></li></ol></div>

<h2 id="References">References</h2>
<ul id="mwA7I"><li id="mwA7M"> Adams, Douglas (1998). <a rel="mw:ExtLink" href="http://www.biota.org/people/douglasadams/" id="mwA7Q">Is there an Artificial God?</a>, speech at <i id="mwA7U">Digital Biota 2</i>, Cambridge, England, September 1998.</li>
<li id="mwA7Y"> <cite id="CITEREFAdams2002" class="citation book" about="#mwt215" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite book","href":"./Template:Cite_book"},"params":{"last":{"wt":"Adams"},"first":{"wt":"Douglas"},"title":{"wt":"The Salmon of Doubt: Hitchhiking the Galaxy One Last Time"},"year":{"wt":"2002"},"publisher":{"wt":"Macmillan"},"location":{"wt":"London"},"isbn":{"wt":"0-333-76657-1"},"ref":{"wt":"harv"}},"i":0}}]}'>Adams, Douglas (2002). <i>The Salmon of Doubt: Hitchhiking the Galaxy One Last Time</i>. London: Macmillan. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number">ISBN</a><span typeof="mw:Entity"> </span><a rel="mw:WikiLink" href="./Special:BookSources/0-333-76657-1" title="Special:BookSources/0-333-76657-1">0-333-76657-1</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.aufirst=Douglas&amp;rft.aulast=Adams&amp;rft.btitle=The+Salmon+of+Doubt%3A+Hitchhiking+the+Galaxy+One+Last+Time&amp;rft.date=2002&amp;rft.genre=book&amp;rft.isbn=0-333-76657-1&amp;rft.place=London&amp;rft.pub=Macmillan&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt215" id="mwA7c"><span style="display:none;"><span typeof="mw:Entity"> </span></span></span></li>
<li id="mwA7g"> Dawkins, Richard (2003). "Eulogy for Douglas Adams," in <i id="mwA7k">A devil's chaplain: reflections on hope, lies, science, and love</i>. Houghton Mifflin Harcourt.</li>
<li id="mwA7o"> Felch, Laura (2004). <a rel="mw:ExtLink" href="http://www.bookslut.com/nonfiction/2004_05_002057.php" id="mwA7s">Don't Panic: Douglas Adams and the Hitchhiker's Guide to the Galaxy by Neil Gaiman</a>, May 2004</li>
<li id="mwA7w"> Ray, Mohit K (2007). <i id="mwA70">Atlantic Companion to Literature in English</i>, Atlantic Publishers and Distributors. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" about="#mwt216" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"ISBN","href":"./Template:ISBN"},"params":{"1":{"wt":"81-269-0832-7"}},"i":0}}]}' id="mwA74">ISBN</a><span about="#mwt216"> </span><a rel="mw:WikiLink" href="./Special:BookSources/81-269-0832-7" title="Special:BookSources/81-269-0832-7" about="#mwt216" id="mwA78">81-269-0832-7</a></li>
<li id="mwA8A"> <cite id="CITEREFSimpson2003" class="citation book" about="#mwt217" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"cite book","href":"./Template:Cite_book"},"params":{"last":{"wt":"Simpson"},"first":{"wt":"M. J."},"title":{"wt":"[[Hitchhiker: A Biography of Douglas Adams]]"},"year":{"wt":"2003"},"publisher":{"wt":"Justin, Charles &amp; Co"},"location":{"wt":"Boston, Mass."},"isbn":{"wt":"1-932112-17-0"},"edition":{"wt":"1st"},"ref":{"wt":"harv"}},"i":0}}]}'>Simpson, M. J. (2003). <i><a rel="mw:WikiLink" href="./Hitchhiker:_A_Biography_of_Douglas_Adams" title="Hitchhiker: A Biography of Douglas Adams" class="new">Hitchhiker: A Biography of Douglas Adams</a></i> (1st ed.). Boston, Mass.: Justin, Charles &amp; Co. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number">ISBN</a><span typeof="mw:Entity"> </span><a rel="mw:WikiLink" href="./Special:BookSources/1-932112-17-0" title="Special:BookSources/1-932112-17-0">1-932112-17-0</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.aufirst=M.+J.&amp;rft.aulast=Simpson&amp;rft.btitle=Hitchhiker%3A+A+Biography+of+Douglas+Adams&amp;rft.date=2003&amp;rft.edition=1st&amp;rft.genre=book&amp;rft.isbn=1-932112-17-0&amp;rft.place=Boston%2C+Mass.&amp;rft.pub=Justin%2C+Charles+%26+Co&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook" class="Z3988" about="#mwt217" id="mwA8E"><span style="display:none;"><span typeof="mw:Entity"> </span></span></span></li>
<li id="mwA8I"> Webb, Nick (2005a). <i id="mwA8M">Wish You Were Here: The Official Biography of Douglas Adams</i>. Ballantine Books. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" about="#mwt218" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"ISBN","href":"./Template:ISBN"},"params":{"1":{"wt":"0-345-47650-6"}},"i":0}}]}' id="mwA8Q">ISBN</a><span about="#mwt218"> </span><a rel="mw:WikiLink" href="./Special:BookSources/0-345-47650-6" title="Special:BookSources/0-345-47650-6" about="#mwt218" id="mwA8U">0-345-47650-6</a></li>
<li id="mwA8Y"> Webb, Nick (2005b). <a rel="mw:ExtLink" href="http://www.oxforddnb.com/view/article/75853" id="mwA8c">"Adams, Douglas Noël (1952–2001)"</a>, <i id="mwA8g">Oxford Dictionary of National Biography</i>, Oxford University Press, January 2005. Retrieved 25 October 2005.</li>
<li id="mwA8k"> Roberts, Jem (2014) "The Frood: The Authorised &amp; Very Official Biography of Douglas Adams &amp; The Hitchhiker's Guide To The Galaxy" Preface Publishing. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" about="#mwt219" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"ISBN","href":"./Template:ISBN"},"params":{"1":{"wt":"009959076X"}},"i":0}}]}' id="mwA8o">ISBN</a><span about="#mwt219"> </span><a rel="mw:WikiLink" href="./Special:BookSources/009959076X" title="Special:BookSources/009959076X" about="#mwt219" id="mwA8s">009959076X</a> <a rel="mw:ExtLink" href="https://www.penguin.co.uk/books/1097370/the-frood" id="mwA8w">"The Frood"</a></li></ul>

<h2 id="Further_reading">Further reading</h2>
<h3 id="Articles">Articles</h3>
<div class="refbegin   columns references-column-width" style="-moz-column-width: 30em; -webkit-column-width: 30em; column-width: 30em;" about="#mwt220" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Refbegin","href":"./Template:Refbegin"},"params":{"1":{"wt":"30em"}},"i":0}},"\n* Herbert, R. (1980). The Hitchhiker&#39;s Guide to the Galaxy (Book Review). Library Journal, 105(16), 1982.\n* Adams, J., &amp; Brown, R. (1981). The Hitchhiker&#39;s Guide to the Galaxy (Book Review). School Library Journal, 27(5), 74.\n* Nickerson, S. L. (1982). The Restaurant at the End of the Universe (Book). Library Journal, 107(4), 476.\n* Nickerson, S. L. (1982). Life, the Universe, and Everything (Book). Library Journal, 107(18), 2007.\n* Morner, C. (1982). The Restaurant at the End of the Universe (Book Review). School Library Journal, 28(8), 87.\n* Morner, C. (1983). Life, the Universe and Everything (Book Review). School Library Journal, 29(6), 93.\n* Shorb, B. (1985). So Long, and Thanks for All the Fish (Book). School Library Journal, 31(6), 90.\n* The Long Dark Tea-Time of the Soul (Book). (1989). Atlantic (02769077), 263(4), 99.\n* Hoffert, B., &amp; Quinn, J. (1990). Last Chance To See (Book). Library Journal, 115(16), 77.\n* Reed, S. S., &amp; Cook, I. I. (1991). Dances with kakapos. People, 35(19), 79.\n* Last Chance to See (Book). (1991). Science News, 139(8), 126.\n* Field, M. M., &amp; Steinberg, S. S. (1991). Douglas Adams. Publishers Weekly, 238(6), 62.\n* Dieter, W. (1991). Last Chance to See (Book). Smithsonian, 22(3), 140.\n* Dykhuis, R. (1991). Last Chance To See (Book). Library Journal, 116(1), 140.\n* Beatty, J. (1991). Good Show (Book). Atlantic (02769077), 267(3), 131.\n* A guide to the future. (1992). Maclean&#39;s, 106(44), 51.\n* Zinsser, J. (1993). Audio reviews: Fiction. Publishers Weekly, 240(9), 24.\n* Taylor, B., &amp; Annichiarico, M. (1993). Audio reviews. Library Journal, 118(2), 132.\n* Good reads. (1995). NetGuide, 2(4), 109.\n* Stone, B. (1998). The unsinkable starship. Newsweek, 131(15), 78.\n* Gaslin, G. (2001). Galaxy Quest. Entertainment Weekly, (599), 79.\n* So long, and thanks for all the fish. (2001). Economist, 359(8222), 79.\n* Geier, T., &amp; Raftery, B. M. (2001). Legacy. Entertainment Weekly, (597), 11.\n* Passages. (2001). Maclean&#39;s, 114(21), 13.\n* Don&#39;t panic! Douglas Adams to keynote Embedded show. (2001). Embedded Systems Programming, 14(3), 10.\n* Ehrenman, G. (2001). World Wide Weird. InternetWeek, (862), 15.\n* Zaleski, J. (2002). The Salmon of Doubt (Book). Publishers Weekly, 249(15), 43.\n* Mort, J. (2002). The Salmon of Doubt (Book). Booklist, 98(16), 1386.\n* Lewis, D. L. (2002). Last Time Round The Galaxy. Quadrant Magazine, 46(9), 84.\n* Burns, A. (2002). The Salmon of Doubt (Book). Library Journal, 127(15), 111.\n* Burns, A., &amp; Rhodes, B. (2002). The Restaurant at the End of the Universe (Book). Library Journal, 127(19), 118.\n* Kaveney, R. (2002). A cheerful whale. TLS, (5173), 23.\n* Pearl, N., &amp; Welch, R. (2003). The Hitchhiker&#39;s Guide To The Galaxy (Book). Library Journal, 128(11), 124.\n* Preying on composite materials. (2003). R&amp;D Magazine, 45(6), 44.\n* Webb, N. (2003). The Berkeley Hotel hostage. Bookseller, (5069), 25.\n* The author who toured the universe. (2003). Bookseller, (5060), 35.\n* Osmond, A. (2005). Only human. Sight &amp; Sound, 15(5), 12–15.\n* Culture vulture. (2005). Times Educational Supplement, (4640), 19.\n* Maughan, S. (2005). Audio Bestsellers/Fiction. Publishers Weekly, 252(30), 17.\n* Hitchhiker At The Science Museum. (2005). In Britain, 14(10), 9.\n* Rea, A. (2005). The Adams asteroids. New Scientist, 185(2488), 31.\n* Most Improbable Adventure. (2005). Popular Mechanics, 182(5), 32.\n* The Hitchhiker&#39;s Guide To The Galaxy: The Tertiary Phase. (2005). Publishers Weekly, 252(14), 21.\n* Bartelt, K. R. (2005). Wish You Were Here: The Official Biography of Douglas Adams. Library Journal, 130(4), 86.\n* Larsen, D. (2005). I was a teenage android. New Zealand Listener, 198(3390), 37–38.\n* Tanner, J. C. (2005). Simplicity: it&#39;s hard. Telecom Asia, 16(6), 6.\n* Nielsen Bookscan Charts. (2005). Bookseller, (5175), 18–21.\n* Buena Vista launches regional site to push Hitchhiker&#39;s movie. (2005). New Media Age, 9.\n* Shynola bring Beckland to life. (2005). Creative Review, 25(3), 24–26.\n* Carwardine, M. (15 September 2007). The baiji: So long and thanks for all the fish. New Scientist. pp.&amp;nbsp;50–53.\n* Czarniawska, B. (2008). Accounting and gender across times and places: An excursion into fiction. Accounting, Organizations &amp; Society, 33(1), 33–47.\n* Pope, M. (2008). Life, the Universe, Religion and Science. Issues, (82), 31–34.\n* Bearne, S. (2008). BBC builds site to trail Last Chance To See TV series. New Media Age, 08.\n* Arrow to reissue Adams. (2008). Bookseller, (5352), 14.\n* Page, B. (2008). Colfer is new Hitchhiker. Bookseller, (5350), 7.\n* I&#39;ve got a perfect puzzle for you. (2009). Bookseller, (5404), 42.\n* Mostly Harmless.... (2009). Bookseller, (5374), 46.\n* Penguin and PanMac hitch a ride together. (2009). Bookseller, (5373), 6.\n* Adams, Douglas. Britannica Biographies [serial online]. October 2010;:1\n* Douglas (Noël) Adams (1952–2001). Hutchinson&#39;s Biography Database [serial online]. July 2011;:1\n* My life in books. (2011). Times Educational Supplement, (4940), 27.\n",{"template":{"target":{"wt":"Refend","href":"./Template:Refend"},"params":{},"i":1}}]}' id="mwA80">
<ul><li> Herbert, R. (1980). The Hitchhiker's Guide to the Galaxy (Book Review). Library Journal, 105(16), 1982.</li>
<li> Adams, J., &amp; Brown, R. (1981). The Hitchhiker's Guide to the Galaxy (Book Review). School Library Journal, 27(5), 74.</li>
<li> Nickerson, S. L. (1982). The Restaurant at the End of the Universe (Book). Library Journal, 107(4), 476.</li>
<li> Nickerson, S. L. (1982). Life, the Universe, and Everything (Book). Library Journal, 107(18), 2007.</li>
<li> Morner, C. (1982). The Restaurant at the End of the Universe (Book Review). School Library Journal, 28(8), 87.</li>
<li> Morner, C. (1983). Life, the Universe and Everything (Book Review). School Library Journal, 29(6), 93.</li>
<li> Shorb, B. (1985). So Long, and Thanks for All the Fish (Book). School Library Journal, 31(6), 90.</li>
<li> The Long Dark Tea-Time of the Soul (Book). (1989). Atlantic (02769077), 263(4), 99.</li>
<li> Hoffert, B., &amp; Quinn, J. (1990). Last Chance To See (Book). Library Journal, 115(16), 77.</li>
<li> Reed, S. S., &amp; Cook, I. I. (1991). Dances with kakapos. People, 35(19), 79.</li>
<li> Last Chance to See (Book). (1991). Science News, 139(8), 126.</li>
<li> Field, M. M., &amp; Steinberg, S. S. (1991). Douglas Adams. Publishers Weekly, 238(6), 62.</li>
<li> Dieter, W. (1991). Last Chance to See (Book). Smithsonian, 22(3), 140.</li>
<li> Dykhuis, R. (1991). Last Chance To See (Book). Library Journal, 116(1), 140.</li>
<li> Beatty, J. (1991). Good Show (Book). Atlantic (02769077), 267(3), 131.</li>
<li> A guide to the future. (1992). Maclean's, 106(44), 51.</li>
<li> Zinsser, J. (1993). Audio reviews: Fiction. Publishers Weekly, 240(9), 24.</li>
<li> Taylor, B., &amp; Annichiarico, M. (1993). Audio reviews. Library Journal, 118(2), 132.</li>
<li> Good reads. (1995). NetGuide, 2(4), 109.</li>
<li> Stone, B. (1998). The unsinkable starship. Newsweek, 131(15), 78.</li>
<li> Gaslin, G. (2001). Galaxy Quest. Entertainment Weekly, (599), 79.</li>
<li> So long, and thanks for all the fish. (2001). Economist, 359(8222), 79.</li>
<li> Geier, T., &amp; Raftery, B. M. (2001). Legacy. Entertainment Weekly, (597), 11.</li>
<li> Passages. (2001). Maclean's, 114(21), 13.</li>
<li> Don't panic! Douglas Adams to keynote Embedded show. (2001). Embedded Systems Programming, 14(3), 10.</li>
<li> Ehrenman, G. (2001). World Wide Weird. InternetWeek, (862), 15.</li>
<li> Zaleski, J. (2002). The Salmon of Doubt (Book). Publishers Weekly, 249(15), 43.</li>
<li> Mort, J. (2002). The Salmon of Doubt (Book). Booklist, 98(16), 1386.</li>
<li> Lewis, D. L. (2002). Last Time Round The Galaxy. Quadrant Magazine, 46(9), 84.</li>
<li> Burns, A. (2002). The Salmon of Doubt (Book). Library Journal, 127(15), 111.</li>
<li> Burns, A., &amp; Rhodes, B. (2002). The Restaurant at the End of the Universe (Book). Library Journal, 127(19), 118.</li>
<li> Kaveney, R. (2002). A cheerful whale. TLS, (5173), 23.</li>
<li> Pearl, N., &amp; Welch, R. (2003). The Hitchhiker's Guide To The Galaxy (Book). Library Journal, 128(11), 124.</li>
<li> Preying on composite materials. (2003). R&amp;D Magazine, 45(6), 44.</li>
<li> Webb, N. (2003). The Berkeley Hotel hostage. Bookseller, (5069), 25.</li>
<li> The author who toured the universe. (2003). Bookseller, (5060), 35.</li>
<li> Osmond, A. (2005). Only human. Sight &amp; Sound, 15(5), 12–15.</li>
<li> Culture vulture. (2005). Times Educational Supplement, (4640), 19.</li>
<li> Maughan, S. (2005). Audio Bestsellers/Fiction. Publishers Weekly, 252(30), 17.</li>
<li> Hitchhiker At The Science Museum. (2005). In Britain, 14(10), 9.</li>
<li> Rea, A. (2005). The Adams asteroids. New Scientist, 185(2488), 31.</li>
<li> Most Improbable Adventure. (2005). Popular Mechanics, 182(5), 32.</li>
<li> The Hitchhiker's Guide To The Galaxy: The Tertiary Phase. (2005). Publishers Weekly, 252(14), 21.</li>
<li> Bartelt, K. R. (2005). Wish You Were Here: The Official Biography of Douglas Adams. Library Journal, 130(4), 86.</li>
<li> Larsen, D. (2005). I was a teenage android. New Zealand Listener, 198(3390), 37–38.</li>
<li> Tanner, J. C. (2005). Simplicity: it's hard. Telecom Asia, 16(6), 6.</li>
<li> Nielsen Bookscan Charts. (2005). Bookseller, (5175), 18–21.</li>
<li> Buena Vista launches regional site to push Hitchhiker's movie. (2005). New Media Age, 9.</li>
<li> Shynola bring Beckland to life. (2005). Creative Review, 25(3), 24–26.</li>
<li> Carwardine, M. (15 September 2007). The baiji: So long and thanks for all the fish. New Scientist. pp.<span typeof="mw:Entity"> </span>50–53.</li>
<li> Czarniawska, B. (2008). Accounting and gender across times and places: An excursion into fiction. Accounting, Organizations &amp; Society, 33(1), 33–47.</li>
<li> Pope, M. (2008). Life, the Universe, Religion and Science. Issues, (82), 31–34.</li>
<li> Bearne, S. (2008). BBC builds site to trail Last Chance To See TV series. New Media Age, 08.</li>
<li> Arrow to reissue Adams. (2008). Bookseller, (5352), 14.</li>
<li> Page, B. (2008). Colfer is new Hitchhiker. Bookseller, (5350), 7.</li>
<li> I've got a perfect puzzle for you. (2009). Bookseller, (5404), 42.</li>
<li> Mostly Harmless.... (2009). Bookseller, (5374), 46.</li>
<li> Penguin and PanMac hitch a ride together. (2009). Bookseller, (5373), 6.</li>
<li> Adams, Douglas. Britannica Biographies [serial online]. October 2010;:1</li>
<li> Douglas (Noël) Adams (1952–2001). Hutchinson's Biography Database [serial online]. July 2011;:1</li>
<li> My life in books. (2011). Times Educational Supplement, (4940), 27.</li></ul>
</div>

<h3 id="Other">Other</h3>
<ul id="mwA84"><li id="mwA88"> <a rel="mw:ExtLink" href="https://web.archive.org/web/20110720193159/http://www.douglasadams.com/" about="#mwt225" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"webarchive ","href":"./Template:Webarchive"},"params":{"url":{"wt":"https://web.archive.org/web/20110720193159/http://www.douglasadams.com/"},"date":{"wt":"20 July 2011"},"title":{"wt":"Adams&#39;s official web site"}},"i":0}}]}' id="mwA9A">Adams's official web site</a><span about="#mwt225"> at the </span><a rel="mw:WikiLink" href="./Wayback_Machine" title="Wayback Machine" about="#mwt225">Wayback Machine</a><span typeof="mw:Entity" about="#mwt225"> </span><span about="#mwt225">(archived 20 July 2011)</span><link rel="mw:PageProp/Category" href="./Category:Webarchive_template_wayback_links" about="#mwt225" id="mwA9E"/>, established by him, and still operated by <a rel="mw:WikiLink" href="./The_Digital_Village" title="The Digital Village" id="mwA9I">The Digital Village</a></li>
<li id="mwA9M"> <a rel="mw:ExtLink" href="https://www.ted.com/speakers/douglas_adams" about="#mwt226" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"TED speaker","href":"./Template:TED_speaker"},"params":{"1":{"wt":"douglas_adams"}},"i":0}}]}' id="mwA9Q">Douglas Adams</a><span about="#mwt226"> at </span><a rel="mw:WikiLink" href="./TED_(conference)" title="TED (conference)" about="#mwt226">TED</a><link rel="mw:PageProp/Category" href="./Category:TED_speaker_ID_same_as_Wikidata" about="#mwt226" id="mwA9U"/></li>
<li id="mwA9Y"> <a rel="mw:ExtLink" href="http://www.biota.org/people/douglasadams/" id="mwA9c">Douglas Adams speech at Digital Biota 2 (1998)</a> <a rel="mw:ExtLink" href="http://www.biota.org/podcast/#DNA" id="mwA9g">(The audio of the speech)</a></li>
<li id="mwA9k"> <a rel="mw:ExtLink" href="https://www.theguardian.com/books/2008/jun/09/douglasadams" id="mwA9o">Guardian Books "Author Page"</a>, with profile and links to further articles.</li>
<li id="mwA9s"> <a rel="mw:ExtLink" href="//worldcat.org/identities/lccn-n80-76765" about="#mwt227" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Worldcat id","href":"./Template:Worldcat_id"},"params":{"id":{"wt":"lccn-n80-76765"}},"i":0}}]}' id="mwA9w">Works by or about Douglas Adams</a><span about="#mwt227"> in libraries (</span><a rel="mw:WikiLink" href="./WorldCat" title="WorldCat" about="#mwt227">WorldCat</a><span about="#mwt227"> catalog)</span></li>
<li id="mwA90"> <a rel="mw:ExtLink" href="http://www.vintagemacworld.com/iifx.html" id="mwA94">Douglas Adams &amp; his Computer</a> article about his Mac IIfx</li>
<li id="mwA98"> BBC2 "Omnibus" tribute to Adams, presented by Kirsty Wark, 4 August 2001</li>
<li id="mwA-A"> Mueller, Rick and Greengrass, Joel (2002). <i id="mwA-E">Life, The Universe and Douglas Adams</i>, documentary.</li>
<li id="mwA-I"> Simpson, M.J. (2001). <i id="mwA-M">The Pocket Essential Hitchhiker's Guide</i>. <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" about="#mwt228" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"ISBN","href":"./Template:ISBN"},"params":{"1":{"wt":"1-903047-40-4"}},"i":0}}]}' id="mwA-Q">ISBN</a><span about="#mwt228"> </span><a rel="mw:WikiLink" href="./Special:BookSources/1-903047-40-4" title="Special:BookSources/1-903047-40-4" about="#mwt228" id="mwA-U">1-903047-40-4</a>. Updated April 2005 <a rel="mw:WikiLink" href="./International_Standard_Book_Number" title="International Standard Book Number" about="#mwt229" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"ISBN","href":"./Template:ISBN"},"params":{"1":{"wt":"1-904048-46-3"}},"i":0}}]}' id="mwA-Y">ISBN</a><span about="#mwt229"> </span><a rel="mw:WikiLink" href="./Special:BookSources/1-904048-46-3" title="Special:BookSources/1-904048-46-3" about="#mwt229" id="mwA-c">1-904048-46-3</a></li>
<li id="mwA-g"> <a rel="mw:ExtLink" href="http://www.bbc.co.uk/programmes/p00fpvbm" id="mwA-k">Special edition of BBC Book Club featuring Douglas Adams</a>, first broadcast 2 January 2000 on BBC Radio 4</li></ul>

<h2 id="External_links">External links</h2>
<table class="vertical-navbox nowraplinks infobox" style="float:right;clear:right;width:auto;margin:0 0 1.0em 1.0em;background:#f9f9f9;border:1px solid #aaa;padding:0.2em;border-spacing:0.4em 0;text-align:center;line-height:1.4em;font-size:88%" about="#mwt230" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Library resources box\n ","href":"./Template:Library_resources_box"},"params":{"by":{"wt":"yes"},"viaf":{"wt":"113230702"},"label":{"wt":"Douglas Adams"}},"i":0}}]}' id="mwA-o"><tbody><tr><td style="padding-top:0.4em;line-height:1.2em"><a rel="mw:WikiLink" href="./Wikipedia:LIBRARY" title="Wikipedia:LIBRARY" class="mw-redirect">Library resources</a> about <br/> <b>Douglas Adams</b> <hr/></td></tr><tr><td class="plainlist" style="padding:0 0.1em 0.4em;text-align:left;">
<ul><li> <a rel="mw:ExtLink" href="//tools.wmflabs.org/ftl/cgi-bin/ftl?st=viaf&amp;su=113230702">Resources in your library</a></li>
<li> <a rel="mw:ExtLink" href="//tools.wmflabs.org/ftl/cgi-bin/ftl?st=viaf&amp;su=113230702&amp;library=0CHOOSE0">Resources in other libraries</a></li></ul></td>
</tr><tr><th style="padding:0.1em">
By Douglas Adams</th></tr><tr><td class="plainlist" style="padding:0 0.1em 0.4em;text-align:left;">
<ul><li> <a rel="mw:ExtLink" href="//tools.wmflabs.org/ftl/cgi-bin/ftl?at=viaf&amp;au=113230702">Resources in your library</a></li>
<li> <a rel="mw:ExtLink" href="//tools.wmflabs.org/ftl/cgi-bin/ftl?at=viaf&amp;au=113230702&amp;library=0CHOOSE0">Resources in other libraries</a></li></ul></td>
</tr></tbody></table>
<div id="section_SpokenWikipedia" class="infobox sisterproject noprint" about="#mwt231" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Spoken Wikipedia-2","href":"./Template:Spoken_Wikipedia-2"},"params":{"1":{"wt":"2006-02-11"},"2":{"wt":"Douglas_Adams_Part_1.ogg"},"3":{"wt":"Douglas_Adams_Part_2.ogg"}},"i":0}}]}'>
<div style="text-align: center;"><b>Listen to this article (2 parts)<span typeof="mw:Entity"> </span><b><span typeof="mw:Entity">·</span></b><span typeof="mw:Entity"> </span> <a rel="mw:WikiLink" href="./File:Douglas_Adams_Part_1.ogg" title="File:Douglas Adams Part 1.ogg">(info)</a></b></div>
<div style="text-align: center; font-size: 90%; margin-bottom: .4em;"><i><a rel="mw:MediaLink" href="//upload.wikimedia.org/wikipedia/commons/4/4a/Douglas_Adams_Part_1.ogg" title="Douglas Adams Part 1.ogg">Part 1</a><span typeof="mw:Entity"> </span>• <a rel="mw:MediaLink" href="//upload.wikimedia.org/wikipedia/commons/c/c6/Douglas_Adams_Part_2.ogg" title="Douglas Adams Part 2.ogg">Part 2</a></i></div>
<div style="float: left; margin-left: 5px;"><figure class="mw-halign-none" typeof="mw:Image"><span><img alt="" resource="./File:Sound-icon.svg" src="//upload.wikimedia.org/wikipedia/commons/thumb/4/47/Sound-icon.svg/45px-Sound-icon.svg.png" data-file-width="128" data-file-height="96" data-file-type="drawing" height="34" width="45" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/4/47/Sound-icon.svg/90px-Sound-icon.svg.png 2x, //upload.wikimedia.org/wikipedia/commons/thumb/4/47/Sound-icon.svg/68px-Sound-icon.svg.png 1.5x"/></span><figcaption>Spoken Wikipedia</figcaption></figure></div>
<div style="font-size: xx-small; line-height: 1.6em; margin-left: 60px;">This audio file was created from a revision of the "<span class="fn">Douglas Adams</span>" article dated 2006-02-11, and does not reflect subsequent edits to the article. (<a rel="mw:WikiLink" href="./Wikipedia:Media_help" title="Wikipedia:Media help">Audio help</a>)</div>
<div style="text-align: center; clear: both"><b><a rel="mw:WikiLink" href="./Wikipedia:Spoken_articles" title="Wikipedia:Spoken articles">More spoken articles</a></b></div>
<link rel="mw:PageProp/Category" href="./Category:Spoken_articles"/>
</div><span about="#mwt231">
</span><p about="#mwt231"><span typeof="mw:Extension/indicator" about="#mwt272" data-mw='{"name":"indicator","attrs":{"name":"spoken-icon"},"body":{"extsrc":"[[File:Sound-icon.svg|20x20px\n |link=File:Douglas_Adams_Part_1.ogg\n |\n |Listen to this article]]\n"}}'>
</span></p>
<ul id="mwA-s"><li id="mwA-w"> <span class="official-website" about="#mwt232" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Official website","href":"./Template:Official_website"},"params":{},"i":0}}]}' id="mwA-0"><span class="url"><a rel="mw:ExtLink" href="http://www.douglasadams.com/">Official website</a></span></span></li>
<li id="mwA-4"> <span class="noviewer" typeof="mw:Transclusion mw:Image" about="#mwt233" data-mw='{"parts":[{"template":{"target":{"wt":"Commons category-inline","href":"./Template:Commons_category-inline"},"params":{},"i":0}}]}' id="mwA-8"><a href="./File:Commons-logo.svg"><img alt="" resource="./File:Commons-logo.svg" src="//upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/12px-Commons-logo.svg.png" data-file-width="1024" data-file-height="1376" data-file-type="drawing" height="16" width="12" srcset="//upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/24px-Commons-logo.svg.png 2x, //upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/18px-Commons-logo.svg.png 1.5x"/></a></span><span about="#mwt233"> Media related to </span><a rel="mw:ExtLink" href="https://commons.wikimedia.org/wiki/Category:Douglas%20Adams" title="commons:Category:Douglas Adams" about="#mwt233">Douglas Adams</a><span about="#mwt233"> at Wikimedia Commons</span></li>
<li id="mwA_A"> <span class="noviewer" typeof="mw:Transclusion mw:Image" about="#mwt234" data-mw='{"parts":[{"template":{"target":{"wt":"Wikiquote-inline","href":"./Template:Wikiquote-inline"},"params":{},"i":0}}]}' id="mwA_E"><a href="./File:Wikiquote-logo.svg"><img alt="" resource="./File:Wikiquote-logo.svg" src="//upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikiquote-logo.svg/13px-Wikiquote-logo.svg.png" data-file-width="300" data-file-height="355" data-file-type="drawing" height="16" width="13" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikiquote-logo.svg/27px-Wikiquote-logo.svg.png 2x, //upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikiquote-logo.svg/20px-Wikiquote-logo.svg.png 1.5x"/></a></span><span about="#mwt234"> Quotations related to </span><a rel="mw:ExtLink" href="https://en.wikiquote.org/wiki/Special:Search/Douglas%20Adams" title="wikiquote:Special:Search/Douglas Adams" about="#mwt234">Douglas Adams</a><span about="#mwt234"> at Wikiquote</span></li>
<li id="mwA_I"> <a rel="mw:ExtLink" href="https://www.findagrave.com/cgi-bin/fg.cgi?page=gr&amp;GRid=22814" about="#mwt235" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Find a Grave","href":"./Template:Find_a_Grave"},"params":{},"i":0}}]}' id="mwA_M">Douglas Adams</a><span about="#mwt235"> at </span><a rel="mw:WikiLink" href="./Find_a_Grave" title="Find a Grave" about="#mwt235">Find a Grave</a><span about="#mwt235"> </span><span class="mw-valign-text-top" typeof="mw:Image/Frameless" about="#mwt235" data-mw='{"caption":"Edit this at Wikidata"}'><a href="https://www.wikidata.org/wiki/Q42#P535"><img alt="Edit this at Wikidata" resource="./File:Blue_pencil.svg" src="//upload.wikimedia.org/wikipedia/commons/thumb/7/73/Blue_pencil.svg/10px-Blue_pencil.svg.png" data-file-width="600" data-file-height="600" data-file-type="drawing" height="10" width="10" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/7/73/Blue_pencil.svg/20px-Blue_pencil.svg.png 2x, //upload.wikimedia.org/wikipedia/commons/thumb/7/73/Blue_pencil.svg/15px-Blue_pencil.svg.png 1.5x"/></a></span><link rel="mw:PageProp/Category" href="./Category:Find_a_Grave_template_using_Wikidata" about="#mwt235" id="mwA_Q"/></li>
<li id="mwA_U"> <a rel="mw:ExtLink" href="http://www.imdb.com/name/nm0010930/" about="#mwt236" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"IMDb name","href":"./Template:IMDb_name"},"params":{},"i":0}}]}' id="mwA_Y">Douglas Adams</a><span about="#mwt236"> on </span><a rel="mw:WikiLink" href="./IMDb" title="IMDb" about="#mwt236">IMDb</a><span about="#mwt236"> </span><span class="mw-valign-text-top" typeof="mw:Image/Frameless" about="#mwt236" data-mw='{"caption":"Edit this at Wikidata"}'><a href="https://www.wikidata.org/wiki/Q42#P345"><img alt="Edit this at Wikidata" resource="./File:Blue_pencil.svg" src="//upload.wikimedia.org/wikipedia/commons/thumb/7/73/Blue_pencil.svg/10px-Blue_pencil.svg.png" data-file-width="600" data-file-height="600" data-file-type="drawing" height="10" width="10" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/7/73/Blue_pencil.svg/20px-Blue_pencil.svg.png 2x, //upload.wikimedia.org/wikipedia/commons/thumb/7/73/Blue_pencil.svg/15px-Blue_pencil.svg.png 1.5x"/></a></span></li>
<li id="mwA_c"> <a rel="mw:ExtLink" href="http://towelday.org/" id="mwA_g">Towel Day, 25 May</a></li></ul>

<span about="#mwt237" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"s-start","href":"./Template:S-start"},"params":{},"i":0}},"\n",{"template":{"target":{"wt":"s-bef","href":"./Template:S-bef"},"params":{"before":{"wt":"[[Anthony Read]]"}},"i":1}}," \n",{"template":{"target":{"wt":"s-ttl","href":"./Template:S-ttl"},"params":{"title":{"wt":"&#39;&#39;[[Doctor Who]]&#39;&#39; script editor"},"years":{"wt":"1979–80"}},"i":2}}," \n",{"template":{"target":{"wt":"s-aft","href":"./Template:S-aft"},"params":{"after":{"wt":"[[Christopher H. Bidmead]]"}},"i":3}},"\n",{"template":{"target":{"wt":"s-end","href":"./Template:S-end"},"params":{},"i":4}}]}' id="mwA_k">
</span><table class="wikitable succession-box" style="margin:0.5em auto; font-size:95%;clear:both;" about="#mwt237">
<tbody><tr style="text-align:center;">
<td style="width:30%;" rowspan="1">Preceded<span typeof="mw:Entity"> </span>by<br/><span style="font-weight: bold"><a rel="mw:WikiLink" href="./Anthony_Read" title="Anthony Read">Anthony Read</a></span></td>
<td style="width: 40%; text-align: center;" rowspan="1"><b><i><a rel="mw:WikiLink" href="./Doctor_Who" title="Doctor Who">Doctor Who</a></i> script editor</b><br/>1979–80        </td>
<td style="width: 30%; text-align: center;" rowspan="1"> Succeeded<span typeof="mw:Entity"> </span>by<br/><span style="font-weight: bold"><a rel="mw:WikiLink" href="./Christopher_H._Bidmead" title="Christopher H. Bidmead">Christopher H. Bidmead</a></span></td></tr>

</tbody></table>
<div class="navbox" style="padding:3px" about="#mwt242" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Douglas Adams","href":"./Template:Douglas_Adams"},"params":{},"i":0}}]}' id="mwA_o"><table class="nowraplinks collapsible autocollapse navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="col" class="navbox-title" colspan="2"><div class="plainlinks hlist navbar mini"><ul><li class="nv-view"><a rel="mw:WikiLink" href="./Template:Douglas_Adams" title="Template:Douglas Adams"><abbr title="View this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">v</abbr></a></li><li class="nv-talk"><a rel="mw:WikiLink" href="./Template_talk:Douglas_Adams" title="Template talk:Douglas Adams"><abbr title="Discuss this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">t</abbr></a></li><li class="nv-edit"><a rel="mw:ExtLink" href="//en.wikipedia.org/w/index.php?title=Template:Douglas_Adams&amp;action=edit"><abbr title="Edit this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">e</abbr></a></li></ul></div><div id="Works_by_Douglas_Adams" style="font-size:114%;margin:0 4em">Works by <a rel="mw:WikiLink" href="./Douglas_Adams" title="Douglas Adams">Douglas Adams</a></div></th></tr><tr><th scope="row" class="navbox-group" style="width:1%">Novels</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(novel)" title="The Hitchhiker's Guide to the Galaxy (novel)">The Hitchhiker's Guide to the Galaxy</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Restaurant_at_the_End_of_the_Universe" title="The Restaurant at the End of the Universe">The Restaurant at the End of the Universe</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Life,_the_Universe_and_Everything" title="Life, the Universe and Everything">Life, the Universe and Everything</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./So_Long,_and_Thanks_for_All_the_Fish" title="So Long, and Thanks for All the Fish">So Long, and Thanks for All the Fish</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Dirk_Gently's_Holistic_Detective_Agency" title="Dirk Gently's Holistic Detective Agency">Dirk Gently's Holistic Detective Agency</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Long_Dark_Tea-Time_of_the_Soul" title="The Long Dark Tea-Time of the Soul">The Long Dark Tea-Time of the Soul</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Mostly_Harmless" title="Mostly Harmless">Mostly Harmless</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Short stories</th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> "<a rel="mw:WikiLink" href="./The_Private_Life_of_Genghis_Khan" title="The Private Life of Genghis Khan">The Private Life of Genghis Khan</a>"</li>
<li> "<a rel="mw:WikiLink" href="./Young_Zaphod_Plays_It_Safe" title="Young Zaphod Plays It Safe">Young Zaphod Plays It Safe</a>"</li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Books</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./The_Meaning_of_Liff" title="The Meaning of Liff">The Meaning of Liff</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy:_The_Original_Radio_Scripts" title="The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts">The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Last_Chance_to_See" title="Last Chance to See">Last Chance to See</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Deeper_Meaning_of_Liff" title="The Deeper Meaning of Liff" class="mw-redirect">The Deeper Meaning of Liff</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Douglas_Adams's_Guide_to_The_Hitchhiker's_Guide_to_the_Galaxy" title="Douglas Adams's Guide to The Hitchhiker's Guide to the Galaxy">Douglas Adams's Guide to The Hitchhiker's Guide to the Galaxy</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Salmon_of_Doubt" title="The Salmon of Doubt">The Salmon of Doubt</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Screenplays</th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i>Monty Python's Flying Circus</i>
<ul><li> "<a rel="mw:WikiLink" href="./Patient_Abuse" title="Patient Abuse">Patient Abuse</a>"</li></ul></li>
<li> <i><a rel="mw:WikiLink" href="./Out_of_the_Trees" title="Out of the Trees">Out of the Trees</a></i></li>
<li> <i>Doctor Who</i>
<ul><li> <i><a rel="mw:WikiLink" href="./The_Pirate_Planet" title="The Pirate Planet">The Pirate Planet</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./City_of_Death" title="City of Death">City of Death</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Shada_(Doctor_Who)" title="Shada (Doctor Who)">Shada</a></i></li></ul></li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(TV_series)" title="The Hitchhiker's Guide to the Galaxy (TV series)">The Hitchhiker's Guide to the Galaxy</a></i> (TV series)</li>
<li> <i><a rel="mw:WikiLink" href="./Hyperland" title="Hyperland">Hyperland</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(film)" title="The Hitchhiker's Guide to the Galaxy (film)">The Hitchhiker's Guide to the Galaxy</a></i> (film)</li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Video games</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(video_game)" title="The Hitchhiker's Guide to the Galaxy (video game)">The Hitchhiker's Guide to the Galaxy</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Bureaucracy_(video_game)" title="Bureaucracy (video game)">Bureaucracy</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Starship_Titanic" title="Starship Titanic">Starship Titanic</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">See also</th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy" title="The Hitchhiker's Guide to the Galaxy">The Hitchhiker's Guide to the Galaxy</a></i> (series)</li>
<li> <i><a rel="mw:WikiLink" href="./Douglas_Adams_at_the_BBC" title="Douglas Adams at the BBC">Douglas Adams at the BBC</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Future" title="The Hitchhiker's Guide to the Future">The Hitchhiker's Guide to the Future</a></i> (BBC radio series)</li>
<li> <i><a rel="mw:WikiLink" href="./The_Utterly_Utterly_Merry_Comic_Relief_Christmas_Book" title="The Utterly Utterly Merry Comic Relief Christmas Book">The Utterly Utterly Merry Comic Relief Christmas Book</a></i></li></ul>
</div></td></tr></tbody></table></div>
<div class="navbox" style="padding:3px" about="#mwt243" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"HitchhikerBooks","href":"./Template:HitchhikerBooks"},"params":{},"i":0}}]}' id="mwA_s"><table class="nowraplinks collapsible autocollapse navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="col" class="navbox-title" colspan="2"><div class="plainlinks hlist navbar mini"><ul><li class="nv-view"><a rel="mw:WikiLink" href="./Template:The_Hitchhiker's_Guide_to_the_Galaxy" title="Template:The Hitchhiker's Guide to the Galaxy"><abbr title="View this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">v</abbr></a></li><li class="nv-talk"><a rel="mw:WikiLink" href="./Template_talk:The_Hitchhiker's_Guide_to_the_Galaxy" title="Template talk:The Hitchhiker's Guide to the Galaxy"><abbr title="Discuss this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">t</abbr></a></li><li class="nv-edit"><a rel="mw:ExtLink" href="//en.wikipedia.org/w/index.php?title=Template:The_Hitchhiker%27s_Guide_to_the_Galaxy&amp;action=edit"><abbr title="Edit this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">e</abbr></a></li></ul></div><div id="Douglas_Adams.27_The_Hitchhiker.27s_Guide_to_the_Galaxy" style="font-size:114%;margin:0 4em"><a rel="mw:WikiLink" href="./Douglas_Adams" title="Douglas Adams">Douglas Adams'</a> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy" title="The Hitchhiker's Guide to the Galaxy">The Hitchhiker's Guide to the Galaxy</a></i></div></th></tr><tr><th scope="row" class="navbox-group" style="width:1%">Books</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em"></div><table class="nowraplinks navbox-subgroup" style="border-spacing:0"><tbody><tr><th scope="row" class="navbox-group" style="width:1%">Main series</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(novel)" title="The Hitchhiker's Guide to the Galaxy (novel)">The Hitchhiker's Guide to the Galaxy</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Restaurant_at_the_End_of_the_Universe" title="The Restaurant at the End of the Universe">The Restaurant at the End of the Universe</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Life,_the_Universe_and_Everything" title="Life, the Universe and Everything">Life, the Universe and Everything</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./So_Long,_and_Thanks_for_All_the_Fish" title="So Long, and Thanks for All the Fish">So Long, and Thanks for All the Fish</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Mostly_Harmless" title="Mostly Harmless">Mostly Harmless</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Related works</th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> "<a rel="mw:WikiLink" href="./Young_Zaphod_Plays_It_Safe" title="Young Zaphod Plays It Safe">Young Zaphod Plays It Safe</a>"</li>
<li> <i><a rel="mw:WikiLink" href="./The_Salmon_of_Doubt" title="The Salmon of Doubt">The Salmon of Doubt</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">by <a rel="mw:WikiLink" href="./Eoin_Colfer" title="Eoin Colfer">Eoin Colfer</a></th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em"><i><a rel="mw:WikiLink" href="./And_Another_Thing..._(novel)" title="And Another Thing... (novel)">And Another Thing...</a></i></div></td></tr></tbody></table><div></div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Media</th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(radio_series)" title="The Hitchhiker's Guide to the Galaxy (radio series)">Radio series</a>
<ul><li> <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_Primary_and_Secondary_Phases" title="The Hitchhiker's Guide to the Galaxy Primary and Secondary Phases">Phases 1 &amp; 2</a></li>
<li> <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_Tertiary_to_Quintessential_Phases" title="The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases">Phases 3, 4 &amp; 5</a></li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy:_The_Original_Radio_Scripts" title="The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts">The Original Radio Scripts</a></i></li></ul></li>
<li> <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(TV_series)" title="The Hitchhiker's Guide to the Galaxy (TV series)">TV series</a></li>
<li> <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(film)" title="The Hitchhiker's Guide to the Galaxy (film)">Film</a></li>
<li> <a rel="mw:WikiLink" href="./Timeline_of_The_Hitchhiker's_Guide_to_the_Galaxy_versions" title="Timeline of The Hitchhiker's Guide to the Galaxy versions">Timeline of <i>The Hitchhiker's Guide to the Galaxy</i> versions</a></li>
<li> <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_cast_lists" title="The Hitchhiker's Guide to the Galaxy cast lists">Cast lists</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Games</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(video_game)" title="The Hitchhiker's Guide to the Galaxy (video game)">The Hitchhiker's Guide to the Galaxy</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Companion<br/>media</th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./Don't_Panic:_The_Official_Hitchhiker's_Guide_to_the_Galaxy_Companion" title="Don't Panic: The Official Hitchhiker's Guide to the Galaxy Companion">Don't Panic: The Official Hitchhiker's Guide to the Galaxy Companion</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Douglas_Adams's_Guide_to_The_Hitchhiker's_Guide_to_the_Galaxy" title="Douglas Adams's Guide to The Hitchhiker's Guide to the Galaxy">Douglas Adams's Guide to The Hitchhiker's Guide to the Galaxy</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Characters</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <a rel="mw:WikiLink" href="./Arthur_Dent" title="Arthur Dent">Arthur Dent</a></li>
<li> <a rel="mw:WikiLink" href="./Ford_Prefect_(character)" title="Ford Prefect (character)">Ford Prefect</a></li>
<li> <a rel="mw:WikiLink" href="./Zaphod_Beeblebrox" title="Zaphod Beeblebrox">Zaphod Beeblebrox</a></li>
<li> <a rel="mw:WikiLink" href="./Marvin_(character)" title="Marvin (character)">Marvin the Paranoid Android</a></li>
<li> <a rel="mw:WikiLink" href="./Trillian_(character)" title="Trillian (character)">Trillian</a></li>
<li> <a rel="mw:WikiLink" href="./Slartibartfast" title="Slartibartfast">Slartibartfast</a></li>
<li> <a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(fictional)" title="The Hitchhiker's Guide to the Galaxy (fictional)">The <i>Guide</i></a></li>
<li> <a rel="mw:WikiLink" href="./List_of_minor_The_Hitchhiker's_Guide_to_the_Galaxy_characters" title="List of minor The Hitchhiker's Guide to the Galaxy characters">Minor characters</a></li>
<li> <a rel="mw:WikiLink" href="./List_of_races_and_species_in_The_Hitchhiker's_Guide_to_the_Galaxy" title="List of races and species in The Hitchhiker's Guide to the Galaxy">Races and species</a></li>
<li> <a rel="mw:WikiLink" href="./Vogon" title="Vogon">Vogons</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Miscellanea</th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <a rel="mw:WikiLink" href="./Phrases_from_The_Hitchhiker's_Guide_to_the_Galaxy" title="Phrases from The Hitchhiker's Guide to the Galaxy">Phrases</a></li>
<li> <a rel="mw:WikiLink" href="./Places_in_The_Hitchhiker's_Guide_to_the_Galaxy" title="Places in The Hitchhiker's Guide to the Galaxy">Places</a></li>
<li> <a rel="mw:WikiLink" href="./Technology_in_The_Hitchhiker's_Guide_to_the_Galaxy" title="Technology in The Hitchhiker's Guide to the Galaxy">Technology</a></li>
<li> <a rel="mw:WikiLink" href="./Somebody_else's_problem" title="Somebody else's problem">Somebody else's problem</a></li>
<li> <i><a rel="mw:WikiLink" href="./Encyclopedia_Galactica" title="Encyclopedia Galactica">Encyclopedia Galactica</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">In culture</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <a rel="mw:WikiLink" href="./H2g2" title="H2g2">h2g2</a></li>
<li> <a rel="mw:WikiLink" href="./Hitchcon" title="Hitchcon">Hitchcon</a></li>
<li> <a rel="mw:WikiLink" href="./Towel_Day" title="Towel Day">Towel Day</a></li>
<li><a rel="mw:WikiLink" href="./One_of_These_Nights#.22Journey_of_the_Sorcerer.22" title="One of These Nights">"Journey of the Sorcerer"</a></li>
<li> <a rel="mw:WikiLink" href="./18610_Arthurdent" title="18610 Arthurdent">18610 Arthurdent</a></li>
<li> <a rel="mw:WikiLink" href="./25924_Douglasadams" title="25924 Douglasadams">25924 Douglasadams</a></li>
<li> <i><a rel="mw:WikiLink" href="./Bidenichthys_beeblebroxi" title="Bidenichthys beeblebroxi">Bidenichthys beeblebroxi</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Erechthias_beeblebroxi" title="Erechthias beeblebroxi">Erechthias beeblebroxi</a></i></li></ul>
</div></td></tr><tr><td class="navbox-abovebelow hlist" colspan="2"><div>
<ul><li> <a rel="mw:WikiLink" href="./Portal:Hitchhiker's" title="Portal:Hitchhiker's">Portal</a></li>
<li> <a rel="mw:WikiLink" href="./Category:The_Hitchhiker's_Guide_to_the_Galaxy" title="Category:The Hitchhiker's Guide to the Galaxy">Category</a></li></ul>
</div></td></tr></tbody></table></div>
<div class="navbox" style="padding:3px" about="#mwt244" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Dirk Gently","href":"./Template:Dirk_Gently"},"params":{},"i":0}}]}' id="mwA_w"><table class="nowraplinks collapsible autocollapse navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="col" class="navbox-title" colspan="3"><div class="plainlinks hlist navbar mini"><ul><li class="nv-view"><a rel="mw:WikiLink" href="./Template:Dirk_Gently" title="Template:Dirk Gently"><abbr title="View this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">v</abbr></a></li><li class="nv-talk"><a rel="mw:WikiLink" href="./Template_talk:Dirk_Gently" title="Template talk:Dirk Gently"><abbr title="Discuss this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">t</abbr></a></li><li class="nv-edit"><a rel="mw:ExtLink" href="//en.wikipedia.org/w/index.php?title=Template:Dirk_Gently&amp;action=edit"><abbr title="Edit this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">e</abbr></a></li></ul></div><div id="Douglas_Adams.27_Dirk_Gently" style="font-size:114%;margin:0 4em"><a rel="mw:WikiLink" href="./Douglas_Adams" title="Douglas Adams">Douglas Adams</a>' <a rel="mw:WikiLink" href="./Dirk_Gently" title="Dirk Gently">Dirk Gently</a></div></th></tr><tr><th scope="row" class="navbox-group" style="width:1%">Novels</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./Dirk_Gently's_Holistic_Detective_Agency" title="Dirk Gently's Holistic Detective Agency">Dirk Gently's Holistic Detective Agency</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Long_Dark_Tea-Time_of_the_Soul" title="The Long Dark Tea-Time of the Soul">The Long Dark Tea-Time of the Soul</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Salmon_of_Doubt" title="The Salmon of Doubt">The Salmon of Doubt</a></i> (unfinished)</li></ul>
</div></td><td class="navbox-image" rowspan="3" style="width:1px;padding:0px 0px 0px 2px"><div><span typeof="mw:Image"><span><img alt="" resource="./File:Dirk_Gently's_Holistic_Detective_Agency.svg" src="//upload.wikimedia.org/wikipedia/commons/thumb/7/74/Dirk_Gently%27s_Holistic_Detective_Agency.svg/150px-Dirk_Gently%27s_Holistic_Detective_Agency.svg.png" data-file-width="512" data-file-height="384" data-file-type="drawing" height="113" width="150" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/7/74/Dirk_Gently%27s_Holistic_Detective_Agency.svg/300px-Dirk_Gently%27s_Holistic_Detective_Agency.svg.png 2x, //upload.wikimedia.org/wikipedia/commons/thumb/7/74/Dirk_Gently%27s_Holistic_Detective_Agency.svg/225px-Dirk_Gently%27s_Holistic_Detective_Agency.svg.png 1.5x"/></span></span></div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Adaptations</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em"></div><table class="nowraplinks navbox-subgroup" style="border-spacing:0"><tbody><tr><th scope="row" class="navbox-group" style="width:1%;padding-left:0;padding-right:0;"><div style="padding:0em 0.75em;">Radio</div></th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./Dirk_Gently's_Holistic_Detective_Agency_(radio_serial)" title="Dirk Gently's Holistic Detective Agency (radio serial)" class="mw-redirect">Dirk Gently's Holistic Detective Agency</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Long_Dark_Tea-Time_of_the_Soul_(radio_serial)" title="The Long Dark Tea-Time of the Soul (radio serial)">The Long Dark Tea-Time of the Soul</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%;padding-left:0;padding-right:0;"><div style="padding:0em 0.75em;">Theatre</div></th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em"><i><a rel="mw:WikiLink" href="./Dirk_(play)" title="Dirk (play)">Dirk</a></i></div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%;padding-left:0;padding-right:0;"><div style="padding:0em 0.75em;">Television</div></th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./Dirk_Gently_(TV_series)" title="Dirk Gently (TV series)">Dirk Gently</a></i>
<ul><li> "<a rel="mw:WikiLink" href="./Pilot_(Dirk_Gently)" title="Pilot (Dirk Gently)">Pilot</a>"</li></ul></li>
<li> <i><a rel="mw:WikiLink" href="./Dirk_Gently's_Holistic_Detective_Agency_(TV_series)" title="Dirk Gently's Holistic Detective Agency (TV series)">Dirk Gently's Holistic Detective Agency</a></i></li></ul>
</div></td></tr></tbody></table><div></div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Related</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <a rel="mw:WikiLink" href="./Professor_Chronotis" title="Professor Chronotis">Professor Chronotis</a></li>
<li> <a rel="mw:WikiLink" href="./St._Cedd's_College,_Cambridge" title="St. Cedd's College, Cambridge">St. Cedd's College</a></li>
<li> <i><a rel="mw:WikiLink" href="./Douglas_Adams_at_the_BBC" title="Douglas Adams at the BBC">Douglas Adams at the BBC</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy" title="The Hitchhiker's Guide to the Galaxy">The Hitchhiker's Guide to the Galaxy</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Shada_(Doctor_Who)" title="Shada (Doctor Who)">Shada</a></i></li></ul>
</div></td></tr></tbody></table></div>
<div class="navbox" style="padding:3px" about="#mwt245" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Infocom games","href":"./Template:Infocom_games"},"params":{},"i":0}}]}' id="mwA_0"><table class="nowraplinks collapsible autocollapse navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="col" class="navbox-title" colspan="2"><div class="plainlinks hlist navbar mini"><ul><li class="nv-view"><a rel="mw:WikiLink" href="./Template:Infocom_games" title="Template:Infocom games"><abbr title="View this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">v</abbr></a></li><li class="nv-talk"><a rel="mw:WikiLink" href="./Template_talk:Infocom_games" title="Template talk:Infocom games"><abbr title="Discuss this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">t</abbr></a></li><li class="nv-edit"><a rel="mw:ExtLink" href="//en.wikipedia.org/w/index.php?title=Template:Infocom_games&amp;action=edit"><abbr title="Edit this template" style=";;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;">e</abbr></a></li></ul></div><div id="Infocom" style="font-size:114%;margin:0 4em"><a rel="mw:WikiLink" href="./Infocom" title="Infocom">Infocom</a></div></th></tr><tr><th scope="row" class="navbox-group" style="width:1%"><i>Zork</i> series</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./Zork_I" title="Zork I">Zork I</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Zork_II" title="Zork II">Zork II</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Zork_III" title="Zork III">Zork III</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Beyond_Zork" title="Beyond Zork">Beyond Zork</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Zork_Zero" title="Zork Zero">Zork Zero</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Return_to_Zork" title="Return to Zork">Return to Zork</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Zork_Nemesis" title="Zork Nemesis">Zork Nemesis</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Zork:_Grand_Inquisitor" title="Zork: Grand Inquisitor">Zork: Grand Inquisitor</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Zork:_The_Undiscovered_Underground" title="Zork: The Undiscovered Underground">Zork: The Undiscovered Underground</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Legends_of_Zork" title="Legends of Zork">Legends of Zork</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Text adventures</th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./Arthur:_The_Quest_for_Excalibur" title="Arthur: The Quest for Excalibur">Arthur: The Quest for Excalibur</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Ballyhoo_(video_game)" title="Ballyhoo (video game)">Ballyhoo</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Border_Zone_(video_game)" title="Border Zone (video game)">Border Zone</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Bureaucracy_(video_game)" title="Bureaucracy (video game)">Bureaucracy</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Cutthroats" title="Cutthroats">Cutthroats</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Deadline_(video_game)" title="Deadline (video game)">Deadline</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Enchanter_(video_game)" title="Enchanter (video game)">Enchanter</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Hitchhiker's_Guide_to_the_Galaxy_(video_game)" title="The Hitchhiker's Guide to the Galaxy (video game)">The Hitchhiker's Guide to the Galaxy</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Hollywood_Hijinx" title="Hollywood Hijinx">Hollywood Hijinx</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Infidel_(video_game)" title="Infidel (video game)">Infidel</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Journey_(1989_video_game)" title="Journey (1989 video game)">Journey</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Leather_Goddesses_of_Phobos" title="Leather Goddesses of Phobos">Leather Goddesses of Phobos</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Lurking_Horror" title="The Lurking Horror">The Lurking Horror</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./A_Mind_Forever_Voyaging" title="A Mind Forever Voyaging">A Mind Forever Voyaging</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Moonmist" title="Moonmist">Moonmist</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Nord_and_Bert_Couldn't_Make_Head_or_Tail_of_It" title="Nord and Bert Couldn't Make Head or Tail of It">Nord and Bert Couldn't Make Head or Tail of It</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Planetfall" title="Planetfall">Planetfall</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Plundered_Hearts" title="Plundered Hearts">Plundered Hearts</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Seastalker" title="Seastalker">Seastalker</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Sherlock:_The_Riddle_of_the_Crown_Jewels" title="Sherlock: The Riddle of the Crown Jewels">Sherlock: The Riddle of the Crown Jewels</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./James_Clavell's_Shōgun" title="James Clavell's Shōgun">James Clavell's Shōgun</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Sorcerer_(video_game)" title="Sorcerer (video game)">Sorcerer</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Spellbreaker" title="Spellbreaker">Spellbreaker</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Starcross_(video_game)" title="Starcross (video game)">Starcross</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Stationfall" title="Stationfall">Stationfall</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Suspect_(video_game)" title="Suspect (video game)">Suspect</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Suspended" title="Suspended">Suspended</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Trinity_(video_game)" title="Trinity (video game)">Trinity</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Wishbringer" title="Wishbringer">Wishbringer</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./The_Witness_(1983_video_game)" title="The Witness (1983 video game)">The Witness</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Other titles</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <i><a rel="mw:WikiLink" href="./BattleTech:_The_Crescent_Hawk's_Inception" title="BattleTech: The Crescent Hawk's Inception">BattleTech: The Crescent Hawk's Inception</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./BattleTech:_The_Crescent_Hawk's_Revenge" title="BattleTech: The Crescent Hawk's Revenge">BattleTech: The Crescent Hawk's Revenge</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Circuit's_Edge" title="Circuit's Edge">Circuit's Edge</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Cornerstone_(software)" title="Cornerstone (software)">Cornerstone</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Fooblitzky" title="Fooblitzky">Fooblitzky</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Leather_Goddesses_of_Phobos_2:_Gas_Pump_Girls_Meet_the_Pulsating_Inconvenience_from_Planet_X!" title="Leather Goddesses of Phobos 2: Gas Pump Girls Meet the Pulsating Inconvenience from Planet X!">Leather Goddesses of Phobos 2</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Mines_of_Titan" title="Mines of Titan">Mines of Titan</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Quarterstaff:_The_Tomb_of_Setmoth" title="Quarterstaff: The Tomb of Setmoth">Quarterstaff: The Tomb of Setmoth</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Tombs_&amp;_Treasure" title="Tombs &amp; Treasure">Tombs &amp; Treasure</a></i></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%"><a rel="mw:WikiLink" href="./Implementer_(video_games)" title="Implementer (video games)">Implementers</a></th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <a rel="mw:WikiLink" href="./Tim_Anderson_(Zork)" title="Tim Anderson (Zork)" class="mw-redirect">Tim Anderson</a></li>
<li> <a rel="mw:WikiLink" href="./Bob_Bates" title="Bob Bates">Bob Bates</a></li>
<li> <a rel="mw:WikiLink" href="./Michael_Berlyn" title="Michael Berlyn">Michael Berlyn</a></li>
<li> <a rel="mw:WikiLink" href="./Marc_Blank" title="Marc Blank">Marc Blank</a></li>
<li> <a rel="mw:WikiLink" href="./Amy_Briggs" title="Amy Briggs">Amy Briggs</a></li>
<li> <a rel="mw:WikiLink" href="./Dave_Lebling" title="Dave Lebling">Dave Lebling</a></li>
<li> <a rel="mw:WikiLink" href="./Steve_Meretzky" title="Steve Meretzky">Steve Meretzky</a></li>
<li> <a rel="mw:WikiLink" href="./Brian_Moriarty" title="Brian Moriarty">Brian Moriarty</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Other people</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <a rel="mw:WikiLink" href="./Douglas_Adams" title="Douglas Adams">Douglas Adams</a></li>
<li> <a rel="mw:WikiLink" href="./Bruce_Daniels" title="Bruce Daniels">Bruce Daniels</a></li>
<li> <a rel="mw:WikiLink" href="./Albert_Vezza" title="Albert Vezza">Albert Vezza</a></li>
<li> <a rel="mw:WikiLink" href="./Joe_Ybarra" title="Joe Ybarra">Joe Ybarra</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Companies</th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <a rel="mw:WikiLink" href="./Infocom" title="Infocom">Infocom</a></li>
<li> <a rel="mw:WikiLink" href="./Activision" title="Activision">Activision</a></li>
<li> <a rel="mw:WikiLink" href="./Legend_Entertainment" title="Legend Entertainment">Legend Entertainment</a></li>
<li> <a rel="mw:WikiLink" href="./Westwood_Studios" title="Westwood Studios">Westwood Studios</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Miscellaneous</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li> <a rel="mw:WikiLink" href="./69105_(number)" title="69105 (number)">69,105</a></li>
<li> <i><a rel="mw:WikiLink" href="./Classic_Text_Adventure_Masterpieces_of_Infocom" title="Classic Text Adventure Masterpieces of Infocom">Classic Text Adventure Masterpieces of Infocom</a></i></li>
<li> <i><a rel="mw:WikiLink" href="./Get_Lamp" title="Get Lamp">Get Lamp</a></i></li>
<li> <a rel="mw:WikiLink" href="./Grue_(monster)" title="Grue (monster)">Grue</a></li>
<li> <a rel="mw:WikiLink" href="./Hello,_sailor" title="Hello, sailor">Hello, sailor</a></li>
<li> <a rel="mw:WikiLink" href="./InfoTaskForce" title="InfoTaskForce">InfoTaskForce</a></li>
<li> <a rel="mw:WikiLink" href="./InvisiClues" title="InvisiClues">InvisiClues</a></li>
<li> <i><a rel="mw:WikiLink" href="./The_Lost_Treasures_of_Infocom" title="The Lost Treasures of Infocom">The Lost Treasures of Infocom</a></i></li>
<li> <a rel="mw:WikiLink" href="./Z-machine" title="Z-machine">Z-machine</a></li>
<li> <a rel="mw:WikiLink" href="./Zork_books" title="Zork books">Zork books</a></li></ul>
</div></td></tr></tbody></table></div>

<div class="navbox" style="padding:3px" about="#mwt246" typeof="mw:Transclusion" data-mw='{"parts":[{"template":{"target":{"wt":"Authority control","href":"./Template:Authority_control"},"params":{},"i":0}}]}' id="mwA_4"><table class="nowraplinks hlist navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="row" class="navbox-group" style="width:1%"><a rel="mw:WikiLink" href="./Help:Authority_control" title="Help:Authority control">Authority control</a><link rel="mw:PageProp/Category" href="./Category:AC_with_17_elements"/></th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><span class="nowrap"> <a rel="mw:ExtLink" href="//www.worldcat.org/identities/containsVIAFID/113230702">WorldCat Identities</a></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./Virtual_International_Authority_File" title="Virtual International Authority File">VIAF</a>: <span class="uid"><a rel="mw:ExtLink" href="https://viaf.org/viaf/113230702">113230702</a><link rel="mw:PageProp/Category" href="./Category:Wikipedia_articles_with_VIAF_identifiers"/></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./Library_of_Congress_Control_Number" title="Library of Congress Control Number">LCCN</a>: <span class="uid"><a rel="mw:ExtLink" href="http://id.loc.gov/authorities/names/n80076765">n80076765</a><link rel="mw:PageProp/Category" href="./Category:Wikipedia_articles_with_LCCN_identifiers"/></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./International_Standard_Name_Identifier" title="International Standard Name Identifier">ISNI</a>: <span class="uid"><a rel="mw:ExtLink" href="http://isni.org/isni/0000000080456315">0000 0000 8045 6315</a><link rel="mw:PageProp/Category" href="./Category:Wikipedia_articles_with_ISNI_identifiers"/></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./Integrated_Authority_File" title="Integrated Authority File">GND</a>: <span class="uid"><a rel="mw:ExtLink" href="http://d-nb.info/gnd/119033364">119033364</a><link rel="mw:PageProp/Category" href="./Category:Wikipedia_articles_with_GND_identifiers"/></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./LIBRIS" title="LIBRIS">SELIBR</a>: <span class="uid"><a rel="mw:ExtLink" href="//libris.kb.se/auth/230807">230807</a><link rel="mw:PageProp/Category" href="./Category:Wikipedia_articles_with_SELIBR_identifiers"/></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./Système_universitaire_de_documentation" title="Système universitaire de documentation">SUDOC</a>: <span class="uid"><a rel="mw:ExtLink" href="https://www.idref.fr/026677636">026677636</a></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./Bibliothèque_nationale_de_France" title="Bibliothèque nationale de France">BNF</a>: <span class="uid"><a rel="mw:ExtLink" href="http://catalogue.bnf.fr/ark:/12148/cb11888092r">cb11888092r</a> <a rel="mw:ExtLink" href="http://data.bnf.fr/ark:/12148/cb11888092r">(data)</a><link rel="mw:PageProp/Category" href="./Category:Wikipedia_articles_with_BNF_identifiers"/></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./BIBSYS" title="BIBSYS" class="mw-redirect">BIBSYS</a>: <span class="uid"><a rel="mw:ExtLink" href="https://authority.bibsys.no/authority/rest/authorities/html/90196888">90196888</a><link rel="mw:PageProp/Category" href="./Category:Wikipedia_articles_with_BIBSYS_identifiers"/></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./MusicBrainz" title="MusicBrainz">MusicBrainz</a>: <span class="uid"><a rel="mw:ExtLink" href="//musicbrainz.org/artist/e9ed318d-8cc5-4cf8-ab77-505e39ab6ea4">e9ed318d-8cc5-4cf8-ab77-505e39ab6ea4</a><link rel="mw:PageProp/Category" href="./Category:Wikipedia_articles_with_MusicBrainz_identifiers"/></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./National_Library_of_Australia" title="National Library of Australia">NLA</a>: <span class="uid"><a rel="mw:ExtLink" href="//nla.gov.au/anbd.aut-an35163268">35163268</a><link rel="mw:PageProp/Category" href="./Category:Wikipedia_articles_with_NLA_identifiers"/></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./National_Diet_Library" title="National Diet Library">NDL</a>: <span class="uid"><a rel="mw:ExtLink" href="https://id.ndl.go.jp/auth/ndlna/00430962">00430962</a></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./National_Library_of_the_Czech_Republic" title="National Library of the Czech Republic">NKC</a>: <span class="uid"><a rel="mw:ExtLink" href="http://aleph.nkp.cz/F/?func=find-c&amp;local_base=aut&amp;ccl_term=ica=jn19990000029&amp;CON_LNG=ENG">jn19990000029</a></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./Istituto_Centrale_per_il_Catalogo_Unico" title="Istituto Centrale per il Catalogo Unico">ICCU</a>: <span class="uid"><a rel="mw:ExtLink" href="http://opac.sbn.it/opacsbn/opac/iccu/scheda_authority.jsp?bid=IT\ICCU\RAVV\034417">IT\ICCU\RAVV\034417</a><link rel="mw:PageProp/Category" href="./Category:Wikipedia_articles_with_SBN_identifiers"/></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./Russian_State_Library" title="Russian State Library">RLS</a>: <span class="uid"><a rel="mw:ExtLink" href="http://aleph.rsl.ru/F?func=find-b&amp;find_code=SYS&amp;adjacent=Y&amp;local_base=RSL11&amp;request=000002833&amp;CON_LNG=ENG">000002833</a></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./Biblioteca_Nacional_de_España" title="Biblioteca Nacional de España">BNE</a>: <span class="uid"><a rel="mw:ExtLink" href="http://catalogo.bne.es/uhtbin/authoritybrowse.cgi?action=display&amp;authority_id=XX1149955">XX1149955</a></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./CiNii" title="CiNii">CiNii</a>: <span class="uid"><a rel="mw:ExtLink" href="http://ci.nii.ac.jp/author/DA07517784?l=en">DA07517784</a></span></span></li>
<li><span class="nowrap"><a rel="mw:WikiLink" href="./Institute_for_Advanced_Technology_in_the_Humanities" title="Institute for Advanced Technology in the Humanities">IATH</a>: <span class="uid"><a rel="mw:ExtLink" href="http://socialarchive.iath.virginia.edu/ark:/99166/w65h7md1">w65h7md1</a><link rel="mw:PageProp/Category" href="./Category:Wikipedia_articles_with_SNAC-ID_identifiers"/></span></span></li></ul>

</div></td></tr></tbody></table></div>

<meta property="mw:PageProp/categorydefaultsort" content="Adams, Douglas" id="mwA_8"/>
<link rel="mw:PageProp/Category" href="./Category:Douglas_Adams#%20" id="mwBAA"/>
<link rel="mw:PageProp/Category" href="./Category:1952_births" id="mwBAE"/>
<link rel="mw:PageProp/Category" href="./Category:2001_deaths" id="mwBAI"/>
<link rel="mw:PageProp/Category" href="./Category:20th-century_atheists" id="mwBAM"/>
<link rel="mw:PageProp/Category" href="./Category:21st-century_atheists" id="mwBAQ"/>
<link rel="mw:PageProp/Category" href="./Category:Alumni_of_St_John's_College,_Cambridge" id="mwBAU"/>
<link rel="mw:PageProp/Category" href="./Category:British_atheism_activists" id="mwBAY"/>
<link rel="mw:PageProp/Category" href="./Category:Audio_book_narrators" id="mwBAc"/>
<link rel="mw:PageProp/Category" href="./Category:English_social_commentators" id="mwBAg"/>
<link rel="mw:PageProp/Category" href="./Category:BBC_radio_producers" id="mwBAk"/>
<link rel="mw:PageProp/Category" href="./Category:British_child_writers" id="mwBAo"/>
<link rel="mw:PageProp/Category" href="./Category:Burials_at_Highgate_Cemetery" id="mwBAs"/>
<link rel="mw:PageProp/Category" href="./Category:English_atheists" id="mwBAw"/>
<link rel="mw:PageProp/Category" href="./Category:English_comedy_writers" id="mwBA0"/>
<link rel="mw:PageProp/Category" href="./Category:English_humanists" id="mwBA4"/>
<link rel="mw:PageProp/Category" href="./Category:English_humorists" id="mwBA8"/>
<link rel="mw:PageProp/Category" href="./Category:English_radio_writers" id="mwBBA"/>
<link rel="mw:PageProp/Category" href="./Category:English_science_fiction_writers" id="mwBBE"/>
<link rel="mw:PageProp/Category" href="./Category:English_television_writers" id="mwBBI"/>
<link rel="mw:PageProp/Category" href="./Category:Infocom" id="mwBBM"/>
<link rel="mw:PageProp/Category" href="./Category:Interactive_fiction_writers" id="mwBBQ"/>
<link rel="mw:PageProp/Category" href="./Category:Monty_Python" id="mwBBU"/>
<link rel="mw:PageProp/Category" href="./Category:Non-fiction_environmental_writers" id="mwBBY"/>
<link rel="mw:PageProp/Category" href="./Category:People_educated_at_Brentwood_School_(Essex)" id="mwBBc"/>
<link rel="mw:PageProp/Category" href="./Category:People_from_Cambridge" id="mwBBg"/>
<link rel="mw:PageProp/Category" href="./Category:Usenet_people" id="mwBBk"/>
<link rel="mw:PageProp/Category" href="./Category:Critics_of_religions" id="mwBBo"/>
<link rel="mw:PageProp/Category" href="./Category:20th-century_English_novelists" id="mwBBs"/>
<link rel="mw:PageProp/Category" href="./Category:21st-century_British_novelists" id="mwBBw"/></body></html>"""

info = {'content-type': 'text/html', 'status': 200}
cache = {'query': query, 'response': response, 'info': info}
