# -*- coding:utf-8 -*-

query = 'https://en.wikipedia.org/w/api.php?action=parse&formatversion=2&contentmodel=text&disableeditsection=&disablelimitreport=&disabletoc=&prop=text|iwlinks|parsetree|wikitext|displaytitle|properties&redirects&page=Blue%20Train%20%28album%29'

response = r"""
{
    "parse": {
        "title": "Blue Train (album)",
        "pageid": 1315380,
        "redirects": [],
        "text": "<div class=\"mw-parser-output\"><table class=\"infobox vevent haudio\" style=\"width:22em\">\n<tr>\n<th colspan=\"2\" class=\"summary album\" style=\"text-align:center;font-size:125%;font-weight:bold;font-style: italic; background-color: lightsteelblue\">Blue Train</th>\n</tr>\n<tr>\n<td colspan=\"2\" style=\"text-align:center\"><a href=\"/wiki/File:John_Coltrane_-_Blue_Train.jpg\" class=\"image\" title=\"Coltrane leans back with a reed in his mouth in a deep blue-on-black photo. The words &quot;BLUE TRAIN&quot; are written above his head in white followed by &quot;john coltrane&quot; in orange.\"><img alt=\"Coltrane leans back with a reed in his mouth in a deep blue-on-black photo. The words &quot;BLUE TRAIN&quot; are written above his head in white followed by &quot;john coltrane&quot; in orange.\" src=\"//upload.wikimedia.org/wikipedia/en/thumb/6/68/John_Coltrane_-_Blue_Train.jpg/220px-John_Coltrane_-_Blue_Train.jpg\" width=\"220\" height=\"220\" srcset=\"//upload.wikimedia.org/wikipedia/en/6/68/John_Coltrane_-_Blue_Train.jpg 1.5x\" data-file-width=\"300\" data-file-height=\"300\" /></a></td>\n</tr>\n<tr>\n<th colspan=\"2\" class=\"description\" style=\"text-align:center;background-color: lightsteelblue\"><a href=\"/wiki/Album\" title=\"Album\">Studio album</a> by <span class=\"contributor\"><a href=\"/wiki/John_Coltrane\" title=\"John Coltrane\">John Coltrane</a></span></th>\n</tr>\n<tr>\n<th scope=\"row\">Released</th>\n<td class=\"published\">1958</td>\n</tr>\n<tr>\n<th scope=\"row\">Recorded</th>\n<td class=\"plainlist\">September 15, 1957</td>\n</tr>\n<tr>\n<th scope=\"row\">Studio</th>\n<td class=\"plainlist\"><a href=\"/wiki/Van_Gelder_Studio\" title=\"Van Gelder Studio\">Van Gelder Studio</a>, <a href=\"/wiki/Hackensack,_New_Jersey\" title=\"Hackensack, New Jersey\">Hackensack</a></td>\n</tr>\n<tr>\n<th scope=\"row\"><a href=\"/wiki/Music_genre\" title=\"Music genre\">Genre</a></th>\n<td class=\"category hlist\"><a href=\"/wiki/Hard_bop\" title=\"Hard bop\">Hard bop</a><sup id=\"cite_ref-FOOTNOTECook2004103_1-0\" class=\"reference\"><a href=\"#cite_note-FOOTNOTECook2004103-1\">[1]</a></sup></td>\n</tr>\n<tr>\n<th scope=\"row\">Length</th>\n<td><span class=\"duration\"><span class=\"min\">42</span>:<span class=\"s\">50</span></span></td>\n</tr>\n<tr>\n<th scope=\"row\"><a href=\"/wiki/Record_label\" title=\"Record label\">Label</a></th>\n<td class=\"hlist\"><a href=\"/wiki/Blue_Note_Records\" title=\"Blue Note Records\">Blue Note</a><br />\n<span style=\"font-size:85%;\">BLP 1577</span></td>\n</tr>\n<tr>\n<th scope=\"row\"><a href=\"/wiki/Record_producer\" title=\"Record producer\">Producer</a></th>\n<td class=\"hlist\"><a href=\"/wiki/Alfred_Lion\" title=\"Alfred Lion\">Alfred Lion</a></td>\n</tr>\n<tr>\n<th colspan=\"2\" class=\"description\" style=\"text-align:center;background-color: lightsteelblue\"><a href=\"/wiki/John_Coltrane\" title=\"John Coltrane\">John Coltrane</a> chronology</th>\n</tr>\n<tr>\n<td colspan=\"2\" style=\"text-align:center\">\n<table style=\"background: transparent; width: 100%; min-width: 100%; border-collapse: collapse\">\n<tr style=\"line-height: 1.4em;\">\n<td style=\"width: 33%; text-align: center; vertical-align: top; padding: .2em .1em .2em 0\"><i><a href=\"/wiki/Coltrane_(1957_album)\" title=\"Coltrane (1957 album)\">Coltrane</a></i><br />\n(1957)</td>\n<td style=\"width: 33%; text-align: center; vertical-align: top; padding: .2em .1em\"><i><b>Blue Train</b></i><br />\n(1958)</td>\n<td style=\"width: 33%; text-align: center; vertical-align: top; padding: .2em 0 .2em .1em\"><i><a href=\"/wiki/John_Coltrane_with_the_Red_Garland_Trio\" title=\"John Coltrane with the Red Garland Trio\">John Coltrane with the Red Garland Trio</a></i><br />\n(1958)</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<table class=\"wikitable floatright\" style=\"float:right;clear:right;width:24.2em;font-size:80%;text-align:center;margin:0.5em 0 0.5em 1em;padding:0;border-spacing:0\">\n<tr>\n<th scope=\"col\" colspan=\"2\" style=\"font-size:120%\">Professional ratings</th>\n</tr>\n<tr>\n<th scope=\"col\" colspan=\"2\" style=\"text-align:center;background:#d1dbdf;font-size:120%\">Review scores</th>\n</tr>\n<tr>\n<th scope=\"col\">Source</th>\n<th scope=\"col\">Rating</th>\n</tr>\n<tr>\n<td style=\"text-align:center;vertical-align:middle\"><a href=\"/wiki/AllMusic\" title=\"AllMusic\">AllMusic</a></td>\n<td style=\"text-align:center;vertical-align:middle\"><span style=\"white-space:nowrap\" title=\"5/5 stars\"><img alt=\"5/5 stars\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" title=\"5/5 stars\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /></span><sup id=\"cite_ref-2\" class=\"reference\"><a href=\"#cite_note-2\">[2]</a></sup></td>\n</tr>\n<tr>\n<td style=\"text-align:center;vertical-align:middle\"><i><a href=\"/wiki/The_Penguin_Guide_to_Jazz\" title=\"The Penguin Guide to Jazz\">The Penguin Guide to Jazz</a></i></td>\n<td style=\"text-align:center;vertical-align:middle\"><span style=\"white-space:nowrap\" title=\"4/4 stars\"><img alt=\"4/4 stars\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" title=\"4/4 stars\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /></span><sup id=\"cite_ref-Penguin_3-0\" class=\"reference\"><a href=\"#cite_note-Penguin-3\">[3]</a></sup></td>\n</tr>\n<tr>\n<td style=\"text-align:center;vertical-align:middle\"><i><a href=\"/wiki/The_Rolling_Stone_Jazz_Record_Guide\" class=\"mw-redirect\" title=\"The Rolling Stone Jazz Record Guide\">The Rolling Stone Jazz Record Guide</a></i></td>\n<td style=\"text-align:center;vertical-align:middle\"><span style=\"white-space:nowrap\" title=\"5/5 stars\"><img alt=\"5/5 stars\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" title=\"5/5 stars\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/11px-Star_full.svg.png\" width=\"11\" height=\"11\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/17px-Star_full.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/51/Star_full.svg/22px-Star_full.svg.png 2x\" data-file-width=\"108\" data-file-height=\"110\" /></span><sup id=\"cite_ref-RSJRG_4-0\" class=\"reference\"><a href=\"#cite_note-RSJRG-4\">[4]</a></sup></td>\n</tr>\n</table>\n<p><i><b>Blue Train</b></i> is a studio album by <a href=\"/wiki/John_Coltrane\" title=\"John Coltrane\">John Coltrane</a>, released in 1958 on <a href=\"/wiki/Blue_Note_Records\" title=\"Blue Note Records\">Blue Note Records</a>, catalogue BLP 1577. Recorded at the <a href=\"/wiki/Van_Gelder_Studio\" title=\"Van Gelder Studio\">Van Gelder Studio</a> in <a href=\"/wiki/Hackensack,_New_Jersey\" title=\"Hackensack, New Jersey\">Hackensack, New Jersey</a>, it is the only Blue Note recording by Coltrane as the leader on the session. It has been certified a <a href=\"/wiki/Music_recording_sales_certification\" class=\"mw-redirect\" title=\"Music recording sales certification\">gold record</a> by the <a href=\"/wiki/RIAA\" class=\"mw-redirect\" title=\"RIAA\">RIAA</a>.<sup id=\"cite_ref-5\" class=\"reference\"><a href=\"#cite_note-5\">[5]</a></sup></p>\n<p></p>\n<h2><span class=\"mw-headline\" id=\"Background\">Background</span></h2>\n<p>The album was recorded in the midst of Coltrane's residency at the <a href=\"/wiki/Five_Spot\" class=\"mw-redirect\" title=\"Five Spot\">Five Spot</a> as a member of the <a href=\"/wiki/Thelonious_Monk\" title=\"Thelonious Monk\">Thelonious Monk</a> quartet. The personnel include Coltrane's <a href=\"/wiki/Miles_Davis\" title=\"Miles Davis\">Miles Davis</a> bandmates, <a href=\"/wiki/Paul_Chambers\" title=\"Paul Chambers\">Paul Chambers</a> on bass and <a href=\"/wiki/Philly_Joe_Jones\" title=\"Philly Joe Jones\">Philly Joe Jones</a> on drums, both of whom had worked before with pianist <a href=\"/wiki/Kenny_Drew\" title=\"Kenny Drew\">Kenny Drew</a>. Both trumpeter <a href=\"/wiki/Lee_Morgan\" title=\"Lee Morgan\">Lee Morgan</a> and trombonist <a href=\"/wiki/Curtis_Fuller\" title=\"Curtis Fuller\">Curtis Fuller</a> were up-and-coming jazz musicians, and both would be members of <a href=\"/wiki/Art_Blakey\" title=\"Art Blakey\">Art Blakey</a>'s Jazz Messengers, working together on several of Blakey's albums.</p>\n<p>All of the compositions were written by Coltrane, with the exception of the <a href=\"/wiki/Pop_standard\" class=\"mw-redirect\" title=\"Pop standard\">standard</a> \"<a href=\"/wiki/I%27m_Old_Fashioned\" title=\"I'm Old Fashioned\">I'm Old Fashioned</a>\". The <a href=\"/wiki/Blue_Train_(composition)\" title=\"Blue Train (composition)\">title track</a> is a long, rhythmically variegated <a href=\"/wiki/Blues\" title=\"Blues\">blues</a> with a sentimental [quasi minor; in fact based on major chords with flat tenth, or raised ninth] theme that gradually shows the <a href=\"/wiki/Major_key\" class=\"mw-redirect\" title=\"Major key\">major</a> key during Coltrane's first chorus. \"Locomotion\" is also a blues riff tune, in forty-four-bar form.<sup id=\"cite_ref-6\" class=\"reference\"><a href=\"#cite_note-6\">[6]</a></sup> During a 1960 interview, Coltrane described <i>Blue Train</i> as his favorite album of his own up to that point.<sup id=\"cite_ref-FOOTNOTEPorter1999157_7-0\" class=\"reference\"><a href=\"#cite_note-FOOTNOTEPorter1999157-7\">[7]</a></sup></p>\n<h2><span class=\"mw-headline\" id=\"Legacy\">Legacy</span></h2>\n<p>John Coltrane's next major album, <i><a href=\"/wiki/Giant_Steps\" title=\"Giant Steps\">Giant Steps</a></i>, recorded in 1959, would break new melodic and harmonic ground in jazz, whereas <i>Blue Train</i> adheres to the <a href=\"/wiki/Hard_bop\" title=\"Hard bop\">hard bop</a> style of the era. Musicologist Lewis Porter has also demonstrated a harmonic relationship between Coltrane's \"Lazy Bird\" and <a href=\"/wiki/Tadd_Dameron\" title=\"Tadd Dameron\">Tadd Dameron</a>'s \"<a href=\"/wiki/Lady_Bird_(composition)\" title=\"Lady Bird (composition)\">Lady Bird</a>\".<sup id=\"cite_ref-FOOTNOTEPorter1999128-131_8-0\" class=\"reference\"><a href=\"#cite_note-FOOTNOTEPorter1999128-131-8\">[8]</a></sup></p>\n<p>In 1997, <i>The Ultimate Blue Train</i> was released, adding two alternate takes and <a href=\"/wiki/Enhanced_CD\" title=\"Enhanced CD\">enhanced content</a>, and in 1999 a <a href=\"/wiki/DVD-Audio\" title=\"DVD-Audio\">24bit 192&#160;kHz DVD-Audio</a> version was issued. In 2003, both a <a href=\"/wiki/Super_Audio_Compact_Disc\" class=\"mw-redirect\" title=\"Super Audio Compact Disc\">Super Audio Compact Disc</a> version was released, as well as a <a href=\"/wiki/Audio_mastering\" title=\"Audio mastering\">remastered</a> compact disc as part of Blue Note's <a href=\"/wiki/Rudy_Van_Gelder\" title=\"Rudy Van Gelder\">Rudy Van Gelder</a> series.</p>\n<p>In 2015, Blue Note/Universal released a <a href=\"/wiki/Blu-Ray_Audio\" class=\"mw-redirect\" title=\"Blu-Ray Audio\">Blu-Ray Audio</a> edition of the album with four bonus tracks, one of which is a previously unreleased take of \"Lazy Bird\".</p>\n<h2><span class=\"mw-headline\" id=\"Track_listing\">Track listing</span></h2>\n<h3><span class=\"mw-headline\" id=\"Side_one\">Side one</span></h3>\n<table class=\"tracklist\" style=\"display:block;border-spacing:0px;border-collapse:collapse;padding:4px\">\n<tr>\n<th class=\"tlheader\" scope=\"col\" style=\"width:2em;padding-left:10px;padding-right:10px;text-align:right;background-color:#eee\"><abbr title=\"Number\">No.</abbr></th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:60%;text-align:left;background-color:#eee\">Title</th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:40%;text-align:left;background-color:#eee\">Writer(s)</th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:4em;padding-right:10px;text-align:right;background-color:#eee\">Length</th>\n</tr>\n<tr style=\"background-color:#fff\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">1.</td>\n<td style=\"vertical-align:top\">\"<a href=\"/wiki/Blue_Train_(composition)\" title=\"Blue Train (composition)\">Blue Train</a>\"</td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">10:43</td>\n</tr>\n<tr style=\"background-color:#f7f7f7\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">2.</td>\n<td style=\"vertical-align:top\">\"<a href=\"/wiki/Moment%27s_Notice\" title=\"Moment's Notice\">Moment's Notice</a>\"</td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">9:10</td>\n</tr>\n</table>\n<h3><span class=\"mw-headline\" id=\"Side_two\">Side two</span></h3>\n<table class=\"tracklist\" style=\"display:block;border-spacing:0px;border-collapse:collapse;padding:4px\">\n<tr>\n<th class=\"tlheader\" scope=\"col\" style=\"width:2em;padding-left:10px;padding-right:10px;text-align:right;background-color:#eee\"><abbr title=\"Number\">No.</abbr></th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:60%;text-align:left;background-color:#eee\">Title</th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:40%;text-align:left;background-color:#eee\">Writer(s)</th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:4em;padding-right:10px;text-align:right;background-color:#eee\">Length</th>\n</tr>\n<tr style=\"background-color:#fff\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">1.</td>\n<td style=\"vertical-align:top\">\"Locomotion\"</td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">7:14</td>\n</tr>\n<tr style=\"background-color:#f7f7f7\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">2.</td>\n<td style=\"vertical-align:top\">\"<a href=\"/wiki/I%27m_Old_Fashioned\" title=\"I'm Old Fashioned\">I'm Old Fashioned</a>\"</td>\n<td style=\"vertical-align:top\"><a href=\"/wiki/Johnny_Mercer\" title=\"Johnny Mercer\">Johnny Mercer</a>, <a href=\"/wiki/Jerome_Kern\" title=\"Jerome Kern\">Jerome Kern</a></td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">7:58</td>\n</tr>\n<tr style=\"background-color:#fff\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">3.</td>\n<td style=\"vertical-align:top\">\"<a href=\"/wiki/Lazy_Bird\" title=\"Lazy Bird\">Lazy Bird</a>\"</td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">7:00</td>\n</tr>\n</table>\n<h3><span class=\"mw-headline\" id=\"1997_bonus_tracks\">1997 bonus tracks</span></h3>\n<table class=\"tracklist\" style=\"display:block;border-spacing:0px;border-collapse:collapse;padding:4px\">\n<tr>\n<th class=\"tlheader\" scope=\"col\" style=\"width:2em;padding-left:10px;padding-right:10px;text-align:right;background-color:#eee\"><abbr title=\"Number\">No.</abbr></th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:60%;text-align:left;background-color:#eee\">Title</th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:40%;text-align:left;background-color:#eee\">Writer(s)</th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:4em;padding-right:10px;text-align:right;background-color:#eee\">Length</th>\n</tr>\n<tr style=\"background-color:#fff\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">6.</td>\n<td style=\"vertical-align:top\">\"Blue Train\" <span style=\"font-size:85%\">(alternate take)</span></td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">9:58</td>\n</tr>\n<tr style=\"background-color:#f7f7f7\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">7.</td>\n<td style=\"vertical-align:top\">\"Lazy Bird\" <span style=\"font-size:85%\">(alternate take)</span></td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">7:12</td>\n</tr>\n</table>\n<h3><span id=\"2013_Blue_Note_SHM-CD_Remaster_Edition_.28Japan_Release.29\"></span><span class=\"mw-headline\" id=\"2013_Blue_Note_SHM-CD_Remaster_Edition_(Japan_Release)\">2013 Blue Note SHM-CD Remaster Edition (Japan Release)</span></h3>\n<table class=\"tracklist\" style=\"display:block;border-spacing:0px;border-collapse:collapse;padding:4px\">\n<tr>\n<th class=\"tlheader\" scope=\"col\" style=\"width:2em;padding-left:10px;padding-right:10px;text-align:right;background-color:#eee\"><abbr title=\"Number\">No.</abbr></th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:60%;text-align:left;background-color:#eee\">Title</th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:40%;text-align:left;background-color:#eee\">Writer(s)</th>\n<th class=\"tlheader\" scope=\"col\" style=\"width:4em;padding-right:10px;text-align:right;background-color:#eee\">Length</th>\n</tr>\n<tr style=\"background-color:#fff\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">1.</td>\n<td style=\"vertical-align:top\">\"<a href=\"/wiki/Blue_Train_(composition)\" title=\"Blue Train (composition)\">Blue Train</a>\"</td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">10:43</td>\n</tr>\n<tr style=\"background-color:#f7f7f7\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">2.</td>\n<td style=\"vertical-align:top\">\"<a href=\"/wiki/Moment%27s_Notice\" title=\"Moment's Notice\">Moment's Notice</a>\"</td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">9:10</td>\n</tr>\n<tr style=\"background-color:#fff\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">3.</td>\n<td style=\"vertical-align:top\">\"Locomotion\"</td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">7:14</td>\n</tr>\n<tr style=\"background-color:#f7f7f7\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">4.</td>\n<td style=\"vertical-align:top\">\"<a href=\"/wiki/I%27m_Old_Fashioned\" title=\"I'm Old Fashioned\">I'm Old Fashioned</a>\"</td>\n<td style=\"vertical-align:top\"><a href=\"/wiki/Johnny_Mercer\" title=\"Johnny Mercer\">Johnny Mercer</a>, <a href=\"/wiki/Jerome_Kern\" title=\"Jerome Kern\">Jerome Kern</a></td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">7:58</td>\n</tr>\n<tr style=\"background-color:#fff\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">5.</td>\n<td style=\"vertical-align:top\">\"<a href=\"/wiki/Lazy_Bird\" title=\"Lazy Bird\">Lazy Bird</a>\"</td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">7:00</td>\n</tr>\n<tr style=\"background-color:#f7f7f7\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">6.</td>\n<td style=\"vertical-align:top\">\"Blue Train\" <span style=\"font-size:85%\">(Alternate Take 1)</span></td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">7:12</td>\n</tr>\n<tr style=\"background-color:#fff\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">7.</td>\n<td style=\"vertical-align:top\">\"Blue Train\" <span style=\"font-size:85%\">(Alternate Take 2)</span></td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">9:58</td>\n</tr>\n<tr style=\"background-color:#f7f7f7\">\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">8.</td>\n<td style=\"vertical-align:top\">\"Lazy Bird\" <span style=\"font-size:85%\">(Alternate Take)</span></td>\n<td style=\"vertical-align:top\">John Coltrane</td>\n<td style=\"padding-right:10px;text-align:right;vertical-align:top\">7:12</td>\n</tr>\n</table>\n<h2><span class=\"mw-headline\" id=\"Personnel\">Personnel</span></h2>\n<ul>\n<li><a href=\"/wiki/John_Coltrane\" title=\"John Coltrane\">John Coltrane</a> – <a href=\"/wiki/Tenor_saxophone\" title=\"Tenor saxophone\">tenor saxophone</a></li>\n<li><a href=\"/wiki/Lee_Morgan\" title=\"Lee Morgan\">Lee Morgan</a> – <a href=\"/wiki/Trumpet\" title=\"Trumpet\">trumpet</a></li>\n<li><a href=\"/wiki/Curtis_Fuller\" title=\"Curtis Fuller\">Curtis Fuller</a> – <a href=\"/wiki/Trombone\" title=\"Trombone\">trombone</a></li>\n<li><a href=\"/wiki/Kenny_Drew\" title=\"Kenny Drew\">Kenny Drew</a> – <a href=\"/wiki/Piano\" title=\"Piano\">piano</a></li>\n<li><a href=\"/wiki/Paul_Chambers\" title=\"Paul Chambers\">Paul Chambers</a> – <a href=\"/wiki/Double_bass\" title=\"Double bass\">bass</a></li>\n<li><a href=\"/wiki/Philly_Joe_Jones\" title=\"Philly Joe Jones\">Philly Joe Jones</a> – <a href=\"/wiki/Drum_kit\" title=\"Drum kit\">drums</a></li>\n</ul>\n<h2><span class=\"mw-headline\" id=\"References\">References</span></h2>\n<div class=\"reflist\" style=\"list-style-type: decimal;\">\n<div class=\"mw-references-wrap\">\n<ol class=\"references\">\n<li id=\"cite_note-FOOTNOTECook2004103-1\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-FOOTNOTECook2004103_1-0\">^</a></b></span> <span class=\"reference-text\"><a href=\"#CITEREFCook2004\">Cook 2004</a>, p.&#160;103.</span></li>\n<li id=\"cite_note-2\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-2\">^</a></b></span> <span class=\"reference-text\"><a rel=\"nofollow\" class=\"external text\" href=\"https://www.allmusic.com/album/r136902\">Blue Train</a> at <a href=\"/wiki/AllMusic\" title=\"AllMusic\">AllMusic</a></span></li>\n<li id=\"cite_note-Penguin-3\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Penguin_3-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation book\"><a href=\"/wiki/Richard_Cook_(journalist)\" title=\"Richard Cook (journalist)\">Cook, Richard</a>; <a href=\"/wiki/Brian_Morton_(Scottish_writer)\" title=\"Brian Morton (Scottish writer)\">Morton, Brian</a> (2008). <i>The Penguin Guide to Jazz Recordings</i> (9th ed.). <a href=\"/wiki/Penguin_Books\" title=\"Penguin Books\">Penguin</a>. p.&#160;284. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/978-0-14-103401-0\" title=\"Special:BookSources/978-0-14-103401-0\">978-0-14-103401-0</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Penguin+Guide+to+Jazz+Recordings&amp;rft.pages=284&amp;rft.edition=9th&amp;rft.pub=Penguin&amp;rft.date=2008&amp;rft.isbn=978-0-14-103401-0&amp;rft.aulast=Cook&amp;rft.aufirst=Richard&amp;rft.au=Morton%2C+Brian&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABlue+Train+%28album%29\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-RSJRG-4\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-RSJRG_4-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation book\">Swenson, J. (Editor) (1985). <i>The Rolling Stone Jazz Record Guide</i>. USA: Random House/Rolling Stone. p.&#160;46. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/0-394-72643-X\" title=\"Special:BookSources/0-394-72643-X\">0-394-72643-X</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Rolling+Stone+Jazz+Record+Guide&amp;rft.place=USA&amp;rft.pages=46&amp;rft.pub=Random+House%2FRolling+Stone&amp;rft.date=1985&amp;rft.isbn=0-394-72643-X&amp;rft.aulast=Swenson&amp;rft.aufirst=J.+%28Editor%29&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABlue+Train+%28album%29\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span><span class=\"citation-comment\" style=\"display:none; color:#33aa33; margin-left:0.3em\">CS1 maint: Extra text: authors list (<a href=\"/wiki/Category:CS1_maint:_Extra_text:_authors_list\" title=\"Category:CS1 maint: Extra text: authors list\">link</a>)</span></span></li>\n<li id=\"cite_note-5\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-5\">^</a></b></span> <span class=\"reference-text\"><a rel=\"nofollow\" class=\"external text\" href=\"https://www.riaa.com/goldandplatinumdata.php?table=SEARCH\">RIAA Gold and Platinum Search retrieved August 2, 2011</a> <a rel=\"nofollow\" class=\"external text\" href=\"https://web.archive.org/web/20070626000000/http://www.riaa.com/goldandplatinumdata.php?table=SEARCH\">Archived</a> June 26, 2007, at the <a href=\"/wiki/Wayback_Machine\" title=\"Wayback Machine\">Wayback Machine</a>.</span></li>\n<li id=\"cite_note-6\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-6\">^</a></b></span> <span class=\"reference-text\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.jazzdisco.org/john-coltrane/catalog/album-index/\">Jazz Discography on-line</a></span></li>\n<li id=\"cite_note-FOOTNOTEPorter1999157-7\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-FOOTNOTEPorter1999157_7-0\">^</a></b></span> <span class=\"reference-text\"><a href=\"#CITEREFPorter1999\">Porter 1999</a>, p.&#160;157.</span></li>\n<li id=\"cite_note-FOOTNOTEPorter1999128-131-8\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-FOOTNOTEPorter1999128-131_8-0\">^</a></b></span> <span class=\"reference-text\"><a href=\"#CITEREFPorter1999\">Porter 1999</a>, pp.&#160;128-131.</span></li>\n</ol>\n</div>\n</div>\n<h2><span class=\"mw-headline\" id=\"Bibliography\">Bibliography</span></h2>\n<ul>\n<li><cite id=\"CITEREFCook2004\" class=\"citation book\"><a href=\"/wiki/Richard_Cook_(journalist)\" title=\"Richard Cook (journalist)\">Cook, Richard</a> (May 1, 2004). <i>Blue Note Records: The Biography</i>. <a href=\"/wiki/Justin,_Charles_%26_Co.\" title=\"Justin, Charles &amp; Co.\">Justin, Charles &amp; Co.</a> <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/1-932112-27-8\" title=\"Special:BookSources/1-932112-27-8\">1-932112-27-8</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Blue+Note+Records%3A+The+Biography&amp;rft.pub=Justin%2C+Charles+%26+Co.&amp;rft.date=2004-05-01&amp;rft.isbn=1-932112-27-8&amp;rft.aulast=Cook&amp;rft.aufirst=Richard&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABlue+Train+%28album%29\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></li>\n<li><cite id=\"CITEREFPorter1999\" class=\"citation book\"><a href=\"/wiki/Lewis_Porter\" title=\"Lewis Porter\">Porter, Lewis</a> (1999). <i>John Coltrane: His Life and Music</i>. <a href=\"/wiki/Ann_Arbor,_Michigan\" title=\"Ann Arbor, Michigan\">Ann Arbor</a>: <a href=\"/wiki/The_University_of_Michigan_Press\" class=\"mw-redirect\" title=\"The University of Michigan Press\">The University of Michigan Press</a>. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/0-472-10161-7\" title=\"Special:BookSources/0-472-10161-7\">0-472-10161-7</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=John+Coltrane%3A+His+Life+and+Music&amp;rft.place=Ann+Arbor&amp;rft.pub=The+University+of+Michigan+Press&amp;rft.date=1999&amp;rft.isbn=0-472-10161-7&amp;rft.aulast=Porter&amp;rft.aufirst=Lewis&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ABlue+Train+%28album%29\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></li>\n</ul>\n<h2><span class=\"mw-headline\" id=\"External_links\">External links</span></h2>\n<ul>\n<li><i><a rel=\"nofollow\" class=\"external text\" href=\"https://www.discogs.com/master/32208\">Blue Train</a></i> at <a href=\"/wiki/Discogs\" title=\"Discogs\">Discogs</a> (list of releases)</li>\n</ul>\n<div role=\"navigation\" class=\"navbox\" aria-labelledby=\"John_Coltrane\" style=\"padding:3px\">\n<table class=\"nowraplinks vcard hlist collapsible autocollapse navbox-inner\" style=\"border-spacing:0;background:transparent;color:inherit\">\n<tr>\n<th scope=\"col\" class=\"navbox-title\" colspan=\"2\" style=\"background: #f4bf92;\">\n<div class=\"plainlinks hlist navbar mini\">\n<ul>\n<li class=\"nv-view\"><a href=\"/wiki/Template:John_Coltrane\" title=\"Template:John Coltrane\"><abbr title=\"View this template\" style=\";background: #f4bf92;;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;\">v</abbr></a></li>\n<li class=\"nv-talk\"><a href=\"/wiki/Template_talk:John_Coltrane\" title=\"Template talk:John Coltrane\"><abbr title=\"Discuss this template\" style=\";background: #f4bf92;;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;\">t</abbr></a></li>\n<li class=\"nv-edit\"><a class=\"external text\" href=\"//en.wikipedia.org/w/index.php?title=Template:John_Coltrane&amp;action=edit\"><abbr title=\"Edit this template\" style=\";background: #f4bf92;;background:none transparent;border:none;-moz-box-shadow:none;-webkit-box-shadow:none;box-shadow:none;\">e</abbr></a></li>\n</ul>\n</div>\n<div id=\"John_Coltrane\" class=\"fn\" style=\"font-size:114%;margin:0 4em\"><a href=\"/wiki/John_Coltrane\" title=\"John Coltrane\">John Coltrane</a></div>\n</th>\n</tr>\n<tr>\n<td class=\"navbox-abovebelow\" colspan=\"2\" style=\"background: #EEEEEE;\">\n<div><a href=\"/wiki/John_Coltrane_discography\" title=\"John Coltrane discography\">Discography</a></div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\"><a href=\"/wiki/Prestige_Records\" title=\"Prestige Records\">Prestige</a> albums</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Bahia_(album)\" title=\"Bahia (album)\">Bahia</a></i></li>\n<li><i><a href=\"/wiki/The_Believer_(John_Coltrane_album)\" title=\"The Believer (John Coltrane album)\">The Believer</a></i></li>\n<li><i><a href=\"/wiki/Black_Pearls\" title=\"Black Pearls\">Black Pearls</a></i></li>\n<li><i><a href=\"/wiki/The_Cats_(album)\" title=\"The Cats (album)\">The Cats</a></i></li>\n<li><i><a href=\"/wiki/Cattin%27_with_Coltrane_and_Quinichette\" title=\"Cattin' with Coltrane and Quinichette\">Cattin' with Coltrane and Quinichette</a></i></li>\n<li><i><a href=\"/wiki/Coltrane_(1957_album)\" title=\"Coltrane (1957 album)\">Coltrane</a></i></li>\n<li><i><a href=\"/wiki/Dakar_(album)\" title=\"Dakar (album)\">Dakar</a></i></li>\n<li><i><a href=\"/wiki/Interplay_(John_Coltrane_album)\" class=\"mw-redirect\" title=\"Interplay (John Coltrane album)\">Interplay</a></i></li>\n<li><i><a href=\"/wiki/John_Coltrane_with_the_Red_Garland_Trio\" title=\"John Coltrane with the Red Garland Trio\">John Coltrane with the Red Garland Trio</a></i></li>\n<li><i><a href=\"/wiki/Kenny_Burrell_and_John_Coltrane\" class=\"mw-redirect\" title=\"Kenny Burrell and John Coltrane\">Kenny Burrell and John Coltrane</a></i></li>\n<li><i><a href=\"/wiki/The_Last_Trane\" title=\"The Last Trane\">The Last Trane</a></i></li>\n<li><i><a href=\"/wiki/Lush_Life_(John_Coltrane_album)\" title=\"Lush Life (John Coltrane album)\">Lush Life</a></i></li>\n<li><i><a href=\"/wiki/Settin%27_the_Pace\" title=\"Settin' the Pace\">Settin' the Pace</a></i></li>\n<li><i><a href=\"/wiki/Soultrane\" title=\"Soultrane\">Soultrane</a></i></li>\n<li><i><a href=\"/wiki/Standard_Coltrane_(album)\" class=\"mw-redirect\" title=\"Standard Coltrane (album)\">Standard Coltrane</a></i></li>\n<li><i><a href=\"/wiki/Stardust_(John_Coltrane_album)\" title=\"Stardust (John Coltrane album)\">Stardust</a></i></li>\n<li><i><a href=\"/wiki/Tenor_Conclave\" title=\"Tenor Conclave\">Tenor Conclave</a></i></li>\n<li><i><a href=\"/wiki/Two_Tenors\" title=\"Two Tenors\">Two Tenors</a></i></li>\n<li><i><a href=\"/wiki/Wheelin%27_%26_Dealin%27\" title=\"Wheelin' &amp; Dealin'\">Wheelin' and Dealin'</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\"><a href=\"/wiki/Blue_Note_Records\" title=\"Blue Note Records\">Blue Note</a> albums</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a class=\"mw-selflink selflink\">Blue Train</a></i></li>\n<li><i><a href=\"/wiki/Coltrane_Time\" class=\"mw-redirect\" title=\"Coltrane Time\">Coltrane Time</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\"><a href=\"/wiki/Atlantic_Records\" title=\"Atlantic Records\">Atlantic</a> albums</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Avant-Garde_(album)\" title=\"The Avant-Garde (album)\">The Avant-Garde</a></i></li>\n<li><i><a href=\"/wiki/Bags_%26_Trane\" title=\"Bags &amp; Trane\">Bags &amp; Trane</a></i></li>\n<li><i><a href=\"/wiki/Coltrane_Jazz\" title=\"Coltrane Jazz\">Coltrane Jazz</a></i></li>\n<li><i><a href=\"/wiki/Coltrane_Plays_the_Blues\" title=\"Coltrane Plays the Blues\">Coltrane Plays the Blues</a></i></li>\n<li><i><a href=\"/wiki/Coltrane%27s_Sound\" title=\"Coltrane's Sound\">Coltrane's Sound</a></i></li>\n<li><i><a href=\"/wiki/Giant_Steps\" title=\"Giant Steps\">Giant Steps</a></i></li>\n<li><i><a href=\"/wiki/My_Favorite_Things_(album)\" title=\"My Favorite Things (album)\">My Favorite Things</a></i></li>\n<li><i><a href=\"/wiki/Ol%C3%A9_Coltrane\" title=\"Olé Coltrane\">Olé Coltrane</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\"><a href=\"/wiki/Impulse!_Records\" title=\"Impulse! Records\">Impulse!</a> albums</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Africa/Brass\" title=\"Africa/Brass\">Africa/Brass</a></i></li>\n<li><i><a href=\"/wiki/Ascension_(John_Coltrane_album)\" title=\"Ascension (John Coltrane album)\">Ascension</a></i></li>\n<li><i><a href=\"/wiki/Ballads_(John_Coltrane_album)\" title=\"Ballads (John Coltrane album)\">Ballads</a></i></li>\n<li><i><a href=\"/wiki/Coltrane_(1962_album)\" title=\"Coltrane (1962 album)\">Coltrane</a></i></li>\n<li><i><a href=\"/wiki/Cosmic_Music\" title=\"Cosmic Music\">Cosmic Music</a></i></li>\n<li><i><a href=\"/wiki/Crescent_(John_Coltrane_album)\" title=\"Crescent (John Coltrane album)\">Crescent</a></i></li>\n<li><i><a href=\"/wiki/Duke_Ellington_%26_John_Coltrane\" title=\"Duke Ellington &amp; John Coltrane\">Duke Ellington &amp; John Coltrane</a></i></li>\n<li><i><a href=\"/wiki/Expression_(album)\" title=\"Expression (album)\">Expression</a></i></li>\n<li><i><a href=\"/wiki/First_Meditations_(for_quartet)\" title=\"First Meditations (for quartet)\">First Meditations</a></i></li>\n<li><i><a href=\"/wiki/Impressions_(John_Coltrane_album)\" title=\"Impressions (John Coltrane album)\">Impressions</a></i></li>\n<li><i><a href=\"/wiki/John_Coltrane:_Infinity\" class=\"mw-redirect\" title=\"John Coltrane: Infinity\">Infinity</a></i></li>\n<li><i><a href=\"/wiki/Interstellar_Space\" title=\"Interstellar Space\">Interstellar Space</a></i></li>\n<li><i><a href=\"/wiki/John_Coltrane_and_Johnny_Hartman\" title=\"John Coltrane and Johnny Hartman\">John Coltrane and Johnny Hartman</a></i></li>\n<li><i><a href=\"/wiki/The_John_Coltrane_Quartet_Plays\" title=\"The John Coltrane Quartet Plays\">The John Coltrane Quartet Plays</a></i></li>\n<li><i><a href=\"/wiki/Kulu_S%C3%A9_Mama\" title=\"Kulu Sé Mama\">Kulu Sé Mama</a></i></li>\n<li><i><a href=\"/wiki/A_Love_Supreme\" title=\"A Love Supreme\">A Love Supreme</a></i></li>\n<li><i><a href=\"/wiki/Meditations_(John_Coltrane_album)\" title=\"Meditations (John Coltrane album)\">Meditations</a></i></li>\n<li><i><a href=\"/wiki/Om_(John_Coltrane_album)\" title=\"Om (John Coltrane album)\">Om</a></i></li>\n<li><i><a href=\"/wiki/Selflessness:_Featuring_My_Favorite_Things\" title=\"Selflessness: Featuring My Favorite Things\">Selflessness: Featuring My Favorite Things</a></i></li>\n<li><i><a href=\"/wiki/Stellar_Regions\" title=\"Stellar Regions\">Stellar Regions</a></i></li>\n<li><i><a href=\"/wiki/Sun_Ship\" title=\"Sun Ship\">Sun Ship</a></i></li>\n<li><i><a href=\"/wiki/Transition_(John_Coltrane_album)\" title=\"Transition (John Coltrane album)\">Transition</a></i></li>\n<li><i><a href=\"/wiki/Infinity_(John_Coltrane_album)\" title=\"Infinity (John Coltrane album)\">Infinity</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\">With <a href=\"/wiki/Miles_Davis\" title=\"Miles Davis\">Miles Davis</a></th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Miles:_The_New_Miles_Davis_Quintet\" title=\"Miles: The New Miles Davis Quintet\">Miles: The New Miles Davis Quintet</a></i></li>\n<li><i><a href=\"/wiki/Basic_Miles\" class=\"mw-redirect\" title=\"Basic Miles\">Basic Miles</a></i></li>\n<li><i><a href=\"/wiki/%27Round_About_Midnight\" title=\"'Round About Midnight\">'Round About Midnight</a></i></li>\n<li><i><a href=\"/wiki/Workin%27_with_The_Miles_Davis_Quintet\" class=\"mw-redirect\" title=\"Workin' with The Miles Davis Quintet\">Workin' with The Miles Davis Quintet</a></i></li>\n<li><i><a href=\"/wiki/Steamin%27_with_The_Miles_Davis_Quintet\" class=\"mw-redirect\" title=\"Steamin' with The Miles Davis Quintet\">Steamin' with The Miles Davis Quintet</a></i></li>\n<li><i><a href=\"/wiki/Relaxin%27_with_The_Miles_Davis_Quintet\" class=\"mw-redirect\" title=\"Relaxin' with The Miles Davis Quintet\">Relaxin' with The Miles Davis Quintet</a></i></li>\n<li><i><a href=\"/wiki/Cookin%27_with_The_Miles_Davis_Quintet\" class=\"mw-redirect\" title=\"Cookin' with The Miles Davis Quintet\">Cookin' with The Miles Davis Quintet</a></i></li>\n<li><i><a href=\"/wiki/Miles_Davis_Quintet_at_Peacock_Alley\" title=\"Miles Davis Quintet at Peacock Alley\">Miles Davis Quintet at Peacock Alley</a></i></li>\n<li><i><a href=\"/wiki/Milestones_(Miles_Davis_album)\" title=\"Milestones (Miles Davis album)\">Milestones</a></i></li>\n<li><i><a href=\"/wiki/1958_Miles\" title=\"1958 Miles\">1958 Miles</a></i></li>\n<li><i><a href=\"/wiki/Miles_%26_Monk_at_Newport\" title=\"Miles &amp; Monk at Newport\">Miles &amp; Monk at Newport</a></i></li>\n<li><i><a href=\"/wiki/Kind_of_Blue\" title=\"Kind of Blue\">Kind of Blue</a></i></li>\n<li><i><a href=\"/wiki/Someday_My_Prince_Will_Come_(Miles_Davis_album)\" title=\"Someday My Prince Will Come (Miles Davis album)\">Someday My Prince Will Come</a></i></li>\n<li><i><a href=\"/wiki/Jazz_at_the_Plaza_Vol._I\" title=\"Jazz at the Plaza Vol. I\">Jazz at the Plaza Vol. I</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\">With <a href=\"/wiki/Ray_Draper\" title=\"Ray Draper\">Ray Draper</a></th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Ray_Draper_Quintet_featuring_John_Coltrane\" title=\"The Ray Draper Quintet featuring John Coltrane\">The Ray Draper Quintet featuring John Coltrane</a></i></li>\n<li><i><a href=\"/wiki/Like_Sonny\" title=\"Like Sonny\">A Tuba Jazz</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\">With <a href=\"/wiki/Wilbur_Harden\" title=\"Wilbur Harden\">Wilbur Harden</a></th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Mainstream_1958\" title=\"Mainstream 1958\">Mainstream 1958</a></i></li>\n<li><i><a href=\"/wiki/Jazz_Way_Out\" title=\"Jazz Way Out\">Jazz Way Out</a></i></li>\n<li><i><a href=\"/wiki/Tanganyika_Strut\" title=\"Tanganyika Strut\">Tanganyika Strut</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\">With <a href=\"/wiki/Thelonious_Monk\" title=\"Thelonious Monk\">Thelonious Monk</a></th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Complete_1957_Riverside_Recordings\" title=\"The Complete 1957 Riverside Recordings\">The Complete 1957 Riverside Recordings</a></i></li>\n<li><i><a href=\"/wiki/Thelonious_Himself\" title=\"Thelonious Himself\">Thelonious Himself</a></i></li>\n<li><i><a href=\"/wiki/Monk%27s_Music\" title=\"Monk's Music\">Monk's Music</a></i></li>\n<li><i><a href=\"/wiki/Thelonious_Monk_Quartet_with_John_Coltrane_at_Carnegie_Hall\" title=\"Thelonious Monk Quartet with John Coltrane at Carnegie Hall\">Thelonious Monk Quartet with John Coltrane at Carnegie Hall</a></i></li>\n<li><i><a href=\"/wiki/Thelonious_Monk_with_John_Coltrane\" title=\"Thelonious Monk with John Coltrane\">Thelonious Monk with John Coltrane</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\">Live albums</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Afro_Blue_Impressions\" title=\"Afro Blue Impressions\">Afro Blue Impressions</a></i></li>\n<li><i><a href=\"/wiki/Bye_Bye_Blackbird_(John_Coltrane_album)\" title=\"Bye Bye Blackbird (John Coltrane album)\">Bye Bye Blackbird</a></i></li>\n<li><i><a href=\"/wiki/The_European_Tour\" title=\"The European Tour\">The European Tour</a></i></li>\n<li><i><a href=\"/wiki/Live_at_Birdland_(John_Coltrane_album)\" title=\"Live at Birdland (John Coltrane album)\">Live at Birdland</a></i></li>\n<li><i><a href=\"/wiki/Live_at_the_Half_Note:_One_Down,_One_Up\" title=\"Live at the Half Note: One Down, One Up\">Live at the Half Note: One Down, One Up</a></i></li>\n<li><i><a href=\"/wiki/Live!_at_the_Village_Vanguard\" class=\"mw-redirect\" title=\"Live! at the Village Vanguard\">Live! at the Village Vanguard</a></i></li>\n<li><i><a href=\"/wiki/Live_at_the_Village_Vanguard_Again!\" title=\"Live at the Village Vanguard Again!\">Live at the Village Vanguard Again!</a></i></li>\n<li><i><a href=\"/wiki/The_Complete_1961_Village_Vanguard_Recordings\" title=\"The Complete 1961 Village Vanguard Recordings\">The Complete 1961 Village Vanguard Recordings</a></i></li>\n<li><i><a href=\"/wiki/Live_in_Japan_(John_Coltrane_album)\" title=\"Live in Japan (John Coltrane album)\">Live in Japan</a></i></li>\n<li><i><a href=\"/wiki/Live_in_Paris_(John_Coltrane_album)\" title=\"Live in Paris (John Coltrane album)\">Live in Paris</a></i></li>\n<li><i><a href=\"/wiki/Live_in_Seattle_(John_Coltrane_album)\" title=\"Live in Seattle (John Coltrane album)\">Live in Seattle</a></i></li>\n<li><i><a href=\"/wiki/Newport_%2763\" title=\"Newport '63\">Newport '63</a></i></li>\n<li><i><a href=\"/wiki/New_Thing_at_Newport\" title=\"New Thing at Newport\">New Thing at Newport</a></i></li>\n<li><i><a href=\"/wiki/The_Olatunji_Concert:_The_Last_Live_Recording\" title=\"The Olatunji Concert: The Last Live Recording\">The Olatunji Concert: The Last Live Recording</a></i></li>\n<li><i><a href=\"/wiki/The_Paris_Concert_(John_Coltrane_album)\" title=\"The Paris Concert (John Coltrane album)\">The Paris Concert</a></i></li>\n<li><i><a href=\"/wiki/Offering:_Live_at_Temple_University\" title=\"Offering: Live at Temple University\">Offering: Live at Temple University</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\">Compilations</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Alternate_Takes\" title=\"Alternate Takes\">Alternate Takes</a></i></li>\n<li><i><a href=\"/wiki/The_Best_of_John_Coltrane\" title=\"The Best of John Coltrane\">The Best of John Coltrane</a></i></li>\n<li><i><a href=\"/wiki/The_Classic_Quartet:_The_Complete_Impulse!_Recordings\" title=\"The Classic Quartet: The Complete Impulse! Recordings\">The Classic Quartet: The Complete Impulse! Recordings</a></i></li>\n<li><i><a href=\"/wiki/Coltrane_for_Lovers\" title=\"Coltrane for Lovers\">Coltrane for Lovers</a></i></li>\n<li><i><a href=\"/wiki/The_Coltrane_Legacy\" title=\"The Coltrane Legacy\">The Coltrane Legacy</a></i></li>\n<li><i><a href=\"/wiki/The_Complete_Columbia_Recordings_of_Miles_Davis_with_John_Coltrane\" title=\"The Complete Columbia Recordings of Miles Davis with John Coltrane\">The Complete Columbia Recordings of Miles Davis with John Coltrane</a></i></li>\n<li><i><a href=\"/wiki/The_Prestige_Recordings\" title=\"The Prestige Recordings\">The Prestige Recordings</a></i></li>\n<li><i><a href=\"/wiki/Countdown:_The_Savoy_Sessions\" title=\"Countdown: The Savoy Sessions\">Countdown: The Savoy Sessions</a></i></li>\n<li><i><a href=\"/wiki/Dial_Africa:_The_Savoy_Sessions\" title=\"Dial Africa: The Savoy Sessions\">Dial Africa: The Savoy Sessions</a></i></li>\n<li><i><a href=\"/wiki/The_Mastery_of_John_Coltrane,_Vol._1:_Feelin%27_Good\" title=\"The Mastery of John Coltrane, Vol. 1: Feelin' Good\">Feelin' Good</a></i></li>\n<li><i><a href=\"/wiki/Gleanings_(album)\" title=\"Gleanings (album)\">Gleanings</a></i></li>\n<li><i><a href=\"/wiki/Gold_Coast_(album)\" title=\"Gold Coast (album)\">Gold Coast</a></i></li>\n<li><i><a href=\"/wiki/The_Heavyweight_Champion:_The_Complete_Atlantic_Recordings\" title=\"The Heavyweight Champion: The Complete Atlantic Recordings\">The Heavyweight Champion: The Complete Atlantic Recordings</a></i></li>\n<li><i><a href=\"/wiki/High_Step\" title=\"High Step\">High Step</a></i></li>\n<li><i><a href=\"/wiki/The_Major_Works_of_John_Coltrane\" title=\"The Major Works of John Coltrane\">The Major Works of John Coltrane</a></i></li>\n<li><i><a href=\"/wiki/The_Mastery_of_John_Coltrane,_Vol._3:_Jupiter_Variation\" title=\"The Mastery of John Coltrane, Vol. 3: Jupiter Variation\">Jupiter Variation</a></i></li>\n<li><i><a href=\"/wiki/Ken_Burns_Jazz:_John_Coltrane\" title=\"Ken Burns Jazz: John Coltrane\">Ken Burns Jazz: John Coltrane</a></i></li>\n<li><i><a href=\"/wiki/The_Last_Giant:_Anthology\" title=\"The Last Giant: Anthology\">The Last Giant: Anthology</a></i></li>\n<li><i><a href=\"/wiki/Living_Space_(album)\" title=\"Living Space (album)\">Living Space</a></i></li>\n<li><i><a href=\"/wiki/To_the_Beat_of_a_Different_Drum\" class=\"mw-redirect\" title=\"To the Beat of a Different Drum\">To the Beat of a Different Drum</a></i></li>\n<li><i><a href=\"/wiki/Trane%27s_Blues\" title=\"Trane's Blues\">Trane's Blues</a></i></li>\n<li><i><a href=\"/wiki/The_Mastery_of_John_Coltrane,_Vol._4:_Trane%27s_Modes\" title=\"The Mastery of John Coltrane, Vol. 4: Trane's Modes\">Trane's Modes</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\">Compositions</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li>\"<a href=\"/wiki/26-2\" title=\"26-2\">26-2</a>\"</li>\n<li>\"<a href=\"/wiki/Alabama_(John_Coltrane_song)\" title=\"Alabama (John Coltrane song)\">Alabama</a>\"</li>\n<li>\"<a href=\"/wiki/Equinox_(standard)\" class=\"mw-redirect\" title=\"Equinox (standard)\">Equinox</a>\"</li>\n<li>\"<a href=\"/wiki/Giant_Steps_(composition)\" title=\"Giant Steps (composition)\">Giant Steps</a>\"</li>\n<li>\"<a href=\"/wiki/Impressions_(composition)\" class=\"mw-redirect\" title=\"Impressions (composition)\">Impressions</a>\"</li>\n<li>\"<a href=\"/wiki/Lazy_Bird\" title=\"Lazy Bird\">Lazy Bird</a>\"</li>\n<li>\"<a href=\"/wiki/Moment%27s_Notice\" title=\"Moment's Notice\">Moment's Notice</a>\"</li>\n<li>\"<a href=\"/wiki/Mr._P.C._(composition)\" title=\"Mr. P.C. (composition)\">Mr. P.C.</a>\"</li>\n<li>\"<a href=\"/wiki/Naima\" title=\"Naima\">Naima</a>\"</li>\n<li>\"<a href=\"/wiki/Ogunde_(song)\" title=\"Ogunde (song)\">Ogunde</a>\"</li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\">Documentaries</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Church_of_Saint_Coltrane\" title=\"The Church of Saint Coltrane\">The Church of Saint Coltrane</a></i></li>\n<li><i><a href=\"/wiki/The_World_According_to_John_Coltrane\" title=\"The World According to John Coltrane\">The World According to John Coltrane</a></i></li>\n<li><i><a href=\"/wiki/Trane_Tracks:_The_Legacy_of_John_Coltrane\" title=\"Trane Tracks: The Legacy of John Coltrane\">Trane Tracks: The Legacy of John Coltrane</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:1%;background: #EEEEEE;\">Related</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Coltrane_changes\" title=\"Coltrane changes\">Coltrane changes</a></li>\n<li><a href=\"/wiki/Sheets_of_sound\" title=\"Sheets of sound\">Sheets of sound</a></li>\n<li><a href=\"/wiki/Ravi_Coltrane\" title=\"Ravi Coltrane\">Ravi Coltrane</a></li>\n<li><a href=\"/wiki/Alice_Coltrane\" title=\"Alice Coltrane\">Alice Coltrane</a></li>\n<li><a href=\"/wiki/Flying_Lotus\" title=\"Flying Lotus\">Flying Lotus</a></li>\n<li><a href=\"/wiki/John_Coltrane_Home\" title=\"John Coltrane Home\">Dix Hills home</a></li>\n<li><a href=\"/wiki/John_Coltrane_House\" title=\"John Coltrane House\">Philadelphia house</a></li>\n<li><a href=\"/wiki/5893_Coltrane\" class=\"mw-redirect\" title=\"5893 Coltrane\">5893 Coltrane asteroid</a></li>\n<li><a href=\"/wiki/John_W._Coltrane_Cultural_Society\" class=\"mw-redirect\" title=\"John W. Coltrane Cultural Society\">John W. Coltrane Cultural Society</a></li>\n<li><i><a href=\"/wiki/Blues_for_Coltrane:_A_Tribute_to_John_Coltrane\" title=\"Blues for Coltrane: A Tribute to John Coltrane\">Blues for Coltrane: A Tribute to John Coltrane</a></i></li>\n<li><i><a href=\"/wiki/Before_John_Was_a_Jazz_Giant:_A_Song_of_John_Coltrane\" class=\"mw-redirect\" title=\"Before John Was a Jazz Giant: A Song of John Coltrane\">Before John Was a Jazz Giant: A Song of John Coltrane</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</div>\n\n</div>",
        "displaytitle": "<i>Blue Train</i> (album)",
        "iwlinks": [],
        "wikitext": "{{Infobox album\n| name       = Blue Train\n| type       = studio\n| artist     = [[John Coltrane]]\n| cover      = John Coltrane - Blue Train.jpg\n| alt        = Coltrane leans back with a reed in his mouth in a deep blue-on-black photo. The words \"BLUE TRAIN\" are written above his head in white followed by \"john coltrane\" in orange.\n| released   = 1958\n| recorded   = September 15, 1957\n| venue      =\n| studio     = [[Van Gelder Studio]], [[Hackensack, New Jersey|Hackensack]]\n| genre      = [[Hard bop]]{{sfn|Cook|2004|p=103}}\n| length     = {{Duration|m=42|s=50}}\n| label      = [[Blue Note Records|Blue Note]]<br />{{small|BLP 1577}}\n| producer   = [[Alfred Lion]]\n| prev_title = [[Coltrane (1957 album)|Coltrane]]\n| prev_year  = 1957\n| next_title = [[John Coltrane with the Red Garland Trio]]\n| next_year  = 1958\n}}\n{{Album ratings\n| rev1 = [[AllMusic]]\n| rev1Score = {{Rating|5|5}}<ref>{{AllMusic|class=album|id=r136902}}</ref>\n|rev2      = ''[[The Penguin Guide to Jazz]]''\n|rev2score = {{Rating|4|4}}<ref name=\"Penguin\">{{cite book|last1=Cook|first1=Richard|authorlink1=Richard Cook (journalist)|last2=Morton|first2=Brian|authorlink2=Brian Morton (Scottish writer)|year=2008|title=The Penguin Guide to Jazz Recordings|edition=9th|publisher=[[Penguin Books|Penguin]]|page=284|isbn=978-0-14-103401-0}}</ref>\n|rev3 = ''[[The Rolling Stone Jazz Record Guide]]''\n| rev3Score = {{rating|5|5}}<ref name=RSJRG>{{Cite book|last=Swenson|first=J. (Editor) | author-link =|year=1985|title=The Rolling Stone Jazz Record Guide|publisher=Random House/Rolling Stone|location=USA|isbn=0-394-72643-X|page=46}}</ref>\n}}\n\n'''''Blue Train''''' is a studio album by [[John Coltrane]], released in 1958 on [[Blue Note Records]], catalogue BLP 1577. Recorded at the [[Van Gelder Studio]] in [[Hackensack, New Jersey]], it is the only Blue Note recording by Coltrane as the leader on the session. It has been certified a [[Music recording sales certification|gold record]] by the [[RIAA]].<ref>[https://www.riaa.com/goldandplatinumdata.php?table=SEARCH RIAA Gold and Platinum Search retrieved August 2, 2011] {{webarchive |url=https://web.archive.org/web/20070626000000/http://www.riaa.com/goldandplatinumdata.php?table=SEARCH |date=June 26, 2007 }}</ref>\n\n==Background==\nThe album was recorded in the midst of Coltrane's residency at the [[Five Spot]] as a member of the [[Thelonious Monk]] quartet. The personnel include Coltrane's [[Miles Davis]] bandmates, [[Paul Chambers]] on bass and [[Philly Joe Jones]] on drums, both of whom had worked before with pianist [[Kenny Drew]]. Both trumpeter [[Lee Morgan]] and trombonist [[Curtis Fuller]] were up-and-coming jazz musicians, and both would be members of [[Art Blakey]]'s Jazz Messengers, working together on several of Blakey's albums.\n\nAll of the compositions were written by Coltrane, with the exception of the [[pop standard|standard]] \"[[I'm Old Fashioned]]\". The [[Blue Train (composition)|title track]] is a long, rhythmically variegated [[blues]] with a sentimental [quasi minor; in fact based on major chords with flat tenth, or raised ninth] theme that gradually shows the [[major key|major]] key during Coltrane's first chorus. \"Locomotion\" is also a blues riff tune, in forty-four-bar form.<ref>[http://www.jazzdisco.org/john-coltrane/catalog/album-index/ Jazz Discography on-line]</ref> During a 1960 interview, Coltrane described ''Blue Train'' as his favorite album of his own up to that point.{{sfn|Porter|1999|p=157}}\n\n==Legacy==\nJohn Coltrane's next major album, ''[[Giant Steps]]'', recorded in 1959, would break new melodic and harmonic ground in jazz, whereas ''Blue Train'' adheres to the [[hard bop]] style of the era. Musicologist Lewis Porter has also demonstrated a harmonic relationship between Coltrane's \"Lazy Bird\" and [[Tadd Dameron]]'s \"[[Lady Bird (composition)|Lady Bird]]\".{{sfn|Porter|1999|pp=128-131}}\n\nIn 1997, ''The Ultimate Blue Train'' was released, adding two alternate takes and [[Enhanced CD|enhanced content]], and in 1999 a [[DVD-Audio|24bit 192&nbsp;kHz DVD-Audio]] version was issued. In 2003, both a [[Super Audio Compact Disc]] version was released, as well as a [[Audio mastering|remastered]] compact disc as part of Blue Note's [[Rudy Van Gelder]] series.\n\nIn 2015, Blue Note/Universal released a [[Blu-Ray Audio]] edition of the album with four bonus tracks, one of which is a previously unreleased take of \"Lazy Bird\".\n\n==Track listing==\n===Side one===\n{{tracklist\n| title1          = [[Blue Train (composition)|Blue Train]]\n| writer1         = John Coltrane\n| length1         = 10:43\n| title2          = [[Moment's Notice]]\n| writer2         = John Coltrane\n| length2         = 9:10\n}}\n\n===Side two===\n{{tracklist\n| title1          = Locomotion\n| writer1         = John Coltrane\n| length1         = 7:14\n| title2          = [[I'm Old Fashioned]]\n| writer2         = [[Johnny Mercer]], [[Jerome Kern]]\n| length2         = 7:58\n| title3          = [[Lazy Bird]]\n| writer3         = John Coltrane\n| length3         = 7:00\n}}\n===1997 bonus tracks===\n{{tracklist\n| title6          = Blue Train\n| note6           = alternate take\n| writer6         = John Coltrane\n| length6         = 9:58\n| title7          = Lazy Bird\n| note7           = alternate take\n| writer7         = John Coltrane\n| length7         = 7:12\n}}\n\n===2013 Blue Note SHM-CD Remaster Edition (Japan Release)===\n{{tracklist\n| title1          = [[Blue Train (composition)|Blue Train]]\n| writer1         = John Coltrane\n| length1         = 10:43\n| title2          = [[Moment's Notice]]\n| writer2         = John Coltrane\n| length2         = 9:10\n| title3          = Locomotion\n| writer3         = John Coltrane\n| length3         = 7:14\n| title4          = [[I'm Old Fashioned]]\n| writer4         = [[Johnny Mercer]], [[Jerome Kern]]\n| length4         = 7:58\n| title5          = [[Lazy Bird]]\n| writer5         = John Coltrane\n| length5         = 7:00\n| title6          = Blue Train\n| note6           = Alternate Take 1\n| writer6         = John Coltrane\n| length6         = 7:12\n| title7          = Blue Train\n| note7           = Alternate Take 2\n| writer7         = John Coltrane\n| length7         = 9:58\n| title8          = Lazy Bird\n| note8           = Alternate Take\n| writer8         = John Coltrane\n| length8         = 7:12\n}}\n\n==Personnel==\n* [[John Coltrane]] – [[tenor saxophone]]\n* [[Lee Morgan]] – [[trumpet]]\n* [[Curtis Fuller]] – [[trombone]]\n* [[Kenny Drew]] – [[piano]]\n* [[Paul Chambers]] – [[double bass|bass]]\n* [[Philly Joe Jones]] – [[drum kit|drums]]\n\n==References==\n{{reflist}}\n\n==Bibliography==\n* {{cite book|ref=harv|last=Cook|first=Richard|authorlink=Richard Cook (journalist)|date=May 1, 2004|title=Blue Note Records: The Biography|publisher=[[Justin, Charles & Co.]]|isbn=1-932112-27-8}}\n* {{cite book|ref=harv|last=Porter|first=Lewis|authorlink=Lewis Porter|year=1999|title=John Coltrane: His Life and Music|publisher=[[The University of Michigan Press]]|location=[[Ann Arbor, Michigan|Ann Arbor]]|isbn=0-472-10161-7}}\n\n==External links==\n* {{Discogs master|type=album|32208|name=Blue Train}}\n\n{{John Coltrane}}\n\n{{DEFAULTSORT:Blue Train}}\n[[Category:1958 albums]]\n[[Category:Albums produced by Alfred Lion]]\n[[Category:Blue Note Records albums]]\n[[Category:Grammy Hall of Fame Award recipients]]\n[[Category:Hard bop albums]]\n[[Category:John Coltrane albums]]\n[[Category:Instrumental albums]]\n[[Category:Albums recorded at Van Gelder Studio]]",
        "properties": {
            "displaytitle": "<i>Blue Train</i> (album)",
            "defaultsort": "Blue Train",
            "wikibase_item": "Q258596"
        },
        "parsetree": "<root><template><title>Infobox album\n</title><part><name> name       </name><equals>=</equals><value> Blue Train\n</value></part><part><name> type       </name><equals>=</equals><value> studio\n</value></part><part><name> artist     </name><equals>=</equals><value> [[John Coltrane]]\n</value></part><part><name> cover      </name><equals>=</equals><value> John Coltrane - Blue Train.jpg\n</value></part><part><name> alt        </name><equals>=</equals><value> Coltrane leans back with a reed in his mouth in a deep blue-on-black photo. The words &quot;BLUE TRAIN&quot; are written above his head in white followed by &quot;john coltrane&quot; in orange.\n</value></part><part><name> released   </name><equals>=</equals><value> 1958\n</value></part><part><name> recorded   </name><equals>=</equals><value> September 15, 1957\n</value></part><part><name> venue      </name><equals>=</equals><value>\n</value></part><part><name> studio     </name><equals>=</equals><value> [[Van Gelder Studio]], [[Hackensack, New Jersey|Hackensack]]\n</value></part><part><name> genre      </name><equals>=</equals><value> [[Hard bop]]<template><title>sfn</title><part><name index=\"1\"/><value>Cook</value></part><part><name index=\"2\"/><value>2004</value></part><part><name>p</name><equals>=</equals><value>103</value></part></template>\n</value></part><part><name> length     </name><equals>=</equals><value> <template><title>Duration</title><part><name>m</name><equals>=</equals><value>42</value></part><part><name>s</name><equals>=</equals><value>50</value></part></template>\n</value></part><part><name> label      </name><equals>=</equals><value> [[Blue Note Records|Blue Note]]&lt;br /&gt;<template><title>small</title><part><name index=\"1\"/><value>BLP 1577</value></part></template>\n</value></part><part><name> producer   </name><equals>=</equals><value> [[Alfred Lion]]\n</value></part><part><name> prev_title </name><equals>=</equals><value> [[Coltrane (1957 album)|Coltrane]]\n</value></part><part><name> prev_year  </name><equals>=</equals><value> 1957\n</value></part><part><name> next_title </name><equals>=</equals><value> [[John Coltrane with the Red Garland Trio]]\n</value></part><part><name> next_year  </name><equals>=</equals><value> 1958\n</value></part></template>\n<template lineStart=\"1\"><title>Album ratings\n</title><part><name> rev1 </name><equals>=</equals><value> [[AllMusic]]\n</value></part><part><name> rev1Score </name><equals>=</equals><value> <template><title>Rating</title><part><name index=\"1\"/><value>5</value></part><part><name index=\"2\"/><value>5</value></part></template><ext><name>ref</name><attr/><inner>{{AllMusic|class=album|id=r136902}}</inner><close>&lt;/ref&gt;</close></ext>\n</value></part><part><name>rev2      </name><equals>=</equals><value> ''[[The Penguin Guide to Jazz]]''\n</value></part><part><name>rev2score </name><equals>=</equals><value> <template><title>Rating</title><part><name index=\"1\"/><value>4</value></part><part><name index=\"2\"/><value>4</value></part></template><ext><name>ref</name><attr> name=&quot;Penguin&quot;</attr><inner>{{cite book|last1=Cook|first1=Richard|authorlink1=Richard Cook (journalist)|last2=Morton|first2=Brian|authorlink2=Brian Morton (Scottish writer)|year=2008|title=The Penguin Guide to Jazz Recordings|edition=9th|publisher=[[Penguin Books|Penguin]]|page=284|isbn=978-0-14-103401-0}}</inner><close>&lt;/ref&gt;</close></ext>\n</value></part><part><name>rev3 </name><equals>=</equals><value> ''[[The Rolling Stone Jazz Record Guide]]''\n</value></part><part><name> rev3Score </name><equals>=</equals><value> <template><title>rating</title><part><name index=\"1\"/><value>5</value></part><part><name index=\"2\"/><value>5</value></part></template><ext><name>ref</name><attr> name=RSJRG</attr><inner>{{Cite book|last=Swenson|first=J. (Editor) | author-link =|year=1985|title=The Rolling Stone Jazz Record Guide|publisher=Random House/Rolling Stone|location=USA|isbn=0-394-72643-X|page=46}}</inner><close>&lt;/ref&gt;</close></ext>\n</value></part></template>\n\n'''''Blue Train''''' is a studio album by [[John Coltrane]], released in 1958 on [[Blue Note Records]], catalogue BLP 1577. Recorded at the [[Van Gelder Studio]] in [[Hackensack, New Jersey]], it is the only Blue Note recording by Coltrane as the leader on the session. It has been certified a [[Music recording sales certification|gold record]] by the [[RIAA]].<ext><name>ref</name><attr/><inner>[https://www.riaa.com/goldandplatinumdata.php?table=SEARCH RIAA Gold and Platinum Search retrieved August 2, 2011] {{webarchive |url=https://web.archive.org/web/20070626000000/http://www.riaa.com/goldandplatinumdata.php?table=SEARCH |date=June 26, 2007 }}</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"2\" i=\"1\">==Background==</h>\nThe album was recorded in the midst of Coltrane's residency at the [[Five Spot]] as a member of the [[Thelonious Monk]] quartet. The personnel include Coltrane's [[Miles Davis]] bandmates, [[Paul Chambers]] on bass and [[Philly Joe Jones]] on drums, both of whom had worked before with pianist [[Kenny Drew]]. Both trumpeter [[Lee Morgan]] and trombonist [[Curtis Fuller]] were up-and-coming jazz musicians, and both would be members of [[Art Blakey]]'s Jazz Messengers, working together on several of Blakey's albums.\n\nAll of the compositions were written by Coltrane, with the exception of the [[pop standard|standard]] &quot;[[I'm Old Fashioned]]&quot;. The [[Blue Train (composition)|title track]] is a long, rhythmically variegated [[blues]] with a sentimental [quasi minor; in fact based on major chords with flat tenth, or raised ninth] theme that gradually shows the [[major key|major]] key during Coltrane's first chorus. &quot;Locomotion&quot; is also a blues riff tune, in forty-four-bar form.<ext><name>ref</name><attr/><inner>[http://www.jazzdisco.org/john-coltrane/catalog/album-index/ Jazz Discography on-line]</inner><close>&lt;/ref&gt;</close></ext> During a 1960 interview, Coltrane described ''Blue Train'' as his favorite album of his own up to that point.<template><title>sfn</title><part><name index=\"1\"/><value>Porter</value></part><part><name index=\"2\"/><value>1999</value></part><part><name>p</name><equals>=</equals><value>157</value></part></template>\n\n<h level=\"2\" i=\"2\">==Legacy==</h>\nJohn Coltrane's next major album, ''[[Giant Steps]]'', recorded in 1959, would break new melodic and harmonic ground in jazz, whereas ''Blue Train'' adheres to the [[hard bop]] style of the era. Musicologist Lewis Porter has also demonstrated a harmonic relationship between Coltrane's &quot;Lazy Bird&quot; and [[Tadd Dameron]]'s &quot;[[Lady Bird (composition)|Lady Bird]]&quot;.<template><title>sfn</title><part><name index=\"1\"/><value>Porter</value></part><part><name index=\"2\"/><value>1999</value></part><part><name>pp</name><equals>=</equals><value>128-131</value></part></template>\n\nIn 1997, ''The Ultimate Blue Train'' was released, adding two alternate takes and [[Enhanced CD|enhanced content]], and in 1999 a [[DVD-Audio|24bit 192&amp;nbsp;kHz DVD-Audio]] version was issued. In 2003, both a [[Super Audio Compact Disc]] version was released, as well as a [[Audio mastering|remastered]] compact disc as part of Blue Note's [[Rudy Van Gelder]] series.\n\nIn 2015, Blue Note/Universal released a [[Blu-Ray Audio]] edition of the album with four bonus tracks, one of which is a previously unreleased take of &quot;Lazy Bird&quot;.\n\n<h level=\"2\" i=\"3\">==Track listing==</h>\n<h level=\"3\" i=\"4\">===Side one===</h>\n<template lineStart=\"1\"><title>tracklist\n</title><part><name> title1          </name><equals>=</equals><value> [[Blue Train (composition)|Blue Train]]\n</value></part><part><name> writer1         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length1         </name><equals>=</equals><value> 10:43\n</value></part><part><name> title2          </name><equals>=</equals><value> [[Moment's Notice]]\n</value></part><part><name> writer2         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length2         </name><equals>=</equals><value> 9:10\n</value></part></template>\n\n<h level=\"3\" i=\"5\">===Side two===</h>\n<template lineStart=\"1\"><title>tracklist\n</title><part><name> title1          </name><equals>=</equals><value> Locomotion\n</value></part><part><name> writer1         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length1         </name><equals>=</equals><value> 7:14\n</value></part><part><name> title2          </name><equals>=</equals><value> [[I'm Old Fashioned]]\n</value></part><part><name> writer2         </name><equals>=</equals><value> [[Johnny Mercer]], [[Jerome Kern]]\n</value></part><part><name> length2         </name><equals>=</equals><value> 7:58\n</value></part><part><name> title3          </name><equals>=</equals><value> [[Lazy Bird]]\n</value></part><part><name> writer3         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length3         </name><equals>=</equals><value> 7:00\n</value></part></template>\n<h level=\"3\" i=\"6\">===1997 bonus tracks===</h>\n<template lineStart=\"1\"><title>tracklist\n</title><part><name> title6          </name><equals>=</equals><value> Blue Train\n</value></part><part><name> note6           </name><equals>=</equals><value> alternate take\n</value></part><part><name> writer6         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length6         </name><equals>=</equals><value> 9:58\n</value></part><part><name> title7          </name><equals>=</equals><value> Lazy Bird\n</value></part><part><name> note7           </name><equals>=</equals><value> alternate take\n</value></part><part><name> writer7         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length7         </name><equals>=</equals><value> 7:12\n</value></part></template>\n\n<h level=\"3\" i=\"7\">===2013 Blue Note SHM-CD Remaster Edition (Japan Release)===</h>\n<template lineStart=\"1\"><title>tracklist\n</title><part><name> title1          </name><equals>=</equals><value> [[Blue Train (composition)|Blue Train]]\n</value></part><part><name> writer1         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length1         </name><equals>=</equals><value> 10:43\n</value></part><part><name> title2          </name><equals>=</equals><value> [[Moment's Notice]]\n</value></part><part><name> writer2         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length2         </name><equals>=</equals><value> 9:10\n</value></part><part><name> title3          </name><equals>=</equals><value> Locomotion\n</value></part><part><name> writer3         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length3         </name><equals>=</equals><value> 7:14\n</value></part><part><name> title4          </name><equals>=</equals><value> [[I'm Old Fashioned]]\n</value></part><part><name> writer4         </name><equals>=</equals><value> [[Johnny Mercer]], [[Jerome Kern]]\n</value></part><part><name> length4         </name><equals>=</equals><value> 7:58\n</value></part><part><name> title5          </name><equals>=</equals><value> [[Lazy Bird]]\n</value></part><part><name> writer5         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length5         </name><equals>=</equals><value> 7:00\n</value></part><part><name> title6          </name><equals>=</equals><value> Blue Train\n</value></part><part><name> note6           </name><equals>=</equals><value> Alternate Take 1\n</value></part><part><name> writer6         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length6         </name><equals>=</equals><value> 7:12\n</value></part><part><name> title7          </name><equals>=</equals><value> Blue Train\n</value></part><part><name> note7           </name><equals>=</equals><value> Alternate Take 2\n</value></part><part><name> writer7         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length7         </name><equals>=</equals><value> 9:58\n</value></part><part><name> title8          </name><equals>=</equals><value> Lazy Bird\n</value></part><part><name> note8           </name><equals>=</equals><value> Alternate Take\n</value></part><part><name> writer8         </name><equals>=</equals><value> John Coltrane\n</value></part><part><name> length8         </name><equals>=</equals><value> 7:12\n</value></part></template>\n\n<h level=\"2\" i=\"8\">==Personnel==</h>\n* [[John Coltrane]] – [[tenor saxophone]]\n* [[Lee Morgan]] – [[trumpet]]\n* [[Curtis Fuller]] – [[trombone]]\n* [[Kenny Drew]] – [[piano]]\n* [[Paul Chambers]] – [[double bass|bass]]\n* [[Philly Joe Jones]] – [[drum kit|drums]]\n\n<h level=\"2\" i=\"9\">==References==</h>\n<template lineStart=\"1\"><title>reflist</title></template>\n\n<h level=\"2\" i=\"10\">==Bibliography==</h>\n* <template><title>cite book</title><part><name>ref</name><equals>=</equals><value>harv</value></part><part><name>last</name><equals>=</equals><value>Cook</value></part><part><name>first</name><equals>=</equals><value>Richard</value></part><part><name>authorlink</name><equals>=</equals><value>Richard Cook (journalist)</value></part><part><name>date</name><equals>=</equals><value>May 1, 2004</value></part><part><name>title</name><equals>=</equals><value>Blue Note Records: The Biography</value></part><part><name>publisher</name><equals>=</equals><value>[[Justin, Charles &amp; Co.]]</value></part><part><name>isbn</name><equals>=</equals><value>1-932112-27-8</value></part></template>\n* <template><title>cite book</title><part><name>ref</name><equals>=</equals><value>harv</value></part><part><name>last</name><equals>=</equals><value>Porter</value></part><part><name>first</name><equals>=</equals><value>Lewis</value></part><part><name>authorlink</name><equals>=</equals><value>Lewis Porter</value></part><part><name>year</name><equals>=</equals><value>1999</value></part><part><name>title</name><equals>=</equals><value>John Coltrane: His Life and Music</value></part><part><name>publisher</name><equals>=</equals><value>[[The University of Michigan Press]]</value></part><part><name>location</name><equals>=</equals><value>[[Ann Arbor, Michigan|Ann Arbor]]</value></part><part><name>isbn</name><equals>=</equals><value>0-472-10161-7</value></part></template>\n\n<h level=\"2\" i=\"11\">==External links==</h>\n* <template><title>Discogs master</title><part><name>type</name><equals>=</equals><value>album</value></part><part><name index=\"1\"/><value>32208</value></part><part><name>name</name><equals>=</equals><value>Blue Train</value></part></template>\n\n<template lineStart=\"1\"><title>John Coltrane</title></template>\n\n<template lineStart=\"1\"><title>DEFAULTSORT:Blue Train</title></template>\n[[Category:1958 albums]]\n[[Category:Albums produced by Alfred Lion]]\n[[Category:Blue Note Records albums]]\n[[Category:Grammy Hall of Fame Award recipients]]\n[[Category:Hard bop albums]]\n[[Category:John Coltrane albums]]\n[[Category:Instrumental albums]]\n[[Category:Albums recorded at Van Gelder Studio]]</root>"
    }
}
"""

cache = {'info': {'status': 200}, 'query': query, 'response': response}
