# -*- coding:utf-8 -*-

query = 'https://fr.wikipedia.org/w/api.php?action=parse&formatversion=2&contentmodel=text&disableeditsection=&disablelimitreport=&disabletoc=&prop=text|iwlinks|parsetree|wikitext|displaytitle|properties&redirects&page=Okapi'

response = r"""{"parse":{"title":"Okapi","pageid":26145,"redirects":[],"text":"<div class=\"mw-parser-output\"><p><span id=\"sous_titre_h1\"><i>Okapia johnstoni</i></span></p>\n<div class=\"homonymie\"><a href=\"/wiki/Aide:Homonymie\" title=\"Aide:Homonymie\"><img alt=\"Page d'aide sur l'homonymie\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/3/3e/Disambig_colour.svg/20px-Disambig_colour.svg.png\" width=\"20\" height=\"15\" class=\"noviewer\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/3/3e/Disambig_colour.svg/30px-Disambig_colour.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/3/3e/Disambig_colour.svg/40px-Disambig_colour.svg.png 2x\" data-file-width=\"272\" data-file-height=\"200\" /></a> Pour les articles homonymes, voir <a href=\"/wiki/Okapi_(homonymie)\" class=\"mw-disambig\" title=\"Okapi (homonymie)\">Okapi (homonymie)</a>.</div>\n<div class=\"bandeau-article bandeau-niveau-modere plainlinks metadata\">\n<div class=\"floatright\"><a href=\"/wiki/Aide:Liste_de_bandeaux_de_maintenance_d%27articles\" title=\"Si ce bandeau n'est plus pertinent, retirez-le. Cliquez pour voir d'autres modèles.\"><img alt=\"Si ce bandeau n'est plus pertinent, retirez-le. Cliquez pour voir d'autres modèles.\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/3/38/Info_Simple.svg/12px-Info_Simple.svg.png\" width=\"12\" height=\"12\" class=\"noviewer\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/3/38/Info_Simple.svg/18px-Info_Simple.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/3/38/Info_Simple.svg/24px-Info_Simple.svg.png 2x\" data-file-width=\"512\" data-file-height=\"512\" /></a></div>\n<div class=\"bandeau-cell bandeau-icone\"><a href=\"/wiki/Fichier:Question_book-4.svg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/6/64/Question_book-4.svg/45px-Question_book-4.svg.png\" width=\"45\" height=\"35\" class=\"noviewer\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/6/64/Question_book-4.svg/68px-Question_book-4.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/64/Question_book-4.svg/90px-Question_book-4.svg.png 2x\" data-file-width=\"262\" data-file-height=\"204\" /></a></div>\n<div class=\"bandeau-cell\"><strong class=\"bandeau-titre\">Des informations de cet article ou de cette section devraient être mieux reliées aux sources mentionnées dans les sections «&#160;Bibliographie&#160;», «&#160;Sources&#160;» ou «&#160;Liens externes&#160;»</strong> <small>(juin 2015).</small>\n<p>Améliorez sa <a href=\"/wiki/Wikip%C3%A9dia:V%C3%A9rifiabilit%C3%A9\" title=\"Wikipédia:Vérifiabilité\">vérifiabilité</a> en les <a href=\"/wiki/Mod%C3%A8le:Sources_%C3%A0_lier/Explication\" title=\"Modèle:Sources à lier/Explication\">associant par des références</a> à l'aide d'<a href=\"/wiki/Aide:Note\" title=\"Aide:Note\">appels de notes</a>.</p>\n</div>\n</div>\n<div class=\"infobox_v3 large taxobox_v3 zoologie animal bordered\" style=\"width:20em\">\n<div class=\"entete\" style=\"\">\n<div><i>Okapia johnstoni</i></div>\n</div>\n<div class=\"images\"><a href=\"/wiki/Fichier:Okapi2.jpg\" class=\"image\" title=\"Okapi\"><img alt=\"Description de cette image, également commentée ci-après\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/1/18/Okapi2.jpg/290px-Okapi2.jpg\" width=\"290\" height=\"252\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/1/18/Okapi2.jpg/435px-Okapi2.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/1/18/Okapi2.jpg/580px-Okapi2.jpg 2x\" data-file-width=\"1707\" data-file-height=\"1482\" /></a></div>\n<div class=\"legend\">Okapi</div>\n<table class=\"taxobox_classification\">\n<caption><a href=\"/wiki/Classification_scientifique_des_esp%C3%A8ces\" title=\"Classification scientifique des espèces\">Classification</a></caption>\n<tr>\n<th scope=\"row\" style=\"width:8em;\"><a href=\"/wiki/R%C3%A8gne_(biologie)\" title=\"Règne (biologie)\">Règne</a></th>\n<td><span class=\"normal\"><a href=\"/wiki/Animal\" title=\"Animal\">Animalia</a></span></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"width:8em;\"><a href=\"/wiki/Embranchement_(biologie)\" title=\"Embranchement (biologie)\">Embranchement</a></th>\n<td><span class=\"normal\"><a href=\"/wiki/Chordata\" title=\"Chordata\">Chordata</a></span></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"width:8em;\"><a href=\"/wiki/Classe_(biologie)\" title=\"Classe (biologie)\">Classe</a></th>\n<td><span class=\"normal\"><a href=\"/wiki/Mammalia\" class=\"mw-redirect\" title=\"Mammalia\">Mammalia</a></span></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"width:8em;\"><a href=\"/wiki/Sous-classe_(biologie)\" title=\"Sous-classe (biologie)\">Sous-classe</a></th>\n<td><span class=\"normal\"><a href=\"/wiki/Theria\" title=\"Theria\">Theria</a></span></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"width:8em;\"><a href=\"/wiki/Ordre_(biologie)\" title=\"Ordre (biologie)\">Ordre</a></th>\n<td><span class=\"normal\"><a href=\"/wiki/Artiodactyla\" title=\"Artiodactyla\">Artiodactyla</a></span></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"width:8em;\"><a href=\"/wiki/Famille_(biologie)\" title=\"Famille (biologie)\">Famille</a></th>\n<td><span class=\"normal\"><a href=\"/wiki/Giraffidae\" title=\"Giraffidae\">Giraffidae</a></span></td>\n</tr>\n</table>\n<p class=\"bloc\"><a href=\"/wiki/Genre_(biologie)\" title=\"Genre (biologie)\">Genre</a></p>\n<div class=\"center taxobox_classification\"><b><span style=\"font-style: normal\"><i>Okapia</i></span></b><br />\n<span class=\"rnormal\"><small><b><a href=\"/wiki/Edwin_Ray_Lankester\" title=\"Edwin Ray Lankester\">Lankester</a>, <a href=\"/wiki/1901\" title=\"1901\">1901</a></b></small></span></div>\n<p class=\"bloc\"><a href=\"/wiki/Nom_binominal\" title=\"Nom binominal\">Nom binominal</a></p>\n<div class=\"center taxobox_classification\"><b><span style=\"font-style: normal\"><i>Okapia johnstoni</i></span></b><br />\n<span class=\"rnormal\"><small><b>(<a href=\"/wiki/Philip_Lutley_Sclater\" title=\"Philip Lutley Sclater\">Sclater</a>, <a href=\"/wiki/1901\" title=\"1901\">1901</a>)</b></small></span></div>\n<p class=\"bloc\"><a href=\"/wiki/Synonyme_(taxinomie)\" title=\"Synonyme (taxinomie)\">Synonymes</a></p>\n<ul>\n<li><i>Equus johnstoni</i> <small>P.L. Sclater, 1901</small></li>\n</ul>\n<p class=\"bloc\"><a href=\"/wiki/Statut_de_conservation\" title=\"Statut de conservation\">Statut de conservation</a> <a href=\"/wiki/Union_internationale_pour_la_conservation_de_la_nature\" title=\"Union internationale pour la conservation de la nature\">UICN</a></p>\n<p class=\"center\"><img alt=\"( EN )\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/d/df/Status_iucn3.1_EN-fr.svg/244px-Status_iucn3.1_EN-fr.svg.png\" width=\"244\" height=\"65\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/d/df/Status_iucn3.1_EN-fr.svg/366px-Status_iucn3.1_EN-fr.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/d/df/Status_iucn3.1_EN-fr.svg/488px-Status_iucn3.1_EN-fr.svg.png 2x\" data-file-width=\"240\" data-file-height=\"64\" /><br />\n<b>EN</b> A2abcd+4abcd&#160;: <b>En danger</b></p>\n<p class=\"bloc\">Répartition géographique</p>\n<div class=\"images\"><a href=\"/wiki/Fichier:Okapi_map.jpg\" class=\"image\"><img alt=\"Description de l'image Okapi map.jpg.\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/7/7f/Okapi_map.jpg/290px-Okapi_map.jpg\" width=\"290\" height=\"140\" srcset=\"//upload.wikimedia.org/wikipedia/commons/7/7f/Okapi_map.jpg 1.5x\" data-file-width=\"347\" data-file-height=\"167\" /></a></div>\n<p class=\"bloc\">Répartition géographique</p>\n<div class=\"images\"><a href=\"/wiki/Fichier:Okapi_distribution.PNG\" class=\"image\"><img alt=\"Description de l'image Okapi distribution.PNG.\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/6/6a/Okapi_distribution.PNG/290px-Okapi_distribution.PNG\" width=\"290\" height=\"365\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/6/6a/Okapi_distribution.PNG/435px-Okapi_distribution.PNG 1.5x, //upload.wikimedia.org/wikipedia/commons/6/6a/Okapi_distribution.PNG 2x\" data-file-width=\"477\" data-file-height=\"601\" /></a></div>\n</div>\n<p>L’<b>okapi</b> (<i><b>Okapia johnstoni</b></i>), aussi connu sous le nom de <b>Mondonga</b>, est une <a href=\"/wiki/Esp%C3%A8ce\" title=\"Espèce\">espèce</a> de <a href=\"/wiki/Mammif%C3%A8re\" title=\"Mammifère\">mammifères</a> <a href=\"/wiki/Ruminant\" class=\"mw-redirect\" title=\"Ruminant\">ruminants</a> de la même <a href=\"/wiki/Famille_(biologie)\" title=\"Famille (biologie)\">famille</a> que la <a href=\"/wiki/Girafe\" title=\"Girafe\">girafe</a>, venant des forêts équatoriales de l'<a href=\"/wiki/Afrique_centrale\" title=\"Afrique centrale\">Afrique centrale</a>. Bien que connu par les <a href=\"/wiki/Pygm%C3%A9e\" title=\"Pygmée\">Pygmées</a>, il est «&#160;<a href=\"/wiki/D%C3%A9couverte_scientifique\" title=\"Découverte scientifique\">découvert</a>&#160;» en <a href=\"/wiki/1901\" title=\"1901\">1901</a> par Sir <a href=\"/wiki/Harry_Johnston\" title=\"Harry Johnston\">Harry Johnston</a> à qui il doit son nom. C’est l'un des derniers grands <a href=\"/wiki/Mammif%C3%A8re\" title=\"Mammifère\">mammifères</a> à être observé scientifiquement sur la planète.</p>\n<p>Cet animal dont l’allure rappelle à la fois celle du <a href=\"/wiki/Z%C3%A8bre\" title=\"Zèbre\">zèbre</a> et de la <a href=\"/wiki/Girafe\" title=\"Girafe\">girafe</a> vit exclusivement dans une petite région au nord-est de la <a href=\"/wiki/R%C3%A9publique_d%C3%A9mocratique_du_Congo\" title=\"République démocratique du Congo\">République démocratique du Congo</a>, la <a href=\"/wiki/For%C3%AAt_de_l%27Ituri\" title=\"Forêt de l'Ituri\">forêt tropicale de l’Ituri</a>, où une réserve lui est spécialement dédiée. Son nom vernaculaire en <a href=\"/wiki/Lingala\" title=\"Lingala\">lingala</a> est <i>mondonga</i>.</p>\n<p><span class=\"need_ref\" style=\"cursor:help;\" title=\"Ce passage nécessite une référence.\">Cet animal ne vit pas exclusivement en RD Congo. Il a été aussi observé dans les forêts du sud-est du Gabon, à la frontière avec le Congo-Brazzaville. Il a entre autre été vu par des chasseurs français en 1983 sur la piste reliant Boumango à Mbinda</span><sup class=\"need_ref_tag\" style=\"padding-left:2px;\"><a href=\"/wiki/Aide:R%C3%A9f%C3%A9rence_n%C3%A9cessaire\" title=\"Aide:Référence nécessaire\">[réf.&#160;nécessaire]</a></sup>.</p>\n<p></p>\n<h2><span id=\"Caract.C3.A9ristiques_physiques\"></span><span class=\"mw-headline\" id=\"Caractéristiques_physiques\">Caractéristiques physiques</span></h2>\n<p>L’okapi mesure environ <span class=\"nowrap\">1,80 <abbr class=\"abbr\" title=\"mètre\">m</abbr></span> au <a href=\"/wiki/Garrot_(anatomie)\" title=\"Garrot (anatomie)\">garrot</a> et pèse au maximum <span class=\"nowrap\">200 à 230 <abbr class=\"abbr\" title=\"kilogramme\">kg</abbr></span>. Sa <a href=\"/wiki/Morphologie_(biologie)\" title=\"Morphologie (biologie)\">morphologie</a> est relativement proche de celle de la <a href=\"/wiki/Girafe\" title=\"Girafe\">girafe</a>&#160;: son corps est court et massif, ses pattes arrières sont plus courtes que celles de devant (ce qui lui donne l'allure d'avoir la croupe plus basse que les épaules) et sa colonne vertébrale a un axe oblique. Toutefois son cou est moins long et plus épais que celui de la girafe. Le mâle porte des <a href=\"/wiki/Ossic%C3%B4ne\" title=\"Ossicône\">ossicônes</a>, sortes de petites cornes osseuses recouvertes de peau qui se développent entre 1 et 5 ans. Ses oreilles sont larges et particulièrement mobiles. Sa langue <a href=\"/wiki/Pr%C3%A9hensile\" class=\"mw-redirect\" title=\"Préhensile\">préhensile</a> est noire et mesure entre <span class=\"nowrap\">30 et 50 <abbr class=\"abbr\" title=\"centimètre\">cm</abbr></span> de long&#160;: avec elle, il peut saisir sa nourriture mais aussi nettoyer toutes les parties de son corps, y compris ses oreilles.</p>\n<p>Son pelage court est d’un brun chocolat sur le corps avec des zébrures noires et blanches sur les pattes et l’arrière-train. La tête est marquée d’une tache blanche au niveau de la joue.</p>\n<h2><span class=\"mw-headline\" id=\"Histoire\">Histoire</span></h2>\n<p>Les <a href=\"/wiki/Pygm%C3%A9e\" title=\"Pygmée\">pygmées</a> de l’actuelle <a href=\"/wiki/R%C3%A9publique_d%C3%A9mocratique_du_Congo\" title=\"République démocratique du Congo\">République démocratique du Congo</a> connaissaient depuis longtemps l’okapi qu’ils prenaient parfois au piège dans des trous camouflés. Ils l’appelaient <i>o’api</i>. En 1890, le journaliste <a href=\"/wiki/Henry_Morton_Stanley\" title=\"Henry Morton Stanley\">Henry Morton Stanley</a> (1841-1904) venu à la rencontre des pygmées rapporte l’existence d’une sorte d’âne-zèbre broutant des feuilles. Sir <a href=\"/wiki/Harry_Hamilton_Johnston\" class=\"mw-redirect\" title=\"Harry Hamilton Johnston\">Harry Hamilton Johnston</a> (1858-1927), futur gouverneur de l’<a href=\"/wiki/Ouganda\" title=\"Ouganda\">Ouganda</a>, curieux de cet animal étrange, partit en 1899 à sa recherche et le baptisa <i>Equus johnstoni</i>, pensant qu’il s’agissait d’une nouvelle espèce de <a href=\"/wiki/Z%C3%A8bre\" title=\"Zèbre\">zèbre</a> (du genre <i>Equus</i>). En 1901, il réussit à se procurer la peau entière d’un okapi ainsi que deux crânes. Leur étude révéla qu’il ne s’agissait pas d’un <a href=\"/wiki/Z%C3%A8bre\" title=\"Zèbre\">zèbre</a> mais d’une espèce d'un nouveau genre et on changea son nom en <i>Okapia johnstoni</i>.</p>\n<h2><span class=\"mw-headline\" id=\"Alimentation\">Alimentation</span></h2>\n<p>L’okapi se nourrit de <a href=\"/wiki/Feuille\" title=\"Feuille\">feuilles</a>, de divers végétaux différents (dont l’<a href=\"/wiki/Euphorbe\" title=\"Euphorbe\">euphorbe</a>, particulièrement toxique pour l’homme), de bourgeons, de branches tendres, de fruits, de champignons et de fougères. Il cueille sa nourriture à l’aide de sa langue et de ses lèvres préhensiles. Il comble ses besoins en minéraux en mangeant de l’argile sulfureuse qu’il trouve près des rivières ou des <a href=\"/wiki/Gramin%C3%A9e\" class=\"mw-redirect\" title=\"Graminée\">graminées</a> poussant sur des sols hautement minéralisés.</p>\n<h2><span class=\"mw-headline\" id=\"Habitat\">Habitat</span></h2>\n<p>L’okapi est un animal discret et solitaire qui ne fréquente ses pairs qu’au moment de la reproduction. On compte généralement deux individus au km². Sédentaire, il vit sur un territoire qu’il marque par des dépôts d’urine et des sécrétions issues de glandes situées entre ses doigts. Il emprunte toujours les mêmes pistes de passage qu’il a ainsi marquées. C’est un animal essentiellement nocturne dont le principal prédateur est le <a href=\"/wiki/L%C3%A9opard_(f%C3%A9lin)\" class=\"mw-redirect\" title=\"Léopard (félin)\">léopard</a>. Ses oreilles très grandes lui permettent d'entendre le moindre bruit en cas d'attaque.</p>\n<h2><span class=\"mw-headline\" id=\"Reproduction\">Reproduction</span></h2>\n<p>La saison des amours a lieu de mai à juillet. La femelle, qui a déjà signalé sa piste par ses sécrétions odoriférantes, guide le mâle à travers la forêt dense en émettant des appels ressemblant à des toussotements. Il peut y avoir des affrontements entre les mâles convoitant une même femelle. Les deux membres du couple se rejoignent finalement dans une courte parade nuptiale faite de fuites et d’esquives puis s’accouplent. Après une <a href=\"/wiki/Gestation\" title=\"Gestation\">gestation</a> de <span class=\"nowrap\">15 mois</span> environ, elle donne naissance à un petit d’environ <span class=\"nowrap\">75 <abbr class=\"abbr\" title=\"centimètre\">cm</abbr></span> au garrot et pesant environ <span class=\"nowrap\">20 <abbr class=\"abbr\" title=\"kilogramme\">kg</abbr></span>. Celui-ci suit sa mère pendant quelques jours jusqu’à trouver un fourré où se cacher. Il y reste la plupart de son temps jusqu’à atteindre l’âge de deux mois, à partir duquel il suit sa mère dans ses déplacements. Le <a href=\"/wiki/Sevrage_(alimentation)\" title=\"Sevrage (alimentation)\">sevrage</a> a lieu entre <span class=\"nowrap\">6 et 10 mois</span>.</p>\n<h2><span id=\"Une_esp.C3.A8ce_menac.C3.A9e\"></span><span class=\"mw-headline\" id=\"Une_espèce_menacée\">Une espèce menacée</span></h2>\n<p>L’okapi figure sur la liste rouge des espèces menacées de l’<a href=\"/wiki/UICN\" class=\"mw-redirect\" title=\"UICN\">UICN</a>. En effet, son habitat est de plus en plus restreint. Même à l’intérieur de la réserve, l’okapi est victime du <a href=\"/wiki/Braconnage\" title=\"Braconnage\">braconnage</a>, surtout dans le parc national de Virunga. Leur population est estimée de <span class=\"nowrap\">10&#160;000 à 35&#160;000 individus</span> et la tendance est à la baisse. Cet animal est protégé depuis 1933<sup id=\"cite_ref-1\" class=\"reference\"><a href=\"#cite_note-1\"><span class=\"cite_crochet\">[</span>1<span class=\"cite_crochet\">]</span></a></sup>. L'espèce est en danger depuis décembre 2013.</p>\n<h2><span id=\"La_vie_en_captivit.C3.A9\"></span><span class=\"mw-headline\" id=\"La_vie_en_captivité\">La vie en captivité</span></h2>\n<div class=\"thumb tright\">\n<div class=\"thumbinner\" style=\"width:222px;\"><a href=\"/wiki/Fichier:Okapia_johnstoni_(Okapi)_-_437.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/2/2f/Okapia_johnstoni_%28Okapi%29_-_437.jpg/220px-Okapia_johnstoni_%28Okapi%29_-_437.jpg\" width=\"220\" height=\"147\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/2/2f/Okapia_johnstoni_%28Okapi%29_-_437.jpg/330px-Okapia_johnstoni_%28Okapi%29_-_437.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/2/2f/Okapia_johnstoni_%28Okapi%29_-_437.jpg/440px-Okapia_johnstoni_%28Okapi%29_-_437.jpg 2x\" data-file-width=\"2061\" data-file-height=\"1374\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/Fichier:Okapia_johnstoni_(Okapi)_-_437.jpg\" class=\"internal\" title=\"Agrandir\"></a></div>\nUn okapia johnstoni (Okapi) au <a href=\"/wiki/ZooParc_de_Beauval\" title=\"ZooParc de Beauval\">ZooParc de Beauval</a> à <a href=\"/wiki/Saint-Aignan_(Loir-et-Cher)\" title=\"Saint-Aignan (Loir-et-Cher)\">Saint-Aignan</a>, France.</div>\n</div>\n</div>\n<p>La survie de l’okapi dépend aussi des zoos où il peut vivre et se reproduire en sécurité. Toutefois, son acclimatation à la vie en captivité a été difficile. Le premier spécimen ramené en <a href=\"/wiki/Europe\" title=\"Europe\">Europe</a> fut donné au <a href=\"/wiki/Zoo_d%27Anvers\" title=\"Zoo d'Anvers\">zoo d'Anvers</a> en 1918 mais ne survécut que <span class=\"nowrap\">50 jours</span>. Jusqu’en 1940, toutes les tentatives d’acclimatation de l’okapi en zoo furent des échecs hormis à Anvers où un individu vécut <span class=\"nowrap\">15 ans</span> à partir de 1928. La première naissance en captivité eut lieu à Anvers en 1954 mais le petit ne vécut qu’une journée. D’autres naissances eurent lieu dans divers zoos mais les petits ne survivaient jamais longtemps. En 1957 eut lieu la première naissance viable, au <a href=\"/wiki/Zoo_de_Vincennes\" class=\"mw-redirect\" title=\"Zoo de Vincennes\">zoo de Vincennes</a>.</p>\n<h2><span class=\"mw-headline\" id=\"Sources\">Sources</span></h2>\n<ul>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"http://www.leszoosdanslemonde.com/introduction/archives_actualites/2003/07_2003_vincennes.htm\">Les okapis et le parc zoologique de Paris</a></li>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"http://www.thebigzoo.com/Animals/Okapi.asp\">Un site en anglais sur l'okapi</a></li>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"http://www.dinosoria.com/okapi.htm\">L'okapi</a></li>\n<li><a rel=\"nofollow\" class=\"external autonumber\" href=\"http://www.webjunoir.net/encyclopedie/l-okapi-99.php\">[1]</a></li>\n</ul>\n<h2><span id=\"R.C3.A9f.C3.A9rences\"></span><span class=\"mw-headline\" id=\"Références\">Références</span></h2>\n<div class=\"references-small decimal\" style=\"\">\n<div class=\"mw-references-wrap\">\n<ol class=\"references\">\n<li id=\"cite_note-1\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-1\">↑</a></span> <span class=\"reference-text\"><span class=\"indicateur-langue\">(<abbr class=\"abbr\" title=\"Langue&#160;: anglais\">en</abbr>)</span> <span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.iucnredlist.org/details/15188\">«&#160;<cite style=\"font-style: normal;\">l'okapi sur le site de l'UICN</cite>&#160;»</a>, sur <i>iucnredlist.org</i> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">3 juillet 2012</span>)</small></span>.</span></li>\n</ol>\n</div>\n</div>\n<h2><span class=\"mw-headline\" id=\"Liens_externes\">Liens externes</span></h2>\n<div class=\"autres-projets boite-grise boite-a-droite noprint js-interprojets\">\n<p class=\"titre\">Sur les autres projets Wikimedia&#160;:</p>\n<ul class=\"noarchive plainlinks\">\n<li class=\"commons\"><a class=\"external text\" href=\"https://commons.wikimedia.org/wiki/Category:Okapia_johnstoni?uselang=fr\">Okapi</a>, sur <span class=\"project\">Wikimedia Commons</span></li>\n<li class=\"wikispecies\"><a href=\"https://species.wikimedia.org/wiki/Okapia_johnstoni\" class=\"extiw\" title=\"wikispecies:Okapia johnstoni\">Okapi</a>, <span class=\"nowrap\">sur <span class=\"project\">Wikispecies</span></span></li>\n</ul>\n</div>\n<ul>\n<li><span class=\"ouvrage\" id=\"ADW\">Référence <a href=\"/wiki/Animal_Diversity_Web\" title=\"Animal Diversity Web\">Animal Diversity Web</a>&#160;: <a rel=\"nofollow\" class=\"external text\" href=\"http://animaldiversity.org/accounts/Okapia_johnstoni/\"><i>Okapia johnstoni</i></a> <span class=\"indicateur-langue\">(<abbr class=\"abbr\" title=\"Langue&#160;: anglais\">en</abbr>)</span> <small>(consulté le <time class=\"nowrap\" datetime=\"2013-11-28\">28 novembre 2013</time>)</small></span></li>\n<li><span class=\"ouvrage\" id=\"ARKive_GES\">Référence <a rel=\"nofollow\" class=\"external text\" href=\"http://www.arkive.org/\">Fonds documentaire ARKive</a>&#160;: <a rel=\"nofollow\" class=\"external text\" href=\"http://www.arkive.org/en/Okapia-johnstoni/\"><i>Okapia johnstoni</i></a> <span class=\"indicateur-langue\">(<abbr class=\"abbr\" title=\"Langue&#160;: anglais\">en</abbr>)</span> <small>(consulté le <time class=\"nowrap\" datetime=\"2013-11-28\">28 novembre 2013</time>)</small></span></li>\n<li><span class=\"ouvrage\" id=\"ITIS\">Référence <a href=\"/wiki/Syst%C3%A8me_d%27information_taxonomique_int%C3%A9gr%C3%A9\" title=\"Système d'information taxonomique intégré\">ITIS</a>&#160;: <a rel=\"nofollow\" class=\"external text\" href=\"http://www.cbif.gc.ca/acp/fra/siti/regarder?tsn=625037\"><i>Okapia johnstoni</i> (P. L. Sclater, 1901)</a> <span class=\"indicateur-langue\">(<abbr class=\"abbr\" title=\"Langue&#160;: français\">fr</abbr>)</span> (<span class=\"plainlinksneverexpand\"><small>+ <a rel=\"nofollow\" class=\"external text\" href=\"http://www.itis.gov/servlet/SingleRpt/SingleRpt?search_topic=TSN&amp;search_value=625037\">version anglaise</a></small></span> <span class=\"indicateur-langue\">(<abbr class=\"abbr\" title=\"Langue&#160;: anglais\">en</abbr>)</span>) <small>(consulté le <time class=\"nowrap\" datetime=\"2013-11-28\">28 novembre 2013</time>)</small></span></li>\n<li><span class=\"ouvrage\" id=\"MSW\">Référence <a href=\"/wiki/Mammal_Species_of_the_World\" title=\"Mammal Species of the World\">Mammal Species of the World</a>&#160;: <a rel=\"nofollow\" class=\"external text\" href=\"http://www.departments.bucknell.edu/biology/resources/msw3/browse.asp?s=y&amp;id=14200484\"><i>Okapia johnstoni</i> P. L. Sclater, 1901</a> <span class=\"indicateur-langue\">(<abbr class=\"abbr\" title=\"Langue&#160;: anglais\">en</abbr>)</span> <small>(consulté le <time class=\"nowrap\" datetime=\"2013-11-28\">28 novembre 2013</time>)</small></span></li>\n<li><span class=\"ouvrage\" id=\"NCBI\">Référence <a href=\"/wiki/National_Center_for_Biotechnology_Information\" title=\"National Center for Biotechnology Information\">NCBI</a>&#160;: <a rel=\"nofollow\" class=\"external text\" href=\"http://www.ncbi.nlm.nih.gov/Taxonomy/Browser/wwwtax.cgi?lin=s&amp;p=has_linkout&amp;id=86973\"><i>Okapia johnstoni</i></a> <span class=\"indicateur-langue\">(<abbr class=\"abbr\" title=\"Langue&#160;: anglais\">en</abbr>)</span> <small>(consulté le <time class=\"nowrap\" datetime=\"2013-11-28\">28 novembre 2013</time>)</small></span></li>\n<li><span class=\"ouvrage\" id=\"Tolweb\">Référence <a rel=\"nofollow\" class=\"external text\" href=\"http://tolweb.org/tree/phylogeny.html\"><span class=\"lang-en\" lang=\"en\">Tree of Life</span> Web Project</a>&#160;: <a rel=\"nofollow\" class=\"external text\" href=\"http://tolweb.org/Okapia+johnstoni\"><i>Okapia johnstoni</i></a> <span class=\"indicateur-langue\">(<abbr class=\"abbr\" title=\"Langue&#160;: anglais\">en</abbr>)</span> <small>(consulté le <time class=\"nowrap\" datetime=\"2013-11-28\">28 novembre 2013</time>)</small></span></li>\n<li><span class=\"ouvrage\" id=\"UBIO\">Référence <a href=\"/wiki/Universal_Biological_Indexer_and_Organizer\" title=\"Universal Biological Indexer and Organizer\">uBio</a>&#160;: <a rel=\"nofollow\" class=\"external text\" href=\"http://www.ubio.org/browser/details.php?namebankID=106096\"><i>Okapia johnstoni</i> (P. L. Sclater, 1901)</a> <span class=\"indicateur-langue\">(<abbr class=\"abbr\" title=\"Langue&#160;: anglais\">en</abbr>)</span> <small>(consulté le <time class=\"nowrap\" datetime=\"2013-11-28\">28 novembre 2013</time>)</small></span></li>\n<li><span class=\"ouvrage\" id=\"UICN\">Référence <a href=\"/wiki/Union_internationale_pour_la_conservation_de_la_nature\" title=\"Union internationale pour la conservation de la nature\">UICN</a>&#160;: <a rel=\"nofollow\" class=\"external text\" href=\"http://www.iucnredlist.org/apps/redlist/details/15188\"><small>espèce</small> <i>Okapia johnstoni</i> (Sclater, 1901)</a> <span class=\"indicateur-langue\">(<abbr class=\"abbr\" title=\"Langue&#160;: anglais\">en</abbr>)</span> <small>(consulté le <time class=\"nowrap\" datetime=\"2015-05-27\">27 mai 2015</time>)</small></span></li>\n</ul>\n<table class=\"navbox collapsible noprint collapsed\" data-autocollapse-group=\"palette\" style=\"\">\n<tr>\n<th class=\"navbox-title\" colspan=\"3\" style=\"background-color:#E6E2AF;\">\n<div style=\"float:left; width:6em; text-align:left\">\n<div class=\"noprint plainlinksneverexpand nowrap tnavbar\" style=\"background-color:transparent; padding:0; font-size:xx-small; color:#000000;\"><a href=\"/wiki/Mod%C3%A8le:Palette_Cryptozoologie\" title=\"Modèle:Palette Cryptozoologie\"><abbr class=\"abbr\" title=\"Voir ce modèle.\">v</abbr></a>&#160;· <a class=\"external text\" href=\"//fr.wikipedia.org/w/index.php?title=Mod%C3%A8le:Palette_Cryptozoologie&amp;action=edit\"><abbr class=\"abbr\" title=\"Modifier ce modèle. Merci de prévisualiser avant de sauvegarder.\">m</abbr></a></div>\n</div>\n<span style=\"font-size:110%\"><a href=\"/wiki/Cryptozoologie\" title=\"Cryptozoologie\">Cryptozoologie</a></span></th>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"width:150px;background:#DDDDFF; vertical-align:middle; background-color:#d9cf98;\">Cryptozoologues</th>\n<td class=\"navbox-list\" style=\"text-align:center;; background-color:#E6E2AF;\"><span class=\"nowrap\"><a href=\"/wiki/Bernard_Heuvelmans\" title=\"Bernard Heuvelmans\">Bernard Heuvelmans</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Karl_Shuker\" title=\"Karl Shuker\">Karl Shuker</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Richard_Ellis_(biologiste)\" title=\"Richard Ellis (biologiste)\">Richard Ellis</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Benjamin_Radford\" title=\"Benjamin Radford\">Benjamin Radford</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Ivan_T._Sanderson\" title=\"Ivan T. Sanderson\">Ivan Terence Sanderson</a></span></td>\n<td rowspan=\"5\" style=\"vertical-align:middle;padding-left:7px\"><a href=\"/wiki/Fichier:Lake_monster_petroglyph.svg\" class=\"image\"><img alt=\"Lake monster petroglyph.svg\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/2/23/Lake_monster_petroglyph.svg/70px-Lake_monster_petroglyph.svg.png\" width=\"70\" height=\"224\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/2/23/Lake_monster_petroglyph.svg/105px-Lake_monster_petroglyph.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/2/23/Lake_monster_petroglyph.svg/140px-Lake_monster_petroglyph.svg.png 2x\" data-file-width=\"59\" data-file-height=\"189\" /></a></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"width:150px;background:#DDDDFF; vertical-align:middle; background-color:#d9cf98;\">Cryptides</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:center;; background-color:#FCFAE1;\">\n<table class=\"navbox-subgroup\" style=\"\">\n<tr>\n<th class=\"navbox-group\" style=\"width:150px; vertical-align:middle; background-color:#d9cf98;\"><a href=\"/wiki/Monstre_marin\" title=\"Monstre marin\">Monstres aquatiques</a> et <a href=\"/wiki/Serpent_de_mer\" title=\"Serpent de mer\">serpents de mer</a></th>\n<td class=\"navbox-list navbox-even\" style=\";text-align:left;background-color:#FCFAE1;\"><span class=\"nowrap\"><a href=\"/wiki/Bownessie\" title=\"Bownessie\">Bownessie</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Manipogo\" title=\"Manipogo\">Manipogo</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Memphr%C3%A9\" title=\"Memphré\">Memphré</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Ogopogo\" title=\"Ogopogo\">Ogopogo</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Ponik\" title=\"Ponik\">Ponik</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Selma_(cr%C3%A9ature_lacustre)\" title=\"Selma (créature lacustre)\">Selma</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Storsj%C3%B6odjuret\" title=\"Storsjöodjuret\">Storsjöodjuret</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Champ_(cr%C3%A9ature_lacustre)\" title=\"Champ (créature lacustre)\">Champ</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Mussie\" title=\"Mussie\">Mussie</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Monstre_du_Loch_Ness\" title=\"Monstre du Loch Ness\">Monstre du Loch Ness</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Lusca\" title=\"Lusca\">Lusca</a></span></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"width:150px; vertical-align:middle; background-color:#d9cf98;\"><a href=\"/wiki/Dinosaure\" title=\"Dinosaure\">Dinosaures</a> vivants</th>\n<td class=\"navbox-list\" style=\";background:#E6E2AF; text-align:left;\"><span class=\"nowrap\"><a href=\"/wiki/Mokele-mbembe\" class=\"mw-redirect\" title=\"Mokele-mbembe\">Mokele-mbembe</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Emela-ntouka\" title=\"Emela-ntouka\">Emela-ntouka</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Kongamato\" title=\"Kongamato\">Kongamato</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Mbielu-mbielu-mbielu\" title=\"Mbielu-mbielu-mbielu\">Mbielu-mbielu-mbielu</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Ngoubou\" title=\"Ngoubou\">Ngoubou</a></span></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"width:150px; vertical-align:middle; background-color:#d9cf98;\">Liste de bêtes dévorantes</th>\n<td class=\"navbox-list navbox-even\" style=\";text-align:left;background-color:#FCFAE1;\"><span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_de_Cinglais\" title=\"Bête de Cinglais\">Bête de Cinglais</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_du_Benais\" class=\"mw-redirect\" title=\"Bête du Benais\">Bête du Benais</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_de_l%27Auxerrois\" title=\"Bête de l'Auxerrois\">Bête de l'Auxerrois</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_de_Primarette\" title=\"Bête de Primarette\">Bête de Primarette</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_du_Lyonnais\" title=\"Bête du Lyonnais\">Bête du Lyonnais</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_du_G%C3%A9vaudan\" title=\"Bête du Gévaudan\">Bête du Gévaudan</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_de_Sarlat\" title=\"Bête de Sarlat\">Bête de Sarlat</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_de_Veyreau\" title=\"Bête de Veyreau\">Bête de Veyreau</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_de_Chaingy\" title=\"Bête de Chaingy\">Bête de Chaingy</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_des_C%C3%A9vennes\" title=\"Bête des Cévennes\">Bête des Cévennes</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_du_C%C3%A9zallier\" title=\"Bête du Cézallier\">Bête du Cézallier</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_du_Valais\" class=\"mw-redirect\" title=\"Bête du Valais\">Bête du Valais</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_des_Vosges\" title=\"Bête des Vosges\">Bête des Vosges</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_de_Noth\" title=\"Bête de Noth\">Bête de Noth</a></span></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"width:150px; vertical-align:middle; background-color:#d9cf98;\">Anthropomorphes et hominidés</th>\n<td class=\"navbox-list\" style=\";background:#E6E2AF; text-align:left;\"><span class=\"nowrap\"><a href=\"/wiki/Agogwe\" title=\"Agogwe\">Agogwe</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Almasty\" title=\"Almasty\">Almasty</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Ebu_Gogo\" title=\"Ebu Gogo\">Ebu Gogo</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Homme-singe_de_New_Delhi\" title=\"Homme-singe de New Delhi\">Homme-singe</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Orang_pendek\" title=\"Orang pendek\">Orang pendek</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Sasquatch\" class=\"mw-redirect\" title=\"Sasquatch\">Sasquatch</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Wendigo\" title=\"Wendigo\">Wendigo</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Yowie\" class=\"mw-disambig\" title=\"Yowie\">Yowie</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Y%C3%A9ti\" title=\"Yéti\">Yéti</a></span></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"width:150px; vertical-align:middle; background-color:#d9cf98;\"><a href=\"/wiki/Globster\" title=\"Globster\">Globsters</a> et cadavres</th>\n<td class=\"navbox-list navbox-even\" style=\";text-align:left;background-color:#FCFAE1;\"><span class=\"nowrap\"><a href=\"/wiki/B%C3%AAte_de_Stronsay\" title=\"Bête de Stronsay\">Bête de Stronsay</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Monstre_de_Montauk\" title=\"Monstre de Montauk\">Monstre de Montauk</a></span></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"width:150px; vertical-align:middle; background-color:#d9cf98;\">Autres animaux inconnus</th>\n<td class=\"navbox-list\" style=\";background:#E6E2AF; text-align:left;\"><span class=\"nowrap\"><a href=\"/wiki/Mapinguari\" title=\"Mapinguari\">Mapinguari</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Khting_voar\" title=\"Khting voar\">Khting voar</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Mngwa\" title=\"Mngwa\">Mngwa</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Olgo%C3%AF-Khorkho%C3%AF\" title=\"Olgoï-Khorkhoï\">Olgoï-Khorkhoï</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Tsuchinoko\" title=\"Tsuchinoko\">Tsuchinoko</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Ours_Nandi\" title=\"Ours Nandi\">Ours Nandi</a></span></td>\n</tr>\n</table>\n</td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"width:150px;background:#DDDDFF; vertical-align:middle; background-color:#d9cf98;\">Les animaux bien réels</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:center;; background-color:#FCFAE1;\"><span class=\"nowrap\"><a href=\"/wiki/Architeuthis\" class=\"mw-redirect\" title=\"Architeuthis\">Calamar géant</a></span>&#160;• <span class=\"nowrap\"><a class=\"mw-selflink selflink\">Okapi</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Grand-duc_du_N%C3%A9pal\" title=\"Grand-duc du Népal\">Grand-duc du Népal</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Gorille\" title=\"Gorille\">Gorille</a></span></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"width:150px;background:#DDDDFF; vertical-align:middle; background-color:#d9cf98;\">Dans la fiction</th>\n<td class=\"navbox-list\" style=\"text-align:center;; background-color:#E6E2AF;\"><span class=\"nowrap\"><i><a href=\"/wiki/Les_Saturdays\" title=\"Les Saturdays\">Les Saturdays</a></i></span>&#160;• <span class=\"nowrap\"><i><a href=\"/wiki/Sanctuary_(s%C3%A9rie_t%C3%A9l%C3%A9vis%C3%A9e)\" title=\"Sanctuary (série télévisée)\">Sanctuary</a></i></span>&#160;• <span class=\"nowrap\"><i><a href=\"/wiki/Nick_Cutter_et_les_Portes_du_temps\" title=\"Nick Cutter et les Portes du temps\">Primeval</a></i> et <i><a href=\"/wiki/Les_Portes_du_temps_:_Un_nouveau_monde\" title=\"Les Portes du temps : Un nouveau monde\">Les Portes du temps : Un nouveau monde</a></i></span>&#160;• <span class=\"nowrap\"><i><a href=\"/wiki/Kenya_(bande_dessin%C3%A9e)\" title=\"Kenya (bande dessinée)\">Kenya</a></i></span>&#160;• <span class=\"nowrap\"><i><a href=\"/wiki/Ad%C3%A8le_et_la_B%C3%AAte\" title=\"Adèle et la Bête\">Adèle et la Bête</a></i></span>&#160;• <span class=\"nowrap\"><i><a href=\"/wiki/Tintin_au_Tibet\" title=\"Tintin au Tibet\">Tintin au Tibet</a></i></span>&#160;• <span class=\"nowrap\"><i><a href=\"/wiki/Le_Monde_perdu_(Arthur_Conan_Doyle)\" title=\"Le Monde perdu (Arthur Conan Doyle)\">Le Monde perdu</a></i></span></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"width:150px;background:#DDDDFF; vertical-align:middle; background-color:#d9cf98;\">Humour et supercheries</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:center;; background-color:#FCFAE1;\"><span class=\"nowrap\"><a href=\"/wiki/Rhinogrades\" title=\"Rhinogrades\">Rhinogradentia</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Marsupilami\" title=\"Marsupilami\">Marsupilami franquini</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Cantatrix_sopranica_L.\" title=\"Cantatrix sopranica L.\">Cantatrix sopranica L.</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Homo_orcus_-_Une_seconde_humanit%C3%A9\" title=\"Homo orcus - Une seconde humanité\">Homo orcus</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Sir%C3%A8ne_des_Fidji\" title=\"Sirène des Fidji\">Sirène des Fidji</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Skvader\" title=\"Skvader\">Skvader</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Pieuvre_arboricole_du_Nord-Ouest_Pacifique\" title=\"Pieuvre arboricole du Nord-Ouest Pacifique\">Pieuvre arboricole du Nord-Ouest Pacifique</a></span></td>\n</tr>\n<tr>\n<td class=\"navbox-banner\" style=\"background-color:#E6E2AF;font-size:85%;\" colspan=\"3\"><span class=\"nowrap\"><a href=\"/wiki/Esp%C3%A8ce_panchronique\" title=\"Espèce panchronique\">Espèce panchronique</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Taxon_Lazare\" title=\"Taxon Lazare\">Taxon Lazare</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/T%C3%A9ratologie\" title=\"Tératologie\">Tératologie</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Pseudo-science\" title=\"Pseudo-science\">Pseudo-science</a></span></td>\n</tr>\n</table>\n<ul id=\"bandeau-portail\" class=\"bandeau-portail\">\n<li><span class=\"bandeau-portail-element\"><span class=\"bandeau-portail-icone\"><a href=\"/wiki/Portail:Mammif%C3%A8res\" title=\"Portail des mammifères\"><img alt=\"Portail des mammifères\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/f/f1/Mouse.svg/41px-Mouse.svg.png\" width=\"41\" height=\"24\" class=\"noviewer\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/f/f1/Mouse.svg/61px-Mouse.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/f/f1/Mouse.svg/81px-Mouse.svg.png 2x\" data-file-width=\"365\" data-file-height=\"218\" /></a></span> <span class=\"bandeau-portail-texte\"><a href=\"/wiki/Portail:Mammif%C3%A8res\" title=\"Portail:Mammifères\">Portail des mammifères</a></span></span></li>\n</ul>\n\n</div>","displaytitle":"Okapi","iwlinks":[{"prefix":"wikispecies","url":"https://species.wikimedia.org/wiki/Okapia_johnstoni","title":"wikispecies:Okapia johnstoni"}],"wikitext":"{{sous-titre/Taxon|ns1=Okapia johnstoni}}\n{{Voir homonymes|Okapi (homonymie)}}\n{{Sources à lier|date=juin 2015}}\n{{Taxobox début | animal | ''Okapia johnstoni'' | Okapi2.jpg | Okapi }}\n{{Taxobox | embranchement | Chordata }}\n{{Taxobox | classe | Mammalia }}\n{{Taxobox | sous-classe | Theria }}\n{{Taxobox | ordre | Artiodactyla }}\n{{Taxobox | famille | Giraffidae }}\n{{Taxobox taxon | animal | genre | Okapia | [[Edwin Ray Lankester|Lankester]], [[1901]] }}\n{{Taxobox taxon | animal | espèce | Okapia johnstoni | ([[Philip Lutley Sclater|Sclater]], [[1901]]) }}\n{{Taxobox synonymes |\n* ''Equus johnstoni'' <small>P.L. Sclater, 1901</small>}}\n{{Taxobox UICN | EN | A2abcd+4abcd }}\n{{Taxobox répartition | Okapi map.jpg }}\n{{Taxobox répartition | Okapi distribution.PNG }}\n{{Taxobox fin}}\n\nL’'''okapi''' ('''''Okapia johnstoni'''''), aussi connu sous le nom de '''Mondonga''', est une [[espèce]] de [[mammifère]]s [[ruminant]]s de la même [[Famille (biologie)|famille]] que la [[girafe]], venant des forêts équatoriales de l'[[Afrique centrale]]. Bien que connu par les [[Pygmée]]s, il est « [[Découverte scientifique|découvert]] » en [[1901]] par Sir [[Harry Johnston]] à qui il doit son nom. C’est l'un des derniers grands [[mammifère]]s à être observé scientifiquement sur la planète.\n\nCet animal dont l’allure rappelle à la fois celle du [[zèbre]] et de la [[girafe]] vit exclusivement dans une petite région au nord-est de la [[République démocratique du Congo]], la [[Forêt de l'Ituri|forêt tropicale de l’Ituri]], où une réserve lui est spécialement dédiée. Son nom vernaculaire en [[lingala]] est ''mondonga''.\n\n{{ref nec|Cet animal ne vit pas exclusivement en RD Congo. Il a été aussi observé dans les forêts du sud-est du Gabon, à la frontière avec le Congo-Brazzaville. Il a entre autre été vu par des chasseurs français en 1983 sur la piste reliant Boumango à Mbinda}}.\n\n== Caractéristiques physiques ==\nL’okapi mesure environ {{unité|1.80|m}} au [[Garrot (anatomie)|garrot]] et pèse au maximum {{unité|200 à 230|kg}}. Sa [[Morphologie (biologie)|morphologie]] est relativement proche de celle de la [[girafe]] : son corps est court et massif, ses pattes arrières sont plus courtes que celles de devant (ce qui lui donne l'allure d'avoir la croupe plus basse que les épaules) et sa colonne vertébrale a un axe oblique. Toutefois son cou est moins long et plus épais que celui de la girafe. Le mâle porte des [[ossicône]]s, sortes de petites cornes osseuses recouvertes de peau qui se développent entre 1 et 5 ans. Ses oreilles sont larges et particulièrement mobiles. Sa langue [[préhensile]] est noire et mesure entre {{unité|30 et 50|cm}} de long : avec elle, il peut saisir sa nourriture mais aussi nettoyer toutes les parties de son corps, y compris ses oreilles.\n\nSon pelage court est d’un brun chocolat sur le corps avec des zébrures noires et blanches sur les pattes et l’arrière-train. La tête est marquée d’une tache blanche au niveau de la joue.\n\n== Histoire ==\nLes [[pygmée]]s de l’actuelle [[République démocratique du Congo]] connaissaient depuis longtemps l’okapi qu’ils prenaient parfois au piège dans des trous camouflés. Ils l’appelaient ''o’api''. En 1890, le journaliste [[Henry Morton Stanley]] (1841-1904) venu à la rencontre des pygmées rapporte l’existence d’une sorte d’âne-zèbre broutant des feuilles. Sir [[Harry Hamilton Johnston]] (1858-1927), futur gouverneur de l’[[Ouganda]], curieux de cet animal étrange, partit en 1899 à sa recherche et le baptisa ''Equus johnstoni'', pensant qu’il s’agissait d’une nouvelle espèce de [[zèbre]] (du genre ''Equus''). En 1901, il réussit à se procurer la peau entière d’un okapi ainsi que deux crânes. Leur étude révéla qu’il ne s’agissait pas d’un [[zèbre]] mais d’une espèce d'un nouveau genre et on changea son nom en ''Okapia johnstoni''.\n\n== Alimentation ==\nL’okapi se nourrit de [[feuille]]s, de divers végétaux différents (dont l’[[euphorbe]], particulièrement toxique pour l’homme), de bourgeons, de branches tendres, de fruits, de champignons et de fougères. Il cueille sa nourriture à l’aide de sa langue et de ses lèvres préhensiles. Il comble ses besoins en minéraux en mangeant de l’argile sulfureuse qu’il trouve près des rivières ou des [[graminée]]s poussant sur des sols hautement minéralisés.\n\n== Habitat ==\nL’okapi est un animal discret et solitaire qui ne fréquente ses pairs qu’au moment de la reproduction. On compte généralement deux individus au km². Sédentaire, il vit sur un territoire qu’il marque par des dépôts d’urine et des sécrétions issues de glandes situées entre ses doigts. Il emprunte toujours les mêmes pistes de passage qu’il a ainsi marquées. C’est un animal essentiellement nocturne dont le principal prédateur est le [[Léopard (félin)|léopard]]. Ses oreilles très grandes lui permettent d'entendre le moindre bruit en cas d'attaque.\n\n== Reproduction ==\nLa saison des amours a lieu de mai à juillet. La femelle, qui a déjà signalé sa piste par ses sécrétions odoriférantes, guide le mâle à travers la forêt dense en émettant des appels ressemblant à des toussotements. Il peut y avoir des affrontements entre les mâles convoitant une même femelle. Les deux membres du couple se rejoignent finalement dans une courte parade nuptiale faite de fuites et d’esquives puis s’accouplent. Après une [[gestation]] de {{unité|15|mois}} environ, elle donne naissance à un petit d’environ {{unité|75|cm}} au garrot et pesant environ {{unité|20|kg}}. Celui-ci suit sa mère pendant quelques jours jusqu’à trouver un fourré où se cacher. Il y reste la plupart de son temps jusqu’à atteindre l’âge de deux mois, à partir duquel il suit sa mère dans ses déplacements. Le [[Sevrage (alimentation)|sevrage]] a lieu entre {{unité|6 et 10|mois}}.\n\n== Une espèce menacée ==\nL’okapi figure sur la liste rouge des espèces menacées de l’[[UICN]]. En effet, son habitat est de plus en plus restreint. Même à l’intérieur de la réserve, l’okapi est victime du [[braconnage]], surtout dans le parc national de Virunga. Leur population est estimée de {{unité|10000 à 35000|individus}} et la tendance est à la baisse. Cet animal est protégé depuis 1933<ref>{{en}} {{lien web|url=http://www.iucnredlist.org/details/15188|titre=l'okapi sur le site de l'UICN|site=iucnredlist.org|citation=|en ligne le=|consulté le=3 juillet 2012}}.</ref>. L'espèce est en danger depuis décembre 2013.\n\n== La vie en captivité ==\n[[Fichier:Okapia johnstoni (Okapi) - 437.jpg|vignette|Un okapia johnstoni (Okapi) au [[ZooParc de Beauval]] à [[Saint-Aignan (Loir-et-Cher)|Saint-Aignan]], France.]]\n\nLa survie de l’okapi dépend aussi des zoos où il peut vivre et se reproduire en sécurité. Toutefois, son acclimatation à la vie en captivité a été difficile. Le premier spécimen ramené en [[Europe]] fut donné au [[zoo d'Anvers]] en 1918 mais ne survécut que {{unité|50|jours}}. Jusqu’en 1940, toutes les tentatives d’acclimatation de l’okapi en zoo furent des échecs hormis à Anvers où un individu vécut {{unité|15|ans}} à partir de 1928. La première naissance en captivité eut lieu à Anvers en 1954 mais le petit ne vécut qu’une journée. D’autres naissances eurent lieu dans divers zoos mais les petits ne survivaient jamais longtemps. En 1957 eut lieu la première naissance viable, au [[zoo de Vincennes]].\n\n== Sources ==\n* [http://www.leszoosdanslemonde.com/introduction/archives_actualites/2003/07_2003_vincennes.htm Les okapis et le parc zoologique de Paris]\n* [http://www.thebigzoo.com/Animals/Okapi.asp Un site en anglais sur l'okapi]\n* [http://www.dinosoria.com/okapi.htm L'okapi]\n* [http://www.webjunoir.net/encyclopedie/l-okapi-99.php]\n\n== Références ==\n{{Références}}\n\n== Liens externes ==\n{{Autres projets\n|commons=Category:Okapia johnstoni\n|wikispecies=Okapia johnstoni\n}}\n* {{ADW|Okapia_johnstoni|''Okapia johnstoni''|consulté le=28 Nov 2013}}\n* {{ARKive GES|mammals|Okapia|johnstoni|consulté le=28 Nov 2013}}\n* {{ITIS|625037|''Okapia johnstoni''  (P. L. Sclater, 1901)|consulté le=28 Nov 2013}}\n* {{MSW|14200484|Okapia johnstoni|P. L. Sclater, 1901|consulté le=28 Nov 2013}}\n* {{NCBI|86973|''Okapia johnstoni''|consulté le=28 Nov 2013}}\n* {{Tolweb|Okapia johnstoni|consulté le=28 Nov 2013}}\n* {{uBIO|106096|''Okapia johnstoni''  (P. L. Sclater, 1901)|consulté le=28 Nov 2013}}\n* {{UICN|15188|''Okapia johnstoni'' (Sclater, 1901)|consulté le=27 mai 2015}}\n\n{{Palette Cryptozoologie}}\n\n{{Portail|Mammifères}}\n\n[[Catégorie:Mammifère (nom vernaculaire)]]\n[[Catégorie:Giraffidae]]\n[[Catégorie:Faune d'Afrique centrale]]","properties":{"wikibase_item":"Q82037"},"parsetree":"<root><template><title>sous-titre/Taxon</title><part><name>ns1</name><equals>=</equals><value>Okapia johnstoni</value></part></template>\n<template lineStart=\"1\"><title>Voir homonymes</title><part><name index=\"1\"/><value>Okapi (homonymie)</value></part></template>\n<template lineStart=\"1\"><title>Sources à lier</title><part><name>date</name><equals>=</equals><value>juin 2015</value></part></template>\n<template lineStart=\"1\"><title>Taxobox début </title><part><name index=\"1\"/><value> animal </value></part><part><name index=\"2\"/><value> ''Okapia johnstoni'' </value></part><part><name index=\"3\"/><value> Okapi2.jpg </value></part><part><name index=\"4\"/><value> Okapi </value></part></template>\n<template lineStart=\"1\"><title>Taxobox </title><part><name index=\"1\"/><value> embranchement </value></part><part><name index=\"2\"/><value> Chordata </value></part></template>\n<template lineStart=\"1\"><title>Taxobox </title><part><name index=\"1\"/><value> classe </value></part><part><name index=\"2\"/><value> Mammalia </value></part></template>\n<template lineStart=\"1\"><title>Taxobox </title><part><name index=\"1\"/><value> sous-classe </value></part><part><name index=\"2\"/><value> Theria </value></part></template>\n<template lineStart=\"1\"><title>Taxobox </title><part><name index=\"1\"/><value> ordre </value></part><part><name index=\"2\"/><value> Artiodactyla </value></part></template>\n<template lineStart=\"1\"><title>Taxobox </title><part><name index=\"1\"/><value> famille </value></part><part><name index=\"2\"/><value> Giraffidae </value></part></template>\n<template lineStart=\"1\"><title>Taxobox taxon </title><part><name index=\"1\"/><value> animal </value></part><part><name index=\"2\"/><value> genre </value></part><part><name index=\"3\"/><value> Okapia </value></part><part><name index=\"4\"/><value> [[Edwin Ray Lankester|Lankester]], [[1901]] </value></part></template>\n<template lineStart=\"1\"><title>Taxobox taxon </title><part><name index=\"1\"/><value> animal </value></part><part><name index=\"2\"/><value> espèce </value></part><part><name index=\"3\"/><value> Okapia johnstoni </value></part><part><name index=\"4\"/><value> ([[Philip Lutley Sclater|Sclater]], [[1901]]) </value></part></template>\n<template lineStart=\"1\"><title>Taxobox synonymes </title><part><name index=\"1\"/><value>\n* ''Equus johnstoni'' &lt;small&gt;P.L. Sclater, 1901&lt;/small&gt;</value></part></template>\n<template lineStart=\"1\"><title>Taxobox UICN </title><part><name index=\"1\"/><value> EN </value></part><part><name index=\"2\"/><value> A2abcd+4abcd </value></part></template>\n<template lineStart=\"1\"><title>Taxobox répartition </title><part><name index=\"1\"/><value> Okapi map.jpg </value></part></template>\n<template lineStart=\"1\"><title>Taxobox répartition </title><part><name index=\"1\"/><value> Okapi distribution.PNG </value></part></template>\n<template lineStart=\"1\"><title>Taxobox fin</title></template>\n\nL’'''okapi''' ('''''Okapia johnstoni'''''), aussi connu sous le nom de '''Mondonga''', est une [[espèce]] de [[mammifère]]s [[ruminant]]s de la même [[Famille (biologie)|famille]] que la [[girafe]], venant des forêts équatoriales de l'[[Afrique centrale]]. Bien que connu par les [[Pygmée]]s, il est « [[Découverte scientifique|découvert]] » en [[1901]] par Sir [[Harry Johnston]] à qui il doit son nom. C’est l'un des derniers grands [[mammifère]]s à être observé scientifiquement sur la planète.\n\nCet animal dont l’allure rappelle à la fois celle du [[zèbre]] et de la [[girafe]] vit exclusivement dans une petite région au nord-est de la [[République démocratique du Congo]], la [[Forêt de l'Ituri|forêt tropicale de l’Ituri]], où une réserve lui est spécialement dédiée. Son nom vernaculaire en [[lingala]] est ''mondonga''.\n\n<template lineStart=\"1\"><title>ref nec</title><part><name index=\"1\"/><value>Cet animal ne vit pas exclusivement en RD Congo. Il a été aussi observé dans les forêts du sud-est du Gabon, à la frontière avec le Congo-Brazzaville. Il a entre autre été vu par des chasseurs français en 1983 sur la piste reliant Boumango à Mbinda</value></part></template>.\n\n<h level=\"2\" i=\"1\">== Caractéristiques physiques ==</h>\nL’okapi mesure environ <template><title>unité</title><part><name index=\"1\"/><value>1.80</value></part><part><name index=\"2\"/><value>m</value></part></template> au [[Garrot (anatomie)|garrot]] et pèse au maximum <template><title>unité</title><part><name index=\"1\"/><value>200 à 230</value></part><part><name index=\"2\"/><value>kg</value></part></template>. Sa [[Morphologie (biologie)|morphologie]] est relativement proche de celle de la [[girafe]] : son corps est court et massif, ses pattes arrières sont plus courtes que celles de devant (ce qui lui donne l'allure d'avoir la croupe plus basse que les épaules) et sa colonne vertébrale a un axe oblique. Toutefois son cou est moins long et plus épais que celui de la girafe. Le mâle porte des [[ossicône]]s, sortes de petites cornes osseuses recouvertes de peau qui se développent entre 1 et 5 ans. Ses oreilles sont larges et particulièrement mobiles. Sa langue [[préhensile]] est noire et mesure entre <template><title>unité</title><part><name index=\"1\"/><value>30 et 50</value></part><part><name index=\"2\"/><value>cm</value></part></template> de long : avec elle, il peut saisir sa nourriture mais aussi nettoyer toutes les parties de son corps, y compris ses oreilles.\n\nSon pelage court est d’un brun chocolat sur le corps avec des zébrures noires et blanches sur les pattes et l’arrière-train. La tête est marquée d’une tache blanche au niveau de la joue.\n\n<h level=\"2\" i=\"2\">== Histoire ==</h>\nLes [[pygmée]]s de l’actuelle [[République démocratique du Congo]] connaissaient depuis longtemps l’okapi qu’ils prenaient parfois au piège dans des trous camouflés. Ils l’appelaient ''o’api''. En 1890, le journaliste [[Henry Morton Stanley]] (1841-1904) venu à la rencontre des pygmées rapporte l’existence d’une sorte d’âne-zèbre broutant des feuilles. Sir [[Harry Hamilton Johnston]] (1858-1927), futur gouverneur de l’[[Ouganda]], curieux de cet animal étrange, partit en 1899 à sa recherche et le baptisa ''Equus johnstoni'', pensant qu’il s’agissait d’une nouvelle espèce de [[zèbre]] (du genre ''Equus''). En 1901, il réussit à se procurer la peau entière d’un okapi ainsi que deux crânes. Leur étude révéla qu’il ne s’agissait pas d’un [[zèbre]] mais d’une espèce d'un nouveau genre et on changea son nom en ''Okapia johnstoni''.\n\n<h level=\"2\" i=\"3\">== Alimentation ==</h>\nL’okapi se nourrit de [[feuille]]s, de divers végétaux différents (dont l’[[euphorbe]], particulièrement toxique pour l’homme), de bourgeons, de branches tendres, de fruits, de champignons et de fougères. Il cueille sa nourriture à l’aide de sa langue et de ses lèvres préhensiles. Il comble ses besoins en minéraux en mangeant de l’argile sulfureuse qu’il trouve près des rivières ou des [[graminée]]s poussant sur des sols hautement minéralisés.\n\n<h level=\"2\" i=\"4\">== Habitat ==</h>\nL’okapi est un animal discret et solitaire qui ne fréquente ses pairs qu’au moment de la reproduction. On compte généralement deux individus au km². Sédentaire, il vit sur un territoire qu’il marque par des dépôts d’urine et des sécrétions issues de glandes situées entre ses doigts. Il emprunte toujours les mêmes pistes de passage qu’il a ainsi marquées. C’est un animal essentiellement nocturne dont le principal prédateur est le [[Léopard (félin)|léopard]]. Ses oreilles très grandes lui permettent d'entendre le moindre bruit en cas d'attaque.\n\n<h level=\"2\" i=\"5\">== Reproduction ==</h>\nLa saison des amours a lieu de mai à juillet. La femelle, qui a déjà signalé sa piste par ses sécrétions odoriférantes, guide le mâle à travers la forêt dense en émettant des appels ressemblant à des toussotements. Il peut y avoir des affrontements entre les mâles convoitant une même femelle. Les deux membres du couple se rejoignent finalement dans une courte parade nuptiale faite de fuites et d’esquives puis s’accouplent. Après une [[gestation]] de <template><title>unité</title><part><name index=\"1\"/><value>15</value></part><part><name index=\"2\"/><value>mois</value></part></template> environ, elle donne naissance à un petit d’environ <template><title>unité</title><part><name index=\"1\"/><value>75</value></part><part><name index=\"2\"/><value>cm</value></part></template> au garrot et pesant environ <template><title>unité</title><part><name index=\"1\"/><value>20</value></part><part><name index=\"2\"/><value>kg</value></part></template>. Celui-ci suit sa mère pendant quelques jours jusqu’à trouver un fourré où se cacher. Il y reste la plupart de son temps jusqu’à atteindre l’âge de deux mois, à partir duquel il suit sa mère dans ses déplacements. Le [[Sevrage (alimentation)|sevrage]] a lieu entre <template><title>unité</title><part><name index=\"1\"/><value>6 et 10</value></part><part><name index=\"2\"/><value>mois</value></part></template>.\n\n<h level=\"2\" i=\"6\">== Une espèce menacée ==</h>\nL’okapi figure sur la liste rouge des espèces menacées de l’[[UICN]]. En effet, son habitat est de plus en plus restreint. Même à l’intérieur de la réserve, l’okapi est victime du [[braconnage]], surtout dans le parc national de Virunga. Leur population est estimée de <template><title>unité</title><part><name index=\"1\"/><value>10000 à 35000</value></part><part><name index=\"2\"/><value>individus</value></part></template> et la tendance est à la baisse. Cet animal est protégé depuis 1933<ext><name>ref</name><attr/><inner>{{en}} {{lien web|url=http://www.iucnredlist.org/details/15188|titre=l'okapi sur le site de l'UICN|site=iucnredlist.org|citation=|en ligne le=|consulté le=3 juillet 2012}}.</inner><close>&lt;/ref&gt;</close></ext>. L'espèce est en danger depuis décembre 2013.\n\n<h level=\"2\" i=\"7\">== La vie en captivité ==</h>\n[[Fichier:Okapia johnstoni (Okapi) - 437.jpg|vignette|Un okapia johnstoni (Okapi) au [[ZooParc de Beauval]] à [[Saint-Aignan (Loir-et-Cher)|Saint-Aignan]], France.]]\n\nLa survie de l’okapi dépend aussi des zoos où il peut vivre et se reproduire en sécurité. Toutefois, son acclimatation à la vie en captivité a été difficile. Le premier spécimen ramené en [[Europe]] fut donné au [[zoo d'Anvers]] en 1918 mais ne survécut que <template><title>unité</title><part><name index=\"1\"/><value>50</value></part><part><name index=\"2\"/><value>jours</value></part></template>. Jusqu’en 1940, toutes les tentatives d’acclimatation de l’okapi en zoo furent des échecs hormis à Anvers où un individu vécut <template><title>unité</title><part><name index=\"1\"/><value>15</value></part><part><name index=\"2\"/><value>ans</value></part></template> à partir de 1928. La première naissance en captivité eut lieu à Anvers en 1954 mais le petit ne vécut qu’une journée. D’autres naissances eurent lieu dans divers zoos mais les petits ne survivaient jamais longtemps. En 1957 eut lieu la première naissance viable, au [[zoo de Vincennes]].\n\n<h level=\"2\" i=\"8\">== Sources ==</h>\n* [http://www.leszoosdanslemonde.com/introduction/archives_actualites/2003/07_2003_vincennes.htm Les okapis et le parc zoologique de Paris]\n* [http://www.thebigzoo.com/Animals/Okapi.asp Un site en anglais sur l'okapi]\n* [http://www.dinosoria.com/okapi.htm L'okapi]\n* [http://www.webjunoir.net/encyclopedie/l-okapi-99.php]\n\n<h level=\"2\" i=\"9\">== Références ==</h>\n<template lineStart=\"1\"><title>Références</title></template>\n\n<h level=\"2\" i=\"10\">== Liens externes ==</h>\n<template lineStart=\"1\"><title>Autres projets\n</title><part><name>commons</name><equals>=</equals><value>Category:Okapia johnstoni\n</value></part><part><name>wikispecies</name><equals>=</equals><value>Okapia johnstoni\n</value></part></template>\n* <template><title>ADW</title><part><name index=\"1\"/><value>Okapia_johnstoni</value></part><part><name index=\"2\"/><value>''Okapia johnstoni''</value></part><part><name>consulté le</name><equals>=</equals><value>28 Nov 2013</value></part></template>\n* <template><title>ARKive GES</title><part><name index=\"1\"/><value>mammals</value></part><part><name index=\"2\"/><value>Okapia</value></part><part><name index=\"3\"/><value>johnstoni</value></part><part><name>consulté le</name><equals>=</equals><value>28 Nov 2013</value></part></template>\n* <template><title>ITIS</title><part><name index=\"1\"/><value>625037</value></part><part><name index=\"2\"/><value>''Okapia johnstoni''  (P. L. Sclater, 1901)</value></part><part><name>consulté le</name><equals>=</equals><value>28 Nov 2013</value></part></template>\n* <template><title>MSW</title><part><name index=\"1\"/><value>14200484</value></part><part><name index=\"2\"/><value>Okapia johnstoni</value></part><part><name index=\"3\"/><value>P. L. Sclater, 1901</value></part><part><name>consulté le</name><equals>=</equals><value>28 Nov 2013</value></part></template>\n* <template><title>NCBI</title><part><name index=\"1\"/><value>86973</value></part><part><name index=\"2\"/><value>''Okapia johnstoni''</value></part><part><name>consulté le</name><equals>=</equals><value>28 Nov 2013</value></part></template>\n* <template><title>Tolweb</title><part><name index=\"1\"/><value>Okapia johnstoni</value></part><part><name>consulté le</name><equals>=</equals><value>28 Nov 2013</value></part></template>\n* <template><title>uBIO</title><part><name index=\"1\"/><value>106096</value></part><part><name index=\"2\"/><value>''Okapia johnstoni''  (P. L. Sclater, 1901)</value></part><part><name>consulté le</name><equals>=</equals><value>28 Nov 2013</value></part></template>\n* <template><title>UICN</title><part><name index=\"1\"/><value>15188</value></part><part><name index=\"2\"/><value>''Okapia johnstoni'' (Sclater, 1901)</value></part><part><name>consulté le</name><equals>=</equals><value>27 mai 2015</value></part></template>\n\n<template lineStart=\"1\"><title>Palette Cryptozoologie</title></template>\n\n<template lineStart=\"1\"><title>Portail</title><part><name index=\"1\"/><value>Mammifères</value></part></template>\n\n[[Catégorie:Mammifère (nom vernaculaire)]]\n[[Catégorie:Giraffidae]]\n[[Catégorie:Faune d'Afrique centrale]]</root>"}}"""

cache = {'info': {'status': 200}, 'query': query, 'response': response}
