# -*- coding:utf-8 -*-

query = 'https://de.wikipedia.org/w/api.php?action=parse&formatversion=2&contentmodel=text&disableeditsection=&disablelimitreport=&disabletoc=&prop=text|iwlinks|parsetree|wikitext|displaytitle|properties&redirects&page=Lewisit'

response = r"""{"parse":{"title":"Lewisit","pageid":800460,"redirects":[],"text":"<div class=\"mw-parser-output\"><table class=\"float-right infobox wikitable\" id=\"Vorlage_Infobox_Chemikalie\" style=\"font-size:90%; margin-top:0; width:350px;\" summary=\"Infobox Chemikalie\">\n\n<tbody><tr>\n<th colspan=\"2\" style=\"background:#FFDEAD;\"> Strukturformel\n</th></tr>\n<tr>\n<td colspan=\"2\" style=\"background:#FFFFFF; text-align:center;\"> <a href=\"/wiki/Datei:Lewisite_structures.svg\" class=\"image\" title=\"Struktur von Lewisit\"><img alt=\"Struktur von Lewisit\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/d/d4/Lewisite_structures.svg/300px-Lewisite_structures.svg.png\" width=\"300\" height=\"72\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/d/d4/Lewisite_structures.svg/450px-Lewisite_structures.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/d/d4/Lewisite_structures.svg/600px-Lewisite_structures.svg.png 2x\" data-file-width=\"1143\" data-file-height=\"275\" /></a>\n</td></tr>\n<tr>\n<td colspan=\"2\" style=\"text-align:center; font-size:80%;\"> <i>trans</i>- und <i>cis</i>-Isomer\n</td></tr>\n\n\n\n\n\n\n\n\n<tr>\n<th colspan=\"2\" style=\"background:#FFDEAD;\"> Allgemeines\n</th></tr>\n<tr>\n<td style=\"width:33%;\"> Name\n</td>\n<td> Lewisit\n</td></tr>\n<tr>\n<td> Andere Namen\n</td>\n<td>\n<ul><li>2-Chlorvinyldichlorarsin</li>\n<li> Dichlor(2-chlorvinyl)arsin</li>\n<li> 2-Chlorvinylarsindichlorid</li>\n<li> 2-Chlorethylendichlorarsin</li>\n<li> Lewisit I</li></ul>\n</td></tr>\n<tr>\n<td> <a href=\"/wiki/Summenformel\" title=\"Summenformel\">Summenformel</a>\n</td>\n<td> C<sub>2</sub>H<sub>2</sub>AsCl<sub>3</sub>\n</td></tr>\n<tr>\n<td> Kurzbeschreibung\n</td>\n<td>\n<p>ölige, farb- und geruchlose Flüssigkeit <sup id=\"cite_ref-GESTIS_1-0\" class=\"reference\"><a href=\"#cite_note-GESTIS-1\">&#91;1&#93;</a></sup>\n</p>\n</td></tr>\n<tr>\n<th colspan=\"2\" style=\"background:#FFDEAD;\"> Externe Identifikatoren/Datenbanken\n</th></tr>\n<tr>\n<td colspan=\"2\" style=\"padding:0;\">\n<table class=\"mw-collapsible mw-collapsed wikitable\" data-expandtext=\"+\" data-collapsetext=\"−\" style=\"border-top:none; margin:-1px; width:calc(100% + 2px);\">\n\n<tbody><tr>\n<td style=\"width:33%;\"> <a href=\"/wiki/CAS-Nummer\" title=\"CAS-Nummer\">CAS-Nummer</a>\n</td>\n<td> 541-25-3\n</td>\n<td style=\"background:#FFDEAD; border-top:1px solid #FFDEAD; padding:0.2em 0; vertical-align:bottom; width:5%;\">\n</td></tr>\n\n\n\n\n<tr>\n<td> <a href=\"/wiki/PubChem\" title=\"PubChem\">PubChem</a>\n</td>\n<td colspan=\"2\"> <a rel=\"nofollow\" class=\"external text\" href=\"https://pubchem.ncbi.nlm.nih.gov/compound/5372798\">5372798</a>\n</td></tr>\n\n\n\n\n<tr>\n<td style=\"border-right:1px solid #a2a9b1;\"> <a href=\"/wiki/Wikidata\" title=\"Wikidata\">Wikidata</a>\n</td>\n<td colspan=\"2\"> <a href=\"https://www.wikidata.org/wiki/Q407502\" class=\"extiw\" title=\"d:Q407502\">Q407502</a>\n</td></tr></tbody></table>\n</td></tr>\n\n\n\n\n\n\n\n\n<tr>\n<th colspan=\"2\" style=\"background:#FFDEAD;\"> Eigenschaften\n</th></tr>\n<tr>\n<td> <a href=\"/wiki/Molare_Masse\" title=\"Molare Masse\">Molare Masse</a>\n</td>\n<td> 207,32 g·<a href=\"/wiki/Mol\" title=\"Mol\">mol</a><sup>−1</sup>\n</td></tr>\n<tr>\n<td> <a href=\"/wiki/Aggregatzustand\" title=\"Aggregatzustand\">Aggregatzustand</a>\n</td>\n<td>\n<p>flüssig\n</p>\n</td></tr>\n<tr>\n<td> <a href=\"/wiki/Dichte\" title=\"Dichte\">Dichte</a>\n</td>\n<td>\n<ul><li> 1,8793 g·cm<sup>−3</sup> (25 °C, <i>trans</i>-Isomer) <sup id=\"cite_ref-Whiting_2-0\" class=\"reference\"><a href=\"#cite_note-Whiting-2\">&#91;2&#93;</a></sup></li>\n<li> 1,8598 g·cm<sup>−3</sup> (25 °C, <i>cis</i>-Isomer) <sup id=\"cite_ref-Whiting_2-1\" class=\"reference\"><a href=\"#cite_note-Whiting-2\">&#91;2&#93;</a></sup></li></ul>\n</td></tr>\n<tr>\n<td> <a href=\"/wiki/Schmelzpunkt\" title=\"Schmelzpunkt\">Schmelzpunkt</a>\n</td>\n<td>\n<ul><li> −2,4 <a href=\"/wiki/Grad_Celsius\" title=\"Grad Celsius\">°C</a> (<i>trans</i>-Isomer) <sup id=\"cite_ref-3\" class=\"reference\"><a href=\"#cite_note-3\">&#91;3&#93;</a></sup></li>\n<li> −44,7&#160;°C (<i>cis</i>-Isomer) <sup id=\"cite_ref-GESTIS_1-1\" class=\"reference\"><a href=\"#cite_note-GESTIS-1\">&#91;1&#93;</a></sup></li></ul>\n</td></tr>\n<tr>\n<td> <a href=\"/wiki/Siedepunkt\" title=\"Siedepunkt\">Siedepunkt</a>\n</td>\n<td>\n<ul><li> 196,6 °C (Zersetzung, <i>trans</i>-Isomer) <sup id=\"cite_ref-Whiting_2-2\" class=\"reference\"><a href=\"#cite_note-Whiting-2\">&#91;2&#93;</a></sup></li>\n<li> 169,8&#160;°C (Zersetzung, <i>cis</i>-Isomer) <sup id=\"cite_ref-GESTIS_1-2\" class=\"reference\"><a href=\"#cite_note-GESTIS-1\">&#91;1&#93;</a></sup></li></ul>\n</td></tr>\n\n\n<tr>\n<td> <a href=\"/wiki/Dampfdruck\" title=\"Dampfdruck\">Dampfdruck</a>\n</td>\n<td>\n<ul><li> 53 <a href=\"/wiki/Pascal_(Einheit)\" title=\"Pascal (Einheit)\">Pa</a> (<i>trans</i>-Isomer, 25 °C) <sup id=\"cite_ref-roempp_4-0\" class=\"reference\"><a href=\"#cite_note-roempp-4\">&#91;4&#93;</a></sup></li>\n<li> 208 <a href=\"/wiki/Pascal_(Einheit)\" title=\"Pascal (Einheit)\">Pa</a> (<i>cis</i>-Isomer, 25 °C) <sup id=\"cite_ref-roempp_4-1\" class=\"reference\"><a href=\"#cite_note-roempp-4\">&#91;4&#93;</a></sup></li></ul>\n</td></tr>\n\n\n<tr>\n<td> <a href=\"/wiki/L%C3%B6slichkeit\" title=\"Löslichkeit\">Löslichkeit</a>\n</td>\n<td>\n<ul><li> 0,5 g·l<sup>−1</sup> in Wasser (20 °C) <sup id=\"cite_ref-roempp_4-2\" class=\"reference\"><a href=\"#cite_note-roempp-4\">&#91;4&#93;</a></sup></li>\n<li> löslich in <a href=\"/wiki/Ethanol\" title=\"Ethanol\">Ethanol</a>, <a href=\"/wiki/Halogenalkane\" class=\"mw-redirect\" title=\"Halogenalkane\">Halogenalkanen</a> und <a href=\"/wiki/Benzin\" class=\"mw-disambig\" title=\"Benzin\">Benzin</a> <sup id=\"cite_ref-roempp_4-3\" class=\"reference\"><a href=\"#cite_note-roempp-4\">&#91;4&#93;</a></sup></li></ul>\n</td></tr>\n\n\n\n\n<tr>\n<td> <a href=\"/wiki/Brechungsindex\" title=\"Brechungsindex\">Brechungsindex</a>\n</td>\n<td>\n<ul><li> 1,6076 (25 °C, <i>trans</i>-Isomer) <sup id=\"cite_ref-Whiting_2-3\" class=\"reference\"><a href=\"#cite_note-Whiting-2\">&#91;2&#93;</a></sup></li>\n<li> 1,5859 (25 °C, <i>cis</i>-Isomer) <sup id=\"cite_ref-Whiting_2-4\" class=\"reference\"><a href=\"#cite_note-Whiting-2\">&#91;2&#93;</a></sup></li></ul>\n</td></tr>\n<tr>\n<th colspan=\"2\" style=\"background:#FFDEAD;\"> Sicherheitshinweise\n</th></tr>\n<tr>\n<td colspan=\"2\">\n<table cellspacing=\"0\" cellpadding=\"2\" style=\"width:100%;\">\n\n\n\n\n<tbody><tr>\n<th colspan=\"2\"> <a href=\"/wiki/Global_harmonisiertes_System_zur_Einstufung_und_Kennzeichnung_von_Chemikalien\" title=\"Global harmonisiertes System zur Einstufung und Kennzeichnung von Chemikalien\">GHS-Gefahrstoffkennzeichnung</a> &#32;aus&#160;<a href=\"/wiki/Verordnung_(EG)_Nr._1272/2008_(CLP)\" title=\"Verordnung (EG) Nr. 1272/2008 (CLP)\">Verordnung&#160;(EG) Nr.&#160;1272/2008&#160;(CLP)</a>,<sup id=\"cite_ref-CLP_100.240.769_5-0\" class=\"reference\"><a href=\"#cite_note-CLP_100.240.769-5\">&#91;5&#93;</a></sup> ggf. erweitert<span class=\"editoronly\" style=\"display:none;\"></span><sup id=\"cite_ref-GESTIS_1-3\" class=\"reference\"><a href=\"#cite_note-GESTIS-1\">&#91;1&#93;</a></sup>\n<table style=\"text-align:center; margin-left:auto; margin-right:auto; background-color:transparent;\">\n\n<tbody><tr>\n<td> <a href=\"/wiki/Global_harmonisiertes_System_zur_Einstufung_und_Kennzeichnung_von_Chemikalien#Übersicht:_EU-Gefahrensymbole,_UN/GHS-Gefahrenpiktogramme,_UN/ADR-Gefahrensymbole\" title=\"06 – Giftig oder sehr giftig\"><img alt=\"06 – Giftig oder sehr giftig\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/58/GHS-pictogram-skull.svg/80px-GHS-pictogram-skull.svg.png\" width=\"80\" height=\"80\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/58/GHS-pictogram-skull.svg/120px-GHS-pictogram-skull.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/58/GHS-pictogram-skull.svg/160px-GHS-pictogram-skull.svg.png 2x\" data-file-width=\"724\" data-file-height=\"724\" /></a>\n</td>\n<td> <a href=\"/wiki/Global_harmonisiertes_System_zur_Einstufung_und_Kennzeichnung_von_Chemikalien#Übersicht:_EU-Gefahrensymbole,_UN/GHS-Gefahrenpiktogramme,_UN/ADR-Gefahrensymbole\" title=\"09 – Umweltgefährlich\"><img alt=\"09 – Umweltgefährlich\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/b/b9/GHS-pictogram-pollu.svg/80px-GHS-pictogram-pollu.svg.png\" width=\"80\" height=\"80\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/b/b9/GHS-pictogram-pollu.svg/120px-GHS-pictogram-pollu.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/b/b9/GHS-pictogram-pollu.svg/160px-GHS-pictogram-pollu.svg.png 2x\" data-file-width=\"724\" data-file-height=\"724\" /></a>\n</td></tr></tbody></table>\n<p>Gefahr\n</p>\n</th></tr>\n<tr>\n<td rowspan=\"2\" width=\"33%\" style=\"border-top:1px #A7A7A7 dashed; border-right:1px #A7A7A7 dashed;\"> <a href=\"/wiki/H-_und_P-S%C3%A4tze\" title=\"H- und P-Sätze\">H- und P-Sätze</a>\n</td>\n<td style=\"border-top:1px #A7A7A7 dashed;\"> H: <a href=\"/wiki/H-_und_P-S%C3%A4tze#H-Sätze\" title=\"H- und P-Sätze\"><span style=\"display:inline-block;\"><span style=\"color:#ff5400; border-bottom:1px dotted #ff5400;\" title=\"Giftig bei Einatmen.\">331</span></span></a>&#8203;&#8208;&#8203;<a href=\"/wiki/H-_und_P-S%C3%A4tze#H-Sätze\" title=\"H- und P-Sätze\"><span style=\"display:inline-block;\"><span style=\"color:#ff5400; border-bottom:1px dotted #ff5400;\" title=\"Giftig bei Verschlucken.\">301</span></span></a>&#8203;&#8208;&#8203;<a href=\"/wiki/H-_und_P-S%C3%A4tze#H-Sätze\" title=\"H- und P-Sätze\"><span style=\"display:inline-block;\"><span style=\"color:#ff5400; border-bottom:1px dotted #ff5400;\" title=\"Sehr giftig für Wasserorganismen mit langfristiger Wirkung.\">410</span></span></a>\n</td></tr>\n\n\n\n<tr>\n<td style=\"border-top:1px #A7A7A7 dashed;\"> P: <span style=\"color:#ff5400; border-bottom:1px dotted #ff5400;\" title=\"Fehlende P-Sätze\">?</span>\n</td></tr>\n\n</tbody></table>\n</td></tr>\n\n\n\n\n<tr>\n<td> <a href=\"/wiki/Toxizit%C3%A4t\" title=\"Toxizität\">Toxikologische Daten</a>\n</td>\n<td>\n<ul><li> 6 <a href=\"/wiki/Parts_per_million\" title=\"Parts per million\">ppm</a> (<a href=\"/wiki/Letale_Konzentration\" title=\"Letale Konzentration\">LC<sub>Lo</sub></a>,&#160;<a href=\"/wiki/Mensch\" title=\"Mensch\">Mensch</a>,&#160;<a href=\"/wiki/Inhalation\" title=\"Inhalation\">inh.</a>)<sup id=\"cite_ref-ChemIDplus_6-0\" class=\"reference\"><a href=\"#cite_note-ChemIDplus-6\">&#91;6&#93;</a></sup><span class=\"editoronly\" style=\"display:none;\"></span></li>\n<li> 37,6 mg·kg<sup>−1</sup> (<a href=\"/wiki/Letale_Dosis\" title=\"Letale Dosis\">LD<sub>Lo</sub></a>,&#160;<a href=\"/wiki/Mensch\" title=\"Mensch\">Mensch</a>,&#160;<a href=\"/wiki/Perkutan\" title=\"Perkutan\">perkutan</a>)<sup id=\"cite_ref-ChemIDplus_6-1\" class=\"reference\"><a href=\"#cite_note-ChemIDplus-6\">&#91;6&#93;</a></sup><span class=\"editoronly\" style=\"display:none;\"></span></li></ul>\n</td></tr>\n\n\n\n\n\n\n\n\n\n\n<tr>\n<td colspan=\"2\" style=\"background:#FFDEAD; font-size:80%; line-height:150%; padding:.25em;\"> Soweit möglich und gebräuchlich, werden <a href=\"/wiki/Internationales_Einheitensystem\" title=\"Internationales Einheitensystem\">SI-Einheiten</a> verwendet. Wenn nicht anders vermerkt, gelten die angegebenen Daten bei <a href=\"/wiki/Standardbedingungen\" title=\"Standardbedingungen\">Standardbedingungen</a>. Brechungsindex: <a href=\"/wiki/Natrium-D-Linie\" title=\"Natrium-D-Linie\">Na-D-Linie</a>, 20&#160;°C\n</td></tr></tbody></table><div style=\"display:none;\"><a href=\"/w/index.php?title=Vorlage:Infobox_Chemikalie/Summenformelsuche_vorhanden&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Vorlage:Infobox Chemikalie/Summenformelsuche vorhanden (Seite nicht vorhanden)\">Vorlage:Infobox Chemikalie/Summenformelsuche vorhanden</a></div><p><span class=\"editoronly\" style=\"display:none;\"></span>\n</p><p><b>Lewisit</b>, auch <i>Lewisit I</i> genannt, ist eine <a href=\"/wiki/Chlor\" title=\"Chlor\">chlorhaltige</a> organische <a href=\"/wiki/Arsen\" title=\"Arsen\">Arsenverbindung</a>, deren Wirkung beim Einsatz als <a href=\"/wiki/Chemische_Waffe\" title=\"Chemische Waffe\">chemische Waffe</a> den <a href=\"/wiki/Loste\" title=\"Loste\">Losten</a> ähnelt. Die Substanz bewirkt ein starkes Brennen der Haut mit Blasenbildung. Lewisit wurde nach dem amerikanischen Chemiker <a href=\"/w/index.php?title=Winford_Lee_Lewis&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Winford Lee Lewis (Seite nicht vorhanden)\">Winford Lee Lewis</a> (1879–1943) benannt. Unter Soldaten trug es den Beinamen <i>Tau des Todes</i>.\n</p><p>Es existieren mit dem <i>trans</i>-Lewisit und dem <i>cis</i>-Lewisit (auch Isolewisit genannt) zwei <a href=\"/wiki/Cis-trans-Isomerie\" title=\"Cis-trans-Isomerie\">Konfigurationsisomere</a>.\n</p>\n\n<h2><span class=\"mw-headline\" id=\"Geschichte_und_Darstellung\">Geschichte und Darstellung</span></h2>\n<p>Winford Lee Lewis stellte die Substanz 1918 durch Reaktion von <a href=\"/wiki/Arsen(III)-chlorid\" title=\"Arsen(III)-chlorid\">Arsentrichlorid</a> (AsCl<sub>3</sub>) mit <a href=\"/wiki/Ethin\" title=\"Ethin\">Ethin</a> (Acetylen) in Anwesenheit von <a href=\"/wiki/Chlorwasserstoff\" title=\"Chlorwasserstoff\">Chlorwasserstoff</a> in einer <a href=\"/wiki/Quecksilber(II)-chlorid\" title=\"Quecksilber(II)-chlorid\">Quecksilber(II)-chlorid</a>-Lösung (HgCl<sub>2</sub>) her:\n</p>\n<dl><dd><span class=\"mwe-math-element\"><span class=\"mwe-math-mathml-inline mwe-math-mathml-a11y\" style=\"display: none;\"><math xmlns=\"http://www.w3.org/1998/Math/MathML\"  alttext=\"{\\displaystyle \\mathrm {AsCl_{3}+HC{\\equiv }CH\\ {\\xrightarrow[{HCl}]{HgCl_{2}}}\\ Cl_{2}As{-}CH{=}CHCl} }\">\n  <semantics>\n    <mrow class=\"MJX-TeXAtom-ORD\">\n      <mstyle displaystyle=\"true\" scriptlevel=\"0\">\n        <mrow class=\"MJX-TeXAtom-ORD\">\n          <mi mathvariant=\"normal\">A</mi>\n          <mi mathvariant=\"normal\">s</mi>\n          <mi mathvariant=\"normal\">C</mi>\n          <msub>\n            <mi mathvariant=\"normal\">l</mi>\n            <mrow class=\"MJX-TeXAtom-ORD\">\n              <mn>3</mn>\n            </mrow>\n          </msub>\n          <mo>+</mo>\n          <mi mathvariant=\"normal\">H</mi>\n          <mi mathvariant=\"normal\">C</mi>\n          <mrow class=\"MJX-TeXAtom-ORD\">\n            <mo>&#x2261;<!-- ≡ --></mo>\n          </mrow>\n          <mi mathvariant=\"normal\">C</mi>\n          <mi mathvariant=\"normal\">H</mi>\n          <mtext>&#xA0;</mtext>\n          <mrow class=\"MJX-TeXAtom-ORD\">\n            <munderover>\n              <mo>&#x2192;</mo>\n              <mpadded width=\"+0.611em\" lspace=\"0.278em\" voffset=\"-.24em\">\n                <mrow class=\"MJX-TeXAtom-ORD\">\n                  <mi mathvariant=\"normal\">H</mi>\n                  <mi mathvariant=\"normal\">C</mi>\n                  <mi mathvariant=\"normal\">l</mi>\n                </mrow>\n              </mpadded>\n              <mpadded width=\"+0.611em\" lspace=\"0.278em\" voffset=\".15em\">\n                <mi mathvariant=\"normal\">H</mi>\n                <mi mathvariant=\"normal\">g</mi>\n                <mi mathvariant=\"normal\">C</mi>\n                <msub>\n                  <mi mathvariant=\"normal\">l</mi>\n                  <mrow class=\"MJX-TeXAtom-ORD\">\n                    <mn>2</mn>\n                  </mrow>\n                </msub>\n              </mpadded>\n            </munderover>\n          </mrow>\n          <mtext>&#xA0;</mtext>\n          <mi mathvariant=\"normal\">C</mi>\n          <msub>\n            <mi mathvariant=\"normal\">l</mi>\n            <mrow class=\"MJX-TeXAtom-ORD\">\n              <mn>2</mn>\n            </mrow>\n          </msub>\n          <mi mathvariant=\"normal\">A</mi>\n          <mi mathvariant=\"normal\">s</mi>\n          <mrow class=\"MJX-TeXAtom-ORD\">\n            <mo>&#x2212;<!-- − --></mo>\n          </mrow>\n          <mi mathvariant=\"normal\">C</mi>\n          <mi mathvariant=\"normal\">H</mi>\n          <mrow class=\"MJX-TeXAtom-ORD\">\n            <mo>=</mo>\n          </mrow>\n          <mi mathvariant=\"normal\">C</mi>\n          <mi mathvariant=\"normal\">H</mi>\n          <mi mathvariant=\"normal\">C</mi>\n          <mi mathvariant=\"normal\">l</mi>\n        </mrow>\n      </mstyle>\n    </mrow>\n    <annotation encoding=\"application/x-tex\">{\\displaystyle \\mathrm {AsCl_{3}+HC{\\equiv }CH\\ {\\xrightarrow[{HCl}]{HgCl_{2}}}\\ Cl_{2}As{-}CH{=}CHCl} }</annotation>\n  </semantics>\n</math></span><img src=\"https://wikimedia.org/api/rest_v1/media/math/render/svg/22931ff390e49dc51c719f761e8a4c4c351acfe3\" class=\"mwe-math-fallback-image-inline\" aria-hidden=\"true\" style=\"vertical-align: -1.843ex; margin-top: -0.326ex; margin-bottom: -0.662ex; width:43.366ex; height:6.009ex;\" alt=\"{\\displaystyle \\mathrm {AsCl_{3}+HC{\\equiv }CH\\ {\\xrightarrow[{HCl}]{HgCl_{2}}}\\ Cl_{2}As{-}CH{=}CHCl} }\" /></span></dd></dl>\n<p>Als Nebenprodukte entstehen noch β-Lewisit (2,2’-Dichlordivinylarsinchlorid) und γ-Lewisit (1,1’,1’’-Trichlortrivinylarsin).<sup id=\"cite_ref-roempp_4-4\" class=\"reference\"><a href=\"#cite_note-roempp-4\">&#91;4&#93;</a></sup>\n</p><p>Später wurde die Substanz gezielt von der US-amerikanischen Armee als chemischer Kampfstoff weiterentwickelt und hergestellt.<sup id=\"cite_ref-7\" class=\"reference\"><a href=\"#cite_note-7\">&#91;7&#93;</a></sup> Teilweise wurde es als Giftgasgemisch zusammen mit <a href=\"/wiki/Senfgas\" title=\"Senfgas\">Senfgas</a> als <i>Mustard-Lewisite</i> eingesetzt. Es wurden insgesamt etwa 20.000 <a href=\"/wiki/Tonne_(Einheit)\" title=\"Tonne (Einheit)\">t</a> Lewisit hergestellt. Seit Ende der 1950er Jahre wurde der Einsatz eingestellt. <a href=\"/wiki/Japan\" title=\"Japan\">Japan</a> produzierte im <a href=\"/wiki/Zweiter_Weltkrieg\" title=\"Zweiter Weltkrieg\">Zweiten Weltkrieg</a> ebenfalls Lewisit und hatte Bestände im besetzten <a href=\"/wiki/China\" title=\"China\">China</a> vergraben, die 2006 wiederentdeckt wurden.<sup id=\"cite_ref-8\" class=\"reference\"><a href=\"#cite_note-8\">&#91;8&#93;</a></sup>\n</p>\n<h2><span class=\"mw-headline\" id=\"Eigenschaften\">Eigenschaften</span></h2>\n<p>Das <i>cis</i>-, das <i>trans</i>-Isomer bzw. das Isomerengemisch sind ölige, farb- und geruchlose Flüssigkeiten<sup id=\"cite_ref-roempp_4-5\" class=\"reference\"><a href=\"#cite_note-roempp-4\">&#91;4&#93;</a></sup>, die sich beim Kontakt mit Wasser zersetzen. Die Dämpfe sind sehr viel schwerer als Luft. Hinsichtlich der physikalischen Eigenschaften unterscheiden sich die Isomere stark. Das <i>cis</i>-Isomer besitzt einen wesentlich niedrigeren Schmelz- und Siedepunkt. Es ist wegen des höheren Dampfdrucks leichter flüchtig als das <i>trans</i>-Isomer. Die Dampfdruckkurve für das <i>cis</i>-Isomer ergibt sich nach lgp = 8,4131 - 2450,2/T, die des <i>trans</i>-Isomers nach lgp = 48660 - 13297·lgT - 4815,3/T (p in Torr, T in K).<sup id=\"cite_ref-Whiting_2-5\" class=\"reference\"><a href=\"#cite_note-Whiting-2\">&#91;2&#93;</a></sup>\n</p>\n<h2><span class=\"mw-headline\" id=\"Giftwirkung_und_Gegenmittel\">Giftwirkung und Gegenmittel</span></h2>\n<p>Die Aufnahme des Giftes kann über Haut, Atemwege und <a href=\"/wiki/Magen-Darm-Trakt\" class=\"mw-redirect\" title=\"Magen-Darm-Trakt\">Magen-Darm-Trakt</a> erfolgen. Lewisit reagiert mit den <a href=\"/wiki/Thiolgruppe\" class=\"mw-redirect\" title=\"Thiolgruppe\">Thiolgruppen</a> von Proteinen und stört somit, soweit <a href=\"/wiki/Enzym\" title=\"Enzym\">Enzyme</a> betroffen sind, massiv den Stoffwechsel. Ähnlich wie die Loste reagiert es auch mit <a href=\"/wiki/Desoxyribonukleins%C3%A4ure\" title=\"Desoxyribonukleinsäure\">DNA</a>-Molekülen, indem diese alkyliert werden.<sup id=\"cite_ref-wo_9-0\" class=\"reference\"><a href=\"#cite_note-wo-9\">&#91;9&#93;</a></sup> Auf der Haut erzeugt Lewisit sofort ein starkes Brennen, nach 30 Minuten <a href=\"/wiki/Erythema\" title=\"Erythema\">Erytheme</a>; nach 12 Stunden werden daraus scharf begrenzte, oberflächliche Blasen, bis zu tiefen schmerzhaften <a href=\"/wiki/Nekrose\" title=\"Nekrose\">Nekrosen</a>.<sup id=\"cite_ref-GESTIS_1-4\" class=\"reference\"><a href=\"#cite_note-GESTIS-1\">&#91;1&#93;</a></sup> \n</p><p>Als Gegenmittel kann <a href=\"/wiki/Dithioglycerin\" class=\"mw-redirect\" title=\"Dithioglycerin\">Dithioglycerin</a> (andere Bezeichnungen sind <i>BAL</i>, <i>British Anti Lewisite</i>, Dimercaprol bzw. 2,3-Dimercaptopropanol) verwendet werden. Dithioglycerin bindet Lewisit oder setzt an Proteine gebundenes Lewisit wieder frei.<sup id=\"cite_ref-wo_9-1\" class=\"reference\"><a href=\"#cite_note-wo-9\">&#91;9&#93;</a></sup>\n</p>\n<h2><span class=\"mw-headline\" id=\"Andere_Lewisite\">Andere Lewisite</span></h2>\n<p>Neben dem Lewisit I gibt es ferner noch: \n</p>\n<ul class=\"gallery mw-gallery-traditional\">\n\t\t<li class=\"gallerybox\" style=\"width: 185px\"><div style=\"width: 185px\">\n\t\t\t<div class=\"thumb\" style=\"width: 180px;\"><div style=\"margin:48px auto;\"><a href=\"/wiki/Datei:Lewisite2.png\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/1/13/Lewisite2.png/150px-Lewisite2.png\" width=\"150\" height=\"54\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/1/13/Lewisite2.png/225px-Lewisite2.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/1/13/Lewisite2.png/300px-Lewisite2.png 2x\" data-file-width=\"998\" data-file-height=\"357\" /></a></div></div>\n\t\t\t<div class=\"gallerytext\">\n<p>Lewisit II / β-Lewisit<br />(2,2’-Dichlordivinylarsinchlorid)<sup id=\"cite_ref-10\" class=\"reference\"><a href=\"#cite_note-10\">&#91;10&#93;</a></sup>\n</p>\n\t\t\t</div>\n\t\t</div></li>\n\t\t<li class=\"gallerybox\" style=\"width: 185px\"><div style=\"width: 185px\">\n\t\t\t<div class=\"thumb\" style=\"width: 180px;\"><div style=\"margin:30.5px auto;\"><a href=\"/wiki/Datei:Lewisite3.png\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/f/f1/Lewisite3.png/150px-Lewisite3.png\" width=\"150\" height=\"89\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/f/f1/Lewisite3.png/225px-Lewisite3.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/f/f1/Lewisite3.png/300px-Lewisite3.png 2x\" data-file-width=\"998\" data-file-height=\"595\" /></a></div></div>\n\t\t\t<div class=\"gallerytext\">\n<p>Lewisit III / γ-Lewisit<br />(1,1’,1’’-Trichlortrivinylarsin)<sup id=\"cite_ref-11\" class=\"reference\"><a href=\"#cite_note-11\">&#91;11&#93;</a></sup>\n</p>\n\t\t\t</div>\n\t\t</div></li>\n</ul>\n<h2><span class=\"mw-headline\" id=\"Internationale_Kontrollen\">Internationale Kontrollen</span></h2>\n<p>Lewisite werden als Chemikalien der Liste 1 der internationalen <a href=\"/wiki/Chemiewaffenkonvention\" title=\"Chemiewaffenkonvention\">Chemiewaffenkonvention</a> (auch <i>Chemiewaffenübereinkommen</i>, <i>CWÜ</i>)<sup id=\"cite_ref-12\" class=\"reference\"><a href=\"#cite_note-12\">&#91;12&#93;</a></sup> von der hierfür zuständigen Behörde <a href=\"/wiki/Organisation_f%C3%BCr_das_Verbot_chemischer_Waffen\" title=\"Organisation für das Verbot chemischer Waffen\">OPCW</a> mit Sitz in Den Haag kontrolliert. Die Entwicklung oder der Besitz zu Zwecken, die nicht ausschließlich der Forschung zur Verteidigung gegen diese Substanzen dienen, ist verboten. In Deutschland muss jeder Umgang mit Chemikalien der Liste 1 – ausgenommen im Geschäftsbereich des Bundesministeriums der Verteidigung – vom <a href=\"/wiki/Bundesamt_f%C3%BCr_Wirtschaft_und_Ausfuhrkontrolle\" title=\"Bundesamt für Wirtschaft und Ausfuhrkontrolle\">Bundesamt für Wirtschaft und Ausfuhrkontrolle</a> (BAFA) genehmigt werden und in Abhängigkeit von der ausgeübten Tätigkeit der OPCW gemeldet werden.<sup id=\"cite_ref-13\" class=\"reference\"><a href=\"#cite_note-13\">&#91;13&#93;</a></sup>\n</p>\n<h2><span class=\"mw-headline\" id=\"Siehe_auch\">Siehe auch</span></h2>\n<ul><li> <a href=\"/wiki/Liste_chemischer_Kampfstoffe\" title=\"Liste chemischer Kampfstoffe\">Liste chemischer Kampfstoffe</a></li>\n<li> <a href=\"/wiki/Gelbkreuz\" title=\"Gelbkreuz\">Gelbkreuz</a></li></ul>\n<h2><span class=\"mw-headline\" id=\"Weblinks\">Weblinks</span></h2>\n<ul><li> Haas, R. <i>et al.</i>: Chemisch-analytische Untersuchung von Arsenkampfstoffen und ihren Metaboliten, <i><a href=\"/wiki/UWSF_%E2%80%93_Z_Umweltchem_%C3%96kotox\" class=\"mw-redirect\" title=\"UWSF – Z Umweltchem Ökotox\">UWSF – Z Umweltchem Ökotox</a></i>; 10 (1998), 289–293; <a rel=\"nofollow\" class=\"external text\" href=\"http://www.r-haas.de/uwsf10_289_293.pdf\">PDF</a> (freier Volltextzugriff)</li></ul>\n<h2><span class=\"mw-headline\" id=\"Einzelnachweise\">Einzelnachweise</span></h2>\n<ol class=\"references\">\n<li id=\"cite_note-GESTIS-1\"><span class=\"mw-cite-backlink\">↑ <sup><a href=\"#cite_ref-GESTIS_1-0\">a</a></sup> <sup><a href=\"#cite_ref-GESTIS_1-1\">b</a></sup> <sup><a href=\"#cite_ref-GESTIS_1-2\">c</a></sup> <sup><a href=\"#cite_ref-GESTIS_1-3\">d</a></sup> <sup><a href=\"#cite_ref-GESTIS_1-4\">e</a></sup></span> <span class=\"reference-text\">Eintrag zu <i><a rel=\"nofollow\" class=\"external text\" href=\"http://gestis.itrust.de/nxt/gateway.dll?f=id$t=default.htm$vid=gestisdeu:sdbdeu$id=570100\">Chlorvinyldichlorarsin</a></i> in der <a href=\"/wiki/GESTIS-Stoffdatenbank\" title=\"GESTIS-Stoffdatenbank\">GESTIS-Stoffdatenbank</a> des <a href=\"/wiki/Institut_f%C3%BCr_Arbeitsschutz_der_Deutschen_Gesetzlichen_Unfallversicherung\" title=\"Institut für Arbeitsschutz der Deutschen Gesetzlichen Unfallversicherung\">IFA</a>, abgerufen am 16. Februar 2017<small class=\"noscript\"><span></span> (JavaScript erforderlich)</small>.</span>\n</li>\n<li id=\"cite_note-Whiting-2\"><span class=\"mw-cite-backlink\">↑ <sup><a href=\"#cite_ref-Whiting_2-0\">a</a></sup> <sup><a href=\"#cite_ref-Whiting_2-1\">b</a></sup> <sup><a href=\"#cite_ref-Whiting_2-2\">c</a></sup> <sup><a href=\"#cite_ref-Whiting_2-3\">d</a></sup> <sup><a href=\"#cite_ref-Whiting_2-4\">e</a></sup> <sup><a href=\"#cite_ref-Whiting_2-5\">f</a></sup></span> <span class=\"reference-text\">Whiting, G.H.: <i>Some physicochemical properties of cis-2-chlorovinyldichloroarsine</i> in <a href=\"/wiki/J._Chem._Soc.\" class=\"mw-redirect\" title=\"J. Chem. Soc.\">J. Chem. Soc.</a> 1948, 1209–1210, <a href=\"/wiki/Digital_Object_Identifier\" title=\"Digital Object Identifier\">doi</a>:<span class=\"uri-handle\"><a rel=\"nofollow\" class=\"external text\" href=\"//doi.org/10.1039%2FJR9480001209\">10.1039/JR9480001209</a></span>.</span>\n</li>\n<li id=\"cite_note-3\"><span class=\"mw-cite-backlink\"><a href=\"#cite_ref-3\">↑</a></span> <span class=\"reference-text\">Lebedev, B.V.; Kulagina, T.G.; Cheremukhina, A.A.; Karataev, E.N.: Russian J. Gen. Chem. 66 (1996) 880-885.</span>\n</li>\n<li id=\"cite_note-roempp-4\"><span class=\"mw-cite-backlink\">↑ <sup><a href=\"#cite_ref-roempp_4-0\">a</a></sup> <sup><a href=\"#cite_ref-roempp_4-1\">b</a></sup> <sup><a href=\"#cite_ref-roempp_4-2\">c</a></sup> <sup><a href=\"#cite_ref-roempp_4-3\">d</a></sup> <sup><a href=\"#cite_ref-roempp_4-4\">e</a></sup> <sup><a href=\"#cite_ref-roempp_4-5\">f</a></sup></span> <span class=\"reference-text\">Eintrag zu <i><a rel=\"nofollow\" class=\"external text\" href=\"https://roempp.thieme.de/roempp4.0/do/data/RD-12-01021\">Lewisit.</a></i> In: <i><a href=\"/wiki/R%C3%B6mpp_Lexikon_Chemie\" title=\"Römpp Lexikon Chemie\">Römpp Online</a>.</i> Georg Thieme Verlag, abgerufen am 5. November 2011.<span class=\"editoronly\" style=\"display:none;\"></span></span>\n</li>\n<li id=\"cite_note-CLP_100.240.769-5\"><span class=\"mw-cite-backlink\"><a href=\"#cite_ref-CLP_100.240.769_5-0\">↑</a></span> <span class=\"reference-text\">Nicht explizit in <a href=\"/wiki/Verordnung_(EG)_Nr._1272/2008_(CLP)#Anhang_VI\" title=\"Verordnung (EG) Nr. 1272/2008 (CLP)\">Verordnung (EG) Nr. 1272/2008 (CLP)</a> gelistet, fällt aber mit der angegebenen Kennzeichnung unter den Gruppeneintrag <a rel=\"nofollow\" class=\"external text\" href=\"http://echa.europa.eu/information-on-chemicals/cl-inventory-database/-/discli/substance/external/100.240.769\"><i>Arsenverbindungen, mit Ausnahme der namentlich in diesem Anhang bezeichneten</i></a> im <i>Classification and Labelling Inventory</i> der <a href=\"/wiki/Europ%C3%A4ische_Chemikalienagentur\" title=\"Europäische Chemikalienagentur\">Europäischen Chemikalienagentur</a> (ECHA), abgerufen am 1. Februar 2016. Hersteller bzw. <a href=\"/wiki/Inverkehrbringen\" title=\"Inverkehrbringen\">Inverkehrbringer</a> können die harmonisierte Einstufung und Kennzeichnung <a rel=\"nofollow\" class=\"external text\" href=\"http://www.reach-clp-biozid-helpdesk.de/de/CLP/Einstufung/Selbsteinstufung/Selbsteinstufung.html\">erweitern</a>.</span>\n</li>\n<li id=\"cite_note-ChemIDplus-6\"><span class=\"mw-cite-backlink\">↑ <sup><a href=\"#cite_ref-ChemIDplus_6-0\">a</a></sup> <sup><a href=\"#cite_ref-ChemIDplus_6-1\">b</a></sup></span> <span class=\"reference-text\">Eintrag zu <i><a rel=\"nofollow\" class=\"external text\" href=\"http://chem.sis.nlm.nih.gov/chemidplus/rn/541-25-3\">Lewisit</a></i> in der <a href=\"/wiki/ChemIDplus\" title=\"ChemIDplus\">ChemIDplus</a>-Datenbank der <a href=\"/wiki/United_States_National_Library_of_Medicine\" title=\"United States National Library of Medicine\">United States National Library of Medicine</a> (NLM)<span class=\"editoronly\" style=\"display:none;\"></span></span>\n</li>\n<li id=\"cite_note-7\"><span class=\"mw-cite-backlink\"><a href=\"#cite_ref-7\">↑</a></span> <span class=\"reference-text\">Domingo Tabangcura, Jr. and G. Patrick Daubert, MD. <a rel=\"nofollow\" class=\"external text\" href=\"http://www.chm.bris.ac.uk/motm/bal/development.html\">British anti-Lewisite Development</a> <i>Molecule of the Month</i>, University of Bristol School of Chemistry.</span>\n</li>\n<li id=\"cite_note-8\"><span class=\"mw-cite-backlink\"><a href=\"#cite_ref-8\">↑</a></span> <span class=\"reference-text\">NTI: <a rel=\"nofollow\" class=\"external text\" href=\"https://web.archive.org/web/20110929235753/http://www.nti.org/db/china/acwpos.htm\"><i>Abandoned Chemical Weapons (ACW) in China</i></a> (<a href=\"/wiki/Web-Archivierung#Begriffsbestimmung\" title=\"Web-Archivierung\">Memento</a> vom 29. September 2011 im <i><a href=\"/wiki/Internet_Archive\" title=\"Internet Archive\">Internet Archive</a></i>)<span style=\"display:none;\"></span>.</span>\n</li>\n<li id=\"cite_note-wo-9\"><span class=\"mw-cite-backlink\">↑ <sup><a href=\"#cite_ref-wo_9-0\">a</a></sup> <sup><a href=\"#cite_ref-wo_9-1\">b</a></sup></span> <span class=\"reference-text\">wissenschaft-online: <i>Eintrag zum Lewisit im Lexikon der Biologie/Chemie</i>.</span>\n</li>\n<li id=\"cite_note-10\"><span class=\"mw-cite-backlink\"><a href=\"#cite_ref-10\">↑</a></span> <span class=\"reference-text\">Eintrag <a rel=\"nofollow\" class=\"external text\" href=\"https://pubchem.ncbi.nlm.nih.gov/compound/5368106\">5368106</a> in der <a href=\"/wiki/PubChem\" title=\"PubChem\">PubChem</a>-Datenbank des <a href=\"/wiki/National_Center_for_Biotechnology_Information\" title=\"National Center for Biotechnology Information\">National Center for Biotechnology Information</a> (NCBI).</span>\n</li>\n<li id=\"cite_note-11\"><span class=\"mw-cite-backlink\"><a href=\"#cite_ref-11\">↑</a></span> <span class=\"reference-text\">Eintrag <a rel=\"nofollow\" class=\"external text\" href=\"https://pubchem.ncbi.nlm.nih.gov/compound/5352143\">5352143</a> in der <a href=\"/wiki/PubChem\" title=\"PubChem\">PubChem</a>-Datenbank des <a href=\"/wiki/National_Center_for_Biotechnology_Information\" title=\"National Center for Biotechnology Information\">National Center for Biotechnology Information</a> (NCBI).</span>\n</li>\n<li id=\"cite_note-12\"><span class=\"mw-cite-backlink\"><a href=\"#cite_ref-12\">↑</a></span> <span class=\"reference-text\"><i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.ausfuhrkontrolle.info/ausfuhrkontrolle/de/cwue/chemikalienliste/liste_1/index.html\">Chemikalien der Liste 1</a></i> beim <a href=\"/wiki/Bundesamt_f%C3%BCr_Wirtschaft_und_Ausfuhrkontrolle\" title=\"Bundesamt für Wirtschaft und Ausfuhrkontrolle\">Bundesamt für Wirtschaft und Ausfuhrkontrolle</a> (BAFA), abgerufen am 15. Januar 2013.</span>\n</li>\n<li id=\"cite_note-13\"><span class=\"mw-cite-backlink\"><a href=\"#cite_ref-13\">↑</a></span> <span class=\"reference-text\"><i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.ausfuhrkontrolle.info/ausfuhrkontrolle/de/cwue/index.html\">Chemiewaffenübereinkommen: Informationsangebot zum Chemiewaffenübereinkommen (CWÜ)</a></i> beim <a href=\"/wiki/Bundesamt_f%C3%BCr_Wirtschaft_und_Ausfuhrkontrolle\" title=\"Bundesamt für Wirtschaft und Ausfuhrkontrolle\">Bundesamt für Wirtschaft und Ausfuhrkontrolle</a> (BAFA), abgerufen am 15. Januar 2013.</span>\n</li>\n</ol>\n<div id=\"normdaten\" class=\"catlinks normdaten-typ-s\">Normdaten&#160;(Sachbegriff):  <a href=\"/wiki/Gemeinsame_Normdatei\" title=\"Gemeinsame Normdatei\">GND</a>: <span class=\"plainlinks-print\"><a rel=\"nofollow\" class=\"external text\" href=\"http://d-nb.info/gnd/4327792-5\">4327792-5</a></span> <span class=\"metadata noprint\">(<a rel=\"nofollow\" class=\"external text\" href=\"http://beacon.findbuch.de/seemore/gnd-aks?format=sources&amp;id=4327792-5\">AKS</a>)</span>      <span class=\"metadata\"></span></div>\n</div>","displaytitle":"Lewisit","iwlinks":[{"prefix":"d","url":"https://www.wikidata.org/wiki/Q407502","title":"d:Q407502"}],"wikitext":"{{Infobox Chemikalie\n| Strukturformel  = [[Datei:Lewisite structures.svg|300px|Struktur von Lewisit]]\n| Strukturhinweis = ''trans''- und ''cis''-Isomer\n| Suchfunktion    = C2H2AsCl3\n| Andere Namen    = *2-Chlorvinyldichlorarsin\n* Dichlor(2-chlorvinyl)arsin\n* 2-Chlorvinylarsindichlorid\n* 2-Chlorethylendichlorarsin\n* Lewisit I\n| Summenformel    = C<sub>2</sub>H<sub>2</sub>AsCl<sub>3</sub>\n| CAS             = 541-25-3\n| PubChem         = 5372798\n| Beschreibung    = ölige, farb- und geruchlose Flüssigkeit <ref name=\"GESTIS\">{{GESTIS|Name=Chlorvinyldichlorarsin|ZVG=570100|CAS=541-25-3|Datum=16. Februar 2017}}.</ref>\n| Molare Masse    = 207,32 g·[[mol]]<sup>−1</sup>\n| Aggregat        = flüssig\n| Dichte          = * 1,8793 g·cm<sup>−3</sup> (25 °C, ''trans''-Isomer) <ref name=\"Whiting\"/>\n* 1,8598 g·cm<sup>−3</sup> (25 °C, ''cis''-Isomer) <ref name=\"Whiting\"/>\n| Schmelzpunkt    = * −2,4 [[Grad Celsius|°C]] (''trans''-Isomer) <ref>Lebedev, B.V.; Kulagina, T.G.; Cheremukhina, A.A.; Karataev, E.N.: Russian J. Gen. Chem. 66 (1996) 880-885.</ref>\n* −44,7&nbsp;°C (''cis''-Isomer) <ref name=\"GESTIS\"/>\n| Siedepunkt      = * 196,6 °C (Zersetzung, ''trans''-Isomer) <ref name=\"Whiting\">Whiting, G.H.: ''Some physicochemical properties of cis-2-chlorovinyldichloroarsine'' in [[J. Chem. Soc.]] 1948, 1209–1210, {{DOI|10.1039/JR9480001209}}.</ref>\n* 169,8&nbsp;°C (Zersetzung, ''cis''-Isomer) <ref name=\"GESTIS\"/>\n| Dampfdruck      = * 53 [[Pascal (Einheit)|Pa]] (''trans''-Isomer, 25 °C) <ref name=roempp />\n* 208 [[Pascal (Einheit)|Pa]] (''cis''-Isomer, 25 °C) <ref name=roempp>{{RömppOnline|Name=Lewisit|Datum=5. November 2011|ID=RD-12-01021}}</ref>\n| Löslichkeit     = * 0,5 g·l<sup>−1</sup> in Wasser (20 °C) <ref name=roempp />\n* löslich in [[Ethanol]], [[Halogenalkane]]n und [[Benzin]] <ref name=roempp />\n| Brechungsindex  = * 1,6076 (25 °C, ''trans''-Isomer) <ref name=\"Whiting\"/>\n* 1,5859 (25 °C, ''cis''-Isomer) <ref name=\"Whiting\"/>\n| CLH             = {{CLH-ECHA|Sammeleinstufung=ja |ID=100.240.769 |Name=Arsenverbindungen, mit Ausnahme der namentlich in diesem Anhang bezeichneten |Datum=1. Februar 2016}}\n| Quelle GHS-Kz   = <ref name=\"GESTIS\" />\n| GHS-Piktogramme = {{GHS-Piktogramme|06|09}}\n| GHS-Signalwort  = Gefahr\n| H               = {{H-Sätze|331|301|410}}\n| EUH             = {{EUH-Sätze|-}}\n| P               = {{P-Sätze|?}}\n| Quelle P        = \n| MAK             = \n| ToxDaten        = * {{ToxDaten |Typ=LCLo |Organismus=Mensch |Applikationsart=inhalativ |Wert=6 [[Parts per million|ppm]] |Bezeichnung= |Quelle=<ref name=\"ChemIDplus\">{{ChemID|541-25-3}}</ref> }}\n* {{ToxDaten |Typ=LDLo |Organismus=Mensch |Applikationsart=percutan |Wert=37,6 mg·kg<sup>−1</sup> |Bezeichnung= |Quelle=<ref name=\"ChemIDplus\"/> }}\n}}\n\n'''Lewisit''', auch ''Lewisit I'' genannt, ist eine [[chlor]]haltige organische [[Arsen]]verbindung, deren Wirkung beim Einsatz als [[chemische Waffe]] den [[Loste]]n ähnelt. Die Substanz bewirkt ein starkes Brennen der Haut mit Blasenbildung. Lewisit wurde nach dem amerikanischen Chemiker [[Winford Lee Lewis]] (1879–1943) benannt. Unter Soldaten trug es den Beinamen ''Tau des Todes''.\n\nEs existieren mit dem ''trans''-Lewisit und dem ''cis''-Lewisit (auch Isolewisit genannt) zwei [[cis-trans-Isomerie|Konfigurationsisomere]].\n\n== Geschichte und Darstellung ==\nWinford Lee Lewis stellte die Substanz 1918 durch Reaktion von [[Arsen(III)-chlorid|Arsentrichlorid]] (AsCl<sub>3</sub>) mit [[Ethin]] (Acetylen) in Anwesenheit von [[Chlorwasserstoff]] in einer [[Quecksilber(II)-chlorid]]-Lösung (HgCl<sub>2</sub>) her:\n\n:<math>\\mathrm{AsCl_3 + HC {\\equiv} CH \\ \\xrightarrow[HCl]{HgCl_2} \\ Cl_2As{-}CH{=}CHCl}</math>\n\nAls Nebenprodukte entstehen noch β-Lewisit (2,2’-Dichlordivinylarsinchlorid) und γ-Lewisit (1,1’,1’’-Trichlortrivinylarsin).<ref name=roempp />\n\nSpäter wurde die Substanz gezielt von der US-amerikanischen Armee als chemischer Kampfstoff weiterentwickelt und hergestellt.<ref>Domingo Tabangcura, Jr. and G. Patrick Daubert, MD. [http://www.chm.bris.ac.uk/motm/bal/development.html British anti-Lewisite Development] ''Molecule of the Month'', University of Bristol School of Chemistry.</ref> Teilweise wurde es als Giftgasgemisch zusammen mit [[Senfgas]] als ''Mustard-Lewisite'' eingesetzt. Es wurden insgesamt etwa 20.000 [[Tonne (Einheit)|t]] Lewisit hergestellt. Seit Ende der 1950er Jahre wurde der Einsatz eingestellt. [[Japan]] produzierte im [[Zweiter Weltkrieg|Zweiten Weltkrieg]] ebenfalls Lewisit und hatte Bestände im besetzten [[China]] vergraben, die 2006 wiederentdeckt wurden.<ref>NTI: {{Webarchiv | url=http://www.nti.org/db/china/acwpos.htm | wayback=20110929235753 | text=''Abandoned Chemical Weapons (ACW) in China''}}.</ref>\n\n== Eigenschaften ==\nDas ''cis''-, das ''trans''-Isomer bzw. das Isomerengemisch sind ölige, farb- und geruchlose Flüssigkeiten<ref name=roempp />, die sich beim Kontakt mit Wasser zersetzen. Die Dämpfe sind sehr viel schwerer als Luft. Hinsichtlich der physikalischen Eigenschaften unterscheiden sich die Isomere stark. Das ''cis''-Isomer besitzt einen wesentlich niedrigeren Schmelz- und Siedepunkt. Es ist wegen des höheren Dampfdrucks leichter flüchtig als das ''trans''-Isomer. Die Dampfdruckkurve für das ''cis''-Isomer ergibt sich nach lgp = 8,4131 - 2450,2/T, die des ''trans''-Isomers nach lgp = 48660 - 13297·lgT - 4815,3/T (p in Torr, T in K).<ref name=\"Whiting\"/>\n\n== Giftwirkung und Gegenmittel ==\nDie Aufnahme des Giftes kann über Haut, Atemwege und [[Magen-Darm-Trakt]] erfolgen. Lewisit reagiert mit den [[Thiolgruppe]]n von Proteinen und stört somit, soweit [[Enzym]]e betroffen sind, massiv den Stoffwechsel. Ähnlich wie die Loste reagiert es auch mit [[Desoxyribonukleinsäure|DNA]]-Molekülen, indem diese alkyliert werden.<ref name=wo/> Auf der Haut erzeugt Lewisit sofort ein starkes Brennen, nach 30 Minuten [[Erythema|Erytheme]]; nach 12 Stunden werden daraus scharf begrenzte, oberflächliche Blasen, bis zu tiefen schmerzhaften [[Nekrose]]n.<ref name=\"GESTIS\"/> \n\nAls Gegenmittel kann [[Dithioglycerin]] (andere Bezeichnungen sind ''BAL'', ''British Anti Lewisite'', Dimercaprol bzw. 2,3-Dimercaptopropanol) verwendet werden. Dithioglycerin bindet Lewisit oder setzt an Proteine gebundenes Lewisit wieder frei.<ref name=wo>wissenschaft-online: ''Eintrag zum Lewisit im Lexikon der Biologie/Chemie''.</ref>\n\n== Andere Lewisite ==\nNeben dem Lewisit I gibt es ferner noch: \n<gallery widths =\"150\">\n  Datei:Lewisite2.png|Lewisit II / β-Lewisit<br />(2,2’-Dichlordivinylarsinchlorid)<ref>{{PubChem|5368106}}.</ref>\n  Datei:Lewisite3.png|Lewisit III / γ-Lewisit<br />(1,1’,1’’-Trichlortrivinylarsin)<ref>{{PubChem|5352143}}.</ref>\n</gallery>\n\n== Internationale Kontrollen ==\nLewisite werden als Chemikalien der Liste 1 der internationalen [[Chemiewaffenkonvention]] (auch ''Chemiewaffenübereinkommen'', ''CWÜ'')<ref>''[http://www.ausfuhrkontrolle.info/ausfuhrkontrolle/de/cwue/chemikalienliste/liste_1/index.html Chemikalien der Liste 1]'' beim [[Bundesamt für Wirtschaft und Ausfuhrkontrolle]] (BAFA), abgerufen am 15. Januar 2013.</ref> von der hierfür zuständigen Behörde [[Organisation für das Verbot chemischer Waffen|OPCW]] mit Sitz in Den Haag kontrolliert. Die Entwicklung oder der Besitz zu Zwecken, die nicht ausschließlich der Forschung zur Verteidigung gegen diese Substanzen dienen, ist verboten. In Deutschland muss jeder Umgang mit Chemikalien der Liste 1 – ausgenommen im Geschäftsbereich des Bundesministeriums der Verteidigung – vom [[Bundesamt für Wirtschaft und Ausfuhrkontrolle]] (BAFA) genehmigt werden und in Abhängigkeit von der ausgeübten Tätigkeit der OPCW gemeldet werden.<ref>''[http://www.ausfuhrkontrolle.info/ausfuhrkontrolle/de/cwue/index.html Chemiewaffenübereinkommen: Informationsangebot zum Chemiewaffenübereinkommen (CWÜ)]'' beim [[Bundesamt für Wirtschaft und Ausfuhrkontrolle]] (BAFA), abgerufen am 15. Januar 2013.</ref>\n\n== Siehe auch ==\n* [[Liste chemischer Kampfstoffe]]\n* [[Gelbkreuz]]\n\n== Weblinks ==\n* Haas, R. ''et al.'': Chemisch-analytische Untersuchung von Arsenkampfstoffen und ihren Metaboliten, ''[[UWSF – Z Umweltchem Ökotox]]''; 10 (1998), 289–293; [http://www.r-haas.de/uwsf10_289_293.pdf PDF] (freier Volltextzugriff)\n\n== Einzelnachweise ==\n<references/>\n\n{{Normdaten|TYP=s|GND=4327792-5}}\n\n[[Kategorie:Arsenorganische Verbindung]]\n[[Kategorie:Chlorverbindung]]\n[[Kategorie:Chloralken]]\n[[Kategorie:Chemische Waffe]]","properties":{"wikibase_item":"Q407502"},"parsetree":"<root><template><title>Infobox Chemikalie\n</title><part><name> Strukturformel  </name><equals>=</equals><value> [[Datei:Lewisite structures.svg|300px|Struktur von Lewisit]]\n</value></part><part><name> Strukturhinweis </name><equals>=</equals><value> ''trans''- und ''cis''-Isomer\n</value></part><part><name> Suchfunktion    </name><equals>=</equals><value> C2H2AsCl3\n</value></part><part><name> Andere Namen    </name><equals>=</equals><value> *2-Chlorvinyldichlorarsin\n* Dichlor(2-chlorvinyl)arsin\n* 2-Chlorvinylarsindichlorid\n* 2-Chlorethylendichlorarsin\n* Lewisit I\n</value></part><part><name> Summenformel    </name><equals>=</equals><value> C&lt;sub&gt;2&lt;/sub&gt;H&lt;sub&gt;2&lt;/sub&gt;AsCl&lt;sub&gt;3&lt;/sub&gt;\n</value></part><part><name> CAS             </name><equals>=</equals><value> 541-25-3\n</value></part><part><name> PubChem         </name><equals>=</equals><value> 5372798\n</value></part><part><name> Beschreibung    </name><equals>=</equals><value> ölige, farb- und geruchlose Flüssigkeit <ext><name>ref</name><attr> name=&quot;GESTIS&quot;</attr><inner>{{GESTIS|Name=Chlorvinyldichlorarsin|ZVG=570100|CAS=541-25-3|Datum=16. Februar 2017}}.</inner><close>&lt;/ref&gt;</close></ext>\n</value></part><part><name> Molare Masse    </name><equals>=</equals><value> 207,32 g·[[mol]]&lt;sup&gt;−1&lt;/sup&gt;\n</value></part><part><name> Aggregat        </name><equals>=</equals><value> flüssig\n</value></part><part><name> Dichte          </name><equals>=</equals><value> * 1,8793 g·cm&lt;sup&gt;−3&lt;/sup&gt; (25 °C, ''trans''-Isomer) <ext><name>ref</name><attr> name=&quot;Whiting&quot;</attr></ext>\n* 1,8598 g·cm&lt;sup&gt;−3&lt;/sup&gt; (25 °C, ''cis''-Isomer) <ext><name>ref</name><attr> name=&quot;Whiting&quot;</attr></ext>\n</value></part><part><name> Schmelzpunkt    </name><equals>=</equals><value> * −2,4 [[Grad Celsius|°C]] (''trans''-Isomer) <ext><name>ref</name><attr/><inner>Lebedev, B.V.; Kulagina, T.G.; Cheremukhina, A.A.; Karataev, E.N.: Russian J. Gen. Chem. 66 (1996) 880-885.</inner><close>&lt;/ref&gt;</close></ext>\n* −44,7&amp;nbsp;°C (''cis''-Isomer) <ext><name>ref</name><attr> name=&quot;GESTIS&quot;</attr></ext>\n</value></part><part><name> Siedepunkt      </name><equals>=</equals><value> * 196,6 °C (Zersetzung, ''trans''-Isomer) <ext><name>ref</name><attr> name=&quot;Whiting&quot;</attr><inner>Whiting, G.H.: ''Some physicochemical properties of cis-2-chlorovinyldichloroarsine'' in [[J. Chem. Soc.]] 1948, 1209–1210, {{DOI|10.1039/JR9480001209}}.</inner><close>&lt;/ref&gt;</close></ext>\n* 169,8&amp;nbsp;°C (Zersetzung, ''cis''-Isomer) <ext><name>ref</name><attr> name=&quot;GESTIS&quot;</attr></ext>\n</value></part><part><name> Dampfdruck      </name><equals>=</equals><value> * 53 [[Pascal (Einheit)|Pa]] (''trans''-Isomer, 25 °C) <ext><name>ref</name><attr> name=roempp </attr></ext>\n* 208 [[Pascal (Einheit)|Pa]] (''cis''-Isomer, 25 °C) <ext><name>ref</name><attr> name=roempp</attr><inner>{{RömppOnline|Name=Lewisit|Datum=5. November 2011|ID=RD-12-01021}}</inner><close>&lt;/ref&gt;</close></ext>\n</value></part><part><name> Löslichkeit     </name><equals>=</equals><value> * 0,5 g·l&lt;sup&gt;−1&lt;/sup&gt; in Wasser (20 °C) <ext><name>ref</name><attr> name=roempp </attr></ext>\n* löslich in [[Ethanol]], [[Halogenalkane]]n und [[Benzin]] <ext><name>ref</name><attr> name=roempp </attr></ext>\n</value></part><part><name> Brechungsindex  </name><equals>=</equals><value> * 1,6076 (25 °C, ''trans''-Isomer) <ext><name>ref</name><attr> name=&quot;Whiting&quot;</attr></ext>\n* 1,5859 (25 °C, ''cis''-Isomer) <ext><name>ref</name><attr> name=&quot;Whiting&quot;</attr></ext>\n</value></part><part><name> CLH             </name><equals>=</equals><value> <template><title>CLH-ECHA</title><part><name>Sammeleinstufung</name><equals>=</equals><value>ja </value></part><part><name>ID</name><equals>=</equals><value>100.240.769 </value></part><part><name>Name</name><equals>=</equals><value>Arsenverbindungen, mit Ausnahme der namentlich in diesem Anhang bezeichneten </value></part><part><name>Datum</name><equals>=</equals><value>1. Februar 2016</value></part></template>\n</value></part><part><name> Quelle GHS-Kz   </name><equals>=</equals><value> <ext><name>ref</name><attr> name=&quot;GESTIS&quot; </attr></ext>\n</value></part><part><name> GHS-Piktogramme </name><equals>=</equals><value> <template><title>GHS-Piktogramme</title><part><name index=\"1\"/><value>06</value></part><part><name index=\"2\"/><value>09</value></part></template>\n</value></part><part><name> GHS-Signalwort  </name><equals>=</equals><value> Gefahr\n</value></part><part><name> H               </name><equals>=</equals><value> <template><title>H-Sätze</title><part><name index=\"1\"/><value>331</value></part><part><name index=\"2\"/><value>301</value></part><part><name index=\"3\"/><value>410</value></part></template>\n</value></part><part><name> EUH             </name><equals>=</equals><value> <template><title>EUH-Sätze</title><part><name index=\"1\"/><value>-</value></part></template>\n</value></part><part><name> P               </name><equals>=</equals><value> <template><title>P-Sätze</title><part><name index=\"1\"/><value>?</value></part></template>\n</value></part><part><name> Quelle P        </name><equals>=</equals><value> \n</value></part><part><name> MAK             </name><equals>=</equals><value> \n</value></part><part><name> ToxDaten        </name><equals>=</equals><value> * <template><title>ToxDaten </title><part><name>Typ</name><equals>=</equals><value>LCLo </value></part><part><name>Organismus</name><equals>=</equals><value>Mensch </value></part><part><name>Applikationsart</name><equals>=</equals><value>inhalativ </value></part><part><name>Wert</name><equals>=</equals><value>6 [[Parts per million|ppm]] </value></part><part><name>Bezeichnung</name><equals>=</equals><value> </value></part><part><name>Quelle</name><equals>=</equals><value><ext><name>ref</name><attr> name=&quot;ChemIDplus&quot;</attr><inner>{{ChemID|541-25-3}}</inner><close>&lt;/ref&gt;</close></ext> </value></part></template>\n* <template><title>ToxDaten </title><part><name>Typ</name><equals>=</equals><value>LDLo </value></part><part><name>Organismus</name><equals>=</equals><value>Mensch </value></part><part><name>Applikationsart</name><equals>=</equals><value>percutan </value></part><part><name>Wert</name><equals>=</equals><value>37,6 mg·kg&lt;sup&gt;−1&lt;/sup&gt; </value></part><part><name>Bezeichnung</name><equals>=</equals><value> </value></part><part><name>Quelle</name><equals>=</equals><value><ext><name>ref</name><attr> name=&quot;ChemIDplus&quot;</attr></ext> </value></part></template>\n</value></part></template>\n\n'''Lewisit''', auch ''Lewisit I'' genannt, ist eine [[chlor]]haltige organische [[Arsen]]verbindung, deren Wirkung beim Einsatz als [[chemische Waffe]] den [[Loste]]n ähnelt. Die Substanz bewirkt ein starkes Brennen der Haut mit Blasenbildung. Lewisit wurde nach dem amerikanischen Chemiker [[Winford Lee Lewis]] (1879–1943) benannt. Unter Soldaten trug es den Beinamen ''Tau des Todes''.\n\nEs existieren mit dem ''trans''-Lewisit und dem ''cis''-Lewisit (auch Isolewisit genannt) zwei [[cis-trans-Isomerie|Konfigurationsisomere]].\n\n<h level=\"2\" i=\"1\">== Geschichte und Darstellung ==</h>\nWinford Lee Lewis stellte die Substanz 1918 durch Reaktion von [[Arsen(III)-chlorid|Arsentrichlorid]] (AsCl&lt;sub&gt;3&lt;/sub&gt;) mit [[Ethin]] (Acetylen) in Anwesenheit von [[Chlorwasserstoff]] in einer [[Quecksilber(II)-chlorid]]-Lösung (HgCl&lt;sub&gt;2&lt;/sub&gt;) her:\n\n:<ext><name>math</name><attr/><inner>\\mathrm{AsCl_3 + HC {\\equiv} CH \\ \\xrightarrow[HCl]{HgCl_2} \\ Cl_2As{-}CH{=}CHCl}</inner><close>&lt;/math&gt;</close></ext>\n\nAls Nebenprodukte entstehen noch β-Lewisit (2,2’-Dichlordivinylarsinchlorid) und γ-Lewisit (1,1’,1’’-Trichlortrivinylarsin).<ext><name>ref</name><attr> name=roempp </attr></ext>\n\nSpäter wurde die Substanz gezielt von der US-amerikanischen Armee als chemischer Kampfstoff weiterentwickelt und hergestellt.<ext><name>ref</name><attr/><inner>Domingo Tabangcura, Jr. and G. Patrick Daubert, MD. [http://www.chm.bris.ac.uk/motm/bal/development.html British anti-Lewisite Development] ''Molecule of the Month'', University of Bristol School of Chemistry.</inner><close>&lt;/ref&gt;</close></ext> Teilweise wurde es als Giftgasgemisch zusammen mit [[Senfgas]] als ''Mustard-Lewisite'' eingesetzt. Es wurden insgesamt etwa 20.000 [[Tonne (Einheit)|t]] Lewisit hergestellt. Seit Ende der 1950er Jahre wurde der Einsatz eingestellt. [[Japan]] produzierte im [[Zweiter Weltkrieg|Zweiten Weltkrieg]] ebenfalls Lewisit und hatte Bestände im besetzten [[China]] vergraben, die 2006 wiederentdeckt wurden.<ext><name>ref</name><attr/><inner>NTI: {{Webarchiv | url=http://www.nti.org/db/china/acwpos.htm | wayback=20110929235753 | text=''Abandoned Chemical Weapons (ACW) in China''}}.</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"2\" i=\"2\">== Eigenschaften ==</h>\nDas ''cis''-, das ''trans''-Isomer bzw. das Isomerengemisch sind ölige, farb- und geruchlose Flüssigkeiten<ext><name>ref</name><attr> name=roempp </attr></ext>, die sich beim Kontakt mit Wasser zersetzen. Die Dämpfe sind sehr viel schwerer als Luft. Hinsichtlich der physikalischen Eigenschaften unterscheiden sich die Isomere stark. Das ''cis''-Isomer besitzt einen wesentlich niedrigeren Schmelz- und Siedepunkt. Es ist wegen des höheren Dampfdrucks leichter flüchtig als das ''trans''-Isomer. Die Dampfdruckkurve für das ''cis''-Isomer ergibt sich nach lgp = 8,4131 - 2450,2/T, die des ''trans''-Isomers nach lgp = 48660 - 13297·lgT - 4815,3/T (p in Torr, T in K).<ext><name>ref</name><attr> name=&quot;Whiting&quot;</attr></ext>\n\n<h level=\"2\" i=\"3\">== Giftwirkung und Gegenmittel ==</h>\nDie Aufnahme des Giftes kann über Haut, Atemwege und [[Magen-Darm-Trakt]] erfolgen. Lewisit reagiert mit den [[Thiolgruppe]]n von Proteinen und stört somit, soweit [[Enzym]]e betroffen sind, massiv den Stoffwechsel. Ähnlich wie die Loste reagiert es auch mit [[Desoxyribonukleinsäure|DNA]]-Molekülen, indem diese alkyliert werden.<ext><name>ref</name><attr> name=wo</attr></ext> Auf der Haut erzeugt Lewisit sofort ein starkes Brennen, nach 30 Minuten [[Erythema|Erytheme]]; nach 12 Stunden werden daraus scharf begrenzte, oberflächliche Blasen, bis zu tiefen schmerzhaften [[Nekrose]]n.<ext><name>ref</name><attr> name=&quot;GESTIS&quot;</attr></ext> \n\nAls Gegenmittel kann [[Dithioglycerin]] (andere Bezeichnungen sind ''BAL'', ''British Anti Lewisite'', Dimercaprol bzw. 2,3-Dimercaptopropanol) verwendet werden. Dithioglycerin bindet Lewisit oder setzt an Proteine gebundenes Lewisit wieder frei.<ext><name>ref</name><attr> name=wo</attr><inner>wissenschaft-online: ''Eintrag zum Lewisit im Lexikon der Biologie/Chemie''.</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"2\" i=\"4\">== Andere Lewisite ==</h>\nNeben dem Lewisit I gibt es ferner noch: \n<ext><name>gallery</name><attr> widths =&quot;150&quot;</attr><inner>\n  Datei:Lewisite2.png|Lewisit II / β-Lewisit&lt;br /&gt;(2,2’-Dichlordivinylarsinchlorid)&lt;ref&gt;{{PubChem|5368106}}.&lt;/ref&gt;\n  Datei:Lewisite3.png|Lewisit III / γ-Lewisit&lt;br /&gt;(1,1’,1’’-Trichlortrivinylarsin)&lt;ref&gt;{{PubChem|5352143}}.&lt;/ref&gt;\n</inner><close>&lt;/gallery&gt;</close></ext>\n\n<h level=\"2\" i=\"5\">== Internationale Kontrollen ==</h>\nLewisite werden als Chemikalien der Liste 1 der internationalen [[Chemiewaffenkonvention]] (auch ''Chemiewaffenübereinkommen'', ''CWÜ'')<ext><name>ref</name><attr/><inner>''[http://www.ausfuhrkontrolle.info/ausfuhrkontrolle/de/cwue/chemikalienliste/liste_1/index.html Chemikalien der Liste 1]'' beim [[Bundesamt für Wirtschaft und Ausfuhrkontrolle]] (BAFA), abgerufen am 15. Januar 2013.</inner><close>&lt;/ref&gt;</close></ext> von der hierfür zuständigen Behörde [[Organisation für das Verbot chemischer Waffen|OPCW]] mit Sitz in Den Haag kontrolliert. Die Entwicklung oder der Besitz zu Zwecken, die nicht ausschließlich der Forschung zur Verteidigung gegen diese Substanzen dienen, ist verboten. In Deutschland muss jeder Umgang mit Chemikalien der Liste 1 – ausgenommen im Geschäftsbereich des Bundesministeriums der Verteidigung – vom [[Bundesamt für Wirtschaft und Ausfuhrkontrolle]] (BAFA) genehmigt werden und in Abhängigkeit von der ausgeübten Tätigkeit der OPCW gemeldet werden.<ext><name>ref</name><attr/><inner>''[http://www.ausfuhrkontrolle.info/ausfuhrkontrolle/de/cwue/index.html Chemiewaffenübereinkommen: Informationsangebot zum Chemiewaffenübereinkommen (CWÜ)]'' beim [[Bundesamt für Wirtschaft und Ausfuhrkontrolle]] (BAFA), abgerufen am 15. Januar 2013.</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"2\" i=\"6\">== Siehe auch ==</h>\n* [[Liste chemischer Kampfstoffe]]\n* [[Gelbkreuz]]\n\n<h level=\"2\" i=\"7\">== Weblinks ==</h>\n* Haas, R. ''et al.'': Chemisch-analytische Untersuchung von Arsenkampfstoffen und ihren Metaboliten, ''[[UWSF – Z Umweltchem Ökotox]]''; 10 (1998), 289–293; [http://www.r-haas.de/uwsf10_289_293.pdf PDF] (freier Volltextzugriff)\n\n<h level=\"2\" i=\"8\">== Einzelnachweise ==</h>\n<ext><name>references</name><attr/></ext>\n\n<template lineStart=\"1\"><title>Normdaten</title><part><name>TYP</name><equals>=</equals><value>s</value></part><part><name>GND</name><equals>=</equals><value>4327792-5</value></part></template>\n\n[[Kategorie:Arsenorganische Verbindung]]\n[[Kategorie:Chlorverbindung]]\n[[Kategorie:Chloralken]]\n[[Kategorie:Chemische Waffe]]</root>"}}"""

cache = {'info': {'status': 200}, 'query': query, 'response': response}
