# -*- coding:utf-8 -*-

query = 'https://fr.wikipedia.org/w/api.php?action=parse&formatversion=2&contentmodel=text&disableeditsection=&disablelimitreport=&disabletoc=&prop=text|iwlinks|parsetree|wikitext|displaytitle|properties&redirects&page=Orl%C3%A9ans-cl%C3%A9ry'

response = r"""{"parse":{"title":"Orléans-cléry","pageid":4967760,"redirects":[],"text":"<div class=\"mw-parser-output\"><table class=\"infobox_v2\">\n<tr>\n<td colspan=\"2\" class=\"entete oenologie\" style=\"background-color:#89092D; color:#FFFFFF\">Orléans-cléry</td>\n</tr>\n<tr>\n<td colspan=\"2\" style=\"text-align:center; line-height: 1.5em;\"><a href=\"/wiki/Fichier:AOC_Orl%C3%A9ans-cl%C3%A9ry_vignoble.JPG\" class=\"image\" title=\"Vignoble de l'AOC orléans-cléry à Mareau-aux-Prés.\"><img alt=\"Image illustrative de l'article Orléans-cléry\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/3/33/AOC_Orl%C3%A9ans-cl%C3%A9ry_vignoble.JPG/280px-AOC_Orl%C3%A9ans-cl%C3%A9ry_vignoble.JPG\" width=\"280\" height=\"373\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/3/33/AOC_Orl%C3%A9ans-cl%C3%A9ry_vignoble.JPG/420px-AOC_Orl%C3%A9ans-cl%C3%A9ry_vignoble.JPG 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/3/33/AOC_Orl%C3%A9ans-cl%C3%A9ry_vignoble.JPG/560px-AOC_Orl%C3%A9ans-cl%C3%A9ry_vignoble.JPG 2x\" data-file-width=\"3456\" data-file-height=\"4608\" /></a><br />\nVignoble de l'AOC orléans-cléry à <a href=\"/wiki/Mareau-aux-Pr%C3%A9s\" title=\"Mareau-aux-Prés\">Mareau-aux-Prés</a>.</td>\n</tr>\n<tr>\n<td colspan=\"2\">\n<hr style=\"height:2px;background-color: #89092D;color:#89092D;\" /></td>\n</tr>\n<tr>\n<th scope=\"row\">Désignation(s)</th>\n<td>Orléans-cléry</td>\n</tr>\n<tr>\n<th scope=\"row\">Appellation(s) principale(s)</th>\n<td>orléans-cléry<sup id=\"cite_ref-AO_1-0\" class=\"reference\"><a href=\"#cite_note-AO-1\"><span class=\"cite_crochet\">[</span>Notes 1<span class=\"cite_crochet\">]</span></a></sup></td>\n</tr>\n<tr>\n<th scope=\"row\">Type d'appellation(s)</th>\n<td><a href=\"/wiki/Appellation_d%27origine_contr%C3%B4l%C3%A9e\" title=\"Appellation d'origine contrôlée\">AOC</a>-<a href=\"/wiki/Appellation_d%27origine_prot%C3%A9g%C3%A9e\" title=\"Appellation d'origine protégée\">AOP</a><sup id=\"cite_ref-inao_2-0\" class=\"reference\"><a href=\"#cite_note-inao-2\"><span class=\"cite_crochet\">[</span>1<span class=\"cite_crochet\">]</span></a></sup></td>\n</tr>\n<tr>\n<th scope=\"row\">Reconnue depuis</th>\n<td><a href=\"/wiki/2006\" title=\"2006\">2006</a><sup id=\"cite_ref-Légifrance1_3-0\" class=\"reference\"><a href=\"#cite_note-Légifrance1-3\"><span class=\"cite_crochet\">[</span>2<span class=\"cite_crochet\">]</span></a></sup></td>\n</tr>\n<tr>\n<th scope=\"row\">Pays</th>\n<td><span class=\"datasortkey\" data-sort-value=\"France\"><span class=\"flagicon\"><a href=\"/wiki/Fichier:Flag_of_France.svg\" class=\"image\" title=\"Drapeau de la France\"><img alt=\"Drapeau de la France\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/c/c3/Flag_of_France.svg/20px-Flag_of_France.svg.png\" width=\"20\" height=\"13\" class=\"noviewer thumbborder\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/c/c3/Flag_of_France.svg/30px-Flag_of_France.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/c/c3/Flag_of_France.svg/40px-Flag_of_France.svg.png 2x\" data-file-width=\"900\" data-file-height=\"600\" /></a>&#160;</span><a href=\"/wiki/France\" title=\"France\">France</a></span></td>\n</tr>\n<tr>\n<th scope=\"row\">Région parente</th>\n<td><a href=\"/wiki/Vignoble_de_la_vall%C3%A9e_de_la_Loire\" title=\"Vignoble de la vallée de la Loire\">vallée de la Loire</a></td>\n</tr>\n<tr>\n<th scope=\"row\">Sous-région(s)</th>\n<td><a href=\"/wiki/Orl%C3%A9anais\" title=\"Orléanais\">Orléanais</a></td>\n</tr>\n<tr>\n<th scope=\"row\">Localisation</th>\n<td><a href=\"/wiki/Loiret_(d%C3%A9partement)\" title=\"Loiret (département)\">Loiret</a></td>\n</tr>\n<tr>\n<th scope=\"row\">Climat</th>\n<td><a href=\"/wiki/Climat_temp%C3%A9r%C3%A9\" title=\"Climat tempéré\">tempéré</a> <a href=\"/wiki/Climat_oc%C3%A9anique\" title=\"Climat océanique\">océanique</a> dégradé</td>\n</tr>\n<tr>\n<th scope=\"row\">Ensoleillement<br />\n(moyenne annuelle)</th>\n<td><span class=\"nowrap\">1&#160;804 heures</span>/an<sup id=\"cite_ref-infoclimat_4-0\" class=\"reference\"><a href=\"#cite_note-infoclimat-4\"><span class=\"cite_crochet\">[</span>3<span class=\"cite_crochet\">]</span></a></sup></td>\n</tr>\n<tr>\n<th scope=\"row\">Sol</th>\n<td><a href=\"/wiki/Argile\" title=\"Argile\">argilo</a>-<a href=\"/wiki/Silice\" title=\"Silice\">siliceux</a> et <a href=\"/wiki/Grave_(terrain)\" title=\"Grave (terrain)\">gravelo</a>-<a href=\"/wiki/Silice\" title=\"Silice\">siliceux</a></td>\n</tr>\n<tr>\n<th scope=\"row\">Superficie plantée</th>\n<td>28 <a href=\"/wiki/Hectare\" title=\"Hectare\">hectares</a><sup id=\"cite_ref-Guide_Hachette_5-0\" class=\"reference\"><a href=\"#cite_note-Guide_Hachette-5\"><span class=\"cite_crochet\">[</span>4<span class=\"cite_crochet\">]</span></a></sup></td>\n</tr>\n<tr>\n<th scope=\"row\">Nombre de domaines viticoles</th>\n<td>23 viticulteurs et 6 vinificateurs<sup id=\"cite_ref-inao_2-1\" class=\"reference\"><a href=\"#cite_note-inao-2\"><span class=\"cite_crochet\">[</span>1<span class=\"cite_crochet\">]</span></a></sup></td>\n</tr>\n<tr>\n<th scope=\"row\">Cépages dominants</th>\n<td><a href=\"/wiki/Cabernet_franc\" title=\"Cabernet franc\">cabernet franc</a> N<sup id=\"cite_ref-cep_6-0\" class=\"reference\"><a href=\"#cite_note-cep-6\"><span class=\"cite_crochet\">[</span>Notes 2<span class=\"cite_crochet\">]</span></a></sup><sup class=\"reference cite_virgule\">,</sup><sup id=\"cite_ref-Légifrance2_7-0\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup></td>\n</tr>\n<tr>\n<th scope=\"row\">Vins produits</th>\n<td><a href=\"/wiki/Vin_rouge\" title=\"Vin rouge\">rouges</a></td>\n</tr>\n<tr>\n<th scope=\"row\">Production</th>\n<td><span class=\"nowrap\"><span title=\"84,8 m³ ou 2&#160;867&#160;427,2 fl.oz.\">848</span> hectolitres</span> en <a href=\"/wiki/2009\" title=\"2009\">2009</a><sup id=\"cite_ref-Guide_Hachette_5-1\" class=\"reference\"><a href=\"#cite_note-Guide_Hachette-5\"><span class=\"cite_crochet\">[</span>4<span class=\"cite_crochet\">]</span></a></sup></td>\n</tr>\n<tr>\n<th scope=\"row\">Pieds à l'hectare</th>\n<td>minimum de <span class=\"nowrap\">5&#160;000 pieds</span> par hectare<sup id=\"cite_ref-Légifrance2_7-1\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup></td>\n</tr>\n<tr>\n<th scope=\"row\">Rendement moyen à l'hectare</th>\n<td>maximum 50 à <span class=\"nowrap\"><span title=\"6,5 m³ ou 219&#160;791 fl.oz.\">65</span> hectolitres</span> par hectare<sup id=\"cite_ref-Légifrance2_7-2\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup></td>\n</tr>\n<tr>\n<td class=\"navigation-only\" colspan=\"2\" style=\"border-top: 2px #89092D solid; font-size: 80%; background:inherit; text-align: right;\"><span class=\"plainlinks\" style=\"float:left;\"><a class=\"external text\" href=\"//fr.wikipedia.org/w/index.php?title=Orl%C3%A9ans-cl%C3%A9ry&amp;action=edit&amp;section=0\"><span style=\"color:#555;\">modifier</span></a></span>&#160;<a href=\"/wiki/Mod%C3%A8le:Infobox_R%C3%A9gion_viticole\" title=\"Consultez la documentation du modèle\"><img alt=\"Consultez la documentation du modèle\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/3/38/Info_Simple.svg/12px-Info_Simple.svg.png\" width=\"12\" height=\"12\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/3/38/Info_Simple.svg/18px-Info_Simple.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/3/38/Info_Simple.svg/24px-Info_Simple.svg.png 2x\" data-file-width=\"512\" data-file-height=\"512\" /></a></td>\n</tr>\n</table>\n<p>L’<b>orléans-cléry</b><sup id=\"cite_ref-AO_1-1\" class=\"reference\"><a href=\"#cite_note-AO-1\"><span class=\"cite_crochet\">[</span>Notes 1<span class=\"cite_crochet\">]</span></a></sup> est un <a href=\"/wiki/Vin_rouge\" title=\"Vin rouge\">vin rouge</a> <a href=\"/wiki/France\" title=\"France\">français</a> d'<a href=\"/wiki/Appellation_d%27origine_contr%C3%B4l%C3%A9e\" title=\"Appellation d'origine contrôlée\">appellation d'origine contrôlée</a> (AOC) et d'<a href=\"/wiki/Appellation_d%27origine_prot%C3%A9g%C3%A9e\" title=\"Appellation d'origine protégée\">appellation d'origine protégée</a> (AOP) produit dans le <a href=\"/wiki/D%C3%A9partement_fran%C3%A7ais\" title=\"Département français\">département</a> du <a href=\"/wiki/Loiret_(d%C3%A9partement)\" title=\"Loiret (département)\">Loiret</a> (<a href=\"/wiki/R%C3%A9gion_fran%C3%A7aise\" title=\"Région française\">région</a> <a href=\"/wiki/Centre-Val_de_Loire\" title=\"Centre-Val de Loire\">Centre-Val de Loire</a>).</p>\n<p>L'appellation concerne le territoire de cinq <a href=\"/wiki/Commune_(France)\" title=\"Commune (France)\">communes</a> située à l'ouest de la ville d'<a href=\"/wiki/Orl%C3%A9ans\" title=\"Orléans\">Orléans</a> sur la rive gauche de la <a href=\"/wiki/Loire_(fleuve)\" class=\"mw-redirect\" title=\"Loire (fleuve)\">Loire</a>&#160;: <a href=\"/wiki/Cl%C3%A9ry-Saint-Andr%C3%A9\" title=\"Cléry-Saint-André\">Cléry-Saint-André</a>, <a href=\"/wiki/Mareau-aux-Pr%C3%A9s\" title=\"Mareau-aux-Prés\">Mareau-aux-Prés</a>, <a href=\"/wiki/M%C3%A9zi%C3%A8res-lez-Cl%C3%A9ry\" title=\"Mézières-lez-Cléry\">Mézières-lez-Cléry</a>, <a href=\"/wiki/Olivet_(Loiret)\" title=\"Olivet (Loiret)\">Olivet</a> et <a href=\"/wiki/Saint-Hilaire-Saint-Mesmin\" title=\"Saint-Hilaire-Saint-Mesmin\">Saint-Hilaire-Saint-Mesmin</a><sup id=\"cite_ref-Légifrance2_7-3\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup>. Elle se trouve au sein d'une autre appellation plus vaste, celle d'<a href=\"/wiki/Orl%C3%A9ans_(AOC)\" title=\"Orléans (AOC)\">orléans</a>.</p>\n<p>L'orléans-cléry, obtenue en <a href=\"/wiki/2006\" title=\"2006\">2006</a><sup id=\"cite_ref-Légifrance1_3-1\" class=\"reference\"><a href=\"#cite_note-Légifrance1-3\"><span class=\"cite_crochet\">[</span>2<span class=\"cite_crochet\">]</span></a></sup>, est l'une des trois <a href=\"/wiki/Appellation_d%27origine_contr%C3%B4l%C3%A9e\" title=\"Appellation d'origine contrôlée\">AOC</a> viticoles de l'<a href=\"/wiki/Orl%C3%A9anais\" title=\"Orléanais\">Orléanais</a> avec l'<a href=\"/wiki/Orl%C3%A9ans_(AOC)\" title=\"Orléans (AOC)\">orléans</a> et les <a href=\"/wiki/Coteaux-du-giennois\" title=\"Coteaux-du-giennois\">coteaux-du-giennois</a>.</p>\n<p></p>\n<h2><span class=\"mw-headline\" id=\"Histoire\">Histoire</span></h2>\n<div class=\"thumb tright\">\n<div class=\"thumbinner\" style=\"width:222px;\"><a href=\"/wiki/Fichier:Hercule_Guespin_Hymne_du_vin_d%27Orl%C3%A9ans_1605.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/6/65/Hercule_Guespin_Hymne_du_vin_d%27Orl%C3%A9ans_1605.jpg/220px-Hercule_Guespin_Hymne_du_vin_d%27Orl%C3%A9ans_1605.jpg\" width=\"220\" height=\"314\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/6/65/Hercule_Guespin_Hymne_du_vin_d%27Orl%C3%A9ans_1605.jpg/330px-Hercule_Guespin_Hymne_du_vin_d%27Orl%C3%A9ans_1605.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/65/Hercule_Guespin_Hymne_du_vin_d%27Orl%C3%A9ans_1605.jpg/440px-Hercule_Guespin_Hymne_du_vin_d%27Orl%C3%A9ans_1605.jpg 2x\" data-file-width=\"650\" data-file-height=\"929\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/Fichier:Hercule_Guespin_Hymne_du_vin_d%27Orl%C3%A9ans_1605.jpg\" class=\"internal\" title=\"Agrandir\"></a></div>\nPage de couverture de l'ouvrage du poète Simon du Rouzeau, 1605</div>\n</div>\n</div>\n<h3><span id=\"Moyen_.C3.82ge\"></span><span class=\"mw-headline\" id=\"Moyen_Âge\">Moyen Âge</span></h3>\n<p>Il semble que les <a href=\"/wiki/Moine\" title=\"Moine\">moines</a> de l'<a href=\"/wiki/Abbaye_Saint-Mesmin_de_Micy\" title=\"Abbaye Saint-Mesmin de Micy\">abbaye Saint-Mesmin de Micy</a> aient produit du vin dès le début du <a href=\"/wiki/VIe_si%C3%A8cle\" title=\"VIe siècle\"><abbr class=\"abbr\" title=\"6ᵉ siècle\"><span class=\"romain\">VI</span><sup style=\"font-size:72%\">e</sup></abbr>&#160;siècle</a>. À la même époque, <a href=\"/wiki/Gr%C3%A9goire_de_Tours\" title=\"Grégoire de Tours\">Grégoire de Tours</a> mentionne la présence de <a href=\"/wiki/Viticulture\" title=\"Viticulture\">viticulture</a> dans la <a href=\"/wiki/Anciennes_provinces_de_France\" class=\"mw-redirect\" title=\"Anciennes provinces de France\">province</a> de l'<a href=\"/wiki/Orl%C3%A9anais\" title=\"Orléanais\">Orléanais</a><sup id=\"cite_ref-inao_2-2\" class=\"reference\"><a href=\"#cite_note-inao-2\"><span class=\"cite_crochet\">[</span>1<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Au <a href=\"/wiki/XIIIe_si%C3%A8cle\" title=\"XIIIe siècle\"><abbr class=\"abbr\" title=\"13ᵉ siècle\"><span class=\"romain\">XIII</span><sup style=\"font-size:72%\">e</sup></abbr>&#160;siècle</a>, le roi de France <a href=\"/wiki/Louis_IX_de_France\" class=\"mw-redirect\" title=\"Louis IX de France\">Saint Louis</a>, fait exploiter par son personnel un vignoble à <a href=\"/wiki/Ch%C3%A9cy\" title=\"Chécy\">Chécy</a><sup id=\"cite_ref-8\" class=\"reference\"><a href=\"#cite_note-8\"><span class=\"cite_crochet\">[</span>6<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<h3><span id=\".C3.89poque_moderne\"></span><span class=\"mw-headline\" id=\"Époque_moderne\">Époque moderne</span></h3>\n<p>Durant l'<a href=\"/wiki/%C3%89poque_moderne\" title=\"Époque moderne\">époque moderne</a> et pour diverses raisons, le vignoble connait une importante extension, sous forme de quasi-<a href=\"/wiki/Monoculture\" title=\"Monoculture\">monoculture</a> de <a href=\"/wiki/Ch%C3%A2teauneuf-sur-Loire\" title=\"Châteauneuf-sur-Loire\">Châteauneuf-sur-Loire</a> à l'est jusqu'à <a href=\"/wiki/Beaugency\" title=\"Beaugency\">Beaugency</a> à l'ouest. Le <a href=\"/wiki/Domaine_royal_fran%C3%A7ais\" title=\"Domaine royal français\">Domaine royal français</a>, très restreint à l'époque, se tourne donc naturellement vers le vignoble orléanais. De plus, ce dernier est chargé d'approvisionner la ville de <a href=\"/wiki/Paris\" title=\"Paris\">Paris</a> en vin. En effet, en 1577, le Parlement de Paris promulgue une loi interdisant aux Parisiens l'achat de vins produits à moins de 90 kilomètres de la capitale, la production orléanaise est alors augmentée pour satisfaire la demande. Le transport du vin vers la capitale en grande quantité est favorisé par la courte distance (133 kilomètres) sur terrain plat, le <a href=\"/wiki/Pav%C3%A9\" title=\"Pavé\">pavage</a> de la route de bout en bout dès 1577 (tronçon de l'actuelle <a href=\"/wiki/Route_nationale_20_(France)\" title=\"Route nationale 20 (France)\">route nationale 20</a>) et la construction du <a href=\"/wiki/Canal_de_Briare\" title=\"Canal de Briare\">canal de Briare</a> ouvert en <a href=\"/wiki/1642\" title=\"1642\">1642</a> (reliant la <a href=\"/wiki/Loire_(fleuve)\" class=\"mw-redirect\" title=\"Loire (fleuve)\">Loire</a> à la <a href=\"/wiki/Seine\" title=\"Seine\">Seine</a> par la vallée du <a href=\"/wiki/Loing\" title=\"Loing\">Loing</a>). L'augmentation de la production s'effectue au détriment de la qualité<sup id=\"cite_ref-inao_2-3\" class=\"reference\"><a href=\"#cite_note-inao-2\"><span class=\"cite_crochet\">[</span>1<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Il semble que la table royale s'approvisionne en <a href=\"/wiki/Vignoble_de_la_vall%C3%A9e_de_la_Loire\" title=\"Vignoble de la vallée de la Loire\">vins de la vallée de la Loire</a> jusqu'au <a href=\"/wiki/XVIe_si%C3%A8cle\" title=\"XVIe siècle\"><abbr class=\"abbr\" title=\"16ᵉ siècle\"><span class=\"romain\">XVI</span><sup style=\"font-size:72%\">e</sup></abbr>&#160;siècle</a>. Pour tenter de limiter la consommation excessive qu'en fait <a href=\"/wiki/Henri_IV_de_France\" class=\"mw-redirect\" title=\"Henri IV de France\">Henri IV</a>, roi de France de <a href=\"/wiki/1589\" title=\"1589\">1589</a> à <a href=\"/wiki/1610\" title=\"1610\">1610</a>, son médecin et conseiller <a href=\"/wiki/Joseph_du_Chesne\" title=\"Joseph du Chesne\">Joseph du Chesne</a> écrit en <a href=\"/wiki/1606\" title=\"1606\">1606</a> dans son <i>pourtraict de la santé</i>&#160;: <span class=\"citation\">«&#160;le vin de <a href=\"/wiki/Coucy\" title=\"Coucy\">Coussy</a> et d'<a href=\"/wiki/Ay_(Marne)\" title=\"Ay (Marne)\">Hay</a> et semblables ont même été trouvés meilleurs que ceux d'Orléans qui sont fumeux et qui donnent à la tête. C'est pourquoi ont fait prêter serment à tous les maîtres d'hôtel du Roy à leur réception en telle charge de ne faire servir pour la bouche du Roy des vins d'Orléans, bien que d'ailleurs, ils sont mis au nombre des bons vins quant au goût&#160;»</span><sup id=\"cite_ref-9\" class=\"reference\"><a href=\"#cite_note-9\"><span class=\"cite_crochet\">[</span>7<span class=\"cite_crochet\">]</span></a></sup> La cour semble délaisser peu à peu le vin orléanais sous <a href=\"/wiki/Louis_XIII_de_France\" class=\"mw-redirect\" title=\"Louis XIII de France\">Louis XIII</a> qui règne de <a href=\"/wiki/1610\" title=\"1610\">1610</a> à <a href=\"/wiki/1643\" title=\"1643\">1643</a><sup id=\"cite_ref-10\" class=\"reference\"><a href=\"#cite_note-10\"><span class=\"cite_crochet\">[</span>8<span class=\"cite_crochet\">]</span></a></sup>. L'avis du roi est suivi par l'<a href=\"/wiki/Aristocratie\" title=\"Aristocratie\">aristocratie</a> qui à son tour opte pour les <a href=\"/wiki/Vignoble_de_Champagne\" title=\"Vignoble de Champagne\">vins de Champagne</a> puis <a href=\"/wiki/Vignoble_de_Bourgogne\" title=\"Vignoble de Bourgogne\">de Bourgogne</a>, ce qui a pour effet de spécialiser l'Orléanais dans la production de vins médiocres et bon marché.</p>\n<div class=\"thumb tleft\">\n<div class=\"thumbinner\" style=\"width:222px;\"><a href=\"/wiki/Fichier:Mani%C3%A8re_de_bien_cultiver_la_vigne_dans_le_vignoble_d%27Orl%C3%A9ans_1712.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/3/39/Mani%C3%A8re_de_bien_cultiver_la_vigne_dans_le_vignoble_d%27Orl%C3%A9ans_1712.jpg/220px-Mani%C3%A8re_de_bien_cultiver_la_vigne_dans_le_vignoble_d%27Orl%C3%A9ans_1712.jpg\" width=\"220\" height=\"339\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/3/39/Mani%C3%A8re_de_bien_cultiver_la_vigne_dans_le_vignoble_d%27Orl%C3%A9ans_1712.jpg/330px-Mani%C3%A8re_de_bien_cultiver_la_vigne_dans_le_vignoble_d%27Orl%C3%A9ans_1712.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/3/39/Mani%C3%A8re_de_bien_cultiver_la_vigne_dans_le_vignoble_d%27Orl%C3%A9ans_1712.jpg 2x\" data-file-width=\"388\" data-file-height=\"597\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/Fichier:Mani%C3%A8re_de_bien_cultiver_la_vigne_dans_le_vignoble_d%27Orl%C3%A9ans_1712.jpg\" class=\"internal\" title=\"Agrandir\"></a></div>\nPage de couverture de l'ouvrage du chanoine Boullay, 1712</div>\n</div>\n</div>\n<p>Le premier quart du <a href=\"/wiki/XVIIIe_si%C3%A8cle\" title=\"XVIIIe siècle\"><abbr class=\"abbr\" title=\"18ᵉ siècle\"><span class=\"romain\">XVIII</span><sup style=\"font-size:72%\">e</sup></abbr>&#160;siècle</a> est marqué par la publication de trois éditions<sup id=\"cite_ref-11\" class=\"reference\"><a href=\"#cite_note-11\"><span class=\"cite_crochet\">[</span>Notes 3<span class=\"cite_crochet\">]</span></a></sup> de l'ouvrage du <a href=\"/wiki/Chanoine\" title=\"Chanoine\">chanoine</a> orléanais Jacques Boullay de Saint-Pierre-Ampon intitulé <i>Manière de bien cultiver la vigne dans le vignoble d'Orléans</i><sup id=\"cite_ref-12\" class=\"reference\"><a href=\"#cite_note-12\"><span class=\"cite_crochet\">[</span>9<span class=\"cite_crochet\">]</span></a></sup>. À cette époque, la qualité du vin orléanais continue de décliner, les classes bourgeoises, propriétaires des vignobles, n'accordent qu'une confiance limitée aux pratiques agricoles des vignerons qui exploitent leurs vignes. Jacques Boullay s'improvise donc professeur et médiateur, en dénonçant les <span class=\"citation\">«&#160;friponneries des mauvais vignerons&#160;»</span>. Sa démarche sera très critiquée par les cultivateurs et sa personne s'en trouvera menacée<sup id=\"cite_ref-13\" class=\"reference\"><a href=\"#cite_note-13\"><span class=\"cite_crochet\">[</span>10<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Dans son <i>dictionnaire géographique, historique et politique des Gaules et de la France</i> paru en <a href=\"/wiki/1768\" title=\"1768\">1768</a>, l'abbé <a href=\"/wiki/Louis-Alexandre_Expilly_de_La_Poipe\" title=\"Louis-Alexandre Expilly de La Poipe\">Louis-Alexandre Expilly de La Poipe</a> décrit le vignoble d'Orléans comme l'un des plus vaste de France (dix à onze lieues<sup id=\"cite_ref-14\" class=\"reference\"><a href=\"#cite_note-14\"><span class=\"cite_crochet\">[</span>Notes 4<span class=\"cite_crochet\">]</span></a></sup> d'étendue). Il couvre 25 à 30 communes entre <a href=\"/wiki/Beaugency\" title=\"Beaugency\">Beaugency</a> et <a href=\"/wiki/Jargeau\" title=\"Jargeau\">Jargeau</a>. Plusieurs vins blancs y sont produits dont notamment le <i>Gennetin</i> à <a href=\"/wiki/Abbaye_Saint-Mesmin_de_Micy\" title=\"Abbaye Saint-Mesmin de Micy\">Saint-Mesmin</a> et les vins de <a href=\"/wiki/Marigny-les-Usages\" title=\"Marigny-les-Usages\">Marigny</a> et <a href=\"/wiki/Rebr%C3%A9chien\" title=\"Rebréchien\">Rebréchien</a>. Parmi les vins rouges, surnommés <i>Auvernat</i> car probablement issu d'un cépage venu d'Auvergne, sont nommés ceux de <a href=\"/wiki/Saint-Denis-en-Val\" title=\"Saint-Denis-en-Val\">Saint-Denis-en-Val</a>, <a href=\"/wiki/La_Chapelle-Saint-Mesmin\" title=\"La Chapelle-Saint-Mesmin\">La Chapelle</a>, Fourneaux et <a href=\"/wiki/Saint-Ay\" title=\"Saint-Ay\">Saint-Ay</a><sup id=\"cite_ref-15\" class=\"reference\"><a href=\"#cite_note-15\"><span class=\"cite_crochet\">[</span>11<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>En <a href=\"/wiki/1770\" title=\"1770\">1770</a>, le chanoine orléanais, <a href=\"/wiki/Jean-Fran%C3%A7ois_Colas\" title=\"Jean-François Colas\">Jean-François Colas</a> de la <a href=\"/wiki/Coll%C3%A9giale_Saint-Aignan_d%27Orl%C3%A9ans\" title=\"Collégiale Saint-Aignan d'Orléans\">collégiale Saint-Aignan</a>, publie à son tour un traité, <i>Le manuel du cultivateur dans le vignoble d'Orléans</i>, sur un ton plus neutre et moins accusateur<sup id=\"cite_ref-16\" class=\"reference\"><a href=\"#cite_note-16\"><span class=\"cite_crochet\">[</span>12<span class=\"cite_crochet\">]</span></a></sup><sup class=\"reference cite_virgule\">,</sup><sup id=\"cite_ref-17\" class=\"reference\"><a href=\"#cite_note-17\"><span class=\"cite_crochet\">[</span>13<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<h3><span id=\".C3.89poque_contemporaine\"></span><span class=\"mw-headline\" id=\"Époque_contemporaine\">Époque contemporaine</span></h3>\n<p>Dès le <abbr class=\"abbr\" title=\"18ᵉ siècle\"><span class=\"romain\">XVIII</span><sup style=\"font-size:72%\">e</sup></abbr> et jusqu'au milieu du <a href=\"/wiki/XIXe_si%C3%A8cle\" title=\"XIXe siècle\"><abbr class=\"abbr\" title=\"19ᵉ siècle\"><span class=\"romain\">XIX</span><sup style=\"font-size:72%\">e</sup></abbr>&#160;siècle</a>, <a href=\"/wiki/Orl%C3%A9ans\" title=\"Orléans\">Orléans</a> devient un <a href=\"/wiki/Port_d%27Orl%C3%A9ans\" title=\"Port d'Orléans\">port fluvial de transit</a> pour les vins d'autres régions, de l'amont comme de l'aval (<a href=\"/wiki/Touraine\" title=\"Touraine\">Touraine</a>, <a href=\"/wiki/Anjou\" title=\"Anjou\">Anjou</a>, puis <a href=\"/wiki/Pays_nantais\" title=\"Pays nantais\">Pays nantais</a>) de la Loire, mais aussi de Bourgogne et du <a href=\"/wiki/Vignoble_du_beaujolais\" class=\"mw-redirect\" title=\"Vignoble du beaujolais\">Haut-Beaujolais</a> (les actuels crus du Beaujolais). Les vins ayant tourné étaient alors transformés en <a href=\"/wiki/Vinaigre\" title=\"Vinaigre\">vinaigre</a> («&#160;vin aigre&#160;»), qui est depuis une des spécialités de la ville.</p>\n<div class=\"bandeau-section bandeau-niveau-detail loupe\">Article connexe&#160;: <a href=\"/wiki/Port_d%27Orl%C3%A9ans#La_vinaigrerie\" title=\"Port d'Orléans\">vinaigre d'Orléans</a>.</div>\n<p>Au début du <abbr class=\"abbr\" title=\"19ᵉ siècle\"><span class=\"romain\">XIX</span><sup style=\"font-size:72%\">e</sup></abbr>, l'<a href=\"/wiki/%C5%92nologue\" class=\"mw-redirect\" title=\"Œnologue\">œnologue</a> français <a href=\"/wiki/Andr%C3%A9_Jullien_(vin)\" class=\"mw-redirect\" title=\"André Jullien (vin)\">André Jullien</a> dans son ouvrage <i>Topographie de tous les vignobles connus</i> paru en <a href=\"/wiki/1816\" title=\"1816\">1816</a> dresse un état des lieux du vignoble orléanais. La superficie des vignobles du département du Loiret est estimée à <span class=\"nowrap\"><span title=\"330&#160;000&#160;000 m² ou 330 km²\">33&#160;000</span> hectares</span> pour une récolte de <span class=\"nowrap\"><span title=\"89&#160;600 m³ ou 3&#160;029&#160;734&#160;400 fl.oz.\">896&#160;000</span> hectolitres</span> dont 220&#160;000 sont consommés par les autochtones, le reste étant exporté sous l'appellation <i>vin d'Orléans</i><sup id=\"cite_ref-18\" class=\"reference\"><a href=\"#cite_note-18\"><span class=\"cite_crochet\">[</span>B 1<span class=\"cite_crochet\">]</span></a></sup>. Parmi les vins rouges dits de première classe, on trouve à l'Ouest d'Orléans ceux du lieu-dit Guignes à <a href=\"/wiki/Tavers\" title=\"Tavers\">Tavers</a>, du clos Sainte-Marie à <a href=\"/wiki/Saint-Jean-de-Braye\" title=\"Saint-Jean-de-Braye\">Saint-Jean-de-Braye</a>, de <a href=\"/wiki/La_Chapelle-Saint-Mesmin\" title=\"La Chapelle-Saint-Mesmin\">La Chapelle</a>, de Saint-Gy, de <a href=\"/wiki/Saint-Ay\" title=\"Saint-Ay\">Saint-Ay</a>, des Fourneaux, de <a href=\"/wiki/Beaugency\" title=\"Beaugency\">Beaugency</a>, de <a href=\"/wiki/Baule\" title=\"Baule\">Baule</a>, de Beaulette et de <a href=\"/wiki/Meung-sur-Loire\" title=\"Meung-sur-Loire\">Meung-sur-Loire</a><sup id=\"cite_ref-19\" class=\"reference\"><a href=\"#cite_note-19\"><span class=\"cite_crochet\">[</span>B 2<span class=\"cite_crochet\">]</span></a></sup>. À l'Est d'Orléans, on trouve ceux de <a href=\"/wiki/Saint-Denis-en-Val\" title=\"Saint-Denis-en-Val\">Saint-Denis-en-Val</a>, <a href=\"/wiki/Combleux\" title=\"Combleux\">Combleux</a> et <a href=\"/wiki/Sandillon\" title=\"Sandillon\">Sandillon</a><sup id=\"cite_ref-20\" class=\"reference\"><a href=\"#cite_note-20\"><span class=\"cite_crochet\">[</span>B 3<span class=\"cite_crochet\">]</span></a></sup>. Parmi les vins rouges de deuxième classe, on trouve à Orléans ceux de Saint-Marc, Saint-Marceau, Saint-Paterne, à l'Ouest ceux de <a href=\"/wiki/Saint-Pryv%C3%A9-Saint-Mesmin\" title=\"Saint-Pryvé-Saint-Mesmin\">Saint-Privé</a>, au nord ceux de <a href=\"/wiki/Saran\" title=\"Saran\">Sarang</a>, <a href=\"/wiki/Gidy\" title=\"Gidy\">Gédy</a>, <a href=\"/wiki/Fleury-les-Aubrais\" title=\"Fleury-les-Aubrais\">Fleury</a> et <a href=\"/wiki/Semoy_(Loiret)\" title=\"Semoy (Loiret)\">Semoy</a>, à l'ouest celui d'<a href=\"/wiki/Ingr%C3%A9\" title=\"Ingré\">Ingré</a>, au sud celui d'<a href=\"/wiki/Olivet_(Loiret)\" title=\"Olivet (Loiret)\">Olivet</a> et à l'Est ceux de <a href=\"/wiki/Saint-Jean-le-Blanc_(Loiret)\" title=\"Saint-Jean-le-Blanc (Loiret)\">Saint-Jean-le-Blanc</a>, <a href=\"/wiki/Bou\" title=\"Bou\">Bou</a>, <a href=\"/wiki/Mardi%C3%A9\" title=\"Mardié\">Mardié</a>, <a href=\"/wiki/Saint-Denis-de-l%27H%C3%B4tel\" title=\"Saint-Denis-de-l'Hôtel\">Saint-Denis-de-Jargeau</a> et <a href=\"/wiki/Jargeau\" title=\"Jargeau\">Jargeau</a><sup id=\"cite_ref-21\" class=\"reference\"><a href=\"#cite_note-21\"><span class=\"cite_crochet\">[</span>B 4<span class=\"cite_crochet\">]</span></a></sup>. Parmi les vins blancs, sont cités ceux produits à <a href=\"/wiki/Marigny-les-Usages\" title=\"Marigny-les-Usages\">Marigny</a> et <a href=\"/wiki/Rebr%C3%A9chien\" title=\"Rebréchien\">Rebréchien</a>. Celui de <a href=\"/wiki/Loury\" title=\"Loury\">Loury</a>, cité comme un vin de médiocre qualité, sert à la fabrication du vinaigre d'Orléans<sup id=\"cite_ref-22\" class=\"reference\"><a href=\"#cite_note-22\"><span class=\"cite_crochet\">[</span>B 5<span class=\"cite_crochet\">]</span></a></sup>. Les tonneaux utilisés pour stocker le vin d'Orléans sont nommés <i>pièce</i> ou <i>poinçon</i> et possèdent une contenance de <span class=\"nowrap\"><span title=\"0,228 m³ ou 7&#160;709,592 fl.oz.\">228</span> litres</span><sup id=\"cite_ref-23\" class=\"reference\"><a href=\"#cite_note-23\"><span class=\"cite_crochet\">[</span>B 6<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Le développement du réseau de <a href=\"/wiki/Chemin_de_fer\" title=\"Chemin de fer\">chemins de fer</a> au milieu du <abbr class=\"abbr\" title=\"19ᵉ siècle\"><span class=\"romain\">XIX</span><sup style=\"font-size:72%\">e</sup></abbr> porte un coup fatal à la viticulture de l'Orléanais, permettant l'importation à moindre coût des vins du Midi (produits dans le <a href=\"/wiki/Vignoble_du_Languedoc-Roussillon\" title=\"Vignoble du Languedoc-Roussillon\">vignoble du Languedoc-Roussillon</a>).</p>\n<p>On peut dresser un nouvel état des lieux du vignoble orléanais grâce à l'ouvrage du médecin et physicien français <a href=\"/wiki/Jules_Guyot\" title=\"Jules Guyot\">Jules Guyot</a>, <i>Étude des vignobles de France&#160;: pour servir à l'enseignement mutuel de la viticulture et de la vinification françaises</i>, paru en <a href=\"/wiki/1868\" title=\"1868\">1868</a>. Économiquement parlant, l'exploitation d'un vignoble dans la région d'Orléans est décrite comme rentable si le propriétaire est capable de l'exploiter par lui-même. Un grand-propriétaire qui doit payer un vigneron n'en retire pas de bénéfices considérables. Trois grands types de culture de la vigne sont recensées, l'une sur la rive droite de la Loire, l'une sur la rive gauche et la dernière dans une petite région centrée sur la commune d'Olivet. Dans tout le vignoble, les plants sont organisés en ligne à <span class=\"nowrap\">80 <abbr class=\"abbr\" title=\"centimètre\">cm</abbr></span> les uns des autres<sup id=\"cite_ref-24\" class=\"reference\"><a href=\"#cite_note-24\"><span class=\"cite_crochet\">[</span>14<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<div class=\"thumb tright\">\n<div class=\"thumbinner\" style=\"width:222px;\"><a href=\"/wiki/Fichier:Loiret_Vendanges_en_Sologne.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/2/28/Loiret_Vendanges_en_Sologne.jpg/220px-Loiret_Vendanges_en_Sologne.jpg\" width=\"220\" height=\"342\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/2/28/Loiret_Vendanges_en_Sologne.jpg/330px-Loiret_Vendanges_en_Sologne.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/2/28/Loiret_Vendanges_en_Sologne.jpg/440px-Loiret_Vendanges_en_Sologne.jpg 2x\" data-file-width=\"965\" data-file-height=\"1500\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/Fichier:Loiret_Vendanges_en_Sologne.jpg\" class=\"internal\" title=\"Agrandir\"></a></div>\nVendanges entre Orléans et la Sologne</div>\n</div>\n</div>\n<p>Après les ravages causés par le <a href=\"/wiki/Phyllox%C3%A9ra\" title=\"Phylloxéra\">phylloxéra</a>, un puceron ravageur de la vigne, à la fin du <abbr class=\"abbr\" title=\"19ᵉ siècle\"><span class=\"romain\">XIX</span><sup style=\"font-size:72%\">e</sup></abbr>, très peu de replantations sont faites autour d'Orléans. Les surfaces cultivées disparaissant presque totalement au cours du <a href=\"/wiki/XXe_si%C3%A8cle\" title=\"XXe siècle\"><abbr class=\"abbr\" title=\"20ᵉ siècle\"><span class=\"romain\">XX</span><sup style=\"font-size:72%\">e</sup></abbr>&#160;siècle</a> du fait d'une très forte concurrence pour ce type de vin courant.</p>\n<p>Malgré tout, quelques producteurs poursuivent une petite production, encadrée à partir de <a href=\"/wiki/1951\" title=\"1951\">1951</a> par l'<a href=\"/wiki/Appellation_d%27origine_vin_d%C3%A9limit%C3%A9_de_qualit%C3%A9_sup%C3%A9rieure\" class=\"mw-redirect\" title=\"Appellation d'origine vin délimité de qualité supérieure\">appellation d'origine vin délimité de qualité supérieure</a> (VDQS) «&#160;vin de l'Orléanais&#160;»<sup id=\"cite_ref-25\" class=\"reference\"><a href=\"#cite_note-25\"><span class=\"cite_crochet\">[</span>15<span class=\"cite_crochet\">]</span></a></sup>. L'<a href=\"/wiki/Institut_national_de_l%27origine_et_de_la_qualit%C3%A9\" title=\"Institut national de l'origine et de la qualité\">Institut national de l'origine et de la qualité</a> (INAO) fait reconnaître une appellation VDQS particulière sous le nom d'«&#160;orléans-cléry&#160;» par l'arrêté du <time class=\"nowrap date-lien\" datetime=\"2002-10-14\"><a href=\"/wiki/14_octobre\" title=\"14 octobre\">14</a> <a href=\"/wiki/Octobre_2002\" title=\"Octobre 2002\">octobre</a> <a href=\"/wiki/2002\" title=\"2002\">2002</a></time> publié au <a href=\"/wiki/Journal_officiel_de_la_R%C3%A9publique_fran%C3%A7aise\" title=\"Journal officiel de la République française\">journal officiel de la République française</a> du <time class=\"nowrap date-lien\" datetime=\"2002-11-15\"><a href=\"/wiki/15_novembre\" title=\"15 novembre\">15</a> <a href=\"/wiki/Novembre_2002\" title=\"Novembre 2002\">novembre</a> <a href=\"/wiki/2002\" title=\"2002\">2002</a></time><sup id=\"cite_ref-Légifrance0_26-0\" class=\"reference\"><a href=\"#cite_note-Légifrance0-26\"><span class=\"cite_crochet\">[</span>16<span class=\"cite_crochet\">]</span></a></sup>, avant de le faire passer au statut d'<a href=\"/wiki/Appellation_d%27origine_contr%C3%B4l%C3%A9e\" title=\"Appellation d'origine contrôlée\">appellation d'origine contrôlée</a> par le décret du <time class=\"nowrap date-lien\" datetime=\"2006-11-23\"><a href=\"/wiki/23_novembre\" title=\"23 novembre\">23</a> <a href=\"/wiki/Novembre_2006\" title=\"Novembre 2006\">novembre</a> <a href=\"/wiki/2006\" title=\"2006\">2006</a></time><sup id=\"cite_ref-Légifrance1_3-2\" class=\"reference\"><a href=\"#cite_note-Légifrance1-3\"><span class=\"cite_crochet\">[</span>2<span class=\"cite_crochet\">]</span></a></sup>, modifié par le décret du <time class=\"nowrap date-lien\" datetime=\"2009-10-16\"><a href=\"/wiki/16_octobre\" title=\"16 octobre\">16</a> <a href=\"/wiki/Octobre_2009\" title=\"Octobre 2009\">octobre</a> <a href=\"/wiki/2009\" title=\"2009\">2009</a></time><sup id=\"cite_ref-Légifrance2_7-4\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Le syndicat viticole de l’Orléanais, reconnu dès <a href=\"/wiki/1994\" title=\"1994\">1994</a><sup id=\"cite_ref-27\" class=\"reference\"><a href=\"#cite_note-27\"><span class=\"cite_crochet\">[</span>17<span class=\"cite_crochet\">]</span></a></sup> et basé à <a href=\"/wiki/Saint-Hilaire-Saint-Mesmin\" title=\"Saint-Hilaire-Saint-Mesmin\">Saint-Hilaire-Saint-Mesmin</a> est, depuis <a href=\"/wiki/2007\" title=\"2007\">2007</a>, chargé de la promotion de l'appellation, s'appuyant entre autres sur la <a href=\"/wiki/Confr%C3%A9rie\" title=\"Confrérie\">confrérie</a> vigneronne des chevaliers d'Orléans-Cléry créée à <a href=\"/wiki/Cl%C3%A9ry-Saint-Andr%C3%A9\" title=\"Cléry-Saint-André\">Cléry-Saint-André</a> et hébergée à la mairie<sup id=\"cite_ref-28\" class=\"reference\"><a href=\"#cite_note-28\"><span class=\"cite_crochet\">[</span>18<span class=\"cite_crochet\">]</span></a></sup> dans le but d'améliorer la promotion des vins locaux.</p>\n<h3><span id=\".C3.89tymologie\"></span><span class=\"mw-headline\" id=\"Étymologie\">Étymologie</span></h3>\n<div class=\"thumb tright\">\n<div class=\"thumbinner\" style=\"width:352px;\"><a href=\"/wiki/Fichier:Plan_de_Cl%C3%A9ry_au_18e_si%C3%A8cle.JPG\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/1/17/Plan_de_Cl%C3%A9ry_au_18e_si%C3%A8cle.JPG/350px-Plan_de_Cl%C3%A9ry_au_18e_si%C3%A8cle.JPG\" width=\"350\" height=\"142\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/1/17/Plan_de_Cl%C3%A9ry_au_18e_si%C3%A8cle.JPG/525px-Plan_de_Cl%C3%A9ry_au_18e_si%C3%A8cle.JPG 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/1/17/Plan_de_Cl%C3%A9ry_au_18e_si%C3%A8cle.JPG/700px-Plan_de_Cl%C3%A9ry_au_18e_si%C3%A8cle.JPG 2x\" data-file-width=\"1409\" data-file-height=\"573\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/Fichier:Plan_de_Cl%C3%A9ry_au_18e_si%C3%A8cle.JPG\" class=\"internal\" title=\"Agrandir\"></a></div>\nPlan de <a href=\"/wiki/Cl%C3%A9ry-Saint-Andr%C3%A9\" title=\"Cléry-Saint-André\">Cléry</a> au <a href=\"/wiki/XVIIIe_si%C3%A8cle\" title=\"XVIIIe siècle\"><abbr class=\"abbr\" title=\"18ᵉ siècle\"><span class=\"romain\">XVIII</span><sup style=\"font-size:72%\">e</sup></abbr>&#160;siècle</a>, avec les vignes indiquées sur les terrasses.</div>\n</div>\n</div>\n<p>Le nom de l'appellation est formé des noms des communes d'Orléans, préfecture du département, et de Cléry-Saint-André, au centre de l'aire d'appellation.</p>\n<p><span class=\"need_ref\" style=\"cursor:help;\" title=\"Ce passage nécessite une référence.\">La première mention écrite de <a href=\"/wiki/Cl%C3%A9ry-Saint-Andr%C3%A9\" title=\"Cléry-Saint-André\">Cléry</a> date du milieu du <a href=\"/wiki/VIe_si%C3%A8cle\" title=\"VIe siècle\"><abbr class=\"abbr\" title=\"6ᵉ siècle\"><span class=\"romain\">VI</span><sup style=\"font-size:72%\">e</sup></abbr>&#160;siècle</a>&#160;: l’<a href=\"/wiki/Liste_des_%C3%A9v%C3%AAques_d%27Orl%C3%A9ans\" title=\"Liste des évêques d'Orléans\">évêque d’Orléans</a> Marc mentionne le lieu <i>Clariacus vicus</i>&#160;: le terme <i><a href=\"/wiki/Vicus\" title=\"Vicus\">Vicus</a></i> désigne en <a href=\"/wiki/Latin\" title=\"Latin\">latin</a> un groupe d’habitations, village ou hameau, et <i>Clariacus</i> son nom.</span><sup class=\"need_ref_tag\" style=\"padding-left:2px;\"><a href=\"/wiki/Aide:R%C3%A9f%C3%A9rence_n%C3%A9cessaire\" title=\"Aide:Référence nécessaire\">[réf.&#160;nécessaire]</a></sup></p>\n<p>Le nom de la ville d'Orléans dérive probablement de la corruption de l'un de ses anciens noms, <i>Aurelianum</i>, qui pourrait être issu du nom des empereurs romains <a href=\"/wiki/Marc_Aur%C3%A8le\" title=\"Marc Aurèle\">Marc Aurèle</a>, qui aurait fait embellir la ville en <a href=\"/wiki/163\" title=\"163\">163</a>, ou Aurélien qui la fit rebâtir en <a href=\"/wiki/273\" title=\"273\">273</a>. Une autre hypothèse évoque la possibilité que la ville tienne son nom de la mère de <a href=\"/wiki/Jules_C%C3%A9sar\" title=\"Jules César\">Jules César</a>, <a href=\"/wiki/Aurelia_Cotta\" title=\"Aurelia Cotta\">Aurelia Cotta</a><sup id=\"cite_ref-29\" class=\"reference\"><a href=\"#cite_note-29\"><span class=\"cite_crochet\">[</span>19<span class=\"cite_crochet\">]</span></a></sup>. Une étude de Jacques Soyer relègue néanmoins ces hypothèses au statut de légende, <i>Aurelia</i> descendant, d'après ses recherches, du nom de la <a href=\"/wiki/Gens_(Rome_antique)\" title=\"Gens (Rome antique)\">gens</a> <i>Aurelia</i> qui possédait des terres à <a href=\"/wiki/Cenabum\" title=\"Cenabum\">Cenabum</a>, ancienne cité <a href=\"/wiki/Peuples_celtes\" title=\"Peuples celtes\">celtique</a> des <a href=\"/wiki/Carnutes\" title=\"Carnutes\">Carnutes</a> située à l'emplacement d'Orléans<sup id=\"cite_ref-30\" class=\"reference\"><a href=\"#cite_note-30\"><span class=\"cite_crochet\">[</span>20<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<h3><span id=\"Le_vin_d.27Orl.C3.A9ans_dans_les_arts\"></span><span class=\"mw-headline\" id=\"Le_vin_d'Orléans_dans_les_arts\">Le vin d'Orléans dans les arts</span></h3>\n<p>En <a href=\"/wiki/1605\" title=\"1605\">1605</a>, le poète orléanais, Simon du Rouzeau (?-<a href=\"/wiki/1627\" title=\"1627\">1627</a>)<sup id=\"cite_ref-31\" class=\"reference\"><a href=\"#cite_note-31\"><span class=\"cite_crochet\">[</span>21<span class=\"cite_crochet\">]</span></a></sup> fait paraître <i>L'Hercule Guespin ou l'himne du vin d'Orléans</i>, texte qui vante la qualité du vin d'Orléans<sup id=\"cite_ref-32\" class=\"reference\"><a href=\"#cite_note-32\"><span class=\"cite_crochet\">[</span>22<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Le comédien Antoine Girard (v.<a href=\"/wiki/1584\" title=\"1584\">1584</a>-<a href=\"/wiki/1633\" title=\"1633\">1633</a>) dit <a href=\"/wiki/Tabarin\" title=\"Tabarin\">Tabarin</a> écrit en <a href=\"/wiki/1623\" title=\"1623\">1623</a> dans son <i>adieu de Tabarin au peuple de Paris</i>, où le vin d'Orléans était à l'époque très consommé&#160;: <span class=\"citation\">«&#160;ce vin d'Orléans, lequel bridant la raison, lasche les resnes à la folie, me fait devenir fol de regret&#160;»</span><sup id=\"cite_ref-33\" class=\"reference\"><a href=\"#cite_note-33\"><span class=\"cite_crochet\">[</span>23<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<h2><span id=\"Situation_g.C3.A9ographique\"></span><span class=\"mw-headline\" id=\"Situation_géographique\">Situation géographique</span></h2>\n<p>L'orléans-cléry<sup id=\"cite_ref-AO_1-2\" class=\"reference\"><a href=\"#cite_note-AO-1\"><span class=\"cite_crochet\">[</span>Notes 1<span class=\"cite_crochet\">]</span></a></sup> est produit en <a href=\"/wiki/France\" title=\"France\">France</a>, dans la <a href=\"/wiki/R%C3%A9gion_fran%C3%A7aise\" title=\"Région française\">région</a> <a href=\"/wiki/R%C3%A9gion_Centre\" class=\"mw-redirect\" title=\"Région Centre\">Centre</a>, plus précisément dans le département du <a href=\"/wiki/Loiret_(d%C3%A9partement)\" title=\"Loiret (département)\">Loiret</a> sur le territoire des communes de <a href=\"/wiki/Cl%C3%A9ry-Saint-Andr%C3%A9\" title=\"Cléry-Saint-André\">Cléry-Saint-André</a>, <a href=\"/wiki/Mareau-aux-Pr%C3%A9s\" title=\"Mareau-aux-Prés\">Mareau-aux-Prés</a>, <a href=\"/wiki/M%C3%A9zi%C3%A8res-lez-Cl%C3%A9ry\" title=\"Mézières-lez-Cléry\">Mézières-lez-Cléry</a>, <a href=\"/wiki/Olivet_(Loiret)\" title=\"Olivet (Loiret)\">Olivet</a> et <a href=\"/wiki/Saint-Hilaire-Saint-Mesmin\" title=\"Saint-Hilaire-Saint-Mesmin\">Saint-Hilaire-Saint-Mesmin</a>, en aval d'<a href=\"/wiki/Orl%C3%A9ans\" title=\"Orléans\">Orléans</a>.</p>\n<h3><span id=\"G.C3.A9ologie_et_orographie\"></span><span class=\"mw-headline\" id=\"Géologie_et_orographie\">Géologie et orographie</span></h3>\n<div class=\"thumb tright\">\n<div class=\"thumbinner\" style=\"width:222px;\"><a href=\"/wiki/Fichier:Rep%C3%A8res_de_crues_de_la_Loire_%C3%A0_Orl%C3%A9ans.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/8/8d/Rep%C3%A8res_de_crues_de_la_Loire_%C3%A0_Orl%C3%A9ans.jpg/220px-Rep%C3%A8res_de_crues_de_la_Loire_%C3%A0_Orl%C3%A9ans.jpg\" width=\"220\" height=\"527\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/8/8d/Rep%C3%A8res_de_crues_de_la_Loire_%C3%A0_Orl%C3%A9ans.jpg/330px-Rep%C3%A8res_de_crues_de_la_Loire_%C3%A0_Orl%C3%A9ans.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/8/8d/Rep%C3%A8res_de_crues_de_la_Loire_%C3%A0_Orl%C3%A9ans.jpg/440px-Rep%C3%A8res_de_crues_de_la_Loire_%C3%A0_Orl%C3%A9ans.jpg 2x\" data-file-width=\"960\" data-file-height=\"2300\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/Fichier:Rep%C3%A8res_de_crues_de_la_Loire_%C3%A0_Orl%C3%A9ans.jpg\" class=\"internal\" title=\"Agrandir\"></a></div>\nLa géologie locale est déterminée par les dépôts de la Loire&#160;; repères de crues du fleuve à Orléans.</div>\n</div>\n</div>\n<div class=\"thumb tleft\">\n<div class=\"thumbinner\" style=\"width:222px;\"><a href=\"/wiki/Fichier:Sol_alluvions_Mareau.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/f/f6/Sol_alluvions_Mareau.jpg/220px-Sol_alluvions_Mareau.jpg\" width=\"220\" height=\"147\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/f/f6/Sol_alluvions_Mareau.jpg/330px-Sol_alluvions_Mareau.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/f/f6/Sol_alluvions_Mareau.jpg/440px-Sol_alluvions_Mareau.jpg 2x\" data-file-width=\"1452\" data-file-height=\"972\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/Fichier:Sol_alluvions_Mareau.jpg\" class=\"internal\" title=\"Agrandir\"></a></div>\nSol d'<a href=\"/wiki/Alluvions\" class=\"mw-redirect\" title=\"Alluvions\">alluvions</a> (<a href=\"/wiki/Sable\" title=\"Sable\">sable</a> et <a href=\"/wiki/Limon_(roche)\" title=\"Limon (roche)\">limon</a>) à <a href=\"/wiki/Mareau-aux-Pr%C3%A9s\" title=\"Mareau-aux-Prés\">Mareau-aux-Prés</a></div>\n</div>\n</div>\n<p>.</p>\n<p>Les vignes sont plantées sur les <a href=\"/wiki/Alluvions\" class=\"mw-redirect\" title=\"Alluvions\">alluvions</a> qui recouvrent presque toute la rive gauche de la <a href=\"/wiki/Loire_(fleuve)\" class=\"mw-redirect\" title=\"Loire (fleuve)\">Loire</a>. Au bord du fleuve s'étalent d'abord les alluvions les plus récentes, délimitant le <a href=\"/wiki/Lit_mineur\" title=\"Lit mineur\">lit mineur</a> mais aussi <a href=\"/wiki/Lit_(hydrologie)\" title=\"Lit (hydrologie)\">majeur</a> (les zones inondables, protégées par les <a href=\"/wiki/Lev%C3%A9e_de_la_Loire\" title=\"Levée de la Loire\">levées de la Loire</a>). Ces alluvions sont de différentes tailles, du <a href=\"/wiki/Limon_(roche)\" title=\"Limon (roche)\">limon</a> <a href=\"/wiki/Sable\" title=\"Sable\">sableux</a> le plus fin aux <a href=\"/wiki/Galet\" title=\"Galet\">galets</a>, majoritairement <a href=\"/wiki/Silice\" title=\"Silice\">siliceux</a> (sable de <a href=\"/wiki/Quartz_(min%C3%A9ral)\" title=\"Quartz (minéral)\">quartz</a> et de <a href=\"/wiki/Feldspath\" title=\"Feldspath\">feldspaths</a>, galets de <a href=\"/wiki/Silex\" title=\"Silex\">silex</a>, de <a href=\"/wiki/Gr%C3%A8s_(g%C3%A9ologie)\" title=\"Grès (géologie)\">grès</a>, de <a href=\"/wiki/Roche_volcanique\" title=\"Roche volcanique\">roches éruptives</a> et de <a href=\"/wiki/Calcaire\" title=\"Calcaire\">calcaire</a>) provenant du <a href=\"/wiki/Massif_central\" title=\"Massif central\">Massif central</a>.</p>\n<p>Un peu au-dessus, à la limite basse des villages, affleure le calcaire de <a href=\"/wiki/Beauce_(France)\" class=\"mw-redirect\" title=\"Beauce (France)\">Beauce</a> sous forme d'une étroite bande. Datant de l'<a href=\"/wiki/Aquitanien\" title=\"Aquitanien\">Aquitanien</a>, c'est un calcaire <a href=\"/wiki/Craie\" title=\"Craie\">crayeux</a> qui plonge immédiatement sous le placage des alluvions du haut du coteau. Plus haut, ce calcaire est couvert par des sables alluviaux éolisés (chariés à l'origine par le vent), du <a href=\"/wiki/Glacis_(g%C3%A9omorphologie)\" title=\"Glacis (géomorphologie)\">glacis</a> d'Olivet à Mareau-aux-Prés, sur lesquels sont plantés vignes et vergers.</p>\n<p>Enfin à partir de la limite des bois couvrant la <a href=\"/wiki/Sologne\" title=\"Sologne\">Sologne</a> commence la couche de six à sept mètres d'alluvions anciennes, formant la terrasse de <a href=\"/wiki/Ch%C3%A2teauneuf-sur-Loire\" title=\"Châteauneuf-sur-Loire\">Châteauneuf</a>. Datant de la <a href=\"/wiki/Glaciation_de_Riss\" title=\"Glaciation de Riss\">glaciation de Riss</a>, ces alluvions vont de l'<a href=\"/wiki/Argile\" title=\"Argile\">argile</a> aux gros blocs, composées uniquement de silice sans le moindre calcaire<sup id=\"cite_ref-34\" class=\"reference\"><a href=\"#cite_note-34\"><span class=\"cite_crochet\">[</span>24<span class=\"cite_crochet\">]</span></a></sup><sup class=\"reference cite_virgule\">,</sup><sup id=\"cite_ref-35\" class=\"reference\"><a href=\"#cite_note-35\"><span class=\"cite_crochet\">[</span>25<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<div class=\"bandeau-section bandeau-niveau-detail loupe\">Article détaillé&#160;: <a href=\"/wiki/%C3%89chelle_des_temps_g%C3%A9ologiques\" title=\"Échelle des temps géologiques\">échelle des temps géologiques</a>.</div>\n<h3><span class=\"mw-headline\" id=\"Climatologie\">Climatologie</span></h3>\n<div class=\"bandeau-section bandeau-niveau-detail loupe\">Article connexe&#160;: <a href=\"/wiki/Climat_du_Loiret\" title=\"Climat du Loiret\">climat du Loiret</a>.</div>\n<p>Le climat est <a href=\"/wiki/Climat_temp%C3%A9r%C3%A9\" title=\"Climat tempéré\">tempéré</a> <a href=\"/wiki/Climat_oc%C3%A9anique\" title=\"Climat océanique\">océanique</a> à influence <a href=\"/wiki/Climat_continental\" title=\"Climat continental\">continentale</a>.</p>\n<p>La <a href=\"/wiki/Station_m%C3%A9t%C3%A9o\" class=\"mw-redirect\" title=\"Station météo\">station météo</a> de niveau 0<sup id=\"cite_ref-36\" class=\"reference\"><a href=\"#cite_note-36\"><span class=\"cite_crochet\">[</span>Notes 5<span class=\"cite_crochet\">]</span></a></sup> la plus proche du vignoble est celle du village de <a href=\"/wiki/Bricy\" title=\"Bricy\">Bricy</a>. Elle est située à <span class=\"nowrap\">17 <abbr class=\"abbr\" title=\"kilomètre\">km</abbr></span> au nord du centre de l'aire d'appellation<sup id=\"cite_ref-37\" class=\"reference\"><a href=\"#cite_note-37\"><span class=\"cite_crochet\">[</span>Notes 6<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<table class=\"wikitable sortable centre\" style=\"text-align:center; background: #FFFFFF; color:#000000;\">\n<caption>Relevé météorologique d'Orléans-Bricy 1961-1990</caption>\n<tr>\n<th scope=\"col\" class=\"unsortable\">Mois</th>\n<th scope=\"col\" class=\"unsortable\"><abbr title=\"janvier\">jan.</abbr></th>\n<th scope=\"col\" class=\"unsortable\"><abbr title=\"février\">fév.</abbr></th>\n<th scope=\"col\" class=\"unsortable\">mars</th>\n<th scope=\"col\" class=\"unsortable\">avril</th>\n<th scope=\"col\" class=\"unsortable\">mai</th>\n<th scope=\"col\" class=\"unsortable\">juin</th>\n<th scope=\"col\" class=\"unsortable\"><abbr title=\"juillet\">jui.</abbr></th>\n<th scope=\"col\" class=\"unsortable\">août</th>\n<th scope=\"col\" class=\"unsortable\"><abbr title=\"septembre\">sep.</abbr></th>\n<th scope=\"col\" class=\"unsortable\"><abbr title=\"octobre\">oct.</abbr></th>\n<th scope=\"col\" class=\"unsortable\"><abbr title=\"novembre\">nov.</abbr></th>\n<th scope=\"col\" class=\"unsortable\"><abbr title=\"décembre\">déc.</abbr></th>\n<th scope=\"col\" class=\"unsortable\">année</th>\n</tr>\n<tr>\n<th scope=\"row\" style=\"text-align:left;\">Température minimale moyenne (<a href=\"/wiki/Degr%C3%A9_Celsius\" title=\"Degré Celsius\">°C</a>)</th>\n<td style=\"background-color:#FFFFFF\">0,3</td>\n<td style=\"background-color:#FFFFFF\">0,8</td>\n<td style=\"background-color:#FFFFFF\">2,2</td>\n<td style=\"background-color:#FFFFFF\">4,3</td>\n<td style=\"background-color:#FFFFC0\">7,8</td>\n<td style=\"background-color:#FFFFC0\">10,7</td>\n<td style=\"background-color:#FFFF80\">12,6</td>\n<td style=\"background-color:#FFFFC0\">12,3</td>\n<td style=\"background-color:#FFFFC0\">10,3</td>\n<td style=\"background-color:#FFFFC0\">7,3</td>\n<td style=\"background-color:#FFFFFF\">3,3</td>\n<td style=\"background-color:#FFFFFF\">1,1</td>\n<td><b>6,1</b></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"text-align:left;\">Température moyenne (°C)</th>\n<td style=\"background-color:#FFFFFF\">3,1</td>\n<td style=\"background-color:#FFFFFF\">4,2</td>\n<td style=\"background-color:#FFFFC0\">6,6</td>\n<td style=\"background-color:#FFFFC0\">9,3</td>\n<td style=\"background-color:#FFFF80\">12,9</td>\n<td style=\"background-color:#FFFF80\">16,2</td>\n<td style=\"background-color:#FFFF80\">18,5</td>\n<td style=\"background-color:#FFFF80\">18,2</td>\n<td style=\"background-color:#FFFF80\">15,8</td>\n<td style=\"background-color:#FFFFC0\">11,7</td>\n<td style=\"background-color:#FFFFC0\">6,6</td>\n<td style=\"background-color:#FFFFFF\">3,8</td>\n<td><b>10,6</b></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"text-align:left;\">Température maximale moyenne (°C)</th>\n<td style=\"background-color:#FFFFC0\">5,9</td>\n<td style=\"background-color:#FFFFC0\">7,6</td>\n<td style=\"background-color:#FFFFC0\">10,9</td>\n<td style=\"background-color:#FFFF80\">14,3</td>\n<td style=\"background-color:#FFFF80\">18,1</td>\n<td style=\"background-color:#FFC040\">21,6</td>\n<td style=\"background-color:#FFC040\">24,4</td>\n<td style=\"background-color:#FFC040\">24</td>\n<td style=\"background-color:#FFC040\">21,2</td>\n<td style=\"background-color:#FFFF80\">16,2</td>\n<td style=\"background-color:#FFFFC0\">9,9</td>\n<td style=\"background-color:#FFFFC0\">6,5</td>\n<td><b>15,1</b></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"text-align:left;\">Ensoleillement (<a href=\"/wiki/Heure\" title=\"Heure\">h</a>)</th>\n<td style=\"background-color:#FFFFC0\">58,5</td>\n<td style=\"background-color:#FFFFC0\">85,2</td>\n<td style=\"background-color:#FFFF80\">134,7</td>\n<td style=\"background-color:#FFC040\">176,6</td>\n<td style=\"background-color:#FFC040\">206,7</td>\n<td style=\"background-color:#FF8000\">230,4</td>\n<td style=\"background-color:#FF8000\">252,2</td>\n<td style=\"background-color:#FF8000\">225</td>\n<td style=\"background-color:#FFC040\">180,3</td>\n<td style=\"background-color:#FFFF80\">129,5</td>\n<td style=\"background-color:#FFFFC0\">74,6</td>\n<td style=\"background-color:#FFFFC0\">50,7</td>\n<td><b>1&#160;804,5</b></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"text-align:left;\">Précipitations (<a href=\"/wiki/Millim%C3%A8tre\" title=\"Millimètre\">mm</a>)</th>\n<td style=\"background-color:#DCF0FF\">55,2</td>\n<td style=\"background-color:#DCF0FF\">49,7</td>\n<td style=\"background-color:#DCF0FF\">51,8</td>\n<td style=\"background-color:#FFFFFF\">47,9</td>\n<td style=\"background-color:#DCF0FF\">65,8</td>\n<td style=\"background-color:#FFFFFF\">47,5</td>\n<td style=\"background-color:#DCF0FF\">52,4</td>\n<td style=\"background-color:#FFFFFF\">45,3</td>\n<td style=\"background-color:#DCF0FF\">49,3</td>\n<td style=\"background-color:#DCF0FF\">57,9</td>\n<td style=\"background-color:#DCF0FF\">60,1</td>\n<td style=\"background-color:#DCF0FF\">54,3</td>\n<td><b>637,2</b></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"text-align:left;\">Humidité relative (%)</th>\n<td style=\"background-color:#6478FF\">89</td>\n<td style=\"background-color:#6478FF\">85</td>\n<td style=\"background-color:#8CA0FF\">79</td>\n<td style=\"background-color:#8CA0FF\">74</td>\n<td style=\"background-color:#8CA0FF\">76</td>\n<td style=\"background-color:#8CA0FF\">74</td>\n<td style=\"background-color:#8CA0FF\">72</td>\n<td style=\"background-color:#8CA0FF\">72</td>\n<td style=\"background-color:#8CA0FF\">77</td>\n<td style=\"background-color:#6478FF\">84</td>\n<td style=\"background-color:#6478FF\">89</td>\n<td style=\"background-color:#6478FF\">90</td>\n<td><b>80</b></td>\n</tr>\n</table>\n<div style=\"font-style:italic; margin-top: -1em; text-align:center; font-size:85%\">Source&#160;: Infoclimat<sup id=\"cite_ref-infoclimat_4-1\" class=\"reference\"><a href=\"#cite_note-infoclimat-4\"><span class=\"cite_crochet\">[</span>3<span class=\"cite_crochet\">]</span></a></sup></div>\n<table style=\"text-align:center; margin: 1em auto; border:solid 1px silver; border-collapse: collapse;\">\n<tr>\n<td colspan=\"12\"><a href=\"/wiki/Diagramme_climatique\" title=\"Diagramme climatique\">Diagramme climatique</a></td>\n</tr>\n<tr>\n<td><abbr title=\"janvier\">J</abbr></td>\n<td><abbr title=\"février\">F</abbr></td>\n<td><abbr title=\"mars\">M</abbr></td>\n<td><abbr title=\"avril\">A</abbr></td>\n<td><abbr title=\"mai\">M</abbr></td>\n<td><abbr title=\"juin\">J</abbr></td>\n<td><abbr title=\"juillet\">J</abbr></td>\n<td><abbr title=\"août\">A</abbr></td>\n<td><abbr title=\"septembre\">S</abbr></td>\n<td><abbr title=\"octobre\">O</abbr></td>\n<td><abbr title=\"novembre\">N</abbr></td>\n<td><abbr title=\"décembre\">D</abbr></td>\n</tr>\n<tr>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:1.104em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:8.06em;left:.4em;height:1.12em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:8.93em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>5,9</small></div>\n<div style=\"position:absolute;margin:0;bottom:6.56em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>0,3</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>55,2</small></div>\n</div>\n</td>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:0.994em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:8.16em;left:.4em;height:1.36em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:9.27em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>7,6</small></div>\n<div style=\"position:absolute;margin:0;bottom:6.66em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>0,8</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>49,7</small></div>\n</div>\n</td>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:1.036em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:8.44em;left:.4em;height:1.74em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:9.93em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>10,9</small></div>\n<div style=\"position:absolute;margin:0;bottom:6.94em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>2,2</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>51,8</small></div>\n</div>\n</td>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:0.958em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:8.86em;left:.4em;height:2em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:10.61em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>14,3</small></div>\n<div style=\"position:absolute;margin:0;bottom:7.36em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>4,3</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>47,9</small></div>\n</div>\n</td>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:1.316em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:9.56em;left:.4em;height:2.06em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:11.37em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>18,1</small></div>\n<div style=\"position:absolute;margin:0;bottom:8.06em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>7,8</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>65,8</small></div>\n</div>\n</td>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:0.95em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:10.14em;left:.4em;height:2.18em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:12.07em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>21,6</small></div>\n<div style=\"position:absolute;margin:0;bottom:8.64em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>10,7</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>47,5</small></div>\n</div>\n</td>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:1.048em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:10.52em;left:.4em;height:2.36em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:12.63em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>24,4</small></div>\n<div style=\"position:absolute;margin:0;bottom:9.02em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>12,6</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>52,4</small></div>\n</div>\n</td>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:0.906em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:10.46em;left:.4em;height:2.34em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:12.55em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>24</small></div>\n<div style=\"position:absolute;margin:0;bottom:8.96em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>12,3</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>45,3</small></div>\n</div>\n</td>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:0.986em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:10.06em;left:.4em;height:2.18em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:11.99em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>21,2</small></div>\n<div style=\"position:absolute;margin:0;bottom:8.56em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>10,3</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>49,3</small></div>\n</div>\n</td>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:1.158em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:9.46em;left:.4em;height:1.78em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:10.99em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>16,2</small></div>\n<div style=\"position:absolute;margin:0;bottom:7.96em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>7,3</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>57,9</small></div>\n</div>\n</td>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:1.202em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:8.66em;left:.4em;height:1.32em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:9.73em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>9,9</small></div>\n<div style=\"position:absolute;margin:0;bottom:7.16em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>3,3</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>60,1</small></div>\n</div>\n</td>\n<td>\n<div style=\"position:relative;margin:0;height:16.5em;width:1.6em;background:white;padding:0;color:black;line-height:1.5;vertical-align:bottom;text-align:center\">\n<div style=\"position:absolute;margin:0;bottom:2em;left:0;height:6em;width:1.6em;overflow:hidden;border-top:1px dotted #AAA;border-bottom:1px dotted #AAA;background:none;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:2em;left:.4em;height:1.086em;width:.8em;overflow:hidden;background:#6478FF;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:8.22em;left:.4em;height:1.08em;width:.8em;overflow:hidden;background:black;padding:0;color:transparent\">&#160;</div>\n<div style=\"position:absolute;margin:0;bottom:9.05em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:red\"><small>6,5</small></div>\n<div style=\"position:absolute;margin:0;bottom:6.72em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:blue\"><small>1,1</small></div>\n<div style=\"position:absolute;margin:0;bottom:.5em;left:0;height:1.5em;width:1.6em;background:none;padding:0;color:#6478FF\"><small>54,3</small></div>\n</div>\n</td>\n</tr>\n<tr>\n<td colspan=\"12\" style=\"text-align:left;\">Moyennes&#160;: <abbr title=\"Températures\">• Temp.</abbr> <span style=\"color:red\">maxi</span> et <span style=\"color:blue\">mini</span> <abbr title=\"Degrés Celsius\">°C</abbr> <span style=\"color:#6478FF\">• Précipitation</span> <abbr title=\"Millimètres\">mm</abbr></td>\n</tr>\n</table>\n<p>Le tableau ci-dessous permet de comparer l'ensoleillement du vignoble orléanais à celui d'autres régions françaises&#160;:</p>\n<table border=\"0\">\n<tr>\n<td valign=\"center\" width=\"70%\">\n<table class=\"wikitable centre\" style=\"text-align:right\">\n<caption class=\"hidden\">Comparaison des données météorologiques de Orléans avec les données nationales</caption>\n<tr>\n<th scope=\"col\" style=\"background:#DDFFDD\">Ville</th>\n<th scope=\"col\" width=\"100\" style=\"background-color:#DDFFDD\">Ensoleillement<br />\n<img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/e/e2/Weather-clear.svg/20px-Weather-clear.svg.png\" width=\"20\" height=\"20\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/e/e2/Weather-clear.svg/30px-Weather-clear.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/e/e2/Weather-clear.svg/40px-Weather-clear.svg.png 2x\" data-file-width=\"48\" data-file-height=\"48\" /> (h/an)</th>\n<th scope=\"col\" width=\"100\" style=\"background:#DDFFDD\">Pluie<br />\n<img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/4/45/Weather-overcast-rare-showers.svg/20px-Weather-overcast-rare-showers.svg.png\" width=\"20\" height=\"20\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/4/45/Weather-overcast-rare-showers.svg/30px-Weather-overcast-rare-showers.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/4/45/Weather-overcast-rare-showers.svg/40px-Weather-overcast-rare-showers.svg.png 2x\" data-file-width=\"48\" data-file-height=\"48\" /> (mm/an)</th>\n</tr>\n<tr>\n<th scope=\"row\">Moyenne nationale</th>\n<td>1 973</td>\n<td>770</td>\n</tr>\n<tr style=\"background: #D1E8FF\">\n<th scope=\"row\" style=\"background:#D1E8FF\"><b>Orléans</b></th>\n<td><b>1804</b></td>\n<td><b>637</b></td>\n</tr>\n<tr>\n<th scope=\"row\"><a href=\"/wiki/Paris\" title=\"Paris\">Paris</a></th>\n<td>1 661</td>\n<td>637</td>\n</tr>\n<tr>\n<th scope=\"row\"><a href=\"/wiki/Nice\" title=\"Nice\">Nice</a></th>\n<td>2 724</td>\n<td>733</td>\n</tr>\n<tr>\n<th scope=\"row\"><a href=\"/wiki/Strasbourg\" title=\"Strasbourg\">Strasbourg</a></th>\n<td>1 693</td>\n<td>665</td>\n</tr>\n<tr>\n<th scope=\"row\"><a href=\"/wiki/Brest\" title=\"Brest\">Brest</a></th>\n<td>1 605</td>\n<td>1 211</td>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<p>Les données relevées à la station de Bricy peuvent néanmoins présenter plusieurs biais potentiels par rapport aux véritables conditions rencontrées dans le vignoble. En effet, la station est située à <span class=\"nowrap\">125 mètres</span> d'altitude, au nord de la Loire et au sud de la région naturelle de <a href=\"/wiki/Beauce_(France)\" class=\"mw-redirect\" title=\"Beauce (France)\">Beauce</a> alors que l'aire d'appellation d'orléans-cléry est localisée entre 82 et <span class=\"nowrap\">109 mètres</span> d'altitude au sud du fleuve, dans le val de Loire, au contact du nord de la <a href=\"/wiki/Sologne\" title=\"Sologne\">Sologne</a>. Dès lors, les stations manuelles de niveau 4, situées à <a href=\"/wiki/Baule\" title=\"Baule\">Baule</a>, <a href=\"/wiki/Orl%C3%A9ans-la-Source\" title=\"Orléans-la-Source\">Orléans-la-Source</a> et Saint-Hilaire-Saint-Mesmin<sup id=\"cite_ref-38\" class=\"reference\"><a href=\"#cite_note-38\"><span class=\"cite_crochet\">[</span>26<span class=\"cite_crochet\">]</span></a></sup> ainsi que la station du réseau des stations amateurs en ligne d'Infoclimat de <a href=\"/wiki/Saint-Cyr-en-Val\" title=\"Saint-Cyr-en-Val\">Saint-Cyr-en-Val</a><sup id=\"cite_ref-39\" class=\"reference\"><a href=\"#cite_note-39\"><span class=\"cite_crochet\">[</span>27<span class=\"cite_crochet\">]</span></a></sup> peuvent également être informatives quant aux conditions météorologiques rencontrées sur le vignoble.</p>\n<table border=\"0\">\n<tr>\n<td valign=\"top\" width=\"50%\">\n<table border=\"0\" align=\"center\" style=\"border: 1px solid #999; background-color:#FFFFFF\" cellspacing=\"3px\" cellpadding=\"10px\">\n<tr align=\"center\" bgcolor=\"#CCCCCC\">\n<th colspan=\"3\">Altitudes (en mètres) rencontrées<br />\ndans les communes de l'aire d'appellation</th>\n</tr>\n<tr>\n<th>Communes</th>\n<th>min.</th>\n<th>max.</th>\n</tr>\n<tr>\n<td><a href=\"/wiki/Cl%C3%A9ry-Saint-Andr%C3%A9\" title=\"Cléry-Saint-André\">Cléry-Saint-André</a><sup id=\"cite_ref-40\" class=\"reference\"><a href=\"#cite_note-40\"><span class=\"cite_crochet\">[</span>A 1<span class=\"cite_crochet\">]</span></a></sup></td>\n<td>84</td>\n<td>107</td>\n</tr>\n<tr>\n<td><a href=\"/wiki/Mareau-aux-Pr%C3%A9s\" title=\"Mareau-aux-Prés\">Mareau-aux-Prés</a><sup id=\"cite_ref-41\" class=\"reference\"><a href=\"#cite_note-41\"><span class=\"cite_crochet\">[</span>A 2<span class=\"cite_crochet\">]</span></a></sup></td>\n<td>82</td>\n<td>103</td>\n</tr>\n<tr>\n<td><a href=\"/wiki/M%C3%A9zi%C3%A8res-lez-Cl%C3%A9ry\" title=\"Mézières-lez-Cléry\">Mézières-lez-Cléry</a><sup id=\"cite_ref-42\" class=\"reference\"><a href=\"#cite_note-42\"><span class=\"cite_crochet\">[</span>A 3<span class=\"cite_crochet\">]</span></a></sup></td>\n<td>91</td>\n<td>108</td>\n</tr>\n<tr>\n<td><a href=\"/wiki/Olivet_(Loiret)\" title=\"Olivet (Loiret)\">Olivet</a><sup id=\"cite_ref-43\" class=\"reference\"><a href=\"#cite_note-43\"><span class=\"cite_crochet\">[</span>A 4<span class=\"cite_crochet\">]</span></a></sup></td>\n<td>89</td>\n<td>109</td>\n</tr>\n<tr>\n<td><a href=\"/wiki/Saint-Hilaire-Saint-Mesmin\" title=\"Saint-Hilaire-Saint-Mesmin\">Saint-Hilaire-Saint-Mesmin</a><sup id=\"cite_ref-44\" class=\"reference\"><a href=\"#cite_note-44\"><span class=\"cite_crochet\">[</span>A 5<span class=\"cite_crochet\">]</span></a></sup></td>\n<td>87</td>\n<td>105</td>\n</tr>\n<tr>\n<th colspan=\"3\"><small>min.&#160;: altitude minimum&#160;; max.&#160;: altitude maximum</small></th>\n</tr>\n</table>\n</td>\n<td valign=\"top\" width=\"50%\">\n<table border=\"0\" align=\"center\" style=\"border: 1px solid #999; background-color:#FFFFFF\" cellspacing=\"3px\" cellpadding=\"10px\">\n<tr align=\"center\" bgcolor=\"#CCCCCC\">\n<th colspan=\"4\">Caractéristiques des stations météorologiques<br />\nsituées à proximité de l'aire d'appellation</th>\n</tr>\n<tr>\n<th>Stations</th>\n<th>type</th>\n<th>alt.</th>\n<th>km</th>\n</tr>\n<tr>\n<td><a href=\"/wiki/Baule\" title=\"Baule\">Baule</a></td>\n<td>4</td>\n<td>&#160;?</td>\n<td>11</td>\n</tr>\n<tr>\n<td><a href=\"/wiki/Bricy\" title=\"Bricy\">Bricy</a></td>\n<td>0</td>\n<td>125</td>\n<td>17</td>\n</tr>\n<tr>\n<td><a href=\"/wiki/Orl%C3%A9ans-la-Source\" title=\"Orléans-la-Source\">Orléans-la-Source</a></td>\n<td>4</td>\n<td>&#160;?</td>\n<td>9</td>\n</tr>\n<tr>\n<td><a href=\"/wiki/Saint-Cyr-en-Val\" title=\"Saint-Cyr-en-Val\">Saint-Cyr-en-Val</a></td>\n<td><small>amateur</small></td>\n<td>96</td>\n<td>12</td>\n</tr>\n<tr>\n<td><a href=\"/wiki/Saint-Hilaire-Saint-Mesmin\" title=\"Saint-Hilaire-Saint-Mesmin\">Saint-Hilaire-Saint-Mesmin</a></td>\n<td>4</td>\n<td>&#160;?</td>\n<td>3</td>\n</tr>\n<tr>\n<th colspan=\"4\"><small>alt.&#160;: altitude&#160;; km&#160;: distance en kilomètres<br />\npar rapport au centre de l'aire d'appellation</small></th>\n</tr>\n</table>\n</td>\n</tr>\n</table>\n<h2><span class=\"mw-headline\" id=\"Vignoble\">Vignoble</span></h2>\n<div class=\"thumb tright\">\n<div class=\"thumbinner\" style=\"width:302px;\"><a href=\"/wiki/Fichier:Carte_vignoble_vallee_de_la_loire.png\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/b/b0/Carte_vignoble_vallee_de_la_loire.png/300px-Carte_vignoble_vallee_de_la_loire.png\" width=\"300\" height=\"150\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/b/b0/Carte_vignoble_vallee_de_la_loire.png/450px-Carte_vignoble_vallee_de_la_loire.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/b/b0/Carte_vignoble_vallee_de_la_loire.png/600px-Carte_vignoble_vallee_de_la_loire.png 2x\" data-file-width=\"1447\" data-file-height=\"723\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/Fichier:Carte_vignoble_vallee_de_la_loire.png\" class=\"internal\" title=\"Agrandir\"></a></div>\nCarte du <a href=\"/wiki/Vignoble_de_la_vall%C3%A9e_de_la_Loire\" title=\"Vignoble de la vallée de la Loire\">vignoble de la vallée de la Loire</a>. Les appellations orléans et orléans-cléry apparaissent en rose dans la région septentrionale de la Loire</div>\n</div>\n</div>\n<p>La surface exploitée de l'aire d'appellation est de <span class=\"nowrap\"><span title=\"280&#160;000 m² ou 0,28 km²\">28</span> <abbr class=\"abbr\" title=\"hectares\"><a href=\"/wiki/Hectare\" title=\"Hectare\">hectares</a></abbr></span><sup id=\"cite_ref-Guide_Hachette_5-2\" class=\"reference\"><a href=\"#cite_note-Guide_Hachette-5\"><span class=\"cite_crochet\">[</span>4<span class=\"cite_crochet\">]</span></a></sup>. Le vignoble est situé sur le cours de la <a href=\"/wiki/Loire_(fleuve)\" class=\"mw-redirect\" title=\"Loire (fleuve)\">Loire</a> entre les vignobles de <a href=\"/wiki/Touraine_(AOC)\" title=\"Touraine (AOC)\">Touraine</a> (à l'ouest) et de Centre-Loire (au sud-est).</p>\n<h3><span id=\"G.C3.A9ographie\"></span><span class=\"mw-headline\" id=\"Géographie\">Géographie</span></h3>\n<p>Cinq communes productrices peuvent prétendre à l'appellation orléans-cléry<sup id=\"cite_ref-AO_1-3\" class=\"reference\"><a href=\"#cite_note-AO-1\"><span class=\"cite_crochet\">[</span>Notes 1<span class=\"cite_crochet\">]</span></a></sup>, trois du <a href=\"/wiki/Canton_de_Cl%C3%A9ry-Saint-Andr%C3%A9\" title=\"Canton de Cléry-Saint-André\">canton de Cléry-Saint-André</a>, à savoir <a href=\"/wiki/Cl%C3%A9ry-Saint-Andr%C3%A9\" title=\"Cléry-Saint-André\">Cléry-Saint-André</a>, <a href=\"/wiki/Mareau-aux-Pr%C3%A9s\" title=\"Mareau-aux-Prés\">Mareau-aux-Prés</a> et <a href=\"/wiki/M%C3%A9zi%C3%A8res-lez-Cl%C3%A9ry\" title=\"Mézières-lez-Cléry\">Mézières-lez-Cléry</a>, et deux du <a href=\"/wiki/Canton_d%27Olivet\" title=\"Canton d'Olivet\">canton d'Olivet</a>, à savoir <a href=\"/wiki/Olivet_(Loiret)\" title=\"Olivet (Loiret)\">Olivet</a> et <a href=\"/wiki/Saint-Hilaire-Saint-Mesmin\" title=\"Saint-Hilaire-Saint-Mesmin\">Saint-Hilaire-Saint-Mesmin</a>. Ces communes sont toutes situées dans l'<a href=\"/wiki/Arrondissement_d%27Orl%C3%A9ans\" title=\"Arrondissement d'Orléans\">arrondissement</a> et l'<a href=\"/wiki/Aire_urbaine_d%27Orl%C3%A9ans\" title=\"Aire urbaine d'Orléans\">aire urbaine</a> d'Orléans du département du <a href=\"/wiki/Loiret_(d%C3%A9partement)\" title=\"Loiret (département)\">Loiret</a><sup id=\"cite_ref-Légifrance2_7-5\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup><sup class=\"reference cite_virgule\">,</sup><sup id=\"cite_ref-45\" class=\"reference\"><a href=\"#cite_note-45\"><span class=\"cite_crochet\">[</span>28<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Les parcelles, très dispersées, se trouvent dans le <a href=\"/wiki/Val_de_Loire\" title=\"Val de Loire\">val de Loire</a>, sur le coteau en pente douce de la rive gauche de la <a href=\"/wiki/Loire_(fleuve)\" class=\"mw-redirect\" title=\"Loire (fleuve)\">Loire</a>, à une altitude d'environ <span class=\"nowrap\">100 mètres</span>, au milieu de vergers, à la limite avec le massif boisé de la <a href=\"/wiki/R%C3%A9gion_naturelle_de_France\" title=\"Région naturelle de France\">région naturelle</a> de <a href=\"/wiki/Sologne\" title=\"Sologne\">Sologne</a>.</p>\n<h3><span id=\"Enc.C3.A9pagement\"></span><span class=\"mw-headline\" id=\"Encépagement\">Encépagement</span></h3>\n<p>Le nombre de pieds à l'hectare doit au moins être égal à 5&#160;000, chacun d'entre eux devant être espacé d'au moins un mètre, tout en respectant un écartement entre les rangs de deux mètres au maximum. Le pourcentage de pieds de vigne morts ou manquants ne doit pas dépasser 20&#160;%<sup id=\"cite_ref-Légifrance2_7-6\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Les raisins issus des jeunes vignes peuvent bénéficier de l'AOC à partir de la deuxième année suivant celle au cours de laquelle la plantation a été réalisée<sup id=\"cite_ref-Légifrance2_7-7\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Le cépage utilisé majoritairement est le <a href=\"/wiki/Cabernet_franc\" title=\"Cabernet franc\">cabernet franc</a> N<sup id=\"cite_ref-Légifrance2_7-8\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup><sup class=\"reference cite_virgule\">,</sup><sup id=\"cite_ref-cep_6-1\" class=\"reference\"><a href=\"#cite_note-cep-6\"><span class=\"cite_crochet\">[</span>Notes 2<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>À titre transitoire, les parcelles encore plantées en <a href=\"/wiki/Cabernet_sauvignon\" title=\"Cabernet sauvignon\">cabernet sauvignon</a> N en <a href=\"/wiki/2006\" title=\"2006\">2006</a> <span class=\"citation\">«&#160;continuent à bénéficier pour leur récolte du droit à l'appellation d'origine contrôlée, en qualité de cépage accessoire, jusqu'à la récolte 2020 incluse. La proportion de ce cépage ne peut pas être supérieure à 25&#160;% de l'encépagement&#160;»</span><sup id=\"cite_ref-Légifrance2_7-9\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Le cabernet franc N est un <a href=\"/wiki/C%C3%A9page\" title=\"Cépage\">cépage</a> largement utilisé dans le <a href=\"/wiki/Vignoble_de_Bordeaux\" title=\"Vignoble de Bordeaux\">vignoble de Bordeaux</a> et dans le <a href=\"/wiki/Vignoble_de_la_vall%C3%A9e_de_la_Loire\" title=\"Vignoble de la vallée de la Loire\">vignoble de la vallée de la Loire</a>.</p>\n<ul class=\"gallery mw-gallery-traditional\">\n<li class=\"gallerybox\" style=\"width: 155px\">\n<div style=\"width: 155px\">\n<div class=\"thumb\" style=\"width: 150px;\">\n<div style=\"margin:15px auto;\"><a href=\"/wiki/Fichier:Cab_Franc_grape.JPG\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/6/63/Cab_Franc_grape.JPG/112px-Cab_Franc_grape.JPG\" width=\"112\" height=\"120\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/6/63/Cab_Franc_grape.JPG/168px-Cab_Franc_grape.JPG 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/63/Cab_Franc_grape.JPG/224px-Cab_Franc_grape.JPG 2x\" data-file-width=\"449\" data-file-height=\"481\" /></a></div>\n</div>\n<div class=\"gallerytext\">\n<p>Grappe de <a href=\"/wiki/Cabernet_franc\" title=\"Cabernet franc\">cabernet franc</a> N.</p>\n</div>\n</div>\n</li>\n<li class=\"gallerybox\" style=\"width: 155px\">\n<div style=\"width: 155px\">\n<div class=\"thumb\" style=\"width: 150px;\">\n<div style=\"margin:15px auto;\"><a href=\"/wiki/Fichier:Cabernet_Franc_Weinsberg_20060909.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/9/96/Cabernet_Franc_Weinsberg_20060909.jpg/80px-Cabernet_Franc_Weinsberg_20060909.jpg\" width=\"80\" height=\"120\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/9/96/Cabernet_Franc_Weinsberg_20060909.jpg/120px-Cabernet_Franc_Weinsberg_20060909.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/9/96/Cabernet_Franc_Weinsberg_20060909.jpg/160px-Cabernet_Franc_Weinsberg_20060909.jpg 2x\" data-file-width=\"1600\" data-file-height=\"2400\" /></a></div>\n</div>\n<div class=\"gallerytext\">\n<p>Grappe de <a href=\"/wiki/Cabernet_franc\" title=\"Cabernet franc\">cabernet franc</a> N sur pied.</p>\n</div>\n</div>\n</li>\n<li class=\"gallerybox\" style=\"width: 155px\">\n<div style=\"width: 155px\">\n<div class=\"thumb\" style=\"width: 150px;\">\n<div style=\"margin:22px auto;\"><a href=\"/wiki/Fichier:Cab_franc_leaf.JPG\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/c/c1/Cab_franc_leaf.JPG/120px-Cab_franc_leaf.JPG\" width=\"120\" height=\"106\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/c/c1/Cab_franc_leaf.JPG/180px-Cab_franc_leaf.JPG 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/c/c1/Cab_franc_leaf.JPG/240px-Cab_franc_leaf.JPG 2x\" data-file-width=\"747\" data-file-height=\"659\" /></a></div>\n</div>\n<div class=\"gallerytext\">\n<p>Feuille du <a href=\"/wiki/Cabernet_franc\" title=\"Cabernet franc\">cabernet franc</a> N.</p>\n</div>\n</div>\n</li>\n</ul>\n<h3><span id=\"M.C3.A9thodes_culturales\"></span><span class=\"mw-headline\" id=\"Méthodes_culturales\">Méthodes culturales</span></h3>\n<h4><span class=\"mw-headline\" id=\"Travail_manuel\">Travail manuel</span></h4>\n<p>Ce travail commence par la <a href=\"/wiki/Taille_de_la_vigne\" title=\"Taille de la vigne\">taille</a>&#160;: en guyot simple, le cep portant un long bois à sept yeux francs au maximum et un ou deux coursons à un ou deux yeux francs&#160;; en <a href=\"/wiki/Guyot_double\" title=\"Guyot double\">guyot double</a> courte avec deux taquets à quatre yeux francs maximum. Le nombre d'yeux francs par pied ne doit pas excéder dix<sup id=\"cite_ref-Légifrance2_7-10\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Le tirage des sarments suit la taille. Les sarments sont enlevés et peuvent être brûlés ou mis au milieu du rang pour être broyés. On passe ensuite aux réparations ou éventuellement des plantations de greffes. L'<a href=\"/wiki/%C3%89bourgeonnage\" title=\"Ébourgeonnage\">ébourgeonnage</a> peut débuter dès que la vigne a commencé à pousser. Cette méthode permet, en partie, de réguler les rendements<sup id=\"cite_ref-VITI_46-0\" class=\"reference\"><a href=\"#cite_note-VITI-46\"><span class=\"cite_crochet\">[</span>29<span class=\"cite_crochet\">]</span></a></sup>. Le «&#160;relevage&#160;» est pratiqué lorsque la <a href=\"/wiki/Vigne\" title=\"Vigne\">vigne</a> commence à avoir bien poussé. En général, deux à trois relevages sont pratiqués. Pour finir avec le travail manuel à la vigne, se réalise l'étape importante des <a href=\"/wiki/Vendange\" title=\"Vendange\">vendanges</a>.</p>\n<h4><span id=\"Travail_m.C3.A9canique\"></span><span class=\"mw-headline\" id=\"Travail_mécanique\">Travail mécanique</span></h4>\n<p>L'<a href=\"/wiki/Enjambeur\" title=\"Enjambeur\">enjambeur</a> est d'une aide précieuse. Les différents travaux se composent du broyage des sarments&#160;; de trou fait à la tarière, là où les pieds de vignes sont manquants&#160;; de <a href=\"/wiki/Labour\" title=\"Labour\">labourage</a> ou «&#160;griffage&#160;», réalisé dans le but d'aérer les sols et de supprimer des mauvaises herbes<sup id=\"cite_ref-VITI_46-1\" class=\"reference\"><a href=\"#cite_note-VITI-46\"><span class=\"cite_crochet\">[</span>29<span class=\"cite_crochet\">]</span></a></sup>&#160;; de <a href=\"/wiki/D%C3%A9sherbage_(agriculture)\" class=\"mw-redirect\" title=\"Désherbage (agriculture)\">désherbage</a>&#160;; de plusieurs <a href=\"/wiki/Traitement_de_la_vigne\" title=\"Traitement de la vigne\">traitements</a> des vignes, réalisés dans le but de les protéger contre certaines maladies cryptogamiques (dues à des champignons&#160;: <a href=\"/wiki/Mildiou\" title=\"Mildiou\">mildiou</a>, <a href=\"/wiki/O%C3%AFdium\" title=\"Oïdium\">oïdium</a> et <a href=\"/wiki/Pourriture_grise\" title=\"Pourriture grise\">pourriture grise</a>)<sup id=\"cite_ref-VITI_46-2\" class=\"reference\"><a href=\"#cite_note-VITI-46\"><span class=\"cite_crochet\">[</span>29<span class=\"cite_crochet\">]</span></a></sup>&#160;; de plusieurs rognages consistant à «&#160;reciper&#160;» ou couper les branches de vignes (rameaux) qui dépassent du système de palissage&#160;; des vendanges mécaniques se réalisant avec une <a href=\"/wiki/Machine_%C3%A0_vendanger\" title=\"Machine à vendanger\">machine à vendanger</a> ou une tête de récolte montée sur un enjambeur.</p>\n<h3><span id=\"R.C3.A9colte\"></span><span class=\"mw-headline\" id=\"Récolte\">Récolte</span></h3>\n<p>Lors de la récolte, les raisins doivent présenter une richesse en sucre inférieure à 162 grammes par litre de <a href=\"/wiki/Mo%C3%BBt\" title=\"Moût\">moût</a>.</p>\n<h3><span class=\"mw-headline\" id=\"Rendements\">Rendements</span></h3>\n<p>Le <a href=\"/wiki/Rendement_viticole\" title=\"Rendement viticole\">rendement</a> est limité à 50 hectolitres par hectare, avec un rendement butoir à 55 hectolitres par hectare et un rendements maximum de production fixé à 65 hectolitres par hectare<sup id=\"cite_ref-Légifrance2_7-11\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Le rendement réel est largement inférieur, le rendement moyen pour l'ensemble de l'appellation en <a href=\"/wiki/2009\" title=\"2009\">2009</a> était en effet de 30,3 hectolitres par hectare<sup id=\"cite_ref-Guide_Hachette_5-3\" class=\"reference\"><a href=\"#cite_note-Guide_Hachette-5\"><span class=\"cite_crochet\">[</span>4<span class=\"cite_crochet\">]</span></a></sup><sup class=\"reference cite_virgule\">,</sup><sup id=\"cite_ref-47\" class=\"reference\"><a href=\"#cite_note-47\"><span class=\"cite_crochet\">[</span>Notes 7<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<h2><span class=\"mw-headline\" id=\"Vins\">Vins</span></h2>\n<h3><span id=\"Vinification_et_.C3.A9levage\"></span><span class=\"mw-headline\" id=\"Vinification_et_élevage\">Vinification et élevage</span></h3>\n<div class=\"bandeau-section bandeau-niveau-detail loupe\">Article détaillé&#160;: <a href=\"/wiki/Vin_rouge#Vinification\" title=\"Vin rouge\">vinification du vin rouge</a>.</div>\n<p>La <a href=\"/wiki/Vendange\" title=\"Vendange\">récolte</a> des raisins se fait à maturité et de façon manuelle ou mécanique. La vendange manuelle est parfois triée, soit à la vigne soit à la cave avec une table de tri, ce qui permet d'enlever les grappes pourries ou insuffisamment mûres<sup id=\"cite_ref-VITI_46-3\" class=\"reference\"><a href=\"#cite_note-VITI-46\"><span class=\"cite_crochet\">[</span>29<span class=\"cite_crochet\">]</span></a></sup>. La vendange manuelle est généralement <a href=\"/wiki/%C3%89raflage\" title=\"Éraflage\">éraflée</a> puis mise en <a href=\"/wiki/Cuve\" title=\"Cuve\">cuve</a>.</p>\n<p>Une macération pré-fermentaire à froid est quelquefois pratiquée. La <a href=\"/wiki/Fermentation_alcoolique\" title=\"Fermentation alcoolique\">fermentation alcoolique</a> peut démarrer, le plus souvent après un levurage. Commence alors le travail d'extraction des <a href=\"/wiki/Polyph%C3%A9nol\" title=\"Polyphénol\">polyphénols</a> (tanins, anthocyanes) et autres éléments du raisin. L'extraction se faisait par <a href=\"/wiki/Vinification\" title=\"Vinification\">pigeage</a>, opération qui consiste à enfoncer le chapeau de marc dans le jus en fermentation. Plus couramment, l'extraction est conduite aussi par des remontages, opération qui consiste à pomper le jus depuis le bas de la cuve pour arroser le chapeau de marc et ainsi lessiver les composants qualitatifs du raisin.</p>\n<p>Les températures de fermentation alcoolique peuvent être plus ou moins élevées, avec une moyenne générale de 28 à 35&#160;°C au maximum de la fermentation. La <a href=\"/wiki/Chaptalisation\" title=\"Chaptalisation\">chaptalisation</a> est réalisée si le degré naturel est insuffisant&#160;: cette pratique est réglementée. À l'issue de la fermentation alcoolique suit l'opération de décuvage qui donne le <a href=\"/wiki/Vin_de_goutte\" title=\"Vin de goutte\">vin de goutte</a> et le <a href=\"/wiki/Vin_de_presse\" title=\"Vin de presse\">vin de presse</a>. La <a href=\"/wiki/Fermentation_malolactique\" title=\"Fermentation malolactique\">fermentation malolactique</a> se déroule après mais est dépendante de la température<sup id=\"cite_ref-VITI_46-4\" class=\"reference\"><a href=\"#cite_note-VITI-46\"><span class=\"cite_crochet\">[</span>29<span class=\"cite_crochet\">]</span></a></sup>. À la fin de la fermentation malolactique, la teneur en acide malique doit être inférieure ou égale à 0,3 gramme par litre. De plus, la teneur en sucres fermentescibles (<a href=\"/wiki/Glucose\" title=\"Glucose\">glucose</a> et <a href=\"/wiki/Fructose\" title=\"Fructose\">fructose</a>) doit être inférieure ou égale à 2 grammes par litre<sup id=\"cite_ref-Légifrance2_7-12\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup>. Le vin est soutiré et mis en <a href=\"/wiki/F%C3%BBt_(r%C3%A9cipient)\" title=\"Fût (récipient)\">fût</a> ou cuve pour son <a href=\"/wiki/%C3%89levage_du_vin\" title=\"Élevage du vin\">élevage</a>. L'élevage se poursuit pendant plusieurs mois, puis le vin est collé, filtré et mis en bouteilles<sup id=\"cite_ref-VITI_46-5\" class=\"reference\"><a href=\"#cite_note-VITI-46\"><span class=\"cite_crochet\">[</span>29<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>En plus des cinq communes de l'aire d'appellation, une aire de proximité immédiate où la vinification de l'orléans-cléry est également autorisée a été définie, elle couvre le territoire des communes suivantes&#160;: <a href=\"/wiki/Ardon_(Loiret)\" title=\"Ardon (Loiret)\">Ardon</a>, <a href=\"/wiki/Baule\" title=\"Baule\">Baule</a>, <a href=\"/wiki/Beaugency\" title=\"Beaugency\">Beaugency</a>, <a href=\"/wiki/Bou\" title=\"Bou\">Bou</a>, <a href=\"/wiki/Chaingy\" title=\"Chaingy\">Chaingy</a>, <a href=\"/wiki/Ch%C3%A9cy\" title=\"Chécy\">Chécy</a>, <a href=\"/wiki/Combleux\" title=\"Combleux\">Combleux</a>, <a href=\"/wiki/Dry_(Loiret)\" title=\"Dry (Loiret)\">Dry</a>, <a href=\"/wiki/Huisseau-sur-Mauves\" title=\"Huisseau-sur-Mauves\">Huisseau-sur-Mauves</a>, <a href=\"/wiki/Jouy-le-Potier\" title=\"Jouy-le-Potier\">Jouy-le-Potier</a>, <a href=\"/wiki/Lailly-en-Val\" title=\"Lailly-en-Val\">Lailly-en-Val</a>, <a href=\"/wiki/Mardi%C3%A9\" title=\"Mardié\">Mardié</a>, <a href=\"/wiki/Messas\" title=\"Messas\">Messas</a>, <a href=\"/wiki/Meung-sur-Loire\" title=\"Meung-sur-Loire\">Meung-sur-Loire</a>, <a href=\"/wiki/Orl%C3%A9ans\" title=\"Orléans\">Orléans</a>, <a href=\"/wiki/Saint-Ay\" title=\"Saint-Ay\">Saint-Ay</a>, <a href=\"/wiki/Saint-Jean-de-Braye\" title=\"Saint-Jean-de-Braye\">Saint-Jean-de-Braye</a>, <a href=\"/wiki/Saint-Pryv%C3%A9-Saint-Mesmin\" title=\"Saint-Pryvé-Saint-Mesmin\">Saint-Pryvé-Saint-Mesmin</a>, <a href=\"/wiki/Semoy_(Loiret)\" title=\"Semoy (Loiret)\">Semoy</a>, <a href=\"/wiki/Tavers\" title=\"Tavers\">Tavers</a> et <a href=\"/wiki/Villorceau\" title=\"Villorceau\">Villorceau</a><sup id=\"cite_ref-Légifrance2_7-13\" class=\"reference\"><a href=\"#cite_note-Légifrance2-7\"><span class=\"cite_crochet\">[</span>5<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<h3><span class=\"mw-headline\" id=\"Gastronomie\">Gastronomie</span></h3>\n<p>Les vins sont en général simples, francs et fruités. Ils sont à boire rapidement, dans les 2 à 5 ans suivant leur mise en bouteille.</p>\n<h3><span id=\"R.C3.A9compenses\"></span><span class=\"mw-headline\" id=\"Récompenses\">Récompenses</span></h3>\n<p>Les vins de l'appellation ayant été primés au <a href=\"/wiki/Concours_g%C3%A9n%C3%A9ral_agricole\" title=\"Concours général agricole\">concours général agricole</a> sont les suivants&#160;: le clos Saint-Fiacre, médailles d'or (2003, 2004), d'argent (2006) et de bronze (2009)&#160;; le domaine Saint-Avit, médailles d'argent (2003, 2005, 2008), les vignerons de la Grand'maison, médailles d'or (2007) et d'argent (2009), le vignoble du chant des oiseaux, médailles d'or (2005) et de bronze (2006)<sup id=\"cite_ref-48\" class=\"reference\"><a href=\"#cite_note-48\"><span class=\"cite_crochet\">[</span>30<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<h2><span id=\".C3.89conomie\"></span><span class=\"mw-headline\" id=\"Économie\">Économie</span></h2>\n<div class=\"thumb tright\">\n<div class=\"thumbinner\" style=\"width:312px;\"><a href=\"/wiki/Fichier:Cave_coop%C3%A9rative,_Mareau-aux-Pr%C3%A9s,_Loiret,_Centre,_France.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/1/13/Cave_coop%C3%A9rative%2C_Mareau-aux-Pr%C3%A9s%2C_Loiret%2C_Centre%2C_France.jpg/310px-Cave_coop%C3%A9rative%2C_Mareau-aux-Pr%C3%A9s%2C_Loiret%2C_Centre%2C_France.jpg\" width=\"310\" height=\"233\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/1/13/Cave_coop%C3%A9rative%2C_Mareau-aux-Pr%C3%A9s%2C_Loiret%2C_Centre%2C_France.jpg/465px-Cave_coop%C3%A9rative%2C_Mareau-aux-Pr%C3%A9s%2C_Loiret%2C_Centre%2C_France.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/1/13/Cave_coop%C3%A9rative%2C_Mareau-aux-Pr%C3%A9s%2C_Loiret%2C_Centre%2C_France.jpg/620px-Cave_coop%C3%A9rative%2C_Mareau-aux-Pr%C3%A9s%2C_Loiret%2C_Centre%2C_France.jpg 2x\" data-file-width=\"2592\" data-file-height=\"1944\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/Fichier:Cave_coop%C3%A9rative,_Mareau-aux-Pr%C3%A9s,_Loiret,_Centre,_France.jpg\" class=\"internal\" title=\"Agrandir\"></a></div>\nLa cave coopérative à <a href=\"/wiki/Mareau-aux-Pr%C3%A9s\" title=\"Mareau-aux-Prés\">Mareau-aux-Prés</a> portant la date de <a href=\"/wiki/1931\" title=\"1931\">1931</a> sur son fronton.</div>\n</div>\n</div>\n<h3><span class=\"mw-headline\" id=\"Structure_des_exploitations\">Structure des exploitations</span></h3>\n<p>Une partie de la production est faite par <a href=\"/wiki/Domaine_viticole\" title=\"Domaine viticole\">domaines</a> de petites tailles. Ces domaines mettent tous leurs vins en bouteilles et les commercialisent.</p>\n<p>Une <a href=\"/wiki/Cave_coop%C3%A9rative_de_vinification\" title=\"Cave coopérative de vinification\">cave coopérative de vinification</a> (Les vignerons de la Grand'maison) regroupe quelques producteurs qui lui confient leurs récoltes.</p>\n<p>La plupart des producteurs maintiennent leur exploitation en <a href=\"/wiki/Polyculture\" title=\"Polyculture\">polyculture</a><sup id=\"cite_ref-49\" class=\"reference\"><a href=\"#cite_note-49\"><span class=\"cite_crochet\">[</span>31<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<h3><span class=\"mw-headline\" id=\"Commercialisation\">Commercialisation</span></h3>\n<p>La commercialisation de l'appellation est très limitée, du fait de sa production très restreinte et de sa faible notoriété<sup id=\"cite_ref-50\" class=\"reference\"><a href=\"#cite_note-50\"><span class=\"cite_crochet\">[</span>32<span class=\"cite_crochet\">]</span></a></sup>.</p>\n<p>Les caveaux des viticulteurs écoulent directement une partie de la production, complétée par les <a href=\"/wiki/Salon_(%C3%A9v%C3%A8nementiel)\" class=\"mw-redirect\" title=\"Salon (évènementiel)\">salons</a> des vins (notamment celui des <a href=\"/wiki/Vignerons_ind%C3%A9pendants_de_France\" title=\"Vignerons indépendants de France\">Vignerons indépendants de France</a>), les <a href=\"/wiki/Foire_(%C3%A9conomie)\" title=\"Foire (économie)\">foires</a>, <a href=\"/wiki/Caf%C3%A9_(%C3%A9tablissement)\" title=\"Café (établissement)\">cafés</a>, <a href=\"/wiki/H%C3%B4tel\" title=\"Hôtel\">hôtels</a>, <a href=\"/wiki/Restaurant\" title=\"Restaurant\">restaurants</a> et <a href=\"/wiki/Grande_distribution\" title=\"Grande distribution\">supermarchés</a> locaux.</p>\n<h3><span class=\"mw-headline\" id=\"Liste_de_producteurs\">Liste de producteurs</span></h3>\n<p>Les petites surfaces cultivées expliquent le petit nombre de producteurs<sup id=\"cite_ref-51\" class=\"reference\"><a href=\"#cite_note-51\"><span class=\"cite_crochet\">[</span>Notes 8<span class=\"cite_crochet\">]</span></a></sup>&#160;:</p>\n<ul>\n<li>Clos Saint-Fiacre (famille Montigny-Piel), à <a href=\"/wiki/Mareau-aux-Pr%C3%A9s\" title=\"Mareau-aux-Prés\">Mareau-aux-Prés</a><sup id=\"cite_ref-52\" class=\"reference\"><a href=\"#cite_note-52\"><span class=\"cite_crochet\">[</span>33<span class=\"cite_crochet\">]</span></a></sup>&#160;;</li>\n<li>Domaine Saint-Avit (Pascal Javoy), à <a href=\"/wiki/M%C3%A9zi%C3%A8res-lez-Cl%C3%A9ry\" title=\"Mézières-lez-Cléry\">Mézières-lez-Cléry</a><sup id=\"cite_ref-53\" class=\"reference\"><a href=\"#cite_note-53\"><span class=\"cite_crochet\">[</span>34<span class=\"cite_crochet\">]</span></a></sup>&#160;;</li>\n<li>Les vignerons de la Grand'maison, à <a href=\"/wiki/Mareau-aux-Pr%C3%A9s\" title=\"Mareau-aux-Prés\">Mareau-aux-Prés</a>&#160;;</li>\n<li>Vignoble du Chant d'Oiseaux (Édouard Montigny), à <a href=\"/wiki/Mareau-aux-Pr%C3%A9s\" title=\"Mareau-aux-Prés\">Mareau-aux-Prés</a><sup id=\"cite_ref-54\" class=\"reference\"><a href=\"#cite_note-54\"><span class=\"cite_crochet\">[</span>35<span class=\"cite_crochet\">]</span></a></sup>&#160;;</li>\n<li>Domaine Pèlerin (David Parou), à <a href=\"/wiki/Mareau-aux-Pr%C3%A9s\" title=\"Mareau-aux-Prés\">Mareau-aux-Prés</a>.</li>\n</ul>\n<h2><span id=\"Notes_et_r.C3.A9f.C3.A9rences\"></span><span class=\"mw-headline\" id=\"Notes_et_références\">Notes et références</span></h2>\n<h3><span class=\"mw-headline\" id=\"Notes\">Notes</span></h3>\n<div class=\"references-small decimal\" style=\"\">\n<div class=\"mw-references-wrap\">\n<ol class=\"references\">\n<li id=\"cite_note-AO-1\"><span class=\"noprint renvois_vers_le_texte\">↑ <sup><a href=\"#cite_ref-AO_1-0\">a</a>, <a href=\"#cite_ref-AO_1-1\">b</a>, <a href=\"#cite_ref-AO_1-2\">c</a> et <a href=\"#cite_ref-AO_1-3\">d</a></sup></span> <span class=\"reference-text\"><a href=\"/wiki/Appellation_d%27origine#Grammaire\" title=\"Appellation d'origine\">Références sur la façon d'orthographier les appellations d'origine</a>.</span></li>\n<li id=\"cite_note-cep-6\"><span class=\"noprint renvois_vers_le_texte\">↑ <sup><a href=\"#cite_ref-cep_6-0\">a</a> et <a href=\"#cite_ref-cep_6-1\">b</a></sup></span> <span class=\"reference-text\">Le code international d'écriture des cépages mentionne la couleur du raisin de la manière suivante&#160;: B = blanc, N = noir, Rs = rose, G = gris.</span></li>\n<li id=\"cite_note-11\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-11\">↑</a></span> <span class=\"reference-text\">La date de la première édition de l'ouvrage du chanoine orléanais Jacques Boullay <i>Manière de bien cultiver la vigne dans le vignoble d'Orléans</i> n'est pas précisément connue, les deux autres datent de <a href=\"/wiki/1712\" title=\"1712\">1712</a> et <a href=\"/wiki/1723\" title=\"1723\">1723</a>.</span></li>\n<li id=\"cite_note-14\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-14\">↑</a></span> <span class=\"reference-text\">La <a href=\"/wiki/Lieue\" title=\"Lieue\">lieue</a> métrique vaut 4 km.</span></li>\n<li id=\"cite_note-36\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-36\">↑</a></span> <span class=\"reference-text\">Météo France définit les stations météo selon <a rel=\"nofollow\" class=\"external text\" href=\"http://climatheque.meteo.fr/aide/climatheque/reseauPostes/aideTypePoste.html\">six grands types</a>, numérotés de 0 à 5&#160;; professionnelle avec observation humaine (0), non professionnelle avec observation humaine ou à distance (1), automatique en temps réel (2), station automatique temps différé (3), manuelle (4), poste à interrogation occasionnelle (5)</span></li>\n<li id=\"cite_note-37\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-37\">↑</a></span> <span class=\"reference-text\">Les distances sont mesurées grâce à l'outil <i>Distance measure</i> sur site <a rel=\"nofollow\" class=\"external text\" href=\"http://wikimapia.org\">wikimapia.org</a>. Le centre de l'appellation est fixée à Mareau-aux-Prés.</span></li>\n<li id=\"cite_note-47\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-47\">↑</a></span> <span class=\"reference-text\">Le rendement réel est calculé en divisant le volume de la production par la surface exploitée, soit 848 / 28 = 30,29 hectolitres par hectare.</span></li>\n<li id=\"cite_note-51\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-51\">↑</a></span> <span class=\"reference-text\">Cette liste de producteurs a été modifié en mars 2011&#160;; elle est à compléter.</span></li>\n</ol>\n</div>\n</div>\n<h3><span id=\"R.C3.A9f.C3.A9rences\"></span><span class=\"mw-headline\" id=\"Références\">Références</span></h3>\n<div class=\"references-small decimal\" style=\"-moz-column-width:36em;-webkit-column-width:36em;column-width:36em;\">\n<ol class=\"references\">\n<li id=\"cite_note-inao-2\"><span class=\"noprint renvois_vers_le_texte\">↑ <sup><a href=\"#cite_ref-inao_2-0\">a</a>, <a href=\"#cite_ref-inao_2-1\">b</a>, <a href=\"#cite_ref-inao_2-2\">c</a> et <a href=\"#cite_ref-inao_2-3\">d</a></sup></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"2011\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.inao.gouv.fr/public/produits/detailProduit.php?ID_PRODUIT=5301\">«&#160;<cite style=\"font-style: normal;\">Orléans-Cléry</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.inao.gouv.fr\">www.inao.gouv.fr</a></i>, <a href=\"/wiki/Minist%C3%A8re_de_l%27agriculture_(France)\" class=\"mw-redirect\" title=\"Ministère de l'agriculture (France)\">Ministère de l'agriculture</a>. <a href=\"/wiki/Institut_national_de_l%27origine_et_de_la_qualit%C3%A9\" title=\"Institut national de l'origine et de la qualité\">Institut national de l'origine et de la qualité</a>, <time class=\"nowrap\" datetime=\"2011-03-10\">10 mars 2011</time> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">17 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-Légifrance1-3\"><span class=\"noprint renvois_vers_le_texte\">↑ <sup><a href=\"#cite_ref-Légifrance1_3-0\">a</a>, <a href=\"#cite_ref-Légifrance1_3-1\">b</a> et <a href=\"#cite_ref-Légifrance1_3-2\">c</a></sup></span> <span class=\"reference-text\"><span class=\"legifrance\" style=\"font-size:100%\"><a rel=\"nofollow\" class=\"external text\" href=\"https://www.legifrance.gouv.fr/WAspad/UnTexteDeJorf?numjo=AGRP0602138D\">Décret du 23 novembre 2006</a></span> relatif à l'appellation d'origine contrôlée \"Orléans-Cléry\". <span class=\"ouvrage\" id=\"2006\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.legifrance.gouv.fr\">«&#160;<cite style=\"font-style: normal;\">www.legifrance.gouv.fr</cite>&#160;»</a>, Secrétariat général du gouvernement français, <time>2006</time> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">17 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-infoclimat-4\"><span class=\"noprint renvois_vers_le_texte\">↑ <sup><a href=\"#cite_ref-infoclimat_4-0\">a</a> et <a href=\"#cite_ref-infoclimat_4-1\">b</a></sup></span> <span class=\"reference-text\"><span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.infoclimat.fr/climatologie/index.php?s=07249&amp;aff=details\">«&#160;<cite style=\"font-style: normal;\">Relevés Orléans-Bricy 1961-1990</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.infoclimat.fr\">www.infoclimat.fr</a></i>, Association Infoclimat <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">11 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-Guide_Hachette-5\"><span class=\"noprint renvois_vers_le_texte\">↑ <sup><a href=\"#cite_ref-Guide_Hachette_5-0\">a</a>, <a href=\"#cite_ref-Guide_Hachette_5-1\">b</a>, <a href=\"#cite_ref-Guide_Hachette_5-2\">c</a> et <a href=\"#cite_ref-Guide_Hachette_5-3\">d</a></sup></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Collectif2010\"><span class=\"nom_auteur\">Collectif</span>, <cite class=\"italique\">Le guide Hachette des vins 2011&#160;: des vins pour tous les goût, à tous les prix</cite>, Paris, Hachette livre, <time class=\"nowrap\" datetime=\"2010-08\">août 2010</time>, 1402&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Sp%C3%A9cial:Ouvrages_de_r%C3%A9f%C3%A9rence/978-2-01-237681-6\" title=\"Spécial:Ouvrages de référence/978-2-01-237681-6\"><span class=\"nowrap\">978-2-01-237681-6</span></a>)</small>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;1050<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Le+guide+Hachette+des+vins+2011&amp;rft.place=Paris&amp;rft.pub=Hachette+livre&amp;rft.stitle=des+vins+pour+tous+les+go%C3%BBt%2C+%C3%A0+tous+les+prix&amp;rft.aulast=Collectif&amp;rft.date=2010-08&amp;rft.pages=1050&amp;rft.tpages=1402&amp;rft.isbn=978-2-01-237681-6&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_33285\"></span></span></span></li>\n<li id=\"cite_note-Légifrance2-7\"><span class=\"noprint renvois_vers_le_texte\">↑ <sup><a href=\"#cite_ref-Légifrance2_7-0\">a</a>, <a href=\"#cite_ref-Légifrance2_7-1\">b</a>, <a href=\"#cite_ref-Légifrance2_7-2\">c</a>, <a href=\"#cite_ref-Légifrance2_7-3\">d</a>, <a href=\"#cite_ref-Légifrance2_7-4\">e</a>, <a href=\"#cite_ref-Légifrance2_7-5\">f</a>, <a href=\"#cite_ref-Légifrance2_7-6\">g</a>, <a href=\"#cite_ref-Légifrance2_7-7\">h</a>, <a href=\"#cite_ref-Légifrance2_7-8\">i</a>, <a href=\"#cite_ref-Légifrance2_7-9\">j</a>, <a href=\"#cite_ref-Légifrance2_7-10\">k</a>, <a href=\"#cite_ref-Légifrance2_7-11\">l</a>, <a href=\"#cite_ref-Légifrance2_7-12\">m</a> et <a href=\"#cite_ref-Légifrance2_7-13\">n</a></sup></span> <span class=\"reference-text\"><abbr class=\"abbr indicateur-format format-pdf\" title=\"Document au format Portable Document Format (PDF) d'Adobe\">[PDF]</abbr> <span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://agriculture.gouv.fr/IMG/pdf/AOC_SOMM44.pdf\">«&#160;<cite style=\"font-style: normal;\">Cahier des charges de l'appellation</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external free\" href=\"http://agriculture.gouv.fr/\">http://agriculture.gouv.fr/</a></i></span>, homologué par le <span class=\"ouvrage\" id=\"2011\">«&#160;<cite style=\"font-style:normal;\"><span class=\"legifrance\" style=\"font-size:100%\"><a rel=\"nofollow\" class=\"external text\" href=\"https://www.legifrance.gouv.fr/WAspad/UnTexteDeJorf?numjo=AGRT1114927D\">décret <abbr class=\"abbr\" title=\"numéro\">n<sup>o</sup></abbr>&#160;2011-1399 du 26 octobre 2011</a></span> relatif à l'appellation d'origine contrôlée «&#160;Orléans-Cléry&#160;»</cite>&#160;», <i><a href=\"/wiki/Journal_officiel_de_la_R%C3%A9publique_fran%C3%A7aise\" title=\"Journal officiel de la République française\">JORF</a></i>, <abbr class=\"abbr\" title=\"numéro\">n<sup>o</sup></abbr>&#160;0252,‎ <time class=\"nowrap\" datetime=\"2011-10-29\">29 octobre 2011</time>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;18279<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=d%C3%A9cret+no%26nbsp%3B2011-1399+du+26+octobre+2011+relatif+%C3%A0+l%27appellation+d%27origine+contr%C3%B4l%C3%A9e+%C2%AB+Orl%C3%A9ans-Cl%C3%A9ry+%C2%BB&amp;rft.jtitle=JORF&amp;rft.issue=0252&amp;rft.date=2011-10-29&amp;rft.pages=18279&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_30695\"></span></span>.</span></li>\n<li id=\"cite_note-8\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-8\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Boucher_de_Molandon1876\"><span class=\"nom_auteur\">Boucher de Molandon</span>, <cite class=\"italique\">Première expédition de Jeanne d'Arc&#160;: le ravitaillement d'Orléans</cite>, <abbr class=\"abbr\" title=\"tome\">t.</abbr>&#160;15, Orléans, Herluison, <abbr class=\"abbr\" title=\"collection\">coll.</abbr>&#160;«&#160;Mémoires de la Société archéologique et historique de l'Orléanais&#160;», <time>1876</time>, 550&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"http://gallica.bnf.fr/ark:/12148/bpt6k5544845w/f123\">lire en ligne</a>)</small>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;99<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Premi%C3%A8re+exp%C3%A9dition+de+Jeanne+d%27Arc&amp;rft.place=Orl%C3%A9ans&amp;rft.pub=Herluison&amp;rft.stitle=le+ravitaillement+d%27Orl%C3%A9ans&amp;rft.aulast=Boucher+de+Molandon&amp;rft.date=1876&amp;rft.pages=99&amp;rft.tpages=550&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_31524\"></span></span></span></li>\n<li id=\"cite_note-9\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-9\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Duchesne1606\"><span class=\"ouvrage\" id=\"Joseph_Duchesne1606\"><a href=\"/wiki/Joseph_Duchesne\" class=\"mw-redirect\" title=\"Joseph Duchesne\">Joseph <span class=\"nom_auteur\">Duchesne</span></a>, <cite class=\"italique\">Le pourtraict de la santé où est au vif représentée la règle universelle et particulière, de bien sainement et longuement vivre&#160;: enrichis de plusieurs préceptes, raisons et beaux exemples, tirés des médecins, philosophes et historiens, tant grecs que latins, les plus célèbres</cite>, Paris, chez Claude Morel, <time>1606</time>, 595&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"https://books.google.fr/books?id=CUcemq8P94IC\">lire en ligne</a>)</small>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;221<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Le+pourtraict+de+la+sant%C3%A9+o%C3%B9+est+au+vif+repr%C3%A9sent%C3%A9e+la+r%C3%A8gle+universelle+et+particuli%C3%A8re%2C+de+bien+sainement+et+longuement+vivre&amp;rft.place=Paris&amp;rft.pub=chez+Claude+Morel&amp;rft.stitle=enrichis+de+plusieurs+pr%C3%A9ceptes%2C+raisons+et+beaux+exemples%2C+tir%C3%A9s+des+m%C3%A9decins%2C+philosophes+et+historiens%2C+tant+grecs+que+latins%2C+les+plus+c%C3%A9l%C3%A8bres&amp;rft.aulast=Duchesne&amp;rft.aufirst=Joseph&amp;rft.date=1606&amp;rft.pages=221&amp;rft.tpages=595&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_55397\"></span></span></span></span></li>\n<li id=\"cite_note-10\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-10\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Pradels1913\"><span class=\"ouvrage\" id=\"Octave_Pradels1913\">Octave <span class=\"nom_auteur\">Pradels</span>, <cite class=\"italique\">Le vin et la chanson</cite>, Paris, Flammarion, <time>1913</time> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"http://gallica.bnf.fr/ark:/12148/bpt6k56525250/f246\">lire en ligne</a>)</small>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;236<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Le+vin+et+la+chanson&amp;rft.place=Paris&amp;rft.pub=Flammarion&amp;rft.aulast=Pradels&amp;rft.aufirst=Octave&amp;rft.date=1913&amp;rft.pages=236&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_24594\"></span></span></span></span></li>\n<li id=\"cite_note-12\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-12\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Boullay1712\"><span class=\"ouvrage\" id=\"Jacques_Boullay1712\">Jacques <span class=\"nom_auteur\">Boullay</span>, <cite class=\"italique\">Manière de bien cultiver la vigne dans le vignoble d'Orléans&#160;: beaucoup plus amples et plus exacte que la précédente</cite>, Orléans, François Borde, <time>1712</time>, <abbr class=\"abbr\" title=\"deuxième\">2<sup>e</sup></abbr>&#160;<abbr class=\"abbr\" title=\"édition\">éd.</abbr>, 206&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"https://books.google.fr/books?id=38s6AAAAcAAJ\">lire en ligne</a>)</small><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Mani%C3%A8re+de+bien+cultiver+la+vigne+dans+le+vignoble+d%27Orl%C3%A9ans&amp;rft.place=Orl%C3%A9ans&amp;rft.pub=Fran%C3%A7ois+Borde&amp;rft.edition=2&amp;rft.stitle=beaucoup+plus+amples+et+plus+exacte+que+la+pr%C3%A9c%C3%A9dente&amp;rft.aulast=Boullay&amp;rft.aufirst=Jacques&amp;rft.date=1712&amp;rft.tpages=206&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_38164\"></span></span></span>&#160;; <span class=\"ouvrage\" id=\"Boullay1723\"><span class=\"ouvrage\" id=\"Jacques_Boullay1723\">Jacques <span class=\"nom_auteur\">Boullay</span>, <cite class=\"italique\">Manière de bien cultiver la vigne, de faire la vendange et le vin dans le vignoble d'Orléans&#160;: utile à tous les autres vignobles du royaume où l'on donne les moyens de prévenir et de découvrir les friponneries des mauvais vignerons</cite>, Orléans, J. Rouzeau, <time>1723</time>, <abbr class=\"abbr\" title=\"troisième\">3<sup>e</sup></abbr>&#160;<abbr class=\"abbr\" title=\"édition\">éd.</abbr><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Mani%C3%A8re+de+bien+cultiver+la+vigne%2C+de+faire+la+vendange+et+le+vin+dans+le+vignoble+d%27Orl%C3%A9ans&amp;rft.place=Orl%C3%A9ans&amp;rft.pub=J.+Rouzeau&amp;rft.edition=3&amp;rft.stitle=utile+%C3%A0+tous+les+autres+vignobles+du+royaume+o%C3%B9+l%27on+donne+les+moyens+de+pr%C3%A9venir+et+de+d%C3%A9couvrir+les+friponneries+des+mauvais+vignerons&amp;rft.aulast=Boullay&amp;rft.aufirst=Jacques&amp;rft.date=1723&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_47805\"></span></span></span></span></li>\n<li id=\"cite_note-13\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-13\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Bouvier1926\"><span class=\"ouvrage\" id=\"André_Bouvier1926\">André <span class=\"nom_auteur\">Bouvier</span>, <cite class=\"italique\">Mémoires de la société archéologique de l'Orléanais&#160;: un analyste orléanais peu connu, Jean-François Rozier fils (1762-1854) et les débuts de la Révolution à Orléans d'après des documents inédits</cite>, <abbr class=\"abbr\" title=\"tome\">t.</abbr>&#160;36, Orléans, Société archéologique de l'Orléanais, <time>1926</time>, 372&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"http://gallica.bnf.fr/ark:/12148/bpt6k5774582f/f248\">lire en ligne</a>)</small>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;238<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=M%C3%A9moires+de+la+soci%C3%A9t%C3%A9+arch%C3%A9ologique+de+l%27Orl%C3%A9anais&amp;rft.place=Orl%C3%A9ans&amp;rft.pub=Soci%C3%A9t%C3%A9+arch%C3%A9ologique+de+l%27Orl%C3%A9anais&amp;rft.stitle=un+analyste+orl%C3%A9anais+peu+connu%2C+Jean-Fran%C3%A7ois+Rozier+fils+%281762-1854%29+et+les+d%C3%A9buts+de+la+R%C3%A9volution+%C3%A0+Orl%C3%A9ans+d%27apr%C3%A8s+des+documents+in%C3%A9dits&amp;rft.aulast=Bouvier&amp;rft.aufirst=Andr%C3%A9&amp;rft.date=1926&amp;rft.pages=238&amp;rft.tpages=372&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_50223\"></span></span></span></span></li>\n<li id=\"cite_note-15\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-15\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Expilly1768\"><span class=\"ouvrage\" id=\"Louis-Alexandre_Expilly1768\"><a href=\"/wiki/Louis-Alexandre_Expilly_de_La_Poipe\" title=\"Louis-Alexandre Expilly de La Poipe\">Louis-Alexandre <span class=\"nom_auteur\">Expilly</span></a>, <cite class=\"italique\">Dictionnaire géographique, historique et politique des Gaules et de la France</cite>, <abbr class=\"abbr\" title=\"tome\">t.</abbr>&#160;5, Amsterdam, <time>1768</time>, 1064&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"https://books.google.fr/books?id=__eYqVsFlkIC&amp;pg=PA327\">lire en ligne</a>)</small>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;327<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Dictionnaire+g%C3%A9ographique%2C+historique+et+politique+des+Gaules+et+de+la+France&amp;rft.place=Amsterdam&amp;rft.aulast=Expilly&amp;rft.aufirst=Louis-Alexandre&amp;rft.date=1768&amp;rft.pages=327&amp;rft.tpages=1064&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_31325\"></span></span></span></span></li>\n<li id=\"cite_note-16\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-16\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Colas1770\"><span class=\"ouvrage\" id=\"Jean-François_Colas1770\">Jean-François <span class=\"nom_auteur\">Colas</span>, <cite class=\"italique\">Le manuel du cultivateur dans le vignoble d'Orléans utile à tous les autres vignobles du royaume</cite>, Orléans, Chez Charles Jacob, <time>1770</time>, 207&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"https://books.google.fr/books?id=nesaQwAACAAJ\">lire en ligne</a>)</small><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Le+manuel+du+cultivateur+dans+le+vignoble+d%27Orl%C3%A9ans+utile+%C3%A0+tous+les+autres+vignobles+du+royaume&amp;rft.place=Orl%C3%A9ans&amp;rft.pub=Chez+Charles+Jacob&amp;rft.aulast=Colas&amp;rft.aufirst=Jean-Fran%C3%A7ois&amp;rft.date=1770&amp;rft.tpages=207&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_34358\"></span></span></span></span></li>\n<li id=\"cite_note-17\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-17\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"CorvolBru-Malgras2002\"><span class=\"ouvrage\" id=\"André_CorvolChristine_Bru-Malgras2002\">André <span class=\"nom_auteur\">Corvol</span> et Christine <span class=\"nom_auteur\">Bru-Malgras</span>, <cite class=\"italique\">Forêt et vigne, bois et vin&#160;: XVI<sup>e</sup>-XX<sup>e</sup> siècles. Le savoir-faire ecclésiastique et monastique en matière de vigne et forêt</cite>, L'Harmattan, <time>2002</time>, 501&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Sp%C3%A9cial:Ouvrages_de_r%C3%A9f%C3%A9rence/9782747528269\" title=\"Spécial:Ouvrages de référence/9782747528269\"><span class=\"nowrap\">9782747528269</span></a>, <a rel=\"nofollow\" class=\"external text\" href=\"https://books.google.fr/books?id=ehOLRK8V5qUC\">lire en ligne</a>)</small>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;192-195<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=For%C3%AAt+et+vigne%2C+bois+et+vin+%3A+XVIe-XXe+si%C3%A8cles.+Le+savoir-faire+eccl%C3%A9siastique+et+monastique+en+mati%C3%A8re+de+vigne+et+for%C3%AAt&amp;rft.pub=L%27Harmattan&amp;rft.aulast=Corvol&amp;rft.aufirst=Andr%C3%A9&amp;rft.au=Bru-Malgras%2C+Christine&amp;rft.date=2002&amp;rft.pages=192-195&amp;rft.tpages=501&amp;rft.isbn=9782747528269&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_39876\"></span></span></span></span></li>\n<li id=\"cite_note-24\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-24\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Guyot1868\"><span class=\"ouvrage\" id=\"Jules_Guyot1868\"><a href=\"/wiki/Jules_Guyot\" title=\"Jules Guyot\">Jules <span class=\"nom_auteur\">Guyot</span></a>, <cite class=\"italique\">Étude des vignobles de France&#160;: pour servir à l'enseignement mutuel de la viticulture et de la vinification françaises. Régions du Centre-Nord, du Nord et du Nord-Ouest</cite>, <abbr class=\"abbr\" title=\"tome\">t.</abbr>&#160;3, Paris, <a href=\"/wiki/Imprimerie_nationale_(France)\" class=\"mw-redirect\" title=\"Imprimerie nationale (France)\">Imprimerie impériale</a>, <time>1868</time>, 710&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"http://gallica.bnf.fr/ark:/12148/bpt6k1109477/f224\">lire en ligne</a>)</small>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;220-232<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=%C3%89tude+des+vignobles+de+France&amp;rft.place=Paris&amp;rft.pub=Imprimerie+imp%C3%A9riale&amp;rft.stitle=pour+servir+%C3%A0+l%27enseignement+mutuel+de+la+viticulture+et+de+la+vinification+fran%C3%A7aises.+R%C3%A9gions+du+Centre-Nord%2C+du+Nord+et+du+Nord-Ouest&amp;rft.aulast=Guyot&amp;rft.aufirst=Jules&amp;rft.date=1868&amp;rft.pages=220-232&amp;rft.tpages=710&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_43014\"></span></span></span></span></li>\n<li id=\"cite_note-25\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-25\">↑</a></span> <span class=\"reference-text\">Arrêté du 9 août 1951 relatif aux \"vins de l'Orléanais\", définition du droit à l'appellation en application de la loi du 6 mais 1919 relative aux appellations d'origine, publié au <a rel=\"nofollow\" class=\"external text\" href=\"http://www.legifrance.gouv.fr/jopdf/common/jo_pdf.jsp?numJO=0&amp;dateJO=19510823&amp;numTexte=&amp;pageDebut=08990&amp;pageFin=\"><i>JORF</i> du 23 août 1951, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;8990</a>.</span></li>\n<li id=\"cite_note-Légifrance0-26\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-Légifrance0_26-0\">↑</a></span> <span class=\"reference-text\"><span class=\"legifrance\" style=\"font-size:100%\"><a rel=\"nofollow\" class=\"external text\" href=\"https://www.legifrance.gouv.fr/WAspad/UnTexteDeJorf?numjo=AGRP0202372A\">Arrêté du 14 octobre 2002</a></span> relatif à l'appellation d'origine Vin délimité de qualité supérieure «&#160;Orléans-Cléry&#160;». JORF <abbr class=\"abbr\" title=\"numéro\">n<sup>o</sup></abbr>&#160;266 du 15 novembre 2002, page 18903, texte <abbr class=\"abbr\" title=\"numéro\">n<sup>o</sup></abbr>&#160;46. <span class=\"ouvrage\" id=\"2002\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.legifrance.gouv.fr\">«&#160;<cite style=\"font-style: normal;\">www.legifrance.gouv.fr</cite>&#160;»</a>, Secrétariat général du gouvernement français, <time>2002</time> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">17 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-27\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-27\">↑</a></span> <span class=\"reference-text\"><span class=\"legifrance\" style=\"font-size:100%\"><a rel=\"nofollow\" class=\"external text\" href=\"https://www.legifrance.gouv.fr/WAspad/UnTexteDeJorf?numjo=ECOC9400118A\">Arrêté du 10 août 1994</a></span> portant agrément des organismes professionnels chargés de la dégustation des vins de pays. JORF <abbr class=\"abbr\" title=\"numéro\">n<sup>o</sup></abbr>&#160;202 du <abbr class=\"abbr\" title=\"Premier\">1<sup>er</sup></abbr> septembre 1994, page 12675. <span class=\"ouvrage\" id=\"1994\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.legifrance.gouv.fr\">«&#160;<cite style=\"font-style: normal;\">www.legifrance.gouv.fr</cite>&#160;»</a>, Secrétariat général du gouvernement français, <time>1994</time> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">17 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-28\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-28\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.clery-saint-andre.com/vie-associative/social-culture-et-loisirs/122-confrerie-vigneronne-des-chevaliers-dorleans-clery\">«&#160;<cite style=\"font-style: normal;\">Confrérie Vigneronne des Chevaliers d'Orléans-Cléry</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.clery-saint-andre.com\">www.clery-saint-andre.com</a></i>, Ville de Cléry-Saint-André <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">17 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-29\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-29\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Bimbenet\"><span class=\"nom_auteur\">Bimbenet</span>, «&#160;<cite style=\"font-style:normal;\">Rapport au nom de la section des belles-lettres sur le mémoire Orléans et ses panégyristes au <abbr class=\"abbr\" title=\"16ᵉ siècle\"><span class=\"romain\">XVI</span><sup style=\"font-size:72%\">e</sup></abbr>&#160;siècle par Baguenault de Viéville</cite>&#160;», <i>Mémoires de la Société d'agriculture, sciences, belles-lettres et arts d'Orléans</i>, <abbr class=\"abbr\" title=\"volume\">vol.</abbr>&#160;3,‎ <time>1857</time>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;108-122 <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"https://books.google.fr/books?id=Vr8XAAAAYAAJ\">lire en ligne</a>)</small><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=Rapport+au+nom+de+la+section+des+belles-lettres+sur+le+m%C3%A9moire+Orl%C3%A9ans+et+ses+pan%C3%A9gyristes+au+XVIe%26nbsp%3Bsi%C3%A8cle+par+Baguenault+de+Vi%C3%A9ville&amp;rft.jtitle=M%C3%A9moires+de+la+Soci%C3%A9t%C3%A9+d%27agriculture%2C+sciences%2C+belles-lettres+et+arts+d%27Orl%C3%A9ans&amp;rft.aulast=Bimbenet&amp;rft.date=1857&amp;rft.volume=3&amp;rft.pages=108-122&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_43997\"></span></span></span></li>\n<li id=\"cite_note-30\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-30\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Soyer1912\"><span class=\"ouvrage\" id=\"Jacques_Soyer1912\">Jacques <span class=\"nom_auteur\">Soyer</span>, «&#160;<cite style=\"font-style:normal;\">La légende de la fondation d'Orléans par l'empereur Aurélien</cite>&#160;», <i>Mémoires de la société d'agriculture, sciences, belles-lettres et arts d'Orléans</i>, <abbr class=\"abbr\" title=\"volume\">vol.</abbr>&#160;73, <abbr class=\"abbr\" title=\"numéro\">n<sup>o</sup></abbr>&#160;73,‎ <time>1912</time>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;130 <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"http://www.persee.fr/web/revues/home/prescript/article/bec_0373-6237_1912_num_73_1_460916_t1_0130_0000_001\">lire en ligne</a>)</small><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=La+l%C3%A9gende+de+la+fondation+d%27Orl%C3%A9ans+par+l%27empereur+Aur%C3%A9lien&amp;rft.jtitle=M%C3%A9moires+de+la+soci%C3%A9t%C3%A9+d%27agriculture%2C+sciences%2C+belles-lettres+et+arts+d%27Orl%C3%A9ans&amp;rft.issue=73&amp;rft.aulast=Soyer&amp;rft.aufirst=Jacques&amp;rft.date=1912&amp;rft.volume=73&amp;rft.pages=130&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_38839\"></span></span></span></span></li>\n<li id=\"cite_note-31\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-31\">↑</a></span> <span class=\"reference-text\">Présenté dans <i>Poètes du vin, poètes divins</i> de <a href=\"/wiki/Kilien_Stengel\" title=\"Kilien Stengel\">Kilien Stengel</a>, préface de <a href=\"/wiki/Jean-Robert_Pitte\" title=\"Jean-Robert Pitte\">Jean-Robert Pitte</a>, Paris, collection Ecriture, <a href=\"/wiki/%C3%89ditions_de_l%27Archipel\" title=\"Éditions de l'Archipel\">Éditions de l'Archipel</a>, 2012, 280 p.</span></li>\n<li id=\"cite_note-32\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-32\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"du_Rouzeau1860\"><span class=\"ouvrage\" id=\"Simon_du_Rouzeau1860\">Simon <span class=\"nom_auteur\">du Rouzeau</span>, <cite class=\"italique\">L'Hercule Guepin&#160;: poème en l'honneur du vin d'Orléans&#160;: édition conforme à celle de 1605 accompagnée de notes et d'une notice bibliographique</cite>, Orléans, H. Herluison, <time>1860</time>, 56&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"https://books.google.com/books?id=i8cLAAAAQAAJ\">lire en ligne</a>)</small><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=L%27Hercule+Guepin+%3A+po%C3%A8me+en+l%27honneur+du+vin+d%27Orl%C3%A9ans&amp;rft.place=Orl%C3%A9ans&amp;rft.pub=H.+Herluison&amp;rft.stitle=%C3%A9dition+conforme+%C3%A0+celle+de+1605+accompagn%C3%A9e+de+notes+et+d%27une+notice+bibliographique&amp;rft.aulast=du+Rouzeau&amp;rft.aufirst=Simon&amp;rft.date=1860&amp;rft.tpages=56&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_39094\"></span></span></span>. Voir l'édition originale dans la bibliographie.</span></li>\n<li id=\"cite_note-33\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-33\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Tabarin1858\"><span class=\"nom_auteur\">Tabarin</span>, <cite class=\"italique\">Œuvres complètes de Tabarin&#160;: l'adieu de Tabarin au peuple de Paris avec les regrets des bons morceaux et du bon vin, adressé aux artisans de la gueule et aux suppost de Bacchus, 1623, édité Chez Pierre Rocolet</cite>, <abbr class=\"abbr\" title=\"volume\">vol.</abbr>&#160;2, Paris, P. Jannet, <time>1858</time>, 504&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"http://gallica.bnf.fr/ark:/12148/bpt6k277976/f463\">lire en ligne</a>)</small>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;463<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=%C5%92uvres+compl%C3%A8tes+de+Tabarin&amp;rft.place=Paris&amp;rft.pub=P.+Jannet&amp;rft.stitle=l%27adieu+de+Tabarin+au+peuple+de+Paris+avec+les+regrets+des+bons+morceaux+et+du+bon+vin%2C+adress%C3%A9+aux+artisans+de+la+gueule+et+aux+suppost+de+Bacchus%2C+1623%2C+%C3%A9dit%C3%A9+Chez+Pierre+Rocolet&amp;rft.aulast=Tabarin&amp;rft.date=1858&amp;rft.volume=2&amp;rft.pages=463&amp;rft.tpages=504&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_44973\"></span></span></span></li>\n<li id=\"cite_note-34\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-34\">↑</a></span> <span class=\"reference-text\">Notices des cartes du <a href=\"/wiki/BRGM\" class=\"mw-redirect\" title=\"BRGM\">BRGM</a> <abbr class=\"abbr indicateur-format format-pdf\" title=\"Document au format Portable Document Format (PDF) d'Adobe\">[PDF]</abbr><a rel=\"nofollow\" class=\"external text\" href=\"http://ficheinfoterre.brgm.fr/Notices/0397N.pdf\"><abbr class=\"abbr\" title=\"numéro\">n<sup>o</sup></abbr>&#160;397 (Beaugency)</a> et <abbr class=\"abbr indicateur-format format-pdf\" title=\"Document au format Portable Document Format (PDF) d'Adobe\">[PDF]</abbr><a rel=\"nofollow\" class=\"external text\" href=\"http://ficheinfoterre.brgm.fr/Notices/0363N.pdf\"><abbr class=\"abbr\" title=\"numéro\">n<sup>o</sup></abbr>&#160;363 (Orléans)</a>, disponibles sur le site <a rel=\"nofollow\" class=\"external text\" href=\"http://infoterre.brgm.fr/\">infoterre.brgm.fr</a>.</span></li>\n<li id=\"cite_note-35\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-35\">↑</a></span> <span class=\"reference-text\"><a rel=\"nofollow\" class=\"external text\" href=\"https://www.geoportail.gouv.fr/carte?c=1.80667,47.8389&amp;z=6.4E-5&amp;l0=GEOLOGY.GEOLOGY::EXTERNAL:OGC:EXTERNALWMS(1)&amp;permalink=yes\">Carte géologique centrée sur le hameau des Muids</a> sur <a href=\"/wiki/G%C3%A9oportail_(France)\" title=\"Géoportail (France)\">Géoportail</a>.</span></li>\n<li id=\"cite_note-38\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-38\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"2011\"><a rel=\"nofollow\" class=\"external text\" href=\"http://climatheque.meteo.fr/aide/climatheque/reseauPostes/pdf/dep45.pdf\">«&#160;<cite style=\"font-style: normal;\">Station météorologique en service dans le département du Loiret</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://climatheque.meteo.fr\">climatheque.meteo.fr</a></i>, Météo France et Institut géographique national, <time class=\"nowrap\" datetime=\"2011-03-03\">3 mars 2011</time> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">18 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-39\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-39\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.infoclimat.fr/stations-meteo/index.php?s=00045\">«&#160;<cite style=\"font-style: normal;\">Station météo de Saint-Cyr-en-Val</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.infoclimat.fr\">www.infoclimat.fr</a></i>, Association Infoclimat <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">18 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-45\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-45\">↑</a></span> <span class=\"reference-text\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.inao.gouv.fr/repository/editeur/pdf/Cartes/AOC_OrleansClery_A_12062009.pdf\">Carte de l'aire d'appellation</a>, disponible sur le site <a rel=\"nofollow\" class=\"external text\" href=\"http://www.inao.gouv.fr/\">inao.gouv.fr</a>.</span></li>\n<li id=\"cite_note-VITI-46\"><span class=\"noprint renvois_vers_le_texte\">↑ <sup><a href=\"#cite_ref-VITI_46-0\">a</a>, <a href=\"#cite_ref-VITI_46-1\">b</a>, <a href=\"#cite_ref-VITI_46-2\">c</a>, <a href=\"#cite_ref-VITI_46-3\">d</a>, <a href=\"#cite_ref-VITI_46-4\">e</a> et <a href=\"#cite_ref-VITI_46-5\">f</a></sup></span> <span class=\"reference-text\"><i>Conduite et gestion de l'exploitation agricole</i>, cours de viticulture du lycée viticole de Beaune (1999-2001), Baccalauréat professionnel option viticulture-œnologie.</span></li>\n<li id=\"cite_note-48\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-48\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"2004-2011\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.concours-agricole.com/palmares_departement.aspx\">«&#160;<cite style=\"font-style: normal;\">Concours général agricole, les palmarès par année et par département</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.concours-agricole.com\">www.concours-agricole.com</a></i>, SAS Comexposium, 2004-2011 <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">22 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-49\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-49\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Gasparotto2006\"><span class=\"ouvrage\" id=\"Laure_Gasparotto2006\"><a href=\"/wiki/Laure_Gasparotto\" title=\"Laure Gasparotto\">Laure Gasparotto</a>, <a rel=\"nofollow\" class=\"external text\" href=\"http://www.lepoint.fr/archives/article.php/15908\">«&#160;<cite style=\"font-style: normal;\">Le vin d'Orléans reprend du galon</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.lepoint.fr\">www.lepoint.fr</a></i>, Le Point, <time class=\"nowrap\" datetime=\"2006-10-26\">26 octobre 2006</time> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">15 mars 2011</span>)</small></span></span></span></li>\n<li id=\"cite_note-50\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-50\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\" id=\"Centofanti2009\"><span class=\"ouvrage\" id=\"Charles_Centofanti2009\">Charles Centofanti, <a rel=\"nofollow\" class=\"external text\" href=\"http://www.tribune-orleans.fr/Economie/Vins-dOrleans-un-business-limite-en-quete-de-notoriete.html\">«&#160;<cite style=\"font-style: normal;\">Vins d’Orléans&#160;: un business limité en quête de notoriété</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.tribune-orleans.fr\">www.tribune-orleans.fr</a></i>, La Tribune d'Orléans, <time class=\"nowrap\" datetime=\"2009-09-24\">24 septembre 2009</time> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">15 mars 2011</span>)</small></span></span></span></li>\n<li id=\"cite_note-52\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-52\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.clossaintfiacre.fr\">«&#160;<cite style=\"font-style: normal;\">Clos Saint-Fiacre</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.clossaintfiacre.fr\">www.clossaintfiacre.fr</a></i> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">13 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-53\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-53\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.javoy.com\">«&#160;<cite style=\"font-style: normal;\">Javoy père et fils</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.javoy.com\">www.javoy.com</a></i> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">13 mars 2011</span>)</small></span>[ ].</span></li>\n<li id=\"cite_note-54\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-54\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.vignobleduchantdoiseaux.com\">«&#160;<cite style=\"font-style: normal;\">Vignoble du chant des oiseaux</cite>&#160;»</a>, sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://www.vignobleduchantdoiseaux.com\">www.vignobleduchantdoiseaux.com</a></i> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">13 mars 2011</span>)</small></span></span></li>\n</ol>\n</div>\n<ul>\n<li>Altitudes des communes sur <i><a rel=\"nofollow\" class=\"external text\" href=\"http://cassini.ehess.fr\">Des villages de Cassini aux communes d'aujourd'hui</a></i>, site de l'École des hautes études en sciences sociales&#160;:</li>\n</ul>\n<div class=\"references-small decimal\" style=\"-moz-column-width:24em;-webkit-column-width:24em;column-width:24em;\">\n<ol class=\"references\">\n<li id=\"cite_note-40\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-40\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=22231\">«&#160;<cite style=\"font-style: normal;\">Cléry-Saint-André</cite>&#160;»</a> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">18 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-41\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-41\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=21114\">«&#160;<cite style=\"font-style: normal;\">Mareau-aux-Prés</cite>&#160;»</a> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">18 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-42\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-42\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=22443\">«&#160;<cite style=\"font-style: normal;\">Mézières-lez-Cléry</cite>&#160;»</a> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">18 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-43\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-43\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=25536\">«&#160;<cite style=\"font-style: normal;\">Olivet</cite>&#160;»</a> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">18 mars 2011</span>)</small></span></span></li>\n<li id=\"cite_note-44\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-44\">↑</a></span> <span class=\"reference-text\"><span class=\"ouvrage\"><a rel=\"nofollow\" class=\"external text\" href=\"http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=32290\">«&#160;<cite style=\"font-style: normal;\">Saint-Hilaire-Saint-Mesmin</cite>&#160;»</a> <small style=\"line-height:1em;\">(consulté le <span class=\"nowrap\">18 mars 2011</span>)</small></span></span></li>\n</ol>\n</div>\n<ul>\n<li><span class=\"ouvrage\" id=\"Jullien1816\"><span class=\"ouvrage\" id=\"André_Jullien1816\"><a href=\"/wiki/Andr%C3%A9_Jullien_(vin)\" class=\"mw-redirect\" title=\"André Jullien (vin)\">André <span class=\"nom_auteur\">Jullien</span></a>, <cite class=\"italique\">Topographie de tous les vignobles connus contenant&#160;: leur position géographique, l'indication du genre et de la qualité des produits de chaque cru, les lieux où se font les chargements et le principal commerce de vin, le nom et la capacité des tonneaux et des mesures en usage, les moyens de transport ordinairement employés, suivie d'une classification générale de vins</cite>, Paris, L'Auteur, Madame Huzard, L. Colas, <time>1816</time>, <abbr class=\"abbr\" title=\"première\">1<sup>re</sup></abbr>&#160;<abbr class=\"abbr\" title=\"édition\">éd.</abbr>, 566&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"https://books.google.fr/books?id=xvs6AAAAcAAJ\">lire en ligne</a>)</small>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;80-85&#160;:<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Topographie+de+tous+les+vignobles+connus+contenant&amp;rft.place=Paris&amp;rft.pub=L%27Auteur%2C+Madame+Huzard%2C+L.+Colas&amp;rft.edition=1&amp;rft.stitle=leur+position+g%C3%A9ographique%2C+l%27indication+du+genre+et+de+la+qualit%C3%A9+des+produits+de+chaque+cru%2C+les+lieux+o%C3%B9+se+font+les+chargements+et+le+principal+commerce+de+vin%2C+le+nom+et+la+capacit%C3%A9+des+tonneaux+et+des+mesures+en+usage%2C+les+moyens+de+transport+ordinairement+employ%C3%A9s%2C+suivie+d%27une+classification+g%C3%A9n%C3%A9rale+de+vins&amp;rft.aulast=Jullien&amp;rft.aufirst=Andr%C3%A9&amp;rft.date=1816&amp;rft.pages=80-85+%3A&amp;rft.tpages=566&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_66522\"></span></span></span></li>\n</ul>\n<div class=\"references-small decimal\" style=\"-moz-column-width:18em;-webkit-column-width:18em;column-width:18em;\">\n<ol class=\"references\">\n<li id=\"cite_note-18\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-18\">↑</a></span> <span class=\"reference-text\"><abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;80</span></li>\n<li id=\"cite_note-19\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-19\">↑</a></span> <span class=\"reference-text\"><abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;81-82</span></li>\n<li id=\"cite_note-20\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-20\">↑</a></span> <span class=\"reference-text\"><abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;82</span></li>\n<li id=\"cite_note-21\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-21\">↑</a></span> <span class=\"reference-text\"><abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;82-83</span></li>\n<li id=\"cite_note-22\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-22\">↑</a></span> <span class=\"reference-text\"><abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;84</span></li>\n<li id=\"cite_note-23\"><span class=\"noprint renvois_vers_le_texte\"><a href=\"#cite_ref-23\">↑</a></span> <span class=\"reference-text\"><abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;85</span></li>\n</ol>\n</div>\n<h2><span class=\"mw-headline\" id=\"Voir_aussi\">Voir aussi</span></h2>\n<h3><span class=\"mw-headline\" id=\"Bibliographie\">Bibliographie</span></h3>\n<ul>\n<li><span class=\"ouvrage\" id=\"Rouzeau1605\"><span class=\"ouvrage\" id=\"Simon_Rouzeau1605\">Simon <span class=\"nom_auteur\">Rouzeau</span>, <cite class=\"italique\">L'Hercule guespin, ou l'hymne du vin d'Orléans&#160;: à monsieur d'Escures, conseiller du Roy, maréchal général des logis de ses armées, commissaire ordinaire des guerres et intendant des levées et turcies de Loyre et Cher</cite>, Orléans, Saturnin Hotot, imprimeur ordinaire du Roy, <time>1605</time>, 31&#160;<abbr class=\"abbr\" title=\"pages\">p.</abbr> <small style=\"line-height:1em;\">(<a rel=\"nofollow\" class=\"external text\" href=\"http://gallica.bnf.fr/ark:/12148/bpt6k72266c\">lire en ligne</a>)</small><span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=L%27Hercule+guespin%2C+ou+l%27hymne+du+vin+d%27Orl%C3%A9ans&amp;rft.place=Orl%C3%A9ans&amp;rft.pub=Saturnin+Hotot%2C+imprimeur+ordinaire+du+Roy&amp;rft.stitle=%C3%A0+monsieur+d%27Escures%2C+conseiller+du+Roy%2C+mar%C3%A9chal+g%C3%A9n%C3%A9ral+des+logis+de+ses+arm%C3%A9es%2C+commissaire+ordinaire+des+guerres+et+intendant+des+lev%C3%A9es+et+turcies+de+Loyre+et+Cher&amp;rft.aulast=Rouzeau&amp;rft.aufirst=Simon&amp;rft.date=1605&amp;rft.tpages=31&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_50023\"></span></span></span></li>\n<li><span class=\"ouvrage\" id=\"Linglois1999\"><span class=\"ouvrage\" id=\"André_Linglois1999\">André <span class=\"nom_auteur\">Linglois</span>, «&#160;<cite style=\"font-style:normal;\">Le vin orléanais dans les textes littéraires, du haut Moyen Âge au <abbr class=\"abbr\" title=\"18ᵉ siècle\"><span class=\"romain\">XVIII</span><sup style=\"font-size:72%\">e</sup></abbr>&#160;siècle</cite>&#160;», <i>Bulletin de la société archéologique et historique de l'Orléanais</i>, <a href=\"/wiki/Soci%C3%A9t%C3%A9_arch%C3%A9ologique_et_historique_de_l%27Orl%C3%A9anais\" title=\"Société archéologique et historique de l'Orléanais\">Société archéologique et historique de l'Orléanais</a>, <abbr class=\"abbr\" title=\"volume\">vol.</abbr>&#160;15, <abbr class=\"abbr\" title=\"numéro\">n<sup>o</sup></abbr>&#160;123,‎ <time>1999</time>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;43-68.<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=Le+vin+orl%C3%A9anais+dans+les+textes+litt%C3%A9raires%2C+du+haut+Moyen+%C3%82ge+au+XVIIIe%26nbsp%3Bsi%C3%A8cle&amp;rft.jtitle=Bulletin+de+la+soci%C3%A9t%C3%A9+arch%C3%A9ologique+et+historique+de+l%27Orl%C3%A9anais&amp;rft.issue=123&amp;rft.aulast=Linglois&amp;rft.aufirst=Andr%C3%A9&amp;rft.date=1999&amp;rft.volume=15&amp;rft.pages=43-68.&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_40362\"></span></span></span></li>\n<li><span class=\"ouvrage\" id=\"Poitou2013\"><span class=\"ouvrage\" id=\"Christian_Poitou2013\">Christian <span class=\"nom_auteur\">Poitou</span>, «&#160;<cite style=\"font-style:normal;\">Le phylloxéra et ses conséquences pour les viticulteurs du Loiret (1870-1910)</cite>&#160;», <i>Bulletin de la société archéologique et historique de l'Orléanais</i>, <a href=\"/wiki/Soci%C3%A9t%C3%A9_arch%C3%A9ologique_et_historique_de_l%27Orl%C3%A9anais\" title=\"Société archéologique et historique de l'Orléanais\">Société archéologique et historique de l'Orléanais</a>, <abbr class=\"abbr\" title=\"volume\">vol.</abbr>&#160;21, <abbr class=\"abbr\" title=\"numéro\">n<sup>o</sup></abbr>&#160;170,‎ <time>2013</time>, <abbr class=\"abbr\" title=\"page(s)\">p.</abbr>&#160;117-123.<span class=\"Z3988\" title=\"ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=Le+phyllox%C3%A9ra+et+ses+cons%C3%A9quences+pour+les+viticulteurs+du+Loiret+%281870-1910%29&amp;rft.jtitle=Bulletin+de+la+soci%C3%A9t%C3%A9+arch%C3%A9ologique+et+historique+de+l%27Orl%C3%A9anais&amp;rft.issue=170&amp;rft.aulast=Poitou&amp;rft.aufirst=Christian&amp;rft.date=2013&amp;rft.volume=21&amp;rft.pages=117-123.&amp;rfr_id=info%3Asid%2Ffr.wikipedia.org%3AOrl%C3%A9ans-cl%C3%A9ry\" id=\"COinS_39004\"></span></span></span></li>\n</ul>\n<h3><span class=\"mw-headline\" id=\"Liens_internes\">Liens internes</span></h3>\n<ul>\n<li><a href=\"/wiki/%C3%89conomie_du_Loiret\" title=\"Économie du Loiret\">Économie du Loiret</a></li>\n</ul>\n<div class=\"navbox-container\" style=\"clear:both;\">\n<table class=\"navbox collapsible noprint autocollapse\" data-autocollapse-group=\"palette\" style=\"\">\n<tr>\n<th class=\"navbox-title\" colspan=\"3\" style=\"\">\n<div style=\"float:left; width:6em; text-align:left\">\n<div class=\"noprint plainlinksneverexpand nowrap tnavbar\" style=\"background-color:transparent; padding:0; font-size:xx-small; color:#000000;\"><a href=\"/wiki/Mod%C3%A8le:Palette_Vignoble_de_la_vall%C3%A9e_de_la_Loire\" title=\"Modèle:Palette Vignoble de la vallée de la Loire\"><abbr class=\"abbr\" title=\"Voir ce modèle.\">v</abbr></a>&#160;· <a class=\"external text\" href=\"//fr.wikipedia.org/w/index.php?title=Mod%C3%A8le:Palette_Vignoble_de_la_vall%C3%A9e_de_la_Loire&amp;action=edit\"><abbr class=\"abbr\" title=\"Modifier ce modèle. Merci de prévisualiser avant de sauvegarder.\">m</abbr></a></div>\n</div>\n<span style=\"font-size:110%\"><a href=\"/wiki/Vignoble_de_la_vall%C3%A9e_de_la_Loire\" title=\"Vignoble de la vallée de la Loire\">Vignoble de la vallée de la Loire</a></span></th>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"\">Appellations régionales</th>\n<td class=\"navbox-list\" style=\"\"><span class=\"nowrap\"><a href=\"/wiki/Cr%C3%A9mant_de_Loire\" title=\"Crémant de Loire\">crémant de Loire</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Ros%C3%A9_de_Loire\" title=\"Rosé de Loire\">rosé de Loire</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Val-de-loire_(IGP)\" title=\"Val-de-loire (IGP)\">val-de-loire</a></span></td>\n<td rowspan=\"6\" style=\"vertical-align:middle;padding-left:7px\"><a href=\"/wiki/Fichier:Grape-symbol.svg\" class=\"image\"><img alt=\"Grape-symbol.svg\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/0/00/Grape-symbol.svg/20px-Grape-symbol.svg.png\" width=\"20\" height=\"20\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/0/00/Grape-symbol.svg/30px-Grape-symbol.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/0/00/Grape-symbol.svg/40px-Grape-symbol.svg.png 2x\" data-file-width=\"800\" data-file-height=\"800\" /></a></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"\">Vignoble du <a href=\"/wiki/Pays_nantais\" title=\"Pays nantais\">Pays nantais</a></th>\n<td class=\"navbox-list navbox-even\" style=\"\"><span class=\"nowrap\"><a href=\"/wiki/Gros-plant-du-pays-nantais\" title=\"Gros-plant-du-pays-nantais\">gros-plant-du-pays-nantais</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Muscadet_(AOC)\" title=\"Muscadet (AOC)\">muscadet</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Muscadet-coteaux-de-la-loire\" title=\"Muscadet-coteaux-de-la-loire\">muscadet-coteaux-de-la-loire</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Coteaux-d%27ancenis\" title=\"Coteaux-d'ancenis\">coteaux-d'ancenis</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Muscadet-s%C3%A8vre-et-maine\" title=\"Muscadet-sèvre-et-maine\">muscadet-sèvre-et-maine</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Muscadet-c%C3%B4tes-de-grandlieu\" title=\"Muscadet-côtes-de-grandlieu\">muscadet-côtes-de-grandlieu</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Fiefs-vend%C3%A9ens\" title=\"Fiefs-vendéens\">fiefs-vendéens</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Loire-atlantique_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Loire-atlantique (IGP) (page inexistante)\">loire-atlantique</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Vend%C3%A9e_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Vendée (IGP) (page inexistante)\">vendée</a></span></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"\">Vignoble d'<a href=\"/wiki/Anjou\" title=\"Anjou\">Anjou</a></th>\n<td class=\"navbox-list\" style=\"\"><span class=\"nowrap\"><a href=\"/wiki/Anjou_(AOC)\" title=\"Anjou (AOC)\">anjou</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Cabernet_d%27Anjou\" title=\"Cabernet d'Anjou\">cabernet d'Anjou</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Ros%C3%A9_d%27Anjou\" title=\"Rosé d'Anjou\">rosé d'Anjou</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Anjou-coteaux-de-la-loire\" title=\"Anjou-coteaux-de-la-loire\">anjou-coteaux-de-la-loire</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Savenni%C3%A8res_(AOC)\" title=\"Savennières (AOC)\">savennières</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Coteaux-du-layon\" title=\"Coteaux-du-layon\">coteaux-du-layon</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Chaume_(AOC)\" title=\"Chaume (AOC)\">coteaux-du-layon chaume</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Quarts-de-chaume\" title=\"Quarts-de-chaume\">quarts-de-chaume</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Bonnezeaux\" title=\"Bonnezeaux\">bonnezeaux</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Coteaux-de-l%27aubance\" title=\"Coteaux-de-l'aubance\">coteaux-de-l'aubance</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Anjou_villages\" title=\"Anjou villages\">anjou villages</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Anjou_villages_brissac\" title=\"Anjou villages brissac\">Anjou villages brissac</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Saumur_(AOC)\" title=\"Saumur (AOC)\">saumur</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Coteaux-de-saumur\" title=\"Coteaux-de-saumur\">coteaux-de-saumur</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Saumur-champigny\" title=\"Saumur-champigny\">saumur-champigny</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Vin_du_Thouarsais\" title=\"Vin du Thouarsais\">Thouarsais</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Cabernet_de_Saumur\" title=\"Cabernet de Saumur\">cabernet de Saumur</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Maine-et-loire_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Maine-et-loire (IGP) (page inexistante)\">maine-et-loire</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Deux-s%C3%A8vres_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Deux-sèvres (IGP) (page inexistante)\">deux-sèvres</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Indre-et-loire_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Indre-et-loire (IGP) (page inexistante)\">indre-et-loire</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Vienne_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Vienne (IGP) (page inexistante)\">vienne</a></span></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"\">Vignoble de <a href=\"/wiki/Touraine\" title=\"Touraine\">Touraine</a></th>\n<td class=\"navbox-list navbox-even\" style=\"\"><span class=\"nowrap\"><a href=\"/wiki/Saint-nicolas-de-bourgueil_(AOC)\" title=\"Saint-nicolas-de-bourgueil (AOC)\">saint-nicolas-de-bourgueil</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Bourgueil_(AOC)\" title=\"Bourgueil (AOC)\">bourgueil</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Chinon_(AOC)\" title=\"Chinon (AOC)\">chinon</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Touraine_(AOC)\" title=\"Touraine (AOC)\">touraine</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Touraine-azay-le-rideau\" title=\"Touraine-azay-le-rideau\">touraine-azay-le-rideau</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Touraine-noble-jou%C3%A9\" title=\"Touraine-noble-joué\">touraine-noble-joué</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Vouvray_(AOC)\" title=\"Vouvray (AOC)\">vouvray</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Montlouis-sur-Loire_(AOC)\" title=\"Montlouis-sur-Loire (AOC)\">montlouis-sur-loire</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Touraine-amboise\" title=\"Touraine-amboise\">touraine-amboise</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Touraine-mesland\" title=\"Touraine-mesland\">touraine-mesland</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Cheverny_(AOC)\" title=\"Cheverny (AOC)\">cheverny</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Cour-cheverny_(AOC)\" title=\"Cour-cheverny (AOC)\">cour-cheverny</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Coteaux-du-loir\" title=\"Coteaux-du-loir\">coteaux-du-loir</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Jasni%C3%A8res\" title=\"Jasnières\">jasnières</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Coteaux-du-vend%C3%B4mois\" title=\"Coteaux-du-vendômois\">coteaux-du-vendômois</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Haut-Poitou_(AOC)\" title=\"Haut-Poitou (AOC)\">haut-poitou</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Loir-et-cher_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Loir-et-cher (IGP) (page inexistante)\">loir-et-cher</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Sarthe_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Sarthe (IGP) (page inexistante)\">sarthe</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Coteaux-du-cher-et-de-l%27arnon\" title=\"Coteaux-du-cher-et-de-l'arnon\">coteaux-du-cher-et-de-l'arnon</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Indre_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Indre (IGP) (page inexistante)\">indre</a></span></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"\">Vignobles de l'<a href=\"/wiki/Orl%C3%A9anais\" title=\"Orléanais\">Orléanais</a>, du <a href=\"/wiki/Centre-Val_de_Loire\" title=\"Centre-Val de Loire\">Centre-Val de Loire</a> et du <a href=\"/wiki/Massif_central\" title=\"Massif central\">Massif central</a></th>\n<td class=\"navbox-list\" style=\"\"><span class=\"nowrap\"><a href=\"/wiki/Orl%C3%A9ans_(AOC)\" title=\"Orléans (AOC)\">orléans</a></span>&#160;• <span class=\"nowrap\"><a class=\"mw-selflink selflink\">orléans-cléry</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Ch%C3%A2teaumeillant_(AOC)\" title=\"Châteaumeillant (AOC)\">châteaumeillant</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Coteaux-du-giennois\" title=\"Coteaux-du-giennois\">coteaux-du-giennois</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Menetou-salon_(AOC)\" title=\"Menetou-salon (AOC)\">menetou-salon</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Pouilly-fum%C3%A9\" title=\"Pouilly-fumé\">pouilly-fumé</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Pouilly-sur-loire_(AOC)\" title=\"Pouilly-sur-loire (AOC)\">pouilly-sur-loire</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Quincy_(AOC)\" title=\"Quincy (AOC)\">quincy</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Reuilly_(AOC)\" title=\"Reuilly (AOC)\">reuilly</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Sancerre_(AOC)\" title=\"Sancerre (AOC)\">sancerre</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Valen%C3%A7ay_(AOC)\" title=\"Valençay (AOC)\">valençay</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Saint-pour%C3%A7ain_(AOC)\" title=\"Saint-pourçain (AOC)\">saint-pourçain</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/C%C3%B4tes-d%27auvergne\" title=\"Côtes-d'auvergne\">côtes-d'auvergne</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/C%C3%B4te-roannaise\" title=\"Côte-roannaise\">côte-roannaise</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/C%C3%B4tes-du-forez\" title=\"Côtes-du-forez\">côtes-du-forez</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Loiret_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Loiret (IGP) (page inexistante)\">loiret</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Cher_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Cher (IGP) (page inexistante)\">cher</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Ni%C3%A8vre_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Nièvre (IGP) (page inexistante)\">nièvre</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Allier_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Allier (IGP) (page inexistante)\">allier</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Puy-de-d%C3%B4me_(IGP)\" title=\"Puy-de-dôme (IGP)\">puy-de-dôme</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Coteaux-charitois_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Coteaux-charitois (IGP) (page inexistante)\">coteaux-charitois</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Coteaux-de-tannay\" title=\"Coteaux-de-tannay\">coteaux-de-tannay</a></span>&#160;• <span class=\"nowrap\"><a href=\"/w/index.php?title=Bourbonnais_(IGP)&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Bourbonnais (IGP) (page inexistante)\">bourbonnais</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Urf%C3%A9_(IGP)\" title=\"Urfé (IGP)\">urfé</a></span></td>\n</tr>\n<tr>\n<th class=\"navbox-group\" style=\"\">Autres vignobles isolés</th>\n<td class=\"navbox-list navbox-even\" style=\"\"><span class=\"nowrap\"><a href=\"/wiki/Calvados_(IGP)\" title=\"Calvados (IGP)\">calvados</a></span>&#160;• <span class=\"nowrap\"><a href=\"/wiki/Haute-Vienne_(IGP)\" title=\"Haute-Vienne (IGP)\">haute-vienne</a></span></td>\n</tr>\n</table>\n</div>\n<ul id=\"bandeau-portail\" class=\"bandeau-portail\">\n<li><span class=\"bandeau-portail-element\"><span class=\"bandeau-portail-icone\"><a href=\"/wiki/Portail:Vigne_et_vin\" title=\"Portail de la vigne et du vin\"><img alt=\"Portail de la vigne et du vin\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/f/fe/Grape-symbol-logo.svg/24px-Grape-symbol-logo.svg.png\" width=\"24\" height=\"24\" class=\"noviewer\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/f/fe/Grape-symbol-logo.svg/36px-Grape-symbol-logo.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/f/fe/Grape-symbol-logo.svg/48px-Grape-symbol-logo.svg.png 2x\" data-file-width=\"800\" data-file-height=\"800\" /></a></span> <span class=\"bandeau-portail-texte\"><a href=\"/wiki/Portail:Vigne_et_vin\" title=\"Portail:Vigne et vin\">Portail de la vigne et du vin</a></span></span></li>\n<li><span class=\"bandeau-portail-element\"><span class=\"bandeau-portail-icone\"><a href=\"/wiki/Portail:Loiret\" title=\"Portail du Loiret\"><img alt=\"Portail du Loiret\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/58/Blason_d%C3%A9partement_fr_Loiret.svg/22px-Blason_d%C3%A9partement_fr_Loiret.svg.png\" width=\"22\" height=\"24\" class=\"noviewer\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/5/58/Blason_d%C3%A9partement_fr_Loiret.svg/33px-Blason_d%C3%A9partement_fr_Loiret.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/58/Blason_d%C3%A9partement_fr_Loiret.svg/44px-Blason_d%C3%A9partement_fr_Loiret.svg.png 2x\" data-file-width=\"600\" data-file-height=\"660\" /></a></span> <span class=\"bandeau-portail-texte\"><a href=\"/wiki/Portail:Loiret\" title=\"Portail:Loiret\">Portail du Loiret</a></span></span></li>\n</ul>\n\n</div>","displaytitle":"Orléans-cléry","iwlinks":[],"wikitext":"{{Infobox Région viticole\n | nom               = Orléans-cléry\n | charte             = rouge\n | image             = AOC Orléans-cléry vignoble.JPG\n | légende           = Vignoble de l'AOC orléans-cléry à [[Mareau-aux-Prés]].\n | appellations      = orléans-cléry<ref group=\"Notes\" name=\"AO\"/>\n | typeappellation   = [[appellation d'origine contrôlée|AOC]]-[[appellation d'origine protégée|AOP]]<ref name=\"inao\">{{Lien web|url=http://www.inao.gouv.fr/public/produits/detailProduit.php?ID_PRODUIT=5301 |titre=Orléans-Cléry |site=[http://www.inao.gouv.fr www.inao.gouv.fr] |année=10 mars 2011 |éditeur=[[Ministère de l'agriculture (France)|Ministère de l'agriculture]]. [[Institut national de l'origine et de la qualité]] |consulté le=17 mars 2011 }}</ref>\n| année             = [[2006]]<ref name=\"Légifrance1\">{{Légifrance | base=JORF | numéro=AGRP0602138D | texte=Décret du 23 novembre 2006 }} relatif à l'appellation d'origine contrôlée \"Orléans-Cléry\". {{Lien web|url=http://www.legifrance.gouv.fr |titre=www.legifrance.gouv.fr |année=2006 |éditeur=Secrétariat général du gouvernement français |consulté le=17 mars 2011 }}</ref>\n | pays              = {{France}}\n | région-mère       = [[Vignoble de la vallée de la Loire|vallée de la Loire]]\n | similaire         = \n | sous-régions      = [[Orléanais]]\n | localisation      = [[Loiret (département)|Loiret]]\n | saison            = \n | climat            = [[Climat tempéré|tempéré]] [[Climat océanique|océanique]] dégradé\n | jourssoleil       = {{unité|1804|heures}}/an<ref name=\"infoclimat\"/>\n | sol               = [[argile|argilo]]-[[silice|siliceux]] et [[Grave (terrain)|gravelo]]-[[silice|siliceux]]\n | superficietotale  = \n | superficieplantée = 28 [[hectare]]s<ref name=\"Guide Hachette\">{{ouvrage|langue=fr|prénom1=|nom1=Collectif|lien auteur1=|titre=Le guide Hachette des vins 2011 |sous-titre=des vins pour tous les goût, à tous les prix|numéro d'édition=|éditeur=Hachette livre|lien éditeur=|lieu=Paris|mois=août|année=2010|pages totales=1402|passage=1050|isbn=978-2-01-237681-6|consulté le=17 mars 2011}}</ref>\n | exploitations     = 23 viticulteurs et 6 vinificateurs<ref name=\"inao\"/>\n | cépages           = [[cabernet franc]] N<ref group=\"Notes\" name=\"cep\">Le code international d'écriture des cépages mentionne la couleur du raisin de la manière suivante : B = blanc, N = noir, Rs = rose, G = gris.</ref>{{,}}<ref name=\"Légifrance2\">{{pdf}} {{lien web|url=http://agriculture.gouv.fr/IMG/pdf/AOC_SOMM44.pdf |titre=Cahier des charges de l'appellation |site=http://agriculture.gouv.fr/ }}, homologué par le {{article|titre={{Légifrance | base=JORF | numéro=AGRT1114927D | texte=décret {{n°}}2011-1399 du 26 octobre 2011 }} relatif à l'appellation d'origine contrôlée « Orléans-Cléry » |périodique=JORF |lien périodique=Journal officiel de la République française |numéro=0252 |jour=29 |mois=octobre |année=2011 |passage=18279}}.</ref>\n | vins              = [[Vin rouge|rouges]]\n | volproduction     = {{unité|848|hectolitres}} en [[2009]]<ref name=\"Guide Hachette\"/>\n | densité           = minimum de {{unité|5000|pieds}} par hectare<ref name=\"Légifrance2\"/>\n | rendement         = maximum 50 à {{unité|65|hectolitres}} par hectare<ref name=\"Légifrance2\"/>\n}}\nL’'''orléans-cléry'''<ref group=\"Notes\" name=\"AO\">[[Appellation d'origine#Grammaire|Références sur la façon d'orthographier les appellations d'origine]].</ref> est un [[vin rouge]] [[France|français]] d'[[appellation d'origine contrôlée]] (AOC) et d'[[appellation d'origine protégée]] (AOP) produit dans le [[département français|département]] du [[Loiret (département)|Loiret]] ([[Région française|région]] [[Centre-Val de Loire]]).\n\nL'appellation concerne le territoire de cinq [[commune (France)|communes]] située à l'ouest de la ville d'[[Orléans]] sur la rive gauche de la [[Loire (fleuve)|Loire]] : [[Cléry-Saint-André]], [[Mareau-aux-Prés]], [[Mézières-lez-Cléry]], [[Olivet (Loiret)|Olivet]] et [[Saint-Hilaire-Saint-Mesmin]]<ref name=\"Légifrance2\"/>. Elle se trouve au sein d'une autre appellation plus vaste, celle d'[[orléans (AOC)|orléans]].\n\nL'orléans-cléry, obtenue en [[2006]]<ref name=\"Légifrance1\"/>, est l'une des trois [[Appellation d'origine contrôlée|AOC]] viticoles de l'[[Orléanais]] avec l'[[Orléans (AOC)|orléans]] et les [[coteaux-du-giennois]].\n\n== Histoire ==\n[[Fichier:Hercule Guespin Hymne du vin d'Orléans 1605.jpg|thumb|Page de couverture de l'ouvrage du poète Simon du Rouzeau, 1605]]\n=== Moyen Âge ===\nIl semble que les [[moine]]s de l'[[abbaye Saint-Mesmin de Micy]] aient produit du vin dès le début du {{s|VI}}. À la même époque, [[Grégoire de Tours]] mentionne la présence de [[viticulture]] dans la [[anciennes provinces de France|province]] de l'[[Orléanais]]<ref name=\"inao\"/>.\n\nAu {{s|XIII}}, le roi de France [[Louis IX de France|Saint Louis]], fait exploiter par son personnel un vignoble à [[Chécy]]<ref>{{ouvrage|langue=fr|prénom1=|nom1=Boucher de Molandon|lien auteur1=|titre=Première expédition de Jeanne d'Arc |sous-titre=le ravitaillement d'Orléans|numéro d'édition=|éditeur=Herluison|collection=Mémoires de la Société archéologique et historique de l'Orléanais|lieu=Orléans|jour=|mois=|année=1876|volume=|tome=15|pages totales=550|passage=99|isbn=|lire en ligne=http://gallica.bnf.fr/ark:/12148/bpt6k5544845w/f123|consulté le=5 avril 2011}}</ref>.\n\n=== Époque moderne ===\nDurant l'[[époque moderne]] et pour diverses raisons, le vignoble connait une importante extension, sous forme de quasi-[[monoculture]] de [[Châteauneuf-sur-Loire]] à l'est jusqu'à [[Beaugency]] à l'ouest. Le [[Domaine royal français]], très restreint à l'époque, se tourne donc naturellement vers le vignoble orléanais. De plus, ce dernier est chargé d'approvisionner la ville de [[Paris]] en vin. En effet, en 1577, le Parlement de Paris promulgue une loi interdisant aux Parisiens l'achat de vins produits à moins de 90 kilomètres de la capitale, la production orléanaise est alors augmentée pour satisfaire la demande. Le transport du vin vers la capitale en grande quantité est favorisé par la courte distance (133 kilomètres) sur terrain plat, le [[Pavé|pavage]] de la route de bout en bout dès 1577 (tronçon de l'actuelle [[Route nationale 20 (France)|route nationale 20]]) et la construction du [[canal de Briare]] ouvert en [[1642]] (reliant la [[Loire (fleuve)|Loire]] à la [[Seine]] par la vallée du [[Loing]]). L'augmentation de la production s'effectue au détriment de la qualité<ref name=\"inao\"/>.\n\nIl semble que la table royale s'approvisionne en [[Vignoble de la vallée de la Loire|vins de la vallée de la Loire]] jusqu'au {{XVIe siècle}}. Pour tenter de limiter la consommation excessive qu'en fait [[Henri IV de France|Henri IV]], roi de France de [[1589]] à [[1610]], son médecin et conseiller [[Joseph du Chesne]] écrit en [[1606]] dans son ''pourtraict de la santé'' : {{citation|le vin de [[Coucy|Coussy]] et d'[[Ay (Marne)|Hay]] et semblables ont même été trouvés meilleurs que ceux d'Orléans qui sont fumeux et qui donnent à la tête. C'est pourquoi ont fait prêter serment à tous les maîtres d'hôtel du Roy à leur réception en telle charge de ne faire servir pour la bouche du Roy des vins d'Orléans, bien que d'ailleurs, ils sont mis au nombre des bons vins quant au goût}}<ref>{{ouvrage|langue=fr|prénom1=Joseph|nom1=Duchesne|lien auteur1=Joseph Duchesne|titre=Le pourtraict de la santé où est au vif représentée la règle universelle et particulière, de bien sainement et longuement vivre |sous-titre=enrichis de plusieurs préceptes, raisons et beaux exemples, tirés des médecins, philosophes et historiens, tant grecs que latins, les plus célèbres|éditeur=chez Claude Morel|lieu=Paris|année=1606|pages totales=595|passage=221|lire en ligne=https://books.google.fr/books?id=CUcemq8P94IC|consulté le=17 mars 2011}}</ref> La cour semble délaisser peu à peu le vin orléanais sous [[Louis XIII de France|Louis XIII]] qui règne de [[1610]] à [[1643]]<ref>{{ouvrage|langue=fr|prénom1=Octave|nom1=Pradels|lien auteur1=|titre=Le vin et la chanson |sous-titre=|numéro d'édition=|éditeur=Flammarion|lien éditeur=|lieu=Paris|jour=|mois=|année=1913|volume=|tome=|pages totales=|passage=236|isbn=|lire en ligne=http://gallica.bnf.fr/ark:/12148/bpt6k56525250/f246|consulté le=19 mars 2011}}</ref>.\nL'avis du roi est suivi par l'[[aristocratie]] qui à son tour opte pour les [[Vignoble de Champagne|vins de Champagne]] puis [[Vignoble de Bourgogne|de Bourgogne]], ce qui a pour effet de spécialiser l'Orléanais dans la production de vins médiocres et bon marché.\n\n[[Fichier:Manière de bien cultiver la vigne dans le vignoble d'Orléans 1712.jpg|thumb|left|Page de couverture de l'ouvrage du chanoine  Boullay, 1712]]\nLe premier quart du {{XVIIIe siècle}} est marqué par la publication de trois éditions<ref group=\"Notes\">La date de la première édition de l'ouvrage du chanoine orléanais Jacques Boullay ''Manière de bien cultiver la vigne dans le vignoble d'Orléans'' n'est pas précisément connue, les deux autres datent de [[1712]] et [[1723]].</ref> de l'ouvrage du [[chanoine]] orléanais Jacques Boullay de Saint-Pierre-Ampon intitulé ''Manière de bien cultiver la vigne dans le vignoble d'Orléans''<ref>{{ouvrage|langue=fr|prénom1=Jacques|nom1=Boullay|lien auteur1=|titre=Manière de bien cultiver la vigne dans le vignoble d'Orléans |sous-titre=beaucoup plus amples et plus exacte que la précédente|numéro d'édition=2|éditeur=François Borde|lien éditeur=|lieu=Orléans|jour=|mois=|année=1712|volume=|tome=|pages totales=206|passage=|isbn=|lire en ligne=https://books.google.fr/books?id=38s6AAAAcAAJ|consulté le=19 mars 2011}} ; {{ouvrage|langue=fr|prénom1=Jacques|nom1=Boullay|lien auteur1=|titre=Manière de bien cultiver la vigne, de faire la vendange et le vin dans le vignoble d'Orléans|sous-titre=utile à tous les autres vignobles du royaume où l'on donne les moyens de prévenir et de découvrir les friponneries des mauvais vignerons|numéro d'édition=3|éditeur=J. Rouzeau|lien éditeur=|lieu=Orléans|jour=|mois=|année=1723|volume=|tome=|pages totales=|passage=|isbn=|lire en ligne=|consulté le=}}</ref>. À cette époque, la qualité du vin orléanais continue de décliner, les classes bourgeoises, propriétaires des vignobles, n'accordent qu'une confiance limitée aux pratiques agricoles des vignerons qui exploitent leurs vignes. Jacques Boullay s'improvise donc professeur et médiateur, en dénonçant les {{citation|friponneries des mauvais vignerons}}. Sa démarche sera très critiquée par les cultivateurs et sa personne s'en trouvera menacée<ref>{{ouvrage|langue=fr|prénom1=André|nom1=Bouvier|lien auteur1=|titre=Mémoires de la société archéologique de l'Orléanais |sous-titre=un analyste orléanais peu connu, Jean-François Rozier fils (1762-1854) et les débuts de la Révolution à Orléans d'après des documents inédits |numéro d'édition=|éditeur=Société archéologique de l'Orléanais|lien éditeur=|lieu=Orléans|jour=|mois=|année=1926|volume=|tome=36|pages totales=372|passage=238|isbn=|lire en ligne=http://gallica.bnf.fr/ark:/12148/bpt6k5774582f/f248|consulté le=19 mars 2011}}</ref>.\n\nDans son ''dictionnaire géographique, historique et politique des Gaules et de la France'' paru en [[1768]], l'abbé [[Louis-Alexandre Expilly de La Poipe]] décrit le vignoble d'Orléans comme l'un des plus vaste de France (dix à onze lieues<ref group=\"Notes\">La [[lieue]] métrique vaut 4 km.</ref> d'étendue). Il couvre 25 à 30 communes entre [[Beaugency]] et [[Jargeau]]. Plusieurs vins blancs y sont produits dont notamment le ''Gennetin'' à [[Abbaye Saint-Mesmin de Micy|Saint-Mesmin]] et les vins de [[Marigny-les-Usages|Marigny]] et [[Rebréchien]]. Parmi les vins rouges, surnommés ''Auvernat'' car probablement issu d'un cépage venu d'Auvergne, sont nommés ceux de [[Saint-Denis-en-Val]], [[La Chapelle-Saint-Mesmin|La Chapelle]], Fourneaux et [[Saint-Ay]]<ref>{{ouvrage|langue=fr|prénom1=Louis-Alexandre|nom1=Expilly|lien auteur1=Louis-Alexandre Expilly de La Poipe|titre=Dictionnaire géographique, historique et politique des Gaules et de la France|sous-titre=|numéro d'édition=|éditeur=|lien éditeur=|lieu=Amsterdam|jour=|mois=|année=1768|volume=|tome=5|pages totales=1064|passage=327|isbn=|lire en ligne=https://books.google.fr/books?id=__eYqVsFlkIC&pg=PA327|consulté le=24 mars 2011}}</ref>.\n\nEn [[1770]], le chanoine orléanais, [[Jean-François Colas]] de la [[collégiale Saint-Aignan d'Orléans|collégiale Saint-Aignan]], publie à son tour un traité, ''Le manuel du cultivateur dans le vignoble d'Orléans'', sur un ton plus neutre et moins accusateur<ref>{{ouvrage|langue=fr|prénom1=Jean-François|nom1=Colas|lien auteur1=|titre=Le manuel du cultivateur dans le vignoble d'Orléans utile à tous les autres vignobles du royaume |sous-titre=|numéro d'édition=|éditeur=Chez Charles Jacob|lien éditeur=|lieu=Orléans|jour=|mois=|année=1770|volume=|tome=|pages totales=207|passage=|isbn=|lire en ligne=https://books.google.fr/books?id=nesaQwAACAAJ|consulté le=}}</ref>{{,}}<ref>{{ouvrage|langue=fr|prénom1=André|nom1=Corvol|prénom2=Christine|nom2=Bru-Malgras|lien auteur1=|titre=Forêt et vigne, bois et vin : XVI{{e}}-XX{{e}} siècles. Le savoir-faire ecclésiastique et monastique en matière de vigne et forêt |sous-titre=|numéro d'édition=|éditeur=L'Harmattan|lien éditeur=|lieu=|jour=|mois=|année=2002|volume=|tome=|pages totales=501|passage=192-195|isbn=9782747528269|lire en ligne=https://books.google.fr/books?id=ehOLRK8V5qUC|consulté le=19 mars 2011}}</ref>.\n\n=== Époque contemporaine ===\nDès le {{s mini-|XVIII|e}} et jusqu'au milieu du {{XIXe siècle}}, [[Orléans]] devient un [[Port d'Orléans|port fluvial de transit]] pour les vins d'autres régions, de l'amont comme de l'aval ([[Touraine]], [[Anjou]], puis [[Pays nantais]]) de la Loire, mais aussi de Bourgogne et du [[Vignoble du beaujolais|Haut-Beaujolais]] (les actuels crus du Beaujolais). Les vins ayant tourné étaient alors transformés en [[vinaigre]] (« vin aigre »), qui est depuis une des spécialités de la ville.\n{{Article connexe|port_d'Orléans#La_vinaigrerie{{!}}vinaigre d'Orléans}}\n\nAu début du {{s mini-|XIX|e}}, l'[[œnologue]] français [[André Jullien (vin)|André Jullien]] dans son ouvrage ''Topographie de tous les vignobles connus'' paru en [[1816]] dresse un état des lieux du vignoble orléanais. La superficie des vignobles du département du Loiret est estimée à {{unité|33000|hectares}} pour une récolte de {{unité|896000|hectolitres}} dont {{formatnum:220000}} sont consommés par les autochtones, le reste étant exporté sous l'appellation ''vin d'Orléans''<ref group=\"B\">{{p.}}80</ref>. Parmi les vins rouges dits de première classe, on trouve à l'Ouest d'Orléans ceux du lieu-dit Guignes à [[Tavers]], du clos Sainte-Marie à [[Saint-Jean-de-Braye]], de [[La Chapelle-Saint-Mesmin|La Chapelle]], de Saint-Gy, de [[Saint-Ay]], des Fourneaux, de [[Beaugency]], de [[Baule]], de Beaulette et de [[Meung-sur-Loire]]<ref group=\"B\">{{p.}}81-82</ref>. À l'Est d'Orléans, on trouve ceux de [[Saint-Denis-en-Val]], [[Combleux]] et [[Sandillon]]<ref group=\"B\">{{p.}}82</ref>. Parmi les vins rouges de deuxième classe, on trouve à Orléans ceux de Saint-Marc, Saint-Marceau, Saint-Paterne, à l'Ouest ceux de [[Saint-Pryvé-Saint-Mesmin|Saint-Privé]], au nord ceux de [[Saran]]g, [[Gidy|Gédy]], [[Fleury-les-Aubrais|Fleury]] et [[Semoy (Loiret)|Semoy]], à l'ouest celui d'[[Ingré]], au sud celui d'[[Olivet (Loiret)|Olivet]] et à l'Est ceux de [[Saint-Jean-le-Blanc (Loiret)|Saint-Jean-le-Blanc]], [[Bou]], [[Mardié]], [[Saint-Denis-de-l'Hôtel|Saint-Denis-de-Jargeau]] et [[Jargeau]]<ref group=\"B\">{{p.}}82-83</ref>. Parmi les vins blancs, sont cités ceux produits à [[Marigny-les-Usages|Marigny]] et [[Rebréchien]]. Celui de [[Loury]], cité comme un vin de médiocre qualité, sert à la fabrication du vinaigre d'Orléans<ref group=\"B\">{{p.}}84</ref>. Les tonneaux utilisés pour stocker le vin d'Orléans sont nommés ''pièce'' ou ''poinçon'' et possèdent une contenance de {{unité|228|litres}}<ref group=\"B\">{{p.}}85</ref>.\n\nLe développement du réseau de [[chemin de fer|chemins de fer]] au milieu du {{s mini-|XIX|e}} porte un coup fatal à la viticulture de l'Orléanais, permettant l'importation à moindre coût des vins du Midi (produits dans le [[vignoble du Languedoc-Roussillon]]).\n\nOn peut dresser un nouvel état des lieux du vignoble orléanais grâce à l'ouvrage du médecin et physicien français [[Jules Guyot]], ''Étude des vignobles de France : pour servir à l'enseignement mutuel de la viticulture et de la vinification françaises'', paru en [[1868]]. Économiquement parlant, l'exploitation d'un vignoble dans la région d'Orléans est décrite comme rentable si le propriétaire est capable de l'exploiter par lui-même. Un grand-propriétaire qui doit payer un vigneron n'en retire pas de bénéfices considérables. Trois grands types de culture de la vigne sont recensées, l'une sur la rive droite de la Loire, l'une sur la rive gauche et la dernière dans une petite région centrée sur la commune d'Olivet. Dans tout le vignoble, les plants sont organisés en ligne à {{unité|80|cm}} les uns des autres<ref>{{ouvrage|langue=fr|prénom1=Jules|nom1=Guyot|lien auteur1=Jules Guyot|titre=Étude des vignobles de France  |sous-titre=pour servir à l'enseignement mutuel de la viticulture et de la vinification françaises. Régions du Centre-Nord, du Nord et du Nord-Ouest |numéro d'édition=|éditeur=Imprimerie impériale|lien éditeur=Imprimerie nationale (France)|lieu=Paris|jour=|mois=|année=1868|volume=|tome=3|pages totales=710|passage=220-232|isbn=|lire en ligne=http://gallica.bnf.fr/ark:/12148/bpt6k1109477/f224|consulté le=24 mars 2011}}</ref>.\n[[File:Loiret Vendanges en Sologne.jpg|thumb|Vendanges entre Orléans et la Sologne]]\nAprès les ravages causés par le [[phylloxéra]], un puceron ravageur de la vigne, à la fin du {{s mini-|XIX|e}}, très peu de replantations sont faites autour d'Orléans. Les surfaces cultivées disparaissant presque totalement au cours du {{s|XX}} du fait d'une très forte concurrence pour ce type de vin courant.\n\nMalgré tout, quelques producteurs poursuivent une petite production, encadrée à partir de [[1951]] par l'[[appellation d'origine vin délimité de qualité supérieure]] (VDQS) « vin de l'Orléanais »<ref>Arrêté du 9 août 1951 relatif aux \"vins de l'Orléanais\", définition du droit à l'appellation en application de la loi du 6 mais 1919 relative aux appellations d'origine, publié au [http://www.legifrance.gouv.fr/jopdf/common/jo_pdf.jsp?numJO=0&dateJO=19510823&numTexte=&pageDebut=08990&pageFin= ''JORF'' du 23 août 1951, {{p.}}8990].</ref>. L'[[Institut national de l'origine et de la qualité]] (INAO) fait reconnaître une appellation VDQS particulière sous le nom d'« orléans-cléry » par l'arrêté du {{date|14|octobre|2002}} publié au [[journal officiel de la République française]] du {{date|15|novembre|2002}}<ref name=\"Légifrance0\">{{Légifrance | base=JORF | numéro=AGRP0202372A | texte=Arrêté du 14 octobre 2002 }} relatif à l'appellation d'origine Vin délimité de qualité supérieure « Orléans-Cléry ». JORF {{n°}}266 du 15 novembre 2002, page 18903, texte {{n°}}46. {{Lien web|url=http://www.legifrance.gouv.fr |titre=www.legifrance.gouv.fr |année=2002 |éditeur=Secrétariat général du gouvernement français |consulté le=17 mars 2011 }}</ref>, avant de le faire passer au statut d'[[appellation d'origine contrôlée]] par le décret du {{date|23|novembre|2006}}<ref name=\"Légifrance1\"/>, modifié par le décret du {{date|16|octobre|2009}}<ref name=\"Légifrance2\"/>.\n\nLe syndicat viticole de l’Orléanais, reconnu dès [[1994]]<ref>{{Légifrance | base=JORF | numéro=ECOC9400118A | texte=Arrêté du 10 août 1994}} portant agrément des organismes professionnels chargés de la dégustation des vins de pays. JORF {{n°}}202 du {{1er}} septembre 1994, page 12675. {{Lien web|url=http://www.legifrance.gouv.fr |titre=www.legifrance.gouv.fr |année=1994 |éditeur=Secrétariat général du gouvernement français |consulté le=17 mars 2011 }}</ref> et basé à [[Saint-Hilaire-Saint-Mesmin]] est, depuis [[2007]], chargé de la promotion de l'appellation, s'appuyant entre autres sur la [[confrérie]] vigneronne des chevaliers d'Orléans-Cléry créée à [[Cléry-Saint-André]] et hébergée à la mairie<ref>{{Lien web|url=http://www.clery-saint-andre.com/vie-associative/social-culture-et-loisirs/122-confrerie-vigneronne-des-chevaliers-dorleans-clery |titre=Confrérie Vigneronne des Chevaliers d'Orléans-Cléry |site=[http://www.clery-saint-andre.com www.clery-saint-andre.com] |éditeur=Ville de Cléry-Saint-André |consulté le=17 mars 2011 }}</ref> dans le but d'améliorer la promotion des vins locaux.\n\n=== Étymologie ===\n[[Fichier:Plan de Cléry au 18e siècle.JPG|thumb|350px|Plan de [[Cléry-Saint-André|Cléry]] au {{XVIIIe siècle}}, avec les vignes indiquées sur les terrasses.]]\nLe nom de l'appellation est formé des noms des communes d'Orléans, préfecture du département, et de Cléry-Saint-André, au centre de l'aire d'appellation.\n\n{{référence nécessaire|La première mention écrite de [[Cléry-Saint-André|Cléry]] date du milieu du {{VIe siècle}} : l’[[Liste des évêques d'Orléans|évêque d’Orléans]] Marc mentionne le lieu ''Clariacus vicus'' : le terme ''[[Vicus]]'' désigne en [[latin]] un groupe d’habitations, village ou hameau, et ''Clariacus'' son nom.}}\n\nLe nom de la ville d'Orléans dérive probablement de la corruption de l'un de ses anciens noms, ''Aurelianum'', qui pourrait être issu du nom des empereurs romains [[Marc Aurèle]], qui aurait fait embellir la ville en [[163]], ou Aurélien qui la fit rebâtir en [[273]]. Une autre hypothèse évoque la possibilité que la ville tienne son nom de la mère de [[Jules César]], [[Aurelia Cotta]]<ref>{{article|id=Bimbenet|langue=fr|prénom1=|nom1=Bimbenet|lien auteur1=|titre=Rapport au nom de la section des belles-lettres sur le mémoire Orléans et ses panégyristes au {{s-|XVI}} par Baguenault de Viéville |périodique=Mémoires de la Société d'agriculture, sciences, belles-lettres et arts d'Orléans|lien périodique=|volume=3|numéro=|jour=|mois=|année=1857|pages=108-122|issn=|url texte=https://books.google.fr/books?id=Vr8XAAAAYAAJ|consulté le=9 décembre 2010}}</ref>. Une étude de Jacques Soyer relègue néanmoins ces hypothèses au statut de légende, ''Aurelia'' descendant, d'après ses recherches, du nom de la [[Gens (Rome antique)|gens]] ''Aurelia'' qui possédait des terres à [[Cenabum]], ancienne cité [[Peuples celtes|celtique]] des [[Carnutes]] située à l'emplacement d'Orléans<ref>{{article|langue=fr|prénom1=Jacques|nom1=Soyer|lien auteur1=|titre=La légende de la fondation d'Orléans par l'empereur Aurélien|périodique=Mémoires de la société d'agriculture, sciences, belles-lettres et arts d'Orléans|lien périodique=|volume=73|numéro=73|jour=|mois=|année=1912|pages=130|issn=|url texte=http://www.persee.fr/web/revues/home/prescript/article/bec_0373-6237_1912_num_73_1_460916_t1_0130_0000_001|consulté le=9 décembre 2010}}</ref>.\n\n=== Le vin d'Orléans dans les arts ===\nEn [[1605]], le poète orléanais, Simon du Rouzeau (?-[[1627]])<ref>Présenté dans ''Poètes du vin, poètes divins'' de [[Kilien Stengel]], préface de [[Jean-Robert Pitte]], Paris, collection Ecriture, [[Éditions de l'Archipel]], 2012, 280 p.</ref> fait paraître ''L'Hercule Guespin ou l'himne du vin d'Orléans'', texte qui vante la qualité du vin d'Orléans<ref>{{ouvrage|langue=|prénom1=Simon|nom1=du Rouzeau|lien auteur1=|titre=L'Hercule Guepin : poème en l'honneur du vin d'Orléans |sous-titre=édition conforme à celle de 1605 accompagnée de notes et d'une notice bibliographique|numéro d'édition=|éditeur=H. Herluison|lien éditeur=|lieu=Orléans|jour=|mois=|année=1860|volume=|tome=|pages totales=56|passage=|isbn=|lire en ligne=https://books.google.com/books?id=i8cLAAAAQAAJ|consulté le=19 mars 2011}}. Voir l'édition originale dans la bibliographie.</ref>.\n\nLe comédien Antoine Girard (v.[[1584]]-[[1633]]) dit [[Tabarin]] écrit en [[1623]] dans son ''adieu de Tabarin au peuple de Paris'', où le vin d'Orléans était à l'époque très consommé : {{citation|ce vin d'Orléans, lequel bridant la raison, lasche les resnes à la folie, me fait devenir fol de regret}}<ref>{{ouvrage|langue=|prénom1=|nom1=Tabarin|lien auteur1=|titre=Œuvres complètes de Tabarin |sous-titre=l'adieu de Tabarin au peuple de Paris avec les regrets des bons morceaux et du bon vin, adressé aux artisans de la gueule et aux suppost de Bacchus, 1623, édité Chez Pierre Rocolet|numéro d'édition=|éditeur=P. Jannet|lien éditeur=|lieu=Paris|jour=|mois=|année=1858|volume=2|tome=|pages totales=504|passage=463|isbn=|lire en ligne=http://gallica.bnf.fr/ark:/12148/bpt6k277976/f463|consulté le=20 mars 2011}}</ref>.\n\n== Situation géographique ==\nL'orléans-cléry<ref group=\"Notes\" name=\"AO\"/> est produit en [[France]], dans la [[région française|région]] [[région Centre|Centre]], plus précisément dans le département du [[Loiret (département)|Loiret]] sur le territoire des communes de [[Cléry-Saint-André]], [[Mareau-aux-Prés]], [[Mézières-lez-Cléry]], [[Olivet (Loiret)|Olivet]] et [[Saint-Hilaire-Saint-Mesmin]], en aval d'[[Orléans]].\n\n=== Géologie et orographie ===\n[[Fichier:Repères de crues de la Loire à Orléans.jpg|thumb|La géologie locale est déterminée par les dépôts de la Loire ; repères de crues du fleuve à Orléans.]]\n[[Fichier:Sol alluvions Mareau.jpg|thumb|left|Sol d'[[alluvions]] ([[sable]] et [[limon (roche)|limon]]) à [[Mareau-aux-Prés]]]].\nLes vignes sont plantées sur les [[alluvions]] qui recouvrent presque toute la rive gauche de la [[Loire (fleuve)|Loire]]. Au bord du fleuve s'étalent d'abord les alluvions les plus récentes, délimitant le [[lit mineur]] mais aussi [[Lit (hydrologie)|majeur]] (les zones inondables, protégées par les [[levée de la Loire|levées de la Loire]]). Ces alluvions sont de différentes tailles, du [[limon (roche)|limon]] [[sable]]ux le plus fin aux [[galet]]s, majoritairement [[silice]]ux (sable de [[quartz (minéral)|quartz]] et de [[feldspath]]s, galets de [[silex]], de [[Grès (géologie)|grès]], de [[Roche volcanique|roches éruptives]] et de [[calcaire]]) provenant du [[Massif central]].\n\nUn peu au-dessus, à la limite basse des villages, affleure le calcaire de [[Beauce (France)|Beauce]] sous forme d'une étroite bande. Datant de l'[[Aquitanien]], c'est un calcaire [[Craie|crayeux]] qui plonge immédiatement sous le placage des alluvions du haut du coteau. Plus haut, ce calcaire est couvert par des sables alluviaux éolisés (chariés à l'origine par le vent), du [[Glacis (géomorphologie)|glacis]] d'Olivet à Mareau-aux-Prés, sur lesquels sont plantés vignes et vergers.\n\nEnfin à partir de la limite des bois couvrant la [[Sologne]] commence la couche de six à sept mètres d'alluvions anciennes, formant la terrasse de [[Châteauneuf-sur-Loire|Châteauneuf]]. Datant de la [[glaciation de Riss]], ces alluvions vont de l'[[argile]] aux gros blocs, composées uniquement de silice sans le moindre calcaire<ref>Notices des cartes du [[BRGM]] {{pdf}}[http://ficheinfoterre.brgm.fr/Notices/0397N.pdf {{n°}}397 (Beaugency)] et {{pdf}}[http://ficheinfoterre.brgm.fr/Notices/0363N.pdf {{n°}}363 (Orléans)], disponibles sur le site [http://infoterre.brgm.fr/ infoterre.brgm.fr].</ref>{{,}}<ref>{{Géoportail\n | latitude    = 47/50/20/N\n | longitude   = 01/48/24/E\n | zoom        = \n | échelle     = 32000\n | couches     = Geologie\n | desc        = Carte géologique centrée sur le hameau des Muids\n | consulté le = \n}}</ref>.\n{{Article détaillé|échelle des temps géologiques}}\n\n=== Climatologie ===\n{{voir aussi|climat du Loiret}}\nLe climat est [[climat tempéré|tempéré]] [[Climat océanique|océanique]] à influence [[climat continental|continentale]]. \n\nLa [[station météo]] de niveau 0<ref group=\"Notes\">Météo France définit les stations météo selon [http://climatheque.meteo.fr/aide/climatheque/reseauPostes/aideTypePoste.html six grands types], numérotés de 0 à 5 ;  professionnelle avec observation humaine (0), non professionnelle avec observation humaine ou à distance (1), automatique en temps réel (2), station automatique temps différé (3), manuelle (4), poste à interrogation occasionnelle (5)</ref> la plus proche du vignoble est celle du village de [[Bricy]]. Elle est située à {{unité|17|km}} au nord du centre de l'aire d'appellation<ref group=\"Notes\">Les distances sont mesurées grâce à l'outil ''Distance measure'' sur site [http://wikimapia.org wikimapia.org]. Le centre de l'appellation est fixée à Mareau-aux-Prés.</ref>.\n\n<!-- DÉBUT DU TABLEAU DES DONNÉES MÉTÉO -->\n{{Relevé météo\n|titre=Relevé météorologique d'Orléans-Bricy 1961-1990\n|source=Infoclimat<ref name=\"infoclimat\">{{Lien web|url=http://www.infoclimat.fr/climatologie/index.php?s=07249&aff=details |titre=Relevés Orléans-Bricy 1961-1990 |site=[http://www.infoclimat.fr www.infoclimat.fr] |année= |éditeur=Association Infoclimat |consulté le=11 mars 2011 }}</ref>\n|diagramme=oui\n\n<!-- PARTIE A : TEMPÉRATURES MOYENNES, ENSOLEILLEMENT ET HUMIDITÉ -->\n<!--température minimale moyenne (en°C)-->\n|tmin-jan=0.3\n|tmin-fev=0.8\n|tmin-mar=2.2\n|tmin-avr=4.3\n|tmin-mai=7.8\n|tmin-jui=10.7\n|tmin-jul=12.6\n|tmin-aou=12.3\n|tmin-sep=10.3\n|tmin-oct=7.3\n|tmin-nov=3.3\n|tmin-dec=1.1\n|tmin-ann=6.1\n<!--température moyenne (en°C)-->\n|tmoy-jan=3.1\n|tmoy-fev=4.2\n|tmoy-mar=6.6\n|tmoy-avr=9.3\n|tmoy-mai=12.9\n|tmoy-jui=16.2\n|tmoy-jul=18.5\n|tmoy-aou=18.2\n|tmoy-sep=15.8\n|tmoy-oct=11.7\n|tmoy-nov=6.6\n|tmoy-dec=3.8\n|tmoy-ann=10.6\n<!--température maximale moyenne (en°C)-->\n|tmax-jan=5.9\n|tmax-fev=7.6\n|tmax-mar=10.9\n|tmax-avr=14.3\n|tmax-mai=18.1\n|tmax-jui=21.6\n|tmax-jul=24.4\n|tmax-aou=24.0\n|tmax-sep=21.2\n|tmax-oct=16.2\n|tmax-nov=9.9\n|tmax-dec=6.5\n|tmax-ann=15.1\n\n<!--ensoleillement moyen (en h) -->\n|soleil-jan=58.5\n|soleil-fev=85.2\n|soleil-mar=134.7\n|soleil-avr=176.6\n|soleil-mai=206.7\n|soleil-jui=230.4\n|soleil-jul=252.2\n|soleil-aou=225\n|soleil-sep=180.3\n|soleil-oct=129.5\n|soleil-nov=74.6\n|soleil-dec=50.7\n|soleil-ann=1804.5\n\n<!--Humidité relative (%)-->\n|humidité-jan=89\n|humidité-fev=85\n|humidité-mar=79\n|humidité-avr=74\n|humidité-mai=76\n|humidité-jui=74\n|humidité-jul=72\n|humidité-aou=72\n|humidité-sep=77\n|humidité-oct=84\n|humidité-nov=89\n|humidité-dec=90\n|humidité-ann=80\n\n<!-- PARTIE B : PRÉCIPITATIONS -->\n<!--précipitations mensuelles (en mm) -->\n|prec-jan=55.2\n|prec-fev=49.7\n|prec-mar=51.8\n|prec-avr=47.9\n|prec-mai=65.8\n|prec-jui=47.5\n|prec-jul=52.4\n|prec-aou=45.3\n|prec-sep=49.3\n|prec-oct=57.9\n|prec-nov=60.1\n|prec-dec=54.3\n|prec-ann=637.2\n\n}}\n<!-- FIN DE TABLEAU DE DONNÉES MÉTÉO -->\n\nLe tableau ci-dessous permet de comparer l'ensoleillement du vignoble orléanais à celui d'autres régions françaises :\n\n{| border=\"0\"\n| valign=\"center\" width=\"70%\" |\n{{Météo France\n|Ville=Orléans\n|SoleilVille=1804\n|PluieVille=637\n|NeigeVille=\n|OrageVille=\n|BrouillardVille=\n}}\n|}\n\nLes données relevées à la station de Bricy peuvent néanmoins présenter plusieurs biais potentiels par rapport aux véritables conditions rencontrées dans le vignoble. En effet, la station est située à {{unité|125|mètres}} d'altitude, au nord de la Loire et au sud de la région naturelle de [[Beauce (France)|Beauce]] alors que l'aire d'appellation d'orléans-cléry est localisée entre 82 et {{unité|109|mètres}} d'altitude au sud du fleuve, dans le val de Loire, au contact du nord de la [[Sologne]]. Dès lors, les stations manuelles de niveau 4, situées à [[Baule]], [[Orléans-la-Source]] et Saint-Hilaire-Saint-Mesmin<ref>{{Lien web|url=http://climatheque.meteo.fr/aide/climatheque/reseauPostes/pdf/dep45.pdf |titre=Station météorologique en service dans le département du Loiret |site=[http://climatheque.meteo.fr climatheque.meteo.fr] |année=3 mars 2011 |éditeur=Météo France et Institut géographique national |consulté le=18 mars 2011 }}</ref> ainsi que la station du réseau des stations amateurs en ligne d'Infoclimat de [[Saint-Cyr-en-Val]]<ref>{{Lien web|url=http://www.infoclimat.fr/stations-meteo/index.php?s=00045 |titre=Station météo de Saint-Cyr-en-Val |site=[http://www.infoclimat.fr www.infoclimat.fr] |année= |éditeur=Association Infoclimat |consulté le=18 mars 2011 }}</ref> peuvent également être informatives quant aux conditions météorologiques rencontrées sur le vignoble.\n\n{| border=\"0\"\n| valign=\"top\" width=\"50%\" |\n{| border=\"0\" align=\"center\" style=\"border: 1px solid #999; background-color:#FFFFFF\"  text-align: \"center\"; cellspacing=\"3px\" cellpadding=\"10px\"\n|-align=\"center\" bgcolor=\"#CCCCCC\"\n! colspan=3 | Altitudes (en mètres) rencontrées<br />dans les communes de l'aire d'appellation\n|-\n! Communes !! min. !! max.\n|-\n| [[Cléry-Saint-André]]<ref group=\"A\">{{Lien web|url=http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=22231|titre=Cléry-Saint-André|consulté le=18 mars 2011}}</ref> || 84 || 107  \n|-\n| [[Mareau-aux-Prés]]<ref group=\"A\">{{Lien web|url=http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=21114|titre=Mareau-aux-Prés|consulté le=18 mars 2011}}</ref> || 82 || 103 \n|-\n| [[Mézières-lez-Cléry]]<ref group=\"A\">{{Lien web|url=http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=22443|titre=Mézières-lez-Cléry|consulté le=18 mars 2011}}</ref> || 91 || 108 \n|-\n| [[Olivet (Loiret)|Olivet]]<ref group=\"A\">{{Lien web|url=http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=25536|titre=Olivet|consulté le=18 mars 2011}}</ref> || 89 || 109 \n|-\n| [[Saint-Hilaire-Saint-Mesmin]]<ref group=\"A\">{{Lien web|url=http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=32290|titre=Saint-Hilaire-Saint-Mesmin|consulté le=18 mars 2011}}</ref> || 87 || 105\n|-\n! colspan=3 | <small>min. : altitude minimum ; max. : altitude maximum</small>\n|}\n| valign=\"top\" width=\"50%\" |\n{| border=\"0\" align=\"center\" style=\"border: 1px solid #999; background-color:#FFFFFF\"  text-align: \"center\"; cellspacing=\"3px\" cellpadding=\"10px\"\n|-align=\"center\" bgcolor=\"#CCCCCC\"\n! colspan=4 | Caractéristiques des stations météorologiques<br />situées à proximité de l'aire d'appellation\n|-\n! Stations !! type !! alt. !! km\n|-\n| [[Baule]] || 4 || ? || 11\n|-\n| [[Bricy]] || 0 || 125 || 17\n|-\n| [[Orléans-la-Source]] || 4 || ? || 9\n|-\n| [[Saint-Cyr-en-Val]] || <small>amateur</small> || 96 || 12\n|-\n| [[Saint-Hilaire-Saint-Mesmin]] || 4  || ? || 3\n|-\n! colspan=4 | <small>alt. : altitude ; km : distance en kilomètres<br />par rapport au centre de l'aire d'appellation</small>\n|}\n|}\n\n== Vignoble ==\n[[Fichier:Carte vignoble vallee de la loire.png|thumb|300px|Carte du [[vignoble de la vallée de la Loire]]. Les appellations orléans et orléans-cléry apparaissent en rose dans la région septentrionale de la Loire]]\nLa surface exploitée de l'aire d'appellation est de {{unité|28|[[hectare]]s}}<ref name=\"Guide Hachette\"/>. Le vignoble est situé sur le cours de la [[Loire (fleuve)|Loire]] entre les vignobles de [[Touraine (AOC)|Touraine]] (à l'ouest) et de Centre-Loire (au sud-est).\n\n=== Géographie ===\nCinq communes productrices peuvent prétendre à l'appellation orléans-cléry<ref group=\"Notes\" name=\"AO\"/>, trois du [[canton de Cléry-Saint-André]], à savoir [[Cléry-Saint-André]], [[Mareau-aux-Prés]] et [[Mézières-lez-Cléry]], et deux du [[canton d'Olivet]], à savoir [[Olivet (Loiret)|Olivet]] et [[Saint-Hilaire-Saint-Mesmin]]. Ces communes sont toutes situées dans l'[[arrondissement d'Orléans|arrondissement]] et l'[[aire urbaine d'Orléans|aire urbaine]] d'Orléans du département du [[Loiret (département)|Loiret]]<ref name=\"Légifrance2\"/>{{,}}<ref>[http://www.inao.gouv.fr/repository/editeur/pdf/Cartes/AOC_OrleansClery_A_12062009.pdf Carte de l'aire d'appellation], disponible sur le site [http://www.inao.gouv.fr/ inao.gouv.fr].</ref>.\n\nLes parcelles, très dispersées, se trouvent dans le [[val de Loire]], sur le coteau en pente douce de la rive gauche de la [[Loire (fleuve)|Loire]], à une altitude d'environ {{unité|100|mètres}}, au milieu de vergers, à la limite avec le massif boisé de la [[Région naturelle de France|région naturelle]] de [[Sologne]].\n\n=== Encépagement ===\nLe nombre de pieds à l'hectare doit au moins être égal à {{formatnum:5000}}, chacun d'entre eux devant être espacé d'au moins un mètre, tout en respectant un écartement entre les rangs de deux mètres au maximum. Le pourcentage de pieds de vigne morts ou manquants ne doit pas dépasser 20 %<ref name=\"Légifrance2\"/>.\n\nLes raisins issus des jeunes vignes peuvent bénéficier de l'AOC à partir de la deuxième année suivant celle au cours de laquelle la plantation a été réalisée<ref name=\"Légifrance2\"/>.\n\nLe cépage utilisé majoritairement est le [[cabernet franc]] N<ref name=\"Légifrance2\"/>{{,}}<ref group=\"Notes\" name=\"cep\"/>.\n\nÀ titre transitoire, les parcelles encore plantées en [[cabernet sauvignon]] N en [[2006]] {{citation|continuent à bénéficier pour leur récolte du droit à l'appellation d'origine contrôlée, en qualité de cépage accessoire, jusqu'à la récolte 2020 incluse. La proportion de ce cépage ne peut pas être supérieure à 25 % de l'encépagement}}<ref name=\"Légifrance2\"/>.\n\nLe cabernet franc N est un [[cépage]] largement utilisé dans le [[vignoble de Bordeaux]] et dans le [[vignoble de la vallée de la Loire]].\n\n<gallery>\nImage:Cab Franc grape.JPG|Grappe de [[cabernet franc]] N.\nImage:Cabernet Franc Weinsberg 20060909.jpg|Grappe de [[cabernet franc]] N sur pied.\nImage:Cab franc leaf.JPG|Feuille du [[cabernet franc]] N.\n</gallery>\n\n=== Méthodes culturales ===\n==== Travail manuel ====\nCe travail commence par la [[Taille de la vigne|taille]] : en guyot simple, le cep portant un long bois à sept yeux francs au maximum et un ou deux coursons à un ou deux yeux francs ; en [[guyot double]] courte avec deux taquets à quatre yeux francs maximum. Le nombre d'yeux francs par pied ne doit pas excéder dix<ref name=\"Légifrance2\"/>.\n\nLe tirage des sarments suit la taille. Les sarments sont enlevés et peuvent être brûlés ou mis au milieu du rang pour être broyés. On passe ensuite aux réparations ou éventuellement des plantations de greffes. L'[[ébourgeonnage]] peut débuter dès que la vigne a commencé à pousser. Cette méthode permet, en partie, de réguler les rendements<ref name=\"VITI\">''Conduite et gestion de l'exploitation agricole'', cours de viticulture du lycée viticole de Beaune (1999-2001), Baccalauréat professionnel option viticulture-œnologie.</ref>. Le « relevage » est pratiqué lorsque la [[vigne]] commence à avoir bien poussé. En général, deux à trois relevages sont pratiqués. Pour finir avec le travail manuel à la vigne, se réalise l'étape importante des [[vendange]]s.\n\n==== Travail mécanique ====\nL'[[enjambeur]] est d'une aide précieuse. Les différents travaux se composent du broyage des sarments ; de trou fait à la tarière, là où les pieds de vignes sont manquants ; de [[labour]]age ou « griffage », réalisé dans le but d'aérer les sols et de supprimer des mauvaises herbes<ref name=\"VITI\"/> ; de [[Désherbage (agriculture)|désherbage]] ; de plusieurs [[Traitement de la vigne|traitements]] des vignes, réalisés dans le but de les protéger contre certaines maladies cryptogamiques (dues à des champignons : [[mildiou]], [[oïdium]] et [[pourriture grise]])<ref name=\"VITI\"/> ; de plusieurs rognages consistant à « reciper » ou couper les branches de vignes (rameaux) qui dépassent du système de palissage ; des vendanges mécaniques se réalisant avec une [[machine à vendanger]] ou une tête de récolte montée sur un enjambeur.\n\n=== Récolte ===\nLors de la récolte, les raisins doivent présenter une richesse en sucre inférieure à 162 grammes par litre de [[moût]].\n\n=== Rendements ===\nLe [[Rendement viticole|rendement]] est limité à 50 hectolitres par hectare, avec un rendement butoir à 55 hectolitres par hectare et un rendements maximum de production fixé à 65 hectolitres par hectare<ref name=\"Légifrance2\"/>.\n\nLe rendement réel est largement inférieur, le rendement moyen pour l'ensemble de l'appellation en [[2009]] était en effet de 30,3 hectolitres par hectare<ref name=\"Guide Hachette\"/>{{,}}<ref group=\"Notes\">Le rendement réel est calculé en divisant le volume de la production par la surface exploitée, soit 848 / 28 = 30,29 hectolitres par hectare.</ref>.\n\n== Vins ==\n=== Vinification et élevage ===\n{{article détaillé|vin_rouge#Vinification{{!}}vinification du vin rouge}}\nLa [[Vendange|récolte]] des raisins se fait à maturité et de façon manuelle ou mécanique. La vendange manuelle est parfois triée, soit à la vigne soit à la cave avec une table de tri, ce qui permet d'enlever les grappes pourries ou insuffisamment mûres<ref name=\"VITI\"/>. La vendange manuelle est généralement [[Éraflage|éraflée]] puis mise en [[cuve]].\n\nUne macération pré-fermentaire à froid est quelquefois pratiquée. La [[fermentation alcoolique]] peut démarrer, le plus souvent après un levurage. Commence alors le travail d'extraction des [[polyphénol]]s (tanins, anthocyanes) et autres éléments du raisin. L'extraction se faisait par [[vinification|pigeage]], opération qui consiste à enfoncer le chapeau de marc dans le jus en fermentation. Plus couramment, l'extraction est conduite aussi par des remontages, opération qui consiste à pomper le jus depuis le bas de la cuve pour arroser le chapeau de marc et ainsi lessiver les composants qualitatifs du raisin.\n\nLes températures de fermentation alcoolique peuvent être plus ou moins élevées, avec une moyenne générale de 28 à 35&nbsp;°C au maximum de la fermentation. La [[chaptalisation]] est réalisée si le degré naturel est insuffisant : cette pratique est réglementée. À l'issue de la fermentation alcoolique suit l'opération de décuvage qui donne le [[vin de goutte]] et le [[vin de presse]]. La [[fermentation malolactique]] se déroule après mais est dépendante de la température<ref name=\"VITI\"/>. À la fin de la fermentation malolactique, la teneur en acide malique doit être inférieure ou égale à 0,3 gramme par litre. De plus, la teneur en sucres fermentescibles ([[glucose]] et [[fructose]]) doit être inférieure ou égale à 2 grammes par litre<ref name=\"Légifrance2\"/>. Le vin est soutiré et mis en [[fût (récipient)|fût]] ou cuve pour son [[élevage du vin|élevage]]. L'élevage se poursuit pendant plusieurs mois, puis le vin est collé, filtré et mis en bouteilles<ref name=\"VITI\"/>.\n\nEn plus des cinq communes de l'aire d'appellation, une aire de proximité immédiate où la vinification de l'orléans-cléry est également autorisée a été définie, elle couvre le territoire des communes suivantes : [[Ardon (Loiret)|Ardon]], [[Baule]], [[Beaugency]], [[Bou]], [[Chaingy]], [[Chécy]], [[Combleux]], [[Dry (Loiret)|Dry]], [[Huisseau-sur-Mauves]], [[Jouy-le-Potier]], [[Lailly-en-Val]], [[Mardié]], [[Messas]], [[Meung-sur-Loire]], [[Orléans]], [[Saint-Ay]], [[Saint-Jean-de-Braye]], [[Saint-Pryvé-Saint-Mesmin]], [[Semoy (Loiret)|Semoy]], [[Tavers]] et [[Villorceau]]<ref name=\"Légifrance2\"/>.\n\n=== Gastronomie ===\nLes vins sont en général simples, francs et fruités. Ils sont à boire rapidement, dans les 2 à 5 ans suivant leur mise en bouteille.\n\n=== Récompenses ===\nLes vins de l'appellation ayant été primés au [[concours général agricole]] sont les suivants : le clos Saint-Fiacre, médailles d'or (2003, 2004), d'argent (2006) et de bronze (2009) ; le domaine Saint-Avit, médailles d'argent (2003, 2005, 2008), les vignerons de la Grand'maison, médailles d'or (2007) et d'argent (2009), le vignoble du chant des oiseaux, médailles d'or (2005) et de bronze (2006)<ref>{{Lien web|url=http://www.concours-agricole.com/palmares_departement.aspx |titre=Concours général agricole, les palmarès par année et par département |site=[http://www.concours-agricole.com www.concours-agricole.com] |année=2004-2011 |éditeur=SAS Comexposium |consulté le=22 mars 2011 }}</ref>.\n\n== Économie ==\n[[Fichier:Cave coopérative, Mareau-aux-Prés, Loiret, Centre, France.jpg|thumb|upright=1.4|La cave coopérative à [[Mareau-aux-Prés]] portant la date de [[1931]] sur son fronton.]]\n=== Structure des exploitations ===\nUne partie de la production est faite par [[Domaine viticole|domaines]] de petites tailles. Ces domaines mettent tous leurs vins en bouteilles et les commercialisent.\n\nUne [[cave coopérative de vinification]] (Les vignerons de la Grand'maison) regroupe quelques producteurs qui lui confient leurs récoltes.\n\nLa plupart des producteurs maintiennent leur exploitation en [[polyculture]]<ref>{{Lien web|url=http://www.lepoint.fr/archives/article.php/15908 |titre=Le vin d'Orléans reprend du galon |site=[http://www.lepoint.fr www.lepoint.fr] |auteur=[[Laure Gasparotto]] |année=26 octobre 2006 |éditeur=Le Point |consulté le=15 mars 2011 }}</ref>.\n\n=== Commercialisation ===\nLa commercialisation de l'appellation est très limitée, du fait de sa production très restreinte et de sa faible notoriété<ref>{{Lien web|url=http://www.tribune-orleans.fr/Economie/Vins-dOrleans-un-business-limite-en-quete-de-notoriete.html |titre=Vins d’Orléans : un business limité en quête de notoriété |site=[http://www.tribune-orleans.fr www.tribune-orleans.fr] |auteur=Charles Centofanti |année=24 septembre 2009 |éditeur=La Tribune d'Orléans |consulté le=15 mars 2011 }}</ref>.\n\nLes caveaux des viticulteurs écoulent directement une partie de la production, complétée par les [[Salon (évènementiel)|salons]] des vins (notamment celui des [[Vignerons indépendants de France]]), les [[Foire (économie)|foires]], [[Café (établissement)|cafés]], [[hôtel]]s, [[restaurant]]s et [[Grande distribution|supermarchés]] locaux.\n\n=== Liste de producteurs ===\nLes petites surfaces cultivées expliquent le petit nombre de producteurs<ref group=\"Notes\">Cette liste de producteurs a été modifié en mars 2011 ; elle est à compléter.</ref> :\n*Clos Saint-Fiacre (famille Montigny-Piel), à [[Mareau-aux-Prés]]<ref>{{Lien web|url=http://www.clossaintfiacre.fr |titre=Clos Saint-Fiacre |site=[http://www.clossaintfiacre.fr www.clossaintfiacre.fr] |année= |éditeur= |consulté le=13 mars 2011 }}</ref> ;\n*Domaine Saint-Avit (Pascal Javoy), à [[Mézières-lez-Cléry]]<ref>{{Lien web|url=http://www.javoy.com |titre=Javoy père et fils |site=[http://www.javoy.com www.javoy.com] |année= |éditeur= |consulté le=13 mars 2011 }}[ ].</ref> ;\n*Les vignerons de la Grand'maison, à [[Mareau-aux-Prés]] ;\n*Vignoble du Chant d'Oiseaux (Édouard Montigny), à [[Mareau-aux-Prés]]<ref>{{Lien web|url=http://www.vignobleduchantdoiseaux.com |titre=Vignoble du chant des oiseaux |site=[http://www.vignobleduchantdoiseaux.com www.vignobleduchantdoiseaux.com] |année= |éditeur= |consulté le=13 mars 2011 }}</ref> ;\n*Domaine Pèlerin (David Parou), à [[Mareau-aux-Prés]].\n\n== Notes et références ==\n=== Notes ===\n{{Références|groupe=Notes}}\n\n=== Références ===\n{{Références|colonnes=2}}\n\n* Altitudes des communes sur ''[http://cassini.ehess.fr Des villages de Cassini aux communes d'aujourd'hui]'', site de l'École des hautes études en sciences sociales :\n{{Références|groupe=\"A\"|colonnes=3}}\n\n* {{ouvrage|langue=fr|prénom1=André|nom1=Jullien|lien auteur1=André Jullien (vin)|titre=Topographie de tous les vignobles connus contenant|sous-titre=leur position géographique, l'indication du genre et de la qualité des produits de chaque cru, les lieux où se font les chargements et le principal commerce de vin, le nom et la capacité des tonneaux et des mesures en usage, les moyens de transport ordinairement employés, suivie d'une classification générale de vins|numéro d'édition=1|éditeur=L'Auteur, Madame Huzard, L. Colas|lien éditeur=|lieu=Paris|jour=|mois=|année=1816|volume=|tome=|pages totales=566|passage=80-85 :|isbn=|lire en ligne=https://books.google.fr/books?id=xvs6AAAAcAAJ|consulté le=23 mars 2011}}\n{{Références|groupe=\"B\"|colonnes=4}}\n\n== Voir aussi ==\n=== Bibliographie ===\n* {{ouvrage|langue=fr|prénom1=Simon|nom1=Rouzeau|lien auteur1=|titre=L'Hercule guespin, ou l'hymne du vin d'Orléans |sous-titre=à monsieur d'Escures, conseiller du Roy, maréchal général des logis de ses armées, commissaire ordinaire des guerres et intendant des levées et turcies de Loyre et Cher|numéro d'édition=|éditeur=Saturnin Hotot, imprimeur ordinaire du Roy|lien éditeur=|lieu=Orléans|jour=|mois=|année=1605|volume=|tome=|pages totales=31|passage=|isbn=|lire en ligne=http://gallica.bnf.fr/ark:/12148/bpt6k72266c|consulté le=18 mars 2011}}\n* {{article|langue=fr|prénom1=André|nom1=Linglois|lien auteur1=|titre=Le vin orléanais dans les textes littéraires, du haut Moyen Âge au {{s-|XVIII}}|périodique=Bulletin de la société archéologique et historique de l'Orléanais|éditeur=[[Société archéologique et historique de l'Orléanais]]|volume=15|numéro=123|jour=|mois=|année=1999|pages=43-68.|issn=|url texte=|consulté le=}}\n* {{article|langue=fr|prénom1=Christian|nom1=Poitou|titre=Le phylloxéra et ses conséquences pour les viticulteurs du Loiret (1870-1910)|périodique=Bulletin de la société archéologique et historique de l'Orléanais|éditeur=[[Société archéologique et historique de l'Orléanais]]|volume=21|numéro=170|jour=|mois=|année=2013|pages=117-123.|issn=|url texte=|consulté le=}}\n\n=== Liens internes ===\n* [[Économie du Loiret]]\n\n{{Palette|Vignoble de la vallée de la Loire}}\n\n{{Portail|vin|Loiret}}\n\n{{DEFAULTSORT:Orleans-clery (AOC)}}\n[[Catégorie:Vin AOC dans le Loiret]]\n[[Catégorie:Vignoble du Val-de-Loire]]\n[[Catégorie:Vignoble de la vallée de la Loire]]","properties":{"defaultsort":"Orleans-clery (AOC)","wikibase_item":"Q3356495"},"parsetree":"<root><template><title>Infobox Région viticole\n </title><part><name> nom               </name><equals>=</equals><value> Orléans-cléry\n </value></part><part><name> charte             </name><equals>=</equals><value> rouge\n </value></part><part><name> image             </name><equals>=</equals><value> AOC Orléans-cléry vignoble.JPG\n </value></part><part><name> légende           </name><equals>=</equals><value> Vignoble de l'AOC orléans-cléry à [[Mareau-aux-Prés]].\n </value></part><part><name> appellations      </name><equals>=</equals><value> orléans-cléry<ext><name>ref</name><attr> group=&quot;Notes&quot; name=&quot;AO&quot;</attr></ext>\n </value></part><part><name> typeappellation   </name><equals>=</equals><value> [[appellation d'origine contrôlée|AOC]]-[[appellation d'origine protégée|AOP]]<ext><name>ref</name><attr> name=&quot;inao&quot;</attr><inner>{{Lien web|url=http://www.inao.gouv.fr/public/produits/detailProduit.php?ID_PRODUIT=5301 |titre=Orléans-Cléry |site=[http://www.inao.gouv.fr www.inao.gouv.fr] |année=10 mars 2011 |éditeur=[[Ministère de l'agriculture (France)|Ministère de l'agriculture]]. [[Institut national de l'origine et de la qualité]] |consulté le=17 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext>\n</value></part><part><name> année             </name><equals>=</equals><value> [[2006]]<ext><name>ref</name><attr> name=&quot;Légifrance1&quot;</attr><inner>{{Légifrance | base=JORF | numéro=AGRP0602138D | texte=Décret du 23 novembre 2006 }} relatif à l'appellation d'origine contrôlée &quot;Orléans-Cléry&quot;. {{Lien web|url=http://www.legifrance.gouv.fr |titre=www.legifrance.gouv.fr |année=2006 |éditeur=Secrétariat général du gouvernement français |consulté le=17 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext>\n </value></part><part><name> pays              </name><equals>=</equals><value> <template><title>France</title></template>\n </value></part><part><name> région-mère       </name><equals>=</equals><value> [[Vignoble de la vallée de la Loire|vallée de la Loire]]\n </value></part><part><name> similaire         </name><equals>=</equals><value> \n </value></part><part><name> sous-régions      </name><equals>=</equals><value> [[Orléanais]]\n </value></part><part><name> localisation      </name><equals>=</equals><value> [[Loiret (département)|Loiret]]\n </value></part><part><name> saison            </name><equals>=</equals><value> \n </value></part><part><name> climat            </name><equals>=</equals><value> [[Climat tempéré|tempéré]] [[Climat océanique|océanique]] dégradé\n </value></part><part><name> jourssoleil       </name><equals>=</equals><value> <template><title>unité</title><part><name index=\"1\"/><value>1804</value></part><part><name index=\"2\"/><value>heures</value></part></template>/an<ext><name>ref</name><attr> name=&quot;infoclimat&quot;</attr></ext>\n </value></part><part><name> sol               </name><equals>=</equals><value> [[argile|argilo]]-[[silice|siliceux]] et [[Grave (terrain)|gravelo]]-[[silice|siliceux]]\n </value></part><part><name> superficietotale  </name><equals>=</equals><value> \n </value></part><part><name> superficieplantée </name><equals>=</equals><value> 28 [[hectare]]s<ext><name>ref</name><attr> name=&quot;Guide Hachette&quot;</attr><inner>{{ouvrage|langue=fr|prénom1=|nom1=Collectif|lien auteur1=|titre=Le guide Hachette des vins 2011 |sous-titre=des vins pour tous les goût, à tous les prix|numéro d'édition=|éditeur=Hachette livre|lien éditeur=|lieu=Paris|mois=août|année=2010|pages totales=1402|passage=1050|isbn=978-2-01-237681-6|consulté le=17 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext>\n </value></part><part><name> exploitations     </name><equals>=</equals><value> 23 viticulteurs et 6 vinificateurs<ext><name>ref</name><attr> name=&quot;inao&quot;</attr></ext>\n </value></part><part><name> cépages           </name><equals>=</equals><value> [[cabernet franc]] N<ext><name>ref</name><attr> group=&quot;Notes&quot; name=&quot;cep&quot;</attr><inner>Le code international d'écriture des cépages mentionne la couleur du raisin de la manière suivante : B = blanc, N = noir, Rs = rose, G = gris.</inner><close>&lt;/ref&gt;</close></ext><template><title>,</title></template><ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr><inner>{{pdf}} {{lien web|url=http://agriculture.gouv.fr/IMG/pdf/AOC_SOMM44.pdf |titre=Cahier des charges de l'appellation |site=http://agriculture.gouv.fr/ }}, homologué par le {{article|titre={{Légifrance | base=JORF | numéro=AGRT1114927D | texte=décret {{n°}}2011-1399 du 26 octobre 2011 }} relatif à l'appellation d'origine contrôlée « Orléans-Cléry » |périodique=JORF |lien périodique=Journal officiel de la République française |numéro=0252 |jour=29 |mois=octobre |année=2011 |passage=18279}}.</inner><close>&lt;/ref&gt;</close></ext>\n </value></part><part><name> vins              </name><equals>=</equals><value> [[Vin rouge|rouges]]\n </value></part><part><name> volproduction     </name><equals>=</equals><value> <template><title>unité</title><part><name index=\"1\"/><value>848</value></part><part><name index=\"2\"/><value>hectolitres</value></part></template> en [[2009]]<ext><name>ref</name><attr> name=&quot;Guide Hachette&quot;</attr></ext>\n </value></part><part><name> densité           </name><equals>=</equals><value> minimum de <template><title>unité</title><part><name index=\"1\"/><value>5000</value></part><part><name index=\"2\"/><value>pieds</value></part></template> par hectare<ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext>\n </value></part><part><name> rendement         </name><equals>=</equals><value> maximum 50 à <template><title>unité</title><part><name index=\"1\"/><value>65</value></part><part><name index=\"2\"/><value>hectolitres</value></part></template> par hectare<ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext>\n</value></part></template>\nL’'''orléans-cléry'''<ext><name>ref</name><attr> group=&quot;Notes&quot; name=&quot;AO&quot;</attr><inner>[[Appellation d'origine#Grammaire|Références sur la façon d'orthographier les appellations d'origine]].</inner><close>&lt;/ref&gt;</close></ext> est un [[vin rouge]] [[France|français]] d'[[appellation d'origine contrôlée]] (AOC) et d'[[appellation d'origine protégée]] (AOP) produit dans le [[département français|département]] du [[Loiret (département)|Loiret]] ([[Région française|région]] [[Centre-Val de Loire]]).\n\nL'appellation concerne le territoire de cinq [[commune (France)|communes]] située à l'ouest de la ville d'[[Orléans]] sur la rive gauche de la [[Loire (fleuve)|Loire]] : [[Cléry-Saint-André]], [[Mareau-aux-Prés]], [[Mézières-lez-Cléry]], [[Olivet (Loiret)|Olivet]] et [[Saint-Hilaire-Saint-Mesmin]]<ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext>. Elle se trouve au sein d'une autre appellation plus vaste, celle d'[[orléans (AOC)|orléans]].\n\nL'orléans-cléry, obtenue en [[2006]]<ext><name>ref</name><attr> name=&quot;Légifrance1&quot;</attr></ext>, est l'une des trois [[Appellation d'origine contrôlée|AOC]] viticoles de l'[[Orléanais]] avec l'[[Orléans (AOC)|orléans]] et les [[coteaux-du-giennois]].\n\n<h level=\"2\" i=\"1\">== Histoire ==</h>\n[[Fichier:Hercule Guespin Hymne du vin d'Orléans 1605.jpg|thumb|Page de couverture de l'ouvrage du poète Simon du Rouzeau, 1605]]\n<h level=\"3\" i=\"2\">=== Moyen Âge ===</h>\nIl semble que les [[moine]]s de l'[[abbaye Saint-Mesmin de Micy]] aient produit du vin dès le début du <template><title>s</title><part><name index=\"1\"/><value>VI</value></part></template>. À la même époque, [[Grégoire de Tours]] mentionne la présence de [[viticulture]] dans la [[anciennes provinces de France|province]] de l'[[Orléanais]]<ext><name>ref</name><attr> name=&quot;inao&quot;</attr></ext>.\n\nAu <template><title>s</title><part><name index=\"1\"/><value>XIII</value></part></template>, le roi de France [[Louis IX de France|Saint Louis]], fait exploiter par son personnel un vignoble à [[Chécy]]<ext><name>ref</name><attr/><inner>{{ouvrage|langue=fr|prénom1=|nom1=Boucher de Molandon|lien auteur1=|titre=Première expédition de Jeanne d'Arc |sous-titre=le ravitaillement d'Orléans|numéro d'édition=|éditeur=Herluison|collection=Mémoires de la Société archéologique et historique de l'Orléanais|lieu=Orléans|jour=|mois=|année=1876|volume=|tome=15|pages totales=550|passage=99|isbn=|lire en ligne=http://gallica.bnf.fr/ark:/12148/bpt6k5544845w/f123|consulté le=5 avril 2011}}</inner><close>&lt;/ref&gt;</close></ext>.\n\n<h level=\"3\" i=\"3\">=== Époque moderne ===</h>\nDurant l'[[époque moderne]] et pour diverses raisons, le vignoble connait une importante extension, sous forme de quasi-[[monoculture]] de [[Châteauneuf-sur-Loire]] à l'est jusqu'à [[Beaugency]] à l'ouest. Le [[Domaine royal français]], très restreint à l'époque, se tourne donc naturellement vers le vignoble orléanais. De plus, ce dernier est chargé d'approvisionner la ville de [[Paris]] en vin. En effet, en 1577, le Parlement de Paris promulgue une loi interdisant aux Parisiens l'achat de vins produits à moins de 90 kilomètres de la capitale, la production orléanaise est alors augmentée pour satisfaire la demande. Le transport du vin vers la capitale en grande quantité est favorisé par la courte distance (133 kilomètres) sur terrain plat, le [[Pavé|pavage]] de la route de bout en bout dès 1577 (tronçon de l'actuelle [[Route nationale 20 (France)|route nationale 20]]) et la construction du [[canal de Briare]] ouvert en [[1642]] (reliant la [[Loire (fleuve)|Loire]] à la [[Seine]] par la vallée du [[Loing]]). L'augmentation de la production s'effectue au détriment de la qualité<ext><name>ref</name><attr> name=&quot;inao&quot;</attr></ext>.\n\nIl semble que la table royale s'approvisionne en [[Vignoble de la vallée de la Loire|vins de la vallée de la Loire]] jusqu'au <template><title>XVIe siècle</title></template>. Pour tenter de limiter la consommation excessive qu'en fait [[Henri IV de France|Henri IV]], roi de France de [[1589]] à [[1610]], son médecin et conseiller [[Joseph du Chesne]] écrit en [[1606]] dans son ''pourtraict de la santé'' : <template><title>citation</title><part><name index=\"1\"/><value>le vin de [[Coucy|Coussy]] et d'[[Ay (Marne)|Hay]] et semblables ont même été trouvés meilleurs que ceux d'Orléans qui sont fumeux et qui donnent à la tête. C'est pourquoi ont fait prêter serment à tous les maîtres d'hôtel du Roy à leur réception en telle charge de ne faire servir pour la bouche du Roy des vins d'Orléans, bien que d'ailleurs, ils sont mis au nombre des bons vins quant au goût</value></part></template><ext><name>ref</name><attr/><inner>{{ouvrage|langue=fr|prénom1=Joseph|nom1=Duchesne|lien auteur1=Joseph Duchesne|titre=Le pourtraict de la santé où est au vif représentée la règle universelle et particulière, de bien sainement et longuement vivre |sous-titre=enrichis de plusieurs préceptes, raisons et beaux exemples, tirés des médecins, philosophes et historiens, tant grecs que latins, les plus célèbres|éditeur=chez Claude Morel|lieu=Paris|année=1606|pages totales=595|passage=221|lire en ligne=https://books.google.fr/books?id=CUcemq8P94IC|consulté le=17 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext> La cour semble délaisser peu à peu le vin orléanais sous [[Louis XIII de France|Louis XIII]] qui règne de [[1610]] à [[1643]]<ext><name>ref</name><attr/><inner>{{ouvrage|langue=fr|prénom1=Octave|nom1=Pradels|lien auteur1=|titre=Le vin et la chanson |sous-titre=|numéro d'édition=|éditeur=Flammarion|lien éditeur=|lieu=Paris|jour=|mois=|année=1913|volume=|tome=|pages totales=|passage=236|isbn=|lire en ligne=http://gallica.bnf.fr/ark:/12148/bpt6k56525250/f246|consulté le=19 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext>.\nL'avis du roi est suivi par l'[[aristocratie]] qui à son tour opte pour les [[Vignoble de Champagne|vins de Champagne]] puis [[Vignoble de Bourgogne|de Bourgogne]], ce qui a pour effet de spécialiser l'Orléanais dans la production de vins médiocres et bon marché.\n\n[[Fichier:Manière de bien cultiver la vigne dans le vignoble d'Orléans 1712.jpg|thumb|left|Page de couverture de l'ouvrage du chanoine  Boullay, 1712]]\nLe premier quart du <template><title>XVIIIe siècle</title></template> est marqué par la publication de trois éditions<ext><name>ref</name><attr> group=&quot;Notes&quot;</attr><inner>La date de la première édition de l'ouvrage du chanoine orléanais Jacques Boullay ''Manière de bien cultiver la vigne dans le vignoble d'Orléans'' n'est pas précisément connue, les deux autres datent de [[1712]] et [[1723]].</inner><close>&lt;/ref&gt;</close></ext> de l'ouvrage du [[chanoine]] orléanais Jacques Boullay de Saint-Pierre-Ampon intitulé ''Manière de bien cultiver la vigne dans le vignoble d'Orléans''<ext><name>ref</name><attr/><inner>{{ouvrage|langue=fr|prénom1=Jacques|nom1=Boullay|lien auteur1=|titre=Manière de bien cultiver la vigne dans le vignoble d'Orléans |sous-titre=beaucoup plus amples et plus exacte que la précédente|numéro d'édition=2|éditeur=François Borde|lien éditeur=|lieu=Orléans|jour=|mois=|année=1712|volume=|tome=|pages totales=206|passage=|isbn=|lire en ligne=https://books.google.fr/books?id=38s6AAAAcAAJ|consulté le=19 mars 2011}} ; {{ouvrage|langue=fr|prénom1=Jacques|nom1=Boullay|lien auteur1=|titre=Manière de bien cultiver la vigne, de faire la vendange et le vin dans le vignoble d'Orléans|sous-titre=utile à tous les autres vignobles du royaume où l'on donne les moyens de prévenir et de découvrir les friponneries des mauvais vignerons|numéro d'édition=3|éditeur=J. Rouzeau|lien éditeur=|lieu=Orléans|jour=|mois=|année=1723|volume=|tome=|pages totales=|passage=|isbn=|lire en ligne=|consulté le=}}</inner><close>&lt;/ref&gt;</close></ext>. À cette époque, la qualité du vin orléanais continue de décliner, les classes bourgeoises, propriétaires des vignobles, n'accordent qu'une confiance limitée aux pratiques agricoles des vignerons qui exploitent leurs vignes. Jacques Boullay s'improvise donc professeur et médiateur, en dénonçant les <template><title>citation</title><part><name index=\"1\"/><value>friponneries des mauvais vignerons</value></part></template>. Sa démarche sera très critiquée par les cultivateurs et sa personne s'en trouvera menacée<ext><name>ref</name><attr/><inner>{{ouvrage|langue=fr|prénom1=André|nom1=Bouvier|lien auteur1=|titre=Mémoires de la société archéologique de l'Orléanais |sous-titre=un analyste orléanais peu connu, Jean-François Rozier fils (1762-1854) et les débuts de la Révolution à Orléans d'après des documents inédits |numéro d'édition=|éditeur=Société archéologique de l'Orléanais|lien éditeur=|lieu=Orléans|jour=|mois=|année=1926|volume=|tome=36|pages totales=372|passage=238|isbn=|lire en ligne=http://gallica.bnf.fr/ark:/12148/bpt6k5774582f/f248|consulté le=19 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext>.\n\nDans son ''dictionnaire géographique, historique et politique des Gaules et de la France'' paru en [[1768]], l'abbé [[Louis-Alexandre Expilly de La Poipe]] décrit le vignoble d'Orléans comme l'un des plus vaste de France (dix à onze lieues<ext><name>ref</name><attr> group=&quot;Notes&quot;</attr><inner>La [[lieue]] métrique vaut 4 km.</inner><close>&lt;/ref&gt;</close></ext> d'étendue). Il couvre 25 à 30 communes entre [[Beaugency]] et [[Jargeau]]. Plusieurs vins blancs y sont produits dont notamment le ''Gennetin'' à [[Abbaye Saint-Mesmin de Micy|Saint-Mesmin]] et les vins de [[Marigny-les-Usages|Marigny]] et [[Rebréchien]]. Parmi les vins rouges, surnommés ''Auvernat'' car probablement issu d'un cépage venu d'Auvergne, sont nommés ceux de [[Saint-Denis-en-Val]], [[La Chapelle-Saint-Mesmin|La Chapelle]], Fourneaux et [[Saint-Ay]]<ext><name>ref</name><attr/><inner>{{ouvrage|langue=fr|prénom1=Louis-Alexandre|nom1=Expilly|lien auteur1=Louis-Alexandre Expilly de La Poipe|titre=Dictionnaire géographique, historique et politique des Gaules et de la France|sous-titre=|numéro d'édition=|éditeur=|lien éditeur=|lieu=Amsterdam|jour=|mois=|année=1768|volume=|tome=5|pages totales=1064|passage=327|isbn=|lire en ligne=https://books.google.fr/books?id=__eYqVsFlkIC&amp;pg=PA327|consulté le=24 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext>.\n\nEn [[1770]], le chanoine orléanais, [[Jean-François Colas]] de la [[collégiale Saint-Aignan d'Orléans|collégiale Saint-Aignan]], publie à son tour un traité, ''Le manuel du cultivateur dans le vignoble d'Orléans'', sur un ton plus neutre et moins accusateur<ext><name>ref</name><attr/><inner>{{ouvrage|langue=fr|prénom1=Jean-François|nom1=Colas|lien auteur1=|titre=Le manuel du cultivateur dans le vignoble d'Orléans utile à tous les autres vignobles du royaume |sous-titre=|numéro d'édition=|éditeur=Chez Charles Jacob|lien éditeur=|lieu=Orléans|jour=|mois=|année=1770|volume=|tome=|pages totales=207|passage=|isbn=|lire en ligne=https://books.google.fr/books?id=nesaQwAACAAJ|consulté le=}}</inner><close>&lt;/ref&gt;</close></ext><template><title>,</title></template><ext><name>ref</name><attr/><inner>{{ouvrage|langue=fr|prénom1=André|nom1=Corvol|prénom2=Christine|nom2=Bru-Malgras|lien auteur1=|titre=Forêt et vigne, bois et vin : XVI{{e}}-XX{{e}} siècles. Le savoir-faire ecclésiastique et monastique en matière de vigne et forêt |sous-titre=|numéro d'édition=|éditeur=L'Harmattan|lien éditeur=|lieu=|jour=|mois=|année=2002|volume=|tome=|pages totales=501|passage=192-195|isbn=9782747528269|lire en ligne=https://books.google.fr/books?id=ehOLRK8V5qUC|consulté le=19 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext>.\n\n<h level=\"3\" i=\"4\">=== Époque contemporaine ===</h>\nDès le <template><title>s mini-</title><part><name index=\"1\"/><value>XVIII</value></part><part><name index=\"2\"/><value>e</value></part></template> et jusqu'au milieu du <template><title>XIXe siècle</title></template>, [[Orléans]] devient un [[Port d'Orléans|port fluvial de transit]] pour les vins d'autres régions, de l'amont comme de l'aval ([[Touraine]], [[Anjou]], puis [[Pays nantais]]) de la Loire, mais aussi de Bourgogne et du [[Vignoble du beaujolais|Haut-Beaujolais]] (les actuels crus du Beaujolais). Les vins ayant tourné étaient alors transformés en [[vinaigre]] (« vin aigre »), qui est depuis une des spécialités de la ville.\n<template lineStart=\"1\"><title>Article connexe</title><part><name index=\"1\"/><value>port_d'Orléans#La_vinaigrerie<template><title>!</title></template>vinaigre d'Orléans</value></part></template>\n\nAu début du <template><title>s mini-</title><part><name index=\"1\"/><value>XIX</value></part><part><name index=\"2\"/><value>e</value></part></template>, l'[[œnologue]] français [[André Jullien (vin)|André Jullien]] dans son ouvrage ''Topographie de tous les vignobles connus'' paru en [[1816]] dresse un état des lieux du vignoble orléanais. La superficie des vignobles du département du Loiret est estimée à <template><title>unité</title><part><name index=\"1\"/><value>33000</value></part><part><name index=\"2\"/><value>hectares</value></part></template> pour une récolte de <template><title>unité</title><part><name index=\"1\"/><value>896000</value></part><part><name index=\"2\"/><value>hectolitres</value></part></template> dont <template><title>formatnum:220000</title></template> sont consommés par les autochtones, le reste étant exporté sous l'appellation ''vin d'Orléans''<ext><name>ref</name><attr> group=&quot;B&quot;</attr><inner>{{p.}}80</inner><close>&lt;/ref&gt;</close></ext>. Parmi les vins rouges dits de première classe, on trouve à l'Ouest d'Orléans ceux du lieu-dit Guignes à [[Tavers]], du clos Sainte-Marie à [[Saint-Jean-de-Braye]], de [[La Chapelle-Saint-Mesmin|La Chapelle]], de Saint-Gy, de [[Saint-Ay]], des Fourneaux, de [[Beaugency]], de [[Baule]], de Beaulette et de [[Meung-sur-Loire]]<ext><name>ref</name><attr> group=&quot;B&quot;</attr><inner>{{p.}}81-82</inner><close>&lt;/ref&gt;</close></ext>. À l'Est d'Orléans, on trouve ceux de [[Saint-Denis-en-Val]], [[Combleux]] et [[Sandillon]]<ext><name>ref</name><attr> group=&quot;B&quot;</attr><inner>{{p.}}82</inner><close>&lt;/ref&gt;</close></ext>. Parmi les vins rouges de deuxième classe, on trouve à Orléans ceux de Saint-Marc, Saint-Marceau, Saint-Paterne, à l'Ouest ceux de [[Saint-Pryvé-Saint-Mesmin|Saint-Privé]], au nord ceux de [[Saran]]g, [[Gidy|Gédy]], [[Fleury-les-Aubrais|Fleury]] et [[Semoy (Loiret)|Semoy]], à l'ouest celui d'[[Ingré]], au sud celui d'[[Olivet (Loiret)|Olivet]] et à l'Est ceux de [[Saint-Jean-le-Blanc (Loiret)|Saint-Jean-le-Blanc]], [[Bou]], [[Mardié]], [[Saint-Denis-de-l'Hôtel|Saint-Denis-de-Jargeau]] et [[Jargeau]]<ext><name>ref</name><attr> group=&quot;B&quot;</attr><inner>{{p.}}82-83</inner><close>&lt;/ref&gt;</close></ext>. Parmi les vins blancs, sont cités ceux produits à [[Marigny-les-Usages|Marigny]] et [[Rebréchien]]. Celui de [[Loury]], cité comme un vin de médiocre qualité, sert à la fabrication du vinaigre d'Orléans<ext><name>ref</name><attr> group=&quot;B&quot;</attr><inner>{{p.}}84</inner><close>&lt;/ref&gt;</close></ext>. Les tonneaux utilisés pour stocker le vin d'Orléans sont nommés ''pièce'' ou ''poinçon'' et possèdent une contenance de <template><title>unité</title><part><name index=\"1\"/><value>228</value></part><part><name index=\"2\"/><value>litres</value></part></template><ext><name>ref</name><attr> group=&quot;B&quot;</attr><inner>{{p.}}85</inner><close>&lt;/ref&gt;</close></ext>.\n\nLe développement du réseau de [[chemin de fer|chemins de fer]] au milieu du <template><title>s mini-</title><part><name index=\"1\"/><value>XIX</value></part><part><name index=\"2\"/><value>e</value></part></template> porte un coup fatal à la viticulture de l'Orléanais, permettant l'importation à moindre coût des vins du Midi (produits dans le [[vignoble du Languedoc-Roussillon]]).\n\nOn peut dresser un nouvel état des lieux du vignoble orléanais grâce à l'ouvrage du médecin et physicien français [[Jules Guyot]], ''Étude des vignobles de France : pour servir à l'enseignement mutuel de la viticulture et de la vinification françaises'', paru en [[1868]]. Économiquement parlant, l'exploitation d'un vignoble dans la région d'Orléans est décrite comme rentable si le propriétaire est capable de l'exploiter par lui-même. Un grand-propriétaire qui doit payer un vigneron n'en retire pas de bénéfices considérables. Trois grands types de culture de la vigne sont recensées, l'une sur la rive droite de la Loire, l'une sur la rive gauche et la dernière dans une petite région centrée sur la commune d'Olivet. Dans tout le vignoble, les plants sont organisés en ligne à <template><title>unité</title><part><name index=\"1\"/><value>80</value></part><part><name index=\"2\"/><value>cm</value></part></template> les uns des autres<ext><name>ref</name><attr/><inner>{{ouvrage|langue=fr|prénom1=Jules|nom1=Guyot|lien auteur1=Jules Guyot|titre=Étude des vignobles de France  |sous-titre=pour servir à l'enseignement mutuel de la viticulture et de la vinification françaises. Régions du Centre-Nord, du Nord et du Nord-Ouest |numéro d'édition=|éditeur=Imprimerie impériale|lien éditeur=Imprimerie nationale (France)|lieu=Paris|jour=|mois=|année=1868|volume=|tome=3|pages totales=710|passage=220-232|isbn=|lire en ligne=http://gallica.bnf.fr/ark:/12148/bpt6k1109477/f224|consulté le=24 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext>.\n[[File:Loiret Vendanges en Sologne.jpg|thumb|Vendanges entre Orléans et la Sologne]]\nAprès les ravages causés par le [[phylloxéra]], un puceron ravageur de la vigne, à la fin du <template><title>s mini-</title><part><name index=\"1\"/><value>XIX</value></part><part><name index=\"2\"/><value>e</value></part></template>, très peu de replantations sont faites autour d'Orléans. Les surfaces cultivées disparaissant presque totalement au cours du <template><title>s</title><part><name index=\"1\"/><value>XX</value></part></template> du fait d'une très forte concurrence pour ce type de vin courant.\n\nMalgré tout, quelques producteurs poursuivent une petite production, encadrée à partir de [[1951]] par l'[[appellation d'origine vin délimité de qualité supérieure]] (VDQS) « vin de l'Orléanais »<ext><name>ref</name><attr/><inner>Arrêté du 9 août 1951 relatif aux &quot;vins de l'Orléanais&quot;, définition du droit à l'appellation en application de la loi du 6 mais 1919 relative aux appellations d'origine, publié au [http://www.legifrance.gouv.fr/jopdf/common/jo_pdf.jsp?numJO=0&amp;dateJO=19510823&amp;numTexte=&amp;pageDebut=08990&amp;pageFin= ''JORF'' du 23 août 1951, {{p.}}8990].</inner><close>&lt;/ref&gt;</close></ext>. L'[[Institut national de l'origine et de la qualité]] (INAO) fait reconnaître une appellation VDQS particulière sous le nom d'« orléans-cléry » par l'arrêté du <template><title>date</title><part><name index=\"1\"/><value>14</value></part><part><name index=\"2\"/><value>octobre</value></part><part><name index=\"3\"/><value>2002</value></part></template> publié au [[journal officiel de la République française]] du <template><title>date</title><part><name index=\"1\"/><value>15</value></part><part><name index=\"2\"/><value>novembre</value></part><part><name index=\"3\"/><value>2002</value></part></template><ext><name>ref</name><attr> name=&quot;Légifrance0&quot;</attr><inner>{{Légifrance | base=JORF | numéro=AGRP0202372A | texte=Arrêté du 14 octobre 2002 }} relatif à l'appellation d'origine Vin délimité de qualité supérieure « Orléans-Cléry ». JORF {{n°}}266 du 15 novembre 2002, page 18903, texte {{n°}}46. {{Lien web|url=http://www.legifrance.gouv.fr |titre=www.legifrance.gouv.fr |année=2002 |éditeur=Secrétariat général du gouvernement français |consulté le=17 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext>, avant de le faire passer au statut d'[[appellation d'origine contrôlée]] par le décret du <template><title>date</title><part><name index=\"1\"/><value>23</value></part><part><name index=\"2\"/><value>novembre</value></part><part><name index=\"3\"/><value>2006</value></part></template><ext><name>ref</name><attr> name=&quot;Légifrance1&quot;</attr></ext>, modifié par le décret du <template><title>date</title><part><name index=\"1\"/><value>16</value></part><part><name index=\"2\"/><value>octobre</value></part><part><name index=\"3\"/><value>2009</value></part></template><ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext>.\n\nLe syndicat viticole de l’Orléanais, reconnu dès [[1994]]<ext><name>ref</name><attr/><inner>{{Légifrance | base=JORF | numéro=ECOC9400118A | texte=Arrêté du 10 août 1994}} portant agrément des organismes professionnels chargés de la dégustation des vins de pays. JORF {{n°}}202 du {{1er}} septembre 1994, page 12675. {{Lien web|url=http://www.legifrance.gouv.fr |titre=www.legifrance.gouv.fr |année=1994 |éditeur=Secrétariat général du gouvernement français |consulté le=17 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext> et basé à [[Saint-Hilaire-Saint-Mesmin]] est, depuis [[2007]], chargé de la promotion de l'appellation, s'appuyant entre autres sur la [[confrérie]] vigneronne des chevaliers d'Orléans-Cléry créée à [[Cléry-Saint-André]] et hébergée à la mairie<ext><name>ref</name><attr/><inner>{{Lien web|url=http://www.clery-saint-andre.com/vie-associative/social-culture-et-loisirs/122-confrerie-vigneronne-des-chevaliers-dorleans-clery |titre=Confrérie Vigneronne des Chevaliers d'Orléans-Cléry |site=[http://www.clery-saint-andre.com www.clery-saint-andre.com] |éditeur=Ville de Cléry-Saint-André |consulté le=17 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext> dans le but d'améliorer la promotion des vins locaux.\n\n<h level=\"3\" i=\"5\">=== Étymologie ===</h>\n[[Fichier:Plan de Cléry au 18e siècle.JPG|thumb|350px|Plan de [[Cléry-Saint-André|Cléry]] au <template><title>XVIIIe siècle</title></template>, avec les vignes indiquées sur les terrasses.]]\nLe nom de l'appellation est formé des noms des communes d'Orléans, préfecture du département, et de Cléry-Saint-André, au centre de l'aire d'appellation.\n\n<template lineStart=\"1\"><title>référence nécessaire</title><part><name index=\"1\"/><value>La première mention écrite de [[Cléry-Saint-André|Cléry]] date du milieu du <template><title>VIe siècle</title></template> : l’[[Liste des évêques d'Orléans|évêque d’Orléans]] Marc mentionne le lieu ''Clariacus vicus'' : le terme ''[[Vicus]]'' désigne en [[latin]] un groupe d’habitations, village ou hameau, et ''Clariacus'' son nom.</value></part></template>\n\nLe nom de la ville d'Orléans dérive probablement de la corruption de l'un de ses anciens noms, ''Aurelianum'', qui pourrait être issu du nom des empereurs romains [[Marc Aurèle]], qui aurait fait embellir la ville en [[163]], ou Aurélien qui la fit rebâtir en [[273]]. Une autre hypothèse évoque la possibilité que la ville tienne son nom de la mère de [[Jules César]], [[Aurelia Cotta]]<ext><name>ref</name><attr/><inner>{{article|id=Bimbenet|langue=fr|prénom1=|nom1=Bimbenet|lien auteur1=|titre=Rapport au nom de la section des belles-lettres sur le mémoire Orléans et ses panégyristes au {{s-|XVI}} par Baguenault de Viéville |périodique=Mémoires de la Société d'agriculture, sciences, belles-lettres et arts d'Orléans|lien périodique=|volume=3|numéro=|jour=|mois=|année=1857|pages=108-122|issn=|url texte=https://books.google.fr/books?id=Vr8XAAAAYAAJ|consulté le=9 décembre 2010}}</inner><close>&lt;/ref&gt;</close></ext>. Une étude de Jacques Soyer relègue néanmoins ces hypothèses au statut de légende, ''Aurelia'' descendant, d'après ses recherches, du nom de la [[Gens (Rome antique)|gens]] ''Aurelia'' qui possédait des terres à [[Cenabum]], ancienne cité [[Peuples celtes|celtique]] des [[Carnutes]] située à l'emplacement d'Orléans<ext><name>ref</name><attr/><inner>{{article|langue=fr|prénom1=Jacques|nom1=Soyer|lien auteur1=|titre=La légende de la fondation d'Orléans par l'empereur Aurélien|périodique=Mémoires de la société d'agriculture, sciences, belles-lettres et arts d'Orléans|lien périodique=|volume=73|numéro=73|jour=|mois=|année=1912|pages=130|issn=|url texte=http://www.persee.fr/web/revues/home/prescript/article/bec_0373-6237_1912_num_73_1_460916_t1_0130_0000_001|consulté le=9 décembre 2010}}</inner><close>&lt;/ref&gt;</close></ext>.\n\n<h level=\"3\" i=\"6\">=== Le vin d'Orléans dans les arts ===</h>\nEn [[1605]], le poète orléanais, Simon du Rouzeau (?-[[1627]])<ext><name>ref</name><attr/><inner>Présenté dans ''Poètes du vin, poètes divins'' de [[Kilien Stengel]], préface de [[Jean-Robert Pitte]], Paris, collection Ecriture, [[Éditions de l'Archipel]], 2012, 280 p.</inner><close>&lt;/ref&gt;</close></ext> fait paraître ''L'Hercule Guespin ou l'himne du vin d'Orléans'', texte qui vante la qualité du vin d'Orléans<ext><name>ref</name><attr/><inner>{{ouvrage|langue=|prénom1=Simon|nom1=du Rouzeau|lien auteur1=|titre=L'Hercule Guepin : poème en l'honneur du vin d'Orléans |sous-titre=édition conforme à celle de 1605 accompagnée de notes et d'une notice bibliographique|numéro d'édition=|éditeur=H. Herluison|lien éditeur=|lieu=Orléans|jour=|mois=|année=1860|volume=|tome=|pages totales=56|passage=|isbn=|lire en ligne=https://books.google.com/books?id=i8cLAAAAQAAJ|consulté le=19 mars 2011}}. Voir l'édition originale dans la bibliographie.</inner><close>&lt;/ref&gt;</close></ext>.\n\nLe comédien Antoine Girard (v.[[1584]]-[[1633]]) dit [[Tabarin]] écrit en [[1623]] dans son ''adieu de Tabarin au peuple de Paris'', où le vin d'Orléans était à l'époque très consommé : <template><title>citation</title><part><name index=\"1\"/><value>ce vin d'Orléans, lequel bridant la raison, lasche les resnes à la folie, me fait devenir fol de regret</value></part></template><ext><name>ref</name><attr/><inner>{{ouvrage|langue=|prénom1=|nom1=Tabarin|lien auteur1=|titre=Œuvres complètes de Tabarin |sous-titre=l'adieu de Tabarin au peuple de Paris avec les regrets des bons morceaux et du bon vin, adressé aux artisans de la gueule et aux suppost de Bacchus, 1623, édité Chez Pierre Rocolet|numéro d'édition=|éditeur=P. Jannet|lien éditeur=|lieu=Paris|jour=|mois=|année=1858|volume=2|tome=|pages totales=504|passage=463|isbn=|lire en ligne=http://gallica.bnf.fr/ark:/12148/bpt6k277976/f463|consulté le=20 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext>.\n\n<h level=\"2\" i=\"7\">== Situation géographique ==</h>\nL'orléans-cléry<ext><name>ref</name><attr> group=&quot;Notes&quot; name=&quot;AO&quot;</attr></ext> est produit en [[France]], dans la [[région française|région]] [[région Centre|Centre]], plus précisément dans le département du [[Loiret (département)|Loiret]] sur le territoire des communes de [[Cléry-Saint-André]], [[Mareau-aux-Prés]], [[Mézières-lez-Cléry]], [[Olivet (Loiret)|Olivet]] et [[Saint-Hilaire-Saint-Mesmin]], en aval d'[[Orléans]].\n\n<h level=\"3\" i=\"8\">=== Géologie et orographie ===</h>\n[[Fichier:Repères de crues de la Loire à Orléans.jpg|thumb|La géologie locale est déterminée par les dépôts de la Loire ; repères de crues du fleuve à Orléans.]]\n[[Fichier:Sol alluvions Mareau.jpg|thumb|left|Sol d'[[alluvions]] ([[sable]] et [[limon (roche)|limon]]) à [[Mareau-aux-Prés]]]].\nLes vignes sont plantées sur les [[alluvions]] qui recouvrent presque toute la rive gauche de la [[Loire (fleuve)|Loire]]. Au bord du fleuve s'étalent d'abord les alluvions les plus récentes, délimitant le [[lit mineur]] mais aussi [[Lit (hydrologie)|majeur]] (les zones inondables, protégées par les [[levée de la Loire|levées de la Loire]]). Ces alluvions sont de différentes tailles, du [[limon (roche)|limon]] [[sable]]ux le plus fin aux [[galet]]s, majoritairement [[silice]]ux (sable de [[quartz (minéral)|quartz]] et de [[feldspath]]s, galets de [[silex]], de [[Grès (géologie)|grès]], de [[Roche volcanique|roches éruptives]] et de [[calcaire]]) provenant du [[Massif central]].\n\nUn peu au-dessus, à la limite basse des villages, affleure le calcaire de [[Beauce (France)|Beauce]] sous forme d'une étroite bande. Datant de l'[[Aquitanien]], c'est un calcaire [[Craie|crayeux]] qui plonge immédiatement sous le placage des alluvions du haut du coteau. Plus haut, ce calcaire est couvert par des sables alluviaux éolisés (chariés à l'origine par le vent), du [[Glacis (géomorphologie)|glacis]] d'Olivet à Mareau-aux-Prés, sur lesquels sont plantés vignes et vergers.\n\nEnfin à partir de la limite des bois couvrant la [[Sologne]] commence la couche de six à sept mètres d'alluvions anciennes, formant la terrasse de [[Châteauneuf-sur-Loire|Châteauneuf]]. Datant de la [[glaciation de Riss]], ces alluvions vont de l'[[argile]] aux gros blocs, composées uniquement de silice sans le moindre calcaire<ext><name>ref</name><attr/><inner>Notices des cartes du [[BRGM]] {{pdf}}[http://ficheinfoterre.brgm.fr/Notices/0397N.pdf {{n°}}397 (Beaugency)] et {{pdf}}[http://ficheinfoterre.brgm.fr/Notices/0363N.pdf {{n°}}363 (Orléans)], disponibles sur le site [http://infoterre.brgm.fr/ infoterre.brgm.fr].</inner><close>&lt;/ref&gt;</close></ext><template><title>,</title></template><ext><name>ref</name><attr/><inner>{{Géoportail\n | latitude    = 47/50/20/N\n | longitude   = 01/48/24/E\n | zoom        = \n | échelle     = 32000\n | couches     = Geologie\n | desc        = Carte géologique centrée sur le hameau des Muids\n | consulté le = \n}}</inner><close>&lt;/ref&gt;</close></ext>.\n<template lineStart=\"1\"><title>Article détaillé</title><part><name index=\"1\"/><value>échelle des temps géologiques</value></part></template>\n\n<h level=\"3\" i=\"9\">=== Climatologie ===</h>\n<template lineStart=\"1\"><title>voir aussi</title><part><name index=\"1\"/><value>climat du Loiret</value></part></template>\nLe climat est [[climat tempéré|tempéré]] [[Climat océanique|océanique]] à influence [[climat continental|continentale]]. \n\nLa [[station météo]] de niveau 0<ext><name>ref</name><attr> group=&quot;Notes&quot;</attr><inner>Météo France définit les stations météo selon [http://climatheque.meteo.fr/aide/climatheque/reseauPostes/aideTypePoste.html six grands types], numérotés de 0 à 5 ;  professionnelle avec observation humaine (0), non professionnelle avec observation humaine ou à distance (1), automatique en temps réel (2), station automatique temps différé (3), manuelle (4), poste à interrogation occasionnelle (5)</inner><close>&lt;/ref&gt;</close></ext> la plus proche du vignoble est celle du village de [[Bricy]]. Elle est située à <template><title>unité</title><part><name index=\"1\"/><value>17</value></part><part><name index=\"2\"/><value>km</value></part></template> au nord du centre de l'aire d'appellation<ext><name>ref</name><attr> group=&quot;Notes&quot;</attr><inner>Les distances sont mesurées grâce à l'outil ''Distance measure'' sur site [http://wikimapia.org wikimapia.org]. Le centre de l'appellation est fixée à Mareau-aux-Prés.</inner><close>&lt;/ref&gt;</close></ext>.\n\n<comment>&lt;!-- DÉBUT DU TABLEAU DES DONNÉES MÉTÉO --&gt;\n</comment><template lineStart=\"1\"><title>Relevé météo\n</title><part><name>titre</name><equals>=</equals><value>Relevé météorologique d'Orléans-Bricy 1961-1990\n</value></part><part><name>source</name><equals>=</equals><value>Infoclimat<ext><name>ref</name><attr> name=&quot;infoclimat&quot;</attr><inner>{{Lien web|url=http://www.infoclimat.fr/climatologie/index.php?s=07249&amp;aff=details |titre=Relevés Orléans-Bricy 1961-1990 |site=[http://www.infoclimat.fr www.infoclimat.fr] |année= |éditeur=Association Infoclimat |consulté le=11 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext>\n</value></part><part><name>diagramme</name><equals>=</equals><value>oui\n\n<comment>&lt;!-- PARTIE A : TEMPÉRATURES MOYENNES, ENSOLEILLEMENT ET HUMIDITÉ --&gt;\n</comment><comment>&lt;!--température minimale moyenne (en°C)--&gt;\n</comment></value></part><part><name>tmin-jan</name><equals>=</equals><value>0.3\n</value></part><part><name>tmin-fev</name><equals>=</equals><value>0.8\n</value></part><part><name>tmin-mar</name><equals>=</equals><value>2.2\n</value></part><part><name>tmin-avr</name><equals>=</equals><value>4.3\n</value></part><part><name>tmin-mai</name><equals>=</equals><value>7.8\n</value></part><part><name>tmin-jui</name><equals>=</equals><value>10.7\n</value></part><part><name>tmin-jul</name><equals>=</equals><value>12.6\n</value></part><part><name>tmin-aou</name><equals>=</equals><value>12.3\n</value></part><part><name>tmin-sep</name><equals>=</equals><value>10.3\n</value></part><part><name>tmin-oct</name><equals>=</equals><value>7.3\n</value></part><part><name>tmin-nov</name><equals>=</equals><value>3.3\n</value></part><part><name>tmin-dec</name><equals>=</equals><value>1.1\n</value></part><part><name>tmin-ann</name><equals>=</equals><value>6.1\n<comment>&lt;!--température moyenne (en°C)--&gt;\n</comment></value></part><part><name>tmoy-jan</name><equals>=</equals><value>3.1\n</value></part><part><name>tmoy-fev</name><equals>=</equals><value>4.2\n</value></part><part><name>tmoy-mar</name><equals>=</equals><value>6.6\n</value></part><part><name>tmoy-avr</name><equals>=</equals><value>9.3\n</value></part><part><name>tmoy-mai</name><equals>=</equals><value>12.9\n</value></part><part><name>tmoy-jui</name><equals>=</equals><value>16.2\n</value></part><part><name>tmoy-jul</name><equals>=</equals><value>18.5\n</value></part><part><name>tmoy-aou</name><equals>=</equals><value>18.2\n</value></part><part><name>tmoy-sep</name><equals>=</equals><value>15.8\n</value></part><part><name>tmoy-oct</name><equals>=</equals><value>11.7\n</value></part><part><name>tmoy-nov</name><equals>=</equals><value>6.6\n</value></part><part><name>tmoy-dec</name><equals>=</equals><value>3.8\n</value></part><part><name>tmoy-ann</name><equals>=</equals><value>10.6\n<comment>&lt;!--température maximale moyenne (en°C)--&gt;\n</comment></value></part><part><name>tmax-jan</name><equals>=</equals><value>5.9\n</value></part><part><name>tmax-fev</name><equals>=</equals><value>7.6\n</value></part><part><name>tmax-mar</name><equals>=</equals><value>10.9\n</value></part><part><name>tmax-avr</name><equals>=</equals><value>14.3\n</value></part><part><name>tmax-mai</name><equals>=</equals><value>18.1\n</value></part><part><name>tmax-jui</name><equals>=</equals><value>21.6\n</value></part><part><name>tmax-jul</name><equals>=</equals><value>24.4\n</value></part><part><name>tmax-aou</name><equals>=</equals><value>24.0\n</value></part><part><name>tmax-sep</name><equals>=</equals><value>21.2\n</value></part><part><name>tmax-oct</name><equals>=</equals><value>16.2\n</value></part><part><name>tmax-nov</name><equals>=</equals><value>9.9\n</value></part><part><name>tmax-dec</name><equals>=</equals><value>6.5\n</value></part><part><name>tmax-ann</name><equals>=</equals><value>15.1\n\n<comment>&lt;!--ensoleillement moyen (en h) --&gt;\n</comment></value></part><part><name>soleil-jan</name><equals>=</equals><value>58.5\n</value></part><part><name>soleil-fev</name><equals>=</equals><value>85.2\n</value></part><part><name>soleil-mar</name><equals>=</equals><value>134.7\n</value></part><part><name>soleil-avr</name><equals>=</equals><value>176.6\n</value></part><part><name>soleil-mai</name><equals>=</equals><value>206.7\n</value></part><part><name>soleil-jui</name><equals>=</equals><value>230.4\n</value></part><part><name>soleil-jul</name><equals>=</equals><value>252.2\n</value></part><part><name>soleil-aou</name><equals>=</equals><value>225\n</value></part><part><name>soleil-sep</name><equals>=</equals><value>180.3\n</value></part><part><name>soleil-oct</name><equals>=</equals><value>129.5\n</value></part><part><name>soleil-nov</name><equals>=</equals><value>74.6\n</value></part><part><name>soleil-dec</name><equals>=</equals><value>50.7\n</value></part><part><name>soleil-ann</name><equals>=</equals><value>1804.5\n\n<comment>&lt;!--Humidité relative (%)--&gt;\n</comment></value></part><part><name>humidité-jan</name><equals>=</equals><value>89\n</value></part><part><name>humidité-fev</name><equals>=</equals><value>85\n</value></part><part><name>humidité-mar</name><equals>=</equals><value>79\n</value></part><part><name>humidité-avr</name><equals>=</equals><value>74\n</value></part><part><name>humidité-mai</name><equals>=</equals><value>76\n</value></part><part><name>humidité-jui</name><equals>=</equals><value>74\n</value></part><part><name>humidité-jul</name><equals>=</equals><value>72\n</value></part><part><name>humidité-aou</name><equals>=</equals><value>72\n</value></part><part><name>humidité-sep</name><equals>=</equals><value>77\n</value></part><part><name>humidité-oct</name><equals>=</equals><value>84\n</value></part><part><name>humidité-nov</name><equals>=</equals><value>89\n</value></part><part><name>humidité-dec</name><equals>=</equals><value>90\n</value></part><part><name>humidité-ann</name><equals>=</equals><value>80\n\n<comment>&lt;!-- PARTIE B : PRÉCIPITATIONS --&gt;\n</comment><comment>&lt;!--précipitations mensuelles (en mm) --&gt;\n</comment></value></part><part><name>prec-jan</name><equals>=</equals><value>55.2\n</value></part><part><name>prec-fev</name><equals>=</equals><value>49.7\n</value></part><part><name>prec-mar</name><equals>=</equals><value>51.8\n</value></part><part><name>prec-avr</name><equals>=</equals><value>47.9\n</value></part><part><name>prec-mai</name><equals>=</equals><value>65.8\n</value></part><part><name>prec-jui</name><equals>=</equals><value>47.5\n</value></part><part><name>prec-jul</name><equals>=</equals><value>52.4\n</value></part><part><name>prec-aou</name><equals>=</equals><value>45.3\n</value></part><part><name>prec-sep</name><equals>=</equals><value>49.3\n</value></part><part><name>prec-oct</name><equals>=</equals><value>57.9\n</value></part><part><name>prec-nov</name><equals>=</equals><value>60.1\n</value></part><part><name>prec-dec</name><equals>=</equals><value>54.3\n</value></part><part><name>prec-ann</name><equals>=</equals><value>637.2\n\n</value></part></template>\n<comment>&lt;!-- FIN DE TABLEAU DE DONNÉES MÉTÉO --&gt;\n</comment>\nLe tableau ci-dessous permet de comparer l'ensoleillement du vignoble orléanais à celui d'autres régions françaises :\n\n{| border=&quot;0&quot;\n| valign=&quot;center&quot; width=&quot;70%&quot; |\n<template lineStart=\"1\"><title>Météo France\n</title><part><name>Ville</name><equals>=</equals><value>Orléans\n</value></part><part><name>SoleilVille</name><equals>=</equals><value>1804\n</value></part><part><name>PluieVille</name><equals>=</equals><value>637\n</value></part><part><name>NeigeVille</name><equals>=</equals><value>\n</value></part><part><name>OrageVille</name><equals>=</equals><value>\n</value></part><part><name>BrouillardVille</name><equals>=</equals><value>\n</value></part></template>\n|}\n\nLes données relevées à la station de Bricy peuvent néanmoins présenter plusieurs biais potentiels par rapport aux véritables conditions rencontrées dans le vignoble. En effet, la station est située à <template><title>unité</title><part><name index=\"1\"/><value>125</value></part><part><name index=\"2\"/><value>mètres</value></part></template> d'altitude, au nord de la Loire et au sud de la région naturelle de [[Beauce (France)|Beauce]] alors que l'aire d'appellation d'orléans-cléry est localisée entre 82 et <template><title>unité</title><part><name index=\"1\"/><value>109</value></part><part><name index=\"2\"/><value>mètres</value></part></template> d'altitude au sud du fleuve, dans le val de Loire, au contact du nord de la [[Sologne]]. Dès lors, les stations manuelles de niveau 4, situées à [[Baule]], [[Orléans-la-Source]] et Saint-Hilaire-Saint-Mesmin<ext><name>ref</name><attr/><inner>{{Lien web|url=http://climatheque.meteo.fr/aide/climatheque/reseauPostes/pdf/dep45.pdf |titre=Station météorologique en service dans le département du Loiret |site=[http://climatheque.meteo.fr climatheque.meteo.fr] |année=3 mars 2011 |éditeur=Météo France et Institut géographique national |consulté le=18 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext> ainsi que la station du réseau des stations amateurs en ligne d'Infoclimat de [[Saint-Cyr-en-Val]]<ext><name>ref</name><attr/><inner>{{Lien web|url=http://www.infoclimat.fr/stations-meteo/index.php?s=00045 |titre=Station météo de Saint-Cyr-en-Val |site=[http://www.infoclimat.fr www.infoclimat.fr] |année= |éditeur=Association Infoclimat |consulté le=18 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext> peuvent également être informatives quant aux conditions météorologiques rencontrées sur le vignoble.\n\n{| border=&quot;0&quot;\n| valign=&quot;top&quot; width=&quot;50%&quot; |\n{| border=&quot;0&quot; align=&quot;center&quot; style=&quot;border: 1px solid #999; background-color:#FFFFFF&quot;  text-align: &quot;center&quot;; cellspacing=&quot;3px&quot; cellpadding=&quot;10px&quot;\n|-align=&quot;center&quot; bgcolor=&quot;#CCCCCC&quot;\n! colspan=3 | Altitudes (en mètres) rencontrées&lt;br /&gt;dans les communes de l'aire d'appellation\n|-\n! Communes !! min. !! max.\n|-\n| [[Cléry-Saint-André]]<ext><name>ref</name><attr> group=&quot;A&quot;</attr><inner>{{Lien web|url=http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=22231|titre=Cléry-Saint-André|consulté le=18 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext> || 84 || 107  \n|-\n| [[Mareau-aux-Prés]]<ext><name>ref</name><attr> group=&quot;A&quot;</attr><inner>{{Lien web|url=http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=21114|titre=Mareau-aux-Prés|consulté le=18 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext> || 82 || 103 \n|-\n| [[Mézières-lez-Cléry]]<ext><name>ref</name><attr> group=&quot;A&quot;</attr><inner>{{Lien web|url=http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=22443|titre=Mézières-lez-Cléry|consulté le=18 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext> || 91 || 108 \n|-\n| [[Olivet (Loiret)|Olivet]]<ext><name>ref</name><attr> group=&quot;A&quot;</attr><inner>{{Lien web|url=http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=25536|titre=Olivet|consulté le=18 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext> || 89 || 109 \n|-\n| [[Saint-Hilaire-Saint-Mesmin]]<ext><name>ref</name><attr> group=&quot;A&quot;</attr><inner>{{Lien web|url=http://cassini.ehess.fr/cassini/fr/html/fiche.php?select_resultat=32290|titre=Saint-Hilaire-Saint-Mesmin|consulté le=18 mars 2011}}</inner><close>&lt;/ref&gt;</close></ext> || 87 || 105\n|-\n! colspan=3 | &lt;small&gt;min. : altitude minimum ; max. : altitude maximum&lt;/small&gt;\n|}\n| valign=&quot;top&quot; width=&quot;50%&quot; |\n{| border=&quot;0&quot; align=&quot;center&quot; style=&quot;border: 1px solid #999; background-color:#FFFFFF&quot;  text-align: &quot;center&quot;; cellspacing=&quot;3px&quot; cellpadding=&quot;10px&quot;\n|-align=&quot;center&quot; bgcolor=&quot;#CCCCCC&quot;\n! colspan=4 | Caractéristiques des stations météorologiques&lt;br /&gt;situées à proximité de l'aire d'appellation\n|-\n! Stations !! type !! alt. !! km\n|-\n| [[Baule]] || 4 || ? || 11\n|-\n| [[Bricy]] || 0 || 125 || 17\n|-\n| [[Orléans-la-Source]] || 4 || ? || 9\n|-\n| [[Saint-Cyr-en-Val]] || &lt;small&gt;amateur&lt;/small&gt; || 96 || 12\n|-\n| [[Saint-Hilaire-Saint-Mesmin]] || 4  || ? || 3\n|-\n! colspan=4 | &lt;small&gt;alt. : altitude ; km : distance en kilomètres&lt;br /&gt;par rapport au centre de l'aire d'appellation&lt;/small&gt;\n|}\n|}\n\n<h level=\"2\" i=\"10\">== Vignoble ==</h>\n[[Fichier:Carte vignoble vallee de la loire.png|thumb|300px|Carte du [[vignoble de la vallée de la Loire]]. Les appellations orléans et orléans-cléry apparaissent en rose dans la région septentrionale de la Loire]]\nLa surface exploitée de l'aire d'appellation est de <template><title>unité</title><part><name index=\"1\"/><value>28</value></part><part><name index=\"2\"/><value>[[hectare]]s</value></part></template><ext><name>ref</name><attr> name=&quot;Guide Hachette&quot;</attr></ext>. Le vignoble est situé sur le cours de la [[Loire (fleuve)|Loire]] entre les vignobles de [[Touraine (AOC)|Touraine]] (à l'ouest) et de Centre-Loire (au sud-est).\n\n<h level=\"3\" i=\"11\">=== Géographie ===</h>\nCinq communes productrices peuvent prétendre à l'appellation orléans-cléry<ext><name>ref</name><attr> group=&quot;Notes&quot; name=&quot;AO&quot;</attr></ext>, trois du [[canton de Cléry-Saint-André]], à savoir [[Cléry-Saint-André]], [[Mareau-aux-Prés]] et [[Mézières-lez-Cléry]], et deux du [[canton d'Olivet]], à savoir [[Olivet (Loiret)|Olivet]] et [[Saint-Hilaire-Saint-Mesmin]]. Ces communes sont toutes situées dans l'[[arrondissement d'Orléans|arrondissement]] et l'[[aire urbaine d'Orléans|aire urbaine]] d'Orléans du département du [[Loiret (département)|Loiret]]<ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext><template><title>,</title></template><ext><name>ref</name><attr/><inner>[http://www.inao.gouv.fr/repository/editeur/pdf/Cartes/AOC_OrleansClery_A_12062009.pdf Carte de l'aire d'appellation], disponible sur le site [http://www.inao.gouv.fr/ inao.gouv.fr].</inner><close>&lt;/ref&gt;</close></ext>.\n\nLes parcelles, très dispersées, se trouvent dans le [[val de Loire]], sur le coteau en pente douce de la rive gauche de la [[Loire (fleuve)|Loire]], à une altitude d'environ <template><title>unité</title><part><name index=\"1\"/><value>100</value></part><part><name index=\"2\"/><value>mètres</value></part></template>, au milieu de vergers, à la limite avec le massif boisé de la [[Région naturelle de France|région naturelle]] de [[Sologne]].\n\n<h level=\"3\" i=\"12\">=== Encépagement ===</h>\nLe nombre de pieds à l'hectare doit au moins être égal à <template><title>formatnum:5000</title></template>, chacun d'entre eux devant être espacé d'au moins un mètre, tout en respectant un écartement entre les rangs de deux mètres au maximum. Le pourcentage de pieds de vigne morts ou manquants ne doit pas dépasser 20 %<ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext>.\n\nLes raisins issus des jeunes vignes peuvent bénéficier de l'AOC à partir de la deuxième année suivant celle au cours de laquelle la plantation a été réalisée<ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext>.\n\nLe cépage utilisé majoritairement est le [[cabernet franc]] N<ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext><template><title>,</title></template><ext><name>ref</name><attr> group=&quot;Notes&quot; name=&quot;cep&quot;</attr></ext>.\n\nÀ titre transitoire, les parcelles encore plantées en [[cabernet sauvignon]] N en [[2006]] <template><title>citation</title><part><name index=\"1\"/><value>continuent à bénéficier pour leur récolte du droit à l'appellation d'origine contrôlée, en qualité de cépage accessoire, jusqu'à la récolte 2020 incluse. La proportion de ce cépage ne peut pas être supérieure à 25 % de l'encépagement</value></part></template><ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext>.\n\nLe cabernet franc N est un [[cépage]] largement utilisé dans le [[vignoble de Bordeaux]] et dans le [[vignoble de la vallée de la Loire]].\n\n<ext><name>gallery</name><attr/><inner>\nImage:Cab Franc grape.JPG|Grappe de [[cabernet franc]] N.\nImage:Cabernet Franc Weinsberg 20060909.jpg|Grappe de [[cabernet franc]] N sur pied.\nImage:Cab franc leaf.JPG|Feuille du [[cabernet franc]] N.\n</inner><close>&lt;/gallery&gt;</close></ext>\n\n<h level=\"3\" i=\"13\">=== Méthodes culturales ===</h>\n<h level=\"4\" i=\"14\">==== Travail manuel ====</h>\nCe travail commence par la [[Taille de la vigne|taille]] : en guyot simple, le cep portant un long bois à sept yeux francs au maximum et un ou deux coursons à un ou deux yeux francs ; en [[guyot double]] courte avec deux taquets à quatre yeux francs maximum. Le nombre d'yeux francs par pied ne doit pas excéder dix<ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext>.\n\nLe tirage des sarments suit la taille. Les sarments sont enlevés et peuvent être brûlés ou mis au milieu du rang pour être broyés. On passe ensuite aux réparations ou éventuellement des plantations de greffes. L'[[ébourgeonnage]] peut débuter dès que la vigne a commencé à pousser. Cette méthode permet, en partie, de réguler les rendements<ext><name>ref</name><attr> name=&quot;VITI&quot;</attr><inner>''Conduite et gestion de l'exploitation agricole'', cours de viticulture du lycée viticole de Beaune (1999-2001), Baccalauréat professionnel option viticulture-œnologie.</inner><close>&lt;/ref&gt;</close></ext>. Le « relevage » est pratiqué lorsque la [[vigne]] commence à avoir bien poussé. En général, deux à trois relevages sont pratiqués. Pour finir avec le travail manuel à la vigne, se réalise l'étape importante des [[vendange]]s.\n\n<h level=\"4\" i=\"15\">==== Travail mécanique ====</h>\nL'[[enjambeur]] est d'une aide précieuse. Les différents travaux se composent du broyage des sarments ; de trou fait à la tarière, là où les pieds de vignes sont manquants ; de [[labour]]age ou « griffage », réalisé dans le but d'aérer les sols et de supprimer des mauvaises herbes<ext><name>ref</name><attr> name=&quot;VITI&quot;</attr></ext> ; de [[Désherbage (agriculture)|désherbage]] ; de plusieurs [[Traitement de la vigne|traitements]] des vignes, réalisés dans le but de les protéger contre certaines maladies cryptogamiques (dues à des champignons : [[mildiou]], [[oïdium]] et [[pourriture grise]])<ext><name>ref</name><attr> name=&quot;VITI&quot;</attr></ext> ; de plusieurs rognages consistant à « reciper » ou couper les branches de vignes (rameaux) qui dépassent du système de palissage ; des vendanges mécaniques se réalisant avec une [[machine à vendanger]] ou une tête de récolte montée sur un enjambeur.\n\n<h level=\"3\" i=\"16\">=== Récolte ===</h>\nLors de la récolte, les raisins doivent présenter une richesse en sucre inférieure à 162 grammes par litre de [[moût]].\n\n<h level=\"3\" i=\"17\">=== Rendements ===</h>\nLe [[Rendement viticole|rendement]] est limité à 50 hectolitres par hectare, avec un rendement butoir à 55 hectolitres par hectare et un rendements maximum de production fixé à 65 hectolitres par hectare<ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext>.\n\nLe rendement réel est largement inférieur, le rendement moyen pour l'ensemble de l'appellation en [[2009]] était en effet de 30,3 hectolitres par hectare<ext><name>ref</name><attr> name=&quot;Guide Hachette&quot;</attr></ext><template><title>,</title></template><ext><name>ref</name><attr> group=&quot;Notes&quot;</attr><inner>Le rendement réel est calculé en divisant le volume de la production par la surface exploitée, soit 848 / 28 = 30,29 hectolitres par hectare.</inner><close>&lt;/ref&gt;</close></ext>.\n\n<h level=\"2\" i=\"18\">== Vins ==</h>\n<h level=\"3\" i=\"19\">=== Vinification et élevage ===</h>\n<template lineStart=\"1\"><title>article détaillé</title><part><name index=\"1\"/><value>vin_rouge#Vinification<template><title>!</title></template>vinification du vin rouge</value></part></template>\nLa [[Vendange|récolte]] des raisins se fait à maturité et de façon manuelle ou mécanique. La vendange manuelle est parfois triée, soit à la vigne soit à la cave avec une table de tri, ce qui permet d'enlever les grappes pourries ou insuffisamment mûres<ext><name>ref</name><attr> name=&quot;VITI&quot;</attr></ext>. La vendange manuelle est généralement [[Éraflage|éraflée]] puis mise en [[cuve]].\n\nUne macération pré-fermentaire à froid est quelquefois pratiquée. La [[fermentation alcoolique]] peut démarrer, le plus souvent après un levurage. Commence alors le travail d'extraction des [[polyphénol]]s (tanins, anthocyanes) et autres éléments du raisin. L'extraction se faisait par [[vinification|pigeage]], opération qui consiste à enfoncer le chapeau de marc dans le jus en fermentation. Plus couramment, l'extraction est conduite aussi par des remontages, opération qui consiste à pomper le jus depuis le bas de la cuve pour arroser le chapeau de marc et ainsi lessiver les composants qualitatifs du raisin.\n\nLes températures de fermentation alcoolique peuvent être plus ou moins élevées, avec une moyenne générale de 28 à 35&amp;nbsp;°C au maximum de la fermentation. La [[chaptalisation]] est réalisée si le degré naturel est insuffisant : cette pratique est réglementée. À l'issue de la fermentation alcoolique suit l'opération de décuvage qui donne le [[vin de goutte]] et le [[vin de presse]]. La [[fermentation malolactique]] se déroule après mais est dépendante de la température<ext><name>ref</name><attr> name=&quot;VITI&quot;</attr></ext>. À la fin de la fermentation malolactique, la teneur en acide malique doit être inférieure ou égale à 0,3 gramme par litre. De plus, la teneur en sucres fermentescibles ([[glucose]] et [[fructose]]) doit être inférieure ou égale à 2 grammes par litre<ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext>. Le vin est soutiré et mis en [[fût (récipient)|fût]] ou cuve pour son [[élevage du vin|élevage]]. L'élevage se poursuit pendant plusieurs mois, puis le vin est collé, filtré et mis en bouteilles<ext><name>ref</name><attr> name=&quot;VITI&quot;</attr></ext>.\n\nEn plus des cinq communes de l'aire d'appellation, une aire de proximité immédiate où la vinification de l'orléans-cléry est également autorisée a été définie, elle couvre le territoire des communes suivantes : [[Ardon (Loiret)|Ardon]], [[Baule]], [[Beaugency]], [[Bou]], [[Chaingy]], [[Chécy]], [[Combleux]], [[Dry (Loiret)|Dry]], [[Huisseau-sur-Mauves]], [[Jouy-le-Potier]], [[Lailly-en-Val]], [[Mardié]], [[Messas]], [[Meung-sur-Loire]], [[Orléans]], [[Saint-Ay]], [[Saint-Jean-de-Braye]], [[Saint-Pryvé-Saint-Mesmin]], [[Semoy (Loiret)|Semoy]], [[Tavers]] et [[Villorceau]]<ext><name>ref</name><attr> name=&quot;Légifrance2&quot;</attr></ext>.\n\n<h level=\"3\" i=\"20\">=== Gastronomie ===</h>\nLes vins sont en général simples, francs et fruités. Ils sont à boire rapidement, dans les 2 à 5 ans suivant leur mise en bouteille.\n\n<h level=\"3\" i=\"21\">=== Récompenses ===</h>\nLes vins de l'appellation ayant été primés au [[concours général agricole]] sont les suivants : le clos Saint-Fiacre, médailles d'or (2003, 2004), d'argent (2006) et de bronze (2009) ; le domaine Saint-Avit, médailles d'argent (2003, 2005, 2008), les vignerons de la Grand'maison, médailles d'or (2007) et d'argent (2009), le vignoble du chant des oiseaux, médailles d'or (2005) et de bronze (2006)<ext><name>ref</name><attr/><inner>{{Lien web|url=http://www.concours-agricole.com/palmares_departement.aspx |titre=Concours général agricole, les palmarès par année et par département |site=[http://www.concours-agricole.com www.concours-agricole.com] |année=2004-2011 |éditeur=SAS Comexposium |consulté le=22 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext>.\n\n<h level=\"2\" i=\"22\">== Économie ==</h>\n[[Fichier:Cave coopérative, Mareau-aux-Prés, Loiret, Centre, France.jpg|thumb|upright=1.4|La cave coopérative à [[Mareau-aux-Prés]] portant la date de [[1931]] sur son fronton.]]\n<h level=\"3\" i=\"23\">=== Structure des exploitations ===</h>\nUne partie de la production est faite par [[Domaine viticole|domaines]] de petites tailles. Ces domaines mettent tous leurs vins en bouteilles et les commercialisent.\n\nUne [[cave coopérative de vinification]] (Les vignerons de la Grand'maison) regroupe quelques producteurs qui lui confient leurs récoltes.\n\nLa plupart des producteurs maintiennent leur exploitation en [[polyculture]]<ext><name>ref</name><attr/><inner>{{Lien web|url=http://www.lepoint.fr/archives/article.php/15908 |titre=Le vin d'Orléans reprend du galon |site=[http://www.lepoint.fr www.lepoint.fr] |auteur=[[Laure Gasparotto]] |année=26 octobre 2006 |éditeur=Le Point |consulté le=15 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext>.\n\n<h level=\"3\" i=\"24\">=== Commercialisation ===</h>\nLa commercialisation de l'appellation est très limitée, du fait de sa production très restreinte et de sa faible notoriété<ext><name>ref</name><attr/><inner>{{Lien web|url=http://www.tribune-orleans.fr/Economie/Vins-dOrleans-un-business-limite-en-quete-de-notoriete.html |titre=Vins d’Orléans : un business limité en quête de notoriété |site=[http://www.tribune-orleans.fr www.tribune-orleans.fr] |auteur=Charles Centofanti |année=24 septembre 2009 |éditeur=La Tribune d'Orléans |consulté le=15 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext>.\n\nLes caveaux des viticulteurs écoulent directement une partie de la production, complétée par les [[Salon (évènementiel)|salons]] des vins (notamment celui des [[Vignerons indépendants de France]]), les [[Foire (économie)|foires]], [[Café (établissement)|cafés]], [[hôtel]]s, [[restaurant]]s et [[Grande distribution|supermarchés]] locaux.\n\n<h level=\"3\" i=\"25\">=== Liste de producteurs ===</h>\nLes petites surfaces cultivées expliquent le petit nombre de producteurs<ext><name>ref</name><attr> group=&quot;Notes&quot;</attr><inner>Cette liste de producteurs a été modifié en mars 2011 ; elle est à compléter.</inner><close>&lt;/ref&gt;</close></ext> :\n*Clos Saint-Fiacre (famille Montigny-Piel), à [[Mareau-aux-Prés]]<ext><name>ref</name><attr/><inner>{{Lien web|url=http://www.clossaintfiacre.fr |titre=Clos Saint-Fiacre |site=[http://www.clossaintfiacre.fr www.clossaintfiacre.fr] |année= |éditeur= |consulté le=13 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext> ;\n*Domaine Saint-Avit (Pascal Javoy), à [[Mézières-lez-Cléry]]<ext><name>ref</name><attr/><inner>{{Lien web|url=http://www.javoy.com |titre=Javoy père et fils |site=[http://www.javoy.com www.javoy.com] |année= |éditeur= |consulté le=13 mars 2011 }}[ ].</inner><close>&lt;/ref&gt;</close></ext> ;\n*Les vignerons de la Grand'maison, à [[Mareau-aux-Prés]] ;\n*Vignoble du Chant d'Oiseaux (Édouard Montigny), à [[Mareau-aux-Prés]]<ext><name>ref</name><attr/><inner>{{Lien web|url=http://www.vignobleduchantdoiseaux.com |titre=Vignoble du chant des oiseaux |site=[http://www.vignobleduchantdoiseaux.com www.vignobleduchantdoiseaux.com] |année= |éditeur= |consulté le=13 mars 2011 }}</inner><close>&lt;/ref&gt;</close></ext> ;\n*Domaine Pèlerin (David Parou), à [[Mareau-aux-Prés]].\n\n<h level=\"2\" i=\"26\">== Notes et références ==</h>\n<h level=\"3\" i=\"27\">=== Notes ===</h>\n<template lineStart=\"1\"><title>Références</title><part><name>groupe</name><equals>=</equals><value>Notes</value></part></template>\n\n<h level=\"3\" i=\"28\">=== Références ===</h>\n<template lineStart=\"1\"><title>Références</title><part><name>colonnes</name><equals>=</equals><value>2</value></part></template>\n\n* Altitudes des communes sur ''[http://cassini.ehess.fr Des villages de Cassini aux communes d'aujourd'hui]'', site de l'École des hautes études en sciences sociales :\n<template lineStart=\"1\"><title>Références</title><part><name>groupe</name><equals>=</equals><value>&quot;A&quot;</value></part><part><name>colonnes</name><equals>=</equals><value>3</value></part></template>\n\n* <template><title>ouvrage</title><part><name>langue</name><equals>=</equals><value>fr</value></part><part><name>prénom1</name><equals>=</equals><value>André</value></part><part><name>nom1</name><equals>=</equals><value>Jullien</value></part><part><name>lien auteur1</name><equals>=</equals><value>André Jullien (vin)</value></part><part><name>titre</name><equals>=</equals><value>Topographie de tous les vignobles connus contenant</value></part><part><name>sous-titre</name><equals>=</equals><value>leur position géographique, l'indication du genre et de la qualité des produits de chaque cru, les lieux où se font les chargements et le principal commerce de vin, le nom et la capacité des tonneaux et des mesures en usage, les moyens de transport ordinairement employés, suivie d'une classification générale de vins</value></part><part><name>numéro d'édition</name><equals>=</equals><value>1</value></part><part><name>éditeur</name><equals>=</equals><value>L'Auteur, Madame Huzard, L. Colas</value></part><part><name>lien éditeur</name><equals>=</equals><value/></part><part><name>lieu</name><equals>=</equals><value>Paris</value></part><part><name>jour</name><equals>=</equals><value/></part><part><name>mois</name><equals>=</equals><value/></part><part><name>année</name><equals>=</equals><value>1816</value></part><part><name>volume</name><equals>=</equals><value/></part><part><name>tome</name><equals>=</equals><value/></part><part><name>pages totales</name><equals>=</equals><value>566</value></part><part><name>passage</name><equals>=</equals><value>80-85 :</value></part><part><name>isbn</name><equals>=</equals><value/></part><part><name>lire en ligne</name><equals>=</equals><value>https://books.google.fr/books?id=xvs6AAAAcAAJ</value></part><part><name>consulté le</name><equals>=</equals><value>23 mars 2011</value></part></template>\n<template lineStart=\"1\"><title>Références</title><part><name>groupe</name><equals>=</equals><value>&quot;B&quot;</value></part><part><name>colonnes</name><equals>=</equals><value>4</value></part></template>\n\n<h level=\"2\" i=\"29\">== Voir aussi ==</h>\n<h level=\"3\" i=\"30\">=== Bibliographie ===</h>\n* <template><title>ouvrage</title><part><name>langue</name><equals>=</equals><value>fr</value></part><part><name>prénom1</name><equals>=</equals><value>Simon</value></part><part><name>nom1</name><equals>=</equals><value>Rouzeau</value></part><part><name>lien auteur1</name><equals>=</equals><value/></part><part><name>titre</name><equals>=</equals><value>L'Hercule guespin, ou l'hymne du vin d'Orléans </value></part><part><name>sous-titre</name><equals>=</equals><value>à monsieur d'Escures, conseiller du Roy, maréchal général des logis de ses armées, commissaire ordinaire des guerres et intendant des levées et turcies de Loyre et Cher</value></part><part><name>numéro d'édition</name><equals>=</equals><value/></part><part><name>éditeur</name><equals>=</equals><value>Saturnin Hotot, imprimeur ordinaire du Roy</value></part><part><name>lien éditeur</name><equals>=</equals><value/></part><part><name>lieu</name><equals>=</equals><value>Orléans</value></part><part><name>jour</name><equals>=</equals><value/></part><part><name>mois</name><equals>=</equals><value/></part><part><name>année</name><equals>=</equals><value>1605</value></part><part><name>volume</name><equals>=</equals><value/></part><part><name>tome</name><equals>=</equals><value/></part><part><name>pages totales</name><equals>=</equals><value>31</value></part><part><name>passage</name><equals>=</equals><value/></part><part><name>isbn</name><equals>=</equals><value/></part><part><name>lire en ligne</name><equals>=</equals><value>http://gallica.bnf.fr/ark:/12148/bpt6k72266c</value></part><part><name>consulté le</name><equals>=</equals><value>18 mars 2011</value></part></template>\n* <template><title>article</title><part><name>langue</name><equals>=</equals><value>fr</value></part><part><name>prénom1</name><equals>=</equals><value>André</value></part><part><name>nom1</name><equals>=</equals><value>Linglois</value></part><part><name>lien auteur1</name><equals>=</equals><value/></part><part><name>titre</name><equals>=</equals><value>Le vin orléanais dans les textes littéraires, du haut Moyen Âge au <template><title>s-</title><part><name index=\"1\"/><value>XVIII</value></part></template></value></part><part><name>périodique</name><equals>=</equals><value>Bulletin de la société archéologique et historique de l'Orléanais</value></part><part><name>éditeur</name><equals>=</equals><value>[[Société archéologique et historique de l'Orléanais]]</value></part><part><name>volume</name><equals>=</equals><value>15</value></part><part><name>numéro</name><equals>=</equals><value>123</value></part><part><name>jour</name><equals>=</equals><value/></part><part><name>mois</name><equals>=</equals><value/></part><part><name>année</name><equals>=</equals><value>1999</value></part><part><name>pages</name><equals>=</equals><value>43-68.</value></part><part><name>issn</name><equals>=</equals><value/></part><part><name>url texte</name><equals>=</equals><value/></part><part><name>consulté le</name><equals>=</equals><value/></part></template>\n* <template><title>article</title><part><name>langue</name><equals>=</equals><value>fr</value></part><part><name>prénom1</name><equals>=</equals><value>Christian</value></part><part><name>nom1</name><equals>=</equals><value>Poitou</value></part><part><name>titre</name><equals>=</equals><value>Le phylloxéra et ses conséquences pour les viticulteurs du Loiret (1870-1910)</value></part><part><name>périodique</name><equals>=</equals><value>Bulletin de la société archéologique et historique de l'Orléanais</value></part><part><name>éditeur</name><equals>=</equals><value>[[Société archéologique et historique de l'Orléanais]]</value></part><part><name>volume</name><equals>=</equals><value>21</value></part><part><name>numéro</name><equals>=</equals><value>170</value></part><part><name>jour</name><equals>=</equals><value/></part><part><name>mois</name><equals>=</equals><value/></part><part><name>année</name><equals>=</equals><value>2013</value></part><part><name>pages</name><equals>=</equals><value>117-123.</value></part><part><name>issn</name><equals>=</equals><value/></part><part><name>url texte</name><equals>=</equals><value/></part><part><name>consulté le</name><equals>=</equals><value/></part></template>\n\n<h level=\"3\" i=\"31\">=== Liens internes ===</h>\n* [[Économie du Loiret]]\n\n<template lineStart=\"1\"><title>Palette</title><part><name index=\"1\"/><value>Vignoble de la vallée de la Loire</value></part></template>\n\n<template lineStart=\"1\"><title>Portail</title><part><name index=\"1\"/><value>vin</value></part><part><name index=\"2\"/><value>Loiret</value></part></template>\n\n<template lineStart=\"1\"><title>DEFAULTSORT:Orleans-clery (AOC)</title></template>\n[[Catégorie:Vin AOC dans le Loiret]]\n[[Catégorie:Vignoble du Val-de-Loire]]\n[[Catégorie:Vignoble de la vallée de la Loire]]</root>"}}"""

cache = {'info': {'status': 200}, 'query': query, 'response': response}
