# -*- coding:utf-8 -*-

query = 'https://en.wikipedia.org/w/api.php?action=parse&contentmodel=text&disableeditsection=&disablelimitreport=&disabletoc=&format=json&formatversion=2&prop=text|iwlinks|parsetree|wikitext|displaytitle|properties&pageid=8091'

response = r"""
{
  "parse": {
    "title": "Douglas Adams",
    "pageid": 8091,
    "text": "<div role=\"note\" class=\"hatnote\">For other people named Douglas Adams, see <a href=\"/wiki/Douglas_Adams_(disambiguation)\" class=\"mw-disambig\" title=\"Douglas Adams (disambiguation)\">Douglas Adams (disambiguation)</a>.</div>\n<table class=\"infobox vcard\" style=\"width:22em\">\n<tr>\n<th colspan=\"2\" style=\"text-align:center;font-size:125%;font-weight:bold\"><span class=\"fn\">Douglas Adams</span></th>\n</tr>\n<tr>\n<td colspan=\"2\" style=\"text-align:center\"><a href=\"/wiki/File:Douglas_adams_portrait_cropped.jpg\" class=\"image\"><img alt=\"Douglas adams portrait cropped.jpg\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/c/c0/Douglas_adams_portrait_cropped.jpg/220px-Douglas_adams_portrait_cropped.jpg\" width=\"220\" height=\"255\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/c/c0/Douglas_adams_portrait_cropped.jpg/330px-Douglas_adams_portrait_cropped.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/c/c0/Douglas_adams_portrait_cropped.jpg 2x\" data-file-width=\"333\" data-file-height=\"386\" /></a></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"padding-top:0.225em;line-height:1.1em;padding-right:0.65em;\">Born</th>\n<td style=\"line-height:1.4em;\">Douglas Noel Adams<br />\n<span style=\"display:none\">(<span class=\"bday\">1952-03-11</span>)</span>11 March 1952<br />\n<a href=\"/wiki/Cambridge\" title=\"Cambridge\">Cambridge</a>, England</td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"padding-top:0.225em;line-height:1.1em;padding-right:0.65em;\">Died</th>\n<td style=\"line-height:1.4em;\">11 May 2001<span style=\"display:none\">(<span class=\"dday deathdate\">2001-05-11</span>)</span> (aged&#160;49)<br />\n<a href=\"/wiki/Montecito,_California\" title=\"Montecito, California\">Montecito, California</a>, U.S.</td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"padding-top:0.225em;line-height:1.1em;padding-right:0.65em;\">Resting place</th>\n<td style=\"line-height:1.4em;\"><a href=\"/wiki/Highgate_Cemetery\" title=\"Highgate Cemetery\">Highgate Cemetery</a>, London, England</td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"padding-top:0.225em;line-height:1.1em;padding-right:0.65em;\">Occupation</th>\n<td class=\"role\" style=\"line-height:1.4em;\">Writer</td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"padding-top:0.225em;line-height:1.1em;padding-right:0.65em;\">Alma&#160;mater</th>\n<td style=\"line-height:1.4em;\"><a href=\"/wiki/St_John%27s_College,_Cambridge\" title=\"St John's College, Cambridge\">St John's College, Cambridge</a></td>\n</tr>\n<tr>\n<th scope=\"row\" style=\"padding-top:0.225em;line-height:1.1em;padding-right:0.65em;\">Genre</th>\n<td class=\"category\" style=\"line-height:1.4em;\">Science fiction, comedy, satire</td>\n</tr>\n<tr>\n<th colspan=\"2\" style=\"text-align:center\">Website</th>\n</tr>\n<tr>\n<td colspan=\"2\" style=\"text-align:center;line-height:1.4em;\"><span class=\"url\"><a rel=\"nofollow\" class=\"external text\" href=\"http://douglasadams.com/\">douglasadams<wbr />.com</a></span></td>\n</tr>\n</table>\n<p><b>Douglas Noel Adams</b> (11 March 1952 – 11 May 2001) was an <a href=\"/wiki/English_people\" title=\"English people\">English</a> <a href=\"/wiki/Author\" title=\"Author\">author</a>, <a href=\"/wiki/Scriptwriter\" class=\"mw-redirect\" title=\"Scriptwriter\">scriptwriter</a>, <a href=\"/wiki/Essayist\" class=\"mw-redirect\" title=\"Essayist\">essayist</a>, <a href=\"/wiki/List_of_humorists\" title=\"List of humorists\">humourist</a>, <a href=\"/wiki/Satirist\" class=\"mw-redirect\" title=\"Satirist\">satirist</a> and <a href=\"/wiki/Dramatist\" class=\"mw-redirect\" title=\"Dramatist\">dramatist</a>.</p>\n<p>Adams is best known as the author of <i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"The Hitchhiker's Guide to the Galaxy\">The Hitchhiker's Guide to the Galaxy</a></i>, which originated in 1978 as a BBC <a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(radio_series)\" title=\"The Hitchhiker's Guide to the Galaxy (radio series)\">radio comedy</a> before developing into a \"trilogy\" of five books that sold more than 15&#160;million copies in his lifetime and generated a <a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(TV_series)\" title=\"The Hitchhiker's Guide to the Galaxy (TV series)\">television series</a>, several stage plays, comics, a <a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(computer_game)\" class=\"mw-redirect\" title=\"The Hitchhiker's Guide to the Galaxy (computer game)\">computer game</a>, and in 2005 a <a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(film)\" title=\"The Hitchhiker's Guide to the Galaxy (film)\">feature film</a>. Adams's contribution to UK radio is commemorated in <a href=\"/wiki/Radio_Academy\" title=\"Radio Academy\">The Radio Academy</a>'s Hall of Fame.<sup id=\"cite_ref-radioacad_1-0\" class=\"reference\"><a href=\"#cite_note-radioacad-1\">[1]</a></sup></p>\n<p>Adams also wrote <i><a href=\"/wiki/Dirk_Gently%27s_Holistic_Detective_Agency\" title=\"Dirk Gently's Holistic Detective Agency\">Dirk Gently's Holistic Detective Agency</a></i> (1987) and <i><a href=\"/wiki/The_Long_Dark_Tea-Time_of_the_Soul\" title=\"The Long Dark Tea-Time of the Soul\">The Long Dark Tea-Time of the Soul</a></i> (1988), and co-wrote <i><a href=\"/wiki/The_Meaning_of_Liff\" title=\"The Meaning of Liff\">The Meaning of Liff</a></i> (1983), <i><a href=\"/wiki/The_Deeper_Meaning_of_Liff\" class=\"mw-redirect\" title=\"The Deeper Meaning of Liff\">The Deeper Meaning of Liff</a></i> (1990), <i><a href=\"/wiki/Last_Chance_to_See\" title=\"Last Chance to See\">Last Chance to See</a></i> (1990), and three stories for the television series <i><a href=\"/wiki/Doctor_Who\" title=\"Doctor Who\">Doctor Who</a></i>; he also served as <a href=\"/wiki/Script_editor\" title=\"Script editor\">script editor</a> for the show's seventeenth season in 1979. A posthumous collection of his works, including an unfinished novel, was published as <i><a href=\"/wiki/The_Salmon_of_Doubt\" title=\"The Salmon of Doubt\">The Salmon of Doubt</a></i> in 2002.</p>\n<p>Adams was known as an advocate for environmentalism and <a href=\"/wiki/Conservation_movement\" title=\"Conservation movement\">conservation</a>, as a lover of fast cars, cameras, <a href=\"/wiki/Technological_innovation\" class=\"mw-redirect\" title=\"Technological innovation\">technological innovation</a> and the <a href=\"/wiki/Apple_Macintosh\" class=\"mw-redirect\" title=\"Apple Macintosh\">Apple Macintosh</a>, and as a \"devout <a href=\"/wiki/Atheist\" class=\"mw-redirect\" title=\"Atheist\">atheist</a>\".</p>\n<p></p>\n<h2><span class=\"mw-headline\" id=\"Early_life\">Early life</span></h2>\n<p>Adams was born on 11 March 1952 to Janet (née Donovan; 1927–2016) and Christopher Douglas Adams (1927–1985) in <a href=\"/wiki/Cambridge\" title=\"Cambridge\">Cambridge</a>, England.<sup id=\"cite_ref-ODNB_2-0\" class=\"reference\"><a href=\"#cite_note-ODNB-2\">[2]</a></sup> The following year, <a href=\"/wiki/James_D._Watson\" class=\"mw-redirect\" title=\"James D. Watson\">Watson</a> and <a href=\"/wiki/Francis_Crick\" title=\"Francis Crick\">Crick</a> famously first modelled <a href=\"/wiki/DNA\" title=\"DNA\">DNA</a> at <a href=\"/wiki/Cambridge_University\" class=\"mw-redirect\" title=\"Cambridge University\">Cambridge University</a>, leading Adams to later quip he was DNA in Cambridge months earlier. The family moved to <a href=\"/wiki/East_End_of_London\" title=\"East End of London\">East London</a> a few months after his birth, where his sister, Susan, was born three years later.<sup id=\"cite_ref-Adams_xix_3-0\" class=\"reference\"><a href=\"#cite_note-Adams_xix-3\">[3]</a></sup> His parents divorced in 1957; Douglas, Susan, and their mother moved to an <a href=\"/wiki/RSPCA\" class=\"mw-redirect\" title=\"RSPCA\">RSPCA</a> animal shelter in <a href=\"/wiki/Brentwood,_Essex\" title=\"Brentwood, Essex\">Brentwood, Essex</a>, run by his maternal grandparents.<sup id=\"cite_ref-4\" class=\"reference\"><a href=\"#cite_note-4\">[4]</a></sup></p>\n<h3><span class=\"mw-headline\" id=\"Education\">Education</span></h3>\n<p>Adams attended Primrose Hill Primary School in <a href=\"/wiki/Brentwood,_Essex\" title=\"Brentwood, Essex\">Brentwood</a>. At nine, he passed the entrance exam for <a href=\"/wiki/Brentwood_School_(Essex)\" class=\"mw-redirect\" title=\"Brentwood School (Essex)\">Brentwood School</a>, an independent school whose alumni include <a href=\"/wiki/Robin_Day\" title=\"Robin Day\">Robin Day</a>, <a href=\"/wiki/Jack_Straw\" title=\"Jack Straw\">Jack Straw</a>, <a href=\"/wiki/Noel_Edmonds\" title=\"Noel Edmonds\">Noel Edmonds</a>, and <a href=\"/wiki/David_Irving\" title=\"David Irving\">David Irving</a>. <a href=\"/wiki/Griff_Rhys_Jones\" title=\"Griff Rhys Jones\">Griff Rhys Jones</a> was a year below him, and he was in the same class as <a href=\"/wiki/Stuckism\" title=\"Stuckism\">Stuckist</a> artist <a href=\"/wiki/Charles_Thomson_(artist)\" title=\"Charles Thomson (artist)\">Charles Thomson</a>. He attended the <a href=\"/wiki/Preparatory_school_(UK)\" class=\"mw-redirect\" title=\"Preparatory school (UK)\">prep school</a> from 1959 to 1964, then the main school until December 1970. His form master, Frank Halford, said of him: \"Hundreds of boys have passed through the school but Douglas Adams really stood out from the crowd — literally. He was unnecessarily tall and in his short trousers he looked a trifle self-conscious.\" \"The form-master wouldn't say 'Meet under the clock tower,' or 'Meet under the war memorial',\" he joked, \"but 'Meet under Adams'.\"<sup id=\"cite_ref-Adams_7_5-0\" class=\"reference\"><a href=\"#cite_note-Adams_7-5\">[5]</a></sup><sup id=\"cite_ref-6\" class=\"reference\"><a href=\"#cite_note-6\">[6]</a></sup> Yet it was his ability to write first-class stories that really made him \"shine\".<sup id=\"cite_ref-Simpson_9_7-0\" class=\"reference\"><a href=\"#cite_note-Simpson_9-7\">[7]</a></sup></p>\n<p>Adams was six feet tall (1.83&#160;m) by age 12 and stopped growing at 6&#160;ft 5&#160;in (1.96&#160;m). He became the only student ever to be awarded a ten out of ten by Halford for creative writing, something he remembered for the rest of his life, particularly when facing <a href=\"/wiki/Writer%27s_block\" title=\"Writer's block\">writer's block</a>.<sup id=\"cite_ref-Adams_xix_3-1\" class=\"reference\"><a href=\"#cite_note-Adams_xix-3\">[3]</a></sup></p>\n<p>Some of his earliest writing was published at the school, such as a report on its photography club in <i>The Brentwoodian</i> in 1962, or spoof reviews in the school magazine <i>Broadsheet</i>, edited by <a href=\"/wiki/Paul_Neil_Milne_Johnstone\" class=\"mw-redirect\" title=\"Paul Neil Milne Johnstone\">Paul Neil Milne Johnstone</a>, who later became a character in <i>The Hitchhiker's Guide</i>. He also designed the cover of one issue of the <i>Broadsheet</i>, and had a letter and short story published nationally in <i><a href=\"/wiki/Eagle_(comic)\" class=\"mw-redirect\" title=\"Eagle (comic)\">The Eagle</a></i>, the boys' comic, in 1965. A poem entitled \"A Dissertation on the task of writing a poem on a candle and an account of some of the difficulties thereto pertaining\" written by Adams in January 1970, at the age of 17, was discovered by archivist Stacey Harmer in a cupboard at the school in early 2014. In it, Adams rhymes \"futile\" with \"mute, while\" and \"exhausted\" with \"of course did\".<sup id=\"cite_ref-8\" class=\"reference\"><a href=\"#cite_note-8\">[8]</a></sup> On the strength of a bravura essay on religious poetry that discussed <a href=\"/wiki/The_Beatles\" title=\"The Beatles\">the Beatles</a> and <a href=\"/wiki/William_Blake\" title=\"William Blake\">William Blake</a>, he was awarded an <a href=\"/wiki/Exhibition_(scholarship)\" title=\"Exhibition (scholarship)\">Exhibition</a> in English at <a href=\"/wiki/St_John%27s_College,_Cambridge\" title=\"St John's College, Cambridge\">St John's College, Cambridge</a>, going up in 1971. He wanted to join the <a href=\"/wiki/Footlights\" title=\"Footlights\">Footlights</a>, an invitation-only student comedy club that has acted as a hothouse for comic talent. He was not elected immediately as he had hoped, and started to write and perform in revues with Will Adams (no relation) and Martin Smith, forming a group called \"Adams-Smith-Adams\", but became a member of the Footlights by 1973.<sup id=\"cite_ref-Simpson_30-40_9-0\" class=\"reference\"><a href=\"#cite_note-Simpson_30-40-9\">[9]</a></sup> Despite doing very little work—he recalled having completed three essays in three years—he graduated in 1974 with a B.A. in <a href=\"/wiki/English_literature\" title=\"English literature\">English literature</a>.<sup id=\"cite_ref-ODNB_2-1\" class=\"reference\"><a href=\"#cite_note-ODNB-2\">[2]</a></sup></p>\n<h2><span class=\"mw-headline\" id=\"Career\">Career</span></h2>\n<h3><span class=\"mw-headline\" id=\"Writing\">Writing</span></h3>\n<p>After leaving university Adams moved back to London, determined to break into TV and radio as a writer. An edited version of the <i>Footlights Revue</i> appeared on <a href=\"/wiki/BBC_Two\" title=\"BBC Two\">BBC2</a> television in 1974. A version of the Revue performed live in London's <a href=\"/wiki/West_End_of_London\" title=\"West End of London\">West End</a> led to Adams being discovered by <a href=\"/wiki/Monty_Python\" title=\"Monty Python\">Monty Python</a>'s <a href=\"/wiki/Graham_Chapman\" title=\"Graham Chapman\">Graham Chapman</a>. The two formed a brief writing partnership, earning Adams a writing credit in <a href=\"/wiki/List_of_Monty_Python%27s_Flying_Circus_episodes#6._Party_Political_Broadcast\" title=\"List of Monty Python's Flying Circus episodes\">episode 45</a> of <i>Monty Python</i> for a sketch called \"<a href=\"/wiki/Patient_Abuse\" title=\"Patient Abuse\">Patient Abuse</a>\". He is one of only two people outside the original Python members to get a writing credit (the other being <a href=\"/wiki/Neil_Innes\" title=\"Neil Innes\">Neil Innes</a>).<sup id=\"cite_ref-times_10-0\" class=\"reference\"><a href=\"#cite_note-times-10\">[10]</a></sup> The sketch plays on the idea of mind-boggling paper work in an emergency, a joke later incorporated into the <a href=\"/wiki/Vogon\" title=\"Vogon\">Vogons</a>' obsession with paperwork. Adams also contributed to a sketch on the album for <i><a href=\"/wiki/Monty_Python_and_the_Holy_Grail\" title=\"Monty Python and the Holy Grail\">Monty Python and the Holy Grail</a></i>.</p>\n<div class=\"thumb tright\">\n<div class=\"thumbinner\" style=\"width:222px;\"><a href=\"/wiki/File:DNA_in_Monty_Python.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/en/thumb/0/0a/DNA_in_Monty_Python.jpg/220px-DNA_in_Monty_Python.jpg\" width=\"220\" height=\"198\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/en/thumb/0/0a/DNA_in_Monty_Python.jpg/330px-DNA_in_Monty_Python.jpg 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/0/0a/DNA_in_Monty_Python.jpg/440px-DNA_in_Monty_Python.jpg 2x\" data-file-width=\"498\" data-file-height=\"448\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/File:DNA_in_Monty_Python.jpg\" class=\"internal\" title=\"Enlarge\"></a></div>\nAdams in his first <i><a href=\"/wiki/Monty_Python%27s_Flying_Circus\" title=\"Monty Python's Flying Circus\">Monty Python</a></i> appearance, in full surgeon's garb</div>\n</div>\n</div>\n<p>Adams had two brief appearances in the fourth series of <i><a href=\"/wiki/Monty_Python%27s_Flying_Circus\" title=\"Monty Python's Flying Circus\">Monty Python's Flying Circus</a></i>. At the beginning of episode 42, \"The Light Entertainment War\", Adams is in a surgeon's mask (as Dr. Emile Koning, according to on-screen captions), pulling on gloves, while <a href=\"/wiki/Michael_Palin\" title=\"Michael Palin\">Michael Palin</a> narrates a sketch that introduces one person after another but never gets started. At the beginning of episode 44, \"Mr. Neutron\", Adams is dressed in a <a href=\"/wiki/List_of_recurring_Monty_Python%27s_Flying_Circus_characters#The_Pepperpots\" title=\"List of recurring Monty Python's Flying Circus characters\">pepper-pot</a> outfit and loads a missile onto a cart driven by <a href=\"/wiki/Terry_Jones\" title=\"Terry Jones\">Terry Jones</a>, who is calling for scrap metal (\"Any old iron...\"). The two episodes were broadcast in November 1974. Adams and Chapman also attempted non-Python projects, including <i><a href=\"/wiki/Out_of_the_Trees\" title=\"Out of the Trees\">Out of the Trees</a></i>.</p>\n<p>At this point Adams's career stalled; his writing style was unsuited to the then-current style of radio and TV comedy.<sup id=\"cite_ref-ODNB_2-2\" class=\"reference\"><a href=\"#cite_note-ODNB-2\">[2]</a></sup> To make ends meet he took a series of odd jobs, including as a hospital porter, barn builder, and chicken shed cleaner. He was employed as a bodyguard by a Qatari family, who had made their fortune in oil. Anecdotes about that job included that the family had once ordered one of everything from a hotel's menu, tried all the dishes, and sent out for hamburgers. Another story had to do with a prostitute sent to the floor Adams was guarding one evening. They acknowledged each other as she entered, and an hour later, when she left, she is said to have remarked, \"At least you can read while you're on the job.\"<sup id=\"cite_ref-11\" class=\"reference\"><a href=\"#cite_note-11\">[11]</a></sup></p>\n<p>During this time Adams continued to write and submit sketches, though few were accepted. In 1976 his career had a brief improvement when he wrote and performed <i>Unpleasantness at Brodie's Close</i> at the <a href=\"/wiki/Edinburgh_Fringe\" class=\"mw-redirect\" title=\"Edinburgh Fringe\">Edinburgh Fringe</a> festival. By Christmas work had dried up again, and a depressed Adams moved to live with his mother.<sup id=\"cite_ref-ODNB_2-3\" class=\"reference\"><a href=\"#cite_note-ODNB-2\">[2]</a></sup> The lack of writing work hit him hard and low confidence became a feature of Adams's life; \"I have terrible periods of lack of confidence [..] I briefly did therapy, but after a while I realised it was like a farmer complaining about the weather. You can't fix the weather&#160;– you just have to get on with it\".<sup id=\"cite_ref-Adams_prologue_12-0\" class=\"reference\"><a href=\"#cite_note-Adams_prologue-12\">[12]</a></sup></p>\n<p>Some of Adams's early radio work included sketches for <i><a href=\"/wiki/The_Burkiss_Way\" title=\"The Burkiss Way\">The Burkiss Way</a></i> in 1977 and <i><a href=\"/wiki/The_News_Huddlines\" title=\"The News Huddlines\">The News Huddlines</a></i>.<sup id=\"cite_ref-13\" class=\"reference\"><a href=\"#cite_note-13\">[13]</a></sup> He also wrote, again with Chapman, 20 February 1977 episode of <i>Doctor on the Go</i>, a sequel to the <i><a href=\"/wiki/Doctor_in_the_House_(TV_series)\" title=\"Doctor in the House (TV series)\">Doctor in the House</a></i> television comedy series. After the <a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(radio_series)\" title=\"The Hitchhiker's Guide to the Galaxy (radio series)\">first radio series of <i>The Hitchhiker's Guide</i></a> became successful, Adams was made a BBC radio producer, working on <i><a href=\"/wiki/Week_Ending\" title=\"Week Ending\">Week Ending</a></i> and a pantomime called <i><a href=\"/wiki/Black_Cinderella_Two_Goes_East\" title=\"Black Cinderella Two Goes East\">Black Cinderella Two Goes East</a></i>.<sup id=\"cite_ref-14\" class=\"reference\"><a href=\"#cite_note-14\">[14]</a></sup> He left after six months to become the script editor for <i><a href=\"/wiki/Doctor_Who\" title=\"Doctor Who\">Doctor Who</a></i>.</p>\n<p>In 1979 Adams and <a href=\"/wiki/John_Lloyd_(producer)\" title=\"John Lloyd (producer)\">John Lloyd</a> wrote scripts for two half-hour episodes of <i><a href=\"/wiki/Doctor_Snuggles\" title=\"Doctor Snuggles\">Doctor Snuggles</a></i>: \"The Remarkable Fidgety River\" and \"The Great Disappearing Mystery\" (episodes seven and twelve). John Lloyd was also co-author of two episodes from the original <i>Hitchhiker</i> radio series (\"Fit the Fifth\" and \"Fit the Sixth\", also known as \"Episode Five\" and \"Episode Six\"), as well as <i><a href=\"/wiki/The_Meaning_of_Liff\" title=\"The Meaning of Liff\">The Meaning of Liff</a></i> and <i><a href=\"/wiki/The_Deeper_Meaning_of_Liff\" class=\"mw-redirect\" title=\"The Deeper Meaning of Liff\">The Deeper Meaning of Liff</a></i>.</p>\n<h4><span class=\"mw-headline\" id=\"The_Hitchhiker.27s_Guide_to_the_Galaxy\"><i>The Hitchhiker's Guide to the Galaxy</i></span></h4>\n<div role=\"note\" class=\"hatnote\">Main article: <a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"The Hitchhiker's Guide to the Galaxy\">The Hitchhiker's Guide to the Galaxy</a></div>\n<p><i>The Hitchhiker's Guide to the Galaxy</i> was a concept for a science-fiction comedy radio series pitched by Adams and radio producer <a href=\"/wiki/Simon_Brett\" title=\"Simon Brett\">Simon Brett</a> to <a href=\"/wiki/BBC_Radio_4\" title=\"BBC Radio 4\">BBC Radio 4</a> in 1977. Adams came up with an outline for a pilot episode, as well as a few other stories (reprinted in <a href=\"/wiki/Neil_Gaiman\" title=\"Neil Gaiman\">Neil Gaiman</a>'s book <i><a href=\"/wiki/Don%27t_Panic:_The_Official_Hitchhiker%27s_Guide_to_the_Galaxy_Companion\" title=\"Don't Panic: The Official Hitchhiker's Guide to the Galaxy Companion\">Don't Panic: The Official Hitchhiker's Guide to the Galaxy Companion</a></i>) that could potentially be used in the series.</p>\n<div class=\"thumb tright\">\n<div class=\"thumbinner\" style=\"width:172px;\"><a href=\"/wiki/File:Towelday-Innsbruck.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/1/17/Towelday-Innsbruck.jpg/170px-Towelday-Innsbruck.jpg\" width=\"170\" height=\"227\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/1/17/Towelday-Innsbruck.jpg/255px-Towelday-Innsbruck.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/1/17/Towelday-Innsbruck.jpg/340px-Towelday-Innsbruck.jpg 2x\" data-file-width=\"450\" data-file-height=\"600\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/File:Towelday-Innsbruck.jpg\" class=\"internal\" title=\"Enlarge\"></a></div>\n<a href=\"/wiki/Towel_Day\" title=\"Towel Day\">Towel Day</a> 2005 in Innsbruck, Austria, where Adams first had the idea of <i>The Hitchhiker's Guide</i>. In the novels a towel is the most useful thing a space traveller can have. The annual Towel Day (25 May) was first celebrated in 2001, two weeks after Adams's death.</div>\n</div>\n</div>\n<p>According to Adams, the idea for the title occurred to him while he lay drunk in a field in <a href=\"/wiki/Innsbruck\" title=\"Innsbruck\">Innsbruck</a>, Austria, gazing at the stars. He was carrying a copy of the <i><a href=\"/wiki/Hitch-hiker%27s_Guide_to_Europe\" title=\"Hitch-hiker's Guide to Europe\">Hitch-hiker's Guide to Europe</a></i>, and it occurred to him that \"somebody ought to write a <i>Hitchhiker's Guide to the Galaxy</i>\". He later said that the constant repetition of this anecdote had obliterated his memory of the actual event.<sup id=\"cite_ref-15\" class=\"reference\"><a href=\"#cite_note-15\">[15]</a></sup></p>\n<p>Despite the original outline, Adams was said to make up the stories as he wrote. He turned to <a href=\"/wiki/John_Lloyd_(producer)\" title=\"John Lloyd (producer)\">John Lloyd</a> for help with the final two episodes of <a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_Primary_and_Secondary_Phases#The_Primary_Phase\" title=\"The Hitchhiker's Guide to the Galaxy Primary and Secondary Phases\">the first series</a>. Lloyd contributed bits from an unpublished science fiction book of his own, called <i>GiGax</i>.<sup id=\"cite_ref-16\" class=\"reference\"><a href=\"#cite_note-16\">[16]</a></sup> Very little of Lloyd's material survived in later adaptations of <i>Hitchhiker's</i>, such as the novels and the TV series. The TV series was based on the first six radio episodes, and sections contributed by Lloyd were largely re-written.</p>\n<p><a href=\"/wiki/BBC_Radio_4\" title=\"BBC Radio 4\">BBC Radio 4</a> broadcast the first radio series weekly in the UK in March and April 1978. The series was distributed in the United States by <a href=\"/wiki/National_Public_Radio\" class=\"mw-redirect\" title=\"National Public Radio\">National Public Radio</a>. Following the success of the first series, another episode was recorded and broadcast, which was commonly known as the Christmas Episode. <a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_Primary_and_Secondary_Phases#The_Secondary_Phase\" title=\"The Hitchhiker's Guide to the Galaxy Primary and Secondary Phases\">A second series</a> of five episodes was broadcast one per night, during the week of 21–25 January 1980.</p>\n<p>While working on the radio series (and with simultaneous projects such as <i><a href=\"/wiki/The_Pirate_Planet\" title=\"The Pirate Planet\">The Pirate Planet</a></i>) Adams developed problems keeping to writing deadlines that only got worse as he published novels. Adams was never a prolific writer and usually had to be forced by others to do any writing. This included being locked in a hotel suite with his editor for three weeks to ensure that <i><a href=\"/wiki/So_Long,_and_Thanks_for_All_the_Fish\" title=\"So Long, and Thanks for All the Fish\">So Long, and Thanks for All the Fish</a></i> was completed.<sup id=\"cite_ref-17\" class=\"reference\"><a href=\"#cite_note-17\">[17]</a></sup> He was quoted as saying, \"I love deadlines. I love the whooshing noise they make as they go by.\"<sup id=\"cite_ref-Simpson_236_18-0\" class=\"reference\"><a href=\"#cite_note-Simpson_236-18\">[18]</a></sup> Despite the difficulty with deadlines, Adams wrote five novels in the series, published in 1979, 1980, 1982, 1984, and 1992.</p>\n<p>The books formed the basis for other adaptations, such as three-part comic book adaptations for each of the first three books, an interactive text-adventure <a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(computer_game)\" class=\"mw-redirect\" title=\"The Hitchhiker's Guide to the Galaxy (computer game)\">computer game</a>, and a photo-illustrated edition, published in 1994. This latter edition featured a <a href=\"/wiki/42_Puzzle\" class=\"mw-redirect\" title=\"42 Puzzle\">42 Puzzle</a> designed by Adams, which was later incorporated into paperback covers of the first four <i>Hitchhiker's</i> novels (the paperback for the fifth re-used the artwork from the hardback edition).<sup id=\"cite_ref-19\" class=\"reference\"><a href=\"#cite_note-19\">[19]</a></sup></p>\n<p>In 1980 Adams also began attempts to turn the first <i>Hitchhiker's</i> novel into a movie, making several trips to Los Angeles, and working with a number of Hollywood studios and potential producers. The next year, the radio series became the basis for a BBC television mini-series<sup id=\"cite_ref-20\" class=\"reference\"><a href=\"#cite_note-20\">[20]</a></sup> broadcast in six parts. When he died in 2001 in California, he had been trying again to get the movie project started with <a href=\"/wiki/Disney\" class=\"mw-redirect\" title=\"Disney\">Disney</a>, which had bought the rights in 1998. The screenplay finally got a posthumous re-write by <a href=\"/wiki/Karey_Kirkpatrick\" title=\"Karey Kirkpatrick\">Karey Kirkpatrick</a>, and <a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(film)\" title=\"The Hitchhiker's Guide to the Galaxy (film)\">the resulting film</a> was released in 2005.</p>\n<p>Radio producer <a href=\"/wiki/Dirk_Maggs\" title=\"Dirk Maggs\">Dirk Maggs</a> had consulted with Adams, first in 1993, and later in 1997 and 2000 about creating a third radio series, based on the third novel in the <i>Hitchhiker's</i> series.<sup id=\"cite_ref-21\" class=\"reference\"><a href=\"#cite_note-21\">[21]</a></sup> They also discussed the possibilities of radio adaptations of the final two novels in the five-book \"trilogy\". As with the movie, this project was only realised after Adams's death. The third series, <i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_Tertiary_to_Quintessential_Phases#The_Tertiary_Phase\" title=\"The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases\">The Tertiary Phase</a></i>, was broadcast on <a href=\"/wiki/BBC_Radio_4\" title=\"BBC Radio 4\">BBC Radio 4</a> in September 2004 and was subsequently released on audio CD. With the aid of a recording of his reading of <i>Life, the Universe and Everything</i> and editing, Adams can be heard playing the part of Agrajag posthumously. <i>So Long, and Thanks for All the Fish</i> and <i>Mostly Harmless</i> made up the fourth and fifth radio series, respectively (on radio they were titled <i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_Tertiary_to_Quintessential_Phases#The_Quandary_Phase\" title=\"The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases\">The Quandary Phase</a></i> and <i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_Tertiary_to_Quintessential_Phases#The_Quintessential_Phase\" title=\"The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases\">The Quintessential Phase</a></i>) and these were broadcast in May and June 2005, and also subsequently released on Audio CD. The last episode in the last series (with a new, \"more upbeat\" ending) concluded with, \"The very final episode of <i>The Hitchhiker's Guide to the Galaxy</i> by Douglas Adams is affectionately dedicated to its author.\"<sup id=\"cite_ref-22\" class=\"reference\"><a href=\"#cite_note-22\">[22]</a></sup></p>\n<h4><span class=\"mw-headline\" id=\"Dirk_Gently_series\"><i>Dirk Gently</i> series</span></h4>\n<div class=\"thumb tright\">\n<div class=\"thumbinner\" style=\"width:222px;\"><a href=\"/wiki/File:Douglas_Adams_San_Francisco.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/e/ee/Douglas_Adams_San_Francisco.jpg/220px-Douglas_Adams_San_Francisco.jpg\" width=\"220\" height=\"165\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/e/ee/Douglas_Adams_San_Francisco.jpg/330px-Douglas_Adams_San_Francisco.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/e/ee/Douglas_Adams_San_Francisco.jpg/440px-Douglas_Adams_San_Francisco.jpg 2x\" data-file-width=\"1024\" data-file-height=\"768\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/File:Douglas_Adams_San_Francisco.jpg\" class=\"internal\" title=\"Enlarge\"></a></div>\nAdams in March 2000</div>\n</div>\n</div>\n<p>In between Adams's first trip to Madagascar with <a href=\"/wiki/Mark_Carwardine\" title=\"Mark Carwardine\">Mark Carwardine</a> in 1985, and their series of travels that formed the basis for the radio series and non-fiction book <i><a href=\"/wiki/Last_Chance_to_See\" title=\"Last Chance to See\">Last Chance to See</a></i>, Adams wrote two other novels with a new cast of characters. <i><a href=\"/wiki/Dirk_Gently%27s_Holistic_Detective_Agency\" title=\"Dirk Gently's Holistic Detective Agency\">Dirk Gently's Holistic Detective Agency</a></i> was first published in 1987, and was described by its author as \"a kind of ghost-horror-detective-time-travel-romantic-comedy-epic, mainly concerned with mud, music and quantum mechanics\".<sup id=\"cite_ref-23\" class=\"reference\"><a href=\"#cite_note-23\">[23]</a></sup> It was derived from two Doctor Who serials Adams had written.</p>\n<p>A sequel novel, <i><a href=\"/wiki/The_Long_Dark_Tea-Time_of_the_Soul\" title=\"The Long Dark Tea-Time of the Soul\">The Long Dark Tea-Time of the Soul</a></i>, was published a year later. This was an entirely original work, Adams's first since <i>So Long, and Thanks for All the Fish.</i> After the book tour, Adams set off on his round-the-world excursion which supplied him with the material for <i>Last Chance to See</i>.</p>\n<h4><span class=\"mw-headline\" id=\"Doctor_Who\"><i>Doctor Who</i></span></h4>\n<div role=\"note\" class=\"hatnote\">Main article: <a href=\"/wiki/Doctor_Who\" title=\"Doctor Who\">Doctor Who</a></div>\n<p>Adams sent the script for the <i>HHGG</i> pilot radio programme to the <i>Doctor Who</i> production office in 1978, and was commissioned to write <i><a href=\"/wiki/The_Pirate_Planet\" title=\"The Pirate Planet\">The Pirate Planet</a></i> (see below). He had also previously attempted to submit a potential movie script, called \"Doctor Who and the Krikkitmen\", which later became his novel <i>Life, the Universe and Everything</i> (which in turn became the third <i>Hitchhiker's Guide</i> radio series). Adams then went on to serve as script editor on the show for its seventeenth season in 1979. Altogether, he wrote three <a href=\"/wiki/List_of_Doctor_Who_serials\" title=\"List of Doctor Who serials\"><i>Doctor Who</i> serials</a> starring <a href=\"/wiki/Tom_Baker\" title=\"Tom Baker\">Tom Baker</a> as <a href=\"/wiki/The_Doctor_(Doctor_Who)\" title=\"The Doctor (Doctor Who)\">the Doctor</a>:</p>\n<ul>\n<li>\"<a href=\"/wiki/The_Pirate_Planet\" title=\"The Pirate Planet\">The Pirate Planet</a>\" (the second serial in the \"<a href=\"/wiki/The_Key_to_Time\" class=\"mw-redirect\" title=\"The Key to Time\">Key to Time</a>\" arc, in <a href=\"/wiki/Doctor_Who_(season_16)\" class=\"mw-redirect\" title=\"Doctor Who (season 16)\">season 16</a>)</li>\n<li>\"<a href=\"/wiki/City_of_Death\" title=\"City of Death\">City of Death</a>\" (with producer <a href=\"/wiki/Graham_Williams_(television_producer)\" title=\"Graham Williams (television producer)\">Graham Williams</a>, from an original storyline by writer <a href=\"/wiki/David_Fisher_(writer)\" title=\"David Fisher (writer)\">David Fisher</a>. It was transmitted under the pseudonym \"<a href=\"/wiki/David_Agnew\" title=\"David Agnew\">David Agnew</a>\")</li>\n<li>\"<a href=\"/wiki/Shada\" class=\"mw-redirect\" title=\"Shada\">Shada</a>\" (only partially filmed; not televised due to <a href=\"/wiki/Strike_action\" title=\"Strike action\">industry disputes</a>)</li>\n</ul>\n<p>The episodes authored by Adams are some of the few that were not novelised as Adams would not allow anyone else to write them, and asked for a higher price than the publishers were willing to pay.<sup id=\"cite_ref-24\" class=\"reference\"><a href=\"#cite_note-24\">[24]</a></sup> \"Shada\" was later adapted as a novel by <a href=\"/wiki/Gareth_Roberts_(writer)\" title=\"Gareth Roberts (writer)\">Gareth Roberts</a> in 2012 and \"City of Death\" by <a href=\"/wiki/James_Goss_(producer)\" title=\"James Goss (producer)\">James Goss</a> in 2015.</p>\n<p>Adams was also known to allow in-jokes from <i>The Hitchhiker's Guide</i> to appear in the <i>Doctor Who</i> stories he wrote and other stories on which he served as Script Editor. Subsequent writers have also inserted <i>Hitchhiker's</i> references, even <a href=\"/wiki/The_Rings_of_Akhaten\" title=\"The Rings of Akhaten\">as recently as 2013</a>. Conversely, at least one reference to <i>Doctor Who</i> was worked into a <i>Hitchhiker's</i> novel. In <i><a href=\"/wiki/Life,_the_Universe_and_Everything\" title=\"Life, the Universe and Everything\">Life, the Universe and Everything</a></i>, two characters travel in time and land on the pitch at <a href=\"/wiki/Lord%27s_Cricket_Ground\" class=\"mw-redirect\" title=\"Lord's Cricket Ground\">Lord's Cricket Ground</a>. The reaction of the radio commentators to their sudden appearance is very similar to the reactions of commentators in a scene in the eighth episode of the 1965–66-story <i><a href=\"/wiki/The_Daleks%27_Master_Plan\" title=\"The Daleks' Master Plan\">The Daleks' Master Plan</a></i>, which has the Doctor's <a href=\"/wiki/TARDIS\" title=\"TARDIS\">TARDIS</a> <a href=\"/wiki/Materialization_(science_fiction)\" class=\"mw-redirect\" title=\"Materialization (science fiction)\">materialise</a> on the pitch at Lord's.</p>\n<p>Elements of <i>Shada</i> and <i>City of Death</i> were reused in Adams's later novel <i><a href=\"/wiki/Dirk_Gently%27s_Holistic_Detective_Agency\" title=\"Dirk Gently's Holistic Detective Agency\">Dirk Gently's Holistic Detective Agency</a></i>, in particular the character of <a href=\"/wiki/Professor_Chronotis\" title=\"Professor Chronotis\">Professor Chronotis</a>. <a href=\"/wiki/Big_Finish_Productions\" title=\"Big Finish Productions\">Big Finish Productions</a> eventually remade <i>Shada</i> as an audio play starring <a href=\"/wiki/Paul_McGann\" title=\"Paul McGann\">Paul McGann</a> as the Doctor. Accompanied by partially animated illustrations, it was <a href=\"/wiki/Doctor_Who_spin-offs#Webcasts\" title=\"Doctor Who spin-offs\">webcast</a> on the <a href=\"/wiki/BBC_Online\" title=\"BBC Online\">BBC website</a> in 2003, and subsequently released as a two-CD set later that year. An omnibus edition of this version was broadcast on the digital radio station <a href=\"/wiki/BBC7\" class=\"mw-redirect\" title=\"BBC7\">BBC7</a> on 10 December 2005.</p>\n<p>In the <i>Doctor Who</i> 2012 Christmas episode <i><a href=\"/wiki/The_Snowmen#Production\" title=\"The Snowmen\">The Snowmen</a></i>, writer <a href=\"/wiki/Steven_Moffat\" title=\"Steven Moffat\">Steven Moffat</a> was inspired by a storyline that Adams pitched called <i>The Doctor Retires</i>.<sup id=\"cite_ref-25\" class=\"reference\"><a href=\"#cite_note-25\">[25]</a></sup></p>\n<p>While he was at school,<sup class=\"noprint Inline-Template\" style=\"white-space:nowrap;\">[<i><a href=\"/wiki/Wikipedia:Avoid_weasel_words\" class=\"mw-redirect\" title=\"Wikipedia:Avoid weasel words\"><span title=\"The material near this tag possibly uses too vague attribution or weasel words. (October 2015)\">which?</span></a></i>]</sup> he wrote and performed a play called <i>Doctor Which</i>.<sup id=\"cite_ref-Adams_xx_26-0\" class=\"reference\"><a href=\"#cite_note-Adams_xx-26\">[26]</a></sup></p>\n<h3><span class=\"mw-headline\" id=\"Music\">Music</span></h3>\n<p>Adams played the guitar left-handed and had a collection of twenty-four left-handed guitars when he died (having received his first guitar in 1964). He also studied piano in the 1960s with the same teacher as <a href=\"/wiki/Paul_Wickens\" title=\"Paul Wickens\">Paul Wickens</a>, the pianist who plays in <a href=\"/wiki/Paul_McCartney\" title=\"Paul McCartney\">Paul McCartney</a>'s band (and composed the music for the 2004–2005 editions of the <i>Hitchhiker's Guide</i> radio series).<sup id=\"cite_ref-27\" class=\"reference\"><a href=\"#cite_note-27\">[27]</a></sup> <a href=\"/wiki/Pink_Floyd\" title=\"Pink Floyd\">Pink Floyd</a> and <a href=\"/wiki/Procol_Harum\" title=\"Procol Harum\">Procol Harum</a> had important influence on Adams's work.</p>\n<h4><span class=\"mw-headline\" id=\"Pink_Floyd\">Pink Floyd</span></h4>\n<p>Adams included a reference to <a href=\"/wiki/Pink_Floyd\" title=\"Pink Floyd\">Pink Floyd</a> in the original radio version of <i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"The Hitchhiker's Guide to the Galaxy\">The Hitchhiker's Guide to the Galaxy</a></i>, in which he describes the main characters surveying the landscape of an alien planet while Marvin, their android companion, hums Pink Floyd's \"<a href=\"/wiki/Shine_on_You_Crazy_Diamond\" class=\"mw-redirect\" title=\"Shine on You Crazy Diamond\">Shine on You Crazy Diamond</a>\" (Part 1). This was cut out of the CD version. Adams also compared the various noises that the <a href=\"/wiki/Kakapo\" title=\"Kakapo\">kakapo</a> makes to \"Pink Floyd studio out-takes\" in his non-fiction book on endangered species, <i><a href=\"/wiki/Last_Chance_to_See\" title=\"Last Chance to See\">Last Chance to See</a></i>.</p>\n<p>Adams's official biography shares its name with the song \"<a href=\"/wiki/Wish_You_Were_Here_(1975_song)\" class=\"mw-redirect\" title=\"Wish You Were Here (1975 song)\">Wish You Were Here</a>\" by Pink Floyd. Adams was friends with Pink Floyd guitarist <a href=\"/wiki/David_Gilmour\" title=\"David Gilmour\">David Gilmour</a> and, on Adams's 42nd birthday, he was invited to make a guest appearance at Pink Floyd's concert of 28 October 1994 at Earls Court in London, playing guitar on the songs \"<a href=\"/wiki/Brain_Damage_(song)\" title=\"Brain Damage (song)\">Brain Damage</a>\" and \"<a href=\"/wiki/Eclipse_(song)\" title=\"Eclipse (song)\">Eclipse</a>\".<sup id=\"cite_ref-Mabbett-MM_28-0\" class=\"reference\"><a href=\"#cite_note-Mabbett-MM-28\">[28]</a></sup> Adams chose the name for Pink Floyd's 1994 album, <i><a href=\"/wiki/The_Division_Bell\" title=\"The Division Bell\">The Division Bell</a></i>, by picking the words from the lyrics to one of its tracks, \"High Hopes\".<sup id=\"cite_ref-Mabbett-MM_28-1\" class=\"reference\"><a href=\"#cite_note-Mabbett-MM-28\">[28]</a></sup> Gilmour also performed at Adams's memorial service in 2001, and what would have been Adams's 60th birthday party in 2012.</p>\n<h4><span class=\"mw-headline\" id=\"Procol_Harum\">Procol Harum</span></h4>\n<p>Adams was a friend of <a href=\"/wiki/Gary_Brooker\" title=\"Gary Brooker\">Gary Brooker</a>, the lead singer, pianist and songwriter of <a href=\"/wiki/Procol_Harum\" title=\"Procol Harum\">Procol Harum</a>. Adams invited Brooker to one of the many parties that Adams held at his house. On one such occasion Gary Brooker performed the full (4 verse) version of \"<a href=\"/wiki/A_Whiter_Shade_of_Pale\" title=\"A Whiter Shade of Pale\">A Whiter Shade of Pale</a>\". Brooker also performed at Adams's memorial service.</p>\n<p>Adams appeared on stage with Brooker to perform \"In Held 'Twas in I\" at Redhill when the band's lyricist <a href=\"/wiki/Keith_Reid\" title=\"Keith Reid\">Keith Reid</a> was not available. On several other occasions he introduced Procol Harum at their gigs.</p>\n<p>Adams would listen to music while writing, and this would occasionally influence his work. On one occasion the title track from the Procol Harum album <i><a href=\"/wiki/Grand_Hotel_(album)\" title=\"Grand Hotel (album)\">Grand Hotel</a></i> was playing when</p>\n<blockquote class=\"templatequote\">\n<p>Suddenly in the middle of the song there was this huge orchestral climax that came out of nowhere and did not seem to be about anything. I kept wondering what was this huge thing happening in the background? And I eventually thought&#160;... it sounds as if there ought to be some sort of floorshow going on. Something huge and extraordinary, like, well, like the end of the universe. And so that was where the idea for The Restaurant at the End of the Universe came from.</p>\n<div class=\"templatequotecite\"><cite>— Douglas Adams, Procol Harum at The Barbican<sup id=\"cite_ref-29\" class=\"reference\"><a href=\"#cite_note-29\">[29]</a></sup></cite></div>\n</blockquote>\n<h3><span class=\"mw-headline\" id=\"Computer_games_and_projects\">Computer games and projects</span></h3>\n<p>Douglas Adams created an <a href=\"/wiki/Interactive_fiction\" title=\"Interactive fiction\">interactive fiction</a> version of <i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(computer_game)\" class=\"mw-redirect\" title=\"The Hitchhiker's Guide to the Galaxy (computer game)\">HHGG</a></i> with <a href=\"/wiki/Steve_Meretzky\" title=\"Steve Meretzky\">Steve Meretzky</a> from <a href=\"/wiki/Infocom\" title=\"Infocom\">Infocom</a> in 1984. In 1986 he participated in a week-long brainstorming session with the <a href=\"/wiki/Lucasfilm_Games\" class=\"mw-redirect\" title=\"Lucasfilm Games\">Lucasfilm Games</a> team for the game <i><a href=\"/wiki/Labyrinth:_The_Computer_Game\" title=\"Labyrinth: The Computer Game\">Labyrinth</a></i>. Later he was also involved in creating <i><a href=\"/wiki/Bureaucracy_(computer_game)\" class=\"mw-redirect\" title=\"Bureaucracy (computer game)\">Bureaucracy</a></i> (also by Infocom, but not based on any book; Adams wrote it as a parody of events in his own life).</p>\n<p>Adams was a founder-director and Chief Fantasist of <a href=\"/wiki/The_Digital_Village\" title=\"The Digital Village\">The Digital Village</a>, a digital media and Internet company with which he created <i><a href=\"/wiki/Starship_Titanic\" title=\"Starship Titanic\">Starship Titanic</a></i>, a <a href=\"/wiki/Codie\" class=\"mw-redirect\" title=\"Codie\">Codie</a> Award-winning and <a href=\"/wiki/BAFTA#Games_Awards\" class=\"mw-redirect\" title=\"BAFTA\">BAFTA-nominated adventure game</a>, which was published in 1998 by <a href=\"/wiki/Simon_%26_Schuster\" title=\"Simon &amp; Schuster\">Simon &amp; Schuster</a>.<sup id=\"cite_ref-bbc.co.uk_30-0\" class=\"reference\"><a href=\"#cite_note-bbc.co.uk-30\">[30]</a></sup><sup id=\"cite_ref-31\" class=\"reference\"><a href=\"#cite_note-31\">[31]</a></sup> <a href=\"/wiki/Terry_Jones\" title=\"Terry Jones\">Terry Jones</a> wrote the accompanying book, entitled <i>Douglas Adams Starship Titanic</i>, since Adams was too busy with the computer game to do both. In April 1999, Adams initiated the <a href=\"/wiki/H2g2\" title=\"H2g2\">h2g2</a> <a href=\"/wiki/Collaborative_writing\" title=\"Collaborative writing\">collaborative writing</a> project, an experimental attempt at making <i>The Hitchhiker's Guide to the Galaxy</i> a reality, and at harnessing the collective brainpower of the internet community. It found a new home at BBC Online in 2001.<sup id=\"cite_ref-bbc.co.uk_30-1\" class=\"reference\"><a href=\"#cite_note-bbc.co.uk-30\">[30]</a></sup></p>\n<p>In 1990 Adams wrote and presented a television documentary programme <i><a href=\"/wiki/Hyperland\" title=\"Hyperland\">Hyperland</a></i><sup id=\"cite_ref-32\" class=\"reference\"><a href=\"#cite_note-32\">[32]</a></sup> which featured <a href=\"/wiki/Tom_Baker\" title=\"Tom Baker\">Tom Baker</a> as a \"software agent\" (similar to the assistant pictured in Apple's <a href=\"/wiki/Knowledge_Navigator\" title=\"Knowledge Navigator\">Knowledge Navigator</a> video of future concepts from 1987), and interviews with <a href=\"/wiki/Ted_Nelson\" title=\"Ted Nelson\">Ted Nelson</a>, the co-inventor of <a href=\"/wiki/Hypertext\" title=\"Hypertext\">hypertext</a> and the person who coined the term. Although Adams did not invent hypertext, he was an <a href=\"/wiki/Early_adopter\" title=\"Early adopter\">early adopter</a> and advocate of it. This was the same year that <a href=\"/wiki/Tim_Berners-Lee\" title=\"Tim Berners-Lee\">Tim Berners-Lee</a> used the idea of hypertext in his <a href=\"/wiki/HTML\" title=\"HTML\">HTML</a>.</p>\n<h2><span class=\"mw-headline\" id=\"Personal_beliefs_and_activism\">Personal beliefs and activism</span></h2>\n<h3><span class=\"mw-headline\" id=\"Atheism_and_views_on_religion\">Atheism and views on religion</span></h3>\n<p>Adams described himself as a \"radical <a href=\"/wiki/Atheist\" class=\"mw-redirect\" title=\"Atheist\">atheist</a>\", adding <i>radical</i> for emphasis so he would not be asked if he meant agnostic. He told <a href=\"/wiki/American_Atheists\" title=\"American Atheists\">American Atheists</a> that this made things easier, but most importantly it conveyed the fact that he really meant it. \"I am convinced that there is not a god,\" he said. He imagined a <a href=\"/wiki/Fine-tuned_Universe#In_popular_culture\" title=\"Fine-tuned Universe\">sentient puddle</a> who wakes up one morning and thinks, \"This is an interesting world I find myself in – an interesting hole I find myself in – fits me rather neatly, doesn't it? In fact it fits me staggeringly well, must have been made to have me in it!\" to demonstrate his view that the <a href=\"/wiki/Fine-tuned_Universe\" title=\"Fine-tuned Universe\">fine-tuned Universe</a> argument for God was a fallacy.<sup id=\"cite_ref-33\" class=\"reference\"><a href=\"#cite_note-33\">[33]</a></sup></p>\n<p>Despite this, he remained fascinated by religion because of its effect on human affairs. \"I love to keep poking and prodding at it. I've thought about it so much over the years that that fascination is bound to spill over into my writing.\"<sup id=\"cite_ref-amath_34-0\" class=\"reference\"><a href=\"#cite_note-amath-34\">[34]</a></sup></p>\n<p>The evolutionary biologist and atheist <a href=\"/wiki/Richard_Dawkins\" title=\"Richard Dawkins\">Richard Dawkins</a> uses Adams's influence throughout to exemplify arguments for non-belief in his 2006 book <i><a href=\"/wiki/The_God_Delusion\" title=\"The God Delusion\">The God Delusion</a></i>. Dawkins dedicated the book to Adams, whom he jokingly called \"possibly [my] only convert\" to atheism<sup id=\"cite_ref-TheGuardian_35-0\" class=\"reference\"><a href=\"#cite_note-TheGuardian-35\">[35]</a></sup> and wrote on his death that \"Science has lost a friend, literature has lost a luminary, the <a href=\"/wiki/Mountain_gorilla\" title=\"Mountain gorilla\">mountain gorilla</a> and the <a href=\"/wiki/Black_rhino\" class=\"mw-redirect\" title=\"Black rhino\">black rhino</a> have lost a gallant defender.\"<sup id=\"cite_ref-Dawkins2001_36-0\" class=\"reference\"><a href=\"#cite_note-Dawkins2001-36\">[36]</a></sup></p>\n<h3><span class=\"mw-headline\" id=\"Environmental_activism\">Environmental activism</span></h3>\n<p>Adams was also an <a href=\"/wiki/Environmental_activist\" class=\"mw-redirect\" title=\"Environmental activist\">environmental activist</a> who campaigned on behalf of <a href=\"/wiki/Endangered_species\" title=\"Endangered species\">endangered species</a>. This activism included the production of the non-fiction radio series <i><a href=\"/wiki/Last_Chance_to_See\" title=\"Last Chance to See\">Last Chance to See</a></i>, in which he and <a href=\"/wiki/Natural_history\" title=\"Natural history\">naturalist</a> <a href=\"/wiki/Mark_Carwardine\" title=\"Mark Carwardine\">Mark Carwardine</a> visited rare species such as the <a href=\"/wiki/Kakapo\" title=\"Kakapo\">kakapo</a> and <a href=\"/wiki/Chinese_river_dolphin\" class=\"mw-redirect\" title=\"Chinese river dolphin\">baiji</a>, and the publication of a tie-in book of the same name. In 1992 this was made into a CD-ROM combination of <a href=\"/wiki/Audiobook\" title=\"Audiobook\">audiobook</a>, <a href=\"/wiki/E-book\" title=\"E-book\">e-book</a> and picture slide show.</p>\n<p>Adams and Mark Carwardine contributed the 'Meeting a Gorilla' passage from <i><a href=\"/wiki/Last_Chance_to_See\" title=\"Last Chance to See\">Last Chance to See</a></i> to the book <i><a href=\"/wiki/Great_Ape_Project\" title=\"Great Ape Project\">The Great Ape Project</a></i>.<sup id=\"cite_ref-37\" class=\"reference\"><a href=\"#cite_note-37\">[37]</a></sup> This book, edited by <a href=\"/wiki/Paola_Cavalieri\" title=\"Paola Cavalieri\">Paola Cavalieri</a> and <a href=\"/wiki/Peter_Singer\" title=\"Peter Singer\">Peter Singer</a>, launched a wider-scale project in 1993, which calls for the extension of moral equality to include all great apes, human and non-human.</p>\n<p>In 1994 he participated in a climb of <a href=\"/wiki/Mount_Kilimanjaro\" title=\"Mount Kilimanjaro\">Mount Kilimanjaro</a> while wearing a rhino suit for the British charity organisation <i><a href=\"/wiki/Save_the_Rhino\" title=\"Save the Rhino\">Save the Rhino International</a></i>. Puppeteer <a href=\"/wiki/William_Todd-Jones\" title=\"William Todd-Jones\">William Todd-Jones</a>, who had originally worn the suit in the London Marathon to raise money and bring awareness to the group, also participated in the climb wearing a rhino suit; Adams wore the suit while travelling to the mountain before the climb began. About £100,000 was raised through that event, benefiting schools in <a href=\"/wiki/Kenya\" title=\"Kenya\">Kenya</a> and a <a href=\"/wiki/Black_rhinoceros\" title=\"Black rhinoceros\">black rhinoceros</a> preservation programme in <a href=\"/wiki/Tanzania\" title=\"Tanzania\">Tanzania</a>. Adams was also an active supporter of the <i><a href=\"/wiki/Dian_Fossey\" title=\"Dian Fossey\">Dian Fossey</a> Gorilla Fund</i>.</p>\n<p>Since 2003, <i>Save the Rhino</i> has held an annual Douglas Adams Memorial Lecture around the time of his birthday to raise money for environmental campaigns.<sup id=\"cite_ref-38\" class=\"reference\"><a href=\"#cite_note-38\">[38]</a></sup> The lectures in the series are:</p>\n<ul>\n<li>2003 <a href=\"/wiki/Richard_Dawkins\" title=\"Richard Dawkins\">Richard Dawkins</a> – <i>Queerer than we can suppose: the strangeness of science</i></li>\n<li>2004 <a href=\"/wiki/Robert_Swan\" title=\"Robert Swan\">Robert Swan</a> – <i>Mission Antarctica</i></li>\n<li>2005 <a href=\"/wiki/Mark_Carwardine\" title=\"Mark Carwardine\">Mark Carwardine</a> – <i>Last Chance to See... Just a bit more</i></li>\n<li>2006 <a href=\"/wiki/Robert_Winston\" title=\"Robert Winston\">Robert Winston</a> – <i>Is the Human an Endangered Species?</i></li>\n<li>2007 <a href=\"/wiki/Richard_Leakey\" title=\"Richard Leakey\">Richard Leakey</a> – <i>Wildlife Management in East Africa – Is there a future?</i></li>\n<li>2008 <a href=\"/wiki/Steven_Pinker\" title=\"Steven Pinker\">Steven Pinker</a> – <i>The Stuff of Thought, Language as a Window into Human Nature</i></li>\n<li>2009 <a href=\"/wiki/Benedict_Allen\" title=\"Benedict Allen\">Benedict Allen</a> – <i>Unbreakable</i></li>\n<li>2010 <a href=\"/wiki/Marcus_du_Sautoy\" title=\"Marcus du Sautoy\">Marcus du Sautoy</a> – <i>42: the answer to life, the universe and prime numbers</i></li>\n<li>2011 <a href=\"/wiki/Brian_Cox_(physicist)\" title=\"Brian Cox (physicist)\">Brian Cox</a> – <i>The Universe and Why We Should Explore It</i></li>\n<li>2012 Lecture replaced by \"Douglas Adams The Party\"<sup id=\"cite_ref-39\" class=\"reference\"><a href=\"#cite_note-39\">[39]</a></sup></li>\n<li>2013 <a href=\"/wiki/Adam_Rutherford\" title=\"Adam Rutherford\">Adam Rutherford</a> – <i>Creation: the origin and the future of life</i><sup id=\"cite_ref-40\" class=\"reference\"><a href=\"#cite_note-40\">[40]</a></sup></li>\n<li>2014 <a href=\"/wiki/Roger_Highfield\" title=\"Roger Highfield\">Roger Highfield</a> and <a href=\"/wiki/Simon_Singh\" title=\"Simon Singh\">Simon Singh</a> – <i>The Science of Harry Potter and the Mathematics of The Simpsons</i><sup id=\"cite_ref-41\" class=\"reference\"><a href=\"#cite_note-41\">[41]</a></sup></li>\n<li>2015 <a href=\"/wiki/Neil_Gaiman\" title=\"Neil Gaiman\">Neil Gaiman</a> – <i>Immortality and Douglas Adams</i><sup id=\"cite_ref-42\" class=\"reference\"><a href=\"#cite_note-42\">[42]</a></sup></li>\n<li>2016 <a href=\"/wiki/Alice_Roberts\" title=\"Alice Roberts\">Alice Roberts</a> – <i>Survivors of the Ice Age</i><sup id=\"cite_ref-43\" class=\"reference\"><a href=\"#cite_note-43\">[43]</a></sup></li>\n</ul>\n<h3><span class=\"mw-headline\" id=\"Technology_and_innovation\">Technology and innovation</span></h3>\n<p>Adams bought his first <a href=\"/wiki/Word_processor\" title=\"Word processor\">word processor</a> in 1982, having considered one as early as 1979. His first purchase was a 'Nexus'. In 1983, when he and Jane Belson went out to Los Angeles, he bought a <a href=\"/wiki/Digital_Equipment_Corporation\" title=\"Digital Equipment Corporation\">DEC</a> <a href=\"/wiki/Rainbow_100\" title=\"Rainbow 100\">Rainbow</a>. Upon their return to England, Adams bought an <a href=\"/wiki/Apricot_Computers\" title=\"Apricot Computers\">Apricot</a>, then a <a href=\"/wiki/BBC_Micro\" title=\"BBC Micro\">BBC Micro</a> and a <a href=\"/wiki/Tandy_1000\" title=\"Tandy 1000\">Tandy 1000</a>.<sup id=\"cite_ref-Simpson_184-185_44-0\" class=\"reference\"><a href=\"#cite_note-Simpson_184-185-44\">[44]</a></sup> In <i><a href=\"/wiki/Last_Chance_to_See\" title=\"Last Chance to See\">Last Chance to See</a></i> Adams mentions his <a href=\"/wiki/Cambridge_Z88\" title=\"Cambridge Z88\">Cambridge Z88</a>, which he had taken to <a href=\"/wiki/Zaire\" title=\"Zaire\">Zaire</a> on a quest to find the <a href=\"/wiki/Northern_white_rhinoceros\" title=\"Northern white rhinoceros\">northern white rhinoceros</a>.<sup id=\"cite_ref-45\" class=\"reference\"><a href=\"#cite_note-45\">[45]</a></sup></p>\n<p>Adams's posthumously published work, <i><a href=\"/wiki/The_Salmon_of_Doubt\" title=\"The Salmon of Doubt\">The Salmon of Doubt</a></i>, features multiple articles by him on the subject of technology, including reprints of articles that originally ran in <i><a href=\"/wiki/MacUser\" title=\"MacUser\">MacUser</a></i> magazine, and in <i><a href=\"/wiki/The_Independent_on_Sunday\" class=\"mw-redirect\" title=\"The Independent on Sunday\">The Independent on Sunday</a></i> newspaper. In these Adams claims that one of the first computers he ever saw was a <a href=\"/wiki/Commodore_PET\" title=\"Commodore PET\">Commodore PET</a>, and that he has \"adored\" his Apple Macintosh (\"or rather my family of however many Macintoshes it is that I've recklessly accumulated over the years\") since he first saw one at Infocom's offices in Boston in 1984.<sup id=\"cite_ref-46\" class=\"reference\"><a href=\"#cite_note-46\">[46]</a></sup></p>\n<p>Adams was a Macintosh user from the time they first came out in 1984 until his death in 2001. He was the first person to buy a Mac in Europe (the second being <a href=\"/wiki/Stephen_Fry\" title=\"Stephen Fry\">Stephen Fry</a> – though some accounts differ on this, saying Fry bought his Mac first. Fry claims he was second to Adams<sup id=\"cite_ref-47\" class=\"reference\"><a href=\"#cite_note-47\">[47]</a></sup>). Adams was also an \"<a href=\"/wiki/AppleMasters\" title=\"AppleMasters\">Apple Master</a>\", one of several celebrities whom Apple made into spokespeople for its products (other Apple Masters included <a href=\"/wiki/John_Cleese\" title=\"John Cleese\">John Cleese</a> and <a href=\"/wiki/Gregory_Hines\" title=\"Gregory Hines\">Gregory Hines</a>). Adams's contributions included a rock video that he created using the first version of <a href=\"/wiki/IMovie\" title=\"IMovie\">iMovie</a> with footage featuring his daughter Polly. The video was available on Adams's <a href=\"/wiki/.Mac\" class=\"mw-redirect\" title=\".Mac\">.Mac</a> homepage. Adams installed and started using the first release of <a href=\"/wiki/Mac_OS_X\" class=\"mw-redirect\" title=\"Mac OS X\">Mac OS X</a> in the weeks leading up to his death. His very last post to his own forum was in praise of Mac OS X and the possibilities of its <a href=\"/wiki/Cocoa_(API)\" title=\"Cocoa (API)\">Cocoa</a> programming framework. He said it was \"awesome...\", which was also the last word he wrote on his site.<sup id=\"cite_ref-48\" class=\"reference\"><a href=\"#cite_note-48\">[48]</a></sup></p>\n<p>Adams used e-mail extensively long before it reached popular awareness, using it to correspond with <a href=\"/wiki/Steve_Meretzky\" title=\"Steve Meretzky\">Steve Meretzky</a> during the pair's collaboration on Infocom's version of <i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(computer_game)\" class=\"mw-redirect\" title=\"The Hitchhiker's Guide to the Galaxy (computer game)\">The Hitchhiker's Guide to the Galaxy</a></i>.<sup id=\"cite_ref-Simpson_184-185_44-1\" class=\"reference\"><a href=\"#cite_note-Simpson_184-185-44\">[44]</a></sup> While living in New Mexico in 1993 he set up another e-mail address and began posting to his own <a href=\"/wiki/USENET\" class=\"mw-redirect\" title=\"USENET\">USENET</a> newsgroup, alt.fan.douglas-adams, and occasionally, when his computer was acting up, to the comp.sys.mac hierarchy.<sup id=\"cite_ref-49\" class=\"reference\"><a href=\"#cite_note-49\">[49]</a></sup> Many of his posts are now archived through Google. Challenges to the authenticity of his messages later led Adams to set up a message forum on his own website to avoid the issue. In 1996, Adams was a keynote speaker at The <a href=\"/wiki/Microsoft\" title=\"Microsoft\">Microsoft</a> <a href=\"/wiki/Professional_Developers_Conference\" title=\"Professional Developers Conference\">Professional Developers Conference</a> (PDC) where he described the personal computer as being a modelling device. The video of his keynote speech is archived on <a href=\"/wiki/Channel_9_(discussion_forum)\" class=\"mw-redirect\" title=\"Channel 9 (discussion forum)\">Channel 9</a>.<sup id=\"cite_ref-50\" class=\"reference\"><a href=\"#cite_note-50\">[50]</a></sup> Adams was also a keynote speaker for the April 2001 <a href=\"/w/index.php?title=Embedded_Systems_Conference&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Embedded Systems Conference (page does not exist)\">Embedded Systems Conference</a> in San Francisco, one of the major technical conferences on <a href=\"/wiki/Embedded_system\" title=\"Embedded system\">embedded system</a> engineering. In his keynote speech, he shared his vision of technology and how it should contribute in everyday – and every man's – life.<sup id=\"cite_ref-51\" class=\"reference\"><a href=\"#cite_note-51\">[51]</a></sup></p>\n<h2><span class=\"mw-headline\" id=\"Personal_life\">Personal life</span></h2>\n<p>Adams moved to <a href=\"/wiki/Upper_Street\" title=\"Upper Street\">Upper Street</a>, <a href=\"/wiki/Islington\" title=\"Islington\">Islington</a>, in 1981<sup id=\"cite_ref-IPP_52-0\" class=\"reference\"><a href=\"#cite_note-IPP-52\">[52]</a></sup> and to Duncan Terrace, a few minutes' walk away, in the late 1980s.<sup id=\"cite_ref-IPP_52-1\" class=\"reference\"><a href=\"#cite_note-IPP-52\">[52]</a></sup></p>\n<p>In the early 1980s Adams had an affair with novelist <a href=\"/wiki/Sally_Emerson\" title=\"Sally Emerson\">Sally Emerson</a>, who was separated from her husband at that time. Adams later dedicated his book <i><a href=\"/wiki/Life,_the_Universe_and_Everything\" title=\"Life, the Universe and Everything\">Life, the Universe and Everything</a></i> to Emerson. In 1981 Emerson returned to her husband, <a href=\"/wiki/Peter_Stothard\" title=\"Peter Stothard\">Peter Stothard</a>, a contemporary of Adams's at <a href=\"/wiki/Brentwood_School_(England)\" class=\"mw-redirect\" title=\"Brentwood School (England)\">Brentwood School</a>, and later editor of <i><a href=\"/wiki/The_Times\" title=\"The Times\">The Times</a></i>. Adams was soon introduced by friends to Jane Belson, with whom he later became romantically involved. Belson was the \"lady barrister\" mentioned in the jacket-flap biography printed in his books during the mid-1980s (\"He [Adams] lives in Islington with a lady barrister and an Apple Macintosh\"). The two lived in Los Angeles together during 1983 while Adams worked on an early screenplay adaptation of <i>Hitchhiker's</i>. When the deal fell through, they moved back to London, and after several separations (\"He is currently not certain where he lives, or with whom\")<sup id=\"cite_ref-sfweekly_53-0\" class=\"reference\"><a href=\"#cite_note-sfweekly-53\">[53]</a></sup> and an aborted engagement, they married on 25 November 1991. Adams and Belson had one daughter together, Polly Jane Rocket Adams, born on 22 June 1994, shortly after Adams turned 42. In 1999 the family moved from London to <a href=\"/wiki/Santa_Barbara,_California\" title=\"Santa Barbara, California\">Santa Barbara, California</a>, where they lived until his death. Following the funeral, Jane Belson and Polly Adams returned to London.<sup id=\"cite_ref-54\" class=\"reference\"><a href=\"#cite_note-54\">[54]</a></sup> Jane died on 7 September 2011 of cancer, aged 59.<sup id=\"cite_ref-timesobit_55-0\" class=\"reference\"><a href=\"#cite_note-timesobit-55\">[55]</a></sup><sup id=\"cite_ref-h2g2obit_56-0\" class=\"reference\"><a href=\"#cite_note-h2g2obit-56\">[56]</a></sup></p>\n<h2><span class=\"mw-headline\" id=\"Death_and_legacy\">Death and legacy</span></h2>\n<div class=\"thumb tright\">\n<div class=\"thumbinner\" style=\"width:222px;\"><a href=\"/wiki/File:Highgate_Cemetery_-_East_-_Douglas_Adams_01.jpg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/a/aa/Highgate_Cemetery_-_East_-_Douglas_Adams_01.jpg/220px-Highgate_Cemetery_-_East_-_Douglas_Adams_01.jpg\" width=\"220\" height=\"147\" class=\"thumbimage\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/a/aa/Highgate_Cemetery_-_East_-_Douglas_Adams_01.jpg/330px-Highgate_Cemetery_-_East_-_Douglas_Adams_01.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/a/aa/Highgate_Cemetery_-_East_-_Douglas_Adams_01.jpg/440px-Highgate_Cemetery_-_East_-_Douglas_Adams_01.jpg 2x\" data-file-width=\"4189\" data-file-height=\"2793\" /></a>\n<div class=\"thumbcaption\">\n<div class=\"magnify\"><a href=\"/wiki/File:Highgate_Cemetery_-_East_-_Douglas_Adams_01.jpg\" class=\"internal\" title=\"Enlarge\"></a></div>\nAdams's gravestone, <a href=\"/wiki/Highgate_Cemetery\" title=\"Highgate Cemetery\">Highgate Cemetery</a>, North London</div>\n</div>\n</div>\n<p>Adams died of a <a href=\"/wiki/Heart_attack\" class=\"mw-redirect\" title=\"Heart attack\">heart attack</a> on 11 May 2001, aged 49, after resting from his regular workout at a private gym in <a href=\"/wiki/Montecito,_California\" title=\"Montecito, California\">Montecito, California</a>. He had unknowingly suffered a gradual narrowing of the <a href=\"/wiki/Coronary_arteries\" class=\"mw-redirect\" title=\"Coronary arteries\">coronary arteries</a>, which led at that moment to a <a href=\"/wiki/Myocardial_infarction\" title=\"Myocardial infarction\">myocardial infarction</a> and a fatal <a href=\"/wiki/Cardiac_arrhythmia\" title=\"Cardiac arrhythmia\">cardiac arrhythmia</a>.<sup class=\"noprint Inline-Template Template-Fact\" style=\"white-space:nowrap;\">[<i><a href=\"/wiki/Wikipedia:Citation_needed\" title=\"Wikipedia:Citation needed\"><span title=\"This claim needs references to reliable sources. (October 2016)\">citation needed</span></a></i>]</sup> Adams had been due to deliver the commencement address at <a href=\"/wiki/Harvey_Mudd_College\" title=\"Harvey Mudd College\">Harvey Mudd College</a> on 13 May.<sup id=\"cite_ref-57\" class=\"reference\"><a href=\"#cite_note-57\">[57]</a></sup> His funeral was held on 16 May in Santa Barbara, California. His remains were subsequently cremated and the ashes placed in <a href=\"/wiki/Highgate_Cemetery\" title=\"Highgate Cemetery\">Highgate Cemetery</a> in north London in June 2002.<sup id=\"cite_ref-Simpson_337-338_58-0\" class=\"reference\"><a href=\"#cite_note-Simpson_337-338-58\">[58]</a></sup></p>\n<p>A memorial service was held on 17 September 2001 at <a href=\"/wiki/St_Martin-in-the-Fields\" title=\"St Martin-in-the-Fields\">St Martin-in-the-Fields</a> church, <a href=\"/wiki/Trafalgar_Square\" title=\"Trafalgar Square\">Trafalgar Square</a>, London. This became the first church service broadcast live on the web by the BBC.<sup id=\"cite_ref-59\" class=\"reference\"><a href=\"#cite_note-59\">[59]</a></sup> Video clips of the service are still available on the BBC's website for download.<sup id=\"cite_ref-60\" class=\"reference\"><a href=\"#cite_note-60\">[60]</a></sup></p>\n<p>One of his last public appearances was a talk given at the University of California, Santa Barbara, <i>Parrots, the universe and everything</i>, recorded days before his death.<sup id=\"cite_ref-61\" class=\"reference\"><a href=\"#cite_note-61\">[61]</a></sup> A full transcript of the talk is available, and the university has made the full video available on <a rel=\"nofollow\" class=\"external text\" href=\"https://www.youtube.com/watch?v=_ZG8HBuDjgc\">YouTube</a>.<sup id=\"cite_ref-62\" class=\"reference\"><a href=\"#cite_note-62\">[62]</a></sup></p>\n<p>The <a href=\"/wiki/Minor_Planet_Centre\" class=\"mw-redirect\" title=\"Minor Planet Centre\">Minor Planet Centre</a> space agency named an asteroid <a href=\"/wiki/18610_Arthurdent\" title=\"18610 Arthurdent\">18610 Arthurdent</a>, coincidentally announcing its plan two days before Adams died.<sup id=\"cite_ref-MPC42677_63-0\" class=\"reference\"><a href=\"#cite_note-MPC42677-63\">[63]</a></sup> There is also an <a href=\"/wiki/25924_Douglasadams\" title=\"25924 Douglasadams\">asteroid named after Adams himself</a>.<sup id=\"cite_ref-64\" class=\"reference\"><a href=\"#cite_note-64\">[64]</a></sup></p>\n<p>In May 2002 <i><a href=\"/wiki/The_Salmon_of_Doubt\" title=\"The Salmon of Doubt\">The Salmon of Doubt</a></i> was published, containing many short stories, essays, and letters, as well as eulogies from <a href=\"/wiki/Richard_Dawkins\" title=\"Richard Dawkins\">Richard Dawkins</a>, <a href=\"/wiki/Stephen_Fry\" title=\"Stephen Fry\">Stephen Fry</a> (in the UK edition), <a href=\"/wiki/Christopher_Cerf\" title=\"Christopher Cerf\">Christopher Cerf</a> (in the US edition), and <a href=\"/wiki/Terry_Jones\" title=\"Terry Jones\">Terry Jones</a> (in the US paperback edition). It also includes eleven chapters of his long-awaited but unfinished novel, <i>The Salmon of Doubt</i>, which was originally intended to become a new <a href=\"/wiki/Dirk_Gently\" title=\"Dirk Gently\">Dirk Gently</a> novel, but might have later become the sixth <i>Hitchhiker</i> novel.<sup id=\"cite_ref-65\" class=\"reference\"><a href=\"#cite_note-65\">[65]</a></sup><sup id=\"cite_ref-66\" class=\"reference\"><a href=\"#cite_note-66\">[66]</a></sup></p>\n<p>Other events after Adams's death included a <a href=\"/wiki/Webcast\" title=\"Webcast\">webcast</a> production of <i><a href=\"/wiki/Shada\" class=\"mw-redirect\" title=\"Shada\">Shada</a></i>, allowing the complete story to be told, radio dramatisations of the final three books in the <i>Hitchhiker's</i> series, and the completion of <a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(film)\" title=\"The Hitchhiker's Guide to the Galaxy (film)\">the film adaptation</a> of <i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(book)\" class=\"mw-redirect\" title=\"The Hitchhiker's Guide to the Galaxy (book)\">The Hitchhiker's Guide to the Galaxy</a></i>. The film, released in 2005, posthumously credits Adams as a producer, and several art design elements – including a head-shaped planet seen near the end of the film – incorporated Adams's features.</p>\n<p>A 12-part radio series based on the <a href=\"/wiki/Dirk_Gently\" title=\"Dirk Gently\">Dirk Gently</a> novels was announced in 2007, with annual transmissions starting in October.<sup id=\"cite_ref-67\" class=\"reference\"><a href=\"#cite_note-67\">[67]</a></sup></p>\n<p>BBC Radio 4 also commissioned a third Dirk Gently radio series based on the incomplete chapters of <i>The Salmon of Doubt</i>, and written by <a href=\"/wiki/Kim_Fuller\" title=\"Kim Fuller\">Kim Fuller</a>;<sup id=\"cite_ref-68\" class=\"reference\"><a href=\"#cite_note-68\">[68]</a></sup> but this was dropped in favour of a BBC TV series based on the two completed novels.<sup id=\"cite_ref-69\" class=\"reference\"><a href=\"#cite_note-69\">[69]</a></sup> A sixth <i>Hitchhiker</i> novel, <i><a href=\"/wiki/And_Another_Thing..._(novel)\" title=\"And Another Thing... (novel)\">And Another Thing...</a></i>, by <i><a href=\"/wiki/Artemis_Fowl_(series)\" title=\"Artemis Fowl (series)\">Artemis Fowl</a></i> author <a href=\"/wiki/Eoin_Colfer\" title=\"Eoin Colfer\">Eoin Colfer</a>, was released on 12 October 2009 (the 30th anniversary of the first book), published with the full support of Adams's estate. A <a href=\"/wiki/BBC_Radio_4\" title=\"BBC Radio 4\">BBC Radio 4</a> <i><a href=\"/wiki/Book_at_Bedtime\" title=\"Book at Bedtime\">Book at Bedtime</a></i> adaptation and an audio book soon followed.</p>\n<p>On 25 May 2001, two weeks after Adams's death, his fans organised a tribute known as <a href=\"/wiki/Towel_Day\" title=\"Towel Day\">Towel Day</a>, which has been observed every year since then.</p>\n<p>In 2011, over 3,000 people took part in a public vote to choose the subjects of <a href=\"/wiki/Blue_plaque\" title=\"Blue plaque\">People's Plaques</a> in Islington;<sup id=\"cite_ref-IPP_52-2\" class=\"reference\"><a href=\"#cite_note-IPP-52\">[52]</a></sup> Adams received 489 votes.</p>\n<p>On 11 March 2013, Adams's 61st birthday was celebrated with an interactive <a href=\"/wiki/Google_Doodle\" title=\"Google Doodle\">Google Doodle</a>.<sup id=\"cite_ref-GoogleDoodle2013a_70-0\" class=\"reference\"><a href=\"#cite_note-GoogleDoodle2013a-70\">[70]</a></sup><sup id=\"cite_ref-71\" class=\"reference\"><a href=\"#cite_note-71\">[71]</a></sup></p>\n<h2><span class=\"mw-headline\" id=\"Awards_and_nominations\">Awards and nominations</span></h2>\n<table class=\"wikitable\" style=\"font-size:90%\">\n<tr style=\"text-align:center;\">\n<th style=\"background:#B0C4DE;\">Year</th>\n<th style=\"background:#B0C4DE;\">Award</th>\n<th style=\"background:#B0C4DE;\">Work</th>\n<th style=\"background:#B0C4DE;\">Category</th>\n<th style=\"background:#B0C4DE;\">Result</th>\n<th style=\"background:#B0C4DE;\">Reference</th>\n</tr>\n<tr>\n<td>1979</td>\n<td><a href=\"/wiki/Hugo_Award\" title=\"Hugo Award\">Hugo Award</a></td>\n<td><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(radio_series)\" title=\"The Hitchhiker's Guide to the Galaxy (radio series)\">The Hitchhiker's Guide to the Galaxy</a></i><small>(shared with <a href=\"/wiki/Geoffrey_Perkins\" title=\"Geoffrey Perkins\">Geoffrey Perkins</a>)</small></td>\n<td><a href=\"/wiki/Hugo_Award_for_Best_Dramatic_Presentation\" title=\"Hugo Award for Best Dramatic Presentation\">Best Dramatic Presentation</a></td>\n<td style=\"background: #FDD; color: black; vertical-align: middle; text-align: center;\" class=\"no table-no2\">Nominated</td>\n<td></td>\n</tr>\n</table>\n<h2><span class=\"mw-headline\" id=\"Works\">Works</span></h2>\n<div class=\"refbegin columns references-column-width\" style=\"-moz-column-width: 20em; -webkit-column-width: 20em; column-width: 20em;\">\n<ul>\n<li><i><a href=\"/wiki/The_Private_Life_of_Genghis_Khan\" title=\"The Private Life of Genghis Khan\">The Private Life of Genghis Khan</a></i> (1975), based on a comedy sketch Adams co-wrote with <a href=\"/wiki/Graham_Chapman\" title=\"Graham Chapman\">Graham Chapman</a> (short story)</li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(radio_series)\" title=\"The Hitchhiker's Guide to the Galaxy (radio series)\">The Hitchhiker's Guide to the Galaxy</a></i> (1978) (radio series)</li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(book)\" class=\"mw-redirect\" title=\"The Hitchhiker's Guide to the Galaxy (book)\">The Hitchhiker's Guide to the Galaxy</a></i> (1979) (novel)</li>\n<li><i><a href=\"/wiki/Shada\" class=\"mw-redirect\" title=\"Shada\">Shada</a></i> (1979–1980), a Doctor Who serial</li>\n<li><i><a href=\"/wiki/The_Restaurant_at_the_End_of_the_Universe\" title=\"The Restaurant at the End of the Universe\">The Restaurant at the End of the Universe</a></i> (1980) (novel)</li>\n<li><i><a href=\"/wiki/Life,_the_Universe_and_Everything\" title=\"Life, the Universe and Everything\">Life, the Universe and Everything</a></i> (1982) (novel)</li>\n<li><i><a href=\"/wiki/The_Meaning_of_Liff\" title=\"The Meaning of Liff\">The Meaning of Liff</a></i> (1983 (book), with <a href=\"/wiki/John_Lloyd_(producer)\" title=\"John Lloyd (producer)\">John Lloyd</a>)</li>\n<li><i><a href=\"/wiki/So_Long,_and_Thanks_for_All_the_Fish\" title=\"So Long, and Thanks for All the Fish\">So Long, and Thanks for All the Fish</a></i> (1984) (novel)</li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(computer_game)\" class=\"mw-redirect\" title=\"The Hitchhiker's Guide to the Galaxy (computer game)\">The Hitchhiker's Guide to the Galaxy</a></i> (1984, with <a href=\"/wiki/Steve_Meretzky\" title=\"Steve Meretzky\">Steve Meretzky</a>) (computer game)</li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy:_The_Original_Radio_Scripts\" title=\"The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts\">The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts</a></i> (1985, with <a href=\"/wiki/Geoffrey_Perkins\" title=\"Geoffrey Perkins\">Geoffrey Perkins</a>)</li>\n<li><i><a href=\"/wiki/Young_Zaphod_Plays_It_Safe\" title=\"Young Zaphod Plays It Safe\">Young Zaphod Plays It Safe</a> (short story)</i> (1986)</li>\n<li><i><a href=\"/w/index.php?title=A_Christmas_Fairly_Story&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"A Christmas Fairly Story (page does not exist)\">A Christmas Fairly Story</a></i>  [<i><a href=\"/wiki/Sic\" title=\"Sic\">sic</a></i>] (1986, with <a href=\"/wiki/Terry_Jones\" title=\"Terry Jones\">Terry Jones</a>), and</li>\n<li><i>Supplement to The Meaning of Liff</i> (1986, with <a href=\"/wiki/John_Lloyd_(producer)\" title=\"John Lloyd (producer)\">John Lloyd</a> and <a href=\"/wiki/Stephen_Fry\" title=\"Stephen Fry\">Stephen Fry</a>), both part of\n<ul>\n<li><i><a href=\"/wiki/The_Utterly_Utterly_Merry_Comic_Relief_Christmas_Book\" title=\"The Utterly Utterly Merry Comic Relief Christmas Book\">The Utterly Utterly Merry Comic Relief Christmas Book</a></i> (1986, edited with <a href=\"/wiki/Peter_Fincham\" title=\"Peter Fincham\">Peter Fincham</a>)</li>\n</ul>\n</li>\n<li><i><a href=\"/wiki/Bureaucracy_(computer_game)\" class=\"mw-redirect\" title=\"Bureaucracy (computer game)\">Bureaucracy</a></i> (1987) (computer game)</li>\n<li><i><a href=\"/wiki/Dirk_Gently%27s_Holistic_Detective_Agency\" title=\"Dirk Gently's Holistic Detective Agency\">Dirk Gently's Holistic Detective Agency</a></i> (1987) (novel)</li>\n<li><i><a href=\"/wiki/The_Long_Dark_Tea-Time_of_the_Soul\" title=\"The Long Dark Tea-Time of the Soul\">The Long Dark Tea-Time of the Soul</a></i> (1988) (novel)</li>\n<li><i><a href=\"/wiki/The_Deeper_Meaning_of_Liff\" class=\"mw-redirect\" title=\"The Deeper Meaning of Liff\">The Deeper Meaning of Liff</a></i> (1990, with <a href=\"/wiki/John_Lloyd_(producer)\" title=\"John Lloyd (producer)\">John Lloyd</a>)</li>\n<li><i><a href=\"/wiki/Last_Chance_to_See\" title=\"Last Chance to See\">Last Chance to See</a></i> (1990, with <a href=\"/wiki/Mark_Carwardine\" title=\"Mark Carwardine\">Mark Carwardine</a>) (book)</li>\n<li><i><a href=\"/wiki/Mostly_Harmless\" title=\"Mostly Harmless\">Mostly Harmless</a></i> (1992) (novel)</li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(book)#Illustrated_edition\" class=\"mw-redirect\" title=\"The Hitchhiker's Guide to the Galaxy (book)\">The Illustrated Hitchhiker's Guide to the Galaxy</a></i> (1994)</li>\n<li><i><a href=\"/wiki/Douglas_Adams%27s_Starship_Titanic\" class=\"mw-redirect\" title=\"Douglas Adams's Starship Titanic\">Douglas Adams's Starship Titanic</a></i> (1997), written by <a href=\"/wiki/Terry_Jones\" title=\"Terry Jones\">Terry Jones</a>, based on an idea by Adams</li>\n<li><i><a href=\"/wiki/Starship_Titanic\" title=\"Starship Titanic\">Starship Titanic</a></i> (computer game) (1998)</li>\n<li><i><a href=\"/wiki/H2g2\" title=\"H2g2\">h2g2</a></i> (internet project) (1999)</li>\n<li><i>The Internet: The Last Battleground of the 20th century</i> (radio series) (2000)</li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Future\" title=\"The Hitchhiker's Guide to the Future\">The Hitchhiker's Guide to the Future</a></i> (radio series) (2001) final project for <a href=\"/wiki/BBC_Radio_4\" title=\"BBC Radio 4\">BBC Radio 4</a> before his death</li>\n<li><i><a rel=\"nofollow\" class=\"external text\" href=\"https://www.youtube.com/watch?v=_ZG8HBuDjgc\">Parrots, the universe and everything</a></i> (2001)</li>\n<li><i><a href=\"/wiki/The_Salmon_of_Doubt\" title=\"The Salmon of Doubt\">The Salmon of Doubt</a></i> (2002), unfinished novel manuscript (11 chapters), short stories, essays, and interviews (also available as an audiobook, read by <a href=\"/wiki/Simon_Jones_(actor)\" title=\"Simon Jones (actor)\">Simon Jones</a>)</li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(film)\" title=\"The Hitchhiker's Guide to the Galaxy (film)\">The Hitchhiker's Guide to the Galaxy</a></i> (2005) (film)</li>\n</ul>\n</div>\n<h2><span class=\"mw-headline\" id=\"Writing_credits\">Writing credits</span></h2>\n<table class=\"wikitable\">\n<tr style=\"background:#ccc; text-align:center;\">\n<th>Production</th>\n<th>Notes</th>\n<th>Broadcaster</th>\n</tr>\n<tr>\n<td><i><a href=\"/wiki/Monty_Python%27s_Flying_Circus\" title=\"Monty Python's Flying Circus\">Monty Python's Flying Circus</a></i></td>\n<td>\n<ul>\n<li>\"<a href=\"/wiki/List_of_Monty_Python%27s_Flying_Circus_episodes#6._Party_Political_Broadcast\" title=\"List of Monty Python's Flying Circus episodes\">Party Political Broadcast on Behalf of the Liberal Party</a>\" (1974)</li>\n</ul>\n</td>\n<td><a href=\"/wiki/BBC_Two\" title=\"BBC Two\">BBC Two</a></td>\n</tr>\n<tr>\n<td><i><a href=\"/wiki/Out_of_the_Trees\" title=\"Out of the Trees\">Out of the Trees</a></i></td>\n<td>\n<ul>\n<li>Television pilot (1976)</li>\n</ul>\n</td>\n<td>BBC Two</td>\n</tr>\n<tr>\n<td><i><a href=\"/wiki/Doctor_on_the_Go\" title=\"Doctor on the Go\">Doctor on the Go</a></i></td>\n<td>\n<ul>\n<li>\"For Your Own Good\" (1977)</li>\n</ul>\n</td>\n<td><a href=\"/wiki/ITV_(TV_network)\" title=\"ITV (TV network)\">ITV</a></td>\n</tr>\n<tr>\n<td><i><a href=\"/wiki/Doctor_Who\" title=\"Doctor Who\">Doctor Who</a></i></td>\n<td>\n<p>5 episodes (1978-1979, 1983):</p>\n<ul>\n<li>\"<a href=\"/wiki/The_Pirate_Planet\" title=\"The Pirate Planet\">The Pirate Planet</a>\" (1978)</li>\n<li>\"<a href=\"/wiki/Destiny_of_the_Daleks\" title=\"Destiny of the Daleks\">Destiny of the Daleks</a>\" (1979) (uncredited)</li>\n<li>\"<a href=\"/wiki/City_of_Death\" title=\"City of Death\">City of Death</a>\" (co-written with <a href=\"/wiki/Graham_Williams_(television_producer)\" title=\"Graham Williams (television producer)\">Graham Williams</a>, 1979)</li>\n<li>\"<a href=\"/wiki/The_Five_Doctors\" title=\"The Five Doctors\">The Five Doctors</a>\" (1983) (<a href=\"/wiki/Shada\" class=\"mw-redirect\" title=\"Shada\">Shada</a> segments; uncredited)</li>\n</ul>\n</td>\n<td><a href=\"/wiki/BBC_One\" title=\"BBC One\">BBC One</a></td>\n</tr>\n<tr>\n<td><i><a href=\"/wiki/Doctor_Snuggles\" title=\"Doctor Snuggles\">Doctor Snuggles</a></i></td>\n<td>\n<ul>\n<li>\"The Great Disappearing Mystery\" (1979)</li>\n<li>\"The Remarkable Fidgety River\" (1979)</li>\n</ul>\n</td>\n<td>ITV</td>\n</tr>\n<tr>\n<td><i><a href=\"/wiki/Not_the_Nine_O%27Clock_News\" title=\"Not the Nine O'Clock News\">Not the Nine O'Clock News</a></i></td>\n<td>\n<ul>\n<li>Unknown episodes (1979)</li>\n</ul>\n</td>\n<td>BBC Two</td>\n</tr>\n<tr>\n<td><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(TV_series)\" title=\"The Hitchhiker's Guide to the Galaxy (TV series)\">The Hitchhiker's Guide to the Galaxy</a></i></td>\n<td>\n<ul>\n<li>6 episodes (1981)</li>\n</ul>\n</td>\n<td>BBC Two</td>\n</tr>\n<tr>\n<td><i><a href=\"/wiki/Hyperland\" title=\"Hyperland\">Hyperland</a></i></td>\n<td>\n<ul>\n<li>Television documentary (1990)</li>\n</ul>\n</td>\n<td>BBC Two</td>\n</tr>\n</table>\n<h2><span class=\"mw-headline\" id=\"Notes\">Notes</span></h2>\n<div class=\"reflist columns references-column-width\" style=\"-moz-column-width: 30em; -webkit-column-width: 30em; column-width: 30em; list-style-type: decimal;\">\n<ol class=\"references\">\n<li id=\"cite_note-radioacad-1\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-radioacad_1-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.radioacademy.org/hall-of-fame\">\"The Radio Academy Hall of Fame\"</a>. <i>The Radio Academy</i>. <a rel=\"nofollow\" class=\"external text\" href=\"http://www.webcitation.org/63mNGrql2?url=http%3A%2F%2Fwww.radioacademy.org%2Fhall-of-fame%2F\">Archived</a> from the original on 8 December 2011<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">8 December</span> 2011</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=The+Radio+Academy+Hall+of+Fame&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.radioacademy.org%2Fhall-of-fame&amp;rft.jtitle=The+Radio+Academy&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-ODNB-2\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-ODNB_2-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-ODNB_2-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-ODNB_2-2\"><sup><i><b>c</b></i></sup></a> <a href=\"#cite_ref-ODNB_2-3\"><sup><i><b>d</b></i></sup></a></span> <span class=\"reference-text\">Webb 2005b</span></li>\n<li id=\"cite_note-Adams_xix-3\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-Adams_xix_3-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-Adams_xix_3-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><a href=\"#CITEREFAdams2002\">Adams 2002</a>, pp.&#160;xix</span></li>\n<li id=\"cite_note-4\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-4\">^</a></b></span> <span class=\"reference-text\">Webb 2005a, p. 32.</span></li>\n<li id=\"cite_note-Adams_7-5\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Adams_7_5-0\">^</a></b></span> <span class=\"reference-text\"><a href=\"#CITEREFAdams2002\">Adams 2002</a>, pp.&#160;7</span></li>\n<li id=\"cite_note-6\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-6\">^</a></b></span> <span class=\"reference-text\">Botti, Nicholas. <a rel=\"nofollow\" class=\"external text\" href=\"http://douglasadams.eu/interview-with-frank-halford/\">\"Interview with Frank Halford\"</a>. <i>Life, DNA, and H2G2.</i> 2009. Web. Retrieved 13 March 2012. (Click on link at bottom for facsimile page from <i>Daily News</i> article, 7 March 1998.)</span></li>\n<li id=\"cite_note-Simpson_9-7\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Simpson_9_7-0\">^</a></b></span> <span class=\"reference-text\"><a href=\"#CITEREFSimpson2003\">Simpson 2003</a>, pp.&#160;9</span></li>\n<li id=\"cite_note-8\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-8\">^</a></b></span> <span class=\"reference-text\">Flood, Alison (March 2014). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.theguardian.com/books/2014/mar/19/lost-school-poems-douglas-adams-griff-rhys-jones\">\"Lost poems of Douglas Adams and Griff Rhys Jones found in school cupboard\"</a>, <i>The Guardian</i>, 19 March 2014. Accessed 2 July 2014</span></li>\n<li id=\"cite_note-Simpson_30-40-9\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Simpson_30-40_9-0\">^</a></b></span> <span class=\"reference-text\"><a href=\"#CITEREFSimpson2003\">Simpson 2003</a>, pp.&#160;30–40</span></li>\n<li id=\"cite_note-times-10\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-times_10-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation news\">\"Terry Jones remembers Douglas Adams, 'the last of the Pythons<span style=\"padding-right:0.2em;\">'</span>\". <i>The Times</i>. 10 October 2009.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Terry+Jones+remembers+Douglas+Adams%2C+%27the+last+of+the+Pythons%27&amp;rft.date=2009-10-10&amp;rft.genre=article&amp;rft.jtitle=The+Times&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-11\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-11\">^</a></b></span> <span class=\"reference-text\">Webb 2005a, p. 93.</span></li>\n<li id=\"cite_note-Adams_prologue-12\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Adams_prologue_12-0\">^</a></b></span> <span class=\"reference-text\"><a href=\"#CITEREFAdams2002\">Adams 2002</a>, pp.&#160;prologue</span></li>\n<li id=\"cite_note-13\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-13\">^</a></b></span> <span class=\"reference-text\"><i>Hitchhiker: A Biography of Douglas Adams</i> by M. J. Simpson, p87</span></li>\n<li id=\"cite_note-14\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-14\">^</a></b></span> <span class=\"reference-text\">Roberts, Jem. <i>The Clue Bible: The Fully Authorised History of I'm Sorry I Haven't A Clue from Footlights to Mornington Crescent</i>: London, 2009, p164-5</span></li>\n<li id=\"cite_note-15\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-15\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation book\">Adams, Douglas (2003). Geoffrey Perkins (ed.), Additional Material by M. J. Simpson, ed. <i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy:_The_Original_Radio_Scripts\" title=\"The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts\">The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts</a></i> (25th Anniversary ed.). Pan Books. p.&#160;10. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/0-330-41957-9\" title=\"Special:BookSources/0-330-41957-9\">0-330-41957-9</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Adams%2C+Douglas&amp;rft.btitle=The+Hitchhiker%27s+Guide+to+the+Galaxy%3A+The+Original+Radio+Scripts&amp;rft.date=2003&amp;rft.edition=25th+Anniversary&amp;rft.genre=book&amp;rft.isbn=0-330-41957-9&amp;rft.pages=10&amp;rft.pub=Pan+Books&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-16\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-16\">^</a></b></span> <span class=\"reference-text\">Webb 2005a, p. 120.</span></li>\n<li id=\"cite_note-17\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-17\">^</a></b></span> <span class=\"reference-text\">Felch 2004</span></li>\n<li id=\"cite_note-Simpson_236-18\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Simpson_236_18-0\">^</a></b></span> <span class=\"reference-text\"><a href=\"#CITEREFSimpson2003\">Simpson 2003</a>, pp.&#160;236</span></li>\n<li id=\"cite_note-19\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-19\">^</a></b></span> <span class=\"reference-text\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.iblist.com/series.php?id=2\">Internet Book List</a> page, with links to all five novels, and reproductions of the 1990s paperback covers that included the <a href=\"/wiki/42_Puzzle\" class=\"mw-redirect\" title=\"42 Puzzle\">42 Puzzle</a>.</span></li>\n<li id=\"cite_note-20\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-20\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.imdb.com/title/tt0081874/\">The Hitch Hiker's Guide to the Galaxy</a>, Internet Movie Database</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=The+Hitch+Hiker%27s+Guide+to+the+Galaxy&amp;rft.genre=book&amp;rft_id=http%3A%2F%2Fwww.imdb.com%2Ftitle%2Ftt0081874%2F&amp;rft.pub=Internet+Movie+Database&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-21\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-21\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation book\">Adams, Douglas. (2005). <a href=\"/wiki/Dirk_Maggs\" title=\"Dirk Maggs\">Dirk Maggs</a>, dramatisations and editor, ed. <i>The Hitchhiker's Guide to the Galaxy Radio Scripts: The Tertiary, Quandary and Quintessential Phases</i>. Pan Books. xiv. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/0-330-43510-8\" title=\"Special:BookSources/0-330-43510-8\">0-330-43510-8</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Adams%2C+Douglas.&amp;rft.btitle=The+Hitchhiker%27s+Guide+to+the+Galaxy+Radio+Scripts%3A+The+Tertiary%2C+Quandary+and+Quintessential+Phases&amp;rft.date=2005&amp;rft.genre=book&amp;rft.isbn=0-330-43510-8&amp;rft.pages=xiv&amp;rft.pub=Pan+Books&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-22\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-22\">^</a></b></span> <span class=\"reference-text\">Adams, <i>Dirk Maggs</i>, Page 356.</span></li>\n<li id=\"cite_note-23\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-23\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation book\"><a href=\"/wiki/Neil_Gaiman\" title=\"Neil Gaiman\">Gaiman, Neil</a> (2003). <i>Don't Panic: Douglas Adams &amp; The Hitchhiker's Guide to the Galaxy</i> (Second U.S. ed.). Titan Books. p.&#160;169. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/1-84023-742-2\" title=\"Special:BookSources/1-84023-742-2\">1-84023-742-2</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Gaiman%2C+Neil&amp;rft.btitle=Don%27t+Panic%3A+Douglas+Adams+%26+The+Hitchhiker%27s+Guide+to+the+Galaxy&amp;rft.date=2003&amp;rft.edition=Second+U.S.&amp;rft.genre=book&amp;rft.isbn=1-84023-742-2&amp;rft.pages=169&amp;rft.pub=Titan+Books&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-24\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-24\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.skepticfiles.org/en001/drwhogde.htm\">\"A 1990s Doctor Who FAQ\"</a>. Skepticfiles.org<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">11 March</span> 2013</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=A+1990s+Doctor+Who+FAQ&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.skepticfiles.org%2Fen001%2Fdrwhogde.htm&amp;rft.pub=Skepticfiles.org&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-25\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-25\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\">Moffat, Steven (24 December 2012). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.radiotimes.com/news/2012-12-24/doctor-who-christmas-special-steven-moffat-matt-smith-and-jenna-louise-coleman-reveal-all\">\"Doctor Who Christmas special: Steven Moffat, Matt Smith and Jenna-Louise Coleman reveal all\"</a>. <i>Radio Times</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">8 July</span> 2013</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Doctor+Who+Christmas+special%3A+Steven+Moffat%2C+Matt+Smith+and+Jenna-Louise+Coleman+reveal+all&amp;rft.aufirst=Steven&amp;rft.aulast=Moffat&amp;rft.date=2012-12-24&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.radiotimes.com%2Fnews%2F2012-12-24%2Fdoctor-who-christmas-special-steven-moffat-matt-smith-and-jenna-louise-coleman-reveal-all&amp;rft.jtitle=Radio+Times&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-Adams_xx-26\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Adams_xx_26-0\">^</a></b></span> <span class=\"reference-text\"><a href=\"#CITEREFAdams2002\">Adams 2002</a>, pp.&#160;xx</span></li>\n<li id=\"cite_note-27\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-27\">^</a></b></span> <span class=\"reference-text\">Webb, page 49.</span></li>\n<li id=\"cite_note-Mabbett-MM-28\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-Mabbett-MM_28-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-Mabbett-MM_28-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><cite class=\"citation book\">Mabbett, Andy (2010). <i>Pink Floyd – The Music and the Mystery</i>. London: Omnibus Press. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/978-1-84938-370-7\" title=\"Special:BookSources/978-1-84938-370-7\">978-1-84938-370-7</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.aufirst=Andy&amp;rft.aulast=Mabbett&amp;rft.btitle=Pink+Floyd+%93+The+Music+and+the+Mystery&amp;rft.date=2010&amp;rft.genre=book&amp;rft.isbn=978-1-84938-370-7&amp;rft.place=London&amp;rft.pub=Omnibus+Press&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-29\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-29\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\">Adams, Douglas (8 February 1996). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.procolharum.com/dadams.htm\">\"Text of one of Douglas Adams's introductions of Procol Harum in concert\"</a><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">21 August</span> 2006</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.aufirst=Douglas&amp;rft.aulast=Adams&amp;rft.btitle=Text+of+one+of+Douglas+Adams%27s+introductions+of+Procol+Harum+in+concert&amp;rft.date=1996-02-08&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.procolharum.com%2Fdadams.htm&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-bbc.co.uk-30\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-bbc.co.uk_30-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-bbc.co.uk_30-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\">BBC Online (no date) <a rel=\"nofollow\" class=\"external text\" href=\"http://www.bbc.co.uk/cult/hitchhikers/dna/biog.shtml\">\"The Hitchhiker's Guide to the Galaxy: DNA (1952-2001)\"</a> Accessed 9 July 2014</span></li>\n<li id=\"cite_note-31\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-31\">^</a></b></span> <span class=\"reference-text\">Botti, Nicolas (2009). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.douglasadams.eu/en_adams_bio.php\">\"Life, DNA &amp; h2g2: Douglas Adams's Biography\"</a> Accessed 9 July 2014</span></li>\n<li id=\"cite_note-32\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-32\">^</a></b></span> <span class=\"reference-text\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.imdb.com/title/tt0188677/\">Internet Movie Database's page for <i>Hyperland</i></a></span></li>\n<li id=\"cite_note-33\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-33\">^</a></b></span> <span class=\"reference-text\">Adams 1998.</span></li>\n<li id=\"cite_note-amath-34\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-amath_34-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation journal\">Silverman, Dave (1998–1999). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.atheists.org/Interview%3A__Douglas_Adams\">\"Interview: Douglas Adams\"</a>. <i>American Atheist</i>. <b>37</b> (1). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.webcitation.org/63mRFcWVO?url=http%3A%2F%2Fwww.atheists.org%2FInterview%253A__Douglas_Adams\">Archived</a> from the original on 8 December 2011<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">16 August</span> 2009</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Interview%3A+Douglas+Adams&amp;rft.aufirst=Dave&amp;rft.aulast=Silverman&amp;rft.date=1998%2F1999&amp;rft.genre=article&amp;rft_id=http%3A%2F%2Fwww.atheists.org%2FInterview%253A__Douglas_Adams&amp;rft.issue=1&amp;rft.jtitle=American+Atheist&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.volume=37\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-TheGuardian-35\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-TheGuardian_35-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation news\">Bunce, Kim (5 November 2006). <a rel=\"nofollow\" class=\"external text\" href=\"http://books.guardian.co.uk/reviews/roundupstory/0,,1939704,00.html\">\"Observer, ''The God Delusion'', 5&#160;November 2006\"</a>. <i><a href=\"/wiki/The_Guardian\" title=\"The Guardian\">The Guardian</a></i>. London<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">1 June</span> 2009</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Observer%2C+%27%26%2339%3BThe+God+Delusion%27%26%2339%3B%2C+5+November+2006&amp;rft.aufirst=Kim&amp;rft.aulast=Bunce&amp;rft.date=2006-11-05&amp;rft.genre=article&amp;rft_id=http%3A%2F%2Fbooks.guardian.co.uk%2Freviews%2Froundupstory%2F0%2C%2C1939704%2C00.html&amp;rft.jtitle=The+Guardian&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-Dawkins2001-36\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Dawkins2001_36-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation news\">Dawkins, Richard (13 May 2001). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.guardian.co.uk/uk/2001/may/14/books.booksnews\">\"Lament for Douglas Adams\"</a>. <i>The Guardian</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">29 December</span> 2012</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Lament+for+Douglas+Adams&amp;rft.aufirst=Richard&amp;rft.aulast=Dawkins&amp;rft.date=2001-05-13&amp;rft.genre=article&amp;rft_id=http%3A%2F%2Fwww.guardian.co.uk%2Fuk%2F2001%2Fmay%2F14%2Fbooks.booksnews&amp;rft.jtitle=The+Guardian&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-37\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-37\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation book\"><a href=\"/wiki/Paola_Cavalieri\" title=\"Paola Cavalieri\">Cavalieri, Paola</a> and <a href=\"/wiki/Peter_Singer\" title=\"Peter Singer\">Peter Singer</a>, editors (1994). <i>The Great Ape Project: Equality Beyond Humanity</i> (U.S. Paperback ed.). St. Martin's Griffin. pp.&#160;19–23. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/0-312-11818-X\" title=\"Special:BookSources/0-312-11818-X\">0-312-11818-X</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Cavalieri%2C+Paola+and+Peter+Singer%2C+editors&amp;rft.btitle=The+Great+Ape+Project%3A+Equality+Beyond+Humanity&amp;rft.date=1994&amp;rft.edition=U.S.+Paperback&amp;rft.genre=book&amp;rft.isbn=0-312-11818-X&amp;rft.pages=19-23&amp;rft.pub=St.+Martin%27s+Griffin&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span> <span class=\"citation-comment\" style=\"display:none; color:#33aa33\">CS1 maint: Multiple names: authors list (<a href=\"/wiki/Category:CS1_maint:_Multiple_names:_authors_list\" title=\"Category:CS1 maint: Multiple names: authors list\">link</a>)</span></span></li>\n<li id=\"cite_note-38\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-38\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://lifednah2g2.blogspot.co.uk/2011/01/ninth-douglas-adams-memorial-lecture.html\">\"The Ninth Douglas Adams Memorial Lecture\"</a>. Save the Rhino International<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">27 July</span> 2011</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=The+Ninth+Douglas+Adams+Memorial+Lecture&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Flifednah2g2.blogspot.co.uk%2F2011%2F01%2Fninth-douglas-adams-memorial-lecture.html&amp;rft.pub=Save+the+Rhino+International&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-39\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-39\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.savetherhino.org/latest_news/news/287_douglas_adams_the_party\">\"Douglas Adams The Party\"</a>. Save the Rhino International<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">11 March</span> 2013</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Douglas+Adams+The+Party&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.savetherhino.org%2Flatest_news%2Fnews%2F287_douglas_adams_the_party&amp;rft.pub=Save+the+Rhino+International&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-40\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-40\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.savetherhino.org/events/476_douglas_adams_memorial_lecture_2013\">\"Douglas Adams Memorial Lecture 2013\"</a>. Save the Rhino International<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">15 August</span> 2012</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Douglas+Adams+Memorial+Lecture+2013&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.savetherhino.org%2Fevents%2F476_douglas_adams_memorial_lecture_2013&amp;rft.pub=Save+the+Rhino+International&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-41\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-41\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.savetherhino.org/events/798_douglas_adams_memorial_lecture\">\"Douglas Adams Memorial Lecture 2014\"</a>. Save the Rhino International<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">15 November</span> 2013</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Douglas+Adams+Memorial+Lecture+2014&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.savetherhino.org%2Fevents%2F798_douglas_adams_memorial_lecture&amp;rft.pub=Save+the+Rhino+International&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-42\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-42\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.savetherhino.org/events/1059_douglas_adams_memorial_lecture_2015_-_sold_out\">\"Douglas Adams Memorial Lecture 2015\"</a>. Save the Rhino International<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">30 January</span> 2015</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Douglas+Adams+Memorial+Lecture+2015&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.savetherhino.org%2Fevents%2F1059_douglas_adams_memorial_lecture_2015_-_sold_out&amp;rft.pub=Save+the+Rhino+International&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-43\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-43\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"https://www.savetherhino.org/events/1383_douglas_adams_memorial_lecture_2016\">\"Douglas Adams Memorial Lecture 2016\"</a>. Save the Rhino International<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">7 December</span> 2015</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Douglas+Adams+Memorial+Lecture+2016&amp;rft.genre=unknown&amp;rft_id=https%3A%2F%2Fwww.savetherhino.org%2Fevents%2F1383_douglas_adams_memorial_lecture_2016&amp;rft.pub=Save+the+Rhino+International&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-Simpson_184-185-44\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-Simpson_184-185_44-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-Simpson_184-185_44-1\"><sup><i><b>b</b></i></sup></a></span> <span class=\"reference-text\"><a href=\"#CITEREFSimpson2003\">Simpson 2003</a>, pp.&#160;184–185</span></li>\n<li id=\"cite_note-45\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-45\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation book\">Adams, Douglas and <a href=\"/wiki/Mark_Carwardine\" title=\"Mark Carwardine\">Mark Carwardine</a> (1991). <i>Last Chance to See</i> (First U.S. Hardcover ed.). <a href=\"/wiki/Harmony_Books\" title=\"Harmony Books\">Harmony Books</a>. p.&#160;59. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/0-517-58215-5\" title=\"Special:BookSources/0-517-58215-5\">0-517-58215-5</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Adams%2C+Douglas+and+Mark+Carwardine&amp;rft.btitle=Last+Chance+to+See&amp;rft.date=1991&amp;rft.edition=First+U.S.+Hardcover&amp;rft.genre=book&amp;rft.isbn=0-517-58215-5&amp;rft.pages=59&amp;rft.pub=Harmony+Books&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-46\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-46\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation book\">Adams, Douglas (2002). <i>The Salmon of Doubt: Hitchhiking the Galaxy One Last Time</i> (First UK hardcover ed.). Macmillan. pp.&#160;90–1. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/0-333-76657-1\" title=\"Special:BookSources/0-333-76657-1\">0-333-76657-1</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.au=Adams%2C+Douglas&amp;rft.btitle=The+Salmon+of+Doubt%3A+Hitchhiking+the+Galaxy+One+Last+Time&amp;rft.date=2002&amp;rft.edition=First+UK+hardcover&amp;rft.genre=book&amp;rft.isbn=0-333-76657-1&amp;rft.pages=90-1&amp;rft.pub=Macmillan&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-47\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-47\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"https://www.youtube.com/watch?v=gx6WPQkhUXI\">\"Craig Ferguson 23 February, 2010B Late Late show Stephen Fry PT2\"</a>. YouTube. 21 June 2010<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">27 July</span> 2011</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Craig+Ferguson+23+February%2C+2010B+Late+Late+show+Stephen+Fry+PT2&amp;rft.date=2010-06-21&amp;rft.genre=unknown&amp;rft_id=https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3Dgx6WPQkhUXI&amp;rft.pub=YouTube&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-48\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-48\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.douglasadams.com/cgi-bin/mboard/info/dnathread.cgi?2922,1\">\"Adams's final post on his forums at\"</a>. Douglasadams.com<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">1 June</span> 2009</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Adams%27s+final+post+on+his+forums+at&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.douglasadams.com%2Fcgi-bin%2Fmboard%2Finfo%2Fdnathread.cgi%3F2922%2C1&amp;rft.pub=Douglasadams.com&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-49\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-49\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"https://groups.google.com/group/alt.fan.douglas-adams\">\"Discussions – alt.fan.douglas-adams | Google Groups\"</a>. Google<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">11 March</span> 2013</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Discussions+%93+alt.fan.douglas-adams+%26%23124%3B+Google+Groups&amp;rft.genre=unknown&amp;rft_id=https%3A%2F%2Fgroups.google.com%2Fgroup%2Falt.fan.douglas-adams&amp;rft.pub=Google&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-50\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-50\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\">Adams, Douglas (15 May 2001). <a rel=\"nofollow\" class=\"external text\" href=\"http://channel9.msdn.com/Events/PDC/PDC-1996/PDC-1996-Keynote-with-Douglas-Adams\">\"PDC 1996 Keynote with Douglas Adams\"</a>. <i><a href=\"/w/index.php?title=Channel9.msdn.com&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Channel9.msdn.com (page does not exist)\">channel9.msdn.com</a></i>. Channel 9<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">22 March</span> 2013</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=PDC+1996+Keynote+with+Douglas+Adams&amp;rft.aufirst=Douglas&amp;rft.aulast=Adams&amp;rft.date=2001-05-15&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fchannel9.msdn.com%2FEvents%2FPDC%2FPDC-1996%2FPDC-1996-Keynote-with-Douglas-Adams&amp;rft.jtitle=channel9.msdn.com&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-51\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-51\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\">Cassel, David (15 May 2001). <a rel=\"nofollow\" class=\"external text\" href=\"http://archive.salon.com/tech/feature/2001/05/15/douglas_adams/index.html\">\"So long, Douglas Adams, and thanks for all the fun\"</a>. <i><a href=\"/wiki/Salon_(website)\" title=\"Salon (website)\">Salon</a></i>. Salon Media Group<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">10 July</span> 2009</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=So+long%2C+Douglas+Adams%2C+and+thanks+for+all+the+fun&amp;rft.aufirst=David&amp;rft.aulast=Cassel&amp;rft.date=2001-05-15&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Farchive.salon.com%2Ftech%2Ffeature%2F2001%2F05%2F15%2Fdouglas_adams%2Findex.html&amp;rft.jtitle=Salon&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-IPP-52\"><span class=\"mw-cite-backlink\">^ <a href=\"#cite_ref-IPP_52-0\"><sup><i><b>a</b></i></sup></a> <a href=\"#cite_ref-IPP_52-1\"><sup><i><b>b</b></i></sup></a> <a href=\"#cite_ref-IPP_52-2\"><sup><i><b>c</b></i></sup></a></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"https://web.archive.org/web/20120318001614/http://www.islington.gov.uk/Leisure/heritage/heritage_borough/bor_plaques/peoplesplaques.asp\">\"Islington People's Plaques\"</a>. 25 July 2011. Archived from <a rel=\"nofollow\" class=\"external text\" href=\"http://www.islington.gov.uk/Leisure/heritage/heritage_borough/bor_plaques/peoplesplaques.asp\">the original</a> on 18 March 2012<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">13 August</span> 2011</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Islington+People%27s+Plaques&amp;rft.date=2011-07-25&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.islington.gov.uk%2FLeisure%2Fheritage%2Fheritage_borough%2Fbor_plaques%2Fpeoplesplaques.asp&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-sfweekly-53\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-sfweekly_53-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\">Bowers, Keith (6 July 2011). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.sfweekly.com/2011-07-06/calendar/big-three/\">\"Big Three\"</a>. <i>SF Weekly</i>. <a rel=\"nofollow\" class=\"external text\" href=\"http://www.webcitation.org/63mSWp8yr?url=http%3A%2F%2Fwww.sfweekly.com%2F2011-07-06%2Fcalendar%2Fbig-three%2F\">Archived</a> from the original on 8 December 2011<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">8 December</span> 2011</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Big+Three&amp;rft.aufirst=Keith&amp;rft.aulast=Bowers&amp;rft.date=2011-07-06&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.sfweekly.com%2F2011-07-06%2Fcalendar%2Fbig-three%2F&amp;rft.jtitle=SF+Weekly&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-54\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-54\">^</a></b></span> <span class=\"reference-text\">Webb, Chapter 10.</span></li>\n<li id=\"cite_note-timesobit-55\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-timesobit_55-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://announcements.thetimes.co.uk/obituaries/timesonline-uk/obituary.aspx?page=lifestory&amp;pid=153521790\">\"Obituary &amp; Guest Book Preview for Jane Elizabeth BELSON\"</a>. <i>The Times</i>. 9 September 2011. <a rel=\"nofollow\" class=\"external text\" href=\"http://www.webcitation.org/63mSoMnJe\">Archived</a> from the original on 8 December 2011<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">8 December</span> 2011</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Obituary+%26+Guest+Book+Preview+for+Jane+Elizabeth+BELSON&amp;rft.date=2011-09-09&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fannouncements.thetimes.co.uk%2Fobituaries%2Ftimesonline-uk%2Fobituary.aspx%3Fpage%3Dlifestory%26pid%3D153521790&amp;rft.jtitle=The+Times&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-h2g2obit-56\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-h2g2obit_56-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://lifednah2g2.blogspot.com/2011/09/jane-belson-douglas-adams-widow-passed.html\">\"Jane Belson, Douglas Adams's widow, passed away\"</a>. <i>h2g2</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">9 July</span> 2013</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Jane+Belson%2C+Douglas+Adams%27s+widow%2C+passed+away&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Flifednah2g2.blogspot.com%2F2011%2F09%2Fjane-belson-douglas-adams-widow-passed.html&amp;rft.jtitle=h2g2&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-57\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-57\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\">Lewis, Judith; Shulman, Dave (24 May 2001). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.laweekly.com/2001-05-24/news/lots-of-screamingly-funny-sentences-no-fish/\">\"Lots of Screamingly Funny Sentences. No Fish. – page 1\"</a>. LA Weekly. <a rel=\"nofollow\" class=\"external text\" href=\"http://www.webcitation.org/63mQ1aCJQ?url=http%3A%2F%2Fwww.laweekly.com%2F2001-05-24%2Fnews%2Flots-of-screamingly-funny-sentences-no-fish%2F\">Archived</a> from the original on 24 May 2001<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">20 August</span> 2009</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.aufirst=Judith&amp;rft.aulast=Lewis&amp;rft.au=Shulman%2C+Dave&amp;rft.btitle=Lots+of+Screamingly+Funny+Sentences.+No+Fish.+%93+page+1&amp;rft.date=2001-05-24&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.laweekly.com%2F2001-05-24%2Fnews%2Flots-of-screamingly-funny-sentences-no-fish%2F&amp;rft.pub=LA+Weekly&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-Simpson_337-338-58\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-Simpson_337-338_58-0\">^</a></b></span> <span class=\"reference-text\"><a href=\"#CITEREFSimpson2003\">Simpson 2003</a>, pp.&#160;337–338</span></li>\n<li id=\"cite_note-59\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-59\">^</a></b></span> <span class=\"reference-text\">Gaiman, 204.</span></li>\n<li id=\"cite_note-60\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-60\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.bbc.co.uk/cult/hitchhikers/celebration/\">\"BBC Online – Cult – Hitchhiker's – Douglas Adams – Service of Celebration\"</a>. BBC. 17 September 2001<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">11 March</span> 2013</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=BBC+Online+%93+Cult+%93+Hitchhiker%27s+%93+Douglas+Adams+%93+Service+of+Celebration&amp;rft.date=2001-09-17&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.bbc.co.uk%2Fcult%2Fhitchhikers%2Fcelebration%2F&amp;rft.pub=BBC&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-61\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-61\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"https://www.youtube.com/watch?v=_ZG8HBuDjgc\">\"Parrots, the universe and everything, recorded May 2001\"</a>. YouTube<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">11 March</span> 2013</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Parrots%2C+the+universe+and+everything%2C+recorded+May+2001&amp;rft.genre=unknown&amp;rft_id=https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3D_ZG8HBuDjgc&amp;rft.pub=YouTube&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-62\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-62\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://navarroj.com/parrots\">\"Transcript of \"Parrots, the Universe and Everything<span style=\"padding-right:0.2em;\">\"</span>\"</a>. Navarroj.com<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">27 July</span> 2011</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Transcript+of+%22Parrots%2C+the+Universe+and+Everything%22&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fnavarroj.com%2Fparrots&amp;rft.pub=Navarroj.com&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-MPC42677-63\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-MPC42677_63-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.minorplanetcenter.net/iau/ECS/MPCArchive/2001/MPC_20010509.pdf\">\"New Names of Minor Planets\"</a> <span style=\"font-size:85%;\">(PDF)</span>, <i><a href=\"/wiki/Minor_Planet_Circular\" class=\"mw-redirect\" title=\"Minor Planet Circular\">Minor Planet Circular</a></i>, Cambridge, Mass: <a href=\"/wiki/Minor_Planet_Center\" title=\"Minor Planet Center\">Minor Planet Center</a> (MPC 42677), 9 May 2001, <a href=\"/wiki/International_Standard_Serial_Number\" title=\"International Standard Serial Number\">ISSN</a>&#160;<a rel=\"nofollow\" class=\"external text\" href=\"//www.worldcat.org/issn/0736-6884\">0736-6884</a></cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=New+Names+of+Minor+Planets&amp;rft.date=2001-05-09&amp;rft.genre=article&amp;rft_id=http%3A%2F%2Fwww.minorplanetcenter.net%2Fiau%2FECS%2FMPCArchive%2F2001%2FMPC_20010509.pdf&amp;rft.issn=0736-6884&amp;rft.issue=MPC+42677&amp;rft.jtitle=Minor+Planet+Circular&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-64\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-64\">^</a></b></span> <span class=\"reference-text\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.msnbc.msn.com/id/6867061/\">Asteroid named after 'Hitchhiker' humorist: Late British sci-fi author honored after cosmic campaign</a> by Alan Boyle, MSNBC, 25 January 2005</span></li>\n<li id=\"cite_note-65\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-65\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation news\">Murray, Charles Shaar (10 May 2002). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.independent.co.uk/arts-entertainment/books/reviews/the-salmon-of-doubt-by-douglas-adams-650803.html\">\"The Salmon of Doubt by Douglas Adams\"</a>. <i>The Independent</i>. London<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2 August</span> 2009</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=The+Salmon+of+Doubt+by+Douglas+Adams&amp;rft.aufirst=Charles+Shaar&amp;rft.aulast=Murray&amp;rft.date=2002-05-10&amp;rft.genre=article&amp;rft_id=http%3A%2F%2Fwww.independent.co.uk%2Farts-entertainment%2Fbooks%2Freviews%2Fthe-salmon-of-doubt-by-douglas-adams-650803.html&amp;rft.jtitle=The+Independent&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-66\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-66\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation news\">The Literator (5 January 2002). <a rel=\"nofollow\" class=\"external text\" href=\"https://web.archive.org/web/20090801062359/http://www.independent.co.uk/arts-entertainment/books/features/cover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html\">\"Cover Stories: Douglas Adams, Narnia Chronicles, Something like a House\"</a>. <i>The Independent</i>. London. Archived from <a rel=\"nofollow\" class=\"external text\" href=\"http://www.independent.co.uk/arts-entertainment/books/features/cover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html\">the original</a> on 1 August 2009<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">2 August</span> 2009</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Cover+Stories%3A+Douglas+Adams%2C+Narnia+Chronicles%2C+Something+like+a+House&amp;rft.au=The+Literator&amp;rft.date=2002-01-05&amp;rft.genre=article&amp;rft_id=http%3A%2F%2Fwww.independent.co.uk%2Farts-entertainment%2Fbooks%2Ffeatures%2Fcover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html&amp;rft.jtitle=The+Independent&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-67\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-67\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.dirkmaggs.dswilliams.co.uk/Dirk%20Maggs%20News%20%20new%20projects.htm\">\"Dirk Maggs News and New Projects page\"</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Dirk+Maggs+News+and+New+Projects+page&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.dirkmaggs.dswilliams.co.uk%2FDirk%2520Maggs%2520News%2520%2520new%2520projects.htm&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span><sup class=\"noprint Inline-Template\"><span style=\"white-space: nowrap;\">[<i><a href=\"/wiki/Wikipedia:Link_rot\" title=\"Wikipedia:Link rot\"><span title=\"&#160;Dead link since June 2016\">dead link</span></a></i>]</span></sup></span></li>\n<li id=\"cite_note-68\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-68\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\">Matthew Hemley (5 May 2009). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.thestage.co.uk/news/newsstory.php/24312/douglas-adams-final-dirk-gently-novel-to-be\">\"The Stage / News / Douglas Adams's final Dirk Gently novel to be adapted for Radio 4\"</a>. <i>The Stage</i><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">20 August</span> 2009</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=The+Stage+%2F+News+%2F+Douglas+Adams%27s+final+Dirk+Gently+novel+to+be+adapted+for+Radio+4&amp;rft.au=Matthew+Hemley&amp;rft.date=2009-05-05&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.thestage.co.uk%2Fnews%2Fnewsstory.php%2F24312%2Fdouglas-adams-final-dirk-gently-novel-to-be&amp;rft.jtitle=The+Stage&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-69\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-69\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.chortle.co.uk/news/2009/10/11/9767/bbc_plans_dirk_gently_tv_series\">\"BBC plans Dirk Gently TV series\"</a>. Chortle.co.uk. 11 October 2009<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">11 October</span> 2009</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=BBC+plans+Dirk+Gently+TV+series&amp;rft.date=2009-10-11&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.chortle.co.uk%2Fnews%2F2009%2F10%2F11%2F9767%2Fbbc_plans_dirk_gently_tv_series&amp;rft.pub=Chortle.co.uk&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-GoogleDoodle2013a-70\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-GoogleDoodle2013a_70-0\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation news\"><a rel=\"nofollow\" class=\"external text\" href=\"http://abcnews.go.com/blogs/technology/2013/03/dont-panic-google-doodle-honors-author-douglas-adams/\">\"Don't Panic! Google Doodle Honors Author Douglas Adams\"</a>. <i>abc News</i>. 11 March 2013<span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">11 March</span> 2013</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.atitle=Don%27t+Panic%21+Google+Doodle+Honors+Author+Douglas+Adams&amp;rft.date=2013-03-11&amp;rft.genre=article&amp;rft_id=http%3A%2F%2Fabcnews.go.com%2Fblogs%2Ftechnology%2F2013%2F03%2Fdont-panic-google-doodle-honors-author-douglas-adams%2F&amp;rft.jtitle=abc+News&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n<li id=\"cite_note-71\"><span class=\"mw-cite-backlink\"><b><a href=\"#cite_ref-71\">^</a></b></span> <span class=\"reference-text\"><cite class=\"citation web\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.google.com/doodles/douglas-adams-61st-birthday\">\"Douglas Adams' 61st Birthday\"</a><span class=\"reference-accessdate\">. Retrieved <span class=\"nowrap\">11 March</span> 2013</span>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.btitle=Douglas+Adams%27+61st+Birthday&amp;rft.genre=unknown&amp;rft_id=http%3A%2F%2Fwww.google.com%2Fdoodles%2Fdouglas-adams-61st-birthday&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></span></li>\n</ol>\n</div>\n<h2><span class=\"mw-headline\" id=\"References\">References</span></h2>\n<ul>\n<li>Adams, Douglas (1998). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.biota.org/people/douglasadams/\">Is there an Artificial God?</a>, speech at <i>Digital Biota 2</i>, Cambridge, England, September 1998.</li>\n<li><cite id=\"CITEREFAdams2002\" class=\"citation book\">Adams, Douglas (2002). <i>The Salmon of Doubt: Hitchhiking the Galaxy One Last Time</i>. London: Macmillan. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/0-333-76657-1\" title=\"Special:BookSources/0-333-76657-1\">0-333-76657-1</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.aufirst=Douglas&amp;rft.aulast=Adams&amp;rft.btitle=The+Salmon+of+Doubt%3A+Hitchhiking+the+Galaxy+One+Last+Time&amp;rft.date=2002&amp;rft.genre=book&amp;rft.isbn=0-333-76657-1&amp;rft.place=London&amp;rft.pub=Macmillan&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></li>\n<li>Dawkins, Richard (2003). \"Eulogy for Douglas Adams,\" in <i>A devil's chaplain: reflections on hope, lies, science, and love</i>. Houghton Mifflin Harcourt.</li>\n<li>Felch, Laura (2004). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.bookslut.com/nonfiction/2004_05_002057.php\">Don't Panic: Douglas Adams and the Hitchhiker's Guide to the Galaxy by Neil Gaiman</a>, May 2004</li>\n<li>Ray, Mohit K (2007). <i>Atlantic Companion to Literature in English</i>, Atlantic Publishers and Distributors. <a href=\"/wiki/Special:BookSources/8126908327\" class=\"internal mw-magiclink-isbn\">ISBN 81-269-0832-7</a></li>\n<li><cite id=\"CITEREFSimpson2003\" class=\"citation book\">Simpson, M. J. (2003). <i><a href=\"/w/index.php?title=Hitchhiker:_A_Biography_of_Douglas_Adams&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Hitchhiker: A Biography of Douglas Adams (page does not exist)\">Hitchhiker: A Biography of Douglas Adams</a></i> (1st ed.). Boston, Mass.: Justin, Charles &amp; Co. <a href=\"/wiki/International_Standard_Book_Number\" title=\"International Standard Book Number\">ISBN</a>&#160;<a href=\"/wiki/Special:BookSources/1-932112-17-0\" title=\"Special:BookSources/1-932112-17-0\">1-932112-17-0</a>.</cite><span title=\"ctx_ver=Z39.88-2004&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3ADouglas+Adams&amp;rft.aufirst=M.+J.&amp;rft.aulast=Simpson&amp;rft.btitle=Hitchhiker%3A+A+Biography+of+Douglas+Adams&amp;rft.date=2003&amp;rft.edition=1st&amp;rft.genre=book&amp;rft.isbn=1-932112-17-0&amp;rft.place=Boston%2C+Mass.&amp;rft.pub=Justin%2C+Charles+%26+Co&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook\" class=\"Z3988\"><span style=\"display:none;\">&#160;</span></span></li>\n<li>Webb, Nick (2005a). <i>Wish You Were Here: The Official Biography of Douglas Adams</i>. Ballantine Books. <a href=\"/wiki/Special:BookSources/0345476506\" class=\"internal mw-magiclink-isbn\">ISBN 0-345-47650-6</a></li>\n<li>Webb, Nick (2005b). <a rel=\"nofollow\" class=\"external text\" href=\"http://www.oxforddnb.com/view/article/75853\">\"Adams, Douglas Noël (1952–2001)\"</a>, <i>Oxford Dictionary of National Biography</i>, Oxford University Press, January 2005. Retrieved 25 October 2005.</li>\n</ul>\n<h2><span class=\"mw-headline\" id=\"Further_reading\">Further reading</span></h2>\n<h3><span class=\"mw-headline\" id=\"Articles\">Articles</span></h3>\n<div class=\"refbegin columns references-column-width\" style=\"-moz-column-width: 30em; -webkit-column-width: 30em; column-width: 30em;\">\n<ul>\n<li>Herbert, R. (1980). The Hitchhiker's Guide to the Galaxy (Book Review). Library Journal, 105(16), 1982.</li>\n<li>Adams, J., &amp; Brown, R. (1981). The Hitchhiker's Guide to the Galaxy (Book Review). School Library Journal, 27(5), 74.</li>\n<li>Nickerson, S. L. (1982). The Restaurant at the End of the Universe (Book). Library Journal, 107(4), 476.</li>\n<li>Nickerson, S. L. (1982). Life, the Universe, and Everything (Book). Library Journal, 107(18), 2007.</li>\n<li>Morner, C. (1982). The Restaurant at the End of the Universe (Book Review). School Library Journal, 28(8), 87.</li>\n<li>Morner, C. (1983). Life, the Universe and Everything (Book Review). School Library Journal, 29(6), 93.</li>\n<li>Shorb, B. (1985). So Long, and Thanks for All the Fish (Book). School Library Journal, 31(6), 90.</li>\n<li>The Long Dark Tea-Time of the Soul (Book). (1989). Atlantic (02769077), 263(4), 99.</li>\n<li>Hoffert, B., &amp; Quinn, J. (1990). Last Chance To See (Book). Library Journal, 115(16), 77.</li>\n<li>Reed, S. S., &amp; Cook, I. I. (1991). Dances with kakapos. People, 35(19), 79.</li>\n<li>Last Chance to See (Book). (1991). Science News, 139(8), 126.</li>\n<li>Field, M. M., &amp; Steinberg, S. S. (1991). Douglas Adams. Publishers Weekly, 238(6), 62.</li>\n<li>Dieter, W. (1991). Last Chance to See (Book). Smithsonian, 22(3), 140.</li>\n<li>Dykhuis, R. (1991). Last Chance To See (Book). Library Journal, 116(1), 140.</li>\n<li>Beatty, J. (1991). Good Show (Book). Atlantic (02769077), 267(3), 131.</li>\n<li>A guide to the future. (1992). Maclean's, 106(44), 51.</li>\n<li>Zinsser, J. (1993). Audio reviews: Fiction. Publishers Weekly, 240(9), 24.</li>\n<li>Taylor, B., &amp; Annichiarico, M. (1993). Audio reviews. Library Journal, 118(2), 132.</li>\n<li>Good reads. (1995). NetGuide, 2(4), 109.</li>\n<li>Stone, B. (1998). The unsinkable starship. Newsweek, 131(15), 78.</li>\n<li>Gaslin, G. (2001). Galaxy Quest. Entertainment Weekly, (599), 79.</li>\n<li>So long, and thanks for all the fish. (2001). Economist, 359(8222), 79.</li>\n<li>Geier, T., &amp; Raftery, B. M. (2001). Legacy. Entertainment Weekly, (597), 11.</li>\n<li>Passages. (2001). Maclean's, 114(21), 13.</li>\n<li>Don't panic! Douglas Adams to keynote Embedded show. (2001). Embedded Systems Programming, 14(3), 10.</li>\n<li>Ehrenman, G. (2001). World Wide Weird. InternetWeek, (862), 15.</li>\n<li>Zaleski, J. (2002). The Salmon of Doubt (Book). Publishers Weekly, 249(15), 43.</li>\n<li>Mort, J. (2002). The Salmon of Doubt (Book). Booklist, 98(16), 1386.</li>\n<li>Lewis, D. L. (2002). Last Time Round The Galaxy. Quadrant Magazine, 46(9), 84.</li>\n<li>Burns, A. (2002). The Salmon of Doubt (Book). Library Journal, 127(15), 111.</li>\n<li>Burns, A., &amp; Rhodes, B. (2002). The Restaurant at the End of the Universe (Book). Library Journal, 127(19), 118.</li>\n<li>Kaveney, R. (2002). A cheerful whale. TLS, (5173), 23.</li>\n<li>Pearl, N., &amp; Welch, R. (2003). The Hitchhiker's Guide To The Galaxy (Book). Library Journal, 128(11), 124.</li>\n<li>Preying on composite materials. (2003). R&amp;D Magazine, 45(6), 44.</li>\n<li>Webb, N. (2003). The Berkeley Hotel hostage. Bookseller, (5069), 25.</li>\n<li>The author who toured the universe. (2003). Bookseller, (5060), 35.</li>\n<li>Osmond, A. (2005). Only human. Sight &amp; Sound, 15(5), 12–15.</li>\n<li>Culture vulture. (2005). Times Educational Supplement, (4640), 19.</li>\n<li>Maughan, S. (2005). Audio Bestsellers/Fiction. Publishers Weekly, 252(30), 17.</li>\n<li>Hitchhiker At The Science Museum. (2005). In Britain, 14(10), 9.</li>\n<li>Rea, A. (2005). The Adams asteroids. New Scientist, 185(2488), 31.</li>\n<li>Most Improbable Adventure. (2005). Popular Mechanics, 182(5), 32.</li>\n<li>The Hitchhiker's Guide To The Galaxy: The Tertiary Phase. (2005). Publishers Weekly, 252(14), 21.</li>\n<li>Bartelt, K. R. (2005). Wish You Were Here: The Official Biography of Douglas Adams. Library Journal, 130(4), 86.</li>\n<li>Larsen, D. (2005). I was a teenage android. New Zealand Listener, 198(3390), 37–38.</li>\n<li>Tanner, J. C. (2005). Simplicity: it's hard. Telecom Asia, 16(6), 6.</li>\n<li>Nielsen Bookscan Charts. (2005). Bookseller, (5175), 18–21.</li>\n<li>Buena Vista launches regional site to push Hitchhiker's movie. (2005). New Media Age, 9.</li>\n<li>Shynola bring Beckland to life. (2005). Creative Review, 25(3), 24–26.</li>\n<li>Carwardine, M. (15 September 2007). The baiji: So long and thanks for all the fish. New Scientist. pp.&#160;50–53.</li>\n<li>Czarniawska, B. (2008). Accounting and gender across times and places: An excursion into fiction. Accounting, Organizations &amp; Society, 33(1), 33–47.</li>\n<li>Pope, M. (2008). Life, the Universe, Religion and Science. Issues, (82), 31–34.</li>\n<li>Bearne, S. (2008). BBC builds site to trail Last Chance To See TV series. New Media Age, 08.</li>\n<li>Arrow to reissue Adams. (2008). Bookseller, (5352), 14.</li>\n<li>Page, B. (2008). Colfer is new Hitchhiker. Bookseller, (5350), 7.</li>\n<li>I've got a perfect puzzle for you. (2009). Bookseller, (5404), 42.</li>\n<li>Mostly Harmless.... (2009). Bookseller, (5374), 46.</li>\n<li>Penguin and PanMac hitch a ride together. (2009). Bookseller, (5373), 6.</li>\n<li>Adams, Douglas. Britannica Biographies [serial online]. October 2010;:1</li>\n<li>Douglas (Noël) Adams (1952–2001). Hutchinson's Biography Database [serial online]. July 2011;:1</li>\n<li>My life in books. (2011). Times Educational Supplement, (4940), 27.</li>\n</ul>\n</div>\n<h3><span class=\"mw-headline\" id=\"Other\">Other</span></h3>\n<ul>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"https://web.archive.org/web/20110720193159/http://www.douglasadams.com/\">Adams's official web site</a> at the <a href=\"/wiki/Wayback_Machine\" title=\"Wayback Machine\">Wayback Machine</a> (archived 20 July 2011), established by him, and still operated by <a href=\"/wiki/The_Digital_Village\" title=\"The Digital Village\">The Digital Village</a></li>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"https://www.ted.com/speakers/douglas_adams\">Douglas Adams</a> at <a href=\"/wiki/TED_(conference)\" title=\"TED (conference)\">TED</a></li>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"http://www.biota.org/people/douglasadams/\">Douglas Adams speech at Digital Biota 2 (1998)</a> <a rel=\"nofollow\" class=\"external text\" href=\"http://www.biota.org/podcast/#DNA\">(The audio of the speech)</a></li>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"http://www.guardian.co.uk/books/2008/jun/09/douglasadams\">Guardian Books \"Author Page\"</a>, with profile and links to further articles.</li>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"//worldcat.org/identities/lccn-n80-76765\">Works by or about Douglas Adams</a> in libraries (<a href=\"/wiki/WorldCat\" title=\"WorldCat\">WorldCat</a> catalog)</li>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"http://www.vintagemacworld.com/iifx.html\">Douglas Adams &amp; his Computer</a> article about his Mac IIfx</li>\n<li>BBC2 \"Omnibus\" tribute to Adams, presented by Kirsty Wark, 4 August 2001</li>\n<li>Mueller, Rick and Greengrass, Joel (2002). <i>Life, The Universe and Douglas Adams</i>, documentary.</li>\n<li>Simpson, M.J. (2001). <i>The Pocket Essential Hitchhiker's Guide</i>. <a href=\"/wiki/Special:BookSources/1903047404\" class=\"internal mw-magiclink-isbn\">ISBN 1-903047-40-4</a>. Updated April 2005 <a href=\"/wiki/Special:BookSources/1904048463\" class=\"internal mw-magiclink-isbn\">ISBN 1-904048-46-3</a></li>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"http://www.bbc.co.uk/programmes/p00fpvbm\">Special edition of BBC Book Club featuring Douglas Adams</a>, first broadcast 2 January 2000 on BBC Radio 4</li>\n</ul>\n<h2><span class=\"mw-headline\" id=\"External_links\">External links</span></h2>\n<table class=\"vertical-navbox nowraplinks infobox\" style=\"float:right;clear:right;width:auto;margin:0 0 1.0em 1.0em;background:#f9f9f9;border:1px solid #aaa;padding:0.2em;border-spacing:0.4em 0;text-align:center;line-height:1.4em;font-size:88%\">\n<tr>\n<td style=\"padding-top:0.4em;line-height:1.2em\"><a href=\"/wiki/Wikipedia:LIBRARY\" class=\"mw-redirect\" title=\"Wikipedia:LIBRARY\">Library resources</a> about<br />\n<b>Douglas Adams</b>\n<hr /></td>\n</tr>\n<tr>\n<td class=\"plainlist\" style=\"padding:0 0.1em 0.4em;text-align:left;\">\n<ul>\n<li><a class=\"external text\" href=\"//tools.wmflabs.org/ftl/cgi-bin/ftl?st=viaf&amp;su=113230702\">Resources in your library</a></li>\n<li><a class=\"external text\" href=\"//tools.wmflabs.org/ftl/cgi-bin/ftl?st=viaf&amp;su=113230702&amp;library=0CHOOSE0\">Resources in other libraries</a></li>\n</ul>\n</td>\n</tr>\n<tr>\n<th style=\"padding:0.1em\">By Douglas Adams</th>\n</tr>\n<tr>\n<td class=\"plainlist\" style=\"padding:0 0.1em 0.4em;text-align:left;\">\n<ul>\n<li><a class=\"external text\" href=\"//tools.wmflabs.org/ftl/cgi-bin/ftl?at=viaf&amp;au=113230702\">Resources in your library</a></li>\n<li><a class=\"external text\" href=\"//tools.wmflabs.org/ftl/cgi-bin/ftl?at=viaf&amp;au=113230702&amp;library=0CHOOSE0\">Resources in other libraries</a></li>\n</ul>\n</td>\n</tr>\n</table>\n<div id=\"section_SpokenWikipedia\" class=\"infobox sisterproject noprint\">\n<div style=\"text-align: center;\"><b>Listen to this article (2 parts)&#160;</b>·  <a href=\"/wiki/File:Douglas_Adams_Part_1.ogg\" title=\"File:Douglas Adams Part 1.ogg\">(info)</a></div>\n<div style=\"text-align: center; font-size: 90%; margin-bottom: .4em;\"><i><a href=\"//upload.wikimedia.org/wikipedia/commons/4/4a/Douglas_Adams_Part_1.ogg\" class=\"internal\" title=\"Douglas Adams Part 1.ogg\">Part 1</a>&#160;• <a href=\"//upload.wikimedia.org/wikipedia/commons/c/c6/Douglas_Adams_Part_2.ogg\" class=\"internal\" title=\"Douglas Adams Part 2.ogg\">Part 2</a></i></div>\n<div style=\"float: left; margin-left: 5px;\">\n<div class=\"floatnone\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/4/47/Sound-icon.svg/45px-Sound-icon.svg.png\" title=\"Spoken Wikipedia\" width=\"45\" height=\"34\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/4/47/Sound-icon.svg/68px-Sound-icon.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/4/47/Sound-icon.svg/90px-Sound-icon.svg.png 2x\" data-file-width=\"128\" data-file-height=\"96\" /></div>\n</div>\n<div style=\"font-size: xx-small; line-height: 1.6em; margin-left: 60px;\">This audio file was created from a revision of the \"<span class=\"fn\">Douglas Adams</span>\" article dated 2006-02-11, and does not reflect subsequent edits to the article. (<a href=\"/wiki/Wikipedia:Media_help\" title=\"Wikipedia:Media help\">Audio help</a>)</div>\n<div style=\"text-align: center; clear: both\"><b><a href=\"/wiki/Wikipedia:Spoken_articles\" title=\"Wikipedia:Spoken articles\">More spoken articles</a></b></div>\n</div>\n<ul>\n<li><a href=\"/wiki/File:Commons-logo.svg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/12px-Commons-logo.svg.png\" width=\"12\" height=\"16\" class=\"noviewer\" srcset=\"//upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/18px-Commons-logo.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/24px-Commons-logo.svg.png 2x\" data-file-width=\"1024\" data-file-height=\"1376\" /></a> Media related to <a href=\"https://commons.wikimedia.org/wiki/Category:Douglas_Adams\" class=\"extiw\" title=\"commons:Category:Douglas Adams\">Douglas Adams</a> at Wikimedia Commons</li>\n<li><a href=\"/wiki/File:Wikiquote-logo.svg\" class=\"image\"><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikiquote-logo.svg/13px-Wikiquote-logo.svg.png\" width=\"13\" height=\"16\" class=\"noviewer\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikiquote-logo.svg/20px-Wikiquote-logo.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikiquote-logo.svg/27px-Wikiquote-logo.svg.png 2x\" data-file-width=\"300\" data-file-height=\"355\" /></a> Quotations related to <a href=\"https://en.wikiquote.org/wiki/Special:Search/Douglas_Adams\" class=\"extiw\" title=\"wikiquote:Special:Search/Douglas Adams\">Douglas Adams</a> at Wikiquote</li>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"https://www.findagrave.com/cgi-bin/fg.cgi?page=gr&amp;GRid=22814\">Douglas Adams</a> at <i><a href=\"/wiki/Find_a_Grave\" title=\"Find a Grave\">Find a Grave</a></i></li>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"http://www.imdb.com/name/nm0010930/\">Douglas Adams</a> at the <a href=\"/wiki/IMDb\" title=\"IMDb\">Internet Movie Database</a></li>\n<li><a rel=\"nofollow\" class=\"external text\" href=\"http://towelday.org/\">Towel Day, 25 May</a></li>\n</ul>\n<table class=\"wikitable succession-box\" style=\"margin:0.5em auto; font-size:95%;clear:both;\">\n<tr style=\"text-align:center;\">\n<td style=\"width:30%;\" rowspan=\"1\">Preceded&#160;by<br />\n<span style=\"font-weight: bold\"><a href=\"/wiki/Anthony_Read\" title=\"Anthony Read\">Anthony Read</a></span></td>\n<td style=\"width: 40%; text-align: center;\" rowspan=\"1\"><b><i><a href=\"/wiki/Doctor_Who\" title=\"Doctor Who\">Doctor Who</a></i> script editor</b><br />\n1979–80</td>\n<td style=\"width: 30%; text-align: center;\" rowspan=\"1\">Succeeded&#160;by<br />\n<span style=\"font-weight: bold\"><a href=\"/wiki/Christopher_H._Bidmead\" title=\"Christopher H. Bidmead\">Christopher H. Bidmead</a></span></td>\n</tr>\n</table>\n<div role=\"navigation\" class=\"navbox\" aria-labelledby=\"Works_by_Douglas_Adams\" style=\"padding:3px\">\n<table class=\"nowraplinks collapsible autocollapse navbox-inner\" style=\"border-spacing:0;background:transparent;color:inherit\">\n<tr>\n<th scope=\"col\" class=\"navbox-title\" colspan=\"2\">\n<div class=\"plainlinks hlist navbar mini\">\n<ul>\n<li class=\"nv-view\"><a href=\"/wiki/Template:Douglas_Adams\" title=\"Template:Douglas Adams\"><abbr title=\"View this template\" style=\";;background:none transparent;border:none;\">v</abbr></a></li>\n<li class=\"nv-talk\"><a href=\"/wiki/Template_talk:Douglas_Adams\" title=\"Template talk:Douglas Adams\"><abbr title=\"Discuss this template\" style=\";;background:none transparent;border:none;\">t</abbr></a></li>\n<li class=\"nv-edit\"><a class=\"external text\" href=\"//en.wikipedia.org/w/index.php?title=Template:Douglas_Adams&amp;action=edit\"><abbr title=\"Edit this template\" style=\";;background:none transparent;border:none;\">e</abbr></a></li>\n</ul>\n</div>\n<div id=\"Works_by_Douglas_Adams\" style=\"font-size:114%\">Works by <strong class=\"selflink\">Douglas Adams</strong></div>\n</th>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Novels</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(novel)\" title=\"The Hitchhiker's Guide to the Galaxy (novel)\">The Hitchhiker's Guide to the Galaxy</a></i></li>\n<li><i><a href=\"/wiki/The_Restaurant_at_the_End_of_the_Universe\" title=\"The Restaurant at the End of the Universe\">The Restaurant at the End of the Universe</a></i></li>\n<li><i><a href=\"/wiki/Life,_the_Universe_and_Everything\" title=\"Life, the Universe and Everything\">Life, the Universe and Everything</a></i></li>\n<li><i><a href=\"/wiki/So_Long,_and_Thanks_for_All_the_Fish\" title=\"So Long, and Thanks for All the Fish\">So Long, and Thanks for All the Fish</a></i></li>\n<li><i><a href=\"/wiki/Dirk_Gently%27s_Holistic_Detective_Agency\" title=\"Dirk Gently's Holistic Detective Agency\">Dirk Gently's Holistic Detective Agency</a></i></li>\n<li><i><a href=\"/wiki/The_Long_Dark_Tea-Time_of_the_Soul\" title=\"The Long Dark Tea-Time of the Soul\">The Long Dark Tea-Time of the Soul</a></i></li>\n<li><i><a href=\"/wiki/Mostly_Harmless\" title=\"Mostly Harmless\">Mostly Harmless</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Short stories</th>\n<td class=\"navbox-list navbox-even hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li>\"<a href=\"/wiki/The_Private_Life_of_Genghis_Khan\" title=\"The Private Life of Genghis Khan\">The Private Life of Genghis Khan</a>\"</li>\n<li>\"<a href=\"/wiki/Young_Zaphod_Plays_It_Safe\" title=\"Young Zaphod Plays It Safe\">Young Zaphod Plays It Safe</a>\"</li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Books</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Meaning_of_Liff\" title=\"The Meaning of Liff\">The Meaning of Liff</a></i></li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy:_The_Original_Radio_Scripts\" title=\"The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts\">The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts</a></i></li>\n<li><i><a href=\"/wiki/Last_Chance_to_See\" title=\"Last Chance to See\">Last Chance to See</a></i></li>\n<li><i><a href=\"/wiki/The_Deeper_Meaning_of_Liff\" class=\"mw-redirect\" title=\"The Deeper Meaning of Liff\">The Deeper Meaning of Liff</a></i></li>\n<li><i><a href=\"/wiki/Douglas_Adams%27s_Guide_to_The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"Douglas Adams's Guide to The Hitchhiker's Guide to the Galaxy\">Douglas Adams's Guide to The Hitchhiker's Guide to the Galaxy</a></i></li>\n<li><i><a href=\"/wiki/The_Salmon_of_Doubt\" title=\"The Salmon of Doubt\">The Salmon of Doubt</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Screenplays</th>\n<td class=\"navbox-list navbox-even hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i>Monty Python's Flying Circus</i>\n<ul>\n<li>\"<a href=\"/wiki/Patient_Abuse\" title=\"Patient Abuse\">Patient Abuse</a>\"</li>\n</ul>\n</li>\n<li><i><a href=\"/wiki/Out_of_the_Trees\" title=\"Out of the Trees\">Out of the Trees</a></i></li>\n<li><i>Doctor Who</i>\n<ul>\n<li><i><a href=\"/wiki/The_Pirate_Planet\" title=\"The Pirate Planet\">The Pirate Planet</a></i></li>\n<li><i><a href=\"/wiki/City_of_Death\" title=\"City of Death\">City of Death</a></i></li>\n<li><i><a href=\"/wiki/Shada_(Doctor_Who)\" title=\"Shada (Doctor Who)\">Shada</a></i></li>\n</ul>\n</li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(TV_series)\" title=\"The Hitchhiker's Guide to the Galaxy (TV series)\">The Hitchhiker's Guide to the Galaxy</a></i> (TV series)</li>\n<li><i><a href=\"/wiki/Hyperland\" title=\"Hyperland\">Hyperland</a></i></li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(film)\" title=\"The Hitchhiker's Guide to the Galaxy (film)\">The Hitchhiker's Guide to the Galaxy</a></i> (film)</li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Video games</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(video_game)\" title=\"The Hitchhiker's Guide to the Galaxy (video game)\">The Hitchhiker's Guide to the Galaxy</a></i></li>\n<li><i><a href=\"/wiki/Bureaucracy_(video_game)\" title=\"Bureaucracy (video game)\">Bureaucracy</a></i></li>\n<li><i><a href=\"/wiki/Starship_Titanic\" title=\"Starship Titanic\">Starship Titanic</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">See also</th>\n<td class=\"navbox-list navbox-even hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"The Hitchhiker's Guide to the Galaxy\">The Hitchhiker's Guide to the Galaxy</a></i> (series)</li>\n<li><i><a href=\"/wiki/Douglas_Adams_at_the_BBC\" title=\"Douglas Adams at the BBC\">Douglas Adams at the BBC</a></i></li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Future\" title=\"The Hitchhiker's Guide to the Future\">The Hitchhiker's Guide to the Future</a></i> (BBC radio series)</li>\n<li><i><a href=\"/wiki/The_Utterly_Utterly_Merry_Comic_Relief_Christmas_Book\" title=\"The Utterly Utterly Merry Comic Relief Christmas Book\">The Utterly Utterly Merry Comic Relief Christmas Book</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</div>\n<div role=\"navigation\" class=\"navbox\" aria-labelledby=\"Douglas_Adams.27s_The_Hitchhiker.27s_Guide_to_the_Galaxy\" style=\"padding:3px\">\n<table class=\"nowraplinks collapsible autocollapse navbox-inner\" style=\"border-spacing:0;background:transparent;color:inherit\">\n<tr>\n<th scope=\"col\" class=\"navbox-title\" colspan=\"2\">\n<div class=\"plainlinks hlist navbar mini\">\n<ul>\n<li class=\"nv-view\"><a href=\"/wiki/Template:The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"Template:The Hitchhiker's Guide to the Galaxy\"><abbr title=\"View this template\" style=\";;background:none transparent;border:none;\">v</abbr></a></li>\n<li class=\"nv-talk\"><a href=\"/wiki/Template_talk:The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"Template talk:The Hitchhiker's Guide to the Galaxy\"><abbr title=\"Discuss this template\" style=\";;background:none transparent;border:none;\">t</abbr></a></li>\n<li class=\"nv-edit\"><a class=\"external text\" href=\"//en.wikipedia.org/w/index.php?title=Template:The_Hitchhiker%27s_Guide_to_the_Galaxy&amp;action=edit\"><abbr title=\"Edit this template\" style=\";;background:none transparent;border:none;\">e</abbr></a></li>\n</ul>\n</div>\n<div id=\"Douglas_Adams.27s_The_Hitchhiker.27s_Guide_to_the_Galaxy\" style=\"font-size:114%\"><strong class=\"selflink\">Douglas Adams's</strong> <i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"The Hitchhiker's Guide to the Galaxy\">The Hitchhiker's Guide to the Galaxy</a></i></div>\n</th>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Books</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"></div>\n<table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Main series</div>\n</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(novel)\" title=\"The Hitchhiker's Guide to the Galaxy (novel)\">The Hitchhiker's Guide to the Galaxy</a></i></li>\n<li><i><a href=\"/wiki/The_Restaurant_at_the_End_of_the_Universe\" title=\"The Restaurant at the End of the Universe\">The Restaurant at the End of the Universe</a></i></li>\n<li><i><a href=\"/wiki/Life,_the_Universe_and_Everything\" title=\"Life, the Universe and Everything\">Life, the Universe and Everything</a></i></li>\n<li><i><a href=\"/wiki/So_Long,_and_Thanks_for_All_the_Fish\" title=\"So Long, and Thanks for All the Fish\">So Long, and Thanks for All the Fish</a></i></li>\n<li><i><a href=\"/wiki/Mostly_Harmless\" title=\"Mostly Harmless\">Mostly Harmless</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Related works</div>\n</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li>\"<a href=\"/wiki/Young_Zaphod_Plays_It_Safe\" title=\"Young Zaphod Plays It Safe\">Young Zaphod Plays It Safe</a>\"</li>\n<li><i><a href=\"/wiki/The_Salmon_of_Doubt\" title=\"The Salmon of Doubt\">The Salmon of Doubt</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">by <a href=\"/wiki/Eoin_Colfer\" title=\"Eoin Colfer\">Eoin Colfer</a></div>\n</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"><i><a href=\"/wiki/And_Another_Thing..._(novel)\" title=\"And Another Thing... (novel)\">And Another Thing...</a></i></div>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Media</th>\n<td class=\"navbox-list navbox-even hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(radio_series)\" title=\"The Hitchhiker's Guide to the Galaxy (radio series)\">Radio series</a>\n<ul>\n<li><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_Primary_and_Secondary_Phases\" title=\"The Hitchhiker's Guide to the Galaxy Primary and Secondary Phases\">Phases 1 &amp; 2</a></li>\n<li><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_Tertiary_to_Quintessential_Phases\" title=\"The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases\">Phases 3, 4 &amp; 5</a></li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy:_The_Original_Radio_Scripts\" title=\"The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts\">The Original Radio Scripts</a></i></li>\n</ul>\n</li>\n<li><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(TV_series)\" title=\"The Hitchhiker's Guide to the Galaxy (TV series)\">TV series</a></li>\n<li><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(film)\" title=\"The Hitchhiker's Guide to the Galaxy (film)\">Film</a></li>\n<li><a href=\"/wiki/Timeline_of_The_Hitchhiker%27s_Guide_to_the_Galaxy_versions\" title=\"Timeline of The Hitchhiker's Guide to the Galaxy versions\">Timeline of <i>The Hitchhiker's Guide to the Galaxy</i> versions</a></li>\n<li><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_cast_lists\" title=\"The Hitchhiker's Guide to the Galaxy cast lists\">Cast lists</a></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Games</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(video_game)\" title=\"The Hitchhiker's Guide to the Galaxy (video game)\">The Hitchhiker's Guide to the Galaxy</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Companion<br />\nmedia</th>\n<td class=\"navbox-list navbox-even hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Don%27t_Panic:_The_Official_Hitchhiker%27s_Guide_to_the_Galaxy_Companion\" title=\"Don't Panic: The Official Hitchhiker's Guide to the Galaxy Companion\">Don't Panic: The Official Hitchhiker's Guide to the Galaxy Companion</a></i></li>\n<li><i><a href=\"/wiki/Douglas_Adams%27s_Guide_to_The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"Douglas Adams's Guide to The Hitchhiker's Guide to the Galaxy\">Douglas Adams's Guide to The Hitchhiker's Guide to the Galaxy</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Characters</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Arthur_Dent\" title=\"Arthur Dent\">Arthur Dent</a></li>\n<li><a href=\"/wiki/Ford_Prefect_(character)\" title=\"Ford Prefect (character)\">Ford Prefect</a></li>\n<li><a href=\"/wiki/Zaphod_Beeblebrox\" title=\"Zaphod Beeblebrox\">Zaphod Beeblebrox</a></li>\n<li><a href=\"/wiki/Marvin_(character)\" title=\"Marvin (character)\">Marvin the Paranoid Android</a></li>\n<li><a href=\"/wiki/Trillian_(character)\" title=\"Trillian (character)\">Trillian</a></li>\n<li><a href=\"/wiki/Slartibartfast\" title=\"Slartibartfast\">Slartibartfast</a></li>\n<li><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(fictional)\" title=\"The Hitchhiker's Guide to the Galaxy (fictional)\">The <i>Guide</i></a></li>\n<li><a href=\"/wiki/List_of_minor_The_Hitchhiker%27s_Guide_to_the_Galaxy_characters\" title=\"List of minor The Hitchhiker's Guide to the Galaxy characters\">Minor characters</a></li>\n<li><a href=\"/wiki/List_of_races_and_species_in_The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"List of races and species in The Hitchhiker's Guide to the Galaxy\">Races and species</a></li>\n<li><a href=\"/wiki/Vogon\" title=\"Vogon\">Vogons</a></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Miscellanea</th>\n<td class=\"navbox-list navbox-even hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Phrases_from_The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"Phrases from The Hitchhiker's Guide to the Galaxy\">Phrases</a></li>\n<li><a href=\"/wiki/Places_in_The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"Places in The Hitchhiker's Guide to the Galaxy\">Places</a></li>\n<li><a href=\"/wiki/Technology_in_The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"Technology in The Hitchhiker's Guide to the Galaxy\">Technology</a></li>\n<li><a href=\"/wiki/Somebody_else%27s_problem\" title=\"Somebody else's problem\">Somebody else's problem</a></li>\n<li><i><a href=\"/wiki/Encyclopedia_Galactica\" title=\"Encyclopedia Galactica\">Encyclopedia Galactica</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">In culture</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/H2g2\" title=\"H2g2\">h2g2</a></li>\n<li><a href=\"/wiki/Hitchcon\" title=\"Hitchcon\">Hitchcon</a></li>\n<li><a href=\"/wiki/Towel_Day\" title=\"Towel Day\">Towel Day</a></li>\n<li>\"<a href=\"/wiki/Journey_of_the_Sorcerer\" class=\"mw-redirect\" title=\"Journey of the Sorcerer\">Journey of the Sorcerer</a>\"</li>\n<li><a href=\"/wiki/18610_Arthurdent\" title=\"18610 Arthurdent\">18610 Arthurdent</a></li>\n<li><a href=\"/wiki/25924_Douglasadams\" title=\"25924 Douglasadams\">25924 Douglasadams</a></li>\n<li><i><a href=\"/wiki/Bidenichthys_beeblebroxi\" title=\"Bidenichthys beeblebroxi\">Bidenichthys beeblebroxi</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<td class=\"navbox-abovebelow hlist\" colspan=\"2\">\n<div>\n<ul>\n<li><a href=\"/wiki/Portal:Hitchhiker%27s\" title=\"Portal:Hitchhiker's\">Portal</a></li>\n<li><a href=\"/wiki/Category:The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"Category:The Hitchhiker's Guide to the Galaxy\">Category</a></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</div>\n<div role=\"navigation\" class=\"navbox\" aria-labelledby=\"Dirk_Gently\" style=\"padding:3px\">\n<table class=\"nowraplinks collapsible autocollapse navbox-inner\" style=\"border-spacing:0;background:transparent;color:inherit\">\n<tr>\n<th scope=\"col\" class=\"navbox-title\" colspan=\"3\">\n<div class=\"plainlinks hlist navbar mini\">\n<ul>\n<li class=\"nv-view\"><a href=\"/wiki/Template:Dirk_Gently\" title=\"Template:Dirk Gently\"><abbr title=\"View this template\" style=\";;background:none transparent;border:none;\">v</abbr></a></li>\n<li class=\"nv-talk\"><a href=\"/w/index.php?title=Template_talk:Dirk_Gently&amp;action=edit&amp;redlink=1\" class=\"new\" title=\"Template talk:Dirk Gently (page does not exist)\"><abbr title=\"Discuss this template\" style=\";;background:none transparent;border:none;\">t</abbr></a></li>\n<li class=\"nv-edit\"><a class=\"external text\" href=\"//en.wikipedia.org/w/index.php?title=Template:Dirk_Gently&amp;action=edit\"><abbr title=\"Edit this template\" style=\";;background:none transparent;border:none;\">e</abbr></a></li>\n</ul>\n</div>\n<div id=\"Dirk_Gently\" style=\"font-size:114%\"><a href=\"/wiki/Dirk_Gently\" title=\"Dirk Gently\">Dirk Gently</a></div>\n</th>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<td class=\"navbox-abovebelow\" colspan=\"3\">\n<div>By <strong class=\"selflink\">Douglas Adams</strong></div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Novels</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Dirk_Gently%27s_Holistic_Detective_Agency\" title=\"Dirk Gently's Holistic Detective Agency\">Dirk Gently's Holistic Detective Agency</a></i></li>\n<li><i><a href=\"/wiki/The_Long_Dark_Tea-Time_of_the_Soul\" title=\"The Long Dark Tea-Time of the Soul\">The Long Dark Tea-Time of the Soul</a></i></li>\n<li><i><a href=\"/wiki/The_Salmon_of_Doubt\" title=\"The Salmon of Doubt\">The Salmon of Doubt</a></i> (unfinished)</li>\n</ul>\n</div>\n</td>\n<td class=\"navbox-image\" rowspan=\"5\" style=\"width:0%;padding:0px 0px 0px 2px\">\n<div><img alt=\"\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/7/74/Dirk_Gently%27s_Holistic_Detective_Agency.svg/150px-Dirk_Gently%27s_Holistic_Detective_Agency.svg.png\" width=\"150\" height=\"113\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/7/74/Dirk_Gently%27s_Holistic_Detective_Agency.svg/225px-Dirk_Gently%27s_Holistic_Detective_Agency.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/7/74/Dirk_Gently%27s_Holistic_Detective_Agency.svg/300px-Dirk_Gently%27s_Holistic_Detective_Agency.svg.png 2x\" data-file-width=\"512\" data-file-height=\"384\" /></div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Adaptations</th>\n<td class=\"navbox-list navbox-even hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"></div>\n<table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Radio</div>\n</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Dirk_Gently%27s_Holistic_Detective_Agency_(radio_serial)\" class=\"mw-redirect\" title=\"Dirk Gently's Holistic Detective Agency (radio serial)\">Dirk Gently's Holistic Detective Agency</a></i></li>\n<li><i><a href=\"/wiki/The_Long_Dark_Tea-Time_of_the_Soul_(radio_serial)\" title=\"The Long Dark Tea-Time of the Soul (radio serial)\">The Long Dark Tea-Time of the Soul</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Theatre</div>\n</th>\n<td class=\"navbox-list navbox-even hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"><i><a href=\"/wiki/Dirk_(play)\" title=\"Dirk (play)\">Dirk</a></i></div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Television</div>\n</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Dirk_Gently_(TV_series)\" title=\"Dirk Gently (TV series)\">Dirk Gently</a></i>\n<ul>\n<li>\"<a href=\"/wiki/Pilot_(Dirk_Gently)\" title=\"Pilot (Dirk Gently)\">Pilot</a>\"</li>\n</ul>\n</li>\n<li><i><a href=\"/wiki/Dirk_Gently%27s_Holistic_Detective_Agency_(TV_series)\" title=\"Dirk Gently's Holistic Detective Agency (TV series)\">Dirk Gently's Holistic Detective Agency</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Related</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/St._Cedd%27s_College,_Cambridge\" title=\"St. Cedd's College, Cambridge\">St. Cedd's College</a></li>\n<li><i><a href=\"/wiki/Douglas_Adams_at_the_BBC\" title=\"Douglas Adams at the BBC\">Douglas Adams at the BBC</a></i></li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy\" title=\"The Hitchhiker's Guide to the Galaxy\">The Hitchhiker's Guide to the Galaxy</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</div>\n<div role=\"navigation\" class=\"navbox\" aria-labelledby=\"Doctor_Who\" style=\"padding:3px\">\n<table class=\"nowraplinks hlist collapsible autocollapse navbox-inner\" style=\"border-spacing:0;background:transparent;color:inherit\">\n<tr>\n<th scope=\"col\" class=\"navbox-title\" colspan=\"2\">\n<div class=\"plainlinks hlist navbar mini\">\n<ul>\n<li class=\"nv-view\"><a href=\"/wiki/Template:Doctor_Who\" title=\"Template:Doctor Who\"><abbr title=\"View this template\" style=\";;background:none transparent;border:none;\">v</abbr></a></li>\n<li class=\"nv-talk\"><a href=\"/wiki/Template_talk:Doctor_Who\" title=\"Template talk:Doctor Who\"><abbr title=\"Discuss this template\" style=\";;background:none transparent;border:none;\">t</abbr></a></li>\n<li class=\"nv-edit\"><a class=\"external text\" href=\"//en.wikipedia.org/w/index.php?title=Template:Doctor_Who&amp;action=edit\"><abbr title=\"Edit this template\" style=\";;background:none transparent;border:none;\">e</abbr></a></li>\n</ul>\n</div>\n<div id=\"Doctor_Who\" style=\"font-size:114%\"><i><a href=\"/wiki/Doctor_Who\" title=\"Doctor Who\">Doctor Who</a></i></div>\n</th>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Pages</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"></div>\n<table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Characters</div>\n</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/The_Doctor_(Doctor_Who)\" title=\"The Doctor (Doctor Who)\">The Doctor</a></li>\n<li><a href=\"/wiki/Companion_(Doctor_Who)\" title=\"Companion (Doctor Who)\">Companions</a></li>\n<li><a href=\"/wiki/Time_Lord\" title=\"Time Lord\">Time Lords</a></li>\n<li><a href=\"/wiki/Dalek\" title=\"Dalek\">Daleks</a></li>\n<li><a href=\"/wiki/Cyberman\" title=\"Cyberman\">Cybermen</a></li>\n<li><a href=\"/wiki/The_Master_(Doctor_Who)\" title=\"The Master (Doctor Who)\">The Master</a></li>\n<li><a href=\"/wiki/Slitheen\" title=\"Slitheen\">Slitheen</a></li>\n<li><a href=\"/wiki/Sontaran\" title=\"Sontaran\">Sontarans</a></li>\n<li><a href=\"/wiki/Weeping_Angel\" title=\"Weeping Angel\">Weeping Angels</a></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Concepts</div>\n</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/TARDIS\" title=\"TARDIS\">TARDIS</a></li>\n<li><a href=\"/wiki/Regeneration_(Doctor_Who)\" title=\"Regeneration (Doctor Who)\">Regeneration</a></li>\n<li><a href=\"/wiki/Sonic_screwdriver\" title=\"Sonic screwdriver\">Sonic screwdriver</a></li>\n<li><a href=\"/wiki/Time_vortex_(Doctor_Who)\" title=\"Time vortex (Doctor Who)\">Time Vortex</a></li>\n<li><a href=\"/wiki/Time_War_(Doctor_Who)\" title=\"Time War (Doctor Who)\">Time War</a></li>\n<li><a href=\"/wiki/Blinovitch_Limitation_Effect\" title=\"Blinovitch Limitation Effect\">Blinovitch Limitation Effect</a></li>\n<li><a href=\"/wiki/Whoniverse\" title=\"Whoniverse\">Whoniverse</a></li>\n<li><a href=\"/wiki/Torchwood_Institute\" title=\"Torchwood Institute\">Torchwood Institute</a></li>\n<li><a href=\"/wiki/UNIT\" title=\"UNIT\">UNIT</a></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Miscellaneous</div>\n</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/History_of_Doctor_Who\" title=\"History of Doctor Who\">History</a></li>\n<li><a href=\"/wiki/Doctor_Who_missing_episodes\" title=\"Doctor Who missing episodes\">Missing episodes</a></li>\n<li><a href=\"/wiki/Doctor_Who_music\" title=\"Doctor Who music\">Music</a></li>\n<li><a href=\"/wiki/Doctor_Who_theme_music\" title=\"Doctor Who theme music\">Theme music</a></li>\n<li><a href=\"/wiki/Doctor_Who_in_Canada_and_the_United_States\" title=\"Doctor Who in Canada and the United States\"><i>Doctor Who</i> in Canada and the U.S.</a></li>\n<li><a href=\"/wiki/Doctor_Who_in_Australia\" title=\"Doctor Who in Australia\"><i>Doctor Who</i> in Australia</a></li>\n<li><a href=\"/wiki/Doctor_Who_fandom\" title=\"Doctor Who fandom\">Fandom</a></li>\n<li><a href=\"/wiki/Doctor_Who_merchandise\" title=\"Doctor Who merchandise\">Merchandise</a></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Lists</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"></div>\n<table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Production</div>\n</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/List_of_Doctor_Who_serials\" title=\"List of Doctor Who serials\">Serials</a>\n<ul>\n<li><a href=\"/wiki/List_of_unmade_Doctor_Who_serials_and_films\" title=\"List of unmade Doctor Who serials and films\">unmade</a></li>\n</ul>\n</li>\n<li><a href=\"/wiki/List_of_special_Doctor_Who_episodes\" title=\"List of special Doctor Who episodes\">Special episodes</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_Christmas_specials\" title=\"List of Doctor Who Christmas specials\">Christmas specials</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_radio_stories\" title=\"List of Doctor Who radio stories\">Radio stories</a></li>\n<li><a href=\"/wiki/List_of_awards_and_nominations_received_by_Doctor_Who\" title=\"List of awards and nominations received by Doctor Who\">Awards and nominations</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_home_video_releases\" title=\"List of Doctor Who home video releases\">Home video</a></li>\n<li><a href=\"/wiki/List_of_actors_who_have_played_the_Doctor\" title=\"List of actors who have played the Doctor\">Doctors</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_cast_members\" title=\"List of Doctor Who cast members\">Cast</a></li>\n<li><a href=\"/wiki/List_of_guest_appearances_in_Doctor_Who\" title=\"List of guest appearances in Doctor Who\">Guest appearances</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_producers\" title=\"List of Doctor Who producers\">Producers</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_script_editors\" title=\"List of Doctor Who script editors\">Script editors</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_writers\" title=\"List of Doctor Who writers\">Writers</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_directors\" title=\"List of Doctor Who directors\">Directors</a></li>\n<li><a href=\"/wiki/List_of_music_featured_on_Doctor_Who\" title=\"List of music featured on Doctor Who\">Music</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_composers\" title=\"List of Doctor Who composers\">Composers</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_music_releases\" title=\"List of Doctor Who music releases\">Soundtrack releases</a></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Narrative devices</div>\n</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/List_of_Doctor_Who_supporting_characters\" title=\"List of Doctor Who supporting characters\">Supporting characters</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_historical_characters\" title=\"List of Doctor Who historical characters\">Historical characters</a></li>\n<li><a href=\"/wiki/List_of_UNIT_personnel\" title=\"List of UNIT personnel\">UNIT personnel</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_universe_creatures_and_aliens\" title=\"List of Doctor Who universe creatures and aliens\">Creatures and aliens</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_villains\" title=\"List of Doctor Who villains\">Villains</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_henchmen\" title=\"List of Doctor Who henchmen\">Henchmen</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_robots\" title=\"List of Doctor Who robots\">Robots</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_planets\" title=\"List of Doctor Who planets\">Planets</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_items\" title=\"List of Doctor Who items\">Items</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_vehicles\" title=\"List of Doctor Who vehicles\">Vehicles</a></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Miscellaneous</div>\n</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Doctor_Who_exhibitions\" title=\"Doctor Who exhibitions\"><i>Doctor Who</i> exhibitions</a></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Spin-offs and<br />\nrelated shows</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"></div>\n<table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Spin-offs</div>\n</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/K-9_and_Company\" title=\"K-9 and Company\">K-9 and Company</a></i></li>\n<li><a href=\"/wiki/Tardisode\" title=\"Tardisode\">Tardisodes</a></li>\n<li><i><a href=\"/wiki/Torchwood\" title=\"Torchwood\">Torchwood</a></i></li>\n<li><i><a href=\"/wiki/The_Sarah_Jane_Adventures\" title=\"The Sarah Jane Adventures\">The Sarah Jane Adventures</a></i></li>\n<li><i><a href=\"/wiki/K-9_(TV_series)\" title=\"K-9 (TV series)\">K-9</a></i></li>\n<li><i><a href=\"/wiki/Class_(2016_TV_series)\" title=\"Class (2016 TV series)\">Class</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Documentaries</div>\n</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Whose_Doctor_Who\" title=\"Whose Doctor Who\">Whose Doctor Who</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_Thirty_Years_in_the_TARDIS\" title=\"Doctor Who: Thirty Years in the TARDIS\">Thirty Years in the TARDIS</a></i></li>\n<li><i><a href=\"/wiki/Dalekmania\" title=\"Dalekmania\">Dalekmania</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who_Confidential\" title=\"Doctor Who Confidential\">Doctor Who Confidential</a></i></li>\n<li><i><a href=\"/wiki/Totally_Doctor_Who\" title=\"Totally Doctor Who\">Totally Doctor Who</a></i></li>\n<li><i><a href=\"/wiki/Torchwood_Declassified\" title=\"Torchwood Declassified\">Torchwood Declassified</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_The_Commentaries\" title=\"Doctor Who: The Commentaries\">Doctor Who: The Commentaries</a></i></li>\n<li><i><a href=\"/wiki/The_Science_of_Doctor_Who\" title=\"The Science of Doctor Who\">The Science of Doctor Who</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who_Extra\" title=\"Doctor Who Extra\">Doctor Who Extra</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Concerts and<br />\nstage shows</div>\n</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Curse_of_the_Daleks\" title=\"The Curse of the Daleks\">The Curse of the Daleks</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who_and_the_Daleks_in_the_Seven_Keys_to_Doomsday\" title=\"Doctor Who and the Daleks in the Seven Keys to Doomsday\">Doctor Who and the Daleks in the Seven Keys to Doomsday</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who_%E2%80%93_The_Ultimate_Adventure\" title=\"Doctor Who – The Ultimate Adventure\">Doctor Who – The Ultimate Adventure</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_A_Celebration\" title=\"Doctor Who: A Celebration\">Doctor Who: A Celebration</a></i></li>\n<li><i>Doctor Who</i> Prom\n<ul>\n<li><a href=\"/wiki/Doctor_Who_Prom_(2008)\" title=\"Doctor Who Prom (2008)\">2008</a></li>\n<li><a href=\"/wiki/Doctor_Who_Prom_(2010)\" title=\"Doctor Who Prom (2010)\">2010</a></li>\n<li><a href=\"/wiki/Doctor_Who_Prom_(2013)\" title=\"Doctor Who Prom (2013)\">2013</a></li>\n</ul>\n</li>\n<li><i><a href=\"/wiki/Doctor_Who_Live\" title=\"Doctor Who Live\">Doctor Who Live</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Adaptations<br />\nand tie-ins</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"></div>\n<table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Films</div>\n</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Dr._Who_and_the_Daleks\" title=\"Dr. Who and the Daleks\">Dr. Who and the Daleks</a></i></li>\n<li><i><a href=\"/wiki/Daleks_%E2%80%93_Invasion_Earth:_2150_A.D.\" title=\"Daleks – Invasion Earth: 2150 A.D.\">Daleks – Invasion Earth: 2150 A.D.</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Books</div>\n</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/List_of_Doctor_Who_novelisations\" title=\"List of Doctor Who novelisations\">Novelisations</a></li>\n<li><a href=\"/wiki/Virgin_New_Adventures\" title=\"Virgin New Adventures\">New Adventures</a></li>\n<li><a href=\"/wiki/Virgin_Missing_Adventures\" title=\"Virgin Missing Adventures\">Missing Adventures</a></li>\n<li><a href=\"/wiki/Virgin_Decalog\" title=\"Virgin Decalog\">Virgin Decalog</a></li>\n<li><a href=\"/wiki/Eighth_Doctor_Adventures\" title=\"Eighth Doctor Adventures\">Eighth Doctor Adventures</a></li>\n<li><a href=\"/wiki/Past_Doctor_Adventures\" title=\"Past Doctor Adventures\">Past Doctor Adventures</a></li>\n<li><a href=\"/wiki/BBC_Short_Trips\" title=\"BBC Short Trips\">BBC Short Trips</a></li>\n<li><a href=\"/wiki/New_Series_Adventures\" title=\"New Series Adventures\">New Series Adventures</a></li>\n<li><a href=\"/wiki/Telos_Doctor_Who_novellas\" title=\"Telos Doctor Who novellas\">Telos novellas</a></li>\n<li><a href=\"/wiki/Big_Finish_Short_Trips\" title=\"Big Finish Short Trips\">Big Finish Short Trips</a></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Audio</div>\n</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/List_of_Doctor_Who_audio_plays_by_Big_Finish\" title=\"List of Doctor Who audio plays by Big Finish\">Big Finish audio plays</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_audiobooks\" title=\"List of Doctor Who audiobooks\">Audiobooks</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_audio_releases\" title=\"List of Doctor Who audio releases\">Audio releases</a></li>\n<li><i><a href=\"/wiki/Cyberman_(audio_drama_series)\" title=\"Cyberman (audio drama series)\">Cyberman</a></i></li>\n<li><i><a href=\"/wiki/Invasion_of_the_Daleks\" title=\"Invasion of the Daleks\">Dalek Empire</a></i></li>\n<li><i><a href=\"/wiki/Gallifrey_(audio_series)\" title=\"Gallifrey (audio series)\">Gallifrey</a></i></li>\n<li><i><a href=\"/wiki/I,_Davros:_Innocence\" title=\"I, Davros: Innocence\">I, Davros</a></i></li>\n<li><i><a href=\"/wiki/Jago_%26_Litefoot\" title=\"Jago &amp; Litefoot\">Jago &amp; Litefoot</a></i></li>\n<li><i><a href=\"/wiki/Kaldor_City\" title=\"Kaldor City\">Kaldor City</a></i></li>\n<li><i><a href=\"/wiki/Sarah_Jane_Smith:_Comeback\" title=\"Sarah Jane Smith: Comeback\">Sarah Jane Smith</a></i></li>\n<li><i><a href=\"/wiki/UNIT:_Time_Heals\" title=\"UNIT: Time Heals\">UNIT</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_The_Lost_Stories\" title=\"Doctor Who: The Lost Stories\">The Lost Stories</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_Destiny_of_the_Doctor\" title=\"Doctor Who: Destiny of the Doctor\">Destiny of the Doctor</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Video</div>\n</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Wartime_(film)\" title=\"Wartime (film)\">Wartime</a></i></li>\n<li><i><a href=\"/wiki/P.R.O.B.E.\" title=\"P.R.O.B.E.\">P.R.O.B.E.</a></i></li>\n<li><i><a href=\"/wiki/Shakedown:_Return_of_the_Sontarans\" title=\"Shakedown: Return of the Sontarans\">Shakedown: Return of the Sontarans</a></i></li>\n<li><i><a href=\"/wiki/Mindgame_(Doctor_Who)\" title=\"Mindgame (Doctor Who)\">Mindgame</a></i></li>\n<li><i><a href=\"/wiki/Downtime_(Doctor_Who)\" title=\"Downtime (Doctor Who)\">Downtime</a></i></li>\n<li><i><a href=\"/wiki/Auton_(film_series)\" title=\"Auton (film series)\">Auton</a></i></li>\n<li><i><a href=\"/wiki/D%C3%A6mos_Rising\" title=\"Dæmos Rising\">Dæmos Rising</a></i></li>\n<li><i><a href=\"/wiki/Zygon:_When_Being_You_Just_Isn%27t_Enough\" title=\"Zygon: When Being You Just Isn't Enough\">Zygon: When Being You Just Isn't Enough</a></i></li>\n<li><i><a href=\"/wiki/Dead_and_Buried_(Bernice_Summerfield)\" title=\"Dead and Buried (Bernice Summerfield)\">Dead and Buried</a></i></li>\n<li><i><a href=\"/wiki/An_Adventure_in_Space_and_Time\" title=\"An Adventure in Space and Time\">An Adventure in Space and Time</a></i></li>\n<li><i><a href=\"/wiki/The_Five(ish)_Doctors_Reboot\" title=\"The Five(ish) Doctors Reboot\">The Five(ish) Doctors Reboot</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Video games</div>\n</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Doctor_Who:_The_First_Adventure\" title=\"Doctor Who: The First Adventure\">Doctor Who: The First Adventure</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who_and_the_Warlord\" title=\"Doctor Who and the Warlord\">The Warlord</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who_and_the_Mines_of_Terror\" title=\"Doctor Who and the Mines of Terror\">The Mines of Terror</a></i></li>\n<li><i><a href=\"/wiki/Dalek_Attack\" title=\"Dalek Attack\">Dalek Attack</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_Destiny_of_the_Doctors\" title=\"Doctor Who: Destiny of the Doctors\">Destiny of the Doctors</a></i></li>\n<li><i><a href=\"/wiki/Top_Trumps:_Doctor_Who\" title=\"Top Trumps: Doctor Who\">Top Trumps</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_The_Adventure_Games\" title=\"Doctor Who: The Adventure Games\">The Adventure Games</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_Return_to_Earth\" title=\"Doctor Who: Return to Earth\">Return to Earth</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_Evacuation_Earth\" title=\"Doctor Who: Evacuation Earth\">Evacuation Earth</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_The_Mazes_of_Time\" title=\"Doctor Who: The Mazes of Time\">The Mazes of Time</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_Worlds_in_Time\" title=\"Doctor Who: Worlds in Time\">Worlds in Time</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_The_Eternity_Clock\" title=\"Doctor Who: The Eternity Clock\">The Eternity Clock</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_Legacy_(video_game)\" title=\"Doctor Who: Legacy (video game)\">Doctor Who: Legacy</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Miscellaneous</div>\n</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Doctor_Who_spin-offs\" title=\"Doctor Who spin-offs\"><i>Doctor Who</i> spin-offs</a>\n<ul>\n<li><i><a href=\"/wiki/Dimensions_in_Time\" title=\"Dimensions in Time\">Dimensions in Time</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who:_The_Curse_of_Fatal_Death\" title=\"Doctor Who: The Curse of Fatal Death\">The Curse of Fatal Death</a></i></li>\n<li><i><a href=\"/wiki/Scream_of_the_Shalka\" title=\"Scream of the Shalka\">Scream of the Shalka</a></i></li>\n</ul>\n</li>\n<li><a href=\"/wiki/Doctor_Who_(pinball)\" title=\"Doctor Who (pinball)\">Pinball</a></li>\n<li><a href=\"/wiki/Doctor_Who:_The_Card_Game\" title=\"Doctor Who: The Card Game\">Card game</a></li>\n<li><a href=\"/wiki/List_of_Doctor_Who_parodies\" title=\"List of Doctor Who parodies\">Spoofs</a></li>\n<li><a href=\"/wiki/List_of_companions_in_Doctor_Who_spin-offs\" title=\"List of companions in Doctor Who spin-offs\">Spin-off companions</a></li>\n<li><a href=\"/wiki/Faction_Paradox\" title=\"Faction Paradox\">Faction Paradox</a></li>\n<li><a href=\"/wiki/Iris_Wildthyme\" title=\"Iris Wildthyme\">Iris Wildthyme</a></li>\n<li><a href=\"/wiki/Death%27s_Head\" title=\"Death's Head\">Death's Head</a></li>\n<li><a href=\"/wiki/Dalek_comic_strips,_illustrated_annuals_and_graphic_novels\" title=\"Dalek comic strips, illustrated annuals and graphic novels\">Dalek comic strips, illustrated annuals and graphic novels</a></li>\n<li><i><a href=\"/wiki/Star_Trek:_The_Next_Generation/Doctor_Who:_Assimilation2\" title=\"Star Trek: The Next Generation/Doctor Who: Assimilation2\">Star Trek: The Next Generation/Doctor Who: Assimilation2</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Related<br />\npublications</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"></div>\n<table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Magazines</div>\n</th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Doctor_Who_Magazine\" title=\"Doctor Who Magazine\">Doctor Who Magazine</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who_Adventures\" title=\"Doctor Who Adventures\">Doctor Who Adventures</a></i></li>\n<li><i><a href=\"/wiki/Doctor_Who_%E2%80%93_Battles_in_Time\" title=\"Doctor Who – Battles in Time\">Doctor Who – Battles in Time</a></i></li>\n<li><i><a href=\"/wiki/The_Black_Archive\" title=\"The Black Archive\">The Black Archive</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"width:10em;padding-left:0;padding-right:0;\">\n<div style=\"padding:0em 0.75em;\">Publishers</div>\n</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Big_Finish_Productions\" title=\"Big Finish Productions\">Big Finish Productions</a></li>\n<li><a href=\"/wiki/Reeltime_Pictures\" title=\"Reeltime Pictures\">Reeltime Pictures</a></li>\n<li><a href=\"/wiki/Bill_%26_Ben_Video\" title=\"Bill &amp; Ben Video\">BBV</a></li>\n<li><a href=\"/wiki/Mad_Norwegian_Press\" title=\"Mad Norwegian Press\">Mad Norwegian Press</a></li>\n<li><a href=\"/wiki/Magic_Bullet_Productions\" title=\"Magic Bullet Productions\">Magic Bullet Productions</a></li>\n<li><a href=\"/wiki/Obverse_Books\" title=\"Obverse Books\">Obverse Books</a></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<td class=\"navbox-abovebelow\" colspan=\"2\">\n<div>\n<ul>\n<li><img alt=\"Portal\" src=\"//upload.wikimedia.org/wikipedia/en/thumb/f/fd/Portal-puzzle.svg/16px-Portal-puzzle.svg.png\" title=\"Portal\" width=\"16\" height=\"14\" srcset=\"//upload.wikimedia.org/wikipedia/en/thumb/f/fd/Portal-puzzle.svg/24px-Portal-puzzle.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/f/fd/Portal-puzzle.svg/32px-Portal-puzzle.svg.png 2x\" data-file-width=\"32\" data-file-height=\"28\" /> <a href=\"/wiki/Portal:Doctor_Who\" title=\"Portal:Doctor Who\">Portal</a></li>\n<li><img alt=\"Category\" src=\"//upload.wikimedia.org/wikipedia/en/thumb/4/48/Folder_Hexagonal_Icon.svg/16px-Folder_Hexagonal_Icon.svg.png\" title=\"Category\" width=\"16\" height=\"14\" srcset=\"//upload.wikimedia.org/wikipedia/en/thumb/4/48/Folder_Hexagonal_Icon.svg/24px-Folder_Hexagonal_Icon.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/4/48/Folder_Hexagonal_Icon.svg/32px-Folder_Hexagonal_Icon.svg.png 2x\" data-file-width=\"36\" data-file-height=\"31\" /> <a href=\"/wiki/Category:Doctor_Who\" title=\"Category:Doctor Who\">Category</a></li>\n<li><img alt=\"Wikipedia book\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/8/89/Symbol_book_class2.svg/16px-Symbol_book_class2.svg.png\" title=\"Wikipedia book\" width=\"16\" height=\"16\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/8/89/Symbol_book_class2.svg/23px-Symbol_book_class2.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/8/89/Symbol_book_class2.svg/31px-Symbol_book_class2.svg.png 2x\" data-file-width=\"180\" data-file-height=\"185\" /> <a href=\"/wiki/Book:Doctor_Who\" title=\"Book:Doctor Who\">Book</a></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</div>\n<div role=\"navigation\" class=\"navbox\" aria-labelledby=\"Infocom\" style=\"padding:3px\">\n<table class=\"nowraplinks collapsible autocollapse navbox-inner\" style=\"border-spacing:0;background:transparent;color:inherit\">\n<tr>\n<th scope=\"col\" class=\"navbox-title\" colspan=\"2\">\n<div class=\"plainlinks hlist navbar mini\">\n<ul>\n<li class=\"nv-view\"><a href=\"/wiki/Template:Infocom_games\" title=\"Template:Infocom games\"><abbr title=\"View this template\" style=\";;background:none transparent;border:none;\">v</abbr></a></li>\n<li class=\"nv-talk\"><a href=\"/wiki/Template_talk:Infocom_games\" title=\"Template talk:Infocom games\"><abbr title=\"Discuss this template\" style=\";;background:none transparent;border:none;\">t</abbr></a></li>\n<li class=\"nv-edit\"><a class=\"external text\" href=\"//en.wikipedia.org/w/index.php?title=Template:Infocom_games&amp;action=edit\"><abbr title=\"Edit this template\" style=\";;background:none transparent;border:none;\">e</abbr></a></li>\n</ul>\n</div>\n<div id=\"Infocom\" style=\"font-size:114%\"><a href=\"/wiki/Infocom\" title=\"Infocom\">Infocom</a></div>\n</th>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\"><i>Zork</i> series</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Zork\" title=\"Zork\">Zork</a></i></li>\n<li><i><a href=\"/wiki/Beyond_Zork\" title=\"Beyond Zork\">Beyond Zork</a></i></li>\n<li><i><a href=\"/wiki/Zork_Zero\" title=\"Zork Zero\">Zork Zero</a></i></li>\n<li><i><a href=\"/wiki/Return_to_Zork\" title=\"Return to Zork\">Return to Zork</a></i></li>\n<li><i><a href=\"/wiki/Zork_Nemesis\" title=\"Zork Nemesis\">Zork Nemesis</a></i></li>\n<li><i><a href=\"/wiki/Zork:_Grand_Inquisitor\" title=\"Zork: Grand Inquisitor\">Zork: Grand Inquisitor</a></i></li>\n<li><i><a href=\"/wiki/Zork:_The_Undiscovered_Underground\" title=\"Zork: The Undiscovered Underground\">Zork: The Undiscovered Underground</a></i></li>\n<li><i><a href=\"/wiki/Legends_of_Zork\" title=\"Legends of Zork\">Legends of Zork</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Text adventures</th>\n<td class=\"navbox-list navbox-even hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Arthur:_The_Quest_for_Excalibur\" title=\"Arthur: The Quest for Excalibur\">Arthur: The Quest for Excalibur</a></i></li>\n<li><i><a href=\"/wiki/Ballyhoo_(video_game)\" title=\"Ballyhoo (video game)\">Ballyhoo</a></i></li>\n<li><i><a href=\"/wiki/Border_Zone_(video_game)\" title=\"Border Zone (video game)\">Border Zone</a></i></li>\n<li><i><a href=\"/wiki/Bureaucracy_(video_game)\" title=\"Bureaucracy (video game)\">Bureaucracy</a></i></li>\n<li><i><a href=\"/wiki/Cutthroats\" title=\"Cutthroats\">Cutthroats</a></i></li>\n<li><i><a href=\"/wiki/Deadline_(video_game)\" title=\"Deadline (video game)\">Deadline</a></i></li>\n<li><i><a href=\"/wiki/Enchanter_(video_game)\" title=\"Enchanter (video game)\">Enchanter</a></i></li>\n<li><i><a href=\"/wiki/The_Hitchhiker%27s_Guide_to_the_Galaxy_(video_game)\" title=\"The Hitchhiker's Guide to the Galaxy (video game)\">The Hitchhiker's Guide to the Galaxy</a></i></li>\n<li><i><a href=\"/wiki/Hollywood_Hijinx\" title=\"Hollywood Hijinx\">Hollywood Hijinx</a></i></li>\n<li><i><a href=\"/wiki/Infidel_(video_game)\" title=\"Infidel (video game)\">Infidel</a></i></li>\n<li><i><a href=\"/wiki/Journey_(1989_video_game)\" title=\"Journey (1989 video game)\">Journey</a></i></li>\n<li><i><a href=\"/wiki/Leather_Goddesses_of_Phobos\" title=\"Leather Goddesses of Phobos\">Leather Goddesses of Phobos</a></i></li>\n<li><i><a href=\"/wiki/The_Lurking_Horror\" title=\"The Lurking Horror\">The Lurking Horror</a></i></li>\n<li><i><a href=\"/wiki/A_Mind_Forever_Voyaging\" title=\"A Mind Forever Voyaging\">A Mind Forever Voyaging</a></i></li>\n<li><i><a href=\"/wiki/Moonmist\" title=\"Moonmist\">Moonmist</a></i></li>\n<li><i><a href=\"/wiki/Nord_and_Bert_Couldn%27t_Make_Head_or_Tail_of_It\" title=\"Nord and Bert Couldn't Make Head or Tail of It\">Nord and Bert Couldn't Make Head or Tail of It</a></i></li>\n<li><i><a href=\"/wiki/Planetfall\" title=\"Planetfall\">Planetfall</a></i></li>\n<li><i><a href=\"/wiki/Plundered_Hearts\" title=\"Plundered Hearts\">Plundered Hearts</a></i></li>\n<li><i><a href=\"/wiki/Seastalker\" title=\"Seastalker\">Seastalker</a></i></li>\n<li><i><a href=\"/wiki/Sherlock:_The_Riddle_of_the_Crown_Jewels\" title=\"Sherlock: The Riddle of the Crown Jewels\">Sherlock: The Riddle of the Crown Jewels</a></i></li>\n<li><i><a href=\"/wiki/James_Clavell%27s_Sh%C5%8Dgun\" title=\"James Clavell's Shōgun\">James Clavell's Shōgun</a></i></li>\n<li><i><a href=\"/wiki/Sorcerer_(video_game)\" title=\"Sorcerer (video game)\">Sorcerer</a></i></li>\n<li><i><a href=\"/wiki/Spellbreaker\" title=\"Spellbreaker\">Spellbreaker</a></i></li>\n<li><i><a href=\"/wiki/Starcross_(video_game)\" title=\"Starcross (video game)\">Starcross</a></i></li>\n<li><i><a href=\"/wiki/Stationfall\" title=\"Stationfall\">Stationfall</a></i></li>\n<li><i><a href=\"/wiki/Suspect_(video_game)\" title=\"Suspect (video game)\">Suspect</a></i></li>\n<li><i><a href=\"/wiki/Suspended\" title=\"Suspended\">Suspended</a></i></li>\n<li><i><a href=\"/wiki/Trinity_(video_game)\" title=\"Trinity (video game)\">Trinity</a></i></li>\n<li><i><a href=\"/wiki/Wishbringer\" title=\"Wishbringer\">Wishbringer</a></i></li>\n<li><i><a href=\"/wiki/The_Witness_(1983_video_game)\" title=\"The Witness (1983 video game)\">The Witness</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Other titles</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/BattleTech:_The_Crescent_Hawk%27s_Inception\" title=\"BattleTech: The Crescent Hawk's Inception\">BattleTech: The Crescent Hawk's Inception</a></i></li>\n<li><i><a href=\"/wiki/BattleTech:_The_Crescent_Hawk%27s_Revenge\" title=\"BattleTech: The Crescent Hawk's Revenge\">BattleTech: The Crescent Hawk's Revenge</a></i></li>\n<li><i><a href=\"/wiki/Circuit%27s_Edge\" title=\"Circuit's Edge\">Circuit's Edge</a></i></li>\n<li><i><a href=\"/wiki/Cornerstone_(software)\" title=\"Cornerstone (software)\">Cornerstone</a></i></li>\n<li><i><a href=\"/wiki/Fooblitzky\" title=\"Fooblitzky\">Fooblitzky</a></i></li>\n<li><i><a href=\"/wiki/Leather_Goddesses_of_Phobos_2:_Gas_Pump_Girls_Meet_the_Pulsating_Inconvenience_from_Planet_X!\" title=\"Leather Goddesses of Phobos 2: Gas Pump Girls Meet the Pulsating Inconvenience from Planet X!\">Leather Goddesses of Phobos 2</a></i></li>\n<li><i><a href=\"/wiki/Mines_of_Titan\" title=\"Mines of Titan\">Mines of Titan</a></i></li>\n<li><i><a href=\"/wiki/Quarterstaff:_The_Tomb_of_Setmoth\" title=\"Quarterstaff: The Tomb of Setmoth\">Quarterstaff: The Tomb of Setmoth</a></i></li>\n<li><i><a href=\"/wiki/Tombs_%26_Treasure\" title=\"Tombs &amp; Treasure\">Tombs &amp; Treasure</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\"><a href=\"/wiki/Implementer_(video_games)\" title=\"Implementer (video games)\">Implementers</a></th>\n<td class=\"navbox-list navbox-even hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Tim_Anderson_(Zork)\" title=\"Tim Anderson (Zork)\">Tim Anderson</a></li>\n<li><a href=\"/wiki/Bob_Bates\" title=\"Bob Bates\">Bob Bates</a></li>\n<li><a href=\"/wiki/Michael_Berlyn\" title=\"Michael Berlyn\">Michael Berlyn</a></li>\n<li><a href=\"/wiki/Marc_Blank\" title=\"Marc Blank\">Marc Blank</a></li>\n<li><a href=\"/wiki/Amy_Briggs\" title=\"Amy Briggs\">Amy Briggs</a></li>\n<li>Stu Galley</li>\n<li><a href=\"/wiki/Dave_Lebling\" title=\"Dave Lebling\">Dave Lebling</a></li>\n<li><a href=\"/wiki/Steve_Meretzky\" title=\"Steve Meretzky\">Steve Meretzky</a></li>\n<li><a href=\"/wiki/Brian_Moriarty\" title=\"Brian Moriarty\">Brian Moriarty</a></li>\n<li>Jeff O'Neill</li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Other people</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><strong class=\"selflink\">Douglas Adams</strong></li>\n<li><a href=\"/wiki/Bruce_Daniels\" title=\"Bruce Daniels\">Bruce Daniels</a></li>\n<li><a href=\"/wiki/Albert_Vezza\" title=\"Albert Vezza\">Albert Vezza</a></li>\n<li><a href=\"/wiki/Joe_Ybarra\" title=\"Joe Ybarra\">Joe Ybarra</a></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Companies</th>\n<td class=\"navbox-list navbox-even hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Infocom\" title=\"Infocom\">Infocom</a></li>\n<li><a href=\"/wiki/Activision\" title=\"Activision\">Activision</a></li>\n<li><a href=\"/wiki/Legend_Entertainment\" title=\"Legend Entertainment\">Legend Entertainment</a></li>\n<li><a href=\"/wiki/Westwood_Studios\" title=\"Westwood Studios\">Westwood Studios</a></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\">Miscellaneous</th>\n<td class=\"navbox-list navbox-odd hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/69105_(number)\" title=\"69105 (number)\">69,105</a></li>\n<li><i><a href=\"/wiki/Classic_Text_Adventure_Masterpieces_of_Infocom\" title=\"Classic Text Adventure Masterpieces of Infocom\">Classic Text Adventure Masterpieces of Infocom</a></i></li>\n<li><a href=\"/wiki/Feelie\" class=\"mw-redirect\" title=\"Feelie\">Feelie</a></li>\n<li><i><a href=\"/wiki/Get_Lamp\" title=\"Get Lamp\">Get Lamp</a></i></li>\n<li><a href=\"/wiki/Grue_(monster)\" title=\"Grue (monster)\">Grue</a></li>\n<li><a href=\"/wiki/Hello,_sailor\" title=\"Hello, sailor\">Hello, sailor</a></li>\n<li><a href=\"/wiki/InfoTaskForce\" title=\"InfoTaskForce\">InfoTaskForce</a></li>\n<li><a href=\"/wiki/InvisiClues\" title=\"InvisiClues\">InvisiClues</a></li>\n<li><i><a href=\"/wiki/The_Lost_Treasures_of_Infocom\" title=\"The Lost Treasures of Infocom\">The Lost Treasures of Infocom</a></i></li>\n<li><a href=\"/wiki/Z-machine\" title=\"Z-machine\">Z-machine</a></li>\n<li><a href=\"/wiki/Zork_books\" title=\"Zork books\">Zork books</a></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</div>\n<div role=\"navigation\" class=\"navbox\" aria-labelledby=\"Animal_rights\" style=\"padding:3px\">\n<table class=\"nowraplinks collapsible collapsed navbox-inner\" style=\"border-spacing:0;background:transparent;color:inherit\">\n<tr>\n<th scope=\"col\" class=\"navbox-title\" colspan=\"2\" style=\"text-align: center;\">\n<div class=\"plainlinks hlist navbar mini\">\n<ul>\n<li class=\"nv-view\"><a href=\"/wiki/Template:Animal_rights\" title=\"Template:Animal rights\"><abbr title=\"View this template\" style=\"text-align: center;;;background:none transparent;border:none;\">v</abbr></a></li>\n<li class=\"nv-talk\"><a href=\"/wiki/Template_talk:Animal_rights\" title=\"Template talk:Animal rights\"><abbr title=\"Discuss this template\" style=\"text-align: center;;;background:none transparent;border:none;\">t</abbr></a></li>\n<li class=\"nv-edit\"><a class=\"external text\" href=\"//en.wikipedia.org/w/index.php?title=Template:Animal_rights&amp;action=edit\"><abbr title=\"Edit this template\" style=\"text-align: center;;;background:none transparent;border:none;\">e</abbr></a></li>\n</ul>\n</div>\n<div id=\"Animal_rights\" style=\"font-size:114%\"><a href=\"/wiki/Animal_rights\" title=\"Animal rights\">Animal rights</a></div>\n</th>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"text-align: center;\">Topics</th>\n<td class=\"navbox-list navbox-off hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"></div>\n<table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"text-align: center;\"><a href=\"/wiki/Category:Animal_rights\" title=\"Category:Animal rights\">Overview</a></th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Abolitionism_(animal_rights)\" title=\"Abolitionism (animal rights)\">Abolitionism</a></li>\n<li><a href=\"/wiki/Animal_protectionism\" title=\"Animal protectionism\">Animal protectionism</a></li>\n<li><a href=\"/wiki/Animal_welfare\" title=\"Animal welfare\">Animal welfare</a></li>\n<li><a href=\"/wiki/Speciesism\" title=\"Speciesism\">Speciesism</a></li>\n<li><a href=\"/wiki/Veganism\" title=\"Veganism\">Veganism</a></li>\n<li><b><a href=\"/wiki/Category:Animal_rights\" title=\"Category:Animal rights\">more...</a></b></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"text-align: center;\"><a href=\"/wiki/Category:Animal_rights\" title=\"Category:Animal rights\">Issues</a></th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Ahimsa\" title=\"Ahimsa\">Ahimsa</a></li>\n<li><a href=\"/wiki/Animal_cognition\" title=\"Animal cognition\">Animal cognition</a></li>\n<li><a href=\"/wiki/Animal_consciousness\" title=\"Animal consciousness\">Animal consciousness</a></li>\n<li><a href=\"/wiki/Animal_law\" title=\"Animal law\">Animal law</a></li>\n<li><a href=\"/wiki/Animal_model\" class=\"mw-redirect\" title=\"Animal model\">Animal model</a></li>\n<li><a href=\"/wiki/Animal_rights_and_the_Holocaust\" title=\"Animal rights and the Holocaust\">Animal rights and the Holocaust</a></li>\n<li><a href=\"/wiki/Animal_product\" title=\"Animal product\">Animal product</a></li>\n<li><a href=\"/wiki/Animal_rights_movement\" title=\"Animal rights movement\">Animal rights movement</a></li>\n<li><a href=\"/wiki/Animal_testing\" title=\"Animal testing\">Animal testing</a></li>\n<li><a href=\"/wiki/Animal_testing_on_non-human_primates\" title=\"Animal testing on non-human primates\">Animal testing on non-human primates</a></li>\n<li><a href=\"/wiki/Animals_in_sport\" title=\"Animals in sport\">Animals in sport</a></li>\n<li><a href=\"/wiki/Anthrozoology\" title=\"Anthrozoology\">Anthrozoology</a></li>\n<li><a href=\"/wiki/Anti-hunting\" class=\"mw-redirect\" title=\"Anti-hunting\">Anti-hunting</a></li>\n<li><a href=\"/wiki/Bile_bear\" title=\"Bile bear\">Bile bear</a></li>\n<li><a href=\"/wiki/Bioethics\" title=\"Bioethics\">Bioethics</a></li>\n<li><a href=\"/wiki/Blood_sport\" title=\"Blood sport\">Blood sport</a></li>\n<li><a href=\"/wiki/Cambridge_Declaration_on_Consciousness\" class=\"mw-redirect\" title=\"Cambridge Declaration on Consciousness\">Cambridge Declaration on Consciousness</a></li>\n<li><a href=\"/wiki/Carnism\" title=\"Carnism\">Carnism</a></li>\n<li><a href=\"/wiki/Testing_cosmetics_on_animals\" title=\"Testing cosmetics on animals\">Cosmetics testing</a></li>\n<li><a href=\"/wiki/Chick_culling\" title=\"Chick culling\">Chick culling</a></li>\n<li><a href=\"/wiki/Christianity_and_animal_rights\" title=\"Christianity and animal rights\">Christianity and animal rights</a></li>\n<li><a href=\"/wiki/Concentrated_Animal_Feeding_Operation\" class=\"mw-redirect\" title=\"Concentrated Animal Feeding Operation\">Concentrated Animal Feeding Operation</a></li>\n<li><a href=\"/wiki/Cormorant_culling\" title=\"Cormorant culling\">Cormorant culling</a></li>\n<li><a href=\"/wiki/Covance\" title=\"Covance\">Covance</a></li>\n<li><a href=\"/wiki/Cruelty_to_animals\" title=\"Cruelty to animals\">Cruelty to animals</a></li>\n<li><a href=\"/wiki/Deep_ecology\" title=\"Deep ecology\">Deep ecology</a></li>\n<li><a href=\"/wiki/Ethics_of_eating_meat\" title=\"Ethics of eating meat\">Ethics of eating meat</a></li>\n<li><a href=\"/wiki/Fox_hunting\" title=\"Fox hunting\">Fox hunting</a></li>\n<li><a href=\"/wiki/Fur_trade\" title=\"Fur trade\">Fur trade</a></li>\n<li><a href=\"/wiki/Great_ape_research_ban\" title=\"Great ape research ban\">Great ape research ban</a></li>\n<li><a href=\"/wiki/Green_Scare\" title=\"Green Scare\">Green Scare</a></li>\n<li><a href=\"/wiki/Huntingdon_Life_Sciences\" title=\"Huntingdon Life Sciences\">Huntingdon Life Sciences</a></li>\n<li><a href=\"/wiki/Intensive_animal_farming\" title=\"Intensive animal farming\">Intensive animal farming</a></li>\n<li><a href=\"/wiki/Ivory_trade\" title=\"Ivory trade\">Ivory trade</a></li>\n<li><a href=\"/wiki/Livestock\" title=\"Livestock\">Livestock</a></li>\n<li><a href=\"/wiki/Meat_paradox\" class=\"mw-redirect\" title=\"Meat paradox\">Meat paradox</a></li>\n<li><a href=\"/wiki/Nafovanny\" title=\"Nafovanny\">Nafovanny</a></li>\n<li><a href=\"/wiki/Nonviolence\" title=\"Nonviolence\">Nonviolence</a></li>\n<li><a href=\"/wiki/Open_rescue\" title=\"Open rescue\">Open rescue</a></li>\n<li><a href=\"/wiki/Operation_Backfire_(FBI)\" title=\"Operation Backfire (FBI)\">Operation Backfire</a></li>\n<li><a href=\"/wiki/Pain_in_animals\" title=\"Pain in animals\">Pain in animals</a></li>\n<li><a href=\"/wiki/Pain_and_suffering_in_laboratory_animals\" class=\"mw-redirect\" title=\"Pain and suffering in laboratory animals\">Pain and suffering in laboratory animals</a></li>\n<li><a href=\"/wiki/International_primate_trade\" title=\"International primate trade\">Primate trade</a></li>\n<li><a href=\"/wiki/Seal_hunting\" title=\"Seal hunting\">Seal hunting</a></li>\n<li><a href=\"/wiki/Slaughterhouse\" title=\"Slaughterhouse\">Slaughterhouse</a></li>\n<li><a href=\"/wiki/Stock-free_agriculture\" class=\"mw-redirect\" title=\"Stock-free agriculture\">Stock-free agriculture</a></li>\n<li><a href=\"/wiki/Toxicology_testing\" title=\"Toxicology testing\">Toxicology testing</a></li>\n<li><a href=\"/wiki/Veganarchism\" title=\"Veganarchism\">Veganarchism</a></li>\n<li><a href=\"/wiki/Veganism\" title=\"Veganism\">Veganism</a></li>\n<li><a href=\"/wiki/Vegetarianism\" title=\"Vegetarianism\">Vegetarianism</a></li>\n<li><a href=\"/wiki/Western_Australian_shark_cull\" title=\"Western Australian shark cull\">Western Australian shark cull</a></li>\n<li><b><a href=\"/wiki/Category:Animal_rights\" title=\"Category:Animal rights\">more...</a></b></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"text-align: center;\">Cases</th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px;background:\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Brown_Dog_affair\" title=\"Brown Dog affair\">Brown Dog affair</a></li>\n<li><a href=\"/wiki/Cambridge_University_primates\" title=\"Cambridge University primates\">Cambridge University primates</a></li>\n<li><a href=\"/wiki/McDonald%27s_Restaurants_v._Morris_%26_Steel\" class=\"mw-redirect\" title=\"McDonald's Restaurants v. Morris &amp; Steel\">McLibel case</a></li>\n<li><a href=\"/wiki/Pit_of_despair\" title=\"Pit of despair\">Pit of despair</a></li>\n<li><a href=\"/wiki/Silver_Spring_monkeys\" title=\"Silver Spring monkeys\">Silver Spring monkeys</a></li>\n<li><a href=\"/wiki/University_of_California_Riverside_1985_laboratory_raid\" class=\"mw-redirect\" title=\"University of California Riverside 1985 laboratory raid\">University of California Riverside 1985 laboratory raid</a></li>\n<li><i><a href=\"/wiki/Unnecessary_Fuss\" title=\"Unnecessary Fuss\">Unnecessary Fuss</a></i></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"text-align: center;\"><a href=\"/wiki/List_of_animal_rights_advocates\" title=\"List of animal rights advocates\">Advocates</a></th>\n<td class=\"navbox-list navbox-off hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"></div>\n<table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\"><a href=\"/wiki/Category:Animal_rights_advocates\" title=\"Category:Animal rights advocates\">Academics<br />\nand writers</a></th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Carol_J._Adams\" title=\"Carol J. Adams\">Carol Adams</a></li>\n<li><a href=\"/wiki/Tom_Beauchamp\" title=\"Tom Beauchamp\">Tom Beauchamp</a></li>\n<li><a href=\"/wiki/Marc_Bekoff\" title=\"Marc Bekoff\">Marc Bekoff</a></li>\n<li><a href=\"/wiki/Paola_Cavalieri\" title=\"Paola Cavalieri\">Paola Cavalieri</a></li>\n<li><a href=\"/wiki/Stephen_R._L._Clark\" title=\"Stephen R. L. Clark\">Stephen R. L. Clark</a></li>\n<li><a href=\"/wiki/Alasdair_Cochrane\" title=\"Alasdair Cochrane\">Alasdair Cochrane</a></li>\n<li><a href=\"/wiki/J._M._Coetzee\" title=\"J. M. Coetzee\">J. M. Coetzee</a></li>\n<li><a href=\"/wiki/Priscilla_Cohn\" title=\"Priscilla Cohn\">Priscilla Cohn</a></li>\n<li><a href=\"/wiki/David_DeGrazia\" title=\"David DeGrazia\">David DeGrazia</a></li>\n<li><a href=\"/wiki/Sue_Donaldson\" title=\"Sue Donaldson\">Sue Donaldson</a></li>\n<li><a href=\"/wiki/Josephine_Donovan\" title=\"Josephine Donovan\">Josephine Donovan</a></li>\n<li><a href=\"/wiki/Lawrence_Finsen\" title=\"Lawrence Finsen\">Lawrence Finsen</a></li>\n<li><a href=\"/wiki/Gary_Francione\" class=\"mw-redirect\" title=\"Gary Francione\">Gary Francione</a></li>\n<li><a href=\"/wiki/Robert_Garner\" title=\"Robert Garner\">Robert Garner</a></li>\n<li><a href=\"/wiki/Antoine_Goetschel\" title=\"Antoine Goetschel\">Antoine Goetschel</a></li>\n<li><a href=\"/wiki/John_Hadley_(philosopher)\" title=\"John Hadley (philosopher)\">John Hadley</a></li>\n<li><a href=\"/wiki/Will_Kymlicka\" title=\"Will Kymlicka\">Will Kymlicka</a></li>\n<li><a href=\"/wiki/Andrew_Linzey\" title=\"Andrew Linzey\">Andrew Linzey</a></li>\n<li><a href=\"/wiki/Dan_Lyons\" title=\"Dan Lyons\">Dan Lyons</a></li>\n<li><a href=\"/wiki/Mary_Midgley\" title=\"Mary Midgley\">Mary Midgley</a></li>\n<li><a href=\"/wiki/Martha_Nussbaum\" title=\"Martha Nussbaum\">Martha Nussbaum</a></li>\n<li><a href=\"/wiki/Siobhan_O%27Sullivan\" title=\"Siobhan O'Sullivan\">Siobhan O'Sullivan</a></li>\n<li><a href=\"/wiki/Clare_Palmer\" title=\"Clare Palmer\">Clare Palmer</a></li>\n<li><a href=\"/wiki/Tom_Regan\" title=\"Tom Regan\">Tom Regan</a></li>\n<li><a href=\"/wiki/Bernard_Rollin\" title=\"Bernard Rollin\">Bernard Rollin</a></li>\n<li><a href=\"/wiki/Mark_Rowlands\" title=\"Mark Rowlands\">Mark Rowlands</a></li>\n<li><a href=\"/wiki/Richard_D._Ryder\" title=\"Richard D. Ryder\">Richard D. Ryder</a></li>\n<li><a href=\"/wiki/Peter_Singer\" title=\"Peter Singer\">Peter Singer</a></li>\n<li><a href=\"/wiki/Henry_Stephens_Salt\" title=\"Henry Stephens Salt\">Henry Stephens Salt</a></li>\n<li><a href=\"/wiki/Steve_Sapontzis\" title=\"Steve Sapontzis\">Steve Sapontzis</a></li>\n<li><a href=\"/wiki/Gary_Steiner\" title=\"Gary Steiner\">Gary Steiner</a></li>\n<li><a href=\"/wiki/Cass_Sunstein\" title=\"Cass Sunstein\">Cass Sunstein</a></li>\n<li><b><a href=\"/wiki/List_of_animal_rights_advocates\" title=\"List of animal rights advocates\">more...</a></b></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\"><a href=\"/wiki/Category:Animal_rights_advocates\" title=\"Category:Animal rights advocates\">Activists</a></th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Cleveland_Amory\" title=\"Cleveland Amory\">Cleveland Amory</a></li>\n<li><a href=\"/wiki/Pamela_Anderson\" title=\"Pamela Anderson\">Pamela Anderson</a></li>\n<li><a href=\"/wiki/Greg_Avery\" title=\"Greg Avery\">Greg Avery</a></li>\n<li><a href=\"/wiki/Alec_Baldwin\" title=\"Alec Baldwin\">Alec Baldwin</a></li>\n<li><a href=\"/wiki/Matt_Ball\" title=\"Matt Ball\">Matt Ball</a></li>\n<li><a href=\"/wiki/Martin_Balluch\" title=\"Martin Balluch\">Martin Balluch</a></li>\n<li><a href=\"/wiki/Barbi_twins\" class=\"mw-redirect\" title=\"Barbi twins\">Barbi twins</a></li>\n<li><a href=\"/wiki/Brigitte_Bardot\" title=\"Brigitte Bardot\">Brigitte Bardot</a></li>\n<li><a href=\"/wiki/Bob_Barker\" title=\"Bob Barker\">Bob Barker</a></li>\n<li><a href=\"/wiki/Gene_Baur\" title=\"Gene Baur\">Gene Baur</a></li>\n<li><a href=\"/wiki/Frances_Power_Cobbe\" title=\"Frances Power Cobbe\">Frances Power Cobbe</a></li>\n<li><a href=\"/wiki/Rod_Coronado\" title=\"Rod Coronado\">Rod Coronado</a></li>\n<li><a href=\"/wiki/Evandro_Costa\" title=\"Evandro Costa\">Evandro Costa</a></li>\n<li><a href=\"/wiki/Karen_Davis_(activist)\" title=\"Karen Davis (activist)\">Karen Davis</a></li>\n<li><a href=\"/wiki/Chris_DeRose\" title=\"Chris DeRose\">Chris DeRose</a></li>\n<li><a href=\"/wiki/Robert_Enke\" title=\"Robert Enke\">Robert Enke</a></li>\n<li><a href=\"/wiki/John_Feldmann\" title=\"John Feldmann\">John Feldmann</a></li>\n<li><a href=\"/wiki/Bruce_Friedrich\" title=\"Bruce Friedrich\">Bruce Friedrich</a></li>\n<li><a href=\"/wiki/Juliet_Gellatley\" title=\"Juliet Gellatley\">Juliet Gellatley</a></li>\n<li><a href=\"/wiki/Jordan_Halliday\" title=\"Jordan Halliday\">Jordan Halliday</a></li>\n<li><a href=\"/wiki/Barry_Horne\" title=\"Barry Horne\">Barry Horne</a></li>\n<li><a href=\"/wiki/Ronnie_Lee\" title=\"Ronnie Lee\">Ronnie Lee</a></li>\n<li><a href=\"/wiki/Lizzy_Lind_af_Hageby\" title=\"Lizzy Lind af Hageby\">Lizzy Lind af Hageby</a></li>\n<li><a href=\"/wiki/Jo-Anne_McArthur\" title=\"Jo-Anne McArthur\">Jo-Anne McArthur</a></li>\n<li><a href=\"/wiki/Paul_McCartney\" title=\"Paul McCartney\">Paul McCartney</a></li>\n<li><a href=\"/wiki/Bill_Maher\" title=\"Bill Maher\">Bill Maher</a></li>\n<li><a href=\"/wiki/Keith_Mann\" title=\"Keith Mann\">Keith Mann</a></li>\n<li><a href=\"/wiki/Dan_Mathews\" title=\"Dan Mathews\">Dan Mathews</a></li>\n<li><a href=\"/wiki/Ingrid_Newkirk\" title=\"Ingrid Newkirk\">Ingrid Newkirk</a></li>\n<li><a href=\"/wiki/Heather_Nicholson\" title=\"Heather Nicholson\">Heather Nicholson</a></li>\n<li><a href=\"/wiki/Alex_Pacheco_(activist)\" title=\"Alex Pacheco (activist)\">Alex Pacheco</a></li>\n<li><a href=\"/wiki/Jill_Phipps\" title=\"Jill Phipps\">Jill Phipps</a></li>\n<li><a href=\"/wiki/Joaquin_Phoenix\" title=\"Joaquin Phoenix\">Joaquin Phoenix</a></li>\n<li><a href=\"/wiki/Craig_Rosebraugh\" title=\"Craig Rosebraugh\">Craig Rosebraugh</a></li>\n<li><a href=\"/wiki/Nathan_Runkle\" title=\"Nathan Runkle\">Nathan Runkle</a></li>\n<li><a href=\"/wiki/Henry_Spira\" title=\"Henry Spira\">Henry Spira</a></li>\n<li><a href=\"/wiki/Kim_Stallwood\" title=\"Kim Stallwood\">Kim Stallwood</a></li>\n<li><a href=\"/wiki/Marianne_Thieme\" title=\"Marianne Thieme\">Marianne Thieme</a></li>\n<li><a href=\"/wiki/Darren_Thurston\" title=\"Darren Thurston\">Darren Thurston</a></li>\n<li><a href=\"/wiki/Andrew_Tyler\" title=\"Andrew Tyler\">Andrew Tyler</a></li>\n<li><a href=\"/wiki/Gary_Yourofsky\" title=\"Gary Yourofsky\">Gary Yourofsky</a></li>\n<li><b><a href=\"/wiki/List_of_animal_rights_advocates\" title=\"List of animal rights advocates\">more...</a></b></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"text-align: center;\">Movement</th>\n<td class=\"navbox-list navbox-off hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"></div>\n<table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\"><a href=\"/wiki/Category:Animal_rights_movement\" title=\"Category:Animal rights movement\">Groups</a></th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Animal_Aid\" title=\"Animal Aid\">Animal Aid</a></li>\n<li><a href=\"/wiki/Animal_Legal_Defense_Fund\" title=\"Animal Legal Defense Fund\">Animal Legal Defense Fund</a></li>\n<li><a href=\"/wiki/Animal_Liberation_Front\" title=\"Animal Liberation Front\">Animal Liberation Front</a></li>\n<li><a href=\"/wiki/British_Union_for_the_Abolition_of_Vivisection\" class=\"mw-redirect\" title=\"British Union for the Abolition of Vivisection\">British Union for the Abolition of Vivisection</a></li>\n<li><a href=\"/wiki/Centre_for_Animals_and_Social_Justice\" title=\"Centre for Animals and Social Justice\">Centre for Animals and Social Justice</a></li>\n<li><a href=\"/wiki/Chinese_Animal_Protection_Network\" title=\"Chinese Animal Protection Network\">Chinese Animal Protection Network</a></li>\n<li><a href=\"/wiki/Direct_Action_Everywhere\" title=\"Direct Action Everywhere\">Direct Action Everywhere</a></li>\n<li><a href=\"/wiki/Farm_Animal_Rights_Movement\" title=\"Farm Animal Rights Movement\">Farm Animal Rights Movement</a></li>\n<li><a href=\"/wiki/Great_Ape_Project\" title=\"Great Ape Project\">Great Ape Project</a></li>\n<li><a href=\"/wiki/Hunt_Saboteurs_Association\" title=\"Hunt Saboteurs Association\">Hunt Saboteurs Association</a></li>\n<li><a href=\"/wiki/In_Defense_of_Animals\" title=\"In Defense of Animals\">In Defense of Animals</a></li>\n<li><a href=\"/wiki/Korea_Animal_Rights_Advocates\" title=\"Korea Animal Rights Advocates\">Korea Animal Rights Advocates</a></li>\n<li><a href=\"/wiki/Last_Chance_for_Animals\" title=\"Last Chance for Animals\">Last Chance for Animals</a></li>\n<li><a href=\"/wiki/Mercy_for_Animals\" title=\"Mercy for Animals\">Mercy for Animals</a></li>\n<li><a href=\"/wiki/New_England_Anti-Vivisection_Society\" title=\"New England Anti-Vivisection Society\">New England Anti-Vivisection Society</a></li>\n<li><a href=\"/wiki/Oxford_Centre_for_Animal_Ethics\" title=\"Oxford Centre for Animal Ethics\">Oxford Centre for Animal Ethics</a></li>\n<li><a href=\"/wiki/Oxford_Group_(animal_rights)\" title=\"Oxford Group (animal rights)\">Oxford Group</a></li>\n<li><a href=\"/wiki/People_for_the_Ethical_Treatment_of_Animals\" title=\"People for the Ethical Treatment of Animals\">People for the Ethical Treatment of Animals</a></li>\n<li><a href=\"/wiki/United_Poultry_Concerns\" title=\"United Poultry Concerns\">United Poultry Concerns</a></li>\n<li><b><a href=\"/wiki/List_of_animal_rights_groups\" title=\"List of animal rights groups\">more...</a></b></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\"><a href=\"/wiki/Category:Animal_advocacy_parties\" title=\"Category:Animal advocacy parties\">Parties</a></th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Animal_Alliance_Environment_Voters_Party_of_Canada\" title=\"Animal Alliance Environment Voters Party of Canada\">AAEVP</a> (Canada)</li>\n<li><a href=\"/wiki/Animal_Justice_Party\" title=\"Animal Justice Party\">Animal Justice Party</a> (Australia)</li>\n<li><a href=\"/wiki/Animal_Welfare_Party\" title=\"Animal Welfare Party\">Animal Welfare Party</a> (UK)</li>\n<li><i><a href=\"/wiki/Party_Against_Bullfighting,_Cruelty_and_Mistreatment_of_Animals\" class=\"mw-redirect\" title=\"Party Against Bullfighting, Cruelty and Mistreatment of Animals\">PACMA</a></i> (Spain)</li>\n<li><i><a href=\"/wiki/Party_for_the_Animals\" title=\"Party for the Animals\">Partij voor de Dieren</a></i> (Netherlands)</li>\n<li><i><a href=\"/wiki/Italian_Animal_Welfare_Party\" title=\"Italian Animal Welfare Party\">Partito Animalista Italiano</a></i> (Italy)</li>\n<li><i><a href=\"/wiki/Tierschutzpartei\" class=\"mw-redirect\" title=\"Tierschutzpartei\">Tierschutzpartei</a></i> (Germany)</li>\n<li><b><a href=\"/wiki/List_of_animal_advocacy_parties\" title=\"List of animal advocacy parties\">more...</a></b></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"text-align: center;\">Media</th>\n<td class=\"navbox-list navbox-off hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\"></div>\n<table class=\"nowraplinks navbox-subgroup\" style=\"border-spacing:0\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\"><a href=\"/wiki/Category:Books_about_animal_rights\" title=\"Category:Books about animal rights\">Books</a></th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/Animals%27_Rights:_Considered_in_Relation_to_Social_Progress\" title=\"Animals' Rights: Considered in Relation to Social Progress\">Animals' Rights: Considered in Relation to Social Progress</a></i> (1894)</li>\n<li><i><a href=\"/wiki/Animals,_Men_and_Morals\" title=\"Animals, Men and Morals\">Animals, Men and Morals</a></i> (1971)</li>\n<li><i><a href=\"/wiki/Animal_Liberation_(book)\" title=\"Animal Liberation (book)\">Animal Liberation</a></i> (1975)</li>\n<li><i><a href=\"/wiki/The_Case_for_Animal_Rights\" title=\"The Case for Animal Rights\">The Case for Animal Rights</a></i> (1983)</li>\n<li><i><a href=\"/wiki/The_Lives_of_Animals\" title=\"The Lives of Animals\">The Lives of Animals</a></i> (1999)</li>\n<li><i><a href=\"/wiki/Striking_at_the_Roots\" title=\"Striking at the Roots\">Striking at the Roots</a></i> (2008)</li>\n<li><i><a href=\"/wiki/An_American_Trilogy_(book)\" title=\"An American Trilogy (book)\">An American Trilogy</a></i> (2009)</li>\n<li><b><a href=\"/wiki/Category:Books_about_animal_rights\" title=\"Category:Books about animal rights\">more...</a></b></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\"><a href=\"/wiki/Category:Documentary_films_about_animal_rights\" title=\"Category:Documentary films about animal rights\">Films</a></th>\n<td class=\"navbox-list navbox-even\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><i><a href=\"/wiki/The_Animals_Film\" title=\"The Animals Film\">The Animals Film</a></i> (1981)</li>\n<li><i><a href=\"/wiki/A_Cow_at_My_Table\" title=\"A Cow at My Table\">A Cow at My Table</a></i> (1998)</li>\n<li><i><a href=\"/wiki/Meet_Your_Meat\" title=\"Meet Your Meat\">Meet Your Meat</a></i> (2002)</li>\n<li><i><a href=\"/wiki/Peaceable_Kingdom_(documentary)\" class=\"mw-redirect\" title=\"Peaceable Kingdom (documentary)\">Peaceable Kingdom</a></i> (2004)</li>\n<li><i><a href=\"/wiki/Earthlings_(film)\" title=\"Earthlings (film)\">Earthlings</a></i> (2005)</li>\n<li><i><a href=\"/wiki/Behind_the_Mask_(2006_documentary_film)\" class=\"mw-redirect\" title=\"Behind the Mask (2006 documentary film)\">Behind the Mask</a></i> (2006)</li>\n<li><i><a href=\"/wiki/The_Cove_(film)\" title=\"The Cove (film)\">The Cove</a></i> (2009)</li>\n<li><i><a href=\"/wiki/Forks_Over_Knives\" title=\"Forks Over Knives\">Forks Over Knives</a></i> (2011)</li>\n<li><i><a href=\"/wiki/Vegucated\" title=\"Vegucated\">Vegucated</a> (2011)</i></li>\n<li><i><a href=\"/wiki/Speciesism:_The_Movie\" title=\"Speciesism: The Movie\">Speciesism: The Movie</a></i> (2013)</li>\n<li><i><a href=\"/wiki/The_Ghosts_in_Our_Machine\" title=\"The Ghosts in Our Machine\">The Ghosts in Our Machine</a></i> (2013)</li>\n<li><b><a href=\"/wiki/Category:Documentary_films_about_animal_rights\" title=\"Category:Documentary films about animal rights\">more...</a></b></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<th scope=\"row\" class=\"navbox-group\" style=\"text-align: center;\">Categories</th>\n<td class=\"navbox-list navbox-off hlist\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><a href=\"/wiki/Category:Animal_advocacy_parties\" title=\"Category:Animal advocacy parties\">Animal advocacy parties</a></li>\n<li><a href=\"/wiki/Category:Animal_law\" title=\"Category:Animal law\">Animal law</a></li>\n<li><a href=\"/wiki/Category:Animal_Liberation_Front\" title=\"Category:Animal Liberation Front\">Animal Liberation Front</a></li>\n<li><a href=\"/wiki/Category:Animal_rights\" title=\"Category:Animal rights\">Animal rights</a></li>\n<li><a href=\"/wiki/Category:Animal_rights_advocates\" title=\"Category:Animal rights advocates\">Animal rights advocates</a></li>\n<li><a href=\"/wiki/Category:Animal_rights_media\" title=\"Category:Animal rights media\">Animal right media</a></li>\n<li><a href=\"/wiki/Category:Animal_rights_movement\" title=\"Category:Animal rights movement\">Animal rights movement</a></li>\n<li><a href=\"/wiki/Category:Animal_testing\" title=\"Category:Animal testing\">Animal testing</a></li>\n<li><a href=\"/wiki/Category:Blood_sports\" title=\"Category:Blood sports\">Blood sports</a></li>\n<li><a href=\"/wiki/Category:Livestock\" title=\"Category:Livestock\">Livestock</a></li>\n<li><a href=\"/wiki/Category:Meat_industry\" title=\"Category:Meat industry\">Meat industry</a></li>\n<li><a href=\"/wiki/Category:Poultry_farming\" title=\"Category:Poultry farming\">Poultry</a></li>\n<li><a href=\"/wiki/Category:Veganism\" title=\"Category:Veganism\">Veganism</a></li>\n<li><a href=\"/wiki/Category:Vegetarianism\" title=\"Category:Vegetarianism\">Vegetarianism</a></li>\n</ul>\n</div>\n</td>\n</tr>\n<tr style=\"height:2px\">\n<td colspan=\"2\"></td>\n</tr>\n<tr>\n<td class=\"navbox-abovebelow\" colspan=\"2\" style=\"text-align: center;\">\n<div><span class=\"metadata\"><a href=\"/wiki/File:Paw_(Animal_Rights_symbol).svg\" class=\"image\"><img alt=\"icon\" src=\"//upload.wikimedia.org/wikipedia/commons/thumb/7/71/Paw_%28Animal_Rights_symbol%29.svg/16px-Paw_%28Animal_Rights_symbol%29.svg.png\" width=\"16\" height=\"16\" srcset=\"//upload.wikimedia.org/wikipedia/commons/thumb/7/71/Paw_%28Animal_Rights_symbol%29.svg/24px-Paw_%28Animal_Rights_symbol%29.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/7/71/Paw_%28Animal_Rights_symbol%29.svg/32px-Paw_%28Animal_Rights_symbol%29.svg.png 2x\" data-file-width=\"500\" data-file-height=\"500\" /></a> <a href=\"/wiki/Portal:Animal_rights\" title=\"Portal:Animal rights\">Animal rights portal</a></span></div>\n</td>\n</tr>\n</table>\n</div>\n<div role=\"navigation\" class=\"navbox\" aria-label=\"Navbox\" style=\"padding:3px\">\n<table class=\"nowraplinks hlist navbox-inner\" style=\"border-spacing:0;background:transparent;color:inherit\">\n<tr>\n<th scope=\"row\" class=\"navbox-group\"><a href=\"/wiki/Help:Authority_control\" title=\"Help:Authority control\">Authority control</a></th>\n<td class=\"navbox-list navbox-odd\" style=\"text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px\">\n<div style=\"padding:0em 0.25em\">\n<ul>\n<li><span style=\"white-space:nowrap;\"><a rel=\"nofollow\" class=\"external text\" href=\"//www.worldcat.org/identities/containsVIAFID/113230702\">WorldCat Identities</a></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/Virtual_International_Authority_File\" title=\"Virtual International Authority File\">VIAF</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"https://viaf.org/viaf/113230702\">113230702</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/Library_of_Congress_Control_Number\" title=\"Library of Congress Control Number\">LCCN</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://id.loc.gov/authorities/names/n80076765\">n80076765</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/International_Standard_Name_Identifier\" title=\"International Standard Name Identifier\">ISNI</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://isni.org/isni/0000000080456315\">0000 0000 8045 6315</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/Integrated_Authority_File\" title=\"Integrated Authority File\">GND</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://d-nb.info/gnd/119033364\">119033364</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/LIBRIS\" title=\"LIBRIS\">SELIBR</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"//libris.kb.se/auth/230807\">230807</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/Syst%C3%A8me_universitaire_de_documentation\" title=\"Système universitaire de documentation\">SUDOC</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://www.idref.fr/026677636\">026677636</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/Biblioth%C3%A8que_nationale_de_France\" title=\"Bibliothèque nationale de France\">BNF</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://catalogue.bnf.fr/ark:/12148/cb11888092r\">cb11888092r</a> <a rel=\"nofollow\" class=\"external text\" href=\"http://data.bnf.fr/ark:/12148/cb11888092r\">(data)</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/BIBSYS\" class=\"mw-redirect\" title=\"BIBSYS\">BIBSYS</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://ask.bibsys.no/ask/action/result?cmd=&amp;kilde=biblio&amp;cql=bs.autid+%3D+90196888&amp;feltselect=bs.autid\">90196888</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/MusicBrainz\" title=\"MusicBrainz\">MusicBrainz</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"//musicbrainz.org/artist/e9ed318d-8cc5-4cf8-ab77-505e39ab6ea4\">e9ed318d-8cc5-4cf8-ab77-505e39ab6ea4</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/National_Library_of_Australia\" title=\"National Library of Australia\">NLA</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"//nla.gov.au/anbd.aut-an35163268\">35163268</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/National_Diet_Library\" title=\"National Diet Library\">NDL</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://id.ndl.go.jp/auth/ndlna/00430962\">00430962</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/National_Library_of_the_Czech_Republic\" title=\"National Library of the Czech Republic\">NKC</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://aleph.nkp.cz/F/?func=find-c&amp;local_base=aut&amp;ccl_term=ica=jn19990000029&amp;CON_LNG=ENG\">jn19990000029</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/Istituto_Centrale_per_il_Catalogo_Unico\" title=\"Istituto Centrale per il Catalogo Unico\">ICCU</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://opac.sbn.it/opacsbn/opac/iccu/scheda_authority.jsp?bid=IT\\ICCU\\RAVV\\034417\">IT\\ICCU\\RAVV\\034417</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/Russian_State_Library\" title=\"Russian State Library\">RLS</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://aleph.rsl.ru/F?func=find-b&amp;find_code=SYS&amp;adjacent=Y&amp;local_base=RSL11&amp;request=000002833&amp;CON_LNG=ENG\">000002833</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/Biblioteca_Nacional_de_Espa%C3%B1a\" title=\"Biblioteca Nacional de España\">BNE</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://catalogo.bne.es/uhtbin/authoritybrowse.cgi?action=display&amp;authority_id=XX1149955\">XX1149955</a></span></span></li>\n<li><span style=\"white-space:nowrap;\"><a href=\"/wiki/CiNii\" title=\"CiNii\">CiNii</a>: <span class=\"uid\"><a rel=\"nofollow\" class=\"external text\" href=\"http://ci.nii.ac.jp/author/DA07517784?l=en\">DA07517784</a></span></span></li>\n</ul>\n</div>\n</td>\n</tr>\n</table>\n</div>\n\n",
    "displaytitle": "Douglas Adams",
    "iwlinks": [
      {
        "prefix": "commons",
        "url": "https://commons.wikimedia.org/wiki/Category:Douglas_Adams",
        "title": "commons:Category:Douglas Adams"
      },
      {
        "prefix": "wikiquote",
        "url": "https://en.wikiquote.org/wiki/Special:Search/Douglas_Adams",
        "title": "wikiquote:Special:Search/Douglas Adams"
      }
    ],
    "wikitext": "{{other people}}\n{{Use British English|date=October 2013}}\n{{Use dmy dates|date=April 2015}}\n{{Infobox writer <!-- for more information see [[:Template:Infobox writer/doc]] -->\n| name          = Douglas Adams\n| image         = Douglas adams portrait cropped.jpg\n| caption       =\n| birth_name    = Douglas Noel Adams\n| birth_date    = {{birth date|1952|3|11|df=yes}}\n| birth_place   = [[Cambridge]], England\n| height        = {{height|ft=6|in=5}}\n| death_date    = {{Death date and age|2001|5|11|1952|3|11|df=yes}}\n| death_place   = [[Montecito, California]], U.S.\n| resting_place = [[Highgate Cemetery]], London, England\n| alma_mater    = [[St John's College, Cambridge]]\n| occupation    = Writer\n| genre         = Science fiction, comedy, satire\n| movement =\n| website       = {{URL|douglasadams.com/}}\n}}\n<!-- Do *not* change spelling of \"Hitchhiker's\"; see talk page for details -->\n<!-- Please do *not* change spelling of \"Noel\". There is no 'ë'. Any citations have themselves been taken from an earlier, incorrect edit of Wikipedia; see talk page for details -->\n'''Douglas Noel Adams''' (11 March 1952 – 11 May 2001) was an [[English people|English]] [[author]], [[scriptwriter]], [[essayist]], [[List of humorists|humourist]], [[satirist]] and [[dramatist]].\n\nAdams is best known as the author of ''[[The Hitchhiker's Guide to the Galaxy]]'', which originated in 1978 as a BBC [[The Hitchhiker's Guide to the Galaxy (radio series)|radio comedy]] before developing into a \"trilogy\" of five books that sold more than 15&nbsp;million copies in his lifetime and generated a [[The Hitchhiker's Guide to the Galaxy (TV series)|television series]], several stage plays, comics, a [[The Hitchhiker's Guide to the Galaxy (computer game)|computer game]], and in 2005 a [[The Hitchhiker's Guide to the Galaxy (film)|feature film]]. Adams's contribution to UK radio is commemorated in [[Radio Academy|The Radio Academy]]'s Hall of Fame.<ref name=\"radioacad\">{{cite web|title=The Radio Academy Hall of Fame |url=http://www.radioacademy.org/hall-of-fame |work=The Radio Academy |accessdate=8 December 2011 |archiveurl=http://www.webcitation.org/63mNGrql2?url=http%3A%2F%2Fwww.radioacademy.org%2Fhall-of-fame%2F |archivedate=8 December 2011 |deadurl=no |df=dmy }}</ref>\n\nAdams also wrote ''[[Dirk Gently's Holistic Detective Agency]]'' (1987) and ''[[The Long Dark Tea-Time of the Soul]]'' (1988), and co-wrote ''[[The Meaning of Liff]]'' (1983), ''[[The Deeper Meaning of Liff]]'' (1990), ''[[Last Chance to See]]'' (1990), and three stories for the television series ''[[Doctor Who]]''; he also served as [[script editor]] for the show's seventeenth season in 1979. A posthumous collection of his works, including an unfinished novel, was published as ''[[The Salmon of Doubt]]'' in 2002.\n\nAdams was known as an advocate for environmentalism and [[conservation movement|conservation]], as a lover of fast cars, cameras, [[technological innovation]] and the [[Apple Macintosh]], and as a \"devout [[atheist]]\".\n\n==Early life==\n<!-- Please leave this section heading as is, for the chronology of events. Adams's own family (wife and daughter) are discussed later. -->\nAdams was born on 11 March 1952 to Janet (née Donovan; 1927–2016) and Christopher Douglas Adams (1927–1985) in [[Cambridge]], England.<ref name=ODNB >Webb 2005b</ref> The following year, [[James D. Watson|Watson]] and [[Francis Crick|Crick]] famously first modelled [[DNA]] at [[Cambridge University]], leading Adams to later quip he was DNA in Cambridge months earlier. The family moved to [[East End of London|East London]] a few months after his birth, where his sister, Susan, was born three years later.<ref name=Adams_xix>{{Harvnb|Adams|2002|pp=xix}}</ref> His parents divorced in 1957; Douglas, Susan, and their mother moved to an [[RSPCA]] animal shelter in [[Brentwood, Essex]], run by his maternal grandparents.<ref>Webb 2005a, p. 32.</ref>\n\n===Education===\nAdams attended Primrose Hill Primary School in [[Brentwood, Essex|Brentwood]]. At nine, he passed the entrance exam for [[Brentwood School (Essex)|Brentwood School]], an independent school whose alumni include [[Robin Day]], [[Jack Straw]], [[Noel Edmonds]], and [[David Irving]]. [[Griff Rhys Jones]] was a year below him, and he was in the same class as [[Stuckism|Stuckist]] artist [[Charles Thomson (artist)|Charles Thomson]]. He attended the [[Preparatory school (UK)|prep school]] from 1959 to 1964, then the main school until December 1970. His form master, Frank Halford, said of him: \"Hundreds of boys have passed through the school but Douglas Adams really stood out from the crowd — literally. He was unnecessarily tall and in his short trousers he looked a trifle self-conscious.\" \"The form-master wouldn't say 'Meet under the clock tower,' or 'Meet under the war memorial',\" he joked, \"but 'Meet under Adams'.\"<ref name=Adams_7>{{Harvnb|Adams|2002|pp=7}}</ref><ref>Botti, Nicholas. [http://douglasadams.eu/interview-with-frank-halford/ \"Interview with Frank Halford\"]. ''Life, DNA, and H2G2.'' 2009. Web. Retrieved 13 March 2012. (Click on link at bottom for facsimile page from ''Daily News'' article, 7 March 1998.)</ref> Yet it was his ability to write first-class stories that really made him \"shine\".<ref name=Simpson_9>{{Harvnb|Simpson|2003|pp=9}}</ref>\n\nAdams was six feet tall (1.83&nbsp;m) by age 12 and stopped growing at 6&nbsp;ft 5&nbsp;in (1.96&nbsp;m). He became the only student ever to be awarded a ten out of ten by Halford for creative writing, something he remembered for the rest of his life, particularly when facing [[writer's block]].<ref name=Adams_xix />\n\nSome of his earliest writing was published at the school, such as a report on its photography club in ''The Brentwoodian'' in 1962, or spoof reviews in the school magazine ''Broadsheet'', edited by [[Paul Neil Milne Johnstone]], who later became a character in ''The Hitchhiker's Guide''. He also designed the cover of one issue of the ''Broadsheet'', and had a letter and short story published nationally in ''[[Eagle (comic)|The Eagle]]'', the boys' comic, in 1965. A poem entitled \"A Dissertation on the task of writing a poem on a candle and an account of some of the difficulties thereto pertaining\" written by Adams in January 1970, at the age of 17, was discovered by archivist Stacey Harmer in a cupboard at the school in early 2014. In it, Adams rhymes \"futile\" with \"mute, while\" and \"exhausted\" with \"of course did\".<ref>Flood, Alison (March 2014). [http://www.theguardian.com/books/2014/mar/19/lost-school-poems-douglas-adams-griff-rhys-jones \"Lost poems of Douglas Adams and Griff Rhys Jones found in school cupboard\"], ''The Guardian'', 19 March 2014. Accessed 2 July 2014</ref> On the strength of a bravura essay on religious poetry that discussed [[the Beatles]] and [[William Blake]], he was awarded an [[Exhibition (scholarship)|Exhibition]] in English at [[St John's College, Cambridge]], going up in 1971. He wanted to join the [[Footlights]], an invitation-only student comedy club that has acted as a hothouse for comic talent. He was not elected immediately as he had hoped, and started to write and perform in revues with Will Adams (no relation) and Martin Smith, forming a group called \"Adams-Smith-Adams\", but became a member of the Footlights by 1973.<ref name=Simpson_30-40>{{Harvnb|Simpson|2003|pp=30–40}}</ref> Despite doing very little work—he recalled having completed three essays in three years—he graduated in 1974 with a B.A. in [[English literature]].<ref name=ODNB/>\n\n==Career==\n\n===Writing===\nAfter leaving university Adams moved back to London, determined to break into TV and radio as a writer. An edited version of the ''Footlights Revue'' appeared on [[BBC Two|BBC2]] television in 1974. A version of the Revue performed live in London's [[West End of London|West End]] led to Adams being discovered by [[Monty Python]]'s [[Graham Chapman]]. The two formed a brief writing partnership, earning Adams a writing credit in [[List of Monty Python's Flying Circus episodes#6. Party Political Broadcast|episode 45]] of ''Monty Python'' for a sketch called \"[[Patient Abuse]]\". He is one of only two people outside the original Python members to get a writing credit (the other being [[Neil Innes]]).<ref name=times>{{cite news|title=Terry Jones remembers Douglas Adams, 'the last of the Pythons'|newspaper=The Times|date=10 October 2009}}</ref> The sketch plays on the idea of mind-boggling paper work in an emergency, a joke later incorporated into the [[Vogon]]s' obsession with paperwork. Adams also contributed to a sketch on the album for ''[[Monty Python and the Holy Grail]]''.\n\n[[File:DNA in Monty Python.jpg|thumb|Adams in his first ''[[Monty Python's Flying Circus|Monty Python]]'' appearance, in full surgeon's garb]]\n\nAdams had two brief appearances in the fourth series of ''[[Monty Python's Flying Circus]]''. At the beginning of episode 42, \"The Light Entertainment War\", Adams is in a surgeon's mask (as Dr. Emile Koning, according to on-screen captions), pulling on gloves, while [[Michael Palin]] narrates a sketch that introduces one person after another but never gets started. At the beginning of episode 44, \"Mr. Neutron\", Adams is dressed in a [[List of recurring Monty Python's Flying Circus characters#The Pepperpots|pepper-pot]] outfit and loads a missile onto a cart driven by [[Terry Jones]], who is calling for scrap metal (\"Any old iron...\"). The two episodes were broadcast in November 1974. Adams and Chapman also attempted non-Python projects, including ''[[Out of the Trees]]''.\n\nAt this point Adams's career stalled; his writing style was unsuited to the then-current style of radio and TV comedy.<ref name=ODNB /> To make ends meet he took a series of odd jobs, including as a hospital porter, barn builder, and chicken shed cleaner. He was employed as a bodyguard by a Qatari family, who had made their fortune in oil. Anecdotes about that job included that the family had once ordered one of everything from a hotel's menu, tried all the dishes, and sent out for hamburgers. Another story had to do with a prostitute sent to the floor Adams was guarding one evening. They acknowledged each other as she entered, and an hour later, when she left, she is said to have remarked, \"At least you can read while you're on the job.\"<ref>Webb 2005a, p. 93.</ref>\n\nDuring this time Adams continued to write and submit sketches, though few were accepted. In 1976 his career had a brief improvement when he wrote and performed ''Unpleasantness at Brodie's Close'' at the [[Edinburgh Fringe]] festival. By Christmas work had dried up again, and a depressed Adams moved to live with his mother.<ref name=ODNB /> The lack of writing work hit him hard and low confidence became a feature of Adams's life; \"I have terrible periods of lack of confidence [..] I briefly did therapy, but after a while I realised it was like a farmer complaining about the weather. You can't fix the weather&nbsp;– you just have to get on with it\".<ref name=Adams_prologue>{{Harvnb|Adams|2002|pp=prologue}}</ref>\n\nSome of Adams's early radio work included sketches for ''[[The Burkiss Way]]'' in 1977 and ''[[The News Huddlines]]''.<ref>''Hitchhiker: A Biography of Douglas Adams'' by M. J. Simpson, p87</ref> He also wrote, again with Chapman, 20 February 1977 episode of ''Doctor on the Go'', a sequel to the ''[[Doctor in the House (TV series)|Doctor in the House]]'' television comedy series. After the [[The Hitchhiker's Guide to the Galaxy (radio series)|first radio series of ''The Hitchhiker's Guide'']] became successful, Adams was made a BBC radio producer, working on ''[[Week Ending]]'' and a pantomime called ''[[Black Cinderella Two Goes East]]''.<ref>Roberts, Jem. ''The Clue Bible: The Fully Authorised History of I'm Sorry I Haven't A Clue from Footlights to Mornington Crescent'': London, 2009, p164-5</ref> He left  after six months to become the script editor for ''[[Doctor Who]]''.\n\nIn 1979 Adams and [[John Lloyd (producer)|John Lloyd]] wrote scripts for two half-hour episodes of ''[[Doctor Snuggles]]'': \"The Remarkable Fidgety River\" and \"The Great Disappearing Mystery\" (episodes seven and twelve). John Lloyd was also co-author of two episodes from the original ''Hitchhiker'' radio series (\"Fit the Fifth\" and \"Fit the Sixth\", also known as \"Episode Five\" and \"Episode Six\"), as well as ''[[The Meaning of Liff]]'' and ''[[The Deeper Meaning of Liff]]''.\n\n====''The Hitchhiker's Guide to the Galaxy''====\n{{Main article|The Hitchhiker's Guide to the Galaxy}}\n''The Hitchhiker's Guide to the Galaxy'' was a concept for a science-fiction comedy radio series pitched by Adams and radio producer [[Simon Brett]] to [[BBC Radio 4]] in 1977. Adams came up with an outline for a pilot episode, as well as a few other stories (reprinted in [[Neil Gaiman]]'s book ''[[Don't Panic: The Official Hitchhiker's Guide to the Galaxy Companion]]'') that could potentially be used in the series.\n[[File:Towelday-Innsbruck.jpg|thumb|upright|[[Towel Day]] 2005 in Innsbruck, Austria, where Adams first had the idea of ''The Hitchhiker's Guide''. In the novels a towel is the most useful thing a space traveller can have.  The annual Towel Day (25 May) was first celebrated in 2001, two weeks after Adams's death.]]\n\nAccording to Adams, the idea for the title occurred to him while he lay drunk in a field in [[Innsbruck]], Austria, gazing at the stars. He was carrying a copy of the ''[[Hitch-hiker's Guide to Europe]]'', and it occurred to him that \"somebody ought to write a ''Hitchhiker's Guide to the Galaxy''\". He later said that the constant repetition of this anecdote had obliterated his memory of the actual event.<ref>{{cite book | author=Adams, Douglas| editor= Geoffrey Perkins (ed.), Additional Material by M. J. Simpson|title=[[The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts]] | page = 10 | edition =25th Anniversary | publisher=Pan Books | year=2003 | isbn=0-330-41957-9}}</ref>\n\nDespite the original outline, Adams was said to make up the stories as he wrote. He turned to [[John Lloyd (producer)|John Lloyd]] for help with the final two episodes of [[The Hitchhiker's Guide to the Galaxy Primary and Secondary Phases#The Primary Phase|the first series]]. Lloyd contributed bits from an unpublished science fiction book of his own, called ''GiGax''.<ref>Webb 2005a, p. 120.</ref> Very little of Lloyd's material survived in later adaptations of ''Hitchhiker's'', such as the novels and the TV series. The TV series was based on the first six radio episodes, and sections contributed by Lloyd were largely re-written.\n\n[[BBC Radio 4]] broadcast the first radio series weekly in the UK in March and April 1978. The series was distributed in the United States by [[National Public Radio]].  Following the success of the first series, another episode was recorded and broadcast, which was commonly known as the Christmas Episode. [[The Hitchhiker's Guide to the Galaxy Primary and Secondary Phases#The Secondary Phase|A second series]] of five episodes was broadcast one per night, during the week of 21–25 January 1980.\n\nWhile working on the radio series (and with simultaneous projects such as ''[[The Pirate Planet]]'') Adams developed problems keeping to writing deadlines that only got worse as he published novels. Adams was never a prolific writer and usually had to be forced by others to do any writing. This included being locked in a hotel suite with his editor for three weeks to ensure that ''[[So Long, and Thanks for All the Fish]]'' was completed.<ref>Felch 2004</ref> He was quoted as saying, \"I love deadlines. I love the whooshing noise they make as they go by.\"<ref name=Simpson_236>{{Harvnb|Simpson|2003|pp=236}}</ref> Despite the difficulty with deadlines, Adams wrote five novels in the series, published in 1979, 1980, 1982, 1984, and 1992.\n\nThe books formed the basis for other adaptations, such as three-part comic book adaptations for each of the first three books, an interactive text-adventure [[The Hitchhiker's Guide to the Galaxy (computer game)|computer game]], and a photo-illustrated edition, published in 1994. This latter edition featured a [[42 Puzzle]] designed by Adams, which was later incorporated into paperback covers of the first four ''Hitchhiker's'' novels (the paperback for the fifth re-used the artwork from the hardback edition).<ref>[http://www.iblist.com/series.php?id=2 Internet Book List] page, with links to all five novels, and reproductions of the 1990s paperback covers that included the [[42 Puzzle]].</ref>\n\nIn 1980 Adams also began attempts to turn the first ''Hitchhiker's'' novel into a movie, making several trips to Los Angeles, and working with a number of Hollywood studios and potential producers. The next year, the radio series became the basis for a BBC television mini-series<ref>{{citation|url=http://www.imdb.com/title/tt0081874/|title=''The Hitch Hiker's Guide to the Galaxy''|publisher=Internet Movie Database}}</ref> broadcast in six parts. When he died in 2001 in California, he had been trying again to get the movie project started with [[Disney]], which had bought the rights in 1998. The screenplay finally got a posthumous re-write by [[Karey Kirkpatrick]], and [[The Hitchhiker's Guide to the Galaxy (film)|the resulting film]] was released in 2005.\n\nRadio producer [[Dirk Maggs]] had consulted with Adams, first in 1993, and later in 1997 and 2000 about creating a third radio series, based on the third novel in the ''Hitchhiker's'' series.<ref>{{cite book | author=Adams, Douglas. | editor = [[Dirk Maggs]], dramatisations and editor | title=The Hitchhiker's Guide to the Galaxy Radio Scripts: The Tertiary, Quandary and Quintessential Phases | publisher=Pan Books | year=2005|isbn=0-330-43510-8 |pages=xiv | nopp=true}}</ref> They also discussed the possibilities of radio adaptations of the final two novels in the five-book \"trilogy\". As with the movie, this project was only realised after Adams's death. The third series, ''[[The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases#The Tertiary Phase|The Tertiary Phase]]'', was broadcast on [[BBC Radio 4]] in September 2004 and was subsequently released on audio CD. With the aid of a recording of his reading of ''Life, the Universe and Everything'' and editing, Adams can be heard playing the part of Agrajag posthumously. ''So Long, and Thanks for All the Fish'' and ''Mostly Harmless'' made up the fourth and fifth radio series, respectively (on radio they were titled ''[[The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases#The Quandary Phase|The Quandary Phase]]'' and ''[[The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases#The Quintessential Phase|The Quintessential Phase]]'') and these were broadcast in May and June 2005, and also subsequently released on Audio CD. The last episode in the last series (with a new, \"more upbeat\" ending) concluded with, \"The very final episode of ''The Hitchhiker's Guide to the Galaxy'' by Douglas Adams is affectionately dedicated to its author.\"<ref>Adams, ''Dirk Maggs'', Page 356.</ref>\n\n====''Dirk Gently'' series====\n[[File:Douglas Adams San Francisco.jpg|thumb|Adams in March 2000]]\nIn between Adams's first trip to Madagascar with [[Mark Carwardine]] in 1985, and their series of travels that formed the basis for the radio series and non-fiction book ''[[Last Chance to See]]'', Adams wrote two other novels with a new cast of characters. ''[[Dirk Gently's Holistic Detective Agency]]'' was first published in 1987, and was described by its author as \"a kind of ghost-horror-detective-time-travel-romantic-comedy-epic, mainly concerned with mud, music and quantum mechanics\".<ref>{{cite book|author=[[Neil Gaiman|Gaiman, Neil]] | title=Don't Panic: Douglas Adams & The Hitchhiker's Guide to the Galaxy | edition=Second U.S. | publisher=Titan Books | year=2003 | page=169 | isbn=1-84023-742-2}}</ref> It was derived from two Doctor Who serials Adams had written.\n\nA sequel novel, ''[[The Long Dark Tea-Time of the Soul]]'', was published a year later. This was an entirely original work, Adams's first since ''So Long, and Thanks for All the Fish.'' After the book tour, Adams set off on his round-the-world excursion which supplied him with the material for ''Last Chance to See''.\n\n====''Doctor Who''====\n{{Main article|Doctor Who}}\nAdams sent the script for the ''HHGG'' pilot radio programme to the ''Doctor Who'' production office in 1978, and was commissioned to write ''[[The Pirate Planet]]'' (see below). He had also previously attempted to submit a potential movie script, called \"Doctor Who and the Krikkitmen\", which later became his novel ''Life, the Universe and Everything'' (which in turn became the third ''Hitchhiker's Guide'' radio series). Adams then went on to serve as script editor on the show for its seventeenth season in 1979. Altogether, he wrote three [[List of Doctor Who serials|''Doctor Who'' serials]] starring [[Tom Baker]] as [[The Doctor (Doctor Who)|the Doctor]]:\n* \"[[The Pirate Planet]]\" (the second serial in the \"[[The Key to Time|Key to Time]]\" arc, in [[Doctor Who (season 16)|season 16]])\n* \"[[City of Death]]\" (with producer [[Graham Williams (television producer)|Graham Williams]], from an original storyline by writer [[David Fisher (writer)|David Fisher]]. It was transmitted under the pseudonym \"[[David Agnew]]\")\n* \"[[Shada]]\" (only partially filmed; not televised due to [[strike action|industry disputes]])\n\nThe episodes authored by Adams are some of the few that were not novelised as Adams would not allow anyone else to write them, and asked for a higher price than the publishers were willing to pay.<ref>{{cite web|url=http://www.skepticfiles.org/en001/drwhogde.htm |title=A 1990s Doctor Who FAQ |publisher=Skepticfiles.org |accessdate=11 March 2013}}</ref> \"Shada\" was later adapted as a novel by [[Gareth Roberts (writer)|Gareth Roberts]] in 2012 and \"City of Death\" by [[James Goss (producer)|James Goss]] in 2015.\n\nAdams was also known to allow in-jokes from ''The Hitchhiker's Guide'' to appear in the ''Doctor Who'' stories he wrote and other stories on which he served as Script Editor. Subsequent writers have also inserted ''Hitchhiker's'' references, even [[The Rings of Akhaten|as recently as 2013]]. Conversely, at least one reference to ''Doctor Who'' was worked into a ''Hitchhiker's'' novel. In ''[[Life, the Universe and Everything]]'', two characters travel in time and land on the pitch at [[Lord's Cricket Ground]]. The reaction of the radio commentators to their sudden appearance is very similar to the reactions of commentators in a scene in the eighth episode of the 1965–66-story ''[[The Daleks' Master Plan]]'', which has the Doctor's [[TARDIS]] [[Materialization (science fiction)|materialise]] on the pitch at Lord's.\n\nElements of ''Shada'' and ''City of Death'' were reused in Adams's later novel ''[[Dirk Gently's Holistic Detective Agency]]'', in particular the character of [[Professor Chronotis]]. [[Big Finish Productions]] eventually remade ''Shada'' as an audio play starring [[Paul McGann]] as the Doctor. Accompanied by partially animated illustrations, it was [[Doctor Who spin-offs#Webcasts|webcast]] on the [[BBC Online|BBC website]] in 2003, and subsequently released as a two-CD set later that year. An omnibus edition of this version was broadcast on the digital radio station [[BBC7]] on 10 December 2005.\n\nIn the ''Doctor Who'' 2012 Christmas episode ''[[The Snowmen#Production|The Snowmen]]'', writer [[Steven Moffat]] was inspired by a storyline that Adams pitched called ''The Doctor Retires''.<ref>{{cite web|last=Moffat |first=Steven |url=http://www.radiotimes.com/news/2012-12-24/doctor-who-christmas-special-steven-moffat-matt-smith-and-jenna-louise-coleman-reveal-all |title=Doctor Who Christmas special: Steven Moffat, Matt Smith and Jenna-Louise Coleman reveal all |work=Radio Times |date=24 December 2012 |accessdate=8 July 2013}}</ref>\n\nWhile he was at school,{{which|date=October 2015}} he wrote and performed a play called ''Doctor Which''.<ref name=Adams_xx>{{Harvnb|Adams|2002|pp=xx}}</ref>\n\n===Music===\nAdams played the guitar left-handed and had a collection of twenty-four left-handed guitars when he died (having received his first guitar in 1964). He also studied piano in the 1960s with the same teacher as [[Paul Wickens]], the pianist who plays in [[Paul McCartney]]'s band (and composed the music for the 2004–2005 editions of the ''Hitchhiker's Guide'' radio series).<ref>Webb, page 49.</ref> [[Pink Floyd]] and [[Procol Harum]] had important influence on Adams's work.\n\n====Pink Floyd====\n\nAdams included a reference to [[Pink Floyd]] in the original radio version of ''[[The Hitchhiker's Guide to the Galaxy]]'', in which he describes the main characters surveying the landscape of an alien planet while Marvin, their android companion, hums Pink Floyd's \"[[Shine on You Crazy Diamond]]\" (Part 1). This was cut out of the CD version. Adams also compared the various noises that the [[kakapo]] makes to \"Pink Floyd studio out-takes\" in his non-fiction book on endangered species, ''[[Last Chance to See]]''.\n\nAdams's official biography shares its name with the song \"[[Wish You Were Here (1975 song)|Wish You Were Here]]\" by Pink Floyd. Adams was friends with Pink Floyd guitarist [[David Gilmour]] and, on Adams's 42nd birthday, he was invited to make a guest appearance at Pink Floyd's concert of 28 October 1994 at Earls Court in London, playing guitar on the songs \"[[Brain Damage (song)|Brain Damage]]\" and \"[[Eclipse (song)|Eclipse]]\".<ref name=Mabbett-MM>{{Cite book |publisher= Omnibus Press |isbn= 978-1-84938-370-7 |last= Mabbett |first= Andy |title= Pink Floyd – The Music and the Mystery |location= London |year= 2010 }}</ref> Adams chose the name for Pink Floyd's 1994 album, ''[[The Division Bell]]'', by picking the words from the lyrics to one of its tracks, \"High Hopes\".<ref name=Mabbett-MM /> Gilmour also performed at Adams's memorial service in 2001, and what would have been Adams's 60th birthday party in 2012.\n\n====Procol Harum====\nAdams was a friend of [[Gary Brooker]], the lead singer, pianist and songwriter of [[Procol Harum]]. Adams invited Brooker to one of the many parties that Adams held at his house. On one such occasion Gary Brooker performed the full (4 verse) version of \"[[A Whiter Shade of Pale]]\". Brooker also performed at Adams's memorial service.\n\nAdams appeared on stage with Brooker to perform \"In Held 'Twas in I\" at Redhill when the band's lyricist [[Keith Reid]] was not available. On several other occasions he introduced Procol Harum at their gigs.\n\nAdams would listen to music while writing, and this would occasionally influence his work. On one occasion the title track from the Procol Harum album ''[[Grand Hotel (album)|Grand Hotel]]'' was playing when\n{{quotation|Suddenly in the middle of the song there was this huge orchestral climax that came out of nowhere and did not seem to be about anything. I kept wondering what was this huge thing happening in the background? And I eventually thought&nbsp;... it sounds as if there ought to be some sort of floorshow going on. Something huge and extraordinary, like, well, like the end of the universe. And so that was where the idea for The Restaurant at the End of the Universe came from.|Douglas Adams|Procol Harum at The Barbican<ref>{{cite web|url=http://www.procolharum.com/dadams.htm |title=Text of one of Douglas Adams's introductions of Procol Harum in concert |accessdate=21 August 2006|last=Adams |first=Douglas |date=8 February 1996}}</ref>}}\n\n===Computer games and projects===\nDouglas Adams created an [[interactive fiction]] version of ''[[The Hitchhiker's Guide to the Galaxy (computer game)|HHGG]]'' with [[Steve Meretzky]] from [[Infocom]] in 1984. In 1986 he participated in a week-long brainstorming session with the [[Lucasfilm Games]] team for the game ''[[Labyrinth: The Computer Game|Labyrinth]]''. Later he was also involved in creating ''[[Bureaucracy (computer game)|Bureaucracy]]'' (also by Infocom, but not based on any book; Adams wrote it as a parody of events in his own life).\n\nAdams was a founder-director and Chief Fantasist of [[The Digital Village]], a digital media and Internet company with which he created ''[[Starship Titanic]]'', a [[Codie]] Award-winning and [[BAFTA#Games Awards|BAFTA-nominated adventure game]], which was published in 1998 by [[Simon & Schuster]].<ref name=\"bbc.co.uk\">BBC Online (no date) [http://www.bbc.co.uk/cult/hitchhikers/dna/biog.shtml \"The Hitchhiker's Guide to the Galaxy: DNA (1952-2001)\"] Accessed 9 July 2014</ref><ref>Botti, Nicolas (2009). [http://www.douglasadams.eu/en_adams_bio.php \"Life, DNA & h2g2: Douglas Adams's Biography\"] Accessed 9 July 2014</ref> [[Terry Jones]] wrote the accompanying book, entitled ''Douglas Adams Starship Titanic'', since Adams was too busy with the computer game to do both. In April 1999, Adams initiated the [[h2g2]] [[collaborative writing]] project, an experimental attempt at making ''The Hitchhiker's Guide to the Galaxy'' a reality, and at harnessing the collective brainpower of the internet community. It found a new home at BBC Online in 2001.<ref name=\"bbc.co.uk\"/>\n\nIn 1990 Adams wrote and presented a television documentary programme ''[[Hyperland]]''<ref>[http://www.imdb.com/title/tt0188677/ Internet Movie Database's page for ''Hyperland'']</ref> which featured [[Tom Baker]] as a \"software agent\" (similar to the assistant pictured in Apple's [[Knowledge Navigator]] video of future concepts from 1987), and interviews with [[Ted Nelson]], the co-inventor of [[hypertext]] and the person who coined the term. Although Adams did not invent hypertext, he was an [[early adopter]] and advocate of it. This was the same year that [[Tim Berners-Lee]] used the idea of hypertext in his [[HTML]].\n\n==Personal beliefs and activism==\n\n===Atheism and views on religion===\nAdams described himself as a \"radical [[atheist]]\", adding ''radical'' for emphasis so he would not be asked if he meant agnostic. He told [[American Atheists]] that this made things easier, but most importantly it conveyed the fact that he really meant it. \"I am convinced that there is not a god,\" he said. He imagined a [[Fine-tuned Universe#In popular culture|sentient puddle]] who wakes up one morning and thinks, \"This is an interesting world I find myself in – an interesting hole I find myself in – fits me rather neatly, doesn't it? In fact it fits me staggeringly well, must have been made to have me in it!\" to demonstrate his view that the [[fine-tuned Universe]] argument for God was a fallacy.<ref>Adams 1998.</ref>\n\nDespite this, he remained fascinated by religion because of its effect on human affairs. \"I love to keep poking and prodding at it. I've thought about it so much over the years that that fascination is bound to spill over into my writing.\"<ref name=amath>{{cite journal|last=Silverman |first=Dave |title=Interview: Douglas Adams |journal=American Atheist |year=1998–1999 |volume=37 |issue=1 |url=http://www.atheists.org/Interview%3A__Douglas_Adams |accessdate=16 August 2009 |archiveurl=http://www.webcitation.org/63mRFcWVO?url=http%3A%2F%2Fwww.atheists.org%2FInterview%253A__Douglas_Adams |archivedate=8 December 2011 |deadurl=no |df=dmy }}</ref>\n\nThe evolutionary biologist and atheist [[Richard Dawkins]] uses Adams's influence throughout to exemplify arguments for non-belief in his 2006 book ''[[The God Delusion]]''. Dawkins dedicated the book to Adams, whom he jokingly called \"possibly [my] only convert\" to atheism<ref name=\"TheGuardian\">{{cite news|url=http://books.guardian.co.uk/reviews/roundupstory/0,,1939704,00.html |title=Observer, '&#39;The God Delusion'&#39;, 5&nbsp;November 2006|newspaper=[[The Guardian]]|date=5 November 2006 |accessdate=1 June 2009 | location=London | first=Kim | last=Bunce}}</ref> and wrote on his death that \"Science has lost a friend, literature has lost a luminary, the [[mountain gorilla]] and the [[black rhino]] have lost a gallant defender.\"<ref name=Dawkins2001>{{cite news|last=Dawkins|first=Richard|title=Lament for Douglas Adams|url=http://www.guardian.co.uk/uk/2001/may/14/books.booksnews|accessdate=29 December 2012|newspaper=The Guardian|date=13 May 2001}}</ref>\n\n===Environmental activism===\nAdams was also an [[environmental activist]] who campaigned on behalf of [[endangered species]]. This activism included the production of the non-fiction radio series ''[[Last Chance to See]]'', in which he and [[natural history|naturalist]] [[Mark Carwardine]] visited rare species such as the [[kakapo]] and [[Chinese river dolphin|baiji]], and the publication of a tie-in book of the same name. In 1992 this was made into a CD-ROM combination of [[audiobook]], [[e-book]] and picture slide show.\n\nAdams and Mark Carwardine contributed the 'Meeting a Gorilla' passage from ''[[Last Chance to See]]'' to the book ''[[Great Ape Project|The Great Ape Project]]''.<ref>{{cite book | author=[[Paola Cavalieri|Cavalieri, Paola]] and [[Peter Singer]], editors | title=The Great Ape Project: Equality Beyond Humanity | edition=U.S. Paperback | publisher=St. Martin's Griffin | year=1994 | pages=19–23|isbn=0-312-11818-X}}</ref> This book, edited by [[Paola Cavalieri]] and [[Peter Singer]], launched a wider-scale project in 1993, which calls for the extension of moral equality to include all great apes, human and non-human.\n\nIn 1994 he participated in a climb of [[Mount Kilimanjaro]] while wearing a rhino suit for the British charity organisation ''[[Save the Rhino|Save the Rhino International]]''. Puppeteer [[William Todd-Jones]], who had originally worn the suit in the London Marathon to raise money and bring awareness to the group, also participated in the climb wearing a rhino suit; Adams wore the suit while travelling to the mountain before the climb began. About £100,000 was raised through that event, benefiting schools in [[Kenya]] and a [[black rhinoceros]] preservation programme in [[Tanzania]]. Adams was also an active supporter of the ''[[Dian Fossey]] Gorilla Fund''.\n\nSince 2003, ''Save the Rhino'' has held an annual Douglas Adams Memorial Lecture around the time of his birthday to raise money for environmental campaigns.<ref>{{cite web|url=http://lifednah2g2.blogspot.co.uk/2011/01/ninth-douglas-adams-memorial-lecture.html |title=The Ninth Douglas Adams Memorial Lecture |publisher=Save the Rhino International |accessdate=27 July 2011}}</ref> The lectures in the series are:\n* 2003 [[Richard Dawkins]] – ''Queerer than we can suppose: the strangeness of science''\n* 2004 [[Robert Swan]] – ''Mission Antarctica''\n* 2005 [[Mark Carwardine]] – ''Last Chance to See... Just a bit more''\n* 2006 [[Robert Winston]] – ''Is the Human an Endangered Species?''\n* 2007 [[Richard Leakey]] – ''Wildlife Management in East Africa – Is there a future?''\n* 2008 [[Steven Pinker]] – ''The Stuff of Thought, Language as a Window into Human Nature''\n* 2009 [[Benedict Allen]] – ''Unbreakable''\n* 2010 [[Marcus du Sautoy]] – ''42: the answer to life, the universe and prime numbers''\n* 2011 [[Brian Cox (physicist)|Brian Cox]] – ''The Universe and Why We Should Explore It''\n* 2012 Lecture replaced by \"Douglas Adams The Party\"<ref>{{cite web|url=http://www.savetherhino.org/latest_news/news/287_douglas_adams_the_party |title=Douglas Adams The Party |publisher=Save the Rhino International |accessdate=11 March 2013}}</ref>\n* 2013 [[Adam Rutherford]] – ''Creation: the origin and the future of life''<ref>{{cite web|url=http://www.savetherhino.org/events/476_douglas_adams_memorial_lecture_2013 |title=Douglas Adams Memorial Lecture 2013 |publisher=Save the Rhino International |accessdate=15 August 2012}}</ref>\n* 2014 [[Roger Highfield]] and [[Simon Singh]] – ''The Science of Harry Potter and the Mathematics of The Simpsons''<ref>{{cite web|url=http://www.savetherhino.org/events/798_douglas_adams_memorial_lecture |title=Douglas Adams Memorial Lecture 2014 |publisher=Save the Rhino International |accessdate=15 November 2013}}</ref>\n* 2015 [[Neil Gaiman]] – ''Immortality and Douglas Adams''<ref>{{cite web|url=http://www.savetherhino.org/events/1059_douglas_adams_memorial_lecture_2015_-_sold_out  |title=Douglas Adams Memorial Lecture 2015 |publisher=Save the Rhino International |accessdate=30 January 2015}}</ref>\n* 2016 [[Alice Roberts]] – ''Survivors of the Ice Age''<ref>{{ cite web|url=https://www.savetherhino.org/events/1383_douglas_adams_memorial_lecture_2016|title=Douglas Adams Memorial Lecture 2016 |publisher=Save the Rhino International |accessdate=7 December 2015}}</ref>\n\n===Technology and innovation===\nAdams bought his first [[word processor]] in 1982, having considered one as early as 1979. His first purchase was a 'Nexus'. In 1983, when he and Jane Belson went out to Los Angeles, he bought a [[Digital Equipment Corporation|DEC]] [[Rainbow 100|Rainbow]]. Upon their return to England, Adams bought an [[Apricot Computers|Apricot]], then a [[BBC Micro]] and a [[Tandy 1000]].<ref name=Simpson_184-185>{{Harvnb|Simpson|2003|pp=184–185}}</ref> In ''[[Last Chance to See]]'' Adams mentions his [[Cambridge Z88]], which he had taken to [[Zaire]] on a quest to find the [[northern white rhinoceros]].<ref>{{cite book|author=Adams, Douglas and [[Mark Carwardine]] | title=Last Chance to See | edition=First U.S. Hardcover | publisher=[[Harmony Books]] | year=1991 | page=59 | isbn=0-517-58215-5}}</ref>\n\nAdams's posthumously published work, ''[[The Salmon of Doubt]]'', features multiple articles by him on the subject of technology, including reprints of articles that originally ran in ''[[MacUser]]'' magazine, and in ''[[The Independent on Sunday]]'' newspaper. In these Adams claims that one of the first computers he ever saw was a [[Commodore PET]], and that he has \"adored\" his Apple Macintosh (\"or rather my family of however many Macintoshes it is that I've recklessly accumulated over the years\") since he first saw one at Infocom's offices in Boston in 1984.<ref>{{cite book | author=Adams, Douglas | title=The Salmon of Doubt: Hitchhiking the Galaxy One Last Time | edition=First UK hardcover | publisher=Macmillan | year=2002 | pages=90–1 | isbn=0-333-76657-1}}</ref>\n\nAdams was a Macintosh user from the time they first came out in 1984 until his death in 2001. He was the first person to buy a Mac in Europe (the second being [[Stephen Fry]] – though some accounts differ on this, saying Fry bought his Mac first. Fry claims he was second to Adams<ref>{{cite web|url=https://www.youtube.com/watch?v=gx6WPQkhUXI |title=Craig Ferguson 23 February, 2010B Late Late show Stephen Fry PT2 |publisher=YouTube |date=21 June 2010 |accessdate=27 July 2011}}</ref>). Adams was also an \"[[AppleMasters|Apple Master]]\", one of several celebrities whom Apple made into spokespeople for its products (other Apple Masters included [[John Cleese]] and [[Gregory Hines]]). Adams's contributions included a rock video that he created using the first version of [[iMovie]] with footage featuring his daughter Polly. The video was available on Adams's [[.Mac]] homepage. Adams installed and started using the first release of [[Mac OS X]] in the weeks leading up to his death. His very last post to his own forum was in praise of Mac OS X and the possibilities of its [[Cocoa (API)|Cocoa]] programming framework. He said it was \"awesome...\", which was also the last word he wrote on his site.<ref>{{cite web|url=http://www.douglasadams.com/cgi-bin/mboard/info/dnathread.cgi?2922,1 |title=Adams's final post on his forums at |publisher=Douglasadams.com |accessdate=1 June 2009}}</ref>\n\nAdams used e-mail extensively long before it reached popular awareness, using it to correspond with [[Steve Meretzky]] during the pair's collaboration on Infocom's version of ''[[The Hitchhiker's Guide to the Galaxy (computer game)|The Hitchhiker's Guide to the Galaxy]]''.<ref name=\"Simpson_184-185\"/> While living in New Mexico in 1993 he set up another e-mail address and began posting to his own [[USENET]] newsgroup, alt.fan.douglas-adams, and occasionally, when his computer was acting up, to the comp.sys.mac hierarchy.<ref>{{cite web|url=https://groups.google.com/group/alt.fan.douglas-adams |title=Discussions – alt.fan.douglas-adams &#124; Google Groups |publisher=Google |accessdate=11 March 2013}}</ref> Many of his posts are now archived through Google. Challenges to the authenticity of his messages later led Adams to set up a message forum on his own website to avoid the issue. In 1996, Adams was a keynote speaker at The [[Microsoft]] [[Professional Developers Conference]] (PDC) where he described the personal computer as being a modelling device. The video of his keynote speech is archived on [[Channel 9 (discussion forum)|Channel 9]].<ref>{{cite web |last = Adams |first = Douglas |title = PDC 1996 Keynote with Douglas Adams |work=[[channel9.msdn.com]] |publisher=Channel 9 |date = 15 May 2001 |url = http://channel9.msdn.com/Events/PDC/PDC-1996/PDC-1996-Keynote-with-Douglas-Adams |accessdate =22 March 2013}}</ref>\nAdams was also a keynote speaker for the April 2001 [[Embedded Systems Conference#ESC Silicon Valley|Embedded Systems Conference]] in San Francisco, one of the major technical conferences on [[embedded system]] engineering. In his keynote speech, he shared his vision of technology and how it should contribute in everyday – and every man's – life.<ref>{{cite web |last = Cassel |first = David |title = So long, Douglas Adams, and thanks for all the fun |work=[[Salon (website)|Salon]] |publisher=Salon Media Group |date = 15 May 2001 |url = http://archive.salon.com/tech/feature/2001/05/15/douglas_adams/index.html |accessdate =10 July 2009}}</ref>\n\n==Personal life==\nAdams moved to [[Upper Street]], [[Islington]], in 1981<ref name=\"IPP\" /> and to Duncan Terrace, a few minutes' walk away, in the late 1980s.<ref name=\"IPP\" />\n\nIn the early 1980s Adams had an affair with novelist [[Sally Emerson]], who was separated from her husband at that time. Adams later dedicated his book ''[[Life, the Universe and Everything]]'' to Emerson. In 1981 Emerson returned to her husband, [[Peter Stothard]], a contemporary of Adams's at [[Brentwood School (England)|Brentwood School]], and later editor of ''[[The Times]]''. Adams was soon introduced by friends to Jane Belson, with whom he later became romantically involved. Belson was the \"lady barrister\" mentioned in the jacket-flap biography printed in his books during the mid-1980s (\"He [Adams] lives in Islington with a lady barrister and an Apple Macintosh\"). The two lived in Los Angeles together during 1983 while Adams worked on an early screenplay adaptation of ''Hitchhiker's''. When the deal fell through, they moved back to London, and after several separations (\"He is currently not certain where he lives, or with whom\")<ref name=sfweekly>{{cite web|last=Bowers |first=Keith |title=Big Three |url=http://www.sfweekly.com/2011-07-06/calendar/big-three/ |work=SF Weekly |accessdate=8 December 2011 |archiveurl=http://www.webcitation.org/63mSWp8yr?url=http%3A%2F%2Fwww.sfweekly.com%2F2011-07-06%2Fcalendar%2Fbig-three%2F |archivedate=8 December 2011 |deadurl=no |date=6 July 2011 |df=dmy }}</ref> and an aborted engagement, they married on 25 November 1991. Adams and Belson had one daughter together, Polly Jane Rocket Adams, born on 22 June 1994, shortly after Adams turned 42. In 1999 the family moved from London to [[Santa Barbara, California]], where they lived until his death. Following the funeral, Jane Belson and Polly Adams returned to London.<ref>Webb, Chapter 10.</ref> Jane died on 7 September 2011 of cancer, aged 59.<ref name=timesobit>{{cite web|title=Obituary & Guest Book Preview for Jane Elizabeth BELSON|url=http://announcements.thetimes.co.uk/obituaries/timesonline-uk/obituary.aspx?page=lifestory&pid=153521790|work=The Times|accessdate=8 December 2011|archiveurl=http://www.webcitation.org/63mSoMnJe|archivedate=8 December 2011|deadurl=no|date=9 September 2011}}</ref><ref name=h2g2obit>{{cite web|title=Jane Belson, Douglas Adams's widow, passed away|url=http://lifednah2g2.blogspot.com/2011/09/jane-belson-douglas-adams-widow-passed.html|work=h2g2|accessdate=9 July 2013}}</ref>\n\n==Death and legacy==\n[[File:Highgate Cemetery - East - Douglas Adams 01.jpg|thumb|Adams's gravestone, [[Highgate Cemetery]], North London]]\nAdams died of a [[heart attack]] on 11 May 2001, aged 49, after resting from his regular workout at a private gym in [[Montecito, California]]. He had unknowingly suffered a gradual narrowing of the [[coronary arteries]], which led at that moment to a [[myocardial infarction]] and a fatal [[cardiac arrhythmia]].{{cn|date=October 2016}} Adams had been due to deliver the commencement address at [[Harvey Mudd College]] on 13 May.<ref>{{cite web|url=http://www.laweekly.com/2001-05-24/news/lots-of-screamingly-funny-sentences-no-fish/ |title=Lots of Screamingly Funny Sentences. No Fish. – page 1 |last1=Lewis |first1=Judith |last2=Shulman |first2=Dave |publisher=LA Weekly |date=24 May 2001 |accessdate=20 August 2009 |archiveurl=http://www.webcitation.org/63mQ1aCJQ?url=http%3A%2F%2Fwww.laweekly.com%2F2001-05-24%2Fnews%2Flots-of-screamingly-funny-sentences-no-fish%2F |archivedate=24 May 2001 |deadurl=no |df=dmy }}</ref> His funeral was held on 16 May in Santa Barbara, California. His remains were subsequently cremated and the ashes placed in [[Highgate Cemetery]] in north London in June 2002.<ref name=Simpson_337-338>{{Harvnb|Simpson|2003|pp=337–338}}</ref>\n\nA memorial service was held on 17 September 2001 at [[St Martin-in-the-Fields]] church, [[Trafalgar Square]], London. This became the first church service broadcast live on the web by the BBC.<ref>Gaiman, 204.</ref> Video clips of the service are still available on the BBC's website for download.<ref>{{cite web|url=http://www.bbc.co.uk/cult/hitchhikers/celebration/ |title=BBC Online – Cult – Hitchhiker's – Douglas Adams – Service of Celebration |publisher=BBC |date=17 September 2001 |accessdate=11 March 2013}}</ref>\n\nOne of his last public appearances was a talk given at the University of California, Santa Barbara, ''Parrots, the universe and everything'', recorded days before his death.<ref>{{cite web|url=https://www.youtube.com/watch?v=_ZG8HBuDjgc |title=Parrots, the universe and everything, recorded May 2001 |publisher=YouTube |accessdate=11 March 2013}}</ref> A full transcript of the talk is available, and the university has made the full video available on [https://www.youtube.com/watch?v=_ZG8HBuDjgc YouTube].<ref>{{cite web|url=http://navarroj.com/parrots |title=Transcript of \"Parrots, the Universe and Everything\" |publisher=Navarroj.com |accessdate=27 July 2011}}</ref>\n\nThe [[Minor Planet Centre]] space agency named an asteroid [[18610 Arthurdent]], coincidentally announcing its plan two days before Adams died.<ref name=MPC42677>{{Citation | publication-date = 9 May 2001 | title = New Names of Minor Planets | periodical = [[Minor Planet Circular]] | publication-place = Cambridge, Mass | publisher=[[Minor Planet Center]] | issue = MPC 42677 | url = http://www.minorplanetcenter.net/iau/ECS/MPCArchive/2001/MPC_20010509.pdf | issn = 0736-6884 }}</ref> There is also an [[25924 Douglasadams|asteroid named after Adams himself]].<ref>[http://www.msnbc.msn.com/id/6867061/ Asteroid named after 'Hitchhiker' humorist: Late British sci-fi author honored after cosmic campaign] by Alan Boyle, MSNBC, 25 January 2005</ref>\n\nIn May 2002 ''[[The Salmon of Doubt]]'' was published, containing many short stories, essays, and letters, as well as eulogies from [[Richard Dawkins]], [[Stephen Fry]] (in the UK edition), [[Christopher Cerf]] (in the US edition), and [[Terry Jones]] (in the US paperback edition). It also includes eleven chapters of his long-awaited but unfinished novel, ''The Salmon of Doubt'', which was originally intended to become a new [[Dirk Gently]] novel, but might have later become the sixth ''Hitchhiker'' novel.<ref>\n{{cite news\n|url=http://www.independent.co.uk/arts-entertainment/books/reviews/the-salmon-of-doubt-by-douglas-adams-650803.html\n|title=The Salmon of Doubt by Douglas Adams\n|work=The Independent |location=London\n|accessdate=2 August 2009\n|last=Murray\n|first=Charles Shaar\n| date=10 May 2002\n}}\n</ref><ref>\n{{cite news\n|url=http://www.independent.co.uk/arts-entertainment/books/features/cover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html\n|title=Cover Stories: Douglas Adams, Narnia Chronicles, Something like a House\n|work=The Independent |location=London\n|accessdate=2 August 2009\n|author=The Literator\n| date=5 January 2002|archiveurl=https://web.archive.org/web/20090801062359/http://www.independent.co.uk/arts-entertainment/books/features/cover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html|archivedate=1 August 2009 }}\n</ref>\n\nOther events after Adams's death included a [[webcast]] production of ''[[Shada]]'', allowing the complete story to be told, radio dramatisations of the final three books in the ''Hitchhiker's'' series, and the completion of [[The Hitchhiker's Guide to the Galaxy (film)|the film adaptation]] of ''[[The Hitchhiker's Guide to the Galaxy (book)|The Hitchhiker's Guide to the Galaxy]]''. The film, released in 2005, posthumously credits Adams as a producer, and several art design elements – including a head-shaped planet seen near the end of the film – incorporated Adams's features.\n\nA 12-part radio series based on the [[Dirk Gently]] novels was announced in 2007, with annual transmissions starting in October.<ref>{{cite web |url=http://www.dirkmaggs.dswilliams.co.uk/Dirk%20Maggs%20News%20%20new%20projects.htm |title=Dirk Maggs News and New Projects page }}{{dead link|date=June 2016|bot=medic}}{{cbignore|bot=medic}}</ref>\n\nBBC Radio 4 also commissioned a third Dirk Gently radio series based on the incomplete chapters of ''The Salmon of Doubt'', and written by [[Kim Fuller]];<ref>{{cite web|author=Matthew Hemley |url=http://www.thestage.co.uk/news/newsstory.php/24312/douglas-adams-final-dirk-gently-novel-to-be |title=The Stage / News / Douglas Adams's final Dirk Gently novel to be adapted for Radio 4 |work=The Stage |date=5 May 2009 |accessdate=20 August 2009}}</ref> but this was dropped in favour of a BBC TV series based on the two completed novels.<ref>{{cite web|url=http://www.chortle.co.uk/news/2009/10/11/9767/bbc_plans_dirk_gently_tv_series|title=BBC plans Dirk Gently TV series|publisher=Chortle.co.uk|date=11 October 2009|accessdate=11 October 2009}}</ref> A sixth ''Hitchhiker'' novel, ''[[And Another Thing... (novel)|And Another Thing...]]'', by ''[[Artemis Fowl (series)|Artemis Fowl]]'' author [[Eoin Colfer]], was released on 12 October 2009 (the 30th anniversary of the first book), published with the full support of Adams's estate. A [[BBC Radio 4]] ''[[Book at Bedtime]]'' adaptation and an audio book soon followed.\n\nOn 25 May 2001, two weeks after Adams's death, his fans organised a tribute known as [[Towel Day]], which has been observed every year since then.\n\nIn 2011, over 3,000 people took part in a public vote to choose the subjects of [[Blue plaque|People's Plaques]] in Islington;<ref name=\"IPP\">{{cite web|url=http://www.islington.gov.uk/Leisure/heritage/heritage_borough/bor_plaques/peoplesplaques.asp |title=Islington People's Plaques |date=25 July 2011 |accessdate=13 August 2011 |deadurl=yes |archiveurl=https://web.archive.org/web/20120318001614/http://www.islington.gov.uk/Leisure/heritage/heritage_borough/bor_plaques/peoplesplaques.asp |archivedate=18 March 2012 }}</ref> Adams received 489 votes.\n\nOn 11 March 2013, Adams's 61st birthday was celebrated with an interactive [[Google Doodle]].<ref name=GoogleDoodle2013a>{{cite news|title=Don't Panic! Google Doodle Honors Author Douglas Adams|url=http://abcnews.go.com/blogs/technology/2013/03/dont-panic-google-doodle-honors-author-douglas-adams/|accessdate=11 March 2013|newspaper=abc News|date=11 March 2013}}</ref><ref>{{cite web|title=Douglas Adams' 61st Birthday|url=http://www.google.com/doodles/douglas-adams-61st-birthday|accessdate=11 March 2013}}</ref>\n\n==Awards and nominations==\n{| class=\"wikitable\" style=\"font-size:90%\"\n|- style=\"text-align:center;\"\n! style=\"background:#B0C4DE;\" | Year\n! style=\"background:#B0C4DE;\" | Award\n! style=\"background:#B0C4DE;\" | Work\n! style=\"background:#B0C4DE;\" | Category\n! style=\"background:#B0C4DE;\" | Result\n! style=\"background:#B0C4DE;\" | Reference\n|-\n|1979\n|[[Hugo Award]]\n|''[[The Hitchhiker's Guide to the Galaxy (radio series)|The Hitchhiker's Guide to the Galaxy]]''<small>(shared with [[Geoffrey Perkins]])</small>\n|[[Hugo Award for Best Dramatic Presentation|Best Dramatic Presentation]]\n|{{nom}}\n|\n|}\n\n==Works==\n{{Refbegin|20em}}\n* ''[[The Private Life of Genghis Khan]]'' (1975), based on a comedy sketch Adams co-wrote with [[Graham Chapman]] (short story)\n* ''[[The Hitchhiker's Guide to the Galaxy (radio series)|The Hitchhiker's Guide to the Galaxy]]'' (1978) (radio series)\n* ''[[The Hitchhiker's Guide to the Galaxy (book)|The Hitchhiker's Guide to the Galaxy]]'' (1979) (novel)\n* ''[[Shada]]'' (1979–1980), a Doctor Who serial\n* ''[[The Restaurant at the End of the Universe]]'' (1980) (novel)\n* ''[[Life, the Universe and Everything]]'' (1982) (novel)\n* ''[[The Meaning of Liff]]'' (1983 (book), with [[John Lloyd (producer)|John Lloyd]])\n* ''[[So Long, and Thanks for All the Fish]]'' (1984) (novel)\n* ''[[The Hitchhiker's Guide to the Galaxy (computer game)|The Hitchhiker's Guide to the Galaxy]]'' (1984, with [[Steve Meretzky]]) (computer game)\n* ''[[The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts]]'' (1985, with [[Geoffrey Perkins]])\n* ''[[Young Zaphod Plays It Safe]] (short story)'' (1986)\n* ''[[A Christmas Fairly Story]]'' {{sic}} (1986, with [[Terry Jones]]), and\n* ''Supplement to The Meaning of Liff'' (1986, with [[John Lloyd (producer)|John Lloyd]] and [[Stephen Fry]]), both part of\n** ''[[The Utterly Utterly Merry Comic Relief Christmas Book]]'' (1986, edited with [[Peter Fincham]])\n* ''[[Bureaucracy (computer game)|Bureaucracy]]'' (1987) (computer game)\n* ''[[Dirk Gently's Holistic Detective Agency]]'' (1987) (novel)\n* ''[[The Long Dark Tea-Time of the Soul]]'' (1988) (novel)\n* ''[[The Deeper Meaning of Liff]]'' (1990, with [[John Lloyd (producer)|John Lloyd]])\n* ''[[Last Chance to See]]'' (1990, with [[Mark Carwardine]]) (book)\n* ''[[Mostly Harmless]]'' (1992) (novel)\n* ''[[The Hitchhiker's Guide to the Galaxy (book)#Illustrated edition|The Illustrated Hitchhiker's Guide to the Galaxy]]'' (1994)\n* ''[[Douglas Adams's Starship Titanic]]'' (1997), written by [[Terry Jones]], based on an idea by Adams\n* ''[[Starship Titanic]]'' (computer game) (1998)\n* ''[[h2g2]]'' (internet project) (1999)\n* ''The Internet: The Last Battleground of the 20th century'' (radio series) (2000)\n* ''[[The Hitchhiker's Guide to the Future]]'' (radio series) (2001) final project for [[BBC Radio 4]] before his death\n* ''[https://www.youtube.com/watch?v=_ZG8HBuDjgc Parrots, the universe and everything]'' (2001)\n* ''[[The Salmon of Doubt]]'' (2002), unfinished novel manuscript (11 chapters), short stories, essays, and interviews (also available as an audiobook, read by [[Simon Jones (actor)|Simon Jones]])\n*  ''[[The Hitchhiker's Guide to the Galaxy (film)|The Hitchhiker's Guide to the Galaxy]]'' (2005) (film)\n{{Refend}}\n\n==Writing credits==\n{| class=\"wikitable\"\n|-  style=\"background:#ccc; text-align:center;\"\n! Production\n! Notes\n! Broadcaster\n|-\n|''[[Monty Python's Flying Circus]]''\n|\n*\"[[List of Monty Python's Flying Circus episodes#6. Party Political Broadcast|Party Political Broadcast on Behalf of the Liberal Party]]\" (1974)\n|[[BBC Two]]\n|-\n|''[[Out of the Trees]]''\n|\n*Television pilot (1976)\n|BBC Two\n|-\n|''[[Doctor on the Go]]''\n|\n*\"For Your Own Good\" (1977)\n|[[ITV (TV network)|ITV]]\n|-\n|''[[Doctor Who]]''\n|\n5 episodes (1978-1979, 1983): \n*\"[[The Pirate Planet]]\" (1978)\n*\"[[Destiny of the Daleks]]\" (1979) (uncredited)\n*\"[[City of Death]]\" (co-written with [[Graham Williams (television producer)|Graham Williams]], 1979)\n*\"[[The Five Doctors]]\" (1983) ([[Shada]] segments; uncredited)\n|[[BBC One]]\n|-\n|''[[Doctor Snuggles]]''\n|\n*\"The Great Disappearing Mystery\" (1979)\n*\"The Remarkable Fidgety River\" (1979)\n|ITV\n|-\n|''[[Not the Nine O'Clock News]]''\n|\n*Unknown episodes (1979)\n|BBC Two\n|-\n|''[[The Hitchhiker's Guide to the Galaxy (TV series)|The Hitchhiker's Guide to the Galaxy]]''\n|\n*6 episodes (1981)\n|BBC Two\n|-\n|''[[Hyperland]]''\n|\n*Television documentary (1990)\n|BBC Two\n|}\n\n==Notes==\n{{reflist|30em}}\n\n==References==\n* Adams, Douglas (1998). [http://www.biota.org/people/douglasadams/ Is there an Artificial God?], speech at ''Digital Biota 2'', Cambridge, England, September 1998.\n* {{cite book|last=Adams|first=Douglas|title=The Salmon of Doubt: Hitchhiking the Galaxy One Last Time|year=2002|publisher=Macmillan|location=London|isbn=0-333-76657-1|ref=harv}}\n* Dawkins, Richard (2003). \"Eulogy for Douglas Adams,\" in ''A devil's chaplain: reflections on hope, lies, science, and love''. Houghton Mifflin Harcourt.\n* Felch, Laura (2004). [http://www.bookslut.com/nonfiction/2004_05_002057.php Don't Panic: Douglas Adams and the Hitchhiker's Guide to the Galaxy by Neil Gaiman], May 2004\n* Ray, Mohit K (2007). ''Atlantic Companion to Literature in English'', Atlantic Publishers and Distributors. ISBN 81-269-0832-7\n* {{cite book|last=Simpson|first=M. J.|title=[[Hitchhiker: A Biography of Douglas Adams]]|year=2003|publisher=Justin, Charles & Co|location=Boston, Mass.|isbn=1-932112-17-0|edition=1st|ref=harv}}\n* Webb, Nick (2005a). ''Wish You Were Here: The Official Biography of Douglas Adams''. Ballantine Books. ISBN 0-345-47650-6\n* Webb, Nick (2005b). [http://www.oxforddnb.com/view/article/75853 \"Adams, Douglas Noël (1952–2001)\"], ''Oxford Dictionary of National Biography'', Oxford University Press, January 2005. Retrieved 25 October 2005.\n\n==Further reading==\n===Articles===\n{{Refbegin|30em}}\n* Herbert, R. (1980). The Hitchhiker's Guide to the Galaxy (Book Review). Library Journal, 105(16), 1982.\n* Adams, J., & Brown, R. (1981). The Hitchhiker's Guide to the Galaxy (Book Review). School Library Journal, 27(5), 74.\n* Nickerson, S. L. (1982). The Restaurant at the End of the Universe (Book). Library Journal, 107(4), 476.\n* Nickerson, S. L. (1982). Life, the Universe, and Everything (Book). Library Journal, 107(18), 2007.\n* Morner, C. (1982). The Restaurant at the End of the Universe (Book Review). School Library Journal, 28(8), 87.\n* Morner, C. (1983). Life, the Universe and Everything (Book Review). School Library Journal, 29(6), 93.\n* Shorb, B. (1985). So Long, and Thanks for All the Fish (Book). School Library Journal, 31(6), 90.\n* The Long Dark Tea-Time of the Soul (Book). (1989). Atlantic (02769077), 263(4), 99.\n* Hoffert, B., & Quinn, J. (1990). Last Chance To See (Book). Library Journal, 115(16), 77.\n* Reed, S. S., & Cook, I. I. (1991). Dances with kakapos. People, 35(19), 79.\n* Last Chance to See (Book). (1991). Science News, 139(8), 126.\n* Field, M. M., & Steinberg, S. S. (1991). Douglas Adams. Publishers Weekly, 238(6), 62.\n* Dieter, W. (1991). Last Chance to See (Book). Smithsonian, 22(3), 140.\n* Dykhuis, R. (1991). Last Chance To See (Book). Library Journal, 116(1), 140.\n* Beatty, J. (1991). Good Show (Book). Atlantic (02769077), 267(3), 131.\n* A guide to the future. (1992). Maclean's, 106(44), 51.\n* Zinsser, J. (1993). Audio reviews: Fiction. Publishers Weekly, 240(9), 24.\n* Taylor, B., & Annichiarico, M. (1993). Audio reviews. Library Journal, 118(2), 132.\n* Good reads. (1995). NetGuide, 2(4), 109.\n* Stone, B. (1998). The unsinkable starship. Newsweek, 131(15), 78.\n* Gaslin, G. (2001). Galaxy Quest. Entertainment Weekly, (599), 79.\n* So long, and thanks for all the fish. (2001). Economist, 359(8222), 79.\n* Geier, T., & Raftery, B. M. (2001). Legacy. Entertainment Weekly, (597), 11.\n* Passages. (2001). Maclean's, 114(21), 13.\n* Don't panic! Douglas Adams to keynote Embedded show. (2001). Embedded Systems Programming, 14(3), 10.\n* Ehrenman, G. (2001). World Wide Weird. InternetWeek, (862), 15.\n* Zaleski, J. (2002). The Salmon of Doubt (Book). Publishers Weekly, 249(15), 43.\n* Mort, J. (2002). The Salmon of Doubt (Book). Booklist, 98(16), 1386.\n* Lewis, D. L. (2002). Last Time Round The Galaxy. Quadrant Magazine, 46(9), 84.\n* Burns, A. (2002). The Salmon of Doubt (Book). Library Journal, 127(15), 111.\n* Burns, A., & Rhodes, B. (2002). The Restaurant at the End of the Universe (Book). Library Journal, 127(19), 118.\n* Kaveney, R. (2002). A cheerful whale. TLS, (5173), 23.\n* Pearl, N., & Welch, R. (2003). The Hitchhiker's Guide To The Galaxy (Book). Library Journal, 128(11), 124.\n* Preying on composite materials. (2003). R&D Magazine, 45(6), 44.\n* Webb, N. (2003). The Berkeley Hotel hostage. Bookseller, (5069), 25.\n* The author who toured the universe. (2003). Bookseller, (5060), 35.\n* Osmond, A. (2005). Only human. Sight & Sound, 15(5), 12–15.\n* Culture vulture. (2005). Times Educational Supplement, (4640), 19.\n* Maughan, S. (2005). Audio Bestsellers/Fiction. Publishers Weekly, 252(30), 17.\n* Hitchhiker At The Science Museum. (2005). In Britain, 14(10), 9.\n* Rea, A. (2005). The Adams asteroids. New Scientist, 185(2488), 31.\n* Most Improbable Adventure. (2005). Popular Mechanics, 182(5), 32.\n* The Hitchhiker's Guide To The Galaxy: The Tertiary Phase. (2005). Publishers Weekly, 252(14), 21.\n* Bartelt, K. R. (2005). Wish You Were Here: The Official Biography of Douglas Adams. Library Journal, 130(4), 86.\n* Larsen, D. (2005). I was a teenage android. New Zealand Listener, 198(3390), 37–38.\n* Tanner, J. C. (2005). Simplicity: it's hard. Telecom Asia, 16(6), 6.\n* Nielsen Bookscan Charts. (2005). Bookseller, (5175), 18–21.\n* Buena Vista launches regional site to push Hitchhiker's movie. (2005). New Media Age, 9.\n* Shynola bring Beckland to life. (2005). Creative Review, 25(3), 24–26.\n* Carwardine, M. (15 September 2007). The baiji: So long and thanks for all the fish. New Scientist. pp.&nbsp;50–53.\n* Czarniawska, B. (2008). Accounting and gender across times and places: An excursion into fiction. Accounting, Organizations & Society, 33(1), 33–47.\n* Pope, M. (2008). Life, the Universe, Religion and Science. Issues, (82), 31–34.\n* Bearne, S. (2008). BBC builds site to trail Last Chance To See TV series. New Media Age, 08.\n* Arrow to reissue Adams. (2008). Bookseller, (5352), 14.\n* Page, B. (2008). Colfer is new Hitchhiker. Bookseller, (5350), 7.\n* I've got a perfect puzzle for you. (2009). Bookseller, (5404), 42.\n* Mostly Harmless.... (2009). Bookseller, (5374), 46.\n* Penguin and PanMac hitch a ride together. (2009). Bookseller, (5373), 6.\n* Adams, Douglas. Britannica Biographies [serial online]. October 2010;:1\n* Douglas (Noël) Adams (1952–2001). Hutchinson's Biography Database [serial online]. July 2011;:1\n* My life in books. (2011). Times Educational Supplement, (4940), 27.\n{{Refend}}\n\n===Other===\n* {{Wayback |df=yes|date=20110720193159 |url=http://www.douglasadams.com/ |title=Adams's official web site }}, established by him, and still operated by [[The Digital Village]]\n* {{TED speaker|douglas_adams}}\n* [http://www.biota.org/people/douglasadams/ Douglas Adams speech at Digital Biota 2 (1998)] [http://www.biota.org/podcast/#DNA (The audio of the speech)]\n* [http://www.guardian.co.uk/books/2008/jun/09/douglasadams Guardian Books \"Author Page\"], with profile and links to further articles.\n* {{Worldcat id|id=lccn-n80-76765}}\n* [http://www.vintagemacworld.com/iifx.html Douglas Adams & his Computer] article about his Mac IIfx\n* BBC2 \"Omnibus\" tribute to Adams, presented by Kirsty Wark, 4 August 2001\n* Mueller, Rick and Greengrass, Joel (2002). ''Life, The Universe and Douglas Adams'', documentary.\n* Simpson, M.J. (2001). ''The Pocket Essential Hitchhiker's Guide''. ISBN 1-903047-40-4. Updated April 2005 ISBN 1-904048-46-3\n* [http://www.bbc.co.uk/programmes/p00fpvbm Special edition of BBC Book Club featuring Douglas Adams], first broadcast 2 January 2000 on BBC Radio 4\n\n==External links==\n{{Library resources box\n |by=yes\n |viaf=113230702\n |label=Douglas Adams}}\n{{Spoken Wikipedia-2|2006-02-11|Douglas_Adams_Part_1.ogg|Douglas_Adams_Part_2.ogg}}\n* {{Commons category-inline}}\n* {{Wikiquote-inline}}\n* {{Find a Grave|22814}}\n* {{IMDb name|0010930}}\n* [http://towelday.org/ Towel Day, 25 May]\n\n{{s-start}}\n{{s-bef|before= [[Anthony Read]]}} \n{{s-ttl|title=''[[Doctor Who]]'' script editor|years=1979–80}} \n{{s-aft|after= [[Christopher H. Bidmead]]}}\n{{s-end}}\n{{Douglas Adams}}\n{{HitchhikerBooks}}\n{{Dirk Gently}}\n{{Doctor Who}}\n{{Infocom games}}\n{{animal rights|state=collapsed}}\n\n{{Authority control}}\n\n{{DEFAULTSORT:Adams, Douglas}}\n[[Category:Douglas Adams| ]]\n[[Category:1952 births]]\n[[Category:2001 deaths]]\n[[Category:Alumni of St John's College, Cambridge]]\n[[Category:Animal rights advocates]]\n[[Category:Atheism activists]]\n[[Category:Audio book narrators]]\n[[Category:British social commentators]]\n[[Category:BBC radio producers]]\n[[Category:British child writers]]\n[[Category:Burials at Highgate Cemetery]]\n[[Category:English atheists]]\n[[Category:English comedy writers]]\n[[Category:English humanists]]\n[[Category:English humorists]]\n[[Category:English radio writers]]\n[[Category:English science fiction writers]]\n[[Category:English television writers]]\n[[Category:Infocom]]\n[[Category:Interactive fiction writers]]\n[[Category:Monty Python]]\n[[Category:Non-fiction environmental writers]]\n[[Category:People educated at Brentwood School (Essex)]]\n[[Category:People from Cambridge]]\n[[Category:Usenet people]]\n[[Category:Critics of religions]]\n[[Category:20th-century English novelists]]\n[[Category:21st-century British novelists]]",
    "properties": {
      "defaultsort": "Adams, Douglas",
      "wikibase_item": "Q42"
    },
    "parsetree": "<root><template><title>other people</title></template>\n<template lineStart=\"1\"><title>Use British English</title><part><name>date</name><equals>=</equals><value>October 2013</value></part></template>\n<template lineStart=\"1\"><title>Use dmy dates</title><part><name>date</name><equals>=</equals><value>April 2015</value></part></template>\n<template lineStart=\"1\"><title>Infobox writer <comment>&lt;!-- for more information see [[:Template:Infobox writer/doc]] --&gt;</comment>\n</title><part><name> name          </name><equals>=</equals><value> Douglas Adams\n</value></part><part><name> image         </name><equals>=</equals><value> Douglas adams portrait cropped.jpg\n</value></part><part><name> caption       </name><equals>=</equals><value>\n</value></part><part><name> birth_name    </name><equals>=</equals><value> Douglas Noel Adams\n</value></part><part><name> birth_date    </name><equals>=</equals><value> <template><title>birth date</title><part><name index=\"1\"/><value>1952</value></part><part><name index=\"2\"/><value>3</value></part><part><name index=\"3\"/><value>11</value></part><part><name>df</name><equals>=</equals><value>yes</value></part></template>\n</value></part><part><name> birth_place   </name><equals>=</equals><value> [[Cambridge]], England\n</value></part><part><name> height        </name><equals>=</equals><value> <template><title>height</title><part><name>ft</name><equals>=</equals><value>6</value></part><part><name>in</name><equals>=</equals><value>5</value></part></template>\n</value></part><part><name> death_date    </name><equals>=</equals><value> <template><title>Death date and age</title><part><name index=\"1\"/><value>2001</value></part><part><name index=\"2\"/><value>5</value></part><part><name index=\"3\"/><value>11</value></part><part><name index=\"4\"/><value>1952</value></part><part><name index=\"5\"/><value>3</value></part><part><name index=\"6\"/><value>11</value></part><part><name>df</name><equals>=</equals><value>yes</value></part></template>\n</value></part><part><name> death_place   </name><equals>=</equals><value> [[Montecito, California]], U.S.\n</value></part><part><name> resting_place </name><equals>=</equals><value> [[Highgate Cemetery]], London, England\n</value></part><part><name> alma_mater    </name><equals>=</equals><value> [[St John's College, Cambridge]]\n</value></part><part><name> occupation    </name><equals>=</equals><value> Writer\n</value></part><part><name> genre         </name><equals>=</equals><value> Science fiction, comedy, satire\n</value></part><part><name> movement </name><equals>=</equals><value>\n</value></part><part><name> website       </name><equals>=</equals><value> <template><title>URL</title><part><name index=\"1\"/><value>douglasadams.com/</value></part></template>\n</value></part></template>\n<comment>&lt;!-- Do *not* change spelling of &quot;Hitchhiker's&quot;; see talk page for details --&gt;\n</comment><comment>&lt;!-- Please do *not* change spelling of &quot;Noel&quot;. There is no 'ë'. Any citations have themselves been taken from an earlier, incorrect edit of Wikipedia; see talk page for details --&gt;\n</comment>'''Douglas Noel Adams''' (11 March 1952 – 11 May 2001) was an [[English people|English]] [[author]], [[scriptwriter]], [[essayist]], [[List of humorists|humourist]], [[satirist]] and [[dramatist]].\n\nAdams is best known as the author of ''[[The Hitchhiker's Guide to the Galaxy]]'', which originated in 1978 as a BBC [[The Hitchhiker's Guide to the Galaxy (radio series)|radio comedy]] before developing into a &quot;trilogy&quot; of five books that sold more than 15&amp;nbsp;million copies in his lifetime and generated a [[The Hitchhiker's Guide to the Galaxy (TV series)|television series]], several stage plays, comics, a [[The Hitchhiker's Guide to the Galaxy (computer game)|computer game]], and in 2005 a [[The Hitchhiker's Guide to the Galaxy (film)|feature film]]. Adams's contribution to UK radio is commemorated in [[Radio Academy|The Radio Academy]]'s Hall of Fame.<ext><name>ref</name><attr> name=&quot;radioacad&quot;</attr><inner>{{cite web|title=The Radio Academy Hall of Fame |url=http://www.radioacademy.org/hall-of-fame |work=The Radio Academy |accessdate=8 December 2011 |archiveurl=http://www.webcitation.org/63mNGrql2?url=http%3A%2F%2Fwww.radioacademy.org%2Fhall-of-fame%2F |archivedate=8 December 2011 |deadurl=no |df=dmy }}</inner><close>&lt;/ref&gt;</close></ext>\n\nAdams also wrote ''[[Dirk Gently's Holistic Detective Agency]]'' (1987) and ''[[The Long Dark Tea-Time of the Soul]]'' (1988), and co-wrote ''[[The Meaning of Liff]]'' (1983), ''[[The Deeper Meaning of Liff]]'' (1990), ''[[Last Chance to See]]'' (1990), and three stories for the television series ''[[Doctor Who]]''; he also served as [[script editor]] for the show's seventeenth season in 1979. A posthumous collection of his works, including an unfinished novel, was published as ''[[The Salmon of Doubt]]'' in 2002.\n\nAdams was known as an advocate for environmentalism and [[conservation movement|conservation]], as a lover of fast cars, cameras, [[technological innovation]] and the [[Apple Macintosh]], and as a &quot;devout [[atheist]]&quot;.\n\n<h level=\"2\" i=\"1\">==Early life==</h>\n<comment>&lt;!-- Please leave this section heading as is, for the chronology of events. Adams's own family (wife and daughter) are discussed later. --&gt;\n</comment>Adams was born on 11 March 1952 to Janet (née Donovan; 1927–2016) and Christopher Douglas Adams (1927–1985) in [[Cambridge]], England.<ext><name>ref</name><attr> name=ODNB </attr><inner>Webb 2005b</inner><close>&lt;/ref&gt;</close></ext> The following year, [[James D. Watson|Watson]] and [[Francis Crick|Crick]] famously first modelled [[DNA]] at [[Cambridge University]], leading Adams to later quip he was DNA in Cambridge months earlier. The family moved to [[East End of London|East London]] a few months after his birth, where his sister, Susan, was born three years later.<ext><name>ref</name><attr> name=Adams_xix</attr><inner>{{Harvnb|Adams|2002|pp=xix}}</inner><close>&lt;/ref&gt;</close></ext> His parents divorced in 1957; Douglas, Susan, and their mother moved to an [[RSPCA]] animal shelter in [[Brentwood, Essex]], run by his maternal grandparents.<ext><name>ref</name><attr/><inner>Webb 2005a, p. 32.</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"3\" i=\"2\">===Education===</h>\nAdams attended Primrose Hill Primary School in [[Brentwood, Essex|Brentwood]]. At nine, he passed the entrance exam for [[Brentwood School (Essex)|Brentwood School]], an independent school whose alumni include [[Robin Day]], [[Jack Straw]], [[Noel Edmonds]], and [[David Irving]]. [[Griff Rhys Jones]] was a year below him, and he was in the same class as [[Stuckism|Stuckist]] artist [[Charles Thomson (artist)|Charles Thomson]]. He attended the [[Preparatory school (UK)|prep school]] from 1959 to 1964, then the main school until December 1970. His form master, Frank Halford, said of him: &quot;Hundreds of boys have passed through the school but Douglas Adams really stood out from the crowd — literally. He was unnecessarily tall and in his short trousers he looked a trifle self-conscious.&quot; &quot;The form-master wouldn't say 'Meet under the clock tower,' or 'Meet under the war memorial',&quot; he joked, &quot;but 'Meet under Adams'.&quot;<ext><name>ref</name><attr> name=Adams_7</attr><inner>{{Harvnb|Adams|2002|pp=7}}</inner><close>&lt;/ref&gt;</close></ext><ext><name>ref</name><attr/><inner>Botti, Nicholas. [http://douglasadams.eu/interview-with-frank-halford/ &quot;Interview with Frank Halford&quot;]. ''Life, DNA, and H2G2.'' 2009. Web. Retrieved 13 March 2012. (Click on link at bottom for facsimile page from ''Daily News'' article, 7 March 1998.)</inner><close>&lt;/ref&gt;</close></ext> Yet it was his ability to write first-class stories that really made him &quot;shine&quot;.<ext><name>ref</name><attr> name=Simpson_9</attr><inner>{{Harvnb|Simpson|2003|pp=9}}</inner><close>&lt;/ref&gt;</close></ext>\n\nAdams was six feet tall (1.83&amp;nbsp;m) by age 12 and stopped growing at 6&amp;nbsp;ft 5&amp;nbsp;in (1.96&amp;nbsp;m). He became the only student ever to be awarded a ten out of ten by Halford for creative writing, something he remembered for the rest of his life, particularly when facing [[writer's block]].<ext><name>ref</name><attr> name=Adams_xix </attr></ext>\n\nSome of his earliest writing was published at the school, such as a report on its photography club in ''The Brentwoodian'' in 1962, or spoof reviews in the school magazine ''Broadsheet'', edited by [[Paul Neil Milne Johnstone]], who later became a character in ''The Hitchhiker's Guide''. He also designed the cover of one issue of the ''Broadsheet'', and had a letter and short story published nationally in ''[[Eagle (comic)|The Eagle]]'', the boys' comic, in 1965. A poem entitled &quot;A Dissertation on the task of writing a poem on a candle and an account of some of the difficulties thereto pertaining&quot; written by Adams in January 1970, at the age of 17, was discovered by archivist Stacey Harmer in a cupboard at the school in early 2014. In it, Adams rhymes &quot;futile&quot; with &quot;mute, while&quot; and &quot;exhausted&quot; with &quot;of course did&quot;.<ext><name>ref</name><attr/><inner>Flood, Alison (March 2014). [http://www.theguardian.com/books/2014/mar/19/lost-school-poems-douglas-adams-griff-rhys-jones &quot;Lost poems of Douglas Adams and Griff Rhys Jones found in school cupboard&quot;], ''The Guardian'', 19 March 2014. Accessed 2 July 2014</inner><close>&lt;/ref&gt;</close></ext> On the strength of a bravura essay on religious poetry that discussed [[the Beatles]] and [[William Blake]], he was awarded an [[Exhibition (scholarship)|Exhibition]] in English at [[St John's College, Cambridge]], going up in 1971. He wanted to join the [[Footlights]], an invitation-only student comedy club that has acted as a hothouse for comic talent. He was not elected immediately as he had hoped, and started to write and perform in revues with Will Adams (no relation) and Martin Smith, forming a group called &quot;Adams-Smith-Adams&quot;, but became a member of the Footlights by 1973.<ext><name>ref</name><attr> name=Simpson_30-40</attr><inner>{{Harvnb|Simpson|2003|pp=30–40}}</inner><close>&lt;/ref&gt;</close></ext> Despite doing very little work—he recalled having completed three essays in three years—he graduated in 1974 with a B.A. in [[English literature]].<ext><name>ref</name><attr> name=ODNB</attr></ext>\n\n<h level=\"2\" i=\"3\">==Career==</h>\n\n<h level=\"3\" i=\"4\">===Writing===</h>\nAfter leaving university Adams moved back to London, determined to break into TV and radio as a writer. An edited version of the ''Footlights Revue'' appeared on [[BBC Two|BBC2]] television in 1974. A version of the Revue performed live in London's [[West End of London|West End]] led to Adams being discovered by [[Monty Python]]'s [[Graham Chapman]]. The two formed a brief writing partnership, earning Adams a writing credit in [[List of Monty Python's Flying Circus episodes#6. Party Political Broadcast|episode 45]] of ''Monty Python'' for a sketch called &quot;[[Patient Abuse]]&quot;. He is one of only two people outside the original Python members to get a writing credit (the other being [[Neil Innes]]).<ext><name>ref</name><attr> name=times</attr><inner>{{cite news|title=Terry Jones remembers Douglas Adams, 'the last of the Pythons'|newspaper=The Times|date=10 October 2009}}</inner><close>&lt;/ref&gt;</close></ext> The sketch plays on the idea of mind-boggling paper work in an emergency, a joke later incorporated into the [[Vogon]]s' obsession with paperwork. Adams also contributed to a sketch on the album for ''[[Monty Python and the Holy Grail]]''.\n\n[[File:DNA in Monty Python.jpg|thumb|Adams in his first ''[[Monty Python's Flying Circus|Monty Python]]'' appearance, in full surgeon's garb]]\n\nAdams had two brief appearances in the fourth series of ''[[Monty Python's Flying Circus]]''. At the beginning of episode 42, &quot;The Light Entertainment War&quot;, Adams is in a surgeon's mask (as Dr. Emile Koning, according to on-screen captions), pulling on gloves, while [[Michael Palin]] narrates a sketch that introduces one person after another but never gets started. At the beginning of episode 44, &quot;Mr. Neutron&quot;, Adams is dressed in a [[List of recurring Monty Python's Flying Circus characters#The Pepperpots|pepper-pot]] outfit and loads a missile onto a cart driven by [[Terry Jones]], who is calling for scrap metal (&quot;Any old iron...&quot;). The two episodes were broadcast in November 1974. Adams and Chapman also attempted non-Python projects, including ''[[Out of the Trees]]''.\n\nAt this point Adams's career stalled; his writing style was unsuited to the then-current style of radio and TV comedy.<ext><name>ref</name><attr> name=ODNB </attr></ext> To make ends meet he took a series of odd jobs, including as a hospital porter, barn builder, and chicken shed cleaner. He was employed as a bodyguard by a Qatari family, who had made their fortune in oil. Anecdotes about that job included that the family had once ordered one of everything from a hotel's menu, tried all the dishes, and sent out for hamburgers. Another story had to do with a prostitute sent to the floor Adams was guarding one evening. They acknowledged each other as she entered, and an hour later, when she left, she is said to have remarked, &quot;At least you can read while you're on the job.&quot;<ext><name>ref</name><attr/><inner>Webb 2005a, p. 93.</inner><close>&lt;/ref&gt;</close></ext>\n\nDuring this time Adams continued to write and submit sketches, though few were accepted. In 1976 his career had a brief improvement when he wrote and performed ''Unpleasantness at Brodie's Close'' at the [[Edinburgh Fringe]] festival. By Christmas work had dried up again, and a depressed Adams moved to live with his mother.<ext><name>ref</name><attr> name=ODNB </attr></ext> The lack of writing work hit him hard and low confidence became a feature of Adams's life; &quot;I have terrible periods of lack of confidence [..] I briefly did therapy, but after a while I realised it was like a farmer complaining about the weather. You can't fix the weather&amp;nbsp;– you just have to get on with it&quot;.<ext><name>ref</name><attr> name=Adams_prologue</attr><inner>{{Harvnb|Adams|2002|pp=prologue}}</inner><close>&lt;/ref&gt;</close></ext>\n\nSome of Adams's early radio work included sketches for ''[[The Burkiss Way]]'' in 1977 and ''[[The News Huddlines]]''.<ext><name>ref</name><attr/><inner>''Hitchhiker: A Biography of Douglas Adams'' by M. J. Simpson, p87</inner><close>&lt;/ref&gt;</close></ext> He also wrote, again with Chapman, 20 February 1977 episode of ''Doctor on the Go'', a sequel to the ''[[Doctor in the House (TV series)|Doctor in the House]]'' television comedy series. After the [[The Hitchhiker's Guide to the Galaxy (radio series)|first radio series of ''The Hitchhiker's Guide'']] became successful, Adams was made a BBC radio producer, working on ''[[Week Ending]]'' and a pantomime called ''[[Black Cinderella Two Goes East]]''.<ext><name>ref</name><attr/><inner>Roberts, Jem. ''The Clue Bible: The Fully Authorised History of I'm Sorry I Haven't A Clue from Footlights to Mornington Crescent'': London, 2009, p164-5</inner><close>&lt;/ref&gt;</close></ext> He left  after six months to become the script editor for ''[[Doctor Who]]''.\n\nIn 1979 Adams and [[John Lloyd (producer)|John Lloyd]] wrote scripts for two half-hour episodes of ''[[Doctor Snuggles]]'': &quot;The Remarkable Fidgety River&quot; and &quot;The Great Disappearing Mystery&quot; (episodes seven and twelve). John Lloyd was also co-author of two episodes from the original ''Hitchhiker'' radio series (&quot;Fit the Fifth&quot; and &quot;Fit the Sixth&quot;, also known as &quot;Episode Five&quot; and &quot;Episode Six&quot;), as well as ''[[The Meaning of Liff]]'' and ''[[The Deeper Meaning of Liff]]''.\n\n<h level=\"4\" i=\"5\">====''The Hitchhiker's Guide to the Galaxy''====</h>\n<template lineStart=\"1\"><title>Main article</title><part><name index=\"1\"/><value>The Hitchhiker's Guide to the Galaxy</value></part></template>\n''The Hitchhiker's Guide to the Galaxy'' was a concept for a science-fiction comedy radio series pitched by Adams and radio producer [[Simon Brett]] to [[BBC Radio 4]] in 1977. Adams came up with an outline for a pilot episode, as well as a few other stories (reprinted in [[Neil Gaiman]]'s book ''[[Don't Panic: The Official Hitchhiker's Guide to the Galaxy Companion]]'') that could potentially be used in the series.\n[[File:Towelday-Innsbruck.jpg|thumb|upright|[[Towel Day]] 2005 in Innsbruck, Austria, where Adams first had the idea of ''The Hitchhiker's Guide''. In the novels a towel is the most useful thing a space traveller can have.  The annual Towel Day (25 May) was first celebrated in 2001, two weeks after Adams's death.]]\n\nAccording to Adams, the idea for the title occurred to him while he lay drunk in a field in [[Innsbruck]], Austria, gazing at the stars. He was carrying a copy of the ''[[Hitch-hiker's Guide to Europe]]'', and it occurred to him that &quot;somebody ought to write a ''Hitchhiker's Guide to the Galaxy''&quot;. He later said that the constant repetition of this anecdote had obliterated his memory of the actual event.<ext><name>ref</name><attr/><inner>{{cite book | author=Adams, Douglas| editor= Geoffrey Perkins (ed.), Additional Material by M. J. Simpson|title=[[The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts]] | page = 10 | edition =25th Anniversary | publisher=Pan Books | year=2003 | isbn=0-330-41957-9}}</inner><close>&lt;/ref&gt;</close></ext>\n\nDespite the original outline, Adams was said to make up the stories as he wrote. He turned to [[John Lloyd (producer)|John Lloyd]] for help with the final two episodes of [[The Hitchhiker's Guide to the Galaxy Primary and Secondary Phases#The Primary Phase|the first series]]. Lloyd contributed bits from an unpublished science fiction book of his own, called ''GiGax''.<ext><name>ref</name><attr/><inner>Webb 2005a, p. 120.</inner><close>&lt;/ref&gt;</close></ext> Very little of Lloyd's material survived in later adaptations of ''Hitchhiker's'', such as the novels and the TV series. The TV series was based on the first six radio episodes, and sections contributed by Lloyd were largely re-written.\n\n[[BBC Radio 4]] broadcast the first radio series weekly in the UK in March and April 1978. The series was distributed in the United States by [[National Public Radio]].  Following the success of the first series, another episode was recorded and broadcast, which was commonly known as the Christmas Episode. [[The Hitchhiker's Guide to the Galaxy Primary and Secondary Phases#The Secondary Phase|A second series]] of five episodes was broadcast one per night, during the week of 21–25 January 1980.\n\nWhile working on the radio series (and with simultaneous projects such as ''[[The Pirate Planet]]'') Adams developed problems keeping to writing deadlines that only got worse as he published novels. Adams was never a prolific writer and usually had to be forced by others to do any writing. This included being locked in a hotel suite with his editor for three weeks to ensure that ''[[So Long, and Thanks for All the Fish]]'' was completed.<ext><name>ref</name><attr/><inner>Felch 2004</inner><close>&lt;/ref&gt;</close></ext> He was quoted as saying, &quot;I love deadlines. I love the whooshing noise they make as they go by.&quot;<ext><name>ref</name><attr> name=Simpson_236</attr><inner>{{Harvnb|Simpson|2003|pp=236}}</inner><close>&lt;/ref&gt;</close></ext> Despite the difficulty with deadlines, Adams wrote five novels in the series, published in 1979, 1980, 1982, 1984, and 1992.\n\nThe books formed the basis for other adaptations, such as three-part comic book adaptations for each of the first three books, an interactive text-adventure [[The Hitchhiker's Guide to the Galaxy (computer game)|computer game]], and a photo-illustrated edition, published in 1994. This latter edition featured a [[42 Puzzle]] designed by Adams, which was later incorporated into paperback covers of the first four ''Hitchhiker's'' novels (the paperback for the fifth re-used the artwork from the hardback edition).<ext><name>ref</name><attr/><inner>[http://www.iblist.com/series.php?id=2 Internet Book List] page, with links to all five novels, and reproductions of the 1990s paperback covers that included the [[42 Puzzle]].</inner><close>&lt;/ref&gt;</close></ext>\n\nIn 1980 Adams also began attempts to turn the first ''Hitchhiker's'' novel into a movie, making several trips to Los Angeles, and working with a number of Hollywood studios and potential producers. The next year, the radio series became the basis for a BBC television mini-series<ext><name>ref</name><attr/><inner>{{citation|url=http://www.imdb.com/title/tt0081874/|title=''The Hitch Hiker's Guide to the Galaxy''|publisher=Internet Movie Database}}</inner><close>&lt;/ref&gt;</close></ext> broadcast in six parts. When he died in 2001 in California, he had been trying again to get the movie project started with [[Disney]], which had bought the rights in 1998. The screenplay finally got a posthumous re-write by [[Karey Kirkpatrick]], and [[The Hitchhiker's Guide to the Galaxy (film)|the resulting film]] was released in 2005.\n\nRadio producer [[Dirk Maggs]] had consulted with Adams, first in 1993, and later in 1997 and 2000 about creating a third radio series, based on the third novel in the ''Hitchhiker's'' series.<ext><name>ref</name><attr/><inner>{{cite book | author=Adams, Douglas. | editor = [[Dirk Maggs]], dramatisations and editor | title=The Hitchhiker's Guide to the Galaxy Radio Scripts: The Tertiary, Quandary and Quintessential Phases | publisher=Pan Books | year=2005|isbn=0-330-43510-8 |pages=xiv | nopp=true}}</inner><close>&lt;/ref&gt;</close></ext> They also discussed the possibilities of radio adaptations of the final two novels in the five-book &quot;trilogy&quot;. As with the movie, this project was only realised after Adams's death. The third series, ''[[The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases#The Tertiary Phase|The Tertiary Phase]]'', was broadcast on [[BBC Radio 4]] in September 2004 and was subsequently released on audio CD. With the aid of a recording of his reading of ''Life, the Universe and Everything'' and editing, Adams can be heard playing the part of Agrajag posthumously. ''So Long, and Thanks for All the Fish'' and ''Mostly Harmless'' made up the fourth and fifth radio series, respectively (on radio they were titled ''[[The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases#The Quandary Phase|The Quandary Phase]]'' and ''[[The Hitchhiker's Guide to the Galaxy Tertiary to Quintessential Phases#The Quintessential Phase|The Quintessential Phase]]'') and these were broadcast in May and June 2005, and also subsequently released on Audio CD. The last episode in the last series (with a new, &quot;more upbeat&quot; ending) concluded with, &quot;The very final episode of ''The Hitchhiker's Guide to the Galaxy'' by Douglas Adams is affectionately dedicated to its author.&quot;<ext><name>ref</name><attr/><inner>Adams, ''Dirk Maggs'', Page 356.</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"4\" i=\"6\">====''Dirk Gently'' series====</h>\n[[File:Douglas Adams San Francisco.jpg|thumb|Adams in March 2000]]\nIn between Adams's first trip to Madagascar with [[Mark Carwardine]] in 1985, and their series of travels that formed the basis for the radio series and non-fiction book ''[[Last Chance to See]]'', Adams wrote two other novels with a new cast of characters. ''[[Dirk Gently's Holistic Detective Agency]]'' was first published in 1987, and was described by its author as &quot;a kind of ghost-horror-detective-time-travel-romantic-comedy-epic, mainly concerned with mud, music and quantum mechanics&quot;.<ext><name>ref</name><attr/><inner>{{cite book|author=[[Neil Gaiman|Gaiman, Neil]] | title=Don't Panic: Douglas Adams &amp; The Hitchhiker's Guide to the Galaxy | edition=Second U.S. | publisher=Titan Books | year=2003 | page=169 | isbn=1-84023-742-2}}</inner><close>&lt;/ref&gt;</close></ext> It was derived from two Doctor Who serials Adams had written.\n\nA sequel novel, ''[[The Long Dark Tea-Time of the Soul]]'', was published a year later. This was an entirely original work, Adams's first since ''So Long, and Thanks for All the Fish.'' After the book tour, Adams set off on his round-the-world excursion which supplied him with the material for ''Last Chance to See''.\n\n<h level=\"4\" i=\"7\">====''Doctor Who''====</h>\n<template lineStart=\"1\"><title>Main article</title><part><name index=\"1\"/><value>Doctor Who</value></part></template>\nAdams sent the script for the ''HHGG'' pilot radio programme to the ''Doctor Who'' production office in 1978, and was commissioned to write ''[[The Pirate Planet]]'' (see below). He had also previously attempted to submit a potential movie script, called &quot;Doctor Who and the Krikkitmen&quot;, which later became his novel ''Life, the Universe and Everything'' (which in turn became the third ''Hitchhiker's Guide'' radio series). Adams then went on to serve as script editor on the show for its seventeenth season in 1979. Altogether, he wrote three [[List of Doctor Who serials|''Doctor Who'' serials]] starring [[Tom Baker]] as [[The Doctor (Doctor Who)|the Doctor]]:\n* &quot;[[The Pirate Planet]]&quot; (the second serial in the &quot;[[The Key to Time|Key to Time]]&quot; arc, in [[Doctor Who (season 16)|season 16]])\n* &quot;[[City of Death]]&quot; (with producer [[Graham Williams (television producer)|Graham Williams]], from an original storyline by writer [[David Fisher (writer)|David Fisher]]. It was transmitted under the pseudonym &quot;[[David Agnew]]&quot;)\n* &quot;[[Shada]]&quot; (only partially filmed; not televised due to [[strike action|industry disputes]])\n\nThe episodes authored by Adams are some of the few that were not novelised as Adams would not allow anyone else to write them, and asked for a higher price than the publishers were willing to pay.<ext><name>ref</name><attr/><inner>{{cite web|url=http://www.skepticfiles.org/en001/drwhogde.htm |title=A 1990s Doctor Who FAQ |publisher=Skepticfiles.org |accessdate=11 March 2013}}</inner><close>&lt;/ref&gt;</close></ext> &quot;Shada&quot; was later adapted as a novel by [[Gareth Roberts (writer)|Gareth Roberts]] in 2012 and &quot;City of Death&quot; by [[James Goss (producer)|James Goss]] in 2015.\n\nAdams was also known to allow in-jokes from ''The Hitchhiker's Guide'' to appear in the ''Doctor Who'' stories he wrote and other stories on which he served as Script Editor. Subsequent writers have also inserted ''Hitchhiker's'' references, even [[The Rings of Akhaten|as recently as 2013]]. Conversely, at least one reference to ''Doctor Who'' was worked into a ''Hitchhiker's'' novel. In ''[[Life, the Universe and Everything]]'', two characters travel in time and land on the pitch at [[Lord's Cricket Ground]]. The reaction of the radio commentators to their sudden appearance is very similar to the reactions of commentators in a scene in the eighth episode of the 1965–66-story ''[[The Daleks' Master Plan]]'', which has the Doctor's [[TARDIS]] [[Materialization (science fiction)|materialise]] on the pitch at Lord's.\n\nElements of ''Shada'' and ''City of Death'' were reused in Adams's later novel ''[[Dirk Gently's Holistic Detective Agency]]'', in particular the character of [[Professor Chronotis]]. [[Big Finish Productions]] eventually remade ''Shada'' as an audio play starring [[Paul McGann]] as the Doctor. Accompanied by partially animated illustrations, it was [[Doctor Who spin-offs#Webcasts|webcast]] on the [[BBC Online|BBC website]] in 2003, and subsequently released as a two-CD set later that year. An omnibus edition of this version was broadcast on the digital radio station [[BBC7]] on 10 December 2005.\n\nIn the ''Doctor Who'' 2012 Christmas episode ''[[The Snowmen#Production|The Snowmen]]'', writer [[Steven Moffat]] was inspired by a storyline that Adams pitched called ''The Doctor Retires''.<ext><name>ref</name><attr/><inner>{{cite web|last=Moffat |first=Steven |url=http://www.radiotimes.com/news/2012-12-24/doctor-who-christmas-special-steven-moffat-matt-smith-and-jenna-louise-coleman-reveal-all |title=Doctor Who Christmas special: Steven Moffat, Matt Smith and Jenna-Louise Coleman reveal all |work=Radio Times |date=24 December 2012 |accessdate=8 July 2013}}</inner><close>&lt;/ref&gt;</close></ext>\n\nWhile he was at school,<template><title>which</title><part><name>date</name><equals>=</equals><value>October 2015</value></part></template> he wrote and performed a play called ''Doctor Which''.<ext><name>ref</name><attr> name=Adams_xx</attr><inner>{{Harvnb|Adams|2002|pp=xx}}</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"3\" i=\"8\">===Music===</h>\nAdams played the guitar left-handed and had a collection of twenty-four left-handed guitars when he died (having received his first guitar in 1964). He also studied piano in the 1960s with the same teacher as [[Paul Wickens]], the pianist who plays in [[Paul McCartney]]'s band (and composed the music for the 2004–2005 editions of the ''Hitchhiker's Guide'' radio series).<ext><name>ref</name><attr/><inner>Webb, page 49.</inner><close>&lt;/ref&gt;</close></ext> [[Pink Floyd]] and [[Procol Harum]] had important influence on Adams's work.\n\n<h level=\"4\" i=\"9\">====Pink Floyd====</h>\n\nAdams included a reference to [[Pink Floyd]] in the original radio version of ''[[The Hitchhiker's Guide to the Galaxy]]'', in which he describes the main characters surveying the landscape of an alien planet while Marvin, their android companion, hums Pink Floyd's &quot;[[Shine on You Crazy Diamond]]&quot; (Part 1). This was cut out of the CD version. Adams also compared the various noises that the [[kakapo]] makes to &quot;Pink Floyd studio out-takes&quot; in his non-fiction book on endangered species, ''[[Last Chance to See]]''.\n\nAdams's official biography shares its name with the song &quot;[[Wish You Were Here (1975 song)|Wish You Were Here]]&quot; by Pink Floyd. Adams was friends with Pink Floyd guitarist [[David Gilmour]] and, on Adams's 42nd birthday, he was invited to make a guest appearance at Pink Floyd's concert of 28 October 1994 at Earls Court in London, playing guitar on the songs &quot;[[Brain Damage (song)|Brain Damage]]&quot; and &quot;[[Eclipse (song)|Eclipse]]&quot;.<ext><name>ref</name><attr> name=Mabbett-MM</attr><inner>{{Cite book |publisher= Omnibus Press |isbn= 978-1-84938-370-7 |last= Mabbett |first= Andy |title= Pink Floyd – The Music and the Mystery |location= London |year= 2010 }}</inner><close>&lt;/ref&gt;</close></ext> Adams chose the name for Pink Floyd's 1994 album, ''[[The Division Bell]]'', by picking the words from the lyrics to one of its tracks, &quot;High Hopes&quot;.<ext><name>ref</name><attr> name=Mabbett-MM </attr></ext> Gilmour also performed at Adams's memorial service in 2001, and what would have been Adams's 60th birthday party in 2012.\n\n<h level=\"4\" i=\"10\">====Procol Harum====</h>\nAdams was a friend of [[Gary Brooker]], the lead singer, pianist and songwriter of [[Procol Harum]]. Adams invited Brooker to one of the many parties that Adams held at his house. On one such occasion Gary Brooker performed the full (4 verse) version of &quot;[[A Whiter Shade of Pale]]&quot;. Brooker also performed at Adams's memorial service.\n\nAdams appeared on stage with Brooker to perform &quot;In Held 'Twas in I&quot; at Redhill when the band's lyricist [[Keith Reid]] was not available. On several other occasions he introduced Procol Harum at their gigs.\n\nAdams would listen to music while writing, and this would occasionally influence his work. On one occasion the title track from the Procol Harum album ''[[Grand Hotel (album)|Grand Hotel]]'' was playing when\n<template lineStart=\"1\"><title>quotation</title><part><name index=\"1\"/><value>Suddenly in the middle of the song there was this huge orchestral climax that came out of nowhere and did not seem to be about anything. I kept wondering what was this huge thing happening in the background? And I eventually thought&amp;nbsp;... it sounds as if there ought to be some sort of floorshow going on. Something huge and extraordinary, like, well, like the end of the universe. And so that was where the idea for The Restaurant at the End of the Universe came from.</value></part><part><name index=\"2\"/><value>Douglas Adams</value></part><part><name index=\"3\"/><value>Procol Harum at The Barbican<ext><name>ref</name><attr/><inner>{{cite web|url=http://www.procolharum.com/dadams.htm |title=Text of one of Douglas Adams's introductions of Procol Harum in concert |accessdate=21 August 2006|last=Adams |first=Douglas |date=8 February 1996}}</inner><close>&lt;/ref&gt;</close></ext></value></part></template>\n\n<h level=\"3\" i=\"11\">===Computer games and projects===</h>\nDouglas Adams created an [[interactive fiction]] version of ''[[The Hitchhiker's Guide to the Galaxy (computer game)|HHGG]]'' with [[Steve Meretzky]] from [[Infocom]] in 1984. In 1986 he participated in a week-long brainstorming session with the [[Lucasfilm Games]] team for the game ''[[Labyrinth: The Computer Game|Labyrinth]]''. Later he was also involved in creating ''[[Bureaucracy (computer game)|Bureaucracy]]'' (also by Infocom, but not based on any book; Adams wrote it as a parody of events in his own life).\n\nAdams was a founder-director and Chief Fantasist of [[The Digital Village]], a digital media and Internet company with which he created ''[[Starship Titanic]]'', a [[Codie]] Award-winning and [[BAFTA#Games Awards|BAFTA-nominated adventure game]], which was published in 1998 by [[Simon &amp; Schuster]].<ext><name>ref</name><attr> name=&quot;bbc.co.uk&quot;</attr><inner>BBC Online (no date) [http://www.bbc.co.uk/cult/hitchhikers/dna/biog.shtml &quot;The Hitchhiker's Guide to the Galaxy: DNA (1952-2001)&quot;] Accessed 9 July 2014</inner><close>&lt;/ref&gt;</close></ext><ext><name>ref</name><attr/><inner>Botti, Nicolas (2009). [http://www.douglasadams.eu/en_adams_bio.php &quot;Life, DNA &amp; h2g2: Douglas Adams's Biography&quot;] Accessed 9 July 2014</inner><close>&lt;/ref&gt;</close></ext> [[Terry Jones]] wrote the accompanying book, entitled ''Douglas Adams Starship Titanic'', since Adams was too busy with the computer game to do both. In April 1999, Adams initiated the [[h2g2]] [[collaborative writing]] project, an experimental attempt at making ''The Hitchhiker's Guide to the Galaxy'' a reality, and at harnessing the collective brainpower of the internet community. It found a new home at BBC Online in 2001.<ext><name>ref</name><attr> name=&quot;bbc.co.uk&quot;</attr></ext>\n\nIn 1990 Adams wrote and presented a television documentary programme ''[[Hyperland]]''<ext><name>ref</name><attr/><inner>[http://www.imdb.com/title/tt0188677/ Internet Movie Database's page for ''Hyperland'']</inner><close>&lt;/ref&gt;</close></ext> which featured [[Tom Baker]] as a &quot;software agent&quot; (similar to the assistant pictured in Apple's [[Knowledge Navigator]] video of future concepts from 1987), and interviews with [[Ted Nelson]], the co-inventor of [[hypertext]] and the person who coined the term. Although Adams did not invent hypertext, he was an [[early adopter]] and advocate of it. This was the same year that [[Tim Berners-Lee]] used the idea of hypertext in his [[HTML]].\n\n<h level=\"2\" i=\"12\">==Personal beliefs and activism==</h>\n\n<h level=\"3\" i=\"13\">===Atheism and views on religion===</h>\nAdams described himself as a &quot;radical [[atheist]]&quot;, adding ''radical'' for emphasis so he would not be asked if he meant agnostic. He told [[American Atheists]] that this made things easier, but most importantly it conveyed the fact that he really meant it. &quot;I am convinced that there is not a god,&quot; he said. He imagined a [[Fine-tuned Universe#In popular culture|sentient puddle]] who wakes up one morning and thinks, &quot;This is an interesting world I find myself in – an interesting hole I find myself in – fits me rather neatly, doesn't it? In fact it fits me staggeringly well, must have been made to have me in it!&quot; to demonstrate his view that the [[fine-tuned Universe]] argument for God was a fallacy.<ext><name>ref</name><attr/><inner>Adams 1998.</inner><close>&lt;/ref&gt;</close></ext>\n\nDespite this, he remained fascinated by religion because of its effect on human affairs. &quot;I love to keep poking and prodding at it. I've thought about it so much over the years that that fascination is bound to spill over into my writing.&quot;<ext><name>ref</name><attr> name=amath</attr><inner>{{cite journal|last=Silverman |first=Dave |title=Interview: Douglas Adams |journal=American Atheist |year=1998–1999 |volume=37 |issue=1 |url=http://www.atheists.org/Interview%3A__Douglas_Adams |accessdate=16 August 2009 |archiveurl=http://www.webcitation.org/63mRFcWVO?url=http%3A%2F%2Fwww.atheists.org%2FInterview%253A__Douglas_Adams |archivedate=8 December 2011 |deadurl=no |df=dmy }}</inner><close>&lt;/ref&gt;</close></ext>\n\nThe evolutionary biologist and atheist [[Richard Dawkins]] uses Adams's influence throughout to exemplify arguments for non-belief in his 2006 book ''[[The God Delusion]]''. Dawkins dedicated the book to Adams, whom he jokingly called &quot;possibly [my] only convert&quot; to atheism<ext><name>ref</name><attr> name=&quot;TheGuardian&quot;</attr><inner>{{cite news|url=http://books.guardian.co.uk/reviews/roundupstory/0,,1939704,00.html |title=Observer, '&amp;#39;The God Delusion'&amp;#39;, 5&amp;nbsp;November 2006|newspaper=[[The Guardian]]|date=5 November 2006 |accessdate=1 June 2009 | location=London | first=Kim | last=Bunce}}</inner><close>&lt;/ref&gt;</close></ext> and wrote on his death that &quot;Science has lost a friend, literature has lost a luminary, the [[mountain gorilla]] and the [[black rhino]] have lost a gallant defender.&quot;<ext><name>ref</name><attr> name=Dawkins2001</attr><inner>{{cite news|last=Dawkins|first=Richard|title=Lament for Douglas Adams|url=http://www.guardian.co.uk/uk/2001/may/14/books.booksnews|accessdate=29 December 2012|newspaper=The Guardian|date=13 May 2001}}</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"3\" i=\"14\">===Environmental activism===</h>\nAdams was also an [[environmental activist]] who campaigned on behalf of [[endangered species]]. This activism included the production of the non-fiction radio series ''[[Last Chance to See]]'', in which he and [[natural history|naturalist]] [[Mark Carwardine]] visited rare species such as the [[kakapo]] and [[Chinese river dolphin|baiji]], and the publication of a tie-in book of the same name. In 1992 this was made into a CD-ROM combination of [[audiobook]], [[e-book]] and picture slide show.\n\nAdams and Mark Carwardine contributed the 'Meeting a Gorilla' passage from ''[[Last Chance to See]]'' to the book ''[[Great Ape Project|The Great Ape Project]]''.<ext><name>ref</name><attr/><inner>{{cite book | author=[[Paola Cavalieri|Cavalieri, Paola]] and [[Peter Singer]], editors | title=The Great Ape Project: Equality Beyond Humanity | edition=U.S. Paperback | publisher=St. Martin's Griffin | year=1994 | pages=19–23|isbn=0-312-11818-X}}</inner><close>&lt;/ref&gt;</close></ext> This book, edited by [[Paola Cavalieri]] and [[Peter Singer]], launched a wider-scale project in 1993, which calls for the extension of moral equality to include all great apes, human and non-human.\n\nIn 1994 he participated in a climb of [[Mount Kilimanjaro]] while wearing a rhino suit for the British charity organisation ''[[Save the Rhino|Save the Rhino International]]''. Puppeteer [[William Todd-Jones]], who had originally worn the suit in the London Marathon to raise money and bring awareness to the group, also participated in the climb wearing a rhino suit; Adams wore the suit while travelling to the mountain before the climb began. About £100,000 was raised through that event, benefiting schools in [[Kenya]] and a [[black rhinoceros]] preservation programme in [[Tanzania]]. Adams was also an active supporter of the ''[[Dian Fossey]] Gorilla Fund''.\n\nSince 2003, ''Save the Rhino'' has held an annual Douglas Adams Memorial Lecture around the time of his birthday to raise money for environmental campaigns.<ext><name>ref</name><attr/><inner>{{cite web|url=http://lifednah2g2.blogspot.co.uk/2011/01/ninth-douglas-adams-memorial-lecture.html |title=The Ninth Douglas Adams Memorial Lecture |publisher=Save the Rhino International |accessdate=27 July 2011}}</inner><close>&lt;/ref&gt;</close></ext> The lectures in the series are:\n* 2003 [[Richard Dawkins]] – ''Queerer than we can suppose: the strangeness of science''\n* 2004 [[Robert Swan]] – ''Mission Antarctica''\n* 2005 [[Mark Carwardine]] – ''Last Chance to See... Just a bit more''\n* 2006 [[Robert Winston]] – ''Is the Human an Endangered Species?''\n* 2007 [[Richard Leakey]] – ''Wildlife Management in East Africa – Is there a future?''\n* 2008 [[Steven Pinker]] – ''The Stuff of Thought, Language as a Window into Human Nature''\n* 2009 [[Benedict Allen]] – ''Unbreakable''\n* 2010 [[Marcus du Sautoy]] – ''42: the answer to life, the universe and prime numbers''\n* 2011 [[Brian Cox (physicist)|Brian Cox]] – ''The Universe and Why We Should Explore It''\n* 2012 Lecture replaced by &quot;Douglas Adams The Party&quot;<ext><name>ref</name><attr/><inner>{{cite web|url=http://www.savetherhino.org/latest_news/news/287_douglas_adams_the_party |title=Douglas Adams The Party |publisher=Save the Rhino International |accessdate=11 March 2013}}</inner><close>&lt;/ref&gt;</close></ext>\n* 2013 [[Adam Rutherford]] – ''Creation: the origin and the future of life''<ext><name>ref</name><attr/><inner>{{cite web|url=http://www.savetherhino.org/events/476_douglas_adams_memorial_lecture_2013 |title=Douglas Adams Memorial Lecture 2013 |publisher=Save the Rhino International |accessdate=15 August 2012}}</inner><close>&lt;/ref&gt;</close></ext>\n* 2014 [[Roger Highfield]] and [[Simon Singh]] – ''The Science of Harry Potter and the Mathematics of The Simpsons''<ext><name>ref</name><attr/><inner>{{cite web|url=http://www.savetherhino.org/events/798_douglas_adams_memorial_lecture |title=Douglas Adams Memorial Lecture 2014 |publisher=Save the Rhino International |accessdate=15 November 2013}}</inner><close>&lt;/ref&gt;</close></ext>\n* 2015 [[Neil Gaiman]] – ''Immortality and Douglas Adams''<ext><name>ref</name><attr/><inner>{{cite web|url=http://www.savetherhino.org/events/1059_douglas_adams_memorial_lecture_2015_-_sold_out  |title=Douglas Adams Memorial Lecture 2015 |publisher=Save the Rhino International |accessdate=30 January 2015}}</inner><close>&lt;/ref&gt;</close></ext>\n* 2016 [[Alice Roberts]] – ''Survivors of the Ice Age''<ext><name>ref</name><attr/><inner>{{ cite web|url=https://www.savetherhino.org/events/1383_douglas_adams_memorial_lecture_2016|title=Douglas Adams Memorial Lecture 2016 |publisher=Save the Rhino International |accessdate=7 December 2015}}</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"3\" i=\"15\">===Technology and innovation===</h>\nAdams bought his first [[word processor]] in 1982, having considered one as early as 1979. His first purchase was a 'Nexus'. In 1983, when he and Jane Belson went out to Los Angeles, he bought a [[Digital Equipment Corporation|DEC]] [[Rainbow 100|Rainbow]]. Upon their return to England, Adams bought an [[Apricot Computers|Apricot]], then a [[BBC Micro]] and a [[Tandy 1000]].<ext><name>ref</name><attr> name=Simpson_184-185</attr><inner>{{Harvnb|Simpson|2003|pp=184–185}}</inner><close>&lt;/ref&gt;</close></ext> In ''[[Last Chance to See]]'' Adams mentions his [[Cambridge Z88]], which he had taken to [[Zaire]] on a quest to find the [[northern white rhinoceros]].<ext><name>ref</name><attr/><inner>{{cite book|author=Adams, Douglas and [[Mark Carwardine]] | title=Last Chance to See | edition=First U.S. Hardcover | publisher=[[Harmony Books]] | year=1991 | page=59 | isbn=0-517-58215-5}}</inner><close>&lt;/ref&gt;</close></ext>\n\nAdams's posthumously published work, ''[[The Salmon of Doubt]]'', features multiple articles by him on the subject of technology, including reprints of articles that originally ran in ''[[MacUser]]'' magazine, and in ''[[The Independent on Sunday]]'' newspaper. In these Adams claims that one of the first computers he ever saw was a [[Commodore PET]], and that he has &quot;adored&quot; his Apple Macintosh (&quot;or rather my family of however many Macintoshes it is that I've recklessly accumulated over the years&quot;) since he first saw one at Infocom's offices in Boston in 1984.<ext><name>ref</name><attr/><inner>{{cite book | author=Adams, Douglas | title=The Salmon of Doubt: Hitchhiking the Galaxy One Last Time | edition=First UK hardcover | publisher=Macmillan | year=2002 | pages=90–1 | isbn=0-333-76657-1}}</inner><close>&lt;/ref&gt;</close></ext>\n\nAdams was a Macintosh user from the time they first came out in 1984 until his death in 2001. He was the first person to buy a Mac in Europe (the second being [[Stephen Fry]] – though some accounts differ on this, saying Fry bought his Mac first. Fry claims he was second to Adams<ext><name>ref</name><attr/><inner>{{cite web|url=https://www.youtube.com/watch?v=gx6WPQkhUXI |title=Craig Ferguson 23 February, 2010B Late Late show Stephen Fry PT2 |publisher=YouTube |date=21 June 2010 |accessdate=27 July 2011}}</inner><close>&lt;/ref&gt;</close></ext>). Adams was also an &quot;[[AppleMasters|Apple Master]]&quot;, one of several celebrities whom Apple made into spokespeople for its products (other Apple Masters included [[John Cleese]] and [[Gregory Hines]]). Adams's contributions included a rock video that he created using the first version of [[iMovie]] with footage featuring his daughter Polly. The video was available on Adams's [[.Mac]] homepage. Adams installed and started using the first release of [[Mac OS X]] in the weeks leading up to his death. His very last post to his own forum was in praise of Mac OS X and the possibilities of its [[Cocoa (API)|Cocoa]] programming framework. He said it was &quot;awesome...&quot;, which was also the last word he wrote on his site.<ext><name>ref</name><attr/><inner>{{cite web|url=http://www.douglasadams.com/cgi-bin/mboard/info/dnathread.cgi?2922,1 |title=Adams's final post on his forums at |publisher=Douglasadams.com |accessdate=1 June 2009}}</inner><close>&lt;/ref&gt;</close></ext>\n\nAdams used e-mail extensively long before it reached popular awareness, using it to correspond with [[Steve Meretzky]] during the pair's collaboration on Infocom's version of ''[[The Hitchhiker's Guide to the Galaxy (computer game)|The Hitchhiker's Guide to the Galaxy]]''.<ext><name>ref</name><attr> name=&quot;Simpson_184-185&quot;</attr></ext> While living in New Mexico in 1993 he set up another e-mail address and began posting to his own [[USENET]] newsgroup, alt.fan.douglas-adams, and occasionally, when his computer was acting up, to the comp.sys.mac hierarchy.<ext><name>ref</name><attr/><inner>{{cite web|url=https://groups.google.com/group/alt.fan.douglas-adams |title=Discussions – alt.fan.douglas-adams &amp;#124; Google Groups |publisher=Google |accessdate=11 March 2013}}</inner><close>&lt;/ref&gt;</close></ext> Many of his posts are now archived through Google. Challenges to the authenticity of his messages later led Adams to set up a message forum on his own website to avoid the issue. In 1996, Adams was a keynote speaker at The [[Microsoft]] [[Professional Developers Conference]] (PDC) where he described the personal computer as being a modelling device. The video of his keynote speech is archived on [[Channel 9 (discussion forum)|Channel 9]].<ext><name>ref</name><attr/><inner>{{cite web |last = Adams |first = Douglas |title = PDC 1996 Keynote with Douglas Adams |work=[[channel9.msdn.com]] |publisher=Channel 9 |date = 15 May 2001 |url = http://channel9.msdn.com/Events/PDC/PDC-1996/PDC-1996-Keynote-with-Douglas-Adams |accessdate =22 March 2013}}</inner><close>&lt;/ref&gt;</close></ext>\nAdams was also a keynote speaker for the April 2001 [[Embedded Systems Conference#ESC Silicon Valley|Embedded Systems Conference]] in San Francisco, one of the major technical conferences on [[embedded system]] engineering. In his keynote speech, he shared his vision of technology and how it should contribute in everyday – and every man's – life.<ext><name>ref</name><attr/><inner>{{cite web |last = Cassel |first = David |title = So long, Douglas Adams, and thanks for all the fun |work=[[Salon (website)|Salon]] |publisher=Salon Media Group |date = 15 May 2001 |url = http://archive.salon.com/tech/feature/2001/05/15/douglas_adams/index.html |accessdate =10 July 2009}}</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"2\" i=\"16\">==Personal life==</h>\nAdams moved to [[Upper Street]], [[Islington]], in 1981<ext><name>ref</name><attr> name=&quot;IPP&quot; </attr></ext> and to Duncan Terrace, a few minutes' walk away, in the late 1980s.<ext><name>ref</name><attr> name=&quot;IPP&quot; </attr></ext>\n\nIn the early 1980s Adams had an affair with novelist [[Sally Emerson]], who was separated from her husband at that time. Adams later dedicated his book ''[[Life, the Universe and Everything]]'' to Emerson. In 1981 Emerson returned to her husband, [[Peter Stothard]], a contemporary of Adams's at [[Brentwood School (England)|Brentwood School]], and later editor of ''[[The Times]]''. Adams was soon introduced by friends to Jane Belson, with whom he later became romantically involved. Belson was the &quot;lady barrister&quot; mentioned in the jacket-flap biography printed in his books during the mid-1980s (&quot;He [Adams] lives in Islington with a lady barrister and an Apple Macintosh&quot;). The two lived in Los Angeles together during 1983 while Adams worked on an early screenplay adaptation of ''Hitchhiker's''. When the deal fell through, they moved back to London, and after several separations (&quot;He is currently not certain where he lives, or with whom&quot;)<ext><name>ref</name><attr> name=sfweekly</attr><inner>{{cite web|last=Bowers |first=Keith |title=Big Three |url=http://www.sfweekly.com/2011-07-06/calendar/big-three/ |work=SF Weekly |accessdate=8 December 2011 |archiveurl=http://www.webcitation.org/63mSWp8yr?url=http%3A%2F%2Fwww.sfweekly.com%2F2011-07-06%2Fcalendar%2Fbig-three%2F |archivedate=8 December 2011 |deadurl=no |date=6 July 2011 |df=dmy }}</inner><close>&lt;/ref&gt;</close></ext> and an aborted engagement, they married on 25 November 1991. Adams and Belson had one daughter together, Polly Jane Rocket Adams, born on 22 June 1994, shortly after Adams turned 42. In 1999 the family moved from London to [[Santa Barbara, California]], where they lived until his death. Following the funeral, Jane Belson and Polly Adams returned to London.<ext><name>ref</name><attr/><inner>Webb, Chapter 10.</inner><close>&lt;/ref&gt;</close></ext> Jane died on 7 September 2011 of cancer, aged 59.<ext><name>ref</name><attr> name=timesobit</attr><inner>{{cite web|title=Obituary &amp; Guest Book Preview for Jane Elizabeth BELSON|url=http://announcements.thetimes.co.uk/obituaries/timesonline-uk/obituary.aspx?page=lifestory&amp;pid=153521790|work=The Times|accessdate=8 December 2011|archiveurl=http://www.webcitation.org/63mSoMnJe|archivedate=8 December 2011|deadurl=no|date=9 September 2011}}</inner><close>&lt;/ref&gt;</close></ext><ext><name>ref</name><attr> name=h2g2obit</attr><inner>{{cite web|title=Jane Belson, Douglas Adams's widow, passed away|url=http://lifednah2g2.blogspot.com/2011/09/jane-belson-douglas-adams-widow-passed.html|work=h2g2|accessdate=9 July 2013}}</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"2\" i=\"17\">==Death and legacy==</h>\n[[File:Highgate Cemetery - East - Douglas Adams 01.jpg|thumb|Adams's gravestone, [[Highgate Cemetery]], North London]]\nAdams died of a [[heart attack]] on 11 May 2001, aged 49, after resting from his regular workout at a private gym in [[Montecito, California]]. He had unknowingly suffered a gradual narrowing of the [[coronary arteries]], which led at that moment to a [[myocardial infarction]] and a fatal [[cardiac arrhythmia]].<template><title>cn</title><part><name>date</name><equals>=</equals><value>October 2016</value></part></template> Adams had been due to deliver the commencement address at [[Harvey Mudd College]] on 13 May.<ext><name>ref</name><attr/><inner>{{cite web|url=http://www.laweekly.com/2001-05-24/news/lots-of-screamingly-funny-sentences-no-fish/ |title=Lots of Screamingly Funny Sentences. No Fish. – page 1 |last1=Lewis |first1=Judith |last2=Shulman |first2=Dave |publisher=LA Weekly |date=24 May 2001 |accessdate=20 August 2009 |archiveurl=http://www.webcitation.org/63mQ1aCJQ?url=http%3A%2F%2Fwww.laweekly.com%2F2001-05-24%2Fnews%2Flots-of-screamingly-funny-sentences-no-fish%2F |archivedate=24 May 2001 |deadurl=no |df=dmy }}</inner><close>&lt;/ref&gt;</close></ext> His funeral was held on 16 May in Santa Barbara, California. His remains were subsequently cremated and the ashes placed in [[Highgate Cemetery]] in north London in June 2002.<ext><name>ref</name><attr> name=Simpson_337-338</attr><inner>{{Harvnb|Simpson|2003|pp=337–338}}</inner><close>&lt;/ref&gt;</close></ext>\n\nA memorial service was held on 17 September 2001 at [[St Martin-in-the-Fields]] church, [[Trafalgar Square]], London. This became the first church service broadcast live on the web by the BBC.<ext><name>ref</name><attr/><inner>Gaiman, 204.</inner><close>&lt;/ref&gt;</close></ext> Video clips of the service are still available on the BBC's website for download.<ext><name>ref</name><attr/><inner>{{cite web|url=http://www.bbc.co.uk/cult/hitchhikers/celebration/ |title=BBC Online – Cult – Hitchhiker's – Douglas Adams – Service of Celebration |publisher=BBC |date=17 September 2001 |accessdate=11 March 2013}}</inner><close>&lt;/ref&gt;</close></ext>\n\nOne of his last public appearances was a talk given at the University of California, Santa Barbara, ''Parrots, the universe and everything'', recorded days before his death.<ext><name>ref</name><attr/><inner>{{cite web|url=https://www.youtube.com/watch?v=_ZG8HBuDjgc |title=Parrots, the universe and everything, recorded May 2001 |publisher=YouTube |accessdate=11 March 2013}}</inner><close>&lt;/ref&gt;</close></ext> A full transcript of the talk is available, and the university has made the full video available on [https://www.youtube.com/watch?v=_ZG8HBuDjgc YouTube].<ext><name>ref</name><attr/><inner>{{cite web|url=http://navarroj.com/parrots |title=Transcript of &quot;Parrots, the Universe and Everything&quot; |publisher=Navarroj.com |accessdate=27 July 2011}}</inner><close>&lt;/ref&gt;</close></ext>\n\nThe [[Minor Planet Centre]] space agency named an asteroid [[18610 Arthurdent]], coincidentally announcing its plan two days before Adams died.<ext><name>ref</name><attr> name=MPC42677</attr><inner>{{Citation | publication-date = 9 May 2001 | title = New Names of Minor Planets | periodical = [[Minor Planet Circular]] | publication-place = Cambridge, Mass | publisher=[[Minor Planet Center]] | issue = MPC 42677 | url = http://www.minorplanetcenter.net/iau/ECS/MPCArchive/2001/MPC_20010509.pdf | issn = 0736-6884 }}</inner><close>&lt;/ref&gt;</close></ext> There is also an [[25924 Douglasadams|asteroid named after Adams himself]].<ext><name>ref</name><attr/><inner>[http://www.msnbc.msn.com/id/6867061/ Asteroid named after 'Hitchhiker' humorist: Late British sci-fi author honored after cosmic campaign] by Alan Boyle, MSNBC, 25 January 2005</inner><close>&lt;/ref&gt;</close></ext>\n\nIn May 2002 ''[[The Salmon of Doubt]]'' was published, containing many short stories, essays, and letters, as well as eulogies from [[Richard Dawkins]], [[Stephen Fry]] (in the UK edition), [[Christopher Cerf]] (in the US edition), and [[Terry Jones]] (in the US paperback edition). It also includes eleven chapters of his long-awaited but unfinished novel, ''The Salmon of Doubt'', which was originally intended to become a new [[Dirk Gently]] novel, but might have later become the sixth ''Hitchhiker'' novel.<ext><name>ref</name><attr/><inner>\n{{cite news\n|url=http://www.independent.co.uk/arts-entertainment/books/reviews/the-salmon-of-doubt-by-douglas-adams-650803.html\n|title=The Salmon of Doubt by Douglas Adams\n|work=The Independent |location=London\n|accessdate=2 August 2009\n|last=Murray\n|first=Charles Shaar\n| date=10 May 2002\n}}\n</inner><close>&lt;/ref&gt;</close></ext><ext><name>ref</name><attr/><inner>\n{{cite news\n|url=http://www.independent.co.uk/arts-entertainment/books/features/cover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html\n|title=Cover Stories: Douglas Adams, Narnia Chronicles, Something like a House\n|work=The Independent |location=London\n|accessdate=2 August 2009\n|author=The Literator\n| date=5 January 2002|archiveurl=https://web.archive.org/web/20090801062359/http://www.independent.co.uk/arts-entertainment/books/features/cover-stories-douglas-adams-narnia-chronicles-something-like-a-house-672250.html|archivedate=1 August 2009 }}\n</inner><close>&lt;/ref&gt;</close></ext>\n\nOther events after Adams's death included a [[webcast]] production of ''[[Shada]]'', allowing the complete story to be told, radio dramatisations of the final three books in the ''Hitchhiker's'' series, and the completion of [[The Hitchhiker's Guide to the Galaxy (film)|the film adaptation]] of ''[[The Hitchhiker's Guide to the Galaxy (book)|The Hitchhiker's Guide to the Galaxy]]''. The film, released in 2005, posthumously credits Adams as a producer, and several art design elements – including a head-shaped planet seen near the end of the film – incorporated Adams's features.\n\nA 12-part radio series based on the [[Dirk Gently]] novels was announced in 2007, with annual transmissions starting in October.<ext><name>ref</name><attr/><inner>{{cite web |url=http://www.dirkmaggs.dswilliams.co.uk/Dirk%20Maggs%20News%20%20new%20projects.htm |title=Dirk Maggs News and New Projects page }}{{dead link|date=June 2016|bot=medic}}{{cbignore|bot=medic}}</inner><close>&lt;/ref&gt;</close></ext>\n\nBBC Radio 4 also commissioned a third Dirk Gently radio series based on the incomplete chapters of ''The Salmon of Doubt'', and written by [[Kim Fuller]];<ext><name>ref</name><attr/><inner>{{cite web|author=Matthew Hemley |url=http://www.thestage.co.uk/news/newsstory.php/24312/douglas-adams-final-dirk-gently-novel-to-be |title=The Stage / News / Douglas Adams's final Dirk Gently novel to be adapted for Radio 4 |work=The Stage |date=5 May 2009 |accessdate=20 August 2009}}</inner><close>&lt;/ref&gt;</close></ext> but this was dropped in favour of a BBC TV series based on the two completed novels.<ext><name>ref</name><attr/><inner>{{cite web|url=http://www.chortle.co.uk/news/2009/10/11/9767/bbc_plans_dirk_gently_tv_series|title=BBC plans Dirk Gently TV series|publisher=Chortle.co.uk|date=11 October 2009|accessdate=11 October 2009}}</inner><close>&lt;/ref&gt;</close></ext> A sixth ''Hitchhiker'' novel, ''[[And Another Thing... (novel)|And Another Thing...]]'', by ''[[Artemis Fowl (series)|Artemis Fowl]]'' author [[Eoin Colfer]], was released on 12 October 2009 (the 30th anniversary of the first book), published with the full support of Adams's estate. A [[BBC Radio 4]] ''[[Book at Bedtime]]'' adaptation and an audio book soon followed.\n\nOn 25 May 2001, two weeks after Adams's death, his fans organised a tribute known as [[Towel Day]], which has been observed every year since then.\n\nIn 2011, over 3,000 people took part in a public vote to choose the subjects of [[Blue plaque|People's Plaques]] in Islington;<ext><name>ref</name><attr> name=&quot;IPP&quot;</attr><inner>{{cite web|url=http://www.islington.gov.uk/Leisure/heritage/heritage_borough/bor_plaques/peoplesplaques.asp |title=Islington People's Plaques |date=25 July 2011 |accessdate=13 August 2011 |deadurl=yes |archiveurl=https://web.archive.org/web/20120318001614/http://www.islington.gov.uk/Leisure/heritage/heritage_borough/bor_plaques/peoplesplaques.asp |archivedate=18 March 2012 }}</inner><close>&lt;/ref&gt;</close></ext> Adams received 489 votes.\n\nOn 11 March 2013, Adams's 61st birthday was celebrated with an interactive [[Google Doodle]].<ext><name>ref</name><attr> name=GoogleDoodle2013a</attr><inner>{{cite news|title=Don't Panic! Google Doodle Honors Author Douglas Adams|url=http://abcnews.go.com/blogs/technology/2013/03/dont-panic-google-doodle-honors-author-douglas-adams/|accessdate=11 March 2013|newspaper=abc News|date=11 March 2013}}</inner><close>&lt;/ref&gt;</close></ext><ext><name>ref</name><attr/><inner>{{cite web|title=Douglas Adams' 61st Birthday|url=http://www.google.com/doodles/douglas-adams-61st-birthday|accessdate=11 March 2013}}</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"2\" i=\"18\">==Awards and nominations==</h>\n{| class=&quot;wikitable&quot; style=&quot;font-size:90%&quot;\n|- style=&quot;text-align:center;&quot;\n! style=&quot;background:#B0C4DE;&quot; | Year\n! style=&quot;background:#B0C4DE;&quot; | Award\n! style=&quot;background:#B0C4DE;&quot; | Work\n! style=&quot;background:#B0C4DE;&quot; | Category\n! style=&quot;background:#B0C4DE;&quot; | Result\n! style=&quot;background:#B0C4DE;&quot; | Reference\n|-\n|1979\n|[[Hugo Award]]\n|''[[The Hitchhiker's Guide to the Galaxy (radio series)|The Hitchhiker's Guide to the Galaxy]]''&lt;small&gt;(shared with [[Geoffrey Perkins]])&lt;/small&gt;\n|[[Hugo Award for Best Dramatic Presentation|Best Dramatic Presentation]]\n|<template><title>nom</title></template>\n|\n|}\n\n<h level=\"2\" i=\"19\">==Works==</h>\n<template lineStart=\"1\"><title>Refbegin</title><part><name index=\"1\"/><value>20em</value></part></template>\n* ''[[The Private Life of Genghis Khan]]'' (1975), based on a comedy sketch Adams co-wrote with [[Graham Chapman]] (short story)\n* ''[[The Hitchhiker's Guide to the Galaxy (radio series)|The Hitchhiker's Guide to the Galaxy]]'' (1978) (radio series)\n* ''[[The Hitchhiker's Guide to the Galaxy (book)|The Hitchhiker's Guide to the Galaxy]]'' (1979) (novel)\n* ''[[Shada]]'' (1979–1980), a Doctor Who serial\n* ''[[The Restaurant at the End of the Universe]]'' (1980) (novel)\n* ''[[Life, the Universe and Everything]]'' (1982) (novel)\n* ''[[The Meaning of Liff]]'' (1983 (book), with [[John Lloyd (producer)|John Lloyd]])\n* ''[[So Long, and Thanks for All the Fish]]'' (1984) (novel)\n* ''[[The Hitchhiker's Guide to the Galaxy (computer game)|The Hitchhiker's Guide to the Galaxy]]'' (1984, with [[Steve Meretzky]]) (computer game)\n* ''[[The Hitchhiker's Guide to the Galaxy: The Original Radio Scripts]]'' (1985, with [[Geoffrey Perkins]])\n* ''[[Young Zaphod Plays It Safe]] (short story)'' (1986)\n* ''[[A Christmas Fairly Story]]'' <template><title>sic</title></template> (1986, with [[Terry Jones]]), and\n* ''Supplement to The Meaning of Liff'' (1986, with [[John Lloyd (producer)|John Lloyd]] and [[Stephen Fry]]), both part of\n** ''[[The Utterly Utterly Merry Comic Relief Christmas Book]]'' (1986, edited with [[Peter Fincham]])\n* ''[[Bureaucracy (computer game)|Bureaucracy]]'' (1987) (computer game)\n* ''[[Dirk Gently's Holistic Detective Agency]]'' (1987) (novel)\n* ''[[The Long Dark Tea-Time of the Soul]]'' (1988) (novel)\n* ''[[The Deeper Meaning of Liff]]'' (1990, with [[John Lloyd (producer)|John Lloyd]])\n* ''[[Last Chance to See]]'' (1990, with [[Mark Carwardine]]) (book)\n* ''[[Mostly Harmless]]'' (1992) (novel)\n* ''[[The Hitchhiker's Guide to the Galaxy (book)#Illustrated edition|The Illustrated Hitchhiker's Guide to the Galaxy]]'' (1994)\n* ''[[Douglas Adams's Starship Titanic]]'' (1997), written by [[Terry Jones]], based on an idea by Adams\n* ''[[Starship Titanic]]'' (computer game) (1998)\n* ''[[h2g2]]'' (internet project) (1999)\n* ''The Internet: The Last Battleground of the 20th century'' (radio series) (2000)\n* ''[[The Hitchhiker's Guide to the Future]]'' (radio series) (2001) final project for [[BBC Radio 4]] before his death\n* ''[https://www.youtube.com/watch?v=_ZG8HBuDjgc Parrots, the universe and everything]'' (2001)\n* ''[[The Salmon of Doubt]]'' (2002), unfinished novel manuscript (11 chapters), short stories, essays, and interviews (also available as an audiobook, read by [[Simon Jones (actor)|Simon Jones]])\n*  ''[[The Hitchhiker's Guide to the Galaxy (film)|The Hitchhiker's Guide to the Galaxy]]'' (2005) (film)\n<template lineStart=\"1\"><title>Refend</title></template>\n\n<h level=\"2\" i=\"20\">==Writing credits==</h>\n{| class=&quot;wikitable&quot;\n|-  style=&quot;background:#ccc; text-align:center;&quot;\n! Production\n! Notes\n! Broadcaster\n|-\n|''[[Monty Python's Flying Circus]]''\n|\n*&quot;[[List of Monty Python's Flying Circus episodes#6. Party Political Broadcast|Party Political Broadcast on Behalf of the Liberal Party]]&quot; (1974)\n|[[BBC Two]]\n|-\n|''[[Out of the Trees]]''\n|\n*Television pilot (1976)\n|BBC Two\n|-\n|''[[Doctor on the Go]]''\n|\n*&quot;For Your Own Good&quot; (1977)\n|[[ITV (TV network)|ITV]]\n|-\n|''[[Doctor Who]]''\n|\n5 episodes (1978-1979, 1983): \n*&quot;[[The Pirate Planet]]&quot; (1978)\n*&quot;[[Destiny of the Daleks]]&quot; (1979) (uncredited)\n*&quot;[[City of Death]]&quot; (co-written with [[Graham Williams (television producer)|Graham Williams]], 1979)\n*&quot;[[The Five Doctors]]&quot; (1983) ([[Shada]] segments; uncredited)\n|[[BBC One]]\n|-\n|''[[Doctor Snuggles]]''\n|\n*&quot;The Great Disappearing Mystery&quot; (1979)\n*&quot;The Remarkable Fidgety River&quot; (1979)\n|ITV\n|-\n|''[[Not the Nine O'Clock News]]''\n|\n*Unknown episodes (1979)\n|BBC Two\n|-\n|''[[The Hitchhiker's Guide to the Galaxy (TV series)|The Hitchhiker's Guide to the Galaxy]]''\n|\n*6 episodes (1981)\n|BBC Two\n|-\n|''[[Hyperland]]''\n|\n*Television documentary (1990)\n|BBC Two\n|}\n\n<h level=\"2\" i=\"21\">==Notes==</h>\n<template lineStart=\"1\"><title>reflist</title><part><name index=\"1\"/><value>30em</value></part></template>\n\n<h level=\"2\" i=\"22\">==References==</h>\n* Adams, Douglas (1998). [http://www.biota.org/people/douglasadams/ Is there an Artificial God?], speech at ''Digital Biota 2'', Cambridge, England, September 1998.\n* <template><title>cite book</title><part><name>last</name><equals>=</equals><value>Adams</value></part><part><name>first</name><equals>=</equals><value>Douglas</value></part><part><name>title</name><equals>=</equals><value>The Salmon of Doubt: Hitchhiking the Galaxy One Last Time</value></part><part><name>year</name><equals>=</equals><value>2002</value></part><part><name>publisher</name><equals>=</equals><value>Macmillan</value></part><part><name>location</name><equals>=</equals><value>London</value></part><part><name>isbn</name><equals>=</equals><value>0-333-76657-1</value></part><part><name>ref</name><equals>=</equals><value>harv</value></part></template>\n* Dawkins, Richard (2003). &quot;Eulogy for Douglas Adams,&quot; in ''A devil's chaplain: reflections on hope, lies, science, and love''. Houghton Mifflin Harcourt.\n* Felch, Laura (2004). [http://www.bookslut.com/nonfiction/2004_05_002057.php Don't Panic: Douglas Adams and the Hitchhiker's Guide to the Galaxy by Neil Gaiman], May 2004\n* Ray, Mohit K (2007). ''Atlantic Companion to Literature in English'', Atlantic Publishers and Distributors. ISBN 81-269-0832-7\n* <template><title>cite book</title><part><name>last</name><equals>=</equals><value>Simpson</value></part><part><name>first</name><equals>=</equals><value>M. J.</value></part><part><name>title</name><equals>=</equals><value>[[Hitchhiker: A Biography of Douglas Adams]]</value></part><part><name>year</name><equals>=</equals><value>2003</value></part><part><name>publisher</name><equals>=</equals><value>Justin, Charles &amp; Co</value></part><part><name>location</name><equals>=</equals><value>Boston, Mass.</value></part><part><name>isbn</name><equals>=</equals><value>1-932112-17-0</value></part><part><name>edition</name><equals>=</equals><value>1st</value></part><part><name>ref</name><equals>=</equals><value>harv</value></part></template>\n* Webb, Nick (2005a). ''Wish You Were Here: The Official Biography of Douglas Adams''. Ballantine Books. ISBN 0-345-47650-6\n* Webb, Nick (2005b). [http://www.oxforddnb.com/view/article/75853 &quot;Adams, Douglas Noël (1952–2001)&quot;], ''Oxford Dictionary of National Biography'', Oxford University Press, January 2005. Retrieved 25 October 2005.\n\n<h level=\"2\" i=\"23\">==Further reading==</h>\n<h level=\"3\" i=\"24\">===Articles===</h>\n<template lineStart=\"1\"><title>Refbegin</title><part><name index=\"1\"/><value>30em</value></part></template>\n* Herbert, R. (1980). The Hitchhiker's Guide to the Galaxy (Book Review). Library Journal, 105(16), 1982.\n* Adams, J., &amp; Brown, R. (1981). The Hitchhiker's Guide to the Galaxy (Book Review). School Library Journal, 27(5), 74.\n* Nickerson, S. L. (1982). The Restaurant at the End of the Universe (Book). Library Journal, 107(4), 476.\n* Nickerson, S. L. (1982). Life, the Universe, and Everything (Book). Library Journal, 107(18), 2007.\n* Morner, C. (1982). The Restaurant at the End of the Universe (Book Review). School Library Journal, 28(8), 87.\n* Morner, C. (1983). Life, the Universe and Everything (Book Review). School Library Journal, 29(6), 93.\n* Shorb, B. (1985). So Long, and Thanks for All the Fish (Book). School Library Journal, 31(6), 90.\n* The Long Dark Tea-Time of the Soul (Book). (1989). Atlantic (02769077), 263(4), 99.\n* Hoffert, B., &amp; Quinn, J. (1990). Last Chance To See (Book). Library Journal, 115(16), 77.\n* Reed, S. S., &amp; Cook, I. I. (1991). Dances with kakapos. People, 35(19), 79.\n* Last Chance to See (Book). (1991). Science News, 139(8), 126.\n* Field, M. M., &amp; Steinberg, S. S. (1991). Douglas Adams. Publishers Weekly, 238(6), 62.\n* Dieter, W. (1991). Last Chance to See (Book). Smithsonian, 22(3), 140.\n* Dykhuis, R. (1991). Last Chance To See (Book). Library Journal, 116(1), 140.\n* Beatty, J. (1991). Good Show (Book). Atlantic (02769077), 267(3), 131.\n* A guide to the future. (1992). Maclean's, 106(44), 51.\n* Zinsser, J. (1993). Audio reviews: Fiction. Publishers Weekly, 240(9), 24.\n* Taylor, B., &amp; Annichiarico, M. (1993). Audio reviews. Library Journal, 118(2), 132.\n* Good reads. (1995). NetGuide, 2(4), 109.\n* Stone, B. (1998). The unsinkable starship. Newsweek, 131(15), 78.\n* Gaslin, G. (2001). Galaxy Quest. Entertainment Weekly, (599), 79.\n* So long, and thanks for all the fish. (2001). Economist, 359(8222), 79.\n* Geier, T., &amp; Raftery, B. M. (2001). Legacy. Entertainment Weekly, (597), 11.\n* Passages. (2001). Maclean's, 114(21), 13.\n* Don't panic! Douglas Adams to keynote Embedded show. (2001). Embedded Systems Programming, 14(3), 10.\n* Ehrenman, G. (2001). World Wide Weird. InternetWeek, (862), 15.\n* Zaleski, J. (2002). The Salmon of Doubt (Book). Publishers Weekly, 249(15), 43.\n* Mort, J. (2002). The Salmon of Doubt (Book). Booklist, 98(16), 1386.\n* Lewis, D. L. (2002). Last Time Round The Galaxy. Quadrant Magazine, 46(9), 84.\n* Burns, A. (2002). The Salmon of Doubt (Book). Library Journal, 127(15), 111.\n* Burns, A., &amp; Rhodes, B. (2002). The Restaurant at the End of the Universe (Book). Library Journal, 127(19), 118.\n* Kaveney, R. (2002). A cheerful whale. TLS, (5173), 23.\n* Pearl, N., &amp; Welch, R. (2003). The Hitchhiker's Guide To The Galaxy (Book). Library Journal, 128(11), 124.\n* Preying on composite materials. (2003). R&amp;D Magazine, 45(6), 44.\n* Webb, N. (2003). The Berkeley Hotel hostage. Bookseller, (5069), 25.\n* The author who toured the universe. (2003). Bookseller, (5060), 35.\n* Osmond, A. (2005). Only human. Sight &amp; Sound, 15(5), 12–15.\n* Culture vulture. (2005). Times Educational Supplement, (4640), 19.\n* Maughan, S. (2005). Audio Bestsellers/Fiction. Publishers Weekly, 252(30), 17.\n* Hitchhiker At The Science Museum. (2005). In Britain, 14(10), 9.\n* Rea, A. (2005). The Adams asteroids. New Scientist, 185(2488), 31.\n* Most Improbable Adventure. (2005). Popular Mechanics, 182(5), 32.\n* The Hitchhiker's Guide To The Galaxy: The Tertiary Phase. (2005). Publishers Weekly, 252(14), 21.\n* Bartelt, K. R. (2005). Wish You Were Here: The Official Biography of Douglas Adams. Library Journal, 130(4), 86.\n* Larsen, D. (2005). I was a teenage android. New Zealand Listener, 198(3390), 37–38.\n* Tanner, J. C. (2005). Simplicity: it's hard. Telecom Asia, 16(6), 6.\n* Nielsen Bookscan Charts. (2005). Bookseller, (5175), 18–21.\n* Buena Vista launches regional site to push Hitchhiker's movie. (2005). New Media Age, 9.\n* Shynola bring Beckland to life. (2005). Creative Review, 25(3), 24–26.\n* Carwardine, M. (15 September 2007). The baiji: So long and thanks for all the fish. New Scientist. pp.&amp;nbsp;50–53.\n* Czarniawska, B. (2008). Accounting and gender across times and places: An excursion into fiction. Accounting, Organizations &amp; Society, 33(1), 33–47.\n* Pope, M. (2008). Life, the Universe, Religion and Science. Issues, (82), 31–34.\n* Bearne, S. (2008). BBC builds site to trail Last Chance To See TV series. New Media Age, 08.\n* Arrow to reissue Adams. (2008). Bookseller, (5352), 14.\n* Page, B. (2008). Colfer is new Hitchhiker. Bookseller, (5350), 7.\n* I've got a perfect puzzle for you. (2009). Bookseller, (5404), 42.\n* Mostly Harmless.... (2009). Bookseller, (5374), 46.\n* Penguin and PanMac hitch a ride together. (2009). Bookseller, (5373), 6.\n* Adams, Douglas. Britannica Biographies [serial online]. October 2010;:1\n* Douglas (Noël) Adams (1952–2001). Hutchinson's Biography Database [serial online]. July 2011;:1\n* My life in books. (2011). Times Educational Supplement, (4940), 27.\n<template lineStart=\"1\"><title>Refend</title></template>\n\n<h level=\"3\" i=\"25\">===Other===</h>\n* <template><title>Wayback </title><part><name>df</name><equals>=</equals><value>yes</value></part><part><name>date</name><equals>=</equals><value>20110720193159 </value></part><part><name>url</name><equals>=</equals><value>http://www.douglasadams.com/ </value></part><part><name>title</name><equals>=</equals><value>Adams's official web site </value></part></template>, established by him, and still operated by [[The Digital Village]]\n* <template><title>TED speaker</title><part><name index=\"1\"/><value>douglas_adams</value></part></template>\n* [http://www.biota.org/people/douglasadams/ Douglas Adams speech at Digital Biota 2 (1998)] [http://www.biota.org/podcast/#DNA (The audio of the speech)]\n* [http://www.guardian.co.uk/books/2008/jun/09/douglasadams Guardian Books &quot;Author Page&quot;], with profile and links to further articles.\n* <template><title>Worldcat id</title><part><name>id</name><equals>=</equals><value>lccn-n80-76765</value></part></template>\n* [http://www.vintagemacworld.com/iifx.html Douglas Adams &amp; his Computer] article about his Mac IIfx\n* BBC2 &quot;Omnibus&quot; tribute to Adams, presented by Kirsty Wark, 4 August 2001\n* Mueller, Rick and Greengrass, Joel (2002). ''Life, The Universe and Douglas Adams'', documentary.\n* Simpson, M.J. (2001). ''The Pocket Essential Hitchhiker's Guide''. ISBN 1-903047-40-4. Updated April 2005 ISBN 1-904048-46-3\n* [http://www.bbc.co.uk/programmes/p00fpvbm Special edition of BBC Book Club featuring Douglas Adams], first broadcast 2 January 2000 on BBC Radio 4\n\n<h level=\"2\" i=\"26\">==External links==</h>\n<template lineStart=\"1\"><title>Library resources box\n </title><part><name>by</name><equals>=</equals><value>yes\n </value></part><part><name>viaf</name><equals>=</equals><value>113230702\n </value></part><part><name>label</name><equals>=</equals><value>Douglas Adams</value></part></template>\n<template lineStart=\"1\"><title>Spoken Wikipedia-2</title><part><name index=\"1\"/><value>2006-02-11</value></part><part><name index=\"2\"/><value>Douglas_Adams_Part_1.ogg</value></part><part><name index=\"3\"/><value>Douglas_Adams_Part_2.ogg</value></part></template>\n* <template><title>Commons category-inline</title></template>\n* <template><title>Wikiquote-inline</title></template>\n* <template><title>Find a Grave</title><part><name index=\"1\"/><value>22814</value></part></template>\n* <template><title>IMDb name</title><part><name index=\"1\"/><value>0010930</value></part></template>\n* [http://towelday.org/ Towel Day, 25 May]\n\n<template lineStart=\"1\"><title>s-start</title></template>\n<template lineStart=\"1\"><title>s-bef</title><part><name>before</name><equals>=</equals><value> [[Anthony Read]]</value></part></template> \n<template lineStart=\"1\"><title>s-ttl</title><part><name>title</name><equals>=</equals><value>''[[Doctor Who]]'' script editor</value></part><part><name>years</name><equals>=</equals><value>1979–80</value></part></template> \n<template lineStart=\"1\"><title>s-aft</title><part><name>after</name><equals>=</equals><value> [[Christopher H. Bidmead]]</value></part></template>\n<template lineStart=\"1\"><title>s-end</title></template>\n<template lineStart=\"1\"><title>Douglas Adams</title></template>\n<template lineStart=\"1\"><title>HitchhikerBooks</title></template>\n<template lineStart=\"1\"><title>Dirk Gently</title></template>\n<template lineStart=\"1\"><title>Doctor Who</title></template>\n<template lineStart=\"1\"><title>Infocom games</title></template>\n<template lineStart=\"1\"><title>animal rights</title><part><name>state</name><equals>=</equals><value>collapsed</value></part></template>\n\n<template lineStart=\"1\"><title>Authority control</title></template>\n\n<template lineStart=\"1\"><title>DEFAULTSORT:Adams, Douglas</title></template>\n[[Category:Douglas Adams| ]]\n[[Category:1952 births]]\n[[Category:2001 deaths]]\n[[Category:Alumni of St John's College, Cambridge]]\n[[Category:Animal rights advocates]]\n[[Category:Atheism activists]]\n[[Category:Audio book narrators]]\n[[Category:British social commentators]]\n[[Category:BBC radio producers]]\n[[Category:British child writers]]\n[[Category:Burials at Highgate Cemetery]]\n[[Category:English atheists]]\n[[Category:English comedy writers]]\n[[Category:English humanists]]\n[[Category:English humorists]]\n[[Category:English radio writers]]\n[[Category:English science fiction writers]]\n[[Category:English television writers]]\n[[Category:Infocom]]\n[[Category:Interactive fiction writers]]\n[[Category:Monty Python]]\n[[Category:Non-fiction environmental writers]]\n[[Category:People educated at Brentwood School (Essex)]]\n[[Category:People from Cambridge]]\n[[Category:Usenet people]]\n[[Category:Critics of religions]]\n[[Category:20th-century English novelists]]\n[[Category:21st-century British novelists]]</root>"
  }
}
"""

cache = {'query': query, 'response': response}
