# coding: utf-8

"""
    Insights Service API -test

    ---  ## Introduction to PlotRisk  PlotRisk is a module, which ease to create plot for the given area of interest and also   facilitate to check satellite indices, weather and yield data.    **Note**``  Indices, Weather and Yield data can be accessed based on features & subscriptions user has opted while onborading company.  ``    ### Important Definitions    **Plot** - A piece of land, represented by geojson structure i.e. Polygon, Multipolygon or a circle.    **Satellite metrics** - Satellite insights for the plots.    **Yield** - Yield mapping refers to the process of collecting georeferenced data on crop yield and characteristics, such as moisture content, while the crop is being harvested with an onboard yield monitor.    **Weather** - Weather data provides information about the weather and climate of a plot.    **GDD** - GDD (_Cumulative growing degree days_) is an index calculated from temperature data and is used to estimate the time needed for a crop or other organisms to reach a certain stage of development.      ### Prerequisites    1. Users who have already onboarded onto **SMARTFARM_PLUS**, enabled **PlotRisk** feature for atleast few plots will be able  to use these APIs.  ---  ## Resources  A resource is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```  For more details, see [CRUD Operations](https://docs.microsoft.com/en-us/iis-administration/api/crud) to learn more about it.    ---  ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as [Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST APIs.    **Swagger UI**    **Step 1.** Generate access tokens using **/token** resource      **Info** : ``If you are a SMARTFARM_PLUS user, you can request for tokens using tenant,username,password  ``    **Step 2.** Copy **_access_token_** from **Step 1**, then click on **Authorize** button and paste the token.    **Step 3.** Select an API resource and click on **_Try it out_**.    **Step 4.** Fill the headers such as _**TenantType**_, _**OrgId**_ & _**X-Api-Key**_.    **Info** :        TenantType is SF_PLUS_API, if user is onboarded onto SMARTFARM_PLUS platform            X-Api-Key can be obtained from Step 1        OrgId can be sf_plus_<tenant>. For example if tenant name is test, OrgId can be sf_plus_test  ``    **Step 5.**  Query parameters are optional. It filters result based on provided parameter value.  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```   **Step 6.** Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **swagger.json** hypelink at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ---  ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol.  **Access Token** is required to access PlotRisk APIs & same can be generated by following API on passing valid request payload (see Token API)  ```  POST   /tokens  ```    For more details, see [Authentication and Authorization](https://swagger.io/docs/specification/authentication/).    ---  ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    For more details on HTTP Status code, see [HTTP Status Codes](https://restfulapi.net/http-status-codes/)   # noqa: E501

    OpenAPI spec version: v1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class WeatherDataResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'created_date_time': 'datetime',
        'modified_date_time': 'datetime',
        'status': 'str',
        'properties': 'dict(str, object)',
        'tenant_type': 'str',
        'boundary_id': 'str',
        'plot_name': 'str',
        'external_id': 'str',
        'org_id': 'str',
        '_date': 'datetime',
        'weather': 'Weather',
        'gdd': 'Gdd'
    }

    attribute_map = {
        'id': 'id',
        'created_date_time': 'createdDateTime',
        'modified_date_time': 'modifiedDateTime',
        'status': 'status',
        'properties': 'properties',
        'tenant_type': 'tenantType',
        'boundary_id': 'boundaryId',
        'plot_name': 'plotName',
        'external_id': 'externalId',
        'org_id': 'orgId',
        '_date': 'date',
        'weather': 'weather',
        'gdd': 'gdd'
    }

    def __init__(self, id=None, created_date_time=None, modified_date_time=None, status=None, properties=None, tenant_type=None, boundary_id=None, plot_name=None, external_id=None, org_id=None, _date=None, weather=None, gdd=None):  # noqa: E501
        """WeatherDataResponse - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._created_date_time = None
        self._modified_date_time = None
        self._status = None
        self._properties = None
        self._tenant_type = None
        self._boundary_id = None
        self._plot_name = None
        self._external_id = None
        self._org_id = None
        self.__date = None
        self._weather = None
        self._gdd = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if created_date_time is not None:
            self.created_date_time = created_date_time
        if modified_date_time is not None:
            self.modified_date_time = modified_date_time
        if status is not None:
            self.status = status
        if properties is not None:
            self.properties = properties
        if tenant_type is not None:
            self.tenant_type = tenant_type
        if boundary_id is not None:
            self.boundary_id = boundary_id
        if plot_name is not None:
            self.plot_name = plot_name
        if external_id is not None:
            self.external_id = external_id
        if org_id is not None:
            self.org_id = org_id
        if _date is not None:
            self._date = _date
        if weather is not None:
            self.weather = weather
        if gdd is not None:
            self.gdd = gdd

    @property
    def id(self):
        """Gets the id of this WeatherDataResponse.  # noqa: E501


        :return: The id of this WeatherDataResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this WeatherDataResponse.


        :param id: The id of this WeatherDataResponse.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def created_date_time(self):
        """Gets the created_date_time of this WeatherDataResponse.  # noqa: E501


        :return: The created_date_time of this WeatherDataResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_date_time

    @created_date_time.setter
    def created_date_time(self, created_date_time):
        """Sets the created_date_time of this WeatherDataResponse.


        :param created_date_time: The created_date_time of this WeatherDataResponse.  # noqa: E501
        :type: datetime
        """

        self._created_date_time = created_date_time

    @property
    def modified_date_time(self):
        """Gets the modified_date_time of this WeatherDataResponse.  # noqa: E501


        :return: The modified_date_time of this WeatherDataResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._modified_date_time

    @modified_date_time.setter
    def modified_date_time(self, modified_date_time):
        """Sets the modified_date_time of this WeatherDataResponse.


        :param modified_date_time: The modified_date_time of this WeatherDataResponse.  # noqa: E501
        :type: datetime
        """

        self._modified_date_time = modified_date_time

    @property
    def status(self):
        """Gets the status of this WeatherDataResponse.  # noqa: E501


        :return: The status of this WeatherDataResponse.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this WeatherDataResponse.


        :param status: The status of this WeatherDataResponse.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def properties(self):
        """Gets the properties of this WeatherDataResponse.  # noqa: E501


        :return: The properties of this WeatherDataResponse.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this WeatherDataResponse.


        :param properties: The properties of this WeatherDataResponse.  # noqa: E501
        :type: dict(str, object)
        """

        self._properties = properties

    @property
    def tenant_type(self):
        """Gets the tenant_type of this WeatherDataResponse.  # noqa: E501


        :return: The tenant_type of this WeatherDataResponse.  # noqa: E501
        :rtype: str
        """
        return self._tenant_type

    @tenant_type.setter
    def tenant_type(self, tenant_type):
        """Sets the tenant_type of this WeatherDataResponse.


        :param tenant_type: The tenant_type of this WeatherDataResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["SMARTFARM", "SMARTFARM_PLUS", "SMARTRISK", "API_USER", "SF_PLUS_API"]  # noqa: E501
        if tenant_type not in allowed_values:
            raise ValueError(
                "Invalid value for `tenant_type` ({0}), must be one of {1}"  # noqa: E501
                .format(tenant_type, allowed_values)
            )

        self._tenant_type = tenant_type

    @property
    def boundary_id(self):
        """Gets the boundary_id of this WeatherDataResponse.  # noqa: E501


        :return: The boundary_id of this WeatherDataResponse.  # noqa: E501
        :rtype: str
        """
        return self._boundary_id

    @boundary_id.setter
    def boundary_id(self, boundary_id):
        """Sets the boundary_id of this WeatherDataResponse.


        :param boundary_id: The boundary_id of this WeatherDataResponse.  # noqa: E501
        :type: str
        """

        self._boundary_id = boundary_id

    @property
    def plot_name(self):
        """Gets the plot_name of this WeatherDataResponse.  # noqa: E501


        :return: The plot_name of this WeatherDataResponse.  # noqa: E501
        :rtype: str
        """
        return self._plot_name

    @plot_name.setter
    def plot_name(self, plot_name):
        """Sets the plot_name of this WeatherDataResponse.


        :param plot_name: The plot_name of this WeatherDataResponse.  # noqa: E501
        :type: str
        """

        self._plot_name = plot_name

    @property
    def external_id(self):
        """Gets the external_id of this WeatherDataResponse.  # noqa: E501


        :return: The external_id of this WeatherDataResponse.  # noqa: E501
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """Sets the external_id of this WeatherDataResponse.


        :param external_id: The external_id of this WeatherDataResponse.  # noqa: E501
        :type: str
        """

        self._external_id = external_id

    @property
    def org_id(self):
        """Gets the org_id of this WeatherDataResponse.  # noqa: E501


        :return: The org_id of this WeatherDataResponse.  # noqa: E501
        :rtype: str
        """
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Sets the org_id of this WeatherDataResponse.


        :param org_id: The org_id of this WeatherDataResponse.  # noqa: E501
        :type: str
        """

        self._org_id = org_id

    @property
    def _date(self):
        """Gets the _date of this WeatherDataResponse.  # noqa: E501


        :return: The _date of this WeatherDataResponse.  # noqa: E501
        :rtype: datetime
        """
        return self.__date

    @_date.setter
    def _date(self, _date):
        """Sets the _date of this WeatherDataResponse.


        :param _date: The _date of this WeatherDataResponse.  # noqa: E501
        :type: datetime
        """

        self.__date = _date

    @property
    def weather(self):
        """Gets the weather of this WeatherDataResponse.  # noqa: E501


        :return: The weather of this WeatherDataResponse.  # noqa: E501
        :rtype: Weather
        """
        return self._weather

    @weather.setter
    def weather(self, weather):
        """Sets the weather of this WeatherDataResponse.


        :param weather: The weather of this WeatherDataResponse.  # noqa: E501
        :type: Weather
        """

        self._weather = weather

    @property
    def gdd(self):
        """Gets the gdd of this WeatherDataResponse.  # noqa: E501


        :return: The gdd of this WeatherDataResponse.  # noqa: E501
        :rtype: Gdd
        """
        return self._gdd

    @gdd.setter
    def gdd(self, gdd):
        """Sets the gdd of this WeatherDataResponse.


        :param gdd: The gdd of this WeatherDataResponse.  # noqa: E501
        :type: Gdd
        """

        self._gdd = gdd

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WeatherDataResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WeatherDataResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
