# coding: utf-8

"""
    Insights Service API -test

    ---  ## Introduction to PlotRisk  PlotRisk is a module, which ease to create plot for the given area of interest and also   facilitate to check satellite indices, weather and yield data.    **Note**``  Indices, Weather and Yield data can be accessed based on features & subscriptions user has opted while onborading company.  ``    ### Important Definitions    **Plot** - A piece of land, represented by geojson structure i.e. Polygon, Multipolygon or a circle.    **Satellite metrics** - Satellite insights for the plots.    **Yield** - Yield mapping refers to the process of collecting georeferenced data on crop yield and characteristics, such as moisture content, while the crop is being harvested with an onboard yield monitor.    **Weather** - Weather data provides information about the weather and climate of a plot.    **GDD** - GDD (_Cumulative growing degree days_) is an index calculated from temperature data and is used to estimate the time needed for a crop or other organisms to reach a certain stage of development.      ### Prerequisites    1. Users who have already onboarded onto **SMARTFARM_PLUS**, enabled **PlotRisk** feature for atleast few plots will be able  to use these APIs.  ---  ## Resources  A resource is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```  For more details, see [CRUD Operations](https://docs.microsoft.com/en-us/iis-administration/api/crud) to learn more about it.    ---  ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as [Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST APIs.    **Swagger UI**    **Step 1.** Generate access tokens using **/token** resource      **Info** : ``If you are a SMARTFARM_PLUS user, you can request for tokens using tenant,username,password  ``    **Step 2.** Copy **_access_token_** from **Step 1**, then click on **Authorize** button and paste the token.    **Step 3.** Select an API resource and click on **_Try it out_**.    **Step 4.** Fill the headers such as _**TenantType**_, _**OrgId**_ & _**X-Api-Key**_.    **Info** :        TenantType is SF_PLUS_API, if user is onboarded onto SMARTFARM_PLUS platform            X-Api-Key can be obtained from Step 1        OrgId can be sf_plus_<tenant>. For example if tenant name is test, OrgId can be sf_plus_test  ``    **Step 5.**  Query parameters are optional. It filters result based on provided parameter value.  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```   **Step 6.** Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **swagger.json** hypelink at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ---  ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol.  **Access Token** is required to access PlotRisk APIs & same can be generated by following API on passing valid request payload (see Token API)  ```  POST   /tokens  ```    For more details, see [Authentication and Authorization](https://swagger.io/docs/specification/authentication/).    ---  ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    For more details on HTTP Status code, see [HTTP Status Codes](https://restfulapi.net/http-status-codes/)   # noqa: E501

    OpenAPI spec version: v1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class SatelliteMetricsResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'created_date_time': 'datetime',
        'modified_date_time': 'datetime',
        'status': 'str',
        'properties': 'dict(str, object)',
        'tenant_type': 'str',
        'org_id': 'str',
        'boundary_id': 'str',
        'boundary_type': 'str',
        'captured_date_time': 'datetime',
        'unit_version': 'str',
        'metrics': 'Metrics',
        'geo_hierarchy': 'list[dict(str, str)]',
        'model_info': 'ModelInfo'
    }

    attribute_map = {
        'id': 'id',
        'created_date_time': 'createdDateTime',
        'modified_date_time': 'modifiedDateTime',
        'status': 'status',
        'properties': 'properties',
        'tenant_type': 'tenantType',
        'org_id': 'orgId',
        'boundary_id': 'boundaryId',
        'boundary_type': 'boundaryType',
        'captured_date_time': 'capturedDateTime',
        'unit_version': 'unitVersion',
        'metrics': 'metrics',
        'geo_hierarchy': 'geoHierarchy',
        'model_info': 'modelInfo'
    }

    def __init__(self, id=None, created_date_time=None, modified_date_time=None, status=None, properties=None, tenant_type=None, org_id=None, boundary_id=None, boundary_type=None, captured_date_time=None, unit_version=None, metrics=None, geo_hierarchy=None, model_info=None):  # noqa: E501
        """SatelliteMetricsResponse - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._created_date_time = None
        self._modified_date_time = None
        self._status = None
        self._properties = None
        self._tenant_type = None
        self._org_id = None
        self._boundary_id = None
        self._boundary_type = None
        self._captured_date_time = None
        self._unit_version = None
        self._metrics = None
        self._geo_hierarchy = None
        self._model_info = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if created_date_time is not None:
            self.created_date_time = created_date_time
        if modified_date_time is not None:
            self.modified_date_time = modified_date_time
        if status is not None:
            self.status = status
        if properties is not None:
            self.properties = properties
        if tenant_type is not None:
            self.tenant_type = tenant_type
        if org_id is not None:
            self.org_id = org_id
        if boundary_id is not None:
            self.boundary_id = boundary_id
        if boundary_type is not None:
            self.boundary_type = boundary_type
        if captured_date_time is not None:
            self.captured_date_time = captured_date_time
        if unit_version is not None:
            self.unit_version = unit_version
        if metrics is not None:
            self.metrics = metrics
        if geo_hierarchy is not None:
            self.geo_hierarchy = geo_hierarchy
        if model_info is not None:
            self.model_info = model_info

    @property
    def id(self):
        """Gets the id of this SatelliteMetricsResponse.  # noqa: E501


        :return: The id of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SatelliteMetricsResponse.


        :param id: The id of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def created_date_time(self):
        """Gets the created_date_time of this SatelliteMetricsResponse.  # noqa: E501


        :return: The created_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_date_time

    @created_date_time.setter
    def created_date_time(self, created_date_time):
        """Sets the created_date_time of this SatelliteMetricsResponse.


        :param created_date_time: The created_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :type: datetime
        """

        self._created_date_time = created_date_time

    @property
    def modified_date_time(self):
        """Gets the modified_date_time of this SatelliteMetricsResponse.  # noqa: E501


        :return: The modified_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._modified_date_time

    @modified_date_time.setter
    def modified_date_time(self, modified_date_time):
        """Sets the modified_date_time of this SatelliteMetricsResponse.


        :param modified_date_time: The modified_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :type: datetime
        """

        self._modified_date_time = modified_date_time

    @property
    def status(self):
        """Gets the status of this SatelliteMetricsResponse.  # noqa: E501


        :return: The status of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SatelliteMetricsResponse.


        :param status: The status of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def properties(self):
        """Gets the properties of this SatelliteMetricsResponse.  # noqa: E501


        :return: The properties of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this SatelliteMetricsResponse.


        :param properties: The properties of this SatelliteMetricsResponse.  # noqa: E501
        :type: dict(str, object)
        """

        self._properties = properties

    @property
    def tenant_type(self):
        """Gets the tenant_type of this SatelliteMetricsResponse.  # noqa: E501


        :return: The tenant_type of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._tenant_type

    @tenant_type.setter
    def tenant_type(self, tenant_type):
        """Sets the tenant_type of this SatelliteMetricsResponse.


        :param tenant_type: The tenant_type of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["SMARTFARM", "SMARTFARM_PLUS", "SMARTRISK", "API_USER", "SF_PLUS_API"]  # noqa: E501
        if tenant_type not in allowed_values:
            raise ValueError(
                "Invalid value for `tenant_type` ({0}), must be one of {1}"  # noqa: E501
                .format(tenant_type, allowed_values)
            )

        self._tenant_type = tenant_type

    @property
    def org_id(self):
        """Gets the org_id of this SatelliteMetricsResponse.  # noqa: E501


        :return: The org_id of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Sets the org_id of this SatelliteMetricsResponse.


        :param org_id: The org_id of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """

        self._org_id = org_id

    @property
    def boundary_id(self):
        """Gets the boundary_id of this SatelliteMetricsResponse.  # noqa: E501


        :return: The boundary_id of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._boundary_id

    @boundary_id.setter
    def boundary_id(self, boundary_id):
        """Sets the boundary_id of this SatelliteMetricsResponse.


        :param boundary_id: The boundary_id of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """

        self._boundary_id = boundary_id

    @property
    def boundary_type(self):
        """Gets the boundary_type of this SatelliteMetricsResponse.  # noqa: E501


        :return: The boundary_type of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._boundary_type

    @boundary_type.setter
    def boundary_type(self, boundary_type):
        """Sets the boundary_type of this SatelliteMetricsResponse.


        :param boundary_type: The boundary_type of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["SURVEY", "REGION", "PLOT", "TILE"]  # noqa: E501
        if boundary_type not in allowed_values:
            raise ValueError(
                "Invalid value for `boundary_type` ({0}), must be one of {1}"  # noqa: E501
                .format(boundary_type, allowed_values)
            )

        self._boundary_type = boundary_type

    @property
    def captured_date_time(self):
        """Gets the captured_date_time of this SatelliteMetricsResponse.  # noqa: E501


        :return: The captured_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._captured_date_time

    @captured_date_time.setter
    def captured_date_time(self, captured_date_time):
        """Sets the captured_date_time of this SatelliteMetricsResponse.


        :param captured_date_time: The captured_date_time of this SatelliteMetricsResponse.  # noqa: E501
        :type: datetime
        """

        self._captured_date_time = captured_date_time

    @property
    def unit_version(self):
        """Gets the unit_version of this SatelliteMetricsResponse.  # noqa: E501


        :return: The unit_version of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: str
        """
        return self._unit_version

    @unit_version.setter
    def unit_version(self, unit_version):
        """Sets the unit_version of this SatelliteMetricsResponse.


        :param unit_version: The unit_version of this SatelliteMetricsResponse.  # noqa: E501
        :type: str
        """

        self._unit_version = unit_version

    @property
    def metrics(self):
        """Gets the metrics of this SatelliteMetricsResponse.  # noqa: E501


        :return: The metrics of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: Metrics
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """Sets the metrics of this SatelliteMetricsResponse.


        :param metrics: The metrics of this SatelliteMetricsResponse.  # noqa: E501
        :type: Metrics
        """

        self._metrics = metrics

    @property
    def geo_hierarchy(self):
        """Gets the geo_hierarchy of this SatelliteMetricsResponse.  # noqa: E501


        :return: The geo_hierarchy of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: list[dict(str, str)]
        """
        return self._geo_hierarchy

    @geo_hierarchy.setter
    def geo_hierarchy(self, geo_hierarchy):
        """Sets the geo_hierarchy of this SatelliteMetricsResponse.


        :param geo_hierarchy: The geo_hierarchy of this SatelliteMetricsResponse.  # noqa: E501
        :type: list[dict(str, str)]
        """

        self._geo_hierarchy = geo_hierarchy

    @property
    def model_info(self):
        """Gets the model_info of this SatelliteMetricsResponse.  # noqa: E501


        :return: The model_info of this SatelliteMetricsResponse.  # noqa: E501
        :rtype: ModelInfo
        """
        return self._model_info

    @model_info.setter
    def model_info(self, model_info):
        """Sets the model_info of this SatelliteMetricsResponse.


        :param model_info: The model_info of this SatelliteMetricsResponse.  # noqa: E501
        :type: ModelInfo
        """

        self._model_info = model_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SatelliteMetricsResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SatelliteMetricsResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
