# coding: utf-8

"""
    Insights Service API -test

    ---  ## Introduction to PlotRisk  PlotRisk is a module, which ease to create plot for the given area of interest and also   facilitate to check satellite indices, weather and yield data.    **Note**``  Indices, Weather and Yield data can be accessed based on features & subscriptions user has opted while onborading company.  ``    ### Important Definitions    **Plot** - A piece of land, represented by geojson structure i.e. Polygon, Multipolygon or a circle.    **Satellite metrics** - Satellite insights for the plots.    **Yield** - Yield mapping refers to the process of collecting georeferenced data on crop yield and characteristics, such as moisture content, while the crop is being harvested with an onboard yield monitor.    **Weather** - Weather data provides information about the weather and climate of a plot.    **GDD** - GDD (_Cumulative growing degree days_) is an index calculated from temperature data and is used to estimate the time needed for a crop or other organisms to reach a certain stage of development.      ### Prerequisites    1. Users who have already onboarded onto **SMARTFARM_PLUS**, enabled **PlotRisk** feature for atleast few plots will be able  to use these APIs.  ---  ## Resources  A resource is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```  For more details, see [CRUD Operations](https://docs.microsoft.com/en-us/iis-administration/api/crud) to learn more about it.    ---  ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as [Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST APIs.    **Swagger UI**    **Step 1.** Generate access tokens using **/token** resource      **Info** : ``If you are a SMARTFARM_PLUS user, you can request for tokens using tenant,username,password  ``    **Step 2.** Copy **_access_token_** from **Step 1**, then click on **Authorize** button and paste the token.    **Step 3.** Select an API resource and click on **_Try it out_**.    **Step 4.** Fill the headers such as _**TenantType**_, _**OrgId**_ & _**X-Api-Key**_.    **Info** :        TenantType is SF_PLUS_API, if user is onboarded onto SMARTFARM_PLUS platform            X-Api-Key can be obtained from Step 1        OrgId can be sf_plus_<tenant>. For example if tenant name is test, OrgId can be sf_plus_test  ``    **Step 5.**  Query parameters are optional. It filters result based on provided parameter value.  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```   **Step 6.** Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **swagger.json** hypelink at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ---  ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol.  **Access Token** is required to access PlotRisk APIs & same can be generated by following API on passing valid request payload (see Token API)  ```  POST   /tokens  ```    For more details, see [Authentication and Authorization](https://swagger.io/docs/specification/authentication/).    ---  ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    For more details on HTTP Status code, see [HTTP Status Codes](https://restfulapi.net/http-status-codes/)   # noqa: E501

    OpenAPI spec version: v1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PlotImageResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'boundary_id': 'str',
        'image_type': 'str',
        'image_name': 'str',
        '_date': 'str',
        'bytes': 'list[str]'
    }

    attribute_map = {
        'boundary_id': 'boundaryId',
        'image_type': 'imageType',
        'image_name': 'imageName',
        '_date': 'date',
        'bytes': 'bytes'
    }

    def __init__(self, boundary_id=None, image_type=None, image_name=None, _date=None, bytes=None):  # noqa: E501
        """PlotImageResponse - a model defined in Swagger"""  # noqa: E501
        self._boundary_id = None
        self._image_type = None
        self._image_name = None
        self.__date = None
        self._bytes = None
        self.discriminator = None
        if boundary_id is not None:
            self.boundary_id = boundary_id
        if image_type is not None:
            self.image_type = image_type
        if image_name is not None:
            self.image_name = image_name
        if _date is not None:
            self._date = _date
        if bytes is not None:
            self.bytes = bytes

    @property
    def boundary_id(self):
        """Gets the boundary_id of this PlotImageResponse.  # noqa: E501


        :return: The boundary_id of this PlotImageResponse.  # noqa: E501
        :rtype: str
        """
        return self._boundary_id

    @boundary_id.setter
    def boundary_id(self, boundary_id):
        """Sets the boundary_id of this PlotImageResponse.


        :param boundary_id: The boundary_id of this PlotImageResponse.  # noqa: E501
        :type: str
        """

        self._boundary_id = boundary_id

    @property
    def image_type(self):
        """Gets the image_type of this PlotImageResponse.  # noqa: E501


        :return: The image_type of this PlotImageResponse.  # noqa: E501
        :rtype: str
        """
        return self._image_type

    @image_type.setter
    def image_type(self, image_type):
        """Sets the image_type of this PlotImageResponse.


        :param image_type: The image_type of this PlotImageResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["PNG", "TIFF"]  # noqa: E501
        if image_type not in allowed_values:
            raise ValueError(
                "Invalid value for `image_type` ({0}), must be one of {1}"  # noqa: E501
                .format(image_type, allowed_values)
            )

        self._image_type = image_type

    @property
    def image_name(self):
        """Gets the image_name of this PlotImageResponse.  # noqa: E501


        :return: The image_name of this PlotImageResponse.  # noqa: E501
        :rtype: str
        """
        return self._image_name

    @image_name.setter
    def image_name(self, image_name):
        """Sets the image_name of this PlotImageResponse.


        :param image_name: The image_name of this PlotImageResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["ARVI", "CHI_Re", "CROP_HEALTH_CROP_GREENESS", "CROP_HEALTH_NITROGEN_UPTAKE", "CROP_WATER_STRESS_LSWI", "EVI", "HLM", "LAI2", "LSWI", "NDRE", "NDVI", "SAVI"]  # noqa: E501
        if image_name not in allowed_values:
            raise ValueError(
                "Invalid value for `image_name` ({0}), must be one of {1}"  # noqa: E501
                .format(image_name, allowed_values)
            )

        self._image_name = image_name

    @property
    def _date(self):
        """Gets the _date of this PlotImageResponse.  # noqa: E501


        :return: The _date of this PlotImageResponse.  # noqa: E501
        :rtype: str
        """
        return self.__date

    @_date.setter
    def _date(self, _date):
        """Sets the _date of this PlotImageResponse.


        :param _date: The _date of this PlotImageResponse.  # noqa: E501
        :type: str
        """

        self.__date = _date

    @property
    def bytes(self):
        """Gets the bytes of this PlotImageResponse.  # noqa: E501


        :return: The bytes of this PlotImageResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._bytes

    @bytes.setter
    def bytes(self, bytes):
        """Sets the bytes of this PlotImageResponse.


        :param bytes: The bytes of this PlotImageResponse.  # noqa: E501
        :type: list[str]
        """

        self._bytes = bytes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PlotImageResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PlotImageResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
