# coding: utf-8

"""
    Insights Service API -test

    ---  ## Introduction to PlotRisk  PlotRisk is a module, which ease to create plot for the given area of interest and also   facilitate to check satellite indices, weather and yield data.    **Note**``  Indices, Weather and Yield data can be accessed based on features & subscriptions user has opted while onborading company.  ``    ### Important Definitions    **Plot** - A piece of land, represented by geojson structure i.e. Polygon, Multipolygon or a circle.    **Satellite metrics** - Satellite insights for the plots.    **Yield** - Yield mapping refers to the process of collecting georeferenced data on crop yield and characteristics, such as moisture content, while the crop is being harvested with an onboard yield monitor.    **Weather** - Weather data provides information about the weather and climate of a plot.    **GDD** - GDD (_Cumulative growing degree days_) is an index calculated from temperature data and is used to estimate the time needed for a crop or other organisms to reach a certain stage of development.      ### Prerequisites    1. Users who have already onboarded onto **SMARTFARM_PLUS**, enabled **PlotRisk** feature for atleast few plots will be able  to use these APIs.  ---  ## Resources  A resource is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```  For more details, see [CRUD Operations](https://docs.microsoft.com/en-us/iis-administration/api/crud) to learn more about it.    ---  ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as [Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST APIs.    **Swagger UI**    **Step 1.** Generate access tokens using **/token** resource      **Info** : ``If you are a SMARTFARM_PLUS user, you can request for tokens using tenant,username,password  ``    **Step 2.** Copy **_access_token_** from **Step 1**, then click on **Authorize** button and paste the token.    **Step 3.** Select an API resource and click on **_Try it out_**.    **Step 4.** Fill the headers such as _**TenantType**_, _**OrgId**_ & _**X-Api-Key**_.    **Info** :        TenantType is SF_PLUS_API, if user is onboarded onto SMARTFARM_PLUS platform            X-Api-Key can be obtained from Step 1        OrgId can be sf_plus_<tenant>. For example if tenant name is test, OrgId can be sf_plus_test  ``    **Step 5.**  Query parameters are optional. It filters result based on provided parameter value.  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```   **Step 6.** Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **swagger.json** hypelink at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ---  ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol.  **Access Token** is required to access PlotRisk APIs & same can be generated by following API on passing valid request payload (see Token API)  ```  POST   /tokens  ```    For more details, see [Authentication and Authorization](https://swagger.io/docs/specification/authentication/).    ---  ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    For more details on HTTP Status code, see [HTTP Status Codes](https://restfulapi.net/http-status-codes/)   # noqa: E501

    OpenAPI spec version: v1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class BoundaryResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'created_date_time': 'datetime',
        'modified_date_time': 'datetime',
        'status': 'str',
        'properties': 'dict(str, object)',
        'parent_ids': 'list[str]',
        'tenant_type': 'str',
        'org_id': 'str',
        'name': 'str',
        'type': 'str',
        'current_level': 'str',
        'geohash': 'str',
        'area_in_hectares': 'float',
        'external_id': 'str',
        'tile_details': 'dict(str, list[str])',
        'geo_hierarchy': 'list[dict(str, str)]',
        'crop_details': 'list[CropDetail]'
    }

    attribute_map = {
        'id': 'id',
        'created_date_time': 'createdDateTime',
        'modified_date_time': 'modifiedDateTime',
        'status': 'status',
        'properties': 'properties',
        'parent_ids': 'parentIds',
        'tenant_type': 'tenantType',
        'org_id': 'orgId',
        'name': 'name',
        'type': 'type',
        'current_level': 'currentLevel',
        'geohash': 'geohash',
        'area_in_hectares': 'areaInHectares',
        'external_id': 'externalId',
        'tile_details': 'tileDetails',
        'geo_hierarchy': 'geoHierarchy',
        'crop_details': 'cropDetails'
    }

    def __init__(self, id=None, created_date_time=None, modified_date_time=None, status=None, properties=None, parent_ids=None, tenant_type=None, org_id=None, name=None, type=None, current_level=None, geohash=None, area_in_hectares=None, external_id=None, tile_details=None, geo_hierarchy=None, crop_details=None):  # noqa: E501
        """BoundaryResponse - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._created_date_time = None
        self._modified_date_time = None
        self._status = None
        self._properties = None
        self._parent_ids = None
        self._tenant_type = None
        self._org_id = None
        self._name = None
        self._type = None
        self._current_level = None
        self._geohash = None
        self._area_in_hectares = None
        self._external_id = None
        self._tile_details = None
        self._geo_hierarchy = None
        self._crop_details = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if created_date_time is not None:
            self.created_date_time = created_date_time
        if modified_date_time is not None:
            self.modified_date_time = modified_date_time
        if status is not None:
            self.status = status
        if properties is not None:
            self.properties = properties
        if parent_ids is not None:
            self.parent_ids = parent_ids
        if tenant_type is not None:
            self.tenant_type = tenant_type
        if org_id is not None:
            self.org_id = org_id
        if name is not None:
            self.name = name
        if type is not None:
            self.type = type
        if current_level is not None:
            self.current_level = current_level
        if geohash is not None:
            self.geohash = geohash
        if area_in_hectares is not None:
            self.area_in_hectares = area_in_hectares
        if external_id is not None:
            self.external_id = external_id
        if tile_details is not None:
            self.tile_details = tile_details
        if geo_hierarchy is not None:
            self.geo_hierarchy = geo_hierarchy
        if crop_details is not None:
            self.crop_details = crop_details

    @property
    def id(self):
        """Gets the id of this BoundaryResponse.  # noqa: E501


        :return: The id of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BoundaryResponse.


        :param id: The id of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def created_date_time(self):
        """Gets the created_date_time of this BoundaryResponse.  # noqa: E501


        :return: The created_date_time of this BoundaryResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_date_time

    @created_date_time.setter
    def created_date_time(self, created_date_time):
        """Sets the created_date_time of this BoundaryResponse.


        :param created_date_time: The created_date_time of this BoundaryResponse.  # noqa: E501
        :type: datetime
        """

        self._created_date_time = created_date_time

    @property
    def modified_date_time(self):
        """Gets the modified_date_time of this BoundaryResponse.  # noqa: E501


        :return: The modified_date_time of this BoundaryResponse.  # noqa: E501
        :rtype: datetime
        """
        return self._modified_date_time

    @modified_date_time.setter
    def modified_date_time(self, modified_date_time):
        """Sets the modified_date_time of this BoundaryResponse.


        :param modified_date_time: The modified_date_time of this BoundaryResponse.  # noqa: E501
        :type: datetime
        """

        self._modified_date_time = modified_date_time

    @property
    def status(self):
        """Gets the status of this BoundaryResponse.  # noqa: E501


        :return: The status of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BoundaryResponse.


        :param status: The status of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def properties(self):
        """Gets the properties of this BoundaryResponse.  # noqa: E501


        :return: The properties of this BoundaryResponse.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this BoundaryResponse.


        :param properties: The properties of this BoundaryResponse.  # noqa: E501
        :type: dict(str, object)
        """

        self._properties = properties

    @property
    def parent_ids(self):
        """Gets the parent_ids of this BoundaryResponse.  # noqa: E501


        :return: The parent_ids of this BoundaryResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._parent_ids

    @parent_ids.setter
    def parent_ids(self, parent_ids):
        """Sets the parent_ids of this BoundaryResponse.


        :param parent_ids: The parent_ids of this BoundaryResponse.  # noqa: E501
        :type: list[str]
        """

        self._parent_ids = parent_ids

    @property
    def tenant_type(self):
        """Gets the tenant_type of this BoundaryResponse.  # noqa: E501


        :return: The tenant_type of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._tenant_type

    @tenant_type.setter
    def tenant_type(self, tenant_type):
        """Sets the tenant_type of this BoundaryResponse.


        :param tenant_type: The tenant_type of this BoundaryResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["SMARTFARM", "SMARTFARM_PLUS", "SMARTRISK", "API_USER", "SF_PLUS_API"]  # noqa: E501
        if tenant_type not in allowed_values:
            raise ValueError(
                "Invalid value for `tenant_type` ({0}), must be one of {1}"  # noqa: E501
                .format(tenant_type, allowed_values)
            )

        self._tenant_type = tenant_type

    @property
    def org_id(self):
        """Gets the org_id of this BoundaryResponse.  # noqa: E501


        :return: The org_id of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Sets the org_id of this BoundaryResponse.


        :param org_id: The org_id of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._org_id = org_id

    @property
    def name(self):
        """Gets the name of this BoundaryResponse.  # noqa: E501


        :return: The name of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BoundaryResponse.


        :param name: The name of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """Gets the type of this BoundaryResponse.  # noqa: E501


        :return: The type of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BoundaryResponse.


        :param type: The type of this BoundaryResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["SURVEY", "REGION", "PLOT", "TILE"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def current_level(self):
        """Gets the current_level of this BoundaryResponse.  # noqa: E501


        :return: The current_level of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._current_level

    @current_level.setter
    def current_level(self, current_level):
        """Sets the current_level of this BoundaryResponse.


        :param current_level: The current_level of this BoundaryResponse.  # noqa: E501
        :type: str
        """
        allowed_values = ["LEVEL_1", "LEVEL_2", "LEVEL_3", "LEVEL_4", "LEVEL_5", "LEVEL_6", "LEVEL_7"]  # noqa: E501
        if current_level not in allowed_values:
            raise ValueError(
                "Invalid value for `current_level` ({0}), must be one of {1}"  # noqa: E501
                .format(current_level, allowed_values)
            )

        self._current_level = current_level

    @property
    def geohash(self):
        """Gets the geohash of this BoundaryResponse.  # noqa: E501


        :return: The geohash of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._geohash

    @geohash.setter
    def geohash(self, geohash):
        """Sets the geohash of this BoundaryResponse.


        :param geohash: The geohash of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._geohash = geohash

    @property
    def area_in_hectares(self):
        """Gets the area_in_hectares of this BoundaryResponse.  # noqa: E501


        :return: The area_in_hectares of this BoundaryResponse.  # noqa: E501
        :rtype: float
        """
        return self._area_in_hectares

    @area_in_hectares.setter
    def area_in_hectares(self, area_in_hectares):
        """Sets the area_in_hectares of this BoundaryResponse.


        :param area_in_hectares: The area_in_hectares of this BoundaryResponse.  # noqa: E501
        :type: float
        """

        self._area_in_hectares = area_in_hectares

    @property
    def external_id(self):
        """Gets the external_id of this BoundaryResponse.  # noqa: E501


        :return: The external_id of this BoundaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """Sets the external_id of this BoundaryResponse.


        :param external_id: The external_id of this BoundaryResponse.  # noqa: E501
        :type: str
        """

        self._external_id = external_id

    @property
    def tile_details(self):
        """Gets the tile_details of this BoundaryResponse.  # noqa: E501


        :return: The tile_details of this BoundaryResponse.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._tile_details

    @tile_details.setter
    def tile_details(self, tile_details):
        """Sets the tile_details of this BoundaryResponse.


        :param tile_details: The tile_details of this BoundaryResponse.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._tile_details = tile_details

    @property
    def geo_hierarchy(self):
        """Gets the geo_hierarchy of this BoundaryResponse.  # noqa: E501


        :return: The geo_hierarchy of this BoundaryResponse.  # noqa: E501
        :rtype: list[dict(str, str)]
        """
        return self._geo_hierarchy

    @geo_hierarchy.setter
    def geo_hierarchy(self, geo_hierarchy):
        """Sets the geo_hierarchy of this BoundaryResponse.


        :param geo_hierarchy: The geo_hierarchy of this BoundaryResponse.  # noqa: E501
        :type: list[dict(str, str)]
        """

        self._geo_hierarchy = geo_hierarchy

    @property
    def crop_details(self):
        """Gets the crop_details of this BoundaryResponse.  # noqa: E501


        :return: The crop_details of this BoundaryResponse.  # noqa: E501
        :rtype: list[CropDetail]
        """
        return self._crop_details

    @crop_details.setter
    def crop_details(self, crop_details):
        """Sets the crop_details of this BoundaryResponse.


        :param crop_details: The crop_details of this BoundaryResponse.  # noqa: E501
        :type: list[CropDetail]
        """

        self._crop_details = crop_details

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BoundaryResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BoundaryResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
