# coding: utf-8

"""
    Insights Service API -test

    ---  ## Introduction to PlotRisk  PlotRisk is a module, which ease to create plot for the given area of interest and also   facilitate to check satellite indices, weather and yield data.    **Note**``  Indices, Weather and Yield data can be accessed based on features & subscriptions user has opted while onborading company.  ``    ### Important Definitions    **Plot** - A piece of land, represented by geojson structure i.e. Polygon, Multipolygon or a circle.    **Satellite metrics** - Satellite insights for the plots.    **Yield** - Yield mapping refers to the process of collecting georeferenced data on crop yield and characteristics, such as moisture content, while the crop is being harvested with an onboard yield monitor.    **Weather** - Weather data provides information about the weather and climate of a plot.    **GDD** - GDD (_Cumulative growing degree days_) is an index calculated from temperature data and is used to estimate the time needed for a crop or other organisms to reach a certain stage of development.      ### Prerequisites    1. Users who have already onboarded onto **SMARTFARM_PLUS**, enabled **PlotRisk** feature for atleast few plots will be able  to use these APIs.  ---  ## Resources  A resource is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```  For more details, see [CRUD Operations](https://docs.microsoft.com/en-us/iis-administration/api/crud) to learn more about it.    ---  ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as [Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST APIs.    **Swagger UI**    **Step 1.** Generate access tokens using **/token** resource      **Info** : ``If you are a SMARTFARM_PLUS user, you can request for tokens using tenant,username,password  ``    **Step 2.** Copy **_access_token_** from **Step 1**, then click on **Authorize** button and paste the token.    **Step 3.** Select an API resource and click on **_Try it out_**.    **Step 4.** Fill the headers such as _**TenantType**_, _**OrgId**_ & _**X-Api-Key**_.    **Info** :        TenantType is SF_PLUS_API, if user is onboarded onto SMARTFARM_PLUS platform            X-Api-Key can be obtained from Step 1        OrgId can be sf_plus_<tenant>. For example if tenant name is test, OrgId can be sf_plus_test  ``    **Step 5.**  Query parameters are optional. It filters result based on provided parameter value.  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```   **Step 6.** Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **swagger.json** hypelink at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ---  ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol.  **Access Token** is required to access PlotRisk APIs & same can be generated by following API on passing valid request payload (see Token API)  ```  POST   /tokens  ```    For more details, see [Authentication and Authorization](https://swagger.io/docs/specification/authentication/).    ---  ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    For more details on HTTP Status code, see [HTTP Status Codes](https://restfulapi.net/http-status-codes/)   # noqa: E501

    OpenAPI spec version: v1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AccessTokenResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_token': 'str',
        'expires_in': 'int',
        'refresh_token': 'str',
        'refresh_expires_in': 'int',
        'token_type': 'str',
        'x_api_key': 'str'
    }

    attribute_map = {
        'access_token': 'access_token',
        'expires_in': 'expires_in',
        'refresh_token': 'refresh_token',
        'refresh_expires_in': 'refresh_expires_in',
        'token_type': 'token_type',
        'x_api_key': 'X-Api-Key'
    }

    def __init__(self, access_token=None, expires_in=None, refresh_token=None, refresh_expires_in=None, token_type=None, x_api_key=None):  # noqa: E501
        """AccessTokenResponse - a model defined in Swagger"""  # noqa: E501
        self._access_token = None
        self._expires_in = None
        self._refresh_token = None
        self._refresh_expires_in = None
        self._token_type = None
        self._x_api_key = None
        self.discriminator = None
        if access_token is not None:
            self.access_token = access_token
        if expires_in is not None:
            self.expires_in = expires_in
        if refresh_token is not None:
            self.refresh_token = refresh_token
        if refresh_expires_in is not None:
            self.refresh_expires_in = refresh_expires_in
        if token_type is not None:
            self.token_type = token_type
        if x_api_key is not None:
            self.x_api_key = x_api_key

    @property
    def access_token(self):
        """Gets the access_token of this AccessTokenResponse.  # noqa: E501


        :return: The access_token of this AccessTokenResponse.  # noqa: E501
        :rtype: str
        """
        return self._access_token

    @access_token.setter
    def access_token(self, access_token):
        """Sets the access_token of this AccessTokenResponse.


        :param access_token: The access_token of this AccessTokenResponse.  # noqa: E501
        :type: str
        """

        self._access_token = access_token

    @property
    def expires_in(self):
        """Gets the expires_in of this AccessTokenResponse.  # noqa: E501


        :return: The expires_in of this AccessTokenResponse.  # noqa: E501
        :rtype: int
        """
        return self._expires_in

    @expires_in.setter
    def expires_in(self, expires_in):
        """Sets the expires_in of this AccessTokenResponse.


        :param expires_in: The expires_in of this AccessTokenResponse.  # noqa: E501
        :type: int
        """

        self._expires_in = expires_in

    @property
    def refresh_token(self):
        """Gets the refresh_token of this AccessTokenResponse.  # noqa: E501


        :return: The refresh_token of this AccessTokenResponse.  # noqa: E501
        :rtype: str
        """
        return self._refresh_token

    @refresh_token.setter
    def refresh_token(self, refresh_token):
        """Sets the refresh_token of this AccessTokenResponse.


        :param refresh_token: The refresh_token of this AccessTokenResponse.  # noqa: E501
        :type: str
        """

        self._refresh_token = refresh_token

    @property
    def refresh_expires_in(self):
        """Gets the refresh_expires_in of this AccessTokenResponse.  # noqa: E501


        :return: The refresh_expires_in of this AccessTokenResponse.  # noqa: E501
        :rtype: int
        """
        return self._refresh_expires_in

    @refresh_expires_in.setter
    def refresh_expires_in(self, refresh_expires_in):
        """Sets the refresh_expires_in of this AccessTokenResponse.


        :param refresh_expires_in: The refresh_expires_in of this AccessTokenResponse.  # noqa: E501
        :type: int
        """

        self._refresh_expires_in = refresh_expires_in

    @property
    def token_type(self):
        """Gets the token_type of this AccessTokenResponse.  # noqa: E501


        :return: The token_type of this AccessTokenResponse.  # noqa: E501
        :rtype: str
        """
        return self._token_type

    @token_type.setter
    def token_type(self, token_type):
        """Sets the token_type of this AccessTokenResponse.


        :param token_type: The token_type of this AccessTokenResponse.  # noqa: E501
        :type: str
        """

        self._token_type = token_type

    @property
    def x_api_key(self):
        """Gets the x_api_key of this AccessTokenResponse.  # noqa: E501


        :return: The x_api_key of this AccessTokenResponse.  # noqa: E501
        :rtype: str
        """
        return self._x_api_key

    @x_api_key.setter
    def x_api_key(self, x_api_key):
        """Sets the x_api_key of this AccessTokenResponse.


        :param x_api_key: The x_api_key of this AccessTokenResponse.  # noqa: E501
        :type: str
        """

        self._x_api_key = x_api_key

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AccessTokenResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccessTokenResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
