# coding: utf-8

"""
    Insights Service API -test

    ---  ## Introduction to PlotRisk  PlotRisk is a module, which ease to create plot for the given area of interest and also   facilitate to check satellite indices, weather and yield data.    **Note**``  Indices, Weather and Yield data can be accessed based on features & subscriptions user has opted while onborading company.  ``    ### Important Definitions    **Plot** - A piece of land, represented by geojson structure i.e. Polygon, Multipolygon or a circle.    **Satellite metrics** - Satellite insights for the plots.    **Yield** - Yield mapping refers to the process of collecting georeferenced data on crop yield and characteristics, such as moisture content, while the crop is being harvested with an onboard yield monitor.    **Weather** - Weather data provides information about the weather and climate of a plot.    **GDD** - GDD (_Cumulative growing degree days_) is an index calculated from temperature data and is used to estimate the time needed for a crop or other organisms to reach a certain stage of development.      ### Prerequisites    1. Users who have already onboarded onto **SMARTFARM_PLUS**, enabled **PlotRisk** feature for atleast few plots will be able  to use these APIs.  ---  ## Resources  A resource is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```  For more details, see [CRUD Operations](https://docs.microsoft.com/en-us/iis-administration/api/crud) to learn more about it.    ---  ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as [Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST APIs.    **Swagger UI**    **Step 1.** Generate access tokens using **/token** resource      **Info** : ``If you are a SMARTFARM_PLUS user, you can request for tokens using tenant,username,password  ``    **Step 2.** Copy **_access_token_** from **Step 1**, then click on **Authorize** button and paste the token.    **Step 3.** Select an API resource and click on **_Try it out_**.    **Step 4.** Fill the headers such as _**TenantType**_, _**OrgId**_ & _**X-Api-Key**_.    **Info** :        TenantType is SF_PLUS_API, if user is onboarded onto SMARTFARM_PLUS platform            X-Api-Key can be obtained from Step 1        OrgId can be sf_plus_<tenant>. For example if tenant name is test, OrgId can be sf_plus_test  ``    **Step 5.**  Query parameters are optional. It filters result based on provided parameter value.  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```   **Step 6.** Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **swagger.json** hypelink at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ---  ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol.  **Access Token** is required to access PlotRisk APIs & same can be generated by following API on passing valid request payload (see Token API)  ```  POST   /tokens  ```    For more details, see [Authentication and Authorization](https://swagger.io/docs/specification/authentication/).    ---  ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    For more details on HTTP Status code, see [HTTP Status Codes](https://restfulapi.net/http-status-codes/)   # noqa: E501

    OpenAPI spec version: v1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from insights_python_client.api_client import ApiClient


class TokenApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_token(self, body, **kwargs):  # noqa: E501
        """Generate token to authenticate  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_token(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessTokenRequest body: (required)
        :return: AccessTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_token_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_token_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_token_with_http_info(self, body, **kwargs):  # noqa: E501
        """Generate token to authenticate  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_token_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessTokenRequest body: (required)
        :return: AccessTokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `get_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/tokens', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccessTokenResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
