# insights_python_client
---  ## Introduction to PlotRisk  PlotRisk is a module, which ease to create plot for the given area of interest and also   facilitate to check satellite indices, weather and yield data.    **Note**``  Indices, Weather and Yield data can be accessed based on features & subscriptions user has opted while onborading company.  ``    ### Important Definitions    **Plot** - A piece of land, represented by geojson structure i.e. Polygon, Multipolygon or a circle.    **Satellite metrics** - Satellite insights for the plots.    **Yield** - Yield mapping refers to the process of collecting georeferenced data on crop yield and characteristics, such as moisture content, while the crop is being harvested with an onboard yield monitor.    **Weather** - Weather data provides information about the weather and climate of a plot.    **GDD** - GDD (_Cumulative growing degree days_) is an index calculated from temperature data and is used to estimate the time needed for a crop or other organisms to reach a certain stage of development.      ### Prerequisites    1. Users who have already onboarded onto **SMARTFARM_PLUS**, enabled **PlotRisk** feature for atleast few plots will be able  to use these APIs.  ---  ## Resources  A resource is an entity that has a set of exposed operations. The entity can represent an actual object (account, users..) or a set of logical operations collated together. It is up to the specification user to decide whether sub-resources should be referred to as part of their main resource or as a resource of their own. For example, assume the following URL set:     ```    /users         -GET                   POST                    /users/{id}    -GET                   PATCH                   DELETE   ```  For more details, see [CRUD Operations](https://docs.microsoft.com/en-us/iis-administration/api/crud) to learn more about it.    ---  ## Trying the API  You can use [Swagger UI](https://swagger.io/tools/swagger-ui/) or any third party client such as [Postman](https://www.postman.com/), [cURL](https://curl.se/) etc. to test the REST APIs.    **Swagger UI**    **Step 1.** Generate access tokens using **/token** resource      **Info** : ``If you are a SMARTFARM_PLUS user, you can request for tokens using tenant,username,password  ``    **Step 2.** Copy **_access_token_** from **Step 1**, then click on **Authorize** button and paste the token.    **Step 3.** Select an API resource and click on **_Try it out_**.    **Step 4.** Fill the headers such as _**TenantType**_, _**OrgId**_ & _**X-Api-Key**_.    **Info** :        TenantType is SF_PLUS_API, if user is onboarded onto SMARTFARM_PLUS platform            X-Api-Key can be obtained from Step 1        OrgId can be sf_plus_<tenant>. For example if tenant name is test, OrgId can be sf_plus_test  ``    **Step 5.**  Query parameters are optional. It filters result based on provided parameter value.  ```   e.g.   {           \"size\": 300,           \"page\": 0,          }             e.g.   {          }            ```   **Step 6.** Click on **Execute**    **Curl**  ```  curl -X 'GET' \\  'http://localhost:8085/api/v1/crops' \\  -H 'accept: application/json' \\  -H 'TenantType: SMARTRISK' \\  -H 'orgId: test' \\  -H 'X-Api-Key: qwjokooopppp' \\  -H 'Authorization: Bearer jklkopalkddlplplllllllllll2340k'  ```  Using a graphical tool such as Postman, it is possible to import the API specifications directly:    - Download the API specification by clicking the **swagger.json** hypelink at top of this document  - Import the JSON specification in the graphical tool of your choice.  - In *Postman*, you can click the import button at the top    ---  ## Authentication  The API authentication process validates the identity of the client attempting to make a connection by using an authentication protocol.  **Access Token** is required to access PlotRisk APIs & same can be generated by following API on passing valid request payload (see Token API)  ```  POST   /tokens  ```    For more details, see [Authentication and Authorization](https://swagger.io/docs/specification/authentication/).    ---  ## Errors  The REST API reports errors by returning an appropriate HTTP response code, for example 404 (Not Found), and a JSON response. Any HTTP response code that is not in the range 200 - 299 is considered an error.    For more details on HTTP Status code, see [HTTP Status Codes](https://restfulapi.net/http-status-codes/) 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1.0
- Package version: 0.0.2
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import insights_python_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import insights_python_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import insights_python_client
from insights_python_client.rest import ApiException
from pprint import pprint


# create an instance of the API class
api_instance = insights_python_client.FileApi(insights_python_client.ApiClient(configuration))
tenant_type = 'tenant_type_example' # str | TenantType is an identifier to track API usage. Valid input : 'SF_PLUS_API'
x_api_key = 'x_api_key_example' # str | Security key to grant access to APIs
boundary_id = 'boundary_id_example' # str | Unique identifier for plot, e.g. boundaryId = 4d35861
_date = '_date_example' # str | Indicates captured satellite date in yyyy-MM-dd format, e.g. date=2022-03-15
image_name = 'image_name_example' # str | Plot image name, e.g imageName = NDRE
org_id = 'org_id_example' # str | OrgId represents unique Id for a company or entity (optional)
image_type = 'image_type_example' # str | Plot image type, e.g imageType = TIFF (optional)

try:
    # Download plot images
    api_response = api_instance.get_plot_image_for_satellite_and_health_indices(tenant_type, x_api_key, boundary_id, _date, image_name, org_id=org_id, image_type=image_type)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling FileApi->get_plot_image_for_satellite_and_health_indices: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://t608jbcx83.execute-api.ap-southeast-1.amazonaws.com/dev/{basePath}*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*FileApi* | [**get_plot_image_for_satellite_and_health_indices**](docs/FileApi.md#get_plot_image_for_satellite_and_health_indices) | **GET** /download | Download plot images
*MetricsApi* | [**list_all2**](docs/MetricsApi.md#list_all2) | **GET** /satellite | Get satellite metrics
*PlotApi* | [**list_all3**](docs/PlotApi.md#list_all3) | **GET** /plots | Get plots
*TokenApi* | [**get_token**](docs/TokenApi.md#get_token) | **POST** /tokens | Generate token to authenticate
*WeatherApi* | [**list_all1**](docs/WeatherApi.md#list_all1) | **GET** /weather | Get weather data
*YieldApi* | [**list_all**](docs/YieldApi.md#list_all) | **GET** /yield | Get yield data

## Documentation For Models

 - [AccessTokenRequest](docs/AccessTokenRequest.md)
 - [AccessTokenResponse](docs/AccessTokenResponse.md)
 - [BoundaryMetrics](docs/BoundaryMetrics.md)
 - [BoundaryResponse](docs/BoundaryResponse.md)
 - [CropDetail](docs/CropDetail.md)
 - [CropMetric](docs/CropMetric.md)
 - [CustomErrorResponse](docs/CustomErrorResponse.md)
 - [Gdd](docs/Gdd.md)
 - [Metrics](docs/Metrics.md)
 - [ModelInfo](docs/ModelInfo.md)
 - [PlotImageResponse](docs/PlotImageResponse.md)
 - [SatelliteMetricsResponse](docs/SatelliteMetricsResponse.md)
 - [Weather](docs/Weather.md)
 - [WeatherDataResponse](docs/WeatherDataResponse.md)
 - [YieldResponse](docs/YieldResponse.md)
 - [YieldsData](docs/YieldsData.md)

## Documentation For Authorization


## OAuth



## Author


