# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class SignalDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'execution_id': 'str',
        'variables': 'dict(str, VariableValueDto)',
        'tenant_id': 'str',
        'without_tenant_id': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'execution_id': 'executionId',
        'variables': 'variables',
        'tenant_id': 'tenantId',
        'without_tenant_id': 'withoutTenantId'
    }

    def __init__(self, name=None, execution_id=None, variables=None, tenant_id=None, without_tenant_id=None, local_vars_configuration=None):  # noqa: E501
        """SignalDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._execution_id = None
        self._variables = None
        self._tenant_id = None
        self._without_tenant_id = None
        self.discriminator = None

        if name is not None:
            self.name = name
        self.execution_id = execution_id
        self.variables = variables
        self.tenant_id = tenant_id
        self.without_tenant_id = without_tenant_id

    @property
    def name(self):
        """Gets the name of this SignalDto.  # noqa: E501

        The name of the signal to deliver.  **Note**: This property is mandatory.  # noqa: E501

        :return: The name of this SignalDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SignalDto.

        The name of the signal to deliver.  **Note**: This property is mandatory.  # noqa: E501

        :param name: The name of this SignalDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def execution_id(self):
        """Gets the execution_id of this SignalDto.  # noqa: E501

        Optionally specifies a single execution which is notified by the signal.  **Note**: If no execution id is defined the signal is broadcasted to all subscribed handlers.   # noqa: E501

        :return: The execution_id of this SignalDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this SignalDto.

        Optionally specifies a single execution which is notified by the signal.  **Note**: If no execution id is defined the signal is broadcasted to all subscribed handlers.   # noqa: E501

        :param execution_id: The execution_id of this SignalDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def variables(self):
        """Gets the variables of this SignalDto.  # noqa: E501

        A JSON object containing variable key-value pairs. Each key is a variable name and each value a JSON variable value object.  # noqa: E501

        :return: The variables of this SignalDto.  # noqa: E501
        :rtype: dict(str, VariableValueDto)
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """Sets the variables of this SignalDto.

        A JSON object containing variable key-value pairs. Each key is a variable name and each value a JSON variable value object.  # noqa: E501

        :param variables: The variables of this SignalDto.  # noqa: E501
        :type: dict(str, VariableValueDto)
        """

        self._variables = variables

    @property
    def tenant_id(self):
        """Gets the tenant_id of this SignalDto.  # noqa: E501

        Specifies a tenant to deliver the signal. The signal can only be received on executions or process definitions which belongs to the given tenant.  **Note**: Cannot be used in combination with executionId.  # noqa: E501

        :return: The tenant_id of this SignalDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this SignalDto.

        Specifies a tenant to deliver the signal. The signal can only be received on executions or process definitions which belongs to the given tenant.  **Note**: Cannot be used in combination with executionId.  # noqa: E501

        :param tenant_id: The tenant_id of this SignalDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this SignalDto.  # noqa: E501

        If true the signal can only be received on executions or process definitions which belongs to no tenant. Value may not be false as this is the default behavior.  **Note**: Cannot be used in combination with `executionId`.  # noqa: E501

        :return: The without_tenant_id of this SignalDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this SignalDto.

        If true the signal can only be received on executions or process definitions which belongs to no tenant. Value may not be false as this is the default behavior.  **Note**: Cannot be used in combination with `executionId`.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this SignalDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SignalDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SignalDto):
            return True

        return self.to_dict() != other.to_dict()
