# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class ModificationDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'process_definition_id': 'str',
        'skip_custom_listeners': 'bool',
        'skip_io_mappings': 'bool',
        'process_instance_ids': 'list[str]',
        'process_instance_query': 'ProcessInstanceQueryDto',
        'instructions': 'list[MultipleProcessInstanceModificationInstructionDto]',
        'annotation': 'str'
    }

    attribute_map = {
        'process_definition_id': 'processDefinitionId',
        'skip_custom_listeners': 'skipCustomListeners',
        'skip_io_mappings': 'skipIoMappings',
        'process_instance_ids': 'processInstanceIds',
        'process_instance_query': 'processInstanceQuery',
        'instructions': 'instructions',
        'annotation': 'annotation'
    }

    def __init__(self, process_definition_id=None, skip_custom_listeners=None, skip_io_mappings=None, process_instance_ids=None, process_instance_query=None, instructions=None, annotation=None, local_vars_configuration=None):  # noqa: E501
        """ModificationDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._process_definition_id = None
        self._skip_custom_listeners = None
        self._skip_io_mappings = None
        self._process_instance_ids = None
        self._process_instance_query = None
        self._instructions = None
        self._annotation = None
        self.discriminator = None

        self.process_definition_id = process_definition_id
        self.skip_custom_listeners = skip_custom_listeners
        self.skip_io_mappings = skip_io_mappings
        self.process_instance_ids = process_instance_ids
        if process_instance_query is not None:
            self.process_instance_query = process_instance_query
        self.instructions = instructions
        self.annotation = annotation

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this ModificationDto.  # noqa: E501

        The id of the process definition for the modification  # noqa: E501

        :return: The process_definition_id of this ModificationDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this ModificationDto.

        The id of the process definition for the modification  # noqa: E501

        :param process_definition_id: The process_definition_id of this ModificationDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def skip_custom_listeners(self):
        """Gets the skip_custom_listeners of this ModificationDto.  # noqa: E501

        Skip execution listener invocation for activities that are started or ended as part of this request.  # noqa: E501

        :return: The skip_custom_listeners of this ModificationDto.  # noqa: E501
        :rtype: bool
        """
        return self._skip_custom_listeners

    @skip_custom_listeners.setter
    def skip_custom_listeners(self, skip_custom_listeners):
        """Sets the skip_custom_listeners of this ModificationDto.

        Skip execution listener invocation for activities that are started or ended as part of this request.  # noqa: E501

        :param skip_custom_listeners: The skip_custom_listeners of this ModificationDto.  # noqa: E501
        :type: bool
        """

        self._skip_custom_listeners = skip_custom_listeners

    @property
    def skip_io_mappings(self):
        """Gets the skip_io_mappings of this ModificationDto.  # noqa: E501

        Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request.  # noqa: E501

        :return: The skip_io_mappings of this ModificationDto.  # noqa: E501
        :rtype: bool
        """
        return self._skip_io_mappings

    @skip_io_mappings.setter
    def skip_io_mappings(self, skip_io_mappings):
        """Sets the skip_io_mappings of this ModificationDto.

        Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request.  # noqa: E501

        :param skip_io_mappings: The skip_io_mappings of this ModificationDto.  # noqa: E501
        :type: bool
        """

        self._skip_io_mappings = skip_io_mappings

    @property
    def process_instance_ids(self):
        """Gets the process_instance_ids of this ModificationDto.  # noqa: E501

        A list of process instance ids to modify.  # noqa: E501

        :return: The process_instance_ids of this ModificationDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_instance_ids

    @process_instance_ids.setter
    def process_instance_ids(self, process_instance_ids):
        """Sets the process_instance_ids of this ModificationDto.

        A list of process instance ids to modify.  # noqa: E501

        :param process_instance_ids: The process_instance_ids of this ModificationDto.  # noqa: E501
        :type: list[str]
        """

        self._process_instance_ids = process_instance_ids

    @property
    def process_instance_query(self):
        """Gets the process_instance_query of this ModificationDto.  # noqa: E501


        :return: The process_instance_query of this ModificationDto.  # noqa: E501
        :rtype: ProcessInstanceQueryDto
        """
        return self._process_instance_query

    @process_instance_query.setter
    def process_instance_query(self, process_instance_query):
        """Sets the process_instance_query of this ModificationDto.


        :param process_instance_query: The process_instance_query of this ModificationDto.  # noqa: E501
        :type: ProcessInstanceQueryDto
        """

        self._process_instance_query = process_instance_query

    @property
    def instructions(self):
        """Gets the instructions of this ModificationDto.  # noqa: E501

        An array of modification instructions. The instructions are executed in the order they are in.   # noqa: E501

        :return: The instructions of this ModificationDto.  # noqa: E501
        :rtype: list[MultipleProcessInstanceModificationInstructionDto]
        """
        return self._instructions

    @instructions.setter
    def instructions(self, instructions):
        """Sets the instructions of this ModificationDto.

        An array of modification instructions. The instructions are executed in the order they are in.   # noqa: E501

        :param instructions: The instructions of this ModificationDto.  # noqa: E501
        :type: list[MultipleProcessInstanceModificationInstructionDto]
        """

        self._instructions = instructions

    @property
    def annotation(self):
        """Gets the annotation of this ModificationDto.  # noqa: E501

        An arbitrary text annotation set by a user for auditing reasons.  # noqa: E501

        :return: The annotation of this ModificationDto.  # noqa: E501
        :rtype: str
        """
        return self._annotation

    @annotation.setter
    def annotation(self, annotation):
        """Sets the annotation of this ModificationDto.

        An arbitrary text annotation set by a user for auditing reasons.  # noqa: E501

        :param annotation: The annotation of this ModificationDto.  # noqa: E501
        :type: str
        """

        self._annotation = annotation

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ModificationDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ModificationDto):
            return True

        return self.to_dict() != other.to_dict()
