# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class MigrationPlanReportDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'instruction_reports': 'list[MigrationInstructionValidationReportDto]',
        'variable_reports': 'dict(str, MigrationVariableValidationReportDto)'
    }

    attribute_map = {
        'instruction_reports': 'instructionReports',
        'variable_reports': 'variableReports'
    }

    def __init__(self, instruction_reports=None, variable_reports=None, local_vars_configuration=None):  # noqa: E501
        """MigrationPlanReportDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._instruction_reports = None
        self._variable_reports = None
        self.discriminator = None

        self.instruction_reports = instruction_reports
        self.variable_reports = variable_reports

    @property
    def instruction_reports(self):
        """Gets the instruction_reports of this MigrationPlanReportDto.  # noqa: E501

        The list of instruction validation reports. If no validation errors are detected it is an empty list.  # noqa: E501

        :return: The instruction_reports of this MigrationPlanReportDto.  # noqa: E501
        :rtype: list[MigrationInstructionValidationReportDto]
        """
        return self._instruction_reports

    @instruction_reports.setter
    def instruction_reports(self, instruction_reports):
        """Sets the instruction_reports of this MigrationPlanReportDto.

        The list of instruction validation reports. If no validation errors are detected it is an empty list.  # noqa: E501

        :param instruction_reports: The instruction_reports of this MigrationPlanReportDto.  # noqa: E501
        :type: list[MigrationInstructionValidationReportDto]
        """

        self._instruction_reports = instruction_reports

    @property
    def variable_reports(self):
        """Gets the variable_reports of this MigrationPlanReportDto.  # noqa: E501

        A map of variable reports. Each key is a variable name and each value a JSON object consisting of the variable's type, value, value info object and a list of failures.  # noqa: E501

        :return: The variable_reports of this MigrationPlanReportDto.  # noqa: E501
        :rtype: dict(str, MigrationVariableValidationReportDto)
        """
        return self._variable_reports

    @variable_reports.setter
    def variable_reports(self, variable_reports):
        """Sets the variable_reports of this MigrationPlanReportDto.

        A map of variable reports. Each key is a variable name and each value a JSON object consisting of the variable's type, value, value info object and a list of failures.  # noqa: E501

        :param variable_reports: The variable_reports of this MigrationPlanReportDto.  # noqa: E501
        :type: dict(str, MigrationVariableValidationReportDto)
        """

        self._variable_reports = variable_reports

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MigrationPlanReportDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MigrationPlanReportDto):
            return True

        return self.to_dict() != other.to_dict()
