# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class JobDefinitionSuspensionStateDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'include_jobs': 'bool',
        'execution_date': 'str',
        'suspended': 'bool'
    }

    attribute_map = {
        'include_jobs': 'includeJobs',
        'execution_date': 'executionDate',
        'suspended': 'suspended'
    }

    def __init__(self, include_jobs=None, execution_date=None, suspended=None, local_vars_configuration=None):  # noqa: E501
        """JobDefinitionSuspensionStateDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._include_jobs = None
        self._execution_date = None
        self._suspended = None
        self.discriminator = None

        self.include_jobs = include_jobs
        self.execution_date = execution_date
        self.suspended = suspended

    @property
    def include_jobs(self):
        """Gets the include_jobs of this JobDefinitionSuspensionStateDto.  # noqa: E501

        A `Boolean` value which indicates whether to activate or suspend also all jobs of the referenced job definitions. When the value is set to `true`, all jobs of the provided job definitions will be activated or suspended and when the value is set to `false`, the suspension state of all jobs of the provided job definitions will not be updated.  # noqa: E501

        :return: The include_jobs of this JobDefinitionSuspensionStateDto.  # noqa: E501
        :rtype: bool
        """
        return self._include_jobs

    @include_jobs.setter
    def include_jobs(self, include_jobs):
        """Sets the include_jobs of this JobDefinitionSuspensionStateDto.

        A `Boolean` value which indicates whether to activate or suspend also all jobs of the referenced job definitions. When the value is set to `true`, all jobs of the provided job definitions will be activated or suspended and when the value is set to `false`, the suspension state of all jobs of the provided job definitions will not be updated.  # noqa: E501

        :param include_jobs: The include_jobs of this JobDefinitionSuspensionStateDto.  # noqa: E501
        :type: bool
        """

        self._include_jobs = include_jobs

    @property
    def execution_date(self):
        """Gets the execution_date of this JobDefinitionSuspensionStateDto.  # noqa: E501

        The date on which the referenced job definitions will be activated or suspended. If null, the suspension state of the given job definitions is updated immediately. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The execution_date of this JobDefinitionSuspensionStateDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_date

    @execution_date.setter
    def execution_date(self, execution_date):
        """Sets the execution_date of this JobDefinitionSuspensionStateDto.

        The date on which the referenced job definitions will be activated or suspended. If null, the suspension state of the given job definitions is updated immediately. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param execution_date: The execution_date of this JobDefinitionSuspensionStateDto.  # noqa: E501
        :type: str
        """

        self._execution_date = execution_date

    @property
    def suspended(self):
        """Gets the suspended of this JobDefinitionSuspensionStateDto.  # noqa: E501

        A Boolean value which indicates whether to activate or suspend a given instance  (e.g. process instance, job, job definition, or batch). When the value is set to true,  the given instance will be suspended and when the value is set to false,  the given instance will be activated.  # noqa: E501

        :return: The suspended of this JobDefinitionSuspensionStateDto.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this JobDefinitionSuspensionStateDto.

        A Boolean value which indicates whether to activate or suspend a given instance  (e.g. process instance, job, job definition, or batch). When the value is set to true,  the given instance will be suspended and when the value is set to false,  the given instance will be activated.  # noqa: E501

        :param suspended: The suspended of this JobDefinitionSuspensionStateDto.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobDefinitionSuspensionStateDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobDefinitionSuspensionStateDto):
            return True

        return self.to_dict() != other.to_dict()
