# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class JobDefinitionQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'job_definition_id': 'str',
        'activity_id_in': 'list[str]',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'job_type': 'str',
        'job_configuration': 'str',
        'active': 'bool',
        'suspended': 'bool',
        'with_overriding_job_priority': 'bool',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'include_job_definitions_without_tenant_id': 'bool',
        'sorting': 'list[JobDefinitionQueryDtoSorting]'
    }

    attribute_map = {
        'job_definition_id': 'jobDefinitionId',
        'activity_id_in': 'activityIdIn',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'job_type': 'jobType',
        'job_configuration': 'jobConfiguration',
        'active': 'active',
        'suspended': 'suspended',
        'with_overriding_job_priority': 'withOverridingJobPriority',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'include_job_definitions_without_tenant_id': 'includeJobDefinitionsWithoutTenantId',
        'sorting': 'sorting'
    }

    def __init__(self, job_definition_id=None, activity_id_in=None, process_definition_id=None, process_definition_key=None, job_type=None, job_configuration=None, active=None, suspended=None, with_overriding_job_priority=None, tenant_id_in=None, without_tenant_id=None, include_job_definitions_without_tenant_id=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """JobDefinitionQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._job_definition_id = None
        self._activity_id_in = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._job_type = None
        self._job_configuration = None
        self._active = None
        self._suspended = None
        self._with_overriding_job_priority = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._include_job_definitions_without_tenant_id = None
        self._sorting = None
        self.discriminator = None

        self.job_definition_id = job_definition_id
        self.activity_id_in = activity_id_in
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.job_type = job_type
        self.job_configuration = job_configuration
        self.active = active
        self.suspended = suspended
        self.with_overriding_job_priority = with_overriding_job_priority
        self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        self.include_job_definitions_without_tenant_id = include_job_definitions_without_tenant_id
        self.sorting = sorting

    @property
    def job_definition_id(self):
        """Gets the job_definition_id of this JobDefinitionQueryDto.  # noqa: E501

        Filter by job definition id.  # noqa: E501

        :return: The job_definition_id of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._job_definition_id

    @job_definition_id.setter
    def job_definition_id(self, job_definition_id):
        """Sets the job_definition_id of this JobDefinitionQueryDto.

        Filter by job definition id.  # noqa: E501

        :param job_definition_id: The job_definition_id of this JobDefinitionQueryDto.  # noqa: E501
        :type: str
        """

        self._job_definition_id = job_definition_id

    @property
    def activity_id_in(self):
        """Gets the activity_id_in of this JobDefinitionQueryDto.  # noqa: E501

        Only include job definitions which belong to one of the passed activity ids.  # noqa: E501

        :return: The activity_id_in of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._activity_id_in

    @activity_id_in.setter
    def activity_id_in(self, activity_id_in):
        """Sets the activity_id_in of this JobDefinitionQueryDto.

        Only include job definitions which belong to one of the passed activity ids.  # noqa: E501

        :param activity_id_in: The activity_id_in of this JobDefinitionQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._activity_id_in = activity_id_in

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this JobDefinitionQueryDto.  # noqa: E501

        Only include job definitions which exist for the given process definition id.  # noqa: E501

        :return: The process_definition_id of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this JobDefinitionQueryDto.

        Only include job definitions which exist for the given process definition id.  # noqa: E501

        :param process_definition_id: The process_definition_id of this JobDefinitionQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this JobDefinitionQueryDto.  # noqa: E501

        Only include job definitions which exist for the given process definition key.  # noqa: E501

        :return: The process_definition_key of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this JobDefinitionQueryDto.

        Only include job definitions which exist for the given process definition key.  # noqa: E501

        :param process_definition_key: The process_definition_key of this JobDefinitionQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def job_type(self):
        """Gets the job_type of this JobDefinitionQueryDto.  # noqa: E501

        Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types.  # noqa: E501

        :return: The job_type of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._job_type

    @job_type.setter
    def job_type(self, job_type):
        """Sets the job_type of this JobDefinitionQueryDto.

        Only include job definitions which exist for the given job type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types.  # noqa: E501

        :param job_type: The job_type of this JobDefinitionQueryDto.  # noqa: E501
        :type: str
        """

        self._job_type = job_type

    @property
    def job_configuration(self):
        """Gets the job_configuration of this JobDefinitionQueryDto.  # noqa: E501

        Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration.  # noqa: E501

        :return: The job_configuration of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._job_configuration

    @job_configuration.setter
    def job_configuration(self, job_configuration):
        """Sets the job_configuration of this JobDefinitionQueryDto.

        Only include job definitions which exist for the given job configuration. For example: for timer jobs it is the timer configuration.  # noqa: E501

        :param job_configuration: The job_configuration of this JobDefinitionQueryDto.  # noqa: E501
        :type: str
        """

        self._job_configuration = job_configuration

    @property
    def active(self):
        """Gets the active of this JobDefinitionQueryDto.  # noqa: E501

        Only include active job definitions. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The active of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this JobDefinitionQueryDto.

        Only include active job definitions. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param active: The active of this JobDefinitionQueryDto.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def suspended(self):
        """Gets the suspended of this JobDefinitionQueryDto.  # noqa: E501

        Only include suspended job definitions. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The suspended of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this JobDefinitionQueryDto.

        Only include suspended job definitions. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param suspended: The suspended of this JobDefinitionQueryDto.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    @property
    def with_overriding_job_priority(self):
        """Gets the with_overriding_job_priority of this JobDefinitionQueryDto.  # noqa: E501

        Only include job definitions that have an overriding job priority defined. The only effective value is `true`. If set to `false`, this filter is not applied.  # noqa: E501

        :return: The with_overriding_job_priority of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._with_overriding_job_priority

    @with_overriding_job_priority.setter
    def with_overriding_job_priority(self, with_overriding_job_priority):
        """Sets the with_overriding_job_priority of this JobDefinitionQueryDto.

        Only include job definitions that have an overriding job priority defined. The only effective value is `true`. If set to `false`, this filter is not applied.  # noqa: E501

        :param with_overriding_job_priority: The with_overriding_job_priority of this JobDefinitionQueryDto.  # noqa: E501
        :type: bool
        """

        self._with_overriding_job_priority = with_overriding_job_priority

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this JobDefinitionQueryDto.  # noqa: E501

        Only include job definitions which belong to one of the passed tenant ids.  # noqa: E501

        :return: The tenant_id_in of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this JobDefinitionQueryDto.

        Only include job definitions which belong to one of the passed tenant ids.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this JobDefinitionQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this JobDefinitionQueryDto.  # noqa: E501

        Only include job definitions which belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this JobDefinitionQueryDto.

        Only include job definitions which belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this JobDefinitionQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def include_job_definitions_without_tenant_id(self):
        """Gets the include_job_definitions_without_tenant_id of this JobDefinitionQueryDto.  # noqa: E501

        Include job definitions which belong to no tenant. Can be used in combination with `tenantIdIn`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The include_job_definitions_without_tenant_id of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._include_job_definitions_without_tenant_id

    @include_job_definitions_without_tenant_id.setter
    def include_job_definitions_without_tenant_id(self, include_job_definitions_without_tenant_id):
        """Sets the include_job_definitions_without_tenant_id of this JobDefinitionQueryDto.

        Include job definitions which belong to no tenant. Can be used in combination with `tenantIdIn`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param include_job_definitions_without_tenant_id: The include_job_definitions_without_tenant_id of this JobDefinitionQueryDto.  # noqa: E501
        :type: bool
        """

        self._include_job_definitions_without_tenant_id = include_job_definitions_without_tenant_id

    @property
    def sorting(self):
        """Gets the sorting of this JobDefinitionQueryDto.  # noqa: E501

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for `count` endpoints.  # noqa: E501

        :return: The sorting of this JobDefinitionQueryDto.  # noqa: E501
        :rtype: list[JobDefinitionQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this JobDefinitionQueryDto.

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for `count` endpoints.  # noqa: E501

        :param sorting: The sorting of this JobDefinitionQueryDto.  # noqa: E501
        :type: list[JobDefinitionQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobDefinitionQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobDefinitionQueryDto):
            return True

        return self.to_dict() != other.to_dict()
