# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class JobDefinitionDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'activity_id': 'str',
        'job_type': 'str',
        'job_configuration': 'str',
        'overriding_job_priority': 'int',
        'suspended': 'bool',
        'tenant_id': 'str',
        'deployment_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'activity_id': 'activityId',
        'job_type': 'jobType',
        'job_configuration': 'jobConfiguration',
        'overriding_job_priority': 'overridingJobPriority',
        'suspended': 'suspended',
        'tenant_id': 'tenantId',
        'deployment_id': 'deploymentId'
    }

    def __init__(self, id=None, process_definition_id=None, process_definition_key=None, activity_id=None, job_type=None, job_configuration=None, overriding_job_priority=None, suspended=None, tenant_id=None, deployment_id=None, local_vars_configuration=None):  # noqa: E501
        """JobDefinitionDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._activity_id = None
        self._job_type = None
        self._job_configuration = None
        self._overriding_job_priority = None
        self._suspended = None
        self._tenant_id = None
        self._deployment_id = None
        self.discriminator = None

        self.id = id
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.activity_id = activity_id
        self.job_type = job_type
        self.job_configuration = job_configuration
        self.overriding_job_priority = overriding_job_priority
        self.suspended = suspended
        self.tenant_id = tenant_id
        self.deployment_id = deployment_id

    @property
    def id(self):
        """Gets the id of this JobDefinitionDto.  # noqa: E501

        The id of the job definition.  # noqa: E501

        :return: The id of this JobDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this JobDefinitionDto.

        The id of the job definition.  # noqa: E501

        :param id: The id of this JobDefinitionDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this JobDefinitionDto.  # noqa: E501

        The id of the process definition this job definition is associated with.  # noqa: E501

        :return: The process_definition_id of this JobDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this JobDefinitionDto.

        The id of the process definition this job definition is associated with.  # noqa: E501

        :param process_definition_id: The process_definition_id of this JobDefinitionDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this JobDefinitionDto.  # noqa: E501

        The key of the process definition this job definition is associated with.  # noqa: E501

        :return: The process_definition_key of this JobDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this JobDefinitionDto.

        The key of the process definition this job definition is associated with.  # noqa: E501

        :param process_definition_key: The process_definition_key of this JobDefinitionDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def activity_id(self):
        """Gets the activity_id of this JobDefinitionDto.  # noqa: E501

        The id of the activity this job definition is associated with.  # noqa: E501

        :return: The activity_id of this JobDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this JobDefinitionDto.

        The id of the activity this job definition is associated with.  # noqa: E501

        :param activity_id: The activity_id of this JobDefinitionDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def job_type(self):
        """Gets the job_type of this JobDefinitionDto.  # noqa: E501

        The type of the job which is running for this job definition. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types.  # noqa: E501

        :return: The job_type of this JobDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._job_type

    @job_type.setter
    def job_type(self, job_type):
        """Sets the job_type of this JobDefinitionDto.

        The type of the job which is running for this job definition. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types.  # noqa: E501

        :param job_type: The job_type of this JobDefinitionDto.  # noqa: E501
        :type: str
        """

        self._job_type = job_type

    @property
    def job_configuration(self):
        """Gets the job_configuration of this JobDefinitionDto.  # noqa: E501

        The configuration of a job definition provides details about the jobs which will be created. For example: for timer jobs it is the timer configuration.  # noqa: E501

        :return: The job_configuration of this JobDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._job_configuration

    @job_configuration.setter
    def job_configuration(self, job_configuration):
        """Sets the job_configuration of this JobDefinitionDto.

        The configuration of a job definition provides details about the jobs which will be created. For example: for timer jobs it is the timer configuration.  # noqa: E501

        :param job_configuration: The job_configuration of this JobDefinitionDto.  # noqa: E501
        :type: str
        """

        self._job_configuration = job_configuration

    @property
    def overriding_job_priority(self):
        """Gets the overriding_job_priority of this JobDefinitionDto.  # noqa: E501

        The execution priority defined for jobs that are created based on this definition. May be `null` when the priority has not been overridden on the job definition level.  # noqa: E501

        :return: The overriding_job_priority of this JobDefinitionDto.  # noqa: E501
        :rtype: int
        """
        return self._overriding_job_priority

    @overriding_job_priority.setter
    def overriding_job_priority(self, overriding_job_priority):
        """Sets the overriding_job_priority of this JobDefinitionDto.

        The execution priority defined for jobs that are created based on this definition. May be `null` when the priority has not been overridden on the job definition level.  # noqa: E501

        :param overriding_job_priority: The overriding_job_priority of this JobDefinitionDto.  # noqa: E501
        :type: int
        """

        self._overriding_job_priority = overriding_job_priority

    @property
    def suspended(self):
        """Gets the suspended of this JobDefinitionDto.  # noqa: E501

        Indicates whether this job definition is suspended or not.  # noqa: E501

        :return: The suspended of this JobDefinitionDto.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this JobDefinitionDto.

        Indicates whether this job definition is suspended or not.  # noqa: E501

        :param suspended: The suspended of this JobDefinitionDto.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    @property
    def tenant_id(self):
        """Gets the tenant_id of this JobDefinitionDto.  # noqa: E501

        The id of the tenant this job definition is associated with.  # noqa: E501

        :return: The tenant_id of this JobDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this JobDefinitionDto.

        The id of the tenant this job definition is associated with.  # noqa: E501

        :param tenant_id: The tenant_id of this JobDefinitionDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def deployment_id(self):
        """Gets the deployment_id of this JobDefinitionDto.  # noqa: E501

        The id of the deployment this job definition is related to. In a deployment-aware setup, this leads to all jobs of the same definition being executed on the same node.  # noqa: E501

        :return: The deployment_id of this JobDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._deployment_id

    @deployment_id.setter
    def deployment_id(self, deployment_id):
        """Sets the deployment_id of this JobDefinitionDto.

        The id of the deployment this job definition is related to. In a deployment-aware setup, this leads to all jobs of the same definition being executed on the same node.  # noqa: E501

        :param deployment_id: The deployment_id of this JobDefinitionDto.  # noqa: E501
        :type: str
        """

        self._deployment_id = deployment_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobDefinitionDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobDefinitionDto):
            return True

        return self.to_dict() != other.to_dict()
