# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class IncidentStatisticsResultDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'incident_type': 'str',
        'incident_count': 'int'
    }

    attribute_map = {
        'incident_type': 'incidentType',
        'incident_count': 'incidentCount'
    }

    def __init__(self, incident_type=None, incident_count=None, local_vars_configuration=None):  # noqa: E501
        """IncidentStatisticsResultDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._incident_type = None
        self._incident_count = None
        self.discriminator = None

        self.incident_type = incident_type
        self.incident_count = incident_count

    @property
    def incident_type(self):
        """Gets the incident_type of this IncidentStatisticsResultDto.  # noqa: E501

        The type of the incident the number of incidents is aggregated for. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/incidents/#incident-types) for a list of incident types.  # noqa: E501

        :return: The incident_type of this IncidentStatisticsResultDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_type

    @incident_type.setter
    def incident_type(self, incident_type):
        """Sets the incident_type of this IncidentStatisticsResultDto.

        The type of the incident the number of incidents is aggregated for. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/incidents/#incident-types) for a list of incident types.  # noqa: E501

        :param incident_type: The incident_type of this IncidentStatisticsResultDto.  # noqa: E501
        :type: str
        """

        self._incident_type = incident_type

    @property
    def incident_count(self):
        """Gets the incident_count of this IncidentStatisticsResultDto.  # noqa: E501

        The total number of incidents for the corresponding incident type.  # noqa: E501

        :return: The incident_count of this IncidentStatisticsResultDto.  # noqa: E501
        :rtype: int
        """
        return self._incident_count

    @incident_count.setter
    def incident_count(self, incident_count):
        """Sets the incident_count of this IncidentStatisticsResultDto.

        The total number of incidents for the corresponding incident type.  # noqa: E501

        :param incident_count: The incident_count of this IncidentStatisticsResultDto.  # noqa: E501
        :type: int
        """

        self._incident_count = incident_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IncidentStatisticsResultDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IncidentStatisticsResultDto):
            return True

        return self.to_dict() != other.to_dict()
