# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoryCleanupConfigurationDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'batch_window_start_time': 'datetime',
        'batch_window_end_time': 'datetime',
        'enabled': 'bool'
    }

    attribute_map = {
        'batch_window_start_time': 'batchWindowStartTime',
        'batch_window_end_time': 'batchWindowEndTime',
        'enabled': 'enabled'
    }

    def __init__(self, batch_window_start_time=None, batch_window_end_time=None, enabled=None, local_vars_configuration=None):  # noqa: E501
        """HistoryCleanupConfigurationDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._batch_window_start_time = None
        self._batch_window_end_time = None
        self._enabled = None
        self.discriminator = None

        self.batch_window_start_time = batch_window_start_time
        self.batch_window_end_time = batch_window_end_time
        self.enabled = enabled

    @property
    def batch_window_start_time(self):
        """Gets the batch_window_start_time of this HistoryCleanupConfigurationDto.  # noqa: E501

        Start time of the current or next batch window. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The batch_window_start_time of this HistoryCleanupConfigurationDto.  # noqa: E501
        :rtype: datetime
        """
        return self._batch_window_start_time

    @batch_window_start_time.setter
    def batch_window_start_time(self, batch_window_start_time):
        """Sets the batch_window_start_time of this HistoryCleanupConfigurationDto.

        Start time of the current or next batch window. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param batch_window_start_time: The batch_window_start_time of this HistoryCleanupConfigurationDto.  # noqa: E501
        :type: datetime
        """

        self._batch_window_start_time = batch_window_start_time

    @property
    def batch_window_end_time(self):
        """Gets the batch_window_end_time of this HistoryCleanupConfigurationDto.  # noqa: E501

        End time of the current or next batch window. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The batch_window_end_time of this HistoryCleanupConfigurationDto.  # noqa: E501
        :rtype: datetime
        """
        return self._batch_window_end_time

    @batch_window_end_time.setter
    def batch_window_end_time(self, batch_window_end_time):
        """Sets the batch_window_end_time of this HistoryCleanupConfigurationDto.

        End time of the current or next batch window. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param batch_window_end_time: The batch_window_end_time of this HistoryCleanupConfigurationDto.  # noqa: E501
        :type: datetime
        """

        self._batch_window_end_time = batch_window_end_time

    @property
    def enabled(self):
        """Gets the enabled of this HistoryCleanupConfigurationDto.  # noqa: E501

        Indicates whether the engine node participates in history cleanup or not. The default is `true`. Participation can be disabled via [Process Engine Configuration](https://docs.camunda.org/manual/7.16/reference/deployment-descriptors/tags/process-engine/#history-cleanup-enabled).  For more details, see [Cleanup Execution Participation per Node](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#cleanup-execution-participation-per-node).  # noqa: E501

        :return: The enabled of this HistoryCleanupConfigurationDto.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this HistoryCleanupConfigurationDto.

        Indicates whether the engine node participates in history cleanup or not. The default is `true`. Participation can be disabled via [Process Engine Configuration](https://docs.camunda.org/manual/7.16/reference/deployment-descriptors/tags/process-engine/#history-cleanup-enabled).  For more details, see [Cleanup Execution Participation per Node](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#cleanup-execution-participation-per-node).  # noqa: E501

        :param enabled: The enabled of this HistoryCleanupConfigurationDto.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoryCleanupConfigurationDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoryCleanupConfigurationDto):
            return True

        return self.to_dict() != other.to_dict()
