# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricTaskInstanceReportResultDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'task_name': 'str',
        'count': 'int',
        'process_definition_key': 'str',
        'process_definition_id': 'str',
        'process_definition_name': 'str',
        'period': 'int',
        'period_unit': 'str',
        'minimum': 'int',
        'maximum': 'int',
        'average': 'int'
    }

    attribute_map = {
        'task_name': 'taskName',
        'count': 'count',
        'process_definition_key': 'processDefinitionKey',
        'process_definition_id': 'processDefinitionId',
        'process_definition_name': 'processDefinitionName',
        'period': 'period',
        'period_unit': 'periodUnit',
        'minimum': 'minimum',
        'maximum': 'maximum',
        'average': 'average'
    }

    def __init__(self, task_name=None, count=None, process_definition_key=None, process_definition_id=None, process_definition_name=None, period=None, period_unit=None, minimum=None, maximum=None, average=None, local_vars_configuration=None):  # noqa: E501
        """HistoricTaskInstanceReportResultDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._task_name = None
        self._count = None
        self._process_definition_key = None
        self._process_definition_id = None
        self._process_definition_name = None
        self._period = None
        self._period_unit = None
        self._minimum = None
        self._maximum = None
        self._average = None
        self.discriminator = None

        self.task_name = task_name
        self.count = count
        self.process_definition_key = process_definition_key
        self.process_definition_id = process_definition_id
        self.process_definition_name = process_definition_name
        self.period = period
        self.period_unit = period_unit
        self.minimum = minimum
        self.maximum = maximum
        self.average = average

    @property
    def task_name(self):
        """Gets the task_name of this HistoricTaskInstanceReportResultDto.  # noqa: E501

        The name of the task. It is only available when the `groupBy` parameter is set to `taskName`. Else the value is `null`.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.  # noqa: E501

        :return: The task_name of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :rtype: str
        """
        return self._task_name

    @task_name.setter
    def task_name(self, task_name):
        """Sets the task_name of this HistoricTaskInstanceReportResultDto.

        The name of the task. It is only available when the `groupBy` parameter is set to `taskName`. Else the value is `null`.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.  # noqa: E501

        :param task_name: The task_name of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :type: str
        """

        self._task_name = task_name

    @property
    def count(self):
        """Gets the count of this HistoricTaskInstanceReportResultDto.  # noqa: E501

        The number of tasks which have the given definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.  # noqa: E501

        :return: The count of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """Sets the count of this HistoricTaskInstanceReportResultDto.

        The number of tasks which have the given definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.  # noqa: E501

        :param count: The count of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :type: int
        """

        self._count = count

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricTaskInstanceReportResultDto.  # noqa: E501

        The key of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.  # noqa: E501

        :return: The process_definition_key of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricTaskInstanceReportResultDto.

        The key of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricTaskInstanceReportResultDto.  # noqa: E501

        The id of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.  # noqa: E501

        :return: The process_definition_id of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricTaskInstanceReportResultDto.

        The id of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_name(self):
        """Gets the process_definition_name of this HistoricTaskInstanceReportResultDto.  # noqa: E501

        The name of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.  # noqa: E501

        :return: The process_definition_name of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_name

    @process_definition_name.setter
    def process_definition_name(self, process_definition_name):
        """Sets the process_definition_name of this HistoricTaskInstanceReportResultDto.

        The name of the process definition.  **Note:** This property is only set for a historic task report object. In these cases, the value of the `reportType` query parameter is `count`.  # noqa: E501

        :param process_definition_name: The process_definition_name of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :type: str
        """

        self._process_definition_name = process_definition_name

    @property
    def period(self):
        """Gets the period of this HistoricTaskInstanceReportResultDto.  # noqa: E501

        Specifies a span of time within a year. **Note:** The period must be interpreted in conjunction with the returned `periodUnit`.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.  # noqa: E501

        :return: The period of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :rtype: int
        """
        return self._period

    @period.setter
    def period(self, period):
        """Sets the period of this HistoricTaskInstanceReportResultDto.

        Specifies a span of time within a year. **Note:** The period must be interpreted in conjunction with the returned `periodUnit`.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.  # noqa: E501

        :param period: The period of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :type: int
        """

        self._period = period

    @property
    def period_unit(self):
        """Gets the period_unit of this HistoricTaskInstanceReportResultDto.  # noqa: E501

        The unit of the given period. Possible values are `MONTH` and `QUARTER`.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.  # noqa: E501

        :return: The period_unit of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :rtype: str
        """
        return self._period_unit

    @period_unit.setter
    def period_unit(self, period_unit):
        """Sets the period_unit of this HistoricTaskInstanceReportResultDto.

        The unit of the given period. Possible values are `MONTH` and `QUARTER`.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.  # noqa: E501

        :param period_unit: The period_unit of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :type: str
        """
        allowed_values = [None,"MONTH", "QUARTER"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and period_unit not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `period_unit` ({0}), must be one of {1}"  # noqa: E501
                .format(period_unit, allowed_values)
            )

        self._period_unit = period_unit

    @property
    def minimum(self):
        """Gets the minimum of this HistoricTaskInstanceReportResultDto.  # noqa: E501

        The smallest duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.  # noqa: E501

        :return: The minimum of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :rtype: int
        """
        return self._minimum

    @minimum.setter
    def minimum(self, minimum):
        """Sets the minimum of this HistoricTaskInstanceReportResultDto.

        The smallest duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.  # noqa: E501

        :param minimum: The minimum of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :type: int
        """

        self._minimum = minimum

    @property
    def maximum(self):
        """Gets the maximum of this HistoricTaskInstanceReportResultDto.  # noqa: E501

        The greatest duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.  # noqa: E501

        :return: The maximum of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :rtype: int
        """
        return self._maximum

    @maximum.setter
    def maximum(self, maximum):
        """Sets the maximum of this HistoricTaskInstanceReportResultDto.

        The greatest duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.  # noqa: E501

        :param maximum: The maximum of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :type: int
        """

        self._maximum = maximum

    @property
    def average(self):
        """Gets the average of this HistoricTaskInstanceReportResultDto.  # noqa: E501

        The average duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.  # noqa: E501

        :return: The average of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :rtype: int
        """
        return self._average

    @average.setter
    def average(self, average):
        """Sets the average of this HistoricTaskInstanceReportResultDto.

        The average duration in milliseconds of all completed process instances which were started in the given period.  **Note:** This property is only set for a duration report object. In these cases, the value of the `reportType` query parameter is `duration`.  # noqa: E501

        :param average: The average of this HistoricTaskInstanceReportResultDto.  # noqa: E501
        :type: int
        """

        self._average = average

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricTaskInstanceReportResultDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricTaskInstanceReportResultDto):
            return True

        return self.to_dict() != other.to_dict()
