# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricTaskInstanceQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'task_id': 'str',
        'task_parent_task_id': 'str',
        'process_instance_id': 'str',
        'process_instance_business_key': 'str',
        'process_instance_business_key_in': 'list[str]',
        'process_instance_business_key_like': 'str',
        'execution_id': 'str',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'process_definition_name': 'str',
        'case_instance_id': 'str',
        'case_execution_id': 'str',
        'case_definition_id': 'str',
        'case_definition_key': 'str',
        'case_definition_name': 'str',
        'activity_instance_id_in': 'list[str]',
        'task_name': 'str',
        'task_name_like': 'str',
        'task_description': 'str',
        'task_description_like': 'str',
        'task_definition_key': 'str',
        'task_definition_key_in': 'list[str]',
        'task_delete_reason': 'str',
        'task_delete_reason_like': 'str',
        'task_assignee': 'str',
        'task_assignee_like': 'str',
        'task_owner': 'str',
        'task_owner_like': 'str',
        'task_priority': 'int',
        'assigned': 'bool',
        'unassigned': 'bool',
        'finished': 'bool',
        'unfinished': 'bool',
        'process_finished': 'bool',
        'process_unfinished': 'bool',
        'task_due_date': 'datetime',
        'task_due_date_before': 'datetime',
        'task_due_date_after': 'datetime',
        'without_task_due_date': 'bool',
        'task_follow_up_date': 'datetime',
        'task_follow_up_date_before': 'datetime',
        'task_follow_up_date_after': 'datetime',
        'started_before': 'datetime',
        'started_after': 'datetime',
        'finished_before': 'datetime',
        'finished_after': 'datetime',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'task_variables': 'list[VariableQueryParameterDto]',
        'process_variables': 'list[VariableQueryParameterDto]',
        'variable_names_ignore_case': 'bool',
        'variable_values_ignore_case': 'bool',
        'task_involved_user': 'str',
        'task_involved_group': 'str',
        'task_had_candidate_user': 'str',
        'task_had_candidate_group': 'str',
        'with_candidate_groups': 'bool',
        'without_candidate_groups': 'bool',
        'or_queries': 'list[HistoricTaskInstanceQueryDto]',
        'sorting': 'list[HistoricTaskInstanceQueryDtoSorting]'
    }

    attribute_map = {
        'task_id': 'taskId',
        'task_parent_task_id': 'taskParentTaskId',
        'process_instance_id': 'processInstanceId',
        'process_instance_business_key': 'processInstanceBusinessKey',
        'process_instance_business_key_in': 'processInstanceBusinessKeyIn',
        'process_instance_business_key_like': 'processInstanceBusinessKeyLike',
        'execution_id': 'executionId',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'process_definition_name': 'processDefinitionName',
        'case_instance_id': 'caseInstanceId',
        'case_execution_id': 'caseExecutionId',
        'case_definition_id': 'caseDefinitionId',
        'case_definition_key': 'caseDefinitionKey',
        'case_definition_name': 'caseDefinitionName',
        'activity_instance_id_in': 'activityInstanceIdIn',
        'task_name': 'taskName',
        'task_name_like': 'taskNameLike',
        'task_description': 'taskDescription',
        'task_description_like': 'taskDescriptionLike',
        'task_definition_key': 'taskDefinitionKey',
        'task_definition_key_in': 'taskDefinitionKeyIn',
        'task_delete_reason': 'taskDeleteReason',
        'task_delete_reason_like': 'taskDeleteReasonLike',
        'task_assignee': 'taskAssignee',
        'task_assignee_like': 'taskAssigneeLike',
        'task_owner': 'taskOwner',
        'task_owner_like': 'taskOwnerLike',
        'task_priority': 'taskPriority',
        'assigned': 'assigned',
        'unassigned': 'unassigned',
        'finished': 'finished',
        'unfinished': 'unfinished',
        'process_finished': 'processFinished',
        'process_unfinished': 'processUnfinished',
        'task_due_date': 'taskDueDate',
        'task_due_date_before': 'taskDueDateBefore',
        'task_due_date_after': 'taskDueDateAfter',
        'without_task_due_date': 'withoutTaskDueDate',
        'task_follow_up_date': 'taskFollowUpDate',
        'task_follow_up_date_before': 'taskFollowUpDateBefore',
        'task_follow_up_date_after': 'taskFollowUpDateAfter',
        'started_before': 'startedBefore',
        'started_after': 'startedAfter',
        'finished_before': 'finishedBefore',
        'finished_after': 'finishedAfter',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'task_variables': 'taskVariables',
        'process_variables': 'processVariables',
        'variable_names_ignore_case': 'variableNamesIgnoreCase',
        'variable_values_ignore_case': 'variableValuesIgnoreCase',
        'task_involved_user': 'taskInvolvedUser',
        'task_involved_group': 'taskInvolvedGroup',
        'task_had_candidate_user': 'taskHadCandidateUser',
        'task_had_candidate_group': 'taskHadCandidateGroup',
        'with_candidate_groups': 'withCandidateGroups',
        'without_candidate_groups': 'withoutCandidateGroups',
        'or_queries': 'orQueries',
        'sorting': 'sorting'
    }

    def __init__(self, task_id=None, task_parent_task_id=None, process_instance_id=None, process_instance_business_key=None, process_instance_business_key_in=None, process_instance_business_key_like=None, execution_id=None, process_definition_id=None, process_definition_key=None, process_definition_name=None, case_instance_id=None, case_execution_id=None, case_definition_id=None, case_definition_key=None, case_definition_name=None, activity_instance_id_in=None, task_name=None, task_name_like=None, task_description=None, task_description_like=None, task_definition_key=None, task_definition_key_in=None, task_delete_reason=None, task_delete_reason_like=None, task_assignee=None, task_assignee_like=None, task_owner=None, task_owner_like=None, task_priority=None, assigned=None, unassigned=None, finished=None, unfinished=None, process_finished=None, process_unfinished=None, task_due_date=None, task_due_date_before=None, task_due_date_after=None, without_task_due_date=None, task_follow_up_date=None, task_follow_up_date_before=None, task_follow_up_date_after=None, started_before=None, started_after=None, finished_before=None, finished_after=None, tenant_id_in=None, without_tenant_id=None, task_variables=None, process_variables=None, variable_names_ignore_case=None, variable_values_ignore_case=None, task_involved_user=None, task_involved_group=None, task_had_candidate_user=None, task_had_candidate_group=None, with_candidate_groups=None, without_candidate_groups=None, or_queries=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """HistoricTaskInstanceQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._task_id = None
        self._task_parent_task_id = None
        self._process_instance_id = None
        self._process_instance_business_key = None
        self._process_instance_business_key_in = None
        self._process_instance_business_key_like = None
        self._execution_id = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._process_definition_name = None
        self._case_instance_id = None
        self._case_execution_id = None
        self._case_definition_id = None
        self._case_definition_key = None
        self._case_definition_name = None
        self._activity_instance_id_in = None
        self._task_name = None
        self._task_name_like = None
        self._task_description = None
        self._task_description_like = None
        self._task_definition_key = None
        self._task_definition_key_in = None
        self._task_delete_reason = None
        self._task_delete_reason_like = None
        self._task_assignee = None
        self._task_assignee_like = None
        self._task_owner = None
        self._task_owner_like = None
        self._task_priority = None
        self._assigned = None
        self._unassigned = None
        self._finished = None
        self._unfinished = None
        self._process_finished = None
        self._process_unfinished = None
        self._task_due_date = None
        self._task_due_date_before = None
        self._task_due_date_after = None
        self._without_task_due_date = None
        self._task_follow_up_date = None
        self._task_follow_up_date_before = None
        self._task_follow_up_date_after = None
        self._started_before = None
        self._started_after = None
        self._finished_before = None
        self._finished_after = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._task_variables = None
        self._process_variables = None
        self._variable_names_ignore_case = None
        self._variable_values_ignore_case = None
        self._task_involved_user = None
        self._task_involved_group = None
        self._task_had_candidate_user = None
        self._task_had_candidate_group = None
        self._with_candidate_groups = None
        self._without_candidate_groups = None
        self._or_queries = None
        self._sorting = None
        self.discriminator = None

        self.task_id = task_id
        self.task_parent_task_id = task_parent_task_id
        self.process_instance_id = process_instance_id
        self.process_instance_business_key = process_instance_business_key
        self.process_instance_business_key_in = process_instance_business_key_in
        self.process_instance_business_key_like = process_instance_business_key_like
        self.execution_id = execution_id
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.process_definition_name = process_definition_name
        self.case_instance_id = case_instance_id
        self.case_execution_id = case_execution_id
        self.case_definition_id = case_definition_id
        self.case_definition_key = case_definition_key
        self.case_definition_name = case_definition_name
        self.activity_instance_id_in = activity_instance_id_in
        self.task_name = task_name
        self.task_name_like = task_name_like
        self.task_description = task_description
        self.task_description_like = task_description_like
        self.task_definition_key = task_definition_key
        self.task_definition_key_in = task_definition_key_in
        self.task_delete_reason = task_delete_reason
        self.task_delete_reason_like = task_delete_reason_like
        self.task_assignee = task_assignee
        self.task_assignee_like = task_assignee_like
        self.task_owner = task_owner
        self.task_owner_like = task_owner_like
        self.task_priority = task_priority
        self.assigned = assigned
        self.unassigned = unassigned
        self.finished = finished
        self.unfinished = unfinished
        self.process_finished = process_finished
        self.process_unfinished = process_unfinished
        self.task_due_date = task_due_date
        self.task_due_date_before = task_due_date_before
        self.task_due_date_after = task_due_date_after
        self.without_task_due_date = without_task_due_date
        self.task_follow_up_date = task_follow_up_date
        self.task_follow_up_date_before = task_follow_up_date_before
        self.task_follow_up_date_after = task_follow_up_date_after
        self.started_before = started_before
        self.started_after = started_after
        self.finished_before = finished_before
        self.finished_after = finished_after
        self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        self.task_variables = task_variables
        self.process_variables = process_variables
        self.variable_names_ignore_case = variable_names_ignore_case
        self.variable_values_ignore_case = variable_values_ignore_case
        self.task_involved_user = task_involved_user
        self.task_involved_group = task_involved_group
        self.task_had_candidate_user = task_had_candidate_user
        self.task_had_candidate_group = task_had_candidate_group
        self.with_candidate_groups = with_candidate_groups
        self.without_candidate_groups = without_candidate_groups
        self.or_queries = or_queries
        self.sorting = sorting

    @property
    def task_id(self):
        """Gets the task_id of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by task id.  # noqa: E501

        :return: The task_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Sets the task_id of this HistoricTaskInstanceQueryDto.

        Filter by task id.  # noqa: E501

        :param task_id: The task_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_id = task_id

    @property
    def task_parent_task_id(self):
        """Gets the task_parent_task_id of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by parent task id.  # noqa: E501

        :return: The task_parent_task_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_parent_task_id

    @task_parent_task_id.setter
    def task_parent_task_id(self, task_parent_task_id):
        """Sets the task_parent_task_id of this HistoricTaskInstanceQueryDto.

        Filter by parent task id.  # noqa: E501

        :param task_parent_task_id: The task_parent_task_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_parent_task_id = task_parent_task_id

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by process instance id.  # noqa: E501

        :return: The process_instance_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricTaskInstanceQueryDto.

        Filter by process instance id.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def process_instance_business_key(self):
        """Gets the process_instance_business_key of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by process instance business key.  # noqa: E501

        :return: The process_instance_business_key of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_business_key

    @process_instance_business_key.setter
    def process_instance_business_key(self, process_instance_business_key):
        """Sets the process_instance_business_key of this HistoricTaskInstanceQueryDto.

        Filter by process instance business key.  # noqa: E501

        :param process_instance_business_key: The process_instance_business_key of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_business_key = process_instance_business_key

    @property
    def process_instance_business_key_in(self):
        """Gets the process_instance_business_key_in of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list.  # noqa: E501

        :return: The process_instance_business_key_in of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_instance_business_key_in

    @process_instance_business_key_in.setter
    def process_instance_business_key_in(self, process_instance_business_key_in):
        """Sets the process_instance_business_key_in of this HistoricTaskInstanceQueryDto.

        Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list.  # noqa: E501

        :param process_instance_business_key_in: The process_instance_business_key_in of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_instance_business_key_in = process_instance_business_key_in

    @property
    def process_instance_business_key_like(self):
        """Gets the process_instance_business_key_like of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by  process instance business key that has the parameter value as a substring.  # noqa: E501

        :return: The process_instance_business_key_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_business_key_like

    @process_instance_business_key_like.setter
    def process_instance_business_key_like(self, process_instance_business_key_like):
        """Sets the process_instance_business_key_like of this HistoricTaskInstanceQueryDto.

        Filter by  process instance business key that has the parameter value as a substring.  # noqa: E501

        :param process_instance_business_key_like: The process_instance_business_key_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_business_key_like = process_instance_business_key_like

    @property
    def execution_id(self):
        """Gets the execution_id of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by the id of the execution that executed the task.  # noqa: E501

        :return: The execution_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this HistoricTaskInstanceQueryDto.

        Filter by the id of the execution that executed the task.  # noqa: E501

        :param execution_id: The execution_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by process definition id.  # noqa: E501

        :return: The process_definition_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricTaskInstanceQueryDto.

        Filter by process definition id.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that belong to a process definition with the given key.  # noqa: E501

        :return: The process_definition_key of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that belong to a process definition with the given key.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_definition_name(self):
        """Gets the process_definition_name of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that belong to a process definition with the given name.  # noqa: E501

        :return: The process_definition_name of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_name

    @process_definition_name.setter
    def process_definition_name(self, process_definition_name):
        """Sets the process_definition_name of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that belong to a process definition with the given name.  # noqa: E501

        :param process_definition_name: The process_definition_name of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_name = process_definition_name

    @property
    def case_instance_id(self):
        """Gets the case_instance_id of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by case instance id.  # noqa: E501

        :return: The case_instance_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_id

    @case_instance_id.setter
    def case_instance_id(self, case_instance_id):
        """Sets the case_instance_id of this HistoricTaskInstanceQueryDto.

        Filter by case instance id.  # noqa: E501

        :param case_instance_id: The case_instance_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._case_instance_id = case_instance_id

    @property
    def case_execution_id(self):
        """Gets the case_execution_id of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by the id of the case execution that executed the task.  # noqa: E501

        :return: The case_execution_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_execution_id

    @case_execution_id.setter
    def case_execution_id(self, case_execution_id):
        """Sets the case_execution_id of this HistoricTaskInstanceQueryDto.

        Filter by the id of the case execution that executed the task.  # noqa: E501

        :param case_execution_id: The case_execution_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._case_execution_id = case_execution_id

    @property
    def case_definition_id(self):
        """Gets the case_definition_id of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by case definition id.  # noqa: E501

        :return: The case_definition_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_id

    @case_definition_id.setter
    def case_definition_id(self, case_definition_id):
        """Sets the case_definition_id of this HistoricTaskInstanceQueryDto.

        Filter by case definition id.  # noqa: E501

        :param case_definition_id: The case_definition_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._case_definition_id = case_definition_id

    @property
    def case_definition_key(self):
        """Gets the case_definition_key of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that belong to a case definition with the given key.  # noqa: E501

        :return: The case_definition_key of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_key

    @case_definition_key.setter
    def case_definition_key(self, case_definition_key):
        """Sets the case_definition_key of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that belong to a case definition with the given key.  # noqa: E501

        :param case_definition_key: The case_definition_key of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._case_definition_key = case_definition_key

    @property
    def case_definition_name(self):
        """Gets the case_definition_name of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that belong to a case definition with the given name.  # noqa: E501

        :return: The case_definition_name of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_name

    @case_definition_name.setter
    def case_definition_name(self, case_definition_name):
        """Sets the case_definition_name of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that belong to a case definition with the given name.  # noqa: E501

        :param case_definition_name: The case_definition_name of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._case_definition_name = case_definition_name

    @property
    def activity_instance_id_in(self):
        """Gets the activity_instance_id_in of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Only include tasks which belong to one of the passed  activity instance ids.  # noqa: E501

        :return: The activity_instance_id_in of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._activity_instance_id_in

    @activity_instance_id_in.setter
    def activity_instance_id_in(self, activity_instance_id_in):
        """Sets the activity_instance_id_in of this HistoricTaskInstanceQueryDto.

        Only include tasks which belong to one of the passed  activity instance ids.  # noqa: E501

        :param activity_instance_id_in: The activity_instance_id_in of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._activity_instance_id_in = activity_instance_id_in

    @property
    def task_name(self):
        """Gets the task_name of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have the given name.  # noqa: E501

        :return: The task_name of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_name

    @task_name.setter
    def task_name(self, task_name):
        """Sets the task_name of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have the given name.  # noqa: E501

        :param task_name: The task_name of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_name = task_name

    @property
    def task_name_like(self):
        """Gets the task_name_like of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have a name with the given parameter value as substring.  # noqa: E501

        :return: The task_name_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_name_like

    @task_name_like.setter
    def task_name_like(self, task_name_like):
        """Sets the task_name_like of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have a name with the given parameter value as substring.  # noqa: E501

        :param task_name_like: The task_name_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_name_like = task_name_like

    @property
    def task_description(self):
        """Gets the task_description of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have the given description.  # noqa: E501

        :return: The task_description of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_description

    @task_description.setter
    def task_description(self, task_description):
        """Sets the task_description of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have the given description.  # noqa: E501

        :param task_description: The task_description of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_description = task_description

    @property
    def task_description_like(self):
        """Gets the task_description_like of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have a description that has the parameter value as a substring.  # noqa: E501

        :return: The task_description_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_description_like

    @task_description_like.setter
    def task_description_like(self, task_description_like):
        """Sets the task_description_like of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have a description that has the parameter value as a substring.  # noqa: E501

        :param task_description_like: The task_description_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_description_like = task_description_like

    @property
    def task_definition_key(self):
        """Gets the task_definition_key of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have the given key.  # noqa: E501

        :return: The task_definition_key of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_definition_key

    @task_definition_key.setter
    def task_definition_key(self, task_definition_key):
        """Sets the task_definition_key of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have the given key.  # noqa: E501

        :param task_definition_key: The task_definition_key of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_definition_key = task_definition_key

    @property
    def task_definition_key_in(self):
        """Gets the task_definition_key_in of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have one of the passed  task definition keys.  # noqa: E501

        :return: The task_definition_key_in of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._task_definition_key_in

    @task_definition_key_in.setter
    def task_definition_key_in(self, task_definition_key_in):
        """Sets the task_definition_key_in of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have one of the passed  task definition keys.  # noqa: E501

        :param task_definition_key_in: The task_definition_key_in of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._task_definition_key_in = task_definition_key_in

    @property
    def task_delete_reason(self):
        """Gets the task_delete_reason of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have the given delete reason.  # noqa: E501

        :return: The task_delete_reason of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_delete_reason

    @task_delete_reason.setter
    def task_delete_reason(self, task_delete_reason):
        """Sets the task_delete_reason of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have the given delete reason.  # noqa: E501

        :param task_delete_reason: The task_delete_reason of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_delete_reason = task_delete_reason

    @property
    def task_delete_reason_like(self):
        """Gets the task_delete_reason_like of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have a delete reason that has the parameter value as a substring.  # noqa: E501

        :return: The task_delete_reason_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_delete_reason_like

    @task_delete_reason_like.setter
    def task_delete_reason_like(self, task_delete_reason_like):
        """Sets the task_delete_reason_like of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have a delete reason that has the parameter value as a substring.  # noqa: E501

        :param task_delete_reason_like: The task_delete_reason_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_delete_reason_like = task_delete_reason_like

    @property
    def task_assignee(self):
        """Gets the task_assignee of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that the given user is assigned to.  # noqa: E501

        :return: The task_assignee of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_assignee

    @task_assignee.setter
    def task_assignee(self, task_assignee):
        """Sets the task_assignee of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that the given user is assigned to.  # noqa: E501

        :param task_assignee: The task_assignee of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_assignee = task_assignee

    @property
    def task_assignee_like(self):
        """Gets the task_assignee_like of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that are assigned to users with the parameter value as a substring.  # noqa: E501

        :return: The task_assignee_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_assignee_like

    @task_assignee_like.setter
    def task_assignee_like(self, task_assignee_like):
        """Sets the task_assignee_like of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that are assigned to users with the parameter value as a substring.  # noqa: E501

        :param task_assignee_like: The task_assignee_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_assignee_like = task_assignee_like

    @property
    def task_owner(self):
        """Gets the task_owner of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that the given user owns.  # noqa: E501

        :return: The task_owner of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_owner

    @task_owner.setter
    def task_owner(self, task_owner):
        """Sets the task_owner of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that the given user owns.  # noqa: E501

        :param task_owner: The task_owner of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_owner = task_owner

    @property
    def task_owner_like(self):
        """Gets the task_owner_like of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that are owned by users with the parameter value as a substring.  # noqa: E501

        :return: The task_owner_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_owner_like

    @task_owner_like.setter
    def task_owner_like(self, task_owner_like):
        """Sets the task_owner_like of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that are owned by users with the parameter value as a substring.  # noqa: E501

        :param task_owner_like: The task_owner_like of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_owner_like = task_owner_like

    @property
    def task_priority(self):
        """Gets the task_priority of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have the given priority.  # noqa: E501

        :return: The task_priority of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: int
        """
        return self._task_priority

    @task_priority.setter
    def task_priority(self, task_priority):
        """Sets the task_priority of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have the given priority.  # noqa: E501

        :param task_priority: The task_priority of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: int
        """

        self._task_priority = task_priority

    @property
    def assigned(self):
        """Gets the assigned of this HistoricTaskInstanceQueryDto.  # noqa: E501

        If set to `true`, restricts the query to all tasks that are assigned.  # noqa: E501

        :return: The assigned of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._assigned

    @assigned.setter
    def assigned(self, assigned):
        """Sets the assigned of this HistoricTaskInstanceQueryDto.

        If set to `true`, restricts the query to all tasks that are assigned.  # noqa: E501

        :param assigned: The assigned of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._assigned = assigned

    @property
    def unassigned(self):
        """Gets the unassigned of this HistoricTaskInstanceQueryDto.  # noqa: E501

        If set to `true`, restricts the query to all tasks that are unassigned.  # noqa: E501

        :return: The unassigned of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._unassigned

    @unassigned.setter
    def unassigned(self, unassigned):
        """Sets the unassigned of this HistoricTaskInstanceQueryDto.

        If set to `true`, restricts the query to all tasks that are unassigned.  # noqa: E501

        :param unassigned: The unassigned of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._unassigned = unassigned

    @property
    def finished(self):
        """Gets the finished of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Only include finished tasks. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The finished of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._finished

    @finished.setter
    def finished(self, finished):
        """Sets the finished of this HistoricTaskInstanceQueryDto.

        Only include finished tasks. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param finished: The finished of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._finished = finished

    @property
    def unfinished(self):
        """Gets the unfinished of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Only include unfinished tasks. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The unfinished of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._unfinished

    @unfinished.setter
    def unfinished(self, unfinished):
        """Sets the unfinished of this HistoricTaskInstanceQueryDto.

        Only include unfinished tasks. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param unfinished: The unfinished of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._unfinished = unfinished

    @property
    def process_finished(self):
        """Gets the process_finished of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Only include tasks of finished processes. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The process_finished of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._process_finished

    @process_finished.setter
    def process_finished(self, process_finished):
        """Sets the process_finished of this HistoricTaskInstanceQueryDto.

        Only include tasks of finished processes. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param process_finished: The process_finished of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._process_finished = process_finished

    @property
    def process_unfinished(self):
        """Gets the process_unfinished of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Only include tasks of unfinished processes. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The process_unfinished of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._process_unfinished

    @process_unfinished.setter
    def process_unfinished(self, process_unfinished):
        """Sets the process_unfinished of this HistoricTaskInstanceQueryDto.

        Only include tasks of unfinished processes. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param process_unfinished: The process_unfinished of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._process_unfinished = process_unfinished

    @property
    def task_due_date(self):
        """Gets the task_due_date of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The task_due_date of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._task_due_date

    @task_due_date.setter
    def task_due_date(self, task_due_date):
        """Sets the task_due_date of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param task_due_date: The task_due_date of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._task_due_date = task_due_date

    @property
    def task_due_date_before(self):
        """Gets the task_due_date_before of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The task_due_date_before of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._task_due_date_before

    @task_due_date_before.setter
    def task_due_date_before(self, task_due_date_before):
        """Sets the task_due_date_before of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param task_due_date_before: The task_due_date_before of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._task_due_date_before = task_due_date_before

    @property
    def task_due_date_after(self):
        """Gets the task_due_date_after of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The task_due_date_after of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._task_due_date_after

    @task_due_date_after.setter
    def task_due_date_after(self, task_due_date_after):
        """Sets the task_due_date_after of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param task_due_date_after: The task_due_date_after of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._task_due_date_after = task_due_date_after

    @property
    def without_task_due_date(self):
        """Gets the without_task_due_date of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Only include tasks which have no due date. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_task_due_date of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_task_due_date

    @without_task_due_date.setter
    def without_task_due_date(self, without_task_due_date):
        """Sets the without_task_due_date of this HistoricTaskInstanceQueryDto.

        Only include tasks which have no due date. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_task_due_date: The without_task_due_date of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_task_due_date = without_task_due_date

    @property
    def task_follow_up_date(self):
        """Gets the task_follow_up_date of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The task_follow_up_date of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._task_follow_up_date

    @task_follow_up_date.setter
    def task_follow_up_date(self, task_follow_up_date):
        """Sets the task_follow_up_date of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param task_follow_up_date: The task_follow_up_date of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._task_follow_up_date = task_follow_up_date

    @property
    def task_follow_up_date_before(self):
        """Gets the task_follow_up_date_before of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The task_follow_up_date_before of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._task_follow_up_date_before

    @task_follow_up_date_before.setter
    def task_follow_up_date_before(self, task_follow_up_date_before):
        """Sets the task_follow_up_date_before of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param task_follow_up_date_before: The task_follow_up_date_before of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._task_follow_up_date_before = task_follow_up_date_before

    @property
    def task_follow_up_date_after(self):
        """Gets the task_follow_up_date_after of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The task_follow_up_date_after of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._task_follow_up_date_after

    @task_follow_up_date_after.setter
    def task_follow_up_date_after(self, task_follow_up_date_after):
        """Sets the task_follow_up_date_after of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param task_follow_up_date_after: The task_follow_up_date_after of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._task_follow_up_date_after = task_follow_up_date_after

    @property
    def started_before(self):
        """Gets the started_before of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The started_before of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._started_before

    @started_before.setter
    def started_before(self, started_before):
        """Sets the started_before of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param started_before: The started_before of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._started_before = started_before

    @property
    def started_after(self):
        """Gets the started_after of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The started_after of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._started_after

    @started_after.setter
    def started_after(self, started_after):
        """Sets the started_after of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param started_after: The started_after of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._started_after = started_after

    @property
    def finished_before(self):
        """Gets the finished_before of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The finished_before of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._finished_before

    @finished_before.setter
    def finished_before(self, finished_before):
        """Sets the finished_before of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param finished_before: The finished_before of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._finished_before = finished_before

    @property
    def finished_after(self):
        """Gets the finished_after of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The finished_after of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._finished_after

    @finished_after.setter
    def finished_after(self, finished_after):
        """Sets the finished_after of this HistoricTaskInstanceQueryDto.

        Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param finished_after: The finished_after of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: datetime
        """

        self._finished_after = finished_after

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Filter by a  list of tenant ids. A task instance must have one of the given tenant ids.  # noqa: E501

        :return: The tenant_id_in of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this HistoricTaskInstanceQueryDto.

        Filter by a  list of tenant ids. A task instance must have one of the given tenant ids.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Only include historic task instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this HistoricTaskInstanceQueryDto.

        Only include historic task instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def task_variables(self):
        """Gets the task_variables of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`.  `key` and `value` may not contain underscore or comma characters.  # noqa: E501

        :return: The task_variables of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: list[VariableQueryParameterDto]
        """
        return self._task_variables

    @task_variables.setter
    def task_variables(self, task_variables):
        """Sets the task_variables of this HistoricTaskInstanceQueryDto.

        Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`.  `key` and `value` may not contain underscore or comma characters.  # noqa: E501

        :param task_variables: The task_variables of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: list[VariableQueryParameterDto]
        """

        self._task_variables = task_variables

    @property
    def process_variables(self):
        """Gets the process_variables of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`; * `notLike`.  `key` and `value` may not contain underscore or comma characters.  # noqa: E501

        :return: The process_variables of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: list[VariableQueryParameterDto]
        """
        return self._process_variables

    @process_variables.setter
    def process_variables(self, process_variables):
        """Sets the process_variables of this HistoricTaskInstanceQueryDto.

        Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`; * `notLike`.  `key` and `value` may not contain underscore or comma characters.  # noqa: E501

        :param process_variables: The process_variables of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: list[VariableQueryParameterDto]
        """

        self._process_variables = process_variables

    @property
    def variable_names_ignore_case(self):
        """Gets the variable_names_ignore_case of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Match the variable name provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.  # noqa: E501

        :return: The variable_names_ignore_case of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._variable_names_ignore_case

    @variable_names_ignore_case.setter
    def variable_names_ignore_case(self, variable_names_ignore_case):
        """Sets the variable_names_ignore_case of this HistoricTaskInstanceQueryDto.

        Match the variable name provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.  # noqa: E501

        :param variable_names_ignore_case: The variable_names_ignore_case of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._variable_names_ignore_case = variable_names_ignore_case

    @property
    def variable_values_ignore_case(self):
        """Gets the variable_values_ignore_case of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Match the variable value provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.  # noqa: E501

        :return: The variable_values_ignore_case of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._variable_values_ignore_case

    @variable_values_ignore_case.setter
    def variable_values_ignore_case(self, variable_values_ignore_case):
        """Sets the variable_values_ignore_case of this HistoricTaskInstanceQueryDto.

        Match the variable value provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.  # noqa: E501

        :param variable_values_ignore_case: The variable_values_ignore_case of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._variable_values_ignore_case = variable_values_ignore_case

    @property
    def task_involved_user(self):
        """Gets the task_involved_user of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks with a historic identity link to the given user.  # noqa: E501

        :return: The task_involved_user of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_involved_user

    @task_involved_user.setter
    def task_involved_user(self, task_involved_user):
        """Sets the task_involved_user of this HistoricTaskInstanceQueryDto.

        Restrict to tasks with a historic identity link to the given user.  # noqa: E501

        :param task_involved_user: The task_involved_user of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_involved_user = task_involved_user

    @property
    def task_involved_group(self):
        """Gets the task_involved_group of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks with a historic identity link to the given group.  # noqa: E501

        :return: The task_involved_group of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_involved_group

    @task_involved_group.setter
    def task_involved_group(self, task_involved_group):
        """Sets the task_involved_group of this HistoricTaskInstanceQueryDto.

        Restrict to tasks with a historic identity link to the given group.  # noqa: E501

        :param task_involved_group: The task_involved_group of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_involved_group = task_involved_group

    @property
    def task_had_candidate_user(self):
        """Gets the task_had_candidate_user of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks with a historic identity link to the given candidate user.  # noqa: E501

        :return: The task_had_candidate_user of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_had_candidate_user

    @task_had_candidate_user.setter
    def task_had_candidate_user(self, task_had_candidate_user):
        """Sets the task_had_candidate_user of this HistoricTaskInstanceQueryDto.

        Restrict to tasks with a historic identity link to the given candidate user.  # noqa: E501

        :param task_had_candidate_user: The task_had_candidate_user of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_had_candidate_user = task_had_candidate_user

    @property
    def task_had_candidate_group(self):
        """Gets the task_had_candidate_group of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Restrict to tasks with a historic identity link to the given candidate group.  # noqa: E501

        :return: The task_had_candidate_group of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_had_candidate_group

    @task_had_candidate_group.setter
    def task_had_candidate_group(self, task_had_candidate_group):
        """Sets the task_had_candidate_group of this HistoricTaskInstanceQueryDto.

        Restrict to tasks with a historic identity link to the given candidate group.  # noqa: E501

        :param task_had_candidate_group: The task_had_candidate_group of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: str
        """

        self._task_had_candidate_group = task_had_candidate_group

    @property
    def with_candidate_groups(self):
        """Gets the with_candidate_groups of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The with_candidate_groups of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._with_candidate_groups

    @with_candidate_groups.setter
    def with_candidate_groups(self, with_candidate_groups):
        """Sets the with_candidate_groups of this HistoricTaskInstanceQueryDto.

        Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param with_candidate_groups: The with_candidate_groups of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._with_candidate_groups = with_candidate_groups

    @property
    def without_candidate_groups(self):
        """Gets the without_candidate_groups of this HistoricTaskInstanceQueryDto.  # noqa: E501

        Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_candidate_groups of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_candidate_groups

    @without_candidate_groups.setter
    def without_candidate_groups(self, without_candidate_groups):
        """Sets the without_candidate_groups of this HistoricTaskInstanceQueryDto.

        Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_candidate_groups: The without_candidate_groups of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_candidate_groups = without_candidate_groups

    @property
    def or_queries(self):
        """Gets the or_queries of this HistoricTaskInstanceQueryDto.  # noqa: E501

        A JSON array of nested historic task instance queries with OR semantics.  A task instance matches a nested query if it fulfills at least one of the query's predicates.  With multiple nested queries, a task instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All task instance query properties can be used except for: `sorting`, `withCandidateGroups`, ` withoutCandidateGroups`.  See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.  # noqa: E501

        :return: The or_queries of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: list[HistoricTaskInstanceQueryDto]
        """
        return self._or_queries

    @or_queries.setter
    def or_queries(self, or_queries):
        """Sets the or_queries of this HistoricTaskInstanceQueryDto.

        A JSON array of nested historic task instance queries with OR semantics.  A task instance matches a nested query if it fulfills at least one of the query's predicates.  With multiple nested queries, a task instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All task instance query properties can be used except for: `sorting`, `withCandidateGroups`, ` withoutCandidateGroups`.  See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.  # noqa: E501

        :param or_queries: The or_queries of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: list[HistoricTaskInstanceQueryDto]
        """

        self._or_queries = or_queries

    @property
    def sorting(self):
        """Gets the sorting of this HistoricTaskInstanceQueryDto.  # noqa: E501

        An array of criteria to sort the result by. Each element of the array is                     an object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Sorting has no effect for `count` endpoints  # noqa: E501

        :return: The sorting of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :rtype: list[HistoricTaskInstanceQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this HistoricTaskInstanceQueryDto.

        An array of criteria to sort the result by. Each element of the array is                     an object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Sorting has no effect for `count` endpoints  # noqa: E501

        :param sorting: The sorting of this HistoricTaskInstanceQueryDto.  # noqa: E501
        :type: list[HistoricTaskInstanceQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricTaskInstanceQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricTaskInstanceQueryDto):
            return True

        return self.to_dict() != other.to_dict()
