# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricTaskInstanceDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'process_definition_key': 'str',
        'process_definition_id': 'str',
        'process_instance_id': 'str',
        'execution_id': 'str',
        'case_definition_key': 'str',
        'case_definition_id': 'str',
        'case_instance_id': 'str',
        'case_execution_id': 'str',
        'activity_instance_id': 'str',
        'name': 'str',
        'description': 'str',
        'delete_reason': 'str',
        'owner': 'str',
        'assignee': 'str',
        'start_time': 'datetime',
        'end_time': 'datetime',
        'duration': 'int',
        'task_definition_key': 'str',
        'priority': 'int',
        'due': 'datetime',
        'parent_task_id': 'str',
        'follow_up': 'datetime',
        'tenant_id': 'str',
        'removal_time': 'datetime',
        'root_process_instance_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'process_definition_key': 'processDefinitionKey',
        'process_definition_id': 'processDefinitionId',
        'process_instance_id': 'processInstanceId',
        'execution_id': 'executionId',
        'case_definition_key': 'caseDefinitionKey',
        'case_definition_id': 'caseDefinitionId',
        'case_instance_id': 'caseInstanceId',
        'case_execution_id': 'caseExecutionId',
        'activity_instance_id': 'activityInstanceId',
        'name': 'name',
        'description': 'description',
        'delete_reason': 'deleteReason',
        'owner': 'owner',
        'assignee': 'assignee',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'duration': 'duration',
        'task_definition_key': 'taskDefinitionKey',
        'priority': 'priority',
        'due': 'due',
        'parent_task_id': 'parentTaskId',
        'follow_up': 'followUp',
        'tenant_id': 'tenantId',
        'removal_time': 'removalTime',
        'root_process_instance_id': 'rootProcessInstanceId'
    }

    def __init__(self, id=None, process_definition_key=None, process_definition_id=None, process_instance_id=None, execution_id=None, case_definition_key=None, case_definition_id=None, case_instance_id=None, case_execution_id=None, activity_instance_id=None, name=None, description=None, delete_reason=None, owner=None, assignee=None, start_time=None, end_time=None, duration=None, task_definition_key=None, priority=None, due=None, parent_task_id=None, follow_up=None, tenant_id=None, removal_time=None, root_process_instance_id=None, local_vars_configuration=None):  # noqa: E501
        """HistoricTaskInstanceDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._process_definition_key = None
        self._process_definition_id = None
        self._process_instance_id = None
        self._execution_id = None
        self._case_definition_key = None
        self._case_definition_id = None
        self._case_instance_id = None
        self._case_execution_id = None
        self._activity_instance_id = None
        self._name = None
        self._description = None
        self._delete_reason = None
        self._owner = None
        self._assignee = None
        self._start_time = None
        self._end_time = None
        self._duration = None
        self._task_definition_key = None
        self._priority = None
        self._due = None
        self._parent_task_id = None
        self._follow_up = None
        self._tenant_id = None
        self._removal_time = None
        self._root_process_instance_id = None
        self.discriminator = None

        self.id = id
        self.process_definition_key = process_definition_key
        self.process_definition_id = process_definition_id
        self.process_instance_id = process_instance_id
        self.execution_id = execution_id
        self.case_definition_key = case_definition_key
        self.case_definition_id = case_definition_id
        self.case_instance_id = case_instance_id
        self.case_execution_id = case_execution_id
        self.activity_instance_id = activity_instance_id
        self.name = name
        self.description = description
        self.delete_reason = delete_reason
        self.owner = owner
        self.assignee = assignee
        self.start_time = start_time
        self.end_time = end_time
        self.duration = duration
        self.task_definition_key = task_definition_key
        self.priority = priority
        self.due = due
        self.parent_task_id = parent_task_id
        self.follow_up = follow_up
        self.tenant_id = tenant_id
        self.removal_time = removal_time
        self.root_process_instance_id = root_process_instance_id

    @property
    def id(self):
        """Gets the id of this HistoricTaskInstanceDto.  # noqa: E501

        The task id.  # noqa: E501

        :return: The id of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HistoricTaskInstanceDto.

        The task id.  # noqa: E501

        :param id: The id of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricTaskInstanceDto.  # noqa: E501

        The key of the process definition the task belongs to.  # noqa: E501

        :return: The process_definition_key of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricTaskInstanceDto.

        The key of the process definition the task belongs to.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricTaskInstanceDto.  # noqa: E501

        The id of the process definition the task belongs to.  # noqa: E501

        :return: The process_definition_id of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricTaskInstanceDto.

        The id of the process definition the task belongs to.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricTaskInstanceDto.  # noqa: E501

        The id of the process instance the task belongs to.  # noqa: E501

        :return: The process_instance_id of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricTaskInstanceDto.

        The id of the process instance the task belongs to.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def execution_id(self):
        """Gets the execution_id of this HistoricTaskInstanceDto.  # noqa: E501

        The id of the execution the task belongs to.  # noqa: E501

        :return: The execution_id of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this HistoricTaskInstanceDto.

        The id of the execution the task belongs to.  # noqa: E501

        :param execution_id: The execution_id of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def case_definition_key(self):
        """Gets the case_definition_key of this HistoricTaskInstanceDto.  # noqa: E501

        The key of the case definition the task belongs to.  # noqa: E501

        :return: The case_definition_key of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_key

    @case_definition_key.setter
    def case_definition_key(self, case_definition_key):
        """Sets the case_definition_key of this HistoricTaskInstanceDto.

        The key of the case definition the task belongs to.  # noqa: E501

        :param case_definition_key: The case_definition_key of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._case_definition_key = case_definition_key

    @property
    def case_definition_id(self):
        """Gets the case_definition_id of this HistoricTaskInstanceDto.  # noqa: E501

        The id of the case definition the task belongs to.  # noqa: E501

        :return: The case_definition_id of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_id

    @case_definition_id.setter
    def case_definition_id(self, case_definition_id):
        """Sets the case_definition_id of this HistoricTaskInstanceDto.

        The id of the case definition the task belongs to.  # noqa: E501

        :param case_definition_id: The case_definition_id of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._case_definition_id = case_definition_id

    @property
    def case_instance_id(self):
        """Gets the case_instance_id of this HistoricTaskInstanceDto.  # noqa: E501

        The id of the case instance the task belongs to.  # noqa: E501

        :return: The case_instance_id of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_id

    @case_instance_id.setter
    def case_instance_id(self, case_instance_id):
        """Sets the case_instance_id of this HistoricTaskInstanceDto.

        The id of the case instance the task belongs to.  # noqa: E501

        :param case_instance_id: The case_instance_id of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._case_instance_id = case_instance_id

    @property
    def case_execution_id(self):
        """Gets the case_execution_id of this HistoricTaskInstanceDto.  # noqa: E501

        The id of the case execution the task belongs to.  # noqa: E501

        :return: The case_execution_id of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._case_execution_id

    @case_execution_id.setter
    def case_execution_id(self, case_execution_id):
        """Sets the case_execution_id of this HistoricTaskInstanceDto.

        The id of the case execution the task belongs to.  # noqa: E501

        :param case_execution_id: The case_execution_id of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._case_execution_id = case_execution_id

    @property
    def activity_instance_id(self):
        """Gets the activity_instance_id of this HistoricTaskInstanceDto.  # noqa: E501

        The id of the activity that this object is an instance of.  # noqa: E501

        :return: The activity_instance_id of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_instance_id

    @activity_instance_id.setter
    def activity_instance_id(self, activity_instance_id):
        """Sets the activity_instance_id of this HistoricTaskInstanceDto.

        The id of the activity that this object is an instance of.  # noqa: E501

        :param activity_instance_id: The activity_instance_id of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._activity_instance_id = activity_instance_id

    @property
    def name(self):
        """Gets the name of this HistoricTaskInstanceDto.  # noqa: E501

        The task name.  # noqa: E501

        :return: The name of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this HistoricTaskInstanceDto.

        The task name.  # noqa: E501

        :param name: The name of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """Gets the description of this HistoricTaskInstanceDto.  # noqa: E501

        The task's description.  # noqa: E501

        :return: The description of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this HistoricTaskInstanceDto.

        The task's description.  # noqa: E501

        :param description: The description of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def delete_reason(self):
        """Gets the delete_reason of this HistoricTaskInstanceDto.  # noqa: E501

        The task's delete reason.  # noqa: E501

        :return: The delete_reason of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._delete_reason

    @delete_reason.setter
    def delete_reason(self, delete_reason):
        """Sets the delete_reason of this HistoricTaskInstanceDto.

        The task's delete reason.  # noqa: E501

        :param delete_reason: The delete_reason of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._delete_reason = delete_reason

    @property
    def owner(self):
        """Gets the owner of this HistoricTaskInstanceDto.  # noqa: E501

        The owner's id.  # noqa: E501

        :return: The owner of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """Sets the owner of this HistoricTaskInstanceDto.

        The owner's id.  # noqa: E501

        :param owner: The owner of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._owner = owner

    @property
    def assignee(self):
        """Gets the assignee of this HistoricTaskInstanceDto.  # noqa: E501

        The assignee's id.  # noqa: E501

        :return: The assignee of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._assignee

    @assignee.setter
    def assignee(self, assignee):
        """Sets the assignee of this HistoricTaskInstanceDto.

        The assignee's id.  # noqa: E501

        :param assignee: The assignee of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._assignee = assignee

    @property
    def start_time(self):
        """Gets the start_time of this HistoricTaskInstanceDto.  # noqa: E501

        The time the task was started. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The start_time of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this HistoricTaskInstanceDto.

        The time the task was started. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param start_time: The start_time of this HistoricTaskInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """Gets the end_time of this HistoricTaskInstanceDto.  # noqa: E501

        The time the task ended. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The end_time of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this HistoricTaskInstanceDto.

        The time the task ended. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param end_time: The end_time of this HistoricTaskInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._end_time = end_time

    @property
    def duration(self):
        """Gets the duration of this HistoricTaskInstanceDto.  # noqa: E501

        The time the task took to finish (in milliseconds).  # noqa: E501

        :return: The duration of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this HistoricTaskInstanceDto.

        The time the task took to finish (in milliseconds).  # noqa: E501

        :param duration: The duration of this HistoricTaskInstanceDto.  # noqa: E501
        :type: int
        """

        self._duration = duration

    @property
    def task_definition_key(self):
        """Gets the task_definition_key of this HistoricTaskInstanceDto.  # noqa: E501

        The task's key.  # noqa: E501

        :return: The task_definition_key of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._task_definition_key

    @task_definition_key.setter
    def task_definition_key(self, task_definition_key):
        """Sets the task_definition_key of this HistoricTaskInstanceDto.

        The task's key.  # noqa: E501

        :param task_definition_key: The task_definition_key of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._task_definition_key = task_definition_key

    @property
    def priority(self):
        """Gets the priority of this HistoricTaskInstanceDto.  # noqa: E501

        The task's priority.  # noqa: E501

        :return: The priority of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this HistoricTaskInstanceDto.

        The task's priority.  # noqa: E501

        :param priority: The priority of this HistoricTaskInstanceDto.  # noqa: E501
        :type: int
        """

        self._priority = priority

    @property
    def due(self):
        """Gets the due of this HistoricTaskInstanceDto.  # noqa: E501

        The task's due date. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The due of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._due

    @due.setter
    def due(self, due):
        """Sets the due of this HistoricTaskInstanceDto.

        The task's due date. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param due: The due of this HistoricTaskInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._due = due

    @property
    def parent_task_id(self):
        """Gets the parent_task_id of this HistoricTaskInstanceDto.  # noqa: E501

        The id of the parent task, if this task is a subtask.  # noqa: E501

        :return: The parent_task_id of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._parent_task_id

    @parent_task_id.setter
    def parent_task_id(self, parent_task_id):
        """Sets the parent_task_id of this HistoricTaskInstanceDto.

        The id of the parent task, if this task is a subtask.  # noqa: E501

        :param parent_task_id: The parent_task_id of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._parent_task_id = parent_task_id

    @property
    def follow_up(self):
        """Gets the follow_up of this HistoricTaskInstanceDto.  # noqa: E501

        The follow-up date for the task. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The follow_up of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._follow_up

    @follow_up.setter
    def follow_up(self, follow_up):
        """Sets the follow_up of this HistoricTaskInstanceDto.

        The follow-up date for the task. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param follow_up: The follow_up of this HistoricTaskInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._follow_up = follow_up

    @property
    def tenant_id(self):
        """Gets the tenant_id of this HistoricTaskInstanceDto.  # noqa: E501

        The tenant id of the task instance.  # noqa: E501

        :return: The tenant_id of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this HistoricTaskInstanceDto.

        The tenant id of the task instance.  # noqa: E501

        :param tenant_id: The tenant_id of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def removal_time(self):
        """Gets the removal_time of this HistoricTaskInstanceDto.  # noqa: E501

        The time after which the task should be removed by the History Cleanup job. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The removal_time of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._removal_time

    @removal_time.setter
    def removal_time(self, removal_time):
        """Sets the removal_time of this HistoricTaskInstanceDto.

        The time after which the task should be removed by the History Cleanup job. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param removal_time: The removal_time of this HistoricTaskInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._removal_time = removal_time

    @property
    def root_process_instance_id(self):
        """Gets the root_process_instance_id of this HistoricTaskInstanceDto.  # noqa: E501

        The process instance id of the root process instance that initiated the process containing this task.  # noqa: E501

        :return: The root_process_instance_id of this HistoricTaskInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._root_process_instance_id

    @root_process_instance_id.setter
    def root_process_instance_id(self, root_process_instance_id):
        """Sets the root_process_instance_id of this HistoricTaskInstanceDto.

        The process instance id of the root process instance that initiated the process containing this task.  # noqa: E501

        :param root_process_instance_id: The root_process_instance_id of this HistoricTaskInstanceDto.  # noqa: E501
        :type: str
        """

        self._root_process_instance_id = root_process_instance_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricTaskInstanceDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricTaskInstanceDto):
            return True

        return self.to_dict() != other.to_dict()
