# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricJobLogQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'log_id': 'str',
        'job_id': 'str',
        'job_exception_message': 'str',
        'job_definition_id': 'str',
        'job_definition_type': 'str',
        'job_definition_configuration': 'str',
        'activity_id_in': 'list[str]',
        'failed_activity_id_in': 'list[str]',
        'execution_id_in': 'list[str]',
        'process_instance_id': 'str',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'deployment_id': 'str',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'hostname': 'str',
        'job_priority_lower_than_or_equals': 'int',
        'job_priority_higher_than_or_equals': 'int',
        'creation_log': 'bool',
        'failure_log': 'bool',
        'success_log': 'bool',
        'deletion_log': 'bool',
        'sorting': 'list[HistoricJobLogQueryDtoSorting]'
    }

    attribute_map = {
        'log_id': 'logId',
        'job_id': 'jobId',
        'job_exception_message': 'jobExceptionMessage',
        'job_definition_id': 'jobDefinitionId',
        'job_definition_type': 'jobDefinitionType',
        'job_definition_configuration': 'jobDefinitionConfiguration',
        'activity_id_in': 'activityIdIn',
        'failed_activity_id_in': 'failedActivityIdIn',
        'execution_id_in': 'executionIdIn',
        'process_instance_id': 'processInstanceId',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'deployment_id': 'deploymentId',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'hostname': 'hostname',
        'job_priority_lower_than_or_equals': 'jobPriorityLowerThanOrEquals',
        'job_priority_higher_than_or_equals': 'jobPriorityHigherThanOrEquals',
        'creation_log': 'creationLog',
        'failure_log': 'failureLog',
        'success_log': 'successLog',
        'deletion_log': 'deletionLog',
        'sorting': 'sorting'
    }

    def __init__(self, log_id=None, job_id=None, job_exception_message=None, job_definition_id=None, job_definition_type=None, job_definition_configuration=None, activity_id_in=None, failed_activity_id_in=None, execution_id_in=None, process_instance_id=None, process_definition_id=None, process_definition_key=None, deployment_id=None, tenant_id_in=None, without_tenant_id=None, hostname=None, job_priority_lower_than_or_equals=None, job_priority_higher_than_or_equals=None, creation_log=None, failure_log=None, success_log=None, deletion_log=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """HistoricJobLogQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._log_id = None
        self._job_id = None
        self._job_exception_message = None
        self._job_definition_id = None
        self._job_definition_type = None
        self._job_definition_configuration = None
        self._activity_id_in = None
        self._failed_activity_id_in = None
        self._execution_id_in = None
        self._process_instance_id = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._deployment_id = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._hostname = None
        self._job_priority_lower_than_or_equals = None
        self._job_priority_higher_than_or_equals = None
        self._creation_log = None
        self._failure_log = None
        self._success_log = None
        self._deletion_log = None
        self._sorting = None
        self.discriminator = None

        self.log_id = log_id
        self.job_id = job_id
        self.job_exception_message = job_exception_message
        self.job_definition_id = job_definition_id
        self.job_definition_type = job_definition_type
        self.job_definition_configuration = job_definition_configuration
        self.activity_id_in = activity_id_in
        self.failed_activity_id_in = failed_activity_id_in
        self.execution_id_in = execution_id_in
        self.process_instance_id = process_instance_id
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.deployment_id = deployment_id
        self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        self.hostname = hostname
        self.job_priority_lower_than_or_equals = job_priority_lower_than_or_equals
        self.job_priority_higher_than_or_equals = job_priority_higher_than_or_equals
        self.creation_log = creation_log
        self.failure_log = failure_log
        self.success_log = success_log
        self.deletion_log = deletion_log
        self.sorting = sorting

    @property
    def log_id(self):
        """Gets the log_id of this HistoricJobLogQueryDto.  # noqa: E501

        Filter by historic job log id.  # noqa: E501

        :return: The log_id of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._log_id

    @log_id.setter
    def log_id(self, log_id):
        """Sets the log_id of this HistoricJobLogQueryDto.

        Filter by historic job log id.  # noqa: E501

        :param log_id: The log_id of this HistoricJobLogQueryDto.  # noqa: E501
        :type: str
        """

        self._log_id = log_id

    @property
    def job_id(self):
        """Gets the job_id of this HistoricJobLogQueryDto.  # noqa: E501

        Filter by job id.  # noqa: E501

        :return: The job_id of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this HistoricJobLogQueryDto.

        Filter by job id.  # noqa: E501

        :param job_id: The job_id of this HistoricJobLogQueryDto.  # noqa: E501
        :type: str
        """

        self._job_id = job_id

    @property
    def job_exception_message(self):
        """Gets the job_exception_message of this HistoricJobLogQueryDto.  # noqa: E501

        Filter by job exception message.  # noqa: E501

        :return: The job_exception_message of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._job_exception_message

    @job_exception_message.setter
    def job_exception_message(self, job_exception_message):
        """Sets the job_exception_message of this HistoricJobLogQueryDto.

        Filter by job exception message.  # noqa: E501

        :param job_exception_message: The job_exception_message of this HistoricJobLogQueryDto.  # noqa: E501
        :type: str
        """

        self._job_exception_message = job_exception_message

    @property
    def job_definition_id(self):
        """Gets the job_definition_id of this HistoricJobLogQueryDto.  # noqa: E501

        Filter by job definition id.  # noqa: E501

        :return: The job_definition_id of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._job_definition_id

    @job_definition_id.setter
    def job_definition_id(self, job_definition_id):
        """Sets the job_definition_id of this HistoricJobLogQueryDto.

        Filter by job definition id.  # noqa: E501

        :param job_definition_id: The job_definition_id of this HistoricJobLogQueryDto.  # noqa: E501
        :type: str
        """

        self._job_definition_id = job_definition_id

    @property
    def job_definition_type(self):
        """Gets the job_definition_type of this HistoricJobLogQueryDto.  # noqa: E501

        Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.  # noqa: E501

        :return: The job_definition_type of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._job_definition_type

    @job_definition_type.setter
    def job_definition_type(self, job_definition_type):
        """Sets the job_definition_type of this HistoricJobLogQueryDto.

        Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.  # noqa: E501

        :param job_definition_type: The job_definition_type of this HistoricJobLogQueryDto.  # noqa: E501
        :type: str
        """

        self._job_definition_type = job_definition_type

    @property
    def job_definition_configuration(self):
        """Gets the job_definition_configuration of this HistoricJobLogQueryDto.  # noqa: E501

        Filter by job definition configuration.  # noqa: E501

        :return: The job_definition_configuration of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._job_definition_configuration

    @job_definition_configuration.setter
    def job_definition_configuration(self, job_definition_configuration):
        """Sets the job_definition_configuration of this HistoricJobLogQueryDto.

        Filter by job definition configuration.  # noqa: E501

        :param job_definition_configuration: The job_definition_configuration of this HistoricJobLogQueryDto.  # noqa: E501
        :type: str
        """

        self._job_definition_configuration = job_definition_configuration

    @property
    def activity_id_in(self):
        """Gets the activity_id_in of this HistoricJobLogQueryDto.  # noqa: E501

        Only include historic job logs which belong to one of the passed activity ids.  # noqa: E501

        :return: The activity_id_in of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._activity_id_in

    @activity_id_in.setter
    def activity_id_in(self, activity_id_in):
        """Sets the activity_id_in of this HistoricJobLogQueryDto.

        Only include historic job logs which belong to one of the passed activity ids.  # noqa: E501

        :param activity_id_in: The activity_id_in of this HistoricJobLogQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._activity_id_in = activity_id_in

    @property
    def failed_activity_id_in(self):
        """Gets the failed_activity_id_in of this HistoricJobLogQueryDto.  # noqa: E501

        Only include historic job logs which belong to failures of one of the passed activity ids.  # noqa: E501

        :return: The failed_activity_id_in of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._failed_activity_id_in

    @failed_activity_id_in.setter
    def failed_activity_id_in(self, failed_activity_id_in):
        """Sets the failed_activity_id_in of this HistoricJobLogQueryDto.

        Only include historic job logs which belong to failures of one of the passed activity ids.  # noqa: E501

        :param failed_activity_id_in: The failed_activity_id_in of this HistoricJobLogQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._failed_activity_id_in = failed_activity_id_in

    @property
    def execution_id_in(self):
        """Gets the execution_id_in of this HistoricJobLogQueryDto.  # noqa: E501

        Only include historic job logs which belong to one of the passed execution ids.  # noqa: E501

        :return: The execution_id_in of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._execution_id_in

    @execution_id_in.setter
    def execution_id_in(self, execution_id_in):
        """Sets the execution_id_in of this HistoricJobLogQueryDto.

        Only include historic job logs which belong to one of the passed execution ids.  # noqa: E501

        :param execution_id_in: The execution_id_in of this HistoricJobLogQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._execution_id_in = execution_id_in

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricJobLogQueryDto.  # noqa: E501

        Filter by process instance id.  # noqa: E501

        :return: The process_instance_id of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricJobLogQueryDto.

        Filter by process instance id.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricJobLogQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricJobLogQueryDto.  # noqa: E501

        Filter by process definition id.  # noqa: E501

        :return: The process_definition_id of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricJobLogQueryDto.

        Filter by process definition id.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricJobLogQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricJobLogQueryDto.  # noqa: E501

        Filter by process definition key.  # noqa: E501

        :return: The process_definition_key of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricJobLogQueryDto.

        Filter by process definition key.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricJobLogQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def deployment_id(self):
        """Gets the deployment_id of this HistoricJobLogQueryDto.  # noqa: E501

        Filter by deployment id.  # noqa: E501

        :return: The deployment_id of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._deployment_id

    @deployment_id.setter
    def deployment_id(self, deployment_id):
        """Sets the deployment_id of this HistoricJobLogQueryDto.

        Filter by deployment id.  # noqa: E501

        :param deployment_id: The deployment_id of this HistoricJobLogQueryDto.  # noqa: E501
        :type: str
        """

        self._deployment_id = deployment_id

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this HistoricJobLogQueryDto.  # noqa: E501

        Only include historic job log entries which belong to one of the passed and comma- separated tenant ids.  # noqa: E501

        :return: The tenant_id_in of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this HistoricJobLogQueryDto.

        Only include historic job log entries which belong to one of the passed and comma- separated tenant ids.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this HistoricJobLogQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this HistoricJobLogQueryDto.  # noqa: E501

        Only include historic job log entries that belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this HistoricJobLogQueryDto.

        Only include historic job log entries that belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this HistoricJobLogQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def hostname(self):
        """Gets the hostname of this HistoricJobLogQueryDto.  # noqa: E501

        Filter by hostname.  # noqa: E501

        :return: The hostname of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this HistoricJobLogQueryDto.

        Filter by hostname.  # noqa: E501

        :param hostname: The hostname of this HistoricJobLogQueryDto.  # noqa: E501
        :type: str
        """

        self._hostname = hostname

    @property
    def job_priority_lower_than_or_equals(self):
        """Gets the job_priority_lower_than_or_equals of this HistoricJobLogQueryDto.  # noqa: E501

        Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :return: The job_priority_lower_than_or_equals of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: int
        """
        return self._job_priority_lower_than_or_equals

    @job_priority_lower_than_or_equals.setter
    def job_priority_lower_than_or_equals(self, job_priority_lower_than_or_equals):
        """Sets the job_priority_lower_than_or_equals of this HistoricJobLogQueryDto.

        Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :param job_priority_lower_than_or_equals: The job_priority_lower_than_or_equals of this HistoricJobLogQueryDto.  # noqa: E501
        :type: int
        """

        self._job_priority_lower_than_or_equals = job_priority_lower_than_or_equals

    @property
    def job_priority_higher_than_or_equals(self):
        """Gets the job_priority_higher_than_or_equals of this HistoricJobLogQueryDto.  # noqa: E501

        Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :return: The job_priority_higher_than_or_equals of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: int
        """
        return self._job_priority_higher_than_or_equals

    @job_priority_higher_than_or_equals.setter
    def job_priority_higher_than_or_equals(self, job_priority_higher_than_or_equals):
        """Sets the job_priority_higher_than_or_equals of this HistoricJobLogQueryDto.

        Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :param job_priority_higher_than_or_equals: The job_priority_higher_than_or_equals of this HistoricJobLogQueryDto.  # noqa: E501
        :type: int
        """

        self._job_priority_higher_than_or_equals = job_priority_higher_than_or_equals

    @property
    def creation_log(self):
        """Gets the creation_log of this HistoricJobLogQueryDto.  # noqa: E501

        Only include creation logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The creation_log of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._creation_log

    @creation_log.setter
    def creation_log(self, creation_log):
        """Sets the creation_log of this HistoricJobLogQueryDto.

        Only include creation logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param creation_log: The creation_log of this HistoricJobLogQueryDto.  # noqa: E501
        :type: bool
        """

        self._creation_log = creation_log

    @property
    def failure_log(self):
        """Gets the failure_log of this HistoricJobLogQueryDto.  # noqa: E501

        Only include failure logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The failure_log of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._failure_log

    @failure_log.setter
    def failure_log(self, failure_log):
        """Sets the failure_log of this HistoricJobLogQueryDto.

        Only include failure logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param failure_log: The failure_log of this HistoricJobLogQueryDto.  # noqa: E501
        :type: bool
        """

        self._failure_log = failure_log

    @property
    def success_log(self):
        """Gets the success_log of this HistoricJobLogQueryDto.  # noqa: E501

        Only include success logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The success_log of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._success_log

    @success_log.setter
    def success_log(self, success_log):
        """Sets the success_log of this HistoricJobLogQueryDto.

        Only include success logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param success_log: The success_log of this HistoricJobLogQueryDto.  # noqa: E501
        :type: bool
        """

        self._success_log = success_log

    @property
    def deletion_log(self):
        """Gets the deletion_log of this HistoricJobLogQueryDto.  # noqa: E501

        Only include deletion logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The deletion_log of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._deletion_log

    @deletion_log.setter
    def deletion_log(self, deletion_log):
        """Sets the deletion_log of this HistoricJobLogQueryDto.

        Only include deletion logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param deletion_log: The deletion_log of this HistoricJobLogQueryDto.  # noqa: E501
        :type: bool
        """

        self._deletion_log = deletion_log

    @property
    def sorting(self):
        """Gets the sorting of this HistoricJobLogQueryDto.  # noqa: E501

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for `count` endpoints  # noqa: E501

        :return: The sorting of this HistoricJobLogQueryDto.  # noqa: E501
        :rtype: list[HistoricJobLogQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this HistoricJobLogQueryDto.

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for `count` endpoints  # noqa: E501

        :param sorting: The sorting of this HistoricJobLogQueryDto.  # noqa: E501
        :type: list[HistoricJobLogQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricJobLogQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricJobLogQueryDto):
            return True

        return self.to_dict() != other.to_dict()
