# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricJobLogDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'timestamp': 'datetime',
        'removal_time': 'datetime',
        'job_id': 'str',
        'job_due_date': 'datetime',
        'job_retries': 'int',
        'job_priority': 'int',
        'job_exception_message': 'str',
        'failed_activity_id': 'str',
        'job_definition_id': 'str',
        'job_definition_type': 'str',
        'job_definition_configuration': 'str',
        'activity_id': 'str',
        'execution_id': 'str',
        'process_instance_id': 'str',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'deployment_id': 'str',
        'root_process_instance_id': 'str',
        'tenant_id': 'str',
        'hostname': 'str',
        'creation_log': 'bool',
        'failure_log': 'bool',
        'success_log': 'bool',
        'deletion_log': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'timestamp': 'timestamp',
        'removal_time': 'removalTime',
        'job_id': 'jobId',
        'job_due_date': 'jobDueDate',
        'job_retries': 'jobRetries',
        'job_priority': 'jobPriority',
        'job_exception_message': 'jobExceptionMessage',
        'failed_activity_id': 'failedActivityId',
        'job_definition_id': 'jobDefinitionId',
        'job_definition_type': 'jobDefinitionType',
        'job_definition_configuration': 'jobDefinitionConfiguration',
        'activity_id': 'activityId',
        'execution_id': 'executionId',
        'process_instance_id': 'processInstanceId',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'deployment_id': 'deploymentId',
        'root_process_instance_id': 'rootProcessInstanceId',
        'tenant_id': 'tenantId',
        'hostname': 'hostname',
        'creation_log': 'creationLog',
        'failure_log': 'failureLog',
        'success_log': 'successLog',
        'deletion_log': 'deletionLog'
    }

    def __init__(self, id=None, timestamp=None, removal_time=None, job_id=None, job_due_date=None, job_retries=None, job_priority=None, job_exception_message=None, failed_activity_id=None, job_definition_id=None, job_definition_type=None, job_definition_configuration=None, activity_id=None, execution_id=None, process_instance_id=None, process_definition_id=None, process_definition_key=None, deployment_id=None, root_process_instance_id=None, tenant_id=None, hostname=None, creation_log=None, failure_log=None, success_log=None, deletion_log=None, local_vars_configuration=None):  # noqa: E501
        """HistoricJobLogDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._timestamp = None
        self._removal_time = None
        self._job_id = None
        self._job_due_date = None
        self._job_retries = None
        self._job_priority = None
        self._job_exception_message = None
        self._failed_activity_id = None
        self._job_definition_id = None
        self._job_definition_type = None
        self._job_definition_configuration = None
        self._activity_id = None
        self._execution_id = None
        self._process_instance_id = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._deployment_id = None
        self._root_process_instance_id = None
        self._tenant_id = None
        self._hostname = None
        self._creation_log = None
        self._failure_log = None
        self._success_log = None
        self._deletion_log = None
        self.discriminator = None

        self.id = id
        self.timestamp = timestamp
        self.removal_time = removal_time
        self.job_id = job_id
        self.job_due_date = job_due_date
        self.job_retries = job_retries
        self.job_priority = job_priority
        self.job_exception_message = job_exception_message
        self.failed_activity_id = failed_activity_id
        self.job_definition_id = job_definition_id
        self.job_definition_type = job_definition_type
        self.job_definition_configuration = job_definition_configuration
        self.activity_id = activity_id
        self.execution_id = execution_id
        self.process_instance_id = process_instance_id
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.deployment_id = deployment_id
        self.root_process_instance_id = root_process_instance_id
        self.tenant_id = tenant_id
        self.hostname = hostname
        self.creation_log = creation_log
        self.failure_log = failure_log
        self.success_log = success_log
        self.deletion_log = deletion_log

    @property
    def id(self):
        """Gets the id of this HistoricJobLogDto.  # noqa: E501

        The id of the log entry.  # noqa: E501

        :return: The id of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HistoricJobLogDto.

        The id of the log entry.  # noqa: E501

        :param id: The id of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def timestamp(self):
        """Gets the timestamp of this HistoricJobLogDto.  # noqa: E501

        The time when the log entry has been written.  # noqa: E501

        :return: The timestamp of this HistoricJobLogDto.  # noqa: E501
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this HistoricJobLogDto.

        The time when the log entry has been written.  # noqa: E501

        :param timestamp: The timestamp of this HistoricJobLogDto.  # noqa: E501
        :type: datetime
        """

        self._timestamp = timestamp

    @property
    def removal_time(self):
        """Gets the removal_time of this HistoricJobLogDto.  # noqa: E501

        The time after which the log entry should be removed by the History Cleanup job. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further info see the [docs](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/)  # noqa: E501

        :return: The removal_time of this HistoricJobLogDto.  # noqa: E501
        :rtype: datetime
        """
        return self._removal_time

    @removal_time.setter
    def removal_time(self, removal_time):
        """Sets the removal_time of this HistoricJobLogDto.

        The time after which the log entry should be removed by the History Cleanup job. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further info see the [docs](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/)  # noqa: E501

        :param removal_time: The removal_time of this HistoricJobLogDto.  # noqa: E501
        :type: datetime
        """

        self._removal_time = removal_time

    @property
    def job_id(self):
        """Gets the job_id of this HistoricJobLogDto.  # noqa: E501

        The id of the associated job.  # noqa: E501

        :return: The job_id of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._job_id

    @job_id.setter
    def job_id(self, job_id):
        """Sets the job_id of this HistoricJobLogDto.

        The id of the associated job.  # noqa: E501

        :param job_id: The job_id of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._job_id = job_id

    @property
    def job_due_date(self):
        """Gets the job_due_date of this HistoricJobLogDto.  # noqa: E501

        The date on which the associated job is supposed to be processed.  # noqa: E501

        :return: The job_due_date of this HistoricJobLogDto.  # noqa: E501
        :rtype: datetime
        """
        return self._job_due_date

    @job_due_date.setter
    def job_due_date(self, job_due_date):
        """Sets the job_due_date of this HistoricJobLogDto.

        The date on which the associated job is supposed to be processed.  # noqa: E501

        :param job_due_date: The job_due_date of this HistoricJobLogDto.  # noqa: E501
        :type: datetime
        """

        self._job_due_date = job_due_date

    @property
    def job_retries(self):
        """Gets the job_retries of this HistoricJobLogDto.  # noqa: E501

        The number of retries the associated job has left.  # noqa: E501

        :return: The job_retries of this HistoricJobLogDto.  # noqa: E501
        :rtype: int
        """
        return self._job_retries

    @job_retries.setter
    def job_retries(self, job_retries):
        """Sets the job_retries of this HistoricJobLogDto.

        The number of retries the associated job has left.  # noqa: E501

        :param job_retries: The job_retries of this HistoricJobLogDto.  # noqa: E501
        :type: int
        """

        self._job_retries = job_retries

    @property
    def job_priority(self):
        """Gets the job_priority of this HistoricJobLogDto.  # noqa: E501

        The execution priority the job had when the log entry was created.  # noqa: E501

        :return: The job_priority of this HistoricJobLogDto.  # noqa: E501
        :rtype: int
        """
        return self._job_priority

    @job_priority.setter
    def job_priority(self, job_priority):
        """Sets the job_priority of this HistoricJobLogDto.

        The execution priority the job had when the log entry was created.  # noqa: E501

        :param job_priority: The job_priority of this HistoricJobLogDto.  # noqa: E501
        :type: int
        """

        self._job_priority = job_priority

    @property
    def job_exception_message(self):
        """Gets the job_exception_message of this HistoricJobLogDto.  # noqa: E501

        The message of the exception that occurred by executing the associated job.  # noqa: E501

        :return: The job_exception_message of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._job_exception_message

    @job_exception_message.setter
    def job_exception_message(self, job_exception_message):
        """Sets the job_exception_message of this HistoricJobLogDto.

        The message of the exception that occurred by executing the associated job.  # noqa: E501

        :param job_exception_message: The job_exception_message of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._job_exception_message = job_exception_message

    @property
    def failed_activity_id(self):
        """Gets the failed_activity_id of this HistoricJobLogDto.  # noqa: E501

        The id of the activity on which the last exception occurred by executing the associated job.  # noqa: E501

        :return: The failed_activity_id of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._failed_activity_id

    @failed_activity_id.setter
    def failed_activity_id(self, failed_activity_id):
        """Sets the failed_activity_id of this HistoricJobLogDto.

        The id of the activity on which the last exception occurred by executing the associated job.  # noqa: E501

        :param failed_activity_id: The failed_activity_id of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._failed_activity_id = failed_activity_id

    @property
    def job_definition_id(self):
        """Gets the job_definition_id of this HistoricJobLogDto.  # noqa: E501

        The id of the job definition on which the associated job was created.  # noqa: E501

        :return: The job_definition_id of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._job_definition_id

    @job_definition_id.setter
    def job_definition_id(self, job_definition_id):
        """Sets the job_definition_id of this HistoricJobLogDto.

        The id of the job definition on which the associated job was created.  # noqa: E501

        :param job_definition_id: The job_definition_id of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._job_definition_id = job_definition_id

    @property
    def job_definition_type(self):
        """Gets the job_definition_type of this HistoricJobLogDto.  # noqa: E501

        The job definition type of the associated job. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.  # noqa: E501

        :return: The job_definition_type of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._job_definition_type

    @job_definition_type.setter
    def job_definition_type(self, job_definition_type):
        """Sets the job_definition_type of this HistoricJobLogDto.

        The job definition type of the associated job. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.  # noqa: E501

        :param job_definition_type: The job_definition_type of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._job_definition_type = job_definition_type

    @property
    def job_definition_configuration(self):
        """Gets the job_definition_configuration of this HistoricJobLogDto.  # noqa: E501

        The job definition configuration type of the associated job.  # noqa: E501

        :return: The job_definition_configuration of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._job_definition_configuration

    @job_definition_configuration.setter
    def job_definition_configuration(self, job_definition_configuration):
        """Sets the job_definition_configuration of this HistoricJobLogDto.

        The job definition configuration type of the associated job.  # noqa: E501

        :param job_definition_configuration: The job_definition_configuration of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._job_definition_configuration = job_definition_configuration

    @property
    def activity_id(self):
        """Gets the activity_id of this HistoricJobLogDto.  # noqa: E501

        The id of the activity on which the associated job was created.  # noqa: E501

        :return: The activity_id of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this HistoricJobLogDto.

        The id of the activity on which the associated job was created.  # noqa: E501

        :param activity_id: The activity_id of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def execution_id(self):
        """Gets the execution_id of this HistoricJobLogDto.  # noqa: E501

        The execution id on which the associated job was created.  # noqa: E501

        :return: The execution_id of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this HistoricJobLogDto.

        The execution id on which the associated job was created.  # noqa: E501

        :param execution_id: The execution_id of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricJobLogDto.  # noqa: E501

        The id of the process instance on which the associated job was created.  # noqa: E501

        :return: The process_instance_id of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricJobLogDto.

        The id of the process instance on which the associated job was created.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricJobLogDto.  # noqa: E501

        The id of the process definition which the associated job belongs to.  # noqa: E501

        :return: The process_definition_id of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricJobLogDto.

        The id of the process definition which the associated job belongs to.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricJobLogDto.  # noqa: E501

        The key of the process definition which the associated job belongs to.  # noqa: E501

        :return: The process_definition_key of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricJobLogDto.

        The key of the process definition which the associated job belongs to.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def deployment_id(self):
        """Gets the deployment_id of this HistoricJobLogDto.  # noqa: E501

        The id of the deployment which the associated job belongs to.  # noqa: E501

        :return: The deployment_id of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._deployment_id

    @deployment_id.setter
    def deployment_id(self, deployment_id):
        """Sets the deployment_id of this HistoricJobLogDto.

        The id of the deployment which the associated job belongs to.  # noqa: E501

        :param deployment_id: The deployment_id of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._deployment_id = deployment_id

    @property
    def root_process_instance_id(self):
        """Gets the root_process_instance_id of this HistoricJobLogDto.  # noqa: E501

        The process instance id of the root process instance that initiated the process which the associated job belongs to.  # noqa: E501

        :return: The root_process_instance_id of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._root_process_instance_id

    @root_process_instance_id.setter
    def root_process_instance_id(self, root_process_instance_id):
        """Sets the root_process_instance_id of this HistoricJobLogDto.

        The process instance id of the root process instance that initiated the process which the associated job belongs to.  # noqa: E501

        :param root_process_instance_id: The root_process_instance_id of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._root_process_instance_id = root_process_instance_id

    @property
    def tenant_id(self):
        """Gets the tenant_id of this HistoricJobLogDto.  # noqa: E501

        The id of the tenant that this historic job log entry belongs to.  # noqa: E501

        :return: The tenant_id of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this HistoricJobLogDto.

        The id of the tenant that this historic job log entry belongs to.  # noqa: E501

        :param tenant_id: The tenant_id of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def hostname(self):
        """Gets the hostname of this HistoricJobLogDto.  # noqa: E501

         The name of the host of the Process Engine where the job of this historic job log entry was executed.  # noqa: E501

        :return: The hostname of this HistoricJobLogDto.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this HistoricJobLogDto.

         The name of the host of the Process Engine where the job of this historic job log entry was executed.  # noqa: E501

        :param hostname: The hostname of this HistoricJobLogDto.  # noqa: E501
        :type: str
        """

        self._hostname = hostname

    @property
    def creation_log(self):
        """Gets the creation_log of this HistoricJobLogDto.  # noqa: E501

        A flag indicating whether this log represents the creation of the associated job.  # noqa: E501

        :return: The creation_log of this HistoricJobLogDto.  # noqa: E501
        :rtype: bool
        """
        return self._creation_log

    @creation_log.setter
    def creation_log(self, creation_log):
        """Sets the creation_log of this HistoricJobLogDto.

        A flag indicating whether this log represents the creation of the associated job.  # noqa: E501

        :param creation_log: The creation_log of this HistoricJobLogDto.  # noqa: E501
        :type: bool
        """

        self._creation_log = creation_log

    @property
    def failure_log(self):
        """Gets the failure_log of this HistoricJobLogDto.  # noqa: E501

        A flag indicating whether this log represents the failed execution of the associated job.  # noqa: E501

        :return: The failure_log of this HistoricJobLogDto.  # noqa: E501
        :rtype: bool
        """
        return self._failure_log

    @failure_log.setter
    def failure_log(self, failure_log):
        """Sets the failure_log of this HistoricJobLogDto.

        A flag indicating whether this log represents the failed execution of the associated job.  # noqa: E501

        :param failure_log: The failure_log of this HistoricJobLogDto.  # noqa: E501
        :type: bool
        """

        self._failure_log = failure_log

    @property
    def success_log(self):
        """Gets the success_log of this HistoricJobLogDto.  # noqa: E501

        A flag indicating whether this log represents the successful execution of the associated job.  # noqa: E501

        :return: The success_log of this HistoricJobLogDto.  # noqa: E501
        :rtype: bool
        """
        return self._success_log

    @success_log.setter
    def success_log(self, success_log):
        """Sets the success_log of this HistoricJobLogDto.

        A flag indicating whether this log represents the successful execution of the associated job.  # noqa: E501

        :param success_log: The success_log of this HistoricJobLogDto.  # noqa: E501
        :type: bool
        """

        self._success_log = success_log

    @property
    def deletion_log(self):
        """Gets the deletion_log of this HistoricJobLogDto.  # noqa: E501

        A flag indicating whether this log represents the deletion of the associated job.  # noqa: E501

        :return: The deletion_log of this HistoricJobLogDto.  # noqa: E501
        :rtype: bool
        """
        return self._deletion_log

    @deletion_log.setter
    def deletion_log(self, deletion_log):
        """Sets the deletion_log of this HistoricJobLogDto.

        A flag indicating whether this log represents the deletion of the associated job.  # noqa: E501

        :param deletion_log: The deletion_log of this HistoricJobLogDto.  # noqa: E501
        :type: bool
        """

        self._deletion_log = deletion_log

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricJobLogDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricJobLogDto):
            return True

        return self.to_dict() != other.to_dict()
