# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricIncidentDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'process_definition_key': 'str',
        'process_definition_id': 'str',
        'process_instance_id': 'str',
        'execution_id': 'str',
        'root_process_instance_id': 'str',
        'create_time': 'datetime',
        'end_time': 'datetime',
        'removal_time': 'datetime',
        'incident_type': 'str',
        'activity_id': 'str',
        'failed_activity_id': 'str',
        'cause_incident_id': 'str',
        'root_cause_incident_id': 'str',
        'configuration': 'str',
        'history_configuration': 'str',
        'incident_message': 'str',
        'tenant_id': 'str',
        'job_definition_id': 'str',
        'open': 'bool',
        'deleted': 'bool',
        'resolved': 'bool',
        'annotation': 'str'
    }

    attribute_map = {
        'id': 'id',
        'process_definition_key': 'processDefinitionKey',
        'process_definition_id': 'processDefinitionId',
        'process_instance_id': 'processInstanceId',
        'execution_id': 'executionId',
        'root_process_instance_id': 'rootProcessInstanceId',
        'create_time': 'createTime',
        'end_time': 'endTime',
        'removal_time': 'removalTime',
        'incident_type': 'incidentType',
        'activity_id': 'activityId',
        'failed_activity_id': 'failedActivityId',
        'cause_incident_id': 'causeIncidentId',
        'root_cause_incident_id': 'rootCauseIncidentId',
        'configuration': 'configuration',
        'history_configuration': 'historyConfiguration',
        'incident_message': 'incidentMessage',
        'tenant_id': 'tenantId',
        'job_definition_id': 'jobDefinitionId',
        'open': 'open',
        'deleted': 'deleted',
        'resolved': 'resolved',
        'annotation': 'annotation'
    }

    def __init__(self, id=None, process_definition_key=None, process_definition_id=None, process_instance_id=None, execution_id=None, root_process_instance_id=None, create_time=None, end_time=None, removal_time=None, incident_type=None, activity_id=None, failed_activity_id=None, cause_incident_id=None, root_cause_incident_id=None, configuration=None, history_configuration=None, incident_message=None, tenant_id=None, job_definition_id=None, open=None, deleted=None, resolved=None, annotation=None, local_vars_configuration=None):  # noqa: E501
        """HistoricIncidentDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._process_definition_key = None
        self._process_definition_id = None
        self._process_instance_id = None
        self._execution_id = None
        self._root_process_instance_id = None
        self._create_time = None
        self._end_time = None
        self._removal_time = None
        self._incident_type = None
        self._activity_id = None
        self._failed_activity_id = None
        self._cause_incident_id = None
        self._root_cause_incident_id = None
        self._configuration = None
        self._history_configuration = None
        self._incident_message = None
        self._tenant_id = None
        self._job_definition_id = None
        self._open = None
        self._deleted = None
        self._resolved = None
        self._annotation = None
        self.discriminator = None

        self.id = id
        self.process_definition_key = process_definition_key
        self.process_definition_id = process_definition_id
        self.process_instance_id = process_instance_id
        self.execution_id = execution_id
        self.root_process_instance_id = root_process_instance_id
        self.create_time = create_time
        self.end_time = end_time
        self.removal_time = removal_time
        self.incident_type = incident_type
        self.activity_id = activity_id
        self.failed_activity_id = failed_activity_id
        self.cause_incident_id = cause_incident_id
        self.root_cause_incident_id = root_cause_incident_id
        self.configuration = configuration
        self.history_configuration = history_configuration
        self.incident_message = incident_message
        self.tenant_id = tenant_id
        self.job_definition_id = job_definition_id
        self.open = open
        self.deleted = deleted
        self.resolved = resolved
        self.annotation = annotation

    @property
    def id(self):
        """Gets the id of this HistoricIncidentDto.  # noqa: E501

        The id of the incident.  # noqa: E501

        :return: The id of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HistoricIncidentDto.

        The id of the incident.  # noqa: E501

        :param id: The id of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricIncidentDto.  # noqa: E501

        The key of the process definition this incident is associated with.  # noqa: E501

        :return: The process_definition_key of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricIncidentDto.

        The key of the process definition this incident is associated with.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricIncidentDto.  # noqa: E501

        The id of the process definition this incident is associated with.  # noqa: E501

        :return: The process_definition_id of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricIncidentDto.

        The id of the process definition this incident is associated with.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricIncidentDto.  # noqa: E501

        The key of the process definition this incident is associated with.  # noqa: E501

        :return: The process_instance_id of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricIncidentDto.

        The key of the process definition this incident is associated with.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def execution_id(self):
        """Gets the execution_id of this HistoricIncidentDto.  # noqa: E501

        The id of the execution this incident is associated with.  # noqa: E501

        :return: The execution_id of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this HistoricIncidentDto.

        The id of the execution this incident is associated with.  # noqa: E501

        :param execution_id: The execution_id of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def root_process_instance_id(self):
        """Gets the root_process_instance_id of this HistoricIncidentDto.  # noqa: E501

        The process instance id of the root process instance that initiated the process containing this incident.  # noqa: E501

        :return: The root_process_instance_id of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._root_process_instance_id

    @root_process_instance_id.setter
    def root_process_instance_id(self, root_process_instance_id):
        """Sets the root_process_instance_id of this HistoricIncidentDto.

        The process instance id of the root process instance that initiated the process containing this incident.  # noqa: E501

        :param root_process_instance_id: The root_process_instance_id of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._root_process_instance_id = root_process_instance_id

    @property
    def create_time(self):
        """Gets the create_time of this HistoricIncidentDto.  # noqa: E501

        The time this incident happened.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The create_time of this HistoricIncidentDto.  # noqa: E501
        :rtype: datetime
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this HistoricIncidentDto.

        The time this incident happened.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param create_time: The create_time of this HistoricIncidentDto.  # noqa: E501
        :type: datetime
        """

        self._create_time = create_time

    @property
    def end_time(self):
        """Gets the end_time of this HistoricIncidentDto.  # noqa: E501

        The time this incident has been deleted or resolved.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The end_time of this HistoricIncidentDto.  # noqa: E501
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this HistoricIncidentDto.

        The time this incident has been deleted or resolved.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param end_time: The end_time of this HistoricIncidentDto.  # noqa: E501
        :type: datetime
        """

        self._end_time = end_time

    @property
    def removal_time(self):
        """Gets the removal_time of this HistoricIncidentDto.  # noqa: E501

        The time after which the incident should be removed by the History Cleanup job. [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The removal_time of this HistoricIncidentDto.  # noqa: E501
        :rtype: datetime
        """
        return self._removal_time

    @removal_time.setter
    def removal_time(self, removal_time):
        """Sets the removal_time of this HistoricIncidentDto.

        The time after which the incident should be removed by the History Cleanup job. [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param removal_time: The removal_time of this HistoricIncidentDto.  # noqa: E501
        :type: datetime
        """

        self._removal_time = removal_time

    @property
    def incident_type(self):
        """Gets the incident_type of this HistoricIncidentDto.  # noqa: E501

        The type of incident, for example: `failedJobs` will be returned in case of an incident which identified a failed job during the execution of a process instance. See the [User Guide](/manual/develop/user- guide/process-engine/incidents/#incident-types) for a list of incident types.  # noqa: E501

        :return: The incident_type of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_type

    @incident_type.setter
    def incident_type(self, incident_type):
        """Sets the incident_type of this HistoricIncidentDto.

        The type of incident, for example: `failedJobs` will be returned in case of an incident which identified a failed job during the execution of a process instance. See the [User Guide](/manual/develop/user- guide/process-engine/incidents/#incident-types) for a list of incident types.  # noqa: E501

        :param incident_type: The incident_type of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._incident_type = incident_type

    @property
    def activity_id(self):
        """Gets the activity_id of this HistoricIncidentDto.  # noqa: E501

        The id of the activity this incident is associated with.  # noqa: E501

        :return: The activity_id of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this HistoricIncidentDto.

        The id of the activity this incident is associated with.  # noqa: E501

        :param activity_id: The activity_id of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def failed_activity_id(self):
        """Gets the failed_activity_id of this HistoricIncidentDto.  # noqa: E501

        The id of the activity on which the last exception occurred.  # noqa: E501

        :return: The failed_activity_id of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._failed_activity_id

    @failed_activity_id.setter
    def failed_activity_id(self, failed_activity_id):
        """Sets the failed_activity_id of this HistoricIncidentDto.

        The id of the activity on which the last exception occurred.  # noqa: E501

        :param failed_activity_id: The failed_activity_id of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._failed_activity_id = failed_activity_id

    @property
    def cause_incident_id(self):
        """Gets the cause_incident_id of this HistoricIncidentDto.  # noqa: E501

        The id of the associated cause incident which has been triggered.  # noqa: E501

        :return: The cause_incident_id of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._cause_incident_id

    @cause_incident_id.setter
    def cause_incident_id(self, cause_incident_id):
        """Sets the cause_incident_id of this HistoricIncidentDto.

        The id of the associated cause incident which has been triggered.  # noqa: E501

        :param cause_incident_id: The cause_incident_id of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._cause_incident_id = cause_incident_id

    @property
    def root_cause_incident_id(self):
        """Gets the root_cause_incident_id of this HistoricIncidentDto.  # noqa: E501

        The id of the associated root cause incident which has been triggered.  # noqa: E501

        :return: The root_cause_incident_id of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._root_cause_incident_id

    @root_cause_incident_id.setter
    def root_cause_incident_id(self, root_cause_incident_id):
        """Sets the root_cause_incident_id of this HistoricIncidentDto.

        The id of the associated root cause incident which has been triggered.  # noqa: E501

        :param root_cause_incident_id: The root_cause_incident_id of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._root_cause_incident_id = root_cause_incident_id

    @property
    def configuration(self):
        """Gets the configuration of this HistoricIncidentDto.  # noqa: E501

        The payload of this incident.  # noqa: E501

        :return: The configuration of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """Sets the configuration of this HistoricIncidentDto.

        The payload of this incident.  # noqa: E501

        :param configuration: The configuration of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._configuration = configuration

    @property
    def history_configuration(self):
        """Gets the history_configuration of this HistoricIncidentDto.  # noqa: E501

        The payload of this incident at the time when it occurred.  # noqa: E501

        :return: The history_configuration of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._history_configuration

    @history_configuration.setter
    def history_configuration(self, history_configuration):
        """Sets the history_configuration of this HistoricIncidentDto.

        The payload of this incident at the time when it occurred.  # noqa: E501

        :param history_configuration: The history_configuration of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._history_configuration = history_configuration

    @property
    def incident_message(self):
        """Gets the incident_message of this HistoricIncidentDto.  # noqa: E501

        The message of this incident.  # noqa: E501

        :return: The incident_message of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._incident_message

    @incident_message.setter
    def incident_message(self, incident_message):
        """Sets the incident_message of this HistoricIncidentDto.

        The message of this incident.  # noqa: E501

        :param incident_message: The incident_message of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._incident_message = incident_message

    @property
    def tenant_id(self):
        """Gets the tenant_id of this HistoricIncidentDto.  # noqa: E501

        The id of the tenant this incident is associated with.  # noqa: E501

        :return: The tenant_id of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this HistoricIncidentDto.

        The id of the tenant this incident is associated with.  # noqa: E501

        :param tenant_id: The tenant_id of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def job_definition_id(self):
        """Gets the job_definition_id of this HistoricIncidentDto.  # noqa: E501

        The job definition id the incident is associated with.  # noqa: E501

        :return: The job_definition_id of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._job_definition_id

    @job_definition_id.setter
    def job_definition_id(self, job_definition_id):
        """Sets the job_definition_id of this HistoricIncidentDto.

        The job definition id the incident is associated with.  # noqa: E501

        :param job_definition_id: The job_definition_id of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._job_definition_id = job_definition_id

    @property
    def open(self):
        """Gets the open of this HistoricIncidentDto.  # noqa: E501

        If true, this incident is open.  # noqa: E501

        :return: The open of this HistoricIncidentDto.  # noqa: E501
        :rtype: bool
        """
        return self._open

    @open.setter
    def open(self, open):
        """Sets the open of this HistoricIncidentDto.

        If true, this incident is open.  # noqa: E501

        :param open: The open of this HistoricIncidentDto.  # noqa: E501
        :type: bool
        """

        self._open = open

    @property
    def deleted(self):
        """Gets the deleted of this HistoricIncidentDto.  # noqa: E501

        If true, this incident has been deleted.  # noqa: E501

        :return: The deleted of this HistoricIncidentDto.  # noqa: E501
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """Sets the deleted of this HistoricIncidentDto.

        If true, this incident has been deleted.  # noqa: E501

        :param deleted: The deleted of this HistoricIncidentDto.  # noqa: E501
        :type: bool
        """

        self._deleted = deleted

    @property
    def resolved(self):
        """Gets the resolved of this HistoricIncidentDto.  # noqa: E501

        If true, this incident has been resolved.  # noqa: E501

        :return: The resolved of this HistoricIncidentDto.  # noqa: E501
        :rtype: bool
        """
        return self._resolved

    @resolved.setter
    def resolved(self, resolved):
        """Sets the resolved of this HistoricIncidentDto.

        If true, this incident has been resolved.  # noqa: E501

        :param resolved: The resolved of this HistoricIncidentDto.  # noqa: E501
        :type: bool
        """

        self._resolved = resolved

    @property
    def annotation(self):
        """Gets the annotation of this HistoricIncidentDto.  # noqa: E501

        The annotation set to the incident.  # noqa: E501

        :return: The annotation of this HistoricIncidentDto.  # noqa: E501
        :rtype: str
        """
        return self._annotation

    @annotation.setter
    def annotation(self, annotation):
        """Sets the annotation of this HistoricIncidentDto.

        The annotation set to the incident.  # noqa: E501

        :param annotation: The annotation of this HistoricIncidentDto.  # noqa: E501
        :type: str
        """

        self._annotation = annotation

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricIncidentDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricIncidentDto):
            return True

        return self.to_dict() != other.to_dict()
