# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricIdentityLinkLogDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'time': 'datetime',
        'type': 'str',
        'user_id': 'str',
        'group_id': 'str',
        'task_id': 'str',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'operation_type': 'str',
        'assigner_id': 'str',
        'tenant_id': 'str',
        'removal_time': 'datetime',
        'root_process_instance_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'time': 'time',
        'type': 'type',
        'user_id': 'userId',
        'group_id': 'groupId',
        'task_id': 'taskId',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'operation_type': 'operationType',
        'assigner_id': 'assignerId',
        'tenant_id': 'tenantId',
        'removal_time': 'removalTime',
        'root_process_instance_id': 'rootProcessInstanceId'
    }

    def __init__(self, id=None, time=None, type=None, user_id=None, group_id=None, task_id=None, process_definition_id=None, process_definition_key=None, operation_type=None, assigner_id=None, tenant_id=None, removal_time=None, root_process_instance_id=None, local_vars_configuration=None):  # noqa: E501
        """HistoricIdentityLinkLogDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._time = None
        self._type = None
        self._user_id = None
        self._group_id = None
        self._task_id = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._operation_type = None
        self._assigner_id = None
        self._tenant_id = None
        self._removal_time = None
        self._root_process_instance_id = None
        self.discriminator = None

        self.id = id
        self.time = time
        self.type = type
        self.user_id = user_id
        self.group_id = group_id
        self.task_id = task_id
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.operation_type = operation_type
        self.assigner_id = assigner_id
        self.tenant_id = tenant_id
        self.removal_time = removal_time
        self.root_process_instance_id = root_process_instance_id

    @property
    def id(self):
        """Gets the id of this HistoricIdentityLinkLogDto.  # noqa: E501

        Id of the Historic identity link entry.  # noqa: E501

        :return: The id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HistoricIdentityLinkLogDto.

        Id of the Historic identity link entry.  # noqa: E501

        :param id: The id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def time(self):
        """Gets the time of this HistoricIdentityLinkLogDto.  # noqa: E501

        The time when the identity link is logged.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The time of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: datetime
        """
        return self._time

    @time.setter
    def time(self, time):
        """Sets the time of this HistoricIdentityLinkLogDto.

        The time when the identity link is logged.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param time: The time of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: datetime
        """

        self._time = time

    @property
    def type(self):
        """Gets the type of this HistoricIdentityLinkLogDto.  # noqa: E501

        The type of identity link (candidate/assignee/owner).  # noqa: E501

        :return: The type of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this HistoricIdentityLinkLogDto.

        The type of identity link (candidate/assignee/owner).  # noqa: E501

        :param type: The type of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def user_id(self):
        """Gets the user_id of this HistoricIdentityLinkLogDto.  # noqa: E501

        The id of the user/assignee.  # noqa: E501

        :return: The user_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this HistoricIdentityLinkLogDto.

        The id of the user/assignee.  # noqa: E501

        :param user_id: The user_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    @property
    def group_id(self):
        """Gets the group_id of this HistoricIdentityLinkLogDto.  # noqa: E501

        The id of the group.  # noqa: E501

        :return: The group_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """Sets the group_id of this HistoricIdentityLinkLogDto.

        The id of the group.  # noqa: E501

        :param group_id: The group_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: str
        """

        self._group_id = group_id

    @property
    def task_id(self):
        """Gets the task_id of this HistoricIdentityLinkLogDto.  # noqa: E501

        The id of the task.  # noqa: E501

        :return: The task_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: str
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Sets the task_id of this HistoricIdentityLinkLogDto.

        The id of the task.  # noqa: E501

        :param task_id: The task_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: str
        """

        self._task_id = task_id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricIdentityLinkLogDto.  # noqa: E501

        The id of the process definition.  # noqa: E501

        :return: The process_definition_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricIdentityLinkLogDto.

        The id of the process definition.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricIdentityLinkLogDto.  # noqa: E501

        The key of the process definition.  # noqa: E501

        :return: The process_definition_key of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricIdentityLinkLogDto.

        The key of the process definition.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def operation_type(self):
        """Gets the operation_type of this HistoricIdentityLinkLogDto.  # noqa: E501

        Type of operation (add/delete).  # noqa: E501

        :return: The operation_type of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: str
        """
        return self._operation_type

    @operation_type.setter
    def operation_type(self, operation_type):
        """Sets the operation_type of this HistoricIdentityLinkLogDto.

        Type of operation (add/delete).  # noqa: E501

        :param operation_type: The operation_type of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: str
        """

        self._operation_type = operation_type

    @property
    def assigner_id(self):
        """Gets the assigner_id of this HistoricIdentityLinkLogDto.  # noqa: E501

        The id of the assigner.  # noqa: E501

        :return: The assigner_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: str
        """
        return self._assigner_id

    @assigner_id.setter
    def assigner_id(self, assigner_id):
        """Sets the assigner_id of this HistoricIdentityLinkLogDto.

        The id of the assigner.  # noqa: E501

        :param assigner_id: The assigner_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: str
        """

        self._assigner_id = assigner_id

    @property
    def tenant_id(self):
        """Gets the tenant_id of this HistoricIdentityLinkLogDto.  # noqa: E501

        The id of the tenant.  # noqa: E501

        :return: The tenant_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this HistoricIdentityLinkLogDto.

        The id of the tenant.  # noqa: E501

        :param tenant_id: The tenant_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def removal_time(self):
        """Gets the removal_time of this HistoricIdentityLinkLogDto.  # noqa: E501

        The time after which the identity link should be removed by the History Cleanup job.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The removal_time of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: datetime
        """
        return self._removal_time

    @removal_time.setter
    def removal_time(self, removal_time):
        """Sets the removal_time of this HistoricIdentityLinkLogDto.

        The time after which the identity link should be removed by the History Cleanup job.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param removal_time: The removal_time of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: datetime
        """

        self._removal_time = removal_time

    @property
    def root_process_instance_id(self):
        """Gets the root_process_instance_id of this HistoricIdentityLinkLogDto.  # noqa: E501

        The process instance id of the root process instance that initiated the process containing this identity link.  # noqa: E501

        :return: The root_process_instance_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :rtype: str
        """
        return self._root_process_instance_id

    @root_process_instance_id.setter
    def root_process_instance_id(self, root_process_instance_id):
        """Sets the root_process_instance_id of this HistoricIdentityLinkLogDto.

        The process instance id of the root process instance that initiated the process containing this identity link.  # noqa: E501

        :param root_process_instance_id: The root_process_instance_id of this HistoricIdentityLinkLogDto.  # noqa: E501
        :type: str
        """

        self._root_process_instance_id = root_process_instance_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricIdentityLinkLogDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricIdentityLinkLogDto):
            return True

        return self.to_dict() != other.to_dict()
