# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricExternalTaskLogQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'log_id': 'str',
        'external_task_id': 'str',
        'topic_name': 'str',
        'worker_id': 'str',
        'error_message': 'str',
        'activity_id_in': 'list[str]',
        'activity_instance_id_in': 'list[str]',
        'execution_id_in': 'list[str]',
        'process_instance_id': 'str',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'priority_lower_than_or_equals': 'int',
        'priority_higher_than_or_equals': 'int',
        'creation_log': 'bool',
        'failure_log': 'bool',
        'success_log': 'bool',
        'deletion_log': 'bool',
        'sorting': 'list[HistoricExternalTaskLogQueryDtoSorting]'
    }

    attribute_map = {
        'log_id': 'logId',
        'external_task_id': 'externalTaskId',
        'topic_name': 'topicName',
        'worker_id': 'workerId',
        'error_message': 'errorMessage',
        'activity_id_in': 'activityIdIn',
        'activity_instance_id_in': 'activityInstanceIdIn',
        'execution_id_in': 'executionIdIn',
        'process_instance_id': 'processInstanceId',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'priority_lower_than_or_equals': 'priorityLowerThanOrEquals',
        'priority_higher_than_or_equals': 'priorityHigherThanOrEquals',
        'creation_log': 'creationLog',
        'failure_log': 'failureLog',
        'success_log': 'successLog',
        'deletion_log': 'deletionLog',
        'sorting': 'sorting'
    }

    def __init__(self, log_id=None, external_task_id=None, topic_name=None, worker_id=None, error_message=None, activity_id_in=None, activity_instance_id_in=None, execution_id_in=None, process_instance_id=None, process_definition_id=None, process_definition_key=None, tenant_id_in=None, without_tenant_id=None, priority_lower_than_or_equals=None, priority_higher_than_or_equals=None, creation_log=None, failure_log=None, success_log=None, deletion_log=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """HistoricExternalTaskLogQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._log_id = None
        self._external_task_id = None
        self._topic_name = None
        self._worker_id = None
        self._error_message = None
        self._activity_id_in = None
        self._activity_instance_id_in = None
        self._execution_id_in = None
        self._process_instance_id = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._priority_lower_than_or_equals = None
        self._priority_higher_than_or_equals = None
        self._creation_log = None
        self._failure_log = None
        self._success_log = None
        self._deletion_log = None
        self._sorting = None
        self.discriminator = None

        self.log_id = log_id
        self.external_task_id = external_task_id
        self.topic_name = topic_name
        self.worker_id = worker_id
        self.error_message = error_message
        self.activity_id_in = activity_id_in
        self.activity_instance_id_in = activity_instance_id_in
        self.execution_id_in = execution_id_in
        self.process_instance_id = process_instance_id
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        self.priority_lower_than_or_equals = priority_lower_than_or_equals
        self.priority_higher_than_or_equals = priority_higher_than_or_equals
        self.creation_log = creation_log
        self.failure_log = failure_log
        self.success_log = success_log
        self.deletion_log = deletion_log
        self.sorting = sorting

    @property
    def log_id(self):
        """Gets the log_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Filter by historic external task log id.  # noqa: E501

        :return: The log_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._log_id

    @log_id.setter
    def log_id(self, log_id):
        """Sets the log_id of this HistoricExternalTaskLogQueryDto.

        Filter by historic external task log id.  # noqa: E501

        :param log_id: The log_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: str
        """

        self._log_id = log_id

    @property
    def external_task_id(self):
        """Gets the external_task_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Filter by external task id.  # noqa: E501

        :return: The external_task_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._external_task_id

    @external_task_id.setter
    def external_task_id(self, external_task_id):
        """Sets the external_task_id of this HistoricExternalTaskLogQueryDto.

        Filter by external task id.  # noqa: E501

        :param external_task_id: The external_task_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: str
        """

        self._external_task_id = external_task_id

    @property
    def topic_name(self):
        """Gets the topic_name of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Filter by an external task topic.  # noqa: E501

        :return: The topic_name of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._topic_name

    @topic_name.setter
    def topic_name(self, topic_name):
        """Sets the topic_name of this HistoricExternalTaskLogQueryDto.

        Filter by an external task topic.  # noqa: E501

        :param topic_name: The topic_name of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: str
        """

        self._topic_name = topic_name

    @property
    def worker_id(self):
        """Gets the worker_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Filter by the id of the worker that the task was most recently locked by.  # noqa: E501

        :return: The worker_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._worker_id

    @worker_id.setter
    def worker_id(self, worker_id):
        """Sets the worker_id of this HistoricExternalTaskLogQueryDto.

        Filter by the id of the worker that the task was most recently locked by.  # noqa: E501

        :param worker_id: The worker_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: str
        """

        self._worker_id = worker_id

    @property
    def error_message(self):
        """Gets the error_message of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Filter by external task exception message.  # noqa: E501

        :return: The error_message of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """Sets the error_message of this HistoricExternalTaskLogQueryDto.

        Filter by external task exception message.  # noqa: E501

        :param error_message: The error_message of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: str
        """

        self._error_message = error_message

    @property
    def activity_id_in(self):
        """Gets the activity_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Only include historic external task logs which belong to one of the passed activity ids.  # noqa: E501

        :return: The activity_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._activity_id_in

    @activity_id_in.setter
    def activity_id_in(self, activity_id_in):
        """Sets the activity_id_in of this HistoricExternalTaskLogQueryDto.

        Only include historic external task logs which belong to one of the passed activity ids.  # noqa: E501

        :param activity_id_in: The activity_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._activity_id_in = activity_id_in

    @property
    def activity_instance_id_in(self):
        """Gets the activity_instance_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Only include historic external task logs which belong to one of the passed activity instance ids.  # noqa: E501

        :return: The activity_instance_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._activity_instance_id_in

    @activity_instance_id_in.setter
    def activity_instance_id_in(self, activity_instance_id_in):
        """Sets the activity_instance_id_in of this HistoricExternalTaskLogQueryDto.

        Only include historic external task logs which belong to one of the passed activity instance ids.  # noqa: E501

        :param activity_instance_id_in: The activity_instance_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._activity_instance_id_in = activity_instance_id_in

    @property
    def execution_id_in(self):
        """Gets the execution_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Only include historic external task logs which belong to one of the passed execution ids.  # noqa: E501

        :return: The execution_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._execution_id_in

    @execution_id_in.setter
    def execution_id_in(self, execution_id_in):
        """Sets the execution_id_in of this HistoricExternalTaskLogQueryDto.

        Only include historic external task logs which belong to one of the passed execution ids.  # noqa: E501

        :param execution_id_in: The execution_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._execution_id_in = execution_id_in

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Filter by process instance id.  # noqa: E501

        :return: The process_instance_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricExternalTaskLogQueryDto.

        Filter by process instance id.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Filter by process definition id.  # noqa: E501

        :return: The process_definition_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricExternalTaskLogQueryDto.

        Filter by process definition id.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Filter by process definition key.  # noqa: E501

        :return: The process_definition_key of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricExternalTaskLogQueryDto.

        Filter by process definition key.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids.  # noqa: E501

        :return: The tenant_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this HistoricExternalTaskLogQueryDto.

        Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Only include historic external task log entries that belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this HistoricExternalTaskLogQueryDto.

        Only include historic external task log entries that belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def priority_lower_than_or_equals(self):
        """Gets the priority_lower_than_or_equals of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :return: The priority_lower_than_or_equals of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: int
        """
        return self._priority_lower_than_or_equals

    @priority_lower_than_or_equals.setter
    def priority_lower_than_or_equals(self, priority_lower_than_or_equals):
        """Sets the priority_lower_than_or_equals of this HistoricExternalTaskLogQueryDto.

        Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :param priority_lower_than_or_equals: The priority_lower_than_or_equals of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: int
        """

        self._priority_lower_than_or_equals = priority_lower_than_or_equals

    @property
    def priority_higher_than_or_equals(self):
        """Gets the priority_higher_than_or_equals of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :return: The priority_higher_than_or_equals of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: int
        """
        return self._priority_higher_than_or_equals

    @priority_higher_than_or_equals.setter
    def priority_higher_than_or_equals(self, priority_higher_than_or_equals):
        """Sets the priority_higher_than_or_equals of this HistoricExternalTaskLogQueryDto.

        Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid `long` value.  # noqa: E501

        :param priority_higher_than_or_equals: The priority_higher_than_or_equals of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: int
        """

        self._priority_higher_than_or_equals = priority_higher_than_or_equals

    @property
    def creation_log(self):
        """Gets the creation_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Only include creation logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The creation_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._creation_log

    @creation_log.setter
    def creation_log(self, creation_log):
        """Sets the creation_log of this HistoricExternalTaskLogQueryDto.

        Only include creation logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param creation_log: The creation_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: bool
        """

        self._creation_log = creation_log

    @property
    def failure_log(self):
        """Gets the failure_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Only include failure logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The failure_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._failure_log

    @failure_log.setter
    def failure_log(self, failure_log):
        """Sets the failure_log of this HistoricExternalTaskLogQueryDto.

        Only include failure logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param failure_log: The failure_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: bool
        """

        self._failure_log = failure_log

    @property
    def success_log(self):
        """Gets the success_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Only include success logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The success_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._success_log

    @success_log.setter
    def success_log(self, success_log):
        """Sets the success_log of this HistoricExternalTaskLogQueryDto.

        Only include success logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param success_log: The success_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: bool
        """

        self._success_log = success_log

    @property
    def deletion_log(self):
        """Gets the deletion_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        Only include deletion logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The deletion_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._deletion_log

    @deletion_log.setter
    def deletion_log(self, deletion_log):
        """Sets the deletion_log of this HistoricExternalTaskLogQueryDto.

        Only include deletion logs. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param deletion_log: The deletion_log of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: bool
        """

        self._deletion_log = deletion_log

    @property
    def sorting(self):
        """Gets the sorting of this HistoricExternalTaskLogQueryDto.  # noqa: E501

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for `count` endpoints.  # noqa: E501

        :return: The sorting of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :rtype: list[HistoricExternalTaskLogQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this HistoricExternalTaskLogQueryDto.

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Sorting has no effect for `count` endpoints.  # noqa: E501

        :param sorting: The sorting of this HistoricExternalTaskLogQueryDto.  # noqa: E501
        :type: list[HistoricExternalTaskLogQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricExternalTaskLogQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricExternalTaskLogQueryDto):
            return True

        return self.to_dict() != other.to_dict()
