# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricDetailQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'process_instance_id': 'str',
        'process_instance_id_in': 'list[str]',
        'execution_id': 'str',
        'task_id': 'str',
        'activity_instance_id': 'str',
        'case_instance_id': 'str',
        'case_execution_id': 'str',
        'variable_instance_id': 'str',
        'variable_type_in': 'list[str]',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'user_operation_id': 'str',
        'form_fields': 'bool',
        'variable_updates': 'bool',
        'exclude_task_details': 'bool',
        'initial': 'bool',
        'occurred_before': 'datetime',
        'occurred_after': 'datetime',
        'sorting': 'list[HistoricDetailQueryDtoSorting]'
    }

    attribute_map = {
        'process_instance_id': 'processInstanceId',
        'process_instance_id_in': 'processInstanceIdIn',
        'execution_id': 'executionId',
        'task_id': 'taskId',
        'activity_instance_id': 'activityInstanceId',
        'case_instance_id': 'caseInstanceId',
        'case_execution_id': 'caseExecutionId',
        'variable_instance_id': 'variableInstanceId',
        'variable_type_in': 'variableTypeIn',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'user_operation_id': 'userOperationId',
        'form_fields': 'formFields',
        'variable_updates': 'variableUpdates',
        'exclude_task_details': 'excludeTaskDetails',
        'initial': 'initial',
        'occurred_before': 'occurredBefore',
        'occurred_after': 'occurredAfter',
        'sorting': 'sorting'
    }

    def __init__(self, process_instance_id=None, process_instance_id_in=None, execution_id=None, task_id=None, activity_instance_id=None, case_instance_id=None, case_execution_id=None, variable_instance_id=None, variable_type_in=None, tenant_id_in=None, without_tenant_id=None, user_operation_id=None, form_fields=None, variable_updates=None, exclude_task_details=None, initial=None, occurred_before=None, occurred_after=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """HistoricDetailQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._process_instance_id = None
        self._process_instance_id_in = None
        self._execution_id = None
        self._task_id = None
        self._activity_instance_id = None
        self._case_instance_id = None
        self._case_execution_id = None
        self._variable_instance_id = None
        self._variable_type_in = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._user_operation_id = None
        self._form_fields = None
        self._variable_updates = None
        self._exclude_task_details = None
        self._initial = None
        self._occurred_before = None
        self._occurred_after = None
        self._sorting = None
        self.discriminator = None

        self.process_instance_id = process_instance_id
        self.process_instance_id_in = process_instance_id_in
        self.execution_id = execution_id
        self.task_id = task_id
        self.activity_instance_id = activity_instance_id
        self.case_instance_id = case_instance_id
        self.case_execution_id = case_execution_id
        self.variable_instance_id = variable_instance_id
        self.variable_type_in = variable_type_in
        self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        self.user_operation_id = user_operation_id
        self.form_fields = form_fields
        self.variable_updates = variable_updates
        self.exclude_task_details = exclude_task_details
        self.initial = initial
        self.occurred_before = occurred_before
        self.occurred_after = occurred_after
        self.sorting = sorting

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricDetailQueryDto.  # noqa: E501

        Filter by process instance id.  # noqa: E501

        :return: The process_instance_id of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricDetailQueryDto.

        Filter by process instance id.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricDetailQueryDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def process_instance_id_in(self):
        """Gets the process_instance_id_in of this HistoricDetailQueryDto.  # noqa: E501

        Only include historic details which belong to one of the passed  process instance ids.  # noqa: E501

        :return: The process_instance_id_in of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._process_instance_id_in

    @process_instance_id_in.setter
    def process_instance_id_in(self, process_instance_id_in):
        """Sets the process_instance_id_in of this HistoricDetailQueryDto.

        Only include historic details which belong to one of the passed  process instance ids.  # noqa: E501

        :param process_instance_id_in: The process_instance_id_in of this HistoricDetailQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._process_instance_id_in = process_instance_id_in

    @property
    def execution_id(self):
        """Gets the execution_id of this HistoricDetailQueryDto.  # noqa: E501

        Filter by execution id.  # noqa: E501

        :return: The execution_id of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this HistoricDetailQueryDto.

        Filter by execution id.  # noqa: E501

        :param execution_id: The execution_id of this HistoricDetailQueryDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def task_id(self):
        """Gets the task_id of this HistoricDetailQueryDto.  # noqa: E501

        Filter by task id.  # noqa: E501

        :return: The task_id of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Sets the task_id of this HistoricDetailQueryDto.

        Filter by task id.  # noqa: E501

        :param task_id: The task_id of this HistoricDetailQueryDto.  # noqa: E501
        :type: str
        """

        self._task_id = task_id

    @property
    def activity_instance_id(self):
        """Gets the activity_instance_id of this HistoricDetailQueryDto.  # noqa: E501

        Filter by activity instance id.  # noqa: E501

        :return: The activity_instance_id of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_instance_id

    @activity_instance_id.setter
    def activity_instance_id(self, activity_instance_id):
        """Sets the activity_instance_id of this HistoricDetailQueryDto.

        Filter by activity instance id.  # noqa: E501

        :param activity_instance_id: The activity_instance_id of this HistoricDetailQueryDto.  # noqa: E501
        :type: str
        """

        self._activity_instance_id = activity_instance_id

    @property
    def case_instance_id(self):
        """Gets the case_instance_id of this HistoricDetailQueryDto.  # noqa: E501

        Filter by case instance id.  # noqa: E501

        :return: The case_instance_id of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_id

    @case_instance_id.setter
    def case_instance_id(self, case_instance_id):
        """Sets the case_instance_id of this HistoricDetailQueryDto.

        Filter by case instance id.  # noqa: E501

        :param case_instance_id: The case_instance_id of this HistoricDetailQueryDto.  # noqa: E501
        :type: str
        """

        self._case_instance_id = case_instance_id

    @property
    def case_execution_id(self):
        """Gets the case_execution_id of this HistoricDetailQueryDto.  # noqa: E501

        Filter by case execution id.  # noqa: E501

        :return: The case_execution_id of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._case_execution_id

    @case_execution_id.setter
    def case_execution_id(self, case_execution_id):
        """Sets the case_execution_id of this HistoricDetailQueryDto.

        Filter by case execution id.  # noqa: E501

        :param case_execution_id: The case_execution_id of this HistoricDetailQueryDto.  # noqa: E501
        :type: str
        """

        self._case_execution_id = case_execution_id

    @property
    def variable_instance_id(self):
        """Gets the variable_instance_id of this HistoricDetailQueryDto.  # noqa: E501

        Filter by variable instance id.  # noqa: E501

        :return: The variable_instance_id of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._variable_instance_id

    @variable_instance_id.setter
    def variable_instance_id(self, variable_instance_id):
        """Sets the variable_instance_id of this HistoricDetailQueryDto.

        Filter by variable instance id.  # noqa: E501

        :param variable_instance_id: The variable_instance_id of this HistoricDetailQueryDto.  # noqa: E501
        :type: str
        """

        self._variable_instance_id = variable_instance_id

    @property
    def variable_type_in(self):
        """Gets the variable_type_in of this HistoricDetailQueryDto.  # noqa: E501

        Only include historic details where the variable updates belong to one of the passed  list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type `serializable`.  # noqa: E501

        :return: The variable_type_in of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._variable_type_in

    @variable_type_in.setter
    def variable_type_in(self, variable_type_in):
        """Sets the variable_type_in of this HistoricDetailQueryDto.

        Only include historic details where the variable updates belong to one of the passed  list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type `serializable`.  # noqa: E501

        :param variable_type_in: The variable_type_in of this HistoricDetailQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._variable_type_in = variable_type_in

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this HistoricDetailQueryDto.  # noqa: E501

        Filter by a  list of tenant ids.  # noqa: E501

        :return: The tenant_id_in of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this HistoricDetailQueryDto.

        Filter by a  list of tenant ids.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this HistoricDetailQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this HistoricDetailQueryDto.  # noqa: E501

        Only include historic details that belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this HistoricDetailQueryDto.

        Only include historic details that belong to no tenant. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this HistoricDetailQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def user_operation_id(self):
        """Gets the user_operation_id of this HistoricDetailQueryDto.  # noqa: E501

        Filter by a user operation id.  # noqa: E501

        :return: The user_operation_id of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._user_operation_id

    @user_operation_id.setter
    def user_operation_id(self, user_operation_id):
        """Sets the user_operation_id of this HistoricDetailQueryDto.

        Filter by a user operation id.  # noqa: E501

        :param user_operation_id: The user_operation_id of this HistoricDetailQueryDto.  # noqa: E501
        :type: str
        """

        self._user_operation_id = user_operation_id

    @property
    def form_fields(self):
        """Gets the form_fields of this HistoricDetailQueryDto.  # noqa: E501

        Only include `HistoricFormFields`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The form_fields of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._form_fields

    @form_fields.setter
    def form_fields(self, form_fields):
        """Sets the form_fields of this HistoricDetailQueryDto.

        Only include `HistoricFormFields`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param form_fields: The form_fields of this HistoricDetailQueryDto.  # noqa: E501
        :type: bool
        """

        self._form_fields = form_fields

    @property
    def variable_updates(self):
        """Gets the variable_updates of this HistoricDetailQueryDto.  # noqa: E501

        Only include `HistoricVariableUpdates`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The variable_updates of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._variable_updates

    @variable_updates.setter
    def variable_updates(self, variable_updates):
        """Sets the variable_updates of this HistoricDetailQueryDto.

        Only include `HistoricVariableUpdates`. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param variable_updates: The variable_updates of this HistoricDetailQueryDto.  # noqa: E501
        :type: bool
        """

        self._variable_updates = variable_updates

    @property
    def exclude_task_details(self):
        """Gets the exclude_task_details of this HistoricDetailQueryDto.  # noqa: E501

        Excludes all task-related `HistoricDetails`, so only items which have no task id set will be selected. When this parameter is used together with `taskId`, this call is ignored and task details are not excluded. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The exclude_task_details of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._exclude_task_details

    @exclude_task_details.setter
    def exclude_task_details(self, exclude_task_details):
        """Sets the exclude_task_details of this HistoricDetailQueryDto.

        Excludes all task-related `HistoricDetails`, so only items which have no task id set will be selected. When this parameter is used together with `taskId`, this call is ignored and task details are not excluded. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param exclude_task_details: The exclude_task_details of this HistoricDetailQueryDto.  # noqa: E501
        :type: bool
        """

        self._exclude_task_details = exclude_task_details

    @property
    def initial(self):
        """Gets the initial of this HistoricDetailQueryDto.  # noqa: E501

        Restrict to historic variable updates that contain only initial variable values. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The initial of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._initial

    @initial.setter
    def initial(self, initial):
        """Sets the initial of this HistoricDetailQueryDto.

        Restrict to historic variable updates that contain only initial variable values. Value may only be `true`, as `false` is the default behavior.  # noqa: E501

        :param initial: The initial of this HistoricDetailQueryDto.  # noqa: E501
        :type: bool
        """

        self._initial = initial

    @property
    def occurred_before(self):
        """Gets the occurred_before of this HistoricDetailQueryDto.  # noqa: E501

        Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.  # noqa: E501

        :return: The occurred_before of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._occurred_before

    @occurred_before.setter
    def occurred_before(self, occurred_before):
        """Sets the occurred_before of this HistoricDetailQueryDto.

        Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.  # noqa: E501

        :param occurred_before: The occurred_before of this HistoricDetailQueryDto.  # noqa: E501
        :type: datetime
        """

        self._occurred_before = occurred_before

    @property
    def occurred_after(self):
        """Gets the occurred_after of this HistoricDetailQueryDto.  # noqa: E501

        Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.  # noqa: E501

        :return: The occurred_after of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: datetime
        """
        return self._occurred_after

    @occurred_after.setter
    def occurred_after(self, occurred_after):
        """Sets the occurred_after of this HistoricDetailQueryDto.

        Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.  # noqa: E501

        :param occurred_after: The occurred_after of this HistoricDetailQueryDto.  # noqa: E501
        :type: datetime
        """

        self._occurred_after = occurred_after

    @property
    def sorting(self):
        """Gets the sorting of this HistoricDetailQueryDto.  # noqa: E501

        A JSON array of criteria to sort the result by. Each element of the array is                     a JSON object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Does not have an effect for the `count` endpoint.  # noqa: E501

        :return: The sorting of this HistoricDetailQueryDto.  # noqa: E501
        :rtype: list[HistoricDetailQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this HistoricDetailQueryDto.

        A JSON array of criteria to sort the result by. Each element of the array is                     a JSON object that specifies one ordering. The position in the array                     identifies the rank of an ordering, i.e., whether it is primary, secondary,                     etc. Does not have an effect for the `count` endpoint.  # noqa: E501

        :param sorting: The sorting of this HistoricDetailQueryDto.  # noqa: E501
        :type: list[HistoricDetailQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricDetailQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricDetailQueryDto):
            return True

        return self.to_dict() != other.to_dict()
