# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricDetailDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'type': 'str',
        'process_definition_key': 'str',
        'process_definition_id': 'str',
        'process_instance_id': 'str',
        'activity_instance_id': 'str',
        'execution_id': 'str',
        'case_definition_key': 'str',
        'case_definition_id': 'str',
        'case_instance_id': 'str',
        'case_execution_id': 'str',
        'task_id': 'str',
        'tenant_id': 'str',
        'user_operation_id': 'str',
        'time': 'datetime',
        'removal_time': 'datetime',
        'root_process_instance_id': 'str',
        'field_id': 'str',
        'field_value': 'object',
        'variable_name': 'str',
        'variable_instance_id': 'str',
        'variable_type': 'str',
        'value': 'object',
        'value_info': 'dict(str, object)',
        'initial': 'bool',
        'revision': 'int',
        'error_message': 'str'
    }

    attribute_map = {
        'id': 'id',
        'type': 'type',
        'process_definition_key': 'processDefinitionKey',
        'process_definition_id': 'processDefinitionId',
        'process_instance_id': 'processInstanceId',
        'activity_instance_id': 'activityInstanceId',
        'execution_id': 'executionId',
        'case_definition_key': 'caseDefinitionKey',
        'case_definition_id': 'caseDefinitionId',
        'case_instance_id': 'caseInstanceId',
        'case_execution_id': 'caseExecutionId',
        'task_id': 'taskId',
        'tenant_id': 'tenantId',
        'user_operation_id': 'userOperationId',
        'time': 'time',
        'removal_time': 'removalTime',
        'root_process_instance_id': 'rootProcessInstanceId',
        'field_id': 'fieldId',
        'field_value': 'fieldValue',
        'variable_name': 'variableName',
        'variable_instance_id': 'variableInstanceId',
        'variable_type': 'variableType',
        'value': 'value',
        'value_info': 'valueInfo',
        'initial': 'initial',
        'revision': 'revision',
        'error_message': 'errorMessage'
    }

    def __init__(self, id=None, type=None, process_definition_key=None, process_definition_id=None, process_instance_id=None, activity_instance_id=None, execution_id=None, case_definition_key=None, case_definition_id=None, case_instance_id=None, case_execution_id=None, task_id=None, tenant_id=None, user_operation_id=None, time=None, removal_time=None, root_process_instance_id=None, field_id=None, field_value=None, variable_name=None, variable_instance_id=None, variable_type=None, value=None, value_info=None, initial=None, revision=None, error_message=None, local_vars_configuration=None):  # noqa: E501
        """HistoricDetailDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._type = None
        self._process_definition_key = None
        self._process_definition_id = None
        self._process_instance_id = None
        self._activity_instance_id = None
        self._execution_id = None
        self._case_definition_key = None
        self._case_definition_id = None
        self._case_instance_id = None
        self._case_execution_id = None
        self._task_id = None
        self._tenant_id = None
        self._user_operation_id = None
        self._time = None
        self._removal_time = None
        self._root_process_instance_id = None
        self._field_id = None
        self._field_value = None
        self._variable_name = None
        self._variable_instance_id = None
        self._variable_type = None
        self._value = None
        self._value_info = None
        self._initial = None
        self._revision = None
        self._error_message = None
        self.discriminator = None

        self.id = id
        self.type = type
        self.process_definition_key = process_definition_key
        self.process_definition_id = process_definition_id
        self.process_instance_id = process_instance_id
        self.activity_instance_id = activity_instance_id
        self.execution_id = execution_id
        self.case_definition_key = case_definition_key
        self.case_definition_id = case_definition_id
        self.case_instance_id = case_instance_id
        self.case_execution_id = case_execution_id
        self.task_id = task_id
        self.tenant_id = tenant_id
        self.user_operation_id = user_operation_id
        self.time = time
        self.removal_time = removal_time
        self.root_process_instance_id = root_process_instance_id
        self.field_id = field_id
        if field_value is not None:
            self.field_value = field_value
        self.variable_name = variable_name
        self.variable_instance_id = variable_instance_id
        self.variable_type = variable_type
        if value is not None:
            self.value = value
        if value_info is not None:
            self.value_info = value_info
        self.initial = initial
        self.revision = revision
        self.error_message = error_message

    @property
    def id(self):
        """Gets the id of this HistoricDetailDto.  # noqa: E501

        The id of the historic detail.  # noqa: E501

        :return: The id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HistoricDetailDto.

        The id of the historic detail.  # noqa: E501

        :param id: The id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this HistoricDetailDto.  # noqa: E501

        The type of the historic detail. Either `formField` for a submitted form field value or `variableUpdate` for variable updates.  # noqa: E501

        :return: The type of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this HistoricDetailDto.

        The type of the historic detail. Either `formField` for a submitted form field value or `variableUpdate` for variable updates.  # noqa: E501

        :param type: The type of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricDetailDto.  # noqa: E501

        The key of the process definition that this historic detail belongs to.  # noqa: E501

        :return: The process_definition_key of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricDetailDto.

        The key of the process definition that this historic detail belongs to.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricDetailDto.  # noqa: E501

        The id of the process definition that this historic detail belongs to.  # noqa: E501

        :return: The process_definition_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricDetailDto.

        The id of the process definition that this historic detail belongs to.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricDetailDto.  # noqa: E501

        The id of the process instance the historic detail belongs to.  # noqa: E501

        :return: The process_instance_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricDetailDto.

        The id of the process instance the historic detail belongs to.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def activity_instance_id(self):
        """Gets the activity_instance_id of this HistoricDetailDto.  # noqa: E501

        The id of the activity instance the historic detail belongs to.  # noqa: E501

        :return: The activity_instance_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_instance_id

    @activity_instance_id.setter
    def activity_instance_id(self, activity_instance_id):
        """Sets the activity_instance_id of this HistoricDetailDto.

        The id of the activity instance the historic detail belongs to.  # noqa: E501

        :param activity_instance_id: The activity_instance_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._activity_instance_id = activity_instance_id

    @property
    def execution_id(self):
        """Gets the execution_id of this HistoricDetailDto.  # noqa: E501

        The id of the execution the historic detail belongs to.  # noqa: E501

        :return: The execution_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this HistoricDetailDto.

        The id of the execution the historic detail belongs to.  # noqa: E501

        :param execution_id: The execution_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def case_definition_key(self):
        """Gets the case_definition_key of this HistoricDetailDto.  # noqa: E501

        The key of the case definition that this historic detail belongs to.  # noqa: E501

        :return: The case_definition_key of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_key

    @case_definition_key.setter
    def case_definition_key(self, case_definition_key):
        """Sets the case_definition_key of this HistoricDetailDto.

        The key of the case definition that this historic detail belongs to.  # noqa: E501

        :param case_definition_key: The case_definition_key of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._case_definition_key = case_definition_key

    @property
    def case_definition_id(self):
        """Gets the case_definition_id of this HistoricDetailDto.  # noqa: E501

        The id of the case definition that this historic detail belongs to.  # noqa: E501

        :return: The case_definition_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_id

    @case_definition_id.setter
    def case_definition_id(self, case_definition_id):
        """Sets the case_definition_id of this HistoricDetailDto.

        The id of the case definition that this historic detail belongs to.  # noqa: E501

        :param case_definition_id: The case_definition_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._case_definition_id = case_definition_id

    @property
    def case_instance_id(self):
        """Gets the case_instance_id of this HistoricDetailDto.  # noqa: E501

        The id of the case instance the historic detail belongs to.  # noqa: E501

        :return: The case_instance_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_id

    @case_instance_id.setter
    def case_instance_id(self, case_instance_id):
        """Sets the case_instance_id of this HistoricDetailDto.

        The id of the case instance the historic detail belongs to.  # noqa: E501

        :param case_instance_id: The case_instance_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._case_instance_id = case_instance_id

    @property
    def case_execution_id(self):
        """Gets the case_execution_id of this HistoricDetailDto.  # noqa: E501

        The id of the case execution the historic detail belongs to.  # noqa: E501

        :return: The case_execution_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._case_execution_id

    @case_execution_id.setter
    def case_execution_id(self, case_execution_id):
        """Sets the case_execution_id of this HistoricDetailDto.

        The id of the case execution the historic detail belongs to.  # noqa: E501

        :param case_execution_id: The case_execution_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._case_execution_id = case_execution_id

    @property
    def task_id(self):
        """Gets the task_id of this HistoricDetailDto.  # noqa: E501

        The id of the task the historic detail belongs to.  # noqa: E501

        :return: The task_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Sets the task_id of this HistoricDetailDto.

        The id of the task the historic detail belongs to.  # noqa: E501

        :param task_id: The task_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._task_id = task_id

    @property
    def tenant_id(self):
        """Gets the tenant_id of this HistoricDetailDto.  # noqa: E501

        The id of the tenant that this historic detail belongs to.  # noqa: E501

        :return: The tenant_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this HistoricDetailDto.

        The id of the tenant that this historic detail belongs to.  # noqa: E501

        :param tenant_id: The tenant_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def user_operation_id(self):
        """Gets the user_operation_id of this HistoricDetailDto.  # noqa: E501

        The id of user operation which links historic detail with [user operation log](https://docs.camunda.org/manual/7.16/reference/rest/history/user-operation-log/) entries.  # noqa: E501

        :return: The user_operation_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._user_operation_id

    @user_operation_id.setter
    def user_operation_id(self, user_operation_id):
        """Sets the user_operation_id of this HistoricDetailDto.

        The id of user operation which links historic detail with [user operation log](https://docs.camunda.org/manual/7.16/reference/rest/history/user-operation-log/) entries.  # noqa: E501

        :param user_operation_id: The user_operation_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._user_operation_id = user_operation_id

    @property
    def time(self):
        """Gets the time of this HistoricDetailDto.  # noqa: E501

        The time when this historic detail occurred. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The time of this HistoricDetailDto.  # noqa: E501
        :rtype: datetime
        """
        return self._time

    @time.setter
    def time(self, time):
        """Sets the time of this HistoricDetailDto.

        The time when this historic detail occurred. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param time: The time of this HistoricDetailDto.  # noqa: E501
        :type: datetime
        """

        self._time = time

    @property
    def removal_time(self):
        """Gets the removal_time of this HistoricDetailDto.  # noqa: E501

        The time after which the historic detail should be removed by the History Cleanup job. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The removal_time of this HistoricDetailDto.  # noqa: E501
        :rtype: datetime
        """
        return self._removal_time

    @removal_time.setter
    def removal_time(self, removal_time):
        """Sets the removal_time of this HistoricDetailDto.

        The time after which the historic detail should be removed by the History Cleanup job. Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param removal_time: The removal_time of this HistoricDetailDto.  # noqa: E501
        :type: datetime
        """

        self._removal_time = removal_time

    @property
    def root_process_instance_id(self):
        """Gets the root_process_instance_id of this HistoricDetailDto.  # noqa: E501

        The process instance id of the root process instance that initiated the process containing this historic detail.  # noqa: E501

        :return: The root_process_instance_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._root_process_instance_id

    @root_process_instance_id.setter
    def root_process_instance_id(self, root_process_instance_id):
        """Sets the root_process_instance_id of this HistoricDetailDto.

        The process instance id of the root process instance that initiated the process containing this historic detail.  # noqa: E501

        :param root_process_instance_id: The root_process_instance_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._root_process_instance_id = root_process_instance_id

    @property
    def field_id(self):
        """Gets the field_id of this HistoricDetailDto.  # noqa: E501

        The id of the form field.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `formField`.  # noqa: E501

        :return: The field_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._field_id

    @field_id.setter
    def field_id(self, field_id):
        """Sets the field_id of this HistoricDetailDto.

        The id of the form field.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `formField`.  # noqa: E501

        :param field_id: The field_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._field_id = field_id

    @property
    def field_value(self):
        """Gets the field_value of this HistoricDetailDto.  # noqa: E501

        The submitted form field value. The value differs depending on the form field's type and on the `deserializeValue` parameter.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `formField`.  # noqa: E501

        :return: The field_value of this HistoricDetailDto.  # noqa: E501
        :rtype: object
        """
        return self._field_value

    @field_value.setter
    def field_value(self, field_value):
        """Sets the field_value of this HistoricDetailDto.

        The submitted form field value. The value differs depending on the form field's type and on the `deserializeValue` parameter.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `formField`.  # noqa: E501

        :param field_value: The field_value of this HistoricDetailDto.  # noqa: E501
        :type: object
        """

        self._field_value = field_value

    @property
    def variable_name(self):
        """Gets the variable_name of this HistoricDetailDto.  # noqa: E501

        The name of the variable which has been updated.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :return: The variable_name of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._variable_name

    @variable_name.setter
    def variable_name(self, variable_name):
        """Sets the variable_name of this HistoricDetailDto.

        The name of the variable which has been updated.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :param variable_name: The variable_name of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._variable_name = variable_name

    @property
    def variable_instance_id(self):
        """Gets the variable_instance_id of this HistoricDetailDto.  # noqa: E501

        The id of the associated variable instance.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :return: The variable_instance_id of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._variable_instance_id

    @variable_instance_id.setter
    def variable_instance_id(self, variable_instance_id):
        """Sets the variable_instance_id of this HistoricDetailDto.

        The id of the associated variable instance.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :param variable_instance_id: The variable_instance_id of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._variable_instance_id = variable_instance_id

    @property
    def variable_type(self):
        """Gets the variable_type of this HistoricDetailDto.  # noqa: E501

        The value type of the variable.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :return: The variable_type of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._variable_type

    @variable_type.setter
    def variable_type(self, variable_type):
        """Sets the variable_type of this HistoricDetailDto.

        The value type of the variable.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :param variable_type: The variable_type of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._variable_type = variable_type

    @property
    def value(self):
        """Gets the value of this HistoricDetailDto.  # noqa: E501

        The variable's value. Value differs depending on the variable's type and on the deserializeValues parameter.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :return: The value of this HistoricDetailDto.  # noqa: E501
        :rtype: object
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this HistoricDetailDto.

        The variable's value. Value differs depending on the variable's type and on the deserializeValues parameter.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :param value: The value of this HistoricDetailDto.  # noqa: E501
        :type: object
        """

        self._value = value

    @property
    def value_info(self):
        """Gets the value_info of this HistoricDetailDto.  # noqa: E501

        A JSON object containing additional, value-type-dependent properties. For variables of type `Object`, the following properties are returned:  * `objectTypeName`: A string representation of the object's type name. * `serializationDataFormat`: The serialization format used to store the variable.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :return: The value_info of this HistoricDetailDto.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._value_info

    @value_info.setter
    def value_info(self, value_info):
        """Sets the value_info of this HistoricDetailDto.

        A JSON object containing additional, value-type-dependent properties. For variables of type `Object`, the following properties are returned:  * `objectTypeName`: A string representation of the object's type name. * `serializationDataFormat`: The serialization format used to store the variable.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :param value_info: The value_info of this HistoricDetailDto.  # noqa: E501
        :type: dict(str, object)
        """

        self._value_info = value_info

    @property
    def initial(self):
        """Gets the initial of this HistoricDetailDto.  # noqa: E501

        Returns `true` for variable updates that contains the initial values of the variables.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :return: The initial of this HistoricDetailDto.  # noqa: E501
        :rtype: bool
        """
        return self._initial

    @initial.setter
    def initial(self, initial):
        """Sets the initial of this HistoricDetailDto.

        Returns `true` for variable updates that contains the initial values of the variables.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :param initial: The initial of this HistoricDetailDto.  # noqa: E501
        :type: bool
        """

        self._initial = initial

    @property
    def revision(self):
        """Gets the revision of this HistoricDetailDto.  # noqa: E501

        The revision of the historic variable update.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :return: The revision of this HistoricDetailDto.  # noqa: E501
        :rtype: int
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this HistoricDetailDto.

        The revision of the historic variable update.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :param revision: The revision of this HistoricDetailDto.  # noqa: E501
        :type: int
        """

        self._revision = revision

    @property
    def error_message(self):
        """Gets the error_message of this HistoricDetailDto.  # noqa: E501

        An error message in case a Java Serialized Object could not be de-serialized.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :return: The error_message of this HistoricDetailDto.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """Sets the error_message of this HistoricDetailDto.

        An error message in case a Java Serialized Object could not be de-serialized.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.  # noqa: E501

        :param error_message: The error_message of this HistoricDetailDto.  # noqa: E501
        :type: str
        """

        self._error_message = error_message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricDetailDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricDetailDto):
            return True

        return self.to_dict() != other.to_dict()
