# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricDecisionOutputInstanceDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'decision_instance_id': 'str',
        'clause_id': 'str',
        'clause_name': 'str',
        'rule_id': 'str',
        'rule_order': 'int',
        'error_message': 'str',
        'variable_name': 'str',
        'type': 'str',
        'create_time': 'datetime',
        'removal_time': 'datetime',
        'root_process_instance_id': 'str',
        'value': 'object',
        'value_info': 'dict(str, object)'
    }

    attribute_map = {
        'id': 'id',
        'decision_instance_id': 'decisionInstanceId',
        'clause_id': 'clauseId',
        'clause_name': 'clauseName',
        'rule_id': 'ruleId',
        'rule_order': 'ruleOrder',
        'error_message': 'errorMessage',
        'variable_name': 'variableName',
        'type': 'type',
        'create_time': 'createTime',
        'removal_time': 'removalTime',
        'root_process_instance_id': 'rootProcessInstanceId',
        'value': 'value',
        'value_info': 'valueInfo'
    }

    def __init__(self, id=None, decision_instance_id=None, clause_id=None, clause_name=None, rule_id=None, rule_order=None, error_message=None, variable_name=None, type=None, create_time=None, removal_time=None, root_process_instance_id=None, value=None, value_info=None, local_vars_configuration=None):  # noqa: E501
        """HistoricDecisionOutputInstanceDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._decision_instance_id = None
        self._clause_id = None
        self._clause_name = None
        self._rule_id = None
        self._rule_order = None
        self._error_message = None
        self._variable_name = None
        self._type = None
        self._create_time = None
        self._removal_time = None
        self._root_process_instance_id = None
        self._value = None
        self._value_info = None
        self.discriminator = None

        self.id = id
        self.decision_instance_id = decision_instance_id
        self.clause_id = clause_id
        self.clause_name = clause_name
        self.rule_id = rule_id
        self.rule_order = rule_order
        self.error_message = error_message
        self.variable_name = variable_name
        self.type = type
        self.create_time = create_time
        self.removal_time = removal_time
        self.root_process_instance_id = root_process_instance_id
        if value is not None:
            self.value = value
        if value_info is not None:
            self.value_info = value_info

    @property
    def id(self):
        """Gets the id of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The id of the decision output value.  # noqa: E501

        :return: The id of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HistoricDecisionOutputInstanceDto.

        The id of the decision output value.  # noqa: E501

        :param id: The id of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def decision_instance_id(self):
        """Gets the decision_instance_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The id of the decision instance the output value belongs to.  # noqa: E501

        :return: The decision_instance_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._decision_instance_id

    @decision_instance_id.setter
    def decision_instance_id(self, decision_instance_id):
        """Sets the decision_instance_id of this HistoricDecisionOutputInstanceDto.

        The id of the decision instance the output value belongs to.  # noqa: E501

        :param decision_instance_id: The decision_instance_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: str
        """

        self._decision_instance_id = decision_instance_id

    @property
    def clause_id(self):
        """Gets the clause_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The id of the clause the output value belongs to.  # noqa: E501

        :return: The clause_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._clause_id

    @clause_id.setter
    def clause_id(self, clause_id):
        """Sets the clause_id of this HistoricDecisionOutputInstanceDto.

        The id of the clause the output value belongs to.  # noqa: E501

        :param clause_id: The clause_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: str
        """

        self._clause_id = clause_id

    @property
    def clause_name(self):
        """Gets the clause_name of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The name of the clause the output value belongs to.  # noqa: E501

        :return: The clause_name of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._clause_name

    @clause_name.setter
    def clause_name(self, clause_name):
        """Sets the clause_name of this HistoricDecisionOutputInstanceDto.

        The name of the clause the output value belongs to.  # noqa: E501

        :param clause_name: The clause_name of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: str
        """

        self._clause_name = clause_name

    @property
    def rule_id(self):
        """Gets the rule_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The id of the rule the output value belongs to.  # noqa: E501

        :return: The rule_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._rule_id

    @rule_id.setter
    def rule_id(self, rule_id):
        """Sets the rule_id of this HistoricDecisionOutputInstanceDto.

        The id of the rule the output value belongs to.  # noqa: E501

        :param rule_id: The rule_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: str
        """

        self._rule_id = rule_id

    @property
    def rule_order(self):
        """Gets the rule_order of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The order of the rule the output value belongs to.  # noqa: E501

        :return: The rule_order of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: int
        """
        return self._rule_order

    @rule_order.setter
    def rule_order(self, rule_order):
        """Sets the rule_order of this HistoricDecisionOutputInstanceDto.

        The order of the rule the output value belongs to.  # noqa: E501

        :param rule_order: The rule_order of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: int
        """

        self._rule_order = rule_order

    @property
    def error_message(self):
        """Gets the error_message of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        An error message in case a Java Serialized Object could not be de-serialized.  # noqa: E501

        :return: The error_message of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """Sets the error_message of this HistoricDecisionOutputInstanceDto.

        An error message in case a Java Serialized Object could not be de-serialized.  # noqa: E501

        :param error_message: The error_message of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: str
        """

        self._error_message = error_message

    @property
    def variable_name(self):
        """Gets the variable_name of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The name of the output variable.  # noqa: E501

        :return: The variable_name of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._variable_name

    @variable_name.setter
    def variable_name(self, variable_name):
        """Sets the variable_name of this HistoricDecisionOutputInstanceDto.

        The name of the output variable.  # noqa: E501

        :param variable_name: The variable_name of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: str
        """

        self._variable_name = variable_name

    @property
    def type(self):
        """Gets the type of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The value type of the variable.  # noqa: E501

        :return: The type of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this HistoricDecisionOutputInstanceDto.

        The value type of the variable.  # noqa: E501

        :param type: The type of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def create_time(self):
        """Gets the create_time of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The time the variable was inserted.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The create_time of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this HistoricDecisionOutputInstanceDto.

        The time the variable was inserted.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param create_time: The create_time of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._create_time = create_time

    @property
    def removal_time(self):
        """Gets the removal_time of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The time after which the entry should be removed by the History Cleanup job. [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The removal_time of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._removal_time

    @removal_time.setter
    def removal_time(self, removal_time):
        """Sets the removal_time of this HistoricDecisionOutputInstanceDto.

        The time after which the entry should be removed by the History Cleanup job. [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param removal_time: The removal_time of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._removal_time = removal_time

    @property
    def root_process_instance_id(self):
        """Gets the root_process_instance_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The process instance id of the root process instance that initiated the process containing this entry.  # noqa: E501

        :return: The root_process_instance_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._root_process_instance_id

    @root_process_instance_id.setter
    def root_process_instance_id(self, root_process_instance_id):
        """Sets the root_process_instance_id of this HistoricDecisionOutputInstanceDto.

        The process instance id of the root process instance that initiated the process containing this entry.  # noqa: E501

        :param root_process_instance_id: The root_process_instance_id of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: str
        """

        self._root_process_instance_id = root_process_instance_id

    @property
    def value(self):
        """Gets the value of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        The variable's value. Value differs depending on the variable's type and on the `disableCustomObjectDeserialization` parameter.  # noqa: E501

        :return: The value of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: object
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this HistoricDecisionOutputInstanceDto.

        The variable's value. Value differs depending on the variable's type and on the `disableCustomObjectDeserialization` parameter.  # noqa: E501

        :param value: The value of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: object
        """

        self._value = value

    @property
    def value_info(self):
        """Gets the value_info of this HistoricDecisionOutputInstanceDto.  # noqa: E501

        A JSON object containing additional, value-type-dependent properties.  For variables of type `Object`, the following properties are returned:  * `objectTypeName`: A string representation of the object's type name.  * `serializationDataFormat`: The serialization format used to store the variable.  # noqa: E501

        :return: The value_info of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._value_info

    @value_info.setter
    def value_info(self, value_info):
        """Sets the value_info of this HistoricDecisionOutputInstanceDto.

        A JSON object containing additional, value-type-dependent properties.  For variables of type `Object`, the following properties are returned:  * `objectTypeName`: A string representation of the object's type name.  * `serializationDataFormat`: The serialization format used to store the variable.  # noqa: E501

        :param value_info: The value_info of this HistoricDecisionOutputInstanceDto.  # noqa: E501
        :type: dict(str, object)
        """

        self._value_info = value_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricDecisionOutputInstanceDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricDecisionOutputInstanceDto):
            return True

        return self.to_dict() != other.to_dict()
