# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricDecisionInstanceDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'decision_definition_id': 'str',
        'decision_definition_key': 'str',
        'decision_definition_name': 'str',
        'evaluation_time': 'datetime',
        'removal_time': 'datetime',
        'process_definition_id': 'str',
        'process_definition_key': 'str',
        'process_instance_id': 'str',
        'case_definition_id': 'str',
        'case_definition_key': 'str',
        'case_instance_id': 'str',
        'activity_id': 'str',
        'activity_instance_id': 'str',
        'tenant_id': 'str',
        'user_id': 'str',
        'inputs': 'list[HistoricDecisionInputInstanceDto]',
        'ouputs': 'list[HistoricDecisionOutputInstanceDto]',
        'collect_result_value': 'float',
        'root_decision_instance_id': 'str',
        'root_process_instance_id': 'str',
        'decision_requirements_definition_id': 'str',
        'decision_requirements_definition_key': 'str'
    }

    attribute_map = {
        'id': 'id',
        'decision_definition_id': 'decisionDefinitionId',
        'decision_definition_key': 'decisionDefinitionKey',
        'decision_definition_name': 'decisionDefinitionName',
        'evaluation_time': 'evaluationTime',
        'removal_time': 'removalTime',
        'process_definition_id': 'processDefinitionId',
        'process_definition_key': 'processDefinitionKey',
        'process_instance_id': 'processInstanceId',
        'case_definition_id': 'caseDefinitionId',
        'case_definition_key': 'caseDefinitionKey',
        'case_instance_id': 'caseInstanceId',
        'activity_id': 'activityId',
        'activity_instance_id': 'activityInstanceId',
        'tenant_id': 'tenantId',
        'user_id': 'userId',
        'inputs': 'inputs',
        'ouputs': 'ouputs',
        'collect_result_value': 'collectResultValue',
        'root_decision_instance_id': 'rootDecisionInstanceId',
        'root_process_instance_id': 'rootProcessInstanceId',
        'decision_requirements_definition_id': 'decisionRequirementsDefinitionId',
        'decision_requirements_definition_key': 'decisionRequirementsDefinitionKey'
    }

    def __init__(self, id=None, decision_definition_id=None, decision_definition_key=None, decision_definition_name=None, evaluation_time=None, removal_time=None, process_definition_id=None, process_definition_key=None, process_instance_id=None, case_definition_id=None, case_definition_key=None, case_instance_id=None, activity_id=None, activity_instance_id=None, tenant_id=None, user_id=None, inputs=None, ouputs=None, collect_result_value=None, root_decision_instance_id=None, root_process_instance_id=None, decision_requirements_definition_id=None, decision_requirements_definition_key=None, local_vars_configuration=None):  # noqa: E501
        """HistoricDecisionInstanceDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._decision_definition_id = None
        self._decision_definition_key = None
        self._decision_definition_name = None
        self._evaluation_time = None
        self._removal_time = None
        self._process_definition_id = None
        self._process_definition_key = None
        self._process_instance_id = None
        self._case_definition_id = None
        self._case_definition_key = None
        self._case_instance_id = None
        self._activity_id = None
        self._activity_instance_id = None
        self._tenant_id = None
        self._user_id = None
        self._inputs = None
        self._ouputs = None
        self._collect_result_value = None
        self._root_decision_instance_id = None
        self._root_process_instance_id = None
        self._decision_requirements_definition_id = None
        self._decision_requirements_definition_key = None
        self.discriminator = None

        self.id = id
        self.decision_definition_id = decision_definition_id
        self.decision_definition_key = decision_definition_key
        self.decision_definition_name = decision_definition_name
        self.evaluation_time = evaluation_time
        self.removal_time = removal_time
        self.process_definition_id = process_definition_id
        self.process_definition_key = process_definition_key
        self.process_instance_id = process_instance_id
        self.case_definition_id = case_definition_id
        self.case_definition_key = case_definition_key
        self.case_instance_id = case_instance_id
        self.activity_id = activity_id
        self.activity_instance_id = activity_instance_id
        self.tenant_id = tenant_id
        self.user_id = user_id
        self.inputs = inputs
        self.ouputs = ouputs
        self.collect_result_value = collect_result_value
        self.root_decision_instance_id = root_decision_instance_id
        self.root_process_instance_id = root_process_instance_id
        self.decision_requirements_definition_id = decision_requirements_definition_id
        self.decision_requirements_definition_key = decision_requirements_definition_key

    @property
    def id(self):
        """Gets the id of this HistoricDecisionInstanceDto.  # noqa: E501

        The id of the decision instance.  # noqa: E501

        :return: The id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HistoricDecisionInstanceDto.

        The id of the decision instance.  # noqa: E501

        :param id: The id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def decision_definition_id(self):
        """Gets the decision_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The id of the decision definition that this decision instance belongs to.  # noqa: E501

        :return: The decision_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._decision_definition_id

    @decision_definition_id.setter
    def decision_definition_id(self, decision_definition_id):
        """Sets the decision_definition_id of this HistoricDecisionInstanceDto.

        The id of the decision definition that this decision instance belongs to.  # noqa: E501

        :param decision_definition_id: The decision_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._decision_definition_id = decision_definition_id

    @property
    def decision_definition_key(self):
        """Gets the decision_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501

        The key of the decision definition that this decision instance belongs to.  # noqa: E501

        :return: The decision_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._decision_definition_key

    @decision_definition_key.setter
    def decision_definition_key(self, decision_definition_key):
        """Sets the decision_definition_key of this HistoricDecisionInstanceDto.

        The key of the decision definition that this decision instance belongs to.  # noqa: E501

        :param decision_definition_key: The decision_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._decision_definition_key = decision_definition_key

    @property
    def decision_definition_name(self):
        """Gets the decision_definition_name of this HistoricDecisionInstanceDto.  # noqa: E501

        The name of the decision definition that this decision instance belongs to.  # noqa: E501

        :return: The decision_definition_name of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._decision_definition_name

    @decision_definition_name.setter
    def decision_definition_name(self, decision_definition_name):
        """Sets the decision_definition_name of this HistoricDecisionInstanceDto.

        The name of the decision definition that this decision instance belongs to.  # noqa: E501

        :param decision_definition_name: The decision_definition_name of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._decision_definition_name = decision_definition_name

    @property
    def evaluation_time(self):
        """Gets the evaluation_time of this HistoricDecisionInstanceDto.  # noqa: E501

        The time the instance was evaluated.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The evaluation_time of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._evaluation_time

    @evaluation_time.setter
    def evaluation_time(self, evaluation_time):
        """Sets the evaluation_time of this HistoricDecisionInstanceDto.

        The time the instance was evaluated.  [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param evaluation_time: The evaluation_time of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._evaluation_time = evaluation_time

    @property
    def removal_time(self):
        """Gets the removal_time of this HistoricDecisionInstanceDto.  # noqa: E501

        The time after which the instance should be removed by the History Cleanup job. [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :return: The removal_time of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._removal_time

    @removal_time.setter
    def removal_time(self, removal_time):
        """Sets the removal_time of this HistoricDecisionInstanceDto.

        The time after which the instance should be removed by the History Cleanup job. [Default format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  # noqa: E501

        :param removal_time: The removal_time of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._removal_time = removal_time

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The id of the process definition that this decision instance belongs to.  # noqa: E501

        :return: The process_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricDecisionInstanceDto.

        The id of the process definition that this decision instance belongs to.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501

        The key of the process definition that this decision instance belongs to.  # noqa: E501

        :return: The process_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricDecisionInstanceDto.

        The key of the process definition that this decision instance belongs to.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The id of the process instance that this decision instance belongs to.  # noqa: E501

        :return: The process_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricDecisionInstanceDto.

        The id of the process instance that this decision instance belongs to.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def case_definition_id(self):
        """Gets the case_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The id of the case definition that this decision instance belongs to.  # noqa: E501

        :return: The case_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_id

    @case_definition_id.setter
    def case_definition_id(self, case_definition_id):
        """Sets the case_definition_id of this HistoricDecisionInstanceDto.

        The id of the case definition that this decision instance belongs to.  # noqa: E501

        :param case_definition_id: The case_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._case_definition_id = case_definition_id

    @property
    def case_definition_key(self):
        """Gets the case_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501

        The key of the case definition that this decision instance belongs to.  # noqa: E501

        :return: The case_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._case_definition_key

    @case_definition_key.setter
    def case_definition_key(self, case_definition_key):
        """Sets the case_definition_key of this HistoricDecisionInstanceDto.

        The key of the case definition that this decision instance belongs to.  # noqa: E501

        :param case_definition_key: The case_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._case_definition_key = case_definition_key

    @property
    def case_instance_id(self):
        """Gets the case_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The id of the case instance that this decision instance belongs to.  # noqa: E501

        :return: The case_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._case_instance_id

    @case_instance_id.setter
    def case_instance_id(self, case_instance_id):
        """Sets the case_instance_id of this HistoricDecisionInstanceDto.

        The id of the case instance that this decision instance belongs to.  # noqa: E501

        :param case_instance_id: The case_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._case_instance_id = case_instance_id

    @property
    def activity_id(self):
        """Gets the activity_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The id of the activity that this decision instance belongs to.  # noqa: E501

        :return: The activity_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this HistoricDecisionInstanceDto.

        The id of the activity that this decision instance belongs to.  # noqa: E501

        :param activity_id: The activity_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def activity_instance_id(self):
        """Gets the activity_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The id of the activity instance that this decision instance belongs to.  # noqa: E501

        :return: The activity_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_instance_id

    @activity_instance_id.setter
    def activity_instance_id(self, activity_instance_id):
        """Sets the activity_instance_id of this HistoricDecisionInstanceDto.

        The id of the activity instance that this decision instance belongs to.  # noqa: E501

        :param activity_instance_id: The activity_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._activity_instance_id = activity_instance_id

    @property
    def tenant_id(self):
        """Gets the tenant_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The tenant id of the historic decision instance.  # noqa: E501

        :return: The tenant_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this HistoricDecisionInstanceDto.

        The tenant id of the historic decision instance.  # noqa: E501

        :param tenant_id: The tenant_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def user_id(self):
        """Gets the user_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The id of the authenticated user that has evaluated this decision instance without a process or case instance.  # noqa: E501

        :return: The user_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this HistoricDecisionInstanceDto.

        The id of the authenticated user that has evaluated this decision instance without a process or case instance.  # noqa: E501

        :param user_id: The user_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    @property
    def inputs(self):
        """Gets the inputs of this HistoricDecisionInstanceDto.  # noqa: E501

        The list of decision input values. **Only exists** if `includeInputs` was set to `true` in the query.  # noqa: E501

        :return: The inputs of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: list[HistoricDecisionInputInstanceDto]
        """
        return self._inputs

    @inputs.setter
    def inputs(self, inputs):
        """Sets the inputs of this HistoricDecisionInstanceDto.

        The list of decision input values. **Only exists** if `includeInputs` was set to `true` in the query.  # noqa: E501

        :param inputs: The inputs of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: list[HistoricDecisionInputInstanceDto]
        """

        self._inputs = inputs

    @property
    def ouputs(self):
        """Gets the ouputs of this HistoricDecisionInstanceDto.  # noqa: E501

        The list of decision output values. **Only exists** if `includeOutputs` was set to `true` in the query.  # noqa: E501

        :return: The ouputs of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: list[HistoricDecisionOutputInstanceDto]
        """
        return self._ouputs

    @ouputs.setter
    def ouputs(self, ouputs):
        """Sets the ouputs of this HistoricDecisionInstanceDto.

        The list of decision output values. **Only exists** if `includeOutputs` was set to `true` in the query.  # noqa: E501

        :param ouputs: The ouputs of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: list[HistoricDecisionOutputInstanceDto]
        """

        self._ouputs = ouputs

    @property
    def collect_result_value(self):
        """Gets the collect_result_value of this HistoricDecisionInstanceDto.  # noqa: E501

        The result of the collect aggregation of the decision result if used. `null` if no aggregation was used.  # noqa: E501

        :return: The collect_result_value of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: float
        """
        return self._collect_result_value

    @collect_result_value.setter
    def collect_result_value(self, collect_result_value):
        """Sets the collect_result_value of this HistoricDecisionInstanceDto.

        The result of the collect aggregation of the decision result if used. `null` if no aggregation was used.  # noqa: E501

        :param collect_result_value: The collect_result_value of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: float
        """

        self._collect_result_value = collect_result_value

    @property
    def root_decision_instance_id(self):
        """Gets the root_decision_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The decision instance id of the evaluated root decision. Can be `null` if this instance is the root decision instance of the evaluation.  # noqa: E501

        :return: The root_decision_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._root_decision_instance_id

    @root_decision_instance_id.setter
    def root_decision_instance_id(self, root_decision_instance_id):
        """Sets the root_decision_instance_id of this HistoricDecisionInstanceDto.

        The decision instance id of the evaluated root decision. Can be `null` if this instance is the root decision instance of the evaluation.  # noqa: E501

        :param root_decision_instance_id: The root_decision_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._root_decision_instance_id = root_decision_instance_id

    @property
    def root_process_instance_id(self):
        """Gets the root_process_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The process instance id of the root process instance that initiated the evaluation of this decision. Can be `null` if this decision instance is not evaluated as part of a BPMN process.  # noqa: E501

        :return: The root_process_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._root_process_instance_id

    @root_process_instance_id.setter
    def root_process_instance_id(self, root_process_instance_id):
        """Sets the root_process_instance_id of this HistoricDecisionInstanceDto.

        The process instance id of the root process instance that initiated the evaluation of this decision. Can be `null` if this decision instance is not evaluated as part of a BPMN process.  # noqa: E501

        :param root_process_instance_id: The root_process_instance_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._root_process_instance_id = root_process_instance_id

    @property
    def decision_requirements_definition_id(self):
        """Gets the decision_requirements_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501

        The id of the decision requirements definition that this decision instance belongs to.  # noqa: E501

        :return: The decision_requirements_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._decision_requirements_definition_id

    @decision_requirements_definition_id.setter
    def decision_requirements_definition_id(self, decision_requirements_definition_id):
        """Sets the decision_requirements_definition_id of this HistoricDecisionInstanceDto.

        The id of the decision requirements definition that this decision instance belongs to.  # noqa: E501

        :param decision_requirements_definition_id: The decision_requirements_definition_id of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._decision_requirements_definition_id = decision_requirements_definition_id

    @property
    def decision_requirements_definition_key(self):
        """Gets the decision_requirements_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501

        The key of the decision requirements definition that this decision instance belongs to.  # noqa: E501

        :return: The decision_requirements_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._decision_requirements_definition_key

    @decision_requirements_definition_key.setter
    def decision_requirements_definition_key(self, decision_requirements_definition_key):
        """Sets the decision_requirements_definition_key of this HistoricDecisionInstanceDto.

        The key of the decision requirements definition that this decision instance belongs to.  # noqa: E501

        :param decision_requirements_definition_key: The decision_requirements_definition_key of this HistoricDecisionInstanceDto.  # noqa: E501
        :type: str
        """

        self._decision_requirements_definition_key = decision_requirements_definition_key

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricDecisionInstanceDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricDecisionInstanceDto):
            return True

        return self.to_dict() != other.to_dict()
