# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricBatchQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'batch_id': 'str',
        'type': 'str',
        'completed': 'bool',
        'tenant_id_in': 'list[str]',
        'without_tenant_id': 'bool',
        'sorting': 'list[HistoricBatchQueryDtoSorting]'
    }

    attribute_map = {
        'batch_id': 'batchId',
        'type': 'type',
        'completed': 'completed',
        'tenant_id_in': 'tenantIdIn',
        'without_tenant_id': 'withoutTenantId',
        'sorting': 'sorting'
    }

    def __init__(self, batch_id=None, type=None, completed=None, tenant_id_in=None, without_tenant_id=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """HistoricBatchQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._batch_id = None
        self._type = None
        self._completed = None
        self._tenant_id_in = None
        self._without_tenant_id = None
        self._sorting = None
        self.discriminator = None

        self.batch_id = batch_id
        self.type = type
        self.completed = completed
        self.tenant_id_in = tenant_id_in
        self.without_tenant_id = without_tenant_id
        self.sorting = sorting

    @property
    def batch_id(self):
        """Gets the batch_id of this HistoricBatchQueryDto.  # noqa: E501

        Filter by batch id.  # noqa: E501

        :return: The batch_id of this HistoricBatchQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._batch_id

    @batch_id.setter
    def batch_id(self, batch_id):
        """Sets the batch_id of this HistoricBatchQueryDto.

        Filter by batch id.  # noqa: E501

        :param batch_id: The batch_id of this HistoricBatchQueryDto.  # noqa: E501
        :type: str
        """

        self._batch_id = batch_id

    @property
    def type(self):
        """Gets the type of this HistoricBatchQueryDto.  # noqa: E501

        Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.  # noqa: E501

        :return: The type of this HistoricBatchQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this HistoricBatchQueryDto.

        Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.  # noqa: E501

        :param type: The type of this HistoricBatchQueryDto.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def completed(self):
        """Gets the completed of this HistoricBatchQueryDto.  # noqa: E501

         Filter completed or not completed batches. If the value is `true`, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is `false`, only running batches, i.e., end time is null, are returned.  # noqa: E501

        :return: The completed of this HistoricBatchQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._completed

    @completed.setter
    def completed(self, completed):
        """Sets the completed of this HistoricBatchQueryDto.

         Filter completed or not completed batches. If the value is `true`, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is `false`, only running batches, i.e., end time is null, are returned.  # noqa: E501

        :param completed: The completed of this HistoricBatchQueryDto.  # noqa: E501
        :type: bool
        """

        self._completed = completed

    @property
    def tenant_id_in(self):
        """Gets the tenant_id_in of this HistoricBatchQueryDto.  # noqa: E501

        Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids.  # noqa: E501

        :return: The tenant_id_in of this HistoricBatchQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._tenant_id_in

    @tenant_id_in.setter
    def tenant_id_in(self, tenant_id_in):
        """Sets the tenant_id_in of this HistoricBatchQueryDto.

        Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids.  # noqa: E501

        :param tenant_id_in: The tenant_id_in of this HistoricBatchQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._tenant_id_in = tenant_id_in

    @property
    def without_tenant_id(self):
        """Gets the without_tenant_id of this HistoricBatchQueryDto.  # noqa: E501

        Only include batches which belong to no tenant. Value can effectively only be `true`, as `false` is the default behavior.  # noqa: E501

        :return: The without_tenant_id of this HistoricBatchQueryDto.  # noqa: E501
        :rtype: bool
        """
        return self._without_tenant_id

    @without_tenant_id.setter
    def without_tenant_id(self, without_tenant_id):
        """Sets the without_tenant_id of this HistoricBatchQueryDto.

        Only include batches which belong to no tenant. Value can effectively only be `true`, as `false` is the default behavior.  # noqa: E501

        :param without_tenant_id: The without_tenant_id of this HistoricBatchQueryDto.  # noqa: E501
        :type: bool
        """

        self._without_tenant_id = without_tenant_id

    @property
    def sorting(self):
        """Gets the sorting of this HistoricBatchQueryDto.  # noqa: E501

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the `/count` endpoint  # noqa: E501

        :return: The sorting of this HistoricBatchQueryDto.  # noqa: E501
        :rtype: list[HistoricBatchQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this HistoricBatchQueryDto.

        An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the `/count` endpoint  # noqa: E501

        :param sorting: The sorting of this HistoricBatchQueryDto.  # noqa: E501
        :type: list[HistoricBatchQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricBatchQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricBatchQueryDto):
            return True

        return self.to_dict() != other.to_dict()
