# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricBatchDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'type': 'str',
        'total_jobs': 'int',
        'batch_jobs_per_seed': 'int',
        'invocations_per_batch_job': 'int',
        'seed_job_definition_id': 'str',
        'monitor_job_definition_id': 'str',
        'batch_job_definition_id': 'str',
        'tenant_id': 'str',
        'create_user_id': 'str',
        'start_time': 'datetime',
        'end_time': 'datetime',
        'removal_time': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'type': 'type',
        'total_jobs': 'totalJobs',
        'batch_jobs_per_seed': 'batchJobsPerSeed',
        'invocations_per_batch_job': 'invocationsPerBatchJob',
        'seed_job_definition_id': 'seedJobDefinitionId',
        'monitor_job_definition_id': 'monitorJobDefinitionId',
        'batch_job_definition_id': 'batchJobDefinitionId',
        'tenant_id': 'tenantId',
        'create_user_id': 'createUserId',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'removal_time': 'removalTime'
    }

    def __init__(self, id=None, type=None, total_jobs=None, batch_jobs_per_seed=None, invocations_per_batch_job=None, seed_job_definition_id=None, monitor_job_definition_id=None, batch_job_definition_id=None, tenant_id=None, create_user_id=None, start_time=None, end_time=None, removal_time=None, local_vars_configuration=None):  # noqa: E501
        """HistoricBatchDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._type = None
        self._total_jobs = None
        self._batch_jobs_per_seed = None
        self._invocations_per_batch_job = None
        self._seed_job_definition_id = None
        self._monitor_job_definition_id = None
        self._batch_job_definition_id = None
        self._tenant_id = None
        self._create_user_id = None
        self._start_time = None
        self._end_time = None
        self._removal_time = None
        self.discriminator = None

        self.id = id
        self.type = type
        self.total_jobs = total_jobs
        self.batch_jobs_per_seed = batch_jobs_per_seed
        self.invocations_per_batch_job = invocations_per_batch_job
        self.seed_job_definition_id = seed_job_definition_id
        self.monitor_job_definition_id = monitor_job_definition_id
        self.batch_job_definition_id = batch_job_definition_id
        self.tenant_id = tenant_id
        self.create_user_id = create_user_id
        self.start_time = start_time
        self.end_time = end_time
        self.removal_time = removal_time

    @property
    def id(self):
        """Gets the id of this HistoricBatchDto.  # noqa: E501

        The id of the batch.  # noqa: E501

        :return: The id of this HistoricBatchDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HistoricBatchDto.

        The id of the batch.  # noqa: E501

        :param id: The id of this HistoricBatchDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def type(self):
        """Gets the type of this HistoricBatchDto.  # noqa: E501

        The type of the batch. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.  # noqa: E501

        :return: The type of this HistoricBatchDto.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this HistoricBatchDto.

        The type of the batch. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.  # noqa: E501

        :param type: The type of this HistoricBatchDto.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def total_jobs(self):
        """Gets the total_jobs of this HistoricBatchDto.  # noqa: E501

         The total jobs of a batch is the number of batch execution jobs required to complete the batch.   # noqa: E501

        :return: The total_jobs of this HistoricBatchDto.  # noqa: E501
        :rtype: int
        """
        return self._total_jobs

    @total_jobs.setter
    def total_jobs(self, total_jobs):
        """Sets the total_jobs of this HistoricBatchDto.

         The total jobs of a batch is the number of batch execution jobs required to complete the batch.   # noqa: E501

        :param total_jobs: The total_jobs of this HistoricBatchDto.  # noqa: E501
        :type: int
        """

        self._total_jobs = total_jobs

    @property
    def batch_jobs_per_seed(self):
        """Gets the batch_jobs_per_seed of this HistoricBatchDto.  # noqa: E501

         The number of batch execution jobs created per seed job invocation. The batch seed job is invoked until it has created all batch execution jobs required by the batch (see `totalJobs` property).   # noqa: E501

        :return: The batch_jobs_per_seed of this HistoricBatchDto.  # noqa: E501
        :rtype: int
        """
        return self._batch_jobs_per_seed

    @batch_jobs_per_seed.setter
    def batch_jobs_per_seed(self, batch_jobs_per_seed):
        """Sets the batch_jobs_per_seed of this HistoricBatchDto.

         The number of batch execution jobs created per seed job invocation. The batch seed job is invoked until it has created all batch execution jobs required by the batch (see `totalJobs` property).   # noqa: E501

        :param batch_jobs_per_seed: The batch_jobs_per_seed of this HistoricBatchDto.  # noqa: E501
        :type: int
        """

        self._batch_jobs_per_seed = batch_jobs_per_seed

    @property
    def invocations_per_batch_job(self):
        """Gets the invocations_per_batch_job of this HistoricBatchDto.  # noqa: E501

         Every batch execution job invokes the command executed by the batch `invocationsPerBatchJob` times. E.g., for a process instance migration batch this specifies the number of process instances which are migrated per batch execution job.   # noqa: E501

        :return: The invocations_per_batch_job of this HistoricBatchDto.  # noqa: E501
        :rtype: int
        """
        return self._invocations_per_batch_job

    @invocations_per_batch_job.setter
    def invocations_per_batch_job(self, invocations_per_batch_job):
        """Sets the invocations_per_batch_job of this HistoricBatchDto.

         Every batch execution job invokes the command executed by the batch `invocationsPerBatchJob` times. E.g., for a process instance migration batch this specifies the number of process instances which are migrated per batch execution job.   # noqa: E501

        :param invocations_per_batch_job: The invocations_per_batch_job of this HistoricBatchDto.  # noqa: E501
        :type: int
        """

        self._invocations_per_batch_job = invocations_per_batch_job

    @property
    def seed_job_definition_id(self):
        """Gets the seed_job_definition_id of this HistoricBatchDto.  # noqa: E501

        The job definition id for the seed jobs of this batch.  # noqa: E501

        :return: The seed_job_definition_id of this HistoricBatchDto.  # noqa: E501
        :rtype: str
        """
        return self._seed_job_definition_id

    @seed_job_definition_id.setter
    def seed_job_definition_id(self, seed_job_definition_id):
        """Sets the seed_job_definition_id of this HistoricBatchDto.

        The job definition id for the seed jobs of this batch.  # noqa: E501

        :param seed_job_definition_id: The seed_job_definition_id of this HistoricBatchDto.  # noqa: E501
        :type: str
        """

        self._seed_job_definition_id = seed_job_definition_id

    @property
    def monitor_job_definition_id(self):
        """Gets the monitor_job_definition_id of this HistoricBatchDto.  # noqa: E501

        The job definition id for the monitor jobs of this batch.  # noqa: E501

        :return: The monitor_job_definition_id of this HistoricBatchDto.  # noqa: E501
        :rtype: str
        """
        return self._monitor_job_definition_id

    @monitor_job_definition_id.setter
    def monitor_job_definition_id(self, monitor_job_definition_id):
        """Sets the monitor_job_definition_id of this HistoricBatchDto.

        The job definition id for the monitor jobs of this batch.  # noqa: E501

        :param monitor_job_definition_id: The monitor_job_definition_id of this HistoricBatchDto.  # noqa: E501
        :type: str
        """

        self._monitor_job_definition_id = monitor_job_definition_id

    @property
    def batch_job_definition_id(self):
        """Gets the batch_job_definition_id of this HistoricBatchDto.  # noqa: E501

        The job definition id for the batch execution jobs of this batch.  # noqa: E501

        :return: The batch_job_definition_id of this HistoricBatchDto.  # noqa: E501
        :rtype: str
        """
        return self._batch_job_definition_id

    @batch_job_definition_id.setter
    def batch_job_definition_id(self, batch_job_definition_id):
        """Sets the batch_job_definition_id of this HistoricBatchDto.

        The job definition id for the batch execution jobs of this batch.  # noqa: E501

        :param batch_job_definition_id: The batch_job_definition_id of this HistoricBatchDto.  # noqa: E501
        :type: str
        """

        self._batch_job_definition_id = batch_job_definition_id

    @property
    def tenant_id(self):
        """Gets the tenant_id of this HistoricBatchDto.  # noqa: E501

        The tenant id of the batch.  # noqa: E501

        :return: The tenant_id of this HistoricBatchDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this HistoricBatchDto.

        The tenant id of the batch.  # noqa: E501

        :param tenant_id: The tenant_id of this HistoricBatchDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def create_user_id(self):
        """Gets the create_user_id of this HistoricBatchDto.  # noqa: E501

        The batch creator's user id.  # noqa: E501

        :return: The create_user_id of this HistoricBatchDto.  # noqa: E501
        :rtype: str
        """
        return self._create_user_id

    @create_user_id.setter
    def create_user_id(self, create_user_id):
        """Sets the create_user_id of this HistoricBatchDto.

        The batch creator's user id.  # noqa: E501

        :param create_user_id: The create_user_id of this HistoricBatchDto.  # noqa: E501
        :type: str
        """

        self._create_user_id = create_user_id

    @property
    def start_time(self):
        """Gets the start_time of this HistoricBatchDto.  # noqa: E501

        The time the batch was started. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/)  # noqa: E501

        :return: The start_time of this HistoricBatchDto.  # noqa: E501
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this HistoricBatchDto.

        The time the batch was started. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/)  # noqa: E501

        :param start_time: The start_time of this HistoricBatchDto.  # noqa: E501
        :type: datetime
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """Gets the end_time of this HistoricBatchDto.  # noqa: E501

        The time the batch ended. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/)  # noqa: E501

        :return: The end_time of this HistoricBatchDto.  # noqa: E501
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this HistoricBatchDto.

        The time the batch ended. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/)  # noqa: E501

        :param end_time: The end_time of this HistoricBatchDto.  # noqa: E501
        :type: datetime
        """

        self._end_time = end_time

    @property
    def removal_time(self):
        """Gets the removal_time of this HistoricBatchDto.  # noqa: E501

        The time after which the historic batch should be removed by the History Cleanup job. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/)  # noqa: E501

        :return: The removal_time of this HistoricBatchDto.  # noqa: E501
        :rtype: datetime
        """
        return self._removal_time

    @removal_time.setter
    def removal_time(self, removal_time):
        """Sets the removal_time of this HistoricBatchDto.

        The time after which the historic batch should be removed by the History Cleanup job. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/)  # noqa: E501

        :param removal_time: The removal_time of this HistoricBatchDto.  # noqa: E501
        :type: datetime
        """

        self._removal_time = removal_time

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricBatchDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricBatchDto):
            return True

        return self.to_dict() != other.to_dict()
