# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class HistoricActivityInstanceDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'parent_activity_instance_id': 'str',
        'activity_id': 'str',
        'activity_name': 'str',
        'activity_type': 'str',
        'process_definition_key': 'str',
        'process_definition_id': 'str',
        'process_instance_id': 'str',
        'execution_id': 'str',
        'task_id': 'str',
        'assignee': 'str',
        'called_process_instance_id': 'str',
        'called_case_instance_id': 'str',
        'start_time': 'datetime',
        'end_time': 'datetime',
        'duration_in_millis': 'int',
        'canceled': 'bool',
        'complete_scope': 'bool',
        'tenant_id': 'str',
        'removal_time': 'datetime',
        'root_process_instance_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'parent_activity_instance_id': 'parentActivityInstanceId',
        'activity_id': 'activityId',
        'activity_name': 'activityName',
        'activity_type': 'activityType',
        'process_definition_key': 'processDefinitionKey',
        'process_definition_id': 'processDefinitionId',
        'process_instance_id': 'processInstanceId',
        'execution_id': 'executionId',
        'task_id': 'taskId',
        'assignee': 'assignee',
        'called_process_instance_id': 'calledProcessInstanceId',
        'called_case_instance_id': 'calledCaseInstanceId',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'duration_in_millis': 'durationInMillis',
        'canceled': 'canceled',
        'complete_scope': 'completeScope',
        'tenant_id': 'tenantId',
        'removal_time': 'removalTime',
        'root_process_instance_id': 'rootProcessInstanceId'
    }

    def __init__(self, id=None, parent_activity_instance_id=None, activity_id=None, activity_name=None, activity_type=None, process_definition_key=None, process_definition_id=None, process_instance_id=None, execution_id=None, task_id=None, assignee=None, called_process_instance_id=None, called_case_instance_id=None, start_time=None, end_time=None, duration_in_millis=None, canceled=None, complete_scope=None, tenant_id=None, removal_time=None, root_process_instance_id=None, local_vars_configuration=None):  # noqa: E501
        """HistoricActivityInstanceDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._parent_activity_instance_id = None
        self._activity_id = None
        self._activity_name = None
        self._activity_type = None
        self._process_definition_key = None
        self._process_definition_id = None
        self._process_instance_id = None
        self._execution_id = None
        self._task_id = None
        self._assignee = None
        self._called_process_instance_id = None
        self._called_case_instance_id = None
        self._start_time = None
        self._end_time = None
        self._duration_in_millis = None
        self._canceled = None
        self._complete_scope = None
        self._tenant_id = None
        self._removal_time = None
        self._root_process_instance_id = None
        self.discriminator = None

        self.id = id
        self.parent_activity_instance_id = parent_activity_instance_id
        self.activity_id = activity_id
        self.activity_name = activity_name
        self.activity_type = activity_type
        self.process_definition_key = process_definition_key
        self.process_definition_id = process_definition_id
        self.process_instance_id = process_instance_id
        self.execution_id = execution_id
        self.task_id = task_id
        self.assignee = assignee
        self.called_process_instance_id = called_process_instance_id
        self.called_case_instance_id = called_case_instance_id
        self.start_time = start_time
        self.end_time = end_time
        self.duration_in_millis = duration_in_millis
        self.canceled = canceled
        self.complete_scope = complete_scope
        self.tenant_id = tenant_id
        self.removal_time = removal_time
        self.root_process_instance_id = root_process_instance_id

    @property
    def id(self):
        """Gets the id of this HistoricActivityInstanceDto.  # noqa: E501

        The id of the activity instance.  # noqa: E501

        :return: The id of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HistoricActivityInstanceDto.

        The id of the activity instance.  # noqa: E501

        :param id: The id of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def parent_activity_instance_id(self):
        """Gets the parent_activity_instance_id of this HistoricActivityInstanceDto.  # noqa: E501

        The id of the parent activity instance, for example a sub process instance.  # noqa: E501

        :return: The parent_activity_instance_id of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._parent_activity_instance_id

    @parent_activity_instance_id.setter
    def parent_activity_instance_id(self, parent_activity_instance_id):
        """Sets the parent_activity_instance_id of this HistoricActivityInstanceDto.

        The id of the parent activity instance, for example a sub process instance.  # noqa: E501

        :param parent_activity_instance_id: The parent_activity_instance_id of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._parent_activity_instance_id = parent_activity_instance_id

    @property
    def activity_id(self):
        """Gets the activity_id of this HistoricActivityInstanceDto.  # noqa: E501

        The id of the activity that this object is an instance of.  # noqa: E501

        :return: The activity_id of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this HistoricActivityInstanceDto.

        The id of the activity that this object is an instance of.  # noqa: E501

        :param activity_id: The activity_id of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def activity_name(self):
        """Gets the activity_name of this HistoricActivityInstanceDto.  # noqa: E501

        The name of the activity that this object is an instance of.  # noqa: E501

        :return: The activity_name of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_name

    @activity_name.setter
    def activity_name(self, activity_name):
        """Sets the activity_name of this HistoricActivityInstanceDto.

        The name of the activity that this object is an instance of.  # noqa: E501

        :param activity_name: The activity_name of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._activity_name = activity_name

    @property
    def activity_type(self):
        """Gets the activity_type of this HistoricActivityInstanceDto.  # noqa: E501

        The type of the activity that this object is an instance of.  # noqa: E501

        :return: The activity_type of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_type

    @activity_type.setter
    def activity_type(self, activity_type):
        """Sets the activity_type of this HistoricActivityInstanceDto.

        The type of the activity that this object is an instance of.  # noqa: E501

        :param activity_type: The activity_type of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._activity_type = activity_type

    @property
    def process_definition_key(self):
        """Gets the process_definition_key of this HistoricActivityInstanceDto.  # noqa: E501

        The key of the process definition that this activity instance belongs to.  # noqa: E501

        :return: The process_definition_key of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_key

    @process_definition_key.setter
    def process_definition_key(self, process_definition_key):
        """Sets the process_definition_key of this HistoricActivityInstanceDto.

        The key of the process definition that this activity instance belongs to.  # noqa: E501

        :param process_definition_key: The process_definition_key of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_definition_key = process_definition_key

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this HistoricActivityInstanceDto.  # noqa: E501

        The id of the process definition that this activity instance belongs to.  # noqa: E501

        :return: The process_definition_id of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this HistoricActivityInstanceDto.

        The id of the process definition that this activity instance belongs to.  # noqa: E501

        :param process_definition_id: The process_definition_id of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this HistoricActivityInstanceDto.  # noqa: E501

        The id of the process instance that this activity instance belongs to.  # noqa: E501

        :return: The process_instance_id of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this HistoricActivityInstanceDto.

        The id of the process instance that this activity instance belongs to.  # noqa: E501

        :param process_instance_id: The process_instance_id of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def execution_id(self):
        """Gets the execution_id of this HistoricActivityInstanceDto.  # noqa: E501

        The id of the execution that executed this activity instance.  # noqa: E501

        :return: The execution_id of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._execution_id

    @execution_id.setter
    def execution_id(self, execution_id):
        """Sets the execution_id of this HistoricActivityInstanceDto.

        The id of the execution that executed this activity instance.  # noqa: E501

        :param execution_id: The execution_id of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._execution_id = execution_id

    @property
    def task_id(self):
        """Gets the task_id of this HistoricActivityInstanceDto.  # noqa: E501

        The id of the task that is associated to this activity instance. Is only set if the activity is a user task.  # noqa: E501

        :return: The task_id of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """Sets the task_id of this HistoricActivityInstanceDto.

        The id of the task that is associated to this activity instance. Is only set if the activity is a user task.  # noqa: E501

        :param task_id: The task_id of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._task_id = task_id

    @property
    def assignee(self):
        """Gets the assignee of this HistoricActivityInstanceDto.  # noqa: E501

        The assignee of the task that is associated to this activity instance. Is only set if the activity is a user task.  # noqa: E501

        :return: The assignee of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._assignee

    @assignee.setter
    def assignee(self, assignee):
        """Sets the assignee of this HistoricActivityInstanceDto.

        The assignee of the task that is associated to this activity instance. Is only set if the activity is a user task.  # noqa: E501

        :param assignee: The assignee of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._assignee = assignee

    @property
    def called_process_instance_id(self):
        """Gets the called_process_instance_id of this HistoricActivityInstanceDto.  # noqa: E501

        The id of the called process instance. Is only set if the activity is a call activity and the called instance a process instance.  # noqa: E501

        :return: The called_process_instance_id of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._called_process_instance_id

    @called_process_instance_id.setter
    def called_process_instance_id(self, called_process_instance_id):
        """Sets the called_process_instance_id of this HistoricActivityInstanceDto.

        The id of the called process instance. Is only set if the activity is a call activity and the called instance a process instance.  # noqa: E501

        :param called_process_instance_id: The called_process_instance_id of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._called_process_instance_id = called_process_instance_id

    @property
    def called_case_instance_id(self):
        """Gets the called_case_instance_id of this HistoricActivityInstanceDto.  # noqa: E501

        The id of the called case instance. Is only set if the activity is a call activity and the called instance a case instance.  # noqa: E501

        :return: The called_case_instance_id of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._called_case_instance_id

    @called_case_instance_id.setter
    def called_case_instance_id(self, called_case_instance_id):
        """Sets the called_case_instance_id of this HistoricActivityInstanceDto.

        The id of the called case instance. Is only set if the activity is a call activity and the called instance a case instance.  # noqa: E501

        :param called_case_instance_id: The called_case_instance_id of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._called_case_instance_id = called_case_instance_id

    @property
    def start_time(self):
        """Gets the start_time of this HistoricActivityInstanceDto.  # noqa: E501

        The time the instance was started. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The start_time of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """Sets the start_time of this HistoricActivityInstanceDto.

        The time the instance was started. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param start_time: The start_time of this HistoricActivityInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._start_time = start_time

    @property
    def end_time(self):
        """Gets the end_time of this HistoricActivityInstanceDto.  # noqa: E501

        The time the instance ended. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The end_time of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """Sets the end_time of this HistoricActivityInstanceDto.

        The time the instance ended. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param end_time: The end_time of this HistoricActivityInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._end_time = end_time

    @property
    def duration_in_millis(self):
        """Gets the duration_in_millis of this HistoricActivityInstanceDto.  # noqa: E501

        The time the instance took to finish (in milliseconds).  # noqa: E501

        :return: The duration_in_millis of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: int
        """
        return self._duration_in_millis

    @duration_in_millis.setter
    def duration_in_millis(self, duration_in_millis):
        """Sets the duration_in_millis of this HistoricActivityInstanceDto.

        The time the instance took to finish (in milliseconds).  # noqa: E501

        :param duration_in_millis: The duration_in_millis of this HistoricActivityInstanceDto.  # noqa: E501
        :type: int
        """

        self._duration_in_millis = duration_in_millis

    @property
    def canceled(self):
        """Gets the canceled of this HistoricActivityInstanceDto.  # noqa: E501

        If `true`, this activity instance is canceled.  # noqa: E501

        :return: The canceled of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: bool
        """
        return self._canceled

    @canceled.setter
    def canceled(self, canceled):
        """Sets the canceled of this HistoricActivityInstanceDto.

        If `true`, this activity instance is canceled.  # noqa: E501

        :param canceled: The canceled of this HistoricActivityInstanceDto.  # noqa: E501
        :type: bool
        """

        self._canceled = canceled

    @property
    def complete_scope(self):
        """Gets the complete_scope of this HistoricActivityInstanceDto.  # noqa: E501

        If `true`, this activity instance did complete a BPMN 2.0 scope.  # noqa: E501

        :return: The complete_scope of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: bool
        """
        return self._complete_scope

    @complete_scope.setter
    def complete_scope(self, complete_scope):
        """Sets the complete_scope of this HistoricActivityInstanceDto.

        If `true`, this activity instance did complete a BPMN 2.0 scope.  # noqa: E501

        :param complete_scope: The complete_scope of this HistoricActivityInstanceDto.  # noqa: E501
        :type: bool
        """

        self._complete_scope = complete_scope

    @property
    def tenant_id(self):
        """Gets the tenant_id of this HistoricActivityInstanceDto.  # noqa: E501

        The tenant id of the activity instance.  # noqa: E501

        :return: The tenant_id of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this HistoricActivityInstanceDto.

        The tenant id of the activity instance.  # noqa: E501

        :param tenant_id: The tenant_id of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def removal_time(self):
        """Gets the removal_time of this HistoricActivityInstanceDto.  # noqa: E501

        The time after which the activity instance should be removed by the History Cleanup job. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :return: The removal_time of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: datetime
        """
        return self._removal_time

    @removal_time.setter
    def removal_time(self, removal_time):
        """Sets the removal_time of this HistoricActivityInstanceDto.

        The time after which the activity instance should be removed by the History Cleanup job. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.  # noqa: E501

        :param removal_time: The removal_time of this HistoricActivityInstanceDto.  # noqa: E501
        :type: datetime
        """

        self._removal_time = removal_time

    @property
    def root_process_instance_id(self):
        """Gets the root_process_instance_id of this HistoricActivityInstanceDto.  # noqa: E501

        The process instance id of the root process instance that initiated the process containing this activity instance.  # noqa: E501

        :return: The root_process_instance_id of this HistoricActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._root_process_instance_id

    @root_process_instance_id.setter
    def root_process_instance_id(self, root_process_instance_id):
        """Sets the root_process_instance_id of this HistoricActivityInstanceDto.

        The process instance id of the root process instance that initiated the process containing this activity instance.  # noqa: E501

        :param root_process_instance_id: The root_process_instance_id of this HistoricActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._root_process_instance_id = root_process_instance_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HistoricActivityInstanceDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HistoricActivityInstanceDto):
            return True

        return self.to_dict() != other.to_dict()
