# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class GroupQueryDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'id_in': 'list[str]',
        'name': 'str',
        'name_like': 'str',
        'type': 'str',
        'member': 'str',
        'member_of_tenant': 'str',
        'sorting': 'list[GroupQueryDtoSorting]'
    }

    attribute_map = {
        'id': 'id',
        'id_in': 'idIn',
        'name': 'name',
        'name_like': 'nameLike',
        'type': 'type',
        'member': 'member',
        'member_of_tenant': 'memberOfTenant',
        'sorting': 'sorting'
    }

    def __init__(self, id=None, id_in=None, name=None, name_like=None, type=None, member=None, member_of_tenant=None, sorting=None, local_vars_configuration=None):  # noqa: E501
        """GroupQueryDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._id_in = None
        self._name = None
        self._name_like = None
        self._type = None
        self._member = None
        self._member_of_tenant = None
        self._sorting = None
        self.discriminator = None

        self.id = id
        self.id_in = id_in
        self.name = name
        self.name_like = name_like
        self.type = type
        self.member = member
        self.member_of_tenant = member_of_tenant
        self.sorting = sorting

    @property
    def id(self):
        """Gets the id of this GroupQueryDto.  # noqa: E501

        Filter by the id of the group.  # noqa: E501

        :return: The id of this GroupQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this GroupQueryDto.

        Filter by the id of the group.  # noqa: E501

        :param id: The id of this GroupQueryDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def id_in(self):
        """Gets the id_in of this GroupQueryDto.  # noqa: E501

        Filter by a JSON string array of group ids.  # noqa: E501

        :return: The id_in of this GroupQueryDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._id_in

    @id_in.setter
    def id_in(self, id_in):
        """Sets the id_in of this GroupQueryDto.

        Filter by a JSON string array of group ids.  # noqa: E501

        :param id_in: The id_in of this GroupQueryDto.  # noqa: E501
        :type: list[str]
        """

        self._id_in = id_in

    @property
    def name(self):
        """Gets the name of this GroupQueryDto.  # noqa: E501

        Filter by the name of the group.  # noqa: E501

        :return: The name of this GroupQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this GroupQueryDto.

        Filter by the name of the group.  # noqa: E501

        :param name: The name of this GroupQueryDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def name_like(self):
        """Gets the name_like of this GroupQueryDto.  # noqa: E501

        Filter by the name that the parameter is a substring of.  # noqa: E501

        :return: The name_like of this GroupQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._name_like

    @name_like.setter
    def name_like(self, name_like):
        """Sets the name_like of this GroupQueryDto.

        Filter by the name that the parameter is a substring of.  # noqa: E501

        :param name_like: The name_like of this GroupQueryDto.  # noqa: E501
        :type: str
        """

        self._name_like = name_like

    @property
    def type(self):
        """Gets the type of this GroupQueryDto.  # noqa: E501

        Filter by the type of the group.  # noqa: E501

        :return: The type of this GroupQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this GroupQueryDto.

        Filter by the type of the group.  # noqa: E501

        :param type: The type of this GroupQueryDto.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def member(self):
        """Gets the member of this GroupQueryDto.  # noqa: E501

        Only retrieve groups where the given user id is a member of.  # noqa: E501

        :return: The member of this GroupQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._member

    @member.setter
    def member(self, member):
        """Sets the member of this GroupQueryDto.

        Only retrieve groups where the given user id is a member of.  # noqa: E501

        :param member: The member of this GroupQueryDto.  # noqa: E501
        :type: str
        """

        self._member = member

    @property
    def member_of_tenant(self):
        """Gets the member_of_tenant of this GroupQueryDto.  # noqa: E501

        Only retrieve groups which are members of the given tenant.  # noqa: E501

        :return: The member_of_tenant of this GroupQueryDto.  # noqa: E501
        :rtype: str
        """
        return self._member_of_tenant

    @member_of_tenant.setter
    def member_of_tenant(self, member_of_tenant):
        """Sets the member_of_tenant of this GroupQueryDto.

        Only retrieve groups which are members of the given tenant.  # noqa: E501

        :param member_of_tenant: The member_of_tenant of this GroupQueryDto.  # noqa: E501
        :type: str
        """

        self._member_of_tenant = member_of_tenant

    @property
    def sorting(self):
        """Gets the sorting of this GroupQueryDto.  # noqa: E501

        Apply sorting of the result  # noqa: E501

        :return: The sorting of this GroupQueryDto.  # noqa: E501
        :rtype: list[GroupQueryDtoSorting]
        """
        return self._sorting

    @sorting.setter
    def sorting(self, sorting):
        """Sets the sorting of this GroupQueryDto.

        Apply sorting of the result  # noqa: E501

        :param sorting: The sorting of this GroupQueryDto.  # noqa: E501
        :type: list[GroupQueryDtoSorting]
        """

        self._sorting = sorting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GroupQueryDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GroupQueryDto):
            return True

        return self.to_dict() != other.to_dict()
