# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class FetchExternalTasksDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'worker_id': 'str',
        'max_tasks': 'int',
        'use_priority': 'bool',
        'async_response_timeout': 'int',
        'topics': 'list[FetchExternalTaskTopicDto]'
    }

    attribute_map = {
        'worker_id': 'workerId',
        'max_tasks': 'maxTasks',
        'use_priority': 'usePriority',
        'async_response_timeout': 'asyncResponseTimeout',
        'topics': 'topics'
    }

    def __init__(self, worker_id=None, max_tasks=None, use_priority=None, async_response_timeout=None, topics=None, local_vars_configuration=None):  # noqa: E501
        """FetchExternalTasksDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._worker_id = None
        self._max_tasks = None
        self._use_priority = None
        self._async_response_timeout = None
        self._topics = None
        self.discriminator = None

        self.worker_id = worker_id
        self.max_tasks = max_tasks
        self.use_priority = use_priority
        self.async_response_timeout = async_response_timeout
        self.topics = topics

    @property
    def worker_id(self):
        """Gets the worker_id of this FetchExternalTasksDto.  # noqa: E501

        **Mandatory.** The id of the worker on which behalf tasks are fetched. The returned tasks are locked for that worker and can only be completed when providing the same worker id.  # noqa: E501

        :return: The worker_id of this FetchExternalTasksDto.  # noqa: E501
        :rtype: str
        """
        return self._worker_id

    @worker_id.setter
    def worker_id(self, worker_id):
        """Sets the worker_id of this FetchExternalTasksDto.

        **Mandatory.** The id of the worker on which behalf tasks are fetched. The returned tasks are locked for that worker and can only be completed when providing the same worker id.  # noqa: E501

        :param worker_id: The worker_id of this FetchExternalTasksDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and worker_id is None:  # noqa: E501
            raise ValueError("Invalid value for `worker_id`, must not be `None`")  # noqa: E501

        self._worker_id = worker_id

    @property
    def max_tasks(self):
        """Gets the max_tasks of this FetchExternalTasksDto.  # noqa: E501

        **Mandatory.** The maximum number of tasks to return.  # noqa: E501

        :return: The max_tasks of this FetchExternalTasksDto.  # noqa: E501
        :rtype: int
        """
        return self._max_tasks

    @max_tasks.setter
    def max_tasks(self, max_tasks):
        """Sets the max_tasks of this FetchExternalTasksDto.

        **Mandatory.** The maximum number of tasks to return.  # noqa: E501

        :param max_tasks: The max_tasks of this FetchExternalTasksDto.  # noqa: E501
        :type: int
        """

        self._max_tasks = max_tasks

    @property
    def use_priority(self):
        """Gets the use_priority of this FetchExternalTasksDto.  # noqa: E501

        A `boolean` value, which indicates whether the task should be fetched based on its priority or arbitrarily.  # noqa: E501

        :return: The use_priority of this FetchExternalTasksDto.  # noqa: E501
        :rtype: bool
        """
        return self._use_priority

    @use_priority.setter
    def use_priority(self, use_priority):
        """Sets the use_priority of this FetchExternalTasksDto.

        A `boolean` value, which indicates whether the task should be fetched based on its priority or arbitrarily.  # noqa: E501

        :param use_priority: The use_priority of this FetchExternalTasksDto.  # noqa: E501
        :type: bool
        """

        self._use_priority = use_priority

    @property
    def async_response_timeout(self):
        """Gets the async_response_timeout of this FetchExternalTasksDto.  # noqa: E501

        The [Long Polling](https://docs.camunda.org/manual/7.16/user-guide/process-engine/external-tasks/#long-polling-to-fetch-and-lock-external-tasks) timeout in milliseconds.  **Note:** The value cannot be set larger than 1.800.000 milliseconds (corresponds to 30 minutes).  # noqa: E501

        :return: The async_response_timeout of this FetchExternalTasksDto.  # noqa: E501
        :rtype: int
        """
        return self._async_response_timeout

    @async_response_timeout.setter
    def async_response_timeout(self, async_response_timeout):
        """Sets the async_response_timeout of this FetchExternalTasksDto.

        The [Long Polling](https://docs.camunda.org/manual/7.16/user-guide/process-engine/external-tasks/#long-polling-to-fetch-and-lock-external-tasks) timeout in milliseconds.  **Note:** The value cannot be set larger than 1.800.000 milliseconds (corresponds to 30 minutes).  # noqa: E501

        :param async_response_timeout: The async_response_timeout of this FetchExternalTasksDto.  # noqa: E501
        :type: int
        """

        self._async_response_timeout = async_response_timeout

    @property
    def topics(self):
        """Gets the topics of this FetchExternalTasksDto.  # noqa: E501

        A JSON array of topic objects for which external tasks should be fetched. The returned tasks may be arbitrarily distributed among these topics. Each topic object has the following properties:  # noqa: E501

        :return: The topics of this FetchExternalTasksDto.  # noqa: E501
        :rtype: list[FetchExternalTaskTopicDto]
        """
        return self._topics

    @topics.setter
    def topics(self, topics):
        """Sets the topics of this FetchExternalTasksDto.

        A JSON array of topic objects for which external tasks should be fetched. The returned tasks may be arbitrarily distributed among these topics. Each topic object has the following properties:  # noqa: E501

        :param topics: The topics of this FetchExternalTasksDto.  # noqa: E501
        :type: list[FetchExternalTaskTopicDto]
        """

        self._topics = topics

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FetchExternalTasksDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FetchExternalTasksDto):
            return True

        return self.to_dict() != other.to_dict()
