# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class ExternalTaskBpmnError(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'worker_id': 'str',
        'error_code': 'str',
        'error_message': 'str',
        'variables': 'dict(str, VariableValueDto)'
    }

    attribute_map = {
        'worker_id': 'workerId',
        'error_code': 'errorCode',
        'error_message': 'errorMessage',
        'variables': 'variables'
    }

    def __init__(self, worker_id=None, error_code=None, error_message=None, variables=None, local_vars_configuration=None):  # noqa: E501
        """ExternalTaskBpmnError - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._worker_id = None
        self._error_code = None
        self._error_message = None
        self._variables = None
        self.discriminator = None

        self.worker_id = worker_id
        self.error_code = error_code
        self.error_message = error_message
        self.variables = variables

    @property
    def worker_id(self):
        """Gets the worker_id of this ExternalTaskBpmnError.  # noqa: E501

        The id of the worker that reports the failure. Must match the id of the worker who has most recently locked the task.  # noqa: E501

        :return: The worker_id of this ExternalTaskBpmnError.  # noqa: E501
        :rtype: str
        """
        return self._worker_id

    @worker_id.setter
    def worker_id(self, worker_id):
        """Sets the worker_id of this ExternalTaskBpmnError.

        The id of the worker that reports the failure. Must match the id of the worker who has most recently locked the task.  # noqa: E501

        :param worker_id: The worker_id of this ExternalTaskBpmnError.  # noqa: E501
        :type: str
        """

        self._worker_id = worker_id

    @property
    def error_code(self):
        """Gets the error_code of this ExternalTaskBpmnError.  # noqa: E501

        An error code that indicates the predefined error. It is used to identify the BPMN error handler.  # noqa: E501

        :return: The error_code of this ExternalTaskBpmnError.  # noqa: E501
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """Sets the error_code of this ExternalTaskBpmnError.

        An error code that indicates the predefined error. It is used to identify the BPMN error handler.  # noqa: E501

        :param error_code: The error_code of this ExternalTaskBpmnError.  # noqa: E501
        :type: str
        """

        self._error_code = error_code

    @property
    def error_message(self):
        """Gets the error_message of this ExternalTaskBpmnError.  # noqa: E501

        An error message that describes the error.  # noqa: E501

        :return: The error_message of this ExternalTaskBpmnError.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """Sets the error_message of this ExternalTaskBpmnError.

        An error message that describes the error.  # noqa: E501

        :param error_message: The error_message of this ExternalTaskBpmnError.  # noqa: E501
        :type: str
        """

        self._error_message = error_message

    @property
    def variables(self):
        """Gets the variables of this ExternalTaskBpmnError.  # noqa: E501

        A JSON object containing variable key-value pairs.  # noqa: E501

        :return: The variables of this ExternalTaskBpmnError.  # noqa: E501
        :rtype: dict(str, VariableValueDto)
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """Sets the variables of this ExternalTaskBpmnError.

        A JSON object containing variable key-value pairs.  # noqa: E501

        :param variables: The variables of this ExternalTaskBpmnError.  # noqa: E501
        :type: dict(str, VariableValueDto)
        """

        self._variables = variables

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExternalTaskBpmnError):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExternalTaskBpmnError):
            return True

        return self.to_dict() != other.to_dict()
