# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class CalledProcessDefinitionDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'called_from_activity_ids': 'list[str]',
        'calling_process_definition_id': 'str',
        'id': 'str',
        'key': 'str',
        'category': 'str',
        'description': 'str',
        'name': 'str',
        'version': 'int',
        'resource': 'str',
        'deployment_id': 'str',
        'diagram': 'str',
        'suspended': 'bool',
        'tenant_id': 'str',
        'version_tag': 'str',
        'history_time_to_live': 'int',
        'startable_in_tasklist': 'bool'
    }

    attribute_map = {
        'called_from_activity_ids': 'calledFromActivityIds',
        'calling_process_definition_id': 'callingProcessDefinitionId',
        'id': 'id',
        'key': 'key',
        'category': 'category',
        'description': 'description',
        'name': 'name',
        'version': 'version',
        'resource': 'resource',
        'deployment_id': 'deploymentId',
        'diagram': 'diagram',
        'suspended': 'suspended',
        'tenant_id': 'tenantId',
        'version_tag': 'versionTag',
        'history_time_to_live': 'historyTimeToLive',
        'startable_in_tasklist': 'startableInTasklist'
    }

    def __init__(self, called_from_activity_ids=None, calling_process_definition_id=None, id=None, key=None, category=None, description=None, name=None, version=None, resource=None, deployment_id=None, diagram=None, suspended=None, tenant_id=None, version_tag=None, history_time_to_live=None, startable_in_tasklist=None, local_vars_configuration=None):  # noqa: E501
        """CalledProcessDefinitionDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._called_from_activity_ids = None
        self._calling_process_definition_id = None
        self._id = None
        self._key = None
        self._category = None
        self._description = None
        self._name = None
        self._version = None
        self._resource = None
        self._deployment_id = None
        self._diagram = None
        self._suspended = None
        self._tenant_id = None
        self._version_tag = None
        self._history_time_to_live = None
        self._startable_in_tasklist = None
        self.discriminator = None

        self.called_from_activity_ids = called_from_activity_ids
        self.calling_process_definition_id = calling_process_definition_id
        self.id = id
        self.key = key
        self.category = category
        self.description = description
        self.name = name
        self.version = version
        self.resource = resource
        self.deployment_id = deployment_id
        self.diagram = diagram
        self.suspended = suspended
        self.tenant_id = tenant_id
        self.version_tag = version_tag
        self.history_time_to_live = history_time_to_live
        self.startable_in_tasklist = startable_in_tasklist

    @property
    def called_from_activity_ids(self):
        """Gets the called_from_activity_ids of this CalledProcessDefinitionDto.  # noqa: E501

        Ids of the CallActivities which call this process.  # noqa: E501

        :return: The called_from_activity_ids of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._called_from_activity_ids

    @called_from_activity_ids.setter
    def called_from_activity_ids(self, called_from_activity_ids):
        """Sets the called_from_activity_ids of this CalledProcessDefinitionDto.

        Ids of the CallActivities which call this process.  # noqa: E501

        :param called_from_activity_ids: The called_from_activity_ids of this CalledProcessDefinitionDto.  # noqa: E501
        :type: list[str]
        """

        self._called_from_activity_ids = called_from_activity_ids

    @property
    def calling_process_definition_id(self):
        """Gets the calling_process_definition_id of this CalledProcessDefinitionDto.  # noqa: E501

        The id of the calling process definition  # noqa: E501

        :return: The calling_process_definition_id of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._calling_process_definition_id

    @calling_process_definition_id.setter
    def calling_process_definition_id(self, calling_process_definition_id):
        """Sets the calling_process_definition_id of this CalledProcessDefinitionDto.

        The id of the calling process definition  # noqa: E501

        :param calling_process_definition_id: The calling_process_definition_id of this CalledProcessDefinitionDto.  # noqa: E501
        :type: str
        """

        self._calling_process_definition_id = calling_process_definition_id

    @property
    def id(self):
        """Gets the id of this CalledProcessDefinitionDto.  # noqa: E501

        The id of the process definition  # noqa: E501

        :return: The id of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CalledProcessDefinitionDto.

        The id of the process definition  # noqa: E501

        :param id: The id of this CalledProcessDefinitionDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def key(self):
        """Gets the key of this CalledProcessDefinitionDto.  # noqa: E501

        The key of the process definition, i.e., the id of the BPMN 2.0 XML process definition.  # noqa: E501

        :return: The key of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this CalledProcessDefinitionDto.

        The key of the process definition, i.e., the id of the BPMN 2.0 XML process definition.  # noqa: E501

        :param key: The key of this CalledProcessDefinitionDto.  # noqa: E501
        :type: str
        """

        self._key = key

    @property
    def category(self):
        """Gets the category of this CalledProcessDefinitionDto.  # noqa: E501

        The category of the process definition.  # noqa: E501

        :return: The category of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this CalledProcessDefinitionDto.

        The category of the process definition.  # noqa: E501

        :param category: The category of this CalledProcessDefinitionDto.  # noqa: E501
        :type: str
        """

        self._category = category

    @property
    def description(self):
        """Gets the description of this CalledProcessDefinitionDto.  # noqa: E501

        The description of the process definition.  # noqa: E501

        :return: The description of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this CalledProcessDefinitionDto.

        The description of the process definition.  # noqa: E501

        :param description: The description of this CalledProcessDefinitionDto.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def name(self):
        """Gets the name of this CalledProcessDefinitionDto.  # noqa: E501

        The name of the process definition.  # noqa: E501

        :return: The name of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CalledProcessDefinitionDto.

        The name of the process definition.  # noqa: E501

        :param name: The name of this CalledProcessDefinitionDto.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def version(self):
        """Gets the version of this CalledProcessDefinitionDto.  # noqa: E501

        The version of the process definition that the engine assigned to it.  # noqa: E501

        :return: The version of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this CalledProcessDefinitionDto.

        The version of the process definition that the engine assigned to it.  # noqa: E501

        :param version: The version of this CalledProcessDefinitionDto.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def resource(self):
        """Gets the resource of this CalledProcessDefinitionDto.  # noqa: E501

        The file name of the process definition.  # noqa: E501

        :return: The resource of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._resource

    @resource.setter
    def resource(self, resource):
        """Sets the resource of this CalledProcessDefinitionDto.

        The file name of the process definition.  # noqa: E501

        :param resource: The resource of this CalledProcessDefinitionDto.  # noqa: E501
        :type: str
        """

        self._resource = resource

    @property
    def deployment_id(self):
        """Gets the deployment_id of this CalledProcessDefinitionDto.  # noqa: E501

        The deployment id of the process definition.  # noqa: E501

        :return: The deployment_id of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._deployment_id

    @deployment_id.setter
    def deployment_id(self, deployment_id):
        """Sets the deployment_id of this CalledProcessDefinitionDto.

        The deployment id of the process definition.  # noqa: E501

        :param deployment_id: The deployment_id of this CalledProcessDefinitionDto.  # noqa: E501
        :type: str
        """

        self._deployment_id = deployment_id

    @property
    def diagram(self):
        """Gets the diagram of this CalledProcessDefinitionDto.  # noqa: E501

        The file name of the process definition diagram, if it exists.  # noqa: E501

        :return: The diagram of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._diagram

    @diagram.setter
    def diagram(self, diagram):
        """Sets the diagram of this CalledProcessDefinitionDto.

        The file name of the process definition diagram, if it exists.  # noqa: E501

        :param diagram: The diagram of this CalledProcessDefinitionDto.  # noqa: E501
        :type: str
        """

        self._diagram = diagram

    @property
    def suspended(self):
        """Gets the suspended of this CalledProcessDefinitionDto.  # noqa: E501

        A flag indicating whether the definition is suspended or not.  # noqa: E501

        :return: The suspended of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this CalledProcessDefinitionDto.

        A flag indicating whether the definition is suspended or not.  # noqa: E501

        :param suspended: The suspended of this CalledProcessDefinitionDto.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    @property
    def tenant_id(self):
        """Gets the tenant_id of this CalledProcessDefinitionDto.  # noqa: E501

        The tenant id of the process definition.  # noqa: E501

        :return: The tenant_id of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """Sets the tenant_id of this CalledProcessDefinitionDto.

        The tenant id of the process definition.  # noqa: E501

        :param tenant_id: The tenant_id of this CalledProcessDefinitionDto.  # noqa: E501
        :type: str
        """

        self._tenant_id = tenant_id

    @property
    def version_tag(self):
        """Gets the version_tag of this CalledProcessDefinitionDto.  # noqa: E501

        The version tag of the process definition.  # noqa: E501

        :return: The version_tag of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: str
        """
        return self._version_tag

    @version_tag.setter
    def version_tag(self, version_tag):
        """Sets the version_tag of this CalledProcessDefinitionDto.

        The version tag of the process definition.  # noqa: E501

        :param version_tag: The version_tag of this CalledProcessDefinitionDto.  # noqa: E501
        :type: str
        """

        self._version_tag = version_tag

    @property
    def history_time_to_live(self):
        """Gets the history_time_to_live of this CalledProcessDefinitionDto.  # noqa: E501

        History time to live value of the process definition. Is used within [History cleanup](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#history-cleanup).  # noqa: E501

        :return: The history_time_to_live of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: int
        """
        return self._history_time_to_live

    @history_time_to_live.setter
    def history_time_to_live(self, history_time_to_live):
        """Sets the history_time_to_live of this CalledProcessDefinitionDto.

        History time to live value of the process definition. Is used within [History cleanup](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#history-cleanup).  # noqa: E501

        :param history_time_to_live: The history_time_to_live of this CalledProcessDefinitionDto.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                history_time_to_live is not None and history_time_to_live < 0):  # noqa: E501
            raise ValueError("Invalid value for `history_time_to_live`, must be a value greater than or equal to `0`")  # noqa: E501

        self._history_time_to_live = history_time_to_live

    @property
    def startable_in_tasklist(self):
        """Gets the startable_in_tasklist of this CalledProcessDefinitionDto.  # noqa: E501

        A flag indicating whether the process definition is startable in Tasklist or not.  # noqa: E501

        :return: The startable_in_tasklist of this CalledProcessDefinitionDto.  # noqa: E501
        :rtype: bool
        """
        return self._startable_in_tasklist

    @startable_in_tasklist.setter
    def startable_in_tasklist(self, startable_in_tasklist):
        """Sets the startable_in_tasklist of this CalledProcessDefinitionDto.

        A flag indicating whether the process definition is startable in Tasklist or not.  # noqa: E501

        :param startable_in_tasklist: The startable_in_tasklist of this CalledProcessDefinitionDto.  # noqa: E501
        :type: bool
        """

        self._startable_in_tasklist = startable_in_tasklist

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CalledProcessDefinitionDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CalledProcessDefinitionDto):
            return True

        return self.to_dict() != other.to_dict()
