# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class AuthorizationUpdateDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'permissions': 'list[str]',
        'user_id': 'str',
        'group_id': 'str',
        'resource_type': 'int',
        'resource_id': 'str'
    }

    attribute_map = {
        'permissions': 'permissions',
        'user_id': 'userId',
        'group_id': 'groupId',
        'resource_type': 'resourceType',
        'resource_id': 'resourceId'
    }

    def __init__(self, permissions=None, user_id=None, group_id=None, resource_type=None, resource_id=None, local_vars_configuration=None):  # noqa: E501
        """AuthorizationUpdateDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._permissions = None
        self._user_id = None
        self._group_id = None
        self._resource_type = None
        self._resource_id = None
        self.discriminator = None

        self.permissions = permissions
        self.user_id = user_id
        self.group_id = group_id
        self.resource_type = resource_type
        self.resource_id = resource_id

    @property
    def permissions(self):
        """Gets the permissions of this AuthorizationUpdateDto.  # noqa: E501

        An array of Strings holding the permissions provided by this authorization.  # noqa: E501

        :return: The permissions of this AuthorizationUpdateDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._permissions

    @permissions.setter
    def permissions(self, permissions):
        """Sets the permissions of this AuthorizationUpdateDto.

        An array of Strings holding the permissions provided by this authorization.  # noqa: E501

        :param permissions: The permissions of this AuthorizationUpdateDto.  # noqa: E501
        :type: list[str]
        """

        self._permissions = permissions

    @property
    def user_id(self):
        """Gets the user_id of this AuthorizationUpdateDto.  # noqa: E501

        The id of the user this authorization has been created for. The value `*` represents a global authorization ranging over all users.  # noqa: E501

        :return: The user_id of this AuthorizationUpdateDto.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this AuthorizationUpdateDto.

        The id of the user this authorization has been created for. The value `*` represents a global authorization ranging over all users.  # noqa: E501

        :param user_id: The user_id of this AuthorizationUpdateDto.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    @property
    def group_id(self):
        """Gets the group_id of this AuthorizationUpdateDto.  # noqa: E501

        The id of the group this authorization has been created for.  # noqa: E501

        :return: The group_id of this AuthorizationUpdateDto.  # noqa: E501
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """Sets the group_id of this AuthorizationUpdateDto.

        The id of the group this authorization has been created for.  # noqa: E501

        :param group_id: The group_id of this AuthorizationUpdateDto.  # noqa: E501
        :type: str
        """

        self._group_id = group_id

    @property
    def resource_type(self):
        """Gets the resource_type of this AuthorizationUpdateDto.  # noqa: E501

        An integer representing the resource type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types.  # noqa: E501

        :return: The resource_type of this AuthorizationUpdateDto.  # noqa: E501
        :rtype: int
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this AuthorizationUpdateDto.

        An integer representing the resource type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types.  # noqa: E501

        :param resource_type: The resource_type of this AuthorizationUpdateDto.  # noqa: E501
        :type: int
        """

        self._resource_type = resource_type

    @property
    def resource_id(self):
        """Gets the resource_id of this AuthorizationUpdateDto.  # noqa: E501

        The resource Id. The value `*` represents an authorization ranging over all instances of a resource.  # noqa: E501

        :return: The resource_id of this AuthorizationUpdateDto.  # noqa: E501
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """Sets the resource_id of this AuthorizationUpdateDto.

        The resource Id. The value `*` represents an authorization ranging over all instances of a resource.  # noqa: E501

        :param resource_id: The resource_id of this AuthorizationUpdateDto.  # noqa: E501
        :type: str
        """

        self._resource_id = resource_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuthorizationUpdateDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AuthorizationUpdateDto):
            return True

        return self.to_dict() != other.to_dict()
